% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post-block.R
\name{user_block}
\alias{user_block}
\alias{user_unblock}
\title{Blocking or unblocking twitter users}
\usage{
user_block(user, unblock = FALSE, token = NULL)

user_unblock(user, token = NULL)
}
\arguments{
\item{user}{Character vector of screen names or user ids.
See \code{\link[=as_screenname]{as_screenname()}} for more details.}

\item{unblock}{Logical indicating whether to unblock the intended
friend.}

\item{token}{Expert use only. Use this to override authentication for
a single API call. In most cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}
}
\description{
\code{user_block(...)} blocks or unblocks a target twitter user.
\code{user_unblock(...)} is synonymous to \code{user_block(..., unblock=TRUE)}.
}
\examples{
if (auth_has_default()) {
  user_block("rtweet")
  user_unblock("rtweet")
  user_block("rtweet", unblock=TRUE) #<-same as the above
}
}
\references{
Block: \url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/mute-block-report-users/api-reference/post-blocks-create}
}
