#ifndef VARLINK_DEF_H
#define VARLINK_DEF_H

#include <stdbool.h>
#include <stddef.h>
#include <stdio.h>

struct varlink_interface {
	char *name;
	char *description;

	struct varlink_type_alias *type_aliases;
	size_t type_aliases_len;

	struct varlink_method *methods;
	size_t methods_len;

	struct varlink_error *errors;
	size_t errors_len;
};

struct varlink_enum {
	char **entries;
	size_t entries_len;
};

struct varlink_struct {
	char **field_names;
	struct varlink_type *field_types;
	size_t fields_len;
};

struct varlink_method {
	char *name;
	char *description;
	struct varlink_struct in, out;
};

enum varlink_kind {
	VARLINK_STRUCT = 1,
	VARLINK_ENUM,
	VARLINK_NAME,
	VARLINK_BOOL,
	VARLINK_INT,
	VARLINK_FLOAT,
	VARLINK_STRING,
	VARLINK_OBJECT,
	VARLINK_ARRAY,
	VARLINK_MAP,
};

struct varlink_type {
	enum varlink_kind kind;
	bool nullable;

	struct varlink_type *inner; // for VARLINK_ARRAY and VARLINK_MAP
	char *name; // for VARLINK_NAME
	struct varlink_struct struct_; // for VARLINK_STRUCT
	struct varlink_enum enum_; // for VARLINK_ENUM
};

struct varlink_type_alias {
	char *name;
	char *description;
	struct varlink_type type; // only structs and enums
};

struct varlink_error {
	char *name;
	char *description;
	struct varlink_struct struct_;
};

struct varlink_interface *varlink_interface_read(FILE *f);
void varlink_interface_destroy(struct varlink_interface *iface);

#endif
