% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{xgboost-options}
\alias{xgboost-options}
\title{XGBoost Options}
\description{
XGBoost offers an \link[base:options]{option setting} for controlling the behavior
of deprecated and removed function arguments.

Some of the arguments in functions like \code{\link[=xgb.train]{xgb.train()}} or \code{\link[=predict.xgb.Booster]{predict.xgb.Booster()}} been renamed
from how they were in previous versions, or have been removed.

In order to make the transition to newer XGBoost versions easier, some of these parameters are
still accepted but issue a warning when using them. \bold{Note that these warnings will become
errors in the future!!} - this is just a temporary workaround to make the transition easier.

One can optionally use 'strict mode' to turn these warnings into errors, in order to ensure
that code calling xgboost will still work once those are removed in future releases.

Currently, the only supported option is \code{xgboost.strict_mode}, which can be set to \code{TRUE} or
\code{FALSE} (default).

In addition to an R option, it can also be enabled through by setting environment variable
\code{XGB_STRICT_MODE=1}. If set, this environment variable will take precedence over the option.
}
\examples{
options("xgboost.strict_mode" = FALSE)
options("xgboost.strict_mode" = TRUE)
Sys.setenv("XGB_STRICT_MODE" = "1")
Sys.setenv("XGB_STRICT_MODE" = "0")
}
