#ifndef __VMLINUX_H__
#define __VMLINUX_H__

#ifndef BPF_NO_PRESERVE_ACCESS_INDEX
#pragma clang attribute push (__attribute__((preserve_access_index)), apply_to = record)
#endif

#ifndef __ksym
#define __ksym __attribute__((section(".ksyms")))
#endif

#ifndef __weak
#define __weak __attribute__((weak))
#endif

#ifndef __bpf_fastcall
#if __has_attribute(bpf_fastcall)
#define __bpf_fastcall __attribute__((bpf_fastcall))
#else
#define __bpf_fastcall
#endif
#endif

enum {
	ACPI_BATTERY_ALARM_PRESENT = 0,
	ACPI_BATTERY_XINFO_PRESENT = 1,
	ACPI_BATTERY_QUIRK_PERCENTAGE_CAPACITY = 2,
	ACPI_BATTERY_QUIRK_THINKPAD_MAH = 3,
	ACPI_BATTERY_QUIRK_DEGRADED_FULL_CHARGE = 4,
};

enum {
	ACPI_BUTTON_LID_INIT_IGNORE = 0,
	ACPI_BUTTON_LID_INIT_OPEN = 1,
	ACPI_BUTTON_LID_INIT_METHOD = 2,
	ACPI_BUTTON_LID_INIT_DISABLED = 3,
};

enum {
	ACPI_GENL_ATTR_UNSPEC = 0,
	ACPI_GENL_ATTR_EVENT = 1,
	__ACPI_GENL_ATTR_MAX = 2,
};

enum {
	ACPI_GENL_CMD_UNSPEC = 0,
	ACPI_GENL_CMD_EVENT = 1,
	__ACPI_GENL_CMD_MAX = 2,
};

enum {
	ACPI_REFCLASS_LOCAL = 0,
	ACPI_REFCLASS_ARG = 1,
	ACPI_REFCLASS_REFOF = 2,
	ACPI_REFCLASS_INDEX = 3,
	ACPI_REFCLASS_TABLE = 4,
	ACPI_REFCLASS_NAME = 5,
	ACPI_REFCLASS_DEBUG = 6,
	ACPI_REFCLASS_MAX = 6,
};

enum {
	ACPI_RSC_INITGET = 0,
	ACPI_RSC_INITSET = 1,
	ACPI_RSC_FLAGINIT = 2,
	ACPI_RSC_1BITFLAG = 3,
	ACPI_RSC_2BITFLAG = 4,
	ACPI_RSC_3BITFLAG = 5,
	ACPI_RSC_6BITFLAG = 6,
	ACPI_RSC_ADDRESS = 7,
	ACPI_RSC_BITMASK = 8,
	ACPI_RSC_BITMASK16 = 9,
	ACPI_RSC_COUNT = 10,
	ACPI_RSC_COUNT16 = 11,
	ACPI_RSC_COUNT_GPIO_PIN = 12,
	ACPI_RSC_COUNT_GPIO_RES = 13,
	ACPI_RSC_COUNT_GPIO_VEN = 14,
	ACPI_RSC_COUNT_SERIAL_RES = 15,
	ACPI_RSC_COUNT_SERIAL_VEN = 16,
	ACPI_RSC_DATA8 = 17,
	ACPI_RSC_EXIT_EQ = 18,
	ACPI_RSC_EXIT_LE = 19,
	ACPI_RSC_EXIT_NE = 20,
	ACPI_RSC_LENGTH = 21,
	ACPI_RSC_MOVE_GPIO_PIN = 22,
	ACPI_RSC_MOVE_GPIO_RES = 23,
	ACPI_RSC_MOVE_SERIAL_RES = 24,
	ACPI_RSC_MOVE_SERIAL_VEN = 25,
	ACPI_RSC_MOVE8 = 26,
	ACPI_RSC_MOVE16 = 27,
	ACPI_RSC_MOVE32 = 28,
	ACPI_RSC_MOVE64 = 29,
	ACPI_RSC_SET8 = 30,
	ACPI_RSC_SOURCE = 31,
	ACPI_RSC_SOURCEX = 32,
};

enum {
	ACTION_FAIL = 0,
	ACTION_REPREP = 1,
	ACTION_DELAYED_REPREP = 2,
	ACTION_RETRY = 3,
	ACTION_DELAYED_RETRY = 4,
};

enum {
	AC_GRP_AUDIO_FUNCTION = 1,
	AC_GRP_MODEM_FUNCTION = 2,
};

enum {
	AC_JACK_LINE_OUT = 0,
	AC_JACK_SPEAKER = 1,
	AC_JACK_HP_OUT = 2,
	AC_JACK_CD = 3,
	AC_JACK_SPDIF_OUT = 4,
	AC_JACK_DIG_OTHER_OUT = 5,
	AC_JACK_MODEM_LINE_SIDE = 6,
	AC_JACK_MODEM_HAND_SIDE = 7,
	AC_JACK_LINE_IN = 8,
	AC_JACK_AUX = 9,
	AC_JACK_MIC_IN = 10,
	AC_JACK_TELEPHONY = 11,
	AC_JACK_SPDIF_IN = 12,
	AC_JACK_DIG_OTHER_IN = 13,
	AC_JACK_OTHER = 15,
};

enum {
	AC_JACK_LOC_EXTERNAL = 0,
	AC_JACK_LOC_INTERNAL = 16,
	AC_JACK_LOC_SEPARATE = 32,
	AC_JACK_LOC_OTHER = 48,
};

enum {
	AC_JACK_LOC_NONE = 0,
	AC_JACK_LOC_REAR = 1,
	AC_JACK_LOC_FRONT = 2,
	AC_JACK_LOC_LEFT = 3,
	AC_JACK_LOC_RIGHT = 4,
	AC_JACK_LOC_TOP = 5,
	AC_JACK_LOC_BOTTOM = 6,
};

enum {
	AC_JACK_LOC_REAR_PANEL = 7,
	AC_JACK_LOC_DRIVE_BAY = 8,
	AC_JACK_LOC_RISER = 23,
	AC_JACK_LOC_HDMI = 24,
	AC_JACK_LOC_ATAPI = 25,
	AC_JACK_LOC_MOBILE_IN = 55,
	AC_JACK_LOC_MOBILE_OUT = 56,
};

enum {
	AC_JACK_PORT_COMPLEX = 0,
	AC_JACK_PORT_NONE = 1,
	AC_JACK_PORT_FIXED = 2,
	AC_JACK_PORT_BOTH = 3,
};

enum {
	AC_WID_AUD_OUT = 0,
	AC_WID_AUD_IN = 1,
	AC_WID_AUD_MIX = 2,
	AC_WID_AUD_SEL = 3,
	AC_WID_PIN = 4,
	AC_WID_POWER = 5,
	AC_WID_VOL_KNB = 6,
	AC_WID_BEEP = 7,
	AC_WID_VENDOR = 15,
};

enum {
	AFFINITY = 0,
	AFFINITY_LIST = 1,
	EFFECTIVE = 2,
	EFFECTIVE_LIST = 3,
};

enum {
	AHCI_MAX_PORTS = 32,
	AHCI_MAX_SG = 168,
	AHCI_DMA_BOUNDARY = 4294967295,
	AHCI_MAX_CMDS = 32,
	AHCI_CMD_SZ = 32,
	AHCI_CMD_SLOT_SZ = 1024,
	AHCI_RX_FIS_SZ = 256,
	AHCI_CMD_TBL_CDB = 64,
	AHCI_CMD_TBL_HDR_SZ = 128,
	AHCI_CMD_TBL_SZ = 2816,
	AHCI_CMD_TBL_AR_SZ = 90112,
	AHCI_PORT_PRIV_DMA_SZ = 91392,
	AHCI_PORT_PRIV_FBS_DMA_SZ = 95232,
	AHCI_IRQ_ON_SG = 2147483648,
	AHCI_CMD_ATAPI = 32,
	AHCI_CMD_WRITE = 64,
	AHCI_CMD_PREFETCH = 128,
	AHCI_CMD_RESET = 256,
	AHCI_CMD_CLR_BUSY = 1024,
	RX_FIS_PIO_SETUP = 32,
	RX_FIS_D2H_REG = 64,
	RX_FIS_SDB = 88,
	RX_FIS_UNK = 96,
	HOST_CAP = 0,
	HOST_CTL = 4,
	HOST_IRQ_STAT = 8,
	HOST_PORTS_IMPL = 12,
	HOST_VERSION = 16,
	HOST_EM_LOC = 28,
	HOST_EM_CTL = 32,
	HOST_CAP2 = 36,
	HOST_RESET = 1,
	HOST_IRQ_EN = 2,
	HOST_MRSM = 4,
	HOST_AHCI_EN = 2147483648,
	HOST_CAP_SXS = 32,
	HOST_CAP_EMS = 64,
	HOST_CAP_CCC = 128,
	HOST_CAP_PART = 8192,
	HOST_CAP_SSC = 16384,
	HOST_CAP_PIO_MULTI = 32768,
	HOST_CAP_FBS = 65536,
	HOST_CAP_PMP = 131072,
	HOST_CAP_ONLY = 262144,
	HOST_CAP_CLO = 16777216,
	HOST_CAP_LED = 33554432,
	HOST_CAP_ALPM = 67108864,
	HOST_CAP_SSS = 134217728,
	HOST_CAP_MPS = 268435456,
	HOST_CAP_SNTF = 536870912,
	HOST_CAP_NCQ = 1073741824,
	HOST_CAP_64 = 2147483648,
	HOST_CAP2_BOH = 1,
	HOST_CAP2_NVMHCI = 2,
	HOST_CAP2_APST = 4,
	HOST_CAP2_SDS = 8,
	HOST_CAP2_SADM = 16,
	HOST_CAP2_DESO = 32,
	PORT_LST_ADDR = 0,
	PORT_LST_ADDR_HI = 4,
	PORT_FIS_ADDR = 8,
	PORT_FIS_ADDR_HI = 12,
	PORT_IRQ_STAT = 16,
	PORT_IRQ_MASK = 20,
	PORT_CMD = 24,
	PORT_TFDATA = 32,
	PORT_SIG = 36,
	PORT_CMD_ISSUE = 56,
	PORT_SCR_STAT = 40,
	PORT_SCR_CTL = 44,
	PORT_SCR_ERR = 48,
	PORT_SCR_ACT = 52,
	PORT_SCR_NTF = 60,
	PORT_FBS = 64,
	PORT_DEVSLP = 68,
	PORT_IRQ_COLD_PRES = 2147483648,
	PORT_IRQ_TF_ERR = 1073741824,
	PORT_IRQ_HBUS_ERR = 536870912,
	PORT_IRQ_HBUS_DATA_ERR = 268435456,
	PORT_IRQ_IF_ERR = 134217728,
	PORT_IRQ_IF_NONFATAL = 67108864,
	PORT_IRQ_OVERFLOW = 16777216,
	PORT_IRQ_BAD_PMP = 8388608,
	PORT_IRQ_PHYRDY = 4194304,
	PORT_IRQ_DMPS = 128,
	PORT_IRQ_CONNECT = 64,
	PORT_IRQ_SG_DONE = 32,
	PORT_IRQ_UNK_FIS = 16,
	PORT_IRQ_SDB_FIS = 8,
	PORT_IRQ_DMAS_FIS = 4,
	PORT_IRQ_PIOS_FIS = 2,
	PORT_IRQ_D2H_REG_FIS = 1,
	PORT_IRQ_FREEZE = 683671632,
	PORT_IRQ_ERROR = 2025848912,
	DEF_PORT_IRQ = 2025848959,
	PORT_CMD_ASP = 134217728,
	PORT_CMD_ALPE = 67108864,
	PORT_CMD_ATAPI = 16777216,
	PORT_CMD_FBSCP = 4194304,
	PORT_CMD_ESP = 2097152,
	PORT_CMD_CPD = 1048576,
	PORT_CMD_MPSP = 524288,
	PORT_CMD_HPCP = 262144,
	PORT_CMD_PMP = 131072,
	PORT_CMD_LIST_ON = 32768,
	PORT_CMD_FIS_ON = 16384,
	PORT_CMD_FIS_RX = 16,
	PORT_CMD_CLO = 8,
	PORT_CMD_POWER_ON = 4,
	PORT_CMD_SPIN_UP = 2,
	PORT_CMD_START = 1,
	PORT_CMD_ICC_MASK = 4026531840,
	PORT_CMD_ICC_ACTIVE = 268435456,
	PORT_CMD_ICC_PARTIAL = 536870912,
	PORT_CMD_ICC_SLUMBER = 1610612736,
	PORT_CMD_CAP = 8126464,
	PORT_FBS_DWE_OFFSET = 16,
	PORT_FBS_ADO_OFFSET = 12,
	PORT_FBS_DEV_OFFSET = 8,
	PORT_FBS_DEV_MASK = 3840,
	PORT_FBS_SDE = 4,
	PORT_FBS_DEC = 2,
	PORT_FBS_EN = 1,
	PORT_DEVSLP_DM_OFFSET = 25,
	PORT_DEVSLP_DM_MASK = 503316480,
	PORT_DEVSLP_DITO_OFFSET = 15,
	PORT_DEVSLP_MDAT_OFFSET = 10,
	PORT_DEVSLP_DETO_OFFSET = 2,
	PORT_DEVSLP_DSP = 2,
	PORT_DEVSLP_ADSE = 1,
	AHCI_HFLAG_NO_NCQ = 1,
	AHCI_HFLAG_IGN_IRQ_IF_ERR = 2,
	AHCI_HFLAG_IGN_SERR_INTERNAL = 4,
	AHCI_HFLAG_32BIT_ONLY = 8,
	AHCI_HFLAG_MV_PATA = 16,
	AHCI_HFLAG_NO_MSI = 32,
	AHCI_HFLAG_NO_PMP = 64,
	AHCI_HFLAG_SECT255 = 256,
	AHCI_HFLAG_YES_NCQ = 512,
	AHCI_HFLAG_NO_SUSPEND = 1024,
	AHCI_HFLAG_SRST_TOUT_IS_OFFLINE = 2048,
	AHCI_HFLAG_NO_SNTF = 4096,
	AHCI_HFLAG_NO_FPDMA_AA = 8192,
	AHCI_HFLAG_YES_FBS = 16384,
	AHCI_HFLAG_DELAY_ENGINE = 32768,
	AHCI_HFLAG_NO_DEVSLP = 131072,
	AHCI_HFLAG_NO_FBS = 262144,
	AHCI_HFLAG_MULTI_MSI = 1048576,
	AHCI_HFLAG_WAKE_BEFORE_STOP = 4194304,
	AHCI_HFLAG_YES_ALPM = 8388608,
	AHCI_HFLAG_NO_WRITE_TO_RO = 16777216,
	AHCI_HFLAG_SUSPEND_PHYS = 33554432,
	AHCI_HFLAG_NO_SXS = 67108864,
	AHCI_HFLAG_43BIT_ONLY = 134217728,
	AHCI_HFLAG_INTEL_PCS_QUIRK = 268435456,
	AHCI_FLAG_COMMON = 393346,
	ICH_MAP = 144,
	PCS_6 = 146,
	PCS_7 = 148,
	EM_MAX_SLOTS = 15,
	EM_MAX_RETRY = 5,
	EM_CTL_RST = 512,
	EM_CTL_TM = 256,
	EM_CTL_MR = 1,
	EM_CTL_ALHD = 67108864,
	EM_CTL_XMT = 33554432,
	EM_CTL_SMB = 16777216,
	EM_CTL_SGPIO = 524288,
	EM_CTL_SES = 262144,
	EM_CTL_SAFTE = 131072,
	EM_CTL_LED = 65536,
	EM_MSG_TYPE_LED = 1,
	EM_MSG_TYPE_SAFTE = 2,
	EM_MSG_TYPE_SES2 = 4,
	EM_MSG_TYPE_SGPIO = 8,
};

enum {
	AHCI_PCI_BAR_STA2X11 = 0,
	AHCI_PCI_BAR_CAVIUM = 0,
	AHCI_PCI_BAR_LOONGSON = 0,
	AHCI_PCI_BAR_ENMOTUS = 2,
	AHCI_PCI_BAR_CAVIUM_GEN5 = 4,
	AHCI_PCI_BAR_STANDARD = 5,
};

enum {
	ALC260_FIXUP_HP_DC5750 = 0,
	ALC260_FIXUP_HP_PIN_0F = 1,
	ALC260_FIXUP_COEF = 2,
	ALC260_FIXUP_GPIO1 = 3,
	ALC260_FIXUP_GPIO1_TOGGLE = 4,
	ALC260_FIXUP_REPLACER = 5,
	ALC260_FIXUP_HP_B1900 = 6,
	ALC260_FIXUP_KN1 = 7,
	ALC260_FIXUP_FSC_S7020 = 8,
	ALC260_FIXUP_FSC_S7020_JWSE = 9,
	ALC260_FIXUP_VAIO_PINS = 10,
};

enum {
	ALC262_FIXUP_FSC_H270 = 0,
	ALC262_FIXUP_FSC_S7110 = 1,
	ALC262_FIXUP_HP_Z200 = 2,
	ALC262_FIXUP_TYAN = 3,
	ALC262_FIXUP_LENOVO_3000 = 4,
	ALC262_FIXUP_BENQ = 5,
	ALC262_FIXUP_BENQ_T31 = 6,
	ALC262_FIXUP_INV_DMIC = 7,
	ALC262_FIXUP_INTEL_BAYLEYBAY = 8,
};

enum {
	ALC268_FIXUP_INV_DMIC = 0,
	ALC268_FIXUP_HP_EAPD = 1,
	ALC268_FIXUP_SPDIF = 2,
};

enum {
	ALC269_FIXUP_GPIO2 = 0,
	ALC269_FIXUP_SONY_VAIO = 1,
	ALC275_FIXUP_SONY_VAIO_GPIO2 = 2,
	ALC269_FIXUP_DELL_M101Z = 3,
	ALC269_FIXUP_SKU_IGNORE = 4,
	ALC269_FIXUP_ASUS_G73JW = 5,
	ALC269_FIXUP_ASUS_N7601ZM_PINS = 6,
	ALC269_FIXUP_ASUS_N7601ZM = 7,
	ALC269_FIXUP_LENOVO_EAPD = 8,
	ALC275_FIXUP_SONY_HWEQ = 9,
	ALC275_FIXUP_SONY_DISABLE_AAMIX = 10,
	ALC271_FIXUP_DMIC = 11,
	ALC269_FIXUP_PCM_44K = 12,
	ALC269_FIXUP_STEREO_DMIC = 13,
	ALC269_FIXUP_HEADSET_MIC = 14,
	ALC269_FIXUP_QUANTA_MUTE = 15,
	ALC269_FIXUP_LIFEBOOK = 16,
	ALC269_FIXUP_LIFEBOOK_EXTMIC = 17,
	ALC269_FIXUP_LIFEBOOK_HP_PIN = 18,
	ALC269_FIXUP_LIFEBOOK_NO_HP_TO_LINEOUT = 19,
	ALC255_FIXUP_LIFEBOOK_U7x7_HEADSET_MIC = 20,
	ALC269_FIXUP_AMIC = 21,
	ALC269_FIXUP_DMIC = 22,
	ALC269VB_FIXUP_AMIC = 23,
	ALC269VB_FIXUP_DMIC = 24,
	ALC269_FIXUP_HP_MUTE_LED = 25,
	ALC269_FIXUP_HP_MUTE_LED_MIC1 = 26,
	ALC269_FIXUP_HP_MUTE_LED_MIC2 = 27,
	ALC269_FIXUP_HP_MUTE_LED_MIC3 = 28,
	ALC269_FIXUP_HP_GPIO_LED = 29,
	ALC269_FIXUP_HP_GPIO_MIC1_LED = 30,
	ALC269_FIXUP_HP_LINE1_MIC1_LED = 31,
	ALC269_FIXUP_INV_DMIC = 32,
	ALC269_FIXUP_LENOVO_DOCK = 33,
	ALC269_FIXUP_LENOVO_DOCK_LIMIT_BOOST = 34,
	ALC269_FIXUP_NO_SHUTUP = 35,
	ALC286_FIXUP_SONY_MIC_NO_PRESENCE = 36,
	ALC269_FIXUP_PINCFG_NO_HP_TO_LINEOUT = 37,
	ALC269_FIXUP_DELL1_MIC_NO_PRESENCE = 38,
	ALC269_FIXUP_DELL1_LIMIT_INT_MIC_BOOST = 39,
	ALC269_FIXUP_DELL2_MIC_NO_PRESENCE = 40,
	ALC269_FIXUP_DELL3_MIC_NO_PRESENCE = 41,
	ALC269_FIXUP_DELL4_MIC_NO_PRESENCE = 42,
	ALC269_FIXUP_DELL4_MIC_NO_PRESENCE_QUIET = 43,
	ALC269_FIXUP_HEADSET_MODE = 44,
	ALC269_FIXUP_HEADSET_MODE_NO_HP_MIC = 45,
	ALC269_FIXUP_ASPIRE_HEADSET_MIC = 46,
	ALC269_FIXUP_ASUS_X101_FUNC = 47,
	ALC269_FIXUP_ASUS_X101_VERB = 48,
	ALC269_FIXUP_ASUS_X101 = 49,
	ALC271_FIXUP_AMIC_MIC2 = 50,
	ALC271_FIXUP_HP_GATE_MIC_JACK = 51,
	ALC271_FIXUP_HP_GATE_MIC_JACK_E1_572 = 52,
	ALC269_FIXUP_ACER_AC700 = 53,
	ALC269_FIXUP_LIMIT_INT_MIC_BOOST = 54,
	ALC269VB_FIXUP_ASUS_ZENBOOK = 55,
	ALC269VB_FIXUP_ASUS_ZENBOOK_UX31A = 56,
	ALC269VB_FIXUP_ASUS_MIC_NO_PRESENCE = 57,
	ALC269_FIXUP_LIMIT_INT_MIC_BOOST_MUTE_LED = 58,
	ALC269VB_FIXUP_ORDISSIMO_EVE2 = 59,
	ALC283_FIXUP_CHROME_BOOK = 60,
	ALC283_FIXUP_SENSE_COMBO_JACK = 61,
	ALC282_FIXUP_ASUS_TX300 = 62,
	ALC283_FIXUP_INT_MIC = 63,
	ALC290_FIXUP_MONO_SPEAKERS = 64,
	ALC290_FIXUP_MONO_SPEAKERS_HSJACK = 65,
	ALC290_FIXUP_SUBWOOFER = 66,
	ALC290_FIXUP_SUBWOOFER_HSJACK = 67,
	ALC295_FIXUP_HP_MUTE_LED_COEFBIT11 = 68,
	ALC269_FIXUP_THINKPAD_ACPI = 69,
	ALC269_FIXUP_LENOVO_XPAD_ACPI = 70,
	ALC269_FIXUP_DMIC_THINKPAD_ACPI = 71,
	ALC269VB_FIXUP_INFINIX_ZERO_BOOK_13 = 72,
	ALC269VC_FIXUP_INFINIX_Y4_MAX = 73,
	ALC269VB_FIXUP_CHUWI_COREBOOK_XPRO = 74,
	ALC255_FIXUP_ACER_MIC_NO_PRESENCE = 75,
	ALC255_FIXUP_ASUS_MIC_NO_PRESENCE = 76,
	ALC255_FIXUP_DELL1_MIC_NO_PRESENCE = 77,
	ALC255_FIXUP_DELL1_LIMIT_INT_MIC_BOOST = 78,
	ALC255_FIXUP_DELL2_MIC_NO_PRESENCE = 79,
	ALC255_FIXUP_HEADSET_MODE = 80,
	ALC255_FIXUP_HEADSET_MODE_NO_HP_MIC = 81,
	ALC293_FIXUP_DELL1_MIC_NO_PRESENCE = 82,
	ALC292_FIXUP_TPT440_DOCK = 83,
	ALC292_FIXUP_TPT440 = 84,
	ALC283_FIXUP_HEADSET_MIC = 85,
	ALC255_FIXUP_MIC_MUTE_LED = 86,
	ALC282_FIXUP_ASPIRE_V5_PINS = 87,
	ALC269VB_FIXUP_ASPIRE_E1_COEF = 88,
	ALC280_FIXUP_HP_GPIO4 = 89,
	ALC286_FIXUP_HP_GPIO_LED = 90,
	ALC280_FIXUP_HP_GPIO2_MIC_HOTKEY = 91,
	ALC280_FIXUP_HP_DOCK_PINS = 92,
	ALC269_FIXUP_HP_DOCK_GPIO_MIC1_LED = 93,
	ALC280_FIXUP_HP_9480M = 94,
	ALC245_FIXUP_HP_X360_AMP = 95,
	ALC285_FIXUP_HP_SPECTRE_X360_EB1 = 96,
	ALC285_FIXUP_HP_ENVY_X360 = 97,
	ALC288_FIXUP_DELL_HEADSET_MODE = 98,
	ALC288_FIXUP_DELL1_MIC_NO_PRESENCE = 99,
	ALC288_FIXUP_DELL_XPS_13 = 100,
	ALC288_FIXUP_DISABLE_AAMIX = 101,
	ALC292_FIXUP_DELL_E7X_AAMIX = 102,
	ALC292_FIXUP_DELL_E7X = 103,
	ALC292_FIXUP_DISABLE_AAMIX = 104,
	ALC293_FIXUP_DISABLE_AAMIX_MULTIJACK = 105,
	ALC298_FIXUP_ALIENWARE_MIC_NO_PRESENCE = 106,
	ALC298_FIXUP_DELL1_MIC_NO_PRESENCE = 107,
	ALC298_FIXUP_DELL_AIO_MIC_NO_PRESENCE = 108,
	ALC275_FIXUP_DELL_XPS = 109,
	ALC293_FIXUP_LENOVO_SPK_NOISE = 110,
	ALC233_FIXUP_LENOVO_LINE2_MIC_HOTKEY = 111,
	ALC233_FIXUP_LENOVO_L2MH_LOW_ENLED = 112,
	ALC255_FIXUP_DELL_SPK_NOISE = 113,
	ALC225_FIXUP_DISABLE_MIC_VREF = 114,
	ALC225_FIXUP_DELL1_MIC_NO_PRESENCE = 115,
	ALC295_FIXUP_DISABLE_DAC3 = 116,
	ALC285_FIXUP_SPEAKER2_TO_DAC1 = 117,
	ALC285_FIXUP_ASUS_SPEAKER2_TO_DAC1 = 118,
	ALC285_FIXUP_ASUS_HEADSET_MIC = 119,
	ALC285_FIXUP_ASUS_SPI_REAR_SPEAKERS = 120,
	ALC285_FIXUP_ASUS_I2C_SPEAKER2_TO_DAC1 = 121,
	ALC285_FIXUP_ASUS_I2C_HEADSET_MIC = 122,
	ALC280_FIXUP_HP_HEADSET_MIC = 123,
	ALC221_FIXUP_HP_FRONT_MIC = 124,
	ALC292_FIXUP_TPT460 = 125,
	ALC298_FIXUP_SPK_VOLUME = 126,
	ALC298_FIXUP_LENOVO_SPK_VOLUME = 127,
	ALC256_FIXUP_DELL_INSPIRON_7559_SUBWOOFER = 128,
	ALC269_FIXUP_ATIV_BOOK_8 = 129,
	ALC221_FIXUP_HP_288PRO_MIC_NO_PRESENCE = 130,
	ALC221_FIXUP_HP_MIC_NO_PRESENCE = 131,
	ALC256_FIXUP_ASUS_HEADSET_MODE = 132,
	ALC256_FIXUP_ASUS_MIC = 133,
	ALC256_FIXUP_ASUS_AIO_GPIO2 = 134,
	ALC233_FIXUP_ASUS_MIC_NO_PRESENCE = 135,
	ALC233_FIXUP_EAPD_COEF_AND_MIC_NO_PRESENCE = 136,
	ALC233_FIXUP_LENOVO_MULTI_CODECS = 137,
	ALC233_FIXUP_ACER_HEADSET_MIC = 138,
	ALC294_FIXUP_LENOVO_MIC_LOCATION = 139,
	ALC225_FIXUP_DELL_WYSE_MIC_NO_PRESENCE = 140,
	ALC225_FIXUP_S3_POP_NOISE = 141,
	ALC700_FIXUP_INTEL_REFERENCE = 142,
	ALC274_FIXUP_DELL_BIND_DACS = 143,
	ALC274_FIXUP_DELL_AIO_LINEOUT_VERB = 144,
	ALC298_FIXUP_TPT470_DOCK_FIX = 145,
	ALC298_FIXUP_TPT470_DOCK = 146,
	ALC255_FIXUP_DUMMY_LINEOUT_VERB = 147,
	ALC255_FIXUP_DELL_HEADSET_MIC = 148,
	ALC256_FIXUP_HUAWEI_MACH_WX9_PINS = 149,
	ALC298_FIXUP_HUAWEI_MBX_STEREO = 150,
	ALC295_FIXUP_HP_X360 = 151,
	ALC221_FIXUP_HP_HEADSET_MIC = 152,
	ALC285_FIXUP_LENOVO_HEADPHONE_NOISE = 153,
	ALC295_FIXUP_HP_AUTO_MUTE = 154,
	ALC286_FIXUP_ACER_AIO_MIC_NO_PRESENCE = 155,
	ALC294_FIXUP_ASUS_MIC = 156,
	ALC294_FIXUP_ASUS_HEADSET_MIC = 157,
	ALC294_FIXUP_ASUS_SPK = 158,
	ALC293_FIXUP_SYSTEM76_MIC_NO_PRESENCE = 159,
	ALC285_FIXUP_LENOVO_PC_BEEP_IN_NOISE = 160,
	ALC255_FIXUP_ACER_HEADSET_MIC = 161,
	ALC295_FIXUP_CHROME_BOOK = 162,
	ALC225_FIXUP_HEADSET_JACK = 163,
	ALC225_FIXUP_DELL_WYSE_AIO_MIC_NO_PRESENCE = 164,
	ALC225_FIXUP_WYSE_AUTO_MUTE = 165,
	ALC225_FIXUP_WYSE_DISABLE_MIC_VREF = 166,
	ALC286_FIXUP_ACER_AIO_HEADSET_MIC = 167,
	ALC256_FIXUP_ASUS_HEADSET_MIC = 168,
	ALC256_FIXUP_ASUS_MIC_NO_PRESENCE = 169,
	ALC255_FIXUP_PREDATOR_SUBWOOFER = 170,
	ALC299_FIXUP_PREDATOR_SPK = 171,
	ALC256_FIXUP_MEDION_HEADSET_NO_PRESENCE = 172,
	ALC289_FIXUP_DELL_SPK1 = 173,
	ALC289_FIXUP_DELL_SPK2 = 174,
	ALC289_FIXUP_DUAL_SPK = 175,
	ALC289_FIXUP_RTK_AMP_DUAL_SPK = 176,
	ALC294_FIXUP_SPK2_TO_DAC1 = 177,
	ALC294_FIXUP_ASUS_DUAL_SPK = 178,
	ALC285_FIXUP_THINKPAD_X1_GEN7 = 179,
	ALC285_FIXUP_THINKPAD_HEADSET_JACK = 180,
	ALC294_FIXUP_ASUS_ALLY = 181,
	ALC294_FIXUP_ASUS_ALLY_PINS = 182,
	ALC294_FIXUP_ASUS_ALLY_VERBS = 183,
	ALC294_FIXUP_ASUS_ALLY_SPEAKER = 184,
	ALC294_FIXUP_ASUS_HPE = 185,
	ALC294_FIXUP_ASUS_COEF_1B = 186,
	ALC294_FIXUP_ASUS_GX502_HP = 187,
	ALC294_FIXUP_ASUS_GX502_PINS = 188,
	ALC294_FIXUP_ASUS_GX502_VERBS = 189,
	ALC294_FIXUP_ASUS_GU502_HP = 190,
	ALC294_FIXUP_ASUS_GU502_PINS = 191,
	ALC294_FIXUP_ASUS_GU502_VERBS = 192,
	ALC294_FIXUP_ASUS_G513_PINS = 193,
	ALC285_FIXUP_ASUS_G533Z_PINS = 194,
	ALC285_FIXUP_HP_GPIO_LED = 195,
	ALC285_FIXUP_HP_MUTE_LED = 196,
	ALC285_FIXUP_HP_SPECTRE_X360_MUTE_LED = 197,
	ALC236_FIXUP_HP_MUTE_LED_COEFBIT2 = 198,
	ALC236_FIXUP_HP_GPIO_LED = 199,
	ALC236_FIXUP_HP_MUTE_LED = 200,
	ALC236_FIXUP_HP_MUTE_LED_MICMUTE_VREF = 201,
	ALC236_FIXUP_LENOVO_INV_DMIC = 202,
	ALC298_FIXUP_SAMSUNG_AMP = 203,
	ALC298_FIXUP_SAMSUNG_AMP_V2_2_AMPS = 204,
	ALC298_FIXUP_SAMSUNG_AMP_V2_4_AMPS = 205,
	ALC298_FIXUP_SAMSUNG_HEADPHONE_VERY_QUIET = 206,
	ALC256_FIXUP_SAMSUNG_HEADPHONE_VERY_QUIET = 207,
	ALC295_FIXUP_ASUS_MIC_NO_PRESENCE = 208,
	ALC269VC_FIXUP_ACER_VCOPPERBOX_PINS = 209,
	ALC269VC_FIXUP_ACER_HEADSET_MIC = 210,
	ALC269VC_FIXUP_ACER_MIC_NO_PRESENCE = 211,
	ALC289_FIXUP_ASUS_GA401 = 212,
	ALC289_FIXUP_ASUS_GA502 = 213,
	ALC256_FIXUP_ACER_MIC_NO_PRESENCE = 214,
	ALC285_FIXUP_HP_GPIO_AMP_INIT = 215,
	ALC269_FIXUP_CZC_B20 = 216,
	ALC269_FIXUP_CZC_TMI = 217,
	ALC269_FIXUP_CZC_L101 = 218,
	ALC269_FIXUP_LEMOTE_A1802 = 219,
	ALC269_FIXUP_LEMOTE_A190X = 220,
	ALC256_FIXUP_INTEL_NUC8_RUGGED = 221,
	ALC233_FIXUP_INTEL_NUC8_DMIC = 222,
	ALC233_FIXUP_INTEL_NUC8_BOOST = 223,
	ALC256_FIXUP_INTEL_NUC10 = 224,
	ALC255_FIXUP_XIAOMI_HEADSET_MIC = 225,
	ALC274_FIXUP_HP_MIC = 226,
	ALC274_FIXUP_HP_HEADSET_MIC = 227,
	ALC274_FIXUP_HP_ENVY_GPIO = 228,
	ALC274_FIXUP_ASUS_ZEN_AIO_27 = 229,
	ALC256_FIXUP_ASUS_HPE = 230,
	ALC285_FIXUP_THINKPAD_NO_BASS_SPK_HEADSET_JACK = 231,
	ALC287_FIXUP_HP_GPIO_LED = 232,
	ALC256_FIXUP_HP_HEADSET_MIC = 233,
	ALC245_FIXUP_HP_GPIO_LED = 234,
	ALC236_FIXUP_DELL_AIO_HEADSET_MIC = 235,
	ALC282_FIXUP_ACER_DISABLE_LINEOUT = 236,
	ALC255_FIXUP_ACER_LIMIT_INT_MIC_BOOST = 237,
	ALC256_FIXUP_ACER_HEADSET_MIC = 238,
	ALC285_FIXUP_IDEAPAD_S740_COEF = 239,
	ALC285_FIXUP_HP_LIMIT_INT_MIC_BOOST = 240,
	ALC295_FIXUP_ASUS_DACS = 241,
	ALC295_FIXUP_HP_OMEN = 242,
	ALC285_FIXUP_HP_SPECTRE_X360 = 243,
	ALC287_FIXUP_IDEAPAD_BASS_SPK_AMP = 244,
	ALC623_FIXUP_LENOVO_THINKSTATION_P340 = 245,
	ALC255_FIXUP_ACER_HEADPHONE_AND_MIC = 246,
	ALC236_FIXUP_HP_LIMIT_INT_MIC_BOOST = 247,
	ALC287_FIXUP_LEGION_15IMHG05_SPEAKERS = 248,
	ALC287_FIXUP_LEGION_15IMHG05_AUTOMUTE = 249,
	ALC287_FIXUP_YOGA7_14ITL_SPEAKERS = 250,
	ALC298_FIXUP_LENOVO_C940_DUET7 = 251,
	ALC287_FIXUP_13S_GEN2_SPEAKERS = 252,
	ALC256_FIXUP_SET_COEF_DEFAULTS = 253,
	ALC256_FIXUP_SYSTEM76_MIC_NO_PRESENCE = 254,
	ALC233_FIXUP_NO_AUDIO_JACK = 255,
	ALC256_FIXUP_MIC_NO_PRESENCE_AND_RESUME = 256,
	ALC285_FIXUP_LEGION_Y9000X_SPEAKERS = 257,
	ALC285_FIXUP_LEGION_Y9000X_AUTOMUTE = 258,
	ALC287_FIXUP_LEGION_16ACHG6 = 259,
	ALC287_FIXUP_CS35L41_I2C_2 = 260,
	ALC287_FIXUP_CS35L41_I2C_2_HP_GPIO_LED = 261,
	ALC287_FIXUP_CS35L41_I2C_4 = 262,
	ALC245_FIXUP_CS35L41_SPI_2 = 263,
	ALC245_FIXUP_CS35L41_SPI_2_HP_GPIO_LED = 264,
	ALC245_FIXUP_CS35L41_SPI_4 = 265,
	ALC245_FIXUP_CS35L41_SPI_4_HP_GPIO_LED = 266,
	ALC285_FIXUP_HP_SPEAKERS_MICMUTE_LED = 267,
	ALC295_FIXUP_FRAMEWORK_LAPTOP_MIC_NO_PRESENCE = 268,
	ALC287_FIXUP_LEGION_16ITHG6 = 269,
	ALC287_FIXUP_YOGA9_14IAP7_BASS_SPK = 270,
	ALC287_FIXUP_YOGA9_14IAP7_BASS_SPK_PIN = 271,
	ALC287_FIXUP_YOGA9_14IMH9_BASS_SPK_PIN = 272,
	ALC295_FIXUP_DELL_INSPIRON_TOP_SPEAKERS = 273,
	ALC236_FIXUP_DELL_DUAL_CODECS = 274,
	ALC287_FIXUP_CS35L41_I2C_2_THINKPAD_ACPI = 275,
	ALC287_FIXUP_TAS2781_I2C = 276,
	ALC245_FIXUP_TAS2781_SPI_2 = 277,
	ALC287_FIXUP_YOGA7_14ARB7_I2C = 278,
	ALC245_FIXUP_HP_MUTE_LED_COEFBIT = 279,
	ALC245_FIXUP_HP_X360_MUTE_LEDS = 280,
	ALC287_FIXUP_THINKPAD_I2S_SPK = 281,
	ALC287_FIXUP_MG_RTKC_CSAMP_CS35L41_I2C_THINKPAD = 282,
	ALC2XX_FIXUP_HEADSET_MIC = 283,
	ALC289_FIXUP_DELL_CS35L41_SPI_2 = 284,
	ALC294_FIXUP_CS35L41_I2C_2 = 285,
	ALC256_FIXUP_ACER_SFG16_MICMUTE_LED = 286,
	ALC256_FIXUP_HEADPHONE_AMP_VOL = 287,
	ALC245_FIXUP_HP_SPECTRE_X360_EU0XXX = 288,
	ALC245_FIXUP_HP_SPECTRE_X360_16_AA0XXX = 289,
	ALC285_FIXUP_ASUS_GA403U = 290,
	ALC285_FIXUP_ASUS_GA403U_HEADSET_MIC = 291,
	ALC285_FIXUP_ASUS_GA403U_I2C_SPEAKER2_TO_DAC1 = 292,
	ALC285_FIXUP_ASUS_GU605_SPI_2_HEADSET_MIC = 293,
	ALC285_FIXUP_ASUS_GU605_SPI_SPEAKER2_TO_DAC1 = 294,
	ALC287_FIXUP_LENOVO_THKPAD_WH_ALC1318 = 295,
	ALC256_FIXUP_CHROME_BOOK = 296,
	ALC245_FIXUP_CLEVO_NOISY_MIC = 297,
	ALC269_FIXUP_VAIO_VJFH52_MIC_NO_PRESENCE = 298,
	ALC233_FIXUP_MEDION_MTL_SPK = 299,
	ALC294_FIXUP_BASS_SPEAKER_15 = 300,
	ALC283_FIXUP_DELL_HP_RESUME = 301,
};

enum {
	ALC269_TYPE_ALC269VA = 0,
	ALC269_TYPE_ALC269VB = 1,
	ALC269_TYPE_ALC269VC = 2,
	ALC269_TYPE_ALC269VD = 3,
	ALC269_TYPE_ALC280 = 4,
	ALC269_TYPE_ALC282 = 5,
	ALC269_TYPE_ALC283 = 6,
	ALC269_TYPE_ALC284 = 7,
	ALC269_TYPE_ALC293 = 8,
	ALC269_TYPE_ALC286 = 9,
	ALC269_TYPE_ALC298 = 10,
	ALC269_TYPE_ALC255 = 11,
	ALC269_TYPE_ALC256 = 12,
	ALC269_TYPE_ALC257 = 13,
	ALC269_TYPE_ALC215 = 14,
	ALC269_TYPE_ALC225 = 15,
	ALC269_TYPE_ALC245 = 16,
	ALC269_TYPE_ALC287 = 17,
	ALC269_TYPE_ALC294 = 18,
	ALC269_TYPE_ALC300 = 19,
	ALC269_TYPE_ALC623 = 20,
	ALC269_TYPE_ALC700 = 21,
};

enum {
	ALC660VD_FIX_ASUS_GPIO1 = 0,
	ALC861VD_FIX_DALLAS = 1,
};

enum {
	ALC662_FIXUP_ASPIRE = 0,
	ALC662_FIXUP_LED_GPIO1 = 1,
	ALC662_FIXUP_IDEAPAD = 2,
	ALC272_FIXUP_MARIO = 3,
	ALC662_FIXUP_CZC_ET26 = 4,
	ALC662_FIXUP_CZC_P10T = 5,
	ALC662_FIXUP_SKU_IGNORE = 6,
	ALC662_FIXUP_HP_RP5800 = 7,
	ALC662_FIXUP_ASUS_MODE1 = 8,
	ALC662_FIXUP_ASUS_MODE2 = 9,
	ALC662_FIXUP_ASUS_MODE3 = 10,
	ALC662_FIXUP_ASUS_MODE4 = 11,
	ALC662_FIXUP_ASUS_MODE5 = 12,
	ALC662_FIXUP_ASUS_MODE6 = 13,
	ALC662_FIXUP_ASUS_MODE7 = 14,
	ALC662_FIXUP_ASUS_MODE8 = 15,
	ALC662_FIXUP_NO_JACK_DETECT = 16,
	ALC662_FIXUP_ZOTAC_Z68 = 17,
	ALC662_FIXUP_INV_DMIC = 18,
	ALC662_FIXUP_DELL_MIC_NO_PRESENCE = 19,
	ALC668_FIXUP_DELL_MIC_NO_PRESENCE = 20,
	ALC662_FIXUP_HEADSET_MODE = 21,
	ALC668_FIXUP_HEADSET_MODE = 22,
	ALC662_FIXUP_BASS_MODE4_CHMAP = 23,
	ALC662_FIXUP_BASS_16 = 24,
	ALC662_FIXUP_BASS_1A = 25,
	ALC662_FIXUP_BASS_CHMAP = 26,
	ALC668_FIXUP_AUTO_MUTE = 27,
	ALC668_FIXUP_DELL_DISABLE_AAMIX = 28,
	ALC668_FIXUP_DELL_XPS13 = 29,
	ALC662_FIXUP_ASUS_Nx50 = 30,
	ALC668_FIXUP_ASUS_Nx51_HEADSET_MODE = 31,
	ALC668_FIXUP_ASUS_Nx51 = 32,
	ALC668_FIXUP_MIC_COEF = 33,
	ALC668_FIXUP_ASUS_G751 = 34,
	ALC891_FIXUP_HEADSET_MODE = 35,
	ALC891_FIXUP_DELL_MIC_NO_PRESENCE = 36,
	ALC662_FIXUP_ACER_VERITON = 37,
	ALC892_FIXUP_ASROCK_MOBO = 38,
	ALC662_FIXUP_USI_FUNC = 39,
	ALC662_FIXUP_USI_HEADSET_MODE = 40,
	ALC662_FIXUP_LENOVO_MULTI_CODECS = 41,
	ALC669_FIXUP_ACER_ASPIRE_ETHOS = 42,
	ALC669_FIXUP_ACER_ASPIRE_ETHOS_HEADSET = 43,
	ALC671_FIXUP_HP_HEADSET_MIC2 = 44,
	ALC662_FIXUP_ACER_X2660G_HEADSET_MODE = 45,
	ALC662_FIXUP_ACER_NITRO_HEADSET_MODE = 46,
	ALC668_FIXUP_ASUS_NO_HEADSET_MIC = 47,
	ALC668_FIXUP_HEADSET_MIC = 48,
	ALC668_FIXUP_MIC_DET_COEF = 49,
	ALC897_FIXUP_LENOVO_HEADSET_MIC = 50,
	ALC897_FIXUP_HEADSET_MIC_PIN = 51,
	ALC897_FIXUP_HP_HSMIC_VERB = 52,
	ALC897_FIXUP_LENOVO_HEADSET_MODE = 53,
	ALC897_FIXUP_HEADSET_MIC_PIN2 = 54,
	ALC897_FIXUP_UNIS_H3C_X500S = 55,
	ALC897_FIXUP_HEADSET_MIC_PIN3 = 56,
};

enum {
	ALC861_FIXUP_FSC_AMILO_PI1505 = 0,
	ALC861_FIXUP_AMP_VREF_0F = 1,
	ALC861_FIXUP_NO_JACK_DETECT = 2,
	ALC861_FIXUP_ASUS_A6RP = 3,
	ALC660_FIXUP_ASUS_W7J = 4,
};

enum {
	ALC880_FIXUP_GPIO1 = 0,
	ALC880_FIXUP_GPIO2 = 1,
	ALC880_FIXUP_MEDION_RIM = 2,
	ALC880_FIXUP_LG = 3,
	ALC880_FIXUP_LG_LW25 = 4,
	ALC880_FIXUP_W810 = 5,
	ALC880_FIXUP_EAPD_COEF = 6,
	ALC880_FIXUP_TCL_S700 = 7,
	ALC880_FIXUP_VOL_KNOB = 8,
	ALC880_FIXUP_FUJITSU = 9,
	ALC880_FIXUP_F1734 = 10,
	ALC880_FIXUP_UNIWILL = 11,
	ALC880_FIXUP_UNIWILL_DIG = 12,
	ALC880_FIXUP_Z71V = 13,
	ALC880_FIXUP_ASUS_W5A = 14,
	ALC880_FIXUP_3ST_BASE = 15,
	ALC880_FIXUP_3ST = 16,
	ALC880_FIXUP_3ST_DIG = 17,
	ALC880_FIXUP_5ST_BASE = 18,
	ALC880_FIXUP_5ST = 19,
	ALC880_FIXUP_5ST_DIG = 20,
	ALC880_FIXUP_6ST_BASE = 21,
	ALC880_FIXUP_6ST = 22,
	ALC880_FIXUP_6ST_DIG = 23,
	ALC880_FIXUP_6ST_AUTOMUTE = 24,
};

enum {
	ALC882_FIXUP_ABIT_AW9D_MAX = 0,
	ALC882_FIXUP_LENOVO_Y530 = 1,
	ALC882_FIXUP_PB_M5210 = 2,
	ALC882_FIXUP_ACER_ASPIRE_7736 = 3,
	ALC882_FIXUP_ASUS_W90V = 4,
	ALC889_FIXUP_CD = 5,
	ALC889_FIXUP_FRONT_HP_NO_PRESENCE = 6,
	ALC889_FIXUP_VAIO_TT = 7,
	ALC888_FIXUP_EEE1601 = 8,
	ALC886_FIXUP_EAPD = 9,
	ALC882_FIXUP_EAPD = 10,
	ALC883_FIXUP_EAPD = 11,
	ALC883_FIXUP_ACER_EAPD = 12,
	ALC882_FIXUP_GPIO1 = 13,
	ALC882_FIXUP_GPIO2 = 14,
	ALC882_FIXUP_GPIO3 = 15,
	ALC889_FIXUP_COEF = 16,
	ALC882_FIXUP_ASUS_W2JC = 17,
	ALC882_FIXUP_ACER_ASPIRE_4930G = 18,
	ALC882_FIXUP_ACER_ASPIRE_8930G = 19,
	ALC882_FIXUP_ASPIRE_8930G_VERBS = 20,
	ALC885_FIXUP_MACPRO_GPIO = 21,
	ALC889_FIXUP_DAC_ROUTE = 22,
	ALC889_FIXUP_MBP_VREF = 23,
	ALC889_FIXUP_IMAC91_VREF = 24,
	ALC889_FIXUP_MBA11_VREF = 25,
	ALC889_FIXUP_MBA21_VREF = 26,
	ALC889_FIXUP_MP11_VREF = 27,
	ALC889_FIXUP_MP41_VREF = 28,
	ALC882_FIXUP_INV_DMIC = 29,
	ALC882_FIXUP_NO_PRIMARY_HP = 30,
	ALC887_FIXUP_ASUS_BASS = 31,
	ALC887_FIXUP_BASS_CHMAP = 32,
	ALC1220_FIXUP_GB_DUAL_CODECS = 33,
	ALC1220_FIXUP_GB_X570 = 34,
	ALC1220_FIXUP_CLEVO_P950 = 35,
	ALC1220_FIXUP_CLEVO_PB51ED = 36,
	ALC1220_FIXUP_CLEVO_PB51ED_PINS = 37,
	ALC887_FIXUP_ASUS_AUDIO = 38,
	ALC887_FIXUP_ASUS_HMIC = 39,
	ALCS1200A_FIXUP_MIC_VREF = 40,
	ALC888VD_FIXUP_MIC_100VREF = 41,
};

enum {
	ALC_HEADSET_MODE_UNKNOWN = 0,
	ALC_HEADSET_MODE_UNPLUGGED = 1,
	ALC_HEADSET_MODE_HEADSET = 2,
	ALC_HEADSET_MODE_MIC = 3,
	ALC_HEADSET_MODE_HEADPHONE = 4,
};

enum {
	ALC_HEADSET_TYPE_UNKNOWN = 0,
	ALC_HEADSET_TYPE_CTIA = 1,
	ALC_HEADSET_TYPE_OMTP = 2,
};

enum {
	ALC_INIT_UNDEFINED = 0,
	ALC_INIT_NONE = 1,
	ALC_INIT_DEFAULT = 2,
};

enum {
	ALC_KEY_MICMUTE_INDEX = 0,
};

enum {
	AML_FIELD_ACCESS_ANY = 0,
	AML_FIELD_ACCESS_BYTE = 1,
	AML_FIELD_ACCESS_WORD = 2,
	AML_FIELD_ACCESS_DWORD = 3,
	AML_FIELD_ACCESS_QWORD = 4,
	AML_FIELD_ACCESS_BUFFER = 5,
};

enum {
	AML_FIELD_ATTRIB_QUICK = 2,
	AML_FIELD_ATTRIB_SEND_RECEIVE = 4,
	AML_FIELD_ATTRIB_BYTE = 6,
	AML_FIELD_ATTRIB_WORD = 8,
	AML_FIELD_ATTRIB_BLOCK = 10,
	AML_FIELD_ATTRIB_BYTES = 11,
	AML_FIELD_ATTRIB_PROCESS_CALL = 12,
	AML_FIELD_ATTRIB_BLOCK_PROCESS_CALL = 13,
	AML_FIELD_ATTRIB_RAW_BYTES = 14,
	AML_FIELD_ATTRIB_RAW_PROCESS_BYTES = 15,
};

enum {
	AML_FIELD_UPDATE_PRESERVE = 0,
	AML_FIELD_UPDATE_WRITE_AS_ONES = 32,
	AML_FIELD_UPDATE_WRITE_AS_ZEROS = 64,
};

enum {
	ASCII_NULL = 0,
	ASCII_BELL = 7,
	ASCII_BACKSPACE = 8,
	ASCII_IGNORE_FIRST = 8,
	ASCII_HTAB = 9,
	ASCII_LINEFEED = 10,
	ASCII_VTAB = 11,
	ASCII_FORMFEED = 12,
	ASCII_CAR_RET = 13,
	ASCII_IGNORE_LAST = 13,
	ASCII_SHIFTOUT = 14,
	ASCII_SHIFTIN = 15,
	ASCII_CANCEL = 24,
	ASCII_SUBSTITUTE = 26,
	ASCII_ESCAPE = 27,
	ASCII_CSI_IGNORE_FIRST = 32,
	ASCII_CSI_IGNORE_LAST = 63,
	ASCII_DEL = 127,
	ASCII_EXT_CSI = 155,
};

enum {
	ASSUME_PERFECT = 255,
	ASSUME_VALID_DTB = 1,
	ASSUME_VALID_INPUT = 2,
	ASSUME_LATEST = 4,
	ASSUME_NO_ROLLBACK = 8,
	ASSUME_LIBFDT_ORDER = 16,
	ASSUME_LIBFDT_FLAWLESS = 32,
};

enum {
	ATA_EH_SPDN_NCQ_OFF = 1,
	ATA_EH_SPDN_SPEED_DOWN = 2,
	ATA_EH_SPDN_FALLBACK_TO_PIO = 4,
	ATA_EH_SPDN_KEEP_ERRORS = 8,
	ATA_EFLAG_IS_IO = 1,
	ATA_EFLAG_DUBIOUS_XFER = 2,
	ATA_EFLAG_OLD_ER = -2147483648,
	ATA_ECAT_NONE = 0,
	ATA_ECAT_ATA_BUS = 1,
	ATA_ECAT_TOUT_HSM = 2,
	ATA_ECAT_UNK_DEV = 3,
	ATA_ECAT_DUBIOUS_NONE = 4,
	ATA_ECAT_DUBIOUS_ATA_BUS = 5,
	ATA_ECAT_DUBIOUS_TOUT_HSM = 6,
	ATA_ECAT_DUBIOUS_UNK_DEV = 7,
	ATA_ECAT_NR = 8,
	ATA_EH_CMD_DFL_TIMEOUT = 5000,
	ATA_EH_RESET_COOL_DOWN = 5000,
	ATA_EH_PRERESET_TIMEOUT = 10000,
	ATA_EH_FASTDRAIN_INTERVAL = 3000,
	ATA_EH_UA_TRIES = 5,
	ATA_EH_PROBE_TRIAL_INTERVAL = 60000,
	ATA_EH_PROBE_TRIALS = 2,
};

enum {
	ATA_MAX_DEVICES = 2,
	ATA_MAX_PRD = 256,
	ATA_SECT_SIZE = 512,
	ATA_MAX_SECTORS_128 = 128,
	ATA_MAX_SECTORS = 256,
	ATA_MAX_SECTORS_1024 = 1024,
	ATA_MAX_SECTORS_LBA48 = 65535,
	ATA_MAX_SECTORS_TAPE = 65535,
	ATA_MAX_TRIM_RNUM = 64,
	ATA_ID_WORDS = 256,
	ATA_ID_CONFIG = 0,
	ATA_ID_CYLS = 1,
	ATA_ID_HEADS = 3,
	ATA_ID_SECTORS = 6,
	ATA_ID_SERNO = 10,
	ATA_ID_BUF_SIZE = 21,
	ATA_ID_FW_REV = 23,
	ATA_ID_PROD = 27,
	ATA_ID_MAX_MULTSECT = 47,
	ATA_ID_DWORD_IO = 48,
	ATA_ID_TRUSTED = 48,
	ATA_ID_CAPABILITY = 49,
	ATA_ID_OLD_PIO_MODES = 51,
	ATA_ID_OLD_DMA_MODES = 52,
	ATA_ID_FIELD_VALID = 53,
	ATA_ID_CUR_CYLS = 54,
	ATA_ID_CUR_HEADS = 55,
	ATA_ID_CUR_SECTORS = 56,
	ATA_ID_MULTSECT = 59,
	ATA_ID_LBA_CAPACITY = 60,
	ATA_ID_SWDMA_MODES = 62,
	ATA_ID_MWDMA_MODES = 63,
	ATA_ID_PIO_MODES = 64,
	ATA_ID_EIDE_DMA_MIN = 65,
	ATA_ID_EIDE_DMA_TIME = 66,
	ATA_ID_EIDE_PIO = 67,
	ATA_ID_EIDE_PIO_IORDY = 68,
	ATA_ID_ADDITIONAL_SUPP = 69,
	ATA_ID_QUEUE_DEPTH = 75,
	ATA_ID_SATA_CAPABILITY = 76,
	ATA_ID_SATA_CAPABILITY_2 = 77,
	ATA_ID_FEATURE_SUPP = 78,
	ATA_ID_MAJOR_VER = 80,
	ATA_ID_COMMAND_SET_1 = 82,
	ATA_ID_COMMAND_SET_2 = 83,
	ATA_ID_CFSSE = 84,
	ATA_ID_CFS_ENABLE_1 = 85,
	ATA_ID_CFS_ENABLE_2 = 86,
	ATA_ID_CSF_DEFAULT = 87,
	ATA_ID_UDMA_MODES = 88,
	ATA_ID_HW_CONFIG = 93,
	ATA_ID_SPG = 98,
	ATA_ID_LBA_CAPACITY_2 = 100,
	ATA_ID_SECTOR_SIZE = 106,
	ATA_ID_WWN = 108,
	ATA_ID_LOGICAL_SECTOR_SIZE = 117,
	ATA_ID_COMMAND_SET_3 = 119,
	ATA_ID_COMMAND_SET_4 = 120,
	ATA_ID_LAST_LUN = 126,
	ATA_ID_DLF = 128,
	ATA_ID_CSFO = 129,
	ATA_ID_CFA_POWER = 160,
	ATA_ID_CFA_KEY_MGMT = 162,
	ATA_ID_CFA_MODES = 163,
	ATA_ID_DATA_SET_MGMT = 169,
	ATA_ID_SCT_CMD_XPORT = 206,
	ATA_ID_ROT_SPEED = 217,
	ATA_ID_PIO4 = 2,
	ATA_ID_SERNO_LEN = 20,
	ATA_ID_FW_REV_LEN = 8,
	ATA_ID_PROD_LEN = 40,
	ATA_ID_WWN_LEN = 8,
	ATA_PCI_CTL_OFS = 2,
	ATA_PIO0 = 1,
	ATA_PIO1 = 3,
	ATA_PIO2 = 7,
	ATA_PIO3 = 15,
	ATA_PIO4 = 31,
	ATA_PIO5 = 63,
	ATA_PIO6 = 127,
	ATA_PIO4_ONLY = 16,
	ATA_SWDMA0 = 1,
	ATA_SWDMA1 = 3,
	ATA_SWDMA2 = 7,
	ATA_SWDMA2_ONLY = 4,
	ATA_MWDMA0 = 1,
	ATA_MWDMA1 = 3,
	ATA_MWDMA2 = 7,
	ATA_MWDMA3 = 15,
	ATA_MWDMA4 = 31,
	ATA_MWDMA12_ONLY = 6,
	ATA_MWDMA2_ONLY = 4,
	ATA_UDMA0 = 1,
	ATA_UDMA1 = 3,
	ATA_UDMA2 = 7,
	ATA_UDMA3 = 15,
	ATA_UDMA4 = 31,
	ATA_UDMA5 = 63,
	ATA_UDMA6 = 127,
	ATA_UDMA7 = 255,
	ATA_UDMA24_ONLY = 20,
	ATA_UDMA_MASK_40C = 7,
	ATA_PRD_SZ = 8,
	ATA_PRD_TBL_SZ = 2048,
	ATA_PRD_EOT = -2147483648,
	ATA_DMA_TABLE_OFS = 4,
	ATA_DMA_STATUS = 2,
	ATA_DMA_CMD = 0,
	ATA_DMA_WR = 8,
	ATA_DMA_START = 1,
	ATA_DMA_INTR = 4,
	ATA_DMA_ERR = 2,
	ATA_DMA_ACTIVE = 1,
	ATA_HOB = 128,
	ATA_NIEN = 2,
	ATA_LBA = 64,
	ATA_DEV1 = 16,
	ATA_DEVICE_OBS = 160,
	ATA_DEVCTL_OBS = 8,
	ATA_BUSY = 128,
	ATA_DRDY = 64,
	ATA_DF = 32,
	ATA_DSC = 16,
	ATA_DRQ = 8,
	ATA_CORR = 4,
	ATA_SENSE = 2,
	ATA_ERR = 1,
	ATA_SRST = 4,
	ATA_ICRC = 128,
	ATA_BBK = 128,
	ATA_UNC = 64,
	ATA_MC = 32,
	ATA_IDNF = 16,
	ATA_MCR = 8,
	ATA_ABORTED = 4,
	ATA_TRK0NF = 2,
	ATA_AMNF = 1,
	ATAPI_LFS = 240,
	ATAPI_EOM = 2,
	ATAPI_ILI = 1,
	ATAPI_IO = 2,
	ATAPI_COD = 1,
	ATA_REG_DATA = 0,
	ATA_REG_ERR = 1,
	ATA_REG_NSECT = 2,
	ATA_REG_LBAL = 3,
	ATA_REG_LBAM = 4,
	ATA_REG_LBAH = 5,
	ATA_REG_DEVICE = 6,
	ATA_REG_STATUS = 7,
	ATA_REG_FEATURE = 1,
	ATA_REG_CMD = 7,
	ATA_REG_BYTEL = 4,
	ATA_REG_BYTEH = 5,
	ATA_REG_DEVSEL = 6,
	ATA_REG_IRQ = 2,
	ATA_CMD_DEV_RESET = 8,
	ATA_CMD_CHK_POWER = 229,
	ATA_CMD_STANDBY = 226,
	ATA_CMD_IDLE = 227,
	ATA_CMD_EDD = 144,
	ATA_CMD_DOWNLOAD_MICRO = 146,
	ATA_CMD_DOWNLOAD_MICRO_DMA = 147,
	ATA_CMD_NOP = 0,
	ATA_CMD_FLUSH = 231,
	ATA_CMD_FLUSH_EXT = 234,
	ATA_CMD_ID_ATA = 236,
	ATA_CMD_ID_ATAPI = 161,
	ATA_CMD_SERVICE = 162,
	ATA_CMD_READ = 200,
	ATA_CMD_READ_EXT = 37,
	ATA_CMD_READ_QUEUED = 38,
	ATA_CMD_READ_STREAM_EXT = 43,
	ATA_CMD_READ_STREAM_DMA_EXT = 42,
	ATA_CMD_WRITE = 202,
	ATA_CMD_WRITE_EXT = 53,
	ATA_CMD_WRITE_QUEUED = 54,
	ATA_CMD_WRITE_STREAM_EXT = 59,
	ATA_CMD_WRITE_STREAM_DMA_EXT = 58,
	ATA_CMD_WRITE_FUA_EXT = 61,
	ATA_CMD_WRITE_QUEUED_FUA_EXT = 62,
	ATA_CMD_FPDMA_READ = 96,
	ATA_CMD_FPDMA_WRITE = 97,
	ATA_CMD_NCQ_NON_DATA = 99,
	ATA_CMD_FPDMA_SEND = 100,
	ATA_CMD_FPDMA_RECV = 101,
	ATA_CMD_PIO_READ = 32,
	ATA_CMD_PIO_READ_EXT = 36,
	ATA_CMD_PIO_WRITE = 48,
	ATA_CMD_PIO_WRITE_EXT = 52,
	ATA_CMD_READ_MULTI = 196,
	ATA_CMD_READ_MULTI_EXT = 41,
	ATA_CMD_WRITE_MULTI = 197,
	ATA_CMD_WRITE_MULTI_EXT = 57,
	ATA_CMD_WRITE_MULTI_FUA_EXT = 206,
	ATA_CMD_SET_FEATURES = 239,
	ATA_CMD_SET_MULTI = 198,
	ATA_CMD_PACKET = 160,
	ATA_CMD_VERIFY = 64,
	ATA_CMD_VERIFY_EXT = 66,
	ATA_CMD_WRITE_UNCORR_EXT = 69,
	ATA_CMD_STANDBYNOW1 = 224,
	ATA_CMD_IDLEIMMEDIATE = 225,
	ATA_CMD_SLEEP = 230,
	ATA_CMD_INIT_DEV_PARAMS = 145,
	ATA_CMD_READ_NATIVE_MAX = 248,
	ATA_CMD_READ_NATIVE_MAX_EXT = 39,
	ATA_CMD_SET_MAX = 249,
	ATA_CMD_SET_MAX_EXT = 55,
	ATA_CMD_READ_LOG_EXT = 47,
	ATA_CMD_WRITE_LOG_EXT = 63,
	ATA_CMD_READ_LOG_DMA_EXT = 71,
	ATA_CMD_WRITE_LOG_DMA_EXT = 87,
	ATA_CMD_TRUSTED_NONDATA = 91,
	ATA_CMD_TRUSTED_RCV = 92,
	ATA_CMD_TRUSTED_RCV_DMA = 93,
	ATA_CMD_TRUSTED_SND = 94,
	ATA_CMD_TRUSTED_SND_DMA = 95,
	ATA_CMD_PMP_READ = 228,
	ATA_CMD_PMP_READ_DMA = 233,
	ATA_CMD_PMP_WRITE = 232,
	ATA_CMD_PMP_WRITE_DMA = 235,
	ATA_CMD_CONF_OVERLAY = 177,
	ATA_CMD_SEC_SET_PASS = 241,
	ATA_CMD_SEC_UNLOCK = 242,
	ATA_CMD_SEC_ERASE_PREP = 243,
	ATA_CMD_SEC_ERASE_UNIT = 244,
	ATA_CMD_SEC_FREEZE_LOCK = 245,
	ATA_CMD_SEC_DISABLE_PASS = 246,
	ATA_CMD_CONFIG_STREAM = 81,
	ATA_CMD_SMART = 176,
	ATA_CMD_MEDIA_LOCK = 222,
	ATA_CMD_MEDIA_UNLOCK = 223,
	ATA_CMD_DSM = 6,
	ATA_CMD_CHK_MED_CRD_TYP = 209,
	ATA_CMD_CFA_REQ_EXT_ERR = 3,
	ATA_CMD_CFA_WRITE_NE = 56,
	ATA_CMD_CFA_TRANS_SECT = 135,
	ATA_CMD_CFA_ERASE = 192,
	ATA_CMD_CFA_WRITE_MULT_NE = 205,
	ATA_CMD_REQ_SENSE_DATA = 11,
	ATA_CMD_SANITIZE_DEVICE = 180,
	ATA_CMD_ZAC_MGMT_IN = 74,
	ATA_CMD_ZAC_MGMT_OUT = 159,
	ATA_CMD_RESTORE = 16,
	ATA_SUBCMD_FPDMA_RECV_RD_LOG_DMA_EXT = 1,
	ATA_SUBCMD_FPDMA_RECV_ZAC_MGMT_IN = 2,
	ATA_SUBCMD_FPDMA_SEND_DSM = 0,
	ATA_SUBCMD_FPDMA_SEND_WR_LOG_DMA_EXT = 2,
	ATA_SUBCMD_NCQ_NON_DATA_ABORT_QUEUE = 0,
	ATA_SUBCMD_NCQ_NON_DATA_SET_FEATURES = 5,
	ATA_SUBCMD_NCQ_NON_DATA_ZERO_EXT = 6,
	ATA_SUBCMD_NCQ_NON_DATA_ZAC_MGMT_OUT = 7,
	ATA_SUBCMD_ZAC_MGMT_IN_REPORT_ZONES = 0,
	ATA_SUBCMD_ZAC_MGMT_OUT_CLOSE_ZONE = 1,
	ATA_SUBCMD_ZAC_MGMT_OUT_FINISH_ZONE = 2,
	ATA_SUBCMD_ZAC_MGMT_OUT_OPEN_ZONE = 3,
	ATA_SUBCMD_ZAC_MGMT_OUT_RESET_WRITE_POINTER = 4,
	ATA_LOG_DIRECTORY = 0,
	ATA_LOG_SATA_NCQ = 16,
	ATA_LOG_NCQ_NON_DATA = 18,
	ATA_LOG_NCQ_SEND_RECV = 19,
	ATA_LOG_CDL = 24,
	ATA_LOG_CDL_SIZE = 512,
	ATA_LOG_IDENTIFY_DEVICE = 48,
	ATA_LOG_SENSE_NCQ = 15,
	ATA_LOG_SENSE_NCQ_SIZE = 1024,
	ATA_LOG_CONCURRENT_POSITIONING_RANGES = 71,
	ATA_LOG_SUPPORTED_CAPABILITIES = 3,
	ATA_LOG_CURRENT_SETTINGS = 4,
	ATA_LOG_SECURITY = 6,
	ATA_LOG_SATA_SETTINGS = 8,
	ATA_LOG_ZONED_INFORMATION = 9,
	ATA_LOG_DEVSLP_OFFSET = 48,
	ATA_LOG_DEVSLP_SIZE = 8,
	ATA_LOG_DEVSLP_MDAT = 0,
	ATA_LOG_DEVSLP_MDAT_MASK = 31,
	ATA_LOG_DEVSLP_DETO = 1,
	ATA_LOG_DEVSLP_VALID = 7,
	ATA_LOG_DEVSLP_VALID_MASK = 128,
	ATA_LOG_NCQ_PRIO_OFFSET = 9,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_DSM = 1,
	ATA_LOG_NCQ_SEND_RECV_DSM_OFFSET = 4,
	ATA_LOG_NCQ_SEND_RECV_DSM_TRIM = 1,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_OFFSET = 8,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_OFFSET = 12,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OFFSET = 16,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OUT_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_IN_SUPPORTED = 2,
	ATA_LOG_NCQ_SEND_RECV_SIZE = 20,
	ATA_LOG_NCQ_NON_DATA_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_NCQ = 1,
	ATA_LOG_NCQ_NON_DATA_ABORT_ALL = 2,
	ATA_LOG_NCQ_NON_DATA_ABORT_STREAMING = 4,
	ATA_LOG_NCQ_NON_DATA_ABORT_NON_STREAMING = 8,
	ATA_LOG_NCQ_NON_DATA_ABORT_SELECTED = 16,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OFFSET = 28,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OUT = 1,
	ATA_LOG_NCQ_NON_DATA_SIZE = 64,
	ATA_CMD_READ_LONG = 34,
	ATA_CMD_READ_LONG_ONCE = 35,
	ATA_CMD_WRITE_LONG = 50,
	ATA_CMD_WRITE_LONG_ONCE = 51,
	SETFEATURES_XFER = 3,
	XFER_UDMA_7 = 71,
	XFER_UDMA_6 = 70,
	XFER_UDMA_5 = 69,
	XFER_UDMA_4 = 68,
	XFER_UDMA_3 = 67,
	XFER_UDMA_2 = 66,
	XFER_UDMA_1 = 65,
	XFER_UDMA_0 = 64,
	XFER_MW_DMA_4 = 36,
	XFER_MW_DMA_3 = 35,
	XFER_MW_DMA_2 = 34,
	XFER_MW_DMA_1 = 33,
	XFER_MW_DMA_0 = 32,
	XFER_SW_DMA_2 = 18,
	XFER_SW_DMA_1 = 17,
	XFER_SW_DMA_0 = 16,
	XFER_PIO_6 = 14,
	XFER_PIO_5 = 13,
	XFER_PIO_4 = 12,
	XFER_PIO_3 = 11,
	XFER_PIO_2 = 10,
	XFER_PIO_1 = 9,
	XFER_PIO_0 = 8,
	XFER_PIO_SLOW = 0,
	SETFEATURES_WC_ON = 2,
	SETFEATURES_WC_OFF = 130,
	SETFEATURES_RA_ON = 170,
	SETFEATURES_RA_OFF = 85,
	SETFEATURES_AAM_ON = 66,
	SETFEATURES_AAM_OFF = 194,
	SETFEATURES_SPINUP = 7,
	SETFEATURES_SPINUP_TIMEOUT = 30000,
	SETFEATURES_SATA_ENABLE = 16,
	SETFEATURES_SATA_DISABLE = 144,
	SETFEATURES_CDL = 13,
	SATA_FPDMA_OFFSET = 1,
	SATA_FPDMA_AA = 2,
	SATA_DIPM = 3,
	SATA_FPDMA_IN_ORDER = 4,
	SATA_AN = 5,
	SATA_SSP = 6,
	SATA_DEVSLP = 9,
	SETFEATURE_SENSE_DATA = 195,
	SETFEATURE_SENSE_DATA_SUCC_NCQ = 196,
	ATA_SET_MAX_ADDR = 0,
	ATA_SET_MAX_PASSWD = 1,
	ATA_SET_MAX_LOCK = 2,
	ATA_SET_MAX_UNLOCK = 3,
	ATA_SET_MAX_FREEZE_LOCK = 4,
	ATA_SET_MAX_PASSWD_DMA = 5,
	ATA_SET_MAX_UNLOCK_DMA = 6,
	ATA_DCO_RESTORE = 192,
	ATA_DCO_FREEZE_LOCK = 193,
	ATA_DCO_IDENTIFY = 194,
	ATA_DCO_SET = 195,
	ATA_SMART_ENABLE = 216,
	ATA_SMART_READ_VALUES = 208,
	ATA_SMART_READ_THRESHOLDS = 209,
	ATA_DSM_TRIM = 1,
	ATA_SMART_LBAM_PASS = 79,
	ATA_SMART_LBAH_PASS = 194,
	ATAPI_PKT_DMA = 1,
	ATAPI_DMADIR = 4,
	ATAPI_CDB_LEN = 16,
	SATA_PMP_MAX_PORTS = 15,
	SATA_PMP_CTRL_PORT = 15,
	SATA_PMP_GSCR_DWORDS = 128,
	SATA_PMP_GSCR_PROD_ID = 0,
	SATA_PMP_GSCR_REV = 1,
	SATA_PMP_GSCR_PORT_INFO = 2,
	SATA_PMP_GSCR_ERROR = 32,
	SATA_PMP_GSCR_ERROR_EN = 33,
	SATA_PMP_GSCR_FEAT = 64,
	SATA_PMP_GSCR_FEAT_EN = 96,
	SATA_PMP_PSCR_STATUS = 0,
	SATA_PMP_PSCR_ERROR = 1,
	SATA_PMP_PSCR_CONTROL = 2,
	SATA_PMP_FEAT_BIST = 1,
	SATA_PMP_FEAT_PMREQ = 2,
	SATA_PMP_FEAT_DYNSSC = 4,
	SATA_PMP_FEAT_NOTIFY = 8,
	ATA_CBL_NONE = 0,
	ATA_CBL_PATA40 = 1,
	ATA_CBL_PATA80 = 2,
	ATA_CBL_PATA40_SHORT = 3,
	ATA_CBL_PATA_UNK = 4,
	ATA_CBL_PATA_IGN = 5,
	ATA_CBL_SATA = 6,
	SCR_STATUS = 0,
	SCR_ERROR = 1,
	SCR_CONTROL = 2,
	SCR_ACTIVE = 3,
	SCR_NOTIFICATION = 4,
	SERR_DATA_RECOVERED = 1,
	SERR_COMM_RECOVERED = 2,
	SERR_DATA = 256,
	SERR_PERSISTENT = 512,
	SERR_PROTOCOL = 1024,
	SERR_INTERNAL = 2048,
	SERR_PHYRDY_CHG = 65536,
	SERR_PHY_INT_ERR = 131072,
	SERR_COMM_WAKE = 262144,
	SERR_10B_8B_ERR = 524288,
	SERR_DISPARITY = 1048576,
	SERR_CRC = 2097152,
	SERR_HANDSHAKE = 4194304,
	SERR_LINK_SEQ_ERR = 8388608,
	SERR_TRANS_ST_ERROR = 16777216,
	SERR_UNRECOG_FIS = 33554432,
	SERR_DEV_XCHG = 67108864,
};

enum {
	ATA_READID_POSTRESET = 1,
	ATA_DNXFER_PIO = 0,
	ATA_DNXFER_DMA = 1,
	ATA_DNXFER_40C = 2,
	ATA_DNXFER_FORCE_PIO = 3,
	ATA_DNXFER_FORCE_PIO0 = 4,
	ATA_DNXFER_QUIET = -2147483648,
};

enum {
	ATIIXP_IDE_PIO_TIMING = 64,
	ATIIXP_IDE_MWDMA_TIMING = 68,
	ATIIXP_IDE_PIO_CONTROL = 72,
	ATIIXP_IDE_PIO_MODE = 74,
	ATIIXP_IDE_UDMA_CONTROL = 84,
	ATIIXP_IDE_UDMA_MODE = 86,
};

enum {
	AT_PKT_END = -1,
	BEYOND_PKT_END = -2,
};

enum {
	AUTOFS_DEV_IOCTL_VERSION_CMD = 113,
	AUTOFS_DEV_IOCTL_PROTOVER_CMD = 114,
	AUTOFS_DEV_IOCTL_PROTOSUBVER_CMD = 115,
	AUTOFS_DEV_IOCTL_OPENMOUNT_CMD = 116,
	AUTOFS_DEV_IOCTL_CLOSEMOUNT_CMD = 117,
	AUTOFS_DEV_IOCTL_READY_CMD = 118,
	AUTOFS_DEV_IOCTL_FAIL_CMD = 119,
	AUTOFS_DEV_IOCTL_SETPIPEFD_CMD = 120,
	AUTOFS_DEV_IOCTL_CATATONIC_CMD = 121,
	AUTOFS_DEV_IOCTL_TIMEOUT_CMD = 122,
	AUTOFS_DEV_IOCTL_REQUESTER_CMD = 123,
	AUTOFS_DEV_IOCTL_EXPIRE_CMD = 124,
	AUTOFS_DEV_IOCTL_ASKUMOUNT_CMD = 125,
	AUTOFS_DEV_IOCTL_ISMOUNTPOINT_CMD = 126,
};

enum {
	AUTOFS_IOC_EXPIRE_MULTI_CMD = 102,
	AUTOFS_IOC_PROTOSUBVER_CMD = 103,
	AUTOFS_IOC_ASKUMOUNT_CMD = 112,
};

enum {
	AUTOFS_IOC_READY_CMD = 96,
	AUTOFS_IOC_FAIL_CMD = 97,
	AUTOFS_IOC_CATATONIC_CMD = 98,
	AUTOFS_IOC_PROTOVER_CMD = 99,
	AUTOFS_IOC_SETTIMEOUT_CMD = 100,
	AUTOFS_IOC_EXPIRE_CMD = 101,
};

enum {
	AUTOP_INVALID = 0,
	AUTOP_HDD = 1,
	AUTOP_SSD_QD1 = 2,
	AUTOP_SSD_DFL = 3,
	AUTOP_SSD_FAST = 4,
};

enum {
	AUTO_PIN_LINE_OUT = 0,
	AUTO_PIN_SPEAKER_OUT = 1,
	AUTO_PIN_HP_OUT = 2,
};

enum {
	AUTO_PIN_MIC = 0,
	AUTO_PIN_LINE_IN = 1,
	AUTO_PIN_CD = 2,
	AUTO_PIN_AUX = 3,
	AUTO_PIN_LAST = 4,
};

enum {
	AX25_VALUES_IPDEFMODE = 0,
	AX25_VALUES_AXDEFMODE = 1,
	AX25_VALUES_BACKOFF = 2,
	AX25_VALUES_CONMODE = 3,
	AX25_VALUES_WINDOW = 4,
	AX25_VALUES_EWINDOW = 5,
	AX25_VALUES_T1 = 6,
	AX25_VALUES_T2 = 7,
	AX25_VALUES_T3 = 8,
	AX25_VALUES_IDLE = 9,
	AX25_VALUES_N2 = 10,
	AX25_VALUES_PACLEN = 11,
	AX25_VALUES_PROTOCOL = 12,
	AX25_MAX_VALUES = 13,
};

enum {
	AZX_DRIVER_ICH = 0,
	AZX_DRIVER_PCH = 1,
	AZX_DRIVER_SCH = 2,
	AZX_DRIVER_SKL = 3,
	AZX_DRIVER_HDMI = 4,
	AZX_DRIVER_ATI = 5,
	AZX_DRIVER_ATIHDMI = 6,
	AZX_DRIVER_ATIHDMI_NS = 7,
	AZX_DRIVER_GFHDMI = 8,
	AZX_DRIVER_VIA = 9,
	AZX_DRIVER_SIS = 10,
	AZX_DRIVER_ULI = 11,
	AZX_DRIVER_NVIDIA = 12,
	AZX_DRIVER_TERA = 13,
	AZX_DRIVER_CTX = 14,
	AZX_DRIVER_CTHDA = 15,
	AZX_DRIVER_CMEDIA = 16,
	AZX_DRIVER_ZHAOXIN = 17,
	AZX_DRIVER_LOONGSON = 18,
	AZX_DRIVER_GENERIC = 19,
	AZX_NUM_DRIVERS = 20,
};

enum {
	AZX_SNOOP_TYPE_NONE = 0,
	AZX_SNOOP_TYPE_SCH = 1,
	AZX_SNOOP_TYPE_ATI = 2,
	AZX_SNOOP_TYPE_NVIDIA = 3,
};

enum {
	Audit_equal = 0,
	Audit_not_equal = 1,
	Audit_bitmask = 2,
	Audit_bittest = 3,
	Audit_lt = 4,
	Audit_gt = 5,
	Audit_le = 6,
	Audit_ge = 7,
	Audit_bad = 8,
};

enum {
	BAD_NO_PRIMARY_DAC = 65536,
	BAD_NO_DAC = 16384,
	BAD_MULTI_IO = 288,
	BAD_NO_EXTRA_DAC = 258,
	BAD_NO_EXTRA_SURR_DAC = 257,
	BAD_SHARED_SURROUND = 256,
	BAD_NO_INDEP_HP = 16,
	BAD_SHARED_CLFE = 16,
	BAD_SHARED_EXTRA_SURROUND = 16,
	BAD_SHARED_VOL = 16,
};

enum {
	BCM5706 = 0,
	NC370T = 1,
	NC370I = 2,
	BCM5706S = 3,
	NC370F = 4,
	BCM5708 = 5,
	BCM5708S = 6,
	BCM5709 = 7,
	BCM5709S = 8,
	BCM5716 = 9,
	BCM5716S = 10,
};

enum {
	BIAS = 2147483648,
};

enum {
	BIOSET_NEED_BVECS = 1,
	BIOSET_NEED_RESCUER = 2,
	BIOSET_PERCPU_CACHE = 4,
};

enum {
	BIO_PAGE_PINNED = 0,
	BIO_CLONED = 1,
	BIO_BOUNCED = 2,
	BIO_QUIET = 3,
	BIO_CHAIN = 4,
	BIO_REFFED = 5,
	BIO_BPS_THROTTLED = 6,
	BIO_TRACE_COMPLETION = 7,
	BIO_CGROUP_ACCT = 8,
	BIO_QOS_THROTTLED = 9,
	BIO_QOS_MERGED = 10,
	BIO_REMAPPED = 11,
	BIO_ZONE_WRITE_PLUGGING = 12,
	BIO_EMULATES_ZONE_APPEND = 13,
	BIO_FLAG_LAST = 14,
};

enum {
	BLK_MQ_F_TAG_QUEUE_SHARED = 2,
	BLK_MQ_F_STACKING = 4,
	BLK_MQ_F_TAG_HCTX_SHARED = 8,
	BLK_MQ_F_BLOCKING = 16,
	BLK_MQ_F_TAG_RR = 32,
	BLK_MQ_F_NO_SCHED_BY_DEFAULT = 64,
	BLK_MQ_F_MAX = 128,
};

enum {
	BLK_MQ_NO_TAG = 4294967295,
	BLK_MQ_TAG_MIN = 1,
	BLK_MQ_TAG_MAX = 4294967294,
};

enum {
	BLK_MQ_REQ_NOWAIT = 1,
	BLK_MQ_REQ_RESERVED = 2,
	BLK_MQ_REQ_PM = 4,
};

enum {
	BLK_MQ_S_STOPPED = 0,
	BLK_MQ_S_TAG_ACTIVE = 1,
	BLK_MQ_S_SCHED_RESTART = 2,
	BLK_MQ_S_INACTIVE = 3,
	BLK_MQ_S_MAX = 4,
};

enum {
	BLK_MQ_UNIQUE_TAG_BITS = 16,
	BLK_MQ_UNIQUE_TAG_MASK = 65535,
};

enum {
	BLOCK_BITMAP = 0,
	INODE_BITMAP = 1,
	INODE_TABLE = 2,
	GROUP_TABLE_COUNT = 3,
};

enum {
	BPF_ADJ_ROOM_ENCAP_L2_MASK = 255,
	BPF_ADJ_ROOM_ENCAP_L2_SHIFT = 56,
};

enum {
	BPF_ANY = 0,
	BPF_NOEXIST = 1,
	BPF_EXIST = 2,
	BPF_F_LOCK = 4,
};

enum {
	BPF_CSUM_LEVEL_QUERY = 0,
	BPF_CSUM_LEVEL_INC = 1,
	BPF_CSUM_LEVEL_DEC = 2,
	BPF_CSUM_LEVEL_RESET = 3,
};

enum {
	BPF_FIB_LKUP_RET_SUCCESS = 0,
	BPF_FIB_LKUP_RET_BLACKHOLE = 1,
	BPF_FIB_LKUP_RET_UNREACHABLE = 2,
	BPF_FIB_LKUP_RET_PROHIBIT = 3,
	BPF_FIB_LKUP_RET_NOT_FWDED = 4,
	BPF_FIB_LKUP_RET_FWD_DISABLED = 5,
	BPF_FIB_LKUP_RET_UNSUPP_LWT = 6,
	BPF_FIB_LKUP_RET_NO_NEIGH = 7,
	BPF_FIB_LKUP_RET_FRAG_NEEDED = 8,
	BPF_FIB_LKUP_RET_NO_SRC_ADDR = 9,
};

enum {
	BPF_FIB_LOOKUP_DIRECT = 1,
	BPF_FIB_LOOKUP_OUTPUT = 2,
	BPF_FIB_LOOKUP_SKIP_NEIGH = 4,
	BPF_FIB_LOOKUP_TBID = 8,
	BPF_FIB_LOOKUP_SRC = 16,
	BPF_FIB_LOOKUP_MARK = 32,
};

enum {
	BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG = 1,
	BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL = 2,
	BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP = 4,
};

enum {
	BPF_F_ADJ_ROOM_FIXED_GSO = 1,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV4 = 2,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV6 = 4,
	BPF_F_ADJ_ROOM_ENCAP_L4_GRE = 8,
	BPF_F_ADJ_ROOM_ENCAP_L4_UDP = 16,
	BPF_F_ADJ_ROOM_NO_CSUM_RESET = 32,
	BPF_F_ADJ_ROOM_ENCAP_L2_ETH = 64,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV4 = 128,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV6 = 256,
};

enum {
	BPF_F_CURRENT_NETNS = -1,
};

enum {
	BPF_F_GET_BRANCH_RECORDS_SIZE = 1,
};

enum {
	BPF_F_HDR_FIELD_MASK = 15,
};

enum {
	BPF_F_INDEX_MASK = 4294967295ULL,
	BPF_F_CURRENT_CPU = 4294967295ULL,
	BPF_F_CTXLEN_MASK = 4503595332403200ULL,
};

enum {
	BPF_F_INGRESS = 1,
	BPF_F_BROADCAST = 8,
	BPF_F_EXCLUDE_INGRESS = 16,
};

enum {
	BPF_F_NEIGH = 65536,
	BPF_F_PEER = 131072,
	BPF_F_NEXTHOP = 262144,
};

enum {
	BPF_F_NO_PREALLOC = 1,
	BPF_F_NO_COMMON_LRU = 2,
	BPF_F_NUMA_NODE = 4,
	BPF_F_RDONLY = 8,
	BPF_F_WRONLY = 16,
	BPF_F_STACK_BUILD_ID = 32,
	BPF_F_ZERO_SEED = 64,
	BPF_F_RDONLY_PROG = 128,
	BPF_F_WRONLY_PROG = 256,
	BPF_F_CLONE = 512,
	BPF_F_MMAPABLE = 1024,
	BPF_F_PRESERVE_ELEMS = 2048,
	BPF_F_INNER_MAP = 4096,
	BPF_F_LINK = 8192,
	BPF_F_PATH_FD = 16384,
	BPF_F_VTYPE_BTF_OBJ_FD = 32768,
	BPF_F_TOKEN_FD = 65536,
	BPF_F_SEGV_ON_FAULT = 131072,
	BPF_F_NO_USER_CONV = 262144,
};

enum {
	BPF_F_PSEUDO_HDR = 16,
	BPF_F_MARK_MANGLED_0 = 32,
	BPF_F_MARK_ENFORCE = 64,
};

enum {
	BPF_F_RECOMPUTE_CSUM = 1,
	BPF_F_INVALIDATE_HASH = 2,
};

enum {
	BPF_F_SKIP_FIELD_MASK = 255,
	BPF_F_USER_STACK = 256,
	BPF_F_FAST_STACK_CMP = 512,
	BPF_F_REUSE_STACKID = 1024,
	BPF_F_USER_BUILD_ID = 2048,
};

enum {
	BPF_F_SYSCTL_BASE_NAME = 1,
};

enum {
	BPF_F_TIMER_ABS = 1,
	BPF_F_TIMER_CPU_PIN = 2,
};

enum {
	BPF_F_TUNINFO_FLAGS = 16,
};

enum {
	BPF_F_TUNINFO_IPV6 = 1,
};

enum {
	BPF_F_UPROBE_MULTI_RETURN = 1,
};

enum {
	BPF_F_ZERO_CSUM_TX = 2,
	BPF_F_DONT_FRAGMENT = 4,
	BPF_F_SEQ_NUMBER = 8,
	BPF_F_NO_TUNNEL_KEY = 16,
};

enum {
	BPF_LOAD_HDR_OPT_TCP_SYN = 1,
};

enum {
	BPF_LOCAL_STORAGE_GET_F_CREATE = 1,
	BPF_SK_STORAGE_GET_F_CREATE = 1,
};

enum {
	BPF_MAX_LOOPS = 8388608,
};

enum {
	BPF_MAX_TRAMP_LINKS = 38,
};

enum {
	BPF_RB_AVAIL_DATA = 0,
	BPF_RB_RING_SIZE = 1,
	BPF_RB_CONS_POS = 2,
	BPF_RB_PROD_POS = 3,
};

enum {
	BPF_RB_NO_WAKEUP = 1,
	BPF_RB_FORCE_WAKEUP = 2,
};

enum {
	BPF_REG_0 = 0,
	BPF_REG_1 = 1,
	BPF_REG_2 = 2,
	BPF_REG_3 = 3,
	BPF_REG_4 = 4,
	BPF_REG_5 = 5,
	BPF_REG_6 = 6,
	BPF_REG_7 = 7,
	BPF_REG_8 = 8,
	BPF_REG_9 = 9,
	BPF_REG_10 = 10,
	__MAX_BPF_REG = 11,
};

enum {
	BPF_RINGBUF_BUSY_BIT = 2147483648,
	BPF_RINGBUF_DISCARD_BIT = 1073741824,
	BPF_RINGBUF_HDR_SZ = 8,
};

enum {
	BPF_SKB_TSTAMP_UNSPEC = 0,
	BPF_SKB_TSTAMP_DELIVERY_MONO = 1,
	BPF_SKB_CLOCK_REALTIME = 0,
	BPF_SKB_CLOCK_MONOTONIC = 1,
	BPF_SKB_CLOCK_TAI = 2,
};

enum {
	BPF_SK_LOOKUP_F_REPLACE = 1,
	BPF_SK_LOOKUP_F_NO_REUSEPORT = 2,
};

enum {
	BPF_SOCK_OPS_RTO_CB_FLAG = 1,
	BPF_SOCK_OPS_RETRANS_CB_FLAG = 2,
	BPF_SOCK_OPS_STATE_CB_FLAG = 4,
	BPF_SOCK_OPS_RTT_CB_FLAG = 8,
	BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG = 16,
	BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG = 32,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG = 64,
	BPF_SOCK_OPS_ALL_CB_FLAGS = 127,
};

enum {
	BPF_SOCK_OPS_VOID = 0,
	BPF_SOCK_OPS_TIMEOUT_INIT = 1,
	BPF_SOCK_OPS_RWND_INIT = 2,
	BPF_SOCK_OPS_TCP_CONNECT_CB = 3,
	BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB = 4,
	BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB = 5,
	BPF_SOCK_OPS_NEEDS_ECN = 6,
	BPF_SOCK_OPS_BASE_RTT = 7,
	BPF_SOCK_OPS_RTO_CB = 8,
	BPF_SOCK_OPS_RETRANS_CB = 9,
	BPF_SOCK_OPS_STATE_CB = 10,
	BPF_SOCK_OPS_TCP_LISTEN_CB = 11,
	BPF_SOCK_OPS_RTT_CB = 12,
	BPF_SOCK_OPS_PARSE_HDR_OPT_CB = 13,
	BPF_SOCK_OPS_HDR_OPT_LEN_CB = 14,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB = 15,
};

enum {
	BPF_TASK_ITER_ALL_PROCS = 0,
	BPF_TASK_ITER_ALL_THREADS = 1,
	BPF_TASK_ITER_PROC_THREADS = 2,
};

enum {
	BPF_TCP_ESTABLISHED = 1,
	BPF_TCP_SYN_SENT = 2,
	BPF_TCP_SYN_RECV = 3,
	BPF_TCP_FIN_WAIT1 = 4,
	BPF_TCP_FIN_WAIT2 = 5,
	BPF_TCP_TIME_WAIT = 6,
	BPF_TCP_CLOSE = 7,
	BPF_TCP_CLOSE_WAIT = 8,
	BPF_TCP_LAST_ACK = 9,
	BPF_TCP_LISTEN = 10,
	BPF_TCP_CLOSING = 11,
	BPF_TCP_NEW_SYN_RECV = 12,
	BPF_TCP_BOUND_INACTIVE = 13,
	BPF_TCP_MAX_STATES = 14,
};

enum {
	BPF_WRITE_HDR_TCP_CURRENT_MSS = 1,
	BPF_WRITE_HDR_TCP_SYNACK_COOKIE = 2,
};

enum {
	BPF_XFRM_STATE_OPTS_SZ = 36,
};

enum {
	BR_MCAST_DIR_RX = 0,
	BR_MCAST_DIR_TX = 1,
	BR_MCAST_DIR_SIZE = 2,
};

enum {
	BTF_FIELDS_MAX = 11,
};

enum {
	BTF_FIELD_IGNORE = 0,
	BTF_FIELD_FOUND = 1,
};

enum {
	BTF_F_COMPACT = 1,
	BTF_F_NONAME = 2,
	BTF_F_PTR_RAW = 4,
	BTF_F_ZERO = 8,
};

enum {
	BTF_KFUNC_SET_MAX_CNT = 256,
	BTF_DTOR_KFUNC_MAX_CNT = 256,
	BTF_KFUNC_FILTER_MAX_CNT = 16,
};

enum {
	BTF_KIND_UNKN = 0,
	BTF_KIND_INT = 1,
	BTF_KIND_PTR = 2,
	BTF_KIND_ARRAY = 3,
	BTF_KIND_STRUCT = 4,
	BTF_KIND_UNION = 5,
	BTF_KIND_ENUM = 6,
	BTF_KIND_FWD = 7,
	BTF_KIND_TYPEDEF = 8,
	BTF_KIND_VOLATILE = 9,
	BTF_KIND_CONST = 10,
	BTF_KIND_RESTRICT = 11,
	BTF_KIND_FUNC = 12,
	BTF_KIND_FUNC_PROTO = 13,
	BTF_KIND_VAR = 14,
	BTF_KIND_DATASEC = 15,
	BTF_KIND_FLOAT = 16,
	BTF_KIND_DECL_TAG = 17,
	BTF_KIND_TYPE_TAG = 18,
	BTF_KIND_ENUM64 = 19,
	NR_BTF_KINDS = 20,
	BTF_KIND_MAX = 19,
};

enum {
	BTF_MODULE_F_LIVE = 1,
};

enum {
	BTF_SOCK_TYPE_INET = 0,
	BTF_SOCK_TYPE_INET_CONN = 1,
	BTF_SOCK_TYPE_INET_REQ = 2,
	BTF_SOCK_TYPE_INET_TW = 3,
	BTF_SOCK_TYPE_REQ = 4,
	BTF_SOCK_TYPE_SOCK = 5,
	BTF_SOCK_TYPE_SOCK_COMMON = 6,
	BTF_SOCK_TYPE_TCP = 7,
	BTF_SOCK_TYPE_TCP_REQ = 8,
	BTF_SOCK_TYPE_TCP_TW = 9,
	BTF_SOCK_TYPE_TCP6 = 10,
	BTF_SOCK_TYPE_UDP = 11,
	BTF_SOCK_TYPE_UDP6 = 12,
	BTF_SOCK_TYPE_UNIX = 13,
	BTF_SOCK_TYPE_MPTCP = 14,
	BTF_SOCK_TYPE_SOCKET = 15,
	MAX_BTF_SOCK_TYPE = 16,
};

enum {
	BTF_TRACING_TYPE_TASK = 0,
	BTF_TRACING_TYPE_FILE = 1,
	BTF_TRACING_TYPE_VMA = 2,
	MAX_BTF_TRACING_TYPE = 3,
};

enum {
	BTF_VAR_STATIC = 0,
	BTF_VAR_GLOBAL_ALLOCATED = 1,
	BTF_VAR_GLOBAL_EXTERN = 2,
};

enum {
	BTRFS_FILE_EXTENT_INLINE = 0,
	BTRFS_FILE_EXTENT_REG = 1,
	BTRFS_FILE_EXTENT_PREALLOC = 2,
	BTRFS_NR_FILE_EXTENT_TYPES = 3,
};

enum {
	BTRFS_FS_CLOSING_START = 0,
	BTRFS_FS_CLOSING_DONE = 1,
	BTRFS_FS_LOG_RECOVERING = 2,
	BTRFS_FS_OPEN = 3,
	BTRFS_FS_QUOTA_ENABLED = 4,
	BTRFS_FS_UPDATE_UUID_TREE_GEN = 5,
	BTRFS_FS_CREATING_FREE_SPACE_TREE = 6,
	BTRFS_FS_BTREE_ERR = 7,
	BTRFS_FS_LOG1_ERR = 8,
	BTRFS_FS_LOG2_ERR = 9,
	BTRFS_FS_QUOTA_OVERRIDE = 10,
	BTRFS_FS_FROZEN = 11,
	BTRFS_FS_BALANCE_RUNNING = 12,
	BTRFS_FS_RELOC_RUNNING = 13,
	BTRFS_FS_CLEANER_RUNNING = 14,
	BTRFS_FS_CSUM_IMPL_FAST = 15,
	BTRFS_FS_DISCARD_RUNNING = 16,
	BTRFS_FS_CLEANUP_SPACE_CACHE_V1 = 17,
	BTRFS_FS_FREE_SPACE_TREE_UNTRUSTED = 18,
	BTRFS_FS_TREE_MOD_LOG_USERS = 19,
	BTRFS_FS_COMMIT_TRANS = 20,
	BTRFS_FS_UNFINISHED_DROPS = 21,
	BTRFS_FS_NEED_ZONE_FINISH = 22,
	BTRFS_FS_NEED_TRANS_COMMIT = 23,
	BTRFS_FS_ACTIVE_ZONE_TRACKING = 24,
	BTRFS_FS_FEATURE_CHANGED = 25,
	BTRFS_FS_UNALIGNED_TREE_BLOCK = 26,
};

enum {
	BTRFS_FS_STATE_REMOUNTING = 0,
	BTRFS_FS_STATE_RO = 1,
	BTRFS_FS_STATE_TRANS_ABORTED = 2,
	BTRFS_FS_STATE_DEV_REPLACING = 3,
	BTRFS_FS_STATE_DUMMY_FS_INFO = 4,
	BTRFS_FS_STATE_NO_DATA_CSUMS = 5,
	BTRFS_FS_STATE_SKIP_META_CSUMS = 6,
	BTRFS_FS_STATE_LOG_CLEANUP_ERROR = 7,
	BTRFS_FS_STATE_COUNT = 8,
};

enum {
	BTRFS_INODE_FLUSH_ON_CLOSE = 0,
	BTRFS_INODE_DUMMY = 1,
	BTRFS_INODE_IN_DEFRAG = 2,
	BTRFS_INODE_HAS_ASYNC_EXTENT = 3,
	BTRFS_INODE_NEEDS_FULL_SYNC = 4,
	BTRFS_INODE_COPY_EVERYTHING = 5,
	BTRFS_INODE_HAS_PROPS = 6,
	BTRFS_INODE_SNAPSHOT_FLUSH = 7,
	BTRFS_INODE_NO_XATTRS = 8,
	BTRFS_INODE_NO_DELALLOC_FLUSH = 9,
	BTRFS_INODE_VERITY_IN_PROGRESS = 10,
	BTRFS_INODE_FREE_SPACE_INODE = 11,
	BTRFS_INODE_NO_CAP_XATTR = 12,
	BTRFS_INODE_COW_WRITE_ERROR = 13,
	BTRFS_INODE_ROOT_STUB = 14,
};

enum {
	BTRFS_MOUNT_NODATASUM = 1ULL,
	BTRFS_MOUNT_NODATACOW = 2ULL,
	BTRFS_MOUNT_NOBARRIER = 4ULL,
	BTRFS_MOUNT_SSD = 8ULL,
	BTRFS_MOUNT_DEGRADED = 16ULL,
	BTRFS_MOUNT_COMPRESS = 32ULL,
	BTRFS_MOUNT_NOTREELOG = 64ULL,
	BTRFS_MOUNT_FLUSHONCOMMIT = 128ULL,
	BTRFS_MOUNT_SSD_SPREAD = 256ULL,
	BTRFS_MOUNT_NOSSD = 512ULL,
	BTRFS_MOUNT_DISCARD_SYNC = 1024ULL,
	BTRFS_MOUNT_FORCE_COMPRESS = 2048ULL,
	BTRFS_MOUNT_SPACE_CACHE = 4096ULL,
	BTRFS_MOUNT_CLEAR_CACHE = 8192ULL,
	BTRFS_MOUNT_USER_SUBVOL_RM_ALLOWED = 16384ULL,
	BTRFS_MOUNT_ENOSPC_DEBUG = 32768ULL,
	BTRFS_MOUNT_AUTO_DEFRAG = 65536ULL,
	BTRFS_MOUNT_USEBACKUPROOT = 131072ULL,
	BTRFS_MOUNT_SKIP_BALANCE = 262144ULL,
	BTRFS_MOUNT_PANIC_ON_FATAL_ERROR = 524288ULL,
	BTRFS_MOUNT_RESCAN_UUID_TREE = 1048576ULL,
	BTRFS_MOUNT_FRAGMENT_DATA = 2097152ULL,
	BTRFS_MOUNT_FRAGMENT_METADATA = 4194304ULL,
	BTRFS_MOUNT_FREE_SPACE_TREE = 8388608ULL,
	BTRFS_MOUNT_NOLOGREPLAY = 16777216ULL,
	BTRFS_MOUNT_REF_VERIFY = 33554432ULL,
	BTRFS_MOUNT_DISCARD_ASYNC = 67108864ULL,
	BTRFS_MOUNT_IGNOREBADROOTS = 134217728ULL,
	BTRFS_MOUNT_IGNOREDATACSUMS = 268435456ULL,
	BTRFS_MOUNT_NODISCARD = 536870912ULL,
	BTRFS_MOUNT_NOSPACECACHE = 1073741824ULL,
	BTRFS_MOUNT_IGNOREMETACSUMS = 2147483648ULL,
	BTRFS_MOUNT_IGNORESUPERFLAGS = 4294967296ULL,
};

enum {
	BTRFS_ORDERED_REGULAR = 0,
	BTRFS_ORDERED_NOCOW = 1,
	BTRFS_ORDERED_PREALLOC = 2,
	BTRFS_ORDERED_COMPRESSED = 3,
	BTRFS_ORDERED_DIRECT = 4,
	BTRFS_ORDERED_IO_DONE = 5,
	BTRFS_ORDERED_COMPLETE = 6,
	BTRFS_ORDERED_IOERR = 7,
	BTRFS_ORDERED_TRUNCATED = 8,
	BTRFS_ORDERED_LOGGED = 9,
	BTRFS_ORDERED_LOGGED_CSUM = 10,
	BTRFS_ORDERED_PENDING = 11,
	BTRFS_ORDERED_ENCODED = 12,
};

enum {
	BTRFS_ROOT_IN_TRANS_SETUP = 0,
	BTRFS_ROOT_SHAREABLE = 1,
	BTRFS_ROOT_TRACK_DIRTY = 2,
	BTRFS_ROOT_IN_RADIX = 3,
	BTRFS_ROOT_ORPHAN_ITEM_INSERTED = 4,
	BTRFS_ROOT_DEFRAG_RUNNING = 5,
	BTRFS_ROOT_FORCE_COW = 6,
	BTRFS_ROOT_MULTI_LOG_TASKS = 7,
	BTRFS_ROOT_DIRTY = 8,
	BTRFS_ROOT_DELETING = 9,
	BTRFS_ROOT_DEAD_RELOC_TREE = 10,
	BTRFS_ROOT_DEAD_TREE = 11,
	BTRFS_ROOT_HAS_LOG_TREE = 12,
	BTRFS_ROOT_QGROUP_FLUSHING = 13,
	BTRFS_ROOT_ORPHAN_CLEANUP = 14,
	BTRFS_ROOT_UNFINISHED_DROP = 15,
	BTRFS_ROOT_RESET_LOCKDEP_CLASS = 16,
};

enum {
	BTRFS_SEND_A_UNSPEC = 0,
	BTRFS_SEND_A_UUID = 1,
	BTRFS_SEND_A_CTRANSID = 2,
	BTRFS_SEND_A_INO = 3,
	BTRFS_SEND_A_SIZE = 4,
	BTRFS_SEND_A_MODE = 5,
	BTRFS_SEND_A_UID = 6,
	BTRFS_SEND_A_GID = 7,
	BTRFS_SEND_A_RDEV = 8,
	BTRFS_SEND_A_CTIME = 9,
	BTRFS_SEND_A_MTIME = 10,
	BTRFS_SEND_A_ATIME = 11,
	BTRFS_SEND_A_OTIME = 12,
	BTRFS_SEND_A_XATTR_NAME = 13,
	BTRFS_SEND_A_XATTR_DATA = 14,
	BTRFS_SEND_A_PATH = 15,
	BTRFS_SEND_A_PATH_TO = 16,
	BTRFS_SEND_A_PATH_LINK = 17,
	BTRFS_SEND_A_FILE_OFFSET = 18,
	BTRFS_SEND_A_DATA = 19,
	BTRFS_SEND_A_CLONE_UUID = 20,
	BTRFS_SEND_A_CLONE_CTRANSID = 21,
	BTRFS_SEND_A_CLONE_PATH = 22,
	BTRFS_SEND_A_CLONE_OFFSET = 23,
	BTRFS_SEND_A_CLONE_LEN = 24,
	BTRFS_SEND_A_MAX_V1 = 24,
	BTRFS_SEND_A_FALLOCATE_MODE = 25,
	BTRFS_SEND_A_FILEATTR = 26,
	BTRFS_SEND_A_UNENCODED_FILE_LEN = 27,
	BTRFS_SEND_A_UNENCODED_LEN = 28,
	BTRFS_SEND_A_UNENCODED_OFFSET = 29,
	BTRFS_SEND_A_COMPRESSION = 30,
	BTRFS_SEND_A_ENCRYPTION = 31,
	BTRFS_SEND_A_MAX_V2 = 31,
	BTRFS_SEND_A_VERITY_ALGORITHM = 32,
	BTRFS_SEND_A_VERITY_BLOCK_SIZE = 33,
	BTRFS_SEND_A_VERITY_SALT_DATA = 34,
	BTRFS_SEND_A_VERITY_SIG_DATA = 35,
	BTRFS_SEND_A_MAX_V3 = 35,
	__BTRFS_SEND_A_MAX = 35,
};

enum {
	BTRFS_STAT_CURR = 0,
	BTRFS_STAT_PREV = 1,
	BTRFS_STAT_NR_ENTRIES = 2,
};

enum {
	CACHE_PRESENT = 1,
	CACHE_PRIVATE = 2,
	CACHE_INCLUSIVE = 4,
};

enum {
	CACHE_VALID = 0,
	CACHE_NEGATIVE = 1,
	CACHE_PENDING = 2,
	CACHE_CLEANED = 3,
};

enum {
	CFTYPE_ONLY_ON_ROOT = 1,
	CFTYPE_NOT_ON_ROOT = 2,
	CFTYPE_NS_DELEGATABLE = 4,
	CFTYPE_NO_PREFIX = 8,
	CFTYPE_WORLD_WRITABLE = 16,
	CFTYPE_DEBUG = 32,
	__CFTYPE_ONLY_ON_DFL = 65536,
	__CFTYPE_NOT_ON_DFL = 131072,
	__CFTYPE_ADDED = 262144,
};

enum {
	CGROUPSTATS_CMD_ATTR_UNSPEC = 0,
	CGROUPSTATS_CMD_ATTR_FD = 1,
	__CGROUPSTATS_CMD_ATTR_MAX = 2,
};

enum {
	CGROUPSTATS_CMD_UNSPEC = 3,
	CGROUPSTATS_CMD_GET = 4,
	CGROUPSTATS_CMD_NEW = 5,
	__CGROUPSTATS_CMD_MAX = 6,
};

enum {
	CGROUPSTATS_TYPE_UNSPEC = 0,
	CGROUPSTATS_TYPE_CGROUP_STATS = 1,
	__CGROUPSTATS_TYPE_MAX = 2,
};

enum {
	CGRP_NOTIFY_ON_RELEASE = 0,
	CGRP_CPUSET_CLONE_CHILDREN = 1,
	CGRP_FREEZE = 2,
	CGRP_FROZEN = 3,
};

enum {
	CGRP_ROOT_NOPREFIX = 2,
	CGRP_ROOT_XATTR = 4,
	CGRP_ROOT_NS_DELEGATE = 8,
	CGRP_ROOT_FAVOR_DYNMODS = 16,
	CGRP_ROOT_CPUSET_V2_MODE = 65536,
	CGRP_ROOT_MEMORY_LOCAL_EVENTS = 131072,
	CGRP_ROOT_MEMORY_RECURSIVE_PROT = 262144,
	CGRP_ROOT_MEMORY_HUGETLB_ACCOUNTING = 524288,
	CGRP_ROOT_PIDS_LOCAL_EVENTS = 1048576,
};

enum {
	CMIS_MODULE_LOW_PWR = 1,
	CMIS_MODULE_READY = 3,
};

enum {
	COST_CTRL = 0,
	COST_MODEL = 1,
	NR_COST_CTRL_PARAMS = 2,
};

enum {
	CRNG_EMPTY = 0,
	CRNG_EARLY = 1,
	CRNG_READY = 2,
};

enum {
	CRNG_RESEED_START_INTERVAL = 250,
	CRNG_RESEED_INTERVAL = 15000,
};

enum {
	CRYPTOA_UNSPEC = 0,
	CRYPTOA_ALG = 1,
	CRYPTOA_TYPE = 2,
	__CRYPTOA_MAX = 3,
};

enum {
	CRYPTO_KPP_SECRET_TYPE_UNKNOWN = 0,
	CRYPTO_KPP_SECRET_TYPE_DH = 1,
	CRYPTO_KPP_SECRET_TYPE_ECDH = 2,
};

enum {
	CRYPTO_MSG_ALG_REQUEST = 0,
	CRYPTO_MSG_ALG_REGISTER = 1,
	CRYPTO_MSG_ALG_LOADED = 2,
};

enum {
	CSD_FLAG_LOCK = 1,
	IRQ_WORK_PENDING = 1,
	IRQ_WORK_BUSY = 2,
	IRQ_WORK_LAZY = 4,
	IRQ_WORK_HARD_IRQ = 8,
	IRQ_WORK_CLAIMED = 3,
	CSD_TYPE_ASYNC = 0,
	CSD_TYPE_SYNC = 16,
	CSD_TYPE_IRQ_WORK = 32,
	CSD_TYPE_TTWU = 48,
	CSD_FLAG_TYPE_MASK = 240,
};

enum {
	CSI_DEC_hl_CURSOR_KEYS = 1,
	CSI_DEC_hl_132_COLUMNS = 3,
	CSI_DEC_hl_REVERSE_VIDEO = 5,
	CSI_DEC_hl_ORIGIN_MODE = 6,
	CSI_DEC_hl_AUTOWRAP = 7,
	CSI_DEC_hl_AUTOREPEAT = 8,
	CSI_DEC_hl_MOUSE_X10 = 9,
	CSI_DEC_hl_SHOW_CURSOR = 25,
	CSI_DEC_hl_MOUSE_VT200 = 1000,
};

enum {
	CSI_K_CURSOR_TO_LINEEND = 0,
	CSI_K_LINESTART_TO_CURSOR = 1,
	CSI_K_LINE = 2,
};

enum {
	CSI_hl_DISPLAY_CTRL = 3,
	CSI_hl_INSERT = 4,
	CSI_hl_AUTO_NL = 20,
};

enum {
	CSI_m_DEFAULT = 0,
	CSI_m_BOLD = 1,
	CSI_m_HALF_BRIGHT = 2,
	CSI_m_ITALIC = 3,
	CSI_m_UNDERLINE = 4,
	CSI_m_BLINK = 5,
	CSI_m_REVERSE = 7,
	CSI_m_PRI_FONT = 10,
	CSI_m_ALT_FONT1 = 11,
	CSI_m_ALT_FONT2 = 12,
	CSI_m_DOUBLE_UNDERLINE = 21,
	CSI_m_NORMAL_INTENSITY = 22,
	CSI_m_NO_ITALIC = 23,
	CSI_m_NO_UNDERLINE = 24,
	CSI_m_NO_BLINK = 25,
	CSI_m_NO_REVERSE = 27,
	CSI_m_FG_COLOR_BEG = 30,
	CSI_m_FG_COLOR_END = 37,
	CSI_m_FG_COLOR = 38,
	CSI_m_DEFAULT_FG_COLOR = 39,
	CSI_m_BG_COLOR_BEG = 40,
	CSI_m_BG_COLOR_END = 47,
	CSI_m_BG_COLOR = 48,
	CSI_m_DEFAULT_BG_COLOR = 49,
	CSI_m_BRIGHT_FG_COLOR_BEG = 90,
	CSI_m_BRIGHT_FG_COLOR_END = 97,
	CSI_m_BRIGHT_FG_COLOR_OFF = 60,
	CSI_m_BRIGHT_BG_COLOR_BEG = 100,
	CSI_m_BRIGHT_BG_COLOR_END = 107,
	CSI_m_BRIGHT_BG_COLOR_OFF = 60,
};

enum {
	CSS_NO_REF = 1,
	CSS_ONLINE = 2,
	CSS_RELEASED = 4,
	CSS_VISIBLE = 8,
	CSS_DYING = 16,
};

enum {
	CSS_TASK_ITER_PROCS = 1,
	CSS_TASK_ITER_THREADED = 2,
	CSS_TASK_ITER_SKIPPED = 65536,
};

enum {
	CTRL_ATTR_MCAST_GRP_UNSPEC = 0,
	CTRL_ATTR_MCAST_GRP_NAME = 1,
	CTRL_ATTR_MCAST_GRP_ID = 2,
	__CTRL_ATTR_MCAST_GRP_MAX = 3,
};

enum {
	CTRL_ATTR_OP_UNSPEC = 0,
	CTRL_ATTR_OP_ID = 1,
	CTRL_ATTR_OP_FLAGS = 2,
	__CTRL_ATTR_OP_MAX = 3,
};

enum {
	CTRL_ATTR_POLICY_UNSPEC = 0,
	CTRL_ATTR_POLICY_DO = 1,
	CTRL_ATTR_POLICY_DUMP = 2,
	__CTRL_ATTR_POLICY_DUMP_MAX = 3,
	CTRL_ATTR_POLICY_DUMP_MAX = 2,
};

enum {
	CTRL_ATTR_UNSPEC = 0,
	CTRL_ATTR_FAMILY_ID = 1,
	CTRL_ATTR_FAMILY_NAME = 2,
	CTRL_ATTR_VERSION = 3,
	CTRL_ATTR_HDRSIZE = 4,
	CTRL_ATTR_MAXATTR = 5,
	CTRL_ATTR_OPS = 6,
	CTRL_ATTR_MCAST_GROUPS = 7,
	CTRL_ATTR_POLICY = 8,
	CTRL_ATTR_OP_POLICY = 9,
	CTRL_ATTR_OP = 10,
	__CTRL_ATTR_MAX = 11,
};

enum {
	CTRL_CMD_UNSPEC = 0,
	CTRL_CMD_NEWFAMILY = 1,
	CTRL_CMD_DELFAMILY = 2,
	CTRL_CMD_GETFAMILY = 3,
	CTRL_CMD_NEWOPS = 4,
	CTRL_CMD_DELOPS = 5,
	CTRL_CMD_GETOPS = 6,
	CTRL_CMD_NEWMCAST_GRP = 7,
	CTRL_CMD_DELMCAST_GRP = 8,
	CTRL_CMD_GETMCAST_GRP = 9,
	CTRL_CMD_GETPOLICY = 10,
	__CTRL_CMD_MAX = 11,
};

enum {
	CXT_PINCFG_LENOVO_X200 = 0,
	CXT_PINCFG_LENOVO_TP410 = 1,
	CXT_PINCFG_LEMOTE_A1004 = 2,
	CXT_PINCFG_LEMOTE_A1205 = 3,
	CXT_PINCFG_COMPAQ_CQ60 = 4,
	CXT_FIXUP_STEREO_DMIC = 5,
	CXT_PINCFG_LENOVO_NOTEBOOK = 6,
	CXT_FIXUP_INC_MIC_BOOST = 7,
	CXT_FIXUP_HEADPHONE_MIC_PIN = 8,
	CXT_FIXUP_HEADPHONE_MIC = 9,
	CXT_FIXUP_GPIO1 = 10,
	CXT_FIXUP_ASPIRE_DMIC = 11,
	CXT_FIXUP_THINKPAD_ACPI = 12,
	CXT_FIXUP_LENOVO_XPAD_ACPI = 13,
	CXT_FIXUP_OLPC_XO = 14,
	CXT_FIXUP_CAP_MIX_AMP = 15,
	CXT_FIXUP_TOSHIBA_P105 = 16,
	CXT_FIXUP_HP_530 = 17,
	CXT_FIXUP_CAP_MIX_AMP_5047 = 18,
	CXT_FIXUP_MUTE_LED_EAPD = 19,
	CXT_FIXUP_HP_DOCK = 20,
	CXT_FIXUP_HP_SPECTRE = 21,
	CXT_FIXUP_HP_GATE_MIC = 22,
	CXT_FIXUP_MUTE_LED_GPIO = 23,
	CXT_FIXUP_HP_ELITEONE_OUT_DIS = 24,
	CXT_FIXUP_HP_ZBOOK_MUTE_LED = 25,
	CXT_FIXUP_HEADSET_MIC = 26,
	CXT_FIXUP_HP_MIC_NO_PRESENCE = 27,
	CXT_PINCFG_SWS_JS201D = 28,
	CXT_PINCFG_TOP_SPEAKER = 29,
	CXT_FIXUP_HP_A_U = 30,
};

enum {
	DAD_PROCESS = 0,
	DAD_BEGIN = 1,
	DAD_ABORT = 2,
};

enum {
	DD_DIR_COUNT = 2,
};

enum {
	DD_PRIO_COUNT = 3,
};

enum {
	DEVCONF_FORWARDING = 0,
	DEVCONF_HOPLIMIT = 1,
	DEVCONF_MTU6 = 2,
	DEVCONF_ACCEPT_RA = 3,
	DEVCONF_ACCEPT_REDIRECTS = 4,
	DEVCONF_AUTOCONF = 5,
	DEVCONF_DAD_TRANSMITS = 6,
	DEVCONF_RTR_SOLICITS = 7,
	DEVCONF_RTR_SOLICIT_INTERVAL = 8,
	DEVCONF_RTR_SOLICIT_DELAY = 9,
	DEVCONF_USE_TEMPADDR = 10,
	DEVCONF_TEMP_VALID_LFT = 11,
	DEVCONF_TEMP_PREFERED_LFT = 12,
	DEVCONF_REGEN_MAX_RETRY = 13,
	DEVCONF_MAX_DESYNC_FACTOR = 14,
	DEVCONF_MAX_ADDRESSES = 15,
	DEVCONF_FORCE_MLD_VERSION = 16,
	DEVCONF_ACCEPT_RA_DEFRTR = 17,
	DEVCONF_ACCEPT_RA_PINFO = 18,
	DEVCONF_ACCEPT_RA_RTR_PREF = 19,
	DEVCONF_RTR_PROBE_INTERVAL = 20,
	DEVCONF_ACCEPT_RA_RT_INFO_MAX_PLEN = 21,
	DEVCONF_PROXY_NDP = 22,
	DEVCONF_OPTIMISTIC_DAD = 23,
	DEVCONF_ACCEPT_SOURCE_ROUTE = 24,
	DEVCONF_MC_FORWARDING = 25,
	DEVCONF_DISABLE_IPV6 = 26,
	DEVCONF_ACCEPT_DAD = 27,
	DEVCONF_FORCE_TLLAO = 28,
	DEVCONF_NDISC_NOTIFY = 29,
	DEVCONF_MLDV1_UNSOLICITED_REPORT_INTERVAL = 30,
	DEVCONF_MLDV2_UNSOLICITED_REPORT_INTERVAL = 31,
	DEVCONF_SUPPRESS_FRAG_NDISC = 32,
	DEVCONF_ACCEPT_RA_FROM_LOCAL = 33,
	DEVCONF_USE_OPTIMISTIC = 34,
	DEVCONF_ACCEPT_RA_MTU = 35,
	DEVCONF_STABLE_SECRET = 36,
	DEVCONF_USE_OIF_ADDRS_ONLY = 37,
	DEVCONF_ACCEPT_RA_MIN_HOP_LIMIT = 38,
	DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 39,
	DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 40,
	DEVCONF_DROP_UNSOLICITED_NA = 41,
	DEVCONF_KEEP_ADDR_ON_DOWN = 42,
	DEVCONF_RTR_SOLICIT_MAX_INTERVAL = 43,
	DEVCONF_SEG6_ENABLED = 44,
	DEVCONF_SEG6_REQUIRE_HMAC = 45,
	DEVCONF_ENHANCED_DAD = 46,
	DEVCONF_ADDR_GEN_MODE = 47,
	DEVCONF_DISABLE_POLICY = 48,
	DEVCONF_ACCEPT_RA_RT_INFO_MIN_PLEN = 49,
	DEVCONF_NDISC_TCLASS = 50,
	DEVCONF_RPL_SEG_ENABLED = 51,
	DEVCONF_RA_DEFRTR_METRIC = 52,
	DEVCONF_IOAM6_ENABLED = 53,
	DEVCONF_IOAM6_ID = 54,
	DEVCONF_IOAM6_ID_WIDE = 55,
	DEVCONF_NDISC_EVICT_NOCARRIER = 56,
	DEVCONF_ACCEPT_UNTRACKED_NA = 57,
	DEVCONF_ACCEPT_RA_MIN_LFT = 58,
	DEVCONF_MAX = 59,
};

enum {
	DIGBEEP_HZ_STEP = 46875,
	DIGBEEP_HZ_MIN = 93750,
	DIGBEEP_HZ_MAX = 12000000,
};

enum {
	DIO_LOCKING = 1,
	DIO_SKIP_HOLES = 2,
};

enum {
	DIO_SHOULD_DIRTY = 1,
	DIO_IS_SYNC = 2,
};

enum {
	DIR_OFFSET_FIRST = 2,
	DIR_OFFSET_EOD = 2147483647,
};

enum {
	DIR_OFFSET_MIN = 3,
	DIR_OFFSET_MAX = 2147483646,
};

enum {
	DISCOVERED = 16,
	EXPLORED = 32,
	FALLTHROUGH = 1,
	BRANCH = 2,
};

enum {
	DISK_EVENT_FLAG_POLL = 1,
	DISK_EVENT_FLAG_UEVENT = 2,
	DISK_EVENT_FLAG_BLOCK_ON_EXCL_WRITE = 4,
};

enum {
	DISK_EVENT_MEDIA_CHANGE = 1,
	DISK_EVENT_EJECT_REQUEST = 2,
};

enum {
	DM_IO_ACCOUNTED = 0,
	DM_IO_WAS_SPLIT = 1,
	DM_IO_BLK_STAT = 2,
};

enum {
	DM_TIO_INSIDE_DM_IO = 0,
	DM_TIO_IS_DUPLICATE_BIO = 1,
};

enum {
	DM_VERSION_CMD = 0,
	DM_REMOVE_ALL_CMD = 1,
	DM_LIST_DEVICES_CMD = 2,
	DM_DEV_CREATE_CMD = 3,
	DM_DEV_REMOVE_CMD = 4,
	DM_DEV_RENAME_CMD = 5,
	DM_DEV_SUSPEND_CMD = 6,
	DM_DEV_STATUS_CMD = 7,
	DM_DEV_WAIT_CMD = 8,
	DM_TABLE_LOAD_CMD = 9,
	DM_TABLE_CLEAR_CMD = 10,
	DM_TABLE_DEPS_CMD = 11,
	DM_TABLE_STATUS_CMD = 12,
	DM_LIST_VERSIONS_CMD = 13,
	DM_TARGET_MSG_CMD = 14,
	DM_DEV_SET_GEOMETRY_CMD = 15,
	DM_DEV_ARM_POLL_CMD = 16,
	DM_GET_TARGET_VERSION_CMD = 17,
};

enum {
	DONE_EXPLORING = 0,
	KEEP_EXPLORING = 1,
};

enum {
	DQF_INFO_DIRTY_B = 17,
};

enum {
	DQF_ROOT_SQUASH_B = 0,
	DQF_SYS_FILE_B = 16,
	DQF_PRIVATE = 17,
};

enum {
	DQST_LOOKUPS = 0,
	DQST_DROPS = 1,
	DQST_READS = 2,
	DQST_WRITES = 3,
	DQST_CACHE_HITS = 4,
	DQST_ALLOC_DQUOTS = 5,
	DQST_FREE_DQUOTS = 6,
	DQST_SYNCS = 7,
	_DQST_DQSTAT_LAST = 8,
};

enum {
	DRBL_HANDSHAKE = 1,
	DRBL_SOFT_RESET = 2,
	DRBL_BUS_CHANGE = 4,
	DRBL_EVENT_NOTIFY = 8,
	DRBL_MU_RESET = 16,
	DRBL_HANDSHAKE_ISR = 1,
	CMD_FLAG_NON_DATA = 1,
	CMD_FLAG_DMA = 2,
	CMD_FLAG_PIO = 4,
	CMD_FLAG_DATA_IN = 8,
	CMD_FLAG_DATA_OUT = 16,
	CMD_FLAG_PRDT_IN_HOST = 32,
};

enum {
	DUMP_PREFIX_NONE = 0,
	DUMP_PREFIX_ADDRESS = 1,
	DUMP_PREFIX_OFFSET = 2,
};

enum {
	EC_FLAGS_QUERY_ENABLED = 0,
	EC_FLAGS_EVENT_HANDLER_INSTALLED = 1,
	EC_FLAGS_EC_HANDLER_INSTALLED = 2,
	EC_FLAGS_EC_REG_CALLED = 3,
	EC_FLAGS_QUERY_METHODS_INSTALLED = 4,
	EC_FLAGS_STARTED = 5,
	EC_FLAGS_STOPPED = 6,
	EC_FLAGS_EVENTS_MASKED = 7,
};

enum {
	ELANTECH_SMBUS_NOT_SET = -1,
	ELANTECH_SMBUS_OFF = 0,
	ELANTECH_SMBUS_ON = 1,
};

enum {
	EPecma = 0,
	EPdec = 1,
	EPeq = 2,
	EPgt = 3,
	EPlt = 4,
};

enum {
	ERASE = 0,
	WERASE = 1,
	KILL = 2,
};

enum {
	ES_WRITTEN_B = 0,
	ES_UNWRITTEN_B = 1,
	ES_DELAYED_B = 2,
	ES_HOLE_B = 3,
	ES_REFERENCED_B = 4,
	ES_FLAGS = 5,
};

enum {
	ETHTOOL_A_BITSET_BITS_UNSPEC = 0,
	ETHTOOL_A_BITSET_BITS_BIT = 1,
	__ETHTOOL_A_BITSET_BITS_CNT = 2,
	ETHTOOL_A_BITSET_BITS_MAX = 1,
};

enum {
	ETHTOOL_A_BITSET_BIT_UNSPEC = 0,
	ETHTOOL_A_BITSET_BIT_INDEX = 1,
	ETHTOOL_A_BITSET_BIT_NAME = 2,
	ETHTOOL_A_BITSET_BIT_VALUE = 3,
	__ETHTOOL_A_BITSET_BIT_CNT = 4,
	ETHTOOL_A_BITSET_BIT_MAX = 3,
};

enum {
	ETHTOOL_A_BITSET_UNSPEC = 0,
	ETHTOOL_A_BITSET_NOMASK = 1,
	ETHTOOL_A_BITSET_SIZE = 2,
	ETHTOOL_A_BITSET_BITS = 3,
	ETHTOOL_A_BITSET_VALUE = 4,
	ETHTOOL_A_BITSET_MASK = 5,
	__ETHTOOL_A_BITSET_CNT = 6,
	ETHTOOL_A_BITSET_MAX = 5,
};

enum {
	ETHTOOL_A_C33_PSE_PW_LIMIT_UNSPEC = 0,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MIN = 1,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_CNT = 3,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_AMPLITUDE_UNSPEC = 0,
	ETHTOOL_A_CABLE_AMPLITUDE_PAIR = 1,
	ETHTOOL_A_CABLE_AMPLITUDE_mV = 2,
	__ETHTOOL_A_CABLE_AMPLITUDE_CNT = 3,
	ETHTOOL_A_CABLE_AMPLITUDE_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_FAULT_LENGTH_UNSPEC = 0,
	ETHTOOL_A_CABLE_FAULT_LENGTH_PAIR = 1,
	ETHTOOL_A_CABLE_FAULT_LENGTH_CM = 2,
	ETHTOOL_A_CABLE_FAULT_LENGTH_SRC = 3,
	__ETHTOOL_A_CABLE_FAULT_LENGTH_CNT = 4,
	ETHTOOL_A_CABLE_FAULT_LENGTH_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_INF_SRC_UNSPEC = 0,
	ETHTOOL_A_CABLE_INF_SRC_TDR = 1,
	ETHTOOL_A_CABLE_INF_SRC_ALCD = 2,
};

enum {
	ETHTOOL_A_CABLE_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_NEST_RESULT = 1,
	ETHTOOL_A_CABLE_NEST_FAULT_LENGTH = 2,
	__ETHTOOL_A_CABLE_NEST_CNT = 3,
	ETHTOOL_A_CABLE_NEST_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_PAIR_A = 0,
	ETHTOOL_A_CABLE_PAIR_B = 1,
	ETHTOOL_A_CABLE_PAIR_C = 2,
	ETHTOOL_A_CABLE_PAIR_D = 3,
};

enum {
	ETHTOOL_A_CABLE_PULSE_UNSPEC = 0,
	ETHTOOL_A_CABLE_PULSE_mV = 1,
	__ETHTOOL_A_CABLE_PULSE_CNT = 2,
	ETHTOOL_A_CABLE_PULSE_MAX = 1,
};

enum {
	ETHTOOL_A_CABLE_RESULT_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_PAIR = 1,
	ETHTOOL_A_CABLE_RESULT_CODE = 2,
	ETHTOOL_A_CABLE_RESULT_SRC = 3,
	__ETHTOOL_A_CABLE_RESULT_CNT = 4,
	ETHTOOL_A_CABLE_RESULT_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_STEP_UNSPEC = 0,
	ETHTOOL_A_CABLE_STEP_FIRST_DISTANCE = 1,
	ETHTOOL_A_CABLE_STEP_LAST_DISTANCE = 2,
	ETHTOOL_A_CABLE_STEP_STEP_DISTANCE = 3,
	__ETHTOOL_A_CABLE_STEP_CNT = 4,
	ETHTOOL_A_CABLE_STEP_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TDR_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TDR_NEST_STEP = 1,
	ETHTOOL_A_CABLE_TDR_NEST_AMPLITUDE = 2,
	ETHTOOL_A_CABLE_TDR_NEST_PULSE = 3,
	__ETHTOOL_A_CABLE_TDR_NEST_CNT = 4,
	ETHTOOL_A_CABLE_TDR_NEST_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_STARTED = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_COMPLETED = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS = 2,
	ETHTOOL_A_CABLE_TEST_NTF_NEST = 3,
	__ETHTOOL_A_CABLE_TEST_NTF_CNT = 4,
	ETHTOOL_A_CABLE_TEST_NTF_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_CFG_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_FIRST = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_LAST = 2,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_STEP = 3,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_PAIR = 4,
	__ETHTOOL_A_CABLE_TEST_TDR_CFG_CNT = 5,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_MAX = 4,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG = 2,
	__ETHTOOL_A_CABLE_TEST_TDR_CNT = 3,
	ETHTOOL_A_CABLE_TEST_TDR_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_HEADER = 1,
	__ETHTOOL_A_CABLE_TEST_CNT = 2,
	ETHTOOL_A_CABLE_TEST_MAX = 1,
};

enum {
	ETHTOOL_A_CHANNELS_UNSPEC = 0,
	ETHTOOL_A_CHANNELS_HEADER = 1,
	ETHTOOL_A_CHANNELS_RX_MAX = 2,
	ETHTOOL_A_CHANNELS_TX_MAX = 3,
	ETHTOOL_A_CHANNELS_OTHER_MAX = 4,
	ETHTOOL_A_CHANNELS_COMBINED_MAX = 5,
	ETHTOOL_A_CHANNELS_RX_COUNT = 6,
	ETHTOOL_A_CHANNELS_TX_COUNT = 7,
	ETHTOOL_A_CHANNELS_OTHER_COUNT = 8,
	ETHTOOL_A_CHANNELS_COMBINED_COUNT = 9,
	__ETHTOOL_A_CHANNELS_CNT = 10,
	ETHTOOL_A_CHANNELS_MAX = 9,
};

enum {
	ETHTOOL_A_COALESCE_UNSPEC = 0,
	ETHTOOL_A_COALESCE_HEADER = 1,
	ETHTOOL_A_COALESCE_RX_USECS = 2,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES = 3,
	ETHTOOL_A_COALESCE_RX_USECS_IRQ = 4,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ = 5,
	ETHTOOL_A_COALESCE_TX_USECS = 6,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES = 7,
	ETHTOOL_A_COALESCE_TX_USECS_IRQ = 8,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ = 9,
	ETHTOOL_A_COALESCE_STATS_BLOCK_USECS = 10,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX = 11,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX = 12,
	ETHTOOL_A_COALESCE_PKT_RATE_LOW = 13,
	ETHTOOL_A_COALESCE_RX_USECS_LOW = 14,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW = 15,
	ETHTOOL_A_COALESCE_TX_USECS_LOW = 16,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW = 17,
	ETHTOOL_A_COALESCE_PKT_RATE_HIGH = 18,
	ETHTOOL_A_COALESCE_RX_USECS_HIGH = 19,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH = 20,
	ETHTOOL_A_COALESCE_TX_USECS_HIGH = 21,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH = 22,
	ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL = 23,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_TX = 24,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_RX = 25,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_BYTES = 26,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_FRAMES = 27,
	ETHTOOL_A_COALESCE_TX_AGGR_TIME_USECS = 28,
	ETHTOOL_A_COALESCE_RX_PROFILE = 29,
	ETHTOOL_A_COALESCE_TX_PROFILE = 30,
	__ETHTOOL_A_COALESCE_CNT = 31,
	ETHTOOL_A_COALESCE_MAX = 30,
};

enum {
	ETHTOOL_A_DEBUG_UNSPEC = 0,
	ETHTOOL_A_DEBUG_HEADER = 1,
	ETHTOOL_A_DEBUG_MSGMASK = 2,
	__ETHTOOL_A_DEBUG_CNT = 3,
	ETHTOOL_A_DEBUG_MAX = 2,
};

enum {
	ETHTOOL_A_EEE_UNSPEC = 0,
	ETHTOOL_A_EEE_HEADER = 1,
	ETHTOOL_A_EEE_MODES_OURS = 2,
	ETHTOOL_A_EEE_MODES_PEER = 3,
	ETHTOOL_A_EEE_ACTIVE = 4,
	ETHTOOL_A_EEE_ENABLED = 5,
	ETHTOOL_A_EEE_TX_LPI_ENABLED = 6,
	ETHTOOL_A_EEE_TX_LPI_TIMER = 7,
	__ETHTOOL_A_EEE_CNT = 8,
	ETHTOOL_A_EEE_MAX = 7,
};

enum {
	ETHTOOL_A_FEATURES_UNSPEC = 0,
	ETHTOOL_A_FEATURES_HEADER = 1,
	ETHTOOL_A_FEATURES_HW = 2,
	ETHTOOL_A_FEATURES_WANTED = 3,
	ETHTOOL_A_FEATURES_ACTIVE = 4,
	ETHTOOL_A_FEATURES_NOCHANGE = 5,
	__ETHTOOL_A_FEATURES_CNT = 6,
	ETHTOOL_A_FEATURES_MAX = 5,
};

enum {
	ETHTOOL_A_FEC_STAT_UNSPEC = 0,
	ETHTOOL_A_FEC_STAT_PAD = 1,
	ETHTOOL_A_FEC_STAT_CORRECTED = 2,
	ETHTOOL_A_FEC_STAT_UNCORR = 3,
	ETHTOOL_A_FEC_STAT_CORR_BITS = 4,
	__ETHTOOL_A_FEC_STAT_CNT = 5,
	ETHTOOL_A_FEC_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_FEC_UNSPEC = 0,
	ETHTOOL_A_FEC_HEADER = 1,
	ETHTOOL_A_FEC_MODES = 2,
	ETHTOOL_A_FEC_AUTO = 3,
	ETHTOOL_A_FEC_ACTIVE = 4,
	ETHTOOL_A_FEC_STATS = 5,
	__ETHTOOL_A_FEC_CNT = 6,
	ETHTOOL_A_FEC_MAX = 5,
};

enum {
	ETHTOOL_A_HEADER_UNSPEC = 0,
	ETHTOOL_A_HEADER_DEV_INDEX = 1,
	ETHTOOL_A_HEADER_DEV_NAME = 2,
	ETHTOOL_A_HEADER_FLAGS = 3,
	ETHTOOL_A_HEADER_PHY_INDEX = 4,
	__ETHTOOL_A_HEADER_CNT = 5,
	ETHTOOL_A_HEADER_MAX = 4,
};

enum {
	ETHTOOL_A_IRQ_MODERATION_UNSPEC = 0,
	ETHTOOL_A_IRQ_MODERATION_USEC = 1,
	ETHTOOL_A_IRQ_MODERATION_PKTS = 2,
	ETHTOOL_A_IRQ_MODERATION_COMPS = 3,
	__ETHTOOL_A_IRQ_MODERATION_CNT = 4,
	ETHTOOL_A_IRQ_MODERATION_MAX = 3,
};

enum {
	ETHTOOL_A_LINKINFO_UNSPEC = 0,
	ETHTOOL_A_LINKINFO_HEADER = 1,
	ETHTOOL_A_LINKINFO_PORT = 2,
	ETHTOOL_A_LINKINFO_PHYADDR = 3,
	ETHTOOL_A_LINKINFO_TP_MDIX = 4,
	ETHTOOL_A_LINKINFO_TP_MDIX_CTRL = 5,
	ETHTOOL_A_LINKINFO_TRANSCEIVER = 6,
	__ETHTOOL_A_LINKINFO_CNT = 7,
	ETHTOOL_A_LINKINFO_MAX = 6,
};

enum {
	ETHTOOL_A_LINKMODES_UNSPEC = 0,
	ETHTOOL_A_LINKMODES_HEADER = 1,
	ETHTOOL_A_LINKMODES_AUTONEG = 2,
	ETHTOOL_A_LINKMODES_OURS = 3,
	ETHTOOL_A_LINKMODES_PEER = 4,
	ETHTOOL_A_LINKMODES_SPEED = 5,
	ETHTOOL_A_LINKMODES_DUPLEX = 6,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG = 7,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE = 8,
	ETHTOOL_A_LINKMODES_LANES = 9,
	ETHTOOL_A_LINKMODES_RATE_MATCHING = 10,
	__ETHTOOL_A_LINKMODES_CNT = 11,
	ETHTOOL_A_LINKMODES_MAX = 10,
};

enum {
	ETHTOOL_A_LINKSTATE_UNSPEC = 0,
	ETHTOOL_A_LINKSTATE_HEADER = 1,
	ETHTOOL_A_LINKSTATE_LINK = 2,
	ETHTOOL_A_LINKSTATE_SQI = 3,
	ETHTOOL_A_LINKSTATE_SQI_MAX = 4,
	ETHTOOL_A_LINKSTATE_EXT_STATE = 5,
	ETHTOOL_A_LINKSTATE_EXT_SUBSTATE = 6,
	ETHTOOL_A_LINKSTATE_EXT_DOWN_CNT = 7,
	__ETHTOOL_A_LINKSTATE_CNT = 8,
	ETHTOOL_A_LINKSTATE_MAX = 7,
};

enum {
	ETHTOOL_A_MM_STAT_UNSPEC = 0,
	ETHTOOL_A_MM_STAT_PAD = 1,
	ETHTOOL_A_MM_STAT_REASSEMBLY_ERRORS = 2,
	ETHTOOL_A_MM_STAT_SMD_ERRORS = 3,
	ETHTOOL_A_MM_STAT_REASSEMBLY_OK = 4,
	ETHTOOL_A_MM_STAT_RX_FRAG_COUNT = 5,
	ETHTOOL_A_MM_STAT_TX_FRAG_COUNT = 6,
	ETHTOOL_A_MM_STAT_HOLD_COUNT = 7,
	__ETHTOOL_A_MM_STAT_CNT = 8,
	ETHTOOL_A_MM_STAT_MAX = 7,
};

enum {
	ETHTOOL_A_MM_UNSPEC = 0,
	ETHTOOL_A_MM_HEADER = 1,
	ETHTOOL_A_MM_PMAC_ENABLED = 2,
	ETHTOOL_A_MM_TX_ENABLED = 3,
	ETHTOOL_A_MM_TX_ACTIVE = 4,
	ETHTOOL_A_MM_TX_MIN_FRAG_SIZE = 5,
	ETHTOOL_A_MM_RX_MIN_FRAG_SIZE = 6,
	ETHTOOL_A_MM_VERIFY_ENABLED = 7,
	ETHTOOL_A_MM_VERIFY_STATUS = 8,
	ETHTOOL_A_MM_VERIFY_TIME = 9,
	ETHTOOL_A_MM_MAX_VERIFY_TIME = 10,
	ETHTOOL_A_MM_STATS = 11,
	__ETHTOOL_A_MM_CNT = 12,
	ETHTOOL_A_MM_MAX = 11,
};

enum {
	ETHTOOL_A_MODULE_EEPROM_UNSPEC = 0,
	ETHTOOL_A_MODULE_EEPROM_HEADER = 1,
	ETHTOOL_A_MODULE_EEPROM_OFFSET = 2,
	ETHTOOL_A_MODULE_EEPROM_LENGTH = 3,
	ETHTOOL_A_MODULE_EEPROM_PAGE = 4,
	ETHTOOL_A_MODULE_EEPROM_BANK = 5,
	ETHTOOL_A_MODULE_EEPROM_I2C_ADDRESS = 6,
	ETHTOOL_A_MODULE_EEPROM_DATA = 7,
	__ETHTOOL_A_MODULE_EEPROM_CNT = 8,
	ETHTOOL_A_MODULE_EEPROM_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_FW_FLASH_UNSPEC = 0,
	ETHTOOL_A_MODULE_FW_FLASH_HEADER = 1,
	ETHTOOL_A_MODULE_FW_FLASH_FILE_NAME = 2,
	ETHTOOL_A_MODULE_FW_FLASH_PASSWORD = 3,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS = 4,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS_MSG = 5,
	ETHTOOL_A_MODULE_FW_FLASH_DONE = 6,
	ETHTOOL_A_MODULE_FW_FLASH_TOTAL = 7,
	__ETHTOOL_A_MODULE_FW_FLASH_CNT = 8,
	ETHTOOL_A_MODULE_FW_FLASH_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_UNSPEC = 0,
	ETHTOOL_A_MODULE_HEADER = 1,
	ETHTOOL_A_MODULE_POWER_MODE_POLICY = 2,
	ETHTOOL_A_MODULE_POWER_MODE = 3,
	__ETHTOOL_A_MODULE_CNT = 4,
	ETHTOOL_A_MODULE_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_STAT_UNSPEC = 0,
	ETHTOOL_A_PAUSE_STAT_PAD = 1,
	ETHTOOL_A_PAUSE_STAT_TX_FRAMES = 2,
	ETHTOOL_A_PAUSE_STAT_RX_FRAMES = 3,
	__ETHTOOL_A_PAUSE_STAT_CNT = 4,
	ETHTOOL_A_PAUSE_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_UNSPEC = 0,
	ETHTOOL_A_PAUSE_HEADER = 1,
	ETHTOOL_A_PAUSE_AUTONEG = 2,
	ETHTOOL_A_PAUSE_RX = 3,
	ETHTOOL_A_PAUSE_TX = 4,
	ETHTOOL_A_PAUSE_STATS = 5,
	ETHTOOL_A_PAUSE_STATS_SRC = 6,
	__ETHTOOL_A_PAUSE_CNT = 7,
	ETHTOOL_A_PAUSE_MAX = 6,
};

enum {
	ETHTOOL_A_PHC_VCLOCKS_UNSPEC = 0,
	ETHTOOL_A_PHC_VCLOCKS_HEADER = 1,
	ETHTOOL_A_PHC_VCLOCKS_NUM = 2,
	ETHTOOL_A_PHC_VCLOCKS_INDEX = 3,
	__ETHTOOL_A_PHC_VCLOCKS_CNT = 4,
	ETHTOOL_A_PHC_VCLOCKS_MAX = 3,
};

enum {
	ETHTOOL_A_PHY_UNSPEC = 0,
	ETHTOOL_A_PHY_HEADER = 1,
	ETHTOOL_A_PHY_INDEX = 2,
	ETHTOOL_A_PHY_DRVNAME = 3,
	ETHTOOL_A_PHY_NAME = 4,
	ETHTOOL_A_PHY_UPSTREAM_TYPE = 5,
	ETHTOOL_A_PHY_UPSTREAM_INDEX = 6,
	ETHTOOL_A_PHY_UPSTREAM_SFP_NAME = 7,
	ETHTOOL_A_PHY_DOWNSTREAM_SFP_NAME = 8,
	__ETHTOOL_A_PHY_CNT = 9,
	ETHTOOL_A_PHY_MAX = 8,
};

enum {
	ETHTOOL_A_PLCA_UNSPEC = 0,
	ETHTOOL_A_PLCA_HEADER = 1,
	ETHTOOL_A_PLCA_VERSION = 2,
	ETHTOOL_A_PLCA_ENABLED = 3,
	ETHTOOL_A_PLCA_STATUS = 4,
	ETHTOOL_A_PLCA_NODE_CNT = 5,
	ETHTOOL_A_PLCA_NODE_ID = 6,
	ETHTOOL_A_PLCA_TO_TMR = 7,
	ETHTOOL_A_PLCA_BURST_CNT = 8,
	ETHTOOL_A_PLCA_BURST_TMR = 9,
	__ETHTOOL_A_PLCA_CNT = 10,
	ETHTOOL_A_PLCA_MAX = 9,
};

enum {
	ETHTOOL_A_PRIVFLAGS_UNSPEC = 0,
	ETHTOOL_A_PRIVFLAGS_HEADER = 1,
	ETHTOOL_A_PRIVFLAGS_FLAGS = 2,
	__ETHTOOL_A_PRIVFLAGS_CNT = 3,
	ETHTOOL_A_PRIVFLAGS_MAX = 2,
};

enum {
	ETHTOOL_A_PROFILE_UNSPEC = 0,
	ETHTOOL_A_PROFILE_IRQ_MODERATION = 1,
	__ETHTOOL_A_PROFILE_CNT = 2,
	ETHTOOL_A_PROFILE_MAX = 1,
};

enum {
	ETHTOOL_A_PSE_UNSPEC = 0,
	ETHTOOL_A_PSE_HEADER = 1,
	ETHTOOL_A_PODL_PSE_ADMIN_STATE = 2,
	ETHTOOL_A_PODL_PSE_ADMIN_CONTROL = 3,
	ETHTOOL_A_PODL_PSE_PW_D_STATUS = 4,
	ETHTOOL_A_C33_PSE_ADMIN_STATE = 5,
	ETHTOOL_A_C33_PSE_ADMIN_CONTROL = 6,
	ETHTOOL_A_C33_PSE_PW_D_STATUS = 7,
	ETHTOOL_A_C33_PSE_PW_CLASS = 8,
	ETHTOOL_A_C33_PSE_ACTUAL_PW = 9,
	ETHTOOL_A_C33_PSE_EXT_STATE = 10,
	ETHTOOL_A_C33_PSE_EXT_SUBSTATE = 11,
	ETHTOOL_A_C33_PSE_AVAIL_PW_LIMIT = 12,
	ETHTOOL_A_C33_PSE_PW_LIMIT_RANGES = 13,
	__ETHTOOL_A_PSE_CNT = 14,
	ETHTOOL_A_PSE_MAX = 13,
};

enum {
	ETHTOOL_A_RINGS_UNSPEC = 0,
	ETHTOOL_A_RINGS_HEADER = 1,
	ETHTOOL_A_RINGS_RX_MAX = 2,
	ETHTOOL_A_RINGS_RX_MINI_MAX = 3,
	ETHTOOL_A_RINGS_RX_JUMBO_MAX = 4,
	ETHTOOL_A_RINGS_TX_MAX = 5,
	ETHTOOL_A_RINGS_RX = 6,
	ETHTOOL_A_RINGS_RX_MINI = 7,
	ETHTOOL_A_RINGS_RX_JUMBO = 8,
	ETHTOOL_A_RINGS_TX = 9,
	ETHTOOL_A_RINGS_RX_BUF_LEN = 10,
	ETHTOOL_A_RINGS_TCP_DATA_SPLIT = 11,
	ETHTOOL_A_RINGS_CQE_SIZE = 12,
	ETHTOOL_A_RINGS_TX_PUSH = 13,
	ETHTOOL_A_RINGS_RX_PUSH = 14,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN = 15,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN_MAX = 16,
	ETHTOOL_A_RINGS_HDS_THRESH = 17,
	ETHTOOL_A_RINGS_HDS_THRESH_MAX = 18,
	__ETHTOOL_A_RINGS_CNT = 19,
	ETHTOOL_A_RINGS_MAX = 18,
};

enum {
	ETHTOOL_A_RSS_UNSPEC = 0,
	ETHTOOL_A_RSS_HEADER = 1,
	ETHTOOL_A_RSS_CONTEXT = 2,
	ETHTOOL_A_RSS_HFUNC = 3,
	ETHTOOL_A_RSS_INDIR = 4,
	ETHTOOL_A_RSS_HKEY = 5,
	ETHTOOL_A_RSS_INPUT_XFRM = 6,
	ETHTOOL_A_RSS_START_CONTEXT = 7,
	__ETHTOOL_A_RSS_CNT = 8,
	ETHTOOL_A_RSS_MAX = 7,
};

enum {
	ETHTOOL_A_STATS_ETH_CTRL_3_TX = 0,
	ETHTOOL_A_STATS_ETH_CTRL_4_RX = 1,
	ETHTOOL_A_STATS_ETH_CTRL_5_RX_UNSUP = 2,
	__ETHTOOL_A_STATS_ETH_CTRL_CNT = 3,
	ETHTOOL_A_STATS_ETH_CTRL_MAX = 2,
};

enum {
	ETHTOOL_A_STATS_ETH_MAC_2_TX_PKT = 0,
	ETHTOOL_A_STATS_ETH_MAC_3_SINGLE_COL = 1,
	ETHTOOL_A_STATS_ETH_MAC_4_MULTI_COL = 2,
	ETHTOOL_A_STATS_ETH_MAC_5_RX_PKT = 3,
	ETHTOOL_A_STATS_ETH_MAC_6_FCS_ERR = 4,
	ETHTOOL_A_STATS_ETH_MAC_7_ALIGN_ERR = 5,
	ETHTOOL_A_STATS_ETH_MAC_8_TX_BYTES = 6,
	ETHTOOL_A_STATS_ETH_MAC_9_TX_DEFER = 7,
	ETHTOOL_A_STATS_ETH_MAC_10_LATE_COL = 8,
	ETHTOOL_A_STATS_ETH_MAC_11_XS_COL = 9,
	ETHTOOL_A_STATS_ETH_MAC_12_TX_INT_ERR = 10,
	ETHTOOL_A_STATS_ETH_MAC_13_CS_ERR = 11,
	ETHTOOL_A_STATS_ETH_MAC_14_RX_BYTES = 12,
	ETHTOOL_A_STATS_ETH_MAC_15_RX_INT_ERR = 13,
	ETHTOOL_A_STATS_ETH_MAC_18_TX_MCAST = 14,
	ETHTOOL_A_STATS_ETH_MAC_19_TX_BCAST = 15,
	ETHTOOL_A_STATS_ETH_MAC_20_XS_DEFER = 16,
	ETHTOOL_A_STATS_ETH_MAC_21_RX_MCAST = 17,
	ETHTOOL_A_STATS_ETH_MAC_22_RX_BCAST = 18,
	ETHTOOL_A_STATS_ETH_MAC_23_IR_LEN_ERR = 19,
	ETHTOOL_A_STATS_ETH_MAC_24_OOR_LEN = 20,
	ETHTOOL_A_STATS_ETH_MAC_25_TOO_LONG_ERR = 21,
	__ETHTOOL_A_STATS_ETH_MAC_CNT = 22,
	ETHTOOL_A_STATS_ETH_MAC_MAX = 21,
};

enum {
	ETHTOOL_A_STATS_ETH_PHY_5_SYM_ERR = 0,
	__ETHTOOL_A_STATS_ETH_PHY_CNT = 1,
	ETHTOOL_A_STATS_ETH_PHY_MAX = 0,
};

enum {
	ETHTOOL_A_STATS_GRP_UNSPEC = 0,
	ETHTOOL_A_STATS_GRP_PAD = 1,
	ETHTOOL_A_STATS_GRP_ID = 2,
	ETHTOOL_A_STATS_GRP_SS_ID = 3,
	ETHTOOL_A_STATS_GRP_STAT = 4,
	ETHTOOL_A_STATS_GRP_HIST_RX = 5,
	ETHTOOL_A_STATS_GRP_HIST_TX = 6,
	ETHTOOL_A_STATS_GRP_HIST_BKT_LOW = 7,
	ETHTOOL_A_STATS_GRP_HIST_BKT_HI = 8,
	ETHTOOL_A_STATS_GRP_HIST_VAL = 9,
	__ETHTOOL_A_STATS_GRP_CNT = 10,
	ETHTOOL_A_STATS_GRP_MAX = 9,
};

enum {
	ETHTOOL_A_STATS_PHY_RX_PKTS = 0,
	ETHTOOL_A_STATS_PHY_RX_BYTES = 1,
	ETHTOOL_A_STATS_PHY_RX_ERRORS = 2,
	ETHTOOL_A_STATS_PHY_TX_PKTS = 3,
	ETHTOOL_A_STATS_PHY_TX_BYTES = 4,
	ETHTOOL_A_STATS_PHY_TX_ERRORS = 5,
	__ETHTOOL_A_STATS_PHY_CNT = 6,
	ETHTOOL_A_STATS_PHY_MAX = 5,
};

enum {
	ETHTOOL_A_STATS_RMON_UNDERSIZE = 0,
	ETHTOOL_A_STATS_RMON_OVERSIZE = 1,
	ETHTOOL_A_STATS_RMON_FRAG = 2,
	ETHTOOL_A_STATS_RMON_JABBER = 3,
	__ETHTOOL_A_STATS_RMON_CNT = 4,
	ETHTOOL_A_STATS_RMON_MAX = 3,
};

enum {
	ETHTOOL_A_STATS_UNSPEC = 0,
	ETHTOOL_A_STATS_PAD = 1,
	ETHTOOL_A_STATS_HEADER = 2,
	ETHTOOL_A_STATS_GROUPS = 3,
	ETHTOOL_A_STATS_GRP = 4,
	ETHTOOL_A_STATS_SRC = 5,
	__ETHTOOL_A_STATS_CNT = 6,
	ETHTOOL_A_STATS_MAX = 5,
};

enum {
	ETHTOOL_A_STRINGSETS_UNSPEC = 0,
	ETHTOOL_A_STRINGSETS_STRINGSET = 1,
	__ETHTOOL_A_STRINGSETS_CNT = 2,
	ETHTOOL_A_STRINGSETS_MAX = 1,
};

enum {
	ETHTOOL_A_STRINGSET_UNSPEC = 0,
	ETHTOOL_A_STRINGSET_ID = 1,
	ETHTOOL_A_STRINGSET_COUNT = 2,
	ETHTOOL_A_STRINGSET_STRINGS = 3,
	__ETHTOOL_A_STRINGSET_CNT = 4,
	ETHTOOL_A_STRINGSET_MAX = 3,
};

enum {
	ETHTOOL_A_STRINGS_UNSPEC = 0,
	ETHTOOL_A_STRINGS_STRING = 1,
	__ETHTOOL_A_STRINGS_CNT = 2,
	ETHTOOL_A_STRINGS_MAX = 1,
};

enum {
	ETHTOOL_A_STRING_UNSPEC = 0,
	ETHTOOL_A_STRING_INDEX = 1,
	ETHTOOL_A_STRING_VALUE = 2,
	__ETHTOOL_A_STRING_CNT = 3,
	ETHTOOL_A_STRING_MAX = 2,
};

enum {
	ETHTOOL_A_STRSET_UNSPEC = 0,
	ETHTOOL_A_STRSET_HEADER = 1,
	ETHTOOL_A_STRSET_STRINGSETS = 2,
	ETHTOOL_A_STRSET_COUNTS_ONLY = 3,
	__ETHTOOL_A_STRSET_CNT = 4,
	ETHTOOL_A_STRSET_MAX = 3,
};

enum {
	ETHTOOL_A_TSCONFIG_UNSPEC = 0,
	ETHTOOL_A_TSCONFIG_HEADER = 1,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_PROVIDER = 2,
	ETHTOOL_A_TSCONFIG_TX_TYPES = 3,
	ETHTOOL_A_TSCONFIG_RX_FILTERS = 4,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_FLAGS = 5,
	__ETHTOOL_A_TSCONFIG_CNT = 6,
	ETHTOOL_A_TSCONFIG_MAX = 5,
};

enum {
	ETHTOOL_A_TSINFO_UNSPEC = 0,
	ETHTOOL_A_TSINFO_HEADER = 1,
	ETHTOOL_A_TSINFO_TIMESTAMPING = 2,
	ETHTOOL_A_TSINFO_TX_TYPES = 3,
	ETHTOOL_A_TSINFO_RX_FILTERS = 4,
	ETHTOOL_A_TSINFO_PHC_INDEX = 5,
	ETHTOOL_A_TSINFO_STATS = 6,
	ETHTOOL_A_TSINFO_HWTSTAMP_PROVIDER = 7,
	__ETHTOOL_A_TSINFO_CNT = 8,
	ETHTOOL_A_TSINFO_MAX = 7,
};

enum {
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_UNSPEC = 0,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_INDEX = 1,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_QUALIFIER = 2,
	__ETHTOOL_A_TS_HWTSTAMP_PROVIDER_CNT = 3,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_MAX = 2,
};

enum {
	ETHTOOL_A_TS_STAT_UNSPEC = 0,
	ETHTOOL_A_TS_STAT_TX_PKTS = 1,
	ETHTOOL_A_TS_STAT_TX_LOST = 2,
	ETHTOOL_A_TS_STAT_TX_ERR = 3,
	ETHTOOL_A_TS_STAT_TX_ONESTEP_PKTS_UNCONFIRMED = 4,
	__ETHTOOL_A_TS_STAT_CNT = 5,
	ETHTOOL_A_TS_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_TUNNEL_INFO_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_INFO_HEADER = 1,
	ETHTOOL_A_TUNNEL_INFO_UDP_PORTS = 2,
	__ETHTOOL_A_TUNNEL_INFO_CNT = 3,
	ETHTOOL_A_TUNNEL_INFO_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_ENTRY_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_PORT = 1,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_TYPE = 2,
	__ETHTOOL_A_TUNNEL_UDP_ENTRY_CNT = 3,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_TABLE_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE_SIZE = 1,
	ETHTOOL_A_TUNNEL_UDP_TABLE_TYPES = 2,
	ETHTOOL_A_TUNNEL_UDP_TABLE_ENTRY = 3,
	__ETHTOOL_A_TUNNEL_UDP_TABLE_CNT = 4,
	ETHTOOL_A_TUNNEL_UDP_TABLE_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE = 1,
	__ETHTOOL_A_TUNNEL_UDP_CNT = 2,
	ETHTOOL_A_TUNNEL_UDP_MAX = 1,
};

enum {
	ETHTOOL_A_WOL_UNSPEC = 0,
	ETHTOOL_A_WOL_HEADER = 1,
	ETHTOOL_A_WOL_MODES = 2,
	ETHTOOL_A_WOL_SOPASS = 3,
	__ETHTOOL_A_WOL_CNT = 4,
	ETHTOOL_A_WOL_MAX = 3,
};

enum {
	ETHTOOL_MSG_KERNEL_NONE = 0,
	ETHTOOL_MSG_STRSET_GET_REPLY = 1,
	ETHTOOL_MSG_LINKINFO_GET_REPLY = 2,
	ETHTOOL_MSG_LINKINFO_NTF = 3,
	ETHTOOL_MSG_LINKMODES_GET_REPLY = 4,
	ETHTOOL_MSG_LINKMODES_NTF = 5,
	ETHTOOL_MSG_LINKSTATE_GET_REPLY = 6,
	ETHTOOL_MSG_DEBUG_GET_REPLY = 7,
	ETHTOOL_MSG_DEBUG_NTF = 8,
	ETHTOOL_MSG_WOL_GET_REPLY = 9,
	ETHTOOL_MSG_WOL_NTF = 10,
	ETHTOOL_MSG_FEATURES_GET_REPLY = 11,
	ETHTOOL_MSG_FEATURES_SET_REPLY = 12,
	ETHTOOL_MSG_FEATURES_NTF = 13,
	ETHTOOL_MSG_PRIVFLAGS_GET_REPLY = 14,
	ETHTOOL_MSG_PRIVFLAGS_NTF = 15,
	ETHTOOL_MSG_RINGS_GET_REPLY = 16,
	ETHTOOL_MSG_RINGS_NTF = 17,
	ETHTOOL_MSG_CHANNELS_GET_REPLY = 18,
	ETHTOOL_MSG_CHANNELS_NTF = 19,
	ETHTOOL_MSG_COALESCE_GET_REPLY = 20,
	ETHTOOL_MSG_COALESCE_NTF = 21,
	ETHTOOL_MSG_PAUSE_GET_REPLY = 22,
	ETHTOOL_MSG_PAUSE_NTF = 23,
	ETHTOOL_MSG_EEE_GET_REPLY = 24,
	ETHTOOL_MSG_EEE_NTF = 25,
	ETHTOOL_MSG_TSINFO_GET_REPLY = 26,
	ETHTOOL_MSG_CABLE_TEST_NTF = 27,
	ETHTOOL_MSG_CABLE_TEST_TDR_NTF = 28,
	ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY = 29,
	ETHTOOL_MSG_FEC_GET_REPLY = 30,
	ETHTOOL_MSG_FEC_NTF = 31,
	ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY = 32,
	ETHTOOL_MSG_STATS_GET_REPLY = 33,
	ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY = 34,
	ETHTOOL_MSG_MODULE_GET_REPLY = 35,
	ETHTOOL_MSG_MODULE_NTF = 36,
	ETHTOOL_MSG_PSE_GET_REPLY = 37,
	ETHTOOL_MSG_RSS_GET_REPLY = 38,
	ETHTOOL_MSG_PLCA_GET_CFG_REPLY = 39,
	ETHTOOL_MSG_PLCA_GET_STATUS_REPLY = 40,
	ETHTOOL_MSG_PLCA_NTF = 41,
	ETHTOOL_MSG_MM_GET_REPLY = 42,
	ETHTOOL_MSG_MM_NTF = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_NTF = 44,
	ETHTOOL_MSG_PHY_GET_REPLY = 45,
	ETHTOOL_MSG_PHY_NTF = 46,
	ETHTOOL_MSG_TSCONFIG_GET_REPLY = 47,
	ETHTOOL_MSG_TSCONFIG_SET_REPLY = 48,
	__ETHTOOL_MSG_KERNEL_CNT = 49,
	ETHTOOL_MSG_KERNEL_MAX = 48,
};

enum {
	ETHTOOL_MSG_USER_NONE = 0,
	ETHTOOL_MSG_STRSET_GET = 1,
	ETHTOOL_MSG_LINKINFO_GET = 2,
	ETHTOOL_MSG_LINKINFO_SET = 3,
	ETHTOOL_MSG_LINKMODES_GET = 4,
	ETHTOOL_MSG_LINKMODES_SET = 5,
	ETHTOOL_MSG_LINKSTATE_GET = 6,
	ETHTOOL_MSG_DEBUG_GET = 7,
	ETHTOOL_MSG_DEBUG_SET = 8,
	ETHTOOL_MSG_WOL_GET = 9,
	ETHTOOL_MSG_WOL_SET = 10,
	ETHTOOL_MSG_FEATURES_GET = 11,
	ETHTOOL_MSG_FEATURES_SET = 12,
	ETHTOOL_MSG_PRIVFLAGS_GET = 13,
	ETHTOOL_MSG_PRIVFLAGS_SET = 14,
	ETHTOOL_MSG_RINGS_GET = 15,
	ETHTOOL_MSG_RINGS_SET = 16,
	ETHTOOL_MSG_CHANNELS_GET = 17,
	ETHTOOL_MSG_CHANNELS_SET = 18,
	ETHTOOL_MSG_COALESCE_GET = 19,
	ETHTOOL_MSG_COALESCE_SET = 20,
	ETHTOOL_MSG_PAUSE_GET = 21,
	ETHTOOL_MSG_PAUSE_SET = 22,
	ETHTOOL_MSG_EEE_GET = 23,
	ETHTOOL_MSG_EEE_SET = 24,
	ETHTOOL_MSG_TSINFO_GET = 25,
	ETHTOOL_MSG_CABLE_TEST_ACT = 26,
	ETHTOOL_MSG_CABLE_TEST_TDR_ACT = 27,
	ETHTOOL_MSG_TUNNEL_INFO_GET = 28,
	ETHTOOL_MSG_FEC_GET = 29,
	ETHTOOL_MSG_FEC_SET = 30,
	ETHTOOL_MSG_MODULE_EEPROM_GET = 31,
	ETHTOOL_MSG_STATS_GET = 32,
	ETHTOOL_MSG_PHC_VCLOCKS_GET = 33,
	ETHTOOL_MSG_MODULE_GET = 34,
	ETHTOOL_MSG_MODULE_SET = 35,
	ETHTOOL_MSG_PSE_GET = 36,
	ETHTOOL_MSG_PSE_SET = 37,
	ETHTOOL_MSG_RSS_GET = 38,
	ETHTOOL_MSG_PLCA_GET_CFG = 39,
	ETHTOOL_MSG_PLCA_SET_CFG = 40,
	ETHTOOL_MSG_PLCA_GET_STATUS = 41,
	ETHTOOL_MSG_MM_GET = 42,
	ETHTOOL_MSG_MM_SET = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_ACT = 44,
	ETHTOOL_MSG_PHY_GET = 45,
	ETHTOOL_MSG_TSCONFIG_GET = 46,
	ETHTOOL_MSG_TSCONFIG_SET = 47,
	__ETHTOOL_MSG_USER_CNT = 48,
	ETHTOOL_MSG_USER_MAX = 47,
};

enum {
	ETHTOOL_STATS_ETH_PHY = 0,
	ETHTOOL_STATS_ETH_MAC = 1,
	ETHTOOL_STATS_ETH_CTRL = 2,
	ETHTOOL_STATS_RMON = 3,
	ETHTOOL_STATS_PHY = 4,
	__ETHTOOL_STATS_CNT = 5,
};

enum {
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN = 0,
	ETHTOOL_UDP_TUNNEL_TYPE_GENEVE = 1,
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN_GPE = 2,
	__ETHTOOL_UDP_TUNNEL_TYPE_CNT = 3,
	ETHTOOL_UDP_TUNNEL_TYPE_MAX = 2,
};

enum {
	ETH_RSS_HASH_TOP_BIT = 0,
	ETH_RSS_HASH_XOR_BIT = 1,
	ETH_RSS_HASH_CRC32_BIT = 2,
	ETH_RSS_HASH_FUNCS_COUNT = 3,
};

enum {
	EVENTFS_SAVE_MODE = 65536,
	EVENTFS_SAVE_UID = 131072,
	EVENTFS_SAVE_GID = 262144,
};

enum {
	EVENT_FILE_FL_ENABLED = 1,
	EVENT_FILE_FL_RECORDED_CMD = 2,
	EVENT_FILE_FL_RECORDED_TGID = 4,
	EVENT_FILE_FL_FILTERED = 8,
	EVENT_FILE_FL_NO_SET_FILTER = 16,
	EVENT_FILE_FL_SOFT_MODE = 32,
	EVENT_FILE_FL_SOFT_DISABLED = 64,
	EVENT_FILE_FL_TRIGGER_MODE = 128,
	EVENT_FILE_FL_TRIGGER_COND = 256,
	EVENT_FILE_FL_PID_FILTER = 512,
	EVENT_FILE_FL_WAS_ENABLED = 1024,
	EVENT_FILE_FL_FREED = 2048,
};

enum {
	EVENT_FILE_FL_ENABLED_BIT = 0,
	EVENT_FILE_FL_RECORDED_CMD_BIT = 1,
	EVENT_FILE_FL_RECORDED_TGID_BIT = 2,
	EVENT_FILE_FL_FILTERED_BIT = 3,
	EVENT_FILE_FL_NO_SET_FILTER_BIT = 4,
	EVENT_FILE_FL_SOFT_MODE_BIT = 5,
	EVENT_FILE_FL_SOFT_DISABLED_BIT = 6,
	EVENT_FILE_FL_TRIGGER_MODE_BIT = 7,
	EVENT_FILE_FL_TRIGGER_COND_BIT = 8,
	EVENT_FILE_FL_PID_FILTER_BIT = 9,
	EVENT_FILE_FL_WAS_ENABLED_BIT = 10,
	EVENT_FILE_FL_FREED_BIT = 11,
};

enum {
	EVENT_TRIGGER_FL_PROBE = 1,
};

enum {
	EXP_STATS_FH_STALE = 0,
	EXP_STATS_IO_READ = 1,
	EXP_STATS_IO_WRITE = 2,
	EXP_STATS_COUNTERS_NUM = 3,
};

enum {
	EXT4_FC_REASON_XATTR = 0,
	EXT4_FC_REASON_CROSS_RENAME = 1,
	EXT4_FC_REASON_JOURNAL_FLAG_CHANGE = 2,
	EXT4_FC_REASON_NOMEM = 3,
	EXT4_FC_REASON_SWAP_BOOT = 4,
	EXT4_FC_REASON_RESIZE = 5,
	EXT4_FC_REASON_RENAME_DIR = 6,
	EXT4_FC_REASON_FALLOC_RANGE = 7,
	EXT4_FC_REASON_INODE_JOURNAL_DATA = 8,
	EXT4_FC_REASON_ENCRYPTED_FILENAME = 9,
	EXT4_FC_REASON_MAX = 10,
};

enum {
	EXT4_FC_STATUS_OK = 0,
	EXT4_FC_STATUS_INELIGIBLE = 1,
	EXT4_FC_STATUS_SKIPPED = 2,
	EXT4_FC_STATUS_FAILED = 3,
};

enum {
	EXT4_INODE_SECRM = 0,
	EXT4_INODE_UNRM = 1,
	EXT4_INODE_COMPR = 2,
	EXT4_INODE_SYNC = 3,
	EXT4_INODE_IMMUTABLE = 4,
	EXT4_INODE_APPEND = 5,
	EXT4_INODE_NODUMP = 6,
	EXT4_INODE_NOATIME = 7,
	EXT4_INODE_DIRTY = 8,
	EXT4_INODE_COMPRBLK = 9,
	EXT4_INODE_NOCOMPR = 10,
	EXT4_INODE_ENCRYPT = 11,
	EXT4_INODE_INDEX = 12,
	EXT4_INODE_IMAGIC = 13,
	EXT4_INODE_JOURNAL_DATA = 14,
	EXT4_INODE_NOTAIL = 15,
	EXT4_INODE_DIRSYNC = 16,
	EXT4_INODE_TOPDIR = 17,
	EXT4_INODE_HUGE_FILE = 18,
	EXT4_INODE_EXTENTS = 19,
	EXT4_INODE_VERITY = 20,
	EXT4_INODE_EA_INODE = 21,
	EXT4_INODE_DAX = 25,
	EXT4_INODE_INLINE_DATA = 28,
	EXT4_INODE_PROJINHERIT = 29,
	EXT4_INODE_CASEFOLD = 30,
	EXT4_INODE_RESERVED = 31,
};

enum {
	EXT4_MF_MNTDIR_SAMPLED = 0,
	EXT4_MF_FC_INELIGIBLE = 1,
};

enum {
	EXT4_STATE_NEW = 0,
	EXT4_STATE_XATTR = 1,
	EXT4_STATE_NO_EXPAND = 2,
	EXT4_STATE_DA_ALLOC_CLOSE = 3,
	EXT4_STATE_EXT_MIGRATE = 4,
	EXT4_STATE_NEWENTRY = 5,
	EXT4_STATE_MAY_INLINE_DATA = 6,
	EXT4_STATE_EXT_PRECACHED = 7,
	EXT4_STATE_LUSTRE_EA_INODE = 8,
	EXT4_STATE_VERITY_IN_PROGRESS = 9,
	EXT4_STATE_FC_COMMITTING = 10,
	EXT4_STATE_ORPHAN_FILE = 11,
};

enum {
	EXTENT_BUFFER_UPTODATE = 0,
	EXTENT_BUFFER_DIRTY = 1,
	EXTENT_BUFFER_CORRUPT = 2,
	EXTENT_BUFFER_READAHEAD = 3,
	EXTENT_BUFFER_TREE_REF = 4,
	EXTENT_BUFFER_STALE = 5,
	EXTENT_BUFFER_WRITEBACK = 6,
	EXTENT_BUFFER_READ_ERR = 7,
	EXTENT_BUFFER_UNMAPPED = 8,
	EXTENT_BUFFER_IN_TREE = 9,
	EXTENT_BUFFER_WRITE_ERR = 10,
	EXTENT_BUFFER_ZONED_ZEROOUT = 11,
	EXTENT_BUFFER_READING = 12,
};

enum {
	FAN_EVENT_INIT = 0,
	FAN_EVENT_REPORTED = 1,
	FAN_EVENT_ANSWERED = 2,
	FAN_EVENT_CANCELED = 3,
};

enum {
	FATTR4_CLONE_BLKSIZE = 77,
	FATTR4_SPACE_FREED = 78,
	FATTR4_CHANGE_ATTR_TYPE = 79,
	FATTR4_SEC_LABEL = 80,
};

enum {
	FATTR4_DIR_NOTIF_DELAY = 56,
	FATTR4_DIRENT_NOTIF_DELAY = 57,
	FATTR4_DACL = 58,
	FATTR4_SACL = 59,
	FATTR4_CHANGE_POLICY = 60,
	FATTR4_FS_STATUS = 61,
	FATTR4_FS_LAYOUT_TYPES = 62,
	FATTR4_LAYOUT_HINT = 63,
	FATTR4_LAYOUT_TYPES = 64,
	FATTR4_LAYOUT_BLKSIZE = 65,
	FATTR4_LAYOUT_ALIGNMENT = 66,
	FATTR4_FS_LOCATIONS_INFO = 67,
	FATTR4_MDSTHRESHOLD = 68,
	FATTR4_RETENTION_GET = 69,
	FATTR4_RETENTION_SET = 70,
	FATTR4_RETENTEVT_GET = 71,
	FATTR4_RETENTEVT_SET = 72,
	FATTR4_RETENTION_HOLD = 73,
	FATTR4_MODE_SET_MASKED = 74,
	FATTR4_SUPPATTR_EXCLCREAT = 75,
	FATTR4_FS_CHARSET_CAP = 76,
};

enum {
	FATTR4_MODE_UMASK = 81,
};

enum {
	FATTR4_OPEN_ARGUMENTS = 86,
};

enum {
	FATTR4_SUPPORTED_ATTRS = 0,
	FATTR4_TYPE = 1,
	FATTR4_FH_EXPIRE_TYPE = 2,
	FATTR4_CHANGE = 3,
	FATTR4_SIZE = 4,
	FATTR4_LINK_SUPPORT = 5,
	FATTR4_SYMLINK_SUPPORT = 6,
	FATTR4_NAMED_ATTR = 7,
	FATTR4_FSID = 8,
	FATTR4_UNIQUE_HANDLES = 9,
	FATTR4_LEASE_TIME = 10,
	FATTR4_RDATTR_ERROR = 11,
	FATTR4_ACL = 12,
	FATTR4_ACLSUPPORT = 13,
	FATTR4_ARCHIVE = 14,
	FATTR4_CANSETTIME = 15,
	FATTR4_CASE_INSENSITIVE = 16,
	FATTR4_CASE_PRESERVING = 17,
	FATTR4_CHOWN_RESTRICTED = 18,
	FATTR4_FILEHANDLE = 19,
	FATTR4_FILEID = 20,
	FATTR4_FILES_AVAIL = 21,
	FATTR4_FILES_FREE = 22,
	FATTR4_FILES_TOTAL = 23,
	FATTR4_FS_LOCATIONS = 24,
	FATTR4_HIDDEN = 25,
	FATTR4_HOMOGENEOUS = 26,
	FATTR4_MAXFILESIZE = 27,
	FATTR4_MAXLINK = 28,
	FATTR4_MAXNAME = 29,
	FATTR4_MAXREAD = 30,
	FATTR4_MAXWRITE = 31,
	FATTR4_MIMETYPE = 32,
	FATTR4_MODE = 33,
	FATTR4_NO_TRUNC = 34,
	FATTR4_NUMLINKS = 35,
	FATTR4_OWNER = 36,
	FATTR4_OWNER_GROUP = 37,
	FATTR4_QUOTA_AVAIL_HARD = 38,
	FATTR4_QUOTA_AVAIL_SOFT = 39,
	FATTR4_QUOTA_USED = 40,
	FATTR4_RAWDEV = 41,
	FATTR4_SPACE_AVAIL = 42,
	FATTR4_SPACE_FREE = 43,
	FATTR4_SPACE_TOTAL = 44,
	FATTR4_SPACE_USED = 45,
	FATTR4_SYSTEM = 46,
	FATTR4_TIME_ACCESS = 47,
	FATTR4_TIME_ACCESS_SET = 48,
	FATTR4_TIME_BACKUP = 49,
	FATTR4_TIME_CREATE = 50,
	FATTR4_TIME_DELTA = 51,
	FATTR4_TIME_METADATA = 52,
	FATTR4_TIME_MODIFY = 53,
	FATTR4_TIME_MODIFY_SET = 54,
	FATTR4_MOUNTED_ON_FILEID = 55,
};

enum {
	FATTR4_TIME_DELEG_ACCESS = 84,
};

enum {
	FATTR4_TIME_DELEG_MODIFY = 85,
};

enum {
	FATTR4_XATTR_SUPPORT = 82,
};

enum {
	FBCON_LOGO_CANSHOW = -1,
	FBCON_LOGO_DRAW = -2,
	FBCON_LOGO_DONTSHOW = -3,
};

enum {
	FB_BLANK_UNBLANK = 0,
	FB_BLANK_NORMAL = 1,
	FB_BLANK_VSYNC_SUSPEND = 2,
	FB_BLANK_HSYNC_SUSPEND = 3,
	FB_BLANK_POWERDOWN = 4,
};

enum {
	FIB6_NO_SERNUM_CHANGE = 0,
};

enum {
	FILEID_HIGH_OFF = 0,
	FILEID_LOW_OFF = 1,
	FILE_I_TYPE_OFF = 2,
	EMBED_FH_OFF = 3,
};

enum {
	FILTER_OTHER = 0,
	FILTER_STATIC_STRING = 1,
	FILTER_DYN_STRING = 2,
	FILTER_RDYN_STRING = 3,
	FILTER_PTR_STRING = 4,
	FILTER_TRACE_FN = 5,
	FILTER_CPUMASK = 6,
	FILTER_COMM = 7,
	FILTER_CPU = 8,
	FILTER_STACKTRACE = 9,
};

enum {
	FILT_ERR_NONE = 0,
	FILT_ERR_INVALID_OP = 1,
	FILT_ERR_TOO_MANY_OPEN = 2,
	FILT_ERR_TOO_MANY_CLOSE = 3,
	FILT_ERR_MISSING_QUOTE = 4,
	FILT_ERR_MISSING_BRACE_OPEN = 5,
	FILT_ERR_MISSING_BRACE_CLOSE = 6,
	FILT_ERR_OPERAND_TOO_LONG = 7,
	FILT_ERR_EXPECT_STRING = 8,
	FILT_ERR_EXPECT_DIGIT = 9,
	FILT_ERR_ILLEGAL_FIELD_OP = 10,
	FILT_ERR_FIELD_NOT_FOUND = 11,
	FILT_ERR_ILLEGAL_INTVAL = 12,
	FILT_ERR_BAD_SUBSYS_FILTER = 13,
	FILT_ERR_TOO_MANY_PREDS = 14,
	FILT_ERR_INVALID_FILTER = 15,
	FILT_ERR_INVALID_CPULIST = 16,
	FILT_ERR_IP_FIELD_ONLY = 17,
	FILT_ERR_INVALID_VALUE = 18,
	FILT_ERR_NO_FUNCTION = 19,
	FILT_ERR_ERRNO = 20,
	FILT_ERR_NO_FILTER = 21,
};

enum {
	FOLL_TOUCH = 65536,
	FOLL_TRIED = 131072,
	FOLL_REMOTE = 262144,
	FOLL_PIN = 524288,
	FOLL_FAST_ONLY = 1048576,
	FOLL_UNLOCKABLE = 2097152,
	FOLL_MADV_POPULATE = 4194304,
};

enum {
	FOLL_WRITE = 1,
	FOLL_GET = 2,
	FOLL_DUMP = 4,
	FOLL_FORCE = 8,
	FOLL_NOWAIT = 16,
	FOLL_NOFAULT = 32,
	FOLL_HWPOISON = 64,
	FOLL_ANON = 128,
	FOLL_LONGTERM = 256,
	FOLL_SPLIT_PMD = 512,
	FOLL_PCI_P2PDMA = 1024,
	FOLL_INTERRUPTIBLE = 2048,
	FOLL_HONOR_NUMA_FAULT = 4096,
};

enum {
	FORMAT_HEADER = 1,
	FORMAT_FIELD_SEPERATOR = 2,
	FORMAT_PRINTFMT = 3,
};

enum {
	FRACTION_DENOM = 128,
};

enum {
	FRA_UNSPEC = 0,
	FRA_DST = 1,
	FRA_SRC = 2,
	FRA_IIFNAME = 3,
	FRA_GOTO = 4,
	FRA_UNUSED2 = 5,
	FRA_PRIORITY = 6,
	FRA_UNUSED3 = 7,
	FRA_UNUSED4 = 8,
	FRA_UNUSED5 = 9,
	FRA_FWMARK = 10,
	FRA_FLOW = 11,
	FRA_TUN_ID = 12,
	FRA_SUPPRESS_IFGROUP = 13,
	FRA_SUPPRESS_PREFIXLEN = 14,
	FRA_TABLE = 15,
	FRA_FWMASK = 16,
	FRA_OIFNAME = 17,
	FRA_PAD = 18,
	FRA_L3MDEV = 19,
	FRA_UID_RANGE = 20,
	FRA_PROTOCOL = 21,
	FRA_IP_PROTO = 22,
	FRA_SPORT_RANGE = 23,
	FRA_DPORT_RANGE = 24,
	FRA_DSCP = 25,
	FRA_FLOWLABEL = 26,
	FRA_FLOWLABEL_MASK = 27,
	__FRA_MAX = 28,
};

enum {
	FR_ACT_UNSPEC = 0,
	FR_ACT_TO_TBL = 1,
	FR_ACT_GOTO = 2,
	FR_ACT_NOP = 3,
	FR_ACT_RES3 = 4,
	FR_ACT_RES4 = 5,
	FR_ACT_BLACKHOLE = 6,
	FR_ACT_UNREACHABLE = 7,
	FR_ACT_PROHIBIT = 8,
	__FR_ACT_MAX = 9,
};

enum {
	FUTEX_STATE_OK = 0,
	FUTEX_STATE_EXITING = 1,
	FUTEX_STATE_DEAD = 2,
};

enum {
	GENHD_FL_REMOVABLE = 1,
	GENHD_FL_HIDDEN = 2,
	GENHD_FL_NO_PART = 4,
};

enum {
	GPIO_MODDEF0 = 0,
	GPIO_LOS = 1,
	GPIO_TX_FAULT = 2,
	GPIO_TX_DISABLE = 3,
	GPIO_RS0 = 4,
	GPIO_RS1 = 5,
	GPIO_MAX = 6,
	SFP_F_PRESENT = 1,
	SFP_F_LOS = 2,
	SFP_F_TX_FAULT = 4,
	SFP_F_TX_DISABLE = 8,
	SFP_F_RS0 = 16,
	SFP_F_RS1 = 32,
	SFP_F_OUTPUTS = 56,
	SFP_E_INSERT = 0,
	SFP_E_REMOVE = 1,
	SFP_E_DEV_ATTACH = 2,
	SFP_E_DEV_DETACH = 3,
	SFP_E_DEV_DOWN = 4,
	SFP_E_DEV_UP = 5,
	SFP_E_TX_FAULT = 6,
	SFP_E_TX_CLEAR = 7,
	SFP_E_LOS_HIGH = 8,
	SFP_E_LOS_LOW = 9,
	SFP_E_TIMEOUT = 10,
	SFP_MOD_EMPTY = 0,
	SFP_MOD_ERROR = 1,
	SFP_MOD_PROBE = 2,
	SFP_MOD_WAITDEV = 3,
	SFP_MOD_HPOWER = 4,
	SFP_MOD_WAITPWR = 5,
	SFP_MOD_PRESENT = 6,
	SFP_DEV_DETACHED = 0,
	SFP_DEV_DOWN = 1,
	SFP_DEV_UP = 2,
	SFP_S_DOWN = 0,
	SFP_S_FAIL = 1,
	SFP_S_WAIT = 2,
	SFP_S_INIT = 3,
	SFP_S_INIT_PHY = 4,
	SFP_S_INIT_TX_FAULT = 5,
	SFP_S_WAIT_LOS = 6,
	SFP_S_LINK_UP = 7,
	SFP_S_TX_FAULT = 8,
	SFP_S_REINIT = 9,
	SFP_S_TX_DISABLE = 10,
};

enum {
	GP_IDLE = 0,
	GP_ENTER = 1,
	GP_PASSED = 2,
	GP_EXIT = 3,
	GP_REPLAY = 4,
};

enum {
	GSSX_NULL = 0,
	GSSX_INDICATE_MECHS = 1,
	GSSX_GET_CALL_CONTEXT = 2,
	GSSX_IMPORT_AND_CANON_NAME = 3,
	GSSX_EXPORT_CRED = 4,
	GSSX_IMPORT_CRED = 5,
	GSSX_ACQUIRE_CRED = 6,
	GSSX_STORE_CRED = 7,
	GSSX_INIT_SEC_CONTEXT = 8,
	GSSX_ACCEPT_SEC_CONTEXT = 9,
	GSSX_RELEASE_HANDLE = 10,
	GSSX_GET_MIC = 11,
	GSSX_VERIFY = 12,
	GSSX_WRAP = 13,
	GSSX_UNWRAP = 14,
	GSSX_WRAP_SIZE_LIMIT = 15,
};

enum {
	HANDSHAKE_A_ACCEPT_SOCKFD = 1,
	HANDSHAKE_A_ACCEPT_HANDLER_CLASS = 2,
	HANDSHAKE_A_ACCEPT_MESSAGE_TYPE = 3,
	HANDSHAKE_A_ACCEPT_TIMEOUT = 4,
	HANDSHAKE_A_ACCEPT_AUTH_MODE = 5,
	HANDSHAKE_A_ACCEPT_PEER_IDENTITY = 6,
	HANDSHAKE_A_ACCEPT_CERTIFICATE = 7,
	HANDSHAKE_A_ACCEPT_PEERNAME = 8,
	__HANDSHAKE_A_ACCEPT_MAX = 9,
	HANDSHAKE_A_ACCEPT_MAX = 8,
};

enum {
	HANDSHAKE_A_DONE_STATUS = 1,
	HANDSHAKE_A_DONE_SOCKFD = 2,
	HANDSHAKE_A_DONE_REMOTE_AUTH = 3,
	__HANDSHAKE_A_DONE_MAX = 4,
	HANDSHAKE_A_DONE_MAX = 3,
};

enum {
	HANDSHAKE_A_X509_CERT = 1,
	HANDSHAKE_A_X509_PRIVKEY = 2,
	__HANDSHAKE_A_X509_MAX = 3,
	HANDSHAKE_A_X509_MAX = 2,
};

enum {
	HANDSHAKE_CMD_READY = 1,
	HANDSHAKE_CMD_ACCEPT = 2,
	HANDSHAKE_CMD_DONE = 3,
	__HANDSHAKE_CMD_MAX = 4,
	HANDSHAKE_CMD_MAX = 3,
};

enum {
	HANDSHAKE_NLGRP_NONE = 0,
	HANDSHAKE_NLGRP_TLSHD = 1,
};

enum {
	HASH_SIZE = 128,
};

enum {
	HAS_READ = 1,
	HAS_WRITE = 2,
	HAS_LSEEK = 4,
	HAS_POLL = 8,
	HAS_IOCTL = 16,
};

enum {
	HDA_CTL_WIDGET_VOL = 0,
	HDA_CTL_WIDGET_MUTE = 1,
	HDA_CTL_BIND_MUTE = 2,
};

enum {
	HDA_DEV_CORE = 0,
	HDA_DEV_LEGACY = 1,
	HDA_DEV_ASOC = 2,
};

enum {
	HDA_DIG_NONE = 0,
	HDA_DIG_EXCLUSIVE = 1,
	HDA_DIG_ANALOG_DUP = 2,
};

enum {
	HDA_FIXUP_ACT_PRE_PROBE = 0,
	HDA_FIXUP_ACT_PROBE = 1,
	HDA_FIXUP_ACT_INIT = 2,
	HDA_FIXUP_ACT_BUILD = 3,
	HDA_FIXUP_ACT_FREE = 4,
};

enum {
	HDA_FIXUP_INVALID = 0,
	HDA_FIXUP_PINS = 1,
	HDA_FIXUP_VERBS = 2,
	HDA_FIXUP_FUNC = 3,
	HDA_FIXUP_PINCTLS = 4,
};

enum {
	HDA_FRONT = 0,
	HDA_REAR = 1,
	HDA_CLFE = 2,
	HDA_SIDE = 3,
};

enum {
	HDA_GEN_PCM_ACT_OPEN = 0,
	HDA_GEN_PCM_ACT_PREPARE = 1,
	HDA_GEN_PCM_ACT_CLEANUP = 2,
	HDA_GEN_PCM_ACT_CLOSE = 3,
};

enum {
	HDA_HINT_STEREO_MIX_DISABLE = 0,
	HDA_HINT_STEREO_MIX_ENABLE = 1,
	HDA_HINT_STEREO_MIX_AUTO = 2,
};

enum {
	HDA_INPUT = 0,
	HDA_OUTPUT = 1,
};

enum {
	HDA_JACK_NOT_PRESENT = 0,
	HDA_JACK_PRESENT = 1,
	HDA_JACK_PHANTOM = 2,
};

enum {
	HDA_PCM_TYPE_AUDIO = 0,
	HDA_PCM_TYPE_SPDIF = 1,
	HDA_PCM_TYPE_HDMI = 2,
	HDA_PCM_TYPE_MODEM = 3,
	HDA_PCM_NTYPES = 4,
};

enum {
	HIBERNATION_INVALID = 0,
	HIBERNATION_PLATFORM = 1,
	HIBERNATION_SHUTDOWN = 2,
	HIBERNATION_REBOOT = 3,
	HIBERNATION_SUSPEND = 4,
	HIBERNATION_TEST_RESUME = 5,
	__HIBERNATION_AFTER_LAST = 6,
};

enum {
	HI_SOFTIRQ = 0,
	TIMER_SOFTIRQ = 1,
	NET_TX_SOFTIRQ = 2,
	NET_RX_SOFTIRQ = 3,
	BLOCK_SOFTIRQ = 4,
	IRQ_POLL_SOFTIRQ = 5,
	TASKLET_SOFTIRQ = 6,
	SCHED_SOFTIRQ = 7,
	HRTIMER_SOFTIRQ = 8,
	RCU_SOFTIRQ = 9,
	NR_SOFTIRQS = 10,
};

enum {
	HMM_NEED_FAULT = 1,
	HMM_NEED_WRITE_FAULT = 2,
	HMM_NEED_ALL_BITS = 3,
};

enum {
	HP_THREAD_NONE = 0,
	HP_THREAD_ACTIVE = 1,
	HP_THREAD_PARKED = 2,
};

enum {
	HUGETLB_SHMFS_INODE = 1,
	HUGETLB_ANONHUGE_INODE = 2,
};

enum {
	HW_BREAKPOINT_EMPTY = 0,
	HW_BREAKPOINT_R = 1,
	HW_BREAKPOINT_W = 2,
	HW_BREAKPOINT_RW = 3,
	HW_BREAKPOINT_X = 4,
	HW_BREAKPOINT_INVALID = 7,
};

enum {
	HW_BREAKPOINT_LEN_1 = 1,
	HW_BREAKPOINT_LEN_2 = 2,
	HW_BREAKPOINT_LEN_3 = 3,
	HW_BREAKPOINT_LEN_4 = 4,
	HW_BREAKPOINT_LEN_5 = 5,
	HW_BREAKPOINT_LEN_6 = 6,
	HW_BREAKPOINT_LEN_7 = 7,
	HW_BREAKPOINT_LEN_8 = 8,
};

enum {
	IB_MGMT_MAD_HDR = 24,
	IB_MGMT_MAD_DATA = 232,
	IB_MGMT_RMPP_HDR = 36,
	IB_MGMT_RMPP_DATA = 220,
	IB_MGMT_VENDOR_HDR = 40,
	IB_MGMT_VENDOR_DATA = 216,
	IB_MGMT_SA_HDR = 56,
	IB_MGMT_SA_DATA = 200,
	IB_MGMT_DEVICE_HDR = 64,
	IB_MGMT_DEVICE_DATA = 192,
	IB_MGMT_MAD_SIZE = 256,
	OPA_MGMT_MAD_DATA = 2024,
	OPA_MGMT_RMPP_DATA = 2012,
	OPA_MGMT_MAD_SIZE = 2048,
};

enum {
	IB_USER_MAD_USER_RMPP = 1,
};

enum {
	ICMP6_MIB_NUM = 0,
	ICMP6_MIB_INMSGS = 1,
	ICMP6_MIB_INERRORS = 2,
	ICMP6_MIB_OUTMSGS = 3,
	ICMP6_MIB_OUTERRORS = 4,
	ICMP6_MIB_CSUMERRORS = 5,
	ICMP6_MIB_RATELIMITHOST = 6,
	__ICMP6_MIB_MAX = 7,
};

enum {
	ICMP_MIB_NUM = 0,
	ICMP_MIB_INMSGS = 1,
	ICMP_MIB_INERRORS = 2,
	ICMP_MIB_INDESTUNREACHS = 3,
	ICMP_MIB_INTIMEEXCDS = 4,
	ICMP_MIB_INPARMPROBS = 5,
	ICMP_MIB_INSRCQUENCHS = 6,
	ICMP_MIB_INREDIRECTS = 7,
	ICMP_MIB_INECHOS = 8,
	ICMP_MIB_INECHOREPS = 9,
	ICMP_MIB_INTIMESTAMPS = 10,
	ICMP_MIB_INTIMESTAMPREPS = 11,
	ICMP_MIB_INADDRMASKS = 12,
	ICMP_MIB_INADDRMASKREPS = 13,
	ICMP_MIB_OUTMSGS = 14,
	ICMP_MIB_OUTERRORS = 15,
	ICMP_MIB_OUTDESTUNREACHS = 16,
	ICMP_MIB_OUTTIMEEXCDS = 17,
	ICMP_MIB_OUTPARMPROBS = 18,
	ICMP_MIB_OUTSRCQUENCHS = 19,
	ICMP_MIB_OUTREDIRECTS = 20,
	ICMP_MIB_OUTECHOS = 21,
	ICMP_MIB_OUTECHOREPS = 22,
	ICMP_MIB_OUTTIMESTAMPS = 23,
	ICMP_MIB_OUTTIMESTAMPREPS = 24,
	ICMP_MIB_OUTADDRMASKS = 25,
	ICMP_MIB_OUTADDRMASKREPS = 26,
	ICMP_MIB_CSUMERRORS = 27,
	ICMP_MIB_RATELIMITGLOBAL = 28,
	ICMP_MIB_RATELIMITHOST = 29,
	__ICMP_MIB_MAX = 30,
};

enum {
	ICQ_EXITED = 4,
	ICQ_DESTROYED = 8,
};

enum {
	IDX_MODULE_ID = 0,
	IDX_ST_OPS_COMMON_VALUE_ID = 1,
};

enum {
	IFAL_ADDRESS = 1,
	IFAL_LABEL = 2,
	__IFAL_MAX = 3,
};

enum {
	IFA_UNSPEC = 0,
	IFA_ADDRESS = 1,
	IFA_LOCAL = 2,
	IFA_LABEL = 3,
	IFA_BROADCAST = 4,
	IFA_ANYCAST = 5,
	IFA_CACHEINFO = 6,
	IFA_MULTICAST = 7,
	IFA_FLAGS = 8,
	IFA_RT_PRIORITY = 9,
	IFA_TARGET_NETNSID = 10,
	IFA_PROTO = 11,
	__IFA_MAX = 12,
};

enum {
	IFLA_BRIDGE_FLAGS = 0,
	IFLA_BRIDGE_MODE = 1,
	IFLA_BRIDGE_VLAN_INFO = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_INFO = 3,
	IFLA_BRIDGE_MRP = 4,
	IFLA_BRIDGE_CFM = 5,
	IFLA_BRIDGE_MST = 6,
	__IFLA_BRIDGE_MAX = 7,
};

enum {
	IFLA_BRPORT_UNSPEC = 0,
	IFLA_BRPORT_STATE = 1,
	IFLA_BRPORT_PRIORITY = 2,
	IFLA_BRPORT_COST = 3,
	IFLA_BRPORT_MODE = 4,
	IFLA_BRPORT_GUARD = 5,
	IFLA_BRPORT_PROTECT = 6,
	IFLA_BRPORT_FAST_LEAVE = 7,
	IFLA_BRPORT_LEARNING = 8,
	IFLA_BRPORT_UNICAST_FLOOD = 9,
	IFLA_BRPORT_PROXYARP = 10,
	IFLA_BRPORT_LEARNING_SYNC = 11,
	IFLA_BRPORT_PROXYARP_WIFI = 12,
	IFLA_BRPORT_ROOT_ID = 13,
	IFLA_BRPORT_BRIDGE_ID = 14,
	IFLA_BRPORT_DESIGNATED_PORT = 15,
	IFLA_BRPORT_DESIGNATED_COST = 16,
	IFLA_BRPORT_ID = 17,
	IFLA_BRPORT_NO = 18,
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK = 19,
	IFLA_BRPORT_CONFIG_PENDING = 20,
	IFLA_BRPORT_MESSAGE_AGE_TIMER = 21,
	IFLA_BRPORT_FORWARD_DELAY_TIMER = 22,
	IFLA_BRPORT_HOLD_TIMER = 23,
	IFLA_BRPORT_FLUSH = 24,
	IFLA_BRPORT_MULTICAST_ROUTER = 25,
	IFLA_BRPORT_PAD = 26,
	IFLA_BRPORT_MCAST_FLOOD = 27,
	IFLA_BRPORT_MCAST_TO_UCAST = 28,
	IFLA_BRPORT_VLAN_TUNNEL = 29,
	IFLA_BRPORT_BCAST_FLOOD = 30,
	IFLA_BRPORT_GROUP_FWD_MASK = 31,
	IFLA_BRPORT_NEIGH_SUPPRESS = 32,
	IFLA_BRPORT_ISOLATED = 33,
	IFLA_BRPORT_BACKUP_PORT = 34,
	IFLA_BRPORT_MRP_RING_OPEN = 35,
	IFLA_BRPORT_MRP_IN_OPEN = 36,
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT = 37,
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT = 38,
	IFLA_BRPORT_LOCKED = 39,
	IFLA_BRPORT_MAB = 40,
	IFLA_BRPORT_MCAST_N_GROUPS = 41,
	IFLA_BRPORT_MCAST_MAX_GROUPS = 42,
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS = 43,
	IFLA_BRPORT_BACKUP_NHID = 44,
	__IFLA_BRPORT_MAX = 45,
};

enum {
	IFLA_EVENT_NONE = 0,
	IFLA_EVENT_REBOOT = 1,
	IFLA_EVENT_FEATURES = 2,
	IFLA_EVENT_BONDING_FAILOVER = 3,
	IFLA_EVENT_NOTIFY_PEERS = 4,
	IFLA_EVENT_IGMP_RESEND = 5,
	IFLA_EVENT_BONDING_OPTIONS = 6,
};

enum {
	IFLA_INET6_UNSPEC = 0,
	IFLA_INET6_FLAGS = 1,
	IFLA_INET6_CONF = 2,
	IFLA_INET6_STATS = 3,
	IFLA_INET6_MCAST = 4,
	IFLA_INET6_CACHEINFO = 5,
	IFLA_INET6_ICMP6STATS = 6,
	IFLA_INET6_TOKEN = 7,
	IFLA_INET6_ADDR_GEN_MODE = 8,
	IFLA_INET6_RA_MTU = 9,
	__IFLA_INET6_MAX = 10,
};

enum {
	IFLA_INET_UNSPEC = 0,
	IFLA_INET_CONF = 1,
	__IFLA_INET_MAX = 2,
};

enum {
	IFLA_INFO_UNSPEC = 0,
	IFLA_INFO_KIND = 1,
	IFLA_INFO_DATA = 2,
	IFLA_INFO_XSTATS = 3,
	IFLA_INFO_SLAVE_KIND = 4,
	IFLA_INFO_SLAVE_DATA = 5,
	__IFLA_INFO_MAX = 6,
};

enum {
	IFLA_IPTUN_UNSPEC = 0,
	IFLA_IPTUN_LINK = 1,
	IFLA_IPTUN_LOCAL = 2,
	IFLA_IPTUN_REMOTE = 3,
	IFLA_IPTUN_TTL = 4,
	IFLA_IPTUN_TOS = 5,
	IFLA_IPTUN_ENCAP_LIMIT = 6,
	IFLA_IPTUN_FLOWINFO = 7,
	IFLA_IPTUN_FLAGS = 8,
	IFLA_IPTUN_PROTO = 9,
	IFLA_IPTUN_PMTUDISC = 10,
	IFLA_IPTUN_6RD_PREFIX = 11,
	IFLA_IPTUN_6RD_RELAY_PREFIX = 12,
	IFLA_IPTUN_6RD_PREFIXLEN = 13,
	IFLA_IPTUN_6RD_RELAY_PREFIXLEN = 14,
	IFLA_IPTUN_ENCAP_TYPE = 15,
	IFLA_IPTUN_ENCAP_FLAGS = 16,
	IFLA_IPTUN_ENCAP_SPORT = 17,
	IFLA_IPTUN_ENCAP_DPORT = 18,
	IFLA_IPTUN_COLLECT_METADATA = 19,
	IFLA_IPTUN_FWMARK = 20,
	__IFLA_IPTUN_MAX = 21,
};

enum {
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_REQUEST = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_USED = 2,
	__IFLA_OFFLOAD_XSTATS_HW_S_INFO_MAX = 3,
};

enum {
	IFLA_OFFLOAD_XSTATS_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_CPU_HIT = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO = 2,
	IFLA_OFFLOAD_XSTATS_L3_STATS = 3,
	__IFLA_OFFLOAD_XSTATS_MAX = 4,
};

enum {
	IFLA_PORT_UNSPEC = 0,
	IFLA_PORT_VF = 1,
	IFLA_PORT_PROFILE = 2,
	IFLA_PORT_VSI_TYPE = 3,
	IFLA_PORT_INSTANCE_UUID = 4,
	IFLA_PORT_HOST_UUID = 5,
	IFLA_PORT_REQUEST = 6,
	IFLA_PORT_RESPONSE = 7,
	__IFLA_PORT_MAX = 8,
};

enum {
	IFLA_PROTO_DOWN_REASON_UNSPEC = 0,
	IFLA_PROTO_DOWN_REASON_MASK = 1,
	IFLA_PROTO_DOWN_REASON_VALUE = 2,
	__IFLA_PROTO_DOWN_REASON_CNT = 3,
	IFLA_PROTO_DOWN_REASON_MAX = 2,
};

enum {
	IFLA_STATS_GETSET_UNSPEC = 0,
	IFLA_STATS_GET_FILTERS = 1,
	IFLA_STATS_SET_OFFLOAD_XSTATS_L3_STATS = 2,
	__IFLA_STATS_GETSET_MAX = 3,
};

enum {
	IFLA_STATS_UNSPEC = 0,
	IFLA_STATS_LINK_64 = 1,
	IFLA_STATS_LINK_XSTATS = 2,
	IFLA_STATS_LINK_XSTATS_SLAVE = 3,
	IFLA_STATS_LINK_OFFLOAD_XSTATS = 4,
	IFLA_STATS_AF_SPEC = 5,
	__IFLA_STATS_MAX = 6,
};

enum {
	IFLA_UNSPEC = 0,
	IFLA_ADDRESS = 1,
	IFLA_BROADCAST = 2,
	IFLA_IFNAME = 3,
	IFLA_MTU = 4,
	IFLA_LINK = 5,
	IFLA_QDISC = 6,
	IFLA_STATS = 7,
	IFLA_COST = 8,
	IFLA_PRIORITY = 9,
	IFLA_MASTER = 10,
	IFLA_WIRELESS = 11,
	IFLA_PROTINFO = 12,
	IFLA_TXQLEN = 13,
	IFLA_MAP = 14,
	IFLA_WEIGHT = 15,
	IFLA_OPERSTATE = 16,
	IFLA_LINKMODE = 17,
	IFLA_LINKINFO = 18,
	IFLA_NET_NS_PID = 19,
	IFLA_IFALIAS = 20,
	IFLA_NUM_VF = 21,
	IFLA_VFINFO_LIST = 22,
	IFLA_STATS64 = 23,
	IFLA_VF_PORTS = 24,
	IFLA_PORT_SELF = 25,
	IFLA_AF_SPEC = 26,
	IFLA_GROUP = 27,
	IFLA_NET_NS_FD = 28,
	IFLA_EXT_MASK = 29,
	IFLA_PROMISCUITY = 30,
	IFLA_NUM_TX_QUEUES = 31,
	IFLA_NUM_RX_QUEUES = 32,
	IFLA_CARRIER = 33,
	IFLA_PHYS_PORT_ID = 34,
	IFLA_CARRIER_CHANGES = 35,
	IFLA_PHYS_SWITCH_ID = 36,
	IFLA_LINK_NETNSID = 37,
	IFLA_PHYS_PORT_NAME = 38,
	IFLA_PROTO_DOWN = 39,
	IFLA_GSO_MAX_SEGS = 40,
	IFLA_GSO_MAX_SIZE = 41,
	IFLA_PAD = 42,
	IFLA_XDP = 43,
	IFLA_EVENT = 44,
	IFLA_NEW_NETNSID = 45,
	IFLA_IF_NETNSID = 46,
	IFLA_TARGET_NETNSID = 46,
	IFLA_CARRIER_UP_COUNT = 47,
	IFLA_CARRIER_DOWN_COUNT = 48,
	IFLA_NEW_IFINDEX = 49,
	IFLA_MIN_MTU = 50,
	IFLA_MAX_MTU = 51,
	IFLA_PROP_LIST = 52,
	IFLA_ALT_IFNAME = 53,
	IFLA_PERM_ADDRESS = 54,
	IFLA_PROTO_DOWN_REASON = 55,
	IFLA_PARENT_DEV_NAME = 56,
	IFLA_PARENT_DEV_BUS_NAME = 57,
	IFLA_GRO_MAX_SIZE = 58,
	IFLA_TSO_MAX_SIZE = 59,
	IFLA_TSO_MAX_SEGS = 60,
	IFLA_ALLMULTI = 61,
	IFLA_DEVLINK_PORT = 62,
	IFLA_GSO_IPV4_MAX_SIZE = 63,
	IFLA_GRO_IPV4_MAX_SIZE = 64,
	IFLA_DPLL_PIN = 65,
	IFLA_MAX_PACING_OFFLOAD_HORIZON = 66,
	__IFLA_MAX = 67,
};

enum {
	IFLA_VF_INFO_UNSPEC = 0,
	IFLA_VF_INFO = 1,
	__IFLA_VF_INFO_MAX = 2,
};

enum {
	IFLA_VF_LINK_STATE_AUTO = 0,
	IFLA_VF_LINK_STATE_ENABLE = 1,
	IFLA_VF_LINK_STATE_DISABLE = 2,
	__IFLA_VF_LINK_STATE_MAX = 3,
};

enum {
	IFLA_VF_PORT_UNSPEC = 0,
	IFLA_VF_PORT = 1,
	__IFLA_VF_PORT_MAX = 2,
};

enum {
	IFLA_VF_STATS_RX_PACKETS = 0,
	IFLA_VF_STATS_TX_PACKETS = 1,
	IFLA_VF_STATS_RX_BYTES = 2,
	IFLA_VF_STATS_TX_BYTES = 3,
	IFLA_VF_STATS_BROADCAST = 4,
	IFLA_VF_STATS_MULTICAST = 5,
	IFLA_VF_STATS_PAD = 6,
	IFLA_VF_STATS_RX_DROPPED = 7,
	IFLA_VF_STATS_TX_DROPPED = 8,
	__IFLA_VF_STATS_MAX = 9,
};

enum {
	IFLA_VF_UNSPEC = 0,
	IFLA_VF_MAC = 1,
	IFLA_VF_VLAN = 2,
	IFLA_VF_TX_RATE = 3,
	IFLA_VF_SPOOFCHK = 4,
	IFLA_VF_LINK_STATE = 5,
	IFLA_VF_RATE = 6,
	IFLA_VF_RSS_QUERY_EN = 7,
	IFLA_VF_STATS = 8,
	IFLA_VF_TRUST = 9,
	IFLA_VF_IB_NODE_GUID = 10,
	IFLA_VF_IB_PORT_GUID = 11,
	IFLA_VF_VLAN_LIST = 12,
	IFLA_VF_BROADCAST = 13,
	__IFLA_VF_MAX = 14,
};

enum {
	IFLA_VF_VLAN_INFO_UNSPEC = 0,
	IFLA_VF_VLAN_INFO = 1,
	__IFLA_VF_VLAN_INFO_MAX = 2,
};

enum {
	IFLA_VXLAN_UNSPEC = 0,
	IFLA_VXLAN_ID = 1,
	IFLA_VXLAN_GROUP = 2,
	IFLA_VXLAN_LINK = 3,
	IFLA_VXLAN_LOCAL = 4,
	IFLA_VXLAN_TTL = 5,
	IFLA_VXLAN_TOS = 6,
	IFLA_VXLAN_LEARNING = 7,
	IFLA_VXLAN_AGEING = 8,
	IFLA_VXLAN_LIMIT = 9,
	IFLA_VXLAN_PORT_RANGE = 10,
	IFLA_VXLAN_PROXY = 11,
	IFLA_VXLAN_RSC = 12,
	IFLA_VXLAN_L2MISS = 13,
	IFLA_VXLAN_L3MISS = 14,
	IFLA_VXLAN_PORT = 15,
	IFLA_VXLAN_GROUP6 = 16,
	IFLA_VXLAN_LOCAL6 = 17,
	IFLA_VXLAN_UDP_CSUM = 18,
	IFLA_VXLAN_UDP_ZERO_CSUM6_TX = 19,
	IFLA_VXLAN_UDP_ZERO_CSUM6_RX = 20,
	IFLA_VXLAN_REMCSUM_TX = 21,
	IFLA_VXLAN_REMCSUM_RX = 22,
	IFLA_VXLAN_GBP = 23,
	IFLA_VXLAN_REMCSUM_NOPARTIAL = 24,
	IFLA_VXLAN_COLLECT_METADATA = 25,
	IFLA_VXLAN_LABEL = 26,
	IFLA_VXLAN_GPE = 27,
	IFLA_VXLAN_TTL_INHERIT = 28,
	IFLA_VXLAN_DF = 29,
	IFLA_VXLAN_VNIFILTER = 30,
	IFLA_VXLAN_LOCALBYPASS = 31,
	IFLA_VXLAN_LABEL_POLICY = 32,
	IFLA_VXLAN_RESERVED_BITS = 33,
	__IFLA_VXLAN_MAX = 34,
};

enum {
	IFLA_XDP_UNSPEC = 0,
	IFLA_XDP_FD = 1,
	IFLA_XDP_ATTACHED = 2,
	IFLA_XDP_FLAGS = 3,
	IFLA_XDP_PROG_ID = 4,
	IFLA_XDP_DRV_PROG_ID = 5,
	IFLA_XDP_SKB_PROG_ID = 6,
	IFLA_XDP_HW_PROG_ID = 7,
	IFLA_XDP_EXPECTED_FD = 8,
	__IFLA_XDP_MAX = 9,
};

enum {
	IF_ACT_NONE = -1,
	IF_ACT_FILTER = 0,
	IF_ACT_START = 1,
	IF_ACT_STOP = 2,
	IF_SRC_FILE = 3,
	IF_SRC_KERNEL = 4,
	IF_SRC_FILEADDR = 5,
	IF_SRC_KERNELADDR = 6,
};

enum {
	IF_LINK_MODE_DEFAULT = 0,
	IF_LINK_MODE_DORMANT = 1,
	IF_LINK_MODE_TESTING = 2,
};

enum {
	IF_OPER_UNKNOWN = 0,
	IF_OPER_NOTPRESENT = 1,
	IF_OPER_DOWN = 2,
	IF_OPER_LOWERLAYERDOWN = 3,
	IF_OPER_TESTING = 4,
	IF_OPER_DORMANT = 5,
	IF_OPER_UP = 6,
};

enum {
	IF_STATE_ACTION = 0,
	IF_STATE_SOURCE = 1,
	IF_STATE_END = 2,
};

enum {
	INBAND_CISCO_SGMII = 0,
	INBAND_BASEX = 1,
};

enum {
	INET6_IFADDR_STATE_PREDAD = 0,
	INET6_IFADDR_STATE_DAD = 1,
	INET6_IFADDR_STATE_POSTDAD = 2,
	INET6_IFADDR_STATE_ERRDAD = 3,
	INET6_IFADDR_STATE_DEAD = 4,
};

enum {
	INET_DIAG_BC_NOP = 0,
	INET_DIAG_BC_JMP = 1,
	INET_DIAG_BC_S_GE = 2,
	INET_DIAG_BC_S_LE = 3,
	INET_DIAG_BC_D_GE = 4,
	INET_DIAG_BC_D_LE = 5,
	INET_DIAG_BC_AUTO = 6,
	INET_DIAG_BC_S_COND = 7,
	INET_DIAG_BC_D_COND = 8,
	INET_DIAG_BC_DEV_COND = 9,
	INET_DIAG_BC_MARK_COND = 10,
	INET_DIAG_BC_S_EQ = 11,
	INET_DIAG_BC_D_EQ = 12,
	INET_DIAG_BC_CGROUP_COND = 13,
};

enum {
	INET_DIAG_NONE = 0,
	INET_DIAG_MEMINFO = 1,
	INET_DIAG_INFO = 2,
	INET_DIAG_VEGASINFO = 3,
	INET_DIAG_CONG = 4,
	INET_DIAG_TOS = 5,
	INET_DIAG_TCLASS = 6,
	INET_DIAG_SKMEMINFO = 7,
	INET_DIAG_SHUTDOWN = 8,
	INET_DIAG_DCTCPINFO = 9,
	INET_DIAG_PROTOCOL = 10,
	INET_DIAG_SKV6ONLY = 11,
	INET_DIAG_LOCALS = 12,
	INET_DIAG_PEERS = 13,
	INET_DIAG_PAD = 14,
	INET_DIAG_MARK = 15,
	INET_DIAG_BBRINFO = 16,
	INET_DIAG_CLASS_ID = 17,
	INET_DIAG_MD5SIG = 18,
	INET_DIAG_ULP_INFO = 19,
	INET_DIAG_SK_BPF_STORAGES = 20,
	INET_DIAG_CGROUP_ID = 21,
	INET_DIAG_SOCKOPT = 22,
	__INET_DIAG_MAX = 23,
};

enum {
	INET_DIAG_REQ_NONE = 0,
	INET_DIAG_REQ_BYTECODE = 1,
	INET_DIAG_REQ_SK_BPF_STORAGES = 2,
	INET_DIAG_REQ_PROTOCOL = 3,
	__INET_DIAG_REQ_MAX = 4,
};

enum {
	INET_ECN_NOT_ECT = 0,
	INET_ECN_ECT_1 = 1,
	INET_ECN_ECT_0 = 2,
	INET_ECN_CE = 3,
	INET_ECN_MASK = 3,
};

enum {
	INET_FLAGS_PKTINFO = 0,
	INET_FLAGS_TTL = 1,
	INET_FLAGS_TOS = 2,
	INET_FLAGS_RECVOPTS = 3,
	INET_FLAGS_RETOPTS = 4,
	INET_FLAGS_PASSSEC = 5,
	INET_FLAGS_ORIGDSTADDR = 6,
	INET_FLAGS_CHECKSUM = 7,
	INET_FLAGS_RECVFRAGSIZE = 8,
	INET_FLAGS_RECVERR = 9,
	INET_FLAGS_RECVERR_RFC4884 = 10,
	INET_FLAGS_FREEBIND = 11,
	INET_FLAGS_HDRINCL = 12,
	INET_FLAGS_MC_LOOP = 13,
	INET_FLAGS_MC_ALL = 14,
	INET_FLAGS_TRANSPARENT = 15,
	INET_FLAGS_IS_ICSK = 16,
	INET_FLAGS_NODEFRAG = 17,
	INET_FLAGS_BIND_ADDRESS_NO_PORT = 18,
	INET_FLAGS_DEFER_CONNECT = 19,
	INET_FLAGS_MC6_LOOP = 20,
	INET_FLAGS_RECVERR6_RFC4884 = 21,
	INET_FLAGS_MC6_ALL = 22,
	INET_FLAGS_AUTOFLOWLABEL_SET = 23,
	INET_FLAGS_AUTOFLOWLABEL = 24,
	INET_FLAGS_DONTFRAG = 25,
	INET_FLAGS_RECVERR6 = 26,
	INET_FLAGS_REPFLOW = 27,
	INET_FLAGS_RTALERT_ISOLATE = 28,
	INET_FLAGS_SNDFLOW = 29,
	INET_FLAGS_RTALERT = 30,
};

enum {
	INET_FRAG_FIRST_IN = 1,
	INET_FRAG_LAST_IN = 2,
	INET_FRAG_COMPLETE = 4,
	INET_FRAG_HASH_DEAD = 8,
	INET_FRAG_DROP = 16,
};

enum {
	INET_ULP_INFO_UNSPEC = 0,
	INET_ULP_INFO_NAME = 1,
	INET_ULP_INFO_TLS = 2,
	INET_ULP_INFO_MPTCP = 3,
	__INET_ULP_INFO_MAX = 4,
};

enum {
	INPUT_PIN_ATTR_UNUSED = 0,
	INPUT_PIN_ATTR_INT = 1,
	INPUT_PIN_ATTR_DOCK = 2,
	INPUT_PIN_ATTR_NORMAL = 3,
	INPUT_PIN_ATTR_REAR = 4,
	INPUT_PIN_ATTR_FRONT = 5,
	INPUT_PIN_ATTR_LAST = 5,
};

enum {
	INSN_F_FRAMENO_MASK = 7,
	INSN_F_SPI_MASK = 63,
	INSN_F_SPI_SHIFT = 3,
	INSN_F_STACK_ACCESS = 512,
};

enum {
	INVERT = 1,
	PROCESS_AND = 2,
	PROCESS_OR = 4,
};

enum {
	IOAM6_ATTR_UNSPEC = 0,
	IOAM6_ATTR_NS_ID = 1,
	IOAM6_ATTR_NS_DATA = 2,
	IOAM6_ATTR_NS_DATA_WIDE = 3,
	IOAM6_ATTR_SC_ID = 4,
	IOAM6_ATTR_SC_DATA = 5,
	IOAM6_ATTR_SC_NONE = 6,
	IOAM6_ATTR_PAD = 7,
	__IOAM6_ATTR_MAX = 8,
};

enum {
	IOAM6_CMD_UNSPEC = 0,
	IOAM6_CMD_ADD_NAMESPACE = 1,
	IOAM6_CMD_DEL_NAMESPACE = 2,
	IOAM6_CMD_DUMP_NAMESPACES = 3,
	IOAM6_CMD_ADD_SCHEMA = 4,
	IOAM6_CMD_DEL_SCHEMA = 5,
	IOAM6_CMD_DUMP_SCHEMAS = 6,
	IOAM6_CMD_NS_SET_SCHEMA = 7,
	__IOAM6_CMD_MAX = 8,
};

enum {
	IOBL_BUF_RING = 1,
	IOBL_INC = 2,
};

enum {
	IOCB_CMD_PREAD = 0,
	IOCB_CMD_PWRITE = 1,
	IOCB_CMD_FSYNC = 2,
	IOCB_CMD_FDSYNC = 3,
	IOCB_CMD_POLL = 5,
	IOCB_CMD_NOOP = 6,
	IOCB_CMD_PREADV = 7,
	IOCB_CMD_PWRITEV = 8,
};

enum {
	IOMMU_SET_DOMAIN_MUST_SUCCEED = 1,
};

enum {
	IOPRIO_CLASS_NONE = 0,
	IOPRIO_CLASS_RT = 1,
	IOPRIO_CLASS_BE = 2,
	IOPRIO_CLASS_IDLE = 3,
	IOPRIO_CLASS_INVALID = 7,
};

enum {
	IOPRIO_HINT_NONE = 0,
	IOPRIO_HINT_DEV_DURATION_LIMIT_1 = 1,
	IOPRIO_HINT_DEV_DURATION_LIMIT_2 = 2,
	IOPRIO_HINT_DEV_DURATION_LIMIT_3 = 3,
	IOPRIO_HINT_DEV_DURATION_LIMIT_4 = 4,
	IOPRIO_HINT_DEV_DURATION_LIMIT_5 = 5,
	IOPRIO_HINT_DEV_DURATION_LIMIT_6 = 6,
	IOPRIO_HINT_DEV_DURATION_LIMIT_7 = 7,
};

enum {
	IOPRIO_WHO_PROCESS = 1,
	IOPRIO_WHO_PGRP = 2,
	IOPRIO_WHO_USER = 3,
};

enum {
	IORES_DESC_NONE = 0,
	IORES_DESC_CRASH_KERNEL = 1,
	IORES_DESC_ACPI_TABLES = 2,
	IORES_DESC_ACPI_NV_STORAGE = 3,
	IORES_DESC_PERSISTENT_MEMORY = 4,
	IORES_DESC_PERSISTENT_MEMORY_LEGACY = 5,
	IORES_DESC_DEVICE_PRIVATE_MEMORY = 6,
	IORES_DESC_RESERVED = 7,
	IORES_DESC_SOFT_RESERVED = 8,
	IORES_DESC_CXL = 9,
};

enum {
	IORING_MEM_REGION_REG_WAIT_ARG = 1,
};

enum {
	IORING_MEM_REGION_TYPE_USER = 1,
};

enum {
	IORING_REGISTER_SRC_REGISTERED = 1,
	IORING_REGISTER_DST_REPLACE = 2,
};

enum {
	IORING_REG_WAIT_TS = 1,
};

enum {
	IORING_RSRC_FILE = 0,
	IORING_RSRC_BUFFER = 1,
};

enum {
	IOU_F_TWQ_LAZY_WAKE = 1,
};

enum {
	IOU_OK = 0,
	IOU_ISSUE_SKIP_COMPLETE = -529,
	IOU_REQUEUE = -3072,
	IOU_STOP_MULTISHOT = -125,
};

enum {
	IOU_POLL_DONE = 0,
	IOU_POLL_NO_ACTION = 1,
	IOU_POLL_REMOVE_POLL_USE_RES = 2,
	IOU_POLL_REISSUE = 3,
	IOU_POLL_REQUEUE = 4,
};

enum {
	IO_ACCT_STALLED_BIT = 0,
};

enum {
	IO_APOLL_OK = 0,
	IO_APOLL_ABORTED = 1,
	IO_APOLL_READY = 2,
};

enum {
	IO_CHECK_CQ_OVERFLOW_BIT = 0,
	IO_CHECK_CQ_DROPPED_BIT = 1,
};

enum {
	IO_EVENTFD_OP_SIGNAL_BIT = 0,
};

enum {
	IO_REGION_F_VMAP = 1,
	IO_REGION_F_USER_PROVIDED = 2,
	IO_REGION_F_SINGLE_REF = 4,
};

enum {
	IO_SQ_THREAD_SHOULD_STOP = 0,
	IO_SQ_THREAD_SHOULD_PARK = 1,
};

enum {
	IO_TREE_FS_PINNED_EXTENTS = 0,
	IO_TREE_FS_EXCLUDED_EXTENTS = 1,
	IO_TREE_BTREE_INODE_IO = 2,
	IO_TREE_INODE_IO = 3,
	IO_TREE_RELOC_BLOCKS = 4,
	IO_TREE_TRANS_DIRTY_PAGES = 5,
	IO_TREE_ROOT_DIRTY_LOG_PAGES = 6,
	IO_TREE_INODE_FILE_EXTENT = 7,
	IO_TREE_LOG_CSUM_RANGE = 8,
	IO_TREE_SELFTEST = 9,
	IO_TREE_DEVICE_ALLOC_STATE = 10,
};

enum {
	IO_WORKER_F_UP = 0,
	IO_WORKER_F_RUNNING = 1,
	IO_WORKER_F_FREE = 2,
	IO_WORKER_F_BOUND = 3,
};

enum {
	IO_WQ_ACCT_BOUND = 0,
	IO_WQ_ACCT_UNBOUND = 1,
	IO_WQ_ACCT_NR = 2,
};

enum {
	IO_WQ_BIT_EXIT = 0,
};

enum {
	IO_WQ_WORK_CANCEL = 1,
	IO_WQ_WORK_HASHED = 2,
	IO_WQ_WORK_UNBOUND = 4,
	IO_WQ_WORK_CONCURRENT = 16,
	IO_WQ_HASH_SHIFT = 24,
};

enum {
	IP6MRA_CREPORT_UNSPEC = 0,
	IP6MRA_CREPORT_MSGTYPE = 1,
	IP6MRA_CREPORT_MIF_ID = 2,
	IP6MRA_CREPORT_SRC_ADDR = 3,
	IP6MRA_CREPORT_DST_ADDR = 4,
	IP6MRA_CREPORT_PKT = 5,
	__IP6MRA_CREPORT_MAX = 6,
};

enum {
	IP6_FH_F_FRAG = 1,
	IP6_FH_F_AUTH = 2,
	IP6_FH_F_SKIP_RH = 4,
};

enum {
	IPMRA_CREPORT_UNSPEC = 0,
	IPMRA_CREPORT_MSGTYPE = 1,
	IPMRA_CREPORT_VIF_ID = 2,
	IPMRA_CREPORT_SRC_ADDR = 3,
	IPMRA_CREPORT_DST_ADDR = 4,
	IPMRA_CREPORT_PKT = 5,
	IPMRA_CREPORT_TABLE = 6,
	__IPMRA_CREPORT_MAX = 7,
};

enum {
	IPMRA_TABLE_UNSPEC = 0,
	IPMRA_TABLE_ID = 1,
	IPMRA_TABLE_CACHE_RES_QUEUE_LEN = 2,
	IPMRA_TABLE_MROUTE_REG_VIF_NUM = 3,
	IPMRA_TABLE_MROUTE_DO_ASSERT = 4,
	IPMRA_TABLE_MROUTE_DO_PIM = 5,
	IPMRA_TABLE_VIFS = 6,
	IPMRA_TABLE_MROUTE_DO_WRVIFWHOLE = 7,
	__IPMRA_TABLE_MAX = 8,
};

enum {
	IPMRA_VIFA_UNSPEC = 0,
	IPMRA_VIFA_IFINDEX = 1,
	IPMRA_VIFA_VIF_ID = 2,
	IPMRA_VIFA_FLAGS = 3,
	IPMRA_VIFA_BYTES_IN = 4,
	IPMRA_VIFA_BYTES_OUT = 5,
	IPMRA_VIFA_PACKETS_IN = 6,
	IPMRA_VIFA_PACKETS_OUT = 7,
	IPMRA_VIFA_LOCAL_ADDR = 8,
	IPMRA_VIFA_REMOTE_ADDR = 9,
	IPMRA_VIFA_PAD = 10,
	__IPMRA_VIFA_MAX = 11,
};

enum {
	IPMRA_VIF_UNSPEC = 0,
	IPMRA_VIF = 1,
	__IPMRA_VIF_MAX = 2,
};

enum {
	IPPROTO_IP = 0,
	IPPROTO_ICMP = 1,
	IPPROTO_IGMP = 2,
	IPPROTO_IPIP = 4,
	IPPROTO_TCP = 6,
	IPPROTO_EGP = 8,
	IPPROTO_PUP = 12,
	IPPROTO_UDP = 17,
	IPPROTO_IDP = 22,
	IPPROTO_TP = 29,
	IPPROTO_DCCP = 33,
	IPPROTO_IPV6 = 41,
	IPPROTO_RSVP = 46,
	IPPROTO_GRE = 47,
	IPPROTO_ESP = 50,
	IPPROTO_AH = 51,
	IPPROTO_MTP = 92,
	IPPROTO_BEETPH = 94,
	IPPROTO_ENCAP = 98,
	IPPROTO_PIM = 103,
	IPPROTO_COMP = 108,
	IPPROTO_L2TP = 115,
	IPPROTO_SCTP = 132,
	IPPROTO_UDPLITE = 136,
	IPPROTO_MPLS = 137,
	IPPROTO_ETHERNET = 143,
	IPPROTO_AGGFRAG = 144,
	IPPROTO_RAW = 255,
	IPPROTO_SMC = 256,
	IPPROTO_MPTCP = 262,
	IPPROTO_MAX = 263,
};

enum {
	IPSEC_DIR_ANY = 0,
	IPSEC_DIR_INBOUND = 1,
	IPSEC_DIR_OUTBOUND = 2,
	IPSEC_DIR_FWD = 3,
	IPSEC_DIR_MAX = 4,
	IPSEC_DIR_INVALID = 5,
};

enum {
	IPSEC_LEVEL_DEFAULT = 0,
	IPSEC_LEVEL_USE = 1,
	IPSEC_LEVEL_REQUIRE = 2,
	IPSEC_LEVEL_UNIQUE = 3,
};

enum {
	IPSEC_MODE_ANY = 0,
	IPSEC_MODE_TRANSPORT = 1,
	IPSEC_MODE_TUNNEL = 2,
	IPSEC_MODE_BEET = 3,
	IPSEC_MODE_IPTFS = 4,
};

enum {
	IPSEC_POLICY_DISCARD = 0,
	IPSEC_POLICY_NONE = 1,
	IPSEC_POLICY_IPSEC = 2,
	IPSEC_POLICY_ENTRUST = 3,
	IPSEC_POLICY_BYPASS = 4,
};

enum {
	IPSTATS_MIB_NUM = 0,
	IPSTATS_MIB_INPKTS = 1,
	IPSTATS_MIB_INOCTETS = 2,
	IPSTATS_MIB_INDELIVERS = 3,
	IPSTATS_MIB_OUTFORWDATAGRAMS = 4,
	IPSTATS_MIB_OUTREQUESTS = 5,
	IPSTATS_MIB_OUTOCTETS = 6,
	IPSTATS_MIB_INHDRERRORS = 7,
	IPSTATS_MIB_INTOOBIGERRORS = 8,
	IPSTATS_MIB_INNOROUTES = 9,
	IPSTATS_MIB_INADDRERRORS = 10,
	IPSTATS_MIB_INUNKNOWNPROTOS = 11,
	IPSTATS_MIB_INTRUNCATEDPKTS = 12,
	IPSTATS_MIB_INDISCARDS = 13,
	IPSTATS_MIB_OUTDISCARDS = 14,
	IPSTATS_MIB_OUTNOROUTES = 15,
	IPSTATS_MIB_REASMTIMEOUT = 16,
	IPSTATS_MIB_REASMREQDS = 17,
	IPSTATS_MIB_REASMOKS = 18,
	IPSTATS_MIB_REASMFAILS = 19,
	IPSTATS_MIB_FRAGOKS = 20,
	IPSTATS_MIB_FRAGFAILS = 21,
	IPSTATS_MIB_FRAGCREATES = 22,
	IPSTATS_MIB_INMCASTPKTS = 23,
	IPSTATS_MIB_OUTMCASTPKTS = 24,
	IPSTATS_MIB_INBCASTPKTS = 25,
	IPSTATS_MIB_OUTBCASTPKTS = 26,
	IPSTATS_MIB_INMCASTOCTETS = 27,
	IPSTATS_MIB_OUTMCASTOCTETS = 28,
	IPSTATS_MIB_INBCASTOCTETS = 29,
	IPSTATS_MIB_OUTBCASTOCTETS = 30,
	IPSTATS_MIB_CSUMERRORS = 31,
	IPSTATS_MIB_NOECTPKTS = 32,
	IPSTATS_MIB_ECT1PKTS = 33,
	IPSTATS_MIB_ECT0PKTS = 34,
	IPSTATS_MIB_CEPKTS = 35,
	IPSTATS_MIB_REASM_OVERLAPS = 36,
	IPSTATS_MIB_OUTPKTS = 37,
	__IPSTATS_MIB_MAX = 38,
};

enum {
	IPV4_DEVCONF_FORWARDING = 1,
	IPV4_DEVCONF_MC_FORWARDING = 2,
	IPV4_DEVCONF_PROXY_ARP = 3,
	IPV4_DEVCONF_ACCEPT_REDIRECTS = 4,
	IPV4_DEVCONF_SECURE_REDIRECTS = 5,
	IPV4_DEVCONF_SEND_REDIRECTS = 6,
	IPV4_DEVCONF_SHARED_MEDIA = 7,
	IPV4_DEVCONF_RP_FILTER = 8,
	IPV4_DEVCONF_ACCEPT_SOURCE_ROUTE = 9,
	IPV4_DEVCONF_BOOTP_RELAY = 10,
	IPV4_DEVCONF_LOG_MARTIANS = 11,
	IPV4_DEVCONF_TAG = 12,
	IPV4_DEVCONF_ARPFILTER = 13,
	IPV4_DEVCONF_MEDIUM_ID = 14,
	IPV4_DEVCONF_NOXFRM = 15,
	IPV4_DEVCONF_NOPOLICY = 16,
	IPV4_DEVCONF_FORCE_IGMP_VERSION = 17,
	IPV4_DEVCONF_ARP_ANNOUNCE = 18,
	IPV4_DEVCONF_ARP_IGNORE = 19,
	IPV4_DEVCONF_PROMOTE_SECONDARIES = 20,
	IPV4_DEVCONF_ARP_ACCEPT = 21,
	IPV4_DEVCONF_ARP_NOTIFY = 22,
	IPV4_DEVCONF_ACCEPT_LOCAL = 23,
	IPV4_DEVCONF_SRC_VMARK = 24,
	IPV4_DEVCONF_PROXY_ARP_PVLAN = 25,
	IPV4_DEVCONF_ROUTE_LOCALNET = 26,
	IPV4_DEVCONF_IGMPV2_UNSOLICITED_REPORT_INTERVAL = 27,
	IPV4_DEVCONF_IGMPV3_UNSOLICITED_REPORT_INTERVAL = 28,
	IPV4_DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 29,
	IPV4_DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 30,
	IPV4_DEVCONF_DROP_GRATUITOUS_ARP = 31,
	IPV4_DEVCONF_BC_FORWARDING = 32,
	IPV4_DEVCONF_ARP_EVICT_NOCARRIER = 33,
	__IPV4_DEVCONF_MAX = 34,
};

enum {
	IPV6_SADDR_RULE_INIT = 0,
	IPV6_SADDR_RULE_LOCAL = 1,
	IPV6_SADDR_RULE_SCOPE = 2,
	IPV6_SADDR_RULE_PREFERRED = 3,
	IPV6_SADDR_RULE_OIF = 4,
	IPV6_SADDR_RULE_LABEL = 5,
	IPV6_SADDR_RULE_PRIVACY = 6,
	IPV6_SADDR_RULE_ORCHID = 7,
	IPV6_SADDR_RULE_PREFIX = 8,
	IPV6_SADDR_RULE_MAX = 9,
};

enum {
	IP_TUNNEL_CSUM_BIT = 0,
	IP_TUNNEL_ROUTING_BIT = 1,
	IP_TUNNEL_KEY_BIT = 2,
	IP_TUNNEL_SEQ_BIT = 3,
	IP_TUNNEL_STRICT_BIT = 4,
	IP_TUNNEL_REC_BIT = 5,
	IP_TUNNEL_VERSION_BIT = 6,
	IP_TUNNEL_NO_KEY_BIT = 7,
	IP_TUNNEL_DONT_FRAGMENT_BIT = 8,
	IP_TUNNEL_OAM_BIT = 9,
	IP_TUNNEL_CRIT_OPT_BIT = 10,
	IP_TUNNEL_GENEVE_OPT_BIT = 11,
	IP_TUNNEL_VXLAN_OPT_BIT = 12,
	IP_TUNNEL_NOCACHE_BIT = 13,
	IP_TUNNEL_ERSPAN_OPT_BIT = 14,
	IP_TUNNEL_GTP_OPT_BIT = 15,
	IP_TUNNEL_VTI_BIT = 16,
	IP_TUNNEL_SIT_ISATAP_BIT = 16,
	IP_TUNNEL_PFCP_OPT_BIT = 17,
	__IP_TUNNEL_FLAG_NUM = 18,
};

enum {
	IRQCHIP_FWNODE_REAL = 0,
	IRQCHIP_FWNODE_NAMED = 1,
	IRQCHIP_FWNODE_NAMED_ID = 2,
};

enum {
	IRQCHIP_SET_TYPE_MASKED = 1,
	IRQCHIP_EOI_IF_HANDLED = 2,
	IRQCHIP_MASK_ON_SUSPEND = 4,
	IRQCHIP_ONOFFLINE_ENABLED = 8,
	IRQCHIP_SKIP_SET_WAKE = 16,
	IRQCHIP_ONESHOT_SAFE = 32,
	IRQCHIP_EOI_THREADED = 64,
	IRQCHIP_SUPPORTS_LEVEL_MSI = 128,
	IRQCHIP_SUPPORTS_NMI = 256,
	IRQCHIP_ENABLE_WAKEUP_ON_SUSPEND = 512,
	IRQCHIP_AFFINITY_PRE_STARTUP = 1024,
	IRQCHIP_IMMUTABLE = 2048,
	IRQCHIP_MOVE_DEFERRED = 4096,
};

enum {
	IRQC_IS_HARDIRQ = 0,
	IRQC_IS_NESTED = 1,
};

enum {
	IRQD_TRIGGER_MASK = 15,
	IRQD_SETAFFINITY_PENDING = 256,
	IRQD_ACTIVATED = 512,
	IRQD_NO_BALANCING = 1024,
	IRQD_PER_CPU = 2048,
	IRQD_AFFINITY_SET = 4096,
	IRQD_LEVEL = 8192,
	IRQD_WAKEUP_STATE = 16384,
	IRQD_IRQ_DISABLED = 65536,
	IRQD_IRQ_MASKED = 131072,
	IRQD_IRQ_INPROGRESS = 262144,
	IRQD_WAKEUP_ARMED = 524288,
	IRQD_FORWARDED_TO_VCPU = 1048576,
	IRQD_AFFINITY_MANAGED = 2097152,
	IRQD_IRQ_STARTED = 4194304,
	IRQD_MANAGED_SHUTDOWN = 8388608,
	IRQD_SINGLE_TARGET = 16777216,
	IRQD_DEFAULT_TRIGGER_SET = 33554432,
	IRQD_CAN_RESERVE = 67108864,
	IRQD_HANDLE_ENFORCE_IRQCTX = 134217728,
	IRQD_AFFINITY_ON_ACTIVATE = 268435456,
	IRQD_IRQ_ENABLED_ON_SUSPEND = 536870912,
	IRQD_RESEND_WHEN_IN_PROGRESS = 1073741824,
};

enum {
	IRQS_AUTODETECT = 1,
	IRQS_SPURIOUS_DISABLED = 2,
	IRQS_POLL_INPROGRESS = 8,
	IRQS_ONESHOT = 32,
	IRQS_REPLAY = 64,
	IRQS_WAITING = 128,
	IRQS_PENDING = 512,
	IRQS_SUSPENDED = 2048,
	IRQS_TIMINGS = 4096,
	IRQS_NMI = 8192,
	IRQS_SYSFS = 16384,
};

enum {
	IRQTF_RUNTHREAD = 0,
	IRQTF_WARNED = 1,
	IRQTF_AFFINITY = 2,
	IRQTF_FORCED_THREAD = 3,
	IRQTF_READY = 4,
};

enum {
	IRQ_DOMAIN_FLAG_HIERARCHY = 1,
	IRQ_DOMAIN_NAME_ALLOCATED = 2,
	IRQ_DOMAIN_FLAG_IPI_PER_CPU = 4,
	IRQ_DOMAIN_FLAG_IPI_SINGLE = 8,
	IRQ_DOMAIN_FLAG_MSI = 16,
	IRQ_DOMAIN_FLAG_ISOLATED_MSI = 32,
	IRQ_DOMAIN_FLAG_NO_MAP = 64,
	IRQ_DOMAIN_FLAG_MSI_PARENT = 256,
	IRQ_DOMAIN_FLAG_MSI_DEVICE = 512,
	IRQ_DOMAIN_FLAG_DESTROY_GC = 1024,
	IRQ_DOMAIN_FLAG_NONCORE = 65536,
};

enum {
	IRQ_POLL_F_SCHED = 0,
	IRQ_POLL_F_DISABLE = 1,
};

enum {
	IRQ_SET_MASK_OK = 0,
	IRQ_SET_MASK_OK_NOCOPY = 1,
	IRQ_SET_MASK_OK_DONE = 2,
};

enum {
	IRQ_STARTUP_NORMAL = 0,
	IRQ_STARTUP_MANAGED = 1,
	IRQ_STARTUP_ABORT = 2,
};

enum {
	IRQ_TYPE_NONE = 0,
	IRQ_TYPE_EDGE_RISING = 1,
	IRQ_TYPE_EDGE_FALLING = 2,
	IRQ_TYPE_EDGE_BOTH = 3,
	IRQ_TYPE_LEVEL_HIGH = 4,
	IRQ_TYPE_LEVEL_LOW = 8,
	IRQ_TYPE_LEVEL_MASK = 12,
	IRQ_TYPE_SENSE_MASK = 15,
	IRQ_TYPE_DEFAULT = 15,
	IRQ_TYPE_PROBE = 16,
	IRQ_LEVEL = 256,
	IRQ_PER_CPU = 512,
	IRQ_NOPROBE = 1024,
	IRQ_NOREQUEST = 2048,
	IRQ_NOAUTOEN = 4096,
	IRQ_NO_BALANCING = 8192,
	IRQ_NESTED_THREAD = 32768,
	IRQ_NOTHREAD = 65536,
	IRQ_PER_CPU_DEVID = 131072,
	IRQ_IS_POLLED = 262144,
	IRQ_DISABLE_UNLAZY = 524288,
	IRQ_HIDDEN = 1048576,
	IRQ_NO_DEBUG = 2097152,
};

enum {
	I_DATA_SEM_NORMAL = 0,
	I_DATA_SEM_OTHER = 1,
	I_DATA_SEM_QUOTA = 2,
	I_DATA_SEM_EA = 3,
};

enum {
	I_LCOEF_RBPS = 0,
	I_LCOEF_RSEQIOPS = 1,
	I_LCOEF_RRANDIOPS = 2,
	I_LCOEF_WBPS = 3,
	I_LCOEF_WSEQIOPS = 4,
	I_LCOEF_WRANDIOPS = 5,
	NR_I_LCOEFS = 6,
};

enum {
	KBUF_MODE_EXPAND = 1,
	KBUF_MODE_FREE = 2,
};

enum {
	KERNEL_PARAM_FL_UNSAFE = 1,
	KERNEL_PARAM_FL_HWPARAM = 2,
};

enum {
	KERNEL_PARAM_OPS_FL_NOARG = 1,
};

enum {
	KF_ARG_DYNPTR_ID = 0,
	KF_ARG_LIST_HEAD_ID = 1,
	KF_ARG_LIST_NODE_ID = 2,
	KF_ARG_RB_ROOT_ID = 3,
	KF_ARG_RB_NODE_ID = 4,
	KF_ARG_WORKQUEUE_ID = 5,
};

enum {
	KTW_FREEZABLE = 1,
};

enum {
	KYBER_ASYNC_PERCENT = 75,
};

enum {
	KYBER_LATENCY_SHIFT = 2,
	KYBER_GOOD_BUCKETS = 4,
	KYBER_LATENCY_BUCKETS = 8,
};

enum {
	KYBER_READ = 0,
	KYBER_WRITE = 1,
	KYBER_DISCARD = 2,
	KYBER_OTHER = 3,
	KYBER_NUM_DOMAINS = 4,
};

enum {
	KYBER_TOTAL_LATENCY = 0,
	KYBER_IO_LATENCY = 1,
};

enum {
	LAST_NORM = 0,
	LAST_ROOT = 1,
	LAST_DOT = 2,
	LAST_DOTDOT = 3,
};

enum {
	LAT_OK = 1,
	LAT_UNKNOWN = 2,
	LAT_UNKNOWN_WRITES = 3,
	LAT_EXCEEDED = 4,
};

enum {
	LCOEF_RPAGE = 0,
	LCOEF_RSEQIO = 1,
	LCOEF_RRANDIO = 2,
	LCOEF_WPAGE = 3,
	LCOEF_WSEQIO = 4,
	LCOEF_WRANDIO = 5,
	NR_LCOEFS = 6,
};

enum {
	LIBATA_MAX_PRD = 128,
	LIBATA_DUMB_MAX_PRD = 64,
	ATA_DEF_QUEUE = 1,
	ATA_MAX_QUEUE = 32,
	ATA_TAG_INTERNAL = 32,
	ATA_SHORT_PAUSE = 16,
	ATAPI_MAX_DRAIN = 16384,
	ATA_ALL_DEVICES = 3,
	ATA_SHT_EMULATED = 1,
	ATA_SHT_THIS_ID = -1,
	ATA_TFLAG_LBA48 = 1,
	ATA_TFLAG_ISADDR = 2,
	ATA_TFLAG_DEVICE = 4,
	ATA_TFLAG_WRITE = 8,
	ATA_TFLAG_LBA = 16,
	ATA_TFLAG_FUA = 32,
	ATA_TFLAG_POLLING = 64,
	ATA_DFLAG_LBA = 1,
	ATA_DFLAG_LBA48 = 2,
	ATA_DFLAG_CDB_INTR = 4,
	ATA_DFLAG_NCQ = 8,
	ATA_DFLAG_FLUSH_EXT = 16,
	ATA_DFLAG_ACPI_PENDING = 32,
	ATA_DFLAG_ACPI_FAILED = 64,
	ATA_DFLAG_AN = 128,
	ATA_DFLAG_TRUSTED = 256,
	ATA_DFLAG_FUA = 512,
	ATA_DFLAG_DMADIR = 1024,
	ATA_DFLAG_NCQ_SEND_RECV = 2048,
	ATA_DFLAG_NCQ_PRIO = 4096,
	ATA_DFLAG_CDL = 8192,
	ATA_DFLAG_CFG_MASK = 16383,
	ATA_DFLAG_PIO = 16384,
	ATA_DFLAG_NCQ_OFF = 32768,
	ATA_DFLAG_SLEEPING = 65536,
	ATA_DFLAG_DUBIOUS_XFER = 131072,
	ATA_DFLAG_NO_UNLOAD = 262144,
	ATA_DFLAG_UNLOCK_HPA = 524288,
	ATA_DFLAG_INIT_MASK = 1048575,
	ATA_DFLAG_NCQ_PRIO_ENABLED = 1048576,
	ATA_DFLAG_CDL_ENABLED = 2097152,
	ATA_DFLAG_RESUMING = 4194304,
	ATA_DFLAG_DETACH = 16777216,
	ATA_DFLAG_DETACHED = 33554432,
	ATA_DFLAG_DA = 67108864,
	ATA_DFLAG_DEVSLP = 134217728,
	ATA_DFLAG_ACPI_DISABLED = 268435456,
	ATA_DFLAG_D_SENSE = 536870912,
	ATA_DFLAG_ZAC = 1073741824,
	ATA_DFLAG_FEATURES_MASK = 201341696,
	ATA_DEV_UNKNOWN = 0,
	ATA_DEV_ATA = 1,
	ATA_DEV_ATA_UNSUP = 2,
	ATA_DEV_ATAPI = 3,
	ATA_DEV_ATAPI_UNSUP = 4,
	ATA_DEV_PMP = 5,
	ATA_DEV_PMP_UNSUP = 6,
	ATA_DEV_SEMB = 7,
	ATA_DEV_SEMB_UNSUP = 8,
	ATA_DEV_ZAC = 9,
	ATA_DEV_ZAC_UNSUP = 10,
	ATA_DEV_NONE = 11,
	ATA_LFLAG_NO_HRST = 2,
	ATA_LFLAG_NO_SRST = 4,
	ATA_LFLAG_ASSUME_ATA = 8,
	ATA_LFLAG_ASSUME_SEMB = 16,
	ATA_LFLAG_ASSUME_CLASS = 24,
	ATA_LFLAG_NO_RETRY = 32,
	ATA_LFLAG_DISABLED = 64,
	ATA_LFLAG_SW_ACTIVITY = 128,
	ATA_LFLAG_NO_LPM = 256,
	ATA_LFLAG_RST_ONCE = 512,
	ATA_LFLAG_CHANGED = 1024,
	ATA_LFLAG_NO_DEBOUNCE_DELAY = 2048,
	ATA_FLAG_SLAVE_POSS = 1,
	ATA_FLAG_SATA = 2,
	ATA_FLAG_NO_LPM = 4,
	ATA_FLAG_NO_LOG_PAGE = 32,
	ATA_FLAG_NO_ATAPI = 64,
	ATA_FLAG_PIO_DMA = 128,
	ATA_FLAG_PIO_LBA48 = 256,
	ATA_FLAG_PIO_POLLING = 512,
	ATA_FLAG_NCQ = 1024,
	ATA_FLAG_NO_POWEROFF_SPINDOWN = 2048,
	ATA_FLAG_NO_HIBERNATE_SPINDOWN = 4096,
	ATA_FLAG_DEBUGMSG = 8192,
	ATA_FLAG_FPDMA_AA = 16384,
	ATA_FLAG_IGN_SIMPLEX = 32768,
	ATA_FLAG_NO_IORDY = 65536,
	ATA_FLAG_ACPI_SATA = 131072,
	ATA_FLAG_AN = 262144,
	ATA_FLAG_PMP = 524288,
	ATA_FLAG_FPDMA_AUX = 1048576,
	ATA_FLAG_EM = 2097152,
	ATA_FLAG_SW_ACTIVITY = 4194304,
	ATA_FLAG_NO_DIPM = 8388608,
	ATA_FLAG_SAS_HOST = 16777216,
	ATA_PFLAG_EH_PENDING = 1,
	ATA_PFLAG_EH_IN_PROGRESS = 2,
	ATA_PFLAG_FROZEN = 4,
	ATA_PFLAG_RECOVERED = 8,
	ATA_PFLAG_LOADING = 16,
	ATA_PFLAG_SCSI_HOTPLUG = 64,
	ATA_PFLAG_INITIALIZING = 128,
	ATA_PFLAG_RESETTING = 256,
	ATA_PFLAG_UNLOADING = 512,
	ATA_PFLAG_UNLOADED = 1024,
	ATA_PFLAG_RESUMING = 65536,
	ATA_PFLAG_SUSPENDED = 131072,
	ATA_PFLAG_PM_PENDING = 262144,
	ATA_PFLAG_INIT_GTM_VALID = 524288,
	ATA_PFLAG_PIO32 = 1048576,
	ATA_PFLAG_PIO32CHANGE = 2097152,
	ATA_PFLAG_EXTERNAL = 4194304,
	ATA_QCFLAG_ACTIVE = 1,
	ATA_QCFLAG_DMAMAP = 2,
	ATA_QCFLAG_RTF_FILLED = 4,
	ATA_QCFLAG_IO = 8,
	ATA_QCFLAG_RESULT_TF = 16,
	ATA_QCFLAG_CLEAR_EXCL = 32,
	ATA_QCFLAG_QUIET = 64,
	ATA_QCFLAG_RETRY = 128,
	ATA_QCFLAG_HAS_CDL = 256,
	ATA_QCFLAG_EH = 65536,
	ATA_QCFLAG_SENSE_VALID = 131072,
	ATA_QCFLAG_EH_SCHEDULED = 262144,
	ATA_QCFLAG_EH_SUCCESS_CMD = 524288,
	ATA_HOST_SIMPLEX = 1,
	ATA_HOST_STARTED = 2,
	ATA_HOST_PARALLEL_SCAN = 4,
	ATA_HOST_IGNORE_ATA = 8,
	ATA_HOST_NO_PART = 16,
	ATA_HOST_NO_SSC = 32,
	ATA_HOST_NO_DEVSLP = 64,
	ATA_TMOUT_INTERNAL_QUICK = 5000,
	ATA_TMOUT_MAX_PARK = 30000,
	ATA_TMOUT_FF_WAIT_LONG = 2000,
	ATA_TMOUT_FF_WAIT = 800,
	ATA_WAIT_AFTER_RESET = 150,
	ATA_TMOUT_PMP_SRST_WAIT = 10000,
	ATA_TMOUT_SPURIOUS_PHY = 10000,
	BUS_UNKNOWN = 0,
	BUS_DMA = 1,
	BUS_IDLE = 2,
	BUS_NOINTR = 3,
	BUS_NODATA = 4,
	BUS_TIMER = 5,
	BUS_PIO = 6,
	BUS_EDD = 7,
	BUS_IDENTIFY = 8,
	BUS_PACKET = 9,
	PORT_UNKNOWN = 0,
	PORT_ENABLED = 1,
	PORT_DISABLED = 2,
	ATA_NR_PIO_MODES = 7,
	ATA_NR_MWDMA_MODES = 5,
	ATA_NR_UDMA_MODES = 8,
	ATA_SHIFT_PIO = 0,
	ATA_SHIFT_MWDMA = 7,
	ATA_SHIFT_UDMA = 12,
	ATA_SHIFT_PRIO = 6,
	ATA_PRIO_HIGH = 2,
	ATA_DMA_PAD_SZ = 4,
	ATA_ERING_SIZE = 32,
	ATA_DEFER_LINK = 1,
	ATA_DEFER_PORT = 2,
	ATA_EH_DESC_LEN = 80,
	ATA_EH_REVALIDATE = 1,
	ATA_EH_SOFTRESET = 2,
	ATA_EH_HARDRESET = 4,
	ATA_EH_RESET = 6,
	ATA_EH_ENABLE_LINK = 8,
	ATA_EH_PARK = 32,
	ATA_EH_GET_SUCCESS_SENSE = 64,
	ATA_EH_SET_ACTIVE = 128,
	ATA_EH_PERDEV_MASK = 225,
	ATA_EH_ALL_ACTIONS = 15,
	ATA_EHI_HOTPLUGGED = 1,
	ATA_EHI_NO_AUTOPSY = 4,
	ATA_EHI_QUIET = 8,
	ATA_EHI_NO_RECOVERY = 16,
	ATA_EHI_DID_SOFTRESET = 65536,
	ATA_EHI_DID_HARDRESET = 131072,
	ATA_EHI_PRINTINFO = 262144,
	ATA_EHI_SETMODE = 524288,
	ATA_EHI_POST_SETMODE = 1048576,
	ATA_EHI_DID_PRINT_QUIRKS = 2097152,
	ATA_EHI_DID_RESET = 196608,
	ATA_EHI_TO_SLAVE_MASK = 12,
	ATA_EH_MAX_TRIES = 5,
	ATA_LINK_RESUME_TRIES = 5,
	ATA_EH_DEV_TRIES = 3,
	ATA_EH_PMP_TRIES = 5,
	ATA_EH_PMP_LINK_TRIES = 3,
	SATA_PMP_RW_TIMEOUT = 3000,
	ATA_EH_CMD_TIMEOUT_TABLE_SIZE = 8,
	ATA_QUIRK_DIAGNOSTIC = 1,
	ATA_QUIRK_NODMA = 2,
	ATA_QUIRK_NONCQ = 4,
	ATA_QUIRK_MAX_SEC_128 = 8,
	ATA_QUIRK_BROKEN_HPA = 16,
	ATA_QUIRK_DISABLE = 32,
	ATA_QUIRK_HPA_SIZE = 64,
	ATA_QUIRK_IVB = 128,
	ATA_QUIRK_STUCK_ERR = 256,
	ATA_QUIRK_BRIDGE_OK = 512,
	ATA_QUIRK_ATAPI_MOD16_DMA = 1024,
	ATA_QUIRK_FIRMWARE_WARN = 2048,
	ATA_QUIRK_1_5_GBPS = 4096,
	ATA_QUIRK_NOSETXFER = 8192,
	ATA_QUIRK_BROKEN_FPDMA_AA = 16384,
	ATA_QUIRK_DUMP_ID = 32768,
	ATA_QUIRK_MAX_SEC_LBA48 = 65536,
	ATA_QUIRK_ATAPI_DMADIR = 131072,
	ATA_QUIRK_NO_NCQ_TRIM = 262144,
	ATA_QUIRK_NOLPM = 524288,
	ATA_QUIRK_WD_BROKEN_LPM = 1048576,
	ATA_QUIRK_ZERO_AFTER_TRIM = 2097152,
	ATA_QUIRK_NO_DMA_LOG = 4194304,
	ATA_QUIRK_NOTRIM = 8388608,
	ATA_QUIRK_MAX_SEC_1024 = 16777216,
	ATA_QUIRK_MAX_TRIM_128M = 33554432,
	ATA_QUIRK_NO_NCQ_ON_ATI = 67108864,
	ATA_QUIRK_NO_LPM_ON_ATI = 134217728,
	ATA_QUIRK_NO_ID_DEV_LOG = 268435456,
	ATA_QUIRK_NO_LOG_DIR = 536870912,
	ATA_QUIRK_NO_FUA = 1073741824,
	ATA_DMA_MASK_ATA = 1,
	ATA_DMA_MASK_ATAPI = 2,
	ATA_DMA_MASK_CFA = 4,
	ATAPI_READ = 0,
	ATAPI_WRITE = 1,
	ATAPI_READ_CD = 2,
	ATAPI_PASS_THRU = 3,
	ATAPI_MISC = 4,
	ATA_TIMING_SETUP = 1,
	ATA_TIMING_ACT8B = 2,
	ATA_TIMING_REC8B = 4,
	ATA_TIMING_CYC8B = 8,
	ATA_TIMING_8BIT = 14,
	ATA_TIMING_ACTIVE = 16,
	ATA_TIMING_RECOVER = 32,
	ATA_TIMING_DMACK_HOLD = 64,
	ATA_TIMING_CYCLE = 128,
	ATA_TIMING_UDMA = 256,
	ATA_TIMING_ALL = 511,
	ATA_ACPI_FILTER_SETXFER = 1,
	ATA_ACPI_FILTER_LOCK = 2,
	ATA_ACPI_FILTER_DIPM = 4,
	ATA_ACPI_FILTER_FPDMA_OFFSET = 8,
	ATA_ACPI_FILTER_FPDMA_AA = 16,
	ATA_ACPI_FILTER_DEFAULT = 7,
};

enum {
	LINE_MODE_NONE = 0,
	LINE_MODE_CODEC = 1,
	LINE_MODE_MODEL = 2,
	LINE_MODE_PINCFG = 3,
	LINE_MODE_VERB = 4,
	LINE_MODE_HINT = 5,
	LINE_MODE_VENDOR_ID = 6,
	LINE_MODE_SUBSYSTEM_ID = 7,
	LINE_MODE_REVISION_ID = 8,
	LINE_MODE_CHIP_NAME = 9,
	NUM_LINE_MODES = 10,
};

enum {
	LINUX_MIB_NUM = 0,
	LINUX_MIB_SYNCOOKIESSENT = 1,
	LINUX_MIB_SYNCOOKIESRECV = 2,
	LINUX_MIB_SYNCOOKIESFAILED = 3,
	LINUX_MIB_EMBRYONICRSTS = 4,
	LINUX_MIB_PRUNECALLED = 5,
	LINUX_MIB_RCVPRUNED = 6,
	LINUX_MIB_OFOPRUNED = 7,
	LINUX_MIB_OUTOFWINDOWICMPS = 8,
	LINUX_MIB_LOCKDROPPEDICMPS = 9,
	LINUX_MIB_ARPFILTER = 10,
	LINUX_MIB_TIMEWAITED = 11,
	LINUX_MIB_TIMEWAITRECYCLED = 12,
	LINUX_MIB_TIMEWAITKILLED = 13,
	LINUX_MIB_PAWSACTIVEREJECTED = 14,
	LINUX_MIB_PAWSESTABREJECTED = 15,
	LINUX_MIB_PAWS_OLD_ACK = 16,
	LINUX_MIB_DELAYEDACKS = 17,
	LINUX_MIB_DELAYEDACKLOCKED = 18,
	LINUX_MIB_DELAYEDACKLOST = 19,
	LINUX_MIB_LISTENOVERFLOWS = 20,
	LINUX_MIB_LISTENDROPS = 21,
	LINUX_MIB_TCPHPHITS = 22,
	LINUX_MIB_TCPPUREACKS = 23,
	LINUX_MIB_TCPHPACKS = 24,
	LINUX_MIB_TCPRENORECOVERY = 25,
	LINUX_MIB_TCPSACKRECOVERY = 26,
	LINUX_MIB_TCPSACKRENEGING = 27,
	LINUX_MIB_TCPSACKREORDER = 28,
	LINUX_MIB_TCPRENOREORDER = 29,
	LINUX_MIB_TCPTSREORDER = 30,
	LINUX_MIB_TCPFULLUNDO = 31,
	LINUX_MIB_TCPPARTIALUNDO = 32,
	LINUX_MIB_TCPDSACKUNDO = 33,
	LINUX_MIB_TCPLOSSUNDO = 34,
	LINUX_MIB_TCPLOSTRETRANSMIT = 35,
	LINUX_MIB_TCPRENOFAILURES = 36,
	LINUX_MIB_TCPSACKFAILURES = 37,
	LINUX_MIB_TCPLOSSFAILURES = 38,
	LINUX_MIB_TCPFASTRETRANS = 39,
	LINUX_MIB_TCPSLOWSTARTRETRANS = 40,
	LINUX_MIB_TCPTIMEOUTS = 41,
	LINUX_MIB_TCPLOSSPROBES = 42,
	LINUX_MIB_TCPLOSSPROBERECOVERY = 43,
	LINUX_MIB_TCPRENORECOVERYFAIL = 44,
	LINUX_MIB_TCPSACKRECOVERYFAIL = 45,
	LINUX_MIB_TCPRCVCOLLAPSED = 46,
	LINUX_MIB_TCPDSACKOLDSENT = 47,
	LINUX_MIB_TCPDSACKOFOSENT = 48,
	LINUX_MIB_TCPDSACKRECV = 49,
	LINUX_MIB_TCPDSACKOFORECV = 50,
	LINUX_MIB_TCPABORTONDATA = 51,
	LINUX_MIB_TCPABORTONCLOSE = 52,
	LINUX_MIB_TCPABORTONMEMORY = 53,
	LINUX_MIB_TCPABORTONTIMEOUT = 54,
	LINUX_MIB_TCPABORTONLINGER = 55,
	LINUX_MIB_TCPABORTFAILED = 56,
	LINUX_MIB_TCPMEMORYPRESSURES = 57,
	LINUX_MIB_TCPMEMORYPRESSURESCHRONO = 58,
	LINUX_MIB_TCPSACKDISCARD = 59,
	LINUX_MIB_TCPDSACKIGNOREDOLD = 60,
	LINUX_MIB_TCPDSACKIGNOREDNOUNDO = 61,
	LINUX_MIB_TCPSPURIOUSRTOS = 62,
	LINUX_MIB_TCPMD5NOTFOUND = 63,
	LINUX_MIB_TCPMD5UNEXPECTED = 64,
	LINUX_MIB_TCPMD5FAILURE = 65,
	LINUX_MIB_SACKSHIFTED = 66,
	LINUX_MIB_SACKMERGED = 67,
	LINUX_MIB_SACKSHIFTFALLBACK = 68,
	LINUX_MIB_TCPBACKLOGDROP = 69,
	LINUX_MIB_PFMEMALLOCDROP = 70,
	LINUX_MIB_TCPMINTTLDROP = 71,
	LINUX_MIB_TCPDEFERACCEPTDROP = 72,
	LINUX_MIB_IPRPFILTER = 73,
	LINUX_MIB_TCPTIMEWAITOVERFLOW = 74,
	LINUX_MIB_TCPREQQFULLDOCOOKIES = 75,
	LINUX_MIB_TCPREQQFULLDROP = 76,
	LINUX_MIB_TCPRETRANSFAIL = 77,
	LINUX_MIB_TCPRCVCOALESCE = 78,
	LINUX_MIB_TCPBACKLOGCOALESCE = 79,
	LINUX_MIB_TCPOFOQUEUE = 80,
	LINUX_MIB_TCPOFODROP = 81,
	LINUX_MIB_TCPOFOMERGE = 82,
	LINUX_MIB_TCPCHALLENGEACK = 83,
	LINUX_MIB_TCPSYNCHALLENGE = 84,
	LINUX_MIB_TCPFASTOPENACTIVE = 85,
	LINUX_MIB_TCPFASTOPENACTIVEFAIL = 86,
	LINUX_MIB_TCPFASTOPENPASSIVE = 87,
	LINUX_MIB_TCPFASTOPENPASSIVEFAIL = 88,
	LINUX_MIB_TCPFASTOPENLISTENOVERFLOW = 89,
	LINUX_MIB_TCPFASTOPENCOOKIEREQD = 90,
	LINUX_MIB_TCPFASTOPENBLACKHOLE = 91,
	LINUX_MIB_TCPSPURIOUS_RTX_HOSTQUEUES = 92,
	LINUX_MIB_BUSYPOLLRXPACKETS = 93,
	LINUX_MIB_TCPAUTOCORKING = 94,
	LINUX_MIB_TCPFROMZEROWINDOWADV = 95,
	LINUX_MIB_TCPTOZEROWINDOWADV = 96,
	LINUX_MIB_TCPWANTZEROWINDOWADV = 97,
	LINUX_MIB_TCPSYNRETRANS = 98,
	LINUX_MIB_TCPORIGDATASENT = 99,
	LINUX_MIB_TCPHYSTARTTRAINDETECT = 100,
	LINUX_MIB_TCPHYSTARTTRAINCWND = 101,
	LINUX_MIB_TCPHYSTARTDELAYDETECT = 102,
	LINUX_MIB_TCPHYSTARTDELAYCWND = 103,
	LINUX_MIB_TCPACKSKIPPEDSYNRECV = 104,
	LINUX_MIB_TCPACKSKIPPEDPAWS = 105,
	LINUX_MIB_TCPACKSKIPPEDSEQ = 106,
	LINUX_MIB_TCPACKSKIPPEDFINWAIT2 = 107,
	LINUX_MIB_TCPACKSKIPPEDTIMEWAIT = 108,
	LINUX_MIB_TCPACKSKIPPEDCHALLENGE = 109,
	LINUX_MIB_TCPWINPROBE = 110,
	LINUX_MIB_TCPKEEPALIVE = 111,
	LINUX_MIB_TCPMTUPFAIL = 112,
	LINUX_MIB_TCPMTUPSUCCESS = 113,
	LINUX_MIB_TCPDELIVERED = 114,
	LINUX_MIB_TCPDELIVEREDCE = 115,
	LINUX_MIB_TCPACKCOMPRESSED = 116,
	LINUX_MIB_TCPZEROWINDOWDROP = 117,
	LINUX_MIB_TCPRCVQDROP = 118,
	LINUX_MIB_TCPWQUEUETOOBIG = 119,
	LINUX_MIB_TCPFASTOPENPASSIVEALTKEY = 120,
	LINUX_MIB_TCPTIMEOUTREHASH = 121,
	LINUX_MIB_TCPDUPLICATEDATAREHASH = 122,
	LINUX_MIB_TCPDSACKRECVSEGS = 123,
	LINUX_MIB_TCPDSACKIGNOREDDUBIOUS = 124,
	LINUX_MIB_TCPMIGRATEREQSUCCESS = 125,
	LINUX_MIB_TCPMIGRATEREQFAILURE = 126,
	LINUX_MIB_TCPPLBREHASH = 127,
	LINUX_MIB_TCPAOREQUIRED = 128,
	LINUX_MIB_TCPAOBAD = 129,
	LINUX_MIB_TCPAOKEYNOTFOUND = 130,
	LINUX_MIB_TCPAOGOOD = 131,
	LINUX_MIB_TCPAODROPPEDICMPS = 132,
	__LINUX_MIB_MAX = 133,
};

enum {
	LINUX_MIB_TLSNUM = 0,
	LINUX_MIB_TLSCURRTXSW = 1,
	LINUX_MIB_TLSCURRRXSW = 2,
	LINUX_MIB_TLSCURRTXDEVICE = 3,
	LINUX_MIB_TLSCURRRXDEVICE = 4,
	LINUX_MIB_TLSTXSW = 5,
	LINUX_MIB_TLSRXSW = 6,
	LINUX_MIB_TLSTXDEVICE = 7,
	LINUX_MIB_TLSRXDEVICE = 8,
	LINUX_MIB_TLSDECRYPTERROR = 9,
	LINUX_MIB_TLSRXDEVICERESYNC = 10,
	LINUX_MIB_TLSDECRYPTRETRY = 11,
	LINUX_MIB_TLSRXNOPADVIOL = 12,
	LINUX_MIB_TLSRXREKEYOK = 13,
	LINUX_MIB_TLSRXREKEYERROR = 14,
	LINUX_MIB_TLSTXREKEYOK = 15,
	LINUX_MIB_TLSTXREKEYERROR = 16,
	LINUX_MIB_TLSRXREKEYRECEIVED = 17,
	__LINUX_MIB_TLSMAX = 18,
};

enum {
	LINUX_MIB_XFRMNUM = 0,
	LINUX_MIB_XFRMINERROR = 1,
	LINUX_MIB_XFRMINBUFFERERROR = 2,
	LINUX_MIB_XFRMINHDRERROR = 3,
	LINUX_MIB_XFRMINNOSTATES = 4,
	LINUX_MIB_XFRMINSTATEPROTOERROR = 5,
	LINUX_MIB_XFRMINSTATEMODEERROR = 6,
	LINUX_MIB_XFRMINSTATESEQERROR = 7,
	LINUX_MIB_XFRMINSTATEEXPIRED = 8,
	LINUX_MIB_XFRMINSTATEMISMATCH = 9,
	LINUX_MIB_XFRMINSTATEINVALID = 10,
	LINUX_MIB_XFRMINTMPLMISMATCH = 11,
	LINUX_MIB_XFRMINNOPOLS = 12,
	LINUX_MIB_XFRMINPOLBLOCK = 13,
	LINUX_MIB_XFRMINPOLERROR = 14,
	LINUX_MIB_XFRMOUTERROR = 15,
	LINUX_MIB_XFRMOUTBUNDLEGENERROR = 16,
	LINUX_MIB_XFRMOUTBUNDLECHECKERROR = 17,
	LINUX_MIB_XFRMOUTNOSTATES = 18,
	LINUX_MIB_XFRMOUTSTATEPROTOERROR = 19,
	LINUX_MIB_XFRMOUTSTATEMODEERROR = 20,
	LINUX_MIB_XFRMOUTSTATESEQERROR = 21,
	LINUX_MIB_XFRMOUTSTATEEXPIRED = 22,
	LINUX_MIB_XFRMOUTPOLBLOCK = 23,
	LINUX_MIB_XFRMOUTPOLDEAD = 24,
	LINUX_MIB_XFRMOUTPOLERROR = 25,
	LINUX_MIB_XFRMFWDHDRERROR = 26,
	LINUX_MIB_XFRMOUTSTATEINVALID = 27,
	LINUX_MIB_XFRMACQUIREERROR = 28,
	LINUX_MIB_XFRMOUTSTATEDIRERROR = 29,
	LINUX_MIB_XFRMINSTATEDIRERROR = 30,
	LINUX_MIB_XFRMINIPTFSERROR = 31,
	LINUX_MIB_XFRMOUTNOQSPACE = 32,
	__LINUX_MIB_XFRMMAX = 33,
};

enum {
	LK_STATE_IN_USE = 0,
	NFS_DELEGATED_STATE = 1,
	NFS_OPEN_STATE = 2,
	NFS_O_RDONLY_STATE = 3,
	NFS_O_WRONLY_STATE = 4,
	NFS_O_RDWR_STATE = 5,
	NFS_STATE_RECLAIM_REBOOT = 6,
	NFS_STATE_RECLAIM_NOGRACE = 7,
	NFS_STATE_POSIX_LOCKS = 8,
	NFS_STATE_RECOVERY_FAILED = 9,
	NFS_STATE_MAY_NOTIFY_LOCK = 10,
	NFS_STATE_CHANGE_WAIT = 11,
	NFS_CLNT_DST_SSC_COPY_STATE = 12,
	NFS_CLNT_SRC_SSC_COPY_STATE = 13,
	NFS_SRV_SSC_COPY_STATE = 14,
};

enum {
	LOGIC_PIO_INDIRECT = 0,
	LOGIC_PIO_CPU_MMIO = 1,
};

enum {
	LOG_INODE_ALL = 0,
	LOG_INODE_EXISTS = 1,
};

enum {
	LOG_WALK_PIN_ONLY = 0,
	LOG_WALK_REPLAY_INODES = 1,
	LOG_WALK_REPLAY_DIR_INDEX = 2,
	LOG_WALK_REPLAY_ALL = 3,
};

enum {
	LO_FLAGS_READ_ONLY = 1,
	LO_FLAGS_AUTOCLEAR = 4,
	LO_FLAGS_PARTSCAN = 8,
	LO_FLAGS_DIRECT_IO = 16,
};

enum {
	LWTUNNEL_IP_OPTS_UNSPEC = 0,
	LWTUNNEL_IP_OPTS_GENEVE = 1,
	LWTUNNEL_IP_OPTS_VXLAN = 2,
	LWTUNNEL_IP_OPTS_ERSPAN = 3,
	__LWTUNNEL_IP_OPTS_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_ERSPAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_ERSPAN_VER = 1,
	LWTUNNEL_IP_OPT_ERSPAN_INDEX = 2,
	LWTUNNEL_IP_OPT_ERSPAN_DIR = 3,
	LWTUNNEL_IP_OPT_ERSPAN_HWID = 4,
	__LWTUNNEL_IP_OPT_ERSPAN_MAX = 5,
};

enum {
	LWTUNNEL_IP_OPT_GENEVE_UNSPEC = 0,
	LWTUNNEL_IP_OPT_GENEVE_CLASS = 1,
	LWTUNNEL_IP_OPT_GENEVE_TYPE = 2,
	LWTUNNEL_IP_OPT_GENEVE_DATA = 3,
	__LWTUNNEL_IP_OPT_GENEVE_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_VXLAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_VXLAN_GBP = 1,
	__LWTUNNEL_IP_OPT_VXLAN_MAX = 2,
};

enum {
	LWTUNNEL_XMIT_DONE = 0,
	LWTUNNEL_XMIT_CONTINUE = 256,
};

enum {
	Lo_unbound = 0,
	Lo_bound = 1,
	Lo_rundown = 2,
	Lo_deleting = 3,
};

enum {
	MATCH_MTR = 0,
	MATCH_MEQ = 1,
	MATCH_MLE = 2,
	MATCH_MLT = 3,
	MATCH_MGE = 4,
	MATCH_MGT = 5,
};

enum {
	MAX_IORES_LEVEL = 5,
};

enum {
	MAX_OPT_ARGS = 3,
};

enum {
	MBE_REFERENCED_B = 0,
	MBE_REUSABLE_B = 1,
};

enum {
	MB_INODE_PA = 0,
	MB_GROUP_PA = 1,
};

enum {
	MDBA_GET_ENTRY_UNSPEC = 0,
	MDBA_GET_ENTRY = 1,
	MDBA_GET_ENTRY_ATTRS = 2,
	__MDBA_GET_ENTRY_MAX = 3,
};

enum {
	MDBA_MDB_EATTR_UNSPEC = 0,
	MDBA_MDB_EATTR_TIMER = 1,
	MDBA_MDB_EATTR_SRC_LIST = 2,
	MDBA_MDB_EATTR_GROUP_MODE = 3,
	MDBA_MDB_EATTR_SOURCE = 4,
	MDBA_MDB_EATTR_RTPROT = 5,
	MDBA_MDB_EATTR_DST = 6,
	MDBA_MDB_EATTR_DST_PORT = 7,
	MDBA_MDB_EATTR_VNI = 8,
	MDBA_MDB_EATTR_IFINDEX = 9,
	MDBA_MDB_EATTR_SRC_VNI = 10,
	__MDBA_MDB_EATTR_MAX = 11,
};

enum {
	MDBA_MDB_ENTRY_UNSPEC = 0,
	MDBA_MDB_ENTRY_INFO = 1,
	__MDBA_MDB_ENTRY_MAX = 2,
};

enum {
	MDBA_MDB_SRCATTR_UNSPEC = 0,
	MDBA_MDB_SRCATTR_ADDRESS = 1,
	MDBA_MDB_SRCATTR_TIMER = 2,
	__MDBA_MDB_SRCATTR_MAX = 3,
};

enum {
	MDBA_MDB_SRCLIST_UNSPEC = 0,
	MDBA_MDB_SRCLIST_ENTRY = 1,
	__MDBA_MDB_SRCLIST_MAX = 2,
};

enum {
	MDBA_MDB_UNSPEC = 0,
	MDBA_MDB_ENTRY = 1,
	__MDBA_MDB_MAX = 2,
};

enum {
	MDBA_SET_ENTRY_UNSPEC = 0,
	MDBA_SET_ENTRY = 1,
	MDBA_SET_ENTRY_ATTRS = 2,
	__MDBA_SET_ENTRY_MAX = 3,
};

enum {
	MDBA_UNSPEC = 0,
	MDBA_MDB = 1,
	MDBA_ROUTER = 2,
	__MDBA_MAX = 3,
};

enum {
	MDBE_ATTR_UNSPEC = 0,
	MDBE_ATTR_SOURCE = 1,
	MDBE_ATTR_SRC_LIST = 2,
	MDBE_ATTR_GROUP_MODE = 3,
	MDBE_ATTR_RTPROT = 4,
	MDBE_ATTR_DST = 5,
	MDBE_ATTR_DST_PORT = 6,
	MDBE_ATTR_VNI = 7,
	MDBE_ATTR_IFINDEX = 8,
	MDBE_ATTR_SRC_VNI = 9,
	MDBE_ATTR_STATE_MASK = 10,
	__MDBE_ATTR_MAX = 11,
};

enum {
	MDBE_SRCATTR_UNSPEC = 0,
	MDBE_SRCATTR_ADDRESS = 1,
	__MDBE_SRCATTR_MAX = 2,
};

enum {
	MDBE_SRC_LIST_UNSPEC = 0,
	MDBE_SRC_LIST_ENTRY = 1,
	__MDBE_SRC_LIST_MAX = 2,
};

enum {
	MEGASAS_HBA_OPERATIONAL = 0,
	MEGASAS_ADPRESET_SM_INFAULT = 1,
	MEGASAS_ADPRESET_SM_FW_RESET_SUCCESS = 2,
	MEGASAS_ADPRESET_SM_OPERATIONAL = 3,
	MEGASAS_HW_CRITICAL_ERROR = 4,
	MEGASAS_ADPRESET_SM_POLLING = 5,
	MEGASAS_ADPRESET_INPROG_SIGN = 3735936685,
};

enum {
	MEMBARRIER_FLAG_SYNC_CORE = 1,
	MEMBARRIER_FLAG_RSEQ = 2,
};

enum {
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_READY = 1,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED = 2,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED_READY = 4,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED = 8,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE_READY = 16,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ_READY = 64,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ = 128,
};

enum {
	MEMMAP_ON_MEMORY_DISABLE = 0,
	MEMMAP_ON_MEMORY_ENABLE = 1,
	MEMMAP_ON_MEMORY_FORCE = 2,
};

enum {
	MEMORY_RECLAIM_SWAPPINESS = 0,
	MEMORY_RECLAIM_NULL = 1,
};

enum {
	MEMREMAP_WB = 1,
	MEMREMAP_WT = 2,
	MEMREMAP_WC = 4,
	MEMREMAP_ENC = 8,
	MEMREMAP_DEC = 16,
};

enum {
	MFC_STATIC = 1,
	MFC_OFFLOAD = 2,
};

enum {
	MILLION = 1000000,
	MIN_PERIOD = 1000,
	MAX_PERIOD = 1000000,
	MARGIN_MIN_PCT = 10,
	MARGIN_LOW_PCT = 20,
	MARGIN_TARGET_PCT = 50,
	INUSE_ADJ_STEP_PCT = 25,
	TIMER_SLACK_PCT = 1,
	WEIGHT_ONE = 65536,
};

enum {
	MIX_INFLIGHT = 2147483648,
};

enum {
	MLO_PAUSE_NONE = 0,
	MLO_PAUSE_RX = 1,
	MLO_PAUSE_TX = 2,
	MLO_PAUSE_TXRX_MASK = 3,
	MLO_PAUSE_AN = 4,
	MLO_AN_PHY = 0,
	MLO_AN_FIXED = 1,
	MLO_AN_INBAND = 2,
	PHYLINK_PCS_NEG_NONE = 0,
	PHYLINK_PCS_NEG_ENABLED = 16,
	PHYLINK_PCS_NEG_OUTBAND = 32,
	PHYLINK_PCS_NEG_INBAND = 64,
	PHYLINK_PCS_NEG_INBAND_DISABLED = 64,
	PHYLINK_PCS_NEG_INBAND_ENABLED = 80,
	MAC_SYM_PAUSE = 1,
	MAC_ASYM_PAUSE = 2,
	MAC_10HD = 4,
	MAC_10FD = 8,
	MAC_10 = 12,
	MAC_100HD = 16,
	MAC_100FD = 32,
	MAC_100 = 48,
	MAC_1000HD = 64,
	MAC_1000FD = 128,
	MAC_1000 = 192,
	MAC_2500FD = 256,
	MAC_5000FD = 512,
	MAC_10000FD = 1024,
	MAC_20000FD = 2048,
	MAC_25000FD = 4096,
	MAC_40000FD = 8192,
	MAC_50000FD = 16384,
	MAC_56000FD = 32768,
	MAC_100000FD = 65536,
	MAC_200000FD = 131072,
	MAC_400000FD = 262144,
};

enum {
	MMOP_OFFLINE = 0,
	MMOP_ONLINE = 1,
	MMOP_ONLINE_KERNEL = 2,
	MMOP_ONLINE_MOVABLE = 3,
};

enum {
	MM_FILEPAGES = 0,
	MM_ANONPAGES = 1,
	MM_SWAPENTS = 2,
	MM_SHMEMPAGES = 3,
	NR_MM_COUNTERS = 4,
};

enum {
	MOUNTPROC3_NULL = 0,
	MOUNTPROC3_MNT = 1,
	MOUNTPROC3_DUMP = 2,
	MOUNTPROC3_UMNT = 3,
	MOUNTPROC3_UMNTALL = 4,
	MOUNTPROC3_EXPORT = 5,
};

enum {
	MOUNTPROC_NULL = 0,
	MOUNTPROC_MNT = 1,
	MOUNTPROC_DUMP = 2,
	MOUNTPROC_UMNT = 3,
	MOUNTPROC_UMNTALL = 4,
	MOUNTPROC_EXPORT = 5,
};

enum {
	MOXA_SUPP_RS232 = 1,
	MOXA_SUPP_RS422 = 2,
	MOXA_SUPP_RS485 = 4,
};

enum {
	MPOL_DEFAULT = 0,
	MPOL_PREFERRED = 1,
	MPOL_BIND = 2,
	MPOL_INTERLEAVE = 3,
	MPOL_LOCAL = 4,
	MPOL_PREFERRED_MANY = 5,
	MPOL_WEIGHTED_INTERLEAVE = 6,
	MPOL_MAX = 7,
};

enum {
	MPTCP_CMSG_TS = 1,
	MPTCP_CMSG_INQ = 2,
};

enum {
	MPTCP_PM_ADDR_ATTR_UNSPEC = 0,
	MPTCP_PM_ADDR_ATTR_FAMILY = 1,
	MPTCP_PM_ADDR_ATTR_ID = 2,
	MPTCP_PM_ADDR_ATTR_ADDR4 = 3,
	MPTCP_PM_ADDR_ATTR_ADDR6 = 4,
	MPTCP_PM_ADDR_ATTR_PORT = 5,
	MPTCP_PM_ADDR_ATTR_FLAGS = 6,
	MPTCP_PM_ADDR_ATTR_IF_IDX = 7,
	__MPTCP_PM_ADDR_ATTR_MAX = 8,
};

enum {
	MPTCP_PM_ATTR_UNSPEC = 0,
	MPTCP_PM_ATTR_ADDR = 1,
	MPTCP_PM_ATTR_RCV_ADD_ADDRS = 2,
	MPTCP_PM_ATTR_SUBFLOWS = 3,
	MPTCP_PM_ATTR_TOKEN = 4,
	MPTCP_PM_ATTR_LOC_ID = 5,
	MPTCP_PM_ATTR_ADDR_REMOTE = 6,
	__MPTCP_ATTR_AFTER_LAST = 7,
};

enum {
	MPTCP_PM_CMD_UNSPEC = 0,
	MPTCP_PM_CMD_ADD_ADDR = 1,
	MPTCP_PM_CMD_DEL_ADDR = 2,
	MPTCP_PM_CMD_GET_ADDR = 3,
	MPTCP_PM_CMD_FLUSH_ADDRS = 4,
	MPTCP_PM_CMD_SET_LIMITS = 5,
	MPTCP_PM_CMD_GET_LIMITS = 6,
	MPTCP_PM_CMD_SET_FLAGS = 7,
	MPTCP_PM_CMD_ANNOUNCE = 8,
	MPTCP_PM_CMD_REMOVE = 9,
	MPTCP_PM_CMD_SUBFLOW_CREATE = 10,
	MPTCP_PM_CMD_SUBFLOW_DESTROY = 11,
	__MPTCP_PM_CMD_AFTER_LAST = 12,
};

enum {
	MPTCP_PM_ENDPOINT_ADDR = 1,
	__MPTCP_PM_ENDPOINT_MAX = 2,
};

enum {
	MPTCP_SUBFLOW_ATTR_UNSPEC = 0,
	MPTCP_SUBFLOW_ATTR_TOKEN_REM = 1,
	MPTCP_SUBFLOW_ATTR_TOKEN_LOC = 2,
	MPTCP_SUBFLOW_ATTR_RELWRITE_SEQ = 3,
	MPTCP_SUBFLOW_ATTR_MAP_SEQ = 4,
	MPTCP_SUBFLOW_ATTR_MAP_SFSEQ = 5,
	MPTCP_SUBFLOW_ATTR_SSN_OFFSET = 6,
	MPTCP_SUBFLOW_ATTR_MAP_DATALEN = 7,
	MPTCP_SUBFLOW_ATTR_FLAGS = 8,
	MPTCP_SUBFLOW_ATTR_ID_REM = 9,
	MPTCP_SUBFLOW_ATTR_ID_LOC = 10,
	MPTCP_SUBFLOW_ATTR_PAD = 11,
	__MPTCP_SUBFLOW_ATTR_MAX = 12,
};

enum {
	MSI_FLAG_USE_DEF_DOM_OPS = 1,
	MSI_FLAG_USE_DEF_CHIP_OPS = 2,
	MSI_FLAG_ACTIVATE_EARLY = 4,
	MSI_FLAG_MUST_REACTIVATE = 8,
	MSI_FLAG_DEV_SYSFS = 16,
	MSI_FLAG_ALLOC_SIMPLE_MSI_DESCS = 32,
	MSI_FLAG_FREE_MSI_DESCS = 64,
	MSI_FLAG_USE_DEV_FWNODE = 128,
	MSI_FLAG_PARENT_PM_DEV = 256,
	MSI_FLAG_PCI_MSI_MASK_PARENT = 512,
	MSI_GENERIC_FLAGS_MASK = 65535,
	MSI_DOMAIN_FLAGS_MASK = 4294901760,
	MSI_FLAG_MULTI_PCI_MSI = 65536,
	MSI_FLAG_PCI_MSIX = 131072,
	MSI_FLAG_LEVEL_CAPABLE = 262144,
	MSI_FLAG_MSIX_CONTIGUOUS = 524288,
	MSI_FLAG_PCI_MSIX_ALLOC_DYN = 1048576,
	MSI_FLAG_NO_AFFINITY = 2097152,
};

enum {
	MTTG_TRAV_INIT = 0,
	MTTG_TRAV_NFP_UNSPEC = 1,
	MTTG_TRAV_NFP_SPEC = 2,
	MTTG_TRAV_DONE = 3,
};

enum {
	MV_PMA_FW_VER0 = 49169,
	MV_PMA_FW_VER1 = 49170,
	MV_PMA_21X0_PORT_CTRL = 49226,
	MV_PMA_21X0_PORT_CTRL_SWRST = 32768,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_MASK = 7,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_USXGMII = 0,
	MV_PMA_2180_PORT_CTRL_MACTYPE_DXGMII = 1,
	MV_PMA_2180_PORT_CTRL_MACTYPE_QXGMII = 2,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_5GBASER = 4,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_5GBASER_NO_SGMII_AN = 5,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_10GBASER_RATE_MATCH = 6,
	MV_PMA_BOOT = 49232,
	MV_PMA_BOOT_FATAL = 1,
	MV_PCS_BASE_T = 0,
	MV_PCS_BASE_R = 4096,
	MV_PCS_1000BASEX = 8192,
	MV_PCS_CSCR1 = 32768,
	MV_PCS_CSCR1_ED_MASK = 768,
	MV_PCS_CSCR1_ED_OFF = 0,
	MV_PCS_CSCR1_ED_RX = 512,
	MV_PCS_CSCR1_ED_NLP = 768,
	MV_PCS_CSCR1_MDIX_MASK = 96,
	MV_PCS_CSCR1_MDIX_MDI = 0,
	MV_PCS_CSCR1_MDIX_MDIX = 32,
	MV_PCS_CSCR1_MDIX_AUTO = 96,
	MV_PCS_DSC1 = 32771,
	MV_PCS_DSC1_ENABLE = 512,
	MV_PCS_DSC1_10GBT = 448,
	MV_PCS_DSC1_1GBR = 56,
	MV_PCS_DSC1_100BTX = 7,
	MV_PCS_DSC2 = 32772,
	MV_PCS_DSC2_2P5G = 61440,
	MV_PCS_DSC2_5G = 3840,
	MV_PCS_CSSR1 = 32776,
	MV_PCS_CSSR1_SPD1_MASK = 49152,
	MV_PCS_CSSR1_SPD1_SPD2 = 49152,
	MV_PCS_CSSR1_SPD1_1000 = 32768,
	MV_PCS_CSSR1_SPD1_100 = 16384,
	MV_PCS_CSSR1_SPD1_10 = 0,
	MV_PCS_CSSR1_DUPLEX_FULL = 8192,
	MV_PCS_CSSR1_RESOLVED = 2048,
	MV_PCS_CSSR1_MDIX = 64,
	MV_PCS_CSSR1_SPD2_MASK = 12,
	MV_PCS_CSSR1_SPD2_5000 = 8,
	MV_PCS_CSSR1_SPD2_2500 = 4,
	MV_PCS_CSSR1_SPD2_10000 = 0,
	MV_PCS_TEMP = 32834,
	MV_PCS_PORT_INFO = 53261,
	MV_PCS_PORT_INFO_NPORTS_MASK = 896,
	MV_PCS_PORT_INFO_NPORTS_SHIFT = 7,
	MV_AN_21X0_SERDES_CTRL2 = 32783,
	MV_AN_21X0_SERDES_CTRL2_AUTO_INIT_DIS = 8192,
	MV_AN_21X0_SERDES_CTRL2_RUN_INIT = 32768,
	MV_AN_CTRL1000 = 32768,
	MV_AN_STAT1000 = 32769,
	MV_V2_PORT_CTRL = 61441,
	MV_V2_PORT_CTRL_PWRDOWN = 2048,
	MV_V2_33X0_PORT_CTRL_SWRST = 32768,
	MV_V2_33X0_PORT_CTRL_MACTYPE_MASK = 7,
	MV_V2_33X0_PORT_CTRL_MACTYPE_RXAUI = 0,
	MV_V2_3310_PORT_CTRL_MACTYPE_XAUI_RATE_MATCH = 1,
	MV_V2_3340_PORT_CTRL_MACTYPE_RXAUI_NO_SGMII_AN = 1,
	MV_V2_33X0_PORT_CTRL_MACTYPE_RXAUI_RATE_MATCH = 2,
	MV_V2_3310_PORT_CTRL_MACTYPE_XAUI = 3,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER = 4,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER_NO_SGMII_AN = 5,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER_RATE_MATCH = 6,
	MV_V2_33X0_PORT_CTRL_MACTYPE_USXGMII = 7,
	MV_V2_PORT_INTR_STS = 61504,
	MV_V2_PORT_INTR_MASK = 61507,
	MV_V2_PORT_INTR_STS_WOL_EN = 256,
	MV_V2_MAGIC_PKT_WORD0 = 61547,
	MV_V2_MAGIC_PKT_WORD1 = 61548,
	MV_V2_MAGIC_PKT_WORD2 = 61549,
	MV_V2_WOL_CTRL = 61550,
	MV_V2_WOL_CTRL_CLEAR_STS = 32768,
	MV_V2_WOL_CTRL_MAGIC_PKT_EN = 1,
	MV_V2_TEMP_CTRL = 61578,
	MV_V2_TEMP_CTRL_MASK = 49152,
	MV_V2_TEMP_CTRL_SAMPLE = 0,
	MV_V2_TEMP_CTRL_DISABLE = 49152,
	MV_V2_TEMP = 61580,
	MV_V2_TEMP_UNKNOWN = 38400,
};

enum {
	M_I17 = 0,
	M_I20 = 1,
	M_I20_SR = 2,
	M_I24 = 3,
	M_I24_8_1 = 4,
	M_I24_10_1 = 5,
	M_I27_11_1 = 6,
	M_MINI = 7,
	M_MINI_3_1 = 8,
	M_MINI_4_1 = 9,
	M_MB = 10,
	M_MB_2 = 11,
	M_MB_3 = 12,
	M_MB_5_1 = 13,
	M_MB_6_1 = 14,
	M_MB_7_1 = 15,
	M_MB_SR = 16,
	M_MBA = 17,
	M_MBA_3 = 18,
	M_MBP = 19,
	M_MBP_2 = 20,
	M_MBP_2_2 = 21,
	M_MBP_SR = 22,
	M_MBP_4 = 23,
	M_MBP_5_1 = 24,
	M_MBP_5_2 = 25,
	M_MBP_5_3 = 26,
	M_MBP_6_1 = 27,
	M_MBP_6_2 = 28,
	M_MBP_7_1 = 29,
	M_MBP_8_2 = 30,
	M_UNKNOWN = 31,
};

enum {
	NAMESZ = 12,
};

enum {
	NAPIF_STATE_SCHED = 1,
	NAPIF_STATE_MISSED = 2,
	NAPIF_STATE_DISABLE = 4,
	NAPIF_STATE_NPSVC = 8,
	NAPIF_STATE_LISTED = 16,
	NAPIF_STATE_NO_BUSY_POLL = 32,
	NAPIF_STATE_IN_BUSY_POLL = 64,
	NAPIF_STATE_PREFER_BUSY_POLL = 128,
	NAPIF_STATE_THREADED = 256,
	NAPIF_STATE_SCHED_THREADED = 512,
};

enum {
	NAPI_F_PREFER_BUSY_POLL = 1,
	NAPI_F_END_ON_RESCHED = 2,
};

enum {
	NAPI_STATE_SCHED = 0,
	NAPI_STATE_MISSED = 1,
	NAPI_STATE_DISABLE = 2,
	NAPI_STATE_NPSVC = 3,
	NAPI_STATE_LISTED = 4,
	NAPI_STATE_NO_BUSY_POLL = 5,
	NAPI_STATE_IN_BUSY_POLL = 6,
	NAPI_STATE_PREFER_BUSY_POLL = 7,
	NAPI_STATE_THREADED = 8,
	NAPI_STATE_SCHED_THREADED = 9,
};

enum {
	NDA_UNSPEC = 0,
	NDA_DST = 1,
	NDA_LLADDR = 2,
	NDA_CACHEINFO = 3,
	NDA_PROBES = 4,
	NDA_VLAN = 5,
	NDA_PORT = 6,
	NDA_VNI = 7,
	NDA_IFINDEX = 8,
	NDA_MASTER = 9,
	NDA_LINK_NETNSID = 10,
	NDA_SRC_VNI = 11,
	NDA_PROTOCOL = 12,
	NDA_NH_ID = 13,
	NDA_FDB_EXT_ATTRS = 14,
	NDA_FLAGS_EXT = 15,
	NDA_NDM_STATE_MASK = 16,
	NDA_NDM_FLAGS_MASK = 17,
	__NDA_MAX = 18,
};

enum {
	NDTA_UNSPEC = 0,
	NDTA_NAME = 1,
	NDTA_THRESH1 = 2,
	NDTA_THRESH2 = 3,
	NDTA_THRESH3 = 4,
	NDTA_CONFIG = 5,
	NDTA_PARMS = 6,
	NDTA_STATS = 7,
	NDTA_GC_INTERVAL = 8,
	NDTA_PAD = 9,
	__NDTA_MAX = 10,
};

enum {
	NDTPA_UNSPEC = 0,
	NDTPA_IFINDEX = 1,
	NDTPA_REFCNT = 2,
	NDTPA_REACHABLE_TIME = 3,
	NDTPA_BASE_REACHABLE_TIME = 4,
	NDTPA_RETRANS_TIME = 5,
	NDTPA_GC_STALETIME = 6,
	NDTPA_DELAY_PROBE_TIME = 7,
	NDTPA_QUEUE_LEN = 8,
	NDTPA_APP_PROBES = 9,
	NDTPA_UCAST_PROBES = 10,
	NDTPA_MCAST_PROBES = 11,
	NDTPA_ANYCAST_DELAY = 12,
	NDTPA_PROXY_DELAY = 13,
	NDTPA_PROXY_QLEN = 14,
	NDTPA_LOCKTIME = 15,
	NDTPA_QUEUE_LENBYTES = 16,
	NDTPA_MCAST_REPROBES = 17,
	NDTPA_PAD = 18,
	NDTPA_INTERVAL_PROBE_TIME_MS = 19,
	__NDTPA_MAX = 20,
};

enum {
	NDUSEROPT_UNSPEC = 0,
	NDUSEROPT_SRCADDR = 1,
	__NDUSEROPT_MAX = 2,
};

enum {
	NEIGH_ARP_TABLE = 0,
	NEIGH_ND_TABLE = 1,
	NEIGH_NR_TABLES = 2,
	NEIGH_LINK_TABLE = 2,
};

enum {
	NEIGH_VAR_MCAST_PROBES = 0,
	NEIGH_VAR_UCAST_PROBES = 1,
	NEIGH_VAR_APP_PROBES = 2,
	NEIGH_VAR_MCAST_REPROBES = 3,
	NEIGH_VAR_RETRANS_TIME = 4,
	NEIGH_VAR_BASE_REACHABLE_TIME = 5,
	NEIGH_VAR_DELAY_PROBE_TIME = 6,
	NEIGH_VAR_INTERVAL_PROBE_TIME_MS = 7,
	NEIGH_VAR_GC_STALETIME = 8,
	NEIGH_VAR_QUEUE_LEN_BYTES = 9,
	NEIGH_VAR_PROXY_QLEN = 10,
	NEIGH_VAR_ANYCAST_DELAY = 11,
	NEIGH_VAR_PROXY_DELAY = 12,
	NEIGH_VAR_LOCKTIME = 13,
	NEIGH_VAR_QUEUE_LEN = 14,
	NEIGH_VAR_RETRANS_TIME_MS = 15,
	NEIGH_VAR_BASE_REACHABLE_TIME_MS = 16,
	NEIGH_VAR_GC_INTERVAL = 17,
	NEIGH_VAR_GC_THRESH1 = 18,
	NEIGH_VAR_GC_THRESH2 = 19,
	NEIGH_VAR_GC_THRESH3 = 20,
	NEIGH_VAR_MAX = 21,
};

enum {
	NESTED_SYNC_IMM_BIT = 0,
	NESTED_SYNC_TODO_BIT = 1,
};

enum {
	NETCONFA_UNSPEC = 0,
	NETCONFA_IFINDEX = 1,
	NETCONFA_FORWARDING = 2,
	NETCONFA_RP_FILTER = 3,
	NETCONFA_MC_FORWARDING = 4,
	NETCONFA_PROXY_NEIGH = 5,
	NETCONFA_IGNORE_ROUTES_WITH_LINKDOWN = 6,
	NETCONFA_INPUT = 7,
	NETCONFA_BC_FORWARDING = 8,
	__NETCONFA_MAX = 9,
};

enum {
	NETDEV_A_DEV_IFINDEX = 1,
	NETDEV_A_DEV_PAD = 2,
	NETDEV_A_DEV_XDP_FEATURES = 3,
	NETDEV_A_DEV_XDP_ZC_MAX_SEGS = 4,
	NETDEV_A_DEV_XDP_RX_METADATA_FEATURES = 5,
	NETDEV_A_DEV_XSK_FEATURES = 6,
	__NETDEV_A_DEV_MAX = 7,
	NETDEV_A_DEV_MAX = 6,
};

enum {
	NETDEV_A_DMABUF_IFINDEX = 1,
	NETDEV_A_DMABUF_QUEUES = 2,
	NETDEV_A_DMABUF_FD = 3,
	NETDEV_A_DMABUF_ID = 4,
	__NETDEV_A_DMABUF_MAX = 5,
	NETDEV_A_DMABUF_MAX = 4,
};

enum {
	NETDEV_A_NAPI_IFINDEX = 1,
	NETDEV_A_NAPI_ID = 2,
	NETDEV_A_NAPI_IRQ = 3,
	NETDEV_A_NAPI_PID = 4,
	NETDEV_A_NAPI_DEFER_HARD_IRQS = 5,
	NETDEV_A_NAPI_GRO_FLUSH_TIMEOUT = 6,
	NETDEV_A_NAPI_IRQ_SUSPEND_TIMEOUT = 7,
	__NETDEV_A_NAPI_MAX = 8,
	NETDEV_A_NAPI_MAX = 7,
};

enum {
	NETDEV_A_PAGE_POOL_ID = 1,
	NETDEV_A_PAGE_POOL_IFINDEX = 2,
	NETDEV_A_PAGE_POOL_NAPI_ID = 3,
	NETDEV_A_PAGE_POOL_INFLIGHT = 4,
	NETDEV_A_PAGE_POOL_INFLIGHT_MEM = 5,
	NETDEV_A_PAGE_POOL_DETACH_TIME = 6,
	NETDEV_A_PAGE_POOL_DMABUF = 7,
	__NETDEV_A_PAGE_POOL_MAX = 8,
	NETDEV_A_PAGE_POOL_MAX = 7,
};

enum {
	NETDEV_A_PAGE_POOL_STATS_INFO = 1,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_FAST = 8,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW = 9,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW_HIGH_ORDER = 10,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_EMPTY = 11,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_REFILL = 12,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_WAIVE = 13,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHED = 14,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHE_FULL = 15,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING = 16,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING_FULL = 17,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RELEASED_REFCNT = 18,
	__NETDEV_A_PAGE_POOL_STATS_MAX = 19,
	NETDEV_A_PAGE_POOL_STATS_MAX = 18,
};

enum {
	NETDEV_A_QSTATS_IFINDEX = 1,
	NETDEV_A_QSTATS_QUEUE_TYPE = 2,
	NETDEV_A_QSTATS_QUEUE_ID = 3,
	NETDEV_A_QSTATS_SCOPE = 4,
	NETDEV_A_QSTATS_RX_PACKETS = 8,
	NETDEV_A_QSTATS_RX_BYTES = 9,
	NETDEV_A_QSTATS_TX_PACKETS = 10,
	NETDEV_A_QSTATS_TX_BYTES = 11,
	NETDEV_A_QSTATS_RX_ALLOC_FAIL = 12,
	NETDEV_A_QSTATS_RX_HW_DROPS = 13,
	NETDEV_A_QSTATS_RX_HW_DROP_OVERRUNS = 14,
	NETDEV_A_QSTATS_RX_CSUM_COMPLETE = 15,
	NETDEV_A_QSTATS_RX_CSUM_UNNECESSARY = 16,
	NETDEV_A_QSTATS_RX_CSUM_NONE = 17,
	NETDEV_A_QSTATS_RX_CSUM_BAD = 18,
	NETDEV_A_QSTATS_RX_HW_GRO_PACKETS = 19,
	NETDEV_A_QSTATS_RX_HW_GRO_BYTES = 20,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_PACKETS = 21,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_BYTES = 22,
	NETDEV_A_QSTATS_RX_HW_DROP_RATELIMITS = 23,
	NETDEV_A_QSTATS_TX_HW_DROPS = 24,
	NETDEV_A_QSTATS_TX_HW_DROP_ERRORS = 25,
	NETDEV_A_QSTATS_TX_CSUM_NONE = 26,
	NETDEV_A_QSTATS_TX_NEEDS_CSUM = 27,
	NETDEV_A_QSTATS_TX_HW_GSO_PACKETS = 28,
	NETDEV_A_QSTATS_TX_HW_GSO_BYTES = 29,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_PACKETS = 30,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_BYTES = 31,
	NETDEV_A_QSTATS_TX_HW_DROP_RATELIMITS = 32,
	NETDEV_A_QSTATS_TX_STOP = 33,
	NETDEV_A_QSTATS_TX_WAKE = 34,
	__NETDEV_A_QSTATS_MAX = 35,
	NETDEV_A_QSTATS_MAX = 34,
};

enum {
	NETDEV_A_QUEUE_ID = 1,
	NETDEV_A_QUEUE_IFINDEX = 2,
	NETDEV_A_QUEUE_TYPE = 3,
	NETDEV_A_QUEUE_NAPI_ID = 4,
	NETDEV_A_QUEUE_DMABUF = 5,
	__NETDEV_A_QUEUE_MAX = 6,
	NETDEV_A_QUEUE_MAX = 5,
};

enum {
	NETDEV_CMD_DEV_GET = 1,
	NETDEV_CMD_DEV_ADD_NTF = 2,
	NETDEV_CMD_DEV_DEL_NTF = 3,
	NETDEV_CMD_DEV_CHANGE_NTF = 4,
	NETDEV_CMD_PAGE_POOL_GET = 5,
	NETDEV_CMD_PAGE_POOL_ADD_NTF = 6,
	NETDEV_CMD_PAGE_POOL_DEL_NTF = 7,
	NETDEV_CMD_PAGE_POOL_CHANGE_NTF = 8,
	NETDEV_CMD_PAGE_POOL_STATS_GET = 9,
	NETDEV_CMD_QUEUE_GET = 10,
	NETDEV_CMD_NAPI_GET = 11,
	NETDEV_CMD_QSTATS_GET = 12,
	NETDEV_CMD_BIND_RX = 13,
	NETDEV_CMD_NAPI_SET = 14,
	__NETDEV_CMD_MAX = 15,
	NETDEV_CMD_MAX = 14,
};

enum {
	NETDEV_NLGRP_MGMT = 0,
	NETDEV_NLGRP_PAGE_POOL = 1,
};

enum {
	NETDEV_STATS = 0,
	E1000_STATS = 1,
};

enum {
	NETDEV_STATS___2 = 0,
	IXGBE_STATS = 1,
};

enum {
	NETIF_F_SG_BIT = 0,
	NETIF_F_IP_CSUM_BIT = 1,
	__UNUSED_NETIF_F_1 = 2,
	NETIF_F_HW_CSUM_BIT = 3,
	NETIF_F_IPV6_CSUM_BIT = 4,
	NETIF_F_HIGHDMA_BIT = 5,
	NETIF_F_FRAGLIST_BIT = 6,
	NETIF_F_HW_VLAN_CTAG_TX_BIT = 7,
	NETIF_F_HW_VLAN_CTAG_RX_BIT = 8,
	NETIF_F_HW_VLAN_CTAG_FILTER_BIT = 9,
	NETIF_F_VLAN_CHALLENGED_BIT = 10,
	NETIF_F_GSO_BIT = 11,
	__UNUSED_NETIF_F_12 = 12,
	__UNUSED_NETIF_F_13 = 13,
	NETIF_F_GRO_BIT = 14,
	NETIF_F_LRO_BIT = 15,
	NETIF_F_GSO_SHIFT = 16,
	NETIF_F_TSO_BIT = 16,
	NETIF_F_GSO_ROBUST_BIT = 17,
	NETIF_F_TSO_ECN_BIT = 18,
	NETIF_F_TSO_MANGLEID_BIT = 19,
	NETIF_F_TSO6_BIT = 20,
	NETIF_F_FSO_BIT = 21,
	NETIF_F_GSO_GRE_BIT = 22,
	NETIF_F_GSO_GRE_CSUM_BIT = 23,
	NETIF_F_GSO_IPXIP4_BIT = 24,
	NETIF_F_GSO_IPXIP6_BIT = 25,
	NETIF_F_GSO_UDP_TUNNEL_BIT = 26,
	NETIF_F_GSO_UDP_TUNNEL_CSUM_BIT = 27,
	NETIF_F_GSO_PARTIAL_BIT = 28,
	NETIF_F_GSO_TUNNEL_REMCSUM_BIT = 29,
	NETIF_F_GSO_SCTP_BIT = 30,
	NETIF_F_GSO_ESP_BIT = 31,
	NETIF_F_GSO_UDP_BIT = 32,
	NETIF_F_GSO_UDP_L4_BIT = 33,
	NETIF_F_GSO_FRAGLIST_BIT = 34,
	NETIF_F_GSO_LAST = 34,
	NETIF_F_FCOE_CRC_BIT = 35,
	NETIF_F_SCTP_CRC_BIT = 36,
	__UNUSED_NETIF_F_37 = 37,
	NETIF_F_NTUPLE_BIT = 38,
	NETIF_F_RXHASH_BIT = 39,
	NETIF_F_RXCSUM_BIT = 40,
	NETIF_F_NOCACHE_COPY_BIT = 41,
	NETIF_F_LOOPBACK_BIT = 42,
	NETIF_F_RXFCS_BIT = 43,
	NETIF_F_RXALL_BIT = 44,
	NETIF_F_HW_VLAN_STAG_TX_BIT = 45,
	NETIF_F_HW_VLAN_STAG_RX_BIT = 46,
	NETIF_F_HW_VLAN_STAG_FILTER_BIT = 47,
	NETIF_F_HW_L2FW_DOFFLOAD_BIT = 48,
	NETIF_F_HW_TC_BIT = 49,
	NETIF_F_HW_ESP_BIT = 50,
	NETIF_F_HW_ESP_TX_CSUM_BIT = 51,
	NETIF_F_RX_UDP_TUNNEL_PORT_BIT = 52,
	NETIF_F_HW_TLS_TX_BIT = 53,
	NETIF_F_HW_TLS_RX_BIT = 54,
	NETIF_F_GRO_HW_BIT = 55,
	NETIF_F_HW_TLS_RECORD_BIT = 56,
	NETIF_F_GRO_FRAGLIST_BIT = 57,
	NETIF_F_HW_MACSEC_BIT = 58,
	NETIF_F_GRO_UDP_FWD_BIT = 59,
	NETIF_F_HW_HSR_TAG_INS_BIT = 60,
	NETIF_F_HW_HSR_TAG_RM_BIT = 61,
	NETIF_F_HW_HSR_FWD_BIT = 62,
	NETIF_F_HW_HSR_DUP_BIT = 63,
	NETDEV_FEATURE_COUNT = 64,
};

enum {
	NETIF_MSG_DRV_BIT = 0,
	NETIF_MSG_PROBE_BIT = 1,
	NETIF_MSG_LINK_BIT = 2,
	NETIF_MSG_TIMER_BIT = 3,
	NETIF_MSG_IFDOWN_BIT = 4,
	NETIF_MSG_IFUP_BIT = 5,
	NETIF_MSG_RX_ERR_BIT = 6,
	NETIF_MSG_TX_ERR_BIT = 7,
	NETIF_MSG_TX_QUEUED_BIT = 8,
	NETIF_MSG_INTR_BIT = 9,
	NETIF_MSG_TX_DONE_BIT = 10,
	NETIF_MSG_RX_STATUS_BIT = 11,
	NETIF_MSG_PKTDATA_BIT = 12,
	NETIF_MSG_HW_BIT = 13,
	NETIF_MSG_WOL_BIT = 14,
	NETIF_MSG_CLASS_COUNT = 15,
};

enum {
	NETLINK_DIAG_MEMINFO = 0,
	NETLINK_DIAG_GROUPS = 1,
	NETLINK_DIAG_RX_RING = 2,
	NETLINK_DIAG_TX_RING = 3,
	NETLINK_DIAG_FLAGS = 4,
	__NETLINK_DIAG_MAX = 5,
};

enum {
	NETLINK_F_KERNEL_SOCKET = 0,
	NETLINK_F_RECV_PKTINFO = 1,
	NETLINK_F_BROADCAST_SEND_ERROR = 2,
	NETLINK_F_RECV_NO_ENOBUFS = 3,
	NETLINK_F_LISTEN_ALL_NSID = 4,
	NETLINK_F_CAP_ACK = 5,
	NETLINK_F_EXT_ACK = 6,
	NETLINK_F_STRICT_CHK = 7,
};

enum {
	NETLINK_UNCONNECTED = 0,
	NETLINK_CONNECTED = 1,
};

enum {
	NETNSA_NONE = 0,
	NETNSA_NSID = 1,
	NETNSA_PID = 2,
	NETNSA_FD = 3,
	NETNSA_TARGET_NSID = 4,
	NETNSA_CURRENT_NSID = 5,
	__NETNSA_MAX = 6,
};

enum {
	NET_NS_INDEX = 0,
	UTS_NS_INDEX = 1,
	IPC_NS_INDEX = 2,
	PID_NS_INDEX = 3,
	USER_NS_INDEX = 4,
	MNT_NS_INDEX = 5,
	CGROUP_NS_INDEX = 6,
	NR_NAMESPACES = 7,
};

enum {
	NEXTHOP_GRP_TYPE_MPATH = 0,
	NEXTHOP_GRP_TYPE_RES = 1,
	__NEXTHOP_GRP_TYPE_MAX = 2,
};

enum {
	NFPROTO_UNSPEC = 0,
	NFPROTO_INET = 1,
	NFPROTO_IPV4 = 2,
	NFPROTO_ARP = 3,
	NFPROTO_NETDEV = 5,
	NFPROTO_BRIDGE = 7,
	NFPROTO_IPV6 = 10,
	NFPROTO_NUMPROTO = 11,
};

enum {
	NFSD4_ACTIVE = 0,
	NFSD4_COURTESY = 1,
	NFSD4_EXPIRABLE = 2,
};

enum {
	NFSD_A_POOL_MODE_MODE = 1,
	NFSD_A_POOL_MODE_NPOOLS = 2,
	__NFSD_A_POOL_MODE_MAX = 3,
	NFSD_A_POOL_MODE_MAX = 2,
};

enum {
	NFSD_A_RPC_STATUS_XID = 1,
	NFSD_A_RPC_STATUS_FLAGS = 2,
	NFSD_A_RPC_STATUS_PROG = 3,
	NFSD_A_RPC_STATUS_VERSION = 4,
	NFSD_A_RPC_STATUS_PROC = 5,
	NFSD_A_RPC_STATUS_SERVICE_TIME = 6,
	NFSD_A_RPC_STATUS_PAD = 7,
	NFSD_A_RPC_STATUS_SADDR4 = 8,
	NFSD_A_RPC_STATUS_DADDR4 = 9,
	NFSD_A_RPC_STATUS_SADDR6 = 10,
	NFSD_A_RPC_STATUS_DADDR6 = 11,
	NFSD_A_RPC_STATUS_SPORT = 12,
	NFSD_A_RPC_STATUS_DPORT = 13,
	NFSD_A_RPC_STATUS_COMPOUND_OPS = 14,
	__NFSD_A_RPC_STATUS_MAX = 15,
	NFSD_A_RPC_STATUS_MAX = 14,
};

enum {
	NFSD_A_SERVER_PROTO_VERSION = 1,
	__NFSD_A_SERVER_PROTO_MAX = 2,
	NFSD_A_SERVER_PROTO_MAX = 1,
};

enum {
	NFSD_A_SERVER_SOCK_ADDR = 1,
	__NFSD_A_SERVER_SOCK_MAX = 2,
	NFSD_A_SERVER_SOCK_MAX = 1,
};

enum {
	NFSD_A_SERVER_THREADS = 1,
	NFSD_A_SERVER_GRACETIME = 2,
	NFSD_A_SERVER_LEASETIME = 3,
	NFSD_A_SERVER_SCOPE = 4,
	__NFSD_A_SERVER_MAX = 5,
	NFSD_A_SERVER_MAX = 4,
};

enum {
	NFSD_A_SOCK_ADDR = 1,
	NFSD_A_SOCK_TRANSPORT_NAME = 2,
	__NFSD_A_SOCK_MAX = 3,
	NFSD_A_SOCK_MAX = 2,
};

enum {
	NFSD_A_VERSION_MAJOR = 1,
	NFSD_A_VERSION_MINOR = 2,
	NFSD_A_VERSION_ENABLED = 3,
	__NFSD_A_VERSION_MAX = 4,
	NFSD_A_VERSION_MAX = 3,
};

enum {
	NFSD_CMD_RPC_STATUS_GET = 1,
	NFSD_CMD_THREADS_SET = 2,
	NFSD_CMD_THREADS_GET = 3,
	NFSD_CMD_VERSION_SET = 4,
	NFSD_CMD_VERSION_GET = 5,
	NFSD_CMD_LISTENER_SET = 6,
	NFSD_CMD_LISTENER_GET = 7,
	NFSD_CMD_POOL_MODE_SET = 8,
	NFSD_CMD_POOL_MODE_GET = 9,
	__NFSD_CMD_MAX = 10,
	NFSD_CMD_MAX = 9,
};

enum {
	NFSD_Root = 1,
	NFSD_List = 2,
	NFSD_Export_Stats = 3,
	NFSD_Export_features = 4,
	NFSD_Fh = 5,
	NFSD_FO_UnlockIP = 6,
	NFSD_FO_UnlockFS = 7,
	NFSD_Threads = 8,
	NFSD_Pool_Threads = 9,
	NFSD_Pool_Stats = 10,
	NFSD_Reply_Cache_Stats = 11,
	NFSD_Versions = 12,
	NFSD_Ports = 13,
	NFSD_MaxBlkSize = 14,
	NFSD_Filecache = 15,
	NFSD_Leasetime = 16,
	NFSD_Gracetime = 17,
	NFSD_RecoveryDir = 18,
	NFSD_V4EndGrace = 19,
	NFSD_MaxReserved = 20,
};

enum {
	NFSD_STATS_PAYLOAD_MISSES = 0,
	NFSD_STATS_DRC_MEM_USAGE = 1,
	NFSD_STATS_RC_HITS = 2,
	NFSD_STATS_RC_MISSES = 3,
	NFSD_STATS_RC_NOCACHE = 4,
	NFSD_STATS_FH_STALE = 5,
	NFSD_STATS_IO_READ = 6,
	NFSD_STATS_IO_WRITE = 7,
	NFSD_STATS_FIRST_NFS4_OP = 8,
	NFSD_STATS_LAST_NFS4_OP = 83,
	NFSD_STATS_WDELEG_GETATTR = 84,
	NFSD_STATS_COUNTERS_NUM = 85,
};

enum {
	NFSERR_DROPIT = 10097,
	NFSERR_EOF = 10098,
	NFSERR_REPLAY_ME = 10099,
	NFSERR_REPLAY_CACHE = 10100,
	NFSERR_SYMLINK_NOT_DIR = 10101,
};

enum {
	NFSPROC4_CLNT_NULL = 0,
	NFSPROC4_CLNT_READ = 1,
	NFSPROC4_CLNT_WRITE = 2,
	NFSPROC4_CLNT_COMMIT = 3,
	NFSPROC4_CLNT_OPEN = 4,
	NFSPROC4_CLNT_OPEN_CONFIRM = 5,
	NFSPROC4_CLNT_OPEN_NOATTR = 6,
	NFSPROC4_CLNT_OPEN_DOWNGRADE = 7,
	NFSPROC4_CLNT_CLOSE = 8,
	NFSPROC4_CLNT_SETATTR = 9,
	NFSPROC4_CLNT_FSINFO = 10,
	NFSPROC4_CLNT_RENEW = 11,
	NFSPROC4_CLNT_SETCLIENTID = 12,
	NFSPROC4_CLNT_SETCLIENTID_CONFIRM = 13,
	NFSPROC4_CLNT_LOCK = 14,
	NFSPROC4_CLNT_LOCKT = 15,
	NFSPROC4_CLNT_LOCKU = 16,
	NFSPROC4_CLNT_ACCESS = 17,
	NFSPROC4_CLNT_GETATTR = 18,
	NFSPROC4_CLNT_LOOKUP = 19,
	NFSPROC4_CLNT_LOOKUP_ROOT = 20,
	NFSPROC4_CLNT_REMOVE = 21,
	NFSPROC4_CLNT_RENAME = 22,
	NFSPROC4_CLNT_LINK = 23,
	NFSPROC4_CLNT_SYMLINK = 24,
	NFSPROC4_CLNT_CREATE = 25,
	NFSPROC4_CLNT_PATHCONF = 26,
	NFSPROC4_CLNT_STATFS = 27,
	NFSPROC4_CLNT_READLINK = 28,
	NFSPROC4_CLNT_READDIR = 29,
	NFSPROC4_CLNT_SERVER_CAPS = 30,
	NFSPROC4_CLNT_DELEGRETURN = 31,
	NFSPROC4_CLNT_GETACL = 32,
	NFSPROC4_CLNT_SETACL = 33,
	NFSPROC4_CLNT_FS_LOCATIONS = 34,
	NFSPROC4_CLNT_RELEASE_LOCKOWNER = 35,
	NFSPROC4_CLNT_SECINFO = 36,
	NFSPROC4_CLNT_FSID_PRESENT = 37,
	NFSPROC4_CLNT_EXCHANGE_ID = 38,
	NFSPROC4_CLNT_CREATE_SESSION = 39,
	NFSPROC4_CLNT_DESTROY_SESSION = 40,
	NFSPROC4_CLNT_SEQUENCE = 41,
	NFSPROC4_CLNT_GET_LEASE_TIME = 42,
	NFSPROC4_CLNT_RECLAIM_COMPLETE = 43,
	NFSPROC4_CLNT_LAYOUTGET = 44,
	NFSPROC4_CLNT_GETDEVICEINFO = 45,
	NFSPROC4_CLNT_LAYOUTCOMMIT = 46,
	NFSPROC4_CLNT_LAYOUTRETURN = 47,
	NFSPROC4_CLNT_SECINFO_NO_NAME = 48,
	NFSPROC4_CLNT_TEST_STATEID = 49,
	NFSPROC4_CLNT_FREE_STATEID = 50,
	NFSPROC4_CLNT_GETDEVICELIST = 51,
	NFSPROC4_CLNT_BIND_CONN_TO_SESSION = 52,
	NFSPROC4_CLNT_DESTROY_CLIENTID = 53,
	NFSPROC4_CLNT_SEEK = 54,
	NFSPROC4_CLNT_ALLOCATE = 55,
	NFSPROC4_CLNT_DEALLOCATE = 56,
	NFSPROC4_CLNT_LAYOUTSTATS = 57,
	NFSPROC4_CLNT_CLONE = 58,
	NFSPROC4_CLNT_COPY = 59,
	NFSPROC4_CLNT_OFFLOAD_CANCEL = 60,
	NFSPROC4_CLNT_LOOKUPP = 61,
	NFSPROC4_CLNT_LAYOUTERROR = 62,
	NFSPROC4_CLNT_COPY_NOTIFY = 63,
	NFSPROC4_CLNT_GETXATTR = 64,
	NFSPROC4_CLNT_SETXATTR = 65,
	NFSPROC4_CLNT_LISTXATTRS = 66,
	NFSPROC4_CLNT_REMOVEXATTR = 67,
	NFSPROC4_CLNT_READ_PLUS = 68,
};

enum {
	NFS_DELEGATION_NEED_RECLAIM = 0,
	NFS_DELEGATION_RETURN = 1,
	NFS_DELEGATION_RETURN_IF_CLOSED = 2,
	NFS_DELEGATION_REFERENCED = 3,
	NFS_DELEGATION_RETURNING = 4,
	NFS_DELEGATION_REVOKED = 5,
	NFS_DELEGATION_TEST_EXPIRED = 6,
	NFS_DELEGATION_INODE_FREEING = 7,
	NFS_DELEGATION_RETURN_DELAYED = 8,
	NFS_DELEGATION_DELEGTIME = 9,
};

enum {
	NFS_DEVICEID_INVALID = 0,
	NFS_DEVICEID_UNAVAILABLE = 1,
	NFS_DEVICEID_NOCACHE = 2,
};

enum {
	NFS_IOHDR_ERROR = 0,
	NFS_IOHDR_EOF = 1,
	NFS_IOHDR_REDO = 2,
	NFS_IOHDR_STAT = 3,
	NFS_IOHDR_RESEND_PNFS = 4,
	NFS_IOHDR_RESEND_MDS = 5,
	NFS_IOHDR_UNSTABLE_WRITES = 6,
	NFS_IOHDR_ODIRECT = 7,
};

enum {
	NFS_LAYOUT_RO_FAILED = 0,
	NFS_LAYOUT_RW_FAILED = 1,
	NFS_LAYOUT_BULK_RECALL = 2,
	NFS_LAYOUT_RETURN = 3,
	NFS_LAYOUT_RETURN_LOCK = 4,
	NFS_LAYOUT_RETURN_REQUESTED = 5,
	NFS_LAYOUT_INVALID_STID = 6,
	NFS_LAYOUT_FIRST_LAYOUTGET = 7,
	NFS_LAYOUT_INODE_FREEING = 8,
	NFS_LAYOUT_HASHED = 9,
	NFS_LAYOUT_DRAIN = 10,
};

enum {
	NFS_LSEG_VALID = 0,
	NFS_LSEG_ROC = 1,
	NFS_LSEG_LAYOUTCOMMIT = 2,
	NFS_LSEG_LAYOUTRETURN = 3,
	NFS_LSEG_UNAVAILABLE = 4,
};

enum {
	NFS_OWNER_RECLAIM_REBOOT = 0,
	NFS_OWNER_RECLAIM_NOGRACE = 1,
};

enum {
	NHA_GROUP_STATS_ENTRY_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY_ID = 1,
	NHA_GROUP_STATS_ENTRY_PACKETS = 2,
	NHA_GROUP_STATS_ENTRY_PACKETS_HW = 3,
	__NHA_GROUP_STATS_ENTRY_MAX = 4,
};

enum {
	NHA_GROUP_STATS_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY = 1,
	__NHA_GROUP_STATS_MAX = 2,
};

enum {
	NHA_RES_BUCKET_UNSPEC = 0,
	NHA_RES_BUCKET_PAD = 0,
	NHA_RES_BUCKET_INDEX = 1,
	NHA_RES_BUCKET_IDLE_TIME = 2,
	NHA_RES_BUCKET_NH_ID = 3,
	__NHA_RES_BUCKET_MAX = 4,
};

enum {
	NHA_RES_GROUP_UNSPEC = 0,
	NHA_RES_GROUP_PAD = 0,
	NHA_RES_GROUP_BUCKETS = 1,
	NHA_RES_GROUP_IDLE_TIMER = 2,
	NHA_RES_GROUP_UNBALANCED_TIMER = 3,
	NHA_RES_GROUP_UNBALANCED_TIME = 4,
	__NHA_RES_GROUP_MAX = 5,
};

enum {
	NHA_UNSPEC = 0,
	NHA_ID = 1,
	NHA_GROUP = 2,
	NHA_GROUP_TYPE = 3,
	NHA_BLACKHOLE = 4,
	NHA_OIF = 5,
	NHA_GATEWAY = 6,
	NHA_ENCAP_TYPE = 7,
	NHA_ENCAP = 8,
	NHA_GROUPS = 9,
	NHA_MASTER = 10,
	NHA_FDB = 11,
	NHA_RES_GROUP = 12,
	NHA_RES_BUCKET = 13,
	NHA_OP_FLAGS = 14,
	NHA_GROUP_STATS = 15,
	NHA_HW_STATS_ENABLE = 16,
	NHA_HW_STATS_USED = 17,
	__NHA_MAX = 18,
};

enum {
	NHLT_CONFIG_TYPE_GENERIC = 0,
	NHLT_CONFIG_TYPE_MIC_ARRAY = 1,
};

enum {
	NHLT_MIC_ARRAY_2CH_SMALL = 10,
	NHLT_MIC_ARRAY_2CH_BIG = 11,
	NHLT_MIC_ARRAY_4CH_1ST_GEOM = 12,
	NHLT_MIC_ARRAY_4CH_L_SHAPED = 13,
	NHLT_MIC_ARRAY_4CH_2ND_GEOM = 14,
	NHLT_MIC_ARRAY_VENDOR_DEFINED = 15,
};

enum {
	NID_PATH_VOL_CTL = 0,
	NID_PATH_MUTE_CTL = 1,
	NID_PATH_BOOST_CTL = 2,
	NID_PATH_NUM_CTLS = 3,
};

enum {
	NLA_UNSPEC = 0,
	NLA_U8 = 1,
	NLA_U16 = 2,
	NLA_U32 = 3,
	NLA_U64 = 4,
	NLA_STRING = 5,
	NLA_FLAG = 6,
	NLA_MSECS = 7,
	NLA_NESTED = 8,
	NLA_NESTED_ARRAY = 9,
	NLA_NUL_STRING = 10,
	NLA_BINARY = 11,
	NLA_S8 = 12,
	NLA_S16 = 13,
	NLA_S32 = 14,
	NLA_S64 = 15,
	NLA_BITFIELD32 = 16,
	NLA_REJECT = 17,
	NLA_BE16 = 18,
	NLA_BE32 = 19,
	NLA_SINT = 20,
	NLA_UINT = 21,
	__NLA_TYPE_MAX = 22,
};

enum {
	NLM_LCK_GRANTED = 0,
	NLM_LCK_DENIED = 1,
	NLM_LCK_DENIED_NOLOCKS = 2,
	NLM_LCK_BLOCKED = 3,
	NLM_LCK_DENIED_GRACE_PERIOD = 4,
	NLM_DEADLCK = 5,
	NLM_ROFS = 6,
	NLM_STALE_FH = 7,
	NLM_FBIG = 8,
	NLM_FAILED = 9,
};

enum {
	NODE_SIZE = 256,
	KEYS_PER_NODE = 16,
	RECS_PER_LEAF = 15,
};

enum {
	NSMPROC_NULL = 0,
	NSMPROC_STAT = 1,
	NSMPROC_MON = 2,
	NSMPROC_UNMON = 3,
	NSMPROC_UNMON_ALL = 4,
	NSMPROC_SIMU_CRASH = 5,
	NSMPROC_NOTIFY = 6,
};

enum {
	NUM_TRIAL_SAMPLES = 8192,
	MAX_SAMPLES_PER_BIT = 16,
};

enum {
	NVMEM_ADD = 1,
	NVMEM_REMOVE = 2,
	NVMEM_CELL_ADD = 3,
	NVMEM_CELL_REMOVE = 4,
	NVMEM_LAYOUT_ADD = 5,
	NVMEM_LAYOUT_REMOVE = 6,
};

enum {
	NVME_AEN_BIT_NS_ATTR = 8,
	NVME_AEN_BIT_FW_ACT = 9,
	NVME_AEN_BIT_ANA_CHANGE = 11,
	NVME_AEN_BIT_DISC_CHANGE = 31,
};

enum {
	NVME_AEN_CFG_NS_ATTR = 256,
	NVME_AEN_CFG_FW_ACT = 512,
	NVME_AEN_CFG_ANA_CHANGE = 2048,
	NVME_AEN_CFG_DISC_CHANGE = -2147483648,
};

enum {
	NVME_AER_ERROR = 0,
	NVME_AER_SMART = 1,
	NVME_AER_NOTICE = 2,
	NVME_AER_CSS = 6,
	NVME_AER_VS = 7,
};

enum {
	NVME_AER_ERROR_PERSIST_INT_ERR = 3,
};

enum {
	NVME_AER_NOTICE_NS_CHANGED = 0,
	NVME_AER_NOTICE_FW_ACT_STARTING = 1,
	NVME_AER_NOTICE_ANA = 3,
	NVME_AER_NOTICE_DISC_CHANGED = 240,
};

enum {
	NVME_CAP_CRMS_CRWMS = 576460752303423488ULL,
	NVME_CAP_CRMS_CRIMS = 1152921504606846976ULL,
};

enum {
	NVME_CAP_CSS_NVM = 1,
	NVME_CAP_CSS_CSI = 64,
};

enum {
	NVME_CC_ENABLE = 1,
	NVME_CC_EN_SHIFT = 0,
	NVME_CC_CSS_SHIFT = 4,
	NVME_CC_CSS_MASK = 112,
	NVME_CC_CSS_NVM = 0,
	NVME_CC_CSS_CSI = 96,
	NVME_CC_MPS_SHIFT = 7,
	NVME_CC_MPS_MASK = 1920,
	NVME_CC_AMS_SHIFT = 11,
	NVME_CC_AMS_MASK = 14336,
	NVME_CC_AMS_RR = 0,
	NVME_CC_AMS_WRRU = 2048,
	NVME_CC_AMS_VS = 14336,
	NVME_CC_SHN_SHIFT = 14,
	NVME_CC_SHN_MASK = 49152,
	NVME_CC_SHN_NONE = 0,
	NVME_CC_SHN_NORMAL = 16384,
	NVME_CC_SHN_ABRUPT = 32768,
	NVME_CC_IOSQES_SHIFT = 16,
	NVME_CC_IOSQES_MASK = 983040,
	NVME_CC_IOSQES = 393216,
	NVME_CC_IOCQES_SHIFT = 20,
	NVME_CC_IOCQES_MASK = 15728640,
	NVME_CC_IOCQES = 4194304,
	NVME_CC_CRIME = 16777216,
};

enum {
	NVME_CMBMSC_CRE = 1,
	NVME_CMBMSC_CMSE = 2,
};

enum {
	NVME_CMBSZ_SQS = 1,
	NVME_CMBSZ_CQS = 2,
	NVME_CMBSZ_LISTS = 4,
	NVME_CMBSZ_RDS = 8,
	NVME_CMBSZ_WDS = 16,
	NVME_CMBSZ_SZ_SHIFT = 12,
	NVME_CMBSZ_SZ_MASK = 1048575,
	NVME_CMBSZ_SZU_SHIFT = 8,
	NVME_CMBSZ_SZU_MASK = 15,
};

enum {
	NVME_CMD_EFFECTS_CSUPP = 1,
	NVME_CMD_EFFECTS_LBCC = 2,
	NVME_CMD_EFFECTS_NCC = 4,
	NVME_CMD_EFFECTS_NIC = 8,
	NVME_CMD_EFFECTS_CCC = 16,
	NVME_CMD_EFFECTS_CSER_MASK = 49152,
	NVME_CMD_EFFECTS_CSE_MASK = 458752,
	NVME_CMD_EFFECTS_UUID_SEL = 524288,
	NVME_CMD_EFFECTS_SCOPE_MASK = 4293918720,
};

enum {
	NVME_CMD_FUSE_FIRST = 1,
	NVME_CMD_FUSE_SECOND = 2,
	NVME_CMD_SGL_METABUF = 64,
	NVME_CMD_SGL_METASEG = 128,
	NVME_CMD_SGL_ALL = 192,
};

enum {
	NVME_CSI_NVM = 0,
	NVME_CSI_ZNS = 2,
};

enum {
	NVME_CSTS_RDY = 1,
	NVME_CSTS_CFS = 2,
	NVME_CSTS_NSSRO = 16,
	NVME_CSTS_PP = 32,
	NVME_CSTS_SHST_NORMAL = 0,
	NVME_CSTS_SHST_OCCUR = 4,
	NVME_CSTS_SHST_CMPLT = 8,
	NVME_CSTS_SHST_MASK = 12,
};

enum {
	NVME_CTRL_CMIC_MULTI_PORT = 1,
	NVME_CTRL_CMIC_MULTI_CTRL = 2,
	NVME_CTRL_CMIC_ANA = 8,
	NVME_CTRL_ONCS_COMPARE = 1,
	NVME_CTRL_ONCS_WRITE_UNCORRECTABLE = 2,
	NVME_CTRL_ONCS_DSM = 4,
	NVME_CTRL_ONCS_WRITE_ZEROES = 8,
	NVME_CTRL_ONCS_RESERVATIONS = 32,
	NVME_CTRL_ONCS_TIMESTAMP = 64,
	NVME_CTRL_VWC_PRESENT = 1,
	NVME_CTRL_OACS_SEC_SUPP = 1,
	NVME_CTRL_OACS_NS_MNGT_SUPP = 8,
	NVME_CTRL_OACS_DIRECTIVES = 32,
	NVME_CTRL_OACS_DBBUF_SUPP = 256,
	NVME_CTRL_LPA_CMD_EFFECTS_LOG = 2,
	NVME_CTRL_CTRATT_128_ID = 1,
	NVME_CTRL_CTRATT_NON_OP_PSP = 2,
	NVME_CTRL_CTRATT_NVM_SETS = 4,
	NVME_CTRL_CTRATT_READ_RECV_LVLS = 8,
	NVME_CTRL_CTRATT_ENDURANCE_GROUPS = 16,
	NVME_CTRL_CTRATT_PREDICTABLE_LAT = 32,
	NVME_CTRL_CTRATT_NAMESPACE_GRANULARITY = 128,
	NVME_CTRL_CTRATT_UUID_LIST = 512,
	NVME_CTRL_SGLS_BYTE_ALIGNED = 1,
	NVME_CTRL_SGLS_DWORD_ALIGNED = 2,
	NVME_CTRL_SGLS_KSDBDS = 4,
	NVME_CTRL_SGLS_MSDS = 524288,
	NVME_CTRL_SGLS_SAOS = 1048576,
};

enum {
	NVME_DSMGMT_IDR = 1,
	NVME_DSMGMT_IDW = 2,
	NVME_DSMGMT_AD = 4,
};

enum {
	NVME_ENABLE_ACRE = 1,
	NVME_ENABLE_LBAFEE = 1,
};

enum {
	NVME_HOST_MEM_ENABLE = 1,
	NVME_HOST_MEM_RETURN = 2,
};

enum {
	NVME_ID_CNS_NS = 0,
	NVME_ID_CNS_CTRL = 1,
	NVME_ID_CNS_NS_ACTIVE_LIST = 2,
	NVME_ID_CNS_NS_DESC_LIST = 3,
	NVME_ID_CNS_CS_NS = 5,
	NVME_ID_CNS_CS_CTRL = 6,
	NVME_ID_CNS_NS_ACTIVE_LIST_CS = 7,
	NVME_ID_CNS_NS_CS_INDEP = 8,
	NVME_ID_CNS_NS_PRESENT_LIST = 16,
	NVME_ID_CNS_NS_PRESENT = 17,
	NVME_ID_CNS_CTRL_NS_LIST = 18,
	NVME_ID_CNS_CTRL_LIST = 19,
	NVME_ID_CNS_SCNDRY_CTRL_LIST = 21,
	NVME_ID_CNS_NS_GRANULARITY = 22,
	NVME_ID_CNS_UUID_LIST = 23,
	NVME_ID_CNS_ENDGRP_LIST = 25,
};

enum {
	NVME_ID_NS_NVM_STS_MASK = 127,
	NVME_ID_NS_NVM_GUARD_SHIFT = 7,
	NVME_ID_NS_NVM_GUARD_MASK = 3,
	NVME_ID_NS_NVM_QPIF_SHIFT = 9,
	NVME_ID_NS_NVM_QPIF_MASK = 15,
	NVME_ID_NS_NVM_QPIFS = 8,
};

enum {
	NVME_IOCTL_VEC = 1,
	NVME_IOCTL_PARTITION = 2,
};

enum {
	NVME_NIDT_EUI64 = 1,
	NVME_NIDT_NGUID = 2,
	NVME_NIDT_UUID = 3,
	NVME_NIDT_CSI = 4,
};

enum {
	NVME_NSTAT_NRDY = 1,
};

enum {
	NVME_NS_FEAT_THIN = 1,
	NVME_NS_FEAT_ATOMICS = 2,
	NVME_NS_FEAT_IO_OPT = 16,
	NVME_NS_ATTR_RO = 1,
	NVME_NS_FLBAS_LBA_MASK = 15,
	NVME_NS_FLBAS_LBA_UMASK = 96,
	NVME_NS_FLBAS_LBA_SHIFT = 1,
	NVME_NS_FLBAS_META_EXT = 16,
	NVME_NS_NMIC_SHARED = 1,
	NVME_NS_ROTATIONAL = 16,
	NVME_NS_VWC_NOT_PRESENT = 32,
	NVME_LBAF_RP_BEST = 0,
	NVME_LBAF_RP_BETTER = 1,
	NVME_LBAF_RP_GOOD = 2,
	NVME_LBAF_RP_DEGRADED = 3,
	NVME_NS_DPC_PI_LAST = 16,
	NVME_NS_DPC_PI_FIRST = 8,
	NVME_NS_DPC_PI_TYPE3 = 4,
	NVME_NS_DPC_PI_TYPE2 = 2,
	NVME_NS_DPC_PI_TYPE1 = 1,
	NVME_NS_DPS_PI_FIRST = 8,
	NVME_NS_DPS_PI_MASK = 7,
	NVME_NS_DPS_PI_TYPE1 = 1,
	NVME_NS_DPS_PI_TYPE2 = 2,
	NVME_NS_DPS_PI_TYPE3 = 3,
};

enum {
	NVME_NVM_NS_16B_GUARD = 0,
	NVME_NVM_NS_32B_GUARD = 1,
	NVME_NVM_NS_64B_GUARD = 2,
	NVME_NVM_NS_QTYPE_GUARD = 3,
};

enum {
	NVME_PS_FLAGS_MAX_POWER_SCALE = 1,
	NVME_PS_FLAGS_NON_OP_STATE = 2,
};

enum {
	NVME_QUEUE_PHYS_CONTIG = 1,
	NVME_CQ_IRQ_ENABLED = 2,
	NVME_SQ_PRIO_URGENT = 0,
	NVME_SQ_PRIO_HIGH = 2,
	NVME_SQ_PRIO_MEDIUM = 4,
	NVME_SQ_PRIO_LOW = 6,
	NVME_FEAT_ARBITRATION = 1,
	NVME_FEAT_POWER_MGMT = 2,
	NVME_FEAT_LBA_RANGE = 3,
	NVME_FEAT_TEMP_THRESH = 4,
	NVME_FEAT_ERR_RECOVERY = 5,
	NVME_FEAT_VOLATILE_WC = 6,
	NVME_FEAT_NUM_QUEUES = 7,
	NVME_FEAT_IRQ_COALESCE = 8,
	NVME_FEAT_IRQ_CONFIG = 9,
	NVME_FEAT_WRITE_ATOMIC = 10,
	NVME_FEAT_ASYNC_EVENT = 11,
	NVME_FEAT_AUTO_PST = 12,
	NVME_FEAT_HOST_MEM_BUF = 13,
	NVME_FEAT_TIMESTAMP = 14,
	NVME_FEAT_KATO = 15,
	NVME_FEAT_HCTM = 16,
	NVME_FEAT_NOPSC = 17,
	NVME_FEAT_RRL = 18,
	NVME_FEAT_PLM_CONFIG = 19,
	NVME_FEAT_PLM_WINDOW = 20,
	NVME_FEAT_HOST_BEHAVIOR = 22,
	NVME_FEAT_SANITIZE = 23,
	NVME_FEAT_SW_PROGRESS = 128,
	NVME_FEAT_HOST_ID = 129,
	NVME_FEAT_RESV_MASK = 130,
	NVME_FEAT_RESV_PERSIST = 131,
	NVME_FEAT_WRITE_PROTECT = 132,
	NVME_FEAT_VENDOR_START = 192,
	NVME_FEAT_VENDOR_END = 255,
	NVME_LOG_SUPPORTED = 0,
	NVME_LOG_ERROR = 1,
	NVME_LOG_SMART = 2,
	NVME_LOG_FW_SLOT = 3,
	NVME_LOG_CHANGED_NS = 4,
	NVME_LOG_CMD_EFFECTS = 5,
	NVME_LOG_DEVICE_SELF_TEST = 6,
	NVME_LOG_TELEMETRY_HOST = 7,
	NVME_LOG_TELEMETRY_CTRL = 8,
	NVME_LOG_ENDURANCE_GROUP = 9,
	NVME_LOG_ANA = 12,
	NVME_LOG_FEATURES = 18,
	NVME_LOG_RMI = 22,
	NVME_LOG_DISC = 112,
	NVME_LOG_RESERVATION = 128,
	NVME_FWACT_REPL = 0,
	NVME_FWACT_REPL_ACTV = 8,
	NVME_FWACT_ACTV = 16,
};

enum {
	NVME_REG_CAP = 0,
	NVME_REG_VS = 8,
	NVME_REG_INTMS = 12,
	NVME_REG_INTMC = 16,
	NVME_REG_CC = 20,
	NVME_REG_CSTS = 28,
	NVME_REG_NSSR = 32,
	NVME_REG_AQA = 36,
	NVME_REG_ASQ = 40,
	NVME_REG_ACQ = 48,
	NVME_REG_CMBLOC = 56,
	NVME_REG_CMBSZ = 60,
	NVME_REG_BPINFO = 64,
	NVME_REG_BPRSEL = 68,
	NVME_REG_BPMBL = 72,
	NVME_REG_CMBMSC = 80,
	NVME_REG_CRTO = 104,
	NVME_REG_PMRCAP = 3584,
	NVME_REG_PMRCTL = 3588,
	NVME_REG_PMRSTS = 3592,
	NVME_REG_PMREBS = 3596,
	NVME_REG_PMRSWTP = 3600,
	NVME_REG_DBS = 4096,
};

enum {
	NVME_REQ_CANCELLED = 1,
	NVME_REQ_USERCMD = 2,
	NVME_MPATH_IO_STATS = 4,
	NVME_MPATH_CNT_ACTIVE = 8,
};

enum {
	NVME_RW_LR = 32768,
	NVME_RW_FUA = 16384,
	NVME_RW_APPEND_PIREMAP = 512,
	NVME_RW_DSM_FREQ_UNSPEC = 0,
	NVME_RW_DSM_FREQ_TYPICAL = 1,
	NVME_RW_DSM_FREQ_RARE = 2,
	NVME_RW_DSM_FREQ_READS = 3,
	NVME_RW_DSM_FREQ_WRITES = 4,
	NVME_RW_DSM_FREQ_RW = 5,
	NVME_RW_DSM_FREQ_ONCE = 6,
	NVME_RW_DSM_FREQ_PREFETCH = 7,
	NVME_RW_DSM_FREQ_TEMP = 8,
	NVME_RW_DSM_LATENCY_NONE = 0,
	NVME_RW_DSM_LATENCY_IDLE = 16,
	NVME_RW_DSM_LATENCY_NORM = 32,
	NVME_RW_DSM_LATENCY_LOW = 48,
	NVME_RW_DSM_SEQ_REQ = 64,
	NVME_RW_DSM_COMPRESSED = 128,
	NVME_RW_PRINFO_PRCHK_REF = 1024,
	NVME_RW_PRINFO_PRCHK_APP = 2048,
	NVME_RW_PRINFO_PRCHK_GUARD = 4096,
	NVME_RW_PRINFO_PRACT = 8192,
	NVME_RW_DTYPE_STREAMS = 16,
	NVME_WZ_DEAC = 512,
};

enum {
	NVME_SCT_GENERIC = 0,
	NVME_SC_SUCCESS = 0,
	NVME_SC_INVALID_OPCODE = 1,
	NVME_SC_INVALID_FIELD = 2,
	NVME_SC_CMDID_CONFLICT = 3,
	NVME_SC_DATA_XFER_ERROR = 4,
	NVME_SC_POWER_LOSS = 5,
	NVME_SC_INTERNAL = 6,
	NVME_SC_ABORT_REQ = 7,
	NVME_SC_ABORT_QUEUE = 8,
	NVME_SC_FUSED_FAIL = 9,
	NVME_SC_FUSED_MISSING = 10,
	NVME_SC_INVALID_NS = 11,
	NVME_SC_CMD_SEQ_ERROR = 12,
	NVME_SC_SGL_INVALID_LAST = 13,
	NVME_SC_SGL_INVALID_COUNT = 14,
	NVME_SC_SGL_INVALID_DATA = 15,
	NVME_SC_SGL_INVALID_METADATA = 16,
	NVME_SC_SGL_INVALID_TYPE = 17,
	NVME_SC_CMB_INVALID_USE = 18,
	NVME_SC_PRP_INVALID_OFFSET = 19,
	NVME_SC_ATOMIC_WU_EXCEEDED = 20,
	NVME_SC_OP_DENIED = 21,
	NVME_SC_SGL_INVALID_OFFSET = 22,
	NVME_SC_RESERVED = 23,
	NVME_SC_HOST_ID_INCONSIST = 24,
	NVME_SC_KA_TIMEOUT_EXPIRED = 25,
	NVME_SC_KA_TIMEOUT_INVALID = 26,
	NVME_SC_ABORTED_PREEMPT_ABORT = 27,
	NVME_SC_SANITIZE_FAILED = 28,
	NVME_SC_SANITIZE_IN_PROGRESS = 29,
	NVME_SC_SGL_INVALID_GRANULARITY = 30,
	NVME_SC_CMD_NOT_SUP_CMB_QUEUE = 31,
	NVME_SC_NS_WRITE_PROTECTED = 32,
	NVME_SC_CMD_INTERRUPTED = 33,
	NVME_SC_TRANSIENT_TR_ERR = 34,
	NVME_SC_ADMIN_COMMAND_MEDIA_NOT_READY = 36,
	NVME_SC_INVALID_IO_CMD_SET = 44,
	NVME_SC_LBA_RANGE = 128,
	NVME_SC_CAP_EXCEEDED = 129,
	NVME_SC_NS_NOT_READY = 130,
	NVME_SC_RESERVATION_CONFLICT = 131,
	NVME_SC_FORMAT_IN_PROGRESS = 132,
	NVME_SCT_COMMAND_SPECIFIC = 256,
	NVME_SC_CQ_INVALID = 256,
	NVME_SC_QID_INVALID = 257,
	NVME_SC_QUEUE_SIZE = 258,
	NVME_SC_ABORT_LIMIT = 259,
	NVME_SC_ABORT_MISSING = 260,
	NVME_SC_ASYNC_LIMIT = 261,
	NVME_SC_FIRMWARE_SLOT = 262,
	NVME_SC_FIRMWARE_IMAGE = 263,
	NVME_SC_INVALID_VECTOR = 264,
	NVME_SC_INVALID_LOG_PAGE = 265,
	NVME_SC_INVALID_FORMAT = 266,
	NVME_SC_FW_NEEDS_CONV_RESET = 267,
	NVME_SC_INVALID_QUEUE = 268,
	NVME_SC_FEATURE_NOT_SAVEABLE = 269,
	NVME_SC_FEATURE_NOT_CHANGEABLE = 270,
	NVME_SC_FEATURE_NOT_PER_NS = 271,
	NVME_SC_FW_NEEDS_SUBSYS_RESET = 272,
	NVME_SC_FW_NEEDS_RESET = 273,
	NVME_SC_FW_NEEDS_MAX_TIME = 274,
	NVME_SC_FW_ACTIVATE_PROHIBITED = 275,
	NVME_SC_OVERLAPPING_RANGE = 276,
	NVME_SC_NS_INSUFFICIENT_CAP = 277,
	NVME_SC_NS_ID_UNAVAILABLE = 278,
	NVME_SC_NS_ALREADY_ATTACHED = 280,
	NVME_SC_NS_IS_PRIVATE = 281,
	NVME_SC_NS_NOT_ATTACHED = 282,
	NVME_SC_THIN_PROV_NOT_SUPP = 283,
	NVME_SC_CTRL_LIST_INVALID = 284,
	NVME_SC_SELT_TEST_IN_PROGRESS = 285,
	NVME_SC_BP_WRITE_PROHIBITED = 286,
	NVME_SC_CTRL_ID_INVALID = 287,
	NVME_SC_SEC_CTRL_STATE_INVALID = 288,
	NVME_SC_CTRL_RES_NUM_INVALID = 289,
	NVME_SC_RES_ID_INVALID = 290,
	NVME_SC_PMR_SAN_PROHIBITED = 291,
	NVME_SC_ANA_GROUP_ID_INVALID = 292,
	NVME_SC_ANA_ATTACH_FAILED = 293,
	NVME_SC_BAD_ATTRIBUTES = 384,
	NVME_SC_INVALID_PI = 385,
	NVME_SC_READ_ONLY = 386,
	NVME_SC_ONCS_NOT_SUPPORTED = 387,
	NVME_SC_CONNECT_FORMAT = 384,
	NVME_SC_CONNECT_CTRL_BUSY = 385,
	NVME_SC_CONNECT_INVALID_PARAM = 386,
	NVME_SC_CONNECT_RESTART_DISC = 387,
	NVME_SC_CONNECT_INVALID_HOST = 388,
	NVME_SC_DISCOVERY_RESTART = 400,
	NVME_SC_AUTH_REQUIRED = 401,
	NVME_SC_ZONE_BOUNDARY_ERROR = 440,
	NVME_SC_ZONE_FULL = 441,
	NVME_SC_ZONE_READ_ONLY = 442,
	NVME_SC_ZONE_OFFLINE = 443,
	NVME_SC_ZONE_INVALID_WRITE = 444,
	NVME_SC_ZONE_TOO_MANY_ACTIVE = 445,
	NVME_SC_ZONE_TOO_MANY_OPEN = 446,
	NVME_SC_ZONE_INVALID_TRANSITION = 447,
	NVME_SCT_MEDIA_ERROR = 512,
	NVME_SC_WRITE_FAULT = 640,
	NVME_SC_READ_ERROR = 641,
	NVME_SC_GUARD_CHECK = 642,
	NVME_SC_APPTAG_CHECK = 643,
	NVME_SC_REFTAG_CHECK = 644,
	NVME_SC_COMPARE_FAILED = 645,
	NVME_SC_ACCESS_DENIED = 646,
	NVME_SC_UNWRITTEN_BLOCK = 647,
	NVME_SCT_PATH = 768,
	NVME_SC_INTERNAL_PATH_ERROR = 768,
	NVME_SC_ANA_PERSISTENT_LOSS = 769,
	NVME_SC_ANA_INACCESSIBLE = 770,
	NVME_SC_ANA_TRANSITION = 771,
	NVME_SC_CTRL_PATH_ERROR = 864,
	NVME_SC_HOST_PATH_ERROR = 880,
	NVME_SC_HOST_ABORTED_CMD = 881,
	NVME_SC_MASK = 255,
	NVME_SCT_MASK = 1792,
	NVME_SCT_SC_MASK = 2047,
	NVME_STATUS_CRD = 6144,
	NVME_STATUS_MORE = 8192,
	NVME_STATUS_DNR = 16384,
};

enum {
	NVME_SGL_FMT_DATA_DESC = 0,
	NVME_SGL_FMT_SEG_DESC = 2,
	NVME_SGL_FMT_LAST_SEG_DESC = 3,
	NVME_KEY_SGL_FMT_DATA_DESC = 4,
	NVME_TRANSPORT_SGL_DATA_DESC = 5,
};

enum {
	NVME_SUBMIT_AT_HEAD = 1,
	NVME_SUBMIT_NOWAIT = 2,
	NVME_SUBMIT_RESERVED = 4,
	NVME_SUBMIT_RETRY = 8,
};

enum {
	NVME_ZONE_TYPE_SEQWRITE_REQ = 2,
};

enum {
	NVME_ZRA_ZONE_REPORT = 0,
	NVME_ZRASF_ZONE_REPORT_ALL = 0,
	NVME_ZRASF_ZONE_STATE_EMPTY = 1,
	NVME_ZRASF_ZONE_STATE_IMP_OPEN = 2,
	NVME_ZRASF_ZONE_STATE_EXP_OPEN = 3,
	NVME_ZRASF_ZONE_STATE_CLOSED = 4,
	NVME_ZRASF_ZONE_STATE_READONLY = 5,
	NVME_ZRASF_ZONE_STATE_FULL = 6,
	NVME_ZRASF_ZONE_STATE_OFFLINE = 7,
	NVME_REPORT_ZONE_PARTIAL = 1,
};

enum {
	ODP_NOT_NEEDED = 0,
	ODP_ZEROBASED = 1,
	ODP_VIRTUAL = 2,
};

enum {
	OD_NORMAL_SAMPLE = 0,
	OD_SUB_SAMPLE = 1,
};

enum {
	ONLINE_POLICY_CONTIG_ZONES = 0,
	ONLINE_POLICY_AUTO_MOVABLE = 1,
};

enum {
	OPEN4_RESULT_NO_OPEN_STATEID = 16,
};

enum {
	OPEN4_SHARE_ACCESS_WANT_ANY_DELEG = 768,
};

enum {
	OPEN4_SHARE_ACCESS_WANT_CANCEL = 1280,
};

enum {
	OPEN4_SHARE_ACCESS_WANT_DELEG_TIMESTAMPS = 1048576,
};

enum {
	OPEN4_SHARE_ACCESS_WANT_NO_DELEG = 1024,
};

enum {
	OPEN4_SHARE_ACCESS_WANT_NO_PREFERENCE = 0,
};

enum {
	OPEN4_SHARE_ACCESS_WANT_OPEN_XOR_DELEGATION = 2097152,
};

enum {
	OPEN4_SHARE_ACCESS_WANT_READ_DELEG = 256,
};

enum {
	OPEN4_SHARE_ACCESS_WANT_WRITE_DELEG = 512,
};

enum {
	OPT_UID = 0,
	OPT_GID = 1,
	OPT_MODE = 2,
	OPT_DELEGATE_CMDS = 3,
	OPT_DELEGATE_MAPS = 4,
	OPT_DELEGATE_PROGS = 5,
	OPT_DELEGATE_ATTACHS = 6,
};

enum {
	OVERRIDE_NONE = 0,
	OVERRIDE_BASE = 1,
	OVERRIDE_STRIDE = 2,
	OVERRIDE_HEIGHT = 4,
	OVERRIDE_WIDTH = 8,
};

enum {
	OVL_REDIRECT_OFF = 0,
	OVL_REDIRECT_FOLLOW = 1,
	OVL_REDIRECT_NOFOLLOW = 2,
	OVL_REDIRECT_ON = 3,
};

enum {
	OVL_UUID_OFF = 0,
	OVL_UUID_NULL = 1,
	OVL_UUID_AUTO = 2,
	OVL_UUID_ON = 3,
};

enum {
	OVL_VERITY_OFF = 0,
	OVL_VERITY_ON = 1,
	OVL_VERITY_REQUIRE = 2,
};

enum {
	OVL_XINO_OFF = 0,
	OVL_XINO_AUTO = 1,
	OVL_XINO_ON = 2,
};

enum {
	Opt_acl = 0,
	Opt_clear_cache = 1,
	Opt_commit_interval = 2,
	Opt_compress = 3,
	Opt_compress_force = 4,
	Opt_compress_force_type = 5,
	Opt_compress_type = 6,
	Opt_degraded = 7,
	Opt_device = 8,
	Opt_fatal_errors = 9,
	Opt_flushoncommit = 10,
	Opt_max_inline = 11,
	Opt_barrier = 12,
	Opt_datacow = 13,
	Opt_datasum = 14,
	Opt_defrag = 15,
	Opt_discard = 16,
	Opt_discard_mode = 17,
	Opt_ratio = 18,
	Opt_rescan_uuid_tree = 19,
	Opt_skip_balance = 20,
	Opt_space_cache = 21,
	Opt_space_cache_version = 22,
	Opt_ssd = 23,
	Opt_ssd_spread = 24,
	Opt_subvol = 25,
	Opt_subvol_empty = 26,
	Opt_subvolid = 27,
	Opt_thread_pool = 28,
	Opt_treelog = 29,
	Opt_user_subvol_rm_allowed = 30,
	Opt_norecovery = 31,
	Opt_rescue = 32,
	Opt_usebackuproot = 33,
	Opt_nologreplay = 34,
	Opt_enospc_debug = 35,
	Opt_err = 36,
};

enum {
	Opt_block = 0,
	Opt_check = 1,
	Opt_cruft = 2,
	Opt_gid = 3,
	Opt_ignore = 4,
	Opt_iocharset = 5,
	Opt_map = 6,
	Opt_mode = 7,
	Opt_nojoliet = 8,
	Opt_norock = 9,
	Opt_sb = 10,
	Opt_session = 11,
	Opt_uid = 12,
	Opt_unhide = 13,
	Opt_utf8 = 14,
	Opt_err___2 = 15,
	Opt_nocompress = 16,
	Opt_hide = 17,
	Opt_showassoc = 18,
	Opt_dmode = 19,
	Opt_overriderockperm = 20,
};

enum {
	Opt_bsd_df = 0,
	Opt_minix_df = 1,
	Opt_grpid = 2,
	Opt_nogrpid = 3,
	Opt_resgid = 4,
	Opt_resuid = 5,
	Opt_sb___2 = 6,
	Opt_err_cont = 7,
	Opt_err_panic = 8,
	Opt_err_ro = 9,
	Opt_nouid32 = 10,
	Opt_debug = 11,
	Opt_oldalloc = 12,
	Opt_orlov = 13,
	Opt_nobh = 14,
	Opt_user_xattr = 15,
	Opt_nouser_xattr = 16,
	Opt_acl___2 = 17,
	Opt_noacl = 18,
	Opt_xip = 19,
	Opt_dax = 20,
	Opt_ignore___2 = 21,
	Opt_err___3 = 22,
	Opt_quota = 23,
	Opt_usrquota = 24,
	Opt_grpquota = 25,
	Opt_reservation = 26,
	Opt_noreservation = 27,
};

enum {
	Opt_bsd_df___2 = 0,
	Opt_minix_df___2 = 1,
	Opt_grpid___2 = 2,
	Opt_nogrpid___2 = 3,
	Opt_resgid___2 = 4,
	Opt_resuid___2 = 5,
	Opt_sb___3 = 6,
	Opt_nouid32___2 = 7,
	Opt_debug___2 = 8,
	Opt_removed = 9,
	Opt_user_xattr___2 = 10,
	Opt_acl___3 = 11,
	Opt_auto_da_alloc = 12,
	Opt_noauto_da_alloc = 13,
	Opt_noload = 14,
	Opt_commit = 15,
	Opt_min_batch_time = 16,
	Opt_max_batch_time = 17,
	Opt_journal_dev = 18,
	Opt_journal_path = 19,
	Opt_journal_checksum = 20,
	Opt_journal_async_commit = 21,
	Opt_abort = 22,
	Opt_data_journal = 23,
	Opt_data_ordered = 24,
	Opt_data_writeback = 25,
	Opt_data_err_abort = 26,
	Opt_data_err_ignore = 27,
	Opt_test_dummy_encryption = 28,
	Opt_inlinecrypt = 29,
	Opt_usrjquota = 30,
	Opt_grpjquota = 31,
	Opt_quota___2 = 32,
	Opt_noquota = 33,
	Opt_barrier___2 = 34,
	Opt_nobarrier = 35,
	Opt_err___4 = 36,
	Opt_usrquota___2 = 37,
	Opt_grpquota___2 = 38,
	Opt_prjquota = 39,
	Opt_dax___2 = 40,
	Opt_dax_always = 41,
	Opt_dax_inode = 42,
	Opt_dax_never = 43,
	Opt_stripe = 44,
	Opt_delalloc = 45,
	Opt_nodelalloc = 46,
	Opt_warn_on_error = 47,
	Opt_nowarn_on_error = 48,
	Opt_mblk_io_submit = 49,
	Opt_debug_want_extra_isize = 50,
	Opt_nomblk_io_submit = 51,
	Opt_block_validity = 52,
	Opt_noblock_validity = 53,
	Opt_inode_readahead_blks = 54,
	Opt_journal_ioprio = 55,
	Opt_dioread_nolock = 56,
	Opt_dioread_lock = 57,
	Opt_discard___2 = 58,
	Opt_nodiscard = 59,
	Opt_init_itable = 60,
	Opt_noinit_itable = 61,
	Opt_max_dir_size_kb = 62,
	Opt_nojournal_checksum = 63,
	Opt_nombcache = 64,
	Opt_no_prefetch_block_bitmaps = 65,
	Opt_mb_optimize_scan = 66,
	Opt_errors = 67,
	Opt_data = 68,
	Opt_data_err = 69,
	Opt_jqfmt = 70,
	Opt_dax_type = 71,
};

enum {
	Opt_debug___3 = 0,
	Opt_dfltuid = 1,
	Opt_dfltgid = 2,
	Opt_afid = 3,
	Opt_uname = 4,
	Opt_remotename = 5,
	Opt_cache = 6,
	Opt_cachetag = 7,
	Opt_nodevmap = 8,
	Opt_noxattr = 9,
	Opt_directio = 10,
	Opt_ignoreqv = 11,
	Opt_access = 12,
	Opt_posixacl = 13,
	Opt_locktimeout = 14,
	Opt_err___5 = 15,
};

enum {
	Opt_direct = 0,
	Opt_fd = 1,
	Opt_gid___2 = 2,
	Opt_ignore___3 = 3,
	Opt_indirect = 4,
	Opt_maxproto = 5,
	Opt_minproto = 6,
	Opt_offset = 7,
	Opt_pgrp = 8,
	Opt_strictexpire = 9,
	Opt_uid___2 = 10,
};

enum {
	Opt_discard_sync = 0,
	Opt_discard_async = 1,
};

enum {
	Opt_err___6 = 0,
	Opt_enc = 1,
	Opt_hash = 2,
};

enum {
	Opt_error = -1,
	Opt_context = 0,
	Opt_defcontext = 1,
	Opt_fscontext = 2,
	Opt_rootcontext = 3,
	Opt_seclabel = 4,
};

enum {
	Opt_fatal_errors_panic = 0,
	Opt_fatal_errors_bug = 1,
};

enum {
	Opt_find_uid = 0,
	Opt_find_gid = 1,
	Opt_find_user = 2,
	Opt_find_group = 3,
	Opt_find_err = 4,
};

enum {
	Opt_local_lock_all = 0,
	Opt_local_lock_flock = 1,
	Opt_local_lock_none = 2,
	Opt_local_lock_posix = 3,
};

enum {
	Opt_logbufs = 0,
	Opt_logbsize = 1,
	Opt_logdev = 2,
	Opt_rtdev = 3,
	Opt_wsync = 4,
	Opt_noalign = 5,
	Opt_swalloc = 6,
	Opt_sunit = 7,
	Opt_swidth = 8,
	Opt_nouuid = 9,
	Opt_grpid___3 = 10,
	Opt_nogrpid___3 = 11,
	Opt_bsdgroups = 12,
	Opt_sysvgroups = 13,
	Opt_allocsize = 14,
	Opt_norecovery___2 = 15,
	Opt_inode64 = 16,
	Opt_inode32 = 17,
	Opt_ikeep = 18,
	Opt_noikeep = 19,
	Opt_largeio = 20,
	Opt_nolargeio = 21,
	Opt_attr2 = 22,
	Opt_noattr2 = 23,
	Opt_filestreams = 24,
	Opt_quota___3 = 25,
	Opt_noquota___2 = 26,
	Opt_usrquota___3 = 27,
	Opt_grpquota___3 = 28,
	Opt_prjquota___2 = 29,
	Opt_uquota = 30,
	Opt_gquota = 31,
	Opt_pquota = 32,
	Opt_uqnoenforce = 33,
	Opt_gqnoenforce = 34,
	Opt_pqnoenforce = 35,
	Opt_qnoenforce = 36,
	Opt_discard___3 = 37,
	Opt_nodiscard___2 = 38,
	Opt_dax___3 = 39,
	Opt_dax_enum = 40,
};

enum {
	Opt_lookupcache_all = 0,
	Opt_lookupcache_none = 1,
	Opt_lookupcache_positive = 2,
};

enum {
	Opt_msize = 0,
	Opt_trans = 1,
	Opt_legacy = 2,
	Opt_version = 3,
	Opt_err___7 = 4,
};

enum {
	Opt_novrs = 0,
	Opt_nostrict = 1,
	Opt_bs = 2,
	Opt_unhide___2 = 3,
	Opt_undelete = 4,
	Opt_noadinicb = 5,
	Opt_adinicb = 6,
	Opt_shortad = 7,
	Opt_longad = 8,
	Opt_gid___3 = 9,
	Opt_uid___3 = 10,
	Opt_umask = 11,
	Opt_session___2 = 12,
	Opt_lastblock = 13,
	Opt_anchor = 14,
	Opt_volume = 15,
	Opt_partition = 16,
	Opt_fileset = 17,
	Opt_rootdir = 18,
	Opt_utf8___2 = 19,
	Opt_iocharset___2 = 20,
	Opt_err___8 = 21,
	Opt_fmode = 22,
	Opt_dmode___2 = 23,
};

enum {
	Opt_port = 0,
	Opt_rfdno = 1,
	Opt_wfdno = 2,
	Opt_err___9 = 3,
	Opt_privport = 4,
};

enum {
	Opt_rescue_usebackuproot = 0,
	Opt_rescue_nologreplay = 1,
	Opt_rescue_ignorebadroots = 2,
	Opt_rescue_ignoredatacsums = 3,
	Opt_rescue_ignoremetacsums = 4,
	Opt_rescue_ignoresuperflags = 5,
	Opt_rescue_parameter_all = 6,
};

enum {
	Opt_sec_krb5 = 0,
	Opt_sec_krb5i = 1,
	Opt_sec_krb5p = 2,
	Opt_sec_lkey = 3,
	Opt_sec_lkeyi = 4,
	Opt_sec_lkeyp = 5,
	Opt_sec_none = 6,
	Opt_sec_spkm = 7,
	Opt_sec_spkmi = 8,
	Opt_sec_spkmp = 9,
	Opt_sec_sys = 10,
	nr__Opt_sec = 11,
};

enum {
	Opt_space_cache_v1 = 0,
	Opt_space_cache_v2 = 1,
};

enum {
	Opt_uid___4 = 0,
	Opt_gid___4 = 1,
	Opt_mode___2 = 2,
};

enum {
	Opt_uid___5 = 0,
	Opt_gid___5 = 1,
	Opt_mode___3 = 2,
	Opt_source = 3,
};

enum {
	Opt_uid___6 = 0,
	Opt_gid___6 = 1,
	Opt_mode___4 = 2,
	Opt_ptmxmode = 3,
	Opt_newinstance = 4,
	Opt_max = 5,
	Opt_err___10 = 6,
};

enum {
	Opt_vers_2 = 0,
	Opt_vers_3 = 1,
	Opt_vers_4 = 2,
	Opt_vers_4_0 = 3,
	Opt_vers_4_1 = 4,
	Opt_vers_4_2 = 5,
};

enum {
	Opt_write_lazy = 0,
	Opt_write_eager = 1,
	Opt_write_wait = 2,
};

enum {
	Opt_xprt_rdma = 0,
	Opt_xprt_rdma6 = 1,
	Opt_xprt_tcp = 2,
	Opt_xprt_tcp6 = 3,
	Opt_xprt_udp = 4,
	Opt_xprt_udp6 = 5,
	nr__Opt_xprt = 6,
};

enum {
	Opt_xprtsec_none = 0,
	Opt_xprtsec_tls = 1,
	Opt_xprtsec_mtls = 2,
	nr__Opt_xprtsec = 3,
};

enum {
	PAGE_REPORTING_IDLE = 0,
	PAGE_REPORTING_REQUESTED = 1,
	PAGE_REPORTING_ACTIVE = 2,
};

enum {
	PAGE_WAS_MAPPED = 1,
	PAGE_WAS_MLOCKED = 2,
	PAGE_OLD_STATES = 3,
};

enum {
	PBA_STRATEGY_EQUAL = 0,
	PBA_STRATEGY_WEIGHTED = 1,
};

enum {
	PCI_REASSIGN_ALL_RSRC = 1,
	PCI_REASSIGN_ALL_BUS = 2,
	PCI_PROBE_ONLY = 4,
	PCI_CAN_SKIP_ISA_ALIGN = 8,
	PCI_ENABLE_PROC_DOMAINS = 16,
	PCI_COMPAT_DOMAIN_0 = 32,
	PCI_SCAN_ALL_PCIE_DEVS = 64,
};

enum {
	PCI_STD_RESOURCES = 0,
	PCI_STD_RESOURCE_END = 5,
	PCI_ROM_RESOURCE = 6,
	PCI_IOV_RESOURCES = 7,
	PCI_IOV_RESOURCE_END = 12,
	PCI_BRIDGE_RESOURCES = 13,
	PCI_BRIDGE_RESOURCE_END = 16,
	PCI_NUM_RESOURCES = 17,
	DEVICE_COUNT_RESOURCE = 17,
};

enum {
	PERCPU_REF_INIT_ATOMIC = 1,
	PERCPU_REF_INIT_DEAD = 2,
	PERCPU_REF_ALLOW_REINIT = 4,
};

enum {
	PER_LINUX = 0,
	PER_LINUX_32BIT = 8388608,
	PER_LINUX_FDPIC = 524288,
	PER_SVR4 = 68157441,
	PER_SVR3 = 83886082,
	PER_SCOSVR3 = 117440515,
	PER_OSR5 = 100663299,
	PER_WYSEV386 = 83886084,
	PER_ISCR4 = 67108869,
	PER_BSD = 6,
	PER_SUNOS = 67108870,
	PER_XENIX = 83886087,
	PER_LINUX32 = 8,
	PER_LINUX32_3GB = 134217736,
	PER_IRIX32 = 67108873,
	PER_IRIXN32 = 67108874,
	PER_IRIX64 = 67108875,
	PER_RISCOS = 12,
	PER_SOLARIS = 67108877,
	PER_UW7 = 68157454,
	PER_OSF4 = 15,
	PER_HPUX = 16,
	PER_MASK = 255,
};

enum {
	PG_BUSY = 0,
	PG_MAPPED = 1,
	PG_FOLIO = 2,
	PG_CLEAN = 3,
	PG_COMMIT_TO_DS = 4,
	PG_INODE_REF = 5,
	PG_HEADLOCK = 6,
	PG_TEARDOWN = 7,
	PG_UNLOCKPAGE = 8,
	PG_UPTODATE = 9,
	PG_WB_END = 10,
	PG_REMOVE = 11,
	PG_CONTENDED1 = 12,
	PG_CONTENDED2 = 13,
};

enum {
	PHYLINK_DISABLE_STOPPED = 0,
	PHYLINK_DISABLE_LINK = 1,
	PHYLINK_DISABLE_MAC_WOL = 2,
	PCS_STATE_DOWN = 0,
	PCS_STATE_STARTING = 1,
	PCS_STATE_STARTED = 2,
};

enum {
	PIM_TYPE_HELLO = 0,
	PIM_TYPE_REGISTER = 1,
	PIM_TYPE_REGISTER_STOP = 2,
	PIM_TYPE_JOIN_PRUNE = 3,
	PIM_TYPE_BOOTSTRAP = 4,
	PIM_TYPE_ASSERT = 5,
	PIM_TYPE_GRAFT = 6,
	PIM_TYPE_GRAFT_ACK = 7,
	PIM_TYPE_CANDIDATE_RP_ADV = 8,
};

enum {
	PLAT8250_DEV_LEGACY = -1,
	PLAT8250_DEV_PLATFORM = 0,
	PLAT8250_DEV_PLATFORM1 = 1,
	PLAT8250_DEV_PLATFORM2 = 2,
	PLAT8250_DEV_FOURPORT = 3,
	PLAT8250_DEV_ACCENT = 4,
	PLAT8250_DEV_BOCA = 5,
	PLAT8250_DEV_EXAR_ST16C554 = 6,
	PLAT8250_DEV_HUB6 = 7,
	PLAT8250_DEV_AU1X00 = 8,
	PLAT8250_DEV_SM501 = 9,
};

enum {
	PNFS_BDEV_REGISTERED = 0,
};

enum {
	POLICYDB_CAP_NETPEER = 0,
	POLICYDB_CAP_OPENPERM = 1,
	POLICYDB_CAP_EXTSOCKCLASS = 2,
	POLICYDB_CAP_ALWAYSNETWORK = 3,
	POLICYDB_CAP_CGROUPSECLABEL = 4,
	POLICYDB_CAP_NNP_NOSUID_TRANSITION = 5,
	POLICYDB_CAP_GENFS_SECLABEL_SYMLINKS = 6,
	POLICYDB_CAP_IOCTL_SKIP_CLOEXEC = 7,
	POLICYDB_CAP_USERSPACE_INITIAL_CONTEXT = 8,
	POLICYDB_CAP_NETLINK_XPERM = 9,
	__POLICYDB_CAP_MAX = 10,
};

enum {
	POOL_BITS = 256,
	POOL_READY_BITS = 256,
	POOL_EARLY_BITS = 128,
};

enum {
	POS_FIX_AUTO = 0,
	POS_FIX_LPIB = 1,
	POS_FIX_POSBUF = 2,
	POS_FIX_VIACOMBO = 3,
	POS_FIX_COMBO = 4,
	POS_FIX_SKL = 5,
	POS_FIX_FIFO = 6,
};

enum {
	POWER_SUPPLY_CAPACITY_LEVEL_UNKNOWN = 0,
	POWER_SUPPLY_CAPACITY_LEVEL_CRITICAL = 1,
	POWER_SUPPLY_CAPACITY_LEVEL_LOW = 2,
	POWER_SUPPLY_CAPACITY_LEVEL_NORMAL = 3,
	POWER_SUPPLY_CAPACITY_LEVEL_HIGH = 4,
	POWER_SUPPLY_CAPACITY_LEVEL_FULL = 5,
};

enum {
	POWER_SUPPLY_HEALTH_UNKNOWN = 0,
	POWER_SUPPLY_HEALTH_GOOD = 1,
	POWER_SUPPLY_HEALTH_OVERHEAT = 2,
	POWER_SUPPLY_HEALTH_DEAD = 3,
	POWER_SUPPLY_HEALTH_OVERVOLTAGE = 4,
	POWER_SUPPLY_HEALTH_UNDERVOLTAGE = 5,
	POWER_SUPPLY_HEALTH_UNSPEC_FAILURE = 6,
	POWER_SUPPLY_HEALTH_COLD = 7,
	POWER_SUPPLY_HEALTH_WATCHDOG_TIMER_EXPIRE = 8,
	POWER_SUPPLY_HEALTH_SAFETY_TIMER_EXPIRE = 9,
	POWER_SUPPLY_HEALTH_OVERCURRENT = 10,
	POWER_SUPPLY_HEALTH_CALIBRATION_REQUIRED = 11,
	POWER_SUPPLY_HEALTH_WARM = 12,
	POWER_SUPPLY_HEALTH_COOL = 13,
	POWER_SUPPLY_HEALTH_HOT = 14,
	POWER_SUPPLY_HEALTH_NO_BATTERY = 15,
};

enum {
	POWER_SUPPLY_SCOPE_UNKNOWN = 0,
	POWER_SUPPLY_SCOPE_SYSTEM = 1,
	POWER_SUPPLY_SCOPE_DEVICE = 2,
};

enum {
	POWER_SUPPLY_STATUS_UNKNOWN = 0,
	POWER_SUPPLY_STATUS_CHARGING = 1,
	POWER_SUPPLY_STATUS_DISCHARGING = 2,
	POWER_SUPPLY_STATUS_NOT_CHARGING = 3,
	POWER_SUPPLY_STATUS_FULL = 4,
};

enum {
	POWER_SUPPLY_TECHNOLOGY_UNKNOWN = 0,
	POWER_SUPPLY_TECHNOLOGY_NiMH = 1,
	POWER_SUPPLY_TECHNOLOGY_LION = 2,
	POWER_SUPPLY_TECHNOLOGY_LIPO = 3,
	POWER_SUPPLY_TECHNOLOGY_LiFe = 4,
	POWER_SUPPLY_TECHNOLOGY_NiCd = 5,
	POWER_SUPPLY_TECHNOLOGY_LiMn = 6,
};

enum {
	PREFIX_UNSPEC = 0,
	PREFIX_ADDRESS = 1,
	PREFIX_CACHEINFO = 2,
	__PREFIX_MAX = 3,
};

enum {
	PROC_ENTRY_PERMANENT = 1,
	PROC_ENTRY_proc_read_iter = 2,
	PROC_ENTRY_proc_compat_ioctl = 4,
};

enum {
	PROC_ROOT_INO = 1,
	PROC_IPC_INIT_INO = 4026531839,
	PROC_UTS_INIT_INO = 4026531838,
	PROC_USER_INIT_INO = 4026531837,
	PROC_PID_INIT_INO = 4026531836,
	PROC_CGROUP_INIT_INO = 4026531835,
	PROC_TIME_INIT_INO = 4026531834,
};

enum {
	PWMF_REQUESTED = 0,
	PWMF_EXPORTED = 1,
};

enum {
	QIF_BLIMITS_B = 0,
	QIF_SPACE_B = 1,
	QIF_ILIMITS_B = 2,
	QIF_INODES_B = 3,
	QIF_BTIME_B = 4,
	QIF_ITIME_B = 5,
};

enum {
	QOS_ENABLE = 0,
	QOS_CTRL = 1,
	NR_QOS_CTRL_PARAMS = 2,
};

enum {
	QOS_RPPM = 0,
	QOS_RLAT = 1,
	QOS_WPPM = 2,
	QOS_WLAT = 3,
	QOS_MIN = 4,
	QOS_MAX = 5,
	NR_QOS_PARAMS = 6,
};

enum {
	QUEUE_FLAG_DYING = 0,
	QUEUE_FLAG_NOMERGES = 1,
	QUEUE_FLAG_SAME_COMP = 2,
	QUEUE_FLAG_FAIL_IO = 3,
	QUEUE_FLAG_NOXMERGES = 4,
	QUEUE_FLAG_SAME_FORCE = 5,
	QUEUE_FLAG_INIT_DONE = 6,
	QUEUE_FLAG_STATS = 7,
	QUEUE_FLAG_REGISTERED = 8,
	QUEUE_FLAG_QUIESCED = 9,
	QUEUE_FLAG_RQ_ALLOC_TIME = 10,
	QUEUE_FLAG_HCTX_ACTIVE = 11,
	QUEUE_FLAG_SQ_SCHED = 12,
	QUEUE_FLAG_MAX = 13,
};

enum {
	Q_REQUEUE_PI_NONE = 0,
	Q_REQUEUE_PI_IGNORE = 1,
	Q_REQUEUE_PI_IN_PROGRESS = 2,
	Q_REQUEUE_PI_WAIT = 3,
	Q_REQUEUE_PI_DONE = 4,
	Q_REQUEUE_PI_LOCKED = 5,
};

enum {
	RADIX_TREE_ITER_TAG_MASK = 15,
	RADIX_TREE_ITER_TAGGED = 16,
	RADIX_TREE_ITER_CONTIG = 32,
};

enum {
	RANGE_BOUNDARY_WRITTEN_EXTENT = 0,
	RANGE_BOUNDARY_PREALLOC_EXTENT = 1,
	RANGE_BOUNDARY_HOLE = 2,
};

enum {
	RB_ADD_STAMP_NONE = 0,
	RB_ADD_STAMP_EXTEND = 2,
	RB_ADD_STAMP_ABSOLUTE = 4,
	RB_ADD_STAMP_FORCE = 8,
};

enum {
	RB_CTX_TRANSITION = 0,
	RB_CTX_NMI = 1,
	RB_CTX_IRQ = 2,
	RB_CTX_SOFTIRQ = 3,
	RB_CTX_NORMAL = 4,
	RB_CTX_MAX = 5,
};

enum {
	RB_LEN_TIME_EXTEND = 8,
	RB_LEN_TIME_STAMP = 8,
};

enum {
	RCA4_TYPE_MASK_RDATA_DLG = 0,
	RCA4_TYPE_MASK_WDATA_DLG = 1,
	RCA4_TYPE_MASK_DIR_DLG = 2,
	RCA4_TYPE_MASK_FILE_LAYOUT = 3,
	RCA4_TYPE_MASK_BLK_LAYOUT = 4,
	RCA4_TYPE_MASK_OBJ_LAYOUT_MIN = 8,
	RCA4_TYPE_MASK_OBJ_LAYOUT_MAX = 9,
	RCA4_TYPE_MASK_OTHER_LAYOUT_MIN = 12,
	RCA4_TYPE_MASK_OTHER_LAYOUT_MAX = 15,
};

enum {
	RC_DROPIT = 0,
	RC_REPLY = 1,
	RC_DOIT = 2,
};

enum {
	RC_NOCACHE = 0,
	RC_REPLSTAT = 1,
	RC_REPLBUFF = 2,
};

enum {
	RC_UNUSED = 0,
	RC_INPROG = 1,
	RC_DONE = 2,
};

enum {
	RDS_CONN_DOWN = 0,
	RDS_CONN_CONNECTING = 1,
	RDS_CONN_DISCONNECTING = 2,
	RDS_CONN_UP = 3,
	RDS_CONN_RESETTING = 4,
	RDS_CONN_ERROR = 5,
};

enum {
	READA_NONE = 0,
	READA_BACK = 1,
	READA_FORWARD = 2,
	READA_FORWARD_ALWAYS = 3,
};

enum {
	REASON_BOUNDS = -1,
	REASON_TYPE = -2,
	REASON_PATHS = -3,
	REASON_LIMIT = -4,
	REASON_STACK = -5,
};

enum {
	REGION_INTERSECTS = 0,
	REGION_DISJOINT = 1,
	REGION_MIXED = 2,
};

enum {
	REQ_FSEQ_PREFLUSH = 1,
	REQ_FSEQ_DATA = 2,
	REQ_FSEQ_POSTFLUSH = 4,
	REQ_FSEQ_DONE = 8,
	REQ_FSEQ_ACTIONS = 7,
	FLUSH_PENDING_TIMEOUT = 1250,
};

enum {
	REQ_F_FIXED_FILE = 1ULL,
	REQ_F_IO_DRAIN = 2ULL,
	REQ_F_LINK = 4ULL,
	REQ_F_HARDLINK = 8ULL,
	REQ_F_FORCE_ASYNC = 16ULL,
	REQ_F_BUFFER_SELECT = 32ULL,
	REQ_F_CQE_SKIP = 64ULL,
	REQ_F_FAIL = 256ULL,
	REQ_F_INFLIGHT = 512ULL,
	REQ_F_CUR_POS = 1024ULL,
	REQ_F_NOWAIT = 2048ULL,
	REQ_F_LINK_TIMEOUT = 4096ULL,
	REQ_F_NEED_CLEANUP = 8192ULL,
	REQ_F_POLLED = 16384ULL,
	REQ_F_IOPOLL_STATE = 32768ULL,
	REQ_F_BUFFER_SELECTED = 65536ULL,
	REQ_F_BUFFER_RING = 131072ULL,
	REQ_F_REISSUE = 262144ULL,
	REQ_F_SUPPORT_NOWAIT = 268435456ULL,
	REQ_F_ISREG = 536870912ULL,
	REQ_F_CREDS = 524288ULL,
	REQ_F_REFCOUNT = 1048576ULL,
	REQ_F_ARM_LTIMEOUT = 2097152ULL,
	REQ_F_ASYNC_DATA = 4194304ULL,
	REQ_F_SKIP_LINK_CQES = 8388608ULL,
	REQ_F_SINGLE_POLL = 16777216ULL,
	REQ_F_DOUBLE_POLL = 33554432ULL,
	REQ_F_APOLL_MULTISHOT = 67108864ULL,
	REQ_F_CLEAR_POLLIN = 134217728ULL,
	REQ_F_POLL_NO_LAZY = 1073741824ULL,
	REQ_F_CAN_POLL = 2147483648ULL,
	REQ_F_BL_EMPTY = 4294967296ULL,
	REQ_F_BL_NO_RECYCLE = 8589934592ULL,
	REQ_F_BUFFERS_COMMIT = 17179869184ULL,
	REQ_F_BUF_NODE = 34359738368ULL,
	REQ_F_HAS_METADATA = 68719476736ULL,
};

enum {
	REQ_F_FIXED_FILE_BIT = 0,
	REQ_F_IO_DRAIN_BIT = 1,
	REQ_F_LINK_BIT = 2,
	REQ_F_HARDLINK_BIT = 3,
	REQ_F_FORCE_ASYNC_BIT = 4,
	REQ_F_BUFFER_SELECT_BIT = 5,
	REQ_F_CQE_SKIP_BIT = 6,
	REQ_F_FAIL_BIT = 8,
	REQ_F_INFLIGHT_BIT = 9,
	REQ_F_CUR_POS_BIT = 10,
	REQ_F_NOWAIT_BIT = 11,
	REQ_F_LINK_TIMEOUT_BIT = 12,
	REQ_F_NEED_CLEANUP_BIT = 13,
	REQ_F_POLLED_BIT = 14,
	REQ_F_HYBRID_IOPOLL_STATE_BIT = 15,
	REQ_F_BUFFER_SELECTED_BIT = 16,
	REQ_F_BUFFER_RING_BIT = 17,
	REQ_F_REISSUE_BIT = 18,
	REQ_F_CREDS_BIT = 19,
	REQ_F_REFCOUNT_BIT = 20,
	REQ_F_ARM_LTIMEOUT_BIT = 21,
	REQ_F_ASYNC_DATA_BIT = 22,
	REQ_F_SKIP_LINK_CQES_BIT = 23,
	REQ_F_SINGLE_POLL_BIT = 24,
	REQ_F_DOUBLE_POLL_BIT = 25,
	REQ_F_APOLL_MULTISHOT_BIT = 26,
	REQ_F_CLEAR_POLLIN_BIT = 27,
	REQ_F_SUPPORT_NOWAIT_BIT = 28,
	REQ_F_ISREG_BIT = 29,
	REQ_F_POLL_NO_LAZY_BIT = 30,
	REQ_F_CAN_POLL_BIT = 31,
	REQ_F_BL_EMPTY_BIT = 32,
	REQ_F_BL_NO_RECYCLE_BIT = 33,
	REQ_F_BUFFERS_COMMIT_BIT = 34,
	REQ_F_BUF_NODE_BIT = 35,
	REQ_F_HAS_METADATA_BIT = 36,
	__REQ_F_LAST_BIT = 37,
};

enum {
	RES_USAGE = 0,
	RES_RSVD_USAGE = 1,
	RES_LIMIT = 2,
	RES_RSVD_LIMIT = 3,
	RES_MAX_USAGE = 4,
	RES_RSVD_MAX_USAGE = 5,
	RES_FAILCNT = 6,
	RES_RSVD_FAILCNT = 7,
};

enum {
	RPCAUTH_info = 0,
	RPCAUTH_EOF = 1,
};

enum {
	RPCAUTH_lockd = 0,
	RPCAUTH_mount = 1,
	RPCAUTH_nfs = 2,
	RPCAUTH_portmap = 3,
	RPCAUTH_statd = 4,
	RPCAUTH_nfsd4_cb = 5,
	RPCAUTH_cache = 6,
	RPCAUTH_nfsd = 7,
	RPCAUTH_gssd = 8,
	RPCAUTH_RootEOF = 9,
};

enum {
	RPCBPROC_NULL = 0,
	RPCBPROC_SET = 1,
	RPCBPROC_UNSET = 2,
	RPCBPROC_GETPORT = 3,
	RPCBPROC_GETADDR = 3,
	RPCBPROC_DUMP = 4,
	RPCBPROC_CALLIT = 5,
	RPCBPROC_BCAST = 5,
	RPCBPROC_GETTIME = 6,
	RPCBPROC_UADDR2TADDR = 7,
	RPCBPROC_TADDR2UADDR = 8,
	RPCBPROC_GETVERSADDR = 9,
	RPCBPROC_INDIRECT = 10,
	RPCBPROC_GETADDRLIST = 11,
	RPCBPROC_GETSTAT = 12,
};

enum {
	RPC_PIPEFS_MOUNT = 0,
	RPC_PIPEFS_UMOUNT = 1,
};

enum {
	RPC_TASK_RUNNING = 0,
	RPC_TASK_QUEUED = 1,
	RPC_TASK_ACTIVE = 2,
	RPC_TASK_NEED_XMIT = 3,
	RPC_TASK_NEED_RECV = 4,
	RPC_TASK_MSG_PIN_WAIT = 5,
};

enum {
	RQ_SECURE = 0,
	RQ_LOCAL = 1,
	RQ_USEDEFERRAL = 2,
	RQ_DROPME = 3,
	RQ_VICTIM = 4,
	RQ_DATA = 5,
};

enum {
	RQ_WAIT_BUSY_PCT = 5,
	UNBUSY_THR_PCT = 75,
	MIN_DELAY_THR_PCT = 500,
	MAX_DELAY_THR_PCT = 25000,
	MIN_DELAY = 250,
	MAX_DELAY = 250000,
	DFGV_USAGE_PCT = 50,
	DFGV_PERIOD = 100000,
	MAX_LAGGING_PERIODS = 10,
	IOC_PAGE_SHIFT = 12,
	IOC_PAGE_SIZE = 4096,
	IOC_SECT_TO_PAGE_SHIFT = 3,
	LCOEF_RANDIO_PAGES = 4096,
};

enum {
	RTAX_UNSPEC = 0,
	RTAX_LOCK = 1,
	RTAX_MTU = 2,
	RTAX_WINDOW = 3,
	RTAX_RTT = 4,
	RTAX_RTTVAR = 5,
	RTAX_SSTHRESH = 6,
	RTAX_CWND = 7,
	RTAX_ADVMSS = 8,
	RTAX_REORDERING = 9,
	RTAX_HOPLIMIT = 10,
	RTAX_INITCWND = 11,
	RTAX_FEATURES = 12,
	RTAX_RTO_MIN = 13,
	RTAX_INITRWND = 14,
	RTAX_QUICKACK = 15,
	RTAX_CC_ALGO = 16,
	RTAX_FASTOPEN_NO_COOKIE = 17,
	__RTAX_MAX = 18,
};

enum {
	RTM_BASE = 16,
	RTM_NEWLINK = 16,
	RTM_DELLINK = 17,
	RTM_GETLINK = 18,
	RTM_SETLINK = 19,
	RTM_NEWADDR = 20,
	RTM_DELADDR = 21,
	RTM_GETADDR = 22,
	RTM_NEWROUTE = 24,
	RTM_DELROUTE = 25,
	RTM_GETROUTE = 26,
	RTM_NEWNEIGH = 28,
	RTM_DELNEIGH = 29,
	RTM_GETNEIGH = 30,
	RTM_NEWRULE = 32,
	RTM_DELRULE = 33,
	RTM_GETRULE = 34,
	RTM_NEWQDISC = 36,
	RTM_DELQDISC = 37,
	RTM_GETQDISC = 38,
	RTM_NEWTCLASS = 40,
	RTM_DELTCLASS = 41,
	RTM_GETTCLASS = 42,
	RTM_NEWTFILTER = 44,
	RTM_DELTFILTER = 45,
	RTM_GETTFILTER = 46,
	RTM_NEWACTION = 48,
	RTM_DELACTION = 49,
	RTM_GETACTION = 50,
	RTM_NEWPREFIX = 52,
	RTM_NEWMULTICAST = 56,
	RTM_DELMULTICAST = 57,
	RTM_GETMULTICAST = 58,
	RTM_NEWANYCAST = 60,
	RTM_DELANYCAST = 61,
	RTM_GETANYCAST = 62,
	RTM_NEWNEIGHTBL = 64,
	RTM_GETNEIGHTBL = 66,
	RTM_SETNEIGHTBL = 67,
	RTM_NEWNDUSEROPT = 68,
	RTM_NEWADDRLABEL = 72,
	RTM_DELADDRLABEL = 73,
	RTM_GETADDRLABEL = 74,
	RTM_GETDCB = 78,
	RTM_SETDCB = 79,
	RTM_NEWNETCONF = 80,
	RTM_DELNETCONF = 81,
	RTM_GETNETCONF = 82,
	RTM_NEWMDB = 84,
	RTM_DELMDB = 85,
	RTM_GETMDB = 86,
	RTM_NEWNSID = 88,
	RTM_DELNSID = 89,
	RTM_GETNSID = 90,
	RTM_NEWSTATS = 92,
	RTM_GETSTATS = 94,
	RTM_SETSTATS = 95,
	RTM_NEWCACHEREPORT = 96,
	RTM_NEWCHAIN = 100,
	RTM_DELCHAIN = 101,
	RTM_GETCHAIN = 102,
	RTM_NEWNEXTHOP = 104,
	RTM_DELNEXTHOP = 105,
	RTM_GETNEXTHOP = 106,
	RTM_NEWLINKPROP = 108,
	RTM_DELLINKPROP = 109,
	RTM_GETLINKPROP = 110,
	RTM_NEWVLAN = 112,
	RTM_DELVLAN = 113,
	RTM_GETVLAN = 114,
	RTM_NEWNEXTHOPBUCKET = 116,
	RTM_DELNEXTHOPBUCKET = 117,
	RTM_GETNEXTHOPBUCKET = 118,
	RTM_NEWTUNNEL = 120,
	RTM_DELTUNNEL = 121,
	RTM_GETTUNNEL = 122,
	__RTM_MAX = 123,
};

enum {
	RTN_UNSPEC = 0,
	RTN_UNICAST = 1,
	RTN_LOCAL = 2,
	RTN_BROADCAST = 3,
	RTN_ANYCAST = 4,
	RTN_MULTICAST = 5,
	RTN_BLACKHOLE = 6,
	RTN_UNREACHABLE = 7,
	RTN_PROHIBIT = 8,
	RTN_THROW = 9,
	RTN_NAT = 10,
	RTN_XRESOLVE = 11,
	__RTN_MAX = 12,
};

enum {
	RWB_DEF_DEPTH = 16,
	RWB_WINDOW_NSEC = 100000000,
	RWB_MIN_WRITE_SAMPLES = 3,
	RWB_UNKNOWN_BUMP = 5,
};

enum {
	Root_NFS = 255,
	Root_CIFS = 254,
	Root_Generic = 253,
	Root_RAM0 = 1048576,
};

enum {
	Rworksched = 1,
	Rpending = 2,
	Wworksched = 4,
	Wpending = 8,
};

enum {
	SAS_DATAPRES_NO_DATA = 0,
	SAS_DATAPRES_RESPONSE_DATA = 1,
	SAS_DATAPRES_SENSE_DATA = 2,
};

enum {
	SAS_DEV_GONE = 0,
	SAS_DEV_FOUND = 1,
	SAS_DEV_DESTROY = 2,
	SAS_DEV_EH_PENDING = 3,
	SAS_DEV_LU_RESET = 4,
	SAS_DEV_RESET = 5,
};

enum {
	SB_UNFROZEN = 0,
	SB_FREEZE_WRITE = 1,
	SB_FREEZE_PAGEFAULT = 2,
	SB_FREEZE_FS = 3,
	SB_FREEZE_COMPLETE = 4,
};

enum {
	SCM_TSTAMP_SND = 0,
	SCM_TSTAMP_SCHED = 1,
	SCM_TSTAMP_ACK = 2,
};

enum {
	SCTP_AUTH_HMAC_ID_RESERVED_0 = 0,
	SCTP_AUTH_HMAC_ID_SHA1 = 1,
	SCTP_AUTH_HMAC_ID_RESERVED_2 = 2,
	SCTP_AUTH_HMAC_ID_SHA256 = 3,
	__SCTP_AUTH_HMAC_MAX = 4,
};

enum {
	SCTP_MAX_DUP_TSNS = 16,
};

enum {
	SCTP_MAX_STREAM = 65535,
};

enum {
	SD_BALANCE_NEWIDLE = 1,
	SD_BALANCE_EXEC = 2,
	SD_BALANCE_FORK = 4,
	SD_BALANCE_WAKE = 8,
	SD_WAKE_AFFINE = 16,
	SD_ASYM_CPUCAPACITY = 32,
	SD_ASYM_CPUCAPACITY_FULL = 64,
	SD_SHARE_CPUCAPACITY = 128,
	SD_CLUSTER = 256,
	SD_SHARE_LLC = 512,
	SD_SERIALIZE = 1024,
	SD_ASYM_PACKING = 2048,
	SD_PREFER_SIBLING = 4096,
	SD_OVERLAP = 8192,
	SD_NUMA = 16384,
};

enum {
	SD_DEF_XFER_BLOCKS = 65535,
	SD_MAX_XFER_BLOCKS = 4294967295,
	SD_MAX_WS10_BLOCKS = 65535,
	SD_MAX_WS16_BLOCKS = 8388607,
};

enum {
	SD_EXT_CDB_SIZE = 32,
	SD_MEMPOOL_SIZE = 2,
};

enum {
	SD_LBP_FULL = 0,
	SD_LBP_UNMAP = 1,
	SD_LBP_WS16 = 2,
	SD_LBP_WS10 = 3,
	SD_LBP_ZERO = 4,
	SD_LBP_DISABLE = 5,
};

enum {
	SD_ZERO_WRITE = 0,
	SD_ZERO_WS = 1,
	SD_ZERO_WS16_UNMAP = 2,
	SD_ZERO_WS10_UNMAP = 3,
};

enum {
	SECTION_MARKED_PRESENT_BIT = 0,
	SECTION_HAS_MEM_MAP_BIT = 1,
	SECTION_IS_ONLINE_BIT = 2,
	SECTION_IS_EARLY_BIT = 3,
	SECTION_MAP_LAST_BIT = 4,
};

enum {
	SEG6_ATTR_UNSPEC = 0,
	SEG6_ATTR_DST = 1,
	SEG6_ATTR_DSTLEN = 2,
	SEG6_ATTR_HMACKEYID = 3,
	SEG6_ATTR_SECRET = 4,
	SEG6_ATTR_SECRETLEN = 5,
	SEG6_ATTR_ALGID = 6,
	SEG6_ATTR_HMACINFO = 7,
	__SEG6_ATTR_MAX = 8,
};

enum {
	SEG6_CMD_UNSPEC = 0,
	SEG6_CMD_SETHMAC = 1,
	SEG6_CMD_DUMPHMAC = 2,
	SEG6_CMD_SET_TUNSRC = 3,
	SEG6_CMD_GET_TUNSRC = 4,
	__SEG6_CMD_MAX = 5,
};

enum {
	SELNL_MSG_SETENFORCE = 16,
	SELNL_MSG_POLICYLOAD = 17,
	SELNL_MSG_MAX = 18,
};

enum {
	SFF8024_ID_UNK = 0,
	SFF8024_ID_SFF_8472 = 2,
	SFF8024_ID_SFP = 3,
	SFF8024_ID_DWDM_SFP = 11,
	SFF8024_ID_QSFP_8438 = 12,
	SFF8024_ID_QSFP_8436_8636 = 13,
	SFF8024_ID_QSFP28_8636 = 17,
	SFF8024_ID_QSFP_DD = 24,
	SFF8024_ID_OSFP = 25,
	SFF8024_ID_DSFP = 27,
	SFF8024_ID_QSFP_PLUS_CMIS = 30,
	SFF8024_ID_SFP_DD_CMIS = 31,
	SFF8024_ID_SFP_PLUS_CMIS = 32,
	SFF8024_ENCODING_UNSPEC = 0,
	SFF8024_ENCODING_8B10B = 1,
	SFF8024_ENCODING_4B5B = 2,
	SFF8024_ENCODING_NRZ = 3,
	SFF8024_ENCODING_8472_MANCHESTER = 4,
	SFF8024_ENCODING_8472_SONET = 5,
	SFF8024_ENCODING_8472_64B66B = 6,
	SFF8024_ENCODING_8436_MANCHESTER = 6,
	SFF8024_ENCODING_8436_SONET = 4,
	SFF8024_ENCODING_8436_64B66B = 5,
	SFF8024_ENCODING_256B257B = 7,
	SFF8024_ENCODING_PAM4 = 8,
	SFF8024_CONNECTOR_UNSPEC = 0,
	SFF8024_CONNECTOR_SC = 1,
	SFF8024_CONNECTOR_FIBERJACK = 6,
	SFF8024_CONNECTOR_LC = 7,
	SFF8024_CONNECTOR_MT_RJ = 8,
	SFF8024_CONNECTOR_MU = 9,
	SFF8024_CONNECTOR_SG = 10,
	SFF8024_CONNECTOR_OPTICAL_PIGTAIL = 11,
	SFF8024_CONNECTOR_MPO_1X12 = 12,
	SFF8024_CONNECTOR_MPO_2X16 = 13,
	SFF8024_CONNECTOR_HSSDC_II = 32,
	SFF8024_CONNECTOR_COPPER_PIGTAIL = 33,
	SFF8024_CONNECTOR_RJ45 = 34,
	SFF8024_CONNECTOR_NOSEPARATE = 35,
	SFF8024_CONNECTOR_MXC_2X16 = 36,
	SFF8024_ECC_UNSPEC = 0,
	SFF8024_ECC_100G_25GAUI_C2M_AOC = 1,
	SFF8024_ECC_100GBASE_SR4_25GBASE_SR = 2,
	SFF8024_ECC_100GBASE_LR4_25GBASE_LR = 3,
	SFF8024_ECC_100GBASE_ER4_25GBASE_ER = 4,
	SFF8024_ECC_100GBASE_SR10 = 5,
	SFF8024_ECC_100GBASE_CR4 = 11,
	SFF8024_ECC_25GBASE_CR_S = 12,
	SFF8024_ECC_25GBASE_CR_N = 13,
	SFF8024_ECC_10GBASE_T_SFI = 22,
	SFF8024_ECC_10GBASE_T_SR = 28,
	SFF8024_ECC_5GBASE_T = 29,
	SFF8024_ECC_2_5GBASE_T = 30,
};

enum {
	SFP_PHYS_ID = 0,
	SFP_PHYS_EXT_ID = 1,
	SFP_PHYS_EXT_ID_SFP = 4,
	SFP_CONNECTOR = 2,
	SFP_COMPLIANCE = 3,
	SFP_ENCODING = 11,
	SFP_BR_NOMINAL = 12,
	SFP_RATE_ID = 13,
	SFF_RID_8079 = 1,
	SFF_RID_8431_RX_ONLY = 2,
	SFF_RID_8431_TX_ONLY = 4,
	SFF_RID_8431 = 6,
	SFF_RID_10G8G = 14,
	SFP_LINK_LEN_SM_KM = 14,
	SFP_LINK_LEN_SM_100M = 15,
	SFP_LINK_LEN_50UM_OM2_10M = 16,
	SFP_LINK_LEN_62_5UM_OM1_10M = 17,
	SFP_LINK_LEN_COPPER_1M = 18,
	SFP_LINK_LEN_50UM_OM4_10M = 18,
	SFP_LINK_LEN_50UM_OM3_10M = 19,
	SFP_VENDOR_NAME = 20,
	SFP_VENDOR_OUI = 37,
	SFP_VENDOR_PN = 40,
	SFP_VENDOR_REV = 56,
	SFP_OPTICAL_WAVELENGTH_MSB = 60,
	SFP_OPTICAL_WAVELENGTH_LSB = 61,
	SFP_CABLE_SPEC = 60,
	SFP_CC_BASE = 63,
	SFP_OPTIONS = 64,
	SFP_OPTIONS_HIGH_POWER_LEVEL = 8192,
	SFP_OPTIONS_PAGING_A2 = 4096,
	SFP_OPTIONS_RETIMER = 2048,
	SFP_OPTIONS_COOLED_XCVR = 1024,
	SFP_OPTIONS_POWER_DECL = 512,
	SFP_OPTIONS_RX_LINEAR_OUT = 256,
	SFP_OPTIONS_RX_DECISION_THRESH = 128,
	SFP_OPTIONS_TUNABLE_TX = 64,
	SFP_OPTIONS_RATE_SELECT = 32,
	SFP_OPTIONS_TX_DISABLE = 16,
	SFP_OPTIONS_TX_FAULT = 8,
	SFP_OPTIONS_LOS_INVERTED = 4,
	SFP_OPTIONS_LOS_NORMAL = 2,
	SFP_BR_MAX = 66,
	SFP_BR_MIN = 67,
	SFP_VENDOR_SN = 68,
	SFP_DATECODE = 84,
	SFP_DIAGMON = 92,
	SFP_DIAGMON_DDM = 64,
	SFP_DIAGMON_INT_CAL = 32,
	SFP_DIAGMON_EXT_CAL = 16,
	SFP_DIAGMON_RXPWR_AVG = 8,
	SFP_DIAGMON_ADDRMODE = 4,
	SFP_ENHOPTS = 93,
	SFP_ENHOPTS_ALARMWARN = 128,
	SFP_ENHOPTS_SOFT_TX_DISABLE = 64,
	SFP_ENHOPTS_SOFT_TX_FAULT = 32,
	SFP_ENHOPTS_SOFT_RX_LOS = 16,
	SFP_ENHOPTS_SOFT_RATE_SELECT = 8,
	SFP_ENHOPTS_APP_SELECT_SFF8079 = 4,
	SFP_ENHOPTS_SOFT_RATE_SFF8431 = 2,
	SFP_SFF8472_COMPLIANCE = 94,
	SFP_SFF8472_COMPLIANCE_NONE = 0,
	SFP_SFF8472_COMPLIANCE_REV9_3 = 1,
	SFP_SFF8472_COMPLIANCE_REV9_5 = 2,
	SFP_SFF8472_COMPLIANCE_REV10_2 = 3,
	SFP_SFF8472_COMPLIANCE_REV10_4 = 4,
	SFP_SFF8472_COMPLIANCE_REV11_0 = 5,
	SFP_SFF8472_COMPLIANCE_REV11_3 = 6,
	SFP_SFF8472_COMPLIANCE_REV11_4 = 7,
	SFP_SFF8472_COMPLIANCE_REV12_0 = 8,
	SFP_CC_EXT = 95,
};

enum {
	SFP_TEMP_HIGH_ALARM = 0,
	SFP_TEMP_LOW_ALARM = 2,
	SFP_TEMP_HIGH_WARN = 4,
	SFP_TEMP_LOW_WARN = 6,
	SFP_VOLT_HIGH_ALARM = 8,
	SFP_VOLT_LOW_ALARM = 10,
	SFP_VOLT_HIGH_WARN = 12,
	SFP_VOLT_LOW_WARN = 14,
	SFP_BIAS_HIGH_ALARM = 16,
	SFP_BIAS_LOW_ALARM = 18,
	SFP_BIAS_HIGH_WARN = 20,
	SFP_BIAS_LOW_WARN = 22,
	SFP_TXPWR_HIGH_ALARM = 24,
	SFP_TXPWR_LOW_ALARM = 26,
	SFP_TXPWR_HIGH_WARN = 28,
	SFP_TXPWR_LOW_WARN = 30,
	SFP_RXPWR_HIGH_ALARM = 32,
	SFP_RXPWR_LOW_ALARM = 34,
	SFP_RXPWR_HIGH_WARN = 36,
	SFP_RXPWR_LOW_WARN = 38,
	SFP_LASER_TEMP_HIGH_ALARM = 40,
	SFP_LASER_TEMP_LOW_ALARM = 42,
	SFP_LASER_TEMP_HIGH_WARN = 44,
	SFP_LASER_TEMP_LOW_WARN = 46,
	SFP_TEC_CUR_HIGH_ALARM = 48,
	SFP_TEC_CUR_LOW_ALARM = 50,
	SFP_TEC_CUR_HIGH_WARN = 52,
	SFP_TEC_CUR_LOW_WARN = 54,
	SFP_CAL_RXPWR4 = 56,
	SFP_CAL_RXPWR3 = 60,
	SFP_CAL_RXPWR2 = 64,
	SFP_CAL_RXPWR1 = 68,
	SFP_CAL_RXPWR0 = 72,
	SFP_CAL_TXI_SLOPE = 76,
	SFP_CAL_TXI_OFFSET = 78,
	SFP_CAL_TXPWR_SLOPE = 80,
	SFP_CAL_TXPWR_OFFSET = 82,
	SFP_CAL_T_SLOPE = 84,
	SFP_CAL_T_OFFSET = 86,
	SFP_CAL_V_SLOPE = 88,
	SFP_CAL_V_OFFSET = 90,
	SFP_CHKSUM = 95,
	SFP_TEMP = 96,
	SFP_VCC = 98,
	SFP_TX_BIAS = 100,
	SFP_TX_POWER = 102,
	SFP_RX_POWER = 104,
	SFP_LASER_TEMP = 106,
	SFP_TEC_CUR = 108,
	SFP_STATUS = 110,
	SFP_STATUS_TX_DISABLE = 128,
	SFP_STATUS_TX_DISABLE_FORCE = 64,
	SFP_STATUS_RS0_SELECT = 8,
	SFP_STATUS_TX_FAULT = 4,
	SFP_STATUS_RX_LOS = 2,
	SFP_ALARM0 = 112,
	SFP_ALARM0_TEMP_HIGH = 128,
	SFP_ALARM0_TEMP_LOW = 64,
	SFP_ALARM0_VCC_HIGH = 32,
	SFP_ALARM0_VCC_LOW = 16,
	SFP_ALARM0_TX_BIAS_HIGH = 8,
	SFP_ALARM0_TX_BIAS_LOW = 4,
	SFP_ALARM0_TXPWR_HIGH = 2,
	SFP_ALARM0_TXPWR_LOW = 1,
	SFP_ALARM1 = 113,
	SFP_ALARM1_RXPWR_HIGH = 128,
	SFP_ALARM1_RXPWR_LOW = 64,
	SFP_WARN0 = 116,
	SFP_WARN0_TEMP_HIGH = 128,
	SFP_WARN0_TEMP_LOW = 64,
	SFP_WARN0_VCC_HIGH = 32,
	SFP_WARN0_VCC_LOW = 16,
	SFP_WARN0_TX_BIAS_HIGH = 8,
	SFP_WARN0_TX_BIAS_LOW = 4,
	SFP_WARN0_TXPWR_HIGH = 2,
	SFP_WARN0_TXPWR_LOW = 1,
	SFP_WARN1 = 117,
	SFP_WARN1_RXPWR_HIGH = 128,
	SFP_WARN1_RXPWR_LOW = 64,
	SFP_EXT_STATUS = 118,
	SFP_EXT_STATUS_RS1_SELECT = 8,
	SFP_EXT_STATUS_PWRLVL_SELECT = 1,
	SFP_VSL = 120,
	SFP_PAGE = 127,
};

enum {
	SILENT_STREAM_OFF = 0,
	SILENT_STREAM_KAE = 1,
	SILENT_STREAM_I915 = 2,
};

enum {
	SKBFL_ZEROCOPY_ENABLE = 1,
	SKBFL_SHARED_FRAG = 2,
	SKBFL_PURE_ZEROCOPY = 4,
	SKBFL_DONT_ORPHAN = 8,
	SKBFL_MANAGED_FRAG_REFS = 16,
};

enum {
	SKBTX_HW_TSTAMP = 1,
	SKBTX_SW_TSTAMP = 2,
	SKBTX_IN_PROGRESS = 4,
	SKBTX_HW_TSTAMP_USE_CYCLES = 8,
	SKBTX_WIFI_STATUS = 16,
	SKBTX_HW_TSTAMP_NETDEV = 32,
	SKBTX_SCHED_TSTAMP = 64,
};

enum {
	SKB_FCLONE_UNAVAILABLE = 0,
	SKB_FCLONE_ORIG = 1,
	SKB_FCLONE_CLONE = 2,
};

enum {
	SKB_GSO_TCPV4 = 1,
	SKB_GSO_DODGY = 2,
	SKB_GSO_TCP_ECN = 4,
	SKB_GSO_TCP_FIXEDID = 8,
	SKB_GSO_TCPV6 = 16,
	SKB_GSO_FCOE = 32,
	SKB_GSO_GRE = 64,
	SKB_GSO_GRE_CSUM = 128,
	SKB_GSO_IPXIP4 = 256,
	SKB_GSO_IPXIP6 = 512,
	SKB_GSO_UDP_TUNNEL = 1024,
	SKB_GSO_UDP_TUNNEL_CSUM = 2048,
	SKB_GSO_PARTIAL = 4096,
	SKB_GSO_TUNNEL_REMCSUM = 8192,
	SKB_GSO_SCTP = 16384,
	SKB_GSO_ESP = 32768,
	SKB_GSO_UDP = 65536,
	SKB_GSO_UDP_L4 = 131072,
	SKB_GSO_FRAGLIST = 262144,
};

enum {
	SKCIPHER_WALK_SLOW = 1,
	SKCIPHER_WALK_COPY = 2,
	SKCIPHER_WALK_DIFF = 4,
	SKCIPHER_WALK_SLEEP = 8,
};

enum {
	SK_DIAG_BPF_STORAGE_NONE = 0,
	SK_DIAG_BPF_STORAGE_PAD = 1,
	SK_DIAG_BPF_STORAGE_MAP_ID = 2,
	SK_DIAG_BPF_STORAGE_MAP_VALUE = 3,
	__SK_DIAG_BPF_STORAGE_MAX = 4,
};

enum {
	SK_DIAG_BPF_STORAGE_REP_NONE = 0,
	SK_DIAG_BPF_STORAGE = 1,
	__SK_DIAG_BPF_STORAGE_REP_MAX = 2,
};

enum {
	SK_DIAG_BPF_STORAGE_REQ_NONE = 0,
	SK_DIAG_BPF_STORAGE_REQ_MAP_FD = 1,
	__SK_DIAG_BPF_STORAGE_REQ_MAX = 2,
};

enum {
	SK_MEMINFO_RMEM_ALLOC = 0,
	SK_MEMINFO_RCVBUF = 1,
	SK_MEMINFO_WMEM_ALLOC = 2,
	SK_MEMINFO_SNDBUF = 3,
	SK_MEMINFO_FWD_ALLOC = 4,
	SK_MEMINFO_WMEM_QUEUED = 5,
	SK_MEMINFO_OPTMEM = 6,
	SK_MEMINFO_BACKLOG = 7,
	SK_MEMINFO_DROPS = 8,
	SK_MEMINFO_VARS = 9,
};

enum {
	SNDRV_CHMAP_UNKNOWN = 0,
	SNDRV_CHMAP_NA = 1,
	SNDRV_CHMAP_MONO = 2,
	SNDRV_CHMAP_FL = 3,
	SNDRV_CHMAP_FR = 4,
	SNDRV_CHMAP_RL = 5,
	SNDRV_CHMAP_RR = 6,
	SNDRV_CHMAP_FC = 7,
	SNDRV_CHMAP_LFE = 8,
	SNDRV_CHMAP_SL = 9,
	SNDRV_CHMAP_SR = 10,
	SNDRV_CHMAP_RC = 11,
	SNDRV_CHMAP_FLC = 12,
	SNDRV_CHMAP_FRC = 13,
	SNDRV_CHMAP_RLC = 14,
	SNDRV_CHMAP_RRC = 15,
	SNDRV_CHMAP_FLW = 16,
	SNDRV_CHMAP_FRW = 17,
	SNDRV_CHMAP_FLH = 18,
	SNDRV_CHMAP_FCH = 19,
	SNDRV_CHMAP_FRH = 20,
	SNDRV_CHMAP_TC = 21,
	SNDRV_CHMAP_TFL = 22,
	SNDRV_CHMAP_TFR = 23,
	SNDRV_CHMAP_TFC = 24,
	SNDRV_CHMAP_TRL = 25,
	SNDRV_CHMAP_TRR = 26,
	SNDRV_CHMAP_TRC = 27,
	SNDRV_CHMAP_TFLC = 28,
	SNDRV_CHMAP_TFRC = 29,
	SNDRV_CHMAP_TSL = 30,
	SNDRV_CHMAP_TSR = 31,
	SNDRV_CHMAP_LLFE = 32,
	SNDRV_CHMAP_RLFE = 33,
	SNDRV_CHMAP_BC = 34,
	SNDRV_CHMAP_BLC = 35,
	SNDRV_CHMAP_BRC = 36,
	SNDRV_CHMAP_LAST = 36,
};

enum {
	SNDRV_CTL_TLV_OP_READ = 0,
	SNDRV_CTL_TLV_OP_WRITE = 1,
	SNDRV_CTL_TLV_OP_CMD = -1,
};

enum {
	SNDRV_DEVICE_TYPE_CONTROL = 0,
	SNDRV_DEVICE_TYPE_SEQUENCER = 1,
	SNDRV_DEVICE_TYPE_TIMER = 2,
	SNDRV_DEVICE_TYPE_HWDEP = 3,
	SNDRV_DEVICE_TYPE_RAWMIDI = 4,
	SNDRV_DEVICE_TYPE_PCM_PLAYBACK = 5,
	SNDRV_DEVICE_TYPE_PCM_CAPTURE = 6,
	SNDRV_DEVICE_TYPE_COMPRESS = 7,
};

enum {
	SNDRV_HWDEP_IFACE_OPL2 = 0,
	SNDRV_HWDEP_IFACE_OPL3 = 1,
	SNDRV_HWDEP_IFACE_OPL4 = 2,
	SNDRV_HWDEP_IFACE_SB16CSP = 3,
	SNDRV_HWDEP_IFACE_EMU10K1 = 4,
	SNDRV_HWDEP_IFACE_YSS225 = 5,
	SNDRV_HWDEP_IFACE_ICS2115 = 6,
	SNDRV_HWDEP_IFACE_SSCAPE = 7,
	SNDRV_HWDEP_IFACE_VX = 8,
	SNDRV_HWDEP_IFACE_MIXART = 9,
	SNDRV_HWDEP_IFACE_USX2Y = 10,
	SNDRV_HWDEP_IFACE_EMUX_WAVETABLE = 11,
	SNDRV_HWDEP_IFACE_BLUETOOTH = 12,
	SNDRV_HWDEP_IFACE_USX2Y_PCM = 13,
	SNDRV_HWDEP_IFACE_PCXHR = 14,
	SNDRV_HWDEP_IFACE_SB_RC = 15,
	SNDRV_HWDEP_IFACE_HDA = 16,
	SNDRV_HWDEP_IFACE_USB_STREAM = 17,
	SNDRV_HWDEP_IFACE_FW_DICE = 18,
	SNDRV_HWDEP_IFACE_FW_FIREWORKS = 19,
	SNDRV_HWDEP_IFACE_FW_BEBOB = 20,
	SNDRV_HWDEP_IFACE_FW_OXFW = 21,
	SNDRV_HWDEP_IFACE_FW_DIGI00X = 22,
	SNDRV_HWDEP_IFACE_FW_TASCAM = 23,
	SNDRV_HWDEP_IFACE_LINE6 = 24,
	SNDRV_HWDEP_IFACE_FW_MOTU = 25,
	SNDRV_HWDEP_IFACE_FW_FIREFACE = 26,
	SNDRV_HWDEP_IFACE_LAST = 26,
};

enum {
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_COMPAT = 0,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_DEFAULT = 1,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK = 2,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ABSOLUTE = 3,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ESTIMATED = 4,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_SYNCHRONIZED = 5,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LAST = 5,
};

enum {
	SNDRV_PCM_CLASS_GENERIC = 0,
	SNDRV_PCM_CLASS_MULTI = 1,
	SNDRV_PCM_CLASS_MODEM = 2,
	SNDRV_PCM_CLASS_DIGITIZER = 3,
	SNDRV_PCM_CLASS_LAST = 3,
};

enum {
	SNDRV_PCM_MMAP_OFFSET_DATA = 0,
	SNDRV_PCM_MMAP_OFFSET_STATUS_OLD = 2147483648,
	SNDRV_PCM_MMAP_OFFSET_CONTROL_OLD = 2164260864,
	SNDRV_PCM_MMAP_OFFSET_STATUS_NEW = 2181038080,
	SNDRV_PCM_MMAP_OFFSET_CONTROL_NEW = 2197815296,
	SNDRV_PCM_MMAP_OFFSET_STATUS = 2181038080,
	SNDRV_PCM_MMAP_OFFSET_CONTROL = 2197815296,
};

enum {
	SNDRV_PCM_STREAM_PLAYBACK = 0,
	SNDRV_PCM_STREAM_CAPTURE = 1,
	SNDRV_PCM_STREAM_LAST = 1,
};

enum {
	SNDRV_PCM_TSTAMP_NONE = 0,
	SNDRV_PCM_TSTAMP_ENABLE = 1,
	SNDRV_PCM_TSTAMP_LAST = 1,
};

enum {
	SNDRV_PCM_TSTAMP_TYPE_GETTIMEOFDAY = 0,
	SNDRV_PCM_TSTAMP_TYPE_MONOTONIC = 1,
	SNDRV_PCM_TSTAMP_TYPE_MONOTONIC_RAW = 2,
	SNDRV_PCM_TSTAMP_TYPE_LAST = 2,
};

enum {
	SNDRV_TIMER_CLASS_NONE = -1,
	SNDRV_TIMER_CLASS_SLAVE = 0,
	SNDRV_TIMER_CLASS_GLOBAL = 1,
	SNDRV_TIMER_CLASS_CARD = 2,
	SNDRV_TIMER_CLASS_PCM = 3,
	SNDRV_TIMER_CLASS_LAST = 3,
};

enum {
	SNDRV_TIMER_EVENT_RESOLUTION = 0,
	SNDRV_TIMER_EVENT_TICK = 1,
	SNDRV_TIMER_EVENT_START = 2,
	SNDRV_TIMER_EVENT_STOP = 3,
	SNDRV_TIMER_EVENT_CONTINUE = 4,
	SNDRV_TIMER_EVENT_PAUSE = 5,
	SNDRV_TIMER_EVENT_EARLY = 6,
	SNDRV_TIMER_EVENT_SUSPEND = 7,
	SNDRV_TIMER_EVENT_RESUME = 8,
	SNDRV_TIMER_EVENT_MSTART = 12,
	SNDRV_TIMER_EVENT_MSTOP = 13,
	SNDRV_TIMER_EVENT_MCONTINUE = 14,
	SNDRV_TIMER_EVENT_MPAUSE = 15,
	SNDRV_TIMER_EVENT_MSUSPEND = 17,
	SNDRV_TIMER_EVENT_MRESUME = 18,
};

enum {
	SNDRV_TIMER_IOCTL_START_OLD = 21536,
	SNDRV_TIMER_IOCTL_STOP_OLD = 21537,
	SNDRV_TIMER_IOCTL_CONTINUE_OLD = 21538,
	SNDRV_TIMER_IOCTL_PAUSE_OLD = 21539,
};

enum {
	SNDRV_TIMER_SCLASS_NONE = 0,
	SNDRV_TIMER_SCLASS_APPLICATION = 1,
	SNDRV_TIMER_SCLASS_SEQUENCER = 2,
	SNDRV_TIMER_SCLASS_OSS_SEQUENCER = 3,
	SNDRV_TIMER_SCLASS_LAST = 3,
};

enum {
	SND_CTL_SUBDEV_PCM = 0,
	SND_CTL_SUBDEV_RAWMIDI = 1,
	SND_CTL_SUBDEV_ITEMS = 2,
};

enum {
	SND_INTEL_DSP_DRIVER_ANY = 0,
	SND_INTEL_DSP_DRIVER_LEGACY = 1,
	SND_INTEL_DSP_DRIVER_SST = 2,
	SND_INTEL_DSP_DRIVER_SOF = 3,
	SND_INTEL_DSP_DRIVER_AVS = 4,
	SND_INTEL_DSP_DRIVER_LAST = 4,
};

enum {
	SOCK_WAKE_IO = 0,
	SOCK_WAKE_WAITD = 1,
	SOCK_WAKE_SPACE = 2,
	SOCK_WAKE_URG = 3,
};

enum {
	SOF_TIMESTAMPING_TX_HARDWARE = 1,
	SOF_TIMESTAMPING_TX_SOFTWARE = 2,
	SOF_TIMESTAMPING_RX_HARDWARE = 4,
	SOF_TIMESTAMPING_RX_SOFTWARE = 8,
	SOF_TIMESTAMPING_SOFTWARE = 16,
	SOF_TIMESTAMPING_SYS_HARDWARE = 32,
	SOF_TIMESTAMPING_RAW_HARDWARE = 64,
	SOF_TIMESTAMPING_OPT_ID = 128,
	SOF_TIMESTAMPING_TX_SCHED = 256,
	SOF_TIMESTAMPING_TX_ACK = 512,
	SOF_TIMESTAMPING_OPT_CMSG = 1024,
	SOF_TIMESTAMPING_OPT_TSONLY = 2048,
	SOF_TIMESTAMPING_OPT_STATS = 4096,
	SOF_TIMESTAMPING_OPT_PKTINFO = 8192,
	SOF_TIMESTAMPING_OPT_TX_SWHW = 16384,
	SOF_TIMESTAMPING_BIND_PHC = 32768,
	SOF_TIMESTAMPING_OPT_ID_TCP = 65536,
	SOF_TIMESTAMPING_OPT_RX_FILTER = 131072,
	SOF_TIMESTAMPING_LAST = 131072,
	SOF_TIMESTAMPING_MASK = 262143,
};

enum {
	SP_TASK_PENDING = 0,
	SP_NEED_VICTIM = 1,
	SP_VICTIM_REMAINS = 2,
};

enum {
	STAC_9205_REF = 0,
	STAC_9205_DELL_M42 = 1,
	STAC_9205_DELL_M43 = 2,
	STAC_9205_DELL_M44 = 3,
	STAC_9205_EAPD = 4,
	STAC_9205_MODELS = 5,
};

enum {
	STAC_925x_REF = 0,
	STAC_M1 = 1,
	STAC_M1_2 = 2,
	STAC_M2 = 3,
	STAC_M2_2 = 4,
	STAC_M3 = 5,
	STAC_M5 = 6,
	STAC_M6 = 7,
	STAC_925x_MODELS = 8,
};

enum {
	STAC_92HD71BXX_REF = 0,
	STAC_DELL_M4_1 = 1,
	STAC_DELL_M4_2 = 2,
	STAC_DELL_M4_3 = 3,
	STAC_HP_M4 = 4,
	STAC_HP_DV4 = 5,
	STAC_HP_DV5 = 6,
	STAC_HP_HDX = 7,
	STAC_92HD71BXX_HP = 8,
	STAC_92HD71BXX_NO_DMIC = 9,
	STAC_92HD71BXX_NO_SMUX = 10,
	STAC_92HD71BXX_MODELS = 11,
};

enum {
	STAC_92HD73XX_NO_JD = 0,
	STAC_92HD73XX_REF = 1,
	STAC_92HD73XX_INTEL = 2,
	STAC_DELL_M6_AMIC = 3,
	STAC_DELL_M6_DMIC = 4,
	STAC_DELL_M6_BOTH = 5,
	STAC_DELL_EQ = 6,
	STAC_ALIENWARE_M17X = 7,
	STAC_ELO_VUPOINT_15MX = 8,
	STAC_92HD89XX_HP_FRONT_JACK = 9,
	STAC_92HD89XX_HP_Z1_G2_RIGHT_MIC_JACK = 10,
	STAC_92HD73XX_ASUS_MOBO = 11,
	STAC_92HD73XX_MODELS = 12,
};

enum {
	STAC_92HD83XXX_REF = 0,
	STAC_92HD83XXX_PWR_REF = 1,
	STAC_DELL_S14 = 2,
	STAC_DELL_VOSTRO_3500 = 3,
	STAC_92HD83XXX_HP_cNB11_INTQUAD = 4,
	STAC_HP_DV7_4000 = 5,
	STAC_HP_ZEPHYR = 6,
	STAC_92HD83XXX_HP_LED = 7,
	STAC_92HD83XXX_HP_INV_LED = 8,
	STAC_92HD83XXX_HP_MIC_LED = 9,
	STAC_HP_LED_GPIO10 = 10,
	STAC_92HD83XXX_HEADSET_JACK = 11,
	STAC_92HD83XXX_HP = 12,
	STAC_HP_ENVY_BASS = 13,
	STAC_HP_BNB13_EQ = 14,
	STAC_HP_ENVY_TS_BASS = 15,
	STAC_HP_ENVY_TS_DAC_BIND = 16,
	STAC_92HD83XXX_GPIO10_EAPD = 17,
	STAC_92HD83XXX_MODELS = 18,
};

enum {
	STAC_92HD95_HP_LED = 0,
	STAC_92HD95_HP_BASS = 1,
	STAC_92HD95_MODELS = 2,
};

enum {
	STAC_9872_VAIO = 0,
	STAC_9872_MODELS = 1,
};

enum {
	STAC_D945_REF = 0,
	STAC_D945GTP3 = 1,
	STAC_D945GTP5 = 2,
	STAC_INTEL_MAC_V1 = 3,
	STAC_INTEL_MAC_V2 = 4,
	STAC_INTEL_MAC_V3 = 5,
	STAC_INTEL_MAC_V4 = 6,
	STAC_INTEL_MAC_V5 = 7,
	STAC_INTEL_MAC_AUTO = 8,
	STAC_ECS_202 = 9,
	STAC_922X_DELL_D81 = 10,
	STAC_922X_DELL_D82 = 11,
	STAC_922X_DELL_M81 = 12,
	STAC_922X_DELL_M82 = 13,
	STAC_922X_INTEL_MAC_GPIO = 14,
	STAC_922X_MODELS = 15,
};

enum {
	STAC_D965_REF_NO_JD = 0,
	STAC_D965_REF = 1,
	STAC_D965_3ST = 2,
	STAC_D965_5ST = 3,
	STAC_D965_5ST_NO_FP = 4,
	STAC_D965_VERBS = 5,
	STAC_DELL_3ST = 6,
	STAC_DELL_BIOS = 7,
	STAC_NEMO_DEFAULT = 8,
	STAC_DELL_BIOS_AMIC = 9,
	STAC_DELL_BIOS_SPDIF = 10,
	STAC_927X_DELL_DMIC = 11,
	STAC_927X_VOLKNOB = 12,
	STAC_927X_MODELS = 13,
};

enum {
	STAC_REF = 0,
	STAC_9200_OQO = 1,
	STAC_9200_DELL_D21 = 2,
	STAC_9200_DELL_D22 = 3,
	STAC_9200_DELL_D23 = 4,
	STAC_9200_DELL_M21 = 5,
	STAC_9200_DELL_M22 = 6,
	STAC_9200_DELL_M23 = 7,
	STAC_9200_DELL_M24 = 8,
	STAC_9200_DELL_M25 = 9,
	STAC_9200_DELL_M26 = 10,
	STAC_9200_DELL_M27 = 11,
	STAC_9200_M4 = 12,
	STAC_9200_M4_2 = 13,
	STAC_9200_PANASONIC = 14,
	STAC_9200_EAPD_INIT = 15,
	STAC_9200_MODELS = 16,
};

enum {
	STREAM_MULTI_OUT = 0,
	STREAM_INDEP_HP = 1,
};

enum {
	SUNRPC_PIPEFS_NFS_PRIO = 0,
	SUNRPC_PIPEFS_RPC_PRIO = 1,
};

enum {
	SVC_HANDSHAKE_TO = 1250,
};

enum {
	SVC_POOL_AUTO = -1,
	SVC_POOL_GLOBAL = 0,
	SVC_POOL_PERCPU = 1,
	SVC_POOL_PERNODE = 2,
};

enum {
	SWITCHTEC_GAS_MRPC_OFFSET = 0,
	SWITCHTEC_GAS_TOP_CFG_OFFSET = 4096,
	SWITCHTEC_GAS_SW_EVENT_OFFSET = 6144,
	SWITCHTEC_GAS_SYS_INFO_OFFSET = 8192,
	SWITCHTEC_GAS_FLASH_INFO_OFFSET = 8704,
	SWITCHTEC_GAS_PART_CFG_OFFSET = 16384,
	SWITCHTEC_GAS_NTB_OFFSET = 65536,
	SWITCHTEC_GAS_PFF_CSR_OFFSET = 1261568,
};

enum {
	SWITCHTEC_NTB_REG_INFO_OFFSET = 0,
	SWITCHTEC_NTB_REG_CTRL_OFFSET = 16384,
	SWITCHTEC_NTB_REG_DBMSG_OFFSET = 409600,
};

enum {
	SWMII_SPEED_10 = 0,
	SWMII_SPEED_100 = 1,
	SWMII_SPEED_1000 = 2,
	SWMII_DUPLEX_HALF = 0,
	SWMII_DUPLEX_FULL = 1,
};

enum {
	SWP_USED = 1,
	SWP_WRITEOK = 2,
	SWP_DISCARDABLE = 4,
	SWP_DISCARDING = 8,
	SWP_SOLIDSTATE = 16,
	SWP_CONTINUED = 32,
	SWP_BLKDEV = 64,
	SWP_ACTIVATED = 128,
	SWP_FS_OPS = 256,
	SWP_AREA_DISCARD = 512,
	SWP_PAGE_DISCARD = 1024,
	SWP_STABLE_WRITES = 2048,
	SWP_SYNCHRONOUS_IO = 4096,
};

enum {
	SYNAPTICS_INTERTOUCH_NOT_SET = -1,
	SYNAPTICS_INTERTOUCH_OFF = 0,
	SYNAPTICS_INTERTOUCH_ON = 1,
};

enum {
	TASKLET_STATE_SCHED = 0,
	TASKLET_STATE_RUN = 1,
};

enum {
	TASKSTATS_CMD_ATTR_UNSPEC = 0,
	TASKSTATS_CMD_ATTR_PID = 1,
	TASKSTATS_CMD_ATTR_TGID = 2,
	TASKSTATS_CMD_ATTR_REGISTER_CPUMASK = 3,
	TASKSTATS_CMD_ATTR_DEREGISTER_CPUMASK = 4,
	__TASKSTATS_CMD_ATTR_MAX = 5,
};

enum {
	TASKSTATS_CMD_UNSPEC = 0,
	TASKSTATS_CMD_GET = 1,
	TASKSTATS_CMD_NEW = 2,
	__TASKSTATS_CMD_MAX = 3,
};

enum {
	TASKSTATS_TYPE_UNSPEC = 0,
	TASKSTATS_TYPE_PID = 1,
	TASKSTATS_TYPE_TGID = 2,
	TASKSTATS_TYPE_STATS = 3,
	TASKSTATS_TYPE_AGGR_PID = 4,
	TASKSTATS_TYPE_AGGR_TGID = 5,
	TASKSTATS_TYPE_NULL = 6,
	__TASKSTATS_TYPE_MAX = 7,
};

enum {
	TASK_COMM_LEN = 16,
};

enum {
	TCA_ACT_UNSPEC = 0,
	TCA_ACT_KIND = 1,
	TCA_ACT_OPTIONS = 2,
	TCA_ACT_INDEX = 3,
	TCA_ACT_STATS = 4,
	TCA_ACT_PAD = 5,
	TCA_ACT_COOKIE = 6,
	TCA_ACT_FLAGS = 7,
	TCA_ACT_HW_STATS = 8,
	TCA_ACT_USED_HW_STATS = 9,
	TCA_ACT_IN_HW_COUNT = 10,
	__TCA_ACT_MAX = 11,
};

enum {
	TCA_FLOWER_KEY_CT_FLAGS_NEW = 1,
	TCA_FLOWER_KEY_CT_FLAGS_ESTABLISHED = 2,
	TCA_FLOWER_KEY_CT_FLAGS_RELATED = 4,
	TCA_FLOWER_KEY_CT_FLAGS_TRACKED = 8,
	TCA_FLOWER_KEY_CT_FLAGS_INVALID = 16,
	TCA_FLOWER_KEY_CT_FLAGS_REPLY = 32,
	__TCA_FLOWER_KEY_CT_FLAGS_MAX = 33,
};

enum {
	TCA_FLOWER_KEY_FLAGS_IS_FRAGMENT = 1,
	TCA_FLOWER_KEY_FLAGS_FRAG_IS_FIRST = 2,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CSUM = 4,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_DONT_FRAGMENT = 8,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_OAM = 16,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CRIT_OPT = 32,
	__TCA_FLOWER_KEY_FLAGS_MAX = 33,
};

enum {
	TCA_ROOT_UNSPEC = 0,
	TCA_ROOT_TAB = 1,
	TCA_ROOT_FLAGS = 2,
	TCA_ROOT_COUNT = 3,
	TCA_ROOT_TIME_DELTA = 4,
	TCA_ROOT_EXT_WARN_MSG = 5,
	__TCA_ROOT_MAX = 6,
};

enum {
	TCA_STAB_UNSPEC = 0,
	TCA_STAB_BASE = 1,
	TCA_STAB_DATA = 2,
	__TCA_STAB_MAX = 3,
};

enum {
	TCA_STATS_UNSPEC = 0,
	TCA_STATS_BASIC = 1,
	TCA_STATS_RATE_EST = 2,
	TCA_STATS_QUEUE = 3,
	TCA_STATS_APP = 4,
	TCA_STATS_RATE_EST64 = 5,
	TCA_STATS_PAD = 6,
	TCA_STATS_BASIC_HW = 7,
	TCA_STATS_PKT64 = 8,
	__TCA_STATS_MAX = 9,
};

enum {
	TCA_UNSPEC = 0,
	TCA_KIND = 1,
	TCA_OPTIONS = 2,
	TCA_STATS = 3,
	TCA_XSTATS = 4,
	TCA_RATE = 5,
	TCA_FCNT = 6,
	TCA_STATS2 = 7,
	TCA_STAB = 8,
	TCA_PAD = 9,
	TCA_DUMP_INVISIBLE = 10,
	TCA_CHAIN = 11,
	TCA_HW_OFFLOAD = 12,
	TCA_INGRESS_BLOCK = 13,
	TCA_EGRESS_BLOCK = 14,
	TCA_DUMP_FLAGS = 15,
	TCA_EXT_WARN_MSG = 16,
	__TCA_MAX = 17,
};

enum {
	TCPF_ESTABLISHED = 2,
	TCPF_SYN_SENT = 4,
	TCPF_SYN_RECV = 8,
	TCPF_FIN_WAIT1 = 16,
	TCPF_FIN_WAIT2 = 32,
	TCPF_TIME_WAIT = 64,
	TCPF_CLOSE = 128,
	TCPF_CLOSE_WAIT = 256,
	TCPF_LAST_ACK = 512,
	TCPF_LISTEN = 1024,
	TCPF_CLOSING = 2048,
	TCPF_NEW_SYN_RECV = 4096,
	TCPF_BOUND_INACTIVE = 8192,
};

enum {
	TCP_BPF_BASE = 0,
	TCP_BPF_TX = 1,
	TCP_BPF_RX = 2,
	TCP_BPF_TXRX = 3,
	TCP_BPF_NUM_CFGS = 4,
};

enum {
	TCP_BPF_IPV4 = 0,
	TCP_BPF_IPV6 = 1,
	TCP_BPF_NUM_PROTS = 2,
};

enum {
	TCP_BPF_IW = 1001,
	TCP_BPF_SNDCWND_CLAMP = 1002,
	TCP_BPF_DELACK_MAX = 1003,
	TCP_BPF_RTO_MIN = 1004,
	TCP_BPF_SYN = 1005,
	TCP_BPF_SYN_IP = 1006,
	TCP_BPF_SYN_MAC = 1007,
	TCP_BPF_SOCK_OPS_CB_FLAGS = 1008,
};

enum {
	TCP_CMSG_INQ = 1,
	TCP_CMSG_TS = 2,
};

enum {
	TCP_ESTABLISHED = 1,
	TCP_SYN_SENT = 2,
	TCP_SYN_RECV = 3,
	TCP_FIN_WAIT1 = 4,
	TCP_FIN_WAIT2 = 5,
	TCP_TIME_WAIT = 6,
	TCP_CLOSE = 7,
	TCP_CLOSE_WAIT = 8,
	TCP_LAST_ACK = 9,
	TCP_LISTEN = 10,
	TCP_CLOSING = 11,
	TCP_NEW_SYN_RECV = 12,
	TCP_BOUND_INACTIVE = 13,
	TCP_MAX_STATES = 14,
};

enum {
	TCP_FLAG_CWR = 32768,
	TCP_FLAG_ECE = 16384,
	TCP_FLAG_URG = 8192,
	TCP_FLAG_ACK = 4096,
	TCP_FLAG_PSH = 2048,
	TCP_FLAG_RST = 1024,
	TCP_FLAG_SYN = 512,
	TCP_FLAG_FIN = 256,
	TCP_RESERVED_BITS = 15,
	TCP_DATA_OFFSET = 240,
};

enum {
	TCP_METRICS_ATTR_UNSPEC = 0,
	TCP_METRICS_ATTR_ADDR_IPV4 = 1,
	TCP_METRICS_ATTR_ADDR_IPV6 = 2,
	TCP_METRICS_ATTR_AGE = 3,
	TCP_METRICS_ATTR_TW_TSVAL = 4,
	TCP_METRICS_ATTR_TW_TS_STAMP = 5,
	TCP_METRICS_ATTR_VALS = 6,
	TCP_METRICS_ATTR_FOPEN_MSS = 7,
	TCP_METRICS_ATTR_FOPEN_SYN_DROPS = 8,
	TCP_METRICS_ATTR_FOPEN_SYN_DROP_TS = 9,
	TCP_METRICS_ATTR_FOPEN_COOKIE = 10,
	TCP_METRICS_ATTR_SADDR_IPV4 = 11,
	TCP_METRICS_ATTR_SADDR_IPV6 = 12,
	TCP_METRICS_ATTR_PAD = 13,
	__TCP_METRICS_ATTR_MAX = 14,
};

enum {
	TCP_METRICS_CMD_UNSPEC = 0,
	TCP_METRICS_CMD_GET = 1,
	TCP_METRICS_CMD_DEL = 2,
	__TCP_METRICS_CMD_MAX = 3,
};

enum {
	TCP_MIB_NUM = 0,
	TCP_MIB_RTOALGORITHM = 1,
	TCP_MIB_RTOMIN = 2,
	TCP_MIB_RTOMAX = 3,
	TCP_MIB_MAXCONN = 4,
	TCP_MIB_ACTIVEOPENS = 5,
	TCP_MIB_PASSIVEOPENS = 6,
	TCP_MIB_ATTEMPTFAILS = 7,
	TCP_MIB_ESTABRESETS = 8,
	TCP_MIB_CURRESTAB = 9,
	TCP_MIB_INSEGS = 10,
	TCP_MIB_OUTSEGS = 11,
	TCP_MIB_RETRANSSEGS = 12,
	TCP_MIB_INERRS = 13,
	TCP_MIB_OUTRSTS = 14,
	TCP_MIB_CSUMERRORS = 15,
	__TCP_MIB_MAX = 16,
};

enum {
	TCP_NLA_PAD = 0,
	TCP_NLA_BUSY = 1,
	TCP_NLA_RWND_LIMITED = 2,
	TCP_NLA_SNDBUF_LIMITED = 3,
	TCP_NLA_DATA_SEGS_OUT = 4,
	TCP_NLA_TOTAL_RETRANS = 5,
	TCP_NLA_PACING_RATE = 6,
	TCP_NLA_DELIVERY_RATE = 7,
	TCP_NLA_SND_CWND = 8,
	TCP_NLA_REORDERING = 9,
	TCP_NLA_MIN_RTT = 10,
	TCP_NLA_RECUR_RETRANS = 11,
	TCP_NLA_DELIVERY_RATE_APP_LMT = 12,
	TCP_NLA_SNDQ_SIZE = 13,
	TCP_NLA_CA_STATE = 14,
	TCP_NLA_SND_SSTHRESH = 15,
	TCP_NLA_DELIVERED = 16,
	TCP_NLA_DELIVERED_CE = 17,
	TCP_NLA_BYTES_SENT = 18,
	TCP_NLA_BYTES_RETRANS = 19,
	TCP_NLA_DSACK_DUPS = 20,
	TCP_NLA_REORD_SEEN = 21,
	TCP_NLA_SRTT = 22,
	TCP_NLA_TIMEOUT_REHASH = 23,
	TCP_NLA_BYTES_NOTSENT = 24,
	TCP_NLA_EDT = 25,
	TCP_NLA_TTL = 26,
	TCP_NLA_REHASH = 27,
};

enum {
	TCP_NO_QUEUE = 0,
	TCP_RECV_QUEUE = 1,
	TCP_SEND_QUEUE = 2,
	TCP_QUEUES_NR = 3,
};

enum {
	TC_MQPRIO_HW_OFFLOAD_NONE = 0,
	TC_MQPRIO_HW_OFFLOAD_TCS = 1,
	__TC_MQPRIO_HW_OFFLOAD_MAX = 2,
};

enum {
	TC_TAPRIO_CMD_SET_GATES = 0,
	TC_TAPRIO_CMD_SET_AND_HOLD = 1,
	TC_TAPRIO_CMD_SET_AND_RELEASE = 2,
};

enum {
	TEST_ALIGNMENT = 16,
};

enum {
	TEST_NONE = 0,
	TEST_CORE = 1,
	TEST_CPUS = 2,
	TEST_PLATFORM = 3,
	TEST_DEVICES = 4,
	TEST_FREEZER = 5,
	__TEST_AFTER_LAST = 6,
};

enum {
	TLS_ALERT_DESC_CLOSE_NOTIFY = 0,
	TLS_ALERT_DESC_UNEXPECTED_MESSAGE = 10,
	TLS_ALERT_DESC_BAD_RECORD_MAC = 20,
	TLS_ALERT_DESC_RECORD_OVERFLOW = 22,
	TLS_ALERT_DESC_HANDSHAKE_FAILURE = 40,
	TLS_ALERT_DESC_BAD_CERTIFICATE = 42,
	TLS_ALERT_DESC_UNSUPPORTED_CERTIFICATE = 43,
	TLS_ALERT_DESC_CERTIFICATE_REVOKED = 44,
	TLS_ALERT_DESC_CERTIFICATE_EXPIRED = 45,
	TLS_ALERT_DESC_CERTIFICATE_UNKNOWN = 46,
	TLS_ALERT_DESC_ILLEGAL_PARAMETER = 47,
	TLS_ALERT_DESC_UNKNOWN_CA = 48,
	TLS_ALERT_DESC_ACCESS_DENIED = 49,
	TLS_ALERT_DESC_DECODE_ERROR = 50,
	TLS_ALERT_DESC_DECRYPT_ERROR = 51,
	TLS_ALERT_DESC_TOO_MANY_CIDS_REQUESTED = 52,
	TLS_ALERT_DESC_PROTOCOL_VERSION = 70,
	TLS_ALERT_DESC_INSUFFICIENT_SECURITY = 71,
	TLS_ALERT_DESC_INTERNAL_ERROR = 80,
	TLS_ALERT_DESC_INAPPROPRIATE_FALLBACK = 86,
	TLS_ALERT_DESC_USER_CANCELED = 90,
	TLS_ALERT_DESC_MISSING_EXTENSION = 109,
	TLS_ALERT_DESC_UNSUPPORTED_EXTENSION = 110,
	TLS_ALERT_DESC_UNRECOGNIZED_NAME = 112,
	TLS_ALERT_DESC_BAD_CERTIFICATE_STATUS_RESPONSE = 113,
	TLS_ALERT_DESC_UNKNOWN_PSK_IDENTITY = 115,
	TLS_ALERT_DESC_CERTIFICATE_REQUIRED = 116,
	TLS_ALERT_DESC_NO_APPLICATION_PROTOCOL = 120,
};

enum {
	TLS_ALERT_LEVEL_WARNING = 1,
	TLS_ALERT_LEVEL_FATAL = 2,
};

enum {
	TLS_NO_KEYRING = 0,
	TLS_NO_PEERID = 0,
	TLS_NO_CERT = 0,
	TLS_NO_PRIVKEY = 0,
};

enum {
	TLS_RECORD_TYPE_CHANGE_CIPHER_SPEC = 20,
	TLS_RECORD_TYPE_ALERT = 21,
	TLS_RECORD_TYPE_HANDSHAKE = 22,
	TLS_RECORD_TYPE_DATA = 23,
	TLS_RECORD_TYPE_HEARTBEAT = 24,
	TLS_RECORD_TYPE_TLS12_CID = 25,
	TLS_RECORD_TYPE_ACK = 26,
};

enum {
	TOO_MANY_CLOSE = -1,
	TOO_MANY_OPEN = -2,
	MISSING_QUOTE = -3,
};

enum {
	TP_ERR_FILE_NOT_FOUND = 0,
	TP_ERR_NO_REGULAR_FILE = 1,
	TP_ERR_BAD_REFCNT = 2,
	TP_ERR_REFCNT_OPEN_BRACE = 3,
	TP_ERR_BAD_REFCNT_SUFFIX = 4,
	TP_ERR_BAD_UPROBE_OFFS = 5,
	TP_ERR_BAD_MAXACT_TYPE = 6,
	TP_ERR_BAD_MAXACT = 7,
	TP_ERR_MAXACT_TOO_BIG = 8,
	TP_ERR_BAD_PROBE_ADDR = 9,
	TP_ERR_NON_UNIQ_SYMBOL = 10,
	TP_ERR_BAD_RETPROBE = 11,
	TP_ERR_NO_TRACEPOINT = 12,
	TP_ERR_BAD_TP_NAME = 13,
	TP_ERR_BAD_ADDR_SUFFIX = 14,
	TP_ERR_NO_GROUP_NAME = 15,
	TP_ERR_GROUP_TOO_LONG = 16,
	TP_ERR_BAD_GROUP_NAME = 17,
	TP_ERR_NO_EVENT_NAME = 18,
	TP_ERR_EVENT_TOO_LONG = 19,
	TP_ERR_BAD_EVENT_NAME = 20,
	TP_ERR_EVENT_EXIST = 21,
	TP_ERR_RETVAL_ON_PROBE = 22,
	TP_ERR_NO_RETVAL = 23,
	TP_ERR_BAD_STACK_NUM = 24,
	TP_ERR_BAD_ARG_NUM = 25,
	TP_ERR_BAD_VAR = 26,
	TP_ERR_BAD_REG_NAME = 27,
	TP_ERR_BAD_MEM_ADDR = 28,
	TP_ERR_BAD_IMM = 29,
	TP_ERR_IMMSTR_NO_CLOSE = 30,
	TP_ERR_FILE_ON_KPROBE = 31,
	TP_ERR_BAD_FILE_OFFS = 32,
	TP_ERR_SYM_ON_UPROBE = 33,
	TP_ERR_TOO_MANY_OPS = 34,
	TP_ERR_DEREF_NEED_BRACE = 35,
	TP_ERR_BAD_DEREF_OFFS = 36,
	TP_ERR_DEREF_OPEN_BRACE = 37,
	TP_ERR_COMM_CANT_DEREF = 38,
	TP_ERR_BAD_FETCH_ARG = 39,
	TP_ERR_ARRAY_NO_CLOSE = 40,
	TP_ERR_BAD_ARRAY_SUFFIX = 41,
	TP_ERR_BAD_ARRAY_NUM = 42,
	TP_ERR_ARRAY_TOO_BIG = 43,
	TP_ERR_BAD_TYPE = 44,
	TP_ERR_BAD_STRING = 45,
	TP_ERR_BAD_SYMSTRING = 46,
	TP_ERR_BAD_BITFIELD = 47,
	TP_ERR_ARG_NAME_TOO_LONG = 48,
	TP_ERR_NO_ARG_NAME = 49,
	TP_ERR_BAD_ARG_NAME = 50,
	TP_ERR_USED_ARG_NAME = 51,
	TP_ERR_ARG_TOO_LONG = 52,
	TP_ERR_NO_ARG_BODY = 53,
	TP_ERR_BAD_INSN_BNDRY = 54,
	TP_ERR_FAIL_REG_PROBE = 55,
	TP_ERR_DIFF_PROBE_TYPE = 56,
	TP_ERR_DIFF_ARG_TYPE = 57,
	TP_ERR_SAME_PROBE = 58,
	TP_ERR_NO_EVENT_INFO = 59,
	TP_ERR_BAD_ATTACH_EVENT = 60,
	TP_ERR_BAD_ATTACH_ARG = 61,
	TP_ERR_NO_EP_FILTER = 62,
	TP_ERR_NOSUP_BTFARG = 63,
	TP_ERR_NO_BTFARG = 64,
	TP_ERR_NO_BTF_ENTRY = 65,
	TP_ERR_BAD_VAR_ARGS = 66,
	TP_ERR_NOFENTRY_ARGS = 67,
	TP_ERR_DOUBLE_ARGS = 68,
	TP_ERR_ARGS_2LONG = 69,
	TP_ERR_ARGIDX_2BIG = 70,
	TP_ERR_NO_PTR_STRCT = 71,
	TP_ERR_NOSUP_DAT_ARG = 72,
	TP_ERR_BAD_HYPHEN = 73,
	TP_ERR_NO_BTF_FIELD = 74,
	TP_ERR_BAD_BTF_TID = 75,
	TP_ERR_BAD_TYPE4STR = 76,
	TP_ERR_NEED_STRING_TYPE = 77,
	TP_ERR_TOO_MANY_EARGS = 78,
};

enum {
	TRACEFS_EVENT_INODE = 2,
	TRACEFS_GID_PERM_SET = 4,
	TRACEFS_UID_PERM_SET = 8,
	TRACEFS_INSTANCE_INODE = 16,
};

enum {
	TRACE_ARRAY_FL_GLOBAL = 1,
	TRACE_ARRAY_FL_BOOT = 2,
	TRACE_ARRAY_FL_MOD_INIT = 4,
};

enum {
	TRACE_EVENT_FL_CAP_ANY = 1,
	TRACE_EVENT_FL_NO_SET_FILTER = 2,
	TRACE_EVENT_FL_IGNORE_ENABLE = 4,
	TRACE_EVENT_FL_TRACEPOINT = 8,
	TRACE_EVENT_FL_DYNAMIC = 16,
	TRACE_EVENT_FL_KPROBE = 32,
	TRACE_EVENT_FL_UPROBE = 64,
	TRACE_EVENT_FL_EPROBE = 128,
	TRACE_EVENT_FL_FPROBE = 256,
	TRACE_EVENT_FL_CUSTOM = 512,
	TRACE_EVENT_FL_TEST_STR = 1024,
};

enum {
	TRACE_EVENT_FL_CAP_ANY_BIT = 0,
	TRACE_EVENT_FL_NO_SET_FILTER_BIT = 1,
	TRACE_EVENT_FL_IGNORE_ENABLE_BIT = 2,
	TRACE_EVENT_FL_TRACEPOINT_BIT = 3,
	TRACE_EVENT_FL_DYNAMIC_BIT = 4,
	TRACE_EVENT_FL_KPROBE_BIT = 5,
	TRACE_EVENT_FL_UPROBE_BIT = 6,
	TRACE_EVENT_FL_EPROBE_BIT = 7,
	TRACE_EVENT_FL_FPROBE_BIT = 8,
	TRACE_EVENT_FL_CUSTOM_BIT = 9,
	TRACE_EVENT_FL_TEST_STR_BIT = 10,
};

enum {
	TRACE_NOP_OPT_ACCEPT = 1,
	TRACE_NOP_OPT_REFUSE = 2,
};

enum {
	TRACE_PIDS = 1,
	TRACE_NO_PIDS = 2,
};

enum {
	TRACE_SIGNAL_DELIVERED = 0,
	TRACE_SIGNAL_IGNORED = 1,
	TRACE_SIGNAL_ALREADY_PENDING = 2,
	TRACE_SIGNAL_OVERFLOW_FAIL = 3,
	TRACE_SIGNAL_LOSE_INFO = 4,
};

enum {
	UDF_MAX_LINKS = 65535,
};

enum {
	UDP_BPF_IPV4 = 0,
	UDP_BPF_IPV6 = 1,
	UDP_BPF_NUM_PROTS = 2,
};

enum {
	UDP_FLAGS_CORK = 0,
	UDP_FLAGS_NO_CHECK6_TX = 1,
	UDP_FLAGS_NO_CHECK6_RX = 2,
	UDP_FLAGS_GRO_ENABLED = 3,
	UDP_FLAGS_ACCEPT_FRAGLIST = 4,
	UDP_FLAGS_ACCEPT_L4 = 5,
	UDP_FLAGS_ENCAP_ENABLED = 6,
	UDP_FLAGS_UDPLITE_SEND_CC = 7,
	UDP_FLAGS_UDPLITE_RECV_CC = 8,
};

enum {
	UDP_MIB_NUM = 0,
	UDP_MIB_INDATAGRAMS = 1,
	UDP_MIB_NOPORTS = 2,
	UDP_MIB_INERRORS = 3,
	UDP_MIB_OUTDATAGRAMS = 4,
	UDP_MIB_RCVBUFERRORS = 5,
	UDP_MIB_SNDBUFERRORS = 6,
	UDP_MIB_CSUMERRORS = 7,
	UDP_MIB_IGNOREDMULTI = 8,
	UDP_MIB_MEMERRORS = 9,
	__UDP_MIB_MAX = 10,
};

enum {
	UNAME26 = 131072,
	ADDR_NO_RANDOMIZE = 262144,
	FDPIC_FUNCPTRS = 524288,
	MMAP_PAGE_ZERO = 1048576,
	ADDR_COMPAT_LAYOUT = 2097152,
	READ_IMPLIES_EXEC = 4194304,
	ADDR_LIMIT_32BIT = 8388608,
	SHORT_INODE = 16777216,
	WHOLE_SECONDS = 33554432,
	STICKY_TIMEOUTS = 67108864,
	ADDR_LIMIT_3GB = 134217728,
};

enum {
	VDS_POS_PRIMARY_VOL_DESC = 0,
	VDS_POS_UNALLOC_SPACE_DESC = 1,
	VDS_POS_LOGICAL_VOL_DESC = 2,
	VDS_POS_IMP_USE_VOL_DESC = 3,
	VDS_POS_LENGTH = 4,
};

enum {
	VNIFILTER_ENTRY_STATS_UNSPEC = 0,
	VNIFILTER_ENTRY_STATS_RX_BYTES = 1,
	VNIFILTER_ENTRY_STATS_RX_PKTS = 2,
	VNIFILTER_ENTRY_STATS_RX_DROPS = 3,
	VNIFILTER_ENTRY_STATS_RX_ERRORS = 4,
	VNIFILTER_ENTRY_STATS_TX_BYTES = 5,
	VNIFILTER_ENTRY_STATS_TX_PKTS = 6,
	VNIFILTER_ENTRY_STATS_TX_DROPS = 7,
	VNIFILTER_ENTRY_STATS_TX_ERRORS = 8,
	VNIFILTER_ENTRY_STATS_PAD = 9,
	__VNIFILTER_ENTRY_STATS_MAX = 10,
};

enum {
	VP_MSIX_CONFIG_VECTOR = 0,
	VP_MSIX_VQ_VECTOR = 1,
};

enum {
	VTIME_PER_SEC_SHIFT = 37ULL,
	VTIME_PER_SEC = 137438953472ULL,
	VTIME_PER_USEC = 137438ULL,
	VTIME_PER_NSEC = 137ULL,
	VRATE_MIN_PPM = 10000ULL,
	VRATE_MAX_PPM = 100000000ULL,
	VRATE_MIN = 1374ULL,
	VRATE_CLAMP_ADJ_PCT = 4ULL,
	AUTOP_CYCLE_NSEC = 10000000000ULL,
};

enum {
	VXLAN_VNIFILTER_ENTRY_UNSPEC = 0,
	VXLAN_VNIFILTER_ENTRY_START = 1,
	VXLAN_VNIFILTER_ENTRY_END = 2,
	VXLAN_VNIFILTER_ENTRY_GROUP = 3,
	VXLAN_VNIFILTER_ENTRY_GROUP6 = 4,
	VXLAN_VNIFILTER_ENTRY_STATS = 5,
	__VXLAN_VNIFILTER_ENTRY_MAX = 6,
};

enum {
	VXLAN_VNIFILTER_UNSPEC = 0,
	VXLAN_VNIFILTER_ENTRY = 1,
	__VXLAN_VNIFILTER_MAX = 2,
};

enum {
	VXLAN_VNI_STATS_RX = 0,
	VXLAN_VNI_STATS_RX_DROPS = 1,
	VXLAN_VNI_STATS_RX_ERRORS = 2,
	VXLAN_VNI_STATS_TX = 3,
	VXLAN_VNI_STATS_TX_DROPS = 4,
	VXLAN_VNI_STATS_TX_ERRORS = 5,
};

enum {
	WALK_TRAILING = 1,
	WALK_MORE = 2,
	WALK_NOFOLLOW = 4,
};

enum {
	WBT_RWQ_BG = 0,
	WBT_RWQ_SWAP = 1,
	WBT_RWQ_DISCARD = 2,
	WBT_NUM_RWQ = 3,
};

enum {
	WBT_STATE_ON_DEFAULT = 1,
	WBT_STATE_ON_MANUAL = 2,
	WBT_STATE_OFF_DEFAULT = 3,
	WBT_STATE_OFF_MANUAL = 4,
};

enum {
	WORK_DONE_BIT = 0,
	WORK_ORDER_DONE_BIT = 1,
};

enum {
	XA_CHECK_SCHED = 4096,
};

enum {
	XDOMAIN_STATE_INIT = 0,
	XDOMAIN_STATE_UUID = 1,
	XDOMAIN_STATE_LINK_STATUS = 2,
	XDOMAIN_STATE_LINK_STATE_CHANGE = 3,
	XDOMAIN_STATE_LINK_STATUS2 = 4,
	XDOMAIN_STATE_BONDING_UUID_LOW = 5,
	XDOMAIN_STATE_BONDING_UUID_HIGH = 6,
	XDOMAIN_STATE_PROPERTIES = 7,
	XDOMAIN_STATE_ENUMERATED = 8,
	XDOMAIN_STATE_ERROR = 9,
};

enum {
	XDP_ATTACHED_NONE = 0,
	XDP_ATTACHED_DRV = 1,
	XDP_ATTACHED_SKB = 2,
	XDP_ATTACHED_HW = 3,
	XDP_ATTACHED_MULTI = 4,
};

enum {
	XFRM_DEV_OFFLOAD_FLAG_ACQ = 1,
};

enum {
	XFRM_DEV_OFFLOAD_IN = 1,
	XFRM_DEV_OFFLOAD_OUT = 2,
	XFRM_DEV_OFFLOAD_FWD = 3,
};

enum {
	XFRM_DEV_OFFLOAD_UNSPECIFIED = 0,
	XFRM_DEV_OFFLOAD_CRYPTO = 1,
	XFRM_DEV_OFFLOAD_PACKET = 2,
};

enum {
	XFRM_LOOKUP_ICMP = 1,
	XFRM_LOOKUP_QUEUE = 2,
	XFRM_LOOKUP_KEEP_DST_REF = 4,
};

enum {
	XFRM_MODE_FLAG_TUNNEL = 1,
};

enum {
	XFRM_MSG_BASE = 16,
	XFRM_MSG_NEWSA = 16,
	XFRM_MSG_DELSA = 17,
	XFRM_MSG_GETSA = 18,
	XFRM_MSG_NEWPOLICY = 19,
	XFRM_MSG_DELPOLICY = 20,
	XFRM_MSG_GETPOLICY = 21,
	XFRM_MSG_ALLOCSPI = 22,
	XFRM_MSG_ACQUIRE = 23,
	XFRM_MSG_EXPIRE = 24,
	XFRM_MSG_UPDPOLICY = 25,
	XFRM_MSG_UPDSA = 26,
	XFRM_MSG_POLEXPIRE = 27,
	XFRM_MSG_FLUSHSA = 28,
	XFRM_MSG_FLUSHPOLICY = 29,
	XFRM_MSG_NEWAE = 30,
	XFRM_MSG_GETAE = 31,
	XFRM_MSG_REPORT = 32,
	XFRM_MSG_MIGRATE = 33,
	XFRM_MSG_NEWSADINFO = 34,
	XFRM_MSG_GETSADINFO = 35,
	XFRM_MSG_NEWSPDINFO = 36,
	XFRM_MSG_GETSPDINFO = 37,
	XFRM_MSG_MAPPING = 38,
	XFRM_MSG_SETDEFAULT = 39,
	XFRM_MSG_GETDEFAULT = 40,
	__XFRM_MSG_MAX = 41,
};

enum {
	XFRM_POLICY_IN = 0,
	XFRM_POLICY_OUT = 1,
	XFRM_POLICY_FWD = 2,
	XFRM_POLICY_MASK = 3,
	XFRM_POLICY_MAX = 3,
};

enum {
	XFRM_POLICY_TYPE_MAIN = 0,
	XFRM_POLICY_TYPE_SUB = 1,
	XFRM_POLICY_TYPE_MAX = 2,
	XFRM_POLICY_TYPE_ANY = 255,
};

enum {
	XFRM_SHARE_ANY = 0,
	XFRM_SHARE_SESSION = 1,
	XFRM_SHARE_USER = 2,
	XFRM_SHARE_UNIQUE = 3,
};

enum {
	XFRM_STATE_VOID = 0,
	XFRM_STATE_ACQ = 1,
	XFRM_STATE_VALID = 2,
	XFRM_STATE_ERROR = 3,
	XFRM_STATE_EXPIRED = 4,
	XFRM_STATE_DEAD = 5,
};

enum {
	XFS_ERR_DEFAULT = 0,
	XFS_ERR_EIO = 1,
	XFS_ERR_ENOSPC = 2,
	XFS_ERR_ENODEV = 3,
	XFS_ERR_ERRNO_MAX = 4,
};

enum {
	XFS_ERR_METADATA = 0,
	XFS_ERR_CLASS_MAX = 1,
};

enum {
	XFS_LOWSP_1_PCNT = 0,
	XFS_LOWSP_2_PCNT = 1,
	XFS_LOWSP_3_PCNT = 2,
	XFS_LOWSP_4_PCNT = 3,
	XFS_LOWSP_5_PCNT = 4,
	XFS_LOWSP_MAX = 5,
};

enum {
	XFS_QLOWSP_1_PCNT = 0,
	XFS_QLOWSP_3_PCNT = 1,
	XFS_QLOWSP_5_PCNT = 2,
	XFS_QLOWSP_MAX = 3,
};

enum {
	XFS_QM_TRANS_USR = 0,
	XFS_QM_TRANS_GRP = 1,
	XFS_QM_TRANS_PRJ = 2,
	XFS_QM_TRANS_DQTYPES = 3,
};

enum {
	XPT_BUSY = 0,
	XPT_CONN = 1,
	XPT_CLOSE = 2,
	XPT_DATA = 3,
	XPT_TEMP = 4,
	XPT_DEAD = 5,
	XPT_CHNGBUF = 6,
	XPT_DEFERRED = 7,
	XPT_OLD = 8,
	XPT_LISTENER = 9,
	XPT_CACHE_AUTH = 10,
	XPT_LOCAL = 11,
	XPT_KILL_TEMP = 12,
	XPT_CONG_CTRL = 13,
	XPT_HANDSHAKE = 14,
	XPT_TLS_SESSION = 15,
	XPT_PEER_AUTH = 16,
	XPT_PEER_VALID = 17,
};

enum {
	ZONELIST_FALLBACK = 0,
	ZONELIST_NOFALLBACK = 1,
	MAX_ZONELISTS = 2,
};

enum {
	ZSTDbss_compress = 0,
	ZSTDbss_noCompress = 1,
};

enum {
	_DQUOT_USAGE_ENABLED = 0,
	_DQUOT_LIMITS_ENABLED = 1,
	_DQUOT_SUSPENDED = 2,
	_DQUOT_STATE_FLAGS = 3,
};

enum {
	_IRQ_DEFAULT_INIT_FLAGS = 1024,
	_IRQ_PER_CPU = 512,
	_IRQ_LEVEL = 256,
	_IRQ_NOPROBE = 1024,
	_IRQ_NOREQUEST = 2048,
	_IRQ_NOTHREAD = 65536,
	_IRQ_NOAUTOEN = 4096,
	_IRQ_NO_BALANCING = 8192,
	_IRQ_NESTED_THREAD = 32768,
	_IRQ_PER_CPU_DEVID = 131072,
	_IRQ_IS_POLLED = 262144,
	_IRQ_DISABLE_UNLAZY = 524288,
	_IRQ_HIDDEN = 1048576,
	_IRQ_NO_DEBUG = 2097152,
	_IRQF_MODIFY_MASK = 2080527,
};

enum {
	__EXTENT_DIRTY_BIT = 0,
	EXTENT_DIRTY = 1,
	__EXTENT_DIRTY_SEQ = 0,
	__EXTENT_UPTODATE_BIT = 1,
	EXTENT_UPTODATE = 2,
	__EXTENT_UPTODATE_SEQ = 1,
	__EXTENT_LOCKED_BIT = 2,
	EXTENT_LOCKED = 4,
	__EXTENT_LOCKED_SEQ = 2,
	__EXTENT_DIO_LOCKED_BIT = 3,
	EXTENT_DIO_LOCKED = 8,
	__EXTENT_DIO_LOCKED_SEQ = 3,
	__EXTENT_NEW_BIT = 4,
	EXTENT_NEW = 16,
	__EXTENT_NEW_SEQ = 4,
	__EXTENT_DELALLOC_BIT = 5,
	EXTENT_DELALLOC = 32,
	__EXTENT_DELALLOC_SEQ = 5,
	__EXTENT_DEFRAG_BIT = 6,
	EXTENT_DEFRAG = 64,
	__EXTENT_DEFRAG_SEQ = 6,
	__EXTENT_BOUNDARY_BIT = 7,
	EXTENT_BOUNDARY = 128,
	__EXTENT_BOUNDARY_SEQ = 7,
	__EXTENT_NODATASUM_BIT = 8,
	EXTENT_NODATASUM = 256,
	__EXTENT_NODATASUM_SEQ = 8,
	__EXTENT_CLEAR_META_RESV_BIT = 9,
	EXTENT_CLEAR_META_RESV = 512,
	__EXTENT_CLEAR_META_RESV_SEQ = 9,
	__EXTENT_NEED_WAIT_BIT = 10,
	EXTENT_NEED_WAIT = 1024,
	__EXTENT_NEED_WAIT_SEQ = 10,
	__EXTENT_NORESERVE_BIT = 11,
	EXTENT_NORESERVE = 2048,
	__EXTENT_NORESERVE_SEQ = 11,
	__EXTENT_QGROUP_RESERVED_BIT = 12,
	EXTENT_QGROUP_RESERVED = 4096,
	__EXTENT_QGROUP_RESERVED_SEQ = 12,
	__EXTENT_CLEAR_DATA_RESV_BIT = 13,
	EXTENT_CLEAR_DATA_RESV = 8192,
	__EXTENT_CLEAR_DATA_RESV_SEQ = 13,
	__EXTENT_DELALLOC_NEW_BIT = 14,
	EXTENT_DELALLOC_NEW = 16384,
	__EXTENT_DELALLOC_NEW_SEQ = 14,
	__EXTENT_ADD_INODE_BYTES_BIT = 15,
	EXTENT_ADD_INODE_BYTES = 32768,
	__EXTENT_ADD_INODE_BYTES_SEQ = 15,
	__EXTENT_CLEAR_ALL_BITS_BIT = 16,
	EXTENT_CLEAR_ALL_BITS = 65536,
	__EXTENT_CLEAR_ALL_BITS_SEQ = 16,
	__EXTENT_NOWAIT_BIT = 17,
	EXTENT_NOWAIT = 131072,
	__EXTENT_NOWAIT_SEQ = 17,
};

enum {
	__EXTENT_FLAG_PINNED_BIT = 0,
	EXTENT_FLAG_PINNED = 1,
	__EXTENT_FLAG_PINNED_SEQ = 0,
	__EXTENT_FLAG_COMPRESS_ZLIB_BIT = 1,
	EXTENT_FLAG_COMPRESS_ZLIB = 2,
	__EXTENT_FLAG_COMPRESS_ZLIB_SEQ = 1,
	__EXTENT_FLAG_COMPRESS_LZO_BIT = 2,
	EXTENT_FLAG_COMPRESS_LZO = 4,
	__EXTENT_FLAG_COMPRESS_LZO_SEQ = 2,
	__EXTENT_FLAG_COMPRESS_ZSTD_BIT = 3,
	EXTENT_FLAG_COMPRESS_ZSTD = 8,
	__EXTENT_FLAG_COMPRESS_ZSTD_SEQ = 3,
	__EXTENT_FLAG_PREALLOC_BIT = 4,
	EXTENT_FLAG_PREALLOC = 16,
	__EXTENT_FLAG_PREALLOC_SEQ = 4,
	__EXTENT_FLAG_LOGGING_BIT = 5,
	EXTENT_FLAG_LOGGING = 32,
	__EXTENT_FLAG_LOGGING_SEQ = 5,
	__EXTENT_FLAG_MERGED_BIT = 6,
	EXTENT_FLAG_MERGED = 64,
	__EXTENT_FLAG_MERGED_SEQ = 6,
};

enum {
	__ND_OPT_PREFIX_INFO_END = 0,
	ND_OPT_SOURCE_LL_ADDR = 1,
	ND_OPT_TARGET_LL_ADDR = 2,
	ND_OPT_PREFIX_INFO = 3,
	ND_OPT_REDIRECT_HDR = 4,
	ND_OPT_MTU = 5,
	ND_OPT_NONCE = 14,
	__ND_OPT_ARRAY_MAX = 15,
	ND_OPT_ROUTE_INFO = 24,
	ND_OPT_RDNSS = 25,
	ND_OPT_DNSSL = 31,
	ND_OPT_6CO = 34,
	ND_OPT_CAPTIVE_PORTAL = 37,
	ND_OPT_PREF64 = 38,
	__ND_OPT_MAX = 39,
};

enum {
	__PAGE_UNLOCK_BIT = 0,
	PAGE_UNLOCK = 1,
	__PAGE_UNLOCK_SEQ = 0,
	__PAGE_START_WRITEBACK_BIT = 1,
	PAGE_START_WRITEBACK = 2,
	__PAGE_START_WRITEBACK_SEQ = 1,
	__PAGE_END_WRITEBACK_BIT = 2,
	PAGE_END_WRITEBACK = 4,
	__PAGE_END_WRITEBACK_SEQ = 2,
	__PAGE_SET_ORDERED_BIT = 3,
	PAGE_SET_ORDERED = 8,
	__PAGE_SET_ORDERED_SEQ = 3,
};

enum {
	__PERCPU_REF_ATOMIC = 1,
	__PERCPU_REF_DEAD = 2,
	__PERCPU_REF_ATOMIC_DEAD = 3,
	__PERCPU_REF_FLAG_BITS = 2,
};

enum {
	__QGROUP_RESERVE_BIT = 0,
	QGROUP_RESERVE = 1,
	__QGROUP_RESERVE_SEQ = 0,
	__QGROUP_RELEASE_BIT = 1,
	QGROUP_RELEASE = 2,
	__QGROUP_RELEASE_SEQ = 1,
	__QGROUP_FREE_BIT = 2,
	QGROUP_FREE = 4,
	__QGROUP_FREE_SEQ = 2,
};

enum {
	__SCHED_FEAT_PLACE_LAG = 0,
	__SCHED_FEAT_PLACE_DEADLINE_INITIAL = 1,
	__SCHED_FEAT_PLACE_REL_DEADLINE = 2,
	__SCHED_FEAT_RUN_TO_PARITY = 3,
	__SCHED_FEAT_PREEMPT_SHORT = 4,
	__SCHED_FEAT_NEXT_BUDDY = 5,
	__SCHED_FEAT_PICK_BUDDY = 6,
	__SCHED_FEAT_CACHE_HOT_BUDDY = 7,
	__SCHED_FEAT_DELAY_DEQUEUE = 8,
	__SCHED_FEAT_DELAY_ZERO = 9,
	__SCHED_FEAT_WAKEUP_PREEMPTION = 10,
	__SCHED_FEAT_HRTICK = 11,
	__SCHED_FEAT_HRTICK_DL = 12,
	__SCHED_FEAT_NONTASK_CAPACITY = 13,
	__SCHED_FEAT_TTWU_QUEUE = 14,
	__SCHED_FEAT_SIS_UTIL = 15,
	__SCHED_FEAT_WARN_DOUBLE_CLOCK = 16,
	__SCHED_FEAT_RT_PUSH_IPI = 17,
	__SCHED_FEAT_RT_RUNTIME_SHARE = 18,
	__SCHED_FEAT_LB_MIN = 19,
	__SCHED_FEAT_ATTACH_AGE_LOAD = 20,
	__SCHED_FEAT_WA_IDLE = 21,
	__SCHED_FEAT_WA_WEIGHT = 22,
	__SCHED_FEAT_WA_BIAS = 23,
	__SCHED_FEAT_UTIL_EST = 24,
	__SCHED_FEAT_LATENCY_WARN = 25,
	__SCHED_FEAT_NR = 26,
};

enum {
	__XBTS_lookup = 0,
	__XBTS_compare = 1,
	__XBTS_insrec = 2,
	__XBTS_delrec = 3,
	__XBTS_newroot = 4,
	__XBTS_killroot = 5,
	__XBTS_increment = 6,
	__XBTS_decrement = 7,
	__XBTS_lshift = 8,
	__XBTS_rshift = 9,
	__XBTS_split = 10,
	__XBTS_join = 11,
	__XBTS_alloc = 12,
	__XBTS_free = 13,
	__XBTS_moves = 14,
	__XBTS_MAX = 15,
};

enum {
	___GFP_DMA_BIT = 0,
	___GFP_HIGHMEM_BIT = 1,
	___GFP_DMA32_BIT = 2,
	___GFP_MOVABLE_BIT = 3,
	___GFP_RECLAIMABLE_BIT = 4,
	___GFP_HIGH_BIT = 5,
	___GFP_IO_BIT = 6,
	___GFP_FS_BIT = 7,
	___GFP_ZERO_BIT = 8,
	___GFP_UNUSED_BIT = 9,
	___GFP_DIRECT_RECLAIM_BIT = 10,
	___GFP_KSWAPD_RECLAIM_BIT = 11,
	___GFP_WRITE_BIT = 12,
	___GFP_NOWARN_BIT = 13,
	___GFP_RETRY_MAYFAIL_BIT = 14,
	___GFP_NOFAIL_BIT = 15,
	___GFP_NORETRY_BIT = 16,
	___GFP_MEMALLOC_BIT = 17,
	___GFP_COMP_BIT = 18,
	___GFP_NOMEMALLOC_BIT = 19,
	___GFP_HARDWALL_BIT = 20,
	___GFP_THISNODE_BIT = 21,
	___GFP_ACCOUNT_BIT = 22,
	___GFP_ZEROTAGS_BIT = 23,
	___GFP_NO_OBJ_EXT_BIT = 24,
	___GFP_LAST_BIT = 25,
};

enum {
	____TRANS_FREEZABLE_BIT = 0,
	__TRANS_FREEZABLE = 1,
	____TRANS_FREEZABLE_SEQ = 0,
	____TRANS_START_BIT = 1,
	__TRANS_START = 2,
	____TRANS_START_SEQ = 1,
	____TRANS_ATTACH_BIT = 2,
	__TRANS_ATTACH = 4,
	____TRANS_ATTACH_SEQ = 2,
	____TRANS_JOIN_BIT = 3,
	__TRANS_JOIN = 8,
	____TRANS_JOIN_SEQ = 3,
	____TRANS_JOIN_NOLOCK_BIT = 4,
	__TRANS_JOIN_NOLOCK = 16,
	____TRANS_JOIN_NOLOCK_SEQ = 4,
	____TRANS_DUMMY_BIT = 5,
	__TRANS_DUMMY = 32,
	____TRANS_DUMMY_SEQ = 5,
	____TRANS_JOIN_NOSTART_BIT = 6,
	__TRANS_JOIN_NOSTART = 64,
	____TRANS_JOIN_NOSTART_SEQ = 6,
};

enum {
	__ctx_convertBPF_PROG_TYPE_SOCKET_FILTER = 0,
	__ctx_convertBPF_PROG_TYPE_SCHED_CLS = 1,
	__ctx_convertBPF_PROG_TYPE_SCHED_ACT = 2,
	__ctx_convertBPF_PROG_TYPE_XDP = 3,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SKB = 4,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK = 5,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK_ADDR = 6,
	__ctx_convertBPF_PROG_TYPE_LWT_IN = 7,
	__ctx_convertBPF_PROG_TYPE_LWT_OUT = 8,
	__ctx_convertBPF_PROG_TYPE_LWT_XMIT = 9,
	__ctx_convertBPF_PROG_TYPE_LWT_SEG6LOCAL = 10,
	__ctx_convertBPF_PROG_TYPE_SOCK_OPS = 11,
	__ctx_convertBPF_PROG_TYPE_SK_SKB = 12,
	__ctx_convertBPF_PROG_TYPE_SK_MSG = 13,
	__ctx_convertBPF_PROG_TYPE_FLOW_DISSECTOR = 14,
	__ctx_convertBPF_PROG_TYPE_KPROBE = 15,
	__ctx_convertBPF_PROG_TYPE_TRACEPOINT = 16,
	__ctx_convertBPF_PROG_TYPE_PERF_EVENT = 17,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT = 18,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 19,
	__ctx_convertBPF_PROG_TYPE_TRACING = 20,
	__ctx_convertBPF_PROG_TYPE_CGROUP_DEVICE = 21,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SYSCTL = 22,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCKOPT = 23,
	__ctx_convertBPF_PROG_TYPE_SK_REUSEPORT = 24,
	__ctx_convertBPF_PROG_TYPE_SK_LOOKUP = 25,
	__ctx_convertBPF_PROG_TYPE_STRUCT_OPS = 26,
	__ctx_convertBPF_PROG_TYPE_EXT = 27,
	__ctx_convertBPF_PROG_TYPE_SYSCALL = 28,
	__ctx_convertBPF_PROG_TYPE_NETFILTER = 29,
	__ctx_convert_unused = 30,
};

enum {
	attr_noop = 0,
	attr_delayed_allocation_blocks = 1,
	attr_session_write_kbytes = 2,
	attr_lifetime_write_kbytes = 3,
	attr_reserved_clusters = 4,
	attr_sra_exceeded_retry_limit = 5,
	attr_inode_readahead = 6,
	attr_trigger_test_error = 7,
	attr_first_error_time = 8,
	attr_last_error_time = 9,
	attr_clusters_in_group = 10,
	attr_mb_order = 11,
	attr_feature = 12,
	attr_pointer_pi = 13,
	attr_pointer_ui = 14,
	attr_pointer_ul = 15,
	attr_pointer_u64 = 16,
	attr_pointer_u8 = 17,
	attr_pointer_string = 18,
	attr_pointer_atomic = 19,
	attr_journal_task = 20,
};

enum {
	blank_off = 0,
	blank_normal_wait = 1,
	blank_vesa_wait = 2,
};

enum {
	btrfs_bitmap_nr_uptodate = 0,
	btrfs_bitmap_nr_dirty = 1,
	btrfs_bitmap_nr_writeback = 2,
	btrfs_bitmap_nr_ordered = 3,
	btrfs_bitmap_nr_checked = 4,
	btrfs_bitmap_nr_locked = 5,
	btrfs_bitmap_nr_max = 6,
};

enum {
	cpuset = 0,
	possible = 1,
	fail = 2,
};

enum {
	dns_key_data = 0,
	dns_key_error = 1,
};

enum {
	e1000_10_half = 0,
	e1000_10_full = 1,
	e1000_100_half = 2,
	e1000_100_full = 3,
};

enum {
	e1000_igp_cable_length_10 = 10,
	e1000_igp_cable_length_20 = 20,
	e1000_igp_cable_length_30 = 30,
	e1000_igp_cable_length_40 = 40,
	e1000_igp_cable_length_50 = 50,
	e1000_igp_cable_length_60 = 60,
	e1000_igp_cable_length_70 = 70,
	e1000_igp_cable_length_80 = 80,
	e1000_igp_cable_length_90 = 90,
	e1000_igp_cable_length_100 = 100,
	e1000_igp_cable_length_110 = 110,
	e1000_igp_cable_length_115 = 115,
	e1000_igp_cable_length_120 = 120,
	e1000_igp_cable_length_130 = 130,
	e1000_igp_cable_length_140 = 140,
	e1000_igp_cable_length_150 = 150,
	e1000_igp_cable_length_160 = 160,
	e1000_igp_cable_length_170 = 170,
	e1000_igp_cable_length_180 = 180,
};

enum {
	false = 0,
	true = 1,
};

enum {
	mechtype_caddy = 0,
	mechtype_tray = 1,
	mechtype_popup = 2,
	mechtype_individual_changer = 4,
	mechtype_cartridge_changer = 5,
};

enum {
	none = 0,
	day = 1,
	month = 2,
	year = 3,
};

enum {
	pci_channel_io_normal = 1,
	pci_channel_io_frozen = 2,
	pci_channel_io_perm_failure = 3,
};

enum {
	preempt_dynamic_undefined = -1,
	preempt_dynamic_none = 0,
	preempt_dynamic_voluntary = 1,
	preempt_dynamic_full = 2,
	preempt_dynamic_lazy = 3,
};

enum {
	ptr_explicit = 0,
	ptr_ext4_sb_info_offset = 1,
	ptr_ext4_super_block_offset = 2,
};

enum {
	sysctl_hung_task_timeout_secs = 0,
};

typedef enum {
	BIT_DStream_unfinished = 0,
	BIT_DStream_endOfBuffer = 1,
	BIT_DStream_completed = 2,
	BIT_DStream_overflow = 3,
} BIT_DStream_status;

typedef enum {
	EfiPciIoWidthUint8 = 0,
	EfiPciIoWidthUint16 = 1,
	EfiPciIoWidthUint32 = 2,
	EfiPciIoWidthUint64 = 3,
	EfiPciIoWidthFifoUint8 = 4,
	EfiPciIoWidthFifoUint16 = 5,
	EfiPciIoWidthFifoUint32 = 6,
	EfiPciIoWidthFifoUint64 = 7,
	EfiPciIoWidthFillUint8 = 8,
	EfiPciIoWidthFillUint16 = 9,
	EfiPciIoWidthFillUint32 = 10,
	EfiPciIoWidthFillUint64 = 11,
	EfiPciIoWidthMaximum = 12,
} EFI_PCI_IO_PROTOCOL_WIDTH;

typedef enum {
	EfiTimerCancel = 0,
	EfiTimerPeriodic = 1,
	EfiTimerRelative = 2,
} EFI_TIMER_DELAY;

typedef enum {
	ZSTD_error_no_error = 0,
	ZSTD_error_GENERIC = 1,
	ZSTD_error_prefix_unknown = 10,
	ZSTD_error_version_unsupported = 12,
	ZSTD_error_frameParameter_unsupported = 14,
	ZSTD_error_frameParameter_windowTooLarge = 16,
	ZSTD_error_corruption_detected = 20,
	ZSTD_error_checksum_wrong = 22,
	ZSTD_error_dictionary_corrupted = 30,
	ZSTD_error_dictionary_wrong = 32,
	ZSTD_error_dictionaryCreation_failed = 34,
	ZSTD_error_parameter_unsupported = 40,
	ZSTD_error_parameter_outOfBound = 42,
	ZSTD_error_tableLog_tooLarge = 44,
	ZSTD_error_maxSymbolValue_tooLarge = 46,
	ZSTD_error_maxSymbolValue_tooSmall = 48,
	ZSTD_error_stage_wrong = 60,
	ZSTD_error_init_missing = 62,
	ZSTD_error_memory_allocation = 64,
	ZSTD_error_workSpace_tooSmall = 66,
	ZSTD_error_dstSize_tooSmall = 70,
	ZSTD_error_srcSize_wrong = 72,
	ZSTD_error_dstBuffer_null = 74,
	ZSTD_error_frameIndex_tooLarge = 100,
	ZSTD_error_seekableIO = 102,
	ZSTD_error_dstBuffer_wrong = 104,
	ZSTD_error_srcBuffer_wrong = 105,
	ZSTD_error_maxCode = 120,
} ZSTD_ErrorCode;

typedef ZSTD_ErrorCode ERR_enum;

typedef enum {
	FSE_repeat_none = 0,
	FSE_repeat_check = 1,
	FSE_repeat_valid = 2,
} FSE_repeat;

typedef enum {
	trustInput = 0,
	checkMaxSymbolValue = 1,
} HIST_checkInput_e;

typedef enum {
	HUF_singleStream = 0,
	HUF_fourStreams = 1,
} HUF_nbStreams_e;

typedef enum {
	HUF_repeat_none = 0,
	HUF_repeat_check = 1,
	HUF_repeat_valid = 2,
} HUF_repeat;

typedef enum {
	ZSTD_e_continue = 0,
	ZSTD_e_flush = 1,
	ZSTD_e_end = 2,
} ZSTD_EndDirective;

typedef enum {
	zop_dynamic = 0,
	zop_predef = 1,
} ZSTD_OptPrice_e;

typedef enum {
	ZSTD_reset_session_only = 1,
	ZSTD_reset_parameters = 2,
	ZSTD_reset_session_and_parameters = 3,
} ZSTD_ResetDirective;

typedef enum {
	ZSTD_bm_buffered = 0,
	ZSTD_bm_stable = 1,
} ZSTD_bufferMode_e;

typedef enum {
	ZSTDb_not_buffered = 0,
	ZSTDb_buffered = 1,
} ZSTD_buffered_policy_e;

typedef enum {
	ZSTD_cpm_noAttachDict = 0,
	ZSTD_cpm_attachDict = 1,
	ZSTD_cpm_createCDict = 2,
	ZSTD_cpm_unknown = 3,
} ZSTD_cParamMode_e;

typedef enum {
	ZSTD_c_compressionLevel = 100,
	ZSTD_c_windowLog = 101,
	ZSTD_c_hashLog = 102,
	ZSTD_c_chainLog = 103,
	ZSTD_c_searchLog = 104,
	ZSTD_c_minMatch = 105,
	ZSTD_c_targetLength = 106,
	ZSTD_c_strategy = 107,
	ZSTD_c_enableLongDistanceMatching = 160,
	ZSTD_c_ldmHashLog = 161,
	ZSTD_c_ldmMinMatch = 162,
	ZSTD_c_ldmBucketSizeLog = 163,
	ZSTD_c_ldmHashRateLog = 164,
	ZSTD_c_contentSizeFlag = 200,
	ZSTD_c_checksumFlag = 201,
	ZSTD_c_dictIDFlag = 202,
	ZSTD_c_nbWorkers = 400,
	ZSTD_c_jobSize = 401,
	ZSTD_c_overlapLog = 402,
	ZSTD_c_experimentalParam1 = 500,
	ZSTD_c_experimentalParam2 = 10,
	ZSTD_c_experimentalParam3 = 1000,
	ZSTD_c_experimentalParam4 = 1001,
	ZSTD_c_experimentalParam5 = 1002,
	ZSTD_c_experimentalParam6 = 1003,
	ZSTD_c_experimentalParam7 = 1004,
	ZSTD_c_experimentalParam8 = 1005,
	ZSTD_c_experimentalParam9 = 1006,
	ZSTD_c_experimentalParam10 = 1007,
	ZSTD_c_experimentalParam11 = 1008,
	ZSTD_c_experimentalParam12 = 1009,
	ZSTD_c_experimentalParam13 = 1010,
	ZSTD_c_experimentalParam14 = 1011,
	ZSTD_c_experimentalParam15 = 1012,
} ZSTD_cParameter;

typedef enum {
	zcss_init = 0,
	zcss_load = 1,
	zcss_flush = 2,
} ZSTD_cStreamStage;

typedef enum {
	ZSTDcrp_makeClean = 0,
	ZSTDcrp_leaveDirty = 1,
} ZSTD_compResetPolicy_e;

typedef enum {
	ZSTDcs_created = 0,
	ZSTDcs_init = 1,
	ZSTDcs_ongoing = 2,
	ZSTDcs_ending = 3,
} ZSTD_compressionStage_e;

typedef enum {
	ZSTD_cwksp_alloc_objects = 0,
	ZSTD_cwksp_alloc_buffers = 1,
	ZSTD_cwksp_alloc_aligned = 2,
} ZSTD_cwksp_alloc_phase_e;

typedef enum {
	ZSTD_cwksp_dynamic_alloc = 0,
	ZSTD_cwksp_static_alloc = 1,
} ZSTD_cwksp_static_alloc_e;

typedef enum {
	ZSTD_d_windowLogMax = 100,
	ZSTD_d_experimentalParam1 = 1000,
	ZSTD_d_experimentalParam2 = 1001,
	ZSTD_d_experimentalParam3 = 1002,
	ZSTD_d_experimentalParam4 = 1003,
} ZSTD_dParameter;

typedef enum {
	ZSTDds_getFrameHeaderSize = 0,
	ZSTDds_decodeFrameHeader = 1,
	ZSTDds_decodeBlockHeader = 2,
	ZSTDds_decompressBlock = 3,
	ZSTDds_decompressLastBlock = 4,
	ZSTDds_checkChecksum = 5,
	ZSTDds_decodeSkippableHeader = 6,
	ZSTDds_skipFrame = 7,
} ZSTD_dStage;

typedef enum {
	zdss_init = 0,
	zdss_loadHeader = 1,
	zdss_read = 2,
	zdss_load = 3,
	zdss_flush = 4,
} ZSTD_dStreamStage;

typedef enum {
	ZSTD_defaultDisallowed = 0,
	ZSTD_defaultAllowed = 1,
} ZSTD_defaultPolicy_e;

typedef enum {
	ZSTD_dictDefaultAttach = 0,
	ZSTD_dictForceAttach = 1,
	ZSTD_dictForceCopy = 2,
	ZSTD_dictForceLoad = 3,
} ZSTD_dictAttachPref_e;

typedef enum {
	ZSTD_dct_auto = 0,
	ZSTD_dct_rawContent = 1,
	ZSTD_dct_fullDict = 2,
} ZSTD_dictContentType_e;

typedef enum {
	ZSTD_dlm_byCopy = 0,
	ZSTD_dlm_byRef = 1,
} ZSTD_dictLoadMethod_e;

typedef enum {
	ZSTD_noDict = 0,
	ZSTD_extDict = 1,
	ZSTD_dictMatchState = 2,
	ZSTD_dedicatedDictSearch = 3,
} ZSTD_dictMode_e;

typedef enum {
	ZSTD_dtlm_fast = 0,
	ZSTD_dtlm_full = 1,
} ZSTD_dictTableLoadMethod_e;

typedef enum {
	ZSTD_use_indefinitely = -1,
	ZSTD_dont_use = 0,
	ZSTD_use_once = 1,
} ZSTD_dictUses_e;

typedef enum {
	ZSTD_d_validateChecksum = 0,
	ZSTD_d_ignoreChecksum = 1,
} ZSTD_forceIgnoreChecksum_e;

typedef enum {
	ZSTD_f_zstd1 = 0,
	ZSTD_f_zstd1_magicless = 1,
} ZSTD_format_e;

typedef enum {
	ZSTD_frame = 0,
	ZSTD_skippableFrame = 1,
} ZSTD_frameType_e;

typedef enum {
	ZSTDirp_continue = 0,
	ZSTDirp_reset = 1,
} ZSTD_indexResetPolicy_e;

typedef enum {
	ZSTD_not_in_dst = 0,
	ZSTD_in_dst = 1,
	ZSTD_split = 2,
} ZSTD_litLocation_e;

typedef enum {
	ZSTD_llt_none = 0,
	ZSTD_llt_literalLength = 1,
	ZSTD_llt_matchLength = 2,
} ZSTD_longLengthType_e;

typedef enum {
	ZSTD_lo_isRegularOffset = 0,
	ZSTD_lo_isLongOffset = 1,
} ZSTD_longOffset_e;

typedef enum {
	ZSTDnit_frameHeader = 0,
	ZSTDnit_blockHeader = 1,
	ZSTDnit_block = 2,
	ZSTDnit_lastBlock = 3,
	ZSTDnit_checksum = 4,
	ZSTDnit_skippableFrame = 5,
} ZSTD_nextInputType_e;

typedef enum {
	ZSTD_no_overlap = 0,
	ZSTD_overlap_src_before_dst = 1,
} ZSTD_overlap_e;

typedef enum {
	ZSTD_ps_auto = 0,
	ZSTD_ps_enable = 1,
	ZSTD_ps_disable = 2,
} ZSTD_paramSwitch_e;

typedef enum {
	ZSTD_rmd_refSingleDDict = 0,
	ZSTD_rmd_refMultipleDDicts = 1,
} ZSTD_refMultipleDDicts_e;

typedef enum {
	ZSTD_resetTarget_CDict = 0,
	ZSTD_resetTarget_CCtx = 1,
} ZSTD_resetTarget_e;

typedef enum {
	ZSTD_sf_noBlockDelimiters = 0,
	ZSTD_sf_explicitBlockDelimiters = 1,
} ZSTD_sequenceFormat_e;

typedef enum {
	ZSTD_fast = 1,
	ZSTD_dfast = 2,
	ZSTD_greedy = 3,
	ZSTD_lazy = 4,
	ZSTD_lazy2 = 5,
	ZSTD_btlazy2 = 6,
	ZSTD_btopt = 7,
	ZSTD_btultra = 8,
	ZSTD_btultra2 = 9,
} ZSTD_strategy;

typedef enum {
	OSL_GLOBAL_LOCK_HANDLER = 0,
	OSL_NOTIFY_HANDLER = 1,
	OSL_GPE_HANDLER = 2,
	OSL_DEBUGGER_MAIN_THREAD = 3,
	OSL_DEBUGGER_EXEC_THREAD = 4,
	OSL_EC_POLL_HANDLER = 5,
	OSL_EC_BURST_HANDLER = 6,
} acpi_execute_type;

typedef enum {
	ACPI_IMODE_LOAD_PASS1 = 1,
	ACPI_IMODE_LOAD_PASS2 = 2,
	ACPI_IMODE_EXECUTE = 3,
} acpi_interpreter_mode;

typedef enum {
	ACPI_TRACE_AML_METHOD = 0,
	ACPI_TRACE_AML_OPCODE = 1,
	ACPI_TRACE_AML_REGION = 2,
} acpi_trace_event_type;

typedef enum {
	bt_raw = 0,
	bt_rle = 1,
	bt_compressed = 2,
	bt_reserved = 3,
} blockType_e;

typedef enum {
	need_more = 0,
	block_done = 1,
	finish_started = 2,
	finish_done = 3,
} block_state;

typedef enum {
	CODES = 0,
	LENS = 1,
	DISTS = 2,
} codetype;

typedef enum {
	FILE_MEMORY_MIGRATE = 0,
	FILE_CPULIST = 1,
	FILE_MEMLIST = 2,
	FILE_EFFECTIVE_CPULIST = 3,
	FILE_EFFECTIVE_MEMLIST = 4,
	FILE_SUBPARTS_CPULIST = 5,
	FILE_EXCLUSIVE_CPULIST = 6,
	FILE_EFFECTIVE_XCPULIST = 7,
	FILE_ISOLATED_CPULIST = 8,
	FILE_CPU_EXCLUSIVE = 9,
	FILE_MEM_EXCLUSIVE = 10,
	FILE_MEM_HARDWALL = 11,
	FILE_SCHED_LOAD_BALANCE = 12,
	FILE_PARTITION_ROOT = 13,
	FILE_SCHED_RELAX_DOMAIN_LEVEL = 14,
	FILE_MEMORY_PRESSURE_ENABLED = 15,
	FILE_MEMORY_PRESSURE = 16,
	FILE_SPREAD_PAGE = 17,
	FILE_SPREAD_SLAB = 18,
} cpuset_filetype_t;

typedef enum {
	CS_ONLINE = 0,
	CS_CPU_EXCLUSIVE = 1,
	CS_MEM_EXCLUSIVE = 2,
	CS_MEM_HARDWALL = 3,
	CS_MEMORY_MIGRATE = 4,
	CS_SCHED_LOAD_BALANCE = 5,
	CS_SPREAD_PAGE = 6,
	CS_SPREAD_SLAB = 7,
} cpuset_flagbits_t;

typedef enum {
	noDict = 0,
	withPrefix64k = 1,
	usingExtDict = 2,
} dict_directive;

typedef enum {
	EITHER = 0,
	INDEX = 1,
	DIRENT = 2,
	DIRENT_HTREE = 3,
} dirblock_type_t;

typedef enum {
	e1000_1000t_rx_status_not_ok = 0,
	e1000_1000t_rx_status_ok = 1,
	e1000_1000t_rx_status_undefined = 255,
} e1000_1000t_rx_status;

typedef enum {
	e1000_10bt_ext_dist_enable_normal = 0,
	e1000_10bt_ext_dist_enable_lower = 1,
	e1000_10bt_ext_dist_enable_undefined = 255,
} e1000_10bt_ext_dist_enable;

typedef enum {
	e1000_auto_x_mode_manual_mdi = 0,
	e1000_auto_x_mode_manual_mdix = 1,
	e1000_auto_x_mode_auto1 = 2,
	e1000_auto_x_mode_auto2 = 3,
	e1000_auto_x_mode_undefined = 255,
} e1000_auto_x_mode;

typedef enum {
	e1000_bus_speed_unknown = 0,
	e1000_bus_speed_33 = 1,
	e1000_bus_speed_66 = 2,
	e1000_bus_speed_100 = 3,
	e1000_bus_speed_120 = 4,
	e1000_bus_speed_133 = 5,
	e1000_bus_speed_reserved = 6,
} e1000_bus_speed;

typedef enum {
	e1000_bus_type_unknown = 0,
	e1000_bus_type_pci = 1,
	e1000_bus_type_pcix = 2,
	e1000_bus_type_reserved = 3,
} e1000_bus_type;

typedef enum {
	e1000_bus_width_unknown = 0,
	e1000_bus_width_32 = 1,
	e1000_bus_width_64 = 2,
	e1000_bus_width_reserved = 3,
} e1000_bus_width;

typedef enum {
	e1000_cable_length_50 = 0,
	e1000_cable_length_50_80 = 1,
	e1000_cable_length_80_110 = 2,
	e1000_cable_length_110_140 = 3,
	e1000_cable_length_140 = 4,
	e1000_cable_length_undefined = 255,
} e1000_cable_length;

typedef enum {
	e1000_downshift_normal = 0,
	e1000_downshift_activated = 1,
	e1000_downshift_undefined = 255,
} e1000_downshift;

typedef enum {
	e1000_dsp_config_disabled = 0,
	e1000_dsp_config_enabled = 1,
	e1000_dsp_config_activated = 2,
	e1000_dsp_config_undefined = 255,
} e1000_dsp_config;

typedef enum {
	e1000_eeprom_uninitialized = 0,
	e1000_eeprom_spi = 1,
	e1000_eeprom_microwire = 2,
	e1000_eeprom_flash = 3,
	e1000_eeprom_none = 4,
	e1000_num_eeprom_types = 5,
} e1000_eeprom_type;

typedef enum {
	E1000_FC_NONE = 0,
	E1000_FC_RX_PAUSE = 1,
	E1000_FC_TX_PAUSE = 2,
	E1000_FC_FULL = 3,
	E1000_FC_DEFAULT = 255,
} e1000_fc_type;

typedef enum {
	e1000_ffe_config_enabled = 0,
	e1000_ffe_config_active = 1,
	e1000_ffe_config_blocked = 2,
} e1000_ffe_config;

typedef enum {
	e1000_undefined = 0,
	e1000_82542_rev2_0 = 1,
	e1000_82542_rev2_1 = 2,
	e1000_82543 = 3,
	e1000_82544 = 4,
	e1000_82540 = 5,
	e1000_82545 = 6,
	e1000_82545_rev_3 = 7,
	e1000_82546 = 8,
	e1000_ce4100 = 9,
	e1000_82546_rev_3 = 10,
	e1000_82541 = 11,
	e1000_82541_rev_2 = 12,
	e1000_82547 = 13,
	e1000_82547_rev_2 = 14,
	e1000_num_macs = 15,
} e1000_mac_type;

typedef enum {
	e1000_media_type_copper = 0,
	e1000_media_type_fiber = 1,
	e1000_media_type_internal_serdes = 2,
	e1000_num_media_types = 3,
} e1000_media_type;

typedef enum {
	e1000_ms_hw_default = 0,
	e1000_ms_force_master = 1,
	e1000_ms_force_slave = 2,
	e1000_ms_auto = 3,
} e1000_ms_type;

typedef enum {
	e1000_phy_m88 = 0,
	e1000_phy_igp = 1,
	e1000_phy_8211 = 2,
	e1000_phy_8201 = 3,
	e1000_phy_undefined = 255,
} e1000_phy_type;

typedef enum {
	e1000_polarity_reversal_enabled = 0,
	e1000_polarity_reversal_disabled = 1,
	e1000_polarity_reversal_undefined = 255,
} e1000_polarity_reversal;

typedef enum {
	e1000_rev_polarity_normal = 0,
	e1000_rev_polarity_reversed = 1,
	e1000_rev_polarity_undefined = 255,
} e1000_rev_polarity;

typedef enum {
	e1000_smart_speed_default = 0,
	e1000_smart_speed_on = 1,
	e1000_smart_speed_off = 2,
} e1000_smart_speed;

typedef enum {
	decode_full_block = 0,
	partial_decode = 1,
} earlyEnd_directive;

typedef enum {
	endOnOutputSize = 0,
	endOnInputSize = 1,
} endCondition_directive;

typedef enum {
	EXT4_IGET_NORMAL = 0,
	EXT4_IGET_SPECIAL = 1,
	EXT4_IGET_HANDLE = 2,
	EXT4_IGET_BAD = 4,
	EXT4_IGET_EA_INODE = 8,
} ext4_iget_flags;

typedef enum {
	FS_DECRYPT = 0,
	FS_ENCRYPT = 1,
} fscrypt_direction_t;

typedef enum {
	HEAD = 0,
	FLAGS = 1,
	TIME = 2,
	OS = 3,
	EXLEN = 4,
	EXTRA = 5,
	NAME = 6,
	COMMENT = 7,
	HCRC = 8,
	DICTID = 9,
	DICT = 10,
	TYPE = 11,
	TYPEDO = 12,
	STORED = 13,
	COPY = 14,
	TABLE = 15,
	LENLENS = 16,
	CODELENS = 17,
	LEN = 18,
	LENEXT = 19,
	DIST = 20,
	DISTEXT = 21,
	MATCH = 22,
	LIT = 23,
	CHECK = 24,
	LENGTH = 25,
	DONE = 26,
	BAD = 27,
	MEM = 28,
	SYNC = 29,
} inflate_mode;

typedef enum {
	ISOLATE_ABORT = 0,
	ISOLATE_NONE = 1,
	ISOLATE_SUCCESS = 2,
} isolate_migrate_t;

typedef enum {
	MAP_CHG_REUSE = 0,
	MAP_CHG_NEEDED = 1,
	MAP_CHG_ENFORCED = 2,
} map_chg_state;

typedef enum {
	PAGE_KEEP = 0,
	PAGE_ACTIVATE = 1,
	PAGE_SUCCESS = 2,
	PAGE_CLEAN = 3,
} pageout_t;

typedef enum {
	PARPORT_CLASS_LEGACY = 0,
	PARPORT_CLASS_PRINTER = 1,
	PARPORT_CLASS_MODEM = 2,
	PARPORT_CLASS_NET = 3,
	PARPORT_CLASS_HDC = 4,
	PARPORT_CLASS_PCMCIA = 5,
	PARPORT_CLASS_MEDIA = 6,
	PARPORT_CLASS_FDC = 7,
	PARPORT_CLASS_PORTS = 8,
	PARPORT_CLASS_SCANNER = 9,
	PARPORT_CLASS_DIGCAM = 10,
	PARPORT_CLASS_OTHER = 11,
	PARPORT_CLASS_UNSPEC = 12,
	PARPORT_CLASS_SCSIADAPTER = 13,
} parport_device_class;

typedef enum {
	PHY_INTERFACE_MODE_NA = 0,
	PHY_INTERFACE_MODE_INTERNAL = 1,
	PHY_INTERFACE_MODE_MII = 2,
	PHY_INTERFACE_MODE_GMII = 3,
	PHY_INTERFACE_MODE_SGMII = 4,
	PHY_INTERFACE_MODE_TBI = 5,
	PHY_INTERFACE_MODE_REVMII = 6,
	PHY_INTERFACE_MODE_RMII = 7,
	PHY_INTERFACE_MODE_REVRMII = 8,
	PHY_INTERFACE_MODE_RGMII = 9,
	PHY_INTERFACE_MODE_RGMII_ID = 10,
	PHY_INTERFACE_MODE_RGMII_RXID = 11,
	PHY_INTERFACE_MODE_RGMII_TXID = 12,
	PHY_INTERFACE_MODE_RTBI = 13,
	PHY_INTERFACE_MODE_SMII = 14,
	PHY_INTERFACE_MODE_XGMII = 15,
	PHY_INTERFACE_MODE_XLGMII = 16,
	PHY_INTERFACE_MODE_MOCA = 17,
	PHY_INTERFACE_MODE_PSGMII = 18,
	PHY_INTERFACE_MODE_QSGMII = 19,
	PHY_INTERFACE_MODE_TRGMII = 20,
	PHY_INTERFACE_MODE_100BASEX = 21,
	PHY_INTERFACE_MODE_1000BASEX = 22,
	PHY_INTERFACE_MODE_2500BASEX = 23,
	PHY_INTERFACE_MODE_5GBASER = 24,
	PHY_INTERFACE_MODE_RXAUI = 25,
	PHY_INTERFACE_MODE_XAUI = 26,
	PHY_INTERFACE_MODE_10GBASER = 27,
	PHY_INTERFACE_MODE_25GBASER = 28,
	PHY_INTERFACE_MODE_USXGMII = 29,
	PHY_INTERFACE_MODE_10GKR = 30,
	PHY_INTERFACE_MODE_QUSGMII = 31,
	PHY_INTERFACE_MODE_1000BASEKX = 32,
	PHY_INTERFACE_MODE_10G_QXGMII = 33,
	PHY_INTERFACE_MODE_MAX = 34,
} phy_interface_t;

typedef enum {
	PSMOUSE_BAD_DATA = 0,
	PSMOUSE_GOOD_DATA = 1,
	PSMOUSE_FULL_PACKET = 2,
} psmouse_ret_t;

typedef enum {
	search_hashChain = 0,
	search_binaryTree = 1,
	search_rowHash = 2,
} searchMethod_e;

typedef enum {
	SS_FREE = 0,
	SS_UNCONNECTED = 1,
	SS_CONNECTING = 2,
	SS_CONNECTED = 3,
	SS_DISCONNECTING = 4,
} socket_state;

typedef enum {
	STATUSTYPE_INFO = 0,
	STATUSTYPE_TABLE = 1,
	STATUSTYPE_IMA = 2,
} status_type_t;

typedef enum {
	not_streaming = 0,
	is_streaming = 1,
} streaming_operation;

typedef enum {
	set_basic = 0,
	set_rle = 1,
	set_compressed = 2,
	set_repeat = 3,
} symbolEncodingType_e;

typedef enum {
	XFS_EXT_NORM = 0,
	XFS_EXT_UNWRITTEN = 1,
} xfs_exntst_t;

typedef enum {
	XFS_LOOKUP_EQi = 0,
	XFS_LOOKUP_LEi = 1,
	XFS_LOOKUP_GEi = 2,
} xfs_lookup_t;

typedef ZSTD_ErrorCode zstd_error_code;

enum CMD_RET_VALUES {
	REFIRE_CMD = 1,
	COMPLETE_CMD = 2,
	RETURN_CMD = 3,
};

enum CSI_J {
	CSI_J_CURSOR_TO_END = 0,
	CSI_J_START_TO_CURSOR = 1,
	CSI_J_VISIBLE = 2,
	CSI_J_FULL = 3,
};

enum CSI_right_square_bracket {
	CSI_RSB_COLOR_FOR_UNDERLINE = 1,
	CSI_RSB_COLOR_FOR_HALF_BRIGHT = 2,
	CSI_RSB_MAKE_CUR_COLOR_DEFAULT = 8,
	CSI_RSB_BLANKING_INTERVAL = 9,
	CSI_RSB_BELL_FREQUENCY = 10,
	CSI_RSB_BELL_DURATION = 11,
	CSI_RSB_BRING_CONSOLE_TO_FRONT = 12,
	CSI_RSB_UNBLANK = 13,
	CSI_RSB_VESA_OFF_INTERVAL = 14,
	CSI_RSB_BRING_PREV_CONSOLE_TO_FRONT = 15,
	CSI_RSB_CURSOR_BLINK_INTERVAL = 16,
};

enum DCMD_RETURN_STATUS {
	DCMD_SUCCESS = 0,
	DCMD_TIMEOUT = 1,
	DCMD_FAILED = 2,
	DCMD_BUSY = 3,
	DCMD_INIT = 255,
};

enum DCMD_TIMEOUT_ACTION {
	INITIATE_OCR = 0,
	KILL_ADAPTER = 1,
	IGNORE_TIMEOUT = 2,
};

enum E1000_INVM_STRUCTURE_TYPE {
	E1000_INVM_UNINITIALIZED_STRUCTURE = 0,
	E1000_INVM_WORD_AUTOLOAD_STRUCTURE = 1,
	E1000_INVM_CSR_AUTOLOAD_STRUCTURE = 2,
	E1000_INVM_PHY_REGISTER_AUTOLOAD_STRUCTURE = 3,
	E1000_INVM_RSA_KEY_SHA256_STRUCTURE = 4,
	E1000_INVM_INVALIDATED_STRUCTURE = 15,
};

enum FW_BOOT_CONTEXT {
	PROBE_CONTEXT = 0,
	OCR_CONTEXT = 1,
};

enum KTHREAD_BITS {
	KTHREAD_IS_PER_CPU = 0,
	KTHREAD_SHOULD_STOP = 1,
	KTHREAD_SHOULD_PARK = 2,
};

enum MEGASAS_LD_TARGET_ID_STATUS {
	LD_TARGET_ID_INITIAL = 0,
	LD_TARGET_ID_ACTIVE = 1,
	LD_TARGET_ID_DELETED = 2,
};

enum MEGASAS_OCR_CAUSE {
	FW_FAULT_OCR = 0,
	SCSIIO_TIMEOUT_OCR = 1,
	MFI_IO_TIMEOUT_OCR = 2,
};

enum MFI_CMD_OP {
	MFI_CMD_INIT = 0,
	MFI_CMD_LD_READ = 1,
	MFI_CMD_LD_WRITE = 2,
	MFI_CMD_LD_SCSI_IO = 3,
	MFI_CMD_PD_SCSI_IO = 4,
	MFI_CMD_DCMD = 5,
	MFI_CMD_ABORT = 6,
	MFI_CMD_SMP = 7,
	MFI_CMD_STP = 8,
	MFI_CMD_NVME = 9,
	MFI_CMD_TOOLBOX = 10,
	MFI_CMD_OP_COUNT = 11,
	MFI_CMD_INVALID = 255,
};

enum MFI_STAT {
	MFI_STAT_OK = 0,
	MFI_STAT_INVALID_CMD = 1,
	MFI_STAT_INVALID_DCMD = 2,
	MFI_STAT_INVALID_PARAMETER = 3,
	MFI_STAT_INVALID_SEQUENCE_NUMBER = 4,
	MFI_STAT_ABORT_NOT_POSSIBLE = 5,
	MFI_STAT_APP_HOST_CODE_NOT_FOUND = 6,
	MFI_STAT_APP_IN_USE = 7,
	MFI_STAT_APP_NOT_INITIALIZED = 8,
	MFI_STAT_ARRAY_INDEX_INVALID = 9,
	MFI_STAT_ARRAY_ROW_NOT_EMPTY = 10,
	MFI_STAT_CONFIG_RESOURCE_CONFLICT = 11,
	MFI_STAT_DEVICE_NOT_FOUND = 12,
	MFI_STAT_DRIVE_TOO_SMALL = 13,
	MFI_STAT_FLASH_ALLOC_FAIL = 14,
	MFI_STAT_FLASH_BUSY = 15,
	MFI_STAT_FLASH_ERROR = 16,
	MFI_STAT_FLASH_IMAGE_BAD = 17,
	MFI_STAT_FLASH_IMAGE_INCOMPLETE = 18,
	MFI_STAT_FLASH_NOT_OPEN = 19,
	MFI_STAT_FLASH_NOT_STARTED = 20,
	MFI_STAT_FLUSH_FAILED = 21,
	MFI_STAT_HOST_CODE_NOT_FOUNT = 22,
	MFI_STAT_LD_CC_IN_PROGRESS = 23,
	MFI_STAT_LD_INIT_IN_PROGRESS = 24,
	MFI_STAT_LD_LBA_OUT_OF_RANGE = 25,
	MFI_STAT_LD_MAX_CONFIGURED = 26,
	MFI_STAT_LD_NOT_OPTIMAL = 27,
	MFI_STAT_LD_RBLD_IN_PROGRESS = 28,
	MFI_STAT_LD_RECON_IN_PROGRESS = 29,
	MFI_STAT_LD_WRONG_RAID_LEVEL = 30,
	MFI_STAT_MAX_SPARES_EXCEEDED = 31,
	MFI_STAT_MEMORY_NOT_AVAILABLE = 32,
	MFI_STAT_MFC_HW_ERROR = 33,
	MFI_STAT_NO_HW_PRESENT = 34,
	MFI_STAT_NOT_FOUND = 35,
	MFI_STAT_NOT_IN_ENCL = 36,
	MFI_STAT_PD_CLEAR_IN_PROGRESS = 37,
	MFI_STAT_PD_TYPE_WRONG = 38,
	MFI_STAT_PR_DISABLED = 39,
	MFI_STAT_ROW_INDEX_INVALID = 40,
	MFI_STAT_SAS_CONFIG_INVALID_ACTION = 41,
	MFI_STAT_SAS_CONFIG_INVALID_DATA = 42,
	MFI_STAT_SAS_CONFIG_INVALID_PAGE = 43,
	MFI_STAT_SAS_CONFIG_INVALID_TYPE = 44,
	MFI_STAT_SCSI_DONE_WITH_ERROR = 45,
	MFI_STAT_SCSI_IO_FAILED = 46,
	MFI_STAT_SCSI_RESERVATION_CONFLICT = 47,
	MFI_STAT_SHUTDOWN_FAILED = 48,
	MFI_STAT_TIME_NOT_SET = 49,
	MFI_STAT_WRONG_STATE = 50,
	MFI_STAT_LD_OFFLINE = 51,
	MFI_STAT_PEER_NOTIFICATION_REJECTED = 52,
	MFI_STAT_PEER_NOTIFICATION_FAILED = 53,
	MFI_STAT_RESERVATION_IN_PROGRESS = 54,
	MFI_STAT_I2C_ERRORS_DETECTED = 55,
	MFI_STAT_PCI_ERRORS_DETECTED = 56,
	MFI_STAT_CONFIG_SEQ_MISMATCH = 103,
	MFI_STAT_INVALID_STATUS = 255,
};

enum MR_ADAPTER_TYPE {
	MFI_SERIES = 1,
	THUNDERBOLT_SERIES = 2,
	INVADER_SERIES = 3,
	VENTURA_SERIES = 4,
	AERO_SERIES = 5,
};

enum MR_EVT_CLASS {
	MR_EVT_CLASS_DEBUG = -2,
	MR_EVT_CLASS_PROGRESS = -1,
	MR_EVT_CLASS_INFO = 0,
	MR_EVT_CLASS_WARNING = 1,
	MR_EVT_CLASS_CRITICAL = 2,
	MR_EVT_CLASS_FATAL = 3,
	MR_EVT_CLASS_DEAD = 4,
};

enum MR_EVT_LOCALE {
	MR_EVT_LOCALE_LD = 1,
	MR_EVT_LOCALE_PD = 2,
	MR_EVT_LOCALE_ENCL = 4,
	MR_EVT_LOCALE_BBU = 8,
	MR_EVT_LOCALE_SAS = 16,
	MR_EVT_LOCALE_CTRL = 32,
	MR_EVT_LOCALE_CONFIG = 64,
	MR_EVT_LOCALE_CLUSTER = 128,
	MR_EVT_LOCALE_ALL = 65535,
};

enum MR_FW_CRASH_DUMP_STATE {
	UNAVAILABLE = 0,
	AVAILABLE = 1,
	COPYING = 2,
	COPIED = 3,
	COPY_ERROR = 4,
};

enum MR_LD_QUERY_TYPE {
	MR_LD_QUERY_TYPE_ALL = 0,
	MR_LD_QUERY_TYPE_EXPOSED_TO_HOST = 1,
	MR_LD_QUERY_TYPE_USED_TGT_IDS = 2,
	MR_LD_QUERY_TYPE_CLUSTER_ACCESS = 3,
	MR_LD_QUERY_TYPE_CLUSTER_LOCALE = 4,
};

enum MR_PD_QUERY_TYPE {
	MR_PD_QUERY_TYPE_ALL = 0,
	MR_PD_QUERY_TYPE_STATE = 1,
	MR_PD_QUERY_TYPE_POWER_STATE = 2,
	MR_PD_QUERY_TYPE_MEDIA_TYPE = 3,
	MR_PD_QUERY_TYPE_SPEED = 4,
	MR_PD_QUERY_TYPE_EXPOSED_TO_HOST = 5,
};

enum MR_PD_STATE {
	MR_PD_STATE_UNCONFIGURED_GOOD = 0,
	MR_PD_STATE_UNCONFIGURED_BAD = 1,
	MR_PD_STATE_HOT_SPARE = 2,
	MR_PD_STATE_OFFLINE = 16,
	MR_PD_STATE_FAILED = 17,
	MR_PD_STATE_REBUILD = 20,
	MR_PD_STATE_ONLINE = 24,
	MR_PD_STATE_COPYBACK = 32,
	MR_PD_STATE_SYSTEM = 64,
};

enum MR_PD_TYPE {
	UNKNOWN_DRIVE = 0,
	PARALLEL_SCSI = 1,
	SAS_PD = 2,
	SATA_PD = 3,
	FC_PD = 4,
	NVME_PD = 5,
};

enum MR_PERF_MODE {
	MR_BALANCED_PERF_MODE = 0,
	MR_IOPS_PERF_MODE = 1,
	MR_LATENCY_PERF_MODE = 2,
};

enum MR_RAID_FLAGS_IO_SUB_TYPE {
	MR_RAID_FLAGS_IO_SUB_TYPE_NONE = 0,
	MR_RAID_FLAGS_IO_SUB_TYPE_SYSTEM_PD = 1,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_DATA = 2,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_P = 3,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_Q = 4,
	MR_RAID_FLAGS_IO_SUB_TYPE_CACHE_BYPASS = 6,
	MR_RAID_FLAGS_IO_SUB_TYPE_LDIO_BW_LIMIT = 7,
	MR_RAID_FLAGS_IO_SUB_TYPE_R56_DIV_OFFLOAD = 8,
};

enum MR_RAID_MAP_DESC_TYPE {
	RAID_MAP_DESC_TYPE_DEVHDL_INFO = 0,
	RAID_MAP_DESC_TYPE_TGTID_INFO = 1,
	RAID_MAP_DESC_TYPE_ARRAY_INFO = 2,
	RAID_MAP_DESC_TYPE_SPAN_INFO = 3,
	RAID_MAP_DESC_TYPE_COUNT = 4,
};

enum MR_SCSI_CMD_TYPE {
	READ_WRITE_LDIO = 0,
	NON_READ_WRITE_LDIO = 1,
	READ_WRITE_SYSPDIO = 2,
	NON_READ_WRITE_SYSPDIO = 3,
};

enum OID {
	OID_id_dsa_with_sha1 = 0,
	OID_id_dsa = 1,
	OID_id_ecPublicKey = 2,
	OID_id_prime192v1 = 3,
	OID_id_prime256v1 = 4,
	OID_id_ecdsa_with_sha1 = 5,
	OID_id_ecdsa_with_sha224 = 6,
	OID_id_ecdsa_with_sha256 = 7,
	OID_id_ecdsa_with_sha384 = 8,
	OID_id_ecdsa_with_sha512 = 9,
	OID_rsaEncryption = 10,
	OID_sha1WithRSAEncryption = 11,
	OID_sha256WithRSAEncryption = 12,
	OID_sha384WithRSAEncryption = 13,
	OID_sha512WithRSAEncryption = 14,
	OID_sha224WithRSAEncryption = 15,
	OID_data = 16,
	OID_signed_data = 17,
	OID_email_address = 18,
	OID_contentType = 19,
	OID_messageDigest = 20,
	OID_signingTime = 21,
	OID_smimeCapabilites = 22,
	OID_smimeAuthenticatedAttrs = 23,
	OID_mskrb5 = 24,
	OID_krb5 = 25,
	OID_krb5u2u = 26,
	OID_msIndirectData = 27,
	OID_msStatementType = 28,
	OID_msSpOpusInfo = 29,
	OID_msPeImageDataObjId = 30,
	OID_msIndividualSPKeyPurpose = 31,
	OID_msOutlookExpress = 32,
	OID_ntlmssp = 33,
	OID_negoex = 34,
	OID_spnego = 35,
	OID_IAKerb = 36,
	OID_PKU2U = 37,
	OID_Scram = 38,
	OID_certAuthInfoAccess = 39,
	OID_sha1 = 40,
	OID_id_ansip384r1 = 41,
	OID_id_ansip521r1 = 42,
	OID_sha256 = 43,
	OID_sha384 = 44,
	OID_sha512 = 45,
	OID_sha224 = 46,
	OID_commonName = 47,
	OID_surname = 48,
	OID_countryName = 49,
	OID_locality = 50,
	OID_stateOrProvinceName = 51,
	OID_organizationName = 52,
	OID_organizationUnitName = 53,
	OID_title = 54,
	OID_description = 55,
	OID_name = 56,
	OID_givenName = 57,
	OID_initials = 58,
	OID_generationalQualifier = 59,
	OID_subjectKeyIdentifier = 60,
	OID_keyUsage = 61,
	OID_subjectAltName = 62,
	OID_issuerAltName = 63,
	OID_basicConstraints = 64,
	OID_crlDistributionPoints = 65,
	OID_certPolicies = 66,
	OID_authorityKeyIdentifier = 67,
	OID_extKeyUsage = 68,
	OID_NetlogonMechanism = 69,
	OID_appleLocalKdcSupported = 70,
	OID_gostCPSignA = 71,
	OID_gostCPSignB = 72,
	OID_gostCPSignC = 73,
	OID_gost2012PKey256 = 74,
	OID_gost2012PKey512 = 75,
	OID_gost2012Digest256 = 76,
	OID_gost2012Digest512 = 77,
	OID_gost2012Signature256 = 78,
	OID_gost2012Signature512 = 79,
	OID_gostTC26Sign256A = 80,
	OID_gostTC26Sign256B = 81,
	OID_gostTC26Sign256C = 82,
	OID_gostTC26Sign256D = 83,
	OID_gostTC26Sign512A = 84,
	OID_gostTC26Sign512B = 85,
	OID_gostTC26Sign512C = 86,
	OID_sm2 = 87,
	OID_sm3 = 88,
	OID_SM2_with_SM3 = 89,
	OID_sm3WithRSAEncryption = 90,
	OID_TPMLoadableKey = 91,
	OID_TPMImportableKey = 92,
	OID_TPMSealedData = 93,
	OID_sha3_256 = 94,
	OID_sha3_384 = 95,
	OID_sha3_512 = 96,
	OID_id_ecdsa_with_sha3_256 = 97,
	OID_id_ecdsa_with_sha3_384 = 98,
	OID_id_ecdsa_with_sha3_512 = 99,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_256 = 100,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_384 = 101,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_512 = 102,
	OID__NR = 103,
};

enum Opt_errors {
	Opt_errors_continue = 0,
	Opt_errors_panic = 1,
};

enum REGION_TYPE {
	REGION_TYPE_UNUSED = 0,
	REGION_TYPE_SHARED_READ = 1,
	REGION_TYPE_SHARED_WRITE = 2,
	REGION_TYPE_EXCLUSIVE = 3,
};

enum SHIFT_DIRECTION {
	SHIFT_LEFT = 0,
	SHIFT_RIGHT = 1,
};

enum SS4_PACKET_ID {
	SS4_PACKET_ID_IDLE = 0,
	SS4_PACKET_ID_ONE = 1,
	SS4_PACKET_ID_TWO = 2,
	SS4_PACKET_ID_MULTI = 3,
	SS4_PACKET_ID_STICK = 4,
};

enum V7_PACKET_ID {
	V7_PACKET_ID_IDLE = 0,
	V7_PACKET_ID_TWO = 1,
	V7_PACKET_ID_MULTI = 2,
	V7_PACKET_ID_NEW = 3,
	V7_PACKET_ID_UNKNOWN = 4,
};

enum VANIR_REVISION_ID {
	VANIR_A0_REV = 160,
	VANIR_B0_REV = 1,
	VANIR_C0_REV = 2,
	VANIR_C1_REV = 3,
	VANIR_C2_REV = 194,
};

enum WX_MSCA_CMD_value {
	WX_MSCA_CMD_RSV = 0,
	WX_MSCA_CMD_WRITE = 1,
	WX_MSCA_CMD_POST_READ = 2,
	WX_MSCA_CMD_READ = 3,
};

enum _MR_CRASH_BUF_STATUS {
	MR_CRASH_BUF_TURN_OFF = 0,
	MR_CRASH_BUF_TURN_ON = 1,
};

enum __sk_action {
	__SK_DROP = 0,
	__SK_PASS = 1,
	__SK_REDIRECT = 2,
	__SK_NONE = 3,
};

enum _record_type {
	_START_RECORD = 0,
	_COMMIT_RECORD = 1,
};

enum _slab_flag_bits {
	_SLAB_CONSISTENCY_CHECKS = 0,
	_SLAB_RED_ZONE = 1,
	_SLAB_POISON = 2,
	_SLAB_KMALLOC = 3,
	_SLAB_HWCACHE_ALIGN = 4,
	_SLAB_CACHE_DMA = 5,
	_SLAB_CACHE_DMA32 = 6,
	_SLAB_STORE_USER = 7,
	_SLAB_PANIC = 8,
	_SLAB_TYPESAFE_BY_RCU = 9,
	_SLAB_TRACE = 10,
	_SLAB_NOLEAKTRACE = 11,
	_SLAB_NO_MERGE = 12,
	_SLAB_ACCOUNT = 13,
	_SLAB_NO_USER_FLAGS = 14,
	_SLAB_RECLAIM_ACCOUNT = 15,
	_SLAB_OBJECT_POISON = 16,
	_SLAB_CMPXCHG_DOUBLE = 17,
	_SLAB_NO_OBJ_EXT = 18,
	_SLAB_FLAGS_LAST_BIT = 19,
};

enum aa_code {
	AA_U8 = 0,
	AA_U16 = 1,
	AA_U32 = 2,
	AA_U64 = 3,
	AA_NAME = 4,
	AA_STRING = 5,
	AA_BLOB = 6,
	AA_STRUCT = 7,
	AA_STRUCTEND = 8,
	AA_LIST = 9,
	AA_LISTEND = 10,
	AA_ARRAY = 11,
	AA_ARRAYEND = 12,
};

enum aa_sfs_type {
	AA_SFS_TYPE_BOOLEAN = 0,
	AA_SFS_TYPE_STRING = 1,
	AA_SFS_TYPE_U64 = 2,
	AA_SFS_TYPE_FOPS = 3,
	AA_SFS_TYPE_DIR = 4,
};

enum aafs_ns_type {
	AAFS_NS_DIR = 0,
	AAFS_NS_PROFS = 1,
	AAFS_NS_NS = 2,
	AAFS_NS_RAW_DATA = 3,
	AAFS_NS_LOAD = 4,
	AAFS_NS_REPLACE = 5,
	AAFS_NS_REMOVE = 6,
	AAFS_NS_REVISION = 7,
	AAFS_NS_COUNT = 8,
	AAFS_NS_MAX_COUNT = 9,
	AAFS_NS_SIZE = 10,
	AAFS_NS_MAX_SIZE = 11,
	AAFS_NS_OWNER = 12,
	AAFS_NS_SIZEOF = 13,
};

enum aafs_prof_type {
	AAFS_PROF_DIR = 0,
	AAFS_PROF_PROFS = 1,
	AAFS_PROF_NAME = 2,
	AAFS_PROF_MODE = 3,
	AAFS_PROF_ATTACH = 4,
	AAFS_PROF_HASH = 5,
	AAFS_PROF_RAW_DATA = 6,
	AAFS_PROF_RAW_HASH = 7,
	AAFS_PROF_RAW_ABI = 8,
	AAFS_PROF_SIZEOF = 9,
};

enum access_coordinate_class {
	ACCESS_COORDINATE_LOCAL = 0,
	ACCESS_COORDINATE_CPU = 1,
	ACCESS_COORDINATE_MAX = 2,
};

enum acpi_attr_enum {
	ACPI_ATTR_LABEL_SHOW = 0,
	ACPI_ATTR_INDEX_SHOW = 1,
};

enum acpi_bridge_type {
	ACPI_BRIDGE_TYPE_PCIE = 1,
	ACPI_BRIDGE_TYPE_CXL = 2,
};

enum acpi_bus_device_type {
	ACPI_BUS_TYPE_DEVICE = 0,
	ACPI_BUS_TYPE_POWER = 1,
	ACPI_BUS_TYPE_PROCESSOR = 2,
	ACPI_BUS_TYPE_THERMAL = 3,
	ACPI_BUS_TYPE_POWER_BUTTON = 4,
	ACPI_BUS_TYPE_SLEEP_BUTTON = 5,
	ACPI_BUS_TYPE_ECDT_EC = 6,
	ACPI_BUS_DEVICE_TYPE_COUNT = 7,
};

enum acpi_cdat_type {
	ACPI_CDAT_TYPE_DSMAS = 0,
	ACPI_CDAT_TYPE_DSLBIS = 1,
	ACPI_CDAT_TYPE_DSMSCIS = 2,
	ACPI_CDAT_TYPE_DSIS = 3,
	ACPI_CDAT_TYPE_DSEMTS = 4,
	ACPI_CDAT_TYPE_SSLBIS = 5,
	ACPI_CDAT_TYPE_RESERVED = 6,
};

enum acpi_cedt_type {
	ACPI_CEDT_TYPE_CHBS = 0,
	ACPI_CEDT_TYPE_CFMWS = 1,
	ACPI_CEDT_TYPE_CXIMS = 2,
	ACPI_CEDT_TYPE_RDPAS = 3,
	ACPI_CEDT_TYPE_RESERVED = 4,
};

enum acpi_device_swnode_dev_props {
	ACPI_DEVICE_SWNODE_DEV_ROTATION = 0,
	ACPI_DEVICE_SWNODE_DEV_CLOCK_FREQUENCY = 1,
	ACPI_DEVICE_SWNODE_DEV_LED_MAX_MICROAMP = 2,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_MICROAMP = 3,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_TIMEOUT_US = 4,
	ACPI_DEVICE_SWNODE_DEV_NUM_OF = 5,
	ACPI_DEVICE_SWNODE_DEV_NUM_ENTRIES = 6,
};

enum acpi_device_swnode_ep_props {
	ACPI_DEVICE_SWNODE_EP_REMOTE_EP = 0,
	ACPI_DEVICE_SWNODE_EP_BUS_TYPE = 1,
	ACPI_DEVICE_SWNODE_EP_REG = 2,
	ACPI_DEVICE_SWNODE_EP_CLOCK_LANES = 3,
	ACPI_DEVICE_SWNODE_EP_DATA_LANES = 4,
	ACPI_DEVICE_SWNODE_EP_LANE_POLARITIES = 5,
	ACPI_DEVICE_SWNODE_EP_LINK_FREQUENCIES = 6,
	ACPI_DEVICE_SWNODE_EP_NUM_OF = 7,
	ACPI_DEVICE_SWNODE_EP_NUM_ENTRIES = 8,
};

enum acpi_device_swnode_port_props {
	ACPI_DEVICE_SWNODE_PORT_REG = 0,
	ACPI_DEVICE_SWNODE_PORT_NUM_OF = 1,
	ACPI_DEVICE_SWNODE_PORT_NUM_ENTRIES = 2,
};

enum acpi_ec_event_state {
	EC_EVENT_READY = 0,
	EC_EVENT_IN_PROGRESS = 1,
	EC_EVENT_COMPLETE = 2,
};

enum acpi_irq_model_id {
	ACPI_IRQ_MODEL_PIC = 0,
	ACPI_IRQ_MODEL_IOAPIC = 1,
	ACPI_IRQ_MODEL_IOSAPIC = 2,
	ACPI_IRQ_MODEL_PLATFORM = 3,
	ACPI_IRQ_MODEL_GIC = 4,
	ACPI_IRQ_MODEL_LPIC = 5,
	ACPI_IRQ_MODEL_RINTC = 6,
	ACPI_IRQ_MODEL_COUNT = 7,
};

enum acpi_madt_core_pic_version {
	ACPI_MADT_CORE_PIC_VERSION_NONE = 0,
	ACPI_MADT_CORE_PIC_VERSION_V1 = 1,
	ACPI_MADT_CORE_PIC_VERSION_RESERVED = 2,
};

enum acpi_madt_multiproc_wakeup_version {
	ACPI_MADT_MP_WAKEUP_VERSION_NONE = 0,
	ACPI_MADT_MP_WAKEUP_VERSION_V1 = 1,
	ACPI_MADT_MP_WAKEUP_VERSION_RESERVED = 2,
};

enum acpi_madt_type {
	ACPI_MADT_TYPE_LOCAL_APIC = 0,
	ACPI_MADT_TYPE_IO_APIC = 1,
	ACPI_MADT_TYPE_INTERRUPT_OVERRIDE = 2,
	ACPI_MADT_TYPE_NMI_SOURCE = 3,
	ACPI_MADT_TYPE_LOCAL_APIC_NMI = 4,
	ACPI_MADT_TYPE_LOCAL_APIC_OVERRIDE = 5,
	ACPI_MADT_TYPE_IO_SAPIC = 6,
	ACPI_MADT_TYPE_LOCAL_SAPIC = 7,
	ACPI_MADT_TYPE_INTERRUPT_SOURCE = 8,
	ACPI_MADT_TYPE_LOCAL_X2APIC = 9,
	ACPI_MADT_TYPE_LOCAL_X2APIC_NMI = 10,
	ACPI_MADT_TYPE_GENERIC_INTERRUPT = 11,
	ACPI_MADT_TYPE_GENERIC_DISTRIBUTOR = 12,
	ACPI_MADT_TYPE_GENERIC_MSI_FRAME = 13,
	ACPI_MADT_TYPE_GENERIC_REDISTRIBUTOR = 14,
	ACPI_MADT_TYPE_GENERIC_TRANSLATOR = 15,
	ACPI_MADT_TYPE_MULTIPROC_WAKEUP = 16,
	ACPI_MADT_TYPE_CORE_PIC = 17,
	ACPI_MADT_TYPE_LIO_PIC = 18,
	ACPI_MADT_TYPE_HT_PIC = 19,
	ACPI_MADT_TYPE_EIO_PIC = 20,
	ACPI_MADT_TYPE_MSI_PIC = 21,
	ACPI_MADT_TYPE_BIO_PIC = 22,
	ACPI_MADT_TYPE_LPC_PIC = 23,
	ACPI_MADT_TYPE_RINTC = 24,
	ACPI_MADT_TYPE_IMSIC = 25,
	ACPI_MADT_TYPE_APLIC = 26,
	ACPI_MADT_TYPE_PLIC = 27,
	ACPI_MADT_TYPE_RESERVED = 28,
	ACPI_MADT_TYPE_OEM_RESERVED = 128,
};

enum acpi_pptt_type {
	ACPI_PPTT_TYPE_PROCESSOR = 0,
	ACPI_PPTT_TYPE_CACHE = 1,
	ACPI_PPTT_TYPE_ID = 2,
	ACPI_PPTT_TYPE_RESERVED = 3,
};

enum acpi_predicate {
	all_versions = 0,
	less_than_or_equal = 1,
	equal = 2,
	greater_than_or_equal = 3,
};

enum acpi_reconfig_event {
	ACPI_RECONFIG_DEVICE_ADD = 0,
	ACPI_RECONFIG_DEVICE_REMOVE = 1,
};

enum acpi_return_package_types {
	ACPI_PTYPE1_FIXED = 1,
	ACPI_PTYPE1_VAR = 2,
	ACPI_PTYPE1_OPTION = 3,
	ACPI_PTYPE2 = 4,
	ACPI_PTYPE2_COUNT = 5,
	ACPI_PTYPE2_PKG_COUNT = 6,
	ACPI_PTYPE2_FIXED = 7,
	ACPI_PTYPE2_MIN = 8,
	ACPI_PTYPE2_REV_FIXED = 9,
	ACPI_PTYPE2_FIX_VAR = 10,
	ACPI_PTYPE2_VAR_VAR = 11,
	ACPI_PTYPE2_UUID_PAIR = 12,
	ACPI_PTYPE_CUSTOM = 13,
};

enum acpi_srat_type {
	ACPI_SRAT_TYPE_CPU_AFFINITY = 0,
	ACPI_SRAT_TYPE_MEMORY_AFFINITY = 1,
	ACPI_SRAT_TYPE_X2APIC_CPU_AFFINITY = 2,
	ACPI_SRAT_TYPE_GICC_AFFINITY = 3,
	ACPI_SRAT_TYPE_GIC_ITS_AFFINITY = 4,
	ACPI_SRAT_TYPE_GENERIC_AFFINITY = 5,
	ACPI_SRAT_TYPE_GENERIC_PORT_AFFINITY = 6,
	ACPI_SRAT_TYPE_RINTC_AFFINITY = 7,
	ACPI_SRAT_TYPE_RESERVED = 8,
};

enum acpi_subtable_type {
	ACPI_SUBTABLE_COMMON = 0,
	ACPI_SUBTABLE_HMAT = 1,
	ACPI_SUBTABLE_PRMT = 2,
	ACPI_SUBTABLE_CEDT = 3,
	CDAT_SUBTABLE = 4,
};

enum actions {
	REGISTER = 0,
	DEREGISTER = 1,
	CPU_DONT_CARE = 2,
};

enum addr_type_t {
	UNICAST_ADDR = 0,
	MULTICAST_ADDR = 1,
	ANYCAST_ADDR = 2,
};

enum alarmtimer_type {
	ALARM_REALTIME = 0,
	ALARM_BOOTTIME = 1,
	ALARM_NUMTYPE = 2,
	ALARM_REALTIME_FREEZER = 3,
	ALARM_BOOTTIME_FREEZER = 4,
};

enum amd_chipset_gen {
	NOT_AMD_CHIPSET = 0,
	AMD_CHIPSET_SB600 = 1,
	AMD_CHIPSET_SB700 = 2,
	AMD_CHIPSET_SB800 = 3,
	AMD_CHIPSET_HUDSON2 = 4,
	AMD_CHIPSET_BOLTON = 5,
	AMD_CHIPSET_YANGTZE = 6,
	AMD_CHIPSET_TAISHAN = 7,
	AMD_CHIPSET_UNKNOWN = 8,
};

enum asn1_class {
	ASN1_UNIV = 0,
	ASN1_APPL = 1,
	ASN1_CONT = 2,
	ASN1_PRIV = 3,
};

enum asn1_method {
	ASN1_PRIM = 0,
	ASN1_CONS = 1,
};

enum asn1_opcode {
	ASN1_OP_MATCH = 0,
	ASN1_OP_MATCH_OR_SKIP = 1,
	ASN1_OP_MATCH_ACT = 2,
	ASN1_OP_MATCH_ACT_OR_SKIP = 3,
	ASN1_OP_MATCH_JUMP = 4,
	ASN1_OP_MATCH_JUMP_OR_SKIP = 5,
	ASN1_OP_MATCH_ANY = 8,
	ASN1_OP_MATCH_ANY_OR_SKIP = 9,
	ASN1_OP_MATCH_ANY_ACT = 10,
	ASN1_OP_MATCH_ANY_ACT_OR_SKIP = 11,
	ASN1_OP_COND_MATCH_OR_SKIP = 17,
	ASN1_OP_COND_MATCH_ACT_OR_SKIP = 19,
	ASN1_OP_COND_MATCH_JUMP_OR_SKIP = 21,
	ASN1_OP_COND_MATCH_ANY = 24,
	ASN1_OP_COND_MATCH_ANY_OR_SKIP = 25,
	ASN1_OP_COND_MATCH_ANY_ACT = 26,
	ASN1_OP_COND_MATCH_ANY_ACT_OR_SKIP = 27,
	ASN1_OP_COND_FAIL = 28,
	ASN1_OP_COMPLETE = 29,
	ASN1_OP_ACT = 30,
	ASN1_OP_MAYBE_ACT = 31,
	ASN1_OP_END_SEQ = 32,
	ASN1_OP_END_SET = 33,
	ASN1_OP_END_SEQ_OF = 34,
	ASN1_OP_END_SET_OF = 35,
	ASN1_OP_END_SEQ_ACT = 36,
	ASN1_OP_END_SET_ACT = 37,
	ASN1_OP_END_SEQ_OF_ACT = 38,
	ASN1_OP_END_SET_OF_ACT = 39,
	ASN1_OP_RETURN = 40,
	ASN1_OP__NR = 41,
};

enum asn1_tag {
	ASN1_EOC = 0,
	ASN1_BOOL = 1,
	ASN1_INT = 2,
	ASN1_BTS = 3,
	ASN1_OTS = 4,
	ASN1_NULL = 5,
	ASN1_OID = 6,
	ASN1_ODE = 7,
	ASN1_EXT = 8,
	ASN1_REAL = 9,
	ASN1_ENUM = 10,
	ASN1_EPDV = 11,
	ASN1_UTF8STR = 12,
	ASN1_RELOID = 13,
	ASN1_SEQ = 16,
	ASN1_SET = 17,
	ASN1_NUMSTR = 18,
	ASN1_PRNSTR = 19,
	ASN1_TEXSTR = 20,
	ASN1_VIDSTR = 21,
	ASN1_IA5STR = 22,
	ASN1_UNITIM = 23,
	ASN1_GENTIM = 24,
	ASN1_GRASTR = 25,
	ASN1_VISSTR = 26,
	ASN1_GENSTR = 27,
	ASN1_UNISTR = 28,
	ASN1_CHRSTR = 29,
	ASN1_BMPSTR = 30,
	ASN1_LONG_TAG = 31,
};

enum assoc_array_walk_status {
	assoc_array_walk_tree_empty = 0,
	assoc_array_walk_found_terminal_node = 1,
	assoc_array_walk_found_wrong_shortcut = 2,
};

enum ast_chip {
	AST1000 = 65536,
	AST2000 = 65537,
	AST1100 = 131072,
	AST2100 = 131073,
	AST2050 = 131074,
	AST2200 = 196608,
	AST2150 = 196609,
	AST2300 = 262144,
	AST1300 = 262145,
	AST1050 = 262146,
	AST2400 = 327680,
	AST1400 = 327681,
	AST1250 = 327682,
	AST2500 = 393216,
	AST2510 = 393217,
	AST2520 = 393218,
	AST2600 = 458752,
	AST2620 = 458753,
};

enum ast_config_mode {
	ast_use_p2a = 0,
	ast_use_dt = 1,
	ast_use_defaults = 2,
};

enum ast_tx_chip {
	AST_TX_NONE = 0,
	AST_TX_SIL164 = 1,
	AST_TX_DP501 = 2,
	AST_TX_ASTDP = 3,
};

enum asymmetric_payload_bits {
	asym_crypto = 0,
	asym_subtype = 1,
	asym_key_ids = 2,
	asym_auth = 3,
};

enum ata_completion_errors {
	AC_ERR_OK = 0,
	AC_ERR_DEV = 1,
	AC_ERR_HSM = 2,
	AC_ERR_TIMEOUT = 4,
	AC_ERR_MEDIA = 8,
	AC_ERR_ATA_BUS = 16,
	AC_ERR_HOST_BUS = 32,
	AC_ERR_SYSTEM = 64,
	AC_ERR_INVALID = 128,
	AC_ERR_OTHER = 256,
	AC_ERR_NODEV_HINT = 512,
	AC_ERR_NCQ = 1024,
};

enum ata_dev_iter_mode {
	ATA_DITER_ENABLED = 0,
	ATA_DITER_ENABLED_REVERSE = 1,
	ATA_DITER_ALL = 2,
	ATA_DITER_ALL_REVERSE = 3,
};

enum ata_link_iter_mode {
	ATA_LITER_EDGE = 0,
	ATA_LITER_HOST_FIRST = 1,
	ATA_LITER_PMP_FIRST = 2,
};

enum ata_lpm_hints {
	ATA_LPM_EMPTY = 1,
	ATA_LPM_HIPM = 2,
	ATA_LPM_WAKE_ONLY = 4,
};

enum ata_lpm_policy {
	ATA_LPM_UNKNOWN = 0,
	ATA_LPM_MAX_POWER = 1,
	ATA_LPM_MED_POWER = 2,
	ATA_LPM_MED_POWER_WITH_DIPM = 3,
	ATA_LPM_MIN_POWER_WITH_PARTIAL = 4,
	ATA_LPM_MIN_POWER = 5,
};

enum ata_prot_flags {
	ATA_PROT_FLAG_PIO = 1,
	ATA_PROT_FLAG_DMA = 2,
	ATA_PROT_FLAG_NCQ = 4,
	ATA_PROT_FLAG_ATAPI = 8,
	ATA_PROT_UNKNOWN = 255,
	ATA_PROT_NODATA = 0,
	ATA_PROT_PIO = 1,
	ATA_PROT_DMA = 2,
	ATA_PROT_NCQ_NODATA = 4,
	ATA_PROT_NCQ = 6,
	ATAPI_PROT_NODATA = 8,
	ATAPI_PROT_PIO = 9,
	ATAPI_PROT_DMA = 10,
};

enum ata_quirks {
	__ATA_QUIRK_DIAGNOSTIC = 0,
	__ATA_QUIRK_NODMA = 1,
	__ATA_QUIRK_NONCQ = 2,
	__ATA_QUIRK_MAX_SEC_128 = 3,
	__ATA_QUIRK_BROKEN_HPA = 4,
	__ATA_QUIRK_DISABLE = 5,
	__ATA_QUIRK_HPA_SIZE = 6,
	__ATA_QUIRK_IVB = 7,
	__ATA_QUIRK_STUCK_ERR = 8,
	__ATA_QUIRK_BRIDGE_OK = 9,
	__ATA_QUIRK_ATAPI_MOD16_DMA = 10,
	__ATA_QUIRK_FIRMWARE_WARN = 11,
	__ATA_QUIRK_1_5_GBPS = 12,
	__ATA_QUIRK_NOSETXFER = 13,
	__ATA_QUIRK_BROKEN_FPDMA_AA = 14,
	__ATA_QUIRK_DUMP_ID = 15,
	__ATA_QUIRK_MAX_SEC_LBA48 = 16,
	__ATA_QUIRK_ATAPI_DMADIR = 17,
	__ATA_QUIRK_NO_NCQ_TRIM = 18,
	__ATA_QUIRK_NOLPM = 19,
	__ATA_QUIRK_WD_BROKEN_LPM = 20,
	__ATA_QUIRK_ZERO_AFTER_TRIM = 21,
	__ATA_QUIRK_NO_DMA_LOG = 22,
	__ATA_QUIRK_NOTRIM = 23,
	__ATA_QUIRK_MAX_SEC_1024 = 24,
	__ATA_QUIRK_MAX_TRIM_128M = 25,
	__ATA_QUIRK_NO_NCQ_ON_ATI = 26,
	__ATA_QUIRK_NO_LPM_ON_ATI = 27,
	__ATA_QUIRK_NO_ID_DEV_LOG = 28,
	__ATA_QUIRK_NO_LOG_DIR = 29,
	__ATA_QUIRK_NO_FUA = 30,
	__ATA_QUIRK_MAX = 31,
};

enum ata_xfer_mask {
	ATA_MASK_PIO = 127,
	ATA_MASK_MWDMA = 3968,
	ATA_MASK_UDMA = 1044480,
};

enum ati_sink_info_idx {
	ATI_INFO_IDX_MANUFACTURER_ID = 0,
	ATI_INFO_IDX_PRODUCT_ID = 1,
	ATI_INFO_IDX_SINK_DESC_LEN = 2,
	ATI_INFO_IDX_PORT_ID_LOW = 3,
	ATI_INFO_IDX_PORT_ID_HIGH = 4,
	ATI_INFO_IDX_SINK_DESC_FIRST = 5,
	ATI_INFO_IDX_SINK_DESC_LAST = 22,
};

enum audit_mode {
	AUDIT_NORMAL = 0,
	AUDIT_QUIET_DENIED = 1,
	AUDIT_QUIET = 2,
	AUDIT_NOQUIET = 3,
	AUDIT_ALL = 4,
};

enum audit_nfcfgop {
	AUDIT_XT_OP_REGISTER = 0,
	AUDIT_XT_OP_REPLACE = 1,
	AUDIT_XT_OP_UNREGISTER = 2,
	AUDIT_NFT_OP_TABLE_REGISTER = 3,
	AUDIT_NFT_OP_TABLE_UNREGISTER = 4,
	AUDIT_NFT_OP_CHAIN_REGISTER = 5,
	AUDIT_NFT_OP_CHAIN_UNREGISTER = 6,
	AUDIT_NFT_OP_RULE_REGISTER = 7,
	AUDIT_NFT_OP_RULE_UNREGISTER = 8,
	AUDIT_NFT_OP_SET_REGISTER = 9,
	AUDIT_NFT_OP_SET_UNREGISTER = 10,
	AUDIT_NFT_OP_SETELEM_REGISTER = 11,
	AUDIT_NFT_OP_SETELEM_UNREGISTER = 12,
	AUDIT_NFT_OP_GEN_REGISTER = 13,
	AUDIT_NFT_OP_OBJ_REGISTER = 14,
	AUDIT_NFT_OP_OBJ_UNREGISTER = 15,
	AUDIT_NFT_OP_OBJ_RESET = 16,
	AUDIT_NFT_OP_FLOWTABLE_REGISTER = 17,
	AUDIT_NFT_OP_FLOWTABLE_UNREGISTER = 18,
	AUDIT_NFT_OP_SETELEM_RESET = 19,
	AUDIT_NFT_OP_RULE_RESET = 20,
	AUDIT_NFT_OP_INVALID = 21,
};

enum audit_nlgrps {
	AUDIT_NLGRP_NONE = 0,
	AUDIT_NLGRP_READLOG = 1,
	__AUDIT_NLGRP_MAX = 2,
};

enum audit_ntp_type {
	AUDIT_NTP_OFFSET = 0,
	AUDIT_NTP_FREQ = 1,
	AUDIT_NTP_STATUS = 2,
	AUDIT_NTP_TAI = 3,
	AUDIT_NTP_TICK = 4,
	AUDIT_NTP_ADJUST = 5,
	AUDIT_NTP_NVALS = 6,
};

enum audit_state {
	AUDIT_STATE_DISABLED = 0,
	AUDIT_STATE_BUILD = 1,
	AUDIT_STATE_RECORD = 2,
};

enum audit_type {
	AUDIT_APPARMOR_AUDIT = 0,
	AUDIT_APPARMOR_ALLOWED = 1,
	AUDIT_APPARMOR_DENIED = 2,
	AUDIT_APPARMOR_HINT = 3,
	AUDIT_APPARMOR_STATUS = 4,
	AUDIT_APPARMOR_ERROR = 5,
	AUDIT_APPARMOR_KILL = 6,
	AUDIT_APPARMOR_AUTO = 7,
};

enum auditsc_class_t {
	AUDITSC_NATIVE = 0,
	AUDITSC_COMPAT = 1,
	AUDITSC_OPEN = 2,
	AUDITSC_OPENAT = 3,
	AUDITSC_SOCKETCALL = 4,
	AUDITSC_EXECVE = 5,
	AUDITSC_OPENAT2 = 6,
	AUDITSC_NVALS = 7,
};

enum autofs_notify {
	NFY_NONE = 0,
	NFY_MOUNT = 1,
	NFY_EXPIRE = 2,
};

enum backlight_scale {
	BACKLIGHT_SCALE_UNKNOWN = 0,
	BACKLIGHT_SCALE_LINEAR = 1,
	BACKLIGHT_SCALE_NON_LINEAR = 2,
};

enum backlight_type {
	BACKLIGHT_RAW = 1,
	BACKLIGHT_PLATFORM = 2,
	BACKLIGHT_FIRMWARE = 3,
	BACKLIGHT_TYPE_MAX = 4,
};

enum batadv_packettype {
	BATADV_IV_OGM = 0,
	BATADV_BCAST = 1,
	BATADV_CODED = 2,
	BATADV_ELP = 3,
	BATADV_OGM2 = 4,
	BATADV_MCAST = 5,
	BATADV_UNICAST = 64,
	BATADV_UNICAST_FRAG = 65,
	BATADV_UNICAST_4ADDR = 66,
	BATADV_ICMP = 67,
	BATADV_UNICAST_TVLV = 68,
};

enum behavior {
	EXCLUSIVE = 0,
	SHARED = 1,
	DROP = 2,
};

enum bfqq_expiration {
	BFQQE_TOO_IDLE = 0,
	BFQQE_BUDGET_TIMEOUT = 1,
	BFQQE_BUDGET_EXHAUSTED = 2,
	BFQQE_NO_MORE_REQUESTS = 3,
	BFQQE_PREEMPTED = 4,
};

enum bfqq_state_flags {
	BFQQF_just_created = 0,
	BFQQF_busy = 1,
	BFQQF_wait_request = 2,
	BFQQF_non_blocking_wait_rq = 3,
	BFQQF_fifo_expire = 4,
	BFQQF_has_short_ttime = 5,
	BFQQF_sync = 6,
	BFQQF_IO_bound = 7,
	BFQQF_in_large_burst = 8,
	BFQQF_softrt_update = 9,
	BFQQF_coop = 10,
	BFQQF_split_coop = 11,
};

enum bh_state_bits {
	BH_Uptodate = 0,
	BH_Dirty = 1,
	BH_Lock = 2,
	BH_Req = 3,
	BH_Mapped = 4,
	BH_New = 5,
	BH_Async_Read = 6,
	BH_Async_Write = 7,
	BH_Delay = 8,
	BH_Boundary = 9,
	BH_Write_EIO = 10,
	BH_Unwritten = 11,
	BH_Quiet = 12,
	BH_Meta = 13,
	BH_Prio = 14,
	BH_Defer_Completion = 15,
	BH_PrivateStart = 16,
};

enum bio_merge_status {
	BIO_MERGE_OK = 0,
	BIO_MERGE_NONE = 1,
	BIO_MERGE_FAILED = 2,
};

enum bio_post_read_step {
	STEP_INITIAL = 0,
	STEP_DECRYPT = 1,
	STEP_VERITY = 2,
	STEP_MAX = 3,
};

enum bip_flags {
	BIP_BLOCK_INTEGRITY = 1,
	BIP_MAPPED_INTEGRITY = 2,
	BIP_DISK_NOCHECK = 4,
	BIP_IP_CHECKSUM = 8,
	BIP_COPY_USER = 16,
	BIP_CHECK_GUARD = 32,
	BIP_CHECK_REFTAG = 64,
	BIP_CHECK_APPTAG = 128,
};

enum blacklist_hash_type {
	BLACKLIST_HASH_X509_TBS = 1,
	BLACKLIST_HASH_BINARY = 2,
};

enum blake2b_iv {
	BLAKE2B_IV0 = 7640891576956012808ULL,
	BLAKE2B_IV1 = 13503953896175478587ULL,
	BLAKE2B_IV2 = 4354685564936845355ULL,
	BLAKE2B_IV3 = 11912009170470909681ULL,
	BLAKE2B_IV4 = 5840696475078001361ULL,
	BLAKE2B_IV5 = 11170449401992604703ULL,
	BLAKE2B_IV6 = 2270897969802886507ULL,
	BLAKE2B_IV7 = 6620516959819538809ULL,
};

enum blake2b_lengths {
	BLAKE2B_BLOCK_SIZE = 128,
	BLAKE2B_HASH_SIZE = 64,
	BLAKE2B_KEY_SIZE = 64,
	BLAKE2B_160_HASH_SIZE = 20,
	BLAKE2B_256_HASH_SIZE = 32,
	BLAKE2B_384_HASH_SIZE = 48,
	BLAKE2B_512_HASH_SIZE = 64,
};

enum blake2s_iv {
	BLAKE2S_IV0 = 1779033703,
	BLAKE2S_IV1 = 3144134277,
	BLAKE2S_IV2 = 1013904242,
	BLAKE2S_IV3 = 2773480762,
	BLAKE2S_IV4 = 1359893119,
	BLAKE2S_IV5 = 2600822924,
	BLAKE2S_IV6 = 528734635,
	BLAKE2S_IV7 = 1541459225,
};

enum blake2s_lengths {
	BLAKE2S_BLOCK_SIZE = 64,
	BLAKE2S_HASH_SIZE = 32,
	BLAKE2S_KEY_SIZE = 32,
	BLAKE2S_128_HASH_SIZE = 16,
	BLAKE2S_160_HASH_SIZE = 20,
	BLAKE2S_224_HASH_SIZE = 28,
	BLAKE2S_256_HASH_SIZE = 32,
};

enum blk_crypto_mode_num {
	BLK_ENCRYPTION_MODE_INVALID = 0,
	BLK_ENCRYPTION_MODE_AES_256_XTS = 1,
	BLK_ENCRYPTION_MODE_AES_128_CBC_ESSIV = 2,
	BLK_ENCRYPTION_MODE_ADIANTUM = 3,
	BLK_ENCRYPTION_MODE_SM4_XTS = 4,
	BLK_ENCRYPTION_MODE_MAX = 5,
};

enum blk_default_limits {
	BLK_MAX_SEGMENTS = 128,
	BLK_SAFE_MAX_SECTORS = 255,
	BLK_MAX_SEGMENT_SIZE = 65536,
	BLK_SEG_BOUNDARY_MASK = 4294967295,
};

enum blk_eh_timer_return {
	BLK_EH_DONE = 0,
	BLK_EH_RESET_TIMER = 1,
};

enum blk_integrity_checksum {
	BLK_INTEGRITY_CSUM_NONE = 0,
	BLK_INTEGRITY_CSUM_IP = 1,
	BLK_INTEGRITY_CSUM_CRC = 2,
	BLK_INTEGRITY_CSUM_CRC64 = 3,
} __attribute__((mode(byte)));

enum blk_integrity_flags {
	BLK_INTEGRITY_NOVERIFY = 1,
	BLK_INTEGRITY_NOGENERATE = 2,
	BLK_INTEGRITY_DEVICE_CAPABLE = 4,
	BLK_INTEGRITY_REF_TAG = 8,
	BLK_INTEGRITY_STACKED = 16,
};

enum blk_unique_id {
	BLK_UID_T10 = 1,
	BLK_UID_EUI64 = 2,
	BLK_UID_NAA = 3,
};

enum blk_zone_cond {
	BLK_ZONE_COND_NOT_WP = 0,
	BLK_ZONE_COND_EMPTY = 1,
	BLK_ZONE_COND_IMP_OPEN = 2,
	BLK_ZONE_COND_EXP_OPEN = 3,
	BLK_ZONE_COND_CLOSED = 4,
	BLK_ZONE_COND_READONLY = 13,
	BLK_ZONE_COND_FULL = 14,
	BLK_ZONE_COND_OFFLINE = 15,
};

enum blk_zone_report_flags {
	BLK_ZONE_REP_CAPACITY = 1,
};

enum blk_zone_type {
	BLK_ZONE_TYPE_CONVENTIONAL = 1,
	BLK_ZONE_TYPE_SEQWRITE_REQ = 2,
	BLK_ZONE_TYPE_SEQWRITE_PREF = 3,
};

enum blkg_iostat_type {
	BLKG_IOSTAT_READ = 0,
	BLKG_IOSTAT_WRITE = 1,
	BLKG_IOSTAT_DISCARD = 2,
	BLKG_IOSTAT_NR = 3,
};

enum blkg_rwstat_type {
	BLKG_RWSTAT_READ = 0,
	BLKG_RWSTAT_WRITE = 1,
	BLKG_RWSTAT_SYNC = 2,
	BLKG_RWSTAT_ASYNC = 3,
	BLKG_RWSTAT_DISCARD = 4,
	BLKG_RWSTAT_NR = 5,
	BLKG_RWSTAT_TOTAL = 5,
};

enum blktrace_act {
	__BLK_TA_QUEUE = 1,
	__BLK_TA_BACKMERGE = 2,
	__BLK_TA_FRONTMERGE = 3,
	__BLK_TA_GETRQ = 4,
	__BLK_TA_SLEEPRQ = 5,
	__BLK_TA_REQUEUE = 6,
	__BLK_TA_ISSUE = 7,
	__BLK_TA_COMPLETE = 8,
	__BLK_TA_PLUG = 9,
	__BLK_TA_UNPLUG_IO = 10,
	__BLK_TA_UNPLUG_TIMER = 11,
	__BLK_TA_INSERT = 12,
	__BLK_TA_SPLIT = 13,
	__BLK_TA_BOUNCE = 14,
	__BLK_TA_REMAP = 15,
	__BLK_TA_ABORT = 16,
	__BLK_TA_DRV_DATA = 17,
	__BLK_TA_CGROUP = 256,
};

enum block_state {
	NON_BLOCKING = 0,
	BLOCKING = 1,
};

enum board_ids {
	board_ahci = 0,
	board_ahci_43bit_dma = 1,
	board_ahci_ign_iferr = 2,
	board_ahci_no_debounce_delay = 3,
	board_ahci_no_msi = 4,
	board_ahci_pcs_quirk = 5,
	board_ahci_pcs_quirk_no_devslp = 6,
	board_ahci_pcs_quirk_no_sntf = 7,
	board_ahci_yes_fbs = 8,
	board_ahci_al = 9,
	board_ahci_avn = 10,
	board_ahci_mcp65 = 11,
	board_ahci_mcp77 = 12,
	board_ahci_mcp89 = 13,
	board_ahci_mv = 14,
	board_ahci_sb600 = 15,
	board_ahci_sb700 = 16,
	board_ahci_vt8251 = 17,
	board_ahci_mcp_linux = 11,
	board_ahci_mcp67 = 11,
	board_ahci_mcp73 = 11,
	board_ahci_mcp79 = 12,
};

enum bp_type_idx {
	TYPE_INST = 0,
	TYPE_DATA = 1,
	TYPE_MAX = 2,
};

enum bpf_access_src {
	ACCESS_DIRECT = 1,
	ACCESS_HELPER = 2,
};

enum bpf_access_type {
	BPF_READ = 1,
	BPF_WRITE = 2,
};

enum bpf_addr_space_cast {
	BPF_ADDR_SPACE_CAST = 1,
};

enum bpf_adj_room_mode {
	BPF_ADJ_ROOM_NET = 0,
	BPF_ADJ_ROOM_MAC = 1,
};

enum bpf_arg_type {
	ARG_DONTCARE = 0,
	ARG_CONST_MAP_PTR = 1,
	ARG_PTR_TO_MAP_KEY = 2,
	ARG_PTR_TO_MAP_VALUE = 3,
	ARG_PTR_TO_MEM = 4,
	ARG_PTR_TO_ARENA = 5,
	ARG_CONST_SIZE = 6,
	ARG_CONST_SIZE_OR_ZERO = 7,
	ARG_PTR_TO_CTX = 8,
	ARG_ANYTHING = 9,
	ARG_PTR_TO_SPIN_LOCK = 10,
	ARG_PTR_TO_SOCK_COMMON = 11,
	ARG_PTR_TO_SOCKET = 12,
	ARG_PTR_TO_BTF_ID = 13,
	ARG_PTR_TO_RINGBUF_MEM = 14,
	ARG_CONST_ALLOC_SIZE_OR_ZERO = 15,
	ARG_PTR_TO_BTF_ID_SOCK_COMMON = 16,
	ARG_PTR_TO_PERCPU_BTF_ID = 17,
	ARG_PTR_TO_FUNC = 18,
	ARG_PTR_TO_STACK = 19,
	ARG_PTR_TO_CONST_STR = 20,
	ARG_PTR_TO_TIMER = 21,
	ARG_KPTR_XCHG_DEST = 22,
	ARG_PTR_TO_DYNPTR = 23,
	__BPF_ARG_TYPE_MAX = 24,
	ARG_PTR_TO_MAP_VALUE_OR_NULL = 259,
	ARG_PTR_TO_MEM_OR_NULL = 260,
	ARG_PTR_TO_CTX_OR_NULL = 264,
	ARG_PTR_TO_SOCKET_OR_NULL = 268,
	ARG_PTR_TO_STACK_OR_NULL = 275,
	ARG_PTR_TO_BTF_ID_OR_NULL = 269,
	ARG_PTR_TO_UNINIT_MEM = 67141636,
	ARG_PTR_TO_FIXED_SIZE_MEM = 262148,
	__BPF_ARG_TYPE_LIMIT = 134217727,
};

enum bpf_async_type {
	BPF_ASYNC_TYPE_TIMER = 0,
	BPF_ASYNC_TYPE_WQ = 1,
};

enum bpf_attach_type {
	BPF_CGROUP_INET_INGRESS = 0,
	BPF_CGROUP_INET_EGRESS = 1,
	BPF_CGROUP_INET_SOCK_CREATE = 2,
	BPF_CGROUP_SOCK_OPS = 3,
	BPF_SK_SKB_STREAM_PARSER = 4,
	BPF_SK_SKB_STREAM_VERDICT = 5,
	BPF_CGROUP_DEVICE = 6,
	BPF_SK_MSG_VERDICT = 7,
	BPF_CGROUP_INET4_BIND = 8,
	BPF_CGROUP_INET6_BIND = 9,
	BPF_CGROUP_INET4_CONNECT = 10,
	BPF_CGROUP_INET6_CONNECT = 11,
	BPF_CGROUP_INET4_POST_BIND = 12,
	BPF_CGROUP_INET6_POST_BIND = 13,
	BPF_CGROUP_UDP4_SENDMSG = 14,
	BPF_CGROUP_UDP6_SENDMSG = 15,
	BPF_LIRC_MODE2 = 16,
	BPF_FLOW_DISSECTOR = 17,
	BPF_CGROUP_SYSCTL = 18,
	BPF_CGROUP_UDP4_RECVMSG = 19,
	BPF_CGROUP_UDP6_RECVMSG = 20,
	BPF_CGROUP_GETSOCKOPT = 21,
	BPF_CGROUP_SETSOCKOPT = 22,
	BPF_TRACE_RAW_TP = 23,
	BPF_TRACE_FENTRY = 24,
	BPF_TRACE_FEXIT = 25,
	BPF_MODIFY_RETURN = 26,
	BPF_LSM_MAC = 27,
	BPF_TRACE_ITER = 28,
	BPF_CGROUP_INET4_GETPEERNAME = 29,
	BPF_CGROUP_INET6_GETPEERNAME = 30,
	BPF_CGROUP_INET4_GETSOCKNAME = 31,
	BPF_CGROUP_INET6_GETSOCKNAME = 32,
	BPF_XDP_DEVMAP = 33,
	BPF_CGROUP_INET_SOCK_RELEASE = 34,
	BPF_XDP_CPUMAP = 35,
	BPF_SK_LOOKUP = 36,
	BPF_XDP = 37,
	BPF_SK_SKB_VERDICT = 38,
	BPF_SK_REUSEPORT_SELECT = 39,
	BPF_SK_REUSEPORT_SELECT_OR_MIGRATE = 40,
	BPF_PERF_EVENT = 41,
	BPF_TRACE_KPROBE_MULTI = 42,
	BPF_LSM_CGROUP = 43,
	BPF_STRUCT_OPS = 44,
	BPF_NETFILTER = 45,
	BPF_TCX_INGRESS = 46,
	BPF_TCX_EGRESS = 47,
	BPF_TRACE_UPROBE_MULTI = 48,
	BPF_CGROUP_UNIX_CONNECT = 49,
	BPF_CGROUP_UNIX_SENDMSG = 50,
	BPF_CGROUP_UNIX_RECVMSG = 51,
	BPF_CGROUP_UNIX_GETPEERNAME = 52,
	BPF_CGROUP_UNIX_GETSOCKNAME = 53,
	BPF_NETKIT_PRIMARY = 54,
	BPF_NETKIT_PEER = 55,
	BPF_TRACE_KPROBE_SESSION = 56,
	BPF_TRACE_UPROBE_SESSION = 57,
	__MAX_BPF_ATTACH_TYPE = 58,
};

enum bpf_audit {
	BPF_AUDIT_LOAD = 0,
	BPF_AUDIT_UNLOAD = 1,
	BPF_AUDIT_MAX = 2,
};

enum bpf_cgroup_iter_order {
	BPF_CGROUP_ITER_ORDER_UNSPEC = 0,
	BPF_CGROUP_ITER_SELF_ONLY = 1,
	BPF_CGROUP_ITER_DESCENDANTS_PRE = 2,
	BPF_CGROUP_ITER_DESCENDANTS_POST = 3,
	BPF_CGROUP_ITER_ANCESTORS_UP = 4,
};

enum bpf_cgroup_storage_type {
	BPF_CGROUP_STORAGE_SHARED = 0,
	BPF_CGROUP_STORAGE_PERCPU = 1,
	__BPF_CGROUP_STORAGE_MAX = 2,
};

enum bpf_check_mtu_flags {
	BPF_MTU_CHK_SEGS = 1,
};

enum bpf_check_mtu_ret {
	BPF_MTU_CHK_RET_SUCCESS = 0,
	BPF_MTU_CHK_RET_FRAG_NEEDED = 1,
	BPF_MTU_CHK_RET_SEGS_TOOBIG = 2,
};

enum bpf_cmd {
	BPF_MAP_CREATE = 0,
	BPF_MAP_LOOKUP_ELEM = 1,
	BPF_MAP_UPDATE_ELEM = 2,
	BPF_MAP_DELETE_ELEM = 3,
	BPF_MAP_GET_NEXT_KEY = 4,
	BPF_PROG_LOAD = 5,
	BPF_OBJ_PIN = 6,
	BPF_OBJ_GET = 7,
	BPF_PROG_ATTACH = 8,
	BPF_PROG_DETACH = 9,
	BPF_PROG_TEST_RUN = 10,
	BPF_PROG_RUN = 10,
	BPF_PROG_GET_NEXT_ID = 11,
	BPF_MAP_GET_NEXT_ID = 12,
	BPF_PROG_GET_FD_BY_ID = 13,
	BPF_MAP_GET_FD_BY_ID = 14,
	BPF_OBJ_GET_INFO_BY_FD = 15,
	BPF_PROG_QUERY = 16,
	BPF_RAW_TRACEPOINT_OPEN = 17,
	BPF_BTF_LOAD = 18,
	BPF_BTF_GET_FD_BY_ID = 19,
	BPF_TASK_FD_QUERY = 20,
	BPF_MAP_LOOKUP_AND_DELETE_ELEM = 21,
	BPF_MAP_FREEZE = 22,
	BPF_BTF_GET_NEXT_ID = 23,
	BPF_MAP_LOOKUP_BATCH = 24,
	BPF_MAP_LOOKUP_AND_DELETE_BATCH = 25,
	BPF_MAP_UPDATE_BATCH = 26,
	BPF_MAP_DELETE_BATCH = 27,
	BPF_LINK_CREATE = 28,
	BPF_LINK_UPDATE = 29,
	BPF_LINK_GET_FD_BY_ID = 30,
	BPF_LINK_GET_NEXT_ID = 31,
	BPF_ENABLE_STATS = 32,
	BPF_ITER_CREATE = 33,
	BPF_LINK_DETACH = 34,
	BPF_PROG_BIND_MAP = 35,
	BPF_TOKEN_CREATE = 36,
	__MAX_BPF_CMD = 37,
};

enum bpf_cond_pseudo_jmp {
	BPF_MAY_GOTO = 0,
};

enum bpf_core_relo_kind {
	BPF_CORE_FIELD_BYTE_OFFSET = 0,
	BPF_CORE_FIELD_BYTE_SIZE = 1,
	BPF_CORE_FIELD_EXISTS = 2,
	BPF_CORE_FIELD_SIGNED = 3,
	BPF_CORE_FIELD_LSHIFT_U64 = 4,
	BPF_CORE_FIELD_RSHIFT_U64 = 5,
	BPF_CORE_TYPE_ID_LOCAL = 6,
	BPF_CORE_TYPE_ID_TARGET = 7,
	BPF_CORE_TYPE_EXISTS = 8,
	BPF_CORE_TYPE_SIZE = 9,
	BPF_CORE_ENUMVAL_EXISTS = 10,
	BPF_CORE_ENUMVAL_VALUE = 11,
	BPF_CORE_TYPE_MATCHES = 12,
};

enum bpf_dynptr_type {
	BPF_DYNPTR_TYPE_INVALID = 0,
	BPF_DYNPTR_TYPE_LOCAL = 1,
	BPF_DYNPTR_TYPE_RINGBUF = 2,
	BPF_DYNPTR_TYPE_SKB = 3,
	BPF_DYNPTR_TYPE_XDP = 4,
};

enum bpf_func_id {
	BPF_FUNC_unspec = 0,
	BPF_FUNC_map_lookup_elem = 1,
	BPF_FUNC_map_update_elem = 2,
	BPF_FUNC_map_delete_elem = 3,
	BPF_FUNC_probe_read = 4,
	BPF_FUNC_ktime_get_ns = 5,
	BPF_FUNC_trace_printk = 6,
	BPF_FUNC_get_prandom_u32 = 7,
	BPF_FUNC_get_smp_processor_id = 8,
	BPF_FUNC_skb_store_bytes = 9,
	BPF_FUNC_l3_csum_replace = 10,
	BPF_FUNC_l4_csum_replace = 11,
	BPF_FUNC_tail_call = 12,
	BPF_FUNC_clone_redirect = 13,
	BPF_FUNC_get_current_pid_tgid = 14,
	BPF_FUNC_get_current_uid_gid = 15,
	BPF_FUNC_get_current_comm = 16,
	BPF_FUNC_get_cgroup_classid = 17,
	BPF_FUNC_skb_vlan_push = 18,
	BPF_FUNC_skb_vlan_pop = 19,
	BPF_FUNC_skb_get_tunnel_key = 20,
	BPF_FUNC_skb_set_tunnel_key = 21,
	BPF_FUNC_perf_event_read = 22,
	BPF_FUNC_redirect = 23,
	BPF_FUNC_get_route_realm = 24,
	BPF_FUNC_perf_event_output = 25,
	BPF_FUNC_skb_load_bytes = 26,
	BPF_FUNC_get_stackid = 27,
	BPF_FUNC_csum_diff = 28,
	BPF_FUNC_skb_get_tunnel_opt = 29,
	BPF_FUNC_skb_set_tunnel_opt = 30,
	BPF_FUNC_skb_change_proto = 31,
	BPF_FUNC_skb_change_type = 32,
	BPF_FUNC_skb_under_cgroup = 33,
	BPF_FUNC_get_hash_recalc = 34,
	BPF_FUNC_get_current_task = 35,
	BPF_FUNC_probe_write_user = 36,
	BPF_FUNC_current_task_under_cgroup = 37,
	BPF_FUNC_skb_change_tail = 38,
	BPF_FUNC_skb_pull_data = 39,
	BPF_FUNC_csum_update = 40,
	BPF_FUNC_set_hash_invalid = 41,
	BPF_FUNC_get_numa_node_id = 42,
	BPF_FUNC_skb_change_head = 43,
	BPF_FUNC_xdp_adjust_head = 44,
	BPF_FUNC_probe_read_str = 45,
	BPF_FUNC_get_socket_cookie = 46,
	BPF_FUNC_get_socket_uid = 47,
	BPF_FUNC_set_hash = 48,
	BPF_FUNC_setsockopt = 49,
	BPF_FUNC_skb_adjust_room = 50,
	BPF_FUNC_redirect_map = 51,
	BPF_FUNC_sk_redirect_map = 52,
	BPF_FUNC_sock_map_update = 53,
	BPF_FUNC_xdp_adjust_meta = 54,
	BPF_FUNC_perf_event_read_value = 55,
	BPF_FUNC_perf_prog_read_value = 56,
	BPF_FUNC_getsockopt = 57,
	BPF_FUNC_override_return = 58,
	BPF_FUNC_sock_ops_cb_flags_set = 59,
	BPF_FUNC_msg_redirect_map = 60,
	BPF_FUNC_msg_apply_bytes = 61,
	BPF_FUNC_msg_cork_bytes = 62,
	BPF_FUNC_msg_pull_data = 63,
	BPF_FUNC_bind = 64,
	BPF_FUNC_xdp_adjust_tail = 65,
	BPF_FUNC_skb_get_xfrm_state = 66,
	BPF_FUNC_get_stack = 67,
	BPF_FUNC_skb_load_bytes_relative = 68,
	BPF_FUNC_fib_lookup = 69,
	BPF_FUNC_sock_hash_update = 70,
	BPF_FUNC_msg_redirect_hash = 71,
	BPF_FUNC_sk_redirect_hash = 72,
	BPF_FUNC_lwt_push_encap = 73,
	BPF_FUNC_lwt_seg6_store_bytes = 74,
	BPF_FUNC_lwt_seg6_adjust_srh = 75,
	BPF_FUNC_lwt_seg6_action = 76,
	BPF_FUNC_rc_repeat = 77,
	BPF_FUNC_rc_keydown = 78,
	BPF_FUNC_skb_cgroup_id = 79,
	BPF_FUNC_get_current_cgroup_id = 80,
	BPF_FUNC_get_local_storage = 81,
	BPF_FUNC_sk_select_reuseport = 82,
	BPF_FUNC_skb_ancestor_cgroup_id = 83,
	BPF_FUNC_sk_lookup_tcp = 84,
	BPF_FUNC_sk_lookup_udp = 85,
	BPF_FUNC_sk_release = 86,
	BPF_FUNC_map_push_elem = 87,
	BPF_FUNC_map_pop_elem = 88,
	BPF_FUNC_map_peek_elem = 89,
	BPF_FUNC_msg_push_data = 90,
	BPF_FUNC_msg_pop_data = 91,
	BPF_FUNC_rc_pointer_rel = 92,
	BPF_FUNC_spin_lock = 93,
	BPF_FUNC_spin_unlock = 94,
	BPF_FUNC_sk_fullsock = 95,
	BPF_FUNC_tcp_sock = 96,
	BPF_FUNC_skb_ecn_set_ce = 97,
	BPF_FUNC_get_listener_sock = 98,
	BPF_FUNC_skc_lookup_tcp = 99,
	BPF_FUNC_tcp_check_syncookie = 100,
	BPF_FUNC_sysctl_get_name = 101,
	BPF_FUNC_sysctl_get_current_value = 102,
	BPF_FUNC_sysctl_get_new_value = 103,
	BPF_FUNC_sysctl_set_new_value = 104,
	BPF_FUNC_strtol = 105,
	BPF_FUNC_strtoul = 106,
	BPF_FUNC_sk_storage_get = 107,
	BPF_FUNC_sk_storage_delete = 108,
	BPF_FUNC_send_signal = 109,
	BPF_FUNC_tcp_gen_syncookie = 110,
	BPF_FUNC_skb_output = 111,
	BPF_FUNC_probe_read_user = 112,
	BPF_FUNC_probe_read_kernel = 113,
	BPF_FUNC_probe_read_user_str = 114,
	BPF_FUNC_probe_read_kernel_str = 115,
	BPF_FUNC_tcp_send_ack = 116,
	BPF_FUNC_send_signal_thread = 117,
	BPF_FUNC_jiffies64 = 118,
	BPF_FUNC_read_branch_records = 119,
	BPF_FUNC_get_ns_current_pid_tgid = 120,
	BPF_FUNC_xdp_output = 121,
	BPF_FUNC_get_netns_cookie = 122,
	BPF_FUNC_get_current_ancestor_cgroup_id = 123,
	BPF_FUNC_sk_assign = 124,
	BPF_FUNC_ktime_get_boot_ns = 125,
	BPF_FUNC_seq_printf = 126,
	BPF_FUNC_seq_write = 127,
	BPF_FUNC_sk_cgroup_id = 128,
	BPF_FUNC_sk_ancestor_cgroup_id = 129,
	BPF_FUNC_ringbuf_output = 130,
	BPF_FUNC_ringbuf_reserve = 131,
	BPF_FUNC_ringbuf_submit = 132,
	BPF_FUNC_ringbuf_discard = 133,
	BPF_FUNC_ringbuf_query = 134,
	BPF_FUNC_csum_level = 135,
	BPF_FUNC_skc_to_tcp6_sock = 136,
	BPF_FUNC_skc_to_tcp_sock = 137,
	BPF_FUNC_skc_to_tcp_timewait_sock = 138,
	BPF_FUNC_skc_to_tcp_request_sock = 139,
	BPF_FUNC_skc_to_udp6_sock = 140,
	BPF_FUNC_get_task_stack = 141,
	BPF_FUNC_load_hdr_opt = 142,
	BPF_FUNC_store_hdr_opt = 143,
	BPF_FUNC_reserve_hdr_opt = 144,
	BPF_FUNC_inode_storage_get = 145,
	BPF_FUNC_inode_storage_delete = 146,
	BPF_FUNC_d_path = 147,
	BPF_FUNC_copy_from_user = 148,
	BPF_FUNC_snprintf_btf = 149,
	BPF_FUNC_seq_printf_btf = 150,
	BPF_FUNC_skb_cgroup_classid = 151,
	BPF_FUNC_redirect_neigh = 152,
	BPF_FUNC_per_cpu_ptr = 153,
	BPF_FUNC_this_cpu_ptr = 154,
	BPF_FUNC_redirect_peer = 155,
	BPF_FUNC_task_storage_get = 156,
	BPF_FUNC_task_storage_delete = 157,
	BPF_FUNC_get_current_task_btf = 158,
	BPF_FUNC_bprm_opts_set = 159,
	BPF_FUNC_ktime_get_coarse_ns = 160,
	BPF_FUNC_ima_inode_hash = 161,
	BPF_FUNC_sock_from_file = 162,
	BPF_FUNC_check_mtu = 163,
	BPF_FUNC_for_each_map_elem = 164,
	BPF_FUNC_snprintf = 165,
	BPF_FUNC_sys_bpf = 166,
	BPF_FUNC_btf_find_by_name_kind = 167,
	BPF_FUNC_sys_close = 168,
	BPF_FUNC_timer_init = 169,
	BPF_FUNC_timer_set_callback = 170,
	BPF_FUNC_timer_start = 171,
	BPF_FUNC_timer_cancel = 172,
	BPF_FUNC_get_func_ip = 173,
	BPF_FUNC_get_attach_cookie = 174,
	BPF_FUNC_task_pt_regs = 175,
	BPF_FUNC_get_branch_snapshot = 176,
	BPF_FUNC_trace_vprintk = 177,
	BPF_FUNC_skc_to_unix_sock = 178,
	BPF_FUNC_kallsyms_lookup_name = 179,
	BPF_FUNC_find_vma = 180,
	BPF_FUNC_loop = 181,
	BPF_FUNC_strncmp = 182,
	BPF_FUNC_get_func_arg = 183,
	BPF_FUNC_get_func_ret = 184,
	BPF_FUNC_get_func_arg_cnt = 185,
	BPF_FUNC_get_retval = 186,
	BPF_FUNC_set_retval = 187,
	BPF_FUNC_xdp_get_buff_len = 188,
	BPF_FUNC_xdp_load_bytes = 189,
	BPF_FUNC_xdp_store_bytes = 190,
	BPF_FUNC_copy_from_user_task = 191,
	BPF_FUNC_skb_set_tstamp = 192,
	BPF_FUNC_ima_file_hash = 193,
	BPF_FUNC_kptr_xchg = 194,
	BPF_FUNC_map_lookup_percpu_elem = 195,
	BPF_FUNC_skc_to_mptcp_sock = 196,
	BPF_FUNC_dynptr_from_mem = 197,
	BPF_FUNC_ringbuf_reserve_dynptr = 198,
	BPF_FUNC_ringbuf_submit_dynptr = 199,
	BPF_FUNC_ringbuf_discard_dynptr = 200,
	BPF_FUNC_dynptr_read = 201,
	BPF_FUNC_dynptr_write = 202,
	BPF_FUNC_dynptr_data = 203,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv4 = 204,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv6 = 205,
	BPF_FUNC_tcp_raw_check_syncookie_ipv4 = 206,
	BPF_FUNC_tcp_raw_check_syncookie_ipv6 = 207,
	BPF_FUNC_ktime_get_tai_ns = 208,
	BPF_FUNC_user_ringbuf_drain = 209,
	BPF_FUNC_cgrp_storage_get = 210,
	BPF_FUNC_cgrp_storage_delete = 211,
	__BPF_FUNC_MAX_ID = 212,
};

enum bpf_hdr_start_off {
	BPF_HDR_START_MAC = 0,
	BPF_HDR_START_NET = 1,
};

enum bpf_iter_feature {
	BPF_ITER_RESCHED = 1,
};

enum bpf_iter_state {
	BPF_ITER_STATE_INVALID = 0,
	BPF_ITER_STATE_ACTIVE = 1,
	BPF_ITER_STATE_DRAINED = 2,
};

enum bpf_iter_task_type {
	BPF_TASK_ITER_ALL = 0,
	BPF_TASK_ITER_TID = 1,
	BPF_TASK_ITER_TGID = 2,
};

enum bpf_jit_poke_reason {
	BPF_POKE_REASON_TAIL_CALL = 0,
};

enum bpf_kfunc_flags {
	BPF_F_PAD_ZEROS = 1,
};

enum bpf_link_type {
	BPF_LINK_TYPE_UNSPEC = 0,
	BPF_LINK_TYPE_RAW_TRACEPOINT = 1,
	BPF_LINK_TYPE_TRACING = 2,
	BPF_LINK_TYPE_CGROUP = 3,
	BPF_LINK_TYPE_ITER = 4,
	BPF_LINK_TYPE_NETNS = 5,
	BPF_LINK_TYPE_XDP = 6,
	BPF_LINK_TYPE_PERF_EVENT = 7,
	BPF_LINK_TYPE_KPROBE_MULTI = 8,
	BPF_LINK_TYPE_STRUCT_OPS = 9,
	BPF_LINK_TYPE_NETFILTER = 10,
	BPF_LINK_TYPE_TCX = 11,
	BPF_LINK_TYPE_UPROBE_MULTI = 12,
	BPF_LINK_TYPE_NETKIT = 13,
	BPF_LINK_TYPE_SOCKMAP = 14,
	__MAX_BPF_LINK_TYPE = 15,
};

enum bpf_lru_list_type {
	BPF_LRU_LIST_T_ACTIVE = 0,
	BPF_LRU_LIST_T_INACTIVE = 1,
	BPF_LRU_LIST_T_FREE = 2,
	BPF_LRU_LOCAL_LIST_T_FREE = 3,
	BPF_LRU_LOCAL_LIST_T_PENDING = 4,
};

enum bpf_map_type {
	BPF_MAP_TYPE_UNSPEC = 0,
	BPF_MAP_TYPE_HASH = 1,
	BPF_MAP_TYPE_ARRAY = 2,
	BPF_MAP_TYPE_PROG_ARRAY = 3,
	BPF_MAP_TYPE_PERF_EVENT_ARRAY = 4,
	BPF_MAP_TYPE_PERCPU_HASH = 5,
	BPF_MAP_TYPE_PERCPU_ARRAY = 6,
	BPF_MAP_TYPE_STACK_TRACE = 7,
	BPF_MAP_TYPE_CGROUP_ARRAY = 8,
	BPF_MAP_TYPE_LRU_HASH = 9,
	BPF_MAP_TYPE_LRU_PERCPU_HASH = 10,
	BPF_MAP_TYPE_LPM_TRIE = 11,
	BPF_MAP_TYPE_ARRAY_OF_MAPS = 12,
	BPF_MAP_TYPE_HASH_OF_MAPS = 13,
	BPF_MAP_TYPE_DEVMAP = 14,
	BPF_MAP_TYPE_SOCKMAP = 15,
	BPF_MAP_TYPE_CPUMAP = 16,
	BPF_MAP_TYPE_XSKMAP = 17,
	BPF_MAP_TYPE_SOCKHASH = 18,
	BPF_MAP_TYPE_CGROUP_STORAGE_DEPRECATED = 19,
	BPF_MAP_TYPE_CGROUP_STORAGE = 19,
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY = 20,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE_DEPRECATED = 21,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE = 21,
	BPF_MAP_TYPE_QUEUE = 22,
	BPF_MAP_TYPE_STACK = 23,
	BPF_MAP_TYPE_SK_STORAGE = 24,
	BPF_MAP_TYPE_DEVMAP_HASH = 25,
	BPF_MAP_TYPE_STRUCT_OPS = 26,
	BPF_MAP_TYPE_RINGBUF = 27,
	BPF_MAP_TYPE_INODE_STORAGE = 28,
	BPF_MAP_TYPE_TASK_STORAGE = 29,
	BPF_MAP_TYPE_BLOOM_FILTER = 30,
	BPF_MAP_TYPE_USER_RINGBUF = 31,
	BPF_MAP_TYPE_CGRP_STORAGE = 32,
	BPF_MAP_TYPE_ARENA = 33,
	__MAX_BPF_MAP_TYPE = 34,
};

enum bpf_netdev_command {
	XDP_SETUP_PROG = 0,
	XDP_SETUP_PROG_HW = 1,
	BPF_OFFLOAD_MAP_ALLOC = 2,
	BPF_OFFLOAD_MAP_FREE = 3,
	XDP_SETUP_XSK_POOL = 4,
};

enum bpf_perf_event_type {
	BPF_PERF_EVENT_UNSPEC = 0,
	BPF_PERF_EVENT_UPROBE = 1,
	BPF_PERF_EVENT_URETPROBE = 2,
	BPF_PERF_EVENT_KPROBE = 3,
	BPF_PERF_EVENT_KRETPROBE = 4,
	BPF_PERF_EVENT_TRACEPOINT = 5,
	BPF_PERF_EVENT_EVENT = 6,
};

enum bpf_prog_type {
	BPF_PROG_TYPE_UNSPEC = 0,
	BPF_PROG_TYPE_SOCKET_FILTER = 1,
	BPF_PROG_TYPE_KPROBE = 2,
	BPF_PROG_TYPE_SCHED_CLS = 3,
	BPF_PROG_TYPE_SCHED_ACT = 4,
	BPF_PROG_TYPE_TRACEPOINT = 5,
	BPF_PROG_TYPE_XDP = 6,
	BPF_PROG_TYPE_PERF_EVENT = 7,
	BPF_PROG_TYPE_CGROUP_SKB = 8,
	BPF_PROG_TYPE_CGROUP_SOCK = 9,
	BPF_PROG_TYPE_LWT_IN = 10,
	BPF_PROG_TYPE_LWT_OUT = 11,
	BPF_PROG_TYPE_LWT_XMIT = 12,
	BPF_PROG_TYPE_SOCK_OPS = 13,
	BPF_PROG_TYPE_SK_SKB = 14,
	BPF_PROG_TYPE_CGROUP_DEVICE = 15,
	BPF_PROG_TYPE_SK_MSG = 16,
	BPF_PROG_TYPE_RAW_TRACEPOINT = 17,
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR = 18,
	BPF_PROG_TYPE_LWT_SEG6LOCAL = 19,
	BPF_PROG_TYPE_LIRC_MODE2 = 20,
	BPF_PROG_TYPE_SK_REUSEPORT = 21,
	BPF_PROG_TYPE_FLOW_DISSECTOR = 22,
	BPF_PROG_TYPE_CGROUP_SYSCTL = 23,
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 24,
	BPF_PROG_TYPE_CGROUP_SOCKOPT = 25,
	BPF_PROG_TYPE_TRACING = 26,
	BPF_PROG_TYPE_STRUCT_OPS = 27,
	BPF_PROG_TYPE_EXT = 28,
	BPF_PROG_TYPE_LSM = 29,
	BPF_PROG_TYPE_SK_LOOKUP = 30,
	BPF_PROG_TYPE_SYSCALL = 31,
	BPF_PROG_TYPE_NETFILTER = 32,
	__MAX_BPF_PROG_TYPE = 33,
};

enum bpf_reg_liveness {
	REG_LIVE_NONE = 0,
	REG_LIVE_READ32 = 1,
	REG_LIVE_READ64 = 2,
	REG_LIVE_READ = 3,
	REG_LIVE_WRITTEN = 4,
	REG_LIVE_DONE = 8,
};

enum bpf_reg_type {
	NOT_INIT = 0,
	SCALAR_VALUE = 1,
	PTR_TO_CTX = 2,
	CONST_PTR_TO_MAP = 3,
	PTR_TO_MAP_VALUE = 4,
	PTR_TO_MAP_KEY = 5,
	PTR_TO_STACK = 6,
	PTR_TO_PACKET_META = 7,
	PTR_TO_PACKET = 8,
	PTR_TO_PACKET_END = 9,
	PTR_TO_FLOW_KEYS = 10,
	PTR_TO_SOCKET = 11,
	PTR_TO_SOCK_COMMON = 12,
	PTR_TO_TCP_SOCK = 13,
	PTR_TO_TP_BUFFER = 14,
	PTR_TO_XDP_SOCK = 15,
	PTR_TO_BTF_ID = 16,
	PTR_TO_MEM = 17,
	PTR_TO_ARENA = 18,
	PTR_TO_BUF = 19,
	PTR_TO_FUNC = 20,
	CONST_PTR_TO_DYNPTR = 21,
	__BPF_REG_TYPE_MAX = 22,
	PTR_TO_MAP_VALUE_OR_NULL = 260,
	PTR_TO_SOCKET_OR_NULL = 267,
	PTR_TO_SOCK_COMMON_OR_NULL = 268,
	PTR_TO_TCP_SOCK_OR_NULL = 269,
	PTR_TO_BTF_ID_OR_NULL = 272,
	__BPF_REG_TYPE_LIMIT = 134217727,
};

enum bpf_ret_code {
	BPF_OK = 0,
	BPF_DROP = 2,
	BPF_REDIRECT = 7,
	BPF_LWT_REROUTE = 128,
	BPF_FLOW_DISSECTOR_CONTINUE = 129,
};

enum bpf_return_type {
	RET_INTEGER = 0,
	RET_VOID = 1,
	RET_PTR_TO_MAP_VALUE = 2,
	RET_PTR_TO_SOCKET = 3,
	RET_PTR_TO_TCP_SOCK = 4,
	RET_PTR_TO_SOCK_COMMON = 5,
	RET_PTR_TO_MEM = 6,
	RET_PTR_TO_MEM_OR_BTF_ID = 7,
	RET_PTR_TO_BTF_ID = 8,
	__BPF_RET_TYPE_MAX = 9,
	RET_PTR_TO_MAP_VALUE_OR_NULL = 258,
	RET_PTR_TO_SOCKET_OR_NULL = 259,
	RET_PTR_TO_TCP_SOCK_OR_NULL = 260,
	RET_PTR_TO_SOCK_COMMON_OR_NULL = 261,
	RET_PTR_TO_RINGBUF_MEM_OR_NULL = 1286,
	RET_PTR_TO_DYNPTR_MEM_OR_NULL = 262,
	RET_PTR_TO_BTF_ID_OR_NULL = 264,
	RET_PTR_TO_BTF_ID_TRUSTED = 1048584,
	__BPF_RET_TYPE_LIMIT = 134217727,
};

enum bpf_stack_build_id_status {
	BPF_STACK_BUILD_ID_EMPTY = 0,
	BPF_STACK_BUILD_ID_VALID = 1,
	BPF_STACK_BUILD_ID_IP = 2,
};

enum bpf_stack_slot_type {
	STACK_INVALID = 0,
	STACK_SPILL = 1,
	STACK_MISC = 2,
	STACK_ZERO = 3,
	STACK_DYNPTR = 4,
	STACK_ITER = 5,
	STACK_IRQ_FLAG = 6,
};

enum bpf_stats_type {
	BPF_STATS_RUN_TIME = 0,
};

enum bpf_struct_ops_state {
	BPF_STRUCT_OPS_STATE_INIT = 0,
	BPF_STRUCT_OPS_STATE_INUSE = 1,
	BPF_STRUCT_OPS_STATE_TOBEFREE = 2,
	BPF_STRUCT_OPS_STATE_READY = 3,
};

enum bpf_struct_walk_result {
	WALK_SCALAR = 0,
	WALK_PTR = 1,
	WALK_STRUCT = 2,
};

enum bpf_task_fd_type {
	BPF_FD_TYPE_RAW_TRACEPOINT = 0,
	BPF_FD_TYPE_TRACEPOINT = 1,
	BPF_FD_TYPE_KPROBE = 2,
	BPF_FD_TYPE_KRETPROBE = 3,
	BPF_FD_TYPE_UPROBE = 4,
	BPF_FD_TYPE_URETPROBE = 5,
};

enum bpf_task_vma_iter_find_op {
	task_vma_iter_first_vma = 0,
	task_vma_iter_next_vma = 1,
	task_vma_iter_find_vma = 2,
};

enum bpf_text_poke_type {
	BPF_MOD_CALL = 0,
	BPF_MOD_JUMP = 1,
};

enum bpf_tramp_prog_type {
	BPF_TRAMP_FENTRY = 0,
	BPF_TRAMP_FEXIT = 1,
	BPF_TRAMP_MODIFY_RETURN = 2,
	BPF_TRAMP_MAX = 3,
	BPF_TRAMP_REPLACE = 4,
};

enum bpf_type {
	BPF_TYPE_UNSPEC = 0,
	BPF_TYPE_PROG = 1,
	BPF_TYPE_MAP = 2,
	BPF_TYPE_LINK = 3,
};

enum bpf_type_flag {
	PTR_MAYBE_NULL = 256,
	MEM_RDONLY = 512,
	MEM_RINGBUF = 1024,
	MEM_USER = 2048,
	MEM_PERCPU = 4096,
	OBJ_RELEASE = 8192,
	PTR_UNTRUSTED = 16384,
	MEM_UNINIT = 32768,
	DYNPTR_TYPE_LOCAL = 65536,
	DYNPTR_TYPE_RINGBUF = 131072,
	MEM_FIXED_SIZE = 262144,
	MEM_ALLOC = 524288,
	PTR_TRUSTED = 1048576,
	MEM_RCU = 2097152,
	NON_OWN_REF = 4194304,
	DYNPTR_TYPE_SKB = 8388608,
	DYNPTR_TYPE_XDP = 16777216,
	MEM_ALIGNED = 33554432,
	MEM_WRITE = 67108864,
	__BPF_TYPE_FLAG_MAX = 67108865,
	__BPF_TYPE_LAST_FLAG = 67108864,
};

enum bpf_xdp_mode {
	XDP_MODE_SKB = 0,
	XDP_MODE_DRV = 1,
	XDP_MODE_HW = 2,
	__MAX_XDP_MODE = 3,
};

enum btf_arg_tag {
	ARG_TAG_CTX = 1,
	ARG_TAG_NONNULL = 2,
	ARG_TAG_TRUSTED = 4,
	ARG_TAG_NULLABLE = 8,
	ARG_TAG_ARENA = 16,
};

enum btf_field_iter_kind {
	BTF_FIELD_ITER_IDS = 0,
	BTF_FIELD_ITER_STRS = 1,
};

enum btf_field_type {
	BPF_SPIN_LOCK = 1,
	BPF_TIMER = 2,
	BPF_KPTR_UNREF = 4,
	BPF_KPTR_REF = 8,
	BPF_KPTR_PERCPU = 16,
	BPF_KPTR = 28,
	BPF_LIST_HEAD = 32,
	BPF_LIST_NODE = 64,
	BPF_RB_ROOT = 128,
	BPF_RB_NODE = 256,
	BPF_GRAPH_NODE = 320,
	BPF_GRAPH_ROOT = 160,
	BPF_REFCOUNT = 512,
	BPF_WORKQUEUE = 1024,
	BPF_UPTR = 2048,
};

enum btf_func_linkage {
	BTF_FUNC_STATIC = 0,
	BTF_FUNC_GLOBAL = 1,
	BTF_FUNC_EXTERN = 2,
};

enum btf_kfunc_hook {
	BTF_KFUNC_HOOK_COMMON = 0,
	BTF_KFUNC_HOOK_XDP = 1,
	BTF_KFUNC_HOOK_TC = 2,
	BTF_KFUNC_HOOK_STRUCT_OPS = 3,
	BTF_KFUNC_HOOK_TRACING = 4,
	BTF_KFUNC_HOOK_SYSCALL = 5,
	BTF_KFUNC_HOOK_FMODRET = 6,
	BTF_KFUNC_HOOK_CGROUP = 7,
	BTF_KFUNC_HOOK_SCHED_ACT = 8,
	BTF_KFUNC_HOOK_SK_SKB = 9,
	BTF_KFUNC_HOOK_SOCKET_FILTER = 10,
	BTF_KFUNC_HOOK_LWT = 11,
	BTF_KFUNC_HOOK_NETFILTER = 12,
	BTF_KFUNC_HOOK_KPROBE = 13,
	BTF_KFUNC_HOOK_MAX = 14,
};

enum btrfs_block_group_flags {
	BLOCK_GROUP_FLAG_IREF = 0,
	BLOCK_GROUP_FLAG_REMOVED = 1,
	BLOCK_GROUP_FLAG_TO_COPY = 2,
	BLOCK_GROUP_FLAG_RELOCATING_REPAIR = 3,
	BLOCK_GROUP_FLAG_CHUNK_ITEM_INSERTED = 4,
	BLOCK_GROUP_FLAG_ZONE_IS_ACTIVE = 5,
	BLOCK_GROUP_FLAG_ZONED_DATA_RELOC = 6,
	BLOCK_GROUP_FLAG_NEEDS_FREE_SPACE = 7,
	BLOCK_GROUP_FLAG_SEQUENTIAL_ZONE = 8,
	BLOCK_GROUP_FLAG_NEW = 9,
};

enum btrfs_block_group_size_class {
	BTRFS_BG_SZ_NONE = 0,
	BTRFS_BG_SZ_SMALL = 1,
	BTRFS_BG_SZ_MEDIUM = 2,
	BTRFS_BG_SZ_LARGE = 3,
};

enum btrfs_caching_type {
	BTRFS_CACHE_NO = 0,
	BTRFS_CACHE_STARTED = 1,
	BTRFS_CACHE_FINISHED = 2,
	BTRFS_CACHE_ERROR = 3,
};

enum btrfs_chunk_alloc_enum {
	CHUNK_ALLOC_NO_FORCE = 0,
	CHUNK_ALLOC_LIMITED = 1,
	CHUNK_ALLOC_FORCE = 2,
	CHUNK_ALLOC_FORCE_FOR_EXTENT = 3,
};

enum btrfs_chunk_allocation_policy {
	BTRFS_CHUNK_ALLOC_REGULAR = 0,
	BTRFS_CHUNK_ALLOC_ZONED = 1,
};

enum btrfs_compare_tree_result {
	BTRFS_COMPARE_TREE_NEW = 0,
	BTRFS_COMPARE_TREE_DELETED = 1,
	BTRFS_COMPARE_TREE_CHANGED = 2,
	BTRFS_COMPARE_TREE_SAME = 3,
};

enum btrfs_compression_type {
	BTRFS_COMPRESS_NONE = 0,
	BTRFS_COMPRESS_ZLIB = 1,
	BTRFS_COMPRESS_LZO = 2,
	BTRFS_COMPRESS_ZSTD = 3,
	BTRFS_NR_COMPRESS_TYPES = 4,
};

enum btrfs_csum_type {
	BTRFS_CSUM_TYPE_CRC32 = 0,
	BTRFS_CSUM_TYPE_XXHASH = 1,
	BTRFS_CSUM_TYPE_SHA256 = 2,
	BTRFS_CSUM_TYPE_BLAKE2 = 3,
};

enum btrfs_delayed_item_type {
	BTRFS_DELAYED_INSERTION_ITEM = 0,
	BTRFS_DELAYED_DELETION_ITEM = 1,
};

enum btrfs_delayed_ref_action {
	BTRFS_ADD_DELAYED_REF = 1,
	BTRFS_DROP_DELAYED_REF = 2,
	BTRFS_ADD_DELAYED_EXTENT = 3,
	BTRFS_UPDATE_DELAYED_HEAD = 4,
} __attribute__((mode(byte)));

enum btrfs_delayed_ref_flags {
	BTRFS_DELAYED_REFS_FLUSHING = 0,
};

enum btrfs_dev_stat_values {
	BTRFS_DEV_STAT_WRITE_ERRS = 0,
	BTRFS_DEV_STAT_READ_ERRS = 1,
	BTRFS_DEV_STAT_FLUSH_ERRS = 2,
	BTRFS_DEV_STAT_CORRUPTION_ERRS = 3,
	BTRFS_DEV_STAT_GENERATION_ERRS = 4,
	BTRFS_DEV_STAT_VALUES_MAX = 5,
};

enum btrfs_discard_state {
	BTRFS_DISCARD_EXTENTS = 0,
	BTRFS_DISCARD_BITMAPS = 1,
	BTRFS_DISCARD_RESET_CURSOR = 2,
};

enum btrfs_disk_cache_state {
	BTRFS_DC_WRITTEN = 0,
	BTRFS_DC_ERROR = 1,
	BTRFS_DC_CLEAR = 2,
	BTRFS_DC_SETUP = 3,
};

enum btrfs_err_code {
	BTRFS_ERROR_DEV_RAID1_MIN_NOT_MET = 1,
	BTRFS_ERROR_DEV_RAID10_MIN_NOT_MET = 2,
	BTRFS_ERROR_DEV_RAID5_MIN_NOT_MET = 3,
	BTRFS_ERROR_DEV_RAID6_MIN_NOT_MET = 4,
	BTRFS_ERROR_DEV_TGT_REPLACE = 5,
	BTRFS_ERROR_DEV_MISSING_NOT_FOUND = 6,
	BTRFS_ERROR_DEV_ONLY_WRITABLE = 7,
	BTRFS_ERROR_DEV_EXCL_RUN_IN_PROGRESS = 8,
	BTRFS_ERROR_DEV_RAID1C3_MIN_NOT_MET = 9,
	BTRFS_ERROR_DEV_RAID1C4_MIN_NOT_MET = 10,
};

enum btrfs_exclusive_operation {
	BTRFS_EXCLOP_NONE = 0,
	BTRFS_EXCLOP_BALANCE_PAUSED = 1,
	BTRFS_EXCLOP_BALANCE = 2,
	BTRFS_EXCLOP_DEV_ADD = 3,
	BTRFS_EXCLOP_DEV_REMOVE = 4,
	BTRFS_EXCLOP_DEV_REPLACE = 5,
	BTRFS_EXCLOP_RESIZE = 6,
	BTRFS_EXCLOP_SWAP_ACTIVATE = 7,
};

enum btrfs_extent_allocation_policy {
	BTRFS_EXTENT_ALLOC_CLUSTERED = 0,
	BTRFS_EXTENT_ALLOC_ZONED = 1,
};

enum btrfs_feature_set {
	FEAT_COMPAT = 0,
	FEAT_COMPAT_RO = 1,
	FEAT_INCOMPAT = 2,
	FEAT_MAX = 3,
};

enum btrfs_flush_state {
	FLUSH_DELAYED_ITEMS_NR = 1,
	FLUSH_DELAYED_ITEMS = 2,
	FLUSH_DELAYED_REFS_NR = 3,
	FLUSH_DELAYED_REFS = 4,
	FLUSH_DELALLOC = 5,
	FLUSH_DELALLOC_WAIT = 6,
	FLUSH_DELALLOC_FULL = 7,
	ALLOC_CHUNK = 8,
	ALLOC_CHUNK_FORCE = 9,
	RUN_DELAYED_IPUTS = 10,
	COMMIT_TRANS = 11,
	RESET_ZONES = 12,
};

enum btrfs_ilock_type {
	__BTRFS_ILOCK_SHARED_BIT = 0,
	BTRFS_ILOCK_SHARED = 1,
	__BTRFS_ILOCK_SHARED_SEQ = 0,
	__BTRFS_ILOCK_TRY_BIT = 1,
	BTRFS_ILOCK_TRY = 2,
	__BTRFS_ILOCK_TRY_SEQ = 1,
	__BTRFS_ILOCK_MMAP_BIT = 2,
	BTRFS_ILOCK_MMAP = 4,
	__BTRFS_ILOCK_MMAP_SEQ = 2,
};

enum btrfs_inline_ref_type {
	BTRFS_REF_TYPE_INVALID = 0,
	BTRFS_REF_TYPE_BLOCK = 1,
	BTRFS_REF_TYPE_DATA = 2,
	BTRFS_REF_TYPE_ANY = 3,
};

enum btrfs_lock_nesting {
	BTRFS_NESTING_NORMAL = 0,
	BTRFS_NESTING_COW = 1,
	BTRFS_NESTING_LEFT = 2,
	BTRFS_NESTING_RIGHT = 3,
	BTRFS_NESTING_LEFT_COW = 4,
	BTRFS_NESTING_RIGHT_COW = 5,
	BTRFS_NESTING_SPLIT = 6,
	BTRFS_NESTING_NEW_ROOT = 7,
	BTRFS_NESTING_MAX = 8,
};

enum btrfs_loop_type {
	LOOP_CACHING_NOWAIT = 0,
	LOOP_CACHING_WAIT = 1,
	LOOP_UNSET_SIZE_CLASS = 2,
	LOOP_ALLOC_CHUNK = 3,
	LOOP_WRONG_SIZE_CLASS = 4,
	LOOP_NO_EMPTY_SIZE = 5,
};

enum btrfs_map_op {
	BTRFS_MAP_READ = 0,
	BTRFS_MAP_WRITE = 1,
	BTRFS_MAP_GET_READ_MIRRORS = 2,
};

enum btrfs_mod_log_op {
	BTRFS_MOD_LOG_KEY_REPLACE = 0,
	BTRFS_MOD_LOG_KEY_ADD = 1,
	BTRFS_MOD_LOG_KEY_REMOVE = 2,
	BTRFS_MOD_LOG_KEY_REMOVE_WHILE_FREEING = 3,
	BTRFS_MOD_LOG_KEY_REMOVE_WHILE_MOVING = 4,
	BTRFS_MOD_LOG_MOVE_KEYS = 5,
	BTRFS_MOD_LOG_ROOT_REPLACE = 6,
};

enum btrfs_qgroup_mode {
	BTRFS_QGROUP_MODE_DISABLED = 0,
	BTRFS_QGROUP_MODE_FULL = 1,
	BTRFS_QGROUP_MODE_SIMPLE = 2,
};

enum btrfs_qgroup_rsv_type {
	BTRFS_QGROUP_RSV_DATA = 0,
	BTRFS_QGROUP_RSV_META_PERTRANS = 1,
	BTRFS_QGROUP_RSV_META_PREALLOC = 2,
	BTRFS_QGROUP_RSV_LAST = 3,
};

enum btrfs_raid_types {
	BTRFS_RAID_SINGLE = 0,
	BTRFS_RAID_RAID0 = 1,
	BTRFS_RAID_RAID1 = 2,
	BTRFS_RAID_DUP = 3,
	BTRFS_RAID_RAID10 = 4,
	BTRFS_RAID_RAID5 = 5,
	BTRFS_RAID_RAID6 = 6,
	BTRFS_RAID_RAID1C3 = 7,
	BTRFS_RAID_RAID1C4 = 8,
	BTRFS_NR_RAID_TYPES = 9,
};

enum btrfs_rbio_ops {
	BTRFS_RBIO_WRITE = 0,
	BTRFS_RBIO_READ_REBUILD = 1,
	BTRFS_RBIO_PARITY_SCRUB = 2,
};

enum btrfs_read_policy {
	BTRFS_READ_POLICY_PID = 0,
	BTRFS_NR_READ_POLICY = 1,
};

enum btrfs_ref_type {
	BTRFS_REF_NOT_SET = 0,
	BTRFS_REF_DATA = 1,
	BTRFS_REF_METADATA = 2,
	BTRFS_REF_LAST = 3,
} __attribute__((mode(byte)));

enum btrfs_reserve_flush_enum {
	BTRFS_RESERVE_NO_FLUSH = 0,
	BTRFS_RESERVE_FLUSH_LIMIT = 1,
	BTRFS_RESERVE_FLUSH_EVICT = 2,
	BTRFS_RESERVE_FLUSH_DATA = 3,
	BTRFS_RESERVE_FLUSH_FREE_SPACE_INODE = 4,
	BTRFS_RESERVE_FLUSH_ALL = 5,
	BTRFS_RESERVE_FLUSH_ALL_STEAL = 6,
	BTRFS_RESERVE_FLUSH_EMERGENCY = 7,
};

enum btrfs_rsv_type {
	BTRFS_BLOCK_RSV_GLOBAL = 0,
	BTRFS_BLOCK_RSV_DELALLOC = 1,
	BTRFS_BLOCK_RSV_TRANS = 2,
	BTRFS_BLOCK_RSV_CHUNK = 3,
	BTRFS_BLOCK_RSV_DELOPS = 4,
	BTRFS_BLOCK_RSV_DELREFS = 5,
	BTRFS_BLOCK_RSV_EMPTY = 6,
	BTRFS_BLOCK_RSV_TEMP = 7,
};

enum btrfs_send_cmd {
	BTRFS_SEND_C_UNSPEC = 0,
	BTRFS_SEND_C_SUBVOL = 1,
	BTRFS_SEND_C_SNAPSHOT = 2,
	BTRFS_SEND_C_MKFILE = 3,
	BTRFS_SEND_C_MKDIR = 4,
	BTRFS_SEND_C_MKNOD = 5,
	BTRFS_SEND_C_MKFIFO = 6,
	BTRFS_SEND_C_MKSOCK = 7,
	BTRFS_SEND_C_SYMLINK = 8,
	BTRFS_SEND_C_RENAME = 9,
	BTRFS_SEND_C_LINK = 10,
	BTRFS_SEND_C_UNLINK = 11,
	BTRFS_SEND_C_RMDIR = 12,
	BTRFS_SEND_C_SET_XATTR = 13,
	BTRFS_SEND_C_REMOVE_XATTR = 14,
	BTRFS_SEND_C_WRITE = 15,
	BTRFS_SEND_C_CLONE = 16,
	BTRFS_SEND_C_TRUNCATE = 17,
	BTRFS_SEND_C_CHMOD = 18,
	BTRFS_SEND_C_CHOWN = 19,
	BTRFS_SEND_C_UTIMES = 20,
	BTRFS_SEND_C_END = 21,
	BTRFS_SEND_C_UPDATE_EXTENT = 22,
	BTRFS_SEND_C_MAX_V1 = 22,
	BTRFS_SEND_C_FALLOCATE = 23,
	BTRFS_SEND_C_FILEATTR = 24,
	BTRFS_SEND_C_ENCODED_WRITE = 25,
	BTRFS_SEND_C_MAX_V2 = 25,
	BTRFS_SEND_C_ENABLE_VERITY = 26,
	BTRFS_SEND_C_MAX_V3 = 26,
	BTRFS_SEND_C_MAX = 26,
};

enum btrfs_subpage_type {
	BTRFS_SUBPAGE_METADATA = 0,
	BTRFS_SUBPAGE_DATA = 1,
};

enum btrfs_trans_state {
	TRANS_STATE_RUNNING = 0,
	TRANS_STATE_COMMIT_PREP = 1,
	TRANS_STATE_COMMIT_START = 2,
	TRANS_STATE_COMMIT_DOING = 3,
	TRANS_STATE_UNBLOCKED = 4,
	TRANS_STATE_SUPER_COMMITTED = 5,
	TRANS_STATE_COMPLETED = 6,
	TRANS_STATE_MAX = 7,
};

enum btrfs_tree_block_status {
	BTRFS_TREE_BLOCK_CLEAN = 0,
	BTRFS_TREE_BLOCK_INVALID_NRITEMS = 1,
	BTRFS_TREE_BLOCK_INVALID_PARENT_KEY = 2,
	BTRFS_TREE_BLOCK_BAD_KEY_ORDER = 3,
	BTRFS_TREE_BLOCK_INVALID_LEVEL = 4,
	BTRFS_TREE_BLOCK_INVALID_FREE_SPACE = 5,
	BTRFS_TREE_BLOCK_INVALID_OFFSETS = 6,
	BTRFS_TREE_BLOCK_INVALID_BLOCKPTR = 7,
	BTRFS_TREE_BLOCK_INVALID_ITEM = 8,
	BTRFS_TREE_BLOCK_INVALID_OWNER = 9,
	BTRFS_TREE_BLOCK_WRITTEN_NOT_SET = 10,
};

enum btrfs_trim_state {
	BTRFS_TRIM_STATE_UNTRIMMED = 0,
	BTRFS_TRIM_STATE_TRIMMED = 1,
	BTRFS_TRIM_STATE_TRIMMING = 2,
};

enum buddy {
	FIRST = 0,
	LAST = 1,
};

enum bug_trap_type {
	BUG_TRAP_TYPE_NONE = 0,
	BUG_TRAP_TYPE_WARN = 1,
	BUG_TRAP_TYPE_BUG = 2,
};

enum bus_notifier_event {
	BUS_NOTIFY_ADD_DEVICE = 0,
	BUS_NOTIFY_DEL_DEVICE = 1,
	BUS_NOTIFY_REMOVED_DEVICE = 2,
	BUS_NOTIFY_BIND_DRIVER = 3,
	BUS_NOTIFY_BOUND_DRIVER = 4,
	BUS_NOTIFY_UNBIND_DRIVER = 5,
	BUS_NOTIFY_UNBOUND_DRIVER = 6,
	BUS_NOTIFY_DRIVER_NOT_BOUND = 7,
};

enum cache_type {
	CACHE_TYPE_NOCACHE = 0,
	CACHE_TYPE_INST = 1,
	CACHE_TYPE_DATA = 2,
	CACHE_TYPE_SEPARATE = 3,
	CACHE_TYPE_UNIFIED = 4,
};

enum cc_attr {
	CC_ATTR_MEM_ENCRYPT = 0,
	CC_ATTR_HOST_MEM_ENCRYPT = 1,
	CC_ATTR_GUEST_MEM_ENCRYPT = 2,
	CC_ATTR_GUEST_STATE_ENCRYPT = 3,
	CC_ATTR_GUEST_UNROLL_STRING_IO = 4,
	CC_ATTR_GUEST_SEV_SNP = 5,
	CC_ATTR_GUEST_SNP_SECURE_TSC = 6,
	CC_ATTR_HOST_SEV_SNP = 7,
};

enum cdrom_print_option {
	CTL_NAME = 0,
	CTL_SPEED = 1,
	CTL_SLOTS = 2,
	CTL_CAPABILITY = 3,
};

enum cea_audio_coding_types {
	AUDIO_CODING_TYPE_REF_STREAM_HEADER = 0,
	AUDIO_CODING_TYPE_LPCM = 1,
	AUDIO_CODING_TYPE_AC3 = 2,
	AUDIO_CODING_TYPE_MPEG1 = 3,
	AUDIO_CODING_TYPE_MP3 = 4,
	AUDIO_CODING_TYPE_MPEG2 = 5,
	AUDIO_CODING_TYPE_AACLC = 6,
	AUDIO_CODING_TYPE_DTS = 7,
	AUDIO_CODING_TYPE_ATRAC = 8,
	AUDIO_CODING_TYPE_SACD = 9,
	AUDIO_CODING_TYPE_EAC3 = 10,
	AUDIO_CODING_TYPE_DTS_HD = 11,
	AUDIO_CODING_TYPE_MLP = 12,
	AUDIO_CODING_TYPE_DST = 13,
	AUDIO_CODING_TYPE_WMAPRO = 14,
	AUDIO_CODING_TYPE_REF_CXT = 15,
	AUDIO_CODING_TYPE_HE_AAC = 15,
	AUDIO_CODING_TYPE_HE_AAC2 = 16,
	AUDIO_CODING_TYPE_MPEG_SURROUND = 17,
};

enum cea_audio_coding_xtypes {
	AUDIO_CODING_XTYPE_HE_REF_CT = 0,
	AUDIO_CODING_XTYPE_HE_AAC = 1,
	AUDIO_CODING_XTYPE_HE_AAC2 = 2,
	AUDIO_CODING_XTYPE_MPEG_SURROUND = 3,
	AUDIO_CODING_XTYPE_FIRST_RESERVED = 4,
};

enum cea_speaker_placement {
	FL = 1,
	FC = 2,
	FR = 4,
	FLC = 8,
	FRC = 16,
	RL = 32,
	RC = 64,
	RR = 128,
	RLC = 256,
	RRC = 512,
	LFE = 1024,
	FLW = 2048,
	FRW = 4096,
	FLH = 8192,
	FCH = 16384,
	FRH = 32768,
	TC = 65536,
};

enum cfg80211_signal_type {
	CFG80211_SIGNAL_TYPE_NONE = 0,
	CFG80211_SIGNAL_TYPE_MBM = 1,
	CFG80211_SIGNAL_TYPE_UNSPEC = 2,
};

enum cgroup1_param {
	Opt_all = 0,
	Opt_clone_children = 1,
	Opt_cpuset_v2_mode = 2,
	Opt_name = 3,
	Opt_none = 4,
	Opt_noprefix = 5,
	Opt_release_agent = 6,
	Opt_xattr = 7,
	Opt_favordynmods = 8,
	Opt_nofavordynmods = 9,
};

enum cgroup2_param {
	Opt_nsdelegate = 0,
	Opt_favordynmods___2 = 1,
	Opt_memory_localevents = 2,
	Opt_memory_recursiveprot = 3,
	Opt_memory_hugetlb_accounting = 4,
	Opt_pids_localevents = 5,
	nr__cgroup2_params = 6,
};

enum cgroup_bpf_attach_type {
	CGROUP_BPF_ATTACH_TYPE_INVALID = -1,
	CGROUP_INET_INGRESS = 0,
	CGROUP_INET_EGRESS = 1,
	CGROUP_INET_SOCK_CREATE = 2,
	CGROUP_SOCK_OPS = 3,
	CGROUP_DEVICE = 4,
	CGROUP_INET4_BIND = 5,
	CGROUP_INET6_BIND = 6,
	CGROUP_INET4_CONNECT = 7,
	CGROUP_INET6_CONNECT = 8,
	CGROUP_UNIX_CONNECT = 9,
	CGROUP_INET4_POST_BIND = 10,
	CGROUP_INET6_POST_BIND = 11,
	CGROUP_UDP4_SENDMSG = 12,
	CGROUP_UDP6_SENDMSG = 13,
	CGROUP_UNIX_SENDMSG = 14,
	CGROUP_SYSCTL = 15,
	CGROUP_UDP4_RECVMSG = 16,
	CGROUP_UDP6_RECVMSG = 17,
	CGROUP_UNIX_RECVMSG = 18,
	CGROUP_GETSOCKOPT = 19,
	CGROUP_SETSOCKOPT = 20,
	CGROUP_INET4_GETPEERNAME = 21,
	CGROUP_INET6_GETPEERNAME = 22,
	CGROUP_UNIX_GETPEERNAME = 23,
	CGROUP_INET4_GETSOCKNAME = 24,
	CGROUP_INET6_GETSOCKNAME = 25,
	CGROUP_UNIX_GETSOCKNAME = 26,
	CGROUP_INET_SOCK_RELEASE = 27,
	CGROUP_LSM_START = 28,
	CGROUP_LSM_END = 27,
	MAX_CGROUP_BPF_ATTACH_TYPE = 28,
};

enum cgroup_filetype {
	CGROUP_FILE_PROCS = 0,
	CGROUP_FILE_TASKS = 1,
};

enum cgroup_opt_features {
	OPT_FEATURE_PRESSURE = 0,
	OPT_FEATURE_COUNT = 1,
};

enum cgroup_subsys_id {
	cpuset_cgrp_id = 0,
	cpu_cgrp_id = 1,
	cpuacct_cgrp_id = 2,
	io_cgrp_id = 3,
	memory_cgrp_id = 4,
	devices_cgrp_id = 5,
	freezer_cgrp_id = 6,
	net_cls_cgrp_id = 7,
	perf_event_cgrp_id = 8,
	net_prio_cgrp_id = 9,
	hugetlb_cgrp_id = 10,
	pids_cgrp_id = 11,
	rdma_cgrp_id = 12,
	misc_cgrp_id = 13,
	CGROUP_SUBSYS_COUNT = 14,
};

enum chacha_constants {
	CHACHA_CONSTANT_EXPA = 1634760805,
	CHACHA_CONSTANT_ND_3 = 857760878,
	CHACHA_CONSTANT_2_BY = 2036477234,
	CHACHA_CONSTANT_TE_K = 1797285236,
};

enum chip_flavors {
	chip_6320 = 0,
	chip_6440 = 1,
	chip_6485 = 2,
	chip_9480 = 3,
	chip_9180 = 4,
	chip_9445 = 5,
	chip_9485 = 6,
	chip_1300 = 7,
	chip_1320 = 8,
};

enum chip_register_bits {
	PHY_MIN_SPP_PHYS_LINK_RATE_MASK = 3840,
	PHY_MAX_SPP_PHYS_LINK_RATE_MASK = 61440,
	PHY_NEG_SPP_PHYS_LINK_RATE_MASK_OFFSET = 16,
	PHY_NEG_SPP_PHYS_LINK_RATE_MASK = 983040,
};

enum chip_register_bits___2 {
	PHY_MIN_SPP_PHYS_LINK_RATE_MASK___2 = 1792,
	PHY_MAX_SPP_PHYS_LINK_RATE_MASK___2 = 28672,
	PHY_NEG_SPP_PHYS_LINK_RATE_MASK_OFFSET___2 = 16,
	PHY_NEG_SPP_PHYS_LINK_RATE_MASK___2 = 196608,
};

enum class_map_type {
	DD_CLASS_TYPE_DISJOINT_BITS = 0,
	DD_CLASS_TYPE_LEVEL_NUM = 1,
	DD_CLASS_TYPE_DISJOINT_NAMES = 2,
	DD_CLASS_TYPE_LEVEL_NAMES = 3,
};

enum class_stat_type {
	ZS_OBJS_ALLOCATED = 12,
	ZS_OBJS_INUSE = 13,
	NR_CLASS_STAT_TYPES = 14,
};

enum cld_command {
	Cld_Create = 0,
	Cld_Remove = 1,
	Cld_Check = 2,
	Cld_GraceDone = 3,
	Cld_GraceStart = 4,
	Cld_GetVersion = 5,
};

enum cleanup_prefix_rt_t {
	CLEANUP_PREFIX_RT_NOP = 0,
	CLEANUP_PREFIX_RT_DEL = 1,
	CLEANUP_PREFIX_RT_EXPIRE = 2,
};

enum clear_refs_types {
	CLEAR_REFS_ALL = 1,
	CLEAR_REFS_ANON = 2,
	CLEAR_REFS_MAPPED = 3,
	CLEAR_REFS_SOFT_DIRTY = 4,
	CLEAR_REFS_MM_HIWATER_RSS = 5,
	CLEAR_REFS_LAST = 6,
};

enum clock_event_state {
	CLOCK_EVT_STATE_DETACHED = 0,
	CLOCK_EVT_STATE_SHUTDOWN = 1,
	CLOCK_EVT_STATE_PERIODIC = 2,
	CLOCK_EVT_STATE_ONESHOT = 3,
	CLOCK_EVT_STATE_ONESHOT_STOPPED = 4,
};

enum clocksource_ids {
	CSID_GENERIC = 0,
	CSID_ARM_ARCH_COUNTER = 1,
	CSID_S390_TOD = 2,
	CSID_X86_TSC_EARLY = 3,
	CSID_X86_TSC = 4,
	CSID_X86_KVM_CLK = 5,
	CSID_X86_ART = 6,
	CSID_MAX = 7,
};

enum closure_state {
	CLOSURE_BITS_START = 67108864,
	CLOSURE_DESTRUCTOR = 67108864,
	CLOSURE_WAITING = 268435456,
	CLOSURE_RUNNING = 1073741824,
};

enum cmis_cdb_fw_write_mechanism {
	CMIS_CDB_FW_WRITE_MECHANISM_NONE = 0,
	CMIS_CDB_FW_WRITE_MECHANISM_LPL = 1,
	CMIS_CDB_FW_WRITE_MECHANISM_EPL = 16,
	CMIS_CDB_FW_WRITE_MECHANISM_BOTH = 17,
};

enum compact_priority {
	COMPACT_PRIO_SYNC_FULL = 0,
	MIN_COMPACT_PRIORITY = 0,
	COMPACT_PRIO_SYNC_LIGHT = 1,
	MIN_COMPACT_COSTLY_PRIORITY = 1,
	DEF_COMPACT_PRIORITY = 1,
	COMPACT_PRIO_ASYNC = 2,
	INIT_COMPACT_PRIORITY = 2,
};

enum compact_result {
	COMPACT_NOT_SUITABLE_ZONE = 0,
	COMPACT_SKIPPED = 1,
	COMPACT_DEFERRED = 2,
	COMPACT_NO_SUITABLE_PAGE = 3,
	COMPACT_CONTINUE = 4,
	COMPACT_COMPLETE = 5,
	COMPACT_PARTIAL_SKIPPED = 6,
	COMPACT_CONTENDED = 7,
	COMPACT_SUCCESS = 8,
};

enum con_flush_mode {
	CONSOLE_FLUSH_PENDING = 0,
	CONSOLE_REPLAY_ALL = 1,
};

enum con_msg_format_flags {
	MSG_FORMAT_DEFAULT = 0,
	MSG_FORMAT_SYSLOG = 1,
};

enum con_scroll {
	SM_UP = 0,
	SM_DOWN = 1,
};

enum cons_flags {
	CON_PRINTBUFFER = 1,
	CON_CONSDEV = 2,
	CON_ENABLED = 4,
	CON_BOOT = 8,
	CON_ANYTIME = 16,
	CON_BRL = 32,
	CON_EXTENDED = 64,
	CON_SUSPENDED = 128,
	CON_NBCON = 256,
};

enum cpio_fields {
	C_MAGIC = 0,
	C_INO = 1,
	C_MODE = 2,
	C_UID = 3,
	C_GID = 4,
	C_NLINK = 5,
	C_MTIME = 6,
	C_FILESIZE = 7,
	C_MAJ = 8,
	C_MIN = 9,
	C_RMAJ = 10,
	C_RMIN = 11,
	C_NAMESIZE = 12,
	C_CHKSUM = 13,
	C_NFIELDS = 14,
};

enum cpu_idle_type {
	__CPU_NOT_IDLE = 0,
	CPU_IDLE = 1,
	CPU_NEWLY_IDLE = 2,
	CPU_MAX_IDLE_TYPES = 3,
};

enum cpu_mitigations {
	CPU_MITIGATIONS_OFF = 0,
	CPU_MITIGATIONS_AUTO = 1,
	CPU_MITIGATIONS_AUTO_NOSMT = 2,
};

enum cpu_pm_event {
	CPU_PM_ENTER = 0,
	CPU_PM_ENTER_FAILED = 1,
	CPU_PM_EXIT = 2,
	CPU_CLUSTER_PM_ENTER = 3,
	CPU_CLUSTER_PM_ENTER_FAILED = 4,
	CPU_CLUSTER_PM_EXIT = 5,
};

enum cpu_type_enum {
	CPU_UNKNOWN = 0,
	CPU_LOONGSON32 = 1,
	CPU_LOONGSON64 = 2,
	CPU_LAST = 3,
};

enum cpu_usage_stat {
	CPUTIME_USER = 0,
	CPUTIME_NICE = 1,
	CPUTIME_SYSTEM = 2,
	CPUTIME_SOFTIRQ = 3,
	CPUTIME_IRQ = 4,
	CPUTIME_IDLE = 5,
	CPUTIME_IOWAIT = 6,
	CPUTIME_STEAL = 7,
	CPUTIME_GUEST = 8,
	CPUTIME_GUEST_NICE = 9,
	CPUTIME_FORCEIDLE = 10,
	NR_STATS = 11,
};

enum cpuacct_stat_index {
	CPUACCT_STAT_USER = 0,
	CPUACCT_STAT_SYSTEM = 1,
	CPUACCT_STAT_NSTATS = 2,
};

enum cpufreq_table_sorting {
	CPUFREQ_TABLE_UNSORTED = 0,
	CPUFREQ_TABLE_SORTED_ASCENDING = 1,
	CPUFREQ_TABLE_SORTED_DESCENDING = 2,
};

enum cpuhp_smt_control {
	CPU_SMT_ENABLED = 0,
	CPU_SMT_DISABLED = 1,
	CPU_SMT_FORCE_DISABLED = 2,
	CPU_SMT_NOT_SUPPORTED = 3,
	CPU_SMT_NOT_IMPLEMENTED = 4,
};

enum cpuhp_state {
	CPUHP_INVALID = -1,
	CPUHP_OFFLINE = 0,
	CPUHP_CREATE_THREADS = 1,
	CPUHP_PERF_PREPARE = 2,
	CPUHP_PERF_X86_PREPARE = 3,
	CPUHP_PERF_X86_AMD_UNCORE_PREP = 4,
	CPUHP_PERF_POWER = 5,
	CPUHP_PERF_SUPERH = 6,
	CPUHP_X86_HPET_DEAD = 7,
	CPUHP_X86_MCE_DEAD = 8,
	CPUHP_VIRT_NET_DEAD = 9,
	CPUHP_IBMVNIC_DEAD = 10,
	CPUHP_SLUB_DEAD = 11,
	CPUHP_DEBUG_OBJ_DEAD = 12,
	CPUHP_MM_WRITEBACK_DEAD = 13,
	CPUHP_MM_VMSTAT_DEAD = 14,
	CPUHP_SOFTIRQ_DEAD = 15,
	CPUHP_NET_MVNETA_DEAD = 16,
	CPUHP_CPUIDLE_DEAD = 17,
	CPUHP_ARM64_FPSIMD_DEAD = 18,
	CPUHP_ARM_OMAP_WAKE_DEAD = 19,
	CPUHP_IRQ_POLL_DEAD = 20,
	CPUHP_BLOCK_SOFTIRQ_DEAD = 21,
	CPUHP_BIO_DEAD = 22,
	CPUHP_ACPI_CPUDRV_DEAD = 23,
	CPUHP_S390_PFAULT_DEAD = 24,
	CPUHP_BLK_MQ_DEAD = 25,
	CPUHP_FS_BUFF_DEAD = 26,
	CPUHP_PRINTK_DEAD = 27,
	CPUHP_MM_MEMCQ_DEAD = 28,
	CPUHP_PERCPU_CNT_DEAD = 29,
	CPUHP_RADIX_DEAD = 30,
	CPUHP_PAGE_ALLOC = 31,
	CPUHP_NET_DEV_DEAD = 32,
	CPUHP_PCI_XGENE_DEAD = 33,
	CPUHP_IOMMU_IOVA_DEAD = 34,
	CPUHP_AP_ARM_CACHE_B15_RAC_DEAD = 35,
	CPUHP_PADATA_DEAD = 36,
	CPUHP_AP_DTPM_CPU_DEAD = 37,
	CPUHP_RANDOM_PREPARE = 38,
	CPUHP_WORKQUEUE_PREP = 39,
	CPUHP_POWER_NUMA_PREPARE = 40,
	CPUHP_HRTIMERS_PREPARE = 41,
	CPUHP_X2APIC_PREPARE = 42,
	CPUHP_SMPCFD_PREPARE = 43,
	CPUHP_RELAY_PREPARE = 44,
	CPUHP_MD_RAID5_PREPARE = 45,
	CPUHP_RCUTREE_PREP = 46,
	CPUHP_CPUIDLE_COUPLED_PREPARE = 47,
	CPUHP_POWERPC_PMAC_PREPARE = 48,
	CPUHP_POWERPC_MMU_CTX_PREPARE = 49,
	CPUHP_XEN_PREPARE = 50,
	CPUHP_XEN_EVTCHN_PREPARE = 51,
	CPUHP_ARM_SHMOBILE_SCU_PREPARE = 52,
	CPUHP_SH_SH3X_PREPARE = 53,
	CPUHP_TOPOLOGY_PREPARE = 54,
	CPUHP_NET_IUCV_PREPARE = 55,
	CPUHP_ARM_BL_PREPARE = 56,
	CPUHP_TRACE_RB_PREPARE = 57,
	CPUHP_MM_ZS_PREPARE = 58,
	CPUHP_MM_ZSWP_POOL_PREPARE = 59,
	CPUHP_KVM_PPC_BOOK3S_PREPARE = 60,
	CPUHP_ZCOMP_PREPARE = 61,
	CPUHP_TIMERS_PREPARE = 62,
	CPUHP_TMIGR_PREPARE = 63,
	CPUHP_MIPS_SOC_PREPARE = 64,
	CPUHP_BP_PREPARE_DYN = 65,
	CPUHP_BP_PREPARE_DYN_END = 85,
	CPUHP_BP_KICK_AP = 86,
	CPUHP_BRINGUP_CPU = 87,
	CPUHP_AP_IDLE_DEAD = 88,
	CPUHP_AP_OFFLINE = 89,
	CPUHP_AP_CACHECTRL_STARTING = 90,
	CPUHP_AP_SCHED_STARTING = 91,
	CPUHP_AP_RCUTREE_DYING = 92,
	CPUHP_AP_CPU_PM_STARTING = 93,
	CPUHP_AP_IRQ_GIC_STARTING = 94,
	CPUHP_AP_IRQ_HIP04_STARTING = 95,
	CPUHP_AP_IRQ_APPLE_AIC_STARTING = 96,
	CPUHP_AP_IRQ_ARMADA_XP_STARTING = 97,
	CPUHP_AP_IRQ_BCM2836_STARTING = 98,
	CPUHP_AP_IRQ_MIPS_GIC_STARTING = 99,
	CPUHP_AP_IRQ_EIOINTC_STARTING = 100,
	CPUHP_AP_IRQ_AVECINTC_STARTING = 101,
	CPUHP_AP_IRQ_SIFIVE_PLIC_STARTING = 102,
	CPUHP_AP_IRQ_THEAD_ACLINT_SSWI_STARTING = 103,
	CPUHP_AP_IRQ_RISCV_IMSIC_STARTING = 104,
	CPUHP_AP_IRQ_RISCV_SBI_IPI_STARTING = 105,
	CPUHP_AP_ARM_MVEBU_COHERENCY = 106,
	CPUHP_AP_PERF_X86_AMD_UNCORE_STARTING = 107,
	CPUHP_AP_PERF_X86_STARTING = 108,
	CPUHP_AP_PERF_X86_AMD_IBS_STARTING = 109,
	CPUHP_AP_PERF_XTENSA_STARTING = 110,
	CPUHP_AP_ARM_VFP_STARTING = 111,
	CPUHP_AP_ARM64_DEBUG_MONITORS_STARTING = 112,
	CPUHP_AP_PERF_ARM_HW_BREAKPOINT_STARTING = 113,
	CPUHP_AP_PERF_ARM_ACPI_STARTING = 114,
	CPUHP_AP_PERF_ARM_STARTING = 115,
	CPUHP_AP_PERF_RISCV_STARTING = 116,
	CPUHP_AP_ARM_L2X0_STARTING = 117,
	CPUHP_AP_EXYNOS4_MCT_TIMER_STARTING = 118,
	CPUHP_AP_ARM_ARCH_TIMER_STARTING = 119,
	CPUHP_AP_ARM_ARCH_TIMER_EVTSTRM_STARTING = 120,
	CPUHP_AP_ARM_GLOBAL_TIMER_STARTING = 121,
	CPUHP_AP_JCORE_TIMER_STARTING = 122,
	CPUHP_AP_ARM_TWD_STARTING = 123,
	CPUHP_AP_QCOM_TIMER_STARTING = 124,
	CPUHP_AP_TEGRA_TIMER_STARTING = 125,
	CPUHP_AP_ARMADA_TIMER_STARTING = 126,
	CPUHP_AP_MIPS_GIC_TIMER_STARTING = 127,
	CPUHP_AP_ARC_TIMER_STARTING = 128,
	CPUHP_AP_REALTEK_TIMER_STARTING = 129,
	CPUHP_AP_RISCV_TIMER_STARTING = 130,
	CPUHP_AP_CLINT_TIMER_STARTING = 131,
	CPUHP_AP_CSKY_TIMER_STARTING = 132,
	CPUHP_AP_TI_GP_TIMER_STARTING = 133,
	CPUHP_AP_HYPERV_TIMER_STARTING = 134,
	CPUHP_AP_DUMMY_TIMER_STARTING = 135,
	CPUHP_AP_ARM_XEN_STARTING = 136,
	CPUHP_AP_ARM_XEN_RUNSTATE_STARTING = 137,
	CPUHP_AP_ARM_CORESIGHT_STARTING = 138,
	CPUHP_AP_ARM_CORESIGHT_CTI_STARTING = 139,
	CPUHP_AP_ARM64_ISNDEP_STARTING = 140,
	CPUHP_AP_SMPCFD_DYING = 141,
	CPUHP_AP_HRTIMERS_DYING = 142,
	CPUHP_AP_TICK_DYING = 143,
	CPUHP_AP_X86_TBOOT_DYING = 144,
	CPUHP_AP_ARM_CACHE_B15_RAC_DYING = 145,
	CPUHP_AP_ONLINE = 146,
	CPUHP_TEARDOWN_CPU = 147,
	CPUHP_AP_ONLINE_IDLE = 148,
	CPUHP_AP_HYPERV_ONLINE = 149,
	CPUHP_AP_KVM_ONLINE = 150,
	CPUHP_AP_SCHED_WAIT_EMPTY = 151,
	CPUHP_AP_SMPBOOT_THREADS = 152,
	CPUHP_AP_IRQ_AFFINITY_ONLINE = 153,
	CPUHP_AP_BLK_MQ_ONLINE = 154,
	CPUHP_AP_ARM_MVEBU_SYNC_CLOCKS = 155,
	CPUHP_AP_X86_INTEL_EPB_ONLINE = 156,
	CPUHP_AP_PERF_ONLINE = 157,
	CPUHP_AP_PERF_X86_ONLINE = 158,
	CPUHP_AP_PERF_X86_UNCORE_ONLINE = 159,
	CPUHP_AP_PERF_X86_AMD_UNCORE_ONLINE = 160,
	CPUHP_AP_PERF_X86_AMD_POWER_ONLINE = 161,
	CPUHP_AP_PERF_S390_CF_ONLINE = 162,
	CPUHP_AP_PERF_S390_SF_ONLINE = 163,
	CPUHP_AP_PERF_ARM_CCI_ONLINE = 164,
	CPUHP_AP_PERF_ARM_CCN_ONLINE = 165,
	CPUHP_AP_PERF_ARM_HISI_CPA_ONLINE = 166,
	CPUHP_AP_PERF_ARM_HISI_DDRC_ONLINE = 167,
	CPUHP_AP_PERF_ARM_HISI_HHA_ONLINE = 168,
	CPUHP_AP_PERF_ARM_HISI_L3_ONLINE = 169,
	CPUHP_AP_PERF_ARM_HISI_PA_ONLINE = 170,
	CPUHP_AP_PERF_ARM_HISI_SLLC_ONLINE = 171,
	CPUHP_AP_PERF_ARM_HISI_PCIE_PMU_ONLINE = 172,
	CPUHP_AP_PERF_ARM_HNS3_PMU_ONLINE = 173,
	CPUHP_AP_PERF_ARM_L2X0_ONLINE = 174,
	CPUHP_AP_PERF_ARM_QCOM_L2_ONLINE = 175,
	CPUHP_AP_PERF_ARM_QCOM_L3_ONLINE = 176,
	CPUHP_AP_PERF_ARM_APM_XGENE_ONLINE = 177,
	CPUHP_AP_PERF_ARM_CAVIUM_TX2_UNCORE_ONLINE = 178,
	CPUHP_AP_PERF_ARM_MARVELL_CN10K_DDR_ONLINE = 179,
	CPUHP_AP_PERF_ARM_MRVL_PEM_ONLINE = 180,
	CPUHP_AP_PERF_POWERPC_NEST_IMC_ONLINE = 181,
	CPUHP_AP_PERF_POWERPC_CORE_IMC_ONLINE = 182,
	CPUHP_AP_PERF_POWERPC_THREAD_IMC_ONLINE = 183,
	CPUHP_AP_PERF_POWERPC_TRACE_IMC_ONLINE = 184,
	CPUHP_AP_PERF_POWERPC_HV_24x7_ONLINE = 185,
	CPUHP_AP_PERF_POWERPC_HV_GPCI_ONLINE = 186,
	CPUHP_AP_PERF_CSKY_ONLINE = 187,
	CPUHP_AP_TMIGR_ONLINE = 188,
	CPUHP_AP_WATCHDOG_ONLINE = 189,
	CPUHP_AP_WORKQUEUE_ONLINE = 190,
	CPUHP_AP_RANDOM_ONLINE = 191,
	CPUHP_AP_RCUTREE_ONLINE = 192,
	CPUHP_AP_KTHREADS_ONLINE = 193,
	CPUHP_AP_BASE_CACHEINFO_ONLINE = 194,
	CPUHP_AP_ONLINE_DYN = 195,
	CPUHP_AP_ONLINE_DYN_END = 235,
	CPUHP_AP_X86_HPET_ONLINE = 236,
	CPUHP_AP_X86_KVM_CLK_ONLINE = 237,
	CPUHP_AP_ACTIVE = 238,
	CPUHP_ONLINE = 239,
};

enum cpuhp_sync_state {
	SYNC_STATE_DEAD = 0,
	SYNC_STATE_KICKED = 1,
	SYNC_STATE_SHOULD_DIE = 2,
	SYNC_STATE_ALIVE = 3,
	SYNC_STATE_SHOULD_ONLINE = 4,
	SYNC_STATE_ONLINE = 5,
};

enum createmode4 {
	NFS4_CREATE_UNCHECKED = 0,
	NFS4_CREATE_GUARDED = 1,
	NFS4_CREATE_EXCLUSIVE = 2,
	NFS4_CREATE_EXCLUSIVE4_1 = 3,
};

enum criteria {
	CR_POWER2_ALIGNED = 0,
	CR_GOAL_LEN_FAST = 1,
	CR_BEST_AVAIL_LEN = 2,
	CR_GOAL_LEN_SLOW = 3,
	CR_ANY_FREE = 4,
	EXT4_MB_NUM_CRS = 5,
};

enum crypto_attr_type_t {
	CRYPTOCFGA_UNSPEC = 0,
	CRYPTOCFGA_PRIORITY_VAL = 1,
	CRYPTOCFGA_REPORT_LARVAL = 2,
	CRYPTOCFGA_REPORT_HASH = 3,
	CRYPTOCFGA_REPORT_BLKCIPHER = 4,
	CRYPTOCFGA_REPORT_AEAD = 5,
	CRYPTOCFGA_REPORT_COMPRESS = 6,
	CRYPTOCFGA_REPORT_RNG = 7,
	CRYPTOCFGA_REPORT_CIPHER = 8,
	CRYPTOCFGA_REPORT_AKCIPHER = 9,
	CRYPTOCFGA_REPORT_KPP = 10,
	CRYPTOCFGA_REPORT_ACOMP = 11,
	CRYPTOCFGA_STAT_LARVAL = 12,
	CRYPTOCFGA_STAT_HASH = 13,
	CRYPTOCFGA_STAT_BLKCIPHER = 14,
	CRYPTOCFGA_STAT_AEAD = 15,
	CRYPTOCFGA_STAT_COMPRESS = 16,
	CRYPTOCFGA_STAT_RNG = 17,
	CRYPTOCFGA_STAT_CIPHER = 18,
	CRYPTOCFGA_STAT_AKCIPHER = 19,
	CRYPTOCFGA_STAT_KPP = 20,
	CRYPTOCFGA_STAT_ACOMP = 21,
	CRYPTOCFGA_REPORT_SIG = 22,
	__CRYPTOCFGA_MAX = 23,
};

enum ct_dccp_states {
	CT_DCCP_NONE = 0,
	CT_DCCP_REQUEST = 1,
	CT_DCCP_RESPOND = 2,
	CT_DCCP_PARTOPEN = 3,
	CT_DCCP_OPEN = 4,
	CT_DCCP_CLOSEREQ = 5,
	CT_DCCP_CLOSING = 6,
	CT_DCCP_TIMEWAIT = 7,
	CT_DCCP_IGNORE = 8,
	CT_DCCP_INVALID = 9,
	__CT_DCCP_MAX = 10,
};

enum ct_format {
	SSP_F_H = 0,
	SSP_F_IU = 24,
	SSP_F_MAX = 77,
	STP_CMD_FIS = 0,
	STP_ATAPI_CMD = 64,
	STP_F_MAX = 16,
	SMP_F_T = 0,
	SMP_F_DEP = 1,
	SMP_F_MAX = 257,
};

enum cti_port_type {
	CTI_PORT_TYPE_NONE = 0,
	CTI_PORT_TYPE_RS232 = 1,
	CTI_PORT_TYPE_RS422_485 = 2,
	CTI_PORT_TYPE_RS232_422_485_HW = 3,
	CTI_PORT_TYPE_RS232_422_485_SW = 4,
	CTI_PORT_TYPE_RS232_422_485_4B = 5,
	CTI_PORT_TYPE_RS232_422_485_2B = 6,
	CTI_PORT_TYPE_MAX = 7,
};

enum ctrl_offsets {
	BASE_OFFSET = 0,
	SLOT_AVAIL1 = 4,
	SLOT_AVAIL2 = 8,
	SLOT_CONFIG = 12,
	SEC_BUS_CONFIG = 16,
	MSI_CTRL = 18,
	PROG_INTERFACE = 19,
	CMD = 20,
	CMD_STATUS = 22,
	INTR_LOC = 24,
	SERR_LOC = 28,
	SERR_INTR_ENABLE = 32,
	SLOT1 = 36,
};

enum ctx_state {
	CT_STATE_DISABLED = -1,
	CT_STATE_KERNEL = 0,
	CT_STATE_IDLE = 1,
	CT_STATE_USER = 2,
	CT_STATE_GUEST = 3,
	CT_STATE_MAX = 4,
};

enum d_real_type {
	D_REAL_DATA = 0,
	D_REAL_METADATA = 1,
};

enum d_walk_ret {
	D_WALK_CONTINUE = 0,
	D_WALK_QUIT = 1,
	D_WALK_NORETRY = 2,
	D_WALK_SKIP = 3,
};

enum data_content4 {
	NFS4_CONTENT_DATA = 0,
	NFS4_CONTENT_HOLE = 1,
};

enum dax_access_mode {
	DAX_ACCESS = 0,
	DAX_RECOVERY_WRITE = 1,
};

enum dbc_state {
	DS_DISABLED = 0,
	DS_INITIALIZED = 1,
	DS_ENABLED = 2,
	DS_CONNECTED = 3,
	DS_CONFIGURED = 4,
	DS_MAX = 5,
};

enum dbgfs_get_mode {
	DBGFS_GET_ALREADY = 0,
	DBGFS_GET_REGULAR = 1,
	DBGFS_GET_SHORT = 2,
};

enum dcb_pfc_type {
	pfc_disabled = 0,
	pfc_enabled_full = 1,
	pfc_enabled_tx = 2,
	pfc_enabled_rx = 3,
};

enum dccp_state {
	DCCP_OPEN = 1,
	DCCP_REQUESTING = 2,
	DCCP_LISTEN = 10,
	DCCP_RESPOND = 3,
	DCCP_ACTIVE_CLOSEREQ = 4,
	DCCP_PASSIVE_CLOSE = 8,
	DCCP_CLOSING = 11,
	DCCP_TIME_WAIT = 6,
	DCCP_CLOSED = 7,
	DCCP_NEW_SYN_RECV = 12,
	DCCP_PARTOPEN = 14,
	DCCP_PASSIVE_CLOSEREQ = 15,
	DCCP_MAX_STATES = 16,
};

enum dd_data_dir {
	DD_READ = 0,
	DD_WRITE = 1,
};

enum dd_prio {
	DD_RT_PRIO = 0,
	DD_BE_PRIO = 1,
	DD_IDLE_PRIO = 2,
	DD_PRIO_MAX = 2,
};

enum ddc_type {
	ddc_none = 0,
	ddc_monid = 1,
	ddc_dvi = 2,
	ddc_vga = 3,
	ddc_crt2 = 4,
};

enum dentry_d_lock_class {
	DENTRY_D_LOCK_NORMAL = 0,
	DENTRY_D_LOCK_NESTED = 1,
};

enum depot_counter_id {
	DEPOT_COUNTER_REFD_ALLOCS = 0,
	DEPOT_COUNTER_REFD_FREES = 1,
	DEPOT_COUNTER_REFD_INUSE = 2,
	DEPOT_COUNTER_FREELIST_SIZE = 3,
	DEPOT_COUNTER_PERSIST_COUNT = 4,
	DEPOT_COUNTER_PERSIST_BYTES = 5,
	DEPOT_COUNTER_COUNT = 6,
};

enum desc_state {
	desc_miss = -1,
	desc_reserved = 0,
	desc_committed = 1,
	desc_finalized = 2,
	desc_reusable = 3,
};

enum dev_dma_attr {
	DEV_DMA_NOT_SUPPORTED = 0,
	DEV_DMA_NON_COHERENT = 1,
	DEV_DMA_COHERENT = 2,
};

enum dev_pm_opp_event {
	OPP_EVENT_ADD = 0,
	OPP_EVENT_REMOVE = 1,
	OPP_EVENT_ENABLE = 2,
	OPP_EVENT_DISABLE = 3,
	OPP_EVENT_ADJUST_VOLTAGE = 4,
};

enum dev_pm_qos_req_type {
	DEV_PM_QOS_RESUME_LATENCY = 1,
	DEV_PM_QOS_LATENCY_TOLERANCE = 2,
	DEV_PM_QOS_MIN_FREQUENCY = 3,
	DEV_PM_QOS_MAX_FREQUENCY = 4,
	DEV_PM_QOS_FLAGS = 5,
};

enum dev_prop_type {
	DEV_PROP_U8 = 0,
	DEV_PROP_U16 = 1,
	DEV_PROP_U32 = 2,
	DEV_PROP_U64 = 3,
	DEV_PROP_STRING = 4,
	DEV_PROP_REF = 5,
};

enum dev_reset {
	MVS_SOFT_RESET = 0,
	MVS_HARD_RESET = 1,
	MVS_PHY_TUNE = 2,
};

enum dev_status {
	MVS_DEV_NORMAL = 0,
	MVS_DEV_EH = 1,
};

enum devcg_behavior {
	DEVCG_DEFAULT_NONE = 0,
	DEVCG_DEFAULT_ALLOW = 1,
	DEVCG_DEFAULT_DENY = 2,
};

enum devfreq_timer {
	DEVFREQ_TIMER_DEFERRABLE = 0,
	DEVFREQ_TIMER_DELAYED = 1,
	DEVFREQ_TIMER_NUM = 2,
};

enum device_link_state {
	DL_STATE_NONE = -1,
	DL_STATE_DORMANT = 0,
	DL_STATE_AVAILABLE = 1,
	DL_STATE_CONSUMER_PROBE = 2,
	DL_STATE_ACTIVE = 3,
	DL_STATE_SUPPLIER_UNBIND = 4,
};

enum device_physical_location_horizontal_position {
	DEVICE_HORI_POS_LEFT = 0,
	DEVICE_HORI_POS_CENTER = 1,
	DEVICE_HORI_POS_RIGHT = 2,
};

enum device_physical_location_panel {
	DEVICE_PANEL_TOP = 0,
	DEVICE_PANEL_BOTTOM = 1,
	DEVICE_PANEL_LEFT = 2,
	DEVICE_PANEL_RIGHT = 3,
	DEVICE_PANEL_FRONT = 4,
	DEVICE_PANEL_BACK = 5,
	DEVICE_PANEL_UNKNOWN = 6,
};

enum device_physical_location_vertical_position {
	DEVICE_VERT_POS_UPPER = 0,
	DEVICE_VERT_POS_CENTER = 1,
	DEVICE_VERT_POS_LOWER = 2,
};

enum device_removable {
	DEVICE_REMOVABLE_NOT_SUPPORTED = 0,
	DEVICE_REMOVABLE_UNKNOWN = 1,
	DEVICE_FIXED = 2,
	DEVICE_REMOVABLE = 3,
};

enum devkmsg_log_bits {
	__DEVKMSG_LOG_BIT_ON = 0,
	__DEVKMSG_LOG_BIT_OFF = 1,
	__DEVKMSG_LOG_BIT_LOCK = 2,
};

enum devkmsg_log_masks {
	DEVKMSG_LOG_MASK_ON = 1,
	DEVKMSG_LOG_MASK_OFF = 2,
	DEVKMSG_LOG_MASK_LOCK = 4,
};

enum devlink_port_flavour {
	DEVLINK_PORT_FLAVOUR_PHYSICAL = 0,
	DEVLINK_PORT_FLAVOUR_CPU = 1,
	DEVLINK_PORT_FLAVOUR_DSA = 2,
	DEVLINK_PORT_FLAVOUR_PCI_PF = 3,
	DEVLINK_PORT_FLAVOUR_PCI_VF = 4,
	DEVLINK_PORT_FLAVOUR_VIRTUAL = 5,
	DEVLINK_PORT_FLAVOUR_UNUSED = 6,
	DEVLINK_PORT_FLAVOUR_PCI_SF = 7,
};

enum devlink_port_fn_opstate {
	DEVLINK_PORT_FN_OPSTATE_DETACHED = 0,
	DEVLINK_PORT_FN_OPSTATE_ATTACHED = 1,
};

enum devlink_port_fn_state {
	DEVLINK_PORT_FN_STATE_INACTIVE = 0,
	DEVLINK_PORT_FN_STATE_ACTIVE = 1,
};

enum devlink_port_type {
	DEVLINK_PORT_TYPE_NOTSET = 0,
	DEVLINK_PORT_TYPE_AUTO = 1,
	DEVLINK_PORT_TYPE_ETH = 2,
	DEVLINK_PORT_TYPE_IB = 3,
};

enum devlink_rate_type {
	DEVLINK_RATE_TYPE_LEAF = 0,
	DEVLINK_RATE_TYPE_NODE = 1,
};

enum devm_ioremap_type {
	DEVM_IOREMAP = 0,
	DEVM_IOREMAP_UC = 1,
	DEVM_IOREMAP_WC = 2,
	DEVM_IOREMAP_NP = 3,
};

enum die_val {
	DIE_OOPS = 1,
	DIE_RI = 2,
	DIE_FP = 3,
	DIE_SIMD = 4,
	DIE_TRAP = 5,
};

enum dim_cq_period_mode {
	DIM_CQ_PERIOD_MODE_START_FROM_EQE = 0,
	DIM_CQ_PERIOD_MODE_START_FROM_CQE = 1,
	DIM_CQ_PERIOD_NUM_MODES = 2,
};

enum dim_state {
	DIM_START_MEASURE = 0,
	DIM_MEASURE_IN_PROGRESS = 1,
	DIM_APPLY_NEW_PROFILE = 2,
};

enum dim_stats_state {
	DIM_STATS_WORSE = 0,
	DIM_STATS_SAME = 1,
	DIM_STATS_BETTER = 2,
};

enum dim_step_result {
	DIM_STEPPED = 0,
	DIM_TOO_TIRED = 1,
	DIM_ON_EDGE = 2,
};

enum dim_tune_state {
	DIM_PARKING_ON_TOP = 0,
	DIM_PARKING_TIRED = 1,
	DIM_GOING_RIGHT = 2,
	DIM_GOING_LEFT = 3,
};

enum discover_event {
	DISCE_DISCOVER_DOMAIN = 0,
	DISCE_REVALIDATE_DOMAIN = 1,
	DISCE_SUSPEND = 2,
	DISCE_RESUME = 3,
	DISC_NUM_EVENTS = 4,
};

enum dl_bw_request {
	dl_bw_req_deactivate = 0,
	dl_bw_req_alloc = 1,
	dl_bw_req_free = 2,
};

enum dl_dev_state {
	DL_DEV_NO_DRIVER = 0,
	DL_DEV_PROBING = 1,
	DL_DEV_DRIVER_BOUND = 2,
	DL_DEV_UNBINDING = 3,
};

enum dm_io_mem_type {
	DM_IO_PAGE_LIST = 0,
	DM_IO_BIO = 1,
	DM_IO_VMA = 2,
	DM_IO_KMEM = 3,
};

enum dm_queue_mode {
	DM_TYPE_NONE = 0,
	DM_TYPE_BIO_BASED = 1,
	DM_TYPE_REQUEST_BASED = 2,
	DM_TYPE_DAX_BIO_BASED = 3,
};

enum dm_uevent_type {
	DM_UEVENT_PATH_FAILED = 0,
	DM_UEVENT_PATH_REINSTATED = 1,
};

enum dma_ctrl_flags {
	DMA_PREP_INTERRUPT = 1,
	DMA_CTRL_ACK = 2,
	DMA_PREP_PQ_DISABLE_P = 4,
	DMA_PREP_PQ_DISABLE_Q = 8,
	DMA_PREP_CONTINUE = 16,
	DMA_PREP_FENCE = 32,
	DMA_CTRL_REUSE = 64,
	DMA_PREP_CMD = 128,
	DMA_PREP_REPEAT = 256,
	DMA_PREP_LOAD_EOT = 512,
};

enum dma_data_direction {
	DMA_BIDIRECTIONAL = 0,
	DMA_TO_DEVICE = 1,
	DMA_FROM_DEVICE = 2,
	DMA_NONE = 3,
};

enum dma_desc_metadata_mode {
	DESC_METADATA_NONE = 0,
	DESC_METADATA_CLIENT = 1,
	DESC_METADATA_ENGINE = 2,
};

enum dma_dtype {
	DTYPE1 = 1,
	DTYPE2 = 2,
	DTYPE3 = 3,
	DTYPE4 = 4,
	DTYPE5 = 5,
	DTYPE6 = 6,
};

enum dma_fence_flag_bits {
	DMA_FENCE_FLAG_SIGNALED_BIT = 0,
	DMA_FENCE_FLAG_TIMESTAMP_BIT = 1,
	DMA_FENCE_FLAG_ENABLE_SIGNAL_BIT = 2,
	DMA_FENCE_FLAG_USER_BITS = 3,
};

enum dma_irq_dir {
	DMA_DIR_RX = 1,
	DMA_DIR_TX = 2,
	DMA_DIR_RXTX = 3,
};

enum dma_irq_status {
	tx_hard_error = 1,
	tx_hard_error_bump_tc = 2,
	handle_rx = 4,
	handle_tx = 8,
};

enum dma_residue_granularity {
	DMA_RESIDUE_GRANULARITY_DESCRIPTOR = 0,
	DMA_RESIDUE_GRANULARITY_SEGMENT = 1,
	DMA_RESIDUE_GRANULARITY_BURST = 2,
};

enum dma_resv_usage {
	DMA_RESV_USAGE_KERNEL = 0,
	DMA_RESV_USAGE_WRITE = 1,
	DMA_RESV_USAGE_READ = 2,
	DMA_RESV_USAGE_BOOKKEEP = 3,
};

enum dma_rtype {
	NREAD = 0,
	LAST_NWRITE_R = 1,
	ALL_NWRITE = 2,
	ALL_NWRITE_R = 3,
	MAINT_RD = 4,
	MAINT_WR = 5,
};

enum dma_slave_buswidth {
	DMA_SLAVE_BUSWIDTH_UNDEFINED = 0,
	DMA_SLAVE_BUSWIDTH_1_BYTE = 1,
	DMA_SLAVE_BUSWIDTH_2_BYTES = 2,
	DMA_SLAVE_BUSWIDTH_3_BYTES = 3,
	DMA_SLAVE_BUSWIDTH_4_BYTES = 4,
	DMA_SLAVE_BUSWIDTH_8_BYTES = 8,
	DMA_SLAVE_BUSWIDTH_16_BYTES = 16,
	DMA_SLAVE_BUSWIDTH_32_BYTES = 32,
	DMA_SLAVE_BUSWIDTH_64_BYTES = 64,
	DMA_SLAVE_BUSWIDTH_128_BYTES = 128,
};

enum dma_status {
	DMA_COMPLETE = 0,
	DMA_IN_PROGRESS = 1,
	DMA_PAUSED = 2,
	DMA_ERROR = 3,
	DMA_OUT_OF_ORDER = 4,
};

enum dma_transaction_type {
	DMA_MEMCPY = 0,
	DMA_XOR = 1,
	DMA_PQ = 2,
	DMA_XOR_VAL = 3,
	DMA_PQ_VAL = 4,
	DMA_MEMSET = 5,
	DMA_MEMSET_SG = 6,
	DMA_INTERRUPT = 7,
	DMA_PRIVATE = 8,
	DMA_ASYNC_TX = 9,
	DMA_SLAVE = 10,
	DMA_CYCLIC = 11,
	DMA_INTERLEAVE = 12,
	DMA_COMPLETION_NO_ORDER = 13,
	DMA_REPEAT = 14,
	DMA_LOAD_EOT = 15,
	DMA_TX_TYPE_END = 16,
};

enum dma_transfer_direction {
	DMA_MEM_TO_MEM = 0,
	DMA_MEM_TO_DEV = 1,
	DMA_DEV_TO_MEM = 2,
	DMA_DEV_TO_DEV = 3,
	DMA_TRANS_NONE = 4,
};

enum dmaengine_alignment {
	DMAENGINE_ALIGN_1_BYTE = 0,
	DMAENGINE_ALIGN_2_BYTES = 1,
	DMAENGINE_ALIGN_4_BYTES = 2,
	DMAENGINE_ALIGN_8_BYTES = 3,
	DMAENGINE_ALIGN_16_BYTES = 4,
	DMAENGINE_ALIGN_32_BYTES = 5,
	DMAENGINE_ALIGN_64_BYTES = 6,
	DMAENGINE_ALIGN_128_BYTES = 7,
	DMAENGINE_ALIGN_256_BYTES = 8,
};

enum dmaengine_tx_result {
	DMA_TRANS_NOERROR = 0,
	DMA_TRANS_READ_FAILED = 1,
	DMA_TRANS_WRITE_FAILED = 2,
	DMA_TRANS_ABORTED = 3,
};

enum dmi_device_type {
	DMI_DEV_TYPE_ANY = 0,
	DMI_DEV_TYPE_OTHER = 1,
	DMI_DEV_TYPE_UNKNOWN = 2,
	DMI_DEV_TYPE_VIDEO = 3,
	DMI_DEV_TYPE_SCSI = 4,
	DMI_DEV_TYPE_ETHERNET = 5,
	DMI_DEV_TYPE_TOKENRING = 6,
	DMI_DEV_TYPE_SOUND = 7,
	DMI_DEV_TYPE_PATA = 8,
	DMI_DEV_TYPE_SATA = 9,
	DMI_DEV_TYPE_SAS = 10,
	DMI_DEV_TYPE_IPMI = -1,
	DMI_DEV_TYPE_OEM_STRING = -2,
	DMI_DEV_TYPE_DEV_ONBOARD = -3,
	DMI_DEV_TYPE_DEV_SLOT = -4,
};

enum dmi_entry_type {
	DMI_ENTRY_BIOS = 0,
	DMI_ENTRY_SYSTEM = 1,
	DMI_ENTRY_BASEBOARD = 2,
	DMI_ENTRY_CHASSIS = 3,
	DMI_ENTRY_PROCESSOR = 4,
	DMI_ENTRY_MEM_CONTROLLER = 5,
	DMI_ENTRY_MEM_MODULE = 6,
	DMI_ENTRY_CACHE = 7,
	DMI_ENTRY_PORT_CONNECTOR = 8,
	DMI_ENTRY_SYSTEM_SLOT = 9,
	DMI_ENTRY_ONBOARD_DEVICE = 10,
	DMI_ENTRY_OEMSTRINGS = 11,
	DMI_ENTRY_SYSCONF = 12,
	DMI_ENTRY_BIOS_LANG = 13,
	DMI_ENTRY_GROUP_ASSOC = 14,
	DMI_ENTRY_SYSTEM_EVENT_LOG = 15,
	DMI_ENTRY_PHYS_MEM_ARRAY = 16,
	DMI_ENTRY_MEM_DEVICE = 17,
	DMI_ENTRY_32_MEM_ERROR = 18,
	DMI_ENTRY_MEM_ARRAY_MAPPED_ADDR = 19,
	DMI_ENTRY_MEM_DEV_MAPPED_ADDR = 20,
	DMI_ENTRY_BUILTIN_POINTING_DEV = 21,
	DMI_ENTRY_PORTABLE_BATTERY = 22,
	DMI_ENTRY_SYSTEM_RESET = 23,
	DMI_ENTRY_HW_SECURITY = 24,
	DMI_ENTRY_SYSTEM_POWER_CONTROLS = 25,
	DMI_ENTRY_VOLTAGE_PROBE = 26,
	DMI_ENTRY_COOLING_DEV = 27,
	DMI_ENTRY_TEMP_PROBE = 28,
	DMI_ENTRY_ELECTRICAL_CURRENT_PROBE = 29,
	DMI_ENTRY_OOB_REMOTE_ACCESS = 30,
	DMI_ENTRY_BIS_ENTRY = 31,
	DMI_ENTRY_SYSTEM_BOOT = 32,
	DMI_ENTRY_MGMT_DEV = 33,
	DMI_ENTRY_MGMT_DEV_COMPONENT = 34,
	DMI_ENTRY_MGMT_DEV_THRES = 35,
	DMI_ENTRY_MEM_CHANNEL = 36,
	DMI_ENTRY_IPMI_DEV = 37,
	DMI_ENTRY_SYS_POWER_SUPPLY = 38,
	DMI_ENTRY_ADDITIONAL = 39,
	DMI_ENTRY_ONBOARD_DEV_EXT = 40,
	DMI_ENTRY_MGMT_CONTROLLER_HOST = 41,
	DMI_ENTRY_INACTIVE = 126,
	DMI_ENTRY_END_OF_TABLE = 127,
};

enum dmi_field {
	DMI_NONE = 0,
	DMI_BIOS_VENDOR = 1,
	DMI_BIOS_VERSION = 2,
	DMI_BIOS_DATE = 3,
	DMI_BIOS_RELEASE = 4,
	DMI_EC_FIRMWARE_RELEASE = 5,
	DMI_SYS_VENDOR = 6,
	DMI_PRODUCT_NAME = 7,
	DMI_PRODUCT_VERSION = 8,
	DMI_PRODUCT_SERIAL = 9,
	DMI_PRODUCT_UUID = 10,
	DMI_PRODUCT_SKU = 11,
	DMI_PRODUCT_FAMILY = 12,
	DMI_BOARD_VENDOR = 13,
	DMI_BOARD_NAME = 14,
	DMI_BOARD_VERSION = 15,
	DMI_BOARD_SERIAL = 16,
	DMI_BOARD_ASSET_TAG = 17,
	DMI_CHASSIS_VENDOR = 18,
	DMI_CHASSIS_TYPE = 19,
	DMI_CHASSIS_VERSION = 20,
	DMI_CHASSIS_SERIAL = 21,
	DMI_CHASSIS_ASSET_TAG = 22,
	DMI_STRING_MAX = 23,
	DMI_OEM_STRING = 24,
};

enum dns_lookup_status {
	DNS_LOOKUP_NOT_DONE = 0,
	DNS_LOOKUP_GOOD = 1,
	DNS_LOOKUP_GOOD_WITH_BAD = 2,
	DNS_LOOKUP_BAD = 3,
	DNS_LOOKUP_GOT_NOT_FOUND = 4,
	DNS_LOOKUP_GOT_LOCAL_FAILURE = 5,
	DNS_LOOKUP_GOT_TEMP_FAILURE = 6,
	DNS_LOOKUP_GOT_NS_FAILURE = 7,
	NR__dns_lookup_status = 8,
};

enum dns_payload_content_type {
	DNS_PAYLOAD_IS_SERVER_LIST = 0,
};

enum dock_callback_type {
	DOCK_CALL_HANDLER = 0,
	DOCK_CALL_FIXUP = 1,
	DOCK_CALL_UEVENT = 2,
};

enum dpm_order {
	DPM_ORDER_NONE = 0,
	DPM_ORDER_DEV_AFTER_PARENT = 1,
	DPM_ORDER_PARENT_BEFORE_DEV = 2,
	DPM_ORDER_DEV_LAST = 3,
};

enum driver_configuration {
	MVS_TX_RING_SZ = 1024,
	MVS_RX_RING_SZ = 1024,
	MVS_SOC_SLOTS = 64,
	MVS_SOC_TX_RING_SZ = 128,
	MVS_SOC_RX_RING_SZ = 128,
	MVS_SLOT_BUF_SZ = 8192,
	MVS_SSP_CMD_SZ = 64,
	MVS_ATA_CMD_SZ = 96,
	MVS_OAF_SZ = 64,
	MVS_QUEUE_SIZE = 64,
	MVS_RSVD_SLOTS = 4,
	MVS_SOC_CAN_QUEUE = 62,
};

enum drm_bridge_attach_flags {
	DRM_BRIDGE_ATTACH_NO_CONNECTOR = 1,
};

enum drm_bridge_ops {
	DRM_BRIDGE_OP_DETECT = 1,
	DRM_BRIDGE_OP_EDID = 2,
	DRM_BRIDGE_OP_HPD = 4,
	DRM_BRIDGE_OP_MODES = 8,
	DRM_BRIDGE_OP_HDMI = 16,
};

enum drm_color_encoding {
	DRM_COLOR_YCBCR_BT601 = 0,
	DRM_COLOR_YCBCR_BT709 = 1,
	DRM_COLOR_YCBCR_BT2020 = 2,
	DRM_COLOR_ENCODING_MAX = 3,
};

enum drm_color_lut_tests {
	DRM_COLOR_LUT_EQUAL_CHANNELS = 1,
	DRM_COLOR_LUT_NON_DECREASING = 2,
};

enum drm_color_range {
	DRM_COLOR_YCBCR_LIMITED_RANGE = 0,
	DRM_COLOR_YCBCR_FULL_RANGE = 1,
	DRM_COLOR_RANGE_MAX = 2,
};

enum drm_colorspace {
	DRM_MODE_COLORIMETRY_DEFAULT = 0,
	DRM_MODE_COLORIMETRY_NO_DATA = 0,
	DRM_MODE_COLORIMETRY_SMPTE_170M_YCC = 1,
	DRM_MODE_COLORIMETRY_BT709_YCC = 2,
	DRM_MODE_COLORIMETRY_XVYCC_601 = 3,
	DRM_MODE_COLORIMETRY_XVYCC_709 = 4,
	DRM_MODE_COLORIMETRY_SYCC_601 = 5,
	DRM_MODE_COLORIMETRY_OPYCC_601 = 6,
	DRM_MODE_COLORIMETRY_OPRGB = 7,
	DRM_MODE_COLORIMETRY_BT2020_CYCC = 8,
	DRM_MODE_COLORIMETRY_BT2020_RGB = 9,
	DRM_MODE_COLORIMETRY_BT2020_YCC = 10,
	DRM_MODE_COLORIMETRY_DCI_P3_RGB_D65 = 11,
	DRM_MODE_COLORIMETRY_DCI_P3_RGB_THEATER = 12,
	DRM_MODE_COLORIMETRY_RGB_WIDE_FIXED = 13,
	DRM_MODE_COLORIMETRY_RGB_WIDE_FLOAT = 14,
	DRM_MODE_COLORIMETRY_BT601_YCC = 15,
	DRM_MODE_COLORIMETRY_COUNT = 16,
};

enum drm_connector_force {
	DRM_FORCE_UNSPECIFIED = 0,
	DRM_FORCE_OFF = 1,
	DRM_FORCE_ON = 2,
	DRM_FORCE_ON_DIGITAL = 3,
};

enum drm_connector_registration_state {
	DRM_CONNECTOR_INITIALIZING = 0,
	DRM_CONNECTOR_REGISTERED = 1,
	DRM_CONNECTOR_UNREGISTERED = 2,
};

enum drm_connector_status {
	connector_status_connected = 1,
	connector_status_disconnected = 2,
	connector_status_unknown = 3,
};

enum drm_connector_tv_mode {
	DRM_MODE_TV_MODE_NTSC = 0,
	DRM_MODE_TV_MODE_NTSC_443 = 1,
	DRM_MODE_TV_MODE_NTSC_J = 2,
	DRM_MODE_TV_MODE_PAL = 3,
	DRM_MODE_TV_MODE_PAL_M = 4,
	DRM_MODE_TV_MODE_PAL_N = 5,
	DRM_MODE_TV_MODE_SECAM = 6,
	DRM_MODE_TV_MODE_MONOCHROME = 7,
	DRM_MODE_TV_MODE_MAX = 8,
};

enum drm_debug_category {
	DRM_UT_CORE = 0,
	DRM_UT_DRIVER = 1,
	DRM_UT_KMS = 2,
	DRM_UT_PRIME = 3,
	DRM_UT_ATOMIC = 4,
	DRM_UT_VBL = 5,
	DRM_UT_STATE = 6,
	DRM_UT_LEASE = 7,
	DRM_UT_DP = 8,
	DRM_UT_DRMRES = 9,
};

enum drm_driver_feature {
	DRIVER_GEM = 1,
	DRIVER_MODESET = 2,
	DRIVER_RENDER = 8,
	DRIVER_ATOMIC = 16,
	DRIVER_SYNCOBJ = 32,
	DRIVER_SYNCOBJ_TIMELINE = 64,
	DRIVER_COMPUTE_ACCEL = 128,
	DRIVER_GEM_GPUVA = 256,
	DRIVER_CURSOR_HOTSPOT = 512,
	DRIVER_USE_AGP = 33554432,
	DRIVER_LEGACY = 67108864,
	DRIVER_PCI_DMA = 134217728,
	DRIVER_SG = 268435456,
	DRIVER_HAVE_DMA = 536870912,
	DRIVER_HAVE_IRQ = 1073741824,
};

enum drm_gem_object_status {
	DRM_GEM_OBJECT_RESIDENT = 1,
	DRM_GEM_OBJECT_PURGEABLE = 2,
	DRM_GEM_OBJECT_ACTIVE = 4,
};

enum drm_gpuva_flags {
	DRM_GPUVA_INVALIDATED = 1,
	DRM_GPUVA_SPARSE = 2,
	DRM_GPUVA_USERBITS = 4,
};

enum drm_gpuva_op_type {
	DRM_GPUVA_OP_MAP = 0,
	DRM_GPUVA_OP_REMAP = 1,
	DRM_GPUVA_OP_UNMAP = 2,
	DRM_GPUVA_OP_PREFETCH = 3,
};

enum drm_gpuvm_flags {
	DRM_GPUVM_RESV_PROTECTED = 1,
	DRM_GPUVM_USERBITS = 2,
};

enum drm_hdmi_broadcast_rgb {
	DRM_HDMI_BROADCAST_RGB_AUTO = 0,
	DRM_HDMI_BROADCAST_RGB_FULL = 1,
	DRM_HDMI_BROADCAST_RGB_LIMITED = 2,
};

enum drm_ioctl_flags {
	DRM_AUTH = 1,
	DRM_MASTER = 2,
	DRM_ROOT_ONLY = 4,
	DRM_RENDER_ALLOW = 32,
};

enum drm_link_status {
	DRM_LINK_STATUS_GOOD = 0,
	DRM_LINK_STATUS_BAD = 1,
};

enum drm_lvds_dual_link_pixels {
	DRM_LVDS_DUAL_LINK_EVEN_ODD_PIXELS = 0,
	DRM_LVDS_DUAL_LINK_ODD_EVEN_PIXELS = 1,
};

enum drm_minor_type {
	DRM_MINOR_PRIMARY = 0,
	DRM_MINOR_CONTROL = 1,
	DRM_MINOR_RENDER = 2,
	DRM_MINOR_ACCEL = 32,
};

enum drm_mm_insert_mode {
	DRM_MM_INSERT_BEST = 0,
	DRM_MM_INSERT_LOW = 1,
	DRM_MM_INSERT_HIGH = 2,
	DRM_MM_INSERT_EVICT = 3,
	DRM_MM_INSERT_ONCE = 2147483648,
	DRM_MM_INSERT_HIGHEST = 2147483650,
	DRM_MM_INSERT_LOWEST = 2147483649,
};

enum drm_mode_analog {
	DRM_MODE_ANALOG_NTSC = 0,
	DRM_MODE_ANALOG_PAL = 1,
};

enum drm_mode_status {
	MODE_OK = 0,
	MODE_HSYNC = 1,
	MODE_VSYNC = 2,
	MODE_H_ILLEGAL = 3,
	MODE_V_ILLEGAL = 4,
	MODE_BAD_WIDTH = 5,
	MODE_NOMODE = 6,
	MODE_NO_INTERLACE = 7,
	MODE_NO_DBLESCAN = 8,
	MODE_NO_VSCAN = 9,
	MODE_MEM = 10,
	MODE_VIRTUAL_X = 11,
	MODE_VIRTUAL_Y = 12,
	MODE_MEM_VIRT = 13,
	MODE_NOCLOCK = 14,
	MODE_CLOCK_HIGH = 15,
	MODE_CLOCK_LOW = 16,
	MODE_CLOCK_RANGE = 17,
	MODE_BAD_HVALUE = 18,
	MODE_BAD_VVALUE = 19,
	MODE_BAD_VSCAN = 20,
	MODE_HSYNC_NARROW = 21,
	MODE_HSYNC_WIDE = 22,
	MODE_HBLANK_NARROW = 23,
	MODE_HBLANK_WIDE = 24,
	MODE_VSYNC_NARROW = 25,
	MODE_VSYNC_WIDE = 26,
	MODE_VBLANK_NARROW = 27,
	MODE_VBLANK_WIDE = 28,
	MODE_PANEL = 29,
	MODE_INTERLACE_WIDTH = 30,
	MODE_ONE_WIDTH = 31,
	MODE_ONE_HEIGHT = 32,
	MODE_ONE_SIZE = 33,
	MODE_NO_REDUCED = 34,
	MODE_NO_STEREO = 35,
	MODE_NO_420 = 36,
	MODE_STALE = -3,
	MODE_BAD = -2,
	MODE_ERROR = -1,
};

enum drm_mode_subconnector {
	DRM_MODE_SUBCONNECTOR_Automatic = 0,
	DRM_MODE_SUBCONNECTOR_Unknown = 0,
	DRM_MODE_SUBCONNECTOR_VGA = 1,
	DRM_MODE_SUBCONNECTOR_DVID = 3,
	DRM_MODE_SUBCONNECTOR_DVIA = 4,
	DRM_MODE_SUBCONNECTOR_Composite = 5,
	DRM_MODE_SUBCONNECTOR_SVIDEO = 6,
	DRM_MODE_SUBCONNECTOR_Component = 8,
	DRM_MODE_SUBCONNECTOR_SCART = 9,
	DRM_MODE_SUBCONNECTOR_DisplayPort = 10,
	DRM_MODE_SUBCONNECTOR_HDMIA = 11,
	DRM_MODE_SUBCONNECTOR_Native = 15,
	DRM_MODE_SUBCONNECTOR_Wireless = 18,
};

enum drm_of_lvds_pixels {
	DRM_OF_LVDS_EVEN = 1,
	DRM_OF_LVDS_ODD = 2,
};

enum drm_panel_orientation {
	DRM_MODE_PANEL_ORIENTATION_UNKNOWN = -1,
	DRM_MODE_PANEL_ORIENTATION_NORMAL = 0,
	DRM_MODE_PANEL_ORIENTATION_BOTTOM_UP = 1,
	DRM_MODE_PANEL_ORIENTATION_LEFT_UP = 2,
	DRM_MODE_PANEL_ORIENTATION_RIGHT_UP = 3,
};

enum drm_plane_type {
	DRM_PLANE_TYPE_OVERLAY = 0,
	DRM_PLANE_TYPE_PRIMARY = 1,
	DRM_PLANE_TYPE_CURSOR = 2,
};

enum drm_privacy_screen_status {
	PRIVACY_SCREEN_DISABLED = 0,
	PRIVACY_SCREEN_ENABLED = 1,
	PRIVACY_SCREEN_DISABLED_LOCKED = 2,
	PRIVACY_SCREEN_ENABLED_LOCKED = 3,
};

enum drm_scaling_filter {
	DRM_SCALING_FILTER_DEFAULT = 0,
	DRM_SCALING_FILTER_NEAREST_NEIGHBOR = 1,
};

enum drm_stat_type {
	_DRM_STAT_LOCK = 0,
	_DRM_STAT_OPENS = 1,
	_DRM_STAT_CLOSES = 2,
	_DRM_STAT_IOCTLS = 3,
	_DRM_STAT_LOCKS = 4,
	_DRM_STAT_UNLOCKS = 5,
	_DRM_STAT_VALUE = 6,
	_DRM_STAT_BYTE = 7,
	_DRM_STAT_COUNT = 8,
	_DRM_STAT_IRQ = 9,
	_DRM_STAT_PRIMARY = 10,
	_DRM_STAT_SECONDARY = 11,
	_DRM_STAT_DMA = 12,
	_DRM_STAT_SPECIAL = 13,
	_DRM_STAT_MISSED = 14,
};

enum drm_vblank_seq_type {
	_DRM_VBLANK_ABSOLUTE = 0,
	_DRM_VBLANK_RELATIVE = 1,
	_DRM_VBLANK_HIGH_CRTC_MASK = 62,
	_DRM_VBLANK_EVENT = 67108864,
	_DRM_VBLANK_FLIP = 134217728,
	_DRM_VBLANK_NEXTONMISS = 268435456,
	_DRM_VBLANK_SECONDARY = 536870912,
	_DRM_VBLANK_SIGNAL = 1073741824,
};

enum dw_pci_ctl_id_t {
	medfield = 0,
	merrifield = 1,
	baytrail = 2,
	cherrytrail = 3,
	haswell = 4,
	elkhartlake = 5,
	navi_amd = 6,
};

enum dw_xpcs_clock {
	DW_XPCS_CORE_CLK = 0,
	DW_XPCS_PAD_CLK = 1,
	DW_XPCS_NUM_CLKS = 2,
};

enum dw_xpcs_pcs_id {
	DW_XPCS_ID_NATIVE = 0,
	NXP_SJA1105_XPCS_ID = 16,
	NXP_SJA1110_XPCS_ID = 32,
	DW_XPCS_ID = 2039926480,
	DW_XPCS_ID_MASK = 4294967295,
};

enum dw_xpcs_pma_id {
	DW_XPCS_PMA_ID_NATIVE = 0,
	DW_XPCS_PMA_GEN1_3G_ID = 1,
	DW_XPCS_PMA_GEN2_3G_ID = 2,
	DW_XPCS_PMA_GEN2_6G_ID = 3,
	DW_XPCS_PMA_GEN4_3G_ID = 4,
	DW_XPCS_PMA_GEN4_6G_ID = 5,
	DW_XPCS_PMA_GEN5_10G_ID = 6,
	DW_XPCS_PMA_GEN5_12G_ID = 7,
	WX_TXGBE_XPCS_PMA_10G_ID = 1637504,
};

enum dwc2_control_phase {
	DWC2_CONTROL_SETUP = 0,
	DWC2_CONTROL_DATA = 1,
	DWC2_CONTROL_STATUS = 2,
};

enum dwc2_halt_status {
	DWC2_HC_XFER_NO_HALT_STATUS = 0,
	DWC2_HC_XFER_COMPLETE = 1,
	DWC2_HC_XFER_URB_COMPLETE = 2,
	DWC2_HC_XFER_ACK = 3,
	DWC2_HC_XFER_NAK = 4,
	DWC2_HC_XFER_NYET = 5,
	DWC2_HC_XFER_STALL = 6,
	DWC2_HC_XFER_XACT_ERR = 7,
	DWC2_HC_XFER_FRAME_OVERRUN = 8,
	DWC2_HC_XFER_BABBLE_ERR = 9,
	DWC2_HC_XFER_DATA_TOGGLE_ERR = 10,
	DWC2_HC_XFER_AHB_ERR = 11,
	DWC2_HC_XFER_PERIODIC_INCOMPLETE = 12,
	DWC2_HC_XFER_URB_DEQUEUE = 13,
};

enum dwc2_hsotg_dmamode {
	S3C_HSOTG_DMA_NONE = 0,
	S3C_HSOTG_DMA_ONLY = 1,
	S3C_HSOTG_DMA_DRV = 2,
};

enum dwc2_lx_state {
	DWC2_L0 = 0,
	DWC2_L1 = 1,
	DWC2_L2 = 2,
	DWC2_L3 = 3,
};

enum dwc2_transaction_type {
	DWC2_TRANSACTION_NONE = 0,
	DWC2_TRANSACTION_PERIODIC = 1,
	DWC2_TRANSACTION_NON_PERIODIC = 2,
	DWC2_TRANSACTION_ALL = 3,
};

enum dwmac4_irq_status {
	time_stamp_irq = 4096,
	mmc_rx_csum_offload_irq = 2048,
	mmc_tx_irq = 1024,
	mmc_rx_irq = 512,
	mmc_irq = 256,
	lpi_irq = 32,
	pmt_irq = 16,
};

enum dynevent_type {
	DYNEVENT_TYPE_SYNTH = 1,
	DYNEVENT_TYPE_KPROBE = 2,
	DYNEVENT_TYPE_NONE = 3,
};

enum e1000_1000t_rx_status {
	e1000_1000t_rx_status_not_ok___2 = 0,
	e1000_1000t_rx_status_ok___2 = 1,
	e1000_1000t_rx_status_undefined___2 = 255,
};

enum e1000_boards {
	board_82571 = 0,
	board_82572 = 1,
	board_82573 = 2,
	board_82574 = 3,
	board_82583 = 4,
	board_80003es2lan = 5,
	board_ich8lan = 6,
	board_ich9lan = 7,
	board_ich10lan = 8,
	board_pchlan = 9,
	board_pch2lan = 10,
	board_pch_lpt = 11,
	board_pch_spt = 12,
	board_pch_cnp = 13,
	board_pch_tgp = 14,
	board_pch_adp = 15,
	board_pch_mtp = 16,
};

enum e1000_bus_speed {
	e1000_bus_speed_unknown___2 = 0,
	e1000_bus_speed_33___2 = 1,
	e1000_bus_speed_66___2 = 2,
	e1000_bus_speed_100___2 = 3,
	e1000_bus_speed_120___2 = 4,
	e1000_bus_speed_133___2 = 5,
	e1000_bus_speed_2500 = 6,
	e1000_bus_speed_5000 = 7,
	e1000_bus_speed_reserved___2 = 8,
};

enum e1000_bus_type {
	e1000_bus_type_unknown___2 = 0,
	e1000_bus_type_pci___2 = 1,
	e1000_bus_type_pcix___2 = 2,
	e1000_bus_type_pci_express = 3,
	e1000_bus_type_reserved___2 = 4,
};

enum e1000_bus_width {
	e1000_bus_width_unknown___2 = 0,
	e1000_bus_width_pcie_x1 = 1,
	e1000_bus_width_pcie_x2 = 2,
	e1000_bus_width_pcie_x4 = 4,
	e1000_bus_width_pcie_x8 = 8,
	e1000_bus_width_32___2 = 9,
	e1000_bus_width_64___2 = 10,
	e1000_bus_width_reserved___2 = 11,
};

enum e1000_fc_mode {
	e1000_fc_none = 0,
	e1000_fc_rx_pause = 1,
	e1000_fc_tx_pause = 2,
	e1000_fc_full = 3,
	e1000_fc_default = 255,
};

enum e1000_mac_type {
	e1000_82571 = 0,
	e1000_82572 = 1,
	e1000_82573 = 2,
	e1000_82574 = 3,
	e1000_82583 = 4,
	e1000_80003es2lan = 5,
	e1000_ich8lan = 6,
	e1000_ich9lan = 7,
	e1000_ich10lan = 8,
	e1000_pchlan = 9,
	e1000_pch2lan = 10,
	e1000_pch_lpt = 11,
	e1000_pch_spt = 12,
	e1000_pch_cnp = 13,
	e1000_pch_tgp = 14,
	e1000_pch_adp = 15,
	e1000_pch_mtp = 16,
	e1000_pch_lnp = 17,
	e1000_pch_ptp = 18,
	e1000_pch_nvp = 19,
};

enum e1000_mac_type___2 {
	e1000_undefined___2 = 0,
	e1000_82575 = 1,
	e1000_82576 = 2,
	e1000_82580 = 3,
	e1000_i350 = 4,
	e1000_i354 = 5,
	e1000_i210 = 6,
	e1000_i211 = 7,
	e1000_num_macs___2 = 8,
};

enum e1000_media_type {
	e1000_media_type_unknown = 0,
	e1000_media_type_copper___2 = 1,
	e1000_media_type_fiber___2 = 2,
	e1000_media_type_internal_serdes___2 = 3,
	e1000_num_media_types___2 = 4,
};

enum e1000_mng_mode {
	e1000_mng_mode_none = 0,
	e1000_mng_mode_asf = 1,
	e1000_mng_mode_pt = 2,
	e1000_mng_mode_ipmi = 3,
	e1000_mng_mode_host_if_only = 4,
};

enum e1000_ms_type {
	e1000_ms_hw_default___2 = 0,
	e1000_ms_force_master___2 = 1,
	e1000_ms_force_slave___2 = 2,
	e1000_ms_auto___2 = 3,
};

enum e1000_nvm_override {
	e1000_nvm_override_none = 0,
	e1000_nvm_override_spi_small = 1,
	e1000_nvm_override_spi_large = 2,
};

enum e1000_nvm_type {
	e1000_nvm_unknown = 0,
	e1000_nvm_none = 1,
	e1000_nvm_eeprom_spi = 2,
	e1000_nvm_flash_hw = 3,
	e1000_nvm_invm = 4,
	e1000_nvm_flash_sw = 5,
};

enum e1000_nvm_type___2 {
	e1000_nvm_unknown___2 = 0,
	e1000_nvm_none___2 = 1,
	e1000_nvm_eeprom_spi___2 = 2,
	e1000_nvm_flash_hw___2 = 3,
	e1000_nvm_flash_sw___2 = 4,
};

enum e1000_phy_type {
	e1000_phy_unknown = 0,
	e1000_phy_none = 1,
	e1000_phy_m88___2 = 2,
	e1000_phy_igp___2 = 3,
	e1000_phy_igp_2 = 4,
	e1000_phy_gg82563 = 5,
	e1000_phy_igp_3 = 6,
	e1000_phy_ife = 7,
	e1000_phy_bm = 8,
	e1000_phy_82578 = 9,
	e1000_phy_82577 = 10,
	e1000_phy_82579 = 11,
	e1000_phy_i217 = 12,
};

enum e1000_phy_type___2 {
	e1000_phy_unknown___2 = 0,
	e1000_phy_none___2 = 1,
	e1000_phy_m88___3 = 2,
	e1000_phy_igp___3 = 3,
	e1000_phy_igp_2___2 = 4,
	e1000_phy_gg82563___2 = 5,
	e1000_phy_igp_3___2 = 6,
	e1000_phy_ife___2 = 7,
	e1000_phy_82580 = 8,
	e1000_phy_i210 = 9,
	e1000_phy_bcm54616 = 10,
};

enum e1000_rev_polarity {
	e1000_rev_polarity_normal___2 = 0,
	e1000_rev_polarity_reversed___2 = 1,
	e1000_rev_polarity_undefined___2 = 255,
};

enum e1000_ring_flags_t {
	IGB_RING_FLAG_RX_3K_BUFFER = 0,
	IGB_RING_FLAG_RX_BUILD_SKB_ENABLED = 1,
	IGB_RING_FLAG_RX_SCTP_CSUM = 2,
	IGB_RING_FLAG_RX_LB_VLAN_BSWAP = 3,
	IGB_RING_FLAG_TX_CTX_IDX = 4,
	IGB_RING_FLAG_TX_DETECT_HANG = 5,
	IGB_RING_FLAG_TX_DISABLED = 6,
};

enum e1000_serdes_link_state {
	e1000_serdes_link_down = 0,
	e1000_serdes_link_autoneg_progress = 1,
	e1000_serdes_link_autoneg_complete = 2,
	e1000_serdes_link_forced_up = 3,
};

enum e1000_smart_speed {
	e1000_smart_speed_default___2 = 0,
	e1000_smart_speed_on___2 = 1,
	e1000_smart_speed_off___2 = 2,
};

enum e1000_state_t {
	__E1000_TESTING = 0,
	__E1000_RESETTING = 1,
	__E1000_ACCESS_SHARED_RESOURCE = 2,
	__E1000_DOWN = 3,
};

enum e1000_state_t___2 {
	__E1000_TESTING___2 = 0,
	__E1000_RESETTING___2 = 1,
	__E1000_DOWN___2 = 2,
	__E1000_DISABLED = 3,
};

enum e1000_state_t___3 {
	__IGB_TESTING = 0,
	__IGB_RESETTING = 1,
	__IGB_DOWN = 2,
	__IGB_PTP_TX_IN_PROGRESS = 3,
};

enum e1000_ulp_state {
	e1000_ulp_state_unknown = 0,
	e1000_ulp_state_off = 1,
	e1000_ulp_state_on = 2,
};

enum ec_command {
	ACPI_EC_COMMAND_READ = 128,
	ACPI_EC_COMMAND_WRITE = 129,
	ACPI_EC_BURST_ENABLE = 130,
	ACPI_EC_BURST_DISABLE = 131,
	ACPI_EC_COMMAND_QUERY = 132,
};

enum edid_block_status {
	EDID_BLOCK_OK = 0,
	EDID_BLOCK_READ_FAIL = 1,
	EDID_BLOCK_NULL = 2,
	EDID_BLOCK_ZERO = 3,
	EDID_BLOCK_HEADER_CORRUPT = 4,
	EDID_BLOCK_HEADER_REPAIR = 5,
	EDID_BLOCK_HEADER_FIXED = 6,
	EDID_BLOCK_CHECKSUM = 7,
	EDID_BLOCK_VERSION = 8,
};

enum efi_cmdline_option {
	EFI_CMDLINE_NONE = 0,
	EFI_CMDLINE_MODE_NUM = 1,
	EFI_CMDLINE_RES = 2,
	EFI_CMDLINE_AUTO = 3,
	EFI_CMDLINE_LIST = 4,
};

enum efi_rts_ids {
	EFI_NONE = 0,
	EFI_GET_TIME = 1,
	EFI_SET_TIME = 2,
	EFI_GET_WAKEUP_TIME = 3,
	EFI_SET_WAKEUP_TIME = 4,
	EFI_GET_VARIABLE = 5,
	EFI_GET_NEXT_VARIABLE = 6,
	EFI_SET_VARIABLE = 7,
	EFI_QUERY_VARIABLE_INFO = 8,
	EFI_GET_NEXT_HIGH_MONO_COUNT = 9,
	EFI_RESET_SYSTEM = 10,
	EFI_UPDATE_CAPSULE = 11,
	EFI_QUERY_CAPSULE_CAPS = 12,
	EFI_ACPI_PRM_HANDLER = 13,
};

enum efistub_event_type {
	EFISTUB_EVT_INITRD = 0,
	EFISTUB_EVT_LOAD_OPTIONS = 1,
	EFISTUB_EVT_COUNT = 2,
};

enum ehci_hrtimer_event {
	EHCI_HRTIMER_POLL_ASS = 0,
	EHCI_HRTIMER_POLL_PSS = 1,
	EHCI_HRTIMER_POLL_DEAD = 2,
	EHCI_HRTIMER_UNLINK_INTR = 3,
	EHCI_HRTIMER_FREE_ITDS = 4,
	EHCI_HRTIMER_ACTIVE_UNLINK = 5,
	EHCI_HRTIMER_START_UNLINK_INTR = 6,
	EHCI_HRTIMER_ASYNC_UNLINKS = 7,
	EHCI_HRTIMER_IAA_WATCHDOG = 8,
	EHCI_HRTIMER_DISABLE_PERIODIC = 9,
	EHCI_HRTIMER_DISABLE_ASYNC = 10,
	EHCI_HRTIMER_IO_WATCHDOG = 11,
	EHCI_HRTIMER_NUM_EVENTS = 12,
};

enum ehci_rh_state {
	EHCI_RH_HALTED = 0,
	EHCI_RH_SUSPENDED = 1,
	EHCI_RH_RUNNING = 2,
	EHCI_RH_STOPPING = 3,
};

enum eld_versions {
	ELD_VER_CEA_861D = 2,
	ELD_VER_PARTIAL = 31,
};

enum elv_merge {
	ELEVATOR_NO_MERGE = 0,
	ELEVATOR_FRONT_MERGE = 1,
	ELEVATOR_BACK_MERGE = 2,
	ELEVATOR_DISCARD_MERGE = 3,
};

enum em_mac_type {
	em_mac_type_unknown = 0,
	em_mac_type_mdi = 1,
	em_mac_type_rgmii = 2,
};

enum enable_type {
	undefined = -1,
	user_disabled = 0,
	auto_disabled = 1,
	user_enabled = 2,
	auto_enabled = 3,
};

enum environment_cap {
	ENVIRON_ANY = 0,
	ENVIRON_INDOOR = 1,
	ENVIRON_OUTDOOR = 2,
};

enum error_detector {
	ERROR_DETECTOR_KFENCE = 0,
	ERROR_DETECTOR_KASAN = 1,
	ERROR_DETECTOR_WARN = 2,
};

enum error_info_rec {
	CMD_ISS_STPD = 2147483648,
	CMD_PI_ERR = 1073741824,
	RSP_OVER = 536870912,
	RETRY_LIM = 268435456,
	UNK_FIS = 134217728,
	DMA_TERM = 67108864,
	SYNC_ERR = 33554432,
	TFILE_ERR = 16777216,
	R_ERR = 8388608,
	RD_OFS = 1048576,
	XFER_RDY_OFS = 524288,
	UNEXP_XFER_RDY = 262144,
	DATA_OVER_UNDER = 65536,
	INTERLOCK = 32768,
	NAK = 16384,
	ACK_NAK_TO = 8192,
	CXN_CLOSED = 4096,
	OPEN_TO = 2048,
	PATH_BLOCKED = 1024,
	NO_DEST = 512,
	STP_RES_BSY = 256,
	BREAK = 128,
	BAD_DEST = 64,
	BAD_PROTO = 32,
	BAD_RATE = 16,
	WRONG_DEST = 8,
	CREDIT_TO = 4,
	WDOG_TO = 2,
	BUF_PAR = 1,
};

enum ethnl_sock_type {
	ETHTOOL_SOCK_TYPE_MODULE_FW_FLASH = 0,
};

enum ethtool_c33_pse_admin_state {
	ETHTOOL_C33_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_C33_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_C33_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_c33_pse_ext_state {
	ETHTOOL_C33_PSE_EXT_STATE_ERROR_CONDITION = 1,
	ETHTOOL_C33_PSE_EXT_STATE_MR_MPS_VALID = 2,
	ETHTOOL_C33_PSE_EXT_STATE_MR_PSE_ENABLE = 3,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_DETECT_TED = 4,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_VPORT_LIM = 5,
	ETHTOOL_C33_PSE_EXT_STATE_OVLD_DETECTED = 6,
	ETHTOOL_C33_PSE_EXT_STATE_PD_DLL_POWER_TYPE = 7,
	ETHTOOL_C33_PSE_EXT_STATE_POWER_NOT_AVAILABLE = 8,
	ETHTOOL_C33_PSE_EXT_STATE_SHORT_DETECTED = 9,
};

enum ethtool_c33_pse_ext_substate_error_condition {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_NON_EXISTING_PORT = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNDEFINED_PORT = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_INTERNAL_HW_FAULT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_COMM_ERROR_AFTER_FORCE_ON = 4,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNKNOWN_PORT_STATUS = 5,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_TURN_OFF = 6,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_FORCE_SHUTDOWN = 7,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_CONFIG_CHANGE = 8,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_DETECTED_OVER_TEMP = 9,
};

enum ethtool_c33_pse_ext_substate_mr_pse_enable {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_MR_PSE_ENABLE_DISABLE_PIN_ACTIVE = 1,
};

enum ethtool_c33_pse_ext_substate_option_detect_ted {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_DET_IN_PROCESS = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_CONNECTION_CHECK_ERROR = 2,
};

enum ethtool_c33_pse_ext_substate_option_vport_lim {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_HIGH_VOLTAGE = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_LOW_VOLTAGE = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_VOLTAGE_INJECTION = 3,
};

enum ethtool_c33_pse_ext_substate_ovld_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OVLD_DETECTED_OVERLOAD = 1,
};

enum ethtool_c33_pse_ext_substate_power_not_available {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_BUDGET_EXCEEDED = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PORT_PW_LIMIT_EXCEEDS_CONTROLLER_BUDGET = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PD_REQUEST_EXCEEDS_PORT_LIMIT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_HW_PW_LIMIT = 4,
};

enum ethtool_c33_pse_ext_substate_short_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_SHORT_DETECTED_SHORT_CONDITION = 1,
};

enum ethtool_c33_pse_pw_d_status {
	ETHTOOL_C33_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_C33_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_C33_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_C33_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_C33_PSE_PW_D_STATUS_TEST = 5,
	ETHTOOL_C33_PSE_PW_D_STATUS_FAULT = 6,
	ETHTOOL_C33_PSE_PW_D_STATUS_OTHERFAULT = 7,
};

enum ethtool_cmis_cdb_cmd_id {
	ETHTOOL_CMIS_CDB_CMD_QUERY_STATUS = 0,
	ETHTOOL_CMIS_CDB_CMD_MODULE_FEATURES = 64,
	ETHTOOL_CMIS_CDB_CMD_FW_MANAGMENT_FEATURES = 65,
	ETHTOOL_CMIS_CDB_CMD_START_FW_DOWNLOAD = 257,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_LPL = 259,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_EPL = 260,
	ETHTOOL_CMIS_CDB_CMD_COMPLETE_FW_DOWNLOAD = 263,
	ETHTOOL_CMIS_CDB_CMD_RUN_FW_IMAGE = 265,
	ETHTOOL_CMIS_CDB_CMD_COMMIT_FW_IMAGE = 266,
};

enum ethtool_fec_config_bits {
	ETHTOOL_FEC_NONE_BIT = 0,
	ETHTOOL_FEC_AUTO_BIT = 1,
	ETHTOOL_FEC_OFF_BIT = 2,
	ETHTOOL_FEC_RS_BIT = 3,
	ETHTOOL_FEC_BASER_BIT = 4,
	ETHTOOL_FEC_LLRS_BIT = 5,
};

enum ethtool_flags {
	ETH_FLAG_TXVLAN = 128,
	ETH_FLAG_RXVLAN = 256,
	ETH_FLAG_LRO = 32768,
	ETH_FLAG_NTUPLE = 134217728,
	ETH_FLAG_RXHASH = 268435456,
};

enum ethtool_header_flags {
	ETHTOOL_FLAG_COMPACT_BITSETS = 1,
	ETHTOOL_FLAG_OMIT_REPLY = 2,
	ETHTOOL_FLAG_STATS = 4,
};

enum ethtool_link_ext_state {
	ETHTOOL_LINK_EXT_STATE_AUTONEG = 0,
	ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE = 1,
	ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH = 2,
	ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY = 3,
	ETHTOOL_LINK_EXT_STATE_NO_CABLE = 4,
	ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE = 5,
	ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE = 6,
	ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE = 7,
	ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED = 8,
	ETHTOOL_LINK_EXT_STATE_OVERHEAT = 9,
	ETHTOOL_LINK_EXT_STATE_MODULE = 10,
};

enum ethtool_link_ext_substate_autoneg {
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE = 5,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD = 6,
};

enum ethtool_link_ext_substate_bad_signal_integrity {
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_REFERENCE_CLOCK_LOST = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_ALOS = 4,
};

enum ethtool_link_ext_substate_cable_issue {
	ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE = 2,
};

enum ethtool_link_ext_substate_link_logical_mismatch {
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED = 5,
};

enum ethtool_link_ext_substate_link_training {
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT = 4,
};

enum ethtool_link_ext_substate_module {
	ETHTOOL_LINK_EXT_SUBSTATE_MODULE_CMIS_NOT_READY = 1,
};

enum ethtool_link_mode_bit_indices {
	ETHTOOL_LINK_MODE_10baseT_Half_BIT = 0,
	ETHTOOL_LINK_MODE_10baseT_Full_BIT = 1,
	ETHTOOL_LINK_MODE_100baseT_Half_BIT = 2,
	ETHTOOL_LINK_MODE_100baseT_Full_BIT = 3,
	ETHTOOL_LINK_MODE_1000baseT_Half_BIT = 4,
	ETHTOOL_LINK_MODE_1000baseT_Full_BIT = 5,
	ETHTOOL_LINK_MODE_Autoneg_BIT = 6,
	ETHTOOL_LINK_MODE_TP_BIT = 7,
	ETHTOOL_LINK_MODE_AUI_BIT = 8,
	ETHTOOL_LINK_MODE_MII_BIT = 9,
	ETHTOOL_LINK_MODE_FIBRE_BIT = 10,
	ETHTOOL_LINK_MODE_BNC_BIT = 11,
	ETHTOOL_LINK_MODE_10000baseT_Full_BIT = 12,
	ETHTOOL_LINK_MODE_Pause_BIT = 13,
	ETHTOOL_LINK_MODE_Asym_Pause_BIT = 14,
	ETHTOOL_LINK_MODE_2500baseX_Full_BIT = 15,
	ETHTOOL_LINK_MODE_Backplane_BIT = 16,
	ETHTOOL_LINK_MODE_1000baseKX_Full_BIT = 17,
	ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT = 18,
	ETHTOOL_LINK_MODE_10000baseKR_Full_BIT = 19,
	ETHTOOL_LINK_MODE_10000baseR_FEC_BIT = 20,
	ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT = 21,
	ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT = 22,
	ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT = 23,
	ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT = 24,
	ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT = 25,
	ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT = 26,
	ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT = 27,
	ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT = 28,
	ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT = 29,
	ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT = 30,
	ETHTOOL_LINK_MODE_25000baseCR_Full_BIT = 31,
	ETHTOOL_LINK_MODE_25000baseKR_Full_BIT = 32,
	ETHTOOL_LINK_MODE_25000baseSR_Full_BIT = 33,
	ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT = 34,
	ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT = 35,
	ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT = 36,
	ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT = 37,
	ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT = 38,
	ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT = 39,
	ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT = 40,
	ETHTOOL_LINK_MODE_1000baseX_Full_BIT = 41,
	ETHTOOL_LINK_MODE_10000baseCR_Full_BIT = 42,
	ETHTOOL_LINK_MODE_10000baseSR_Full_BIT = 43,
	ETHTOOL_LINK_MODE_10000baseLR_Full_BIT = 44,
	ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT = 45,
	ETHTOOL_LINK_MODE_10000baseER_Full_BIT = 46,
	ETHTOOL_LINK_MODE_2500baseT_Full_BIT = 47,
	ETHTOOL_LINK_MODE_5000baseT_Full_BIT = 48,
	ETHTOOL_LINK_MODE_FEC_NONE_BIT = 49,
	ETHTOOL_LINK_MODE_FEC_RS_BIT = 50,
	ETHTOOL_LINK_MODE_FEC_BASER_BIT = 51,
	ETHTOOL_LINK_MODE_50000baseKR_Full_BIT = 52,
	ETHTOOL_LINK_MODE_50000baseSR_Full_BIT = 53,
	ETHTOOL_LINK_MODE_50000baseCR_Full_BIT = 54,
	ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT = 55,
	ETHTOOL_LINK_MODE_50000baseDR_Full_BIT = 56,
	ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT = 57,
	ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT = 58,
	ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT = 59,
	ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT = 60,
	ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT = 61,
	ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT = 62,
	ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT = 63,
	ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT = 64,
	ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT = 65,
	ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT = 66,
	ETHTOOL_LINK_MODE_100baseT1_Full_BIT = 67,
	ETHTOOL_LINK_MODE_1000baseT1_Full_BIT = 68,
	ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT = 69,
	ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT = 70,
	ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT = 71,
	ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT = 72,
	ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT = 73,
	ETHTOOL_LINK_MODE_FEC_LLRS_BIT = 74,
	ETHTOOL_LINK_MODE_100000baseKR_Full_BIT = 75,
	ETHTOOL_LINK_MODE_100000baseSR_Full_BIT = 76,
	ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT = 77,
	ETHTOOL_LINK_MODE_100000baseCR_Full_BIT = 78,
	ETHTOOL_LINK_MODE_100000baseDR_Full_BIT = 79,
	ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT = 80,
	ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT = 81,
	ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT = 82,
	ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT = 83,
	ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT = 84,
	ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT = 85,
	ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT = 86,
	ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT = 87,
	ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT = 88,
	ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT = 89,
	ETHTOOL_LINK_MODE_100baseFX_Half_BIT = 90,
	ETHTOOL_LINK_MODE_100baseFX_Full_BIT = 91,
	ETHTOOL_LINK_MODE_10baseT1L_Full_BIT = 92,
	ETHTOOL_LINK_MODE_800000baseCR8_Full_BIT = 93,
	ETHTOOL_LINK_MODE_800000baseKR8_Full_BIT = 94,
	ETHTOOL_LINK_MODE_800000baseDR8_Full_BIT = 95,
	ETHTOOL_LINK_MODE_800000baseDR8_2_Full_BIT = 96,
	ETHTOOL_LINK_MODE_800000baseSR8_Full_BIT = 97,
	ETHTOOL_LINK_MODE_800000baseVR8_Full_BIT = 98,
	ETHTOOL_LINK_MODE_10baseT1S_Full_BIT = 99,
	ETHTOOL_LINK_MODE_10baseT1S_Half_BIT = 100,
	ETHTOOL_LINK_MODE_10baseT1S_P2MP_Half_BIT = 101,
	ETHTOOL_LINK_MODE_10baseT1BRR_Full_BIT = 102,
	__ETHTOOL_LINK_MODE_MASK_NBITS = 103,
};

enum ethtool_mac_stats_src {
	ETHTOOL_MAC_STATS_SRC_AGGREGATE = 0,
	ETHTOOL_MAC_STATS_SRC_EMAC = 1,
	ETHTOOL_MAC_STATS_SRC_PMAC = 2,
};

enum ethtool_mm_verify_status {
	ETHTOOL_MM_VERIFY_STATUS_UNKNOWN = 0,
	ETHTOOL_MM_VERIFY_STATUS_INITIAL = 1,
	ETHTOOL_MM_VERIFY_STATUS_VERIFYING = 2,
	ETHTOOL_MM_VERIFY_STATUS_SUCCEEDED = 3,
	ETHTOOL_MM_VERIFY_STATUS_FAILED = 4,
	ETHTOOL_MM_VERIFY_STATUS_DISABLED = 5,
};

enum ethtool_module_fw_flash_status {
	ETHTOOL_MODULE_FW_FLASH_STATUS_STARTED = 1,
	ETHTOOL_MODULE_FW_FLASH_STATUS_IN_PROGRESS = 2,
	ETHTOOL_MODULE_FW_FLASH_STATUS_COMPLETED = 3,
	ETHTOOL_MODULE_FW_FLASH_STATUS_ERROR = 4,
};

enum ethtool_module_power_mode {
	ETHTOOL_MODULE_POWER_MODE_LOW = 1,
	ETHTOOL_MODULE_POWER_MODE_HIGH = 2,
};

enum ethtool_module_power_mode_policy {
	ETHTOOL_MODULE_POWER_MODE_POLICY_HIGH = 1,
	ETHTOOL_MODULE_POWER_MODE_POLICY_AUTO = 2,
};

enum ethtool_multicast_groups {
	ETHNL_MCGRP_MONITOR = 0,
};

enum ethtool_phys_id_state {
	ETHTOOL_ID_INACTIVE = 0,
	ETHTOOL_ID_ACTIVE = 1,
	ETHTOOL_ID_ON = 2,
	ETHTOOL_ID_OFF = 3,
};

enum ethtool_podl_pse_admin_state {
	ETHTOOL_PODL_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_PODL_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_podl_pse_pw_d_status {
	ETHTOOL_PODL_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SLEEP = 5,
	ETHTOOL_PODL_PSE_PW_D_STATUS_IDLE = 6,
	ETHTOOL_PODL_PSE_PW_D_STATUS_ERROR = 7,
};

enum ethtool_reset_flags {
	ETH_RESET_MGMT = 1,
	ETH_RESET_IRQ = 2,
	ETH_RESET_DMA = 4,
	ETH_RESET_FILTER = 8,
	ETH_RESET_OFFLOAD = 16,
	ETH_RESET_MAC = 32,
	ETH_RESET_PHY = 64,
	ETH_RESET_RAM = 128,
	ETH_RESET_AP = 256,
	ETH_RESET_DEDICATED = 65535,
	ETH_RESET_ALL = 4294967295,
};

enum ethtool_sfeatures_retval_bits {
	ETHTOOL_F_UNSUPPORTED__BIT = 0,
	ETHTOOL_F_WISH__BIT = 1,
	ETHTOOL_F_COMPAT__BIT = 2,
};

enum ethtool_stringset {
	ETH_SS_TEST = 0,
	ETH_SS_STATS = 1,
	ETH_SS_PRIV_FLAGS = 2,
	ETH_SS_NTUPLE_FILTERS = 3,
	ETH_SS_FEATURES = 4,
	ETH_SS_RSS_HASH_FUNCS = 5,
	ETH_SS_TUNABLES = 6,
	ETH_SS_PHY_STATS = 7,
	ETH_SS_PHY_TUNABLES = 8,
	ETH_SS_LINK_MODES = 9,
	ETH_SS_MSG_CLASSES = 10,
	ETH_SS_WOL_MODES = 11,
	ETH_SS_SOF_TIMESTAMPING = 12,
	ETH_SS_TS_TX_TYPES = 13,
	ETH_SS_TS_RX_FILTERS = 14,
	ETH_SS_UDP_TUNNEL_TYPES = 15,
	ETH_SS_STATS_STD = 16,
	ETH_SS_STATS_ETH_PHY = 17,
	ETH_SS_STATS_ETH_MAC = 18,
	ETH_SS_STATS_ETH_CTRL = 19,
	ETH_SS_STATS_RMON = 20,
	ETH_SS_STATS_PHY = 21,
	ETH_SS_TS_FLAGS = 22,
	ETH_SS_COUNT = 23,
};

enum ethtool_supported_ring_param {
	ETHTOOL_RING_USE_RX_BUF_LEN = 1,
	ETHTOOL_RING_USE_CQE_SIZE = 2,
	ETHTOOL_RING_USE_TX_PUSH = 4,
	ETHTOOL_RING_USE_RX_PUSH = 8,
	ETHTOOL_RING_USE_TX_PUSH_BUF_LEN = 16,
	ETHTOOL_RING_USE_TCP_DATA_SPLIT = 32,
	ETHTOOL_RING_USE_HDS_THRS = 64,
};

enum ethtool_tcp_data_split {
	ETHTOOL_TCP_DATA_SPLIT_UNKNOWN = 0,
	ETHTOOL_TCP_DATA_SPLIT_DISABLED = 1,
	ETHTOOL_TCP_DATA_SPLIT_ENABLED = 2,
};

enum ethtool_test_flags {
	ETH_TEST_FL_OFFLINE = 1,
	ETH_TEST_FL_FAILED = 2,
	ETH_TEST_FL_EXTERNAL_LB = 4,
	ETH_TEST_FL_EXTERNAL_LB_DONE = 8,
};

enum event_command_flags {
	EVENT_CMD_FL_POST_TRIGGER = 1,
	EVENT_CMD_FL_NEEDS_REC = 2,
};

enum event_trigger_type {
	ETT_NONE = 0,
	ETT_TRACE_ONOFF = 1,
	ETT_SNAPSHOT = 2,
	ETT_STACKTRACE = 4,
	ETT_EVENT_ENABLE = 8,
	ETT_EVENT_HIST = 16,
	ETT_HIST_ENABLE = 32,
	ETT_EVENT_EPROBE = 64,
};

enum event_type_t {
	EVENT_FLEXIBLE = 1,
	EVENT_PINNED = 2,
	EVENT_TIME = 4,
	EVENT_FROZEN = 8,
	EVENT_CPU = 16,
	EVENT_CGROUP = 32,
	EVENT_ALL = 3,
	EVENT_TIME_FROZEN = 12,
};

enum ex_phy_state {
	PHY_EMPTY = 0,
	PHY_VACANT = 1,
	PHY_NOT_PRESENT = 2,
	PHY_DEVICE_DISCOVERED = 3,
};

enum exact_level {
	NOT_EXACT = 0,
	EXACT = 1,
	RANGE_WITHIN = 2,
};

enum exec_status {
	SAS_SAM_STAT_GOOD = 0,
	SAS_SAM_STAT_BUSY = 8,
	SAS_SAM_STAT_TASK_ABORTED = 64,
	SAS_SAM_STAT_CHECK_CONDITION = 2,
	SAS_DEV_NO_RESPONSE = 128,
	SAS_DATA_UNDERRUN = 129,
	SAS_DATA_OVERRUN = 130,
	SAS_INTERRUPTED = 131,
	SAS_QUEUE_FULL = 132,
	SAS_DEVICE_UNKNOWN = 133,
	SAS_OPEN_REJECT = 134,
	SAS_OPEN_TO = 135,
	SAS_PROTO_RESPONSE = 136,
	SAS_PHY_DOWN = 137,
	SAS_NAK_R_ERR = 138,
	SAS_PENDING = 139,
	SAS_ABORTED_TASK = 140,
};

enum execmem_range_flags {
	EXECMEM_KASAN_SHADOW = 1,
	EXECMEM_ROX_CACHE = 2,
};

enum execmem_type {
	EXECMEM_DEFAULT = 0,
	EXECMEM_MODULE_TEXT = 0,
	EXECMEM_KPROBES = 1,
	EXECMEM_FTRACE = 2,
	EXECMEM_BPF = 3,
	EXECMEM_MODULE_DATA = 4,
	EXECMEM_TYPE_MAX = 5,
};

enum ext4_journal_trigger_type {
	EXT4_JTR_ORPHAN_FILE = 0,
	EXT4_JTR_NONE = 1,
};

enum ext4_li_mode {
	EXT4_LI_MODE_PREFETCH_BBITMAP = 0,
	EXT4_LI_MODE_ITABLE = 1,
};

enum fail_dup_mod_reason {
	FAIL_DUP_MOD_BECOMING = 0,
	FAIL_DUP_MOD_LOAD = 1,
};

enum fanotify_event_type {
	FANOTIFY_EVENT_TYPE_FID = 0,
	FANOTIFY_EVENT_TYPE_FID_NAME = 1,
	FANOTIFY_EVENT_TYPE_PATH = 2,
	FANOTIFY_EVENT_TYPE_PATH_PERM = 3,
	FANOTIFY_EVENT_TYPE_OVERFLOW = 4,
	FANOTIFY_EVENT_TYPE_FS_ERROR = 5,
	__FANOTIFY_EVENT_TYPE_NUM = 6,
};

enum fault_flag {
	FAULT_FLAG_WRITE = 1,
	FAULT_FLAG_MKWRITE = 2,
	FAULT_FLAG_ALLOW_RETRY = 4,
	FAULT_FLAG_RETRY_NOWAIT = 8,
	FAULT_FLAG_KILLABLE = 16,
	FAULT_FLAG_TRIED = 32,
	FAULT_FLAG_USER = 64,
	FAULT_FLAG_REMOTE = 128,
	FAULT_FLAG_INSTRUCTION = 256,
	FAULT_FLAG_INTERRUPTIBLE = 512,
	FAULT_FLAG_UNSHARE = 1024,
	FAULT_FLAG_ORIG_PTE_VALID = 2048,
	FAULT_FLAG_VMA_LOCK = 4096,
};

enum fbq_type {
	regular = 0,
	remote = 1,
	all = 2,
};

enum fc_eof {
	FC_EOF_N = 65,
	FC_EOF_T = 66,
	FC_EOF_RT = 68,
	FC_EOF_DT = 70,
	FC_EOF_NI = 73,
	FC_EOF_DTI = 78,
	FC_EOF_RTI = 79,
	FC_EOF_A = 80,
} __attribute__((mode(byte)));

enum fc_rctl {
	FC_RCTL_DD_UNCAT = 0,
	FC_RCTL_DD_SOL_DATA = 1,
	FC_RCTL_DD_UNSOL_CTL = 2,
	FC_RCTL_DD_SOL_CTL = 3,
	FC_RCTL_DD_UNSOL_DATA = 4,
	FC_RCTL_DD_DATA_DESC = 5,
	FC_RCTL_DD_UNSOL_CMD = 6,
	FC_RCTL_DD_CMD_STATUS = 7,
	FC_RCTL_ELS_REQ = 34,
	FC_RCTL_ELS_REP = 35,
	FC_RCTL_ELS4_REQ = 50,
	FC_RCTL_ELS4_REP = 51,
	FC_RCTL_VFTH = 80,
	FC_RCTL_IFRH = 81,
	FC_RCTL_ENCH = 82,
	FC_RCTL_BA_NOP = 128,
	FC_RCTL_BA_ABTS = 129,
	FC_RCTL_BA_RMC = 130,
	FC_RCTL_BA_ACC = 132,
	FC_RCTL_BA_RJT = 133,
	FC_RCTL_BA_PRMT = 134,
	FC_RCTL_ACK_1 = 192,
	FC_RCTL_ACK_0 = 193,
	FC_RCTL_P_RJT = 194,
	FC_RCTL_F_RJT = 195,
	FC_RCTL_P_BSY = 196,
	FC_RCTL_F_BSY = 197,
	FC_RCTL_F_BSYL = 198,
	FC_RCTL_LCR = 199,
	FC_RCTL_END = 201,
};

enum fc_sof {
	FC_SOF_F = 40,
	FC_SOF_I4 = 41,
	FC_SOF_I2 = 45,
	FC_SOF_I3 = 46,
	FC_SOF_N4 = 49,
	FC_SOF_N2 = 53,
	FC_SOF_N3 = 54,
	FC_SOF_C4 = 57,
} __attribute__((mode(byte)));

enum fetch_op {
	FETCH_OP_NOP = 0,
	FETCH_OP_REG = 1,
	FETCH_OP_STACK = 2,
	FETCH_OP_STACKP = 3,
	FETCH_OP_RETVAL = 4,
	FETCH_OP_IMM = 5,
	FETCH_OP_COMM = 6,
	FETCH_OP_ARG = 7,
	FETCH_OP_FOFFS = 8,
	FETCH_OP_DATA = 9,
	FETCH_OP_EDATA = 10,
	FETCH_OP_DEREF = 11,
	FETCH_OP_UDEREF = 12,
	FETCH_OP_ST_RAW = 13,
	FETCH_OP_ST_MEM = 14,
	FETCH_OP_ST_UMEM = 15,
	FETCH_OP_ST_STRING = 16,
	FETCH_OP_ST_USTRING = 17,
	FETCH_OP_ST_SYMSTR = 18,
	FETCH_OP_ST_EDATA = 19,
	FETCH_OP_MOD_BF = 20,
	FETCH_OP_LP_ARRAY = 21,
	FETCH_OP_TP_ARG = 22,
	FETCH_OP_END = 23,
	FETCH_NOP_SYMBOL = 24,
};

enum fib6_walk_state {
	FWS_L = 0,
	FWS_R = 1,
	FWS_C = 2,
	FWS_U = 3,
};

enum fib_event_type {
	FIB_EVENT_ENTRY_REPLACE = 0,
	FIB_EVENT_ENTRY_APPEND = 1,
	FIB_EVENT_ENTRY_ADD = 2,
	FIB_EVENT_ENTRY_DEL = 3,
	FIB_EVENT_RULE_ADD = 4,
	FIB_EVENT_RULE_DEL = 5,
	FIB_EVENT_NH_ADD = 6,
	FIB_EVENT_NH_DEL = 7,
	FIB_EVENT_VIF_ADD = 8,
	FIB_EVENT_VIF_DEL = 9,
};

enum fid_type {
	FILEID_ROOT = 0,
	FILEID_INO32_GEN = 1,
	FILEID_INO32_GEN_PARENT = 2,
	FILEID_BTRFS_WITHOUT_PARENT = 77,
	FILEID_BTRFS_WITH_PARENT = 78,
	FILEID_BTRFS_WITH_PARENT_ROOT = 79,
	FILEID_UDF_WITHOUT_PARENT = 81,
	FILEID_UDF_WITH_PARENT = 82,
	FILEID_NILFS_WITHOUT_PARENT = 97,
	FILEID_NILFS_WITH_PARENT = 98,
	FILEID_FAT_WITHOUT_PARENT = 113,
	FILEID_FAT_WITH_PARENT = 114,
	FILEID_INO64_GEN = 129,
	FILEID_INO64_GEN_PARENT = 130,
	FILEID_LUSTRE = 151,
	FILEID_BCACHEFS_WITHOUT_PARENT = 177,
	FILEID_BCACHEFS_WITH_PARENT = 178,
	FILEID_KERNFS = 254,
	FILEID_INVALID = 255,
};

enum file_time_flags {
	S_ATIME = 1,
	S_MTIME = 2,
	S_CTIME = 4,
	S_VERSION = 8,
};

enum filter_op_ids {
	OP_GLOB = 0,
	OP_NE = 1,
	OP_EQ = 2,
	OP_LE = 3,
	OP_LT = 4,
	OP_GE = 5,
	OP_GT = 6,
	OP_BAND = 7,
	OP_MAX = 8,
};

enum filter_pred_fn {
	FILTER_PRED_FN_NOP = 0,
	FILTER_PRED_FN_64 = 1,
	FILTER_PRED_FN_64_CPUMASK = 2,
	FILTER_PRED_FN_S64 = 3,
	FILTER_PRED_FN_U64 = 4,
	FILTER_PRED_FN_32 = 5,
	FILTER_PRED_FN_32_CPUMASK = 6,
	FILTER_PRED_FN_S32 = 7,
	FILTER_PRED_FN_U32 = 8,
	FILTER_PRED_FN_16 = 9,
	FILTER_PRED_FN_16_CPUMASK = 10,
	FILTER_PRED_FN_S16 = 11,
	FILTER_PRED_FN_U16 = 12,
	FILTER_PRED_FN_8 = 13,
	FILTER_PRED_FN_8_CPUMASK = 14,
	FILTER_PRED_FN_S8 = 15,
	FILTER_PRED_FN_U8 = 16,
	FILTER_PRED_FN_COMM = 17,
	FILTER_PRED_FN_STRING = 18,
	FILTER_PRED_FN_STRLOC = 19,
	FILTER_PRED_FN_STRRELLOC = 20,
	FILTER_PRED_FN_PCHAR_USER = 21,
	FILTER_PRED_FN_PCHAR = 22,
	FILTER_PRED_FN_CPU = 23,
	FILTER_PRED_FN_CPU_CPUMASK = 24,
	FILTER_PRED_FN_CPUMASK = 25,
	FILTER_PRED_FN_CPUMASK_CPU = 26,
	FILTER_PRED_FN_FUNCTION = 27,
	FILTER_PRED_FN_ = 28,
	FILTER_PRED_TEST_VISITED = 29,
};

enum finalization_type {
	FINALIZATION_TYPE_FINAL = 0,
	FINALIZATION_TYPE_FINUP = 1,
	FINALIZATION_TYPE_DIGEST = 2,
};

enum fit_type {
	NOTHING_FIT = 0,
	FL_FIT_TYPE = 1,
	LE_FIT_TYPE = 2,
	RE_FIT_TYPE = 3,
	NE_FIT_TYPE = 4,
};

enum fixed_addresses {
	FIX_HOLE = 0,
	FIX_EARLYCON_MEM_BASE = 1,
	__end_of_fixed_addresses = 2,
};

enum flow_action_hw_stats {
	FLOW_ACTION_HW_STATS_IMMEDIATE = 1,
	FLOW_ACTION_HW_STATS_DELAYED = 2,
	FLOW_ACTION_HW_STATS_ANY = 3,
	FLOW_ACTION_HW_STATS_DISABLED = 4,
	FLOW_ACTION_HW_STATS_DONT_CARE = 7,
};

enum flow_action_hw_stats_bit {
	FLOW_ACTION_HW_STATS_IMMEDIATE_BIT = 0,
	FLOW_ACTION_HW_STATS_DELAYED_BIT = 1,
	FLOW_ACTION_HW_STATS_DISABLED_BIT = 2,
	FLOW_ACTION_HW_STATS_NUM_BITS = 3,
};

enum flow_action_id {
	FLOW_ACTION_ACCEPT = 0,
	FLOW_ACTION_DROP = 1,
	FLOW_ACTION_TRAP = 2,
	FLOW_ACTION_GOTO = 3,
	FLOW_ACTION_REDIRECT = 4,
	FLOW_ACTION_MIRRED = 5,
	FLOW_ACTION_REDIRECT_INGRESS = 6,
	FLOW_ACTION_MIRRED_INGRESS = 7,
	FLOW_ACTION_VLAN_PUSH = 8,
	FLOW_ACTION_VLAN_POP = 9,
	FLOW_ACTION_VLAN_MANGLE = 10,
	FLOW_ACTION_TUNNEL_ENCAP = 11,
	FLOW_ACTION_TUNNEL_DECAP = 12,
	FLOW_ACTION_MANGLE = 13,
	FLOW_ACTION_ADD = 14,
	FLOW_ACTION_CSUM = 15,
	FLOW_ACTION_MARK = 16,
	FLOW_ACTION_PTYPE = 17,
	FLOW_ACTION_PRIORITY = 18,
	FLOW_ACTION_RX_QUEUE_MAPPING = 19,
	FLOW_ACTION_WAKE = 20,
	FLOW_ACTION_QUEUE = 21,
	FLOW_ACTION_SAMPLE = 22,
	FLOW_ACTION_POLICE = 23,
	FLOW_ACTION_CT = 24,
	FLOW_ACTION_CT_METADATA = 25,
	FLOW_ACTION_MPLS_PUSH = 26,
	FLOW_ACTION_MPLS_POP = 27,
	FLOW_ACTION_MPLS_MANGLE = 28,
	FLOW_ACTION_GATE = 29,
	FLOW_ACTION_PPPOE_PUSH = 30,
	FLOW_ACTION_JUMP = 31,
	FLOW_ACTION_PIPE = 32,
	FLOW_ACTION_VLAN_PUSH_ETH = 33,
	FLOW_ACTION_VLAN_POP_ETH = 34,
	FLOW_ACTION_CONTINUE = 35,
	NUM_FLOW_ACTIONS = 36,
};

enum flow_action_mangle_base {
	FLOW_ACT_MANGLE_UNSPEC = 0,
	FLOW_ACT_MANGLE_HDR_TYPE_ETH = 1,
	FLOW_ACT_MANGLE_HDR_TYPE_IP4 = 2,
	FLOW_ACT_MANGLE_HDR_TYPE_IP6 = 3,
	FLOW_ACT_MANGLE_HDR_TYPE_TCP = 4,
	FLOW_ACT_MANGLE_HDR_TYPE_UDP = 5,
};

enum flow_block_binder_type {
	FLOW_BLOCK_BINDER_TYPE_UNSPEC = 0,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_INGRESS = 1,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_EGRESS = 2,
	FLOW_BLOCK_BINDER_TYPE_RED_EARLY_DROP = 3,
	FLOW_BLOCK_BINDER_TYPE_RED_MARK = 4,
};

enum flow_block_command {
	FLOW_BLOCK_BIND = 0,
	FLOW_BLOCK_UNBIND = 1,
};

enum flow_cls_command {
	FLOW_CLS_REPLACE = 0,
	FLOW_CLS_DESTROY = 1,
	FLOW_CLS_STATS = 2,
	FLOW_CLS_TMPLT_CREATE = 3,
	FLOW_CLS_TMPLT_DESTROY = 4,
};

enum flow_dissect_ret {
	FLOW_DISSECT_RET_OUT_GOOD = 0,
	FLOW_DISSECT_RET_OUT_BAD = 1,
	FLOW_DISSECT_RET_PROTO_AGAIN = 2,
	FLOW_DISSECT_RET_IPPROTO_AGAIN = 3,
	FLOW_DISSECT_RET_CONTINUE = 4,
};

enum flow_dissector_ctrl_flags {
	FLOW_DIS_IS_FRAGMENT = 1,
	FLOW_DIS_FIRST_FRAG = 2,
	FLOW_DIS_F_TUNNEL_CSUM = 4,
	FLOW_DIS_F_TUNNEL_DONT_FRAGMENT = 8,
	FLOW_DIS_F_TUNNEL_OAM = 16,
	FLOW_DIS_F_TUNNEL_CRIT_OPT = 32,
	FLOW_DIS_ENCAPSULATION = 64,
};

enum flow_dissector_key_id {
	FLOW_DISSECTOR_KEY_CONTROL = 0,
	FLOW_DISSECTOR_KEY_BASIC = 1,
	FLOW_DISSECTOR_KEY_IPV4_ADDRS = 2,
	FLOW_DISSECTOR_KEY_IPV6_ADDRS = 3,
	FLOW_DISSECTOR_KEY_PORTS = 4,
	FLOW_DISSECTOR_KEY_PORTS_RANGE = 5,
	FLOW_DISSECTOR_KEY_ICMP = 6,
	FLOW_DISSECTOR_KEY_ETH_ADDRS = 7,
	FLOW_DISSECTOR_KEY_TIPC = 8,
	FLOW_DISSECTOR_KEY_ARP = 9,
	FLOW_DISSECTOR_KEY_VLAN = 10,
	FLOW_DISSECTOR_KEY_FLOW_LABEL = 11,
	FLOW_DISSECTOR_KEY_GRE_KEYID = 12,
	FLOW_DISSECTOR_KEY_MPLS_ENTROPY = 13,
	FLOW_DISSECTOR_KEY_ENC_KEYID = 14,
	FLOW_DISSECTOR_KEY_ENC_IPV4_ADDRS = 15,
	FLOW_DISSECTOR_KEY_ENC_IPV6_ADDRS = 16,
	FLOW_DISSECTOR_KEY_ENC_CONTROL = 17,
	FLOW_DISSECTOR_KEY_ENC_PORTS = 18,
	FLOW_DISSECTOR_KEY_MPLS = 19,
	FLOW_DISSECTOR_KEY_TCP = 20,
	FLOW_DISSECTOR_KEY_IP = 21,
	FLOW_DISSECTOR_KEY_CVLAN = 22,
	FLOW_DISSECTOR_KEY_ENC_IP = 23,
	FLOW_DISSECTOR_KEY_ENC_OPTS = 24,
	FLOW_DISSECTOR_KEY_META = 25,
	FLOW_DISSECTOR_KEY_CT = 26,
	FLOW_DISSECTOR_KEY_HASH = 27,
	FLOW_DISSECTOR_KEY_NUM_OF_VLANS = 28,
	FLOW_DISSECTOR_KEY_PPPOE = 29,
	FLOW_DISSECTOR_KEY_L2TPV3 = 30,
	FLOW_DISSECTOR_KEY_CFM = 31,
	FLOW_DISSECTOR_KEY_IPSEC = 32,
	FLOW_DISSECTOR_KEY_MAX = 33,
};

enum flowlabel_reflect {
	FLOWLABEL_REFLECT_ESTABLISHED = 1,
	FLOWLABEL_REFLECT_TCP_RESET = 2,
	FLOWLABEL_REFLECT_ICMPV6_ECHO_REPLIES = 4,
};

enum flush_type {
	FLUSH_TYPE_NONE = 0,
	FLUSH_TYPE_FLUSH = 1,
	FLUSH_TYPE_REIMPORT = 2,
};

enum folio_references {
	FOLIOREF_RECLAIM = 0,
	FOLIOREF_RECLAIM_CLEAN = 1,
	FOLIOREF_KEEP = 2,
	FOLIOREF_ACTIVATE = 3,
};

enum folio_walk_level {
	FW_LEVEL_PTE = 0,
	FW_LEVEL_PMD = 1,
	FW_LEVEL_PUD = 2,
};

enum format_state {
	FORMAT_STATE_NONE = 0,
	FORMAT_STATE_NUM = 1,
	FORMAT_STATE_WIDTH = 2,
	FORMAT_STATE_PRECISION = 3,
	FORMAT_STATE_CHAR = 4,
	FORMAT_STATE_STR = 5,
	FORMAT_STATE_PTR = 6,
	FORMAT_STATE_PERCENT_CHAR = 7,
	FORMAT_STATE_INVALID = 8,
};

enum freeze_holder {
	FREEZE_HOLDER_KERNEL = 1,
	FREEZE_HOLDER_USERSPACE = 2,
	FREEZE_MAY_NEST = 4,
};

enum freezer_state_flags {
	CGROUP_FREEZER_ONLINE = 1,
	CGROUP_FREEZING_SELF = 2,
	CGROUP_FREEZING_PARENT = 4,
	CGROUP_FROZEN = 8,
	CGROUP_FREEZING = 6,
};

enum freq_qos_req_type {
	FREQ_QOS_MIN = 1,
	FREQ_QOS_MAX = 2,
};

enum fs_context_phase {
	FS_CONTEXT_CREATE_PARAMS = 0,
	FS_CONTEXT_CREATING = 1,
	FS_CONTEXT_AWAITING_MOUNT = 2,
	FS_CONTEXT_AWAITING_RECONF = 3,
	FS_CONTEXT_RECONF_PARAMS = 4,
	FS_CONTEXT_RECONFIGURING = 5,
	FS_CONTEXT_FAILED = 6,
};

enum fs_context_purpose {
	FS_CONTEXT_FOR_MOUNT = 0,
	FS_CONTEXT_FOR_SUBMOUNT = 1,
	FS_CONTEXT_FOR_RECONFIGURE = 2,
};

enum fs_value_type {
	fs_value_is_undefined = 0,
	fs_value_is_flag = 1,
	fs_value_is_string = 2,
	fs_value_is_blob = 3,
	fs_value_is_filename = 4,
	fs_value_is_file = 5,
};

enum fscache_access_trace {
	fscache_access_acquire_volume = 0,
	fscache_access_acquire_volume_end = 1,
	fscache_access_cache_pin = 2,
	fscache_access_cache_unpin = 3,
	fscache_access_invalidate_cookie = 4,
	fscache_access_invalidate_cookie_end = 5,
	fscache_access_io_end = 6,
	fscache_access_io_not_live = 7,
	fscache_access_io_read = 8,
	fscache_access_io_resize = 9,
	fscache_access_io_wait = 10,
	fscache_access_io_write = 11,
	fscache_access_lookup_cookie = 12,
	fscache_access_lookup_cookie_end = 13,
	fscache_access_lookup_cookie_end_failed = 14,
	fscache_access_relinquish_volume = 15,
	fscache_access_relinquish_volume_end = 16,
	fscache_access_unlive = 17,
};

enum fscache_active_trace {
	fscache_active_use = 0,
	fscache_active_use_modify = 1,
	fscache_active_unuse = 2,
};

enum fscache_cache_state {
	FSCACHE_CACHE_IS_NOT_PRESENT = 0,
	FSCACHE_CACHE_IS_PREPARING = 1,
	FSCACHE_CACHE_IS_ACTIVE = 2,
	FSCACHE_CACHE_GOT_IOERROR = 3,
	FSCACHE_CACHE_IS_WITHDRAWN = 4,
};

enum fscache_cache_trace {
	fscache_cache_collision = 0,
	fscache_cache_get_acquire = 1,
	fscache_cache_new_acquire = 2,
	fscache_cache_put_alloc_volume = 3,
	fscache_cache_put_cache = 4,
	fscache_cache_put_prep_failed = 5,
	fscache_cache_put_relinquish = 6,
	fscache_cache_put_volume = 7,
};

enum fscache_cookie_state {
	FSCACHE_COOKIE_STATE_QUIESCENT = 0,
	FSCACHE_COOKIE_STATE_LOOKING_UP = 1,
	FSCACHE_COOKIE_STATE_CREATING = 2,
	FSCACHE_COOKIE_STATE_ACTIVE = 3,
	FSCACHE_COOKIE_STATE_INVALIDATING = 4,
	FSCACHE_COOKIE_STATE_FAILED = 5,
	FSCACHE_COOKIE_STATE_LRU_DISCARDING = 6,
	FSCACHE_COOKIE_STATE_WITHDRAWING = 7,
	FSCACHE_COOKIE_STATE_RELINQUISHING = 8,
	FSCACHE_COOKIE_STATE_DROPPED = 9,
} __attribute__((mode(byte)));

enum fscache_cookie_trace {
	fscache_cookie_collision = 0,
	fscache_cookie_discard = 1,
	fscache_cookie_failed = 2,
	fscache_cookie_get_attach_object = 3,
	fscache_cookie_get_end_access = 4,
	fscache_cookie_get_hash_collision = 5,
	fscache_cookie_get_inval_work = 6,
	fscache_cookie_get_lru = 7,
	fscache_cookie_get_use_work = 8,
	fscache_cookie_new_acquire = 9,
	fscache_cookie_put_hash_collision = 10,
	fscache_cookie_put_lru = 11,
	fscache_cookie_put_object = 12,
	fscache_cookie_put_over_queued = 13,
	fscache_cookie_put_relinquish = 14,
	fscache_cookie_put_withdrawn = 15,
	fscache_cookie_put_work = 16,
	fscache_cookie_see_active = 17,
	fscache_cookie_see_lru_discard = 18,
	fscache_cookie_see_lru_discard_clear = 19,
	fscache_cookie_see_lru_do_one = 20,
	fscache_cookie_see_relinquish = 21,
	fscache_cookie_see_withdraw = 22,
	fscache_cookie_see_work = 23,
};

enum fscache_volume_trace {
	fscache_volume_collision = 0,
	fscache_volume_get_cookie = 1,
	fscache_volume_get_create_work = 2,
	fscache_volume_get_hash_collision = 3,
	fscache_volume_get_withdraw = 4,
	fscache_volume_free = 5,
	fscache_volume_new_acquire = 6,
	fscache_volume_put_cookie = 7,
	fscache_volume_put_create_work = 8,
	fscache_volume_put_hash_collision = 9,
	fscache_volume_put_relinquish = 10,
	fscache_volume_put_withdraw = 11,
	fscache_volume_see_create_work = 12,
	fscache_volume_see_hash_wake = 13,
	fscache_volume_wait_create_work = 14,
};

enum fscache_want_state {
	FSCACHE_WANT_PARAMS = 0,
	FSCACHE_WANT_WRITE = 1,
	FSCACHE_WANT_READ = 2,
};

enum fsconfig_command {
	FSCONFIG_SET_FLAG = 0,
	FSCONFIG_SET_STRING = 1,
	FSCONFIG_SET_BINARY = 2,
	FSCONFIG_SET_PATH = 3,
	FSCONFIG_SET_PATH_EMPTY = 4,
	FSCONFIG_SET_FD = 5,
	FSCONFIG_CMD_CREATE = 6,
	FSCONFIG_CMD_RECONFIGURE = 7,
	FSCONFIG_CMD_CREATE_EXCL = 8,
};

enum fsid_source {
	FSIDSOURCE_DEV = 0,
	FSIDSOURCE_FSID = 1,
	FSIDSOURCE_UUID = 2,
};

enum fsl_mc_pool_type {
	FSL_MC_POOL_DPMCP = 0,
	FSL_MC_POOL_DPBP = 1,
	FSL_MC_POOL_DPCON = 2,
	FSL_MC_POOL_IRQ = 3,
	FSL_MC_NUM_POOL_TYPES = 4,
};

enum fsnotify_data_type {
	FSNOTIFY_EVENT_NONE = 0,
	FSNOTIFY_EVENT_FILE_RANGE = 1,
	FSNOTIFY_EVENT_PATH = 2,
	FSNOTIFY_EVENT_INODE = 3,
	FSNOTIFY_EVENT_DENTRY = 4,
	FSNOTIFY_EVENT_ERROR = 5,
};

enum fsnotify_group_prio {
	FSNOTIFY_PRIO_NORMAL = 0,
	FSNOTIFY_PRIO_CONTENT = 1,
	FSNOTIFY_PRIO_PRE_CONTENT = 2,
	__FSNOTIFY_PRIO_NUM = 3,
};

enum fsnotify_iter_type {
	FSNOTIFY_ITER_TYPE_INODE = 0,
	FSNOTIFY_ITER_TYPE_VFSMOUNT = 1,
	FSNOTIFY_ITER_TYPE_SB = 2,
	FSNOTIFY_ITER_TYPE_PARENT = 3,
	FSNOTIFY_ITER_TYPE_INODE2 = 4,
	FSNOTIFY_ITER_TYPE_COUNT = 5,
};

enum fsnotify_obj_type {
	FSNOTIFY_OBJ_TYPE_ANY = -1,
	FSNOTIFY_OBJ_TYPE_INODE = 0,
	FSNOTIFY_OBJ_TYPE_VFSMOUNT = 1,
	FSNOTIFY_OBJ_TYPE_SB = 2,
	FSNOTIFY_OBJ_TYPE_COUNT = 3,
	FSNOTIFY_OBJ_TYPE_DETACHED = 3,
};

enum ftrace_dump_mode {
	DUMP_NONE = 0,
	DUMP_ALL = 1,
	DUMP_ORIG = 2,
	DUMP_PARAM = 3,
};

enum fullness_group {
	ZS_INUSE_RATIO_0 = 0,
	ZS_INUSE_RATIO_10 = 1,
	ZS_INUSE_RATIO_99 = 10,
	ZS_INUSE_RATIO_100 = 11,
	NR_FULLNESS_GROUPS = 12,
};

enum futex_access {
	FUTEX_READ = 0,
	FUTEX_WRITE = 1,
};

enum fw_opt {
	FW_OPT_UEVENT = 1,
	FW_OPT_NOWAIT = 2,
	FW_OPT_USERHELPER = 4,
	FW_OPT_NO_WARN = 8,
	FW_OPT_NOCACHE = 16,
	FW_OPT_NOFALLBACK_SYSFS = 32,
	FW_OPT_FALLBACK_PLATFORM = 64,
	FW_OPT_PARTIAL = 128,
};

enum fw_status {
	FW_STATUS_UNKNOWN = 0,
	FW_STATUS_LOADING = 1,
	FW_STATUS_DONE = 2,
	FW_STATUS_ABORTED = 3,
};

enum gddrnf4_status {
	GDD4_OK = 0,
	GDD4_UNAVAIL = 1,
};

enum genl_validate_flags {
	GENL_DONT_VALIDATE_STRICT = 1,
	GENL_DONT_VALIDATE_DUMP = 2,
	GENL_DONT_VALIDATE_DUMP_STRICT = 4,
};

enum gpio_lookup_flags {
	GPIO_ACTIVE_HIGH = 0,
	GPIO_ACTIVE_LOW = 1,
	GPIO_OPEN_DRAIN = 2,
	GPIO_OPEN_SOURCE = 4,
	GPIO_PERSISTENT = 0,
	GPIO_TRANSITORY = 8,
	GPIO_PULL_UP = 16,
	GPIO_PULL_DOWN = 32,
	GPIO_PULL_DISABLE = 64,
	GPIO_LOOKUP_FLAGS_DEFAULT = 0,
};

enum gpio_v2_line_attr_id {
	GPIO_V2_LINE_ATTR_ID_FLAGS = 1,
	GPIO_V2_LINE_ATTR_ID_OUTPUT_VALUES = 2,
	GPIO_V2_LINE_ATTR_ID_DEBOUNCE = 3,
};

enum gpio_v2_line_changed_type {
	GPIO_V2_LINE_CHANGED_REQUESTED = 1,
	GPIO_V2_LINE_CHANGED_RELEASED = 2,
	GPIO_V2_LINE_CHANGED_CONFIG = 3,
};

enum gpio_v2_line_event_id {
	GPIO_V2_LINE_EVENT_RISING_EDGE = 1,
	GPIO_V2_LINE_EVENT_FALLING_EDGE = 2,
};

enum gpio_v2_line_flag {
	GPIO_V2_LINE_FLAG_USED = 1,
	GPIO_V2_LINE_FLAG_ACTIVE_LOW = 2,
	GPIO_V2_LINE_FLAG_INPUT = 4,
	GPIO_V2_LINE_FLAG_OUTPUT = 8,
	GPIO_V2_LINE_FLAG_EDGE_RISING = 16,
	GPIO_V2_LINE_FLAG_EDGE_FALLING = 32,
	GPIO_V2_LINE_FLAG_OPEN_DRAIN = 64,
	GPIO_V2_LINE_FLAG_OPEN_SOURCE = 128,
	GPIO_V2_LINE_FLAG_BIAS_PULL_UP = 256,
	GPIO_V2_LINE_FLAG_BIAS_PULL_DOWN = 512,
	GPIO_V2_LINE_FLAG_BIAS_DISABLED = 1024,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_REALTIME = 2048,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_HTE = 4096,
};

enum gpiod_flags {
	GPIOD_ASIS = 0,
	GPIOD_IN = 1,
	GPIOD_OUT_LOW = 3,
	GPIOD_OUT_HIGH = 7,
	GPIOD_OUT_LOW_OPEN_DRAIN = 11,
	GPIOD_OUT_HIGH_OPEN_DRAIN = 15,
};

enum gre_conntrack {
	GRE_CT_UNREPLIED = 0,
	GRE_CT_REPLIED = 1,
	GRE_CT_MAX = 2,
};

enum gro_result {
	GRO_MERGED = 0,
	GRO_MERGED_FREE = 1,
	GRO_HELD = 2,
	GRO_NORMAL = 3,
	GRO_CONSUMED = 4,
};

typedef enum gro_result gro_result_t;

enum group_type {
	group_has_spare = 0,
	group_fully_busy = 1,
	group_misfit_task = 2,
	group_smt_balance = 3,
	group_asym_packing = 4,
	group_imbalanced = 5,
	group_overloaded = 6,
};

enum handle_to_path_flags {
	HANDLE_CHECK_PERMS = 1,
	HANDLE_CHECK_SUBTREE = 2,
};

enum handshake_auth {
	HANDSHAKE_AUTH_UNSPEC = 0,
	HANDSHAKE_AUTH_UNAUTH = 1,
	HANDSHAKE_AUTH_PSK = 2,
	HANDSHAKE_AUTH_X509 = 3,
};

enum handshake_handler_class {
	HANDSHAKE_HANDLER_CLASS_NONE = 0,
	HANDSHAKE_HANDLER_CLASS_TLSHD = 1,
	HANDSHAKE_HANDLER_CLASS_MAX = 2,
};

enum handshake_msg_type {
	HANDSHAKE_MSG_TYPE_UNSPEC = 0,
	HANDSHAKE_MSG_TYPE_CLIENTHELLO = 1,
	HANDSHAKE_MSG_TYPE_SERVERHELLO = 2,
};

enum hardware_details {
	MVS_MAX_PHYS = 8,
	MVS_MAX_PORTS = 8,
	MVS_SOC_PHYS = 4,
	MVS_SOC_PORTS = 4,
	MVS_MAX_DEVICES = 1024,
};

enum hash_algo {
	HASH_ALGO_MD4 = 0,
	HASH_ALGO_MD5 = 1,
	HASH_ALGO_SHA1 = 2,
	HASH_ALGO_RIPE_MD_160 = 3,
	HASH_ALGO_SHA256 = 4,
	HASH_ALGO_SHA384 = 5,
	HASH_ALGO_SHA512 = 6,
	HASH_ALGO_SHA224 = 7,
	HASH_ALGO_RIPE_MD_128 = 8,
	HASH_ALGO_RIPE_MD_256 = 9,
	HASH_ALGO_RIPE_MD_320 = 10,
	HASH_ALGO_WP_256 = 11,
	HASH_ALGO_WP_384 = 12,
	HASH_ALGO_WP_512 = 13,
	HASH_ALGO_TGR_128 = 14,
	HASH_ALGO_TGR_160 = 15,
	HASH_ALGO_TGR_192 = 16,
	HASH_ALGO_SM3_256 = 17,
	HASH_ALGO_STREEBOG_256 = 18,
	HASH_ALGO_STREEBOG_512 = 19,
	HASH_ALGO_SHA3_256 = 20,
	HASH_ALGO_SHA3_384 = 21,
	HASH_ALGO_SHA3_512 = 22,
	HASH_ALGO__LAST = 23,
};

enum hba_port_matched_codes {
	NOT_MATCHED = 0,
	MATCHED_WITH_ADDR_AND_PHYMASK = 1,
	MATCHED_WITH_ADDR_SUBPHYMASK_AND_PORT = 2,
	MATCHED_WITH_ADDR_AND_SUBPHYMASK = 3,
	MATCHED_WITH_ADDR = 4,
};

enum hctx_type {
	HCTX_TYPE_DEFAULT = 0,
	HCTX_TYPE_READ = 1,
	HCTX_TYPE_POLL = 2,
	HCTX_MAX_TYPES = 3,
};

enum hdmi_3d_structure {
	HDMI_3D_STRUCTURE_INVALID = -1,
	HDMI_3D_STRUCTURE_FRAME_PACKING = 0,
	HDMI_3D_STRUCTURE_FIELD_ALTERNATIVE = 1,
	HDMI_3D_STRUCTURE_LINE_ALTERNATIVE = 2,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_FULL = 3,
	HDMI_3D_STRUCTURE_L_DEPTH = 4,
	HDMI_3D_STRUCTURE_L_DEPTH_GFX_GFX_DEPTH = 5,
	HDMI_3D_STRUCTURE_TOP_AND_BOTTOM = 6,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_HALF = 8,
};

enum hdmi_active_aspect {
	HDMI_ACTIVE_ASPECT_16_9_TOP = 2,
	HDMI_ACTIVE_ASPECT_14_9_TOP = 3,
	HDMI_ACTIVE_ASPECT_16_9_CENTER = 4,
	HDMI_ACTIVE_ASPECT_PICTURE = 8,
	HDMI_ACTIVE_ASPECT_4_3 = 9,
	HDMI_ACTIVE_ASPECT_16_9 = 10,
	HDMI_ACTIVE_ASPECT_14_9 = 11,
	HDMI_ACTIVE_ASPECT_4_3_SP_14_9 = 13,
	HDMI_ACTIVE_ASPECT_16_9_SP_14_9 = 14,
	HDMI_ACTIVE_ASPECT_16_9_SP_4_3 = 15,
};

enum hdmi_audio_coding_type {
	HDMI_AUDIO_CODING_TYPE_STREAM = 0,
	HDMI_AUDIO_CODING_TYPE_PCM = 1,
	HDMI_AUDIO_CODING_TYPE_AC3 = 2,
	HDMI_AUDIO_CODING_TYPE_MPEG1 = 3,
	HDMI_AUDIO_CODING_TYPE_MP3 = 4,
	HDMI_AUDIO_CODING_TYPE_MPEG2 = 5,
	HDMI_AUDIO_CODING_TYPE_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_DTS = 7,
	HDMI_AUDIO_CODING_TYPE_ATRAC = 8,
	HDMI_AUDIO_CODING_TYPE_DSD = 9,
	HDMI_AUDIO_CODING_TYPE_EAC3 = 10,
	HDMI_AUDIO_CODING_TYPE_DTS_HD = 11,
	HDMI_AUDIO_CODING_TYPE_MLP = 12,
	HDMI_AUDIO_CODING_TYPE_DST = 13,
	HDMI_AUDIO_CODING_TYPE_WMA_PRO = 14,
	HDMI_AUDIO_CODING_TYPE_CXT = 15,
};

enum hdmi_audio_coding_type_ext {
	HDMI_AUDIO_CODING_TYPE_EXT_CT = 0,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC = 1,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC_V2 = 2,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG_SURROUND = 3,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC = 4,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_V2 = 5,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_EXT_DRA = 7,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_SURROUND = 8,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC_SURROUND = 10,
};

enum hdmi_audio_sample_frequency {
	HDMI_AUDIO_SAMPLE_FREQUENCY_STREAM = 0,
	HDMI_AUDIO_SAMPLE_FREQUENCY_32000 = 1,
	HDMI_AUDIO_SAMPLE_FREQUENCY_44100 = 2,
	HDMI_AUDIO_SAMPLE_FREQUENCY_48000 = 3,
	HDMI_AUDIO_SAMPLE_FREQUENCY_88200 = 4,
	HDMI_AUDIO_SAMPLE_FREQUENCY_96000 = 5,
	HDMI_AUDIO_SAMPLE_FREQUENCY_176400 = 6,
	HDMI_AUDIO_SAMPLE_FREQUENCY_192000 = 7,
};

enum hdmi_audio_sample_size {
	HDMI_AUDIO_SAMPLE_SIZE_STREAM = 0,
	HDMI_AUDIO_SAMPLE_SIZE_16 = 1,
	HDMI_AUDIO_SAMPLE_SIZE_20 = 2,
	HDMI_AUDIO_SAMPLE_SIZE_24 = 3,
};

enum hdmi_colorimetry {
	HDMI_COLORIMETRY_NONE = 0,
	HDMI_COLORIMETRY_ITU_601 = 1,
	HDMI_COLORIMETRY_ITU_709 = 2,
	HDMI_COLORIMETRY_EXTENDED = 3,
};

enum hdmi_colorspace {
	HDMI_COLORSPACE_RGB = 0,
	HDMI_COLORSPACE_YUV422 = 1,
	HDMI_COLORSPACE_YUV444 = 2,
	HDMI_COLORSPACE_YUV420 = 3,
	HDMI_COLORSPACE_RESERVED4 = 4,
	HDMI_COLORSPACE_RESERVED5 = 5,
	HDMI_COLORSPACE_RESERVED6 = 6,
	HDMI_COLORSPACE_IDO_DEFINED = 7,
};

enum hdmi_content_type {
	HDMI_CONTENT_TYPE_GRAPHICS = 0,
	HDMI_CONTENT_TYPE_PHOTO = 1,
	HDMI_CONTENT_TYPE_CINEMA = 2,
	HDMI_CONTENT_TYPE_GAME = 3,
};

enum hdmi_eotf {
	HDMI_EOTF_TRADITIONAL_GAMMA_SDR = 0,
	HDMI_EOTF_TRADITIONAL_GAMMA_HDR = 1,
	HDMI_EOTF_SMPTE_ST2084 = 2,
	HDMI_EOTF_BT_2100_HLG = 3,
};

enum hdmi_extended_colorimetry {
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_601 = 0,
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_709 = 1,
	HDMI_EXTENDED_COLORIMETRY_S_YCC_601 = 2,
	HDMI_EXTENDED_COLORIMETRY_OPYCC_601 = 3,
	HDMI_EXTENDED_COLORIMETRY_OPRGB = 4,
	HDMI_EXTENDED_COLORIMETRY_BT2020_CONST_LUM = 5,
	HDMI_EXTENDED_COLORIMETRY_BT2020 = 6,
	HDMI_EXTENDED_COLORIMETRY_RESERVED = 7,
};

enum hdmi_infoframe_type {
	HDMI_INFOFRAME_TYPE_VENDOR = 129,
	HDMI_INFOFRAME_TYPE_AVI = 130,
	HDMI_INFOFRAME_TYPE_SPD = 131,
	HDMI_INFOFRAME_TYPE_AUDIO = 132,
	HDMI_INFOFRAME_TYPE_DRM = 135,
};

enum hdmi_metadata_type {
	HDMI_STATIC_METADATA_TYPE1 = 0,
};

enum hdmi_nups {
	HDMI_NUPS_UNKNOWN = 0,
	HDMI_NUPS_HORIZONTAL = 1,
	HDMI_NUPS_VERTICAL = 2,
	HDMI_NUPS_BOTH = 3,
};

enum hdmi_picture_aspect {
	HDMI_PICTURE_ASPECT_NONE = 0,
	HDMI_PICTURE_ASPECT_4_3 = 1,
	HDMI_PICTURE_ASPECT_16_9 = 2,
	HDMI_PICTURE_ASPECT_64_27 = 3,
	HDMI_PICTURE_ASPECT_256_135 = 4,
	HDMI_PICTURE_ASPECT_RESERVED = 5,
};

enum hdmi_quantization_range {
	HDMI_QUANTIZATION_RANGE_DEFAULT = 0,
	HDMI_QUANTIZATION_RANGE_LIMITED = 1,
	HDMI_QUANTIZATION_RANGE_FULL = 2,
	HDMI_QUANTIZATION_RANGE_RESERVED = 3,
};

enum hdmi_scan_mode {
	HDMI_SCAN_MODE_NONE = 0,
	HDMI_SCAN_MODE_OVERSCAN = 1,
	HDMI_SCAN_MODE_UNDERSCAN = 2,
	HDMI_SCAN_MODE_RESERVED = 3,
};

enum hdmi_spd_sdi {
	HDMI_SPD_SDI_UNKNOWN = 0,
	HDMI_SPD_SDI_DSTB = 1,
	HDMI_SPD_SDI_DVDP = 2,
	HDMI_SPD_SDI_DVHS = 3,
	HDMI_SPD_SDI_HDDVR = 4,
	HDMI_SPD_SDI_DVC = 5,
	HDMI_SPD_SDI_DSC = 6,
	HDMI_SPD_SDI_VCD = 7,
	HDMI_SPD_SDI_GAME = 8,
	HDMI_SPD_SDI_PC = 9,
	HDMI_SPD_SDI_BD = 10,
	HDMI_SPD_SDI_SACD = 11,
	HDMI_SPD_SDI_HDDVD = 12,
	HDMI_SPD_SDI_PMP = 13,
};

enum hdmi_ycc_quantization_range {
	HDMI_YCC_QUANTIZATION_RANGE_LIMITED = 0,
	HDMI_YCC_QUANTIZATION_RANGE_FULL = 1,
};

enum hid_class_request {
	HID_REQ_GET_REPORT = 1,
	HID_REQ_GET_IDLE = 2,
	HID_REQ_GET_PROTOCOL = 3,
	HID_REQ_SET_REPORT = 9,
	HID_REQ_SET_IDLE = 10,
	HID_REQ_SET_PROTOCOL = 11,
};

enum hid_report_type {
	HID_INPUT_REPORT = 0,
	HID_OUTPUT_REPORT = 1,
	HID_FEATURE_REPORT = 2,
	HID_REPORT_TYPES = 3,
};

enum hid_type {
	HID_TYPE_OTHER = 0,
	HID_TYPE_USBMOUSE = 1,
	HID_TYPE_USBNONE = 2,
};

enum hk_flags {
	HK_FLAG_DOMAIN = 1,
	HK_FLAG_MANAGED_IRQ = 2,
	HK_FLAG_KERNEL_NOISE = 4,
};

enum hk_type {
	HK_TYPE_DOMAIN = 0,
	HK_TYPE_MANAGED_IRQ = 1,
	HK_TYPE_KERNEL_NOISE = 2,
	HK_TYPE_MAX = 3,
	HK_TYPE_TICK = 2,
	HK_TYPE_TIMER = 2,
	HK_TYPE_RCU = 2,
	HK_TYPE_MISC = 2,
	HK_TYPE_WQ = 2,
	HK_TYPE_KTHREAD = 2,
};

enum hmm_pfn_flags {
	HMM_PFN_VALID = 9223372036854775808ULL,
	HMM_PFN_WRITE = 4611686018427387904ULL,
	HMM_PFN_ERROR = 2305843009213693952ULL,
	HMM_PFN_ORDER_SHIFT = 56ULL,
	HMM_PFN_REQ_FAULT = 9223372036854775808ULL,
	HMM_PFN_REQ_WRITE = 4611686018427387904ULL,
	HMM_PFN_FLAGS = 18374686479671623680ULL,
};

enum hn_flags_bits {
	HANDSHAKE_F_NET_DRAINING = 0,
};

enum host_registers {
	MVS_HST_CHIP_CONFIG = 65796,
};

enum hp_flags_bits {
	HANDSHAKE_F_PROTO_NOTIFY = 0,
};

enum hprobe_state {
	HPROBE_LEASED = 0,
	HPROBE_STABLE = 1,
	HPROBE_GONE = 2,
	HPROBE_CONSUMED = 3,
};

enum hpx_type3_cfg_loc {
	HPX_CFG_PCICFG = 0,
	HPX_CFG_PCIE_CAP = 1,
	HPX_CFG_PCIE_CAP_EXT = 2,
	HPX_CFG_VEND_CAP = 3,
	HPX_CFG_DVSEC = 4,
	HPX_CFG_MAX = 5,
};

enum hpx_type3_dev_type {
	HPX_TYPE_ENDPOINT = 1,
	HPX_TYPE_LEG_END = 2,
	HPX_TYPE_RC_END = 4,
	HPX_TYPE_RC_EC = 8,
	HPX_TYPE_ROOT_PORT = 16,
	HPX_TYPE_UPSTREAM = 32,
	HPX_TYPE_DOWNSTREAM = 64,
	HPX_TYPE_PCI_BRIDGE = 128,
	HPX_TYPE_PCIE_BRIDGE = 256,
};

enum hpx_type3_fn_type {
	HPX_FN_NORMAL = 1,
	HPX_FN_SRIOV_PHYS = 2,
	HPX_FN_SRIOV_VIRT = 4,
};

enum hr_flags_bits {
	HANDSHAKE_F_REQ_COMPLETED = 0,
	HANDSHAKE_F_REQ_SESSION = 1,
};

enum hrtimer_base_type {
	HRTIMER_BASE_MONOTONIC = 0,
	HRTIMER_BASE_REALTIME = 1,
	HRTIMER_BASE_BOOTTIME = 2,
	HRTIMER_BASE_TAI = 3,
	HRTIMER_BASE_MONOTONIC_SOFT = 4,
	HRTIMER_BASE_REALTIME_SOFT = 5,
	HRTIMER_BASE_BOOTTIME_SOFT = 6,
	HRTIMER_BASE_TAI_SOFT = 7,
	HRTIMER_MAX_CLOCK_BASES = 8,
};

enum hrtimer_mode {
	HRTIMER_MODE_ABS = 0,
	HRTIMER_MODE_REL = 1,
	HRTIMER_MODE_PINNED = 2,
	HRTIMER_MODE_SOFT = 4,
	HRTIMER_MODE_HARD = 8,
	HRTIMER_MODE_ABS_PINNED = 2,
	HRTIMER_MODE_REL_PINNED = 3,
	HRTIMER_MODE_ABS_SOFT = 4,
	HRTIMER_MODE_REL_SOFT = 5,
	HRTIMER_MODE_ABS_PINNED_SOFT = 6,
	HRTIMER_MODE_REL_PINNED_SOFT = 7,
	HRTIMER_MODE_ABS_HARD = 8,
	HRTIMER_MODE_REL_HARD = 9,
	HRTIMER_MODE_ABS_PINNED_HARD = 10,
	HRTIMER_MODE_REL_PINNED_HARD = 11,
};

enum hrtimer_restart {
	HRTIMER_NORESTART = 0,
	HRTIMER_RESTART = 1,
};

enum hsm_task_states {
	HSM_ST_IDLE = 0,
	HSM_ST_FIRST = 1,
	HSM_ST = 2,
	HSM_ST_LAST = 3,
	HSM_ST_ERR = 4,
};

enum hub_activation_type {
	HUB_INIT = 0,
	HUB_INIT2 = 1,
	HUB_INIT3 = 2,
	HUB_POST_RESET = 3,
	HUB_RESUME = 4,
	HUB_RESET_RESUME = 5,
};

enum hub_led_mode {
	INDICATOR_AUTO = 0,
	INDICATOR_CYCLE = 1,
	INDICATOR_GREEN_BLINK = 2,
	INDICATOR_GREEN_BLINK_OFF = 3,
	INDICATOR_AMBER_BLINK = 4,
	INDICATOR_AMBER_BLINK_OFF = 5,
	INDICATOR_ALT_BLINK = 6,
	INDICATOR_ALT_BLINK_OFF = 7,
} __attribute__((mode(byte)));

enum hub_quiescing_type {
	HUB_DISCONNECT = 0,
	HUB_PRE_RESET = 1,
	HUB_SUSPEND = 2,
};

enum hugetlb_memory_event {
	HUGETLB_MAX = 0,
	HUGETLB_NR_MEMORY_EVENTS = 1,
};

enum hugetlb_page_flags {
	HPG_restore_reserve = 0,
	HPG_migratable = 1,
	HPG_temporary = 2,
	HPG_freed = 3,
	HPG_vmemmap_optimized = 4,
	HPG_raw_hwp_unreliable = 5,
	__NR_HPAGEFLAGS = 6,
};

enum hugetlb_param {
	Opt_gid___7 = 0,
	Opt_min_size = 1,
	Opt_mode___5 = 2,
	Opt_nr_inodes = 3,
	Opt_pagesize = 4,
	Opt_size = 5,
	Opt_uid___7 = 6,
};

enum hugetlbfs_size_type {
	NO_SIZE = 0,
	SIZE_STD = 1,
	SIZE_PERCENT = 2,
};

enum hw_breakpoint_ops {
	HW_BREAKPOINT_INSTALL = 0,
	HW_BREAKPOINT_UNINSTALL = 1,
};

enum hw_event_mc_err_type {
	HW_EVENT_ERR_CORRECTED = 0,
	HW_EVENT_ERR_UNCORRECTED = 1,
	HW_EVENT_ERR_DEFERRED = 2,
	HW_EVENT_ERR_FATAL = 3,
	HW_EVENT_ERR_INFO = 4,
};

enum hw_register_bits {
	INT_EN = 2,
	HBA_RST = 1,
	INT_XOR = 16,
	INT_SAS_SATA = 1,
	SATA_TARGET = 65536,
	MODE_AUTO_DET_PORT7 = 32768,
	MODE_AUTO_DET_PORT6 = 16384,
	MODE_AUTO_DET_PORT5 = 8192,
	MODE_AUTO_DET_PORT4 = 4096,
	MODE_AUTO_DET_PORT3 = 2048,
	MODE_AUTO_DET_PORT2 = 1024,
	MODE_AUTO_DET_PORT1 = 512,
	MODE_AUTO_DET_PORT0 = 256,
	MODE_AUTO_DET_EN = 65280,
	MODE_SAS_PORT7_MASK = 128,
	MODE_SAS_PORT6_MASK = 64,
	MODE_SAS_PORT5_MASK = 32,
	MODE_SAS_PORT4_MASK = 16,
	MODE_SAS_PORT3_MASK = 8,
	MODE_SAS_PORT2_MASK = 4,
	MODE_SAS_PORT1_MASK = 2,
	MODE_SAS_PORT0_MASK = 1,
	MODE_SAS_SATA = 255,
	TX_EN = 65536,
	TX_RING_SZ_MASK = 4095,
	RX_EN = 65536,
	RX_RING_SZ_MASK = 4095,
	COAL_EN = 65536,
	CINT_I2C = 2147483648,
	CINT_SW0 = 1073741824,
	CINT_SW1 = 536870912,
	CINT_PRD_BC = 268435456,
	CINT_DMA_PCIE = 134217728,
	CINT_MEM = 67108864,
	CINT_I2C_SLAVE = 33554432,
	CINT_NON_SPEC_NCQ_ERROR = 33554432,
	CINT_SRS = 8,
	CINT_CI_STOP = 2,
	CINT_DONE = 1,
	CINT_PORT_STOPPED = 65536,
	CINT_PORT = 256,
	CINT_PORT_MASK_OFFSET = 8,
	CINT_PORT_MASK = 65280,
	CINT_PHY_MASK_OFFSET = 4,
	CINT_PHY_MASK = 240,
	TXQ_CMD_SHIFT = 29,
	TXQ_CMD_SSP = 1,
	TXQ_CMD_SMP = 2,
	TXQ_CMD_STP = 3,
	TXQ_CMD_SSP_FREE_LIST = 4,
	TXQ_CMD_SLOT_RESET = 7,
	TXQ_MODE_I = 268435456,
	TXQ_MODE_TARGET = 0,
	TXQ_MODE_INITIATOR = 1,
	TXQ_PRIO_HI = 134217728,
	TXQ_PRI_NORMAL = 0,
	TXQ_PRI_HIGH = 1,
	TXQ_SRS_SHIFT = 20,
	TXQ_SRS_MASK = 127,
	TXQ_PHY_SHIFT = 12,
	TXQ_PHY_MASK = 255,
	TXQ_SLOT_MASK = 4095,
	RXQ_GOOD = 8388608,
	RXQ_SLOT_RESET = 2097152,
	RXQ_CMD_RX = 1048576,
	RXQ_ATTN = 524288,
	RXQ_RSP = 262144,
	RXQ_ERR = 131072,
	RXQ_DONE = 65536,
	RXQ_SLOT_MASK = 4095,
	MCH_PRD_LEN_SHIFT = 16,
	MCH_SSP_FR_TYPE_SHIFT = 13,
	MCH_SSP_FR_CMD = 0,
	MCH_SSP_FR_TASK = 1,
	MCH_SSP_FR_XFER_RDY = 4,
	MCH_SSP_FR_RESP = 5,
	MCH_SSP_FR_READ = 6,
	MCH_SSP_FR_READ_RESP = 7,
	MCH_SSP_MODE_PASSTHRU = 1,
	MCH_SSP_MODE_NORMAL = 0,
	MCH_PASSTHRU = 4096,
	MCH_FBURST = 2048,
	MCH_CHK_LEN = 1024,
	MCH_RETRY = 512,
	MCH_PROTECTION = 256,
	MCH_RESET = 128,
	MCH_FPDMA = 64,
	MCH_ATAPI = 32,
	MCH_BIST = 16,
	MCH_PMP_MASK = 15,
	CCTL_RST = 32,
	CCTL_ENDIAN_DATA = 8,
	CCTL_ENDIAN_RSP = 4,
	CCTL_ENDIAN_OPEN = 2,
	CCTL_ENDIAN_CMD = 1,
	PHY_SSP_RST = 8,
	PHY_BCAST_CHG = 4,
	PHY_RST_HARD = 2,
	PHY_RST = 1,
	PHY_READY_MASK = 1048576,
	PHYEV_DEC_ERR = 16777216,
	PHYEV_DCDR_ERR = 8388608,
	PHYEV_CRC_ERR = 4194304,
	PHYEV_UNASSOC_FIS = 524288,
	PHYEV_AN = 262144,
	PHYEV_BIST_ACT = 131072,
	PHYEV_SIG_FIS = 65536,
	PHYEV_POOF = 4096,
	PHYEV_IU_BIG = 2048,
	PHYEV_IU_SMALL = 1024,
	PHYEV_UNK_TAG = 512,
	PHYEV_BROAD_CH = 256,
	PHYEV_COMWAKE = 128,
	PHYEV_PORT_SEL = 64,
	PHYEV_HARD_RST = 32,
	PHYEV_ID_TMOUT = 16,
	PHYEV_ID_FAIL = 8,
	PHYEV_ID_DONE = 4,
	PHYEV_HARD_RST_DONE = 2,
	PHYEV_RDY_CH = 1,
	PCS_EN_SATA_REG_SHIFT = 16,
	PCS_EN_PORT_XMT_SHIFT = 12,
	PCS_EN_PORT_XMT_SHIFT2 = 8,
	PCS_SATA_RETRY = 256,
	PCS_RSP_RX_EN = 128,
	PCS_SATA_RETRY_2 = 64,
	PCS_SELF_CLEAR = 32,
	PCS_FIS_RX_EN = 16,
	PCS_CMD_STOP_ERR = 8,
	PCS_CMD_RST = 2,
	PCS_CMD_EN = 1,
	PORT_DEV_SSP_TRGT = 524288,
	PORT_DEV_SMP_TRGT = 262144,
	PORT_DEV_STP_TRGT = 131072,
	PORT_DEV_SSP_INIT = 2048,
	PORT_DEV_SMP_INIT = 1024,
	PORT_DEV_STP_INIT = 512,
	PORT_PHY_ID_MASK = 4278190080,
	PORT_SSP_TRGT_MASK = 524288,
	PORT_SSP_INIT_MASK = 2048,
	PORT_DEV_TRGT_MASK = 917504,
	PORT_DEV_INIT_MASK = 3584,
	PORT_DEV_TYPE_MASK = 7,
	PHY_RDY = 4,
	PHY_DW_SYNC = 2,
	PHY_OOB_DTCTD = 1,
	PHY_MODE6_LATECLK = 536870912,
	PHY_MODE6_DTL_SPEED = 134217728,
	PHY_MODE6_FC_ORDER = 67108864,
	PHY_MODE6_MUCNT_EN = 16777216,
	PHY_MODE6_SEL_MUCNT_LEN = 4194304,
	PHY_MODE6_SELMUPI = 1048576,
	PHY_MODE6_SELMUPF = 262144,
	PHY_MODE6_SELMUFF = 65536,
	PHY_MODE6_SELMUFI = 16384,
	PHY_MODE6_FREEZE_LOOP = 4096,
	PHY_MODE6_INT_RXFOFFS = 8,
	PHY_MODE6_FRC_RXFOFFS = 4,
	PHY_MODE6_STAU_0D8 = 2,
	PHY_MODE6_RXSAT_DIS = 1,
};

enum hw_registers {
	MVS_GBL_CTL = 4,
	MVS_GBL_INT_STAT = 0,
	MVS_GBL_PI = 12,
	MVS_PHY_CTL = 64,
	MVS_PORTS_IMP = 156,
	MVS_GBL_PORT_TYPE = 160,
	MVS_CTL = 256,
	MVS_PCS = 260,
	MVS_CMD_LIST_LO = 264,
	MVS_CMD_LIST_HI = 268,
	MVS_RX_FIS_LO = 272,
	MVS_RX_FIS_HI = 276,
	MVS_STP_REG_SET_0 = 280,
	MVS_STP_REG_SET_1 = 284,
	MVS_TX_CFG = 288,
	MVS_TX_LO = 292,
	MVS_TX_HI = 296,
	MVS_TX_PROD_IDX = 300,
	MVS_TX_CONS_IDX = 304,
	MVS_RX_CFG = 308,
	MVS_RX_LO = 312,
	MVS_RX_HI = 316,
	MVS_RX_CONS_IDX = 320,
	MVS_INT_COAL = 328,
	MVS_INT_COAL_TMOUT = 332,
	MVS_INT_STAT = 336,
	MVS_INT_MASK = 340,
	MVS_INT_STAT_SRS_0 = 344,
	MVS_INT_MASK_SRS_0 = 348,
	MVS_INT_STAT_SRS_1 = 352,
	MVS_INT_MASK_SRS_1 = 356,
	MVS_NON_NCQ_ERR_0 = 360,
	MVS_NON_NCQ_ERR_1 = 364,
	MVS_CMD_ADDR = 368,
	MVS_CMD_DATA = 372,
	MVS_MEM_PARITY_ERR = 376,
	MVS_P0_INT_STAT = 384,
	MVS_P0_INT_MASK = 388,
	MVS_P4_INT_STAT = 416,
	MVS_P4_INT_MASK = 420,
	MVS_P0_SER_CTLSTAT = 464,
	MVS_P4_SER_CTLSTAT = 480,
	MVS_P0_CFG_ADDR = 512,
	MVS_P0_CFG_DATA = 516,
	MVS_P4_CFG_ADDR = 544,
	MVS_P4_CFG_DATA = 548,
	MVS_P0_VSR_ADDR = 592,
	MVS_P0_VSR_DATA = 596,
	MVS_P4_VSR_ADDR = 592,
	MVS_P4_VSR_DATA = 596,
	MVS_PA_VSR_ADDR = 656,
	MVS_PA_VSR_PORT = 660,
	MVS_COMMAND_ACTIVE = 768,
};

enum hw_registers___2 {
	MVS_GBL_CTL___2 = 4,
	MVS_GBL_INT_STAT___2 = 8,
	MVS_GBL_PI___2 = 12,
	MVS_PHY_CTL___2 = 64,
	MVS_PORTS_IMP___2 = 156,
	MVS_GBL_PORT_TYPE___2 = 160,
	MVS_CTL___2 = 256,
	MVS_PCS___2 = 260,
	MVS_CMD_LIST_LO___2 = 264,
	MVS_CMD_LIST_HI___2 = 268,
	MVS_RX_FIS_LO___2 = 272,
	MVS_RX_FIS_HI___2 = 276,
	MVS_TX_CFG___2 = 288,
	MVS_TX_LO___2 = 292,
	MVS_TX_HI___2 = 296,
	MVS_TX_PROD_IDX___2 = 300,
	MVS_TX_CONS_IDX___2 = 304,
	MVS_RX_CFG___2 = 308,
	MVS_RX_LO___2 = 312,
	MVS_RX_HI___2 = 316,
	MVS_RX_CONS_IDX___2 = 320,
	MVS_INT_COAL___2 = 328,
	MVS_INT_COAL_TMOUT___2 = 332,
	MVS_INT_STAT___2 = 336,
	MVS_INT_MASK___2 = 340,
	MVS_INT_STAT_SRS_0___2 = 344,
	MVS_INT_MASK_SRS_0___2 = 348,
	MVS_P0_INT_STAT___2 = 352,
	MVS_P0_INT_MASK___2 = 356,
	MVS_P4_INT_STAT___2 = 512,
	MVS_P4_INT_MASK___2 = 516,
	MVS_P0_SER_CTLSTAT___2 = 384,
	MVS_P4_SER_CTLSTAT___2 = 544,
	MVS_CMD_ADDR___2 = 440,
	MVS_CMD_DATA___2 = 444,
	MVS_P0_CFG_ADDR___2 = 448,
	MVS_P0_CFG_DATA___2 = 452,
	MVS_P4_CFG_ADDR___2 = 560,
	MVS_P4_CFG_DATA___2 = 564,
	MVS_P0_VSR_ADDR___2 = 480,
	MVS_P0_VSR_DATA___2 = 484,
	MVS_P4_VSR_ADDR___2 = 592,
	MVS_P4_VSR_DATA___2 = 596,
};

enum hwmon_chip_attributes {
	hwmon_chip_temp_reset_history = 0,
	hwmon_chip_in_reset_history = 1,
	hwmon_chip_curr_reset_history = 2,
	hwmon_chip_power_reset_history = 3,
	hwmon_chip_register_tz = 4,
	hwmon_chip_update_interval = 5,
	hwmon_chip_alarms = 6,
	hwmon_chip_samples = 7,
	hwmon_chip_curr_samples = 8,
	hwmon_chip_in_samples = 9,
	hwmon_chip_power_samples = 10,
	hwmon_chip_temp_samples = 11,
	hwmon_chip_beep_enable = 12,
	hwmon_chip_pec = 13,
};

enum hwmon_curr_attributes {
	hwmon_curr_enable = 0,
	hwmon_curr_input = 1,
	hwmon_curr_min = 2,
	hwmon_curr_max = 3,
	hwmon_curr_lcrit = 4,
	hwmon_curr_crit = 5,
	hwmon_curr_average = 6,
	hwmon_curr_lowest = 7,
	hwmon_curr_highest = 8,
	hwmon_curr_reset_history = 9,
	hwmon_curr_label = 10,
	hwmon_curr_alarm = 11,
	hwmon_curr_min_alarm = 12,
	hwmon_curr_max_alarm = 13,
	hwmon_curr_lcrit_alarm = 14,
	hwmon_curr_crit_alarm = 15,
	hwmon_curr_rated_min = 16,
	hwmon_curr_rated_max = 17,
	hwmon_curr_beep = 18,
};

enum hwmon_energy_attributes {
	hwmon_energy_enable = 0,
	hwmon_energy_input = 1,
	hwmon_energy_label = 2,
};

enum hwmon_fan_attributes {
	hwmon_fan_enable = 0,
	hwmon_fan_input = 1,
	hwmon_fan_label = 2,
	hwmon_fan_min = 3,
	hwmon_fan_max = 4,
	hwmon_fan_div = 5,
	hwmon_fan_pulses = 6,
	hwmon_fan_target = 7,
	hwmon_fan_alarm = 8,
	hwmon_fan_min_alarm = 9,
	hwmon_fan_max_alarm = 10,
	hwmon_fan_fault = 11,
	hwmon_fan_beep = 12,
};

enum hwmon_humidity_attributes {
	hwmon_humidity_enable = 0,
	hwmon_humidity_input = 1,
	hwmon_humidity_label = 2,
	hwmon_humidity_min = 3,
	hwmon_humidity_min_hyst = 4,
	hwmon_humidity_max = 5,
	hwmon_humidity_max_hyst = 6,
	hwmon_humidity_alarm = 7,
	hwmon_humidity_fault = 8,
	hwmon_humidity_rated_min = 9,
	hwmon_humidity_rated_max = 10,
	hwmon_humidity_min_alarm = 11,
	hwmon_humidity_max_alarm = 12,
};

enum hwmon_in_attributes {
	hwmon_in_enable = 0,
	hwmon_in_input = 1,
	hwmon_in_min = 2,
	hwmon_in_max = 3,
	hwmon_in_lcrit = 4,
	hwmon_in_crit = 5,
	hwmon_in_average = 6,
	hwmon_in_lowest = 7,
	hwmon_in_highest = 8,
	hwmon_in_reset_history = 9,
	hwmon_in_label = 10,
	hwmon_in_alarm = 11,
	hwmon_in_min_alarm = 12,
	hwmon_in_max_alarm = 13,
	hwmon_in_lcrit_alarm = 14,
	hwmon_in_crit_alarm = 15,
	hwmon_in_rated_min = 16,
	hwmon_in_rated_max = 17,
	hwmon_in_beep = 18,
	hwmon_in_fault = 19,
};

enum hwmon_intrusion_attributes {
	hwmon_intrusion_alarm = 0,
	hwmon_intrusion_beep = 1,
};

enum hwmon_power_attributes {
	hwmon_power_enable = 0,
	hwmon_power_average = 1,
	hwmon_power_average_interval = 2,
	hwmon_power_average_interval_max = 3,
	hwmon_power_average_interval_min = 4,
	hwmon_power_average_highest = 5,
	hwmon_power_average_lowest = 6,
	hwmon_power_average_max = 7,
	hwmon_power_average_min = 8,
	hwmon_power_input = 9,
	hwmon_power_input_highest = 10,
	hwmon_power_input_lowest = 11,
	hwmon_power_reset_history = 12,
	hwmon_power_accuracy = 13,
	hwmon_power_cap = 14,
	hwmon_power_cap_hyst = 15,
	hwmon_power_cap_max = 16,
	hwmon_power_cap_min = 17,
	hwmon_power_min = 18,
	hwmon_power_max = 19,
	hwmon_power_crit = 20,
	hwmon_power_lcrit = 21,
	hwmon_power_label = 22,
	hwmon_power_alarm = 23,
	hwmon_power_cap_alarm = 24,
	hwmon_power_min_alarm = 25,
	hwmon_power_max_alarm = 26,
	hwmon_power_lcrit_alarm = 27,
	hwmon_power_crit_alarm = 28,
	hwmon_power_rated_min = 29,
	hwmon_power_rated_max = 30,
};

enum hwmon_pwm_attributes {
	hwmon_pwm_input = 0,
	hwmon_pwm_enable = 1,
	hwmon_pwm_mode = 2,
	hwmon_pwm_freq = 3,
	hwmon_pwm_auto_channels_temp = 4,
};

enum hwmon_sensor_types {
	hwmon_chip = 0,
	hwmon_temp = 1,
	hwmon_in = 2,
	hwmon_curr = 3,
	hwmon_power = 4,
	hwmon_energy = 5,
	hwmon_humidity = 6,
	hwmon_fan = 7,
	hwmon_pwm = 8,
	hwmon_intrusion = 9,
	hwmon_max = 10,
};

enum hwmon_temp_attributes {
	hwmon_temp_enable = 0,
	hwmon_temp_input = 1,
	hwmon_temp_type = 2,
	hwmon_temp_lcrit = 3,
	hwmon_temp_lcrit_hyst = 4,
	hwmon_temp_min = 5,
	hwmon_temp_min_hyst = 6,
	hwmon_temp_max = 7,
	hwmon_temp_max_hyst = 8,
	hwmon_temp_crit = 9,
	hwmon_temp_crit_hyst = 10,
	hwmon_temp_emergency = 11,
	hwmon_temp_emergency_hyst = 12,
	hwmon_temp_alarm = 13,
	hwmon_temp_lcrit_alarm = 14,
	hwmon_temp_min_alarm = 15,
	hwmon_temp_max_alarm = 16,
	hwmon_temp_crit_alarm = 17,
	hwmon_temp_emergency_alarm = 18,
	hwmon_temp_fault = 19,
	hwmon_temp_offset = 20,
	hwmon_temp_label = 21,
	hwmon_temp_lowest = 22,
	hwmon_temp_highest = 23,
	hwmon_temp_reset_history = 24,
	hwmon_temp_rated_min = 25,
	hwmon_temp_rated_max = 26,
	hwmon_temp_beep = 27,
};

enum hwparam_type {
	hwparam_ioport = 0,
	hwparam_iomem = 1,
	hwparam_ioport_or_iomem = 2,
	hwparam_irq = 3,
	hwparam_dma = 4,
	hwparam_dma_addr = 5,
	hwparam_other = 6,
};

enum hwtstamp_flags {
	HWTSTAMP_FLAG_BONDED_PHC_INDEX = 1,
	HWTSTAMP_FLAG_LAST = 1,
	HWTSTAMP_FLAG_MASK = 1,
};

enum hwtstamp_provider_qualifier {
	HWTSTAMP_PROVIDER_QUALIFIER_PRECISE = 0,
	HWTSTAMP_PROVIDER_QUALIFIER_APPROX = 1,
	HWTSTAMP_PROVIDER_QUALIFIER_CNT = 2,
};

enum hwtstamp_rx_filters {
	HWTSTAMP_FILTER_NONE = 0,
	HWTSTAMP_FILTER_ALL = 1,
	HWTSTAMP_FILTER_SOME = 2,
	HWTSTAMP_FILTER_PTP_V1_L4_EVENT = 3,
	HWTSTAMP_FILTER_PTP_V1_L4_SYNC = 4,
	HWTSTAMP_FILTER_PTP_V1_L4_DELAY_REQ = 5,
	HWTSTAMP_FILTER_PTP_V2_L4_EVENT = 6,
	HWTSTAMP_FILTER_PTP_V2_L4_SYNC = 7,
	HWTSTAMP_FILTER_PTP_V2_L4_DELAY_REQ = 8,
	HWTSTAMP_FILTER_PTP_V2_L2_EVENT = 9,
	HWTSTAMP_FILTER_PTP_V2_L2_SYNC = 10,
	HWTSTAMP_FILTER_PTP_V2_L2_DELAY_REQ = 11,
	HWTSTAMP_FILTER_PTP_V2_EVENT = 12,
	HWTSTAMP_FILTER_PTP_V2_SYNC = 13,
	HWTSTAMP_FILTER_PTP_V2_DELAY_REQ = 14,
	HWTSTAMP_FILTER_NTP_ALL = 15,
	__HWTSTAMP_FILTER_CNT = 16,
};

enum hwtstamp_source {
	HWTSTAMP_SOURCE_UNSPEC = 0,
	HWTSTAMP_SOURCE_NETDEV = 1,
	HWTSTAMP_SOURCE_PHYLIB = 2,
};

enum hwtstamp_tx_types {
	HWTSTAMP_TX_OFF = 0,
	HWTSTAMP_TX_ON = 1,
	HWTSTAMP_TX_ONESTEP_SYNC = 2,
	HWTSTAMP_TX_ONESTEP_P2P = 3,
	__HWTSTAMP_TX_CNT = 4,
};

enum i2c_alert_protocol {
	I2C_PROTOCOL_SMBUS_ALERT = 0,
	I2C_PROTOCOL_SMBUS_HOST_NOTIFY = 1,
};

enum i2c_driver_flags {
	I2C_DRV_ACPI_WAIVE_D0_PROBE = 1,
};

enum i2c_slave_event {
	I2C_SLAVE_READ_REQUESTED = 0,
	I2C_SLAVE_WRITE_REQUESTED = 1,
	I2C_SLAVE_READ_PROCESSED = 2,
	I2C_SLAVE_WRITE_RECEIVED = 3,
	I2C_SLAVE_STOP = 4,
};

enum i8042_controller_reset_mode {
	I8042_RESET_NEVER = 0,
	I8042_RESET_ALWAYS = 1,
	I8042_RESET_ON_S2RAM = 2,
};

enum ib_atomic_cap {
	IB_ATOMIC_NONE = 0,
	IB_ATOMIC_HCA = 1,
	IB_ATOMIC_GLOB = 2,
};

enum ib_cq_notify_flags {
	IB_CQ_SOLICITED = 1,
	IB_CQ_NEXT_COMP = 2,
	IB_CQ_SOLICITED_MASK = 3,
	IB_CQ_REPORT_MISSED_EVENTS = 4,
};

enum ib_event_type {
	IB_EVENT_CQ_ERR = 0,
	IB_EVENT_QP_FATAL = 1,
	IB_EVENT_QP_REQ_ERR = 2,
	IB_EVENT_QP_ACCESS_ERR = 3,
	IB_EVENT_COMM_EST = 4,
	IB_EVENT_SQ_DRAINED = 5,
	IB_EVENT_PATH_MIG = 6,
	IB_EVENT_PATH_MIG_ERR = 7,
	IB_EVENT_DEVICE_FATAL = 8,
	IB_EVENT_PORT_ACTIVE = 9,
	IB_EVENT_PORT_ERR = 10,
	IB_EVENT_LID_CHANGE = 11,
	IB_EVENT_PKEY_CHANGE = 12,
	IB_EVENT_SM_CHANGE = 13,
	IB_EVENT_SRQ_ERR = 14,
	IB_EVENT_SRQ_LIMIT_REACHED = 15,
	IB_EVENT_QP_LAST_WQE_REACHED = 16,
	IB_EVENT_CLIENT_REREGISTER = 17,
	IB_EVENT_GID_CHANGE = 18,
	IB_EVENT_WQ_FATAL = 19,
};

enum ib_flow_action_type {
	IB_FLOW_ACTION_UNSPECIFIED = 0,
	IB_FLOW_ACTION_ESP = 1,
};

enum ib_flow_attr_type {
	IB_FLOW_ATTR_NORMAL = 0,
	IB_FLOW_ATTR_ALL_DEFAULT = 1,
	IB_FLOW_ATTR_MC_DEFAULT = 2,
	IB_FLOW_ATTR_SNIFFER = 3,
};

enum ib_flow_spec_type {
	IB_FLOW_SPEC_ETH = 32,
	IB_FLOW_SPEC_IB = 34,
	IB_FLOW_SPEC_IPV4 = 48,
	IB_FLOW_SPEC_IPV6 = 49,
	IB_FLOW_SPEC_ESP = 52,
	IB_FLOW_SPEC_TCP = 64,
	IB_FLOW_SPEC_UDP = 65,
	IB_FLOW_SPEC_VXLAN_TUNNEL = 80,
	IB_FLOW_SPEC_GRE = 81,
	IB_FLOW_SPEC_MPLS = 96,
	IB_FLOW_SPEC_INNER = 256,
	IB_FLOW_SPEC_ACTION_TAG = 4096,
	IB_FLOW_SPEC_ACTION_DROP = 4097,
	IB_FLOW_SPEC_ACTION_HANDLE = 4098,
	IB_FLOW_SPEC_ACTION_COUNT = 4099,
};

enum ib_gid_type {
	IB_GID_TYPE_IB = 0,
	IB_GID_TYPE_ROCE = 1,
	IB_GID_TYPE_ROCE_UDP_ENCAP = 2,
	IB_GID_TYPE_SIZE = 3,
};

enum ib_mig_state {
	IB_MIG_MIGRATED = 0,
	IB_MIG_REARM = 1,
	IB_MIG_ARMED = 2,
};

enum ib_mr_type {
	IB_MR_TYPE_MEM_REG = 0,
	IB_MR_TYPE_SG_GAPS = 1,
	IB_MR_TYPE_DM = 2,
	IB_MR_TYPE_USER = 3,
	IB_MR_TYPE_DMA = 4,
	IB_MR_TYPE_INTEGRITY = 5,
};

enum ib_mtu {
	IB_MTU_256 = 1,
	IB_MTU_512 = 2,
	IB_MTU_1024 = 3,
	IB_MTU_2048 = 4,
	IB_MTU_4096 = 5,
};

enum ib_mw_type {
	IB_MW_TYPE_1 = 1,
	IB_MW_TYPE_2 = 2,
};

enum ib_poll_context {
	IB_POLL_SOFTIRQ = 0,
	IB_POLL_WORKQUEUE = 1,
	IB_POLL_UNBOUND_WORKQUEUE = 2,
	IB_POLL_LAST_POOL_TYPE = 2,
	IB_POLL_DIRECT = 3,
};

enum ib_port_state {
	IB_PORT_NOP = 0,
	IB_PORT_DOWN = 1,
	IB_PORT_INIT = 2,
	IB_PORT_ARMED = 3,
	IB_PORT_ACTIVE = 4,
	IB_PORT_ACTIVE_DEFER = 5,
};

enum ib_qp_state {
	IB_QPS_RESET = 0,
	IB_QPS_INIT = 1,
	IB_QPS_RTR = 2,
	IB_QPS_RTS = 3,
	IB_QPS_SQD = 4,
	IB_QPS_SQE = 5,
	IB_QPS_ERR = 6,
};

enum ib_qp_type {
	IB_QPT_SMI = 0,
	IB_QPT_GSI = 1,
	IB_QPT_RC = 2,
	IB_QPT_UC = 3,
	IB_QPT_UD = 4,
	IB_QPT_RAW_IPV6 = 5,
	IB_QPT_RAW_ETHERTYPE = 6,
	IB_QPT_RAW_PACKET = 8,
	IB_QPT_XRC_INI = 9,
	IB_QPT_XRC_TGT = 10,
	IB_QPT_MAX = 11,
	IB_QPT_DRIVER = 255,
	IB_QPT_RESERVED1 = 4096,
	IB_QPT_RESERVED2 = 4097,
	IB_QPT_RESERVED3 = 4098,
	IB_QPT_RESERVED4 = 4099,
	IB_QPT_RESERVED5 = 4100,
	IB_QPT_RESERVED6 = 4101,
	IB_QPT_RESERVED7 = 4102,
	IB_QPT_RESERVED8 = 4103,
	IB_QPT_RESERVED9 = 4104,
	IB_QPT_RESERVED10 = 4105,
};

enum ib_sig_err_type {
	IB_SIG_BAD_GUARD = 0,
	IB_SIG_BAD_REFTAG = 1,
	IB_SIG_BAD_APPTAG = 2,
};

enum ib_sig_type {
	IB_SIGNAL_ALL_WR = 0,
	IB_SIGNAL_REQ_WR = 1,
};

enum ib_signature_type {
	IB_SIG_TYPE_NONE = 0,
	IB_SIG_TYPE_T10_DIF = 1,
};

enum ib_srq_attr_mask {
	IB_SRQ_MAX_WR = 1,
	IB_SRQ_LIMIT = 2,
};

enum ib_srq_type {
	IB_SRQT_BASIC = 0,
	IB_SRQT_XRC = 1,
	IB_SRQT_TM = 2,
};

enum ib_t10_dif_bg_type {
	IB_T10DIF_CRC = 0,
	IB_T10DIF_CSUM = 1,
};

enum ib_uverbs_access_flags {
	IB_UVERBS_ACCESS_LOCAL_WRITE = 1,
	IB_UVERBS_ACCESS_REMOTE_WRITE = 2,
	IB_UVERBS_ACCESS_REMOTE_READ = 4,
	IB_UVERBS_ACCESS_REMOTE_ATOMIC = 8,
	IB_UVERBS_ACCESS_MW_BIND = 16,
	IB_UVERBS_ACCESS_ZERO_BASED = 32,
	IB_UVERBS_ACCESS_ON_DEMAND = 64,
	IB_UVERBS_ACCESS_HUGETLB = 128,
	IB_UVERBS_ACCESS_FLUSH_GLOBAL = 256,
	IB_UVERBS_ACCESS_FLUSH_PERSISTENT = 512,
	IB_UVERBS_ACCESS_RELAXED_ORDERING = 1048576,
	IB_UVERBS_ACCESS_OPTIONAL_RANGE = 1072693248,
};

enum ib_uverbs_advise_mr_advice {
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH = 0,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_WRITE = 1,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_NO_FAULT = 2,
};

enum ib_uverbs_create_qp_mask {
	IB_UVERBS_CREATE_QP_MASK_IND_TABLE = 1,
};

enum ib_uverbs_device_cap_flags {
	IB_UVERBS_DEVICE_RESIZE_MAX_WR = 1ULL,
	IB_UVERBS_DEVICE_BAD_PKEY_CNTR = 2ULL,
	IB_UVERBS_DEVICE_BAD_QKEY_CNTR = 4ULL,
	IB_UVERBS_DEVICE_RAW_MULTI = 8ULL,
	IB_UVERBS_DEVICE_AUTO_PATH_MIG = 16ULL,
	IB_UVERBS_DEVICE_CHANGE_PHY_PORT = 32ULL,
	IB_UVERBS_DEVICE_UD_AV_PORT_ENFORCE = 64ULL,
	IB_UVERBS_DEVICE_CURR_QP_STATE_MOD = 128ULL,
	IB_UVERBS_DEVICE_SHUTDOWN_PORT = 256ULL,
	IB_UVERBS_DEVICE_PORT_ACTIVE_EVENT = 1024ULL,
	IB_UVERBS_DEVICE_SYS_IMAGE_GUID = 2048ULL,
	IB_UVERBS_DEVICE_RC_RNR_NAK_GEN = 4096ULL,
	IB_UVERBS_DEVICE_SRQ_RESIZE = 8192ULL,
	IB_UVERBS_DEVICE_N_NOTIFY_CQ = 16384ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW = 131072ULL,
	IB_UVERBS_DEVICE_UD_IP_CSUM = 262144ULL,
	IB_UVERBS_DEVICE_XRC = 1048576ULL,
	IB_UVERBS_DEVICE_MEM_MGT_EXTENSIONS = 2097152ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2A = 8388608ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2B = 16777216ULL,
	IB_UVERBS_DEVICE_RC_IP_CSUM = 33554432ULL,
	IB_UVERBS_DEVICE_RAW_IP_CSUM = 67108864ULL,
	IB_UVERBS_DEVICE_MANAGED_FLOW_STEERING = 536870912ULL,
	IB_UVERBS_DEVICE_RAW_SCATTER_FCS = 17179869184ULL,
	IB_UVERBS_DEVICE_PCI_WRITE_END_PADDING = 68719476736ULL,
	IB_UVERBS_DEVICE_FLUSH_GLOBAL = 274877906944ULL,
	IB_UVERBS_DEVICE_FLUSH_PERSISTENT = 549755813888ULL,
	IB_UVERBS_DEVICE_ATOMIC_WRITE = 1099511627776ULL,
};

enum ib_uverbs_gid_type {
	IB_UVERBS_GID_TYPE_IB = 0,
	IB_UVERBS_GID_TYPE_ROCE_V1 = 1,
	IB_UVERBS_GID_TYPE_ROCE_V2 = 2,
};

enum ib_uverbs_qp_create_flags {
	IB_UVERBS_QP_CREATE_BLOCK_MULTICAST_LOOPBACK = 2,
	IB_UVERBS_QP_CREATE_SCATTER_FCS = 256,
	IB_UVERBS_QP_CREATE_CVLAN_STRIPPING = 512,
	IB_UVERBS_QP_CREATE_PCI_WRITE_END_PADDING = 2048,
	IB_UVERBS_QP_CREATE_SQ_SIG_ALL = 4096,
};

enum ib_uverbs_qp_type {
	IB_UVERBS_QPT_RC = 2,
	IB_UVERBS_QPT_UC = 3,
	IB_UVERBS_QPT_UD = 4,
	IB_UVERBS_QPT_RAW_PACKET = 8,
	IB_UVERBS_QPT_XRC_INI = 9,
	IB_UVERBS_QPT_XRC_TGT = 10,
	IB_UVERBS_QPT_DRIVER = 255,
};

enum ib_uverbs_raw_packet_caps {
	IB_UVERBS_RAW_PACKET_CAP_CVLAN_STRIPPING = 1,
	IB_UVERBS_RAW_PACKET_CAP_SCATTER_FCS = 2,
	IB_UVERBS_RAW_PACKET_CAP_IP_CSUM = 4,
	IB_UVERBS_RAW_PACKET_CAP_DELAY_DROP = 8,
};

enum ib_uverbs_srq_type {
	IB_UVERBS_SRQT_BASIC = 0,
	IB_UVERBS_SRQT_XRC = 1,
	IB_UVERBS_SRQT_TM = 2,
};

enum ib_uverbs_wc_opcode {
	IB_UVERBS_WC_SEND = 0,
	IB_UVERBS_WC_RDMA_WRITE = 1,
	IB_UVERBS_WC_RDMA_READ = 2,
	IB_UVERBS_WC_COMP_SWAP = 3,
	IB_UVERBS_WC_FETCH_ADD = 4,
	IB_UVERBS_WC_BIND_MW = 5,
	IB_UVERBS_WC_LOCAL_INV = 6,
	IB_UVERBS_WC_TSO = 7,
	IB_UVERBS_WC_FLUSH = 8,
	IB_UVERBS_WC_ATOMIC_WRITE = 9,
};

enum ib_uverbs_wq_flags {
	IB_UVERBS_WQ_FLAGS_CVLAN_STRIPPING = 1,
	IB_UVERBS_WQ_FLAGS_SCATTER_FCS = 2,
	IB_UVERBS_WQ_FLAGS_DELAY_DROP = 4,
	IB_UVERBS_WQ_FLAGS_PCI_WRITE_END_PADDING = 8,
};

enum ib_uverbs_wq_type {
	IB_UVERBS_WQT_RQ = 0,
};

enum ib_uverbs_wr_opcode {
	IB_UVERBS_WR_RDMA_WRITE = 0,
	IB_UVERBS_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_UVERBS_WR_SEND = 2,
	IB_UVERBS_WR_SEND_WITH_IMM = 3,
	IB_UVERBS_WR_RDMA_READ = 4,
	IB_UVERBS_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_UVERBS_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_UVERBS_WR_LOCAL_INV = 7,
	IB_UVERBS_WR_BIND_MW = 8,
	IB_UVERBS_WR_SEND_WITH_INV = 9,
	IB_UVERBS_WR_TSO = 10,
	IB_UVERBS_WR_RDMA_READ_WITH_INV = 11,
	IB_UVERBS_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_UVERBS_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_UVERBS_WR_FLUSH = 14,
	IB_UVERBS_WR_ATOMIC_WRITE = 15,
};

enum ib_uverbs_write_cmds {
	IB_USER_VERBS_CMD_GET_CONTEXT = 0,
	IB_USER_VERBS_CMD_QUERY_DEVICE = 1,
	IB_USER_VERBS_CMD_QUERY_PORT = 2,
	IB_USER_VERBS_CMD_ALLOC_PD = 3,
	IB_USER_VERBS_CMD_DEALLOC_PD = 4,
	IB_USER_VERBS_CMD_CREATE_AH = 5,
	IB_USER_VERBS_CMD_MODIFY_AH = 6,
	IB_USER_VERBS_CMD_QUERY_AH = 7,
	IB_USER_VERBS_CMD_DESTROY_AH = 8,
	IB_USER_VERBS_CMD_REG_MR = 9,
	IB_USER_VERBS_CMD_REG_SMR = 10,
	IB_USER_VERBS_CMD_REREG_MR = 11,
	IB_USER_VERBS_CMD_QUERY_MR = 12,
	IB_USER_VERBS_CMD_DEREG_MR = 13,
	IB_USER_VERBS_CMD_ALLOC_MW = 14,
	IB_USER_VERBS_CMD_BIND_MW = 15,
	IB_USER_VERBS_CMD_DEALLOC_MW = 16,
	IB_USER_VERBS_CMD_CREATE_COMP_CHANNEL = 17,
	IB_USER_VERBS_CMD_CREATE_CQ = 18,
	IB_USER_VERBS_CMD_RESIZE_CQ = 19,
	IB_USER_VERBS_CMD_DESTROY_CQ = 20,
	IB_USER_VERBS_CMD_POLL_CQ = 21,
	IB_USER_VERBS_CMD_PEEK_CQ = 22,
	IB_USER_VERBS_CMD_REQ_NOTIFY_CQ = 23,
	IB_USER_VERBS_CMD_CREATE_QP = 24,
	IB_USER_VERBS_CMD_QUERY_QP = 25,
	IB_USER_VERBS_CMD_MODIFY_QP = 26,
	IB_USER_VERBS_CMD_DESTROY_QP = 27,
	IB_USER_VERBS_CMD_POST_SEND = 28,
	IB_USER_VERBS_CMD_POST_RECV = 29,
	IB_USER_VERBS_CMD_ATTACH_MCAST = 30,
	IB_USER_VERBS_CMD_DETACH_MCAST = 31,
	IB_USER_VERBS_CMD_CREATE_SRQ = 32,
	IB_USER_VERBS_CMD_MODIFY_SRQ = 33,
	IB_USER_VERBS_CMD_QUERY_SRQ = 34,
	IB_USER_VERBS_CMD_DESTROY_SRQ = 35,
	IB_USER_VERBS_CMD_POST_SRQ_RECV = 36,
	IB_USER_VERBS_CMD_OPEN_XRCD = 37,
	IB_USER_VERBS_CMD_CLOSE_XRCD = 38,
	IB_USER_VERBS_CMD_CREATE_XSRQ = 39,
	IB_USER_VERBS_CMD_OPEN_QP = 40,
};

enum ib_wc_opcode {
	IB_WC_SEND = 0,
	IB_WC_RDMA_WRITE = 1,
	IB_WC_RDMA_READ = 2,
	IB_WC_COMP_SWAP = 3,
	IB_WC_FETCH_ADD = 4,
	IB_WC_BIND_MW = 5,
	IB_WC_LOCAL_INV = 6,
	IB_WC_LSO = 7,
	IB_WC_ATOMIC_WRITE = 9,
	IB_WC_REG_MR = 10,
	IB_WC_MASKED_COMP_SWAP = 11,
	IB_WC_MASKED_FETCH_ADD = 12,
	IB_WC_FLUSH = 8,
	IB_WC_RECV = 128,
	IB_WC_RECV_RDMA_WITH_IMM = 129,
};

enum ib_wc_status {
	IB_WC_SUCCESS = 0,
	IB_WC_LOC_LEN_ERR = 1,
	IB_WC_LOC_QP_OP_ERR = 2,
	IB_WC_LOC_EEC_OP_ERR = 3,
	IB_WC_LOC_PROT_ERR = 4,
	IB_WC_WR_FLUSH_ERR = 5,
	IB_WC_MW_BIND_ERR = 6,
	IB_WC_BAD_RESP_ERR = 7,
	IB_WC_LOC_ACCESS_ERR = 8,
	IB_WC_REM_INV_REQ_ERR = 9,
	IB_WC_REM_ACCESS_ERR = 10,
	IB_WC_REM_OP_ERR = 11,
	IB_WC_RETRY_EXC_ERR = 12,
	IB_WC_RNR_RETRY_EXC_ERR = 13,
	IB_WC_LOC_RDD_VIOL_ERR = 14,
	IB_WC_REM_INV_RD_REQ_ERR = 15,
	IB_WC_REM_ABORT_ERR = 16,
	IB_WC_INV_EECN_ERR = 17,
	IB_WC_INV_EEC_STATE_ERR = 18,
	IB_WC_FATAL_ERR = 19,
	IB_WC_RESP_TIMEOUT_ERR = 20,
	IB_WC_GENERAL_ERR = 21,
};

enum ib_wq_state {
	IB_WQS_RESET = 0,
	IB_WQS_RDY = 1,
	IB_WQS_ERR = 2,
};

enum ib_wq_type {
	IB_WQT_RQ = 0,
};

enum ib_wr_opcode {
	IB_WR_RDMA_WRITE = 0,
	IB_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_WR_SEND = 2,
	IB_WR_SEND_WITH_IMM = 3,
	IB_WR_RDMA_READ = 4,
	IB_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_WR_BIND_MW = 8,
	IB_WR_LSO = 10,
	IB_WR_SEND_WITH_INV = 9,
	IB_WR_RDMA_READ_WITH_INV = 11,
	IB_WR_LOCAL_INV = 7,
	IB_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_WR_FLUSH = 14,
	IB_WR_ATOMIC_WRITE = 15,
	IB_WR_REG_MR = 32,
	IB_WR_REG_MR_INTEGRITY = 33,
	IB_WR_RESERVED1 = 240,
	IB_WR_RESERVED2 = 241,
	IB_WR_RESERVED3 = 242,
	IB_WR_RESERVED4 = 243,
	IB_WR_RESERVED5 = 244,
	IB_WR_RESERVED6 = 245,
	IB_WR_RESERVED7 = 246,
	IB_WR_RESERVED8 = 247,
	IB_WR_RESERVED9 = 248,
	IB_WR_RESERVED10 = 249,
};

enum icl_lc_mailbox_cmd {
	ICL_LC_GO2SX = 2,
	ICL_LC_GO2SX_NO_WAKE = 3,
	ICL_LC_PREPARE_FOR_RESET = 33,
};

enum icm_event_code {
	ICM_EVENT_DEVICE_CONNECTED = 3,
	ICM_EVENT_DEVICE_DISCONNECTED = 4,
	ICM_EVENT_XDOMAIN_CONNECTED = 6,
	ICM_EVENT_XDOMAIN_DISCONNECTED = 7,
	ICM_EVENT_RTD3_VETO = 10,
};

enum icm_pkg_code {
	ICM_GET_TOPOLOGY = 1,
	ICM_DRIVER_READY = 3,
	ICM_APPROVE_DEVICE = 4,
	ICM_CHALLENGE_DEVICE = 5,
	ICM_ADD_DEVICE_KEY = 6,
	ICM_GET_ROUTE = 10,
	ICM_APPROVE_XDOMAIN = 16,
	ICM_DISCONNECT_XDOMAIN = 17,
	ICM_PREBOOT_ACL = 24,
	ICM_USB4_SWITCH_OP = 32,
};

enum idle_boot_override {
	IDLE_NO_OVERRIDE = 0,
	IDLE_HALT = 1,
	IDLE_NOMWAIT = 2,
	IDLE_POLL = 3,
};

enum ieee1284_phase {
	IEEE1284_PH_FWD_DATA = 0,
	IEEE1284_PH_FWD_IDLE = 1,
	IEEE1284_PH_TERMINATE = 2,
	IEEE1284_PH_NEGOTIATION = 3,
	IEEE1284_PH_HBUSY_DNA = 4,
	IEEE1284_PH_REV_IDLE = 5,
	IEEE1284_PH_HBUSY_DAVAIL = 6,
	IEEE1284_PH_REV_DATA = 7,
	IEEE1284_PH_ECP_SETUP = 8,
	IEEE1284_PH_ECP_FWD_TO_REV = 9,
	IEEE1284_PH_ECP_REV_TO_FWD = 10,
	IEEE1284_PH_ECP_DIR_UNKNOWN = 11,
};

enum ieee80211_bss_type {
	IEEE80211_BSS_TYPE_ESS = 0,
	IEEE80211_BSS_TYPE_PBSS = 1,
	IEEE80211_BSS_TYPE_IBSS = 2,
	IEEE80211_BSS_TYPE_MBSS = 3,
	IEEE80211_BSS_TYPE_ANY = 4,
};

enum ieee80211_edmg_bw_config {
	IEEE80211_EDMG_BW_CONFIG_4 = 4,
	IEEE80211_EDMG_BW_CONFIG_5 = 5,
	IEEE80211_EDMG_BW_CONFIG_6 = 6,
	IEEE80211_EDMG_BW_CONFIG_7 = 7,
	IEEE80211_EDMG_BW_CONFIG_8 = 8,
	IEEE80211_EDMG_BW_CONFIG_9 = 9,
	IEEE80211_EDMG_BW_CONFIG_10 = 10,
	IEEE80211_EDMG_BW_CONFIG_11 = 11,
	IEEE80211_EDMG_BW_CONFIG_12 = 12,
	IEEE80211_EDMG_BW_CONFIG_13 = 13,
	IEEE80211_EDMG_BW_CONFIG_14 = 14,
	IEEE80211_EDMG_BW_CONFIG_15 = 15,
};

enum ifla_vxlan_df {
	VXLAN_DF_UNSET = 0,
	VXLAN_DF_SET = 1,
	VXLAN_DF_INHERIT = 2,
	__VXLAN_DF_END = 3,
	VXLAN_DF_MAX = 2,
};

enum ifla_vxlan_label_policy {
	VXLAN_LABEL_FIXED = 0,
	VXLAN_LABEL_INHERIT = 1,
	__VXLAN_LABEL_END = 2,
	VXLAN_LABEL_MAX = 1,
};

enum igb_boards {
	board_82575 = 0,
};

enum igb_diagnostics_results {
	TEST_REG = 0,
	TEST_EEP = 1,
	TEST_IRQ = 2,
	TEST_LOOP = 3,
	TEST_LINK = 4,
};

enum igb_filter_match_flags {
	IGB_FILTER_FLAG_ETHER_TYPE = 1,
	IGB_FILTER_FLAG_VLAN_TCI = 2,
	IGB_FILTER_FLAG_SRC_MAC_ADDR = 4,
	IGB_FILTER_FLAG_DST_MAC_ADDR = 8,
};

enum igb_tx_buf_type {
	IGB_TYPE_SKB = 0,
	IGB_TYPE_XDP = 1,
	IGB_TYPE_XSK = 2,
};

enum igb_tx_flags {
	IGB_TX_FLAGS_VLAN = 1,
	IGB_TX_FLAGS_TSO = 2,
	IGB_TX_FLAGS_TSTAMP = 4,
	IGB_TX_FLAGS_IPV4 = 16,
	IGB_TX_FLAGS_CSUM = 32,
};

enum in6_addr_gen_mode {
	IN6_ADDR_GEN_MODE_EUI64 = 0,
	IN6_ADDR_GEN_MODE_NONE = 1,
	IN6_ADDR_GEN_MODE_STABLE_PRIVACY = 2,
	IN6_ADDR_GEN_MODE_RANDOM = 3,
};

enum inet_csk_ack_state_t {
	ICSK_ACK_SCHED = 1,
	ICSK_ACK_TIMER = 2,
	ICSK_ACK_PUSHED = 4,
	ICSK_ACK_PUSHED2 = 8,
	ICSK_ACK_NOW = 16,
	ICSK_ACK_NOMEM = 32,
};

enum inode_i_mutex_lock_class {
	I_MUTEX_NORMAL = 0,
	I_MUTEX_PARENT = 1,
	I_MUTEX_CHILD = 2,
	I_MUTEX_XATTR = 3,
	I_MUTEX_NONDIR2 = 4,
	I_MUTEX_PARENT2 = 5,
};

enum inode_state {
	inode_state_no_change = 0,
	inode_state_will_create = 1,
	inode_state_did_create = 2,
	inode_state_will_delete = 3,
	inode_state_did_delete = 4,
};

enum inplace_mode {
	OUT_OF_PLACE = 0,
	INPLACE_ONE_SGLIST = 1,
	INPLACE_TWO_SGLISTS = 2,
};

enum input_clock_type {
	INPUT_CLK_REAL = 0,
	INPUT_CLK_MONO = 1,
	INPUT_CLK_BOOT = 2,
	INPUT_CLK_MAX = 3,
};

enum invtlb_ops {
	INVTLB_ALL = 0,
	INVTLB_CURRENT_ALL = 1,
	INVTLB_CURRENT_GTRUE = 2,
	INVTLB_CURRENT_GFALSE = 3,
	INVTLB_GFALSE_AND_ASID = 4,
	INVTLB_ADDR_GFALSE_AND_ASID = 5,
	INVTLB_ADDR_GTRUE_OR_ASID = 6,
	INVGTLB_GID = 9,
	INVGTLB_GID_GTRUE = 10,
	INVGTLB_GID_GFALSE = 11,
	INVGTLB_GID_GFALSE_ASID = 12,
	INVGTLB_GID_GFALSE_ASID_ADDR = 13,
	INVGTLB_GID_GTRUE_ASID_ADDR = 14,
	INVGTLB_ALLGID_GVA_TO_GPA = 16,
	INVTLB_ALLGID_GPA_TO_HPA = 17,
	INVTLB_ALLGID = 18,
	INVGTLB_GID_GVA_TO_GPA = 19,
	INVTLB_GID_GPA_TO_HPA = 20,
	INVTLB_GID_ALL = 21,
	INVTLB_GID_ADDR = 22,
};

enum io_uring_cmd_flags {
	IO_URING_F_COMPLETE_DEFER = 1,
	IO_URING_F_UNLOCKED = 2,
	IO_URING_F_MULTISHOT = 4,
	IO_URING_F_IOWQ = 8,
	IO_URING_F_NONBLOCK = -2147483648,
	IO_URING_F_SQE128 = 256,
	IO_URING_F_CQE32 = 512,
	IO_URING_F_IOPOLL = 1024,
	IO_URING_F_CANCEL = 2048,
	IO_URING_F_COMPAT = 4096,
	IO_URING_F_TASK_DEAD = 8192,
};

enum io_uring_msg_ring_flags {
	IORING_MSG_DATA = 0,
	IORING_MSG_SEND_FD = 1,
};

enum io_uring_napi_op {
	IO_URING_NAPI_REGISTER_OP = 0,
	IO_URING_NAPI_STATIC_ADD_ID = 1,
	IO_URING_NAPI_STATIC_DEL_ID = 2,
};

enum io_uring_napi_tracking_strategy {
	IO_URING_NAPI_TRACKING_DYNAMIC = 0,
	IO_URING_NAPI_TRACKING_STATIC = 1,
	IO_URING_NAPI_TRACKING_INACTIVE = 255,
};

enum io_uring_op {
	IORING_OP_NOP = 0,
	IORING_OP_READV = 1,
	IORING_OP_WRITEV = 2,
	IORING_OP_FSYNC = 3,
	IORING_OP_READ_FIXED = 4,
	IORING_OP_WRITE_FIXED = 5,
	IORING_OP_POLL_ADD = 6,
	IORING_OP_POLL_REMOVE = 7,
	IORING_OP_SYNC_FILE_RANGE = 8,
	IORING_OP_SENDMSG = 9,
	IORING_OP_RECVMSG = 10,
	IORING_OP_TIMEOUT = 11,
	IORING_OP_TIMEOUT_REMOVE = 12,
	IORING_OP_ACCEPT = 13,
	IORING_OP_ASYNC_CANCEL = 14,
	IORING_OP_LINK_TIMEOUT = 15,
	IORING_OP_CONNECT = 16,
	IORING_OP_FALLOCATE = 17,
	IORING_OP_OPENAT = 18,
	IORING_OP_CLOSE = 19,
	IORING_OP_FILES_UPDATE = 20,
	IORING_OP_STATX = 21,
	IORING_OP_READ = 22,
	IORING_OP_WRITE = 23,
	IORING_OP_FADVISE = 24,
	IORING_OP_MADVISE = 25,
	IORING_OP_SEND = 26,
	IORING_OP_RECV = 27,
	IORING_OP_OPENAT2 = 28,
	IORING_OP_EPOLL_CTL = 29,
	IORING_OP_SPLICE = 30,
	IORING_OP_PROVIDE_BUFFERS = 31,
	IORING_OP_REMOVE_BUFFERS = 32,
	IORING_OP_TEE = 33,
	IORING_OP_SHUTDOWN = 34,
	IORING_OP_RENAMEAT = 35,
	IORING_OP_UNLINKAT = 36,
	IORING_OP_MKDIRAT = 37,
	IORING_OP_SYMLINKAT = 38,
	IORING_OP_LINKAT = 39,
	IORING_OP_MSG_RING = 40,
	IORING_OP_FSETXATTR = 41,
	IORING_OP_SETXATTR = 42,
	IORING_OP_FGETXATTR = 43,
	IORING_OP_GETXATTR = 44,
	IORING_OP_SOCKET = 45,
	IORING_OP_URING_CMD = 46,
	IORING_OP_SEND_ZC = 47,
	IORING_OP_SENDMSG_ZC = 48,
	IORING_OP_READ_MULTISHOT = 49,
	IORING_OP_WAITID = 50,
	IORING_OP_FUTEX_WAIT = 51,
	IORING_OP_FUTEX_WAKE = 52,
	IORING_OP_FUTEX_WAITV = 53,
	IORING_OP_FIXED_FD_INSTALL = 54,
	IORING_OP_FTRUNCATE = 55,
	IORING_OP_BIND = 56,
	IORING_OP_LISTEN = 57,
	IORING_OP_LAST = 58,
};

enum io_uring_register_op {
	IORING_REGISTER_BUFFERS = 0,
	IORING_UNREGISTER_BUFFERS = 1,
	IORING_REGISTER_FILES = 2,
	IORING_UNREGISTER_FILES = 3,
	IORING_REGISTER_EVENTFD = 4,
	IORING_UNREGISTER_EVENTFD = 5,
	IORING_REGISTER_FILES_UPDATE = 6,
	IORING_REGISTER_EVENTFD_ASYNC = 7,
	IORING_REGISTER_PROBE = 8,
	IORING_REGISTER_PERSONALITY = 9,
	IORING_UNREGISTER_PERSONALITY = 10,
	IORING_REGISTER_RESTRICTIONS = 11,
	IORING_REGISTER_ENABLE_RINGS = 12,
	IORING_REGISTER_FILES2 = 13,
	IORING_REGISTER_FILES_UPDATE2 = 14,
	IORING_REGISTER_BUFFERS2 = 15,
	IORING_REGISTER_BUFFERS_UPDATE = 16,
	IORING_REGISTER_IOWQ_AFF = 17,
	IORING_UNREGISTER_IOWQ_AFF = 18,
	IORING_REGISTER_IOWQ_MAX_WORKERS = 19,
	IORING_REGISTER_RING_FDS = 20,
	IORING_UNREGISTER_RING_FDS = 21,
	IORING_REGISTER_PBUF_RING = 22,
	IORING_UNREGISTER_PBUF_RING = 23,
	IORING_REGISTER_SYNC_CANCEL = 24,
	IORING_REGISTER_FILE_ALLOC_RANGE = 25,
	IORING_REGISTER_PBUF_STATUS = 26,
	IORING_REGISTER_NAPI = 27,
	IORING_UNREGISTER_NAPI = 28,
	IORING_REGISTER_CLOCK = 29,
	IORING_REGISTER_CLONE_BUFFERS = 30,
	IORING_REGISTER_SEND_MSG_RING = 31,
	IORING_REGISTER_RESIZE_RINGS = 33,
	IORING_REGISTER_MEM_REGION = 34,
	IORING_REGISTER_LAST = 35,
	IORING_REGISTER_USE_REGISTERED_RING = 2147483648,
};

enum io_uring_register_pbuf_ring_flags {
	IOU_PBUF_RING_MMAP = 1,
	IOU_PBUF_RING_INC = 2,
};

enum io_uring_register_restriction_op {
	IORING_RESTRICTION_REGISTER_OP = 0,
	IORING_RESTRICTION_SQE_OP = 1,
	IORING_RESTRICTION_SQE_FLAGS_ALLOWED = 2,
	IORING_RESTRICTION_SQE_FLAGS_REQUIRED = 3,
	IORING_RESTRICTION_LAST = 4,
};

enum io_uring_socket_op {
	SOCKET_URING_OP_SIOCINQ = 0,
	SOCKET_URING_OP_SIOCOUTQ = 1,
	SOCKET_URING_OP_GETSOCKOPT = 2,
	SOCKET_URING_OP_SETSOCKOPT = 3,
};

enum io_uring_sqe_flags_bit {
	IOSQE_FIXED_FILE_BIT = 0,
	IOSQE_IO_DRAIN_BIT = 1,
	IOSQE_IO_LINK_BIT = 2,
	IOSQE_IO_HARDLINK_BIT = 3,
	IOSQE_ASYNC_BIT = 4,
	IOSQE_BUFFER_SELECT_BIT = 5,
	IOSQE_CQE_SKIP_SUCCESS_BIT = 6,
};

enum io_wq_cancel {
	IO_WQ_CANCEL_OK = 0,
	IO_WQ_CANCEL_RUNNING = 1,
	IO_WQ_CANCEL_NOTFOUND = 2,
};

enum io_wq_type {
	IO_WQ_BOUND = 0,
	IO_WQ_UNBOUND = 1,
};

enum ioam6_event_attr {
	IOAM6_EVENT_ATTR_UNSPEC = 0,
	IOAM6_EVENT_ATTR_TRACE_NAMESPACE = 1,
	IOAM6_EVENT_ATTR_TRACE_NODELEN = 2,
	IOAM6_EVENT_ATTR_TRACE_TYPE = 3,
	IOAM6_EVENT_ATTR_TRACE_DATA = 4,
	__IOAM6_EVENT_ATTR_MAX = 5,
};

enum ioam6_event_type {
	IOAM6_EVENT_UNSPEC = 0,
	IOAM6_EVENT_TRACE = 1,
};

enum ioc_running {
	IOC_IDLE = 0,
	IOC_RUNNING = 1,
	IOC_STOP = 2,
};

enum iommu_cap {
	IOMMU_CAP_CACHE_COHERENCY = 0,
	IOMMU_CAP_NOEXEC = 1,
	IOMMU_CAP_PRE_BOOT_PROTECTION = 2,
	IOMMU_CAP_ENFORCE_CACHE_COHERENCY = 3,
	IOMMU_CAP_DEFERRED_FLUSH = 4,
	IOMMU_CAP_DIRTY_TRACKING = 5,
};

enum iommu_dev_features {
	IOMMU_DEV_FEAT_SVA = 0,
	IOMMU_DEV_FEAT_IOPF = 1,
};

enum iommu_resv_type {
	IOMMU_RESV_DIRECT = 0,
	IOMMU_RESV_DIRECT_RELAXABLE = 1,
	IOMMU_RESV_RESERVED = 2,
	IOMMU_RESV_MSI = 3,
	IOMMU_RESV_SW_MSI = 4,
};

enum iommufd_hwpt_alloc_flags {
	IOMMU_HWPT_ALLOC_NEST_PARENT = 1,
	IOMMU_HWPT_ALLOC_DIRTY_TRACKING = 2,
	IOMMU_HWPT_FAULT_ID_VALID = 4,
	IOMMU_HWPT_ALLOC_PASID = 8,
};

enum ip6_defrag_users {
	IP6_DEFRAG_LOCAL_DELIVER = 0,
	IP6_DEFRAG_CONNTRACK_IN = 1,
	__IP6_DEFRAG_CONNTRACK_IN = 65536,
	IP6_DEFRAG_CONNTRACK_OUT = 65537,
	__IP6_DEFRAG_CONNTRACK_OUT = 131072,
	IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 131073,
	__IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 196608,
};

enum ip_conntrack_dir {
	IP_CT_DIR_ORIGINAL = 0,
	IP_CT_DIR_REPLY = 1,
	IP_CT_DIR_MAX = 2,
};

enum ip_conntrack_info {
	IP_CT_ESTABLISHED = 0,
	IP_CT_RELATED = 1,
	IP_CT_NEW = 2,
	IP_CT_IS_REPLY = 3,
	IP_CT_ESTABLISHED_REPLY = 3,
	IP_CT_RELATED_REPLY = 4,
	IP_CT_NUMBER = 5,
	IP_CT_UNTRACKED = 7,
};

enum ip_conntrack_status {
	IPS_EXPECTED_BIT = 0,
	IPS_EXPECTED = 1,
	IPS_SEEN_REPLY_BIT = 1,
	IPS_SEEN_REPLY = 2,
	IPS_ASSURED_BIT = 2,
	IPS_ASSURED = 4,
	IPS_CONFIRMED_BIT = 3,
	IPS_CONFIRMED = 8,
	IPS_SRC_NAT_BIT = 4,
	IPS_SRC_NAT = 16,
	IPS_DST_NAT_BIT = 5,
	IPS_DST_NAT = 32,
	IPS_NAT_MASK = 48,
	IPS_SEQ_ADJUST_BIT = 6,
	IPS_SEQ_ADJUST = 64,
	IPS_SRC_NAT_DONE_BIT = 7,
	IPS_SRC_NAT_DONE = 128,
	IPS_DST_NAT_DONE_BIT = 8,
	IPS_DST_NAT_DONE = 256,
	IPS_NAT_DONE_MASK = 384,
	IPS_DYING_BIT = 9,
	IPS_DYING = 512,
	IPS_FIXED_TIMEOUT_BIT = 10,
	IPS_FIXED_TIMEOUT = 1024,
	IPS_TEMPLATE_BIT = 11,
	IPS_TEMPLATE = 2048,
	IPS_UNTRACKED_BIT = 12,
	IPS_UNTRACKED = 4096,
	IPS_NAT_CLASH_BIT = 12,
	IPS_NAT_CLASH = 4096,
	IPS_HELPER_BIT = 13,
	IPS_HELPER = 8192,
	IPS_OFFLOAD_BIT = 14,
	IPS_OFFLOAD = 16384,
	IPS_HW_OFFLOAD_BIT = 15,
	IPS_HW_OFFLOAD = 32768,
	IPS_UNCHANGEABLE_MASK = 56313,
	__IPS_MAX_BIT = 16,
};

enum ip_defrag_users {
	IP_DEFRAG_LOCAL_DELIVER = 0,
	IP_DEFRAG_CALL_RA_CHAIN = 1,
	IP_DEFRAG_CONNTRACK_IN = 2,
	__IP_DEFRAG_CONNTRACK_IN_END = 65537,
	IP_DEFRAG_CONNTRACK_OUT = 65538,
	__IP_DEFRAG_CONNTRACK_OUT_END = 131073,
	IP_DEFRAG_CONNTRACK_BRIDGE_IN = 131074,
	__IP_DEFRAG_CONNTRACK_BRIDGE_IN = 196609,
	IP_DEFRAG_VS_IN = 196610,
	IP_DEFRAG_VS_OUT = 196611,
	IP_DEFRAG_VS_FWD = 196612,
	IP_DEFRAG_AF_PACKET = 196613,
	IP_DEFRAG_MACVLAN = 196614,
};

enum ipi_msg_type {
	IPI_RESCHEDULE = 0,
	IPI_CALL_FUNCTION = 1,
	IPI_IRQ_WORK = 2,
	IPI_CLEAR_VECTOR = 3,
};

enum ipmi_addr_space {
	IPMI_IO_ADDR_SPACE = 0,
	IPMI_MEM_ADDR_SPACE = 1,
};

enum ipmi_addr_src {
	SI_INVALID = 0,
	SI_HOTMOD = 1,
	SI_HARDCODED = 2,
	SI_SPMI = 3,
	SI_ACPI = 4,
	SI_SMBIOS = 5,
	SI_PCI = 6,
	SI_DEVICETREE = 7,
	SI_PLATFORM = 8,
	SI_LAST = 9,
};

enum ipmi_plat_interface_type {
	IPMI_PLAT_IF_SI = 0,
	IPMI_PLAT_IF_SSIF = 1,
};

enum irq_domain_bus_token {
	DOMAIN_BUS_ANY = 0,
	DOMAIN_BUS_WIRED = 1,
	DOMAIN_BUS_GENERIC_MSI = 2,
	DOMAIN_BUS_PCI_MSI = 3,
	DOMAIN_BUS_PLATFORM_MSI = 4,
	DOMAIN_BUS_NEXUS = 5,
	DOMAIN_BUS_IPI = 6,
	DOMAIN_BUS_FSL_MC_MSI = 7,
	DOMAIN_BUS_TI_SCI_INTA_MSI = 8,
	DOMAIN_BUS_WAKEUP = 9,
	DOMAIN_BUS_VMD_MSI = 10,
	DOMAIN_BUS_PCI_DEVICE_MSI = 11,
	DOMAIN_BUS_PCI_DEVICE_MSIX = 12,
	DOMAIN_BUS_DMAR = 13,
	DOMAIN_BUS_AMDVI = 14,
	DOMAIN_BUS_DEVICE_MSI = 15,
	DOMAIN_BUS_WIRED_TO_MSI = 16,
};

enum irq_gc_flags {
	IRQ_GC_INIT_MASK_CACHE = 1,
	IRQ_GC_INIT_NESTED_LOCK = 2,
	IRQ_GC_MASK_CACHE_PER_TYPE = 4,
	IRQ_GC_NO_MASK = 8,
	IRQ_GC_BE_IO = 16,
};

enum irqchip_irq_state {
	IRQCHIP_STATE_PENDING = 0,
	IRQCHIP_STATE_ACTIVE = 1,
	IRQCHIP_STATE_MASKED = 2,
	IRQCHIP_STATE_LINE_LEVEL = 3,
};

enum irqreturn {
	IRQ_NONE = 0,
	IRQ_HANDLED = 1,
	IRQ_WAKE_THREAD = 2,
};

typedef enum irqreturn irqreturn_t;

enum isofs_file_format {
	isofs_file_normal = 0,
	isofs_file_sparse = 1,
	isofs_file_compressed = 2,
};

enum iter_type {
	ITER_UBUF = 0,
	ITER_IOVEC = 1,
	ITER_BVEC = 2,
	ITER_KVEC = 3,
	ITER_FOLIOQ = 4,
	ITER_XARRAY = 5,
	ITER_DISCARD = 6,
};

enum ixgbe_aci_err {
	IXGBE_ACI_RC_OK = 0,
	IXGBE_ACI_RC_EPERM = 1,
	IXGBE_ACI_RC_ENOENT = 2,
	IXGBE_ACI_RC_ESRCH = 3,
	IXGBE_ACI_RC_EINTR = 4,
	IXGBE_ACI_RC_EIO = 5,
	IXGBE_ACI_RC_ENXIO = 6,
	IXGBE_ACI_RC_E2BIG = 7,
	IXGBE_ACI_RC_EAGAIN = 8,
	IXGBE_ACI_RC_ENOMEM = 9,
	IXGBE_ACI_RC_EACCES = 10,
	IXGBE_ACI_RC_EFAULT = 11,
	IXGBE_ACI_RC_EBUSY = 12,
	IXGBE_ACI_RC_EEXIST = 13,
	IXGBE_ACI_RC_EINVAL = 14,
	IXGBE_ACI_RC_ENOTTY = 15,
	IXGBE_ACI_RC_ENOSPC = 16,
	IXGBE_ACI_RC_ENOSYS = 17,
	IXGBE_ACI_RC_ERANGE = 18,
	IXGBE_ACI_RC_EFLUSHED = 19,
	IXGBE_ACI_RC_BAD_ADDR = 20,
	IXGBE_ACI_RC_EMODE = 21,
	IXGBE_ACI_RC_EFBIG = 22,
	IXGBE_ACI_RC_ESBCOMP = 23,
	IXGBE_ACI_RC_ENOSEC = 24,
	IXGBE_ACI_RC_EBADSIG = 25,
	IXGBE_ACI_RC_ESVN = 26,
	IXGBE_ACI_RC_EBADMAN = 27,
	IXGBE_ACI_RC_EBADBUF = 28,
	IXGBE_ACI_RC_EACCES_BMCU = 29,
};

enum ixgbe_aci_opc {
	ixgbe_aci_opc_get_ver = 1,
	ixgbe_aci_opc_driver_ver = 2,
	ixgbe_aci_opc_get_exp_err = 5,
	ixgbe_aci_opc_req_res = 8,
	ixgbe_aci_opc_release_res = 9,
	ixgbe_aci_opc_list_func_caps = 10,
	ixgbe_aci_opc_list_dev_caps = 11,
	ixgbe_aci_opc_disable_rxen = 12,
	ixgbe_aci_opc_get_fw_event = 20,
	ixgbe_aci_opc_get_phy_caps = 1536,
	ixgbe_aci_opc_set_phy_cfg = 1537,
	ixgbe_aci_opc_restart_an = 1541,
	ixgbe_aci_opc_get_link_status = 1543,
	ixgbe_aci_opc_set_event_mask = 1555,
	ixgbe_aci_opc_get_link_topo = 1760,
	ixgbe_aci_opc_get_link_topo_pin = 1761,
	ixgbe_aci_opc_read_i2c = 1762,
	ixgbe_aci_opc_write_i2c = 1763,
	ixgbe_aci_opc_read_mdio = 1764,
	ixgbe_aci_opc_write_mdio = 1765,
	ixgbe_aci_opc_set_gpio_by_func = 1766,
	ixgbe_aci_opc_get_gpio_by_func = 1767,
	ixgbe_aci_opc_set_gpio = 1772,
	ixgbe_aci_opc_get_gpio = 1773,
	ixgbe_aci_opc_sff_eeprom = 1774,
	ixgbe_aci_opc_prog_topo_dev_nvm = 1778,
	ixgbe_aci_opc_read_topo_dev_nvm = 1779,
	ixgbe_aci_opc_nvm_read = 1793,
	ixgbe_aci_opc_nvm_erase = 1794,
	ixgbe_aci_opc_nvm_write = 1795,
	ixgbe_aci_opc_nvm_cfg_read = 1796,
	ixgbe_aci_opc_nvm_cfg_write = 1797,
	ixgbe_aci_opc_nvm_checksum = 1798,
	ixgbe_aci_opc_nvm_write_activate = 1799,
	ixgbe_aci_opc_nvm_sr_dump = 1799,
	ixgbe_aci_opc_nvm_save_factory_settings = 1800,
	ixgbe_aci_opc_nvm_update_empr = 1801,
	ixgbe_aci_opc_nvm_pkg_data = 1802,
	ixgbe_aci_opc_nvm_pass_component_tbl = 1803,
	ixgbe_aci_opc_write_alt_direct = 2304,
	ixgbe_aci_opc_write_alt_indirect = 2305,
	ixgbe_aci_opc_read_alt_direct = 2306,
	ixgbe_aci_opc_read_alt_indirect = 2307,
	ixgbe_aci_opc_done_alt_write = 2308,
	ixgbe_aci_opc_clear_port_alt_write = 2310,
	ixgbe_aci_opc_debug_dump_internals = 65288,
	ixgbe_aci_opc_set_health_status_config = 65312,
	ixgbe_aci_opc_get_supported_health_status_codes = 65313,
	ixgbe_aci_opc_get_health_status = 65314,
	ixgbe_aci_opc_clear_health_status = 65315,
};

enum ixgbe_aci_res_access_type {
	IXGBE_RES_READ = 1,
	IXGBE_RES_WRITE = 2,
};

enum ixgbe_aci_res_ids {
	IXGBE_NVM_RES_ID = 1,
	IXGBE_SPD_RES_ID = 2,
	IXGBE_CHANGE_LOCK_RES_ID = 3,
	IXGBE_GLOBAL_CFG_LOCK_RES_ID = 4,
};

enum ixgbe_atr_flow_type {
	IXGBE_ATR_FLOW_TYPE_IPV4 = 0,
	IXGBE_ATR_FLOW_TYPE_UDPV4 = 1,
	IXGBE_ATR_FLOW_TYPE_TCPV4 = 2,
	IXGBE_ATR_FLOW_TYPE_SCTPV4 = 3,
	IXGBE_ATR_FLOW_TYPE_IPV6 = 4,
	IXGBE_ATR_FLOW_TYPE_UDPV6 = 5,
	IXGBE_ATR_FLOW_TYPE_TCPV6 = 6,
	IXGBE_ATR_FLOW_TYPE_SCTPV6 = 7,
};

enum ixgbe_boards {
	board_82598 = 0,
	board_82599 = 1,
	board_X540 = 2,
	board_X550 = 3,
	board_X550EM_x = 4,
	board_x550em_x_fw = 5,
	board_x550em_a = 6,
	board_x550em_a_fw = 7,
	board_e610 = 8,
};

enum ixgbe_bus_speed {
	ixgbe_bus_speed_unknown = 0,
	ixgbe_bus_speed_33 = 33,
	ixgbe_bus_speed_66 = 66,
	ixgbe_bus_speed_100 = 100,
	ixgbe_bus_speed_120 = 120,
	ixgbe_bus_speed_133 = 133,
	ixgbe_bus_speed_2500 = 2500,
	ixgbe_bus_speed_5000 = 5000,
	ixgbe_bus_speed_8000 = 8000,
	ixgbe_bus_speed_reserved = 8001,
};

enum ixgbe_bus_type {
	ixgbe_bus_type_unknown = 0,
	ixgbe_bus_type_pci_express = 1,
	ixgbe_bus_type_internal = 2,
	ixgbe_bus_type_reserved = 3,
};

enum ixgbe_bus_width {
	ixgbe_bus_width_unknown = 0,
	ixgbe_bus_width_pcie_x1 = 1,
	ixgbe_bus_width_pcie_x2 = 2,
	ixgbe_bus_width_pcie_x4 = 4,
	ixgbe_bus_width_pcie_x8 = 8,
	ixgbe_bus_width_32 = 32,
	ixgbe_bus_width_64 = 64,
	ixgbe_bus_width_reserved = 65,
};

enum ixgbe_eeprom_type {
	ixgbe_eeprom_uninitialized = 0,
	ixgbe_eeprom_spi = 1,
	ixgbe_flash = 2,
	ixgbe_eeprom_none = 3,
};

enum ixgbe_fc_mode {
	ixgbe_fc_none = 0,
	ixgbe_fc_rx_pause = 1,
	ixgbe_fc_tx_pause = 2,
	ixgbe_fc_full = 3,
	ixgbe_fc_default = 4,
	ixgbe_fc_pfc = 5,
};

enum ixgbe_fdir_pballoc_type {
	IXGBE_FDIR_PBALLOC_NONE = 0,
	IXGBE_FDIR_PBALLOC_64K = 1,
	IXGBE_FDIR_PBALLOC_128K = 2,
	IXGBE_FDIR_PBALLOC_256K = 3,
};

enum ixgbe_flash_bank {
	IXGBE_INVALID_FLASH_BANK = 0,
	IXGBE_1ST_FLASH_BANK = 1,
	IXGBE_2ND_FLASH_BANK = 2,
};

enum ixgbe_ipsec_tbl_sel {
	ips_rx_ip_tbl = 1,
	ips_rx_spi_tbl = 2,
	ips_rx_key_tbl = 3,
};

enum ixgbe_mac_type {
	ixgbe_mac_unknown = 0,
	ixgbe_mac_82598EB = 1,
	ixgbe_mac_82599EB = 2,
	ixgbe_mac_X540 = 3,
	ixgbe_mac_X550 = 4,
	ixgbe_mac_X550EM_x = 5,
	ixgbe_mac_x550em_a = 6,
	ixgbe_mac_e610 = 7,
	ixgbe_mac_e610_vf = 8,
	ixgbe_num_macs = 9,
};

enum ixgbe_media_type {
	ixgbe_media_type_unknown = 0,
	ixgbe_media_type_fiber = 1,
	ixgbe_media_type_fiber_qsfp = 2,
	ixgbe_media_type_fiber_lco = 3,
	ixgbe_media_type_copper = 4,
	ixgbe_media_type_backplane = 5,
	ixgbe_media_type_cx4 = 6,
	ixgbe_media_type_virtual = 7,
	ixgbe_media_type_da = 8,
	ixgbe_media_type_aui = 9,
};

enum ixgbe_mvals {
	IXGBE_EEC_IDX = 0,
	IXGBE_FLA_IDX = 1,
	IXGBE_GRC_IDX = 2,
	IXGBE_FACTPS_IDX = 3,
	IXGBE_SWSM_IDX = 4,
	IXGBE_SWFW_SYNC_IDX = 5,
	IXGBE_FWSM_IDX = 6,
	IXGBE_SDP0_GPIEN_IDX = 7,
	IXGBE_SDP1_GPIEN_IDX = 8,
	IXGBE_SDP2_GPIEN_IDX = 9,
	IXGBE_EICR_GPI_SDP0_IDX = 10,
	IXGBE_EICR_GPI_SDP1_IDX = 11,
	IXGBE_EICR_GPI_SDP2_IDX = 12,
	IXGBE_CIAA_IDX = 13,
	IXGBE_CIAD_IDX = 14,
	IXGBE_I2C_CLK_IN_IDX = 15,
	IXGBE_I2C_CLK_OUT_IDX = 16,
	IXGBE_I2C_DATA_IN_IDX = 17,
	IXGBE_I2C_DATA_OUT_IDX = 18,
	IXGBE_I2C_DATA_OE_N_EN_IDX = 19,
	IXGBE_I2C_BB_EN_IDX = 20,
	IXGBE_I2C_CLK_OE_N_EN_IDX = 21,
	IXGBE_I2CCTL_IDX = 22,
	IXGBE_MVALS_IDX_LIMIT = 23,
};

enum ixgbe_pfvf_api_rev {
	ixgbe_mbox_api_10 = 0,
	ixgbe_mbox_api_20 = 1,
	ixgbe_mbox_api_11 = 2,
	ixgbe_mbox_api_12 = 3,
	ixgbe_mbox_api_13 = 4,
	ixgbe_mbox_api_14 = 5,
	ixgbe_mbox_api_unknown = 6,
};

enum ixgbe_phy_type {
	ixgbe_phy_unknown = 0,
	ixgbe_phy_none = 1,
	ixgbe_phy_tn = 2,
	ixgbe_phy_aq = 3,
	ixgbe_phy_x550em_kr = 4,
	ixgbe_phy_x550em_kx4 = 5,
	ixgbe_phy_x550em_xfi = 6,
	ixgbe_phy_x550em_ext_t = 7,
	ixgbe_phy_ext_1g_t = 8,
	ixgbe_phy_cu_unknown = 9,
	ixgbe_phy_qt = 10,
	ixgbe_phy_xaui = 11,
	ixgbe_phy_nl = 12,
	ixgbe_phy_sfp_passive_tyco = 13,
	ixgbe_phy_sfp_passive_unknown = 14,
	ixgbe_phy_sfp_active_unknown = 15,
	ixgbe_phy_sfp_avago = 16,
	ixgbe_phy_sfp_ftl = 17,
	ixgbe_phy_sfp_ftl_active = 18,
	ixgbe_phy_sfp_unknown = 19,
	ixgbe_phy_sfp_intel = 20,
	ixgbe_phy_qsfp_passive_unknown = 21,
	ixgbe_phy_qsfp_active_unknown = 22,
	ixgbe_phy_qsfp_intel = 23,
	ixgbe_phy_qsfp_unknown = 24,
	ixgbe_phy_sfp_unsupported = 25,
	ixgbe_phy_sgmii = 26,
	ixgbe_phy_fw = 27,
	ixgbe_phy_generic = 28,
};

enum ixgbe_ring_f_enum {
	RING_F_NONE = 0,
	RING_F_VMDQ = 1,
	RING_F_RSS = 2,
	RING_F_FDIR = 3,
	RING_F_FCOE = 4,
	RING_F_ARRAY_SIZE = 5,
};

enum ixgbe_ring_state_t {
	__IXGBE_RX_3K_BUFFER = 0,
	__IXGBE_RX_BUILD_SKB_ENABLED = 1,
	__IXGBE_RX_RSC_ENABLED = 2,
	__IXGBE_RX_CSUM_UDP_ZERO_ERR = 3,
	__IXGBE_RX_FCOE = 4,
	__IXGBE_TX_FDIR_INIT_DONE = 5,
	__IXGBE_TX_XPS_INIT_DONE = 6,
	__IXGBE_TX_DETECT_HANG = 7,
	__IXGBE_HANG_CHECK_ARMED = 8,
	__IXGBE_TX_XDP_RING = 9,
	__IXGBE_TX_DISABLED = 10,
};

enum ixgbe_sfp_type {
	ixgbe_sfp_type_da_cu = 0,
	ixgbe_sfp_type_sr = 1,
	ixgbe_sfp_type_lr = 2,
	ixgbe_sfp_type_da_cu_core0 = 3,
	ixgbe_sfp_type_da_cu_core1 = 4,
	ixgbe_sfp_type_srlr_core0 = 5,
	ixgbe_sfp_type_srlr_core1 = 6,
	ixgbe_sfp_type_da_act_lmt_core0 = 7,
	ixgbe_sfp_type_da_act_lmt_core1 = 8,
	ixgbe_sfp_type_1g_cu_core0 = 9,
	ixgbe_sfp_type_1g_cu_core1 = 10,
	ixgbe_sfp_type_1g_sx_core0 = 11,
	ixgbe_sfp_type_1g_sx_core1 = 12,
	ixgbe_sfp_type_1g_lx_core0 = 13,
	ixgbe_sfp_type_1g_lx_core1 = 14,
	ixgbe_sfp_type_1g_bx_core0 = 15,
	ixgbe_sfp_type_1g_bx_core1 = 16,
	ixgbe_sfp_type_not_present = 65534,
	ixgbe_sfp_type_unknown = 65535,
};

enum ixgbe_smart_speed {
	ixgbe_smart_speed_auto = 0,
	ixgbe_smart_speed_on = 1,
	ixgbe_smart_speed_off = 2,
};

enum ixgbe_state_t {
	__IXGBE_TESTING = 0,
	__IXGBE_RESETTING = 1,
	__IXGBE_DOWN = 2,
	__IXGBE_DISABLED = 3,
	__IXGBE_REMOVING = 4,
	__IXGBE_SERVICE_SCHED = 5,
	__IXGBE_SERVICE_INITED = 6,
	__IXGBE_IN_SFP_INIT = 7,
	__IXGBE_PTP_RUNNING = 8,
	__IXGBE_PTP_TX_IN_PROGRESS = 9,
	__IXGBE_RESET_REQUESTED = 10,
	__IXGBE_PHY_INIT_COMPLETE = 11,
};

enum ixgbe_tx_flags {
	IXGBE_TX_FLAGS_HW_VLAN = 1,
	IXGBE_TX_FLAGS_TSO = 2,
	IXGBE_TX_FLAGS_TSTAMP = 4,
	IXGBE_TX_FLAGS_CC = 8,
	IXGBE_TX_FLAGS_IPV4 = 16,
	IXGBE_TX_FLAGS_CSUM = 32,
	IXGBE_TX_FLAGS_IPSEC = 64,
	IXGBE_TX_FLAGS_SW_VLAN = 128,
	IXGBE_TX_FLAGS_FCOE = 256,
};

enum ixgbevf_xcast_modes {
	IXGBEVF_XCAST_MODE_NONE = 0,
	IXGBEVF_XCAST_MODE_MULTI = 1,
	IXGBEVF_XCAST_MODE_ALLMULTI = 2,
	IXGBEVF_XCAST_MODE_PROMISC = 3,
};

enum jbd2_shrink_type {
	JBD2_SHRINK_DESTROY = 0,
	JBD2_SHRINK_BUSY_STOP = 1,
	JBD2_SHRINK_BUSY_SKIP = 2,
};

enum jbd_state_bits {
	BH_JBD = 16,
	BH_JWrite = 17,
	BH_Freed = 18,
	BH_Revoked = 19,
	BH_RevokeValid = 20,
	BH_JBDDirty = 21,
	BH_JournalHead = 22,
	BH_Shadow = 23,
	BH_Verified = 24,
	BH_JBDPrivateStart = 25,
};

enum jump_label_type {
	JUMP_LABEL_NOP = 0,
	JUMP_LABEL_JMP = 1,
};

enum kcmp_type {
	KCMP_FILE = 0,
	KCMP_VM = 1,
	KCMP_FILES = 2,
	KCMP_FS = 3,
	KCMP_SIGHAND = 4,
	KCMP_IO = 5,
	KCMP_SYSVSEM = 6,
	KCMP_EPOLL_TFD = 7,
	KCMP_TYPES = 8,
};

enum kcore_type {
	KCORE_TEXT = 0,
	KCORE_VMALLOC = 1,
	KCORE_RAM = 2,
	KCORE_VMEMMAP = 3,
	KCORE_USER = 4,
};

enum kernel_load_data_id {
	LOADING_UNKNOWN = 0,
	LOADING_FIRMWARE = 1,
	LOADING_MODULE = 2,
	LOADING_KEXEC_IMAGE = 3,
	LOADING_KEXEC_INITRAMFS = 4,
	LOADING_POLICY = 5,
	LOADING_X509_CERTIFICATE = 6,
	LOADING_MAX_ID = 7,
};

enum kernel_pkey_operation {
	kernel_pkey_encrypt = 0,
	kernel_pkey_decrypt = 1,
	kernel_pkey_sign = 2,
	kernel_pkey_verify = 3,
};

enum kernel_read_file_id {
	READING_UNKNOWN = 0,
	READING_FIRMWARE = 1,
	READING_MODULE = 2,
	READING_KEXEC_IMAGE = 3,
	READING_KEXEC_INITRAMFS = 4,
	READING_POLICY = 5,
	READING_X509_CERTIFICATE = 6,
	READING_MAX_ID = 7,
};

enum kernfs_node_flag {
	KERNFS_ACTIVATED = 16,
	KERNFS_NS = 32,
	KERNFS_HAS_SEQ_SHOW = 64,
	KERNFS_HAS_MMAP = 128,
	KERNFS_LOCKDEP = 256,
	KERNFS_HIDDEN = 512,
	KERNFS_SUICIDAL = 1024,
	KERNFS_SUICIDED = 2048,
	KERNFS_EMPTY_DIR = 4096,
	KERNFS_HAS_RELEASE = 8192,
	KERNFS_REMOVING = 16384,
};

enum kernfs_node_type {
	KERNFS_DIR = 1,
	KERNFS_FILE = 2,
	KERNFS_LINK = 4,
};

enum kernfs_root_flag {
	KERNFS_ROOT_CREATE_DEACTIVATED = 1,
	KERNFS_ROOT_EXTRA_OPEN_PERM_CHECK = 2,
	KERNFS_ROOT_SUPPORT_EXPORTOP = 4,
	KERNFS_ROOT_SUPPORT_USER_XATTR = 8,
};

enum key_being_used_for {
	VERIFYING_MODULE_SIGNATURE = 0,
	VERIFYING_FIRMWARE_SIGNATURE = 1,
	VERIFYING_KEXEC_PE_SIGNATURE = 2,
	VERIFYING_KEY_SIGNATURE = 3,
	VERIFYING_KEY_SELF_SIGNATURE = 4,
	VERIFYING_UNSPECIFIED_SIGNATURE = 5,
	NR__KEY_BEING_USED_FOR = 6,
};

enum key_lookup_flag {
	KEY_LOOKUP_CREATE = 1,
	KEY_LOOKUP_PARTIAL = 2,
	KEY_LOOKUP_ALL = 3,
};

enum key_need_perm {
	KEY_NEED_UNSPECIFIED = 0,
	KEY_NEED_VIEW = 1,
	KEY_NEED_READ = 2,
	KEY_NEED_WRITE = 3,
	KEY_NEED_SEARCH = 4,
	KEY_NEED_LINK = 5,
	KEY_NEED_SETATTR = 6,
	KEY_NEED_UNLINK = 7,
	KEY_SYSADMIN_OVERRIDE = 8,
	KEY_AUTHTOKEN_OVERRIDE = 9,
	KEY_DEFER_PERM_CHECK = 10,
};

enum key_notification_subtype {
	NOTIFY_KEY_INSTANTIATED = 0,
	NOTIFY_KEY_UPDATED = 1,
	NOTIFY_KEY_LINKED = 2,
	NOTIFY_KEY_UNLINKED = 3,
	NOTIFY_KEY_CLEARED = 4,
	NOTIFY_KEY_REVOKED = 5,
	NOTIFY_KEY_INVALIDATED = 6,
	NOTIFY_KEY_SETATTR = 7,
};

enum key_state {
	KEY_IS_UNINSTANTIATED = 0,
	KEY_IS_POSITIVE = 1,
};

enum kfunc_ptr_arg_type {
	KF_ARG_PTR_TO_CTX = 0,
	KF_ARG_PTR_TO_ALLOC_BTF_ID = 1,
	KF_ARG_PTR_TO_REFCOUNTED_KPTR = 2,
	KF_ARG_PTR_TO_DYNPTR = 3,
	KF_ARG_PTR_TO_ITER = 4,
	KF_ARG_PTR_TO_LIST_HEAD = 5,
	KF_ARG_PTR_TO_LIST_NODE = 6,
	KF_ARG_PTR_TO_BTF_ID = 7,
	KF_ARG_PTR_TO_MEM = 8,
	KF_ARG_PTR_TO_MEM_SIZE = 9,
	KF_ARG_PTR_TO_CALLBACK = 10,
	KF_ARG_PTR_TO_RB_ROOT = 11,
	KF_ARG_PTR_TO_RB_NODE = 12,
	KF_ARG_PTR_TO_NULL = 13,
	KF_ARG_PTR_TO_CONST_STR = 14,
	KF_ARG_PTR_TO_MAP = 15,
	KF_ARG_PTR_TO_WORKQUEUE = 16,
	KF_ARG_PTR_TO_IRQ_FLAG = 17,
};

enum kmalloc_cache_type {
	KMALLOC_NORMAL = 0,
	KMALLOC_DMA = 0,
	KMALLOC_RANDOM_START = 0,
	KMALLOC_RANDOM_END = 0,
	KMALLOC_RECLAIM = 1,
	KMALLOC_CGROUP = 2,
	NR_KMALLOC_TYPES = 3,
};

enum kmsg_dump_reason {
	KMSG_DUMP_UNDEF = 0,
	KMSG_DUMP_PANIC = 1,
	KMSG_DUMP_OOPS = 2,
	KMSG_DUMP_EMERG = 3,
	KMSG_DUMP_SHUTDOWN = 4,
	KMSG_DUMP_MAX = 5,
};

enum kobj_ns_type {
	KOBJ_NS_TYPE_NONE = 0,
	KOBJ_NS_TYPE_NET = 1,
	KOBJ_NS_TYPES = 2,
};

enum kobject_action {
	KOBJ_ADD = 0,
	KOBJ_REMOVE = 1,
	KOBJ_CHANGE = 2,
	KOBJ_MOVE = 3,
	KOBJ_ONLINE = 4,
	KOBJ_OFFLINE = 5,
	KOBJ_BIND = 6,
	KOBJ_UNBIND = 7,
};

enum ksm_advisor_type {
	KSM_ADVISOR_NONE = 0,
	KSM_ADVISOR_SCAN_TIME = 1,
};

enum ksm_get_folio_flags {
	KSM_GET_FOLIO_NOLOCK = 0,
	KSM_GET_FOLIO_LOCK = 1,
	KSM_GET_FOLIO_TRYLOCK = 2,
};

enum kvm_bus {
	KVM_MMIO_BUS = 0,
	KVM_PIO_BUS = 1,
	KVM_VIRTIO_CCW_NOTIFY_BUS = 2,
	KVM_FAST_MMIO_BUS = 3,
	KVM_IOCSR_BUS = 4,
	KVM_NR_BUSES = 5,
};

enum kvm_stat_kind {
	KVM_STAT_VM = 0,
	KVM_STAT_VCPU = 1,
};

enum l2tp_debug_flags {
	L2TP_MSG_DEBUG = 1,
	L2TP_MSG_CONTROL = 2,
	L2TP_MSG_SEQ = 4,
	L2TP_MSG_DATA = 8,
};

enum l3mdev_type {
	L3MDEV_TYPE_UNSPEC = 0,
	L3MDEV_TYPE_VRF = 1,
	__L3MDEV_TYPE_MAX = 2,
};

enum label_flags {
	FLAG_HAT = 1,
	FLAG_UNCONFINED = 2,
	FLAG_NULL = 4,
	FLAG_IX_ON_NAME_ERROR = 8,
	FLAG_IMMUTIBLE = 16,
	FLAG_USER_DEFINED = 32,
	FLAG_NO_LIST_REF = 64,
	FLAG_NS_COUNT = 128,
	FLAG_IN_TREE = 256,
	FLAG_PROFILE = 512,
	FLAG_EXPLICIT = 1024,
	FLAG_STALE = 2048,
	FLAG_RENAMED = 4096,
	FLAG_REVOKED = 8192,
	FLAG_DEBUG1 = 16384,
	FLAG_DEBUG2 = 32768,
};

enum label_initialized {
	LABEL_INVALID = 0,
	LABEL_INITIALIZED = 1,
	LABEL_PENDING = 2,
};

enum landlock_rule_type;

enum latency_range {
	lowest_latency = 0,
	low_latency = 1,
	bulk_latency = 2,
	latency_invalid = 255,
};

enum layout_break_reason {
	BREAK_WRITE = 0,
	BREAK_UNMAP = 1,
};

enum layoutdriver_policy_flags {
	PNFS_LAYOUTRET_ON_SETATTR = 1,
	PNFS_LAYOUTRET_ON_ERROR = 2,
	PNFS_READ_WHOLE_PAGE = 4,
	PNFS_LAYOUTGET_ON_OPEN = 8,
};

enum led_audio {
	LED_AUDIO_MUTE = 0,
	LED_AUDIO_MICMUTE = 1,
	NUM_AUDIO_LEDS = 2,
};

enum led_brightness {
	LED_OFF = 0,
	LED_ON = 1,
	LED_HALF = 127,
	LED_FULL = 255,
};

enum led_default_state {
	LEDS_DEFSTATE_OFF = 0,
	LEDS_DEFSTATE_ON = 1,
	LEDS_DEFSTATE_KEEP = 2,
};

enum led_trigger_netdev_modes {
	TRIGGER_NETDEV_LINK = 0,
	TRIGGER_NETDEV_LINK_10 = 1,
	TRIGGER_NETDEV_LINK_100 = 2,
	TRIGGER_NETDEV_LINK_1000 = 3,
	TRIGGER_NETDEV_LINK_2500 = 4,
	TRIGGER_NETDEV_LINK_5000 = 5,
	TRIGGER_NETDEV_LINK_10000 = 6,
	TRIGGER_NETDEV_HALF_DUPLEX = 7,
	TRIGGER_NETDEV_FULL_DUPLEX = 8,
	TRIGGER_NETDEV_TX = 9,
	TRIGGER_NETDEV_RX = 10,
	TRIGGER_NETDEV_TX_ERR = 11,
	TRIGGER_NETDEV_RX_ERR = 12,
	__TRIGGER_NETDEV_MAX = 13,
};

enum legacy_fs_param {
	LEGACY_FS_UNSET_PARAMS = 0,
	LEGACY_FS_MONOLITHIC_PARAMS = 1,
	LEGACY_FS_INDIVIDUAL_PARAMS = 2,
};

enum limit_by4 {
	NFS4_LIMIT_SIZE = 1,
	NFS4_LIMIT_BLOCKS = 2,
};

enum link_inband_signalling {
	LINK_INBAND_DISABLE = 1,
	LINK_INBAND_ENABLE = 2,
	LINK_INBAND_BYPASS = 4,
};

enum linux_mptcp_mib_field {
	MPTCP_MIB_NUM = 0,
	MPTCP_MIB_MPCAPABLEPASSIVE = 1,
	MPTCP_MIB_MPCAPABLEACTIVE = 2,
	MPTCP_MIB_MPCAPABLEACTIVEACK = 3,
	MPTCP_MIB_MPCAPABLEPASSIVEACK = 4,
	MPTCP_MIB_MPCAPABLEPASSIVEFALLBACK = 5,
	MPTCP_MIB_MPCAPABLEACTIVEFALLBACK = 6,
	MPTCP_MIB_MPCAPABLEACTIVEDROP = 7,
	MPTCP_MIB_MPCAPABLEACTIVEDISABLED = 8,
	MPTCP_MIB_MPCAPABLEENDPATTEMPT = 9,
	MPTCP_MIB_TOKENFALLBACKINIT = 10,
	MPTCP_MIB_RETRANSSEGS = 11,
	MPTCP_MIB_JOINNOTOKEN = 12,
	MPTCP_MIB_JOINSYNRX = 13,
	MPTCP_MIB_JOINSYNBACKUPRX = 14,
	MPTCP_MIB_JOINSYNACKRX = 15,
	MPTCP_MIB_JOINSYNACKBACKUPRX = 16,
	MPTCP_MIB_JOINSYNACKMAC = 17,
	MPTCP_MIB_JOINACKRX = 18,
	MPTCP_MIB_JOINACKMAC = 19,
	MPTCP_MIB_JOINSYNTX = 20,
	MPTCP_MIB_JOINSYNTXCREATSKERR = 21,
	MPTCP_MIB_JOINSYNTXBINDERR = 22,
	MPTCP_MIB_JOINSYNTXCONNECTERR = 23,
	MPTCP_MIB_DSSNOMATCH = 24,
	MPTCP_MIB_DSSCORRUPTIONFALLBACK = 25,
	MPTCP_MIB_DSSCORRUPTIONRESET = 26,
	MPTCP_MIB_INFINITEMAPTX = 27,
	MPTCP_MIB_INFINITEMAPRX = 28,
	MPTCP_MIB_DSSTCPMISMATCH = 29,
	MPTCP_MIB_DATACSUMERR = 30,
	MPTCP_MIB_OFOQUEUETAIL = 31,
	MPTCP_MIB_OFOQUEUE = 32,
	MPTCP_MIB_OFOMERGE = 33,
	MPTCP_MIB_NODSSWINDOW = 34,
	MPTCP_MIB_DUPDATA = 35,
	MPTCP_MIB_ADDADDR = 36,
	MPTCP_MIB_ADDADDRTX = 37,
	MPTCP_MIB_ADDADDRTXDROP = 38,
	MPTCP_MIB_ECHOADD = 39,
	MPTCP_MIB_ECHOADDTX = 40,
	MPTCP_MIB_ECHOADDTXDROP = 41,
	MPTCP_MIB_PORTADD = 42,
	MPTCP_MIB_ADDADDRDROP = 43,
	MPTCP_MIB_JOINPORTSYNRX = 44,
	MPTCP_MIB_JOINPORTSYNACKRX = 45,
	MPTCP_MIB_JOINPORTACKRX = 46,
	MPTCP_MIB_MISMATCHPORTSYNRX = 47,
	MPTCP_MIB_MISMATCHPORTACKRX = 48,
	MPTCP_MIB_RMADDR = 49,
	MPTCP_MIB_RMADDRDROP = 50,
	MPTCP_MIB_RMADDRTX = 51,
	MPTCP_MIB_RMADDRTXDROP = 52,
	MPTCP_MIB_RMSUBFLOW = 53,
	MPTCP_MIB_MPPRIOTX = 54,
	MPTCP_MIB_MPPRIORX = 55,
	MPTCP_MIB_MPFAILTX = 56,
	MPTCP_MIB_MPFAILRX = 57,
	MPTCP_MIB_MPFASTCLOSETX = 58,
	MPTCP_MIB_MPFASTCLOSERX = 59,
	MPTCP_MIB_MPRSTTX = 60,
	MPTCP_MIB_MPRSTRX = 61,
	MPTCP_MIB_RCVPRUNED = 62,
	MPTCP_MIB_SUBFLOWSTALE = 63,
	MPTCP_MIB_SUBFLOWRECOVER = 64,
	MPTCP_MIB_SNDWNDSHARED = 65,
	MPTCP_MIB_RCVWNDSHARED = 66,
	MPTCP_MIB_RCVWNDCONFLICTUPDATE = 67,
	MPTCP_MIB_RCVWNDCONFLICT = 68,
	MPTCP_MIB_CURRESTAB = 69,
	MPTCP_MIB_BLACKHOLE = 70,
	__MPTCP_MIB_MAX = 71,
};

enum lock_type4 {
	NFS4_UNLOCK_LT = 0,
	NFS4_READ_LT = 1,
	NFS4_WRITE_LT = 2,
	NFS4_READW_LT = 3,
	NFS4_WRITEW_LT = 4,
};

enum lockdep_ok {
	LOCKDEP_STILL_OK = 0,
	LOCKDEP_NOW_UNRELIABLE = 1,
};

enum lockdown_reason {
	LOCKDOWN_NONE = 0,
	LOCKDOWN_MODULE_SIGNATURE = 1,
	LOCKDOWN_DEV_MEM = 2,
	LOCKDOWN_EFI_TEST = 3,
	LOCKDOWN_KEXEC = 4,
	LOCKDOWN_HIBERNATION = 5,
	LOCKDOWN_PCI_ACCESS = 6,
	LOCKDOWN_IOPORT = 7,
	LOCKDOWN_MSR = 8,
	LOCKDOWN_ACPI_TABLES = 9,
	LOCKDOWN_DEVICE_TREE = 10,
	LOCKDOWN_PCMCIA_CIS = 11,
	LOCKDOWN_TIOCSSERIAL = 12,
	LOCKDOWN_MODULE_PARAMETERS = 13,
	LOCKDOWN_MMIOTRACE = 14,
	LOCKDOWN_DEBUGFS = 15,
	LOCKDOWN_XMON_WR = 16,
	LOCKDOWN_BPF_WRITE_USER = 17,
	LOCKDOWN_DBG_WRITE_KERNEL = 18,
	LOCKDOWN_RTAS_ERROR_INJECTION = 19,
	LOCKDOWN_INTEGRITY_MAX = 20,
	LOCKDOWN_KCORE = 21,
	LOCKDOWN_KPROBES = 22,
	LOCKDOWN_BPF_READ_KERNEL = 23,
	LOCKDOWN_DBG_READ_KERNEL = 24,
	LOCKDOWN_PERF = 25,
	LOCKDOWN_TRACEFS = 26,
	LOCKDOWN_XMON_RW = 27,
	LOCKDOWN_XFRM_SECRET = 28,
	LOCKDOWN_CONFIDENTIALITY_MAX = 29,
};

enum loongarch_gpr {
	LOONGARCH_GPR_ZERO = 0,
	LOONGARCH_GPR_RA = 1,
	LOONGARCH_GPR_TP = 2,
	LOONGARCH_GPR_SP = 3,
	LOONGARCH_GPR_A0 = 4,
	LOONGARCH_GPR_A1 = 5,
	LOONGARCH_GPR_A2 = 6,
	LOONGARCH_GPR_A3 = 7,
	LOONGARCH_GPR_A4 = 8,
	LOONGARCH_GPR_A5 = 9,
	LOONGARCH_GPR_A6 = 10,
	LOONGARCH_GPR_A7 = 11,
	LOONGARCH_GPR_T0 = 12,
	LOONGARCH_GPR_T1 = 13,
	LOONGARCH_GPR_T2 = 14,
	LOONGARCH_GPR_T3 = 15,
	LOONGARCH_GPR_T4 = 16,
	LOONGARCH_GPR_T5 = 17,
	LOONGARCH_GPR_T6 = 18,
	LOONGARCH_GPR_T7 = 19,
	LOONGARCH_GPR_T8 = 20,
	LOONGARCH_GPR_FP = 22,
	LOONGARCH_GPR_S0 = 23,
	LOONGARCH_GPR_S1 = 24,
	LOONGARCH_GPR_S2 = 25,
	LOONGARCH_GPR_S3 = 26,
	LOONGARCH_GPR_S4 = 27,
	LOONGARCH_GPR_S5 = 28,
	LOONGARCH_GPR_S6 = 29,
	LOONGARCH_GPR_S7 = 30,
	LOONGARCH_GPR_S8 = 31,
	LOONGARCH_GPR_MAX = 32,
};

enum loongarch_regset {
	REGSET_GPR = 0,
	REGSET_FPR = 1,
	REGSET_CPUCFG = 2,
	REGSET_LSX = 3,
	REGSET_LASX = 4,
	REGSET_HW_BREAK = 5,
	REGSET_HW_WATCH = 6,
};

enum loongson2_clk_type {
	CLK_TYPE_PLL = 0,
	CLK_TYPE_SCALE = 1,
	CLK_TYPE_DIVIDER = 2,
	CLK_TYPE_GATE = 3,
	CLK_TYPE_FIXED = 4,
	CLK_TYPE_NONE = 5,
};

enum loongson_chip_id {
	CHIP_LS7A1000 = 0,
	CHIP_LS7A2000 = 1,
	CHIP_LS_LAST = 2,
};

enum loongson_gpio_mode {
	BIT_CTRL_MODE = 0,
	BYTE_CTRL_MODE = 1,
};

enum lru_list {
	LRU_INACTIVE_ANON = 0,
	LRU_ACTIVE_ANON = 1,
	LRU_INACTIVE_FILE = 2,
	LRU_ACTIVE_FILE = 3,
	LRU_UNEVICTABLE = 4,
	NR_LRU_LISTS = 5,
};

enum lru_status {
	LRU_REMOVED = 0,
	LRU_REMOVED_RETRY = 1,
	LRU_ROTATE = 2,
	LRU_SKIP = 3,
	LRU_RETRY = 4,
	LRU_STOP = 5,
};

enum lruvec_flags {
	LRUVEC_CGROUP_CONGESTED = 0,
	LRUVEC_NODE_CONGESTED = 1,
};

enum lsdc_cursor_format {
	CURSOR_FORMAT_DISABLE = 0,
	CURSOR_FORMAT_MONOCHROME = 1,
	CURSOR_FORMAT_ARGB8888 = 2,
};

enum lsdc_cursor_location {
	CURSOR_ON_CRTC0 = 0,
	CURSOR_ON_CRTC1 = 1,
};

enum lsdc_cursor_size {
	CURSOR_SIZE_32X32 = 0,
	CURSOR_SIZE_64X64 = 1,
};

enum lsdc_dma_steps {
	LSDC_DMA_STEP_256_BYTES = 0,
	LSDC_DMA_STEP_128_BYTES = 1,
	LSDC_DMA_STEP_64_BYTES = 2,
	LSDC_DMA_STEP_32_BYTES = 3,
};

enum lsdc_pixel_format {
	LSDC_PF_NONE = 0,
	LSDC_PF_XRGB444 = 1,
	LSDC_PF_XRGB555 = 2,
	LSDC_PF_XRGB565 = 3,
	LSDC_PF_XRGB8888 = 4,
};

enum lsm_event {
	LSM_POLICY_CHANGE = 0,
};

enum lsm_integrity_type {
	LSM_INT_DMVERITY_SIG_VALID = 0,
	LSM_INT_DMVERITY_ROOTHASH = 1,
	LSM_INT_FSVERITY_BUILTINSIG_VALID = 2,
};

enum lsm_order {
	LSM_ORDER_FIRST = -1,
	LSM_ORDER_MUTABLE = 0,
	LSM_ORDER_LAST = 1,
};

enum lw_bits {
	LW_URGENT = 0,
};

enum lwtunnel_encap_types {
	LWTUNNEL_ENCAP_NONE = 0,
	LWTUNNEL_ENCAP_MPLS = 1,
	LWTUNNEL_ENCAP_IP = 2,
	LWTUNNEL_ENCAP_ILA = 3,
	LWTUNNEL_ENCAP_IP6 = 4,
	LWTUNNEL_ENCAP_SEG6 = 5,
	LWTUNNEL_ENCAP_BPF = 6,
	LWTUNNEL_ENCAP_SEG6_LOCAL = 7,
	LWTUNNEL_ENCAP_RPL = 8,
	LWTUNNEL_ENCAP_IOAM6 = 9,
	LWTUNNEL_ENCAP_XFRM = 10,
	__LWTUNNEL_ENCAP_MAX = 11,
};

enum lwtunnel_ip6_t {
	LWTUNNEL_IP6_UNSPEC = 0,
	LWTUNNEL_IP6_ID = 1,
	LWTUNNEL_IP6_DST = 2,
	LWTUNNEL_IP6_SRC = 3,
	LWTUNNEL_IP6_HOPLIMIT = 4,
	LWTUNNEL_IP6_TC = 5,
	LWTUNNEL_IP6_FLAGS = 6,
	LWTUNNEL_IP6_PAD = 7,
	LWTUNNEL_IP6_OPTS = 8,
	__LWTUNNEL_IP6_MAX = 9,
};

enum lwtunnel_ip_t {
	LWTUNNEL_IP_UNSPEC = 0,
	LWTUNNEL_IP_ID = 1,
	LWTUNNEL_IP_DST = 2,
	LWTUNNEL_IP_SRC = 3,
	LWTUNNEL_IP_TTL = 4,
	LWTUNNEL_IP_TOS = 5,
	LWTUNNEL_IP_FLAGS = 6,
	LWTUNNEL_IP_PAD = 7,
	LWTUNNEL_IP_OPTS = 8,
	__LWTUNNEL_IP_MAX = 9,
};

enum lzma2_seq {
	SEQ_CONTROL = 0,
	SEQ_UNCOMPRESSED_1 = 1,
	SEQ_UNCOMPRESSED_2 = 2,
	SEQ_COMPRESSED_0 = 3,
	SEQ_COMPRESSED_1 = 4,
	SEQ_PROPERTIES = 5,
	SEQ_LZMA_PREPARE = 6,
	SEQ_LZMA_RUN = 7,
	SEQ_COPY = 8,
};

enum lzma_state {
	STATE_LIT_LIT = 0,
	STATE_MATCH_LIT_LIT = 1,
	STATE_REP_LIT_LIT = 2,
	STATE_SHORTREP_LIT_LIT = 3,
	STATE_MATCH_LIT = 4,
	STATE_REP_LIT = 5,
	STATE_SHORTREP_LIT = 6,
	STATE_LIT_MATCH = 7,
	STATE_LIT_LONGREP = 8,
	STATE_LIT_SHORTREP = 9,
	STATE_NONLIT_MATCH = 10,
	STATE_NONLIT_REP = 11,
};

enum mac_version {
	RTL_GIGA_MAC_VER_02 = 0,
	RTL_GIGA_MAC_VER_03 = 1,
	RTL_GIGA_MAC_VER_04 = 2,
	RTL_GIGA_MAC_VER_05 = 3,
	RTL_GIGA_MAC_VER_06 = 4,
	RTL_GIGA_MAC_VER_07 = 5,
	RTL_GIGA_MAC_VER_08 = 6,
	RTL_GIGA_MAC_VER_09 = 7,
	RTL_GIGA_MAC_VER_10 = 8,
	RTL_GIGA_MAC_VER_14 = 9,
	RTL_GIGA_MAC_VER_17 = 10,
	RTL_GIGA_MAC_VER_18 = 11,
	RTL_GIGA_MAC_VER_19 = 12,
	RTL_GIGA_MAC_VER_20 = 13,
	RTL_GIGA_MAC_VER_21 = 14,
	RTL_GIGA_MAC_VER_22 = 15,
	RTL_GIGA_MAC_VER_23 = 16,
	RTL_GIGA_MAC_VER_24 = 17,
	RTL_GIGA_MAC_VER_25 = 18,
	RTL_GIGA_MAC_VER_26 = 19,
	RTL_GIGA_MAC_VER_28 = 20,
	RTL_GIGA_MAC_VER_29 = 21,
	RTL_GIGA_MAC_VER_30 = 22,
	RTL_GIGA_MAC_VER_31 = 23,
	RTL_GIGA_MAC_VER_32 = 24,
	RTL_GIGA_MAC_VER_33 = 25,
	RTL_GIGA_MAC_VER_34 = 26,
	RTL_GIGA_MAC_VER_35 = 27,
	RTL_GIGA_MAC_VER_36 = 28,
	RTL_GIGA_MAC_VER_37 = 29,
	RTL_GIGA_MAC_VER_38 = 30,
	RTL_GIGA_MAC_VER_39 = 31,
	RTL_GIGA_MAC_VER_40 = 32,
	RTL_GIGA_MAC_VER_42 = 33,
	RTL_GIGA_MAC_VER_43 = 34,
	RTL_GIGA_MAC_VER_44 = 35,
	RTL_GIGA_MAC_VER_46 = 36,
	RTL_GIGA_MAC_VER_48 = 37,
	RTL_GIGA_MAC_VER_51 = 38,
	RTL_GIGA_MAC_VER_52 = 39,
	RTL_GIGA_MAC_VER_53 = 40,
	RTL_GIGA_MAC_VER_61 = 41,
	RTL_GIGA_MAC_VER_63 = 42,
	RTL_GIGA_MAC_VER_64 = 43,
	RTL_GIGA_MAC_VER_65 = 44,
	RTL_GIGA_MAC_VER_66 = 45,
	RTL_GIGA_MAC_VER_70 = 46,
	RTL_GIGA_MAC_VER_71 = 47,
	RTL_GIGA_MAC_NONE = 48,
};

enum macvlan_mode {
	MACVLAN_MODE_PRIVATE = 1,
	MACVLAN_MODE_VEPA = 2,
	MACVLAN_MODE_BRIDGE = 4,
	MACVLAN_MODE_PASSTHRU = 8,
	MACVLAN_MODE_SOURCE = 16,
};

enum maple_status {
	ma_active = 0,
	ma_start = 1,
	ma_root = 2,
	ma_none = 3,
	ma_pause = 4,
	ma_overflow = 5,
	ma_underflow = 6,
	ma_error = 7,
};

enum maple_type {
	maple_dense = 0,
	maple_leaf_64 = 1,
	maple_range_64 = 2,
	maple_arange_64 = 3,
};

enum mapping_flags {
	AS_EIO = 0,
	AS_ENOSPC = 1,
	AS_MM_ALL_LOCKS = 2,
	AS_UNEVICTABLE = 3,
	AS_EXITING = 4,
	AS_NO_WRITEBACK_TAGS = 5,
	AS_RELEASE_ALWAYS = 6,
	AS_STABLE_WRITES = 7,
	AS_INACCESSIBLE = 8,
	AS_FOLIO_ORDER_BITS = 5,
	AS_FOLIO_ORDER_MIN = 16,
	AS_FOLIO_ORDER_MAX = 21,
};

enum mapping_status {
	MAPPING_OK = 0,
	MAPPING_INVALID = 1,
	MAPPING_EMPTY = 2,
	MAPPING_DATA_FIN = 3,
	MAPPING_DUMMY = 4,
	MAPPING_BAD_CSUM = 5,
	MAPPING_NODSS = 6,
};

enum mctrl_gpio_idx {
	UART_GPIO_CTS = 0,
	UART_GPIO_DSR = 1,
	UART_GPIO_DCD = 2,
	UART_GPIO_RNG = 3,
	UART_GPIO_RI = 3,
	UART_GPIO_RTS = 4,
	UART_GPIO_DTR = 5,
	UART_GPIO_MAX = 6,
};

enum mdio_i2c_proto {
	MDIO_I2C_NONE = 0,
	MDIO_I2C_MARVELL_C22 = 1,
	MDIO_I2C_C45 = 2,
	MDIO_I2C_ROLLBALL = 3,
};

enum membarrier_cmd {
	MEMBARRIER_CMD_QUERY = 0,
	MEMBARRIER_CMD_GLOBAL = 1,
	MEMBARRIER_CMD_GLOBAL_EXPEDITED = 2,
	MEMBARRIER_CMD_REGISTER_GLOBAL_EXPEDITED = 4,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED = 8,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED = 16,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_SYNC_CORE = 64,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_RSEQ = 128,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_RSEQ = 256,
	MEMBARRIER_CMD_GET_REGISTRATIONS = 512,
	MEMBARRIER_CMD_SHARED = 1,
};

enum membarrier_cmd_flag {
	MEMBARRIER_CMD_FLAG_CPU = 1,
};

enum memblock_flags {
	MEMBLOCK_NONE = 0,
	MEMBLOCK_HOTPLUG = 1,
	MEMBLOCK_MIRROR = 2,
	MEMBLOCK_NOMAP = 4,
	MEMBLOCK_DRIVER_MANAGED = 8,
	MEMBLOCK_RSRV_NOINIT = 16,
};

enum memcg_memory_event {
	MEMCG_LOW = 0,
	MEMCG_HIGH = 1,
	MEMCG_MAX = 2,
	MEMCG_OOM = 3,
	MEMCG_OOM_KILL = 4,
	MEMCG_OOM_GROUP_KILL = 5,
	MEMCG_SWAP_HIGH = 6,
	MEMCG_SWAP_MAX = 7,
	MEMCG_SWAP_FAIL = 8,
	MEMCG_NR_MEMORY_EVENTS = 9,
};

enum memcg_stat_item {
	MEMCG_SWAP = 48,
	MEMCG_SOCK = 49,
	MEMCG_PERCPU_B = 50,
	MEMCG_VMALLOC = 51,
	MEMCG_KMEM = 52,
	MEMCG_ZSWAP_B = 53,
	MEMCG_ZSWAPPED = 54,
	MEMCG_NR_STAT = 55,
};

enum meminit_context {
	MEMINIT_EARLY = 0,
	MEMINIT_HOTPLUG = 1,
};

enum memory_type {
	MEMORY_DEVICE_PRIVATE = 1,
	MEMORY_DEVICE_COHERENT = 2,
	MEMORY_DEVICE_FS_DAX = 3,
	MEMORY_DEVICE_GENERIC = 4,
	MEMORY_DEVICE_PCI_P2PDMA = 5,
};

enum metadata_type {
	METADATA_IP_TUNNEL = 0,
	METADATA_HW_PORT_MUX = 1,
	METADATA_MACSEC = 2,
	METADATA_XFRM = 3,
};

enum mfi_evt_class {
	MFI_EVT_CLASS_DEBUG = -2,
	MFI_EVT_CLASS_PROGRESS = -1,
	MFI_EVT_CLASS_INFO = 0,
	MFI_EVT_CLASS_WARNING = 1,
	MFI_EVT_CLASS_CRITICAL = 2,
	MFI_EVT_CLASS_FATAL = 3,
	MFI_EVT_CLASS_DEAD = 4,
};

enum mfill_atomic_mode {
	MFILL_ATOMIC_COPY = 0,
	MFILL_ATOMIC_ZEROPAGE = 1,
	MFILL_ATOMIC_CONTINUE = 2,
	MFILL_ATOMIC_POISON = 3,
	NR_MFILL_ATOMIC_MODES = 4,
};

enum migrate_mode {
	MIGRATE_ASYNC = 0,
	MIGRATE_SYNC_LIGHT = 1,
	MIGRATE_SYNC = 2,
};

enum migrate_reason {
	MR_COMPACTION = 0,
	MR_MEMORY_FAILURE = 1,
	MR_MEMORY_HOTPLUG = 2,
	MR_SYSCALL = 3,
	MR_MEMPOLICY_MBIND = 4,
	MR_NUMA_MISPLACED = 5,
	MR_CONTIG_RANGE = 6,
	MR_LONGTERM_PIN = 7,
	MR_DEMOTION = 8,
	MR_DAMON = 9,
	MR_TYPES = 10,
};

enum migratetype {
	MIGRATE_UNMOVABLE = 0,
	MIGRATE_MOVABLE = 1,
	MIGRATE_RECLAIMABLE = 2,
	MIGRATE_PCPTYPES = 3,
	MIGRATE_HIGHATOMIC = 3,
	MIGRATE_CMA = 4,
	MIGRATE_ISOLATE = 5,
	MIGRATE_TYPES = 6,
};

enum migration_type {
	migrate_load = 0,
	migrate_util = 1,
	migrate_task = 2,
	migrate_misfit = 3,
};

enum misc_res_type {
	MISC_CG_RES_TYPES = 0,
};

enum mm_cid_state {
	MM_CID_UNSET = 4294967295,
	MM_CID_LAZY_PUT = 2147483648,
};

enum mmap_allocation_direction {
	UP = 0,
	DOWN = 1,
};

enum mminit_level {
	MMINIT_WARNING = 0,
	MMINIT_VERIFY = 1,
	MMINIT_TRACE = 2,
};

enum mmu_notifier_event {
	MMU_NOTIFY_UNMAP = 0,
	MMU_NOTIFY_CLEAR = 1,
	MMU_NOTIFY_PROTECTION_VMA = 2,
	MMU_NOTIFY_PROTECTION_PAGE = 3,
	MMU_NOTIFY_SOFT_DIRTY = 4,
	MMU_NOTIFY_RELEASE = 5,
	MMU_NOTIFY_MIGRATE = 6,
	MMU_NOTIFY_EXCLUSIVE = 7,
};

enum mnt_tree_flags_t {
	MNT_TREE_MOVE = 1,
	MNT_TREE_BENEATH = 2,
};

enum mod_license {
	NOT_GPL_ONLY = 0,
	GPL_ONLY = 1,
};

enum mod_mem_type {
	MOD_TEXT = 0,
	MOD_DATA = 1,
	MOD_RODATA = 2,
	MOD_RO_AFTER_INIT = 3,
	MOD_INIT_TEXT = 4,
	MOD_INIT_DATA = 5,
	MOD_INIT_RODATA = 6,
	MOD_MEM_NUM_TYPES = 7,
	MOD_INVALID = -1,
};

enum mode_set_atomic {
	LEAVE_ATOMIC_MODE_SET = 0,
	ENTER_ATOMIC_MODE_SET = 1,
};

enum module_state {
	MODULE_STATE_LIVE = 0,
	MODULE_STATE_COMING = 1,
	MODULE_STATE_GOING = 2,
	MODULE_STATE_UNFORMED = 3,
};

enum mountstat {
	MNT_OK = 0,
	MNT_EPERM = 1,
	MNT_ENOENT = 2,
	MNT_EACCES = 13,
	MNT_EINVAL = 22,
};

enum mountstat3 {
	MNT3_OK = 0,
	MNT3ERR_PERM = 1,
	MNT3ERR_NOENT = 2,
	MNT3ERR_IO = 5,
	MNT3ERR_ACCES = 13,
	MNT3ERR_NOTDIR = 20,
	MNT3ERR_INVAL = 22,
	MNT3ERR_NAMETOOLONG = 63,
	MNT3ERR_NOTSUPP = 10004,
	MNT3ERR_SERVERFAULT = 10006,
};

enum mousedev_emul {
	MOUSEDEV_EMUL_PS2 = 0,
	MOUSEDEV_EMUL_IMPS = 1,
	MOUSEDEV_EMUL_EXPS = 2,
};

enum mpt3sas_perf_mode {
	MPT_PERF_MODE_DEFAULT = -1,
	MPT_PERF_MODE_BALANCED = 0,
	MPT_PERF_MODE_IOPS = 1,
	MPT_PERF_MODE_LATENCY = 2,
};

enum mptcp_addr_signal_status {
	MPTCP_ADD_ADDR_SIGNAL = 0,
	MPTCP_ADD_ADDR_ECHO = 1,
	MPTCP_RM_ADDR_SIGNAL = 2,
};

enum mptcp_event_attr {
	MPTCP_ATTR_UNSPEC = 0,
	MPTCP_ATTR_TOKEN = 1,
	MPTCP_ATTR_FAMILY = 2,
	MPTCP_ATTR_LOC_ID = 3,
	MPTCP_ATTR_REM_ID = 4,
	MPTCP_ATTR_SADDR4 = 5,
	MPTCP_ATTR_SADDR6 = 6,
	MPTCP_ATTR_DADDR4 = 7,
	MPTCP_ATTR_DADDR6 = 8,
	MPTCP_ATTR_SPORT = 9,
	MPTCP_ATTR_DPORT = 10,
	MPTCP_ATTR_BACKUP = 11,
	MPTCP_ATTR_ERROR = 12,
	MPTCP_ATTR_FLAGS = 13,
	MPTCP_ATTR_TIMEOUT = 14,
	MPTCP_ATTR_IF_IDX = 15,
	MPTCP_ATTR_RESET_REASON = 16,
	MPTCP_ATTR_RESET_FLAGS = 17,
	MPTCP_ATTR_SERVER_SIDE = 18,
	__MPTCP_ATTR_MAX = 19,
};

enum mptcp_event_type {
	MPTCP_EVENT_UNSPEC = 0,
	MPTCP_EVENT_CREATED = 1,
	MPTCP_EVENT_ESTABLISHED = 2,
	MPTCP_EVENT_CLOSED = 3,
	MPTCP_EVENT_ANNOUNCED = 6,
	MPTCP_EVENT_REMOVED = 7,
	MPTCP_EVENT_SUB_ESTABLISHED = 10,
	MPTCP_EVENT_SUB_CLOSED = 11,
	MPTCP_EVENT_SUB_PRIORITY = 13,
	MPTCP_EVENT_LISTENER_CREATED = 15,
	MPTCP_EVENT_LISTENER_CLOSED = 16,
};

enum mptcp_pm_status {
	MPTCP_PM_ADD_ADDR_RECEIVED = 0,
	MPTCP_PM_ADD_ADDR_SEND_ACK = 1,
	MPTCP_PM_RM_ADDR_RECEIVED = 2,
	MPTCP_PM_ESTABLISHED = 3,
	MPTCP_PM_SUBFLOW_ESTABLISHED = 4,
	MPTCP_PM_ALREADY_ESTABLISHED = 5,
	MPTCP_PM_MPC_ENDPOINT_ACCOUNTED = 6,
};

enum mptcp_pm_type {
	MPTCP_PM_TYPE_KERNEL = 0,
	MPTCP_PM_TYPE_USERSPACE = 1,
	__MPTCP_PM_TYPE_NR = 2,
	__MPTCP_PM_TYPE_MAX = 1,
};

enum mq_rq_state {
	MQ_RQ_IDLE = 0,
	MQ_RQ_IN_FLIGHT = 1,
	MQ_RQ_COMPLETE = 2,
};

enum msdos_sys_ind {
	DOS_EXTENDED_PARTITION = 5,
	LINUX_EXTENDED_PARTITION = 133,
	WIN98_EXTENDED_PARTITION = 15,
	LINUX_DATA_PARTITION = 131,
	LINUX_LVM_PARTITION = 142,
	LINUX_RAID_PARTITION = 253,
	SOLARIS_X86_PARTITION = 130,
	NEW_SOLARIS_X86_PARTITION = 191,
	DM6_AUX1PARTITION = 81,
	DM6_AUX3PARTITION = 83,
	DM6_PARTITION = 84,
	EZD_PARTITION = 85,
	FREEBSD_PARTITION = 165,
	OPENBSD_PARTITION = 166,
	NETBSD_PARTITION = 169,
	BSDI_PARTITION = 183,
	MINIX_PARTITION = 129,
	UNIXWARE_PARTITION = 99,
};

enum msi_desc_filter {
	MSI_DESC_ALL = 0,
	MSI_DESC_NOTASSOCIATED = 1,
	MSI_DESC_ASSOCIATED = 2,
};

enum msi_domain_ids {
	MSI_DEFAULT_DOMAIN = 0,
	MSI_MAX_DEVICE_IRQDOMAINS = 1,
};

enum mthp_stat_item {
	MTHP_STAT_ANON_FAULT_ALLOC = 0,
	MTHP_STAT_ANON_FAULT_FALLBACK = 1,
	MTHP_STAT_ANON_FAULT_FALLBACK_CHARGE = 2,
	MTHP_STAT_ZSWPOUT = 3,
	MTHP_STAT_SWPIN = 4,
	MTHP_STAT_SWPIN_FALLBACK = 5,
	MTHP_STAT_SWPIN_FALLBACK_CHARGE = 6,
	MTHP_STAT_SWPOUT = 7,
	MTHP_STAT_SWPOUT_FALLBACK = 8,
	MTHP_STAT_SHMEM_ALLOC = 9,
	MTHP_STAT_SHMEM_FALLBACK = 10,
	MTHP_STAT_SHMEM_FALLBACK_CHARGE = 11,
	MTHP_STAT_SPLIT = 12,
	MTHP_STAT_SPLIT_FAILED = 13,
	MTHP_STAT_SPLIT_DEFERRED = 14,
	MTHP_STAT_NR_ANON = 15,
	MTHP_STAT_NR_ANON_PARTIALLY_MAPPED = 16,
	__MTHP_STAT_COUNT = 17,
};

enum multi_stop_state {
	MULTI_STOP_NONE = 0,
	MULTI_STOP_PREPARE = 1,
	MULTI_STOP_DISABLE_IRQ = 2,
	MULTI_STOP_RUN = 3,
	MULTI_STOP_EXIT = 4,
};

enum mvs_event_flags {
	PHY_PLUG_EVENT = 3,
	PHY_PLUG_IN = 1,
	PHY_PLUG_OUT = 2,
	EXP_BRCT_CHG = 4,
};

enum mvs_info_flags {
	MVF_PHY_PWR_FIX = 2,
	MVF_FLAG_SOC = 4,
};

enum mvs_port_type {
	PORT_TGT_MASK = 32,
	PORT_INIT_PORT = 16,
	PORT_TGT_PORT = 8,
	PORT_INIT_TGT_PORT = 24,
	PORT_TYPE_SAS = 2,
	PORT_TYPE_SATA = 1,
};

enum mvumi_qc_result {
	MV_QUEUE_COMMAND_RESULT_SENT = 0,
	MV_QUEUE_COMMAND_RESULT_NO_RESOURCE = 1,
};

enum nbcon_prio {
	NBCON_PRIO_NONE = 0,
	NBCON_PRIO_NORMAL = 1,
	NBCON_PRIO_EMERGENCY = 2,
	NBCON_PRIO_PANIC = 3,
	NBCON_PRIO_MAX = 4,
};

enum net_device_flags {
	IFF_UP = 1,
	IFF_BROADCAST = 2,
	IFF_DEBUG = 4,
	IFF_LOOPBACK = 8,
	IFF_POINTOPOINT = 16,
	IFF_NOTRAILERS = 32,
	IFF_RUNNING = 64,
	IFF_NOARP = 128,
	IFF_PROMISC = 256,
	IFF_ALLMULTI = 512,
	IFF_MASTER = 1024,
	IFF_SLAVE = 2048,
	IFF_MULTICAST = 4096,
	IFF_PORTSEL = 8192,
	IFF_AUTOMEDIA = 16384,
	IFF_DYNAMIC = 32768,
	IFF_LOWER_UP = 65536,
	IFF_DORMANT = 131072,
	IFF_ECHO = 262144,
};

enum net_device_path_type {
	DEV_PATH_ETHERNET = 0,
	DEV_PATH_VLAN = 1,
	DEV_PATH_BRIDGE = 2,
	DEV_PATH_PPPOE = 3,
	DEV_PATH_DSA = 4,
	DEV_PATH_MTK_WDMA = 5,
};

enum net_xmit_qdisc_t {
	__NET_XMIT_STOLEN = 65536,
	__NET_XMIT_BYPASS = 131072,
};

enum netdev_cmd {
	NETDEV_UP = 1,
	NETDEV_DOWN = 2,
	NETDEV_REBOOT = 3,
	NETDEV_CHANGE = 4,
	NETDEV_REGISTER = 5,
	NETDEV_UNREGISTER = 6,
	NETDEV_CHANGEMTU = 7,
	NETDEV_CHANGEADDR = 8,
	NETDEV_PRE_CHANGEADDR = 9,
	NETDEV_GOING_DOWN = 10,
	NETDEV_CHANGENAME = 11,
	NETDEV_FEAT_CHANGE = 12,
	NETDEV_BONDING_FAILOVER = 13,
	NETDEV_PRE_UP = 14,
	NETDEV_PRE_TYPE_CHANGE = 15,
	NETDEV_POST_TYPE_CHANGE = 16,
	NETDEV_POST_INIT = 17,
	NETDEV_PRE_UNINIT = 18,
	NETDEV_RELEASE = 19,
	NETDEV_NOTIFY_PEERS = 20,
	NETDEV_JOIN = 21,
	NETDEV_CHANGEUPPER = 22,
	NETDEV_RESEND_IGMP = 23,
	NETDEV_PRECHANGEMTU = 24,
	NETDEV_CHANGEINFODATA = 25,
	NETDEV_BONDING_INFO = 26,
	NETDEV_PRECHANGEUPPER = 27,
	NETDEV_CHANGELOWERSTATE = 28,
	NETDEV_UDP_TUNNEL_PUSH_INFO = 29,
	NETDEV_UDP_TUNNEL_DROP_INFO = 30,
	NETDEV_CHANGE_TX_QUEUE_LEN = 31,
	NETDEV_CVLAN_FILTER_PUSH_INFO = 32,
	NETDEV_CVLAN_FILTER_DROP_INFO = 33,
	NETDEV_SVLAN_FILTER_PUSH_INFO = 34,
	NETDEV_SVLAN_FILTER_DROP_INFO = 35,
	NETDEV_OFFLOAD_XSTATS_ENABLE = 36,
	NETDEV_OFFLOAD_XSTATS_DISABLE = 37,
	NETDEV_OFFLOAD_XSTATS_REPORT_USED = 38,
	NETDEV_OFFLOAD_XSTATS_REPORT_DELTA = 39,
	NETDEV_XDP_FEAT_CHANGE = 40,
};

enum netdev_ml_priv_type {
	ML_PRIV_NONE = 0,
	ML_PRIV_CAN = 1,
};

enum netdev_offload_xstats_type {
	NETDEV_OFFLOAD_XSTATS_TYPE_L3 = 1,
};

enum netdev_priv_flags {
	IFF_802_1Q_VLAN = 1,
	IFF_EBRIDGE = 2,
	IFF_BONDING = 4,
	IFF_ISATAP = 8,
	IFF_WAN_HDLC = 16,
	IFF_XMIT_DST_RELEASE = 32,
	IFF_DONT_BRIDGE = 64,
	IFF_DISABLE_NETPOLL = 128,
	IFF_MACVLAN_PORT = 256,
	IFF_BRIDGE_PORT = 512,
	IFF_OVS_DATAPATH = 1024,
	IFF_TX_SKB_SHARING = 2048,
	IFF_UNICAST_FLT = 4096,
	IFF_TEAM_PORT = 8192,
	IFF_SUPP_NOFCS = 16384,
	IFF_LIVE_ADDR_CHANGE = 32768,
	IFF_MACVLAN = 65536,
	IFF_XMIT_DST_RELEASE_PERM = 131072,
	IFF_L3MDEV_MASTER = 262144,
	IFF_NO_QUEUE = 524288,
	IFF_OPENVSWITCH = 1048576,
	IFF_L3MDEV_SLAVE = 2097152,
	IFF_TEAM = 4194304,
	IFF_RXFH_CONFIGURED = 8388608,
	IFF_PHONY_HEADROOM = 16777216,
	IFF_MACSEC = 33554432,
	IFF_NO_RX_HANDLER = 67108864,
	IFF_FAILOVER = 134217728,
	IFF_FAILOVER_SLAVE = 268435456,
	IFF_L3MDEV_RX_HANDLER = 536870912,
	IFF_NO_ADDRCONF = 1073741824,
	IFF_TX_SKB_NO_LINEAR = 2147483648,
};

enum netdev_qstats_scope {
	NETDEV_QSTATS_SCOPE_QUEUE = 1,
};

enum netdev_queue_state_t {
	__QUEUE_STATE_DRV_XOFF = 0,
	__QUEUE_STATE_STACK_XOFF = 1,
	__QUEUE_STATE_FROZEN = 2,
};

enum netdev_queue_type {
	NETDEV_QUEUE_TYPE_RX = 0,
	NETDEV_QUEUE_TYPE_TX = 1,
};

enum netdev_reg_state {
	NETREG_UNINITIALIZED = 0,
	NETREG_REGISTERED = 1,
	NETREG_UNREGISTERING = 2,
	NETREG_UNREGISTERED = 3,
	NETREG_RELEASED = 4,
	NETREG_DUMMY = 5,
};

enum netdev_stat_type {
	NETDEV_PCPU_STAT_NONE = 0,
	NETDEV_PCPU_STAT_LSTATS = 1,
	NETDEV_PCPU_STAT_TSTATS = 2,
	NETDEV_PCPU_STAT_DSTATS = 3,
};

enum netdev_state_t {
	__LINK_STATE_START = 0,
	__LINK_STATE_PRESENT = 1,
	__LINK_STATE_NOCARRIER = 2,
	__LINK_STATE_LINKWATCH_PENDING = 3,
	__LINK_STATE_DORMANT = 4,
	__LINK_STATE_TESTING = 5,
};

enum netdev_tx {
	__NETDEV_TX_MIN = -2147483648,
	NETDEV_TX_OK = 0,
	NETDEV_TX_BUSY = 16,
};

typedef enum netdev_tx netdev_tx_t;

enum netdev_xdp_act {
	NETDEV_XDP_ACT_BASIC = 1,
	NETDEV_XDP_ACT_REDIRECT = 2,
	NETDEV_XDP_ACT_NDO_XMIT = 4,
	NETDEV_XDP_ACT_XSK_ZEROCOPY = 8,
	NETDEV_XDP_ACT_HW_OFFLOAD = 16,
	NETDEV_XDP_ACT_RX_SG = 32,
	NETDEV_XDP_ACT_NDO_XMIT_SG = 64,
	NETDEV_XDP_ACT_MASK = 127,
};

enum netdev_xdp_rx_metadata {
	NETDEV_XDP_RX_METADATA_TIMESTAMP = 1,
	NETDEV_XDP_RX_METADATA_HASH = 2,
	NETDEV_XDP_RX_METADATA_VLAN_TAG = 4,
};

enum netdev_xsk_flags {
	NETDEV_XSK_FLAGS_TX_TIMESTAMP = 1,
	NETDEV_XSK_FLAGS_TX_CHECKSUM = 2,
};

enum netevent_notif_type {
	NETEVENT_NEIGH_UPDATE = 1,
	NETEVENT_REDIRECT = 2,
	NETEVENT_DELAY_PROBE_TIME_UPDATE = 3,
	NETEVENT_IPV4_MPATH_HASH_UPDATE = 4,
	NETEVENT_IPV6_MPATH_HASH_UPDATE = 5,
	NETEVENT_IPV4_FWD_UPDATE_PRIORITY_UPDATE = 6,
};

enum netfs_collect_contig_trace {
	netfs_contig_trace_collect = 0,
	netfs_contig_trace_jump = 1,
	netfs_contig_trace_unlock = 2,
} __attribute__((mode(byte)));

enum netfs_donate_trace {
	netfs_trace_donate_tail_to_prev = 0,
	netfs_trace_donate_to_prev = 1,
	netfs_trace_donate_to_next = 2,
	netfs_trace_donate_to_deferred_next = 3,
} __attribute__((mode(byte)));

enum netfs_failure {
	netfs_fail_check_write_begin = 0,
	netfs_fail_copy_to_cache = 1,
	netfs_fail_dio_read_short = 2,
	netfs_fail_dio_read_zero = 3,
	netfs_fail_read = 4,
	netfs_fail_short_read = 5,
	netfs_fail_prepare_write = 6,
	netfs_fail_write = 7,
} __attribute__((mode(byte)));

enum netfs_folio_trace {
	netfs_folio_is_uptodate = 0,
	netfs_just_prefetch = 1,
	netfs_whole_folio_modify = 2,
	netfs_modify_and_clear = 3,
	netfs_streaming_write = 4,
	netfs_streaming_write_cont = 5,
	netfs_flush_content = 6,
	netfs_streaming_filled_page = 7,
	netfs_streaming_cont_filled_page = 8,
	netfs_folio_trace_abandon = 9,
	netfs_folio_trace_alloc_buffer = 10,
	netfs_folio_trace_cancel_copy = 11,
	netfs_folio_trace_cancel_store = 12,
	netfs_folio_trace_clear = 13,
	netfs_folio_trace_clear_cc = 14,
	netfs_folio_trace_clear_g = 15,
	netfs_folio_trace_clear_s = 16,
	netfs_folio_trace_copy_to_cache = 17,
	netfs_folio_trace_end_copy = 18,
	netfs_folio_trace_filled_gaps = 19,
	netfs_folio_trace_kill = 20,
	netfs_folio_trace_kill_cc = 21,
	netfs_folio_trace_kill_g = 22,
	netfs_folio_trace_kill_s = 23,
	netfs_folio_trace_mkwrite = 24,
	netfs_folio_trace_mkwrite_plus = 25,
	netfs_folio_trace_not_under_wback = 26,
	netfs_folio_trace_not_locked = 27,
	netfs_folio_trace_put = 28,
	netfs_folio_trace_read = 29,
	netfs_folio_trace_read_done = 30,
	netfs_folio_trace_read_gaps = 31,
	netfs_folio_trace_read_unlock = 32,
	netfs_folio_trace_redirtied = 33,
	netfs_folio_trace_store = 34,
	netfs_folio_trace_store_copy = 35,
	netfs_folio_trace_store_plus = 36,
	netfs_folio_trace_wthru = 37,
	netfs_folio_trace_wthru_plus = 38,
} __attribute__((mode(byte)));

enum netfs_folioq_trace {
	netfs_trace_folioq_alloc_buffer = 0,
	netfs_trace_folioq_clear = 1,
	netfs_trace_folioq_delete = 2,
	netfs_trace_folioq_make_space = 3,
	netfs_trace_folioq_rollbuf_init = 4,
	netfs_trace_folioq_read_progress = 5,
} __attribute__((mode(byte)));

enum netfs_io_origin {
	NETFS_READAHEAD = 0,
	NETFS_READPAGE = 1,
	NETFS_READ_GAPS = 2,
	NETFS_READ_SINGLE = 3,
	NETFS_READ_FOR_WRITE = 4,
	NETFS_DIO_READ = 5,
	NETFS_WRITEBACK = 6,
	NETFS_WRITEBACK_SINGLE = 7,
	NETFS_WRITETHROUGH = 8,
	NETFS_UNBUFFERED_WRITE = 9,
	NETFS_DIO_WRITE = 10,
	NETFS_PGPRIV2_COPY_TO_CACHE = 11,
	nr__netfs_io_origin = 12,
} __attribute__((mode(byte)));

enum netfs_io_source {
	NETFS_SOURCE_UNKNOWN = 0,
	NETFS_FILL_WITH_ZEROES = 1,
	NETFS_DOWNLOAD_FROM_SERVER = 2,
	NETFS_READ_FROM_CACHE = 3,
	NETFS_INVALID_READ = 4,
	NETFS_UPLOAD_TO_SERVER = 5,
	NETFS_WRITE_TO_CACHE = 6,
	NETFS_INVALID_WRITE = 7,
} __attribute__((mode(byte)));

enum netfs_read_from_hole {
	NETFS_READ_HOLE_IGNORE = 0,
	NETFS_READ_HOLE_CLEAR = 1,
	NETFS_READ_HOLE_FAIL = 2,
};

enum netfs_read_trace {
	netfs_read_trace_dio_read = 0,
	netfs_read_trace_expanded = 1,
	netfs_read_trace_readahead = 2,
	netfs_read_trace_readpage = 3,
	netfs_read_trace_read_gaps = 4,
	netfs_read_trace_read_single = 5,
	netfs_read_trace_prefetch_for_write = 6,
	netfs_read_trace_write_begin = 7,
} __attribute__((mode(byte)));

enum netfs_rreq_ref_trace {
	netfs_rreq_trace_get_for_outstanding = 0,
	netfs_rreq_trace_get_subreq = 1,
	netfs_rreq_trace_get_work = 2,
	netfs_rreq_trace_put_complete = 3,
	netfs_rreq_trace_put_discard = 4,
	netfs_rreq_trace_put_failed = 5,
	netfs_rreq_trace_put_no_submit = 6,
	netfs_rreq_trace_put_return = 7,
	netfs_rreq_trace_put_subreq = 8,
	netfs_rreq_trace_put_work = 9,
	netfs_rreq_trace_put_work_complete = 10,
	netfs_rreq_trace_put_work_nq = 11,
	netfs_rreq_trace_see_work = 12,
	netfs_rreq_trace_new = 13,
} __attribute__((mode(byte)));

enum netfs_rreq_trace {
	netfs_rreq_trace_assess = 0,
	netfs_rreq_trace_copy = 1,
	netfs_rreq_trace_collect = 2,
	netfs_rreq_trace_complete = 3,
	netfs_rreq_trace_dirty = 4,
	netfs_rreq_trace_done = 5,
	netfs_rreq_trace_free = 6,
	netfs_rreq_trace_redirty = 7,
	netfs_rreq_trace_resubmit = 8,
	netfs_rreq_trace_set_abandon = 9,
	netfs_rreq_trace_set_pause = 10,
	netfs_rreq_trace_unlock = 11,
	netfs_rreq_trace_unlock_pgpriv2 = 12,
	netfs_rreq_trace_unmark = 13,
	netfs_rreq_trace_wait_ip = 14,
	netfs_rreq_trace_wait_pause = 15,
	netfs_rreq_trace_wait_queue = 16,
	netfs_rreq_trace_wake_ip = 17,
	netfs_rreq_trace_wake_queue = 18,
	netfs_rreq_trace_woke_queue = 19,
	netfs_rreq_trace_unpause = 20,
	netfs_rreq_trace_write_done = 21,
} __attribute__((mode(byte)));

enum netfs_sreq_ref_trace {
	netfs_sreq_trace_get_copy_to_cache = 0,
	netfs_sreq_trace_get_resubmit = 1,
	netfs_sreq_trace_get_submit = 2,
	netfs_sreq_trace_get_short_read = 3,
	netfs_sreq_trace_new = 4,
	netfs_sreq_trace_put_abandon = 5,
	netfs_sreq_trace_put_cancel = 6,
	netfs_sreq_trace_put_clear = 7,
	netfs_sreq_trace_put_consumed = 8,
	netfs_sreq_trace_put_done = 9,
	netfs_sreq_trace_put_failed = 10,
	netfs_sreq_trace_put_merged = 11,
	netfs_sreq_trace_put_no_copy = 12,
	netfs_sreq_trace_put_oom = 13,
	netfs_sreq_trace_put_wip = 14,
	netfs_sreq_trace_put_work = 15,
	netfs_sreq_trace_put_terminated = 16,
} __attribute__((mode(byte)));

enum netfs_sreq_trace {
	netfs_sreq_trace_add_donations = 0,
	netfs_sreq_trace_added = 1,
	netfs_sreq_trace_cache_nowrite = 2,
	netfs_sreq_trace_cache_prepare = 3,
	netfs_sreq_trace_cache_write = 4,
	netfs_sreq_trace_cancel = 5,
	netfs_sreq_trace_clear = 6,
	netfs_sreq_trace_discard = 7,
	netfs_sreq_trace_donate_to_prev = 8,
	netfs_sreq_trace_donate_to_next = 9,
	netfs_sreq_trace_download_instead = 10,
	netfs_sreq_trace_fail = 11,
	netfs_sreq_trace_free = 12,
	netfs_sreq_trace_hit_eof = 13,
	netfs_sreq_trace_io_progress = 14,
	netfs_sreq_trace_limited = 15,
	netfs_sreq_trace_need_clear = 16,
	netfs_sreq_trace_partial_read = 17,
	netfs_sreq_trace_need_retry = 18,
	netfs_sreq_trace_prepare = 19,
	netfs_sreq_trace_prep_failed = 20,
	netfs_sreq_trace_progress = 21,
	netfs_sreq_trace_reprep_failed = 22,
	netfs_sreq_trace_retry = 23,
	netfs_sreq_trace_short = 24,
	netfs_sreq_trace_split = 25,
	netfs_sreq_trace_submit = 26,
	netfs_sreq_trace_superfluous = 27,
	netfs_sreq_trace_terminated = 28,
	netfs_sreq_trace_wait_for = 29,
	netfs_sreq_trace_write = 30,
	netfs_sreq_trace_write_skip = 31,
	netfs_sreq_trace_write_term = 32,
} __attribute__((mode(byte)));

enum netfs_write_trace {
	netfs_write_trace_copy_to_cache = 0,
	netfs_write_trace_dio_write = 1,
	netfs_write_trace_unbuffered_write = 2,
	netfs_write_trace_writeback = 3,
	netfs_write_trace_writethrough = 4,
} __attribute__((mode(byte)));

enum netlink_attribute_type {
	NL_ATTR_TYPE_INVALID = 0,
	NL_ATTR_TYPE_FLAG = 1,
	NL_ATTR_TYPE_U8 = 2,
	NL_ATTR_TYPE_U16 = 3,
	NL_ATTR_TYPE_U32 = 4,
	NL_ATTR_TYPE_U64 = 5,
	NL_ATTR_TYPE_S8 = 6,
	NL_ATTR_TYPE_S16 = 7,
	NL_ATTR_TYPE_S32 = 8,
	NL_ATTR_TYPE_S64 = 9,
	NL_ATTR_TYPE_BINARY = 10,
	NL_ATTR_TYPE_STRING = 11,
	NL_ATTR_TYPE_NUL_STRING = 12,
	NL_ATTR_TYPE_NESTED = 13,
	NL_ATTR_TYPE_NESTED_ARRAY = 14,
	NL_ATTR_TYPE_BITFIELD32 = 15,
	NL_ATTR_TYPE_SINT = 16,
	NL_ATTR_TYPE_UINT = 17,
};

enum netlink_policy_type_attr {
	NL_POLICY_TYPE_ATTR_UNSPEC = 0,
	NL_POLICY_TYPE_ATTR_TYPE = 1,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_S = 2,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_S = 3,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_U = 4,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_U = 5,
	NL_POLICY_TYPE_ATTR_MIN_LENGTH = 6,
	NL_POLICY_TYPE_ATTR_MAX_LENGTH = 7,
	NL_POLICY_TYPE_ATTR_POLICY_IDX = 8,
	NL_POLICY_TYPE_ATTR_POLICY_MAXTYPE = 9,
	NL_POLICY_TYPE_ATTR_BITFIELD32_MASK = 10,
	NL_POLICY_TYPE_ATTR_PAD = 11,
	NL_POLICY_TYPE_ATTR_MASK = 12,
	__NL_POLICY_TYPE_ATTR_MAX = 13,
	NL_POLICY_TYPE_ATTR_MAX = 12,
};

enum netlink_skb_flags {
	NETLINK_SKB_DST = 8,
};

enum netlink_validation {
	NL_VALIDATE_LIBERAL = 0,
	NL_VALIDATE_TRAILING = 1,
	NL_VALIDATE_MAXTYPE = 2,
	NL_VALIDATE_UNSPEC = 4,
	NL_VALIDATE_STRICT_ATTRS = 8,
	NL_VALIDATE_NESTED = 16,
};

enum netloc_type4 {
	NL4_NAME = 1,
	NL4_URL = 2,
	NL4_NETADDR = 3,
};

enum netns_bpf_attach_type {
	NETNS_BPF_INVALID = -1,
	NETNS_BPF_FLOW_DISSECTOR = 0,
	NETNS_BPF_SK_LOOKUP = 1,
	MAX_NETNS_BPF_ATTACH_TYPE = 2,
};

enum nexthop_event_type {
	NEXTHOP_EVENT_DEL = 0,
	NEXTHOP_EVENT_REPLACE = 1,
	NEXTHOP_EVENT_RES_TABLE_PRE_REPLACE = 2,
	NEXTHOP_EVENT_BUCKET_REPLACE = 3,
	NEXTHOP_EVENT_HW_STATS_REPORT_DELTA = 4,
};

enum nf_ct_ext_id {
	NF_CT_EXT_HELPER = 0,
	NF_CT_EXT_NAT = 1,
	NF_CT_EXT_SEQADJ = 2,
	NF_CT_EXT_ACCT = 3,
	NF_CT_EXT_LABELS = 4,
	NF_CT_EXT_SYNPROXY = 5,
	NF_CT_EXT_NUM = 6,
};

enum nf_dev_hooks {
	NF_NETDEV_INGRESS = 0,
	NF_NETDEV_EGRESS = 1,
	NF_NETDEV_NUMHOOKS = 2,
};

enum nf_hook_ops_type {
	NF_HOOK_OP_UNDEFINED = 0,
	NF_HOOK_OP_NF_TABLES = 1,
	NF_HOOK_OP_BPF = 2,
};

enum nf_inet_hooks {
	NF_INET_PRE_ROUTING = 0,
	NF_INET_LOCAL_IN = 1,
	NF_INET_FORWARD = 2,
	NF_INET_LOCAL_OUT = 3,
	NF_INET_POST_ROUTING = 4,
	NF_INET_NUMHOOKS = 5,
	NF_INET_INGRESS = 5,
};

enum nf_ip6_hook_priorities {
	NF_IP6_PRI_FIRST = -2147483648,
	NF_IP6_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP6_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP6_PRI_RAW = -300,
	NF_IP6_PRI_SELINUX_FIRST = -225,
	NF_IP6_PRI_CONNTRACK = -200,
	NF_IP6_PRI_MANGLE = -150,
	NF_IP6_PRI_NAT_DST = -100,
	NF_IP6_PRI_FILTER = 0,
	NF_IP6_PRI_SECURITY = 50,
	NF_IP6_PRI_NAT_SRC = 100,
	NF_IP6_PRI_SELINUX_LAST = 225,
	NF_IP6_PRI_CONNTRACK_HELPER = 300,
	NF_IP6_PRI_LAST = 2147483647,
};

enum nf_ip_hook_priorities {
	NF_IP_PRI_FIRST = -2147483648,
	NF_IP_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP_PRI_RAW = -300,
	NF_IP_PRI_SELINUX_FIRST = -225,
	NF_IP_PRI_CONNTRACK = -200,
	NF_IP_PRI_MANGLE = -150,
	NF_IP_PRI_NAT_DST = -100,
	NF_IP_PRI_FILTER = 0,
	NF_IP_PRI_SECURITY = 50,
	NF_IP_PRI_NAT_SRC = 100,
	NF_IP_PRI_SELINUX_LAST = 225,
	NF_IP_PRI_CONNTRACK_HELPER = 300,
	NF_IP_PRI_CONNTRACK_CONFIRM = 2147483647,
	NF_IP_PRI_LAST = 2147483647,
};

enum nf_ip_trace_comments {
	NF_IP6_TRACE_COMMENT_RULE = 0,
	NF_IP6_TRACE_COMMENT_RETURN = 1,
	NF_IP6_TRACE_COMMENT_POLICY = 2,
};

enum nf_log_type {
	NF_LOG_TYPE_LOG = 0,
	NF_LOG_TYPE_ULOG = 1,
	NF_LOG_TYPE_MAX = 2,
};

enum nf_nat_manip_type;

enum nfs3_createmode {
	NFS3_CREATE_UNCHECKED = 0,
	NFS3_CREATE_GUARDED = 1,
	NFS3_CREATE_EXCLUSIVE = 2,
};

enum nfs3_ftype {
	NF3NON = 0,
	NF3REG = 1,
	NF3DIR = 2,
	NF3BLK = 3,
	NF3CHR = 4,
	NF3LNK = 5,
	NF3SOCK = 6,
	NF3FIFO = 7,
	NF3BAD = 8,
};

enum nfs3_stable_how {
	NFS_UNSTABLE = 0,
	NFS_DATA_SYNC = 1,
	NFS_FILE_SYNC = 2,
	NFS_INVALID_STABLE_HOW = -1,
};

enum nfs3_time_how {
	DONT_CHANGE = 0,
	SET_TO_SERVER_TIME = 1,
	SET_TO_CLIENT_TIME = 2,
};

enum nfs4_acl_type {
	NFS4ACL_NONE = 0,
	NFS4ACL_ACL = 1,
	NFS4ACL_DACL = 2,
	NFS4ACL_SACL = 3,
};

enum nfs4_acl_whotype {
	NFS4_ACL_WHO_NAMED = 0,
	NFS4_ACL_WHO_OWNER = 1,
	NFS4_ACL_WHO_GROUP = 2,
	NFS4_ACL_WHO_EVERYONE = 3,
};

enum nfs4_callback_procnum {
	CB_NULL = 0,
	CB_COMPOUND = 1,
};

enum nfs4_change_attr_type {
	NFS4_CHANGE_TYPE_IS_MONOTONIC_INCR = 0,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER = 1,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER_NOPNFS = 2,
	NFS4_CHANGE_TYPE_IS_TIME_METADATA = 3,
	NFS4_CHANGE_TYPE_IS_UNDEFINED = 4,
};

enum nfs4_client_state {
	NFS4CLNT_MANAGER_RUNNING = 0,
	NFS4CLNT_CHECK_LEASE = 1,
	NFS4CLNT_LEASE_EXPIRED = 2,
	NFS4CLNT_RECLAIM_REBOOT = 3,
	NFS4CLNT_RECLAIM_NOGRACE = 4,
	NFS4CLNT_DELEGRETURN = 5,
	NFS4CLNT_SESSION_RESET = 6,
	NFS4CLNT_LEASE_CONFIRM = 7,
	NFS4CLNT_SERVER_SCOPE_MISMATCH = 8,
	NFS4CLNT_PURGE_STATE = 9,
	NFS4CLNT_BIND_CONN_TO_SESSION = 10,
	NFS4CLNT_MOVED = 11,
	NFS4CLNT_LEASE_MOVED = 12,
	NFS4CLNT_DELEGATION_EXPIRED = 13,
	NFS4CLNT_RUN_MANAGER = 14,
	NFS4CLNT_MANAGER_AVAILABLE = 15,
	NFS4CLNT_RECALL_RUNNING = 16,
	NFS4CLNT_RECALL_ANY_LAYOUT_READ = 17,
	NFS4CLNT_RECALL_ANY_LAYOUT_RW = 18,
	NFS4CLNT_DELEGRETURN_DELAYED = 19,
};

enum nfs4_ff_op_type {
	NFS4_FF_OP_LAYOUTSTATS = 0,
	NFS4_FF_OP_LAYOUTRETURN = 1,
};

enum nfs4_open_delegation_type4 {
	NFS4_OPEN_DELEGATE_NONE = 0,
	NFS4_OPEN_DELEGATE_READ = 1,
	NFS4_OPEN_DELEGATE_WRITE = 2,
	NFS4_OPEN_DELEGATE_NONE_EXT = 3,
	NFS4_OPEN_DELEGATE_READ_ATTRS_DELEG = 4,
	NFS4_OPEN_DELEGATE_WRITE_ATTRS_DELEG = 5,
};

enum nfs4_session_state {
	NFS4_SESSION_INITING = 0,
	NFS4_SESSION_ESTABLISHED = 1,
};

enum nfs4_setxattr_options {
	SETXATTR4_EITHER = 0,
	SETXATTR4_CREATE = 1,
	SETXATTR4_REPLACE = 2,
};

enum nfs4_slot_tbl_state {
	NFS4_SLOT_TBL_DRAINING = 0,
};

enum nfs_cb_opnum4 {
	OP_CB_GETATTR = 3,
	OP_CB_RECALL = 4,
	OP_CB_LAYOUTRECALL = 5,
	OP_CB_NOTIFY = 6,
	OP_CB_PUSH_DELEG = 7,
	OP_CB_RECALL_ANY = 8,
	OP_CB_RECALLABLE_OBJ_AVAIL = 9,
	OP_CB_RECALL_SLOT = 10,
	OP_CB_SEQUENCE = 11,
	OP_CB_WANTS_CANCELLED = 12,
	OP_CB_NOTIFY_LOCK = 13,
	OP_CB_NOTIFY_DEVICEID = 14,
	OP_CB_OFFLOAD = 15,
	OP_CB_ILLEGAL = 10044,
};

enum nfs_ftype4 {
	NF4BAD = 0,
	NF4REG = 1,
	NF4DIR = 2,
	NF4BLK = 3,
	NF4CHR = 4,
	NF4LNK = 5,
	NF4SOCK = 6,
	NF4FIFO = 7,
	NF4ATTRDIR = 8,
	NF4NAMEDATTR = 9,
};

enum nfs_lock_status {
	NFS_LOCK_NOT_SET = 0,
	NFS_LOCK_LOCK = 1,
	NFS_LOCK_NOLOCK = 2,
};

enum nfs_opnum4 {
	OP_ACCESS = 3,
	OP_CLOSE = 4,
	OP_COMMIT = 5,
	OP_CREATE = 6,
	OP_DELEGPURGE = 7,
	OP_DELEGRETURN = 8,
	OP_GETATTR = 9,
	OP_GETFH = 10,
	OP_LINK = 11,
	OP_LOCK = 12,
	OP_LOCKT = 13,
	OP_LOCKU = 14,
	OP_LOOKUP = 15,
	OP_LOOKUPP = 16,
	OP_NVERIFY = 17,
	OP_OPEN = 18,
	OP_OPENATTR = 19,
	OP_OPEN_CONFIRM = 20,
	OP_OPEN_DOWNGRADE = 21,
	OP_PUTFH = 22,
	OP_PUTPUBFH = 23,
	OP_PUTROOTFH = 24,
	OP_READ = 25,
	OP_READDIR = 26,
	OP_READLINK = 27,
	OP_REMOVE = 28,
	OP_RENAME = 29,
	OP_RENEW = 30,
	OP_RESTOREFH = 31,
	OP_SAVEFH = 32,
	OP_SECINFO = 33,
	OP_SETATTR = 34,
	OP_SETCLIENTID = 35,
	OP_SETCLIENTID_CONFIRM = 36,
	OP_VERIFY = 37,
	OP_WRITE = 38,
	OP_RELEASE_LOCKOWNER = 39,
	OP_BACKCHANNEL_CTL = 40,
	OP_BIND_CONN_TO_SESSION = 41,
	OP_EXCHANGE_ID = 42,
	OP_CREATE_SESSION = 43,
	OP_DESTROY_SESSION = 44,
	OP_FREE_STATEID = 45,
	OP_GET_DIR_DELEGATION = 46,
	OP_GETDEVICEINFO = 47,
	OP_GETDEVICELIST = 48,
	OP_LAYOUTCOMMIT = 49,
	OP_LAYOUTGET = 50,
	OP_LAYOUTRETURN = 51,
	OP_SECINFO_NO_NAME = 52,
	OP_SEQUENCE = 53,
	OP_SET_SSV = 54,
	OP_TEST_STATEID = 55,
	OP_WANT_DELEGATION = 56,
	OP_DESTROY_CLIENTID = 57,
	OP_RECLAIM_COMPLETE = 58,
	OP_ALLOCATE = 59,
	OP_COPY = 60,
	OP_COPY_NOTIFY = 61,
	OP_DEALLOCATE = 62,
	OP_IO_ADVISE = 63,
	OP_LAYOUTERROR = 64,
	OP_LAYOUTSTATS = 65,
	OP_OFFLOAD_CANCEL = 66,
	OP_OFFLOAD_STATUS = 67,
	OP_READ_PLUS = 68,
	OP_SEEK = 69,
	OP_WRITE_SAME = 70,
	OP_CLONE = 71,
	OP_GETXATTR = 72,
	OP_SETXATTR = 73,
	OP_LISTXATTRS = 74,
	OP_REMOVEXATTR = 75,
	OP_ILLEGAL = 10044,
};

enum nfs_param {
	Opt_ac = 0,
	Opt_acdirmax = 1,
	Opt_acdirmin = 2,
	Opt_acl___4 = 3,
	Opt_acregmax = 4,
	Opt_acregmin = 5,
	Opt_actimeo = 6,
	Opt_addr = 7,
	Opt_bg = 8,
	Opt_bsize = 9,
	Opt_clientaddr = 10,
	Opt_cto = 11,
	Opt_alignwrite = 12,
	Opt_fg = 13,
	Opt_fscache = 14,
	Opt_fscache_flag = 15,
	Opt_hard = 16,
	Opt_intr = 17,
	Opt_local_lock = 18,
	Opt_lock = 19,
	Opt_lookupcache = 20,
	Opt_migration = 21,
	Opt_minorversion = 22,
	Opt_mountaddr = 23,
	Opt_mounthost = 24,
	Opt_mountport = 25,
	Opt_mountproto = 26,
	Opt_mountvers = 27,
	Opt_namelen = 28,
	Opt_nconnect = 29,
	Opt_max_connect = 30,
	Opt_port___2 = 31,
	Opt_posix = 32,
	Opt_proto = 33,
	Opt_rdirplus = 34,
	Opt_rdma = 35,
	Opt_resvport = 36,
	Opt_retrans = 37,
	Opt_retry = 38,
	Opt_rsize = 39,
	Opt_sec = 40,
	Opt_sharecache = 41,
	Opt_sloppy = 42,
	Opt_soft = 43,
	Opt_softerr = 44,
	Opt_softreval = 45,
	Opt_source___2 = 46,
	Opt_tcp = 47,
	Opt_timeo = 48,
	Opt_trunkdiscovery = 49,
	Opt_udp = 50,
	Opt_v = 51,
	Opt_vers = 52,
	Opt_wsize = 53,
	Opt_write = 54,
	Opt_xprtsec = 55,
};

enum nfs_stat {
	NFS_OK = 0,
	NFSERR_PERM = 1,
	NFSERR_NOENT = 2,
	NFSERR_IO = 5,
	NFSERR_NXIO = 6,
	NFSERR_EAGAIN = 11,
	NFSERR_ACCES = 13,
	NFSERR_EXIST = 17,
	NFSERR_XDEV = 18,
	NFSERR_NODEV = 19,
	NFSERR_NOTDIR = 20,
	NFSERR_ISDIR = 21,
	NFSERR_INVAL = 22,
	NFSERR_FBIG = 27,
	NFSERR_NOSPC = 28,
	NFSERR_ROFS = 30,
	NFSERR_MLINK = 31,
	NFSERR_NAMETOOLONG = 63,
	NFSERR_NOTEMPTY = 66,
	NFSERR_DQUOT = 69,
	NFSERR_STALE = 70,
	NFSERR_REMOTE = 71,
	NFSERR_WFLUSH = 99,
	NFSERR_BADHANDLE = 10001,
	NFSERR_NOT_SYNC = 10002,
	NFSERR_BAD_COOKIE = 10003,
	NFSERR_NOTSUPP = 10004,
	NFSERR_TOOSMALL = 10005,
	NFSERR_SERVERFAULT = 10006,
	NFSERR_BADTYPE = 10007,
	NFSERR_JUKEBOX = 10008,
	NFSERR_SAME = 10009,
	NFSERR_DENIED = 10010,
	NFSERR_EXPIRED = 10011,
	NFSERR_LOCKED = 10012,
	NFSERR_GRACE = 10013,
	NFSERR_FHEXPIRED = 10014,
	NFSERR_SHARE_DENIED = 10015,
	NFSERR_WRONGSEC = 10016,
	NFSERR_CLID_INUSE = 10017,
	NFSERR_RESOURCE = 10018,
	NFSERR_MOVED = 10019,
	NFSERR_NOFILEHANDLE = 10020,
	NFSERR_MINOR_VERS_MISMATCH = 10021,
	NFSERR_STALE_CLIENTID = 10022,
	NFSERR_STALE_STATEID = 10023,
	NFSERR_OLD_STATEID = 10024,
	NFSERR_BAD_STATEID = 10025,
	NFSERR_BAD_SEQID = 10026,
	NFSERR_NOT_SAME = 10027,
	NFSERR_LOCK_RANGE = 10028,
	NFSERR_SYMLINK = 10029,
	NFSERR_RESTOREFH = 10030,
	NFSERR_LEASE_MOVED = 10031,
	NFSERR_ATTRNOTSUPP = 10032,
	NFSERR_NO_GRACE = 10033,
	NFSERR_RECLAIM_BAD = 10034,
	NFSERR_RECLAIM_CONFLICT = 10035,
	NFSERR_BAD_XDR = 10036,
	NFSERR_LOCKS_HELD = 10037,
	NFSERR_OPENMODE = 10038,
	NFSERR_BADOWNER = 10039,
	NFSERR_BADCHAR = 10040,
	NFSERR_BADNAME = 10041,
	NFSERR_BAD_RANGE = 10042,
	NFSERR_LOCK_NOTSUPP = 10043,
	NFSERR_OP_ILLEGAL = 10044,
	NFSERR_DEADLOCK = 10045,
	NFSERR_FILE_OPEN = 10046,
	NFSERR_ADMIN_REVOKED = 10047,
	NFSERR_CB_PATH_DOWN = 10048,
};

enum nfs_stat_bytecounters {
	NFSIOS_NORMALREADBYTES = 0,
	NFSIOS_NORMALWRITTENBYTES = 1,
	NFSIOS_DIRECTREADBYTES = 2,
	NFSIOS_DIRECTWRITTENBYTES = 3,
	NFSIOS_SERVERREADBYTES = 4,
	NFSIOS_SERVERWRITTENBYTES = 5,
	NFSIOS_READPAGES = 6,
	NFSIOS_WRITEPAGES = 7,
	__NFSIOS_BYTESMAX = 8,
};

enum nfs_stat_eventcounters {
	NFSIOS_INODEREVALIDATE = 0,
	NFSIOS_DENTRYREVALIDATE = 1,
	NFSIOS_DATAINVALIDATE = 2,
	NFSIOS_ATTRINVALIDATE = 3,
	NFSIOS_VFSOPEN = 4,
	NFSIOS_VFSLOOKUP = 5,
	NFSIOS_VFSACCESS = 6,
	NFSIOS_VFSUPDATEPAGE = 7,
	NFSIOS_VFSREADPAGE = 8,
	NFSIOS_VFSREADPAGES = 9,
	NFSIOS_VFSWRITEPAGE = 10,
	NFSIOS_VFSWRITEPAGES = 11,
	NFSIOS_VFSGETDENTS = 12,
	NFSIOS_VFSSETATTR = 13,
	NFSIOS_VFSFLUSH = 14,
	NFSIOS_VFSFSYNC = 15,
	NFSIOS_VFSLOCK = 16,
	NFSIOS_VFSRELEASE = 17,
	NFSIOS_CONGESTIONWAIT = 18,
	NFSIOS_SETATTRTRUNC = 19,
	NFSIOS_EXTENDWRITE = 20,
	NFSIOS_SILLYRENAME = 21,
	NFSIOS_SHORTREAD = 22,
	NFSIOS_SHORTWRITE = 23,
	NFSIOS_DELAY = 24,
	NFSIOS_PNFS_READ = 25,
	NFSIOS_PNFS_WRITE = 26,
	__NFSIOS_COUNTSMAX = 27,
};

enum nfsd4_cb_op {
	NFSPROC4_CLNT_CB_NULL = 0,
	NFSPROC4_CLNT_CB_RECALL = 1,
	NFSPROC4_CLNT_CB_LAYOUT = 2,
	NFSPROC4_CLNT_CB_OFFLOAD = 3,
	NFSPROC4_CLNT_CB_SEQUENCE = 4,
	NFSPROC4_CLNT_CB_NOTIFY_LOCK = 5,
	NFSPROC4_CLNT_CB_RECALL_ANY = 6,
	NFSPROC4_CLNT_CB_GETATTR = 7,
};

enum nfsd4_op_flags {
	ALLOWED_WITHOUT_FH = 1,
	ALLOWED_ON_ABSENT_FS = 2,
	ALLOWED_AS_FIRST_OP = 4,
	OP_HANDLES_WRONGSEC = 8,
	OP_IS_PUTFH_LIKE = 16,
	OP_MODIFIES_SOMETHING = 32,
	OP_CACHEME = 64,
	OP_CLEAR_STATEID = 128,
	OP_NONTRIVIAL_ERROR_ENCODE = 256,
};

enum nfsd_fsid {
	FSID_DEV = 0,
	FSID_NUM = 1,
	FSID_MAJOR_MINOR = 2,
	FSID_ENCODE_DEV = 3,
	FSID_UUID4_INUM = 4,
	FSID_UUID8 = 5,
	FSID_UUID16 = 6,
	FSID_UUID16_INUM = 7,
};

enum nfsstat4 {
	NFS4_OK = 0,
	NFS4ERR_PERM = 1,
	NFS4ERR_NOENT = 2,
	NFS4ERR_IO = 5,
	NFS4ERR_NXIO = 6,
	NFS4ERR_ACCESS = 13,
	NFS4ERR_EXIST = 17,
	NFS4ERR_XDEV = 18,
	NFS4ERR_NOTDIR = 20,
	NFS4ERR_ISDIR = 21,
	NFS4ERR_INVAL = 22,
	NFS4ERR_FBIG = 27,
	NFS4ERR_NOSPC = 28,
	NFS4ERR_ROFS = 30,
	NFS4ERR_MLINK = 31,
	NFS4ERR_NAMETOOLONG = 63,
	NFS4ERR_NOTEMPTY = 66,
	NFS4ERR_DQUOT = 69,
	NFS4ERR_STALE = 70,
	NFS4ERR_BADHANDLE = 10001,
	NFS4ERR_BAD_COOKIE = 10003,
	NFS4ERR_NOTSUPP = 10004,
	NFS4ERR_TOOSMALL = 10005,
	NFS4ERR_SERVERFAULT = 10006,
	NFS4ERR_BADTYPE = 10007,
	NFS4ERR_DELAY = 10008,
	NFS4ERR_SAME = 10009,
	NFS4ERR_DENIED = 10010,
	NFS4ERR_EXPIRED = 10011,
	NFS4ERR_LOCKED = 10012,
	NFS4ERR_GRACE = 10013,
	NFS4ERR_FHEXPIRED = 10014,
	NFS4ERR_SHARE_DENIED = 10015,
	NFS4ERR_WRONGSEC = 10016,
	NFS4ERR_CLID_INUSE = 10017,
	NFS4ERR_RESOURCE = 10018,
	NFS4ERR_MOVED = 10019,
	NFS4ERR_NOFILEHANDLE = 10020,
	NFS4ERR_MINOR_VERS_MISMATCH = 10021,
	NFS4ERR_STALE_CLIENTID = 10022,
	NFS4ERR_STALE_STATEID = 10023,
	NFS4ERR_OLD_STATEID = 10024,
	NFS4ERR_BAD_STATEID = 10025,
	NFS4ERR_BAD_SEQID = 10026,
	NFS4ERR_NOT_SAME = 10027,
	NFS4ERR_LOCK_RANGE = 10028,
	NFS4ERR_SYMLINK = 10029,
	NFS4ERR_RESTOREFH = 10030,
	NFS4ERR_LEASE_MOVED = 10031,
	NFS4ERR_ATTRNOTSUPP = 10032,
	NFS4ERR_NO_GRACE = 10033,
	NFS4ERR_RECLAIM_BAD = 10034,
	NFS4ERR_RECLAIM_CONFLICT = 10035,
	NFS4ERR_BADXDR = 10036,
	NFS4ERR_LOCKS_HELD = 10037,
	NFS4ERR_OPENMODE = 10038,
	NFS4ERR_BADOWNER = 10039,
	NFS4ERR_BADCHAR = 10040,
	NFS4ERR_BADNAME = 10041,
	NFS4ERR_BAD_RANGE = 10042,
	NFS4ERR_LOCK_NOTSUPP = 10043,
	NFS4ERR_OP_ILLEGAL = 10044,
	NFS4ERR_DEADLOCK = 10045,
	NFS4ERR_FILE_OPEN = 10046,
	NFS4ERR_ADMIN_REVOKED = 10047,
	NFS4ERR_CB_PATH_DOWN = 10048,
	NFS4ERR_BADIOMODE = 10049,
	NFS4ERR_BADLAYOUT = 10050,
	NFS4ERR_BAD_SESSION_DIGEST = 10051,
	NFS4ERR_BADSESSION = 10052,
	NFS4ERR_BADSLOT = 10053,
	NFS4ERR_COMPLETE_ALREADY = 10054,
	NFS4ERR_CONN_NOT_BOUND_TO_SESSION = 10055,
	NFS4ERR_DELEG_ALREADY_WANTED = 10056,
	NFS4ERR_BACK_CHAN_BUSY = 10057,
	NFS4ERR_LAYOUTTRYLATER = 10058,
	NFS4ERR_LAYOUTUNAVAILABLE = 10059,
	NFS4ERR_NOMATCHING_LAYOUT = 10060,
	NFS4ERR_RECALLCONFLICT = 10061,
	NFS4ERR_UNKNOWN_LAYOUTTYPE = 10062,
	NFS4ERR_SEQ_MISORDERED = 10063,
	NFS4ERR_SEQUENCE_POS = 10064,
	NFS4ERR_REQ_TOO_BIG = 10065,
	NFS4ERR_REP_TOO_BIG = 10066,
	NFS4ERR_REP_TOO_BIG_TO_CACHE = 10067,
	NFS4ERR_RETRY_UNCACHED_REP = 10068,
	NFS4ERR_UNSAFE_COMPOUND = 10069,
	NFS4ERR_TOO_MANY_OPS = 10070,
	NFS4ERR_OP_NOT_IN_SESSION = 10071,
	NFS4ERR_HASH_ALG_UNSUPP = 10072,
	NFS4ERR_CLIENTID_BUSY = 10074,
	NFS4ERR_PNFS_IO_HOLE = 10075,
	NFS4ERR_SEQ_FALSE_RETRY = 10076,
	NFS4ERR_BAD_HIGH_SLOT = 10077,
	NFS4ERR_DEADSESSION = 10078,
	NFS4ERR_ENCR_ALG_UNSUPP = 10079,
	NFS4ERR_PNFS_NO_LAYOUT = 10080,
	NFS4ERR_NOT_ONLY_OP = 10081,
	NFS4ERR_WRONG_CRED = 10082,
	NFS4ERR_WRONG_TYPE = 10083,
	NFS4ERR_DIRDELEG_UNAVAIL = 10084,
	NFS4ERR_REJECT_DELEG = 10085,
	NFS4ERR_RETURNCONFLICT = 10086,
	NFS4ERR_DELEG_REVOKED = 10087,
	NFS4ERR_PARTNER_NOTSUPP = 10088,
	NFS4ERR_PARTNER_NO_AUTH = 10089,
	NFS4ERR_UNION_NOTSUPP = 10090,
	NFS4ERR_OFFLOAD_DENIED = 10091,
	NFS4ERR_WRONG_LFS = 10092,
	NFS4ERR_BADLABEL = 10093,
	NFS4ERR_OFFLOAD_NO_REQS = 10094,
	NFS4ERR_NOXATTR = 10095,
	NFS4ERR_XATTR2BIG = 10096,
	NFS4ERR_FIRST_FREE = 10097,
};

enum nh_notifier_info_type {
	NH_NOTIFIER_INFO_TYPE_SINGLE = 0,
	NH_NOTIFIER_INFO_TYPE_GRP = 1,
	NH_NOTIFIER_INFO_TYPE_RES_TABLE = 2,
	NH_NOTIFIER_INFO_TYPE_RES_BUCKET = 3,
	NH_NOTIFIER_INFO_TYPE_GRP_HW_STATS = 4,
};

enum nhi_fw_mode {
	NHI_FW_SAFE_MODE = 0,
	NHI_FW_AUTH_MODE = 1,
	NHI_FW_EP_MODE = 2,
	NHI_FW_CM_MODE = 3,
};

enum nhi_mailbox_cmd {
	NHI_MAILBOX_SAVE_DEVS = 5,
	NHI_MAILBOX_DISCONNECT_PCIE_PATHS = 6,
	NHI_MAILBOX_DRV_UNLOADS = 7,
	NHI_MAILBOX_DISCONNECT_PA = 16,
	NHI_MAILBOX_DISCONNECT_PB = 17,
	NHI_MAILBOX_ALLOW_ALL_DEVS = 35,
};

enum nhlt_device_type {
	NHLT_DEVICE_BT = 0,
	NHLT_DEVICE_DMIC = 1,
	NHLT_DEVICE_I2S = 4,
	NHLT_DEVICE_INVALID = 5,
};

enum nhlt_link_type {
	NHLT_LINK_HDA = 0,
	NHLT_LINK_DSP = 1,
	NHLT_LINK_DMIC = 2,
	NHLT_LINK_SSP = 3,
	NHLT_LINK_INVALID = 4,
};

enum nl80211_auth_type {
	NL80211_AUTHTYPE_OPEN_SYSTEM = 0,
	NL80211_AUTHTYPE_SHARED_KEY = 1,
	NL80211_AUTHTYPE_FT = 2,
	NL80211_AUTHTYPE_NETWORK_EAP = 3,
	NL80211_AUTHTYPE_SAE = 4,
	NL80211_AUTHTYPE_FILS_SK = 5,
	NL80211_AUTHTYPE_FILS_SK_PFS = 6,
	NL80211_AUTHTYPE_FILS_PK = 7,
	__NL80211_AUTHTYPE_NUM = 8,
	NL80211_AUTHTYPE_MAX = 7,
	NL80211_AUTHTYPE_AUTOMATIC = 8,
};

enum nl80211_band {
	NL80211_BAND_2GHZ = 0,
	NL80211_BAND_5GHZ = 1,
	NL80211_BAND_60GHZ = 2,
	NL80211_BAND_6GHZ = 3,
	NL80211_BAND_S1GHZ = 4,
	NL80211_BAND_LC = 5,
	NUM_NL80211_BANDS = 6,
};

enum nl80211_bss_select_attr {
	__NL80211_BSS_SELECT_ATTR_INVALID = 0,
	NL80211_BSS_SELECT_ATTR_RSSI = 1,
	NL80211_BSS_SELECT_ATTR_BAND_PREF = 2,
	NL80211_BSS_SELECT_ATTR_RSSI_ADJUST = 3,
	__NL80211_BSS_SELECT_ATTR_AFTER_LAST = 4,
	NL80211_BSS_SELECT_ATTR_MAX = 3,
};

enum nl80211_chan_width {
	NL80211_CHAN_WIDTH_20_NOHT = 0,
	NL80211_CHAN_WIDTH_20 = 1,
	NL80211_CHAN_WIDTH_40 = 2,
	NL80211_CHAN_WIDTH_80 = 3,
	NL80211_CHAN_WIDTH_80P80 = 4,
	NL80211_CHAN_WIDTH_160 = 5,
	NL80211_CHAN_WIDTH_5 = 6,
	NL80211_CHAN_WIDTH_10 = 7,
	NL80211_CHAN_WIDTH_1 = 8,
	NL80211_CHAN_WIDTH_2 = 9,
	NL80211_CHAN_WIDTH_4 = 10,
	NL80211_CHAN_WIDTH_8 = 11,
	NL80211_CHAN_WIDTH_16 = 12,
	NL80211_CHAN_WIDTH_320 = 13,
};

enum nl80211_dfs_regions {
	NL80211_DFS_UNSET = 0,
	NL80211_DFS_FCC = 1,
	NL80211_DFS_ETSI = 2,
	NL80211_DFS_JP = 3,
};

enum nl80211_dfs_state {
	NL80211_DFS_USABLE = 0,
	NL80211_DFS_UNAVAILABLE = 1,
	NL80211_DFS_AVAILABLE = 2,
};

enum nl80211_iftype {
	NL80211_IFTYPE_UNSPECIFIED = 0,
	NL80211_IFTYPE_ADHOC = 1,
	NL80211_IFTYPE_STATION = 2,
	NL80211_IFTYPE_AP = 3,
	NL80211_IFTYPE_AP_VLAN = 4,
	NL80211_IFTYPE_WDS = 5,
	NL80211_IFTYPE_MONITOR = 6,
	NL80211_IFTYPE_MESH_POINT = 7,
	NL80211_IFTYPE_P2P_CLIENT = 8,
	NL80211_IFTYPE_P2P_GO = 9,
	NL80211_IFTYPE_P2P_DEVICE = 10,
	NL80211_IFTYPE_OCB = 11,
	NL80211_IFTYPE_NAN = 12,
	NUM_NL80211_IFTYPES = 13,
	NL80211_IFTYPE_MAX = 12,
};

enum nl80211_key_mode {
	NL80211_KEY_RX_TX = 0,
	NL80211_KEY_NO_TX = 1,
	NL80211_KEY_SET_TX = 2,
};

enum nl80211_mfp {
	NL80211_MFP_NO = 0,
	NL80211_MFP_REQUIRED = 1,
	NL80211_MFP_OPTIONAL = 2,
};

enum nl80211_reg_initiator {
	NL80211_REGDOM_SET_BY_CORE = 0,
	NL80211_REGDOM_SET_BY_USER = 1,
	NL80211_REGDOM_SET_BY_DRIVER = 2,
	NL80211_REGDOM_SET_BY_COUNTRY_IE = 3,
};

enum nl80211_sae_pwe_mechanism {
	NL80211_SAE_PWE_UNSPECIFIED = 0,
	NL80211_SAE_PWE_HUNT_AND_PECK = 1,
	NL80211_SAE_PWE_HASH_TO_ELEMENT = 2,
	NL80211_SAE_PWE_BOTH = 3,
};

enum nl80211_sar_type {
	NL80211_SAR_TYPE_POWER = 0,
	NUM_NL80211_SAR_TYPE = 1,
};

enum nl80211_user_reg_hint_type {
	NL80211_USER_REG_HINT_USER = 0,
	NL80211_USER_REG_HINT_CELL_BASE = 1,
	NL80211_USER_REG_HINT_INDOOR = 2,
};

enum nla_policy_validation {
	NLA_VALIDATE_NONE = 0,
	NLA_VALIDATE_RANGE = 1,
	NLA_VALIDATE_RANGE_WARN_TOO_LONG = 2,
	NLA_VALIDATE_MIN = 3,
	NLA_VALIDATE_MAX = 4,
	NLA_VALIDATE_MASK = 5,
	NLA_VALIDATE_RANGE_PTR = 6,
	NLA_VALIDATE_FUNCTION = 7,
};

enum nlmsgerr_attrs {
	NLMSGERR_ATTR_UNUSED = 0,
	NLMSGERR_ATTR_MSG = 1,
	NLMSGERR_ATTR_OFFS = 2,
	NLMSGERR_ATTR_COOKIE = 3,
	NLMSGERR_ATTR_POLICY = 4,
	NLMSGERR_ATTR_MISS_TYPE = 5,
	NLMSGERR_ATTR_MISS_NEST = 6,
	__NLMSGERR_ATTR_MAX = 7,
	NLMSGERR_ATTR_MAX = 6,
};

enum node_stat_item {
	NR_LRU_BASE = 0,
	NR_INACTIVE_ANON = 0,
	NR_ACTIVE_ANON = 1,
	NR_INACTIVE_FILE = 2,
	NR_ACTIVE_FILE = 3,
	NR_UNEVICTABLE = 4,
	NR_SLAB_RECLAIMABLE_B = 5,
	NR_SLAB_UNRECLAIMABLE_B = 6,
	NR_ISOLATED_ANON = 7,
	NR_ISOLATED_FILE = 8,
	WORKINGSET_NODES = 9,
	WORKINGSET_REFAULT_BASE = 10,
	WORKINGSET_REFAULT_ANON = 10,
	WORKINGSET_REFAULT_FILE = 11,
	WORKINGSET_ACTIVATE_BASE = 12,
	WORKINGSET_ACTIVATE_ANON = 12,
	WORKINGSET_ACTIVATE_FILE = 13,
	WORKINGSET_RESTORE_BASE = 14,
	WORKINGSET_RESTORE_ANON = 14,
	WORKINGSET_RESTORE_FILE = 15,
	WORKINGSET_NODERECLAIM = 16,
	NR_ANON_MAPPED = 17,
	NR_FILE_MAPPED = 18,
	NR_FILE_PAGES = 19,
	NR_FILE_DIRTY = 20,
	NR_WRITEBACK = 21,
	NR_WRITEBACK_TEMP = 22,
	NR_SHMEM = 23,
	NR_SHMEM_THPS = 24,
	NR_SHMEM_PMDMAPPED = 25,
	NR_FILE_THPS = 26,
	NR_FILE_PMDMAPPED = 27,
	NR_ANON_THPS = 28,
	NR_VMSCAN_WRITE = 29,
	NR_VMSCAN_IMMEDIATE = 30,
	NR_DIRTIED = 31,
	NR_WRITTEN = 32,
	NR_THROTTLED_WRITTEN = 33,
	NR_KERNEL_MISC_RECLAIMABLE = 34,
	NR_FOLL_PIN_ACQUIRED = 35,
	NR_FOLL_PIN_RELEASED = 36,
	NR_KERNEL_STACK_KB = 37,
	NR_PAGETABLE = 38,
	NR_SECONDARY_PAGETABLE = 39,
	NR_IOMMU_PAGES = 40,
	NR_SWAPCACHE = 41,
	PGPROMOTE_SUCCESS = 42,
	PGPROMOTE_CANDIDATE = 43,
	PGDEMOTE_KSWAPD = 44,
	PGDEMOTE_DIRECT = 45,
	PGDEMOTE_KHUGEPAGED = 46,
	NR_HUGETLB = 47,
	NR_VM_NODE_STAT_ITEMS = 48,
};

enum node_states {
	N_POSSIBLE = 0,
	N_ONLINE = 1,
	N_NORMAL_MEMORY = 2,
	N_HIGH_MEMORY = 2,
	N_MEMORY = 3,
	N_CPU = 4,
	N_GENERIC_INITIATOR = 5,
	NR_NODE_STATES = 6,
};

enum notify_state {
	SECCOMP_NOTIFY_INIT = 0,
	SECCOMP_NOTIFY_SENT = 1,
	SECCOMP_NOTIFY_REPLIED = 2,
};

enum numa_faults_stats {
	NUMA_MEM = 0,
	NUMA_CPU = 1,
	NUMA_MEMBUF = 2,
	NUMA_CPUBUF = 3,
};

enum numa_stat_item {
	NUMA_HIT = 0,
	NUMA_MISS = 1,
	NUMA_FOREIGN = 2,
	NUMA_INTERLEAVE_HIT = 3,
	NUMA_LOCAL = 4,
	NUMA_OTHER = 5,
	NR_VM_NUMA_EVENT_ITEMS = 6,
};

enum numa_topology_type {
	NUMA_DIRECT = 0,
	NUMA_GLUELESS_MESH = 1,
	NUMA_BACKPLANE = 2,
};

enum numa_type {
	node_has_spare = 0,
	node_fully_busy = 1,
	node_overloaded = 2,
};

enum numa_vmaskip_reason {
	NUMAB_SKIP_UNSUITABLE = 0,
	NUMAB_SKIP_SHARED_RO = 1,
	NUMAB_SKIP_INACCESSIBLE = 2,
	NUMAB_SKIP_SCAN_DELAY = 3,
	NUMAB_SKIP_PID_INACTIVE = 4,
	NUMAB_SKIP_IGNORE_PID = 5,
	NUMAB_SKIP_SEQ_COMPLETED = 6,
};

enum nvme_admin_opcode {
	nvme_admin_delete_sq = 0,
	nvme_admin_create_sq = 1,
	nvme_admin_get_log_page = 2,
	nvme_admin_delete_cq = 4,
	nvme_admin_create_cq = 5,
	nvme_admin_identify = 6,
	nvme_admin_abort_cmd = 8,
	nvme_admin_set_features = 9,
	nvme_admin_get_features = 10,
	nvme_admin_async_event = 12,
	nvme_admin_ns_mgmt = 13,
	nvme_admin_activate_fw = 16,
	nvme_admin_download_fw = 17,
	nvme_admin_dev_self_test = 20,
	nvme_admin_ns_attach = 21,
	nvme_admin_keep_alive = 24,
	nvme_admin_directive_send = 25,
	nvme_admin_directive_recv = 26,
	nvme_admin_virtual_mgmt = 28,
	nvme_admin_nvme_mi_send = 29,
	nvme_admin_nvme_mi_recv = 30,
	nvme_admin_dbbuf = 124,
	nvme_admin_format_nvm = 128,
	nvme_admin_security_send = 129,
	nvme_admin_security_recv = 130,
	nvme_admin_sanitize_nvm = 132,
	nvme_admin_get_lba_status = 134,
	nvme_admin_vendor_start = 192,
};

enum nvme_ana_state {
	NVME_ANA_OPTIMIZED = 1,
	NVME_ANA_NONOPTIMIZED = 2,
	NVME_ANA_INACCESSIBLE = 3,
	NVME_ANA_PERSISTENT_LOSS = 4,
	NVME_ANA_CHANGE = 15,
};

enum nvme_ctrl_attr {
	NVME_CTRL_ATTR_HID_128_BIT = 1,
	NVME_CTRL_ATTR_TBKAS = 64,
	NVME_CTRL_ATTR_ELBAS = 32768,
	NVME_CTRL_ATTR_RHII = 262144,
};

enum nvme_ctrl_flags {
	NVME_CTRL_FAILFAST_EXPIRED = 0,
	NVME_CTRL_ADMIN_Q_STOPPED = 1,
	NVME_CTRL_STARTED_ONCE = 2,
	NVME_CTRL_STOPPED = 3,
	NVME_CTRL_SKIP_ID_CNS_CS = 4,
	NVME_CTRL_DIRTY_CAPABILITY = 5,
	NVME_CTRL_FROZEN = 6,
};

enum nvme_ctrl_state {
	NVME_CTRL_NEW = 0,
	NVME_CTRL_LIVE = 1,
	NVME_CTRL_RESETTING = 2,
	NVME_CTRL_CONNECTING = 3,
	NVME_CTRL_DELETING = 4,
	NVME_CTRL_DELETING_NOIO = 5,
	NVME_CTRL_DEAD = 6,
};

enum nvme_ctrl_type {
	NVME_CTRL_IO = 1,
	NVME_CTRL_DISC = 2,
	NVME_CTRL_ADMIN = 3,
};

enum nvme_dctype {
	NVME_DCTYPE_NOT_REPORTED = 0,
	NVME_DCTYPE_DDC = 1,
	NVME_DCTYPE_CDC = 2,
};

enum nvme_disposition {
	COMPLETE = 0,
	RETRY = 1,
	FAILOVER = 2,
	AUTHENTICATE = 3,
};

enum nvme_eds {
	NVME_EXTENDED_DATA_STRUCT = 1,
};

enum nvme_iopolicy {
	NVME_IOPOLICY_NUMA = 0,
	NVME_IOPOLICY_RR = 1,
	NVME_IOPOLICY_QD = 2,
};

enum nvme_ns_features {
	NVME_NS_EXT_LBAS = 1,
	NVME_NS_METADATA_SUPPORTED = 2,
	NVME_NS_DEAC = 4,
};

enum nvme_opcode {
	nvme_cmd_flush = 0,
	nvme_cmd_write = 1,
	nvme_cmd_read = 2,
	nvme_cmd_write_uncor = 4,
	nvme_cmd_compare = 5,
	nvme_cmd_write_zeroes = 8,
	nvme_cmd_dsm = 9,
	nvme_cmd_verify = 12,
	nvme_cmd_resv_register = 13,
	nvme_cmd_resv_report = 14,
	nvme_cmd_resv_acquire = 17,
	nvme_cmd_resv_release = 21,
	nvme_cmd_zone_mgmt_send = 121,
	nvme_cmd_zone_mgmt_recv = 122,
	nvme_cmd_zone_append = 125,
	nvme_cmd_vendor_start = 128,
};

enum nvme_pr_acquire_action {
	NVME_PR_ACQUIRE_ACT_ACQUIRE = 0,
	NVME_PR_ACQUIRE_ACT_PREEMPT = 1,
	NVME_PR_ACQUIRE_ACT_PREEMPT_AND_ABORT = 2,
};

enum nvme_pr_change_ptpl {
	NVME_PR_CPTPL_NO_CHANGE = 0,
	NVME_PR_CPTPL_RESV = 1073741824,
	NVME_PR_CPTPL_CLEARED = -2147483648,
	NVME_PR_CPTPL_PERSIST = -1073741824,
};

enum nvme_pr_register_action {
	NVME_PR_REGISTER_ACT_REG = 0,
	NVME_PR_REGISTER_ACT_UNREG = 1,
	NVME_PR_REGISTER_ACT_REPLACE = 2,
};

enum nvme_pr_release_action {
	NVME_PR_RELEASE_ACT_RELEASE = 0,
	NVME_PR_RELEASE_ACT_CLEAR = 1,
};

enum nvme_pr_type {
	NVME_PR_WRITE_EXCLUSIVE = 1,
	NVME_PR_EXCLUSIVE_ACCESS = 2,
	NVME_PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	NVME_PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	NVME_PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	NVME_PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

enum nvme_quirks {
	NVME_QUIRK_STRIPE_SIZE = 1,
	NVME_QUIRK_IDENTIFY_CNS = 2,
	NVME_QUIRK_DEALLOCATE_ZEROES = 4,
	NVME_QUIRK_DELAY_BEFORE_CHK_RDY = 8,
	NVME_QUIRK_NO_APST = 16,
	NVME_QUIRK_NO_DEEPEST_PS = 32,
	NVME_QUIRK_QDEPTH_ONE = 64,
	NVME_QUIRK_MEDIUM_PRIO_SQ = 128,
	NVME_QUIRK_IGNORE_DEV_SUBNQN = 256,
	NVME_QUIRK_DISABLE_WRITE_ZEROES = 512,
	NVME_QUIRK_SIMPLE_SUSPEND = 1024,
	NVME_QUIRK_SINGLE_VECTOR = 2048,
	NVME_QUIRK_128_BYTES_SQES = 4096,
	NVME_QUIRK_SHARED_TAGS = 8192,
	NVME_QUIRK_NO_TEMP_THRESH_CHANGE = 16384,
	NVME_QUIRK_NO_NS_DESC_LIST = 32768,
	NVME_QUIRK_DMA_ADDRESS_BITS_48 = 65536,
	NVME_QUIRK_SKIP_CID_GEN = 131072,
	NVME_QUIRK_BOGUS_NID = 262144,
	NVME_QUIRK_NO_SECONDARY_TEMP_THRESH = 524288,
	NVME_QUIRK_FORCE_NO_SIMPLE_SUSPEND = 1048576,
	NVME_QUIRK_BROKEN_MSI = 2097152,
	NVME_QUIRK_DMAPOOL_ALIGN_512 = 4194304,
};

enum nvme_subsys_type {
	NVME_NQN_DISC = 1,
	NVME_NQN_NVME = 2,
	NVME_NQN_CURR = 3,
};

enum nvme_zone_mgmt_action {
	NVME_ZONE_CLOSE = 1,
	NVME_ZONE_FINISH = 2,
	NVME_ZONE_OPEN = 3,
	NVME_ZONE_RESET = 4,
	NVME_ZONE_OFFLINE = 5,
	NVME_ZONE_SET_DESC_EXT = 16,
};

enum nvmem_type {
	NVMEM_TYPE_UNKNOWN = 0,
	NVMEM_TYPE_EEPROM = 1,
	NVMEM_TYPE_OTP = 2,
	NVMEM_TYPE_BATTERY_BACKED = 3,
	NVMEM_TYPE_FRAM = 4,
};

enum nvmf_capsule_command {
	nvme_fabrics_type_property_set = 0,
	nvme_fabrics_type_connect = 1,
	nvme_fabrics_type_property_get = 4,
	nvme_fabrics_type_auth_send = 5,
	nvme_fabrics_type_auth_receive = 6,
};

enum nvmf_fabrics_opcode {
	nvme_fabrics_command = 127,
};

enum objext_flags {
	OBJEXTS_ALLOC_FAIL = 4,
	__NR_OBJEXTS_FLAGS = 8,
};

enum of_gpio_flags {
	OF_GPIO_ACTIVE_LOW = 1,
	OF_GPIO_SINGLE_ENDED = 2,
	OF_GPIO_OPEN_DRAIN = 4,
	OF_GPIO_TRANSITORY = 8,
	OF_GPIO_PULL_UP = 16,
	OF_GPIO_PULL_DOWN = 32,
	OF_GPIO_PULL_DISABLE = 64,
};

enum offload_act_command {
	FLOW_ACT_REPLACE = 0,
	FLOW_ACT_DESTROY = 1,
	FLOW_ACT_STATS = 2,
};

enum ohci_rh_state {
	OHCI_RH_HALTED = 0,
	OHCI_RH_SUSPENDED = 1,
	OHCI_RH_RUNNING = 2,
};

enum oom_constraint {
	CONSTRAINT_NONE = 0,
	CONSTRAINT_CPUSET = 1,
	CONSTRAINT_MEMORY_POLICY = 2,
	CONSTRAINT_MEMCG = 3,
};

enum open_args_createmode4 {
	OPEN_ARGS_CREATEMODE_UNCHECKED4 = 0,
	OPEN_ARGS_CREATE_MODE_GUARDED = 1,
	OPEN_ARGS_CREATEMODE_EXCLUSIVE4 = 2,
	OPEN_ARGS_CREATE_MODE_EXCLUSIVE4_1 = 3,
};

enum open_args_open_claim4 {
	OPEN_ARGS_OPEN_CLAIM_NULL = 0,
	OPEN_ARGS_OPEN_CLAIM_PREVIOUS = 1,
	OPEN_ARGS_OPEN_CLAIM_DELEGATE_CUR = 2,
	OPEN_ARGS_OPEN_CLAIM_DELEGATE_PREV = 3,
	OPEN_ARGS_OPEN_CLAIM_FH = 4,
	OPEN_ARGS_OPEN_CLAIM_DELEG_CUR_FH = 5,
	OPEN_ARGS_OPEN_CLAIM_DELEG_PREV_FH = 6,
};

enum open_args_share_access4 {
	OPEN_ARGS_SHARE_ACCESS_READ = 1,
	OPEN_ARGS_SHARE_ACCESS_WRITE = 2,
	OPEN_ARGS_SHARE_ACCESS_BOTH = 3,
};

enum open_args_share_access_want4 {
	OPEN_ARGS_SHARE_ACCESS_WANT_ANY_DELEG = 3,
	OPEN_ARGS_SHARE_ACCESS_WANT_NO_DELEG = 4,
	OPEN_ARGS_SHARE_ACCESS_WANT_CANCEL = 5,
	OPEN_ARGS_SHARE_ACCESS_WANT_SIGNAL_DELEG_WHEN_RESRC_AVAIL = 17,
	OPEN_ARGS_SHARE_ACCESS_WANT_PUSH_DELEG_WHEN_UNCONTENDED = 18,
	OPEN_ARGS_SHARE_ACCESS_WANT_DELEG_TIMESTAMPS = 20,
	OPEN_ARGS_SHARE_ACCESS_WANT_OPEN_XOR_DELEGATION = 21,
};

enum open_args_share_deny4 {
	OPEN_ARGS_SHARE_DENY_NONE = 0,
	OPEN_ARGS_SHARE_DENY_READ = 1,
	OPEN_ARGS_SHARE_DENY_WRITE = 2,
	OPEN_ARGS_SHARE_DENY_BOTH = 3,
};

enum open_claim_type4 {
	NFS4_OPEN_CLAIM_NULL = 0,
	NFS4_OPEN_CLAIM_PREVIOUS = 1,
	NFS4_OPEN_CLAIM_DELEGATE_CUR = 2,
	NFS4_OPEN_CLAIM_DELEGATE_PREV = 3,
	NFS4_OPEN_CLAIM_FH = 4,
	NFS4_OPEN_CLAIM_DELEG_CUR_FH = 5,
	NFS4_OPEN_CLAIM_DELEG_PREV_FH = 6,
};

enum open_delegation_type4 {
	OPEN_DELEGATE_NONE = 0,
	OPEN_DELEGATE_READ = 1,
	OPEN_DELEGATE_WRITE = 2,
	OPEN_DELEGATE_NONE_EXT = 3,
	OPEN_DELEGATE_READ_ATTRS_DELEG = 4,
	OPEN_DELEGATE_WRITE_ATTRS_DELEG = 5,
};

enum open_frame_protocol {
	PROTOCOL_SMP = 0,
	PROTOCOL_SSP = 1,
	PROTOCOL_STP = 2,
};

enum opentype4 {
	NFS4_OPEN_NOCREATE = 0,
	NFS4_OPEN_CREATE = 1,
};

enum opp_table_access {
	OPP_TABLE_ACCESS_UNKNOWN = 0,
	OPP_TABLE_ACCESS_EXCLUSIVE = 1,
	OPP_TABLE_ACCESS_SHARED = 2,
};

enum ovl_copyop {
	OVL_COPY = 0,
	OVL_CLONE = 1,
	OVL_DEDUPE = 2,
};

enum ovl_entry_flag {
	OVL_E_UPPER_ALIAS = 0,
	OVL_E_OPAQUE = 1,
	OVL_E_CONNECTED = 2,
	OVL_E_XWHITEOUTS = 3,
};

enum ovl_inode_flag {
	OVL_IMPURE = 0,
	OVL_WHITEOUTS = 1,
	OVL_INDEX = 2,
	OVL_UPPERDATA = 3,
	OVL_CONST_INO = 4,
	OVL_HAS_DIGEST = 5,
	OVL_VERIFIED_DIGEST = 6,
};

enum ovl_opt {
	Opt_lowerdir = 0,
	Opt_lowerdir_add = 1,
	Opt_datadir_add = 2,
	Opt_upperdir = 3,
	Opt_workdir = 4,
	Opt_default_permissions = 5,
	Opt_redirect_dir = 6,
	Opt_index = 7,
	Opt_uuid = 8,
	Opt_nfs_export = 9,
	Opt_userxattr = 10,
	Opt_xino = 11,
	Opt_metacopy = 12,
	Opt_verity = 13,
	Opt_volatile = 14,
};

enum ovl_path_type {
	__OVL_PATH_UPPER = 1,
	__OVL_PATH_MERGE = 2,
	__OVL_PATH_ORIGIN = 4,
};

enum ovl_xattr {
	OVL_XATTR_OPAQUE = 0,
	OVL_XATTR_REDIRECT = 1,
	OVL_XATTR_ORIGIN = 2,
	OVL_XATTR_IMPURE = 3,
	OVL_XATTR_NLINK = 4,
	OVL_XATTR_UPPER = 5,
	OVL_XATTR_UUID = 6,
	OVL_XATTR_METACOPY = 7,
	OVL_XATTR_PROTATTR = 8,
	OVL_XATTR_XWHITEOUT = 9,
};

enum owner_state {
	OWNER_NULL = 1,
	OWNER_WRITER = 2,
	OWNER_READER = 4,
	OWNER_NONSPINNABLE = 8,
};

enum p9_cache_bits {
	CACHE_NONE = 0,
	CACHE_FILE = 1,
	CACHE_META = 2,
	CACHE_WRITEBACK = 4,
	CACHE_LOOSE = 8,
	CACHE_FSCACHE = 128,
};

enum p9_cache_shortcuts {
	CACHE_SC_NONE = 0,
	CACHE_SC_READAHEAD = 1,
	CACHE_SC_MMAP = 5,
	CACHE_SC_LOOSE = 15,
	CACHE_SC_FSCACHE = 143,
};

enum p9_fid_reftype {
	P9_FID_REF_CREATE = 0,
	P9_FID_REF_GET = 1,
	P9_FID_REF_PUT = 2,
	P9_FID_REF_DESTROY = 3,
} __attribute__((mode(byte)));

enum p9_msg_t {
	P9_TLERROR = 6,
	P9_RLERROR = 7,
	P9_TSTATFS = 8,
	P9_RSTATFS = 9,
	P9_TLOPEN = 12,
	P9_RLOPEN = 13,
	P9_TLCREATE = 14,
	P9_RLCREATE = 15,
	P9_TSYMLINK = 16,
	P9_RSYMLINK = 17,
	P9_TMKNOD = 18,
	P9_RMKNOD = 19,
	P9_TRENAME = 20,
	P9_RRENAME = 21,
	P9_TREADLINK = 22,
	P9_RREADLINK = 23,
	P9_TGETATTR = 24,
	P9_RGETATTR = 25,
	P9_TSETATTR = 26,
	P9_RSETATTR = 27,
	P9_TXATTRWALK = 30,
	P9_RXATTRWALK = 31,
	P9_TXATTRCREATE = 32,
	P9_RXATTRCREATE = 33,
	P9_TREADDIR = 40,
	P9_RREADDIR = 41,
	P9_TFSYNC = 50,
	P9_RFSYNC = 51,
	P9_TLOCK = 52,
	P9_RLOCK = 53,
	P9_TGETLOCK = 54,
	P9_RGETLOCK = 55,
	P9_TLINK = 70,
	P9_RLINK = 71,
	P9_TMKDIR = 72,
	P9_RMKDIR = 73,
	P9_TRENAMEAT = 74,
	P9_RRENAMEAT = 75,
	P9_TUNLINKAT = 76,
	P9_RUNLINKAT = 77,
	P9_TVERSION = 100,
	P9_RVERSION = 101,
	P9_TAUTH = 102,
	P9_RAUTH = 103,
	P9_TATTACH = 104,
	P9_RATTACH = 105,
	P9_TERROR = 106,
	P9_RERROR = 107,
	P9_TFLUSH = 108,
	P9_RFLUSH = 109,
	P9_TWALK = 110,
	P9_RWALK = 111,
	P9_TOPEN = 112,
	P9_ROPEN = 113,
	P9_TCREATE = 114,
	P9_RCREATE = 115,
	P9_TREAD = 116,
	P9_RREAD = 117,
	P9_TWRITE = 118,
	P9_RWRITE = 119,
	P9_TCLUNK = 120,
	P9_RCLUNK = 121,
	P9_TREMOVE = 122,
	P9_RREMOVE = 123,
	P9_TSTAT = 124,
	P9_RSTAT = 125,
	P9_TWSTAT = 126,
	P9_RWSTAT = 127,
};

enum p9_open_mode_t {
	P9_OREAD = 0,
	P9_OWRITE = 1,
	P9_ORDWR = 2,
	P9_OEXEC = 3,
	P9_OTRUNC = 16,
	P9_OREXEC = 32,
	P9_ORCLOSE = 64,
	P9_OAPPEND = 128,
	P9_OEXCL = 4096,
	P9L_MODE_MASK = 8191,
	P9L_DIRECT = 8192,
	P9L_NOWRITECACHE = 16384,
	P9L_LOOSE = 32768,
};

enum p9_perm_t {
	P9_DMDIR = 2147483648,
	P9_DMAPPEND = 1073741824,
	P9_DMEXCL = 536870912,
	P9_DMMOUNT = 268435456,
	P9_DMAUTH = 134217728,
	P9_DMTMP = 67108864,
	P9_DMSYMLINK = 33554432,
	P9_DMLINK = 16777216,
	P9_DMDEVICE = 8388608,
	P9_DMNAMEDPIPE = 2097152,
	P9_DMSOCKET = 1048576,
	P9_DMSETUID = 524288,
	P9_DMSETGID = 262144,
	P9_DMSETVTX = 65536,
};

enum p9_proto_versions {
	p9_proto_legacy = 0,
	p9_proto_2000u = 1,
	p9_proto_2000L = 2,
};

enum p9_req_status_t {
	REQ_STATUS_ALLOC = 0,
	REQ_STATUS_UNSENT = 1,
	REQ_STATUS_SENT = 2,
	REQ_STATUS_RCVD = 3,
	REQ_STATUS_FLSHD = 4,
	REQ_STATUS_ERROR = 5,
};

enum p9_session_flags {
	V9FS_PROTO_2000U = 1,
	V9FS_PROTO_2000L = 2,
	V9FS_ACCESS_SINGLE = 4,
	V9FS_ACCESS_USER = 8,
	V9FS_ACCESS_CLIENT = 16,
	V9FS_POSIX_ACL = 32,
	V9FS_NO_XATTR = 64,
	V9FS_IGNORE_QV = 128,
	V9FS_DIRECT_IO = 256,
	V9FS_SYNC = 512,
};

enum p9_trans_status {
	Connected = 0,
	BeginDisconnect = 1,
	Disconnected = 2,
	Hung = 3,
};

enum packet_sock_flags {
	PACKET_SOCK_ORIGDEV = 0,
	PACKET_SOCK_AUXDATA = 1,
	PACKET_SOCK_TX_HAS_OFF = 2,
	PACKET_SOCK_TP_LOSS = 3,
	PACKET_SOCK_RUNNING = 4,
	PACKET_SOCK_PRESSURE = 5,
	PACKET_SOCK_QDISC_BYPASS = 6,
};

enum packets_types {
	PACKET_AVCPQ = 1,
	PACKET_PTPQ = 2,
	PACKET_DCBCPQ = 3,
	PACKET_UPQ = 4,
	PACKET_MCBCQ = 5,
};

enum page_memcg_data_flags {
	MEMCG_DATA_OBJEXTS = 1,
	MEMCG_DATA_KMEM = 2,
	__NR_MEMCG_DATA_FLAGS = 4,
};

enum page_size_enum {
	__PAGE_SIZE = 16384,
};

enum page_walk_action {
	ACTION_SUBTREE = 0,
	ACTION_CONTINUE = 1,
	ACTION_AGAIN = 2,
};

enum page_walk_lock {
	PGWALK_RDLOCK = 0,
	PGWALK_WRLOCK = 1,
	PGWALK_WRLOCK_VERIFY = 2,
};

enum pageblock_bits {
	PB_migrate = 0,
	PB_migrate_end = 2,
	PB_migrate_skip = 3,
	NR_PAGEBLOCK_BITS = 4,
};

enum pageflags {
	PG_locked = 0,
	PG_writeback = 1,
	PG_referenced = 2,
	PG_uptodate = 3,
	PG_dirty = 4,
	PG_lru = 5,
	PG_head = 6,
	PG_waiters = 7,
	PG_active = 8,
	PG_workingset = 9,
	PG_owner_priv_1 = 10,
	PG_owner_2 = 11,
	PG_arch_1 = 12,
	PG_reserved = 13,
	PG_private = 14,
	PG_private_2 = 15,
	PG_reclaim = 16,
	PG_swapbacked = 17,
	PG_unevictable = 18,
	PG_dropbehind = 19,
	PG_mlocked = 20,
	__NR_PAGEFLAGS = 21,
	PG_readahead = 16,
	PG_swapcache = 10,
	PG_checked = 10,
	PG_anon_exclusive = 11,
	PG_mappedtodisk = 11,
	PG_fscache = 15,
	PG_pinned = 10,
	PG_savepinned = 4,
	PG_foreign = 10,
	PG_xen_remapped = 10,
	PG_isolated = 16,
	PG_reported = 3,
	PG_vmemmap_self_hosted = 10,
	PG_has_hwpoisoned = 8,
	PG_large_rmappable = 9,
	PG_partially_mapped = 16,
};

enum pagetype {
	PGTY_buddy = 240,
	PGTY_offline = 241,
	PGTY_table = 242,
	PGTY_guard = 243,
	PGTY_hugetlb = 244,
	PGTY_slab = 245,
	PGTY_zsmalloc = 246,
	PGTY_unaccepted = 247,
	PGTY_mapcount_underflow = 255,
};

enum parport_pc_pci_cards {
	titan_110l = 0,
	titan_210l = 1,
	netmos_9xx5_combo = 2,
	netmos_9855 = 3,
	netmos_9855_2p = 4,
	netmos_9900 = 5,
	netmos_9900_2p = 6,
	netmos_99xx_1p = 7,
	avlab_1s1p = 8,
	avlab_1s2p = 9,
	avlab_2s1p = 10,
	siig_1s1p_10x = 11,
	siig_2s1p_10x = 12,
	siig_2p1s_20x = 13,
	siig_1s1p_20x = 14,
	siig_2s1p_20x = 15,
	timedia_4078a = 16,
	timedia_4079h = 17,
	timedia_4085h = 18,
	timedia_4088a = 19,
	timedia_4089a = 20,
	timedia_4095a = 21,
	timedia_4096a = 22,
	timedia_4078u = 23,
	timedia_4079a = 24,
	timedia_4085u = 25,
	timedia_4079r = 26,
	timedia_4079s = 27,
	timedia_4079d = 28,
	timedia_4079e = 29,
	timedia_4079f = 30,
	timedia_9079a = 31,
	timedia_9079b = 32,
	timedia_9079c = 33,
	wch_ch353_1s1p = 34,
	wch_ch353_2s1p = 35,
	wch_ch382_0s1p = 36,
	wch_ch382_2s1p = 37,
	brainboxes_5s1p = 38,
	sunix_4008a = 39,
	sunix_5069a = 40,
	sunix_5079a = 41,
	sunix_5099a = 42,
	brainboxes_uc257 = 43,
	brainboxes_is300 = 44,
	brainboxes_uc414 = 45,
	brainboxes_px263 = 46,
};

enum parport_pc_pci_cards___2 {
	siig_1p_10x = 3,
	siig_2p_10x = 4,
	siig_1p_20x = 5,
	siig_2p_20x = 6,
	lava_parallel = 7,
	lava_parallel_dual_a = 8,
	lava_parallel_dual_b = 9,
	boca_ioppar = 10,
	plx_9050 = 11,
	timedia_4006a = 12,
	timedia_4014 = 13,
	timedia_4008a = 14,
	timedia_4018 = 15,
	timedia_9018a = 16,
	syba_2p_epp = 17,
	syba_1p_ecp = 18,
	titan_010l = 19,
	avlab_1p = 20,
	avlab_2p = 21,
	oxsemi_952 = 22,
	oxsemi_954 = 23,
	oxsemi_840 = 24,
	oxsemi_pcie_pport = 25,
	aks_0100 = 26,
	mobility_pp = 27,
	netmos_9900___2 = 28,
	netmos_9705 = 29,
	netmos_9715 = 30,
	netmos_9755 = 31,
	netmos_9805 = 32,
	netmos_9815 = 33,
	netmos_9901 = 34,
	netmos_9865 = 35,
	asix_ax99100 = 36,
	quatech_sppxp100 = 37,
	wch_ch382l = 38,
	brainboxes_uc146 = 39,
	brainboxes_px203 = 40,
};

enum parport_pc_sio_types {
	sio_via_686a = 0,
	sio_via_8231 = 1,
	sio_ite_8872 = 2,
	last_sio = 3,
};

enum partition_cmd {
	partcmd_enable = 0,
	partcmd_enablei = 1,
	partcmd_disable = 2,
	partcmd_update = 3,
	partcmd_invalidate = 4,
};

enum passtype {
	PASS_SCAN = 0,
	PASS_REVOKE = 1,
	PASS_REPLAY = 2,
};

enum path_flags {
	PATH_IS_DIR = 1,
	PATH_CONNECT_PATH = 4,
	PATH_CHROOT_REL = 8,
	PATH_CHROOT_NSCONNECT = 16,
	PATH_DELEGATE_DELETED = 65536,
	PATH_MEDIATE_DELETED = 131072,
};

enum pce_status {
	PCE_STATUS_NONE = 0,
	PCE_STATUS_ACQUIRED = 1,
	PCE_STATUS_PREPARED = 2,
	PCE_STATUS_ENABLED = 3,
	PCE_STATUS_ERROR = 4,
};

enum pci_bar_type {
	pci_bar_unknown = 0,
	pci_bar_io = 1,
	pci_bar_mem32 = 2,
	pci_bar_mem64 = 3,
};

enum pci_board_num_t {
	pbn_default = 0,
	pbn_b0_1_115200 = 1,
	pbn_b0_2_115200 = 2,
	pbn_b0_4_115200 = 3,
	pbn_b0_5_115200 = 4,
	pbn_b0_8_115200 = 5,
	pbn_b0_1_921600 = 6,
	pbn_b0_2_921600 = 7,
	pbn_b0_4_921600 = 8,
	pbn_b0_2_1130000 = 9,
	pbn_b0_4_1152000 = 10,
	pbn_b0_4_1250000 = 11,
	pbn_b0_2_1843200 = 12,
	pbn_b0_4_1843200 = 13,
	pbn_b0_1_15625000 = 14,
	pbn_b0_bt_1_115200 = 15,
	pbn_b0_bt_2_115200 = 16,
	pbn_b0_bt_4_115200 = 17,
	pbn_b0_bt_8_115200 = 18,
	pbn_b0_bt_1_460800 = 19,
	pbn_b0_bt_2_460800 = 20,
	pbn_b0_bt_4_460800 = 21,
	pbn_b0_bt_1_921600 = 22,
	pbn_b0_bt_2_921600 = 23,
	pbn_b0_bt_4_921600 = 24,
	pbn_b0_bt_8_921600 = 25,
	pbn_b1_1_115200 = 26,
	pbn_b1_2_115200 = 27,
	pbn_b1_4_115200 = 28,
	pbn_b1_8_115200 = 29,
	pbn_b1_16_115200 = 30,
	pbn_b1_1_921600 = 31,
	pbn_b1_2_921600 = 32,
	pbn_b1_4_921600 = 33,
	pbn_b1_8_921600 = 34,
	pbn_b1_2_1250000 = 35,
	pbn_b1_bt_1_115200 = 36,
	pbn_b1_bt_2_115200 = 37,
	pbn_b1_bt_4_115200 = 38,
	pbn_b1_bt_2_921600 = 39,
	pbn_b1_1_1382400 = 40,
	pbn_b1_2_1382400 = 41,
	pbn_b1_4_1382400 = 42,
	pbn_b1_8_1382400 = 43,
	pbn_b2_1_115200 = 44,
	pbn_b2_2_115200 = 45,
	pbn_b2_4_115200 = 46,
	pbn_b2_8_115200 = 47,
	pbn_b2_1_460800 = 48,
	pbn_b2_4_460800 = 49,
	pbn_b2_8_460800 = 50,
	pbn_b2_16_460800 = 51,
	pbn_b2_1_921600 = 52,
	pbn_b2_4_921600 = 53,
	pbn_b2_8_921600 = 54,
	pbn_b2_8_1152000 = 55,
	pbn_b2_bt_1_115200 = 56,
	pbn_b2_bt_2_115200 = 57,
	pbn_b2_bt_4_115200 = 58,
	pbn_b2_bt_2_921600 = 59,
	pbn_b2_bt_4_921600 = 60,
	pbn_b3_2_115200 = 61,
	pbn_b3_4_115200 = 62,
	pbn_b3_8_115200 = 63,
	pbn_b4_bt_2_921600 = 64,
	pbn_b4_bt_4_921600 = 65,
	pbn_b4_bt_8_921600 = 66,
	pbn_panacom = 67,
	pbn_panacom2 = 68,
	pbn_panacom4 = 69,
	pbn_plx_romulus = 70,
	pbn_oxsemi = 71,
	pbn_oxsemi_1_15625000 = 72,
	pbn_oxsemi_2_15625000 = 73,
	pbn_oxsemi_4_15625000 = 74,
	pbn_oxsemi_8_15625000 = 75,
	pbn_intel_i960 = 76,
	pbn_sgi_ioc3 = 77,
	pbn_computone_4 = 78,
	pbn_computone_6 = 79,
	pbn_computone_8 = 80,
	pbn_sbsxrsio = 81,
	pbn_pasemi_1682M = 82,
	pbn_ni8430_2 = 83,
	pbn_ni8430_4 = 84,
	pbn_ni8430_8 = 85,
	pbn_ni8430_16 = 86,
	pbn_ADDIDATA_PCIe_1_3906250 = 87,
	pbn_ADDIDATA_PCIe_2_3906250 = 88,
	pbn_ADDIDATA_PCIe_4_3906250 = 89,
	pbn_ADDIDATA_PCIe_8_3906250 = 90,
	pbn_ce4100_1_115200 = 91,
	pbn_omegapci = 92,
	pbn_NETMOS9900_2s_115200 = 93,
	pbn_brcm_trumanage = 94,
	pbn_fintek_4 = 95,
	pbn_fintek_8 = 96,
	pbn_fintek_12 = 97,
	pbn_fintek_F81504A = 98,
	pbn_fintek_F81508A = 99,
	pbn_fintek_F81512A = 100,
	pbn_wch382_2 = 101,
	pbn_wch384_4 = 102,
	pbn_wch384_8 = 103,
	pbn_sunix_pci_1s = 104,
	pbn_sunix_pci_2s = 105,
	pbn_sunix_pci_4s = 106,
	pbn_sunix_pci_8s = 107,
	pbn_sunix_pci_16s = 108,
	pbn_titan_1_4000000 = 109,
	pbn_titan_2_4000000 = 110,
	pbn_titan_4_4000000 = 111,
	pbn_titan_8_4000000 = 112,
	pbn_moxa_2 = 113,
	pbn_moxa_4 = 114,
	pbn_moxa_8 = 115,
};

enum pci_bus_flags {
	PCI_BUS_FLAGS_NO_MSI = 1,
	PCI_BUS_FLAGS_NO_MMRBC = 2,
	PCI_BUS_FLAGS_NO_AERSID = 4,
	PCI_BUS_FLAGS_NO_EXTCFG = 8,
};

enum pci_bus_speed {
	PCI_SPEED_33MHz = 0,
	PCI_SPEED_66MHz = 1,
	PCI_SPEED_66MHz_PCIX = 2,
	PCI_SPEED_100MHz_PCIX = 3,
	PCI_SPEED_133MHz_PCIX = 4,
	PCI_SPEED_66MHz_PCIX_ECC = 5,
	PCI_SPEED_100MHz_PCIX_ECC = 6,
	PCI_SPEED_133MHz_PCIX_ECC = 7,
	PCI_SPEED_66MHz_PCIX_266 = 9,
	PCI_SPEED_100MHz_PCIX_266 = 10,
	PCI_SPEED_133MHz_PCIX_266 = 11,
	AGP_UNKNOWN = 12,
	AGP_1X = 13,
	AGP_2X = 14,
	AGP_4X = 15,
	AGP_8X = 16,
	PCI_SPEED_66MHz_PCIX_533 = 17,
	PCI_SPEED_100MHz_PCIX_533 = 18,
	PCI_SPEED_133MHz_PCIX_533 = 19,
	PCIE_SPEED_2_5GT = 20,
	PCIE_SPEED_5_0GT = 21,
	PCIE_SPEED_8_0GT = 22,
	PCIE_SPEED_16_0GT = 23,
	PCIE_SPEED_32_0GT = 24,
	PCIE_SPEED_64_0GT = 25,
	PCI_SPEED_UNKNOWN = 255,
};

enum pci_cfg_register_bits {
	PCTL_PWR_OFF = 251658240,
	PCTL_COM_ON = 15728640,
	PCTL_LINK_RST = 983040,
	PCTL_LINK_OFFS = 16,
	PCTL_PHY_DSBL = 61440,
	PCTL_PHY_DSBL_OFFS = 12,
	PRD_REQ_SIZE = 16384,
	PRD_REQ_MASK = 28672,
	PLS_NEG_LINK_WD = 1008,
	PLS_NEG_LINK_WD_OFFS = 4,
	PLS_LINK_SPD = 15,
	PLS_LINK_SPD_OFFS = 0,
};

enum pci_cfg_registers {
	PCR_PHY_CTL = 64,
	PCR_PHY_CTL2 = 144,
	PCR_DEV_CTRL = 232,
	PCR_LINK_STAT = 242,
};

enum pci_cfg_registers___2 {
	PCR_PHY_CTL___2 = 64,
	PCR_PHY_CTL2___2 = 144,
	PCR_DEV_CTRL___2 = 120,
	PCR_LINK_STAT___2 = 130,
};

enum pci_dev_flags {
	PCI_DEV_FLAGS_MSI_INTX_DISABLE_BUG = 1,
	PCI_DEV_FLAGS_NO_D3 = 2,
	PCI_DEV_FLAGS_ASSIGNED = 4,
	PCI_DEV_FLAGS_ACS_ENABLED_QUIRK = 8,
	PCI_DEV_FLAG_PCIE_BRIDGE_ALIAS = 32,
	PCI_DEV_FLAGS_NO_BUS_RESET = 64,
	PCI_DEV_FLAGS_NO_PM_RESET = 128,
	PCI_DEV_FLAGS_VPD_REF_F0 = 256,
	PCI_DEV_FLAGS_BRIDGE_XLATE_ROOT = 512,
	PCI_DEV_FLAGS_NO_FLR_RESET = 1024,
	PCI_DEV_FLAGS_NO_RELAXED_ORDERING = 2048,
	PCI_DEV_FLAGS_HAS_MSI_MASKING = 4096,
};

enum pci_ers_result {
	PCI_ERS_RESULT_NONE = 1,
	PCI_ERS_RESULT_CAN_RECOVER = 2,
	PCI_ERS_RESULT_NEED_RESET = 3,
	PCI_ERS_RESULT_DISCONNECT = 4,
	PCI_ERS_RESULT_RECOVERED = 5,
	PCI_ERS_RESULT_NO_AER_DRIVER = 6,
};

enum pci_fixup_pass {
	pci_fixup_early = 0,
	pci_fixup_header = 1,
	pci_fixup_final = 2,
	pci_fixup_enable = 3,
	pci_fixup_resume = 4,
	pci_fixup_suspend = 5,
	pci_fixup_resume_early = 6,
	pci_fixup_suspend_late = 7,
};

enum pci_interrupt_cause {
	MVS_IRQ_COM_IN_I2O_IOP0 = 1,
	MVS_IRQ_COM_IN_I2O_IOP1 = 2,
	MVS_IRQ_COM_IN_I2O_IOP2 = 4,
	MVS_IRQ_COM_IN_I2O_IOP3 = 8,
	MVS_IRQ_COM_OUT_I2O_HOS0 = 16,
	MVS_IRQ_COM_OUT_I2O_HOS1 = 32,
	MVS_IRQ_COM_OUT_I2O_HOS2 = 64,
	MVS_IRQ_COM_OUT_I2O_HOS3 = 128,
	MVS_IRQ_PCIF_TO_CPU_DRBL0 = 256,
	MVS_IRQ_PCIF_TO_CPU_DRBL1 = 512,
	MVS_IRQ_PCIF_TO_CPU_DRBL2 = 1024,
	MVS_IRQ_PCIF_TO_CPU_DRBL3 = 2048,
	MVS_IRQ_PCIF_DRBL0 = 4096,
	MVS_IRQ_PCIF_DRBL1 = 8192,
	MVS_IRQ_PCIF_DRBL2 = 16384,
	MVS_IRQ_PCIF_DRBL3 = 32768,
	MVS_IRQ_XOR_A = 65536,
	MVS_IRQ_XOR_B = 131072,
	MVS_IRQ_SAS_A = 262144,
	MVS_IRQ_SAS_B = 524288,
	MVS_IRQ_CPU_CNTRL = 1048576,
	MVS_IRQ_GPIO = 2097152,
	MVS_IRQ_UART = 4194304,
	MVS_IRQ_SPI = 8388608,
	MVS_IRQ_I2C = 16777216,
	MVS_IRQ_SGPIO = 33554432,
	MVS_IRQ_COM_ERR = 536870912,
	MVS_IRQ_I2O_ERR = 1073741824,
	MVS_IRQ_PCIE_ERR = -2147483648,
};

enum pci_mmap_api {
	PCI_MMAP_SYSFS = 0,
	PCI_MMAP_PROCFS = 1,
};

enum pci_mmap_state {
	pci_mmap_io = 0,
	pci_mmap_mem = 1,
};

enum pci_p2pdma_map_type {
	PCI_P2PDMA_MAP_UNKNOWN = 0,
	PCI_P2PDMA_MAP_NOT_SUPPORTED = 1,
	PCI_P2PDMA_MAP_BUS_ADDR = 2,
	PCI_P2PDMA_MAP_THRU_HOST_BRIDGE = 3,
};

enum pcie_bus_config_types {
	PCIE_BUS_TUNE_OFF = 0,
	PCIE_BUS_DEFAULT = 1,
	PCIE_BUS_SAFE = 2,
	PCIE_BUS_PERFORMANCE = 3,
	PCIE_BUS_PEER2PEER = 4,
};

enum pcie_link_width {
	PCIE_LNK_WIDTH_RESRV = 0,
	PCIE_LNK_X1 = 1,
	PCIE_LNK_X2 = 2,
	PCIE_LNK_X4 = 4,
	PCIE_LNK_X8 = 8,
	PCIE_LNK_X12 = 12,
	PCIE_LNK_X16 = 16,
	PCIE_LNK_X32 = 32,
	PCIE_LNK_WIDTH_UNKNOWN = 255,
};

enum pcie_reset_state {
	pcie_deassert_reset = 1,
	pcie_warm_reset = 2,
	pcie_hot_reset = 3,
};

enum pcim_addr_devres_type {
	PCIM_ADDR_DEVRES_TYPE_INVALID = 0,
	PCIM_ADDR_DEVRES_TYPE_REGION = 1,
	PCIM_ADDR_DEVRES_TYPE_REGION_MAPPING = 2,
	PCIM_ADDR_DEVRES_TYPE_MAPPING = 3,
};

enum pcpu_fc {
	PCPU_FC_AUTO = 0,
	PCPU_FC_EMBED = 1,
	PCPU_FC_PAGE = 2,
	PCPU_FC_NR = 3,
};

enum pedit_cmd {
	TCA_PEDIT_KEY_EX_CMD_SET = 0,
	TCA_PEDIT_KEY_EX_CMD_ADD = 1,
	__PEDIT_CMD_MAX = 2,
};

enum pedit_header_type {
	TCA_PEDIT_KEY_EX_HDR_TYPE_NETWORK = 0,
	TCA_PEDIT_KEY_EX_HDR_TYPE_ETH = 1,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP4 = 2,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP6 = 3,
	TCA_PEDIT_KEY_EX_HDR_TYPE_TCP = 4,
	TCA_PEDIT_KEY_EX_HDR_TYPE_UDP = 5,
	__PEDIT_HDR_TYPE_MAX = 6,
};

enum perf_addr_filter_action_t {
	PERF_ADDR_FILTER_ACTION_STOP = 0,
	PERF_ADDR_FILTER_ACTION_START = 1,
	PERF_ADDR_FILTER_ACTION_FILTER = 2,
};

enum perf_bpf_event_type {
	PERF_BPF_EVENT_UNKNOWN = 0,
	PERF_BPF_EVENT_PROG_LOAD = 1,
	PERF_BPF_EVENT_PROG_UNLOAD = 2,
	PERF_BPF_EVENT_MAX = 3,
};

enum perf_branch_sample_type {
	PERF_SAMPLE_BRANCH_USER = 1,
	PERF_SAMPLE_BRANCH_KERNEL = 2,
	PERF_SAMPLE_BRANCH_HV = 4,
	PERF_SAMPLE_BRANCH_ANY = 8,
	PERF_SAMPLE_BRANCH_ANY_CALL = 16,
	PERF_SAMPLE_BRANCH_ANY_RETURN = 32,
	PERF_SAMPLE_BRANCH_IND_CALL = 64,
	PERF_SAMPLE_BRANCH_ABORT_TX = 128,
	PERF_SAMPLE_BRANCH_IN_TX = 256,
	PERF_SAMPLE_BRANCH_NO_TX = 512,
	PERF_SAMPLE_BRANCH_COND = 1024,
	PERF_SAMPLE_BRANCH_CALL_STACK = 2048,
	PERF_SAMPLE_BRANCH_IND_JUMP = 4096,
	PERF_SAMPLE_BRANCH_CALL = 8192,
	PERF_SAMPLE_BRANCH_NO_FLAGS = 16384,
	PERF_SAMPLE_BRANCH_NO_CYCLES = 32768,
	PERF_SAMPLE_BRANCH_TYPE_SAVE = 65536,
	PERF_SAMPLE_BRANCH_HW_INDEX = 131072,
	PERF_SAMPLE_BRANCH_PRIV_SAVE = 262144,
	PERF_SAMPLE_BRANCH_COUNTERS = 524288,
	PERF_SAMPLE_BRANCH_MAX = 1048576,
};

enum perf_branch_sample_type_shift {
	PERF_SAMPLE_BRANCH_USER_SHIFT = 0,
	PERF_SAMPLE_BRANCH_KERNEL_SHIFT = 1,
	PERF_SAMPLE_BRANCH_HV_SHIFT = 2,
	PERF_SAMPLE_BRANCH_ANY_SHIFT = 3,
	PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT = 4,
	PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT = 5,
	PERF_SAMPLE_BRANCH_IND_CALL_SHIFT = 6,
	PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT = 7,
	PERF_SAMPLE_BRANCH_IN_TX_SHIFT = 8,
	PERF_SAMPLE_BRANCH_NO_TX_SHIFT = 9,
	PERF_SAMPLE_BRANCH_COND_SHIFT = 10,
	PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT = 11,
	PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT = 12,
	PERF_SAMPLE_BRANCH_CALL_SHIFT = 13,
	PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT = 14,
	PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT = 15,
	PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT = 16,
	PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT = 17,
	PERF_SAMPLE_BRANCH_PRIV_SAVE_SHIFT = 18,
	PERF_SAMPLE_BRANCH_COUNTERS_SHIFT = 19,
	PERF_SAMPLE_BRANCH_MAX_SHIFT = 20,
};

enum perf_callchain_context {
	PERF_CONTEXT_HV = 18446744073709551584ULL,
	PERF_CONTEXT_KERNEL = 18446744073709551488ULL,
	PERF_CONTEXT_USER = 18446744073709551104ULL,
	PERF_CONTEXT_GUEST = 18446744073709549568ULL,
	PERF_CONTEXT_GUEST_KERNEL = 18446744073709549440ULL,
	PERF_CONTEXT_GUEST_USER = 18446744073709549056ULL,
	PERF_CONTEXT_MAX = 18446744073709547521ULL,
};

enum perf_event_ioc_flags {
	PERF_IOC_FLAG_GROUP = 1,
};

enum perf_event_loongarch_regs {
	PERF_REG_LOONGARCH_PC = 0,
	PERF_REG_LOONGARCH_R1 = 1,
	PERF_REG_LOONGARCH_R2 = 2,
	PERF_REG_LOONGARCH_R3 = 3,
	PERF_REG_LOONGARCH_R4 = 4,
	PERF_REG_LOONGARCH_R5 = 5,
	PERF_REG_LOONGARCH_R6 = 6,
	PERF_REG_LOONGARCH_R7 = 7,
	PERF_REG_LOONGARCH_R8 = 8,
	PERF_REG_LOONGARCH_R9 = 9,
	PERF_REG_LOONGARCH_R10 = 10,
	PERF_REG_LOONGARCH_R11 = 11,
	PERF_REG_LOONGARCH_R12 = 12,
	PERF_REG_LOONGARCH_R13 = 13,
	PERF_REG_LOONGARCH_R14 = 14,
	PERF_REG_LOONGARCH_R15 = 15,
	PERF_REG_LOONGARCH_R16 = 16,
	PERF_REG_LOONGARCH_R17 = 17,
	PERF_REG_LOONGARCH_R18 = 18,
	PERF_REG_LOONGARCH_R19 = 19,
	PERF_REG_LOONGARCH_R20 = 20,
	PERF_REG_LOONGARCH_R21 = 21,
	PERF_REG_LOONGARCH_R22 = 22,
	PERF_REG_LOONGARCH_R23 = 23,
	PERF_REG_LOONGARCH_R24 = 24,
	PERF_REG_LOONGARCH_R25 = 25,
	PERF_REG_LOONGARCH_R26 = 26,
	PERF_REG_LOONGARCH_R27 = 27,
	PERF_REG_LOONGARCH_R28 = 28,
	PERF_REG_LOONGARCH_R29 = 29,
	PERF_REG_LOONGARCH_R30 = 30,
	PERF_REG_LOONGARCH_R31 = 31,
	PERF_REG_LOONGARCH_MAX = 32,
};

enum perf_event_read_format {
	PERF_FORMAT_TOTAL_TIME_ENABLED = 1,
	PERF_FORMAT_TOTAL_TIME_RUNNING = 2,
	PERF_FORMAT_ID = 4,
	PERF_FORMAT_GROUP = 8,
	PERF_FORMAT_LOST = 16,
	PERF_FORMAT_MAX = 32,
};

enum perf_event_sample_format {
	PERF_SAMPLE_IP = 1,
	PERF_SAMPLE_TID = 2,
	PERF_SAMPLE_TIME = 4,
	PERF_SAMPLE_ADDR = 8,
	PERF_SAMPLE_READ = 16,
	PERF_SAMPLE_CALLCHAIN = 32,
	PERF_SAMPLE_ID = 64,
	PERF_SAMPLE_CPU = 128,
	PERF_SAMPLE_PERIOD = 256,
	PERF_SAMPLE_STREAM_ID = 512,
	PERF_SAMPLE_RAW = 1024,
	PERF_SAMPLE_BRANCH_STACK = 2048,
	PERF_SAMPLE_REGS_USER = 4096,
	PERF_SAMPLE_STACK_USER = 8192,
	PERF_SAMPLE_WEIGHT = 16384,
	PERF_SAMPLE_DATA_SRC = 32768,
	PERF_SAMPLE_IDENTIFIER = 65536,
	PERF_SAMPLE_TRANSACTION = 131072,
	PERF_SAMPLE_REGS_INTR = 262144,
	PERF_SAMPLE_PHYS_ADDR = 524288,
	PERF_SAMPLE_AUX = 1048576,
	PERF_SAMPLE_CGROUP = 2097152,
	PERF_SAMPLE_DATA_PAGE_SIZE = 4194304,
	PERF_SAMPLE_CODE_PAGE_SIZE = 8388608,
	PERF_SAMPLE_WEIGHT_STRUCT = 16777216,
	PERF_SAMPLE_MAX = 33554432,
};

enum perf_event_state {
	PERF_EVENT_STATE_DEAD = -4,
	PERF_EVENT_STATE_EXIT = -3,
	PERF_EVENT_STATE_ERROR = -2,
	PERF_EVENT_STATE_OFF = -1,
	PERF_EVENT_STATE_INACTIVE = 0,
	PERF_EVENT_STATE_ACTIVE = 1,
};

enum perf_event_task_context {
	perf_invalid_context = -1,
	perf_hw_context = 0,
	perf_sw_context = 1,
	perf_nr_task_contexts = 2,
};

enum perf_event_type {
	PERF_RECORD_MMAP = 1,
	PERF_RECORD_LOST = 2,
	PERF_RECORD_COMM = 3,
	PERF_RECORD_EXIT = 4,
	PERF_RECORD_THROTTLE = 5,
	PERF_RECORD_UNTHROTTLE = 6,
	PERF_RECORD_FORK = 7,
	PERF_RECORD_READ = 8,
	PERF_RECORD_SAMPLE = 9,
	PERF_RECORD_MMAP2 = 10,
	PERF_RECORD_AUX = 11,
	PERF_RECORD_ITRACE_START = 12,
	PERF_RECORD_LOST_SAMPLES = 13,
	PERF_RECORD_SWITCH = 14,
	PERF_RECORD_SWITCH_CPU_WIDE = 15,
	PERF_RECORD_NAMESPACES = 16,
	PERF_RECORD_KSYMBOL = 17,
	PERF_RECORD_BPF_EVENT = 18,
	PERF_RECORD_CGROUP = 19,
	PERF_RECORD_TEXT_POKE = 20,
	PERF_RECORD_AUX_OUTPUT_HW_ID = 21,
	PERF_RECORD_MAX = 22,
};

enum perf_hw_cache_id {
	PERF_COUNT_HW_CACHE_L1D = 0,
	PERF_COUNT_HW_CACHE_L1I = 1,
	PERF_COUNT_HW_CACHE_LL = 2,
	PERF_COUNT_HW_CACHE_DTLB = 3,
	PERF_COUNT_HW_CACHE_ITLB = 4,
	PERF_COUNT_HW_CACHE_BPU = 5,
	PERF_COUNT_HW_CACHE_NODE = 6,
	PERF_COUNT_HW_CACHE_MAX = 7,
};

enum perf_hw_cache_op_id {
	PERF_COUNT_HW_CACHE_OP_READ = 0,
	PERF_COUNT_HW_CACHE_OP_WRITE = 1,
	PERF_COUNT_HW_CACHE_OP_PREFETCH = 2,
	PERF_COUNT_HW_CACHE_OP_MAX = 3,
};

enum perf_hw_cache_op_result_id {
	PERF_COUNT_HW_CACHE_RESULT_ACCESS = 0,
	PERF_COUNT_HW_CACHE_RESULT_MISS = 1,
	PERF_COUNT_HW_CACHE_RESULT_MAX = 2,
};

enum perf_hw_id {
	PERF_COUNT_HW_CPU_CYCLES = 0,
	PERF_COUNT_HW_INSTRUCTIONS = 1,
	PERF_COUNT_HW_CACHE_REFERENCES = 2,
	PERF_COUNT_HW_CACHE_MISSES = 3,
	PERF_COUNT_HW_BRANCH_INSTRUCTIONS = 4,
	PERF_COUNT_HW_BRANCH_MISSES = 5,
	PERF_COUNT_HW_BUS_CYCLES = 6,
	PERF_COUNT_HW_STALLED_CYCLES_FRONTEND = 7,
	PERF_COUNT_HW_STALLED_CYCLES_BACKEND = 8,
	PERF_COUNT_HW_REF_CPU_CYCLES = 9,
	PERF_COUNT_HW_MAX = 10,
};

enum perf_pmu_scope {
	PERF_PMU_SCOPE_NONE = 0,
	PERF_PMU_SCOPE_CORE = 1,
	PERF_PMU_SCOPE_DIE = 2,
	PERF_PMU_SCOPE_CLUSTER = 3,
	PERF_PMU_SCOPE_PKG = 4,
	PERF_PMU_SCOPE_SYS_WIDE = 5,
	PERF_PMU_MAX_SCOPE = 6,
};

enum perf_probe_config {
	PERF_PROBE_CONFIG_IS_RETPROBE = 1,
	PERF_UPROBE_REF_CTR_OFFSET_BITS = 32,
	PERF_UPROBE_REF_CTR_OFFSET_SHIFT = 32,
};

enum perf_record_ksymbol_type {
	PERF_RECORD_KSYMBOL_TYPE_UNKNOWN = 0,
	PERF_RECORD_KSYMBOL_TYPE_BPF = 1,
	PERF_RECORD_KSYMBOL_TYPE_OOL = 2,
	PERF_RECORD_KSYMBOL_TYPE_MAX = 3,
};

enum perf_sample_regs_abi {
	PERF_SAMPLE_REGS_ABI_NONE = 0,
	PERF_SAMPLE_REGS_ABI_32 = 1,
	PERF_SAMPLE_REGS_ABI_64 = 2,
};

enum perf_sw_ids {
	PERF_COUNT_SW_CPU_CLOCK = 0,
	PERF_COUNT_SW_TASK_CLOCK = 1,
	PERF_COUNT_SW_PAGE_FAULTS = 2,
	PERF_COUNT_SW_CONTEXT_SWITCHES = 3,
	PERF_COUNT_SW_CPU_MIGRATIONS = 4,
	PERF_COUNT_SW_PAGE_FAULTS_MIN = 5,
	PERF_COUNT_SW_PAGE_FAULTS_MAJ = 6,
	PERF_COUNT_SW_ALIGNMENT_FAULTS = 7,
	PERF_COUNT_SW_EMULATION_FAULTS = 8,
	PERF_COUNT_SW_DUMMY = 9,
	PERF_COUNT_SW_BPF_OUTPUT = 10,
	PERF_COUNT_SW_CGROUP_SWITCHES = 11,
	PERF_COUNT_SW_MAX = 12,
};

enum perf_type_id {
	PERF_TYPE_HARDWARE = 0,
	PERF_TYPE_SOFTWARE = 1,
	PERF_TYPE_TRACEPOINT = 2,
	PERF_TYPE_HW_CACHE = 3,
	PERF_TYPE_RAW = 4,
	PERF_TYPE_BREAKPOINT = 5,
	PERF_TYPE_MAX = 6,
};

enum pgdat_flags {
	PGDAT_DIRTY = 0,
	PGDAT_WRITEBACK = 1,
	PGDAT_RECLAIM_LOCKED = 2,
};

enum pgt_entry {
	NORMAL_PMD = 0,
	HPAGE_PMD = 1,
	NORMAL_PUD = 2,
	HPAGE_PUD = 3,
};

enum phy_event {
	PHYE_LOSS_OF_SIGNAL = 0,
	PHYE_OOB_DONE = 1,
	PHYE_OOB_ERROR = 2,
	PHYE_SPINUP_HOLD = 3,
	PHYE_RESUME_TIMEOUT = 4,
	PHYE_SHUTDOWN = 5,
	PHY_NUM_EVENTS = 6,
};

enum phy_func {
	PHY_FUNC_NOP = 0,
	PHY_FUNC_LINK_RESET = 1,
	PHY_FUNC_HARD_RESET = 2,
	PHY_FUNC_DISABLE = 3,
	PHY_FUNC_CLEAR_ERROR_LOG = 5,
	PHY_FUNC_CLEAR_AFFIL = 6,
	PHY_FUNC_TX_SATA_PS_SIGNAL = 7,
	PHY_FUNC_RELEASE_SPINUP_HOLD = 16,
	PHY_FUNC_SET_LINK_RATE = 17,
	PHY_FUNC_GET_EVENTS = 18,
};

enum phy_led_modes {
	PHY_LED_ACTIVE_HIGH = 0,
	PHY_LED_ACTIVE_LOW = 1,
	PHY_LED_INACTIVE_HIGH_IMPEDANCE = 2,
	__PHY_LED_MODES_NUM = 3,
};

enum phy_media {
	PHY_MEDIA_DEFAULT = 0,
	PHY_MEDIA_SR = 1,
	PHY_MEDIA_DAC = 2,
};

enum phy_mode {
	PHY_MODE_INVALID = 0,
	PHY_MODE_USB_HOST = 1,
	PHY_MODE_USB_HOST_LS = 2,
	PHY_MODE_USB_HOST_FS = 3,
	PHY_MODE_USB_HOST_HS = 4,
	PHY_MODE_USB_HOST_SS = 5,
	PHY_MODE_USB_DEVICE = 6,
	PHY_MODE_USB_DEVICE_LS = 7,
	PHY_MODE_USB_DEVICE_FS = 8,
	PHY_MODE_USB_DEVICE_HS = 9,
	PHY_MODE_USB_DEVICE_SS = 10,
	PHY_MODE_USB_OTG = 11,
	PHY_MODE_UFS_HS_A = 12,
	PHY_MODE_UFS_HS_B = 13,
	PHY_MODE_PCIE = 14,
	PHY_MODE_ETHERNET = 15,
	PHY_MODE_MIPI_DPHY = 16,
	PHY_MODE_SATA = 17,
	PHY_MODE_LVDS = 18,
	PHY_MODE_DP = 19,
};

enum phy_state {
	PHY_DOWN = 0,
	PHY_READY = 1,
	PHY_HALTED = 2,
	PHY_ERROR = 3,
	PHY_UP = 4,
	PHY_RUNNING = 5,
	PHY_NOLINK = 6,
	PHY_CABLETEST = 7,
};

enum phy_state_work {
	PHY_STATE_WORK_NONE = 0,
	PHY_STATE_WORK_ANEG = 1,
	PHY_STATE_WORK_SUSPEND = 2,
};

enum phy_tunable_id {
	ETHTOOL_PHY_ID_UNSPEC = 0,
	ETHTOOL_PHY_DOWNSHIFT = 1,
	ETHTOOL_PHY_FAST_LINK_DOWN = 2,
	ETHTOOL_PHY_EDPD = 3,
	__ETHTOOL_PHY_TUNABLE_COUNT = 4,
};

enum phy_upstream {
	PHY_UPSTREAM_MAC = 0,
	PHY_UPSTREAM_PHY = 1,
};

enum phylink_op_type {
	PHYLINK_NETDEV = 0,
	PHYLINK_DEV = 1,
};

enum pid_type {
	PIDTYPE_PID = 0,
	PIDTYPE_TGID = 1,
	PIDTYPE_PGID = 2,
	PIDTYPE_SID = 3,
	PIDTYPE_MAX = 4,
};

enum pidcg_event {
	PIDCG_MAX = 0,
	PIDCG_FORKFAIL = 1,
	NR_PIDCG_EVENTS = 2,
};

enum pin_config_param {
	PIN_CONFIG_BIAS_BUS_HOLD = 0,
	PIN_CONFIG_BIAS_DISABLE = 1,
	PIN_CONFIG_BIAS_HIGH_IMPEDANCE = 2,
	PIN_CONFIG_BIAS_PULL_DOWN = 3,
	PIN_CONFIG_BIAS_PULL_PIN_DEFAULT = 4,
	PIN_CONFIG_BIAS_PULL_UP = 5,
	PIN_CONFIG_DRIVE_OPEN_DRAIN = 6,
	PIN_CONFIG_DRIVE_OPEN_SOURCE = 7,
	PIN_CONFIG_DRIVE_PUSH_PULL = 8,
	PIN_CONFIG_DRIVE_STRENGTH = 9,
	PIN_CONFIG_DRIVE_STRENGTH_UA = 10,
	PIN_CONFIG_INPUT_DEBOUNCE = 11,
	PIN_CONFIG_INPUT_ENABLE = 12,
	PIN_CONFIG_INPUT_SCHMITT = 13,
	PIN_CONFIG_INPUT_SCHMITT_ENABLE = 14,
	PIN_CONFIG_INPUT_SCHMITT_UV = 15,
	PIN_CONFIG_MODE_LOW_POWER = 16,
	PIN_CONFIG_MODE_PWM = 17,
	PIN_CONFIG_OUTPUT = 18,
	PIN_CONFIG_OUTPUT_ENABLE = 19,
	PIN_CONFIG_OUTPUT_IMPEDANCE_OHMS = 20,
	PIN_CONFIG_PERSIST_STATE = 21,
	PIN_CONFIG_POWER_SOURCE = 22,
	PIN_CONFIG_SKEW_DELAY = 23,
	PIN_CONFIG_SLEEP_HARDWARE_STATE = 24,
	PIN_CONFIG_SLEW_RATE = 25,
	PIN_CONFIG_END = 127,
	PIN_CONFIG_MAX = 255,
};

enum pinctrl_map_type {
	PIN_MAP_TYPE_INVALID = 0,
	PIN_MAP_TYPE_DUMMY_STATE = 1,
	PIN_MAP_TYPE_MUX_GROUP = 2,
	PIN_MAP_TYPE_CONFIGS_PIN = 3,
	PIN_MAP_TYPE_CONFIGS_GROUP = 4,
};

enum pkcs7_actions {
	ACT_pkcs7_check_content_type = 0,
	ACT_pkcs7_extract_cert = 1,
	ACT_pkcs7_note_OID = 2,
	ACT_pkcs7_note_certificate_list = 3,
	ACT_pkcs7_note_content = 4,
	ACT_pkcs7_note_data = 5,
	ACT_pkcs7_note_signed_info = 6,
	ACT_pkcs7_note_signeddata_version = 7,
	ACT_pkcs7_note_signerinfo_version = 8,
	ACT_pkcs7_sig_note_authenticated_attr = 9,
	ACT_pkcs7_sig_note_digest_algo = 10,
	ACT_pkcs7_sig_note_issuer = 11,
	ACT_pkcs7_sig_note_pkey_algo = 12,
	ACT_pkcs7_sig_note_serial = 13,
	ACT_pkcs7_sig_note_set_of_authattrs = 14,
	ACT_pkcs7_sig_note_signature = 15,
	ACT_pkcs7_sig_note_skid = 16,
	NR__pkcs7_actions = 17,
};

enum pkt_hash_types {
	PKT_HASH_TYPE_NONE = 0,
	PKT_HASH_TYPE_L2 = 1,
	PKT_HASH_TYPE_L3 = 2,
	PKT_HASH_TYPE_L4 = 3,
};

enum pm_qos_flags_status {
	PM_QOS_FLAGS_UNDEFINED = -1,
	PM_QOS_FLAGS_NONE = 0,
	PM_QOS_FLAGS_SOME = 1,
	PM_QOS_FLAGS_ALL = 2,
};

enum pm_qos_req_action {
	PM_QOS_ADD_REQ = 0,
	PM_QOS_UPDATE_REQ = 1,
	PM_QOS_REMOVE_REQ = 2,
};

enum pm_qos_type {
	PM_QOS_UNITIALIZED = 0,
	PM_QOS_MAX = 1,
	PM_QOS_MIN = 2,
};

enum pnfs_block_extent_state {
	PNFS_BLOCK_READWRITE_DATA = 0,
	PNFS_BLOCK_READ_DATA = 1,
	PNFS_BLOCK_INVALID_DATA = 2,
	PNFS_BLOCK_NONE_DATA = 3,
};

enum pnfs_block_volume_type {
	PNFS_BLOCK_VOLUME_SIMPLE = 0,
	PNFS_BLOCK_VOLUME_SLICE = 1,
	PNFS_BLOCK_VOLUME_CONCAT = 2,
	PNFS_BLOCK_VOLUME_STRIPE = 3,
	PNFS_BLOCK_VOLUME_SCSI = 4,
};

enum pnfs_iomode {
	IOMODE_READ = 1,
	IOMODE_RW = 2,
	IOMODE_ANY = 3,
};

enum pnfs_layout_destroy_mode {
	PNFS_LAYOUT_INVALIDATE = 0,
	PNFS_LAYOUT_BULK_RETURN = 1,
	PNFS_LAYOUT_FILE_BULK_RETURN = 2,
};

enum pnfs_layoutreturn_type {
	RETURN_FILE = 1,
	RETURN_FSID = 2,
	RETURN_ALL = 3,
};

enum pnfs_layouttype {
	LAYOUT_NFSV4_1_FILES = 1,
	LAYOUT_OSD2_OBJECTS = 2,
	LAYOUT_BLOCK_VOLUME = 3,
	LAYOUT_FLEX_FILES = 4,
	LAYOUT_SCSI = 5,
	LAYOUT_TYPE_MAX = 6,
};

enum pnfs_notify_deviceid_type4 {
	NOTIFY_DEVICEID4_CHANGE = 2,
	NOTIFY_DEVICEID4_DELETE = 4,
};

enum pnfs_try_status {
	PNFS_ATTEMPTED = 0,
	PNFS_NOT_ATTEMPTED = 1,
	PNFS_TRY_AGAIN = 2,
};

enum pnfs_update_layout_reason {
	PNFS_UPDATE_LAYOUT_UNKNOWN = 0,
	PNFS_UPDATE_LAYOUT_NO_PNFS = 1,
	PNFS_UPDATE_LAYOUT_RD_ZEROLEN = 2,
	PNFS_UPDATE_LAYOUT_MDSTHRESH = 3,
	PNFS_UPDATE_LAYOUT_NOMEM = 4,
	PNFS_UPDATE_LAYOUT_BULK_RECALL = 5,
	PNFS_UPDATE_LAYOUT_IO_TEST_FAIL = 6,
	PNFS_UPDATE_LAYOUT_FOUND_CACHED = 7,
	PNFS_UPDATE_LAYOUT_RETURN = 8,
	PNFS_UPDATE_LAYOUT_RETRY = 9,
	PNFS_UPDATE_LAYOUT_BLOCKED = 10,
	PNFS_UPDATE_LAYOUT_INVALID_OPEN = 11,
	PNFS_UPDATE_LAYOUT_SEND_LAYOUTGET = 12,
	PNFS_UPDATE_LAYOUT_EXIT = 13,
};

enum poll_time_type {
	PT_TIMEVAL = 0,
	PT_OLD_TIMEVAL = 1,
	PT_TIMESPEC = 2,
	PT_OLD_TIMESPEC = 3,
};

enum pool_workqueue_stats {
	PWQ_STAT_STARTED = 0,
	PWQ_STAT_COMPLETED = 1,
	PWQ_STAT_CPU_TIME = 2,
	PWQ_STAT_CPU_INTENSIVE = 3,
	PWQ_STAT_CM_WAKEUP = 4,
	PWQ_STAT_REPATRIATED = 5,
	PWQ_STAT_MAYDAY = 6,
	PWQ_STAT_RESCUED = 7,
	PWQ_NR_STATS = 8,
};

enum port_event {
	PORTE_BYTES_DMAED = 0,
	PORTE_BROADCAST_RCVD = 1,
	PORTE_LINK_RESET_ERR = 2,
	PORTE_TIMER_EVENT = 3,
	PORTE_HARD_RESET = 4,
	PORT_NUM_EVENTS = 5,
};

enum port_pkey_state {
	IB_PORT_PKEY_NOT_VALID = 0,
	IB_PORT_PKEY_VALID = 1,
	IB_PORT_PKEY_LISTED = 2,
};

enum positive_aop_returns {
	AOP_WRITEPAGE_ACTIVATE = 524288,
	AOP_TRUNCATED_PAGE = 524289,
};

enum posix_timer_state {
	POSIX_TIMER_DISARMED = 0,
	POSIX_TIMER_ARMED = 1,
	POSIX_TIMER_REQUEUE_PENDING = 2,
};

enum power_event {
	pointer_reset = 2147483648,
	global_unicast = 512,
	wake_up_rx_frame = 64,
	magic_frame = 32,
	wake_up_frame_en = 4,
	magic_pkt_en = 2,
	power_down = 1,
};

enum power_supply_charge_behaviour {
	POWER_SUPPLY_CHARGE_BEHAVIOUR_AUTO = 0,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_INHIBIT_CHARGE = 1,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_FORCE_DISCHARGE = 2,
};

enum power_supply_charge_type {
	POWER_SUPPLY_CHARGE_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_CHARGE_TYPE_NONE = 1,
	POWER_SUPPLY_CHARGE_TYPE_TRICKLE = 2,
	POWER_SUPPLY_CHARGE_TYPE_FAST = 3,
	POWER_SUPPLY_CHARGE_TYPE_STANDARD = 4,
	POWER_SUPPLY_CHARGE_TYPE_ADAPTIVE = 5,
	POWER_SUPPLY_CHARGE_TYPE_CUSTOM = 6,
	POWER_SUPPLY_CHARGE_TYPE_LONGLIFE = 7,
	POWER_SUPPLY_CHARGE_TYPE_BYPASS = 8,
};

enum power_supply_notifier_events {
	PSY_EVENT_PROP_CHANGED = 0,
};

enum power_supply_property {
	POWER_SUPPLY_PROP_STATUS = 0,
	POWER_SUPPLY_PROP_CHARGE_TYPE = 1,
	POWER_SUPPLY_PROP_CHARGE_TYPES = 2,
	POWER_SUPPLY_PROP_HEALTH = 3,
	POWER_SUPPLY_PROP_PRESENT = 4,
	POWER_SUPPLY_PROP_ONLINE = 5,
	POWER_SUPPLY_PROP_AUTHENTIC = 6,
	POWER_SUPPLY_PROP_TECHNOLOGY = 7,
	POWER_SUPPLY_PROP_CYCLE_COUNT = 8,
	POWER_SUPPLY_PROP_VOLTAGE_MAX = 9,
	POWER_SUPPLY_PROP_VOLTAGE_MIN = 10,
	POWER_SUPPLY_PROP_VOLTAGE_MAX_DESIGN = 11,
	POWER_SUPPLY_PROP_VOLTAGE_MIN_DESIGN = 12,
	POWER_SUPPLY_PROP_VOLTAGE_NOW = 13,
	POWER_SUPPLY_PROP_VOLTAGE_AVG = 14,
	POWER_SUPPLY_PROP_VOLTAGE_OCV = 15,
	POWER_SUPPLY_PROP_VOLTAGE_BOOT = 16,
	POWER_SUPPLY_PROP_CURRENT_MAX = 17,
	POWER_SUPPLY_PROP_CURRENT_NOW = 18,
	POWER_SUPPLY_PROP_CURRENT_AVG = 19,
	POWER_SUPPLY_PROP_CURRENT_BOOT = 20,
	POWER_SUPPLY_PROP_POWER_NOW = 21,
	POWER_SUPPLY_PROP_POWER_AVG = 22,
	POWER_SUPPLY_PROP_CHARGE_FULL_DESIGN = 23,
	POWER_SUPPLY_PROP_CHARGE_EMPTY_DESIGN = 24,
	POWER_SUPPLY_PROP_CHARGE_FULL = 25,
	POWER_SUPPLY_PROP_CHARGE_EMPTY = 26,
	POWER_SUPPLY_PROP_CHARGE_NOW = 27,
	POWER_SUPPLY_PROP_CHARGE_AVG = 28,
	POWER_SUPPLY_PROP_CHARGE_COUNTER = 29,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT = 30,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT_MAX = 31,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE = 32,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE_MAX = 33,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT = 34,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT_MAX = 35,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_START_THRESHOLD = 36,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_END_THRESHOLD = 37,
	POWER_SUPPLY_PROP_CHARGE_BEHAVIOUR = 38,
	POWER_SUPPLY_PROP_INPUT_CURRENT_LIMIT = 39,
	POWER_SUPPLY_PROP_INPUT_VOLTAGE_LIMIT = 40,
	POWER_SUPPLY_PROP_INPUT_POWER_LIMIT = 41,
	POWER_SUPPLY_PROP_ENERGY_FULL_DESIGN = 42,
	POWER_SUPPLY_PROP_ENERGY_EMPTY_DESIGN = 43,
	POWER_SUPPLY_PROP_ENERGY_FULL = 44,
	POWER_SUPPLY_PROP_ENERGY_EMPTY = 45,
	POWER_SUPPLY_PROP_ENERGY_NOW = 46,
	POWER_SUPPLY_PROP_ENERGY_AVG = 47,
	POWER_SUPPLY_PROP_CAPACITY = 48,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MIN = 49,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MAX = 50,
	POWER_SUPPLY_PROP_CAPACITY_ERROR_MARGIN = 51,
	POWER_SUPPLY_PROP_CAPACITY_LEVEL = 52,
	POWER_SUPPLY_PROP_TEMP = 53,
	POWER_SUPPLY_PROP_TEMP_MAX = 54,
	POWER_SUPPLY_PROP_TEMP_MIN = 55,
	POWER_SUPPLY_PROP_TEMP_ALERT_MIN = 56,
	POWER_SUPPLY_PROP_TEMP_ALERT_MAX = 57,
	POWER_SUPPLY_PROP_TEMP_AMBIENT = 58,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MIN = 59,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MAX = 60,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_NOW = 61,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_AVG = 62,
	POWER_SUPPLY_PROP_TIME_TO_FULL_NOW = 63,
	POWER_SUPPLY_PROP_TIME_TO_FULL_AVG = 64,
	POWER_SUPPLY_PROP_TYPE = 65,
	POWER_SUPPLY_PROP_USB_TYPE = 66,
	POWER_SUPPLY_PROP_SCOPE = 67,
	POWER_SUPPLY_PROP_PRECHARGE_CURRENT = 68,
	POWER_SUPPLY_PROP_CHARGE_TERM_CURRENT = 69,
	POWER_SUPPLY_PROP_CALIBRATE = 70,
	POWER_SUPPLY_PROP_MANUFACTURE_YEAR = 71,
	POWER_SUPPLY_PROP_MANUFACTURE_MONTH = 72,
	POWER_SUPPLY_PROP_MANUFACTURE_DAY = 73,
	POWER_SUPPLY_PROP_MODEL_NAME = 74,
	POWER_SUPPLY_PROP_MANUFACTURER = 75,
	POWER_SUPPLY_PROP_SERIAL_NUMBER = 76,
};

enum power_supply_type {
	POWER_SUPPLY_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_TYPE_BATTERY = 1,
	POWER_SUPPLY_TYPE_UPS = 2,
	POWER_SUPPLY_TYPE_MAINS = 3,
	POWER_SUPPLY_TYPE_USB = 4,
	POWER_SUPPLY_TYPE_USB_DCP = 5,
	POWER_SUPPLY_TYPE_USB_CDP = 6,
	POWER_SUPPLY_TYPE_USB_ACA = 7,
	POWER_SUPPLY_TYPE_USB_TYPE_C = 8,
	POWER_SUPPLY_TYPE_USB_PD = 9,
	POWER_SUPPLY_TYPE_USB_PD_DRP = 10,
	POWER_SUPPLY_TYPE_APPLE_BRICK_ID = 11,
	POWER_SUPPLY_TYPE_WIRELESS = 12,
};

enum power_supply_usb_type {
	POWER_SUPPLY_USB_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_USB_TYPE_SDP = 1,
	POWER_SUPPLY_USB_TYPE_DCP = 2,
	POWER_SUPPLY_USB_TYPE_CDP = 3,
	POWER_SUPPLY_USB_TYPE_ACA = 4,
	POWER_SUPPLY_USB_TYPE_C = 5,
	POWER_SUPPLY_USB_TYPE_PD = 6,
	POWER_SUPPLY_USB_TYPE_PD_DRP = 7,
	POWER_SUPPLY_USB_TYPE_PD_PPS = 8,
	POWER_SUPPLY_USB_TYPE_APPLE_BRICK_ID = 9,
};

enum pr_status {
	PR_STS_SUCCESS = 0,
	PR_STS_IOERR = 2,
	PR_STS_RESERVATION_CONFLICT = 24,
	PR_STS_RETRY_PATH_FAILURE = 917504,
	PR_STS_PATH_FAST_FAILED = 983040,
	PR_STS_PATH_FAILED = 65536,
};

enum pr_type {
	PR_WRITE_EXCLUSIVE = 1,
	PR_EXCLUSIVE_ACCESS = 2,
	PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

enum prep_dispatch {
	PREP_DISPATCH_OK = 0,
	PREP_DISPATCH_NO_TAG = 1,
	PREP_DISPATCH_NO_BUDGET = 2,
};

enum print_line_t {
	TRACE_TYPE_PARTIAL_LINE = 0,
	TRACE_TYPE_HANDLED = 1,
	TRACE_TYPE_UNHANDLED = 2,
	TRACE_TYPE_NO_CONSUME = 3,
};

enum printk_info_flags {
	LOG_FORCE_CON = 1,
	LOG_NEWLINE = 2,
	LOG_CONT = 8,
};

enum prio_policy {
	POLICY_NO_CHANGE = 0,
	POLICY_PROMOTE_TO_RT = 1,
	POLICY_RESTRICT_TO_BE = 2,
	POLICY_ALL_TO_IDLE = 3,
	POLICY_NONE_TO_RT = 4,
};

enum priv_stack_mode {
	PRIV_STACK_UNKNOWN = 0,
	NO_PRIV_STACK = 1,
	PRIV_STACK_ADAPTIVE = 2,
};

enum probe_print_type {
	PROBE_PRINT_NORMAL = 0,
	PROBE_PRINT_RETURN = 1,
	PROBE_PRINT_EVENT = 2,
};

enum probe_type {
	PROBE_DEFAULT_STRATEGY = 0,
	PROBE_PREFER_ASYNCHRONOUS = 1,
	PROBE_FORCE_SYNCHRONOUS = 2,
};

enum proc_cn_event {
	PROC_EVENT_NONE = 0,
	PROC_EVENT_FORK = 1,
	PROC_EVENT_EXEC = 2,
	PROC_EVENT_UID = 4,
	PROC_EVENT_GID = 64,
	PROC_EVENT_SID = 128,
	PROC_EVENT_PTRACE = 256,
	PROC_EVENT_COMM = 512,
	PROC_EVENT_NONZERO_EXIT = 536870912,
	PROC_EVENT_COREDUMP = 1073741824,
	PROC_EVENT_EXIT = 2147483648,
};

enum proc_hidepid {
	HIDEPID_OFF = 0,
	HIDEPID_NO_ACCESS = 1,
	HIDEPID_INVISIBLE = 2,
	HIDEPID_NOT_PTRACEABLE = 4,
};

enum proc_mem_force {
	PROC_MEM_FORCE_ALWAYS = 0,
	PROC_MEM_FORCE_PTRACE = 1,
	PROC_MEM_FORCE_NEVER = 2,
};

enum proc_param {
	Opt_gid___8 = 0,
	Opt_hidepid = 1,
	Opt_subset = 2,
};

enum proc_pidonly {
	PROC_PIDONLY_OFF = 0,
	PROC_PIDONLY_ON = 1,
};

enum procmap_query_flags {
	PROCMAP_QUERY_VMA_READABLE = 1,
	PROCMAP_QUERY_VMA_WRITABLE = 2,
	PROCMAP_QUERY_VMA_EXECUTABLE = 4,
	PROCMAP_QUERY_VMA_SHARED = 8,
	PROCMAP_QUERY_COVERING_OR_NEXT_VMA = 16,
	PROCMAP_QUERY_FILE_BACKED_VMA = 32,
};

enum profile_mode {
	APPARMOR_ENFORCE = 0,
	APPARMOR_COMPLAIN = 1,
	APPARMOR_KILL = 2,
	APPARMOR_UNCONFINED = 3,
	APPARMOR_USER = 4,
};

enum prs_errcode {
	PERR_NONE = 0,
	PERR_INVCPUS = 1,
	PERR_INVPARENT = 2,
	PERR_NOTPART = 3,
	PERR_NOTEXCL = 4,
	PERR_NOCPUS = 5,
	PERR_HOTPLUG = 6,
	PERR_CPUSEMPTY = 7,
	PERR_HKEEPING = 8,
	PERR_ACCESS = 9,
};

enum ps2_disposition {
	PS2_PROCESS = 0,
	PS2_IGNORE = 1,
	PS2_ERROR = 2,
};

enum psi_aggregators {
	PSI_AVGS = 0,
	PSI_POLL = 1,
	NR_PSI_AGGREGATORS = 2,
};

enum psi_res {
	PSI_IO = 0,
	PSI_MEM = 1,
	PSI_CPU = 2,
	NR_PSI_RESOURCES = 3,
};

enum psi_states {
	PSI_IO_SOME = 0,
	PSI_IO_FULL = 1,
	PSI_MEM_SOME = 2,
	PSI_MEM_FULL = 3,
	PSI_CPU_SOME = 4,
	PSI_CPU_FULL = 5,
	PSI_NONIDLE = 6,
	NR_PSI_STATES = 7,
};

enum psi_task_count {
	NR_IOWAIT = 0,
	NR_MEMSTALL = 1,
	NR_RUNNING = 2,
	NR_MEMSTALL_RUNNING = 3,
	NR_PSI_TASK_COUNTS = 4,
};

enum psmouse_scale {
	PSMOUSE_SCALE11 = 0,
	PSMOUSE_SCALE21 = 1,
};

enum psmouse_state {
	PSMOUSE_IGNORE = 0,
	PSMOUSE_INITIALIZING = 1,
	PSMOUSE_RESYNCING = 2,
	PSMOUSE_CMD_MODE = 3,
	PSMOUSE_ACTIVATED = 4,
};

enum psmouse_type {
	PSMOUSE_NONE = 0,
	PSMOUSE_PS2 = 1,
	PSMOUSE_PS2PP = 2,
	PSMOUSE_THINKPS = 3,
	PSMOUSE_GENPS = 4,
	PSMOUSE_IMPS = 5,
	PSMOUSE_IMEX = 6,
	PSMOUSE_SYNAPTICS = 7,
	PSMOUSE_ALPS = 8,
	PSMOUSE_LIFEBOOK = 9,
	PSMOUSE_TRACKPOINT = 10,
	PSMOUSE_TOUCHKIT_PS2 = 11,
	PSMOUSE_CORTRON = 12,
	PSMOUSE_HGPK = 13,
	PSMOUSE_ELANTECH = 14,
	PSMOUSE_FSP = 15,
	PSMOUSE_SYNAPTICS_RELATIVE = 16,
	PSMOUSE_CYPRESS = 17,
	PSMOUSE_FOCALTECH = 18,
	PSMOUSE_VMMOUSE = 19,
	PSMOUSE_BYD = 20,
	PSMOUSE_SYNAPTICS_SMBUS = 21,
	PSMOUSE_ELANTECH_SMBUS = 22,
	PSMOUSE_AUTO = 23,
};

enum ptp_clock_events {
	PTP_CLOCK_ALARM = 0,
	PTP_CLOCK_EXTTS = 1,
	PTP_CLOCK_EXTOFF = 2,
	PTP_CLOCK_PPS = 3,
	PTP_CLOCK_PPSUSR = 4,
};

enum ptp_pin_function {
	PTP_PF_NONE = 0,
	PTP_PF_EXTTS = 1,
	PTP_PF_PEROUT = 2,
	PTP_PF_PHYSYNC = 3,
};

enum pwm_polarity {
	PWM_POLARITY_NORMAL = 0,
	PWM_POLARITY_INVERSED = 1,
};

enum qdisc_class_ops_flags {
	QDISC_CLASS_OPS_DOIT_UNLOCKED = 1,
};

enum qdisc_state2_t {
	__QDISC_STATE2_RUNNING = 0,
};

enum qdisc_state_t {
	__QDISC_STATE_SCHED = 0,
	__QDISC_STATE_DEACTIVATED = 1,
	__QDISC_STATE_MISSED = 2,
	__QDISC_STATE_DRAINING = 3,
};

enum queue_mode {
	QUEUE_MODE_STRICT_PRIORITY = 0,
	QUEUE_MODE_STREAM_RESERVATION = 1,
};

enum quota_type {
	USRQUOTA = 0,
	GRPQUOTA = 1,
	PRJQUOTA = 2,
};

enum radeon_chip_flags {
	CHIP_FAMILY_MASK = 65535,
	CHIP_FLAGS_MASK = 4294901760,
	CHIP_IS_MOBILITY = 65536,
	CHIP_IS_IGP = 131072,
	CHIP_HAS_CRTC2 = 262144,
};

enum radeon_errata {
	CHIP_ERRATA_R300_CG = 1,
	CHIP_ERRATA_PLL_DUMMYREADS = 2,
	CHIP_ERRATA_PLL_DELAY = 4,
};

enum radeon_family {
	CHIP_FAMILY_UNKNOW = 0,
	CHIP_FAMILY_LEGACY = 1,
	CHIP_FAMILY_RADEON = 2,
	CHIP_FAMILY_RV100 = 3,
	CHIP_FAMILY_RS100 = 4,
	CHIP_FAMILY_RV200 = 5,
	CHIP_FAMILY_RS200 = 6,
	CHIP_FAMILY_R200 = 7,
	CHIP_FAMILY_RV250 = 8,
	CHIP_FAMILY_RS300 = 9,
	CHIP_FAMILY_RV280 = 10,
	CHIP_FAMILY_R300 = 11,
	CHIP_FAMILY_R350 = 12,
	CHIP_FAMILY_RV350 = 13,
	CHIP_FAMILY_RV380 = 14,
	CHIP_FAMILY_R420 = 15,
	CHIP_FAMILY_RC410 = 16,
	CHIP_FAMILY_RS400 = 17,
	CHIP_FAMILY_RS480 = 18,
	CHIP_FAMILY_LAST = 19,
};

enum radeon_montype {
	MT_NONE = 0,
	MT_CRT = 1,
	MT_LCD = 2,
	MT_DFP = 3,
	MT_CTV = 4,
	MT_STV = 5,
};

enum radeon_pm_mode {
	radeon_pm_none = 0,
	radeon_pm_d2 = 1,
	radeon_pm_off = 2,
};

enum raid_level {
	RAID_LEVEL_UNKNOWN = 0,
	RAID_LEVEL_LINEAR = 1,
	RAID_LEVEL_0 = 2,
	RAID_LEVEL_1 = 3,
	RAID_LEVEL_10 = 4,
	RAID_LEVEL_1E = 5,
	RAID_LEVEL_3 = 6,
	RAID_LEVEL_4 = 7,
	RAID_LEVEL_5 = 8,
	RAID_LEVEL_50 = 9,
	RAID_LEVEL_6 = 10,
	RAID_LEVEL_JBOD = 11,
};

enum raid_state {
	RAID_STATE_UNKNOWN = 0,
	RAID_STATE_ACTIVE = 1,
	RAID_STATE_DEGRADED = 2,
	RAID_STATE_RESYNCING = 3,
	RAID_STATE_OFFLINE = 4,
};

enum ramfs_param {
	Opt_mode___6 = 0,
};

enum rdma_ah_attr_type {
	RDMA_AH_ATTR_TYPE_UNDEFINED = 0,
	RDMA_AH_ATTR_TYPE_IB = 1,
	RDMA_AH_ATTR_TYPE_ROCE = 2,
	RDMA_AH_ATTR_TYPE_OPA = 3,
};

enum rdma_cm_event_type {
	RDMA_CM_EVENT_ADDR_RESOLVED = 0,
	RDMA_CM_EVENT_ADDR_ERROR = 1,
	RDMA_CM_EVENT_ROUTE_RESOLVED = 2,
	RDMA_CM_EVENT_ROUTE_ERROR = 3,
	RDMA_CM_EVENT_CONNECT_REQUEST = 4,
	RDMA_CM_EVENT_CONNECT_RESPONSE = 5,
	RDMA_CM_EVENT_CONNECT_ERROR = 6,
	RDMA_CM_EVENT_UNREACHABLE = 7,
	RDMA_CM_EVENT_REJECTED = 8,
	RDMA_CM_EVENT_ESTABLISHED = 9,
	RDMA_CM_EVENT_DISCONNECTED = 10,
	RDMA_CM_EVENT_DEVICE_REMOVAL = 11,
	RDMA_CM_EVENT_MULTICAST_JOIN = 12,
	RDMA_CM_EVENT_MULTICAST_ERROR = 13,
	RDMA_CM_EVENT_ADDR_CHANGE = 14,
	RDMA_CM_EVENT_TIMEWAIT_EXIT = 15,
};

enum rdma_driver_id {
	RDMA_DRIVER_UNKNOWN = 0,
	RDMA_DRIVER_MLX5 = 1,
	RDMA_DRIVER_MLX4 = 2,
	RDMA_DRIVER_CXGB3 = 3,
	RDMA_DRIVER_CXGB4 = 4,
	RDMA_DRIVER_MTHCA = 5,
	RDMA_DRIVER_BNXT_RE = 6,
	RDMA_DRIVER_OCRDMA = 7,
	RDMA_DRIVER_NES = 8,
	RDMA_DRIVER_I40IW = 9,
	RDMA_DRIVER_IRDMA = 9,
	RDMA_DRIVER_VMW_PVRDMA = 10,
	RDMA_DRIVER_QEDR = 11,
	RDMA_DRIVER_HNS = 12,
	RDMA_DRIVER_USNIC = 13,
	RDMA_DRIVER_RXE = 14,
	RDMA_DRIVER_HFI1 = 15,
	RDMA_DRIVER_QIB = 16,
	RDMA_DRIVER_EFA = 17,
	RDMA_DRIVER_SIW = 18,
	RDMA_DRIVER_ERDMA = 19,
	RDMA_DRIVER_MANA = 20,
};

enum rdma_link_layer {
	IB_LINK_LAYER_UNSPECIFIED = 0,
	IB_LINK_LAYER_INFINIBAND = 1,
	IB_LINK_LAYER_ETHERNET = 2,
};

enum rdma_netdev_t {
	RDMA_NETDEV_OPA_VNIC = 0,
	RDMA_NETDEV_IPOIB = 1,
};

enum rdma_network_type {
	RDMA_NETWORK_IB = 0,
	RDMA_NETWORK_ROCE_V1 = 1,
	RDMA_NETWORK_IPV4 = 2,
	RDMA_NETWORK_IPV6 = 3,
};

enum rdma_nl_counter_mask {
	RDMA_COUNTER_MASK_QP_TYPE = 1,
	RDMA_COUNTER_MASK_PID = 2,
};

enum rdma_nl_counter_mode {
	RDMA_COUNTER_MODE_NONE = 0,
	RDMA_COUNTER_MODE_AUTO = 1,
	RDMA_COUNTER_MODE_MANUAL = 2,
	RDMA_COUNTER_MODE_MAX = 3,
};

enum rdma_nl_dev_type {
	RDMA_DEVICE_TYPE_SMI = 1,
};

enum rdma_nl_name_assign_type {
	RDMA_NAME_ASSIGN_TYPE_UNKNOWN = 0,
	RDMA_NAME_ASSIGN_TYPE_USER = 1,
};

enum rdma_restrack_type {
	RDMA_RESTRACK_PD = 0,
	RDMA_RESTRACK_CQ = 1,
	RDMA_RESTRACK_QP = 2,
	RDMA_RESTRACK_CM_ID = 3,
	RDMA_RESTRACK_MR = 4,
	RDMA_RESTRACK_CTX = 5,
	RDMA_RESTRACK_COUNTER = 6,
	RDMA_RESTRACK_SRQ = 7,
	RDMA_RESTRACK_MAX = 8,
};

enum rdma_transport_type {
	RDMA_TRANSPORT_IB = 0,
	RDMA_TRANSPORT_IWARP = 1,
	RDMA_TRANSPORT_USNIC = 2,
	RDMA_TRANSPORT_USNIC_UDP = 3,
	RDMA_TRANSPORT_UNSPECIFIED = 4,
};

enum rdma_ucm_port_space {
	RDMA_PS_IPOIB = 2,
	RDMA_PS_IB = 319,
	RDMA_PS_TCP = 262,
	RDMA_PS_UDP = 273,
};

enum rdmacg_file_type {
	RDMACG_RESOURCE_TYPE_MAX = 0,
	RDMACG_RESOURCE_TYPE_STAT = 1,
};

enum rdmacg_resource_type {
	RDMACG_RESOURCE_HCA_HANDLE = 0,
	RDMACG_RESOURCE_HCA_OBJECT = 1,
	RDMACG_RESOURCE_MAX = 2,
};

enum rds_message_rxpath_latency {
	RDS_MSG_RX_HDR_TO_DGRAM_START = 0,
	RDS_MSG_RX_DGRAM_REASSEMBLE = 1,
	RDS_MSG_RX_DGRAM_DELIVERED = 2,
	RDS_MSG_RX_DGRAM_TRACE_MAX = 3,
};

enum reboot_mode {
	REBOOT_UNDEFINED = -1,
	REBOOT_COLD = 0,
	REBOOT_WARM = 1,
	REBOOT_HARD = 2,
	REBOOT_SOFT = 3,
	REBOOT_GPIO = 4,
};

enum reboot_type {
	BOOT_TRIPLE = 116,
	BOOT_KBD = 107,
	BOOT_BIOS = 98,
	BOOT_ACPI = 97,
	BOOT_EFI = 101,
	BOOT_CF9_FORCE = 112,
	BOOT_CF9_SAFE = 113,
};

enum ref_state_type {
	REF_TYPE_PTR = 1,
	REF_TYPE_IRQ = 2,
	REF_TYPE_LOCK = 3,
};

enum refcount_saturation_type {
	REFCOUNT_ADD_NOT_ZERO_OVF = 0,
	REFCOUNT_ADD_OVF = 1,
	REFCOUNT_ADD_UAF = 2,
	REFCOUNT_SUB_UAF = 3,
	REFCOUNT_DEC_LEAK = 4,
};

enum reg0i15_op {
	break_op = 84,
};

enum reg0i26_op {
	b_op = 20,
	bl_op = 21,
};

enum reg1i20_op {
	lu12iw_op = 10,
	lu32id_op = 11,
	pcaddi_op = 12,
	pcalau12i_op = 13,
	pcaddu12i_op = 14,
	pcaddu18i_op = 15,
};

enum reg1i21_op {
	beqz_op = 16,
	bnez_op = 17,
	bceqz_op = 18,
	bcnez_op = 18,
};

enum reg2_op {
	revb2h_op = 12,
	revb4h_op = 13,
	revb2w_op = 14,
	revbd_op = 15,
	revh2w_op = 16,
	revhd_op = 17,
	extwh_op = 22,
	extwb_op = 23,
	cpucfg_op = 27,
	iocsrrdb_op = 102912,
	iocsrrdh_op = 102913,
	iocsrrdw_op = 102914,
	iocsrrdd_op = 102915,
	iocsrwrb_op = 102916,
	iocsrwrh_op = 102917,
	iocsrwrw_op = 102918,
	iocsrwrd_op = 102919,
};

enum reg2bstrd_op {
	bstrinsd_op = 2,
	bstrpickd_op = 3,
};

enum reg2i12_op {
	addiw_op = 10,
	addid_op = 11,
	lu52id_op = 12,
	andi_op = 13,
	ori_op = 14,
	xori_op = 15,
	ldb_op = 160,
	ldh_op = 161,
	ldw_op = 162,
	ldd_op = 163,
	stb_op = 164,
	sth_op = 165,
	stw_op = 166,
	std_op = 167,
	ldbu_op = 168,
	ldhu_op = 169,
	ldwu_op = 170,
	flds_op = 172,
	fsts_op = 173,
	fldd_op = 174,
	fstd_op = 175,
};

enum reg2i14_op {
	llw_op = 32,
	scw_op = 33,
	lld_op = 34,
	scd_op = 35,
	ldptrw_op = 36,
	stptrw_op = 37,
	ldptrd_op = 38,
	stptrd_op = 39,
};

enum reg2i16_op {
	jirl_op = 19,
	beq_op = 22,
	bne_op = 23,
	blt_op = 24,
	bge_op = 25,
	bltu_op = 26,
	bgeu_op = 27,
};

enum reg2i5_op {
	slliw_op = 129,
	srliw_op = 137,
	sraiw_op = 145,
};

enum reg2i6_op {
	sllid_op = 65,
	srlid_op = 69,
	sraid_op = 73,
};

enum reg3_op {
	asrtle_op = 2,
	asrtgt_op = 3,
	addw_op = 32,
	addd_op = 33,
	subw_op = 34,
	subd_op = 35,
	nor_op = 40,
	and_op = 41,
	or_op = 42,
	xor_op = 43,
	orn_op = 44,
	andn_op = 45,
	sllw_op = 46,
	srlw_op = 47,
	sraw_op = 48,
	slld_op = 49,
	srld_op = 50,
	srad_op = 51,
	mulw_op = 56,
	mulhw_op = 57,
	mulhwu_op = 58,
	muld_op = 59,
	mulhd_op = 60,
	mulhdu_op = 61,
	divw_op = 64,
	modw_op = 65,
	divwu_op = 66,
	modwu_op = 67,
	divd_op = 68,
	modd_op = 69,
	divdu_op = 70,
	moddu_op = 71,
	ldxb_op = 28672,
	ldxh_op = 28680,
	ldxw_op = 28688,
	ldxd_op = 28696,
	stxb_op = 28704,
	stxh_op = 28712,
	stxw_op = 28720,
	stxd_op = 28728,
	ldxbu_op = 28736,
	ldxhu_op = 28744,
	ldxwu_op = 28752,
	fldxs_op = 28768,
	fldxd_op = 28776,
	fstxs_op = 28784,
	fstxd_op = 28792,
	amswapw_op = 28864,
	amswapd_op = 28865,
	amaddw_op = 28866,
	amaddd_op = 28867,
	amandw_op = 28868,
	amandd_op = 28869,
	amorw_op = 28870,
	amord_op = 28871,
	amxorw_op = 28872,
	amxord_op = 28873,
	ammaxw_op = 28874,
	ammaxd_op = 28875,
	amminw_op = 28876,
	ammind_op = 28877,
	ammaxwu_op = 28878,
	ammaxdu_op = 28879,
	amminwu_op = 28880,
	ammindu_op = 28881,
	amswapdbw_op = 28882,
	amswapdbd_op = 28883,
	amadddbw_op = 28884,
	amadddbd_op = 28885,
	amanddbw_op = 28886,
	amanddbd_op = 28887,
	amordbw_op = 28888,
	amordbd_op = 28889,
	amxordbw_op = 28890,
	amxordbd_op = 28891,
	ammaxdbw_op = 28892,
	ammaxdbd_op = 28893,
	ammindbw_op = 28894,
	ammindbd_op = 28895,
	ammaxdbwu_op = 28896,
	ammaxdbdu_op = 28897,
	ammindbwu_op = 28898,
	ammindbdu_op = 28899,
	fldgts_op = 28904,
	fldgtd_op = 28905,
	fldles_op = 28906,
	fldled_op = 28907,
	fstgts_op = 28908,
	fstgtd_op = 28909,
	fstles_op = 28910,
	fstled_op = 28911,
	ldgtb_op = 28912,
	ldgth_op = 28913,
	ldgtw_op = 28914,
	ldgtd_op = 28915,
	ldleb_op = 28916,
	ldleh_op = 28917,
	ldlew_op = 28918,
	ldled_op = 28919,
	stgtb_op = 28920,
	stgth_op = 28921,
	stgtw_op = 28922,
	stgtd_op = 28923,
	stleb_op = 28924,
	stleh_op = 28925,
	stlew_op = 28926,
	stled_op = 28927,
};

enum reg3sa2_op {
	alslw_op = 2,
	alslwu_op = 3,
	alsld_op = 22,
};

enum reg_arg_type {
	SRC_OP = 0,
	DST_OP = 1,
	DST_OP_NO_MARK = 2,
};

enum regcache_type {
	REGCACHE_NONE = 0,
	REGCACHE_RBTREE = 1,
	REGCACHE_FLAT = 2,
	REGCACHE_MAPLE = 3,
};

enum regex_type {
	MATCH_FULL = 0,
	MATCH_FRONT_ONLY = 1,
	MATCH_MIDDLE_ONLY = 2,
	MATCH_END_ONLY = 3,
	MATCH_GLOB = 4,
	MATCH_INDEX = 5,
};

enum regmap_endian {
	REGMAP_ENDIAN_DEFAULT = 0,
	REGMAP_ENDIAN_BIG = 1,
	REGMAP_ENDIAN_LITTLE = 2,
	REGMAP_ENDIAN_NATIVE = 3,
};

enum release_type {
	leaf_only = 0,
	whole_subtree = 1,
};

enum reloc_stage {
	MOVE_DATA_EXTENTS = 0,
	UPDATE_DATA_PTRS = 1,
};

enum req_flag_bits {
	__REQ_FAILFAST_DEV = 8,
	__REQ_FAILFAST_TRANSPORT = 9,
	__REQ_FAILFAST_DRIVER = 10,
	__REQ_SYNC = 11,
	__REQ_META = 12,
	__REQ_PRIO = 13,
	__REQ_NOMERGE = 14,
	__REQ_IDLE = 15,
	__REQ_INTEGRITY = 16,
	__REQ_FUA = 17,
	__REQ_PREFLUSH = 18,
	__REQ_RAHEAD = 19,
	__REQ_BACKGROUND = 20,
	__REQ_NOWAIT = 21,
	__REQ_POLLED = 22,
	__REQ_ALLOC_CACHE = 23,
	__REQ_SWAP = 24,
	__REQ_DRV = 25,
	__REQ_FS_PRIVATE = 26,
	__REQ_ATOMIC = 27,
	__REQ_NOUNMAP = 28,
	__REQ_NR_BITS = 29,
};

enum req_op {
	REQ_OP_READ = 0,
	REQ_OP_WRITE = 1,
	REQ_OP_FLUSH = 2,
	REQ_OP_DISCARD = 3,
	REQ_OP_SECURE_ERASE = 5,
	REQ_OP_ZONE_APPEND = 7,
	REQ_OP_WRITE_ZEROES = 9,
	REQ_OP_ZONE_OPEN = 10,
	REQ_OP_ZONE_CLOSE = 11,
	REQ_OP_ZONE_FINISH = 12,
	REQ_OP_ZONE_RESET = 13,
	REQ_OP_ZONE_RESET_ALL = 15,
	REQ_OP_DRV_IN = 34,
	REQ_OP_DRV_OUT = 35,
	REQ_OP_LAST = 36,
};

enum request_irq_err {
	REQ_IRQ_ERR_ALL = 0,
	REQ_IRQ_ERR_TX = 1,
	REQ_IRQ_ERR_RX = 2,
	REQ_IRQ_ERR_SFTY = 3,
	REQ_IRQ_ERR_SFTY_UE = 4,
	REQ_IRQ_ERR_SFTY_CE = 5,
	REQ_IRQ_ERR_LPI = 6,
	REQ_IRQ_ERR_WOL = 7,
	REQ_IRQ_ERR_MAC = 8,
	REQ_IRQ_ERR_NO = 9,
};

enum resctrl_conf_type {
	CDP_NONE = 0,
	CDP_CODE = 1,
	CDP_DATA = 2,
};

enum reset_control_flags {
	RESET_CONTROL_EXCLUSIVE = 4,
	RESET_CONTROL_EXCLUSIVE_DEASSERTED = 12,
	RESET_CONTROL_EXCLUSIVE_RELEASED = 0,
	RESET_CONTROL_SHARED = 1,
	RESET_CONTROL_SHARED_DEASSERTED = 9,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE = 6,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_DEASSERTED = 14,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_RELEASED = 2,
	RESET_CONTROL_OPTIONAL_SHARED = 3,
	RESET_CONTROL_OPTIONAL_SHARED_DEASSERTED = 11,
};

enum reset_type {
	FORCE_BIG_HAMMER = 0,
	SOFT_RESET = 1,
};

enum resolve_mode {
	RESOLVE_TBD = 0,
	RESOLVE_PTR = 1,
	RESOLVE_STRUCT_OR_ARRAY = 2,
};

enum resource_type {
	RESOURCE_CACHED_MEMORY = 0,
	RESOURCE_UNCACHED_MEMORY = 1,
};

enum ring_buffer_flags {
	RB_FL_OVERWRITE = 1,
};

enum ring_buffer_type {
	RINGBUF_TYPE_DATA_TYPE_LEN_MAX = 28,
	RINGBUF_TYPE_PADDING = 29,
	RINGBUF_TYPE_TIME_EXTEND = 30,
	RINGBUF_TYPE_TIME_STAMP = 31,
};

enum ring_desc_flags {
	RING_DESC_ISOCH = 1,
	RING_DESC_CRC_ERROR = 1,
	RING_DESC_COMPLETED = 2,
	RING_DESC_POSTED = 4,
	RING_DESC_BUFFER_OVERRUN = 4,
	RING_DESC_INTERRUPT = 8,
};

enum ring_flags {
	RING_FLAG_ISOCH_ENABLE = 134217728,
	RING_FLAG_E2E_FLOW_CONTROL = 268435456,
	RING_FLAG_PCI_NO_SNOOP = 536870912,
	RING_FLAG_RAW = 1073741824,
	RING_FLAG_ENABLE = -2147483648,
};

enum rio_device_state {
	RIO_DEVICE_INITIALIZING = 0,
	RIO_DEVICE_RUNNING = 1,
	RIO_DEVICE_GONE = 2,
	RIO_DEVICE_SHUTDOWN = 3,
};

enum rio_link_speed {
	RIO_LINK_DOWN = 0,
	RIO_LINK_125 = 1,
	RIO_LINK_250 = 2,
	RIO_LINK_312 = 3,
	RIO_LINK_500 = 4,
	RIO_LINK_625 = 5,
};

enum rlimit_type {
	UCOUNT_RLIMIT_NPROC = 0,
	UCOUNT_RLIMIT_MSGQUEUE = 1,
	UCOUNT_RLIMIT_SIGPENDING = 2,
	UCOUNT_RLIMIT_MEMLOCK = 3,
	UCOUNT_RLIMIT_COUNTS = 4,
};

enum rmap_level {
	RMAP_LEVEL_PTE = 0,
	RMAP_LEVEL_PMD = 1,
};

enum rmi_reg_state {
	RMI_REG_STATE_DEFAULT = 0,
	RMI_REG_STATE_OFF = 1,
	RMI_REG_STATE_ON = 2,
};

enum rmi_sensor_type {
	rmi_sensor_default = 0,
	rmi_sensor_touchscreen = 1,
	rmi_sensor_touchpad = 2,
};

enum rmp_flags {
	RMP_LOCKED = 1,
	RMP_USE_SHARED_ZEROPAGE = 2,
};

enum routing_attribute {
	DIRECT_ROUTING = 0,
	SUBTRACTIVE_ROUTING = 1,
	TABLE_ROUTING = 2,
};

enum rp_check {
	RP_CHECK_CALL = 0,
	RP_CHECK_CHAIN_CALL = 1,
	RP_CHECK_RET = 2,
};

enum rp_lock {
	RP_UNLOCKED = 0,
	RP_LOCKED = 1,
	RP_UNHASHED = 2,
};

enum rpc_accept_stat {
	RPC_SUCCESS = 0,
	RPC_PROG_UNAVAIL = 1,
	RPC_PROG_MISMATCH = 2,
	RPC_PROC_UNAVAIL = 3,
	RPC_GARBAGE_ARGS = 4,
	RPC_SYSTEM_ERR = 5,
	RPC_DROP_REPLY = 60000,
};

enum rpc_auth_flavors {
	RPC_AUTH_NULL = 0,
	RPC_AUTH_UNIX = 1,
	RPC_AUTH_SHORT = 2,
	RPC_AUTH_DES = 3,
	RPC_AUTH_KRB = 4,
	RPC_AUTH_GSS = 6,
	RPC_AUTH_TLS = 7,
	RPC_AUTH_MAXFLAVOR = 8,
	RPC_AUTH_GSS_KRB5 = 390003,
	RPC_AUTH_GSS_KRB5I = 390004,
	RPC_AUTH_GSS_KRB5P = 390005,
	RPC_AUTH_GSS_LKEY = 390006,
	RPC_AUTH_GSS_LKEYI = 390007,
	RPC_AUTH_GSS_LKEYP = 390008,
	RPC_AUTH_GSS_SPKM = 390009,
	RPC_AUTH_GSS_SPKMI = 390010,
	RPC_AUTH_GSS_SPKMP = 390011,
};

enum rpc_auth_stat {
	RPC_AUTH_OK = 0,
	RPC_AUTH_BADCRED = 1,
	RPC_AUTH_REJECTEDCRED = 2,
	RPC_AUTH_BADVERF = 3,
	RPC_AUTH_REJECTEDVERF = 4,
	RPC_AUTH_TOOWEAK = 5,
	RPCSEC_GSS_CREDPROBLEM = 13,
	RPCSEC_GSS_CTXPROBLEM = 14,
};

enum rpc_display_format_t {
	RPC_DISPLAY_ADDR = 0,
	RPC_DISPLAY_PORT = 1,
	RPC_DISPLAY_PROTO = 2,
	RPC_DISPLAY_HEX_ADDR = 3,
	RPC_DISPLAY_HEX_PORT = 4,
	RPC_DISPLAY_NETID = 5,
	RPC_DISPLAY_MAX = 6,
};

enum rpc_gss_proc {
	RPC_GSS_PROC_DATA = 0,
	RPC_GSS_PROC_INIT = 1,
	RPC_GSS_PROC_CONTINUE_INIT = 2,
	RPC_GSS_PROC_DESTROY = 3,
};

enum rpc_gss_svc {
	RPC_GSS_SVC_NONE = 1,
	RPC_GSS_SVC_INTEGRITY = 2,
	RPC_GSS_SVC_PRIVACY = 3,
};

enum rpc_msg_type {
	RPC_CALL = 0,
	RPC_REPLY = 1,
};

enum rpc_reject_stat {
	RPC_MISMATCH = 0,
	RPC_AUTH_ERROR = 1,
};

enum rpc_reply_stat {
	RPC_MSG_ACCEPTED = 0,
	RPC_MSG_DENIED = 1,
};

enum rpm_request {
	RPM_REQ_NONE = 0,
	RPM_REQ_IDLE = 1,
	RPM_REQ_SUSPEND = 2,
	RPM_REQ_AUTOSUSPEND = 3,
	RPM_REQ_RESUME = 4,
};

enum rpm_status {
	RPM_INVALID = -1,
	RPM_ACTIVE = 0,
	RPM_RESUMING = 1,
	RPM_SUSPENDED = 2,
	RPM_SUSPENDING = 3,
};

enum rq_end_io_ret {
	RQ_END_IO_NONE = 0,
	RQ_END_IO_FREE = 1,
};

enum rq_qos_id {
	RQ_QOS_WBT = 0,
	RQ_QOS_LATENCY = 1,
	RQ_QOS_COST = 2,
};

enum rqf_flags {
	__RQF_STARTED = 0,
	__RQF_FLUSH_SEQ = 1,
	__RQF_MIXED_MERGE = 2,
	__RQF_DONTPREP = 3,
	__RQF_SCHED_TAGS = 4,
	__RQF_USE_SCHED = 5,
	__RQF_FAILED = 6,
	__RQF_QUIET = 7,
	__RQF_IO_STAT = 8,
	__RQF_PM = 9,
	__RQF_HASHED = 10,
	__RQF_STATS = 11,
	__RQF_SPECIAL_PAYLOAD = 12,
	__RQF_ZONE_WRITE_PLUGGING = 13,
	__RQF_TIMED_OUT = 14,
	__RQF_RESV = 15,
	__RQF_BITS = 16,
};

enum rsaprivkey_actions {
	ACT_rsa_get_d = 0,
	ACT_rsa_get_dp = 1,
	ACT_rsa_get_dq = 2,
	ACT_rsa_get_e = 3,
	ACT_rsa_get_n = 4,
	ACT_rsa_get_p = 5,
	ACT_rsa_get_q = 6,
	ACT_rsa_get_qinv = 7,
	NR__rsaprivkey_actions = 8,
};

enum rsapubkey_actions {
	ACT_rsa_get_e___2 = 0,
	ACT_rsa_get_n___2 = 1,
	NR__rsapubkey_actions = 2,
};

enum rseq_cpu_id_state {
	RSEQ_CPU_ID_UNINITIALIZED = -1,
	RSEQ_CPU_ID_REGISTRATION_FAILED = -2,
};

enum rseq_cs_flags {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL = 2,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE = 4,
};

enum rseq_cs_flags_bit {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT_BIT = 0,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL_BIT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE_BIT = 2,
};

enum rseq_event_mask_bits {
	RSEQ_EVENT_PREEMPT_BIT = 0,
	RSEQ_EVENT_SIGNAL_BIT = 1,
	RSEQ_EVENT_MIGRATE_BIT = 2,
};

enum rseq_flags {
	RSEQ_FLAG_UNREGISTER = 1,
};

enum rt6_nud_state {
	RT6_NUD_FAIL_HARD = -3,
	RT6_NUD_FAIL_PROBE = -2,
	RT6_NUD_FAIL_DO_RR = -1,
	RT6_NUD_SUCCEED = 1,
};

enum rt_class_t {
	RT_TABLE_UNSPEC = 0,
	RT_TABLE_COMPAT = 252,
	RT_TABLE_DEFAULT = 253,
	RT_TABLE_MAIN = 254,
	RT_TABLE_LOCAL = 255,
	RT_TABLE_MAX = 4294967295,
};

enum rt_scope_t {
	RT_SCOPE_UNIVERSE = 0,
	RT_SCOPE_SITE = 200,
	RT_SCOPE_LINK = 253,
	RT_SCOPE_HOST = 254,
	RT_SCOPE_NOWHERE = 255,
};

enum rtattr_type_t {
	RTA_UNSPEC = 0,
	RTA_DST = 1,
	RTA_SRC = 2,
	RTA_IIF = 3,
	RTA_OIF = 4,
	RTA_GATEWAY = 5,
	RTA_PRIORITY = 6,
	RTA_PREFSRC = 7,
	RTA_METRICS = 8,
	RTA_MULTIPATH = 9,
	RTA_PROTOINFO = 10,
	RTA_FLOW = 11,
	RTA_CACHEINFO = 12,
	RTA_SESSION = 13,
	RTA_MP_ALGO = 14,
	RTA_TABLE = 15,
	RTA_MARK = 16,
	RTA_MFC_STATS = 17,
	RTA_VIA = 18,
	RTA_NEWDST = 19,
	RTA_PREF = 20,
	RTA_ENCAP_TYPE = 21,
	RTA_ENCAP = 22,
	RTA_EXPIRES = 23,
	RTA_PAD = 24,
	RTA_UID = 25,
	RTA_TTL_PROPAGATE = 26,
	RTA_IP_PROTO = 27,
	RTA_SPORT = 28,
	RTA_DPORT = 29,
	RTA_NH_ID = 30,
	RTA_FLOWLABEL = 31,
	__RTA_MAX = 32,
};

enum rtc_control {
	DMA_CONTROL_RTC_64 = 0,
	DMA_CONTROL_RTC_32 = 8,
	DMA_CONTROL_RTC_96 = 16,
	DMA_CONTROL_RTC_128 = 24,
};

enum rtl8125_registers {
	LEDSEL0 = 24,
	INT_CFG0_8125 = 52,
	IntrMask_8125 = 56,
	IntrStatus_8125 = 60,
	INT_CFG1_8125 = 122,
	LEDSEL2 = 132,
	LEDSEL1 = 134,
	TxPoll_8125 = 144,
	LEDSEL3 = 150,
	MAC0_BKP = 6624,
	RSS_CTRL_8125 = 17664,
	Q_NUM_CTRL_8125 = 18432,
	EEE_TXIDLE_TIMER_8125 = 24648,
};

enum rtl8168_8101_registers {
	CSIDR = 100,
	CSIAR = 104,
	PMCH = 111,
	EPHYAR = 128,
	DLLPR = 208,
	DBG_REG = 209,
	TWSI = 210,
	MCU = 211,
	EFUSEAR = 220,
	MISC_1 = 242,
};

enum rtl8168_registers {
	LED_CTRL = 24,
	LED_FREQ = 26,
	EEE_LED = 27,
	ERIDR = 112,
	ERIAR = 116,
	EPHY_RXER_NUM = 124,
	OCPDR = 176,
	OCPAR = 180,
	GPHY_OCP = 184,
	RDSAR1 = 208,
	MISC = 240,
};

enum rtl_dash_type {
	RTL_DASH_NONE = 0,
	RTL_DASH_DP = 1,
	RTL_DASH_EP = 2,
	RTL_DASH_25_BP = 3,
};

enum rtl_desc_bit {
	DescOwn = -2147483648,
	RingEnd = 1073741824,
	FirstFrag = 536870912,
	LastFrag = 268435456,
};

enum rtl_flag {
	RTL_FLAG_TASK_RESET_PENDING = 0,
	RTL_FLAG_TASK_TX_TIMEOUT = 1,
	RTL_FLAG_MAX = 2,
};

enum rtl_fw_opcode {
	PHY_READ = 0,
	PHY_DATA_OR = 1,
	PHY_DATA_AND = 2,
	PHY_BJMPN = 3,
	PHY_MDIO_CHG = 4,
	PHY_CLEAR_READCOUNT = 7,
	PHY_WRITE = 8,
	PHY_READCOUNT_EQ_SKIP = 9,
	PHY_COMP_EQ_SKIPN = 10,
	PHY_COMP_NEQ_SKIPN = 11,
	PHY_WRITE_PREVIOUS = 12,
	PHY_SKIPN = 13,
	PHY_DELAY_MS = 14,
};

enum rtl_register_content {
	SYSErr = 32768,
	PCSTimeout = 16384,
	SWInt = 256,
	TxDescUnavail = 128,
	RxFIFOOver = 64,
	LinkChg = 32,
	RxOverflow = 16,
	TxErr = 8,
	TxOK = 4,
	RxErr = 2,
	RxOK = 1,
	RxRWT = 4194304,
	RxRES = 2097152,
	RxRUNT = 1048576,
	RxCRC = 524288,
	StopReq = 128,
	CmdReset = 16,
	CmdRxEnb = 8,
	CmdTxEnb = 4,
	RxBufEmpty = 1,
	HPQ = 128,
	NPQ = 64,
	FSWInt = 1,
	Cfg9346_Lock = 0,
	Cfg9346_Unlock = 192,
	AcceptErr = 32,
	AcceptRunt = 16,
	AcceptBroadcast = 8,
	AcceptMulticast = 4,
	AcceptMyPhys = 2,
	AcceptAllPhys = 1,
	TxInterFrameGapShift = 24,
	TxDMAShift = 8,
	LEDS1 = 128,
	LEDS0 = 64,
	Speed_down = 16,
	MEMMAP = 8,
	IOMAP = 4,
	VPD = 2,
	PMEnable = 1,
	ClkReqEn = 128,
	MSIEnable = 32,
	PCI_Clock_66MHz = 1,
	PCI_Clock_33MHz = 0,
	MagicPacket = 32,
	LinkUp = 16,
	Jumbo_En0 = 4,
	Rdy_to_L23 = 2,
	Beacon_en = 1,
	Jumbo_En1 = 2,
	BWF = 64,
	MWF = 32,
	UWF = 16,
	Spi_en = 8,
	LanWake = 2,
	PMEStatus = 1,
	ASPM_en = 1,
	EnableBist = 32768,
	Mac_dbgo_oe = 16384,
	EnAnaPLL = 16384,
	Normal_mode = 8192,
	Force_half_dup = 4096,
	Force_rxflow_en = 2048,
	Force_txflow_en = 1024,
	Cxpl_dbg_sel = 512,
	ASF = 256,
	PktCntrDisable = 128,
	Mac_dbgo_sel = 28,
	RxVlan = 64,
	RxChkSum = 32,
	PCIDAC = 16,
	PCIMulRW = 8,
	TBI_Enable = 128,
	TxFlowCtrl = 64,
	RxFlowCtrl = 32,
	_1000bpsF = 16,
	_100bps = 8,
	_10bps = 4,
	LinkStatus = 2,
	FullDup = 1,
	CounterReset = 1,
	CounterDump = 8,
	MagicPacket_v2 = 65536,
};

enum rtl_registers {
	MAC0 = 0,
	MAC4 = 4,
	MAR0 = 8,
	CounterAddrLow = 16,
	CounterAddrHigh = 20,
	TxDescStartAddrLow = 32,
	TxDescStartAddrHigh = 36,
	TxHDescStartAddrLow = 40,
	TxHDescStartAddrHigh = 44,
	FLASH = 48,
	ERSR = 54,
	ChipCmd = 55,
	TxPoll = 56,
	IntrMask = 60,
	IntrStatus = 62,
	TxConfig = 64,
	RxConfig = 68,
	Cfg9346 = 80,
	Config0 = 81,
	Config1 = 82,
	Config2 = 83,
	Config3 = 84,
	Config4 = 85,
	Config5 = 86,
	PHYAR = 96,
	PHYstatus = 108,
	RxMaxSize = 218,
	CPlusCmd = 224,
	IntrMitigate = 226,
	RxDescAddrLow = 228,
	RxDescAddrHigh = 232,
	EarlyTxThres = 236,
	MaxTxPacketSize = 236,
	FuncEvent = 240,
	FuncEventMask = 244,
	FuncPresetState = 248,
	IBCR0 = 248,
	IBCR2 = 249,
	IBIMR0 = 250,
	IBISR0 = 251,
	FuncForceEvent = 252,
};

enum rtl_rx_desc_bit {
	PID1 = 262144,
	PID0 = 131072,
	IPFail = 65536,
	UDPFail = 32768,
	TCPFail = 16384,
	RxVlanTag = 65536,
};

enum rtl_tx_desc_bit {
	TD_LSO = 134217728,
	TxVlanTag = 131072,
};

enum rtl_tx_desc_bit_0 {
	TD0_TCP_CS = 65536,
	TD0_UDP_CS = 131072,
	TD0_IP_CS = 262144,
};

enum rtl_tx_desc_bit_1 {
	TD1_GTSENV4 = 67108864,
	TD1_GTSENV6 = 33554432,
	TD1_IPv6_CS = 268435456,
	TD1_IPv4_CS = 536870912,
	TD1_TCP_CS = 1073741824,
	TD1_UDP_CS = -2147483648,
};

enum rtmutex_chainwalk {
	RT_MUTEX_MIN_CHAINWALK = 0,
	RT_MUTEX_FULL_CHAINWALK = 1,
};

enum rtnetlink_groups {
	RTNLGRP_NONE = 0,
	RTNLGRP_LINK = 1,
	RTNLGRP_NOTIFY = 2,
	RTNLGRP_NEIGH = 3,
	RTNLGRP_TC = 4,
	RTNLGRP_IPV4_IFADDR = 5,
	RTNLGRP_IPV4_MROUTE = 6,
	RTNLGRP_IPV4_ROUTE = 7,
	RTNLGRP_IPV4_RULE = 8,
	RTNLGRP_IPV6_IFADDR = 9,
	RTNLGRP_IPV6_MROUTE = 10,
	RTNLGRP_IPV6_ROUTE = 11,
	RTNLGRP_IPV6_IFINFO = 12,
	RTNLGRP_DECnet_IFADDR = 13,
	RTNLGRP_NOP2 = 14,
	RTNLGRP_DECnet_ROUTE = 15,
	RTNLGRP_DECnet_RULE = 16,
	RTNLGRP_NOP4 = 17,
	RTNLGRP_IPV6_PREFIX = 18,
	RTNLGRP_IPV6_RULE = 19,
	RTNLGRP_ND_USEROPT = 20,
	RTNLGRP_PHONET_IFADDR = 21,
	RTNLGRP_PHONET_ROUTE = 22,
	RTNLGRP_DCB = 23,
	RTNLGRP_IPV4_NETCONF = 24,
	RTNLGRP_IPV6_NETCONF = 25,
	RTNLGRP_MDB = 26,
	RTNLGRP_MPLS_ROUTE = 27,
	RTNLGRP_NSID = 28,
	RTNLGRP_MPLS_NETCONF = 29,
	RTNLGRP_IPV4_MROUTE_R = 30,
	RTNLGRP_IPV6_MROUTE_R = 31,
	RTNLGRP_NEXTHOP = 32,
	RTNLGRP_BRVLAN = 33,
	RTNLGRP_MCTP_IFADDR = 34,
	RTNLGRP_TUNNEL = 35,
	RTNLGRP_STATS = 36,
	RTNLGRP_IPV4_MCADDR = 37,
	RTNLGRP_IPV6_MCADDR = 38,
	RTNLGRP_IPV6_ACADDR = 39,
	__RTNLGRP_MAX = 40,
};

enum rtnl_kinds {
	RTNL_KIND_NEW = 0,
	RTNL_KIND_DEL = 1,
	RTNL_KIND_GET = 2,
	RTNL_KIND_SET = 3,
};

enum rtnl_link_flags {
	RTNL_FLAG_DOIT_UNLOCKED = 1,
	RTNL_FLAG_BULK_DEL_SUPPORTED = 2,
	RTNL_FLAG_DUMP_UNLOCKED = 4,
	RTNL_FLAG_DUMP_SPLIT_NLM_DONE = 8,
};

enum rw_hint {
	WRITE_LIFE_NOT_SET = 0,
	WRITE_LIFE_NONE = 1,
	WRITE_LIFE_SHORT = 2,
	WRITE_LIFE_MEDIUM = 3,
	WRITE_LIFE_LONG = 4,
	WRITE_LIFE_EXTREME = 5,
} __attribute__((mode(byte)));

enum rwsem_waiter_type {
	RWSEM_WAITING_FOR_WRITE = 0,
	RWSEM_WAITING_FOR_READ = 1,
};

enum rwsem_wake_type {
	RWSEM_WAKE_ANY = 0,
	RWSEM_WAKE_READERS = 1,
	RWSEM_WAKE_READ_OWNED = 2,
};

enum rx_frame_status {
	good_frame = 0,
	discard_frame = 1,
	csum_none = 2,
	llc_snap = 4,
	dma_own = 8,
	rx_not_ls = 16,
};

enum rx_handler_result {
	RX_HANDLER_CONSUMED = 0,
	RX_HANDLER_ANOTHER = 1,
	RX_HANDLER_EXACT = 2,
	RX_HANDLER_PASS = 3,
};

typedef enum rx_handler_result rx_handler_result_t;

enum s2idle_states {
	S2IDLE_STATE_NONE = 0,
	S2IDLE_STATE_ENTER = 1,
	S2IDLE_STATE_WAKE = 2,
};

enum s_alloc {
	sa_rootdomain = 0,
	sa_sd = 1,
	sa_sd_storage = 2,
	sa_none = 3,
};

enum sa_path_rec_type {
	SA_PATH_REC_TYPE_IB = 0,
	SA_PATH_REC_TYPE_ROCE_V1 = 1,
	SA_PATH_REC_TYPE_ROCE_V2 = 2,
	SA_PATH_REC_TYPE_OPA = 3,
};

enum sam_status {
	SAM_STAT_GOOD = 0,
	SAM_STAT_CHECK_CONDITION = 2,
	SAM_STAT_CONDITION_MET = 4,
	SAM_STAT_BUSY = 8,
	SAM_STAT_INTERMEDIATE = 16,
	SAM_STAT_INTERMEDIATE_CONDITION_MET = 20,
	SAM_STAT_RESERVATION_CONFLICT = 24,
	SAM_STAT_COMMAND_TERMINATED = 34,
	SAM_STAT_TASK_SET_FULL = 40,
	SAM_STAT_ACA_ACTIVE = 48,
	SAM_STAT_TASK_ABORTED = 64,
};

enum sas_cmd_port_registers {
	CMD_CMRST_OOB_DET = 256,
	CMD_CMWK_OOB_DET = 260,
	CMD_CMSAS_OOB_DET = 264,
	CMD_BRST_OOB_DET = 268,
	CMD_OOB_SPACE = 272,
	CMD_OOB_BURST = 276,
	CMD_PHY_TIMER = 280,
	CMD_PHY_CONFIG0 = 284,
	CMD_PHY_CONFIG1 = 288,
	CMD_SAS_CTL0 = 292,
	CMD_SAS_CTL1 = 296,
	CMD_SAS_CTL2 = 300,
	CMD_SAS_CTL3 = 304,
	CMD_ID_TEST = 308,
	CMD_PL_TIMER = 312,
	CMD_WD_TIMER = 316,
	CMD_PORT_SEL_COUNT = 320,
	CMD_APP_MEM_CTL = 324,
	CMD_XOR_MEM_CTL = 328,
	CMD_DMA_MEM_CTL = 332,
	CMD_PORT_MEM_CTL0 = 336,
	CMD_PORT_MEM_CTL1 = 340,
	CMD_SATA_PORT_MEM_CTL0 = 344,
	CMD_SATA_PORT_MEM_CTL1 = 348,
	CMD_XOR_MEM_BIST_CTL = 352,
	CMD_XOR_MEM_BIST_STAT = 356,
	CMD_DMA_MEM_BIST_CTL = 360,
	CMD_DMA_MEM_BIST_STAT = 364,
	CMD_PORT_MEM_BIST_CTL = 368,
	CMD_PORT_MEM_BIST_STAT0 = 372,
	CMD_PORT_MEM_BIST_STAT1 = 376,
	CMD_STP_MEM_BIST_CTL = 380,
	CMD_STP_MEM_BIST_STAT0 = 384,
	CMD_STP_MEM_BIST_STAT1 = 388,
	CMD_RESET_COUNT = 392,
	CMD_MONTR_DATA_SEL = 396,
	CMD_PLL_PHY_CONFIG = 400,
	CMD_PHY_CTL = 404,
	CMD_PHY_TEST_COUNT0 = 408,
	CMD_PHY_TEST_COUNT1 = 412,
	CMD_PHY_TEST_COUNT2 = 416,
	CMD_APP_ERR_CONFIG = 420,
	CMD_PND_FIFO_CTL0 = 424,
	CMD_HOST_CTL = 428,
	CMD_HOST_WR_DATA = 432,
	CMD_HOST_RD_DATA = 436,
	CMD_PHY_MODE_21 = 440,
	CMD_SL_MODE0 = 444,
	CMD_SL_MODE1 = 448,
	CMD_PND_FIFO_CTL1 = 452,
	CMD_PORT_LAYER_TIMER1 = 480,
	CMD_LINK_TIMER = 484,
};

enum sas_device_type {
	SAS_PHY_UNUSED = 0,
	SAS_END_DEVICE = 1,
	SAS_EDGE_EXPANDER_DEVICE = 2,
	SAS_FANOUT_EXPANDER_DEVICE = 3,
	SAS_HA = 4,
	SAS_SATA_DEV = 5,
	SAS_SATA_PM = 7,
	SAS_SATA_PM_PORT = 8,
	SAS_SATA_PENDING = 9,
};

enum sas_gpio_reg_type {
	SAS_GPIO_REG_CFG = 0,
	SAS_GPIO_REG_RX = 1,
	SAS_GPIO_REG_RX_GP = 2,
	SAS_GPIO_REG_TX = 3,
	SAS_GPIO_REG_TX_GP = 4,
};

enum sas_ha_state {
	SAS_HA_REGISTERED = 0,
	SAS_HA_DRAINING = 1,
	SAS_HA_ATA_EH_ACTIVE = 2,
	SAS_HA_FROZEN = 3,
	SAS_HA_RESUMING = 4,
};

enum sas_internal_abort {
	SAS_INTERNAL_ABORT_SINGLE = 0,
	SAS_INTERNAL_ABORT_DEV = 1,
};

enum sas_linkrate {
	SAS_LINK_RATE_UNKNOWN = 0,
	SAS_PHY_DISABLED = 1,
	SAS_PHY_RESET_PROBLEM = 2,
	SAS_SATA_SPINUP_HOLD = 3,
	SAS_SATA_PORT_SELECTOR = 4,
	SAS_PHY_RESET_IN_PROGRESS = 5,
	SAS_LINK_RATE_1_5_GBPS = 8,
	SAS_LINK_RATE_G1 = 8,
	SAS_LINK_RATE_3_0_GBPS = 9,
	SAS_LINK_RATE_G2 = 9,
	SAS_LINK_RATE_6_0_GBPS = 10,
	SAS_LINK_RATE_12_0_GBPS = 11,
	SAS_LINK_RATE_22_5_GBPS = 12,
	SAS_LINK_RATE_FAILED = 16,
	SAS_PHY_VIRTUAL = 17,
};

enum sas_oob_mode {
	OOB_NOT_CONNECTED = 0,
	SATA_OOB_MODE = 1,
	SAS_OOB_MODE = 2,
};

enum sas_open_rej_reason {
	SAS_OREJ_UNKNOWN = 0,
	SAS_OREJ_BAD_DEST = 1,
	SAS_OREJ_CONN_RATE = 2,
	SAS_OREJ_EPROTO = 3,
	SAS_OREJ_RESV_AB0 = 4,
	SAS_OREJ_RESV_AB1 = 5,
	SAS_OREJ_RESV_AB2 = 6,
	SAS_OREJ_RESV_AB3 = 7,
	SAS_OREJ_WRONG_DEST = 8,
	SAS_OREJ_STP_NORES = 9,
	SAS_OREJ_NO_DEST = 10,
	SAS_OREJ_PATH_BLOCKED = 11,
	SAS_OREJ_RSVD_CONT0 = 12,
	SAS_OREJ_RSVD_CONT1 = 13,
	SAS_OREJ_RSVD_INIT0 = 14,
	SAS_OREJ_RSVD_INIT1 = 15,
	SAS_OREJ_RSVD_STOP0 = 16,
	SAS_OREJ_RSVD_STOP1 = 17,
	SAS_OREJ_RSVD_RETRY = 18,
};

enum sas_phy_role {
	PHY_ROLE_NONE = 0,
	PHY_ROLE_TARGET = 64,
	PHY_ROLE_INITIATOR = 128,
};

enum sas_protocol {
	SAS_PROTOCOL_NONE = 0,
	SAS_PROTOCOL_SATA = 1,
	SAS_PROTOCOL_SMP = 2,
	SAS_PROTOCOL_STP = 4,
	SAS_PROTOCOL_SSP = 8,
	SAS_PROTOCOL_ALL = 14,
	SAS_PROTOCOL_STP_ALL = 5,
	SAS_PROTOCOL_INTERNAL_ABORT = 16,
};

enum sas_sata_config_port_regs {
	PHYR_IDENTIFY = 0,
	PHYR_ADDR_LO = 4,
	PHYR_ADDR_HI = 8,
	PHYR_ATT_DEV_INFO = 12,
	PHYR_ATT_ADDR_LO = 16,
	PHYR_ATT_ADDR_HI = 20,
	PHYR_SATA_CTL = 24,
	PHYR_PHY_STAT = 28,
	PHYR_SATA_SIG0 = 32,
	PHYR_SATA_SIG1 = 36,
	PHYR_SATA_SIG2 = 40,
	PHYR_SATA_SIG3 = 44,
	PHYR_R_ERR_COUNT = 48,
	PHYR_CRC_ERR_COUNT = 52,
	PHYR_WIDE_PORT = 56,
	PHYR_CURRENT0 = 128,
	PHYR_CURRENT1 = 132,
	PHYR_CURRENT2 = 136,
	CONFIG_ID_FRAME0 = 256,
	CONFIG_ID_FRAME1 = 260,
	CONFIG_ID_FRAME2 = 264,
	CONFIG_ID_FRAME3 = 268,
	CONFIG_ID_FRAME4 = 272,
	CONFIG_ID_FRAME5 = 276,
	CONFIG_ID_FRAME6 = 280,
	CONFIG_ATT_ID_FRAME0 = 284,
	CONFIG_ATT_ID_FRAME1 = 288,
	CONFIG_ATT_ID_FRAME2 = 292,
	CONFIG_ATT_ID_FRAME3 = 296,
	CONFIG_ATT_ID_FRAME4 = 300,
	CONFIG_ATT_ID_FRAME5 = 304,
	CONFIG_ATT_ID_FRAME6 = 308,
};

enum sas_sata_phy_regs {
	GENERATION_1_SETTING = 280,
	GENERATION_1_2_SETTING = 284,
	GENERATION_2_3_SETTING = 288,
	GENERATION_3_4_SETTING = 292,
};

enum sas_sata_vsp_regs {
	VSR_PHY_STAT = 0,
	VSR_PHY_MODE1 = 1,
	VSR_PHY_MODE2 = 2,
	VSR_PHY_MODE3 = 3,
	VSR_PHY_MODE4 = 4,
	VSR_PHY_MODE5 = 5,
	VSR_PHY_MODE6 = 6,
	VSR_PHY_MODE7 = 7,
	VSR_PHY_MODE8 = 8,
	VSR_PHY_MODE9 = 9,
	VSR_PHY_MODE10 = 10,
	VSR_PHY_MODE11 = 11,
	VSR_PHY_VS0 = 12,
	VSR_PHY_VS1 = 13,
};

enum sas_sata_vsp_regs___2 {
	VSR_PHY_STAT___2 = 0,
	VSR_PHY_MODE1___2 = 4,
	VSR_PHY_MODE2___2 = 8,
	VSR_PHY_MODE3___2 = 12,
	VSR_PHY_MODE4___2 = 16,
	VSR_PHY_MODE5___2 = 20,
	VSR_PHY_MODE6___2 = 24,
	VSR_PHY_MODE7___2 = 28,
	VSR_PHY_MODE8___2 = 32,
	VSR_PHY_MODE9___2 = 36,
	VSR_PHY_MODE10___2 = 40,
	VSR_PHY_MODE11___2 = 44,
	VSR_PHY_ACT_LED = 48,
	VSR_PHY_FFE_CONTROL = 268,
	VSR_PHY_DFE_UPDATE_CRTL = 272,
	VSR_REF_CLOCK_CRTL = 416,
};

enum scan_balance {
	SCAN_EQUAL = 0,
	SCAN_FRACT = 1,
	SCAN_ANON = 2,
	SCAN_FILE = 3,
};

enum scan_result {
	SCAN_FAIL = 0,
	SCAN_SUCCEED = 1,
	SCAN_PMD_NULL = 2,
	SCAN_PMD_NONE = 3,
	SCAN_PMD_MAPPED = 4,
	SCAN_EXCEED_NONE_PTE = 5,
	SCAN_EXCEED_SWAP_PTE = 6,
	SCAN_EXCEED_SHARED_PTE = 7,
	SCAN_PTE_NON_PRESENT = 8,
	SCAN_PTE_UFFD_WP = 9,
	SCAN_PTE_MAPPED_HUGEPAGE = 10,
	SCAN_PAGE_RO = 11,
	SCAN_LACK_REFERENCED_PAGE = 12,
	SCAN_PAGE_NULL = 13,
	SCAN_SCAN_ABORT = 14,
	SCAN_PAGE_COUNT = 15,
	SCAN_PAGE_LRU = 16,
	SCAN_PAGE_LOCK = 17,
	SCAN_PAGE_ANON = 18,
	SCAN_PAGE_COMPOUND = 19,
	SCAN_ANY_PROCESS = 20,
	SCAN_VMA_NULL = 21,
	SCAN_VMA_CHECK = 22,
	SCAN_ADDRESS_RANGE = 23,
	SCAN_DEL_PAGE_LRU = 24,
	SCAN_ALLOC_HUGE_PAGE_FAIL = 25,
	SCAN_CGROUP_CHARGE_FAIL = 26,
	SCAN_TRUNCATED = 27,
	SCAN_PAGE_HAS_PRIVATE = 28,
	SCAN_STORE_FAILED = 29,
	SCAN_COPY_MC = 30,
	SCAN_PAGE_FILLED = 31,
};

enum sched_tunable_scaling {
	SCHED_TUNABLESCALING_NONE = 0,
	SCHED_TUNABLESCALING_LOG = 1,
	SCHED_TUNABLESCALING_LINEAR = 2,
	SCHED_TUNABLESCALING_END = 3,
};

enum scrub_stripe_flags {
	SCRUB_STRIPE_FLAG_INITIALIZED = 0,
	SCRUB_STRIPE_FLAG_REPAIR_DONE = 1,
	SCRUB_STRIPE_FLAG_NO_REPORT = 2,
};

enum scsi_cmnd_submitter {
	SUBMITTED_BY_BLOCK_LAYER = 0,
	SUBMITTED_BY_SCSI_ERROR_HANDLER = 1,
	SUBMITTED_BY_SCSI_RESET_IOCTL = 2,
} __attribute__((mode(byte)));

enum scsi_code_set {
	PS_CODE_SET_BINARY = 1,
	PS_CODE_SET_ASCII = 2,
	PS_CODE_SET_UTF8 = 3,
};

enum scsi_designator_type {
	PS_DESIGNATOR_T10 = 1,
	PS_DESIGNATOR_EUI64 = 2,
	PS_DESIGNATOR_NAA = 3,
	PS_DESIGNATOR_NAME = 8,
};

enum scsi_device_event {
	SDEV_EVT_MEDIA_CHANGE = 1,
	SDEV_EVT_INQUIRY_CHANGE_REPORTED = 2,
	SDEV_EVT_CAPACITY_CHANGE_REPORTED = 3,
	SDEV_EVT_SOFT_THRESHOLD_REACHED_REPORTED = 4,
	SDEV_EVT_MODE_PARAMETER_CHANGE_REPORTED = 5,
	SDEV_EVT_LUN_CHANGE_REPORTED = 6,
	SDEV_EVT_ALUA_STATE_CHANGE_REPORTED = 7,
	SDEV_EVT_POWER_ON_RESET_OCCURRED = 8,
	SDEV_EVT_FIRST = 1,
	SDEV_EVT_LAST = 8,
	SDEV_EVT_MAXBITS = 9,
};

enum scsi_device_state {
	SDEV_CREATED = 1,
	SDEV_RUNNING = 2,
	SDEV_CANCEL = 3,
	SDEV_DEL = 4,
	SDEV_QUIESCE = 5,
	SDEV_OFFLINE = 6,
	SDEV_TRANSPORT_OFFLINE = 7,
	SDEV_BLOCK = 8,
	SDEV_CREATED_BLOCK = 9,
};

enum scsi_devinfo_key {
	SCSI_DEVINFO_GLOBAL = 0,
	SCSI_DEVINFO_SPI = 1,
};

enum scsi_disposition {
	NEEDS_RETRY = 8193,
	SUCCESS = 8194,
	FAILED = 8195,
	QUEUED = 8196,
	SOFT_ERROR = 8197,
	ADD_TO_MLQUEUE = 8198,
	TIMEOUT_ERROR = 8199,
	SCSI_RETURN_NOT_HANDLED = 8200,
	FAST_IO_FAIL = 8201,
};

enum scsi_host_guard_type {
	SHOST_DIX_GUARD_CRC = 1,
	SHOST_DIX_GUARD_IP = 2,
};

enum scsi_host_prot_capabilities {
	SHOST_DIF_TYPE1_PROTECTION = 1,
	SHOST_DIF_TYPE2_PROTECTION = 2,
	SHOST_DIF_TYPE3_PROTECTION = 4,
	SHOST_DIX_TYPE0_PROTECTION = 8,
	SHOST_DIX_TYPE1_PROTECTION = 16,
	SHOST_DIX_TYPE2_PROTECTION = 32,
	SHOST_DIX_TYPE3_PROTECTION = 64,
};

enum scsi_host_state {
	SHOST_CREATED = 1,
	SHOST_RUNNING = 2,
	SHOST_CANCEL = 3,
	SHOST_DEL = 4,
	SHOST_RECOVERY = 5,
	SHOST_CANCEL_RECOVERY = 6,
	SHOST_DEL_RECOVERY = 7,
};

enum scsi_host_status {
	DID_OK = 0,
	DID_NO_CONNECT = 1,
	DID_BUS_BUSY = 2,
	DID_TIME_OUT = 3,
	DID_BAD_TARGET = 4,
	DID_ABORT = 5,
	DID_PARITY = 6,
	DID_ERROR = 7,
	DID_RESET = 8,
	DID_BAD_INTR = 9,
	DID_PASSTHROUGH = 10,
	DID_SOFT_ERROR = 11,
	DID_IMM_RETRY = 12,
	DID_REQUEUE = 13,
	DID_TRANSPORT_DISRUPTED = 14,
	DID_TRANSPORT_FAILFAST = 15,
	DID_TRANSPORT_MARGINAL = 20,
};

enum scsi_ml_status {
	SCSIML_STAT_OK = 0,
	SCSIML_STAT_RESV_CONFLICT = 1,
	SCSIML_STAT_NOSPC = 2,
	SCSIML_STAT_MED_ERROR = 3,
	SCSIML_STAT_TGT_FAILURE = 4,
	SCSIML_STAT_DL_TIMEOUT = 5,
};

enum scsi_msg_byte {
	COMMAND_COMPLETE = 0,
	EXTENDED_MESSAGE = 1,
	SAVE_POINTERS = 2,
	RESTORE_POINTERS = 3,
	DISCONNECT = 4,
	INITIATOR_ERROR = 5,
	ABORT_TASK_SET = 6,
	MESSAGE_REJECT = 7,
	NOP = 8,
	MSG_PARITY_ERROR = 9,
	LINKED_CMD_COMPLETE = 10,
	LINKED_FLG_CMD_COMPLETE = 11,
	TARGET_RESET = 12,
	ABORT_TASK = 13,
	CLEAR_TASK_SET = 14,
	INITIATE_RECOVERY = 15,
	RELEASE_RECOVERY = 16,
	TERMINATE_IO_PROC = 17,
	CLEAR_ACA = 22,
	LOGICAL_UNIT_RESET = 23,
	SIMPLE_QUEUE_TAG = 32,
	HEAD_OF_QUEUE_TAG = 33,
	ORDERED_QUEUE_TAG = 34,
	IGNORE_WIDE_RESIDUE = 35,
	ACA = 36,
	QAS_REQUEST = 85,
	BUS_DEVICE_RESET = 12,
	ABORT = 6,
};

enum scsi_pr_type {
	SCSI_PR_WRITE_EXCLUSIVE = 1,
	SCSI_PR_EXCLUSIVE_ACCESS = 3,
	SCSI_PR_WRITE_EXCLUSIVE_REG_ONLY = 5,
	SCSI_PR_EXCLUSIVE_ACCESS_REG_ONLY = 6,
	SCSI_PR_WRITE_EXCLUSIVE_ALL_REGS = 7,
	SCSI_PR_EXCLUSIVE_ACCESS_ALL_REGS = 8,
};

enum scsi_prot_flags {
	SCSI_PROT_TRANSFER_PI = 1,
	SCSI_PROT_GUARD_CHECK = 2,
	SCSI_PROT_REF_CHECK = 4,
	SCSI_PROT_REF_INCREMENT = 8,
	SCSI_PROT_IP_CHECKSUM = 16,
};

enum scsi_prot_operations {
	SCSI_PROT_NORMAL = 0,
	SCSI_PROT_READ_INSERT = 1,
	SCSI_PROT_WRITE_STRIP = 2,
	SCSI_PROT_READ_STRIP = 3,
	SCSI_PROT_WRITE_INSERT = 4,
	SCSI_PROT_READ_PASS = 5,
	SCSI_PROT_WRITE_PASS = 6,
};

enum scsi_scan_mode {
	SCSI_SCAN_INITIAL = 0,
	SCSI_SCAN_RESCAN = 1,
	SCSI_SCAN_MANUAL = 2,
};

enum scsi_target_state {
	STARGET_CREATED = 1,
	STARGET_RUNNING = 2,
	STARGET_REMOVE = 3,
	STARGET_CREATED_REMOVE = 4,
	STARGET_DEL = 5,
};

enum scsi_timeout_action {
	SCSI_EH_DONE = 0,
	SCSI_EH_RESET_TIMER = 1,
	SCSI_EH_NOT_HANDLED = 2,
};

enum scsi_timeouts {
	SCSI_DEFAULT_EH_TIMEOUT = 2500,
};

enum scsi_vpd_parameters {
	SCSI_VPD_HEADER_SIZE = 4,
	SCSI_VPD_LIST_SIZE = 36,
};

enum sctp_cid {
	SCTP_CID_DATA = 0,
	SCTP_CID_INIT = 1,
	SCTP_CID_INIT_ACK = 2,
	SCTP_CID_SACK = 3,
	SCTP_CID_HEARTBEAT = 4,
	SCTP_CID_HEARTBEAT_ACK = 5,
	SCTP_CID_ABORT = 6,
	SCTP_CID_SHUTDOWN = 7,
	SCTP_CID_SHUTDOWN_ACK = 8,
	SCTP_CID_ERROR = 9,
	SCTP_CID_COOKIE_ECHO = 10,
	SCTP_CID_COOKIE_ACK = 11,
	SCTP_CID_ECN_ECNE = 12,
	SCTP_CID_ECN_CWR = 13,
	SCTP_CID_SHUTDOWN_COMPLETE = 14,
	SCTP_CID_AUTH = 15,
	SCTP_CID_I_DATA = 64,
	SCTP_CID_FWD_TSN = 192,
	SCTP_CID_ASCONF = 193,
	SCTP_CID_I_FWD_TSN = 194,
	SCTP_CID_ASCONF_ACK = 128,
	SCTP_CID_RECONF = 130,
	SCTP_CID_PAD = 132,
};

enum sctp_conntrack {
	SCTP_CONNTRACK_NONE = 0,
	SCTP_CONNTRACK_CLOSED = 1,
	SCTP_CONNTRACK_COOKIE_WAIT = 2,
	SCTP_CONNTRACK_COOKIE_ECHOED = 3,
	SCTP_CONNTRACK_ESTABLISHED = 4,
	SCTP_CONNTRACK_SHUTDOWN_SENT = 5,
	SCTP_CONNTRACK_SHUTDOWN_RECD = 6,
	SCTP_CONNTRACK_SHUTDOWN_ACK_SENT = 7,
	SCTP_CONNTRACK_HEARTBEAT_SENT = 8,
	SCTP_CONNTRACK_HEARTBEAT_ACKED = 9,
	SCTP_CONNTRACK_MAX = 10,
};

enum sctp_endpoint_type {
	SCTP_EP_TYPE_SOCKET = 0,
	SCTP_EP_TYPE_ASSOCIATION = 1,
};

enum sctp_event_timeout {
	SCTP_EVENT_TIMEOUT_NONE = 0,
	SCTP_EVENT_TIMEOUT_T1_COOKIE = 1,
	SCTP_EVENT_TIMEOUT_T1_INIT = 2,
	SCTP_EVENT_TIMEOUT_T2_SHUTDOWN = 3,
	SCTP_EVENT_TIMEOUT_T3_RTX = 4,
	SCTP_EVENT_TIMEOUT_T4_RTO = 5,
	SCTP_EVENT_TIMEOUT_T5_SHUTDOWN_GUARD = 6,
	SCTP_EVENT_TIMEOUT_HEARTBEAT = 7,
	SCTP_EVENT_TIMEOUT_RECONF = 8,
	SCTP_EVENT_TIMEOUT_PROBE = 9,
	SCTP_EVENT_TIMEOUT_SACK = 10,
	SCTP_EVENT_TIMEOUT_AUTOCLOSE = 11,
};

enum sctp_msg_flags {
	MSG_NOTIFICATION = 32768,
};

enum sctp_param {
	SCTP_PARAM_HEARTBEAT_INFO = 256,
	SCTP_PARAM_IPV4_ADDRESS = 1280,
	SCTP_PARAM_IPV6_ADDRESS = 1536,
	SCTP_PARAM_STATE_COOKIE = 1792,
	SCTP_PARAM_UNRECOGNIZED_PARAMETERS = 2048,
	SCTP_PARAM_COOKIE_PRESERVATIVE = 2304,
	SCTP_PARAM_HOST_NAME_ADDRESS = 2816,
	SCTP_PARAM_SUPPORTED_ADDRESS_TYPES = 3072,
	SCTP_PARAM_ECN_CAPABLE = 128,
	SCTP_PARAM_RANDOM = 640,
	SCTP_PARAM_CHUNKS = 896,
	SCTP_PARAM_HMAC_ALGO = 1152,
	SCTP_PARAM_SUPPORTED_EXT = 2176,
	SCTP_PARAM_FWD_TSN_SUPPORT = 192,
	SCTP_PARAM_ADD_IP = 448,
	SCTP_PARAM_DEL_IP = 704,
	SCTP_PARAM_ERR_CAUSE = 960,
	SCTP_PARAM_SET_PRIMARY = 1216,
	SCTP_PARAM_SUCCESS_REPORT = 1472,
	SCTP_PARAM_ADAPTATION_LAYER_IND = 1728,
	SCTP_PARAM_RESET_OUT_REQUEST = 3328,
	SCTP_PARAM_RESET_IN_REQUEST = 3584,
	SCTP_PARAM_RESET_TSN_REQUEST = 3840,
	SCTP_PARAM_RESET_RESPONSE = 4096,
	SCTP_PARAM_RESET_ADD_OUT_STREAMS = 4352,
	SCTP_PARAM_RESET_ADD_IN_STREAMS = 4608,
};

enum sctp_scope {
	SCTP_SCOPE_GLOBAL = 0,
	SCTP_SCOPE_PRIVATE = 1,
	SCTP_SCOPE_LINK = 2,
	SCTP_SCOPE_LOOPBACK = 3,
	SCTP_SCOPE_UNUSABLE = 4,
};

enum sctp_socket_type {
	SCTP_SOCKET_UDP = 0,
	SCTP_SOCKET_UDP_HIGH_BANDWIDTH = 1,
	SCTP_SOCKET_TCP = 2,
};

enum sctp_state {
	SCTP_STATE_CLOSED = 0,
	SCTP_STATE_COOKIE_WAIT = 1,
	SCTP_STATE_COOKIE_ECHOED = 2,
	SCTP_STATE_ESTABLISHED = 3,
	SCTP_STATE_SHUTDOWN_PENDING = 4,
	SCTP_STATE_SHUTDOWN_SENT = 5,
	SCTP_STATE_SHUTDOWN_RECEIVED = 6,
	SCTP_STATE_SHUTDOWN_ACK_SENT = 7,
};

enum sel_inos {
	SEL_ROOT_INO = 2,
	SEL_LOAD = 3,
	SEL_ENFORCE = 4,
	SEL_CONTEXT = 5,
	SEL_ACCESS = 6,
	SEL_CREATE = 7,
	SEL_RELABEL = 8,
	SEL_USER = 9,
	SEL_POLICYVERS = 10,
	SEL_COMMIT_BOOLS = 11,
	SEL_MLS = 12,
	SEL_DISABLE = 13,
	SEL_MEMBER = 14,
	SEL_CHECKREQPROT = 15,
	SEL_COMPAT_NET = 16,
	SEL_REJECT_UNKNOWN = 17,
	SEL_DENY_UNKNOWN = 18,
	SEL_STATUS = 19,
	SEL_POLICY = 20,
	SEL_VALIDATE_TRANS = 21,
	SEL_INO_NEXT = 22,
};

enum selinux_nlgroups {
	SELNLGRP_NONE = 0,
	SELNLGRP_AVC = 1,
	__SELNLGRP_MAX = 2,
};

enum serio_event_type {
	SERIO_RESCAN_PORT = 0,
	SERIO_RECONNECT_PORT = 1,
	SERIO_RECONNECT_SUBTREE = 2,
	SERIO_REGISTER_PORT = 3,
	SERIO_ATTACH_DRIVER = 4,
};

enum service_response {
	SAS_TASK_COMPLETE = 0,
	SAS_TASK_UNDELIVERED = -1,
};

enum set_event_iter_type {
	SET_EVENT_FILE = 0,
	SET_EVENT_MOD = 1,
};

enum sgp_type {
	SGP_READ = 0,
	SGP_NOALLOC = 1,
	SGP_CACHE = 2,
	SGP_WRITE = 3,
	SGP_FALLOC = 4,
};

enum sgpio_led_status {
	LED_OFF___2 = 0,
	LED_ON___2 = 1,
	LED_BLINKA = 2,
	LED_BLINKA_INV = 3,
	LED_BLINKA_SOF = 4,
	LED_BLINKA_EOF = 5,
	LED_BLINKB = 6,
	LED_BLINKB_INV = 7,
};

enum sgpio_registers {
	MVS_SGPIO_HOST_OFFSET = 256,
	MVS_SGPIO_CFG0 = 49664,
	MVS_SGPIO_CFG0_ENABLE = 1,
	MVS_SGPIO_CFG0_BLINKB = 2,
	MVS_SGPIO_CFG0_BLINKA = 4,
	MVS_SGPIO_CFG0_INVSCLK = 8,
	MVS_SGPIO_CFG0_INVSLOAD = 16,
	MVS_SGPIO_CFG0_INVSDOUT = 32,
	MVS_SGPIO_CFG0_SLOAD_FALLEDGE = 64,
	MVS_SGPIO_CFG0_SDOUT_FALLEDGE = 128,
	MVS_SGPIO_CFG0_SDIN_RISEEDGE = 256,
	MVS_SGPIO_CFG0_MAN_BITLEN_SHIFT = 18,
	MVS_SGPIO_CFG0_AUT_BITLEN_SHIFT = 24,
	MVS_SGPIO_CFG1 = 49668,
	MVS_SGPIO_CFG1_LOWA_SHIFT = 0,
	MVS_SGPIO_CFG1_HIA_SHIFT = 4,
	MVS_SGPIO_CFG1_LOWB_SHIFT = 8,
	MVS_SGPIO_CFG1_HIB_SHIFT = 12,
	MVS_SGPIO_CFG1_MAXACTON_SHIFT = 16,
	MVS_SGPIO_CFG1_FORCEACTOFF_SHIFT = 20,
	MVS_SGPIO_CFG1_STRCHACTON_SHIFT = 24,
	MVS_SGPIO_CFG1_STRCHACTOFF_SHIFT = 28,
	MVS_SGPIO_CFG2 = 49672,
	MVS_SGPIO_CFG2_CLK_SHIFT = 0,
	MVS_SGPIO_CFG2_BLINK_SHIFT = 20,
	MVS_SGPIO_CTRL = 49676,
	MVS_SGPIO_CTRL_SDOUT_AUTO = 2,
	MVS_SGPIO_CTRL_SDOUT_SHIFT = 2,
	MVS_SGPIO_DSRC = 49696,
	MVS_SGPIO_DCTRL = 49720,
	MVS_SGPIO_DCTRL_ERR_SHIFT = 0,
	MVS_SGPIO_DCTRL_LOC_SHIFT = 3,
	MVS_SGPIO_DCTRL_ACT_SHIFT = 5,
};

enum shmem_param {
	Opt_gid___9 = 0,
	Opt_huge = 1,
	Opt_mode___7 = 2,
	Opt_mpol = 3,
	Opt_nr_blocks = 4,
	Opt_nr_inodes___2 = 5,
	Opt_size___2 = 6,
	Opt_uid___8 = 7,
	Opt_inode32___2 = 8,
	Opt_inode64___2 = 9,
	Opt_noswap = 10,
	Opt_quota___4 = 11,
	Opt_usrquota___4 = 12,
	Opt_grpquota___4 = 13,
	Opt_usrquota_block_hardlimit = 14,
	Opt_usrquota_inode_hardlimit = 15,
	Opt_grpquota_block_hardlimit = 16,
	Opt_grpquota_inode_hardlimit = 17,
	Opt_casefold_version = 18,
	Opt_casefold = 19,
	Opt_strict_encoding = 20,
};

enum si_type {
	SI_TYPE_INVALID = 0,
	SI_KCS = 1,
	SI_SMIC = 2,
	SI_BT = 3,
	SI_TYPE_MAX = 4,
};

enum sig_handler {
	HANDLER_CURRENT = 0,
	HANDLER_SIG_DFL = 1,
	HANDLER_EXIT = 2,
};

enum siginfo_layout {
	SIL_KILL = 0,
	SIL_TIMER = 1,
	SIL_POLL = 2,
	SIL_FAULT = 3,
	SIL_FAULT_TRAPNO = 4,
	SIL_FAULT_MCEERR = 5,
	SIL_FAULT_BNDERR = 6,
	SIL_FAULT_PKUERR = 7,
	SIL_FAULT_PERF_EVENT = 8,
	SIL_CHLD = 9,
	SIL_RT = 10,
	SIL_SYS = 11,
};

enum sk_action {
	SK_DROP = 0,
	SK_PASS = 1,
};

enum sk_pacing {
	SK_PACING_NONE = 0,
	SK_PACING_NEEDED = 1,
	SK_PACING_FQ = 2,
};

enum sk_psock_state_bits {
	SK_PSOCK_TX_ENABLED = 0,
	SK_PSOCK_RX_STRP_ENABLED = 1,
};

enum sk_rst_reason {
	SK_RST_REASON_NOT_SPECIFIED = 0,
	SK_RST_REASON_NO_SOCKET = 1,
	SK_RST_REASON_TCP_INVALID_ACK_SEQUENCE = 2,
	SK_RST_REASON_TCP_RFC7323_PAWS = 3,
	SK_RST_REASON_TCP_TOO_OLD_ACK = 4,
	SK_RST_REASON_TCP_ACK_UNSENT_DATA = 5,
	SK_RST_REASON_TCP_FLAGS = 6,
	SK_RST_REASON_TCP_OLD_ACK = 7,
	SK_RST_REASON_TCP_ABORT_ON_DATA = 8,
	SK_RST_REASON_TCP_TIMEWAIT_SOCKET = 9,
	SK_RST_REASON_INVALID_SYN = 10,
	SK_RST_REASON_TCP_ABORT_ON_CLOSE = 11,
	SK_RST_REASON_TCP_ABORT_ON_LINGER = 12,
	SK_RST_REASON_TCP_ABORT_ON_MEMORY = 13,
	SK_RST_REASON_TCP_STATE = 14,
	SK_RST_REASON_TCP_KEEPALIVE_TIMEOUT = 15,
	SK_RST_REASON_TCP_DISCONNECT_WITH_DATA = 16,
	SK_RST_REASON_MPTCP_RST_EUNSPEC = 17,
	SK_RST_REASON_MPTCP_RST_EMPTCP = 18,
	SK_RST_REASON_MPTCP_RST_ERESOURCE = 19,
	SK_RST_REASON_MPTCP_RST_EPROHIBIT = 20,
	SK_RST_REASON_MPTCP_RST_EWQ2BIG = 21,
	SK_RST_REASON_MPTCP_RST_EBADPERF = 22,
	SK_RST_REASON_MPTCP_RST_EMIDDLEBOX = 23,
	SK_RST_REASON_ERROR = 24,
	SK_RST_REASON_MAX = 25,
};

enum skb_drop_reason {
	SKB_NOT_DROPPED_YET = 0,
	SKB_CONSUMED = 1,
	SKB_DROP_REASON_NOT_SPECIFIED = 2,
	SKB_DROP_REASON_NO_SOCKET = 3,
	SKB_DROP_REASON_SOCKET_CLOSE = 4,
	SKB_DROP_REASON_SOCKET_FILTER = 5,
	SKB_DROP_REASON_SOCKET_RCVBUFF = 6,
	SKB_DROP_REASON_UNIX_DISCONNECT = 7,
	SKB_DROP_REASON_UNIX_SKIP_OOB = 8,
	SKB_DROP_REASON_PKT_TOO_SMALL = 9,
	SKB_DROP_REASON_TCP_CSUM = 10,
	SKB_DROP_REASON_UDP_CSUM = 11,
	SKB_DROP_REASON_NETFILTER_DROP = 12,
	SKB_DROP_REASON_OTHERHOST = 13,
	SKB_DROP_REASON_IP_CSUM = 14,
	SKB_DROP_REASON_IP_INHDR = 15,
	SKB_DROP_REASON_IP_RPFILTER = 16,
	SKB_DROP_REASON_UNICAST_IN_L2_MULTICAST = 17,
	SKB_DROP_REASON_XFRM_POLICY = 18,
	SKB_DROP_REASON_IP_NOPROTO = 19,
	SKB_DROP_REASON_PROTO_MEM = 20,
	SKB_DROP_REASON_TCP_AUTH_HDR = 21,
	SKB_DROP_REASON_TCP_MD5NOTFOUND = 22,
	SKB_DROP_REASON_TCP_MD5UNEXPECTED = 23,
	SKB_DROP_REASON_TCP_MD5FAILURE = 24,
	SKB_DROP_REASON_TCP_AONOTFOUND = 25,
	SKB_DROP_REASON_TCP_AOUNEXPECTED = 26,
	SKB_DROP_REASON_TCP_AOKEYNOTFOUND = 27,
	SKB_DROP_REASON_TCP_AOFAILURE = 28,
	SKB_DROP_REASON_SOCKET_BACKLOG = 29,
	SKB_DROP_REASON_TCP_FLAGS = 30,
	SKB_DROP_REASON_TCP_ABORT_ON_DATA = 31,
	SKB_DROP_REASON_TCP_ZEROWINDOW = 32,
	SKB_DROP_REASON_TCP_OLD_DATA = 33,
	SKB_DROP_REASON_TCP_OVERWINDOW = 34,
	SKB_DROP_REASON_TCP_OFOMERGE = 35,
	SKB_DROP_REASON_TCP_RFC7323_PAWS = 36,
	SKB_DROP_REASON_TCP_RFC7323_PAWS_ACK = 37,
	SKB_DROP_REASON_TCP_OLD_SEQUENCE = 38,
	SKB_DROP_REASON_TCP_INVALID_SEQUENCE = 39,
	SKB_DROP_REASON_TCP_INVALID_ACK_SEQUENCE = 40,
	SKB_DROP_REASON_TCP_RESET = 41,
	SKB_DROP_REASON_TCP_INVALID_SYN = 42,
	SKB_DROP_REASON_TCP_CLOSE = 43,
	SKB_DROP_REASON_TCP_FASTOPEN = 44,
	SKB_DROP_REASON_TCP_OLD_ACK = 45,
	SKB_DROP_REASON_TCP_TOO_OLD_ACK = 46,
	SKB_DROP_REASON_TCP_ACK_UNSENT_DATA = 47,
	SKB_DROP_REASON_TCP_OFO_QUEUE_PRUNE = 48,
	SKB_DROP_REASON_TCP_OFO_DROP = 49,
	SKB_DROP_REASON_IP_OUTNOROUTES = 50,
	SKB_DROP_REASON_BPF_CGROUP_EGRESS = 51,
	SKB_DROP_REASON_IPV6DISABLED = 52,
	SKB_DROP_REASON_NEIGH_CREATEFAIL = 53,
	SKB_DROP_REASON_NEIGH_FAILED = 54,
	SKB_DROP_REASON_NEIGH_QUEUEFULL = 55,
	SKB_DROP_REASON_NEIGH_DEAD = 56,
	SKB_DROP_REASON_TC_EGRESS = 57,
	SKB_DROP_REASON_SECURITY_HOOK = 58,
	SKB_DROP_REASON_QDISC_DROP = 59,
	SKB_DROP_REASON_QDISC_OVERLIMIT = 60,
	SKB_DROP_REASON_QDISC_CONGESTED = 61,
	SKB_DROP_REASON_CAKE_FLOOD = 62,
	SKB_DROP_REASON_FQ_BAND_LIMIT = 63,
	SKB_DROP_REASON_FQ_HORIZON_LIMIT = 64,
	SKB_DROP_REASON_FQ_FLOW_LIMIT = 65,
	SKB_DROP_REASON_CPU_BACKLOG = 66,
	SKB_DROP_REASON_XDP = 67,
	SKB_DROP_REASON_TC_INGRESS = 68,
	SKB_DROP_REASON_UNHANDLED_PROTO = 69,
	SKB_DROP_REASON_SKB_CSUM = 70,
	SKB_DROP_REASON_SKB_GSO_SEG = 71,
	SKB_DROP_REASON_SKB_UCOPY_FAULT = 72,
	SKB_DROP_REASON_DEV_HDR = 73,
	SKB_DROP_REASON_DEV_READY = 74,
	SKB_DROP_REASON_FULL_RING = 75,
	SKB_DROP_REASON_NOMEM = 76,
	SKB_DROP_REASON_HDR_TRUNC = 77,
	SKB_DROP_REASON_TAP_FILTER = 78,
	SKB_DROP_REASON_TAP_TXFILTER = 79,
	SKB_DROP_REASON_ICMP_CSUM = 80,
	SKB_DROP_REASON_INVALID_PROTO = 81,
	SKB_DROP_REASON_IP_INADDRERRORS = 82,
	SKB_DROP_REASON_IP_INNOROUTES = 83,
	SKB_DROP_REASON_IP_LOCAL_SOURCE = 84,
	SKB_DROP_REASON_IP_INVALID_SOURCE = 85,
	SKB_DROP_REASON_IP_LOCALNET = 86,
	SKB_DROP_REASON_IP_INVALID_DEST = 87,
	SKB_DROP_REASON_PKT_TOO_BIG = 88,
	SKB_DROP_REASON_DUP_FRAG = 89,
	SKB_DROP_REASON_FRAG_REASM_TIMEOUT = 90,
	SKB_DROP_REASON_FRAG_TOO_FAR = 91,
	SKB_DROP_REASON_TCP_MINTTL = 92,
	SKB_DROP_REASON_IPV6_BAD_EXTHDR = 93,
	SKB_DROP_REASON_IPV6_NDISC_FRAG = 94,
	SKB_DROP_REASON_IPV6_NDISC_HOP_LIMIT = 95,
	SKB_DROP_REASON_IPV6_NDISC_BAD_CODE = 96,
	SKB_DROP_REASON_IPV6_NDISC_BAD_OPTIONS = 97,
	SKB_DROP_REASON_IPV6_NDISC_NS_OTHERHOST = 98,
	SKB_DROP_REASON_QUEUE_PURGE = 99,
	SKB_DROP_REASON_TC_COOKIE_ERROR = 100,
	SKB_DROP_REASON_PACKET_SOCK_ERROR = 101,
	SKB_DROP_REASON_TC_CHAIN_NOTFOUND = 102,
	SKB_DROP_REASON_TC_RECLASSIFY_LOOP = 103,
	SKB_DROP_REASON_VXLAN_INVALID_HDR = 104,
	SKB_DROP_REASON_VXLAN_VNI_NOT_FOUND = 105,
	SKB_DROP_REASON_MAC_INVALID_SOURCE = 106,
	SKB_DROP_REASON_VXLAN_ENTRY_EXISTS = 107,
	SKB_DROP_REASON_NO_TX_TARGET = 108,
	SKB_DROP_REASON_IP_TUNNEL_ECN = 109,
	SKB_DROP_REASON_TUNNEL_TXINFO = 110,
	SKB_DROP_REASON_LOCAL_MAC = 111,
	SKB_DROP_REASON_ARP_PVLAN_DISABLE = 112,
	SKB_DROP_REASON_MAC_IEEE_MAC_CONTROL = 113,
	SKB_DROP_REASON_BRIDGE_INGRESS_STP_STATE = 114,
	SKB_DROP_REASON_MAX = 115,
	SKB_DROP_REASON_SUBSYS_MASK = 4294901760,
};

enum skb_drop_reason_subsys {
	SKB_DROP_REASON_SUBSYS_CORE = 0,
	SKB_DROP_REASON_SUBSYS_MAC80211_UNUSABLE = 1,
	SKB_DROP_REASON_SUBSYS_MAC80211_MONITOR = 2,
	SKB_DROP_REASON_SUBSYS_OPENVSWITCH = 3,
	SKB_DROP_REASON_SUBSYS_NUM = 4,
};

enum skb_ext_id {
	SKB_EXT_BRIDGE_NF = 0,
	SKB_EXT_SEC_PATH = 1,
	SKB_EXT_MPTCP = 2,
	SKB_EXT_NUM = 3,
};

enum skb_tstamp_type {
	SKB_CLOCK_REALTIME = 0,
	SKB_CLOCK_MONOTONIC = 1,
	SKB_CLOCK_TAI = 2,
	__SKB_CLOCK_MAX = 2,
};

enum sknetlink_groups {
	SKNLGRP_NONE = 0,
	SKNLGRP_INET_TCP_DESTROY = 1,
	SKNLGRP_INET_UDP_DESTROY = 2,
	SKNLGRP_INET6_TCP_DESTROY = 3,
	SKNLGRP_INET6_UDP_DESTROY = 4,
	__SKNLGRP_MAX = 5,
};

enum slab_stat_type {
	SL_ALL = 0,
	SL_PARTIAL = 1,
	SL_CPU = 2,
	SL_OBJECTS = 3,
	SL_TOTAL = 4,
};

enum slab_state {
	DOWN___2 = 0,
	PARTIAL = 1,
	UP___2 = 2,
	FULL = 3,
};

enum smbios_attr_enum {
	SMBIOS_ATTR_NONE = 0,
	SMBIOS_ATTR_LABEL_SHOW = 1,
	SMBIOS_ATTR_INSTANCE_SHOW = 2,
};

enum snd_compr_direction {
	SND_COMPRESS_PLAYBACK = 0,
	SND_COMPRESS_CAPTURE = 1,
	SND_COMPRESS_ACCEL = 2,
};

enum snd_ctl_add_mode {
	CTL_ADD_EXCLUSIVE = 0,
	CTL_REPLACE = 1,
	CTL_ADD_ON_REPLACE = 2,
};

enum snd_ctl_led_mode {
	MODE_FOLLOW_MUTE = 0,
	MODE_FOLLOW_ROUTE = 1,
	MODE_OFF = 2,
	MODE_ON = 3,
};

enum snd_device_state {
	SNDRV_DEV_BUILD = 0,
	SNDRV_DEV_REGISTERED = 1,
	SNDRV_DEV_DISCONNECTED = 2,
};

enum snd_device_type {
	SNDRV_DEV_LOWLEVEL = 0,
	SNDRV_DEV_INFO = 1,
	SNDRV_DEV_BUS = 2,
	SNDRV_DEV_CODEC = 3,
	SNDRV_DEV_PCM = 4,
	SNDRV_DEV_COMPRESS = 5,
	SNDRV_DEV_RAWMIDI = 6,
	SNDRV_DEV_TIMER = 7,
	SNDRV_DEV_SEQUENCER = 8,
	SNDRV_DEV_HWDEP = 9,
	SNDRV_DEV_JACK = 10,
	SNDRV_DEV_CONTROL = 11,
};

enum snd_dma_sync_mode {
	SNDRV_DMA_SYNC_CPU = 0,
	SNDRV_DMA_SYNC_DEVICE = 1,
};

enum snd_jack_types {
	SND_JACK_HEADPHONE = 1,
	SND_JACK_MICROPHONE = 2,
	SND_JACK_HEADSET = 3,
	SND_JACK_LINEOUT = 4,
	SND_JACK_MECHANICAL = 8,
	SND_JACK_VIDEOOUT = 16,
	SND_JACK_AVOUT = 20,
	SND_JACK_LINEIN = 32,
	SND_JACK_BTN_0 = 16384,
	SND_JACK_BTN_1 = 8192,
	SND_JACK_BTN_2 = 4096,
	SND_JACK_BTN_3 = 2048,
	SND_JACK_BTN_4 = 1024,
	SND_JACK_BTN_5 = 512,
};

enum sndrv_ctl_event_type {
	SNDRV_CTL_EVENT_ELEM = 0,
	SNDRV_CTL_EVENT_LAST = 0,
};

enum snoop_when {
	SUBMIT = 0,
	COMPLETE___2 = 1,
};

enum sock_flags {
	SOCK_DEAD = 0,
	SOCK_DONE = 1,
	SOCK_URGINLINE = 2,
	SOCK_KEEPOPEN = 3,
	SOCK_LINGER = 4,
	SOCK_DESTROY = 5,
	SOCK_BROADCAST = 6,
	SOCK_TIMESTAMP = 7,
	SOCK_ZAPPED = 8,
	SOCK_USE_WRITE_QUEUE = 9,
	SOCK_DBG = 10,
	SOCK_RCVTSTAMP = 11,
	SOCK_RCVTSTAMPNS = 12,
	SOCK_LOCALROUTE = 13,
	SOCK_MEMALLOC = 14,
	SOCK_TIMESTAMPING_RX_SOFTWARE = 15,
	SOCK_FASYNC = 16,
	SOCK_RXQ_OVFL = 17,
	SOCK_ZEROCOPY = 18,
	SOCK_WIFI_STATUS = 19,
	SOCK_NOFCS = 20,
	SOCK_FILTER_LOCKED = 21,
	SOCK_SELECT_ERR_QUEUE = 22,
	SOCK_RCU_FREE = 23,
	SOCK_TXTIME = 24,
	SOCK_XDP = 25,
	SOCK_TSTAMP_NEW = 26,
	SOCK_RCVMARK = 27,
	SOCK_RCVPRIORITY = 28,
};

enum sock_shutdown_cmd {
	SHUT_RD = 0,
	SHUT_WR = 1,
	SHUT_RDWR = 2,
};

enum sock_type {
	SOCK_STREAM = 1,
	SOCK_DGRAM = 2,
	SOCK_RAW = 3,
	SOCK_RDM = 4,
	SOCK_SEQPACKET = 5,
	SOCK_DCCP = 6,
	SOCK_PACKET = 10,
};

enum sp_media_type {
	sp_media_unknown = 0,
	sp_media_fiber = 1,
	sp_media_copper = 2,
	sp_media_backplane = 3,
};

enum special_kfunc_type {
	KF_bpf_obj_new_impl = 0,
	KF_bpf_obj_drop_impl = 1,
	KF_bpf_refcount_acquire_impl = 2,
	KF_bpf_list_push_front_impl = 3,
	KF_bpf_list_push_back_impl = 4,
	KF_bpf_list_pop_front = 5,
	KF_bpf_list_pop_back = 6,
	KF_bpf_cast_to_kern_ctx = 7,
	KF_bpf_rdonly_cast = 8,
	KF_bpf_rcu_read_lock = 9,
	KF_bpf_rcu_read_unlock = 10,
	KF_bpf_rbtree_remove = 11,
	KF_bpf_rbtree_add_impl = 12,
	KF_bpf_rbtree_first = 13,
	KF_bpf_dynptr_from_skb = 14,
	KF_bpf_dynptr_from_xdp = 15,
	KF_bpf_dynptr_slice = 16,
	KF_bpf_dynptr_slice_rdwr = 17,
	KF_bpf_dynptr_clone = 18,
	KF_bpf_percpu_obj_new_impl = 19,
	KF_bpf_percpu_obj_drop_impl = 20,
	KF_bpf_throw = 21,
	KF_bpf_wq_set_callback_impl = 22,
	KF_bpf_preempt_disable = 23,
	KF_bpf_preempt_enable = 24,
	KF_bpf_iter_css_task_new = 25,
	KF_bpf_session_cookie = 26,
	KF_bpf_get_kmem_cache = 27,
	KF_bpf_local_irq_save = 28,
	KF_bpf_local_irq_restore = 29,
	KF_bpf_iter_num_new = 30,
	KF_bpf_iter_num_next = 31,
	KF_bpf_iter_num_destroy = 32,
};

enum spi_mem_data_dir {
	SPI_MEM_NO_DATA = 0,
	SPI_MEM_DATA_IN = 1,
	SPI_MEM_DATA_OUT = 2,
};

enum squashfs_param {
	Opt_errors___2 = 0,
	Opt_threads = 1,
};

enum stack_type {
	STACK_TYPE_UNKNOWN = 0,
	STACK_TYPE_IRQ = 1,
	STACK_TYPE_TASK = 2,
};

enum stat_group {
	STAT_READ = 0,
	STAT_WRITE = 1,
	STAT_DISCARD = 2,
	STAT_FLUSH = 3,
	NR_STAT_GROUPS = 4,
};

enum stat_item {
	ALLOC_FASTPATH = 0,
	ALLOC_SLOWPATH = 1,
	FREE_FASTPATH = 2,
	FREE_SLOWPATH = 3,
	FREE_FROZEN = 4,
	FREE_ADD_PARTIAL = 5,
	FREE_REMOVE_PARTIAL = 6,
	ALLOC_FROM_PARTIAL = 7,
	ALLOC_SLAB = 8,
	ALLOC_REFILL = 9,
	ALLOC_NODE_MISMATCH = 10,
	FREE_SLAB = 11,
	CPUSLAB_FLUSH = 12,
	DEACTIVATE_FULL = 13,
	DEACTIVATE_EMPTY = 14,
	DEACTIVATE_TO_HEAD = 15,
	DEACTIVATE_TO_TAIL = 16,
	DEACTIVATE_REMOTE_FREES = 17,
	DEACTIVATE_BYPASS = 18,
	ORDER_FALLBACK = 19,
	CMPXCHG_DOUBLE_CPU_FAIL = 20,
	CMPXCHG_DOUBLE_FAIL = 21,
	CPU_PARTIAL_ALLOC = 22,
	CPU_PARTIAL_FREE = 23,
	CPU_PARTIAL_NODE = 24,
	CPU_PARTIAL_DRAIN = 25,
	NR_SLUB_STAT_ITEMS = 26,
};

enum state {
	Start = 0,
	Collect = 1,
	GotHeader = 2,
	SkipIt = 3,
	GotName = 4,
	CopyFile = 5,
	GotSymlink = 6,
	Reset = 7,
};

enum state_protect_how4 {
	SP4_NONE = 0,
	SP4_MACH_CRED = 1,
	SP4_SSV = 2,
};

enum status_buffer {
	SB_EIR_OFF = 0,
	SB_RFB_OFF = 8,
	SB_RFB_MAX = 1024,
};

enum stmmac_mpacket_type {
	MPACKET_VERIFY = 0,
	MPACKET_RESPONSE = 1,
};

enum stmmac_rfs_type {
	STMMAC_RFS_T_VLAN = 0,
	STMMAC_RFS_T_LLDP = 1,
	STMMAC_RFS_T_1588 = 2,
	STMMAC_RFS_T_MAX = 3,
};

enum stmmac_state {
	STMMAC_DOWN = 0,
	STMMAC_RESET_REQUESTED = 1,
	STMMAC_RESETING = 2,
	STMMAC_SERVICE_SCHED = 3,
};

enum stmmac_txbuf_type {
	STMMAC_TXBUF_T_SKB = 0,
	STMMAC_TXBUF_T_XDP_TX = 1,
	STMMAC_TXBUF_T_XDP_NDO = 2,
	STMMAC_TXBUF_T_XSK_TX = 3,
};

enum store_type {
	wr_invalid = 0,
	wr_new_root = 1,
	wr_store_root = 2,
	wr_exact_fit = 3,
	wr_spanning_store = 4,
	wr_split_store = 5,
	wr_rebalance = 6,
	wr_append = 7,
	wr_node_store = 8,
	wr_slot_store = 9,
};

enum strict_prio_type {
	prio_none = 0,
	prio_group = 1,
	prio_link = 2,
};

enum string_size_units {
	STRING_UNITS_10 = 0,
	STRING_UNITS_2 = 1,
	STRING_UNITS_MASK = 1,
	STRING_UNITS_NO_SPACE = 1073741824,
	STRING_UNITS_NO_BYTES = 2147483648,
};

enum stripetype4 {
	STRIPE_SPARSE = 1,
	STRIPE_DENSE = 2,
};

enum subpixel_order {
	SubPixelUnknown = 0,
	SubPixelHorizontalRGB = 1,
	SubPixelHorizontalBGR = 2,
	SubPixelVerticalRGB = 3,
	SubPixelVerticalBGR = 4,
	SubPixelNone = 5,
};

enum sum_check_bits {
	SUM_CHECK_P = 0,
	SUM_CHECK_Q = 1,
};

enum sum_check_flags {
	SUM_CHECK_P_RESULT = 1,
	SUM_CHECK_Q_RESULT = 2,
};

enum support_mode {
	ALLOW_LEGACY = 0,
	DENY_LEGACY = 1,
};

enum suspend_mode {
	PRESUSPEND = 0,
	PRESUSPEND_UNDO = 1,
	POSTSUSPEND = 2,
};

enum suspend_stat_step {
	SUSPEND_WORKING = 0,
	SUSPEND_FREEZE = 1,
	SUSPEND_PREPARE = 2,
	SUSPEND_SUSPEND = 3,
	SUSPEND_SUSPEND_LATE = 4,
	SUSPEND_SUSPEND_NOIRQ = 5,
	SUSPEND_RESUME_NOIRQ = 6,
	SUSPEND_RESUME_EARLY = 7,
	SUSPEND_RESUME = 8,
};

enum svc_auth_status {
	SVC_GARBAGE = 1,
	SVC_SYSERR = 2,
	SVC_VALID = 3,
	SVC_NEGATIVE = 4,
	SVC_OK = 5,
	SVC_DROP = 6,
	SVC_CLOSE = 7,
	SVC_DENIED = 8,
	SVC_PENDING = 9,
	SVC_COMPLETE = 10,
};

enum sw_activity {
	OFF = 0,
	BLINK_ON = 1,
	BLINK_OFF = 2,
};

enum swap_cluster_flags {
	CLUSTER_FLAG_NONE = 0,
	CLUSTER_FLAG_FREE = 1,
	CLUSTER_FLAG_NONFULL = 2,
	CLUSTER_FLAG_FRAG = 3,
	CLUSTER_FLAG_USABLE = 3,
	CLUSTER_FLAG_FULL = 4,
	CLUSTER_FLAG_DISCARD = 5,
	CLUSTER_FLAG_MAX = 6,
};

enum switch_power_state {
	DRM_SWITCH_POWER_ON = 0,
	DRM_SWITCH_POWER_OFF = 1,
	DRM_SWITCH_POWER_CHANGING = 2,
	DRM_SWITCH_POWER_DYNAMIC_OFF = 3,
};

enum switchdev_notifier_type {
	SWITCHDEV_FDB_ADD_TO_BRIDGE = 1,
	SWITCHDEV_FDB_DEL_TO_BRIDGE = 2,
	SWITCHDEV_FDB_ADD_TO_DEVICE = 3,
	SWITCHDEV_FDB_DEL_TO_DEVICE = 4,
	SWITCHDEV_FDB_OFFLOADED = 5,
	SWITCHDEV_FDB_FLUSH_TO_BRIDGE = 6,
	SWITCHDEV_PORT_OBJ_ADD = 7,
	SWITCHDEV_PORT_OBJ_DEL = 8,
	SWITCHDEV_PORT_ATTR_SET = 9,
	SWITCHDEV_VXLAN_FDB_ADD_TO_BRIDGE = 10,
	SWITCHDEV_VXLAN_FDB_DEL_TO_BRIDGE = 11,
	SWITCHDEV_VXLAN_FDB_ADD_TO_DEVICE = 12,
	SWITCHDEV_VXLAN_FDB_DEL_TO_DEVICE = 13,
	SWITCHDEV_VXLAN_FDB_OFFLOADED = 14,
	SWITCHDEV_BRPORT_OFFLOADED = 15,
	SWITCHDEV_BRPORT_UNOFFLOADED = 16,
	SWITCHDEV_BRPORT_REPLAY = 17,
};

enum synaptics_pkt_type {
	SYN_NEWABS = 0,
	SYN_NEWABS_STRICT = 1,
	SYN_NEWABS_RELAXED = 2,
	SYN_OLDABS = 3,
};

enum sys_off_mode {
	SYS_OFF_MODE_POWER_OFF_PREPARE = 0,
	SYS_OFF_MODE_POWER_OFF = 1,
	SYS_OFF_MODE_RESTART_PREPARE = 2,
	SYS_OFF_MODE_RESTART = 3,
};

enum syscall_work_bit {
	SYSCALL_WORK_BIT_SECCOMP = 0,
	SYSCALL_WORK_BIT_SYSCALL_TRACEPOINT = 1,
	SYSCALL_WORK_BIT_SYSCALL_TRACE = 2,
	SYSCALL_WORK_BIT_SYSCALL_EMU = 3,
	SYSCALL_WORK_BIT_SYSCALL_AUDIT = 4,
	SYSCALL_WORK_BIT_SYSCALL_USER_DISPATCH = 5,
	SYSCALL_WORK_BIT_SYSCALL_EXIT_TRAP = 6,
};

enum sysctl_writes_mode {
	SYSCTL_WRITES_LEGACY = -1,
	SYSCTL_WRITES_WARN = 0,
	SYSCTL_WRITES_STRICT = 1,
};

enum system_states {
	SYSTEM_BOOTING = 0,
	SYSTEM_SCHEDULING = 1,
	SYSTEM_FREEING_INITMEM = 2,
	SYSTEM_RUNNING = 3,
	SYSTEM_HALT = 4,
	SYSTEM_POWER_OFF = 5,
	SYSTEM_RESTART = 6,
	SYSTEM_SUSPEND = 7,
};

enum t10_dif_type {
	T10_PI_TYPE0_PROTECTION = 0,
	T10_PI_TYPE1_PROTECTION = 1,
	T10_PI_TYPE2_PROTECTION = 2,
	T10_PI_TYPE3_PROTECTION = 3,
};

enum task_attribute {
	TASK_ATTR_SIMPLE = 0,
	TASK_ATTR_HOQ = 1,
	TASK_ATTR_ORDERED = 2,
	TASK_ATTR_ACA = 4,
};

enum task_disposition {
	TASK_IS_DONE = 0,
	TASK_IS_ABORTED = 1,
	TASK_IS_AT_LU = 2,
	TASK_IS_NOT_AT_LU = 3,
	TASK_ABORT_FAILED = 4,
};

enum task_work_notify_mode {
	TWA_NONE = 0,
	TWA_RESUME = 1,
	TWA_SIGNAL = 2,
	TWA_SIGNAL_NO_IPI = 3,
	TWA_NMI_CURRENT = 4,
};

enum tb_cfg_error {
	TB_CFG_ERROR_PORT_NOT_CONNECTED = 0,
	TB_CFG_ERROR_LINK_ERROR = 1,
	TB_CFG_ERROR_INVALID_CONFIG_SPACE = 2,
	TB_CFG_ERROR_NO_SUCH_PORT = 4,
	TB_CFG_ERROR_ACK_PLUG_EVENT = 7,
	TB_CFG_ERROR_LOOP = 8,
	TB_CFG_ERROR_HEC_ERROR_DETECTED = 12,
	TB_CFG_ERROR_FLOW_CONTROL_ERROR = 13,
	TB_CFG_ERROR_LOCK = 15,
	TB_CFG_ERROR_DP_BW = 32,
	TB_CFG_ERROR_ROP_CMPLT = 33,
	TB_CFG_ERROR_POP_CMPLT = 34,
	TB_CFG_ERROR_PCIE_WAKE = 35,
	TB_CFG_ERROR_DP_CON_CHANGE = 36,
	TB_CFG_ERROR_DPTX_DISCOVERY = 37,
	TB_CFG_ERROR_LINK_RECOVERY = 38,
	TB_CFG_ERROR_ASYM_LINK = 39,
};

enum tb_cfg_pkg_type {
	TB_CFG_PKG_READ = 1,
	TB_CFG_PKG_WRITE = 2,
	TB_CFG_PKG_ERROR = 3,
	TB_CFG_PKG_NOTIFY_ACK = 4,
	TB_CFG_PKG_EVENT = 5,
	TB_CFG_PKG_XDOMAIN_REQ = 6,
	TB_CFG_PKG_XDOMAIN_RESP = 7,
	TB_CFG_PKG_OVERRIDE = 8,
	TB_CFG_PKG_RESET = 9,
	TB_CFG_PKG_ICM_EVENT = 10,
	TB_CFG_PKG_ICM_CMD = 11,
	TB_CFG_PKG_ICM_RESP = 12,
};

enum tb_cfg_space {
	TB_CFG_HOPS = 0,
	TB_CFG_PORT = 1,
	TB_CFG_SWITCH = 2,
	TB_CFG_COUNTERS = 3,
};

enum tb_drom_entry_type {
	TB_DROM_ENTRY_GENERIC = 0,
	TB_DROM_ENTRY_PORT = 1,
};

enum tb_eeprom_transfer {
	TB_EEPROM_IN = 0,
	TB_EEPROM_OUT = 1,
};

enum tb_link_width {
	TB_LINK_WIDTH_SINGLE = 1,
	TB_LINK_WIDTH_DUAL = 2,
	TB_LINK_WIDTH_ASYM_TX = 4,
	TB_LINK_WIDTH_ASYM_RX = 8,
};

enum tb_nvm_write_ops {
	WRITE_AND_AUTHENTICATE = 1,
	WRITE_ONLY = 2,
	AUTHENTICATE_ONLY = 3,
};

enum tb_path_port {
	TB_PATH_NONE = 0,
	TB_PATH_SOURCE = 1,
	TB_PATH_INTERNAL = 2,
	TB_PATH_DESTINATION = 4,
	TB_PATH_ALL = 7,
};

enum tb_port_cap {
	TB_PORT_CAP_PHY = 1,
	TB_PORT_CAP_POWER = 2,
	TB_PORT_CAP_TIME1 = 3,
	TB_PORT_CAP_ADAP = 4,
	TB_PORT_CAP_VSE = 5,
	TB_PORT_CAP_USB4 = 6,
};

enum tb_port_state {
	TB_PORT_DISABLED = 0,
	TB_PORT_CONNECTING = 1,
	TB_PORT_UP = 2,
	TB_PORT_TX_CL0S = 3,
	TB_PORT_RX_CL0S = 4,
	TB_PORT_CL1 = 5,
	TB_PORT_CL2 = 6,
	TB_PORT_UNPLUGGED = 7,
};

enum tb_port_type {
	TB_TYPE_INACTIVE = 0,
	TB_TYPE_PORT = 1,
	TB_TYPE_NHI = 2,
	TB_TYPE_DP_HDMI_IN = 917761,
	TB_TYPE_DP_HDMI_OUT = 917762,
	TB_TYPE_PCIE_DOWN = 1048833,
	TB_TYPE_PCIE_UP = 1048834,
	TB_TYPE_USB3_DOWN = 2097409,
	TB_TYPE_USB3_UP = 2097410,
};

enum tb_property_type {
	TB_PROPERTY_TYPE_UNKNOWN = 0,
	TB_PROPERTY_TYPE_DIRECTORY = 68,
	TB_PROPERTY_TYPE_DATA = 100,
	TB_PROPERTY_TYPE_TEXT = 116,
	TB_PROPERTY_TYPE_VALUE = 118,
};

enum tb_security_level {
	TB_SECURITY_NONE = 0,
	TB_SECURITY_USER = 1,
	TB_SECURITY_SECURE = 2,
	TB_SECURITY_DPONLY = 3,
	TB_SECURITY_USBONLY = 4,
	TB_SECURITY_NOPCIE = 5,
};

enum tb_switch_cap {
	TB_SWITCH_CAP_TMU = 3,
	TB_SWITCH_CAP_VSE = 5,
};

enum tb_switch_tmu_mode {
	TB_SWITCH_TMU_MODE_OFF = 0,
	TB_SWITCH_TMU_MODE_LOWRES = 1,
	TB_SWITCH_TMU_MODE_HIFI_UNI = 2,
	TB_SWITCH_TMU_MODE_HIFI_BI = 3,
	TB_SWITCH_TMU_MODE_MEDRES_ENHANCED_UNI = 4,
};

enum tb_switch_vse_cap {
	TB_VSE_CAP_PLUG_EVENTS = 1,
	TB_VSE_CAP_TIME2 = 3,
	TB_VSE_CAP_CP_LP = 4,
	TB_VSE_CAP_LINK_CONTROLLER = 6,
};

enum tb_tunnel_state {
	TB_TUNNEL_INACTIVE = 0,
	TB_TUNNEL_ACTIVATING = 1,
	TB_TUNNEL_ACTIVE = 2,
};

enum tb_tunnel_type {
	TB_TUNNEL_PCI = 0,
	TB_TUNNEL_DP = 1,
	TB_TUNNEL_DMA = 2,
	TB_TUNNEL_USB3 = 3,
};

enum tb_xdp_error {
	ERROR_SUCCESS = 0,
	ERROR_UNKNOWN_PACKET = 1,
	ERROR_UNKNOWN_DOMAIN = 2,
	ERROR_NOT_SUPPORTED = 3,
	ERROR_NOT_READY = 4,
};

enum tb_xdp_type {
	UUID_REQUEST_OLD = 1,
	UUID_RESPONSE = 2,
	PROPERTIES_REQUEST = 3,
	PROPERTIES_RESPONSE = 4,
	PROPERTIES_CHANGED_REQUEST = 5,
	PROPERTIES_CHANGED_RESPONSE = 6,
	ERROR_RESPONSE = 7,
	UUID_REQUEST = 12,
	LINK_STATE_STATUS_REQUEST = 15,
	LINK_STATE_STATUS_RESPONSE = 16,
	LINK_STATE_CHANGE_REQUEST = 17,
	LINK_STATE_CHANGE_RESPONSE = 18,
};

enum tc_clsu32_command {
	TC_CLSU32_NEW_KNODE = 0,
	TC_CLSU32_REPLACE_KNODE = 1,
	TC_CLSU32_DELETE_KNODE = 2,
	TC_CLSU32_NEW_HNODE = 3,
	TC_CLSU32_REPLACE_HNODE = 4,
	TC_CLSU32_DELETE_HNODE = 5,
};

enum tc_fifo_command {
	TC_FIFO_REPLACE = 0,
	TC_FIFO_DESTROY = 1,
	TC_FIFO_STATS = 2,
};

enum tc_link_layer {
	TC_LINKLAYER_UNAWARE = 0,
	TC_LINKLAYER_ETHERNET = 1,
	TC_LINKLAYER_ATM = 2,
};

enum tc_mq_command {
	TC_MQ_CREATE = 0,
	TC_MQ_DESTROY = 1,
	TC_MQ_STATS = 2,
	TC_MQ_GRAFT = 3,
};

enum tc_root_command {
	TC_ROOT_GRAFT = 0,
};

enum tc_setup_type {
	TC_QUERY_CAPS = 0,
	TC_SETUP_QDISC_MQPRIO = 1,
	TC_SETUP_CLSU32 = 2,
	TC_SETUP_CLSFLOWER = 3,
	TC_SETUP_CLSMATCHALL = 4,
	TC_SETUP_CLSBPF = 5,
	TC_SETUP_BLOCK = 6,
	TC_SETUP_QDISC_CBS = 7,
	TC_SETUP_QDISC_RED = 8,
	TC_SETUP_QDISC_PRIO = 9,
	TC_SETUP_QDISC_MQ = 10,
	TC_SETUP_QDISC_ETF = 11,
	TC_SETUP_ROOT_QDISC = 12,
	TC_SETUP_QDISC_GRED = 13,
	TC_SETUP_QDISC_TAPRIO = 14,
	TC_SETUP_FT = 15,
	TC_SETUP_QDISC_ETS = 16,
	TC_SETUP_QDISC_TBF = 17,
	TC_SETUP_QDISC_FIFO = 18,
	TC_SETUP_QDISC_HTB = 19,
	TC_SETUP_ACT = 20,
};

enum tc_taprio_qopt_cmd {
	TAPRIO_CMD_REPLACE = 0,
	TAPRIO_CMD_DESTROY = 1,
	TAPRIO_CMD_STATS = 2,
	TAPRIO_CMD_QUEUE_STATS = 3,
};

enum tca_id {
	TCA_ID_UNSPEC = 0,
	TCA_ID_POLICE = 1,
	TCA_ID_GACT = 5,
	TCA_ID_IPT = 6,
	TCA_ID_PEDIT = 7,
	TCA_ID_MIRRED = 8,
	TCA_ID_NAT = 9,
	TCA_ID_XT = 10,
	TCA_ID_SKBEDIT = 11,
	TCA_ID_VLAN = 12,
	TCA_ID_BPF = 13,
	TCA_ID_CONNMARK = 14,
	TCA_ID_SKBMOD = 15,
	TCA_ID_CSUM = 16,
	TCA_ID_TUNNEL_KEY = 17,
	TCA_ID_SIMP = 22,
	TCA_ID_IFE = 25,
	TCA_ID_SAMPLE = 26,
	TCA_ID_CTINFO = 27,
	TCA_ID_MPLS = 28,
	TCA_ID_CT = 29,
	TCA_ID_GATE = 30,
	__TCA_ID_MAX = 255,
};

enum tcf_proto_ops_flags {
	TCF_PROTO_OPS_DOIT_UNLOCKED = 1,
};

enum tcp_ca_ack_event_flags {
	CA_ACK_SLOWPATH = 1,
	CA_ACK_WIN_UPDATE = 2,
	CA_ACK_ECE = 4,
};

enum tcp_ca_event {
	CA_EVENT_TX_START = 0,
	CA_EVENT_CWND_RESTART = 1,
	CA_EVENT_COMPLETE_CWR = 2,
	CA_EVENT_LOSS = 3,
	CA_EVENT_ECN_NO_CE = 4,
	CA_EVENT_ECN_IS_CE = 5,
};

enum tcp_ca_state {
	TCP_CA_Open = 0,
	TCP_CA_Disorder = 1,
	TCP_CA_CWR = 2,
	TCP_CA_Recovery = 3,
	TCP_CA_Loss = 4,
};

enum tcp_chrono {
	TCP_CHRONO_UNSPEC = 0,
	TCP_CHRONO_BUSY = 1,
	TCP_CHRONO_RWND_LIMITED = 2,
	TCP_CHRONO_SNDBUF_LIMITED = 3,
	__TCP_CHRONO_MAX = 4,
};

enum tcp_conntrack {
	TCP_CONNTRACK_NONE = 0,
	TCP_CONNTRACK_SYN_SENT = 1,
	TCP_CONNTRACK_SYN_RECV = 2,
	TCP_CONNTRACK_ESTABLISHED = 3,
	TCP_CONNTRACK_FIN_WAIT = 4,
	TCP_CONNTRACK_CLOSE_WAIT = 5,
	TCP_CONNTRACK_LAST_ACK = 6,
	TCP_CONNTRACK_TIME_WAIT = 7,
	TCP_CONNTRACK_CLOSE = 8,
	TCP_CONNTRACK_LISTEN = 9,
	TCP_CONNTRACK_MAX = 10,
	TCP_CONNTRACK_IGNORE = 11,
	TCP_CONNTRACK_RETRANS = 12,
	TCP_CONNTRACK_UNACK = 13,
	TCP_CONNTRACK_TIMEOUT_MAX = 14,
};

enum tcp_fastopen_client_fail {
	TFO_STATUS_UNSPEC = 0,
	TFO_COOKIE_UNAVAILABLE = 1,
	TFO_DATA_NOT_ACKED = 2,
	TFO_SYN_RETRANSMITTED = 3,
};

enum tcp_metric_index {
	TCP_METRIC_RTT = 0,
	TCP_METRIC_RTTVAR = 1,
	TCP_METRIC_SSTHRESH = 2,
	TCP_METRIC_CWND = 3,
	TCP_METRIC_REORDERING = 4,
	TCP_METRIC_RTT_US = 5,
	TCP_METRIC_RTTVAR_US = 6,
	__TCP_METRIC_MAX = 7,
};

enum tcp_queue {
	TCP_FRAG_IN_WRITE_QUEUE = 0,
	TCP_FRAG_IN_RTX_QUEUE = 1,
};

enum tcp_seq_states {
	TCP_SEQ_STATE_LISTENING = 0,
	TCP_SEQ_STATE_ESTABLISHED = 1,
};

enum tcp_skb_cb_sacked_flags {
	TCPCB_SACKED_ACKED = 1,
	TCPCB_SACKED_RETRANS = 2,
	TCPCB_LOST = 4,
	TCPCB_TAGBITS = 7,
	TCPCB_REPAIRED = 16,
	TCPCB_EVER_RETRANS = 128,
	TCPCB_RETRANS = 146,
};

enum tcp_synack_type {
	TCP_SYNACK_NORMAL = 0,
	TCP_SYNACK_FASTOPEN = 1,
	TCP_SYNACK_COOKIE = 2,
};

enum tcp_tw_status {
	TCP_TW_SUCCESS = 0,
	TCP_TW_RST = 1,
	TCP_TW_ACK = 2,
	TCP_TW_SYN = 3,
};

enum tcpa_event_types {
	PREBOOT = 0,
	POST_CODE = 1,
	UNUSED = 2,
	NO_ACTION = 3,
	SEPARATOR = 4,
	ACTION = 5,
	EVENT_TAG = 6,
	SCRTM_CONTENTS = 7,
	SCRTM_VERSION = 8,
	CPU_MICROCODE = 9,
	PLATFORM_CONFIG_FLAGS = 10,
	TABLE_OF_DEVICES = 11,
	COMPACT_HASH = 12,
	IPL = 13,
	IPL_PARTITION_DATA = 14,
	NONHOST_CODE = 15,
	NONHOST_CONFIG = 16,
	NONHOST_INFO = 17,
};

enum tcx_action_base {
	TCX_NEXT = -1,
	TCX_PASS = 0,
	TCX_DROP = 2,
	TCX_REDIRECT = 7,
};

enum tg_state_flags {
	THROTL_TG_PENDING = 1,
	THROTL_TG_WAS_EMPTY = 2,
	THROTL_TG_CANCELING = 4,
};

enum thermal_device_mode {
	THERMAL_DEVICE_DISABLED = 0,
	THERMAL_DEVICE_ENABLED = 1,
};

enum thermal_notify_event {
	THERMAL_EVENT_UNSPECIFIED = 0,
	THERMAL_EVENT_TEMP_SAMPLE = 1,
	THERMAL_TRIP_VIOLATED = 2,
	THERMAL_TRIP_CHANGED = 3,
	THERMAL_DEVICE_DOWN = 4,
	THERMAL_DEVICE_UP = 5,
	THERMAL_DEVICE_POWER_CAPABILITY_CHANGED = 6,
	THERMAL_TABLE_CHANGED = 7,
	THERMAL_EVENT_KEEP_ALIVE = 8,
	THERMAL_TZ_BIND_CDEV = 9,
	THERMAL_TZ_UNBIND_CDEV = 10,
	THERMAL_INSTANCE_WEIGHT_CHANGED = 11,
	THERMAL_TZ_RESUME = 12,
	THERMAL_TZ_ADD_THRESHOLD = 13,
	THERMAL_TZ_DEL_THRESHOLD = 14,
	THERMAL_TZ_FLUSH_THRESHOLDS = 15,
};

enum thermal_trend {
	THERMAL_TREND_STABLE = 0,
	THERMAL_TREND_RAISING = 1,
	THERMAL_TREND_DROPPING = 2,
};

enum thermal_trip_type {
	THERMAL_TRIP_ACTIVE = 0,
	THERMAL_TRIP_PASSIVE = 1,
	THERMAL_TRIP_HOT = 2,
	THERMAL_TRIP_CRITICAL = 3,
};

enum tick_broadcast_state {
	TICK_BROADCAST_EXIT = 0,
	TICK_BROADCAST_ENTER = 1,
};

enum tick_dep_bits {
	TICK_DEP_BIT_POSIX_TIMER = 0,
	TICK_DEP_BIT_PERF_EVENTS = 1,
	TICK_DEP_BIT_SCHED = 2,
	TICK_DEP_BIT_CLOCK_UNSTABLE = 3,
	TICK_DEP_BIT_RCU = 4,
	TICK_DEP_BIT_RCU_EXP = 5,
};

enum tick_device_mode {
	TICKDEV_MODE_PERIODIC = 0,
	TICKDEV_MODE_ONESHOT = 1,
};

enum timekeeping_adv_mode {
	TK_ADV_TICK = 0,
	TK_ADV_FREQ = 1,
};

enum timer_tread_format {
	TREAD_FORMAT_NONE = 0,
	TREAD_FORMAT_TIME64 = 1,
	TREAD_FORMAT_TIME32 = 2,
};

enum timespec_type {
	TT_NONE = 0,
	TT_NATIVE = 1,
	TT_COMPAT = 2,
};

enum tk_offsets {
	TK_OFFS_REAL = 0,
	TK_OFFS_BOOT = 1,
	TK_OFFS_TAI = 2,
	TK_OFFS_MAX = 3,
};

enum tlb_flush_reason {
	TLB_FLUSH_ON_TASK_SWITCH = 0,
	TLB_REMOTE_SHOOTDOWN = 1,
	TLB_LOCAL_SHOOTDOWN = 2,
	TLB_LOCAL_MM_SHOOTDOWN = 3,
	TLB_REMOTE_SEND_IPI = 4,
	TLB_REMOTE_WRONG_CPU = 5,
	NR_TLB_FLUSH_REASONS = 6,
};

enum tls_offload_ctx_dir {
	TLS_OFFLOAD_CTX_DIR_RX = 0,
	TLS_OFFLOAD_CTX_DIR_TX = 1,
};

enum tp_func_state {
	TP_FUNC_0 = 0,
	TP_FUNC_1 = 1,
	TP_FUNC_2 = 2,
	TP_FUNC_N = 3,
};

enum tp_transition_sync {
	TP_TRANSITION_SYNC_1_0_1 = 0,
	TP_TRANSITION_SYNC_N_2_1 = 1,
	_NR_TP_TRANSITION_SYNC = 2,
};

enum tpacket_versions {
	TPACKET_V1 = 0,
	TPACKET_V2 = 1,
	TPACKET_V3 = 2,
};

enum tpm_duration {
	TPM_SHORT = 0,
	TPM_MEDIUM = 1,
	TPM_LONG = 2,
	TPM_LONG_LONG = 3,
	TPM_UNDEFINED = 4,
	TPM_NUM_DURATIONS = 4,
};

enum trace_flag_type {
	TRACE_FLAG_IRQS_OFF = 1,
	TRACE_FLAG_NEED_RESCHED_LAZY = 2,
	TRACE_FLAG_NEED_RESCHED = 4,
	TRACE_FLAG_HARDIRQ = 8,
	TRACE_FLAG_SOFTIRQ = 16,
	TRACE_FLAG_PREEMPT_RESCHED = 32,
	TRACE_FLAG_NMI = 64,
	TRACE_FLAG_BH_OFF = 128,
};

enum trace_iter_flags {
	TRACE_FILE_LAT_FMT = 1,
	TRACE_FILE_ANNOTATE = 2,
	TRACE_FILE_TIME_IN_NS = 4,
};

enum trace_iterator_bits {
	TRACE_ITER_PRINT_PARENT_BIT = 0,
	TRACE_ITER_SYM_OFFSET_BIT = 1,
	TRACE_ITER_SYM_ADDR_BIT = 2,
	TRACE_ITER_VERBOSE_BIT = 3,
	TRACE_ITER_RAW_BIT = 4,
	TRACE_ITER_HEX_BIT = 5,
	TRACE_ITER_BIN_BIT = 6,
	TRACE_ITER_BLOCK_BIT = 7,
	TRACE_ITER_FIELDS_BIT = 8,
	TRACE_ITER_PRINTK_BIT = 9,
	TRACE_ITER_ANNOTATE_BIT = 10,
	TRACE_ITER_USERSTACKTRACE_BIT = 11,
	TRACE_ITER_SYM_USEROBJ_BIT = 12,
	TRACE_ITER_PRINTK_MSGONLY_BIT = 13,
	TRACE_ITER_CONTEXT_INFO_BIT = 14,
	TRACE_ITER_LATENCY_FMT_BIT = 15,
	TRACE_ITER_RECORD_CMD_BIT = 16,
	TRACE_ITER_RECORD_TGID_BIT = 17,
	TRACE_ITER_OVERWRITE_BIT = 18,
	TRACE_ITER_STOP_ON_FREE_BIT = 19,
	TRACE_ITER_IRQ_INFO_BIT = 20,
	TRACE_ITER_MARKERS_BIT = 21,
	TRACE_ITER_EVENT_FORK_BIT = 22,
	TRACE_ITER_TRACE_PRINTK_BIT = 23,
	TRACE_ITER_PAUSE_ON_TRACE_BIT = 24,
	TRACE_ITER_HASH_PTR_BIT = 25,
	TRACE_ITER_STACKTRACE_BIT = 26,
	TRACE_ITER_LAST_BIT = 27,
};

enum trace_iterator_flags {
	TRACE_ITER_PRINT_PARENT = 1,
	TRACE_ITER_SYM_OFFSET = 2,
	TRACE_ITER_SYM_ADDR = 4,
	TRACE_ITER_VERBOSE = 8,
	TRACE_ITER_RAW = 16,
	TRACE_ITER_HEX = 32,
	TRACE_ITER_BIN = 64,
	TRACE_ITER_BLOCK = 128,
	TRACE_ITER_FIELDS = 256,
	TRACE_ITER_PRINTK = 512,
	TRACE_ITER_ANNOTATE = 1024,
	TRACE_ITER_USERSTACKTRACE = 2048,
	TRACE_ITER_SYM_USEROBJ = 4096,
	TRACE_ITER_PRINTK_MSGONLY = 8192,
	TRACE_ITER_CONTEXT_INFO = 16384,
	TRACE_ITER_LATENCY_FMT = 32768,
	TRACE_ITER_RECORD_CMD = 65536,
	TRACE_ITER_RECORD_TGID = 131072,
	TRACE_ITER_OVERWRITE = 262144,
	TRACE_ITER_STOP_ON_FREE = 524288,
	TRACE_ITER_IRQ_INFO = 1048576,
	TRACE_ITER_MARKERS = 2097152,
	TRACE_ITER_EVENT_FORK = 4194304,
	TRACE_ITER_TRACE_PRINTK = 8388608,
	TRACE_ITER_PAUSE_ON_TRACE = 16777216,
	TRACE_ITER_HASH_PTR = 33554432,
	TRACE_ITER_STACKTRACE = 67108864,
};

enum trace_reg {
	TRACE_REG_REGISTER = 0,
	TRACE_REG_UNREGISTER = 1,
	TRACE_REG_PERF_REGISTER = 2,
	TRACE_REG_PERF_UNREGISTER = 3,
	TRACE_REG_PERF_OPEN = 4,
	TRACE_REG_PERF_CLOSE = 5,
	TRACE_REG_PERF_ADD = 6,
	TRACE_REG_PERF_DEL = 7,
};

enum trace_type {
	__TRACE_FIRST_TYPE = 0,
	TRACE_FN = 1,
	TRACE_CTX = 2,
	TRACE_WAKE = 3,
	TRACE_STACK = 4,
	TRACE_PRINT = 5,
	TRACE_BPRINT = 6,
	TRACE_MMIO_RW = 7,
	TRACE_MMIO_MAP = 8,
	TRACE_BRANCH = 9,
	TRACE_GRAPH_RET = 10,
	TRACE_GRAPH_ENT = 11,
	TRACE_GRAPH_RETADDR_ENT = 12,
	TRACE_USER_STACK = 13,
	TRACE_BLK = 14,
	TRACE_BPUTS = 15,
	TRACE_HWLAT = 16,
	TRACE_OSNOISE = 17,
	TRACE_TIMERLAT = 18,
	TRACE_RAW_DATA = 19,
	TRACE_FUNC_REPEATS = 20,
	__TRACE_LAST_TYPE = 21,
};

enum track_item {
	TRACK_ALLOC = 0,
	TRACK_FREE = 1,
};

enum translation_map {
	LAT1_MAP = 0,
	GRAF_MAP = 1,
	IBMPC_MAP = 2,
	USER_MAP = 3,
	FIRST_MAP = 0,
	LAST_MAP = 3,
};

enum transparent_hugepage_flag {
	TRANSPARENT_HUGEPAGE_UNSUPPORTED = 0,
	TRANSPARENT_HUGEPAGE_FLAG = 1,
	TRANSPARENT_HUGEPAGE_REQ_MADV_FLAG = 2,
	TRANSPARENT_HUGEPAGE_DEFRAG_DIRECT_FLAG = 3,
	TRANSPARENT_HUGEPAGE_DEFRAG_KSWAPD_FLAG = 4,
	TRANSPARENT_HUGEPAGE_DEFRAG_KSWAPD_OR_MADV_FLAG = 5,
	TRANSPARENT_HUGEPAGE_DEFRAG_REQ_MADV_FLAG = 6,
	TRANSPARENT_HUGEPAGE_DEFRAG_KHUGEPAGED_FLAG = 7,
	TRANSPARENT_HUGEPAGE_USE_ZERO_PAGE_FLAG = 8,
};

enum tsi721_flags {
	TSI721_USING_MSI = 1,
	TSI721_USING_MSIX = 2,
	TSI721_IMSGID_SET = 4,
};

enum tsi721_msix_vect {
	TSI721_VECT_IDB = 0,
	TSI721_VECT_PWRX = 1,
	TSI721_VECT_OMB0_DONE = 2,
	TSI721_VECT_OMB1_DONE = 3,
	TSI721_VECT_OMB2_DONE = 4,
	TSI721_VECT_OMB3_DONE = 5,
	TSI721_VECT_OMB0_INT = 6,
	TSI721_VECT_OMB1_INT = 7,
	TSI721_VECT_OMB2_INT = 8,
	TSI721_VECT_OMB3_INT = 9,
	TSI721_VECT_IMB0_RCV = 10,
	TSI721_VECT_IMB1_RCV = 11,
	TSI721_VECT_IMB2_RCV = 12,
	TSI721_VECT_IMB3_RCV = 13,
	TSI721_VECT_IMB0_INT = 14,
	TSI721_VECT_IMB1_INT = 15,
	TSI721_VECT_IMB2_INT = 16,
	TSI721_VECT_IMB3_INT = 17,
	TSI721_VECT_MAX = 18,
};

enum tsq_enum {
	TSQ_THROTTLED = 0,
	TSQ_QUEUED = 1,
	TCP_TSQ_DEFERRED = 2,
	TCP_WRITE_TIMER_DEFERRED = 3,
	TCP_DELACK_TIMER_DEFERRED = 4,
	TCP_MTU_REDUCED_DEFERRED = 5,
	TCP_ACK_DEFERRED = 6,
};

enum tsq_flags {
	TSQF_THROTTLED = 1,
	TSQF_QUEUED = 2,
	TCPF_TSQ_DEFERRED = 4,
	TCPF_WRITE_TIMER_DEFERRED = 8,
	TCPF_DELACK_TIMER_DEFERRED = 16,
	TCPF_MTU_REDUCED_DEFERRED = 32,
	TCPF_ACK_DEFERRED = 64,
};

enum ttc_control {
	DMA_CONTROL_TTC_64 = 0,
	DMA_CONTROL_TTC_128 = 16384,
	DMA_CONTROL_TTC_192 = 32768,
	DMA_CONTROL_TTC_256 = 49152,
	DMA_CONTROL_TTC_40 = 65536,
	DMA_CONTROL_TTC_32 = 81920,
	DMA_CONTROL_TTC_24 = 98304,
	DMA_CONTROL_TTC_16 = 114688,
};

enum ttc_control___2 {
	DMA_CONTROL_TTC_DEFAULT = 0,
	DMA_CONTROL_TTC_64___2 = 16384,
	DMA_CONTROL_TTC_128___2 = 32768,
	DMA_CONTROL_TTC_256___2 = 49152,
	DMA_CONTROL_TTC_18 = 4194304,
	DMA_CONTROL_TTC_24___2 = 4210688,
	DMA_CONTROL_TTC_32___2 = 4227072,
	DMA_CONTROL_TTC_40___2 = 4243456,
	DMA_CONTROL_SE = 8,
	DMA_CONTROL_OSF = 4,
};

enum ttm_bo_type {
	ttm_bo_type_device = 0,
	ttm_bo_type_kernel = 1,
	ttm_bo_type_sg = 2,
};

enum ttm_caching {
	ttm_uncached = 0,
	ttm_write_combined = 1,
	ttm_cached = 2,
};

enum ttm_lru_item_type {
	TTM_LRU_RESOURCE = 0,
	TTM_LRU_HITCH = 1,
};

enum ttu_flags {
	TTU_SPLIT_HUGE_PMD = 4,
	TTU_IGNORE_MLOCK = 8,
	TTU_SYNC = 16,
	TTU_HWPOISON = 32,
	TTU_BATCH_FLUSH = 64,
	TTU_RMAP_LOCKED = 128,
};

enum tty_flow_change {
	TTY_FLOW_NO_CHANGE = 0,
	TTY_THROTTLE_SAFE = 1,
	TTY_UNTHROTTLE_SAFE = 2,
};

enum tunable_id {
	ETHTOOL_ID_UNSPEC = 0,
	ETHTOOL_RX_COPYBREAK = 1,
	ETHTOOL_TX_COPYBREAK = 2,
	ETHTOOL_PFC_PREVENTION_TOUT = 3,
	ETHTOOL_TX_COPYBREAK_BUF_SIZE = 4,
	__ETHTOOL_TUNABLE_COUNT = 5,
};

enum tunable_type_id {
	ETHTOOL_TUNABLE_UNSPEC = 0,
	ETHTOOL_TUNABLE_U8 = 1,
	ETHTOOL_TUNABLE_U16 = 2,
	ETHTOOL_TUNABLE_U32 = 3,
	ETHTOOL_TUNABLE_U64 = 4,
	ETHTOOL_TUNABLE_STRING = 5,
	ETHTOOL_TUNABLE_S8 = 6,
	ETHTOOL_TUNABLE_S16 = 7,
	ETHTOOL_TUNABLE_S32 = 8,
	ETHTOOL_TUNABLE_S64 = 9,
};

enum tunnel_encap_types {
	TUNNEL_ENCAP_NONE = 0,
	TUNNEL_ENCAP_FOU = 1,
	TUNNEL_ENCAP_GUE = 2,
	TUNNEL_ENCAP_MPLS = 3,
};

enum tx_frame_status {
	tx_done = 0,
	tx_not_ls = 1,
	tx_err = 2,
	tx_dma_own = 4,
	tx_err_bump_tc = 8,
};

enum tx_queue_prio {
	TX_QUEUE_PRIO_HIGH = 0,
	TX_QUEUE_PRIO_LOW = 1,
};

enum txgbe_atr_flow_type {
	TXGBE_ATR_FLOW_TYPE_IPV4 = 0,
	TXGBE_ATR_FLOW_TYPE_UDPV4 = 1,
	TXGBE_ATR_FLOW_TYPE_TCPV4 = 2,
	TXGBE_ATR_FLOW_TYPE_SCTPV4 = 3,
	TXGBE_ATR_FLOW_TYPE_IPV6 = 4,
	TXGBE_ATR_FLOW_TYPE_UDPV6 = 5,
	TXGBE_ATR_FLOW_TYPE_TCPV6 = 6,
	TXGBE_ATR_FLOW_TYPE_SCTPV6 = 7,
	TXGBE_ATR_FLOW_TYPE_TUNNELED_IPV4 = 16,
	TXGBE_ATR_FLOW_TYPE_TUNNELED_UDPV4 = 17,
	TXGBE_ATR_FLOW_TYPE_TUNNELED_TCPV4 = 18,
	TXGBE_ATR_FLOW_TYPE_TUNNELED_SCTPV4 = 19,
	TXGBE_ATR_FLOW_TYPE_TUNNELED_IPV6 = 20,
	TXGBE_ATR_FLOW_TYPE_TUNNELED_UDPV6 = 21,
	TXGBE_ATR_FLOW_TYPE_TUNNELED_TCPV6 = 22,
	TXGBE_ATR_FLOW_TYPE_TUNNELED_SCTPV6 = 23,
};

enum txgbe_fdir_pballoc_type {
	TXGBE_FDIR_PBALLOC_NONE = 0,
	TXGBE_FDIR_PBALLOC_64K = 1,
	TXGBE_FDIR_PBALLOC_128K = 2,
	TXGBE_FDIR_PBALLOC_256K = 3,
};

enum txgbe_misc_irqs {
	TXGBE_IRQ_LINK = 0,
	TXGBE_IRQ_MAX = 1,
};

enum txgbe_swnodes {
	SWNODE_GPIO = 0,
	SWNODE_I2C = 1,
	SWNODE_SFP = 2,
	SWNODE_PHYLINK = 3,
	SWNODE_MAX = 4,
};

enum txtime_flags {
	SOF_TXTIME_DEADLINE_MODE = 1,
	SOF_TXTIME_REPORT_ERRORS = 2,
	SOF_TXTIME_FLAGS_LAST = 2,
	SOF_TXTIME_FLAGS_MASK = 3,
};

enum uart_pm_state {
	UART_PM_STATE_ON = 0,
	UART_PM_STATE_OFF = 3,
	UART_PM_STATE_UNDEFINED = 4,
};

enum uclamp_id {
	UCLAMP_MIN = 0,
	UCLAMP_MAX = 1,
	UCLAMP_CNT = 2,
};

enum ucount_type {
	UCOUNT_USER_NAMESPACES = 0,
	UCOUNT_PID_NAMESPACES = 1,
	UCOUNT_UTS_NAMESPACES = 2,
	UCOUNT_IPC_NAMESPACES = 3,
	UCOUNT_NET_NAMESPACES = 4,
	UCOUNT_MNT_NAMESPACES = 5,
	UCOUNT_CGROUP_NAMESPACES = 6,
	UCOUNT_TIME_NAMESPACES = 7,
	UCOUNT_INOTIFY_INSTANCES = 8,
	UCOUNT_INOTIFY_WATCHES = 9,
	UCOUNT_FANOTIFY_GROUPS = 10,
	UCOUNT_FANOTIFY_MARKS = 11,
	UCOUNT_COUNTS = 12,
};

enum udp_conntrack {
	UDP_CT_UNREPLIED = 0,
	UDP_CT_REPLIED = 1,
	UDP_CT_MAX = 2,
};

enum udp_parsable_tunnel_type {
	UDP_TUNNEL_TYPE_VXLAN = 1,
	UDP_TUNNEL_TYPE_GENEVE = 2,
	UDP_TUNNEL_TYPE_VXLAN_GPE = 4,
};

enum udp_tunnel_nic_info_flags {
	UDP_TUNNEL_NIC_INFO_MAY_SLEEP = 1,
	UDP_TUNNEL_NIC_INFO_OPEN_ONLY = 2,
	UDP_TUNNEL_NIC_INFO_IPV4_ONLY = 4,
	UDP_TUNNEL_NIC_INFO_STATIC_IANA_VXLAN = 8,
};

enum udp_tunnel_nic_table_entry_flags {
	UDP_TUNNEL_NIC_ENTRY_ADD = 1,
	UDP_TUNNEL_NIC_ENTRY_DEL = 2,
	UDP_TUNNEL_NIC_ENTRY_OP_FAIL = 4,
	UDP_TUNNEL_NIC_ENTRY_FROZEN = 8,
};

enum umh_disable_depth {
	UMH_ENABLED = 0,
	UMH_FREEZING = 1,
	UMH_DISABLED = 2,
};

enum umount_tree_flags {
	UMOUNT_SYNC = 1,
	UMOUNT_PROPAGATE = 2,
	UMOUNT_CONNECTED = 4,
};

enum unix_vertex_index {
	UNIX_VERTEX_INDEX_MARK1 = 0,
	UNIX_VERTEX_INDEX_MARK2 = 1,
	UNIX_VERTEX_INDEX_START = 2,
};

enum unwinder_type {
	UNWINDER_GUESS = 0,
	UNWINDER_PROLOGUE = 1,
	UNWINDER_ORC = 2,
};

enum uprobe_task_state {
	UTASK_RUNNING = 0,
	UTASK_SSTEP = 1,
	UTASK_SSTEP_ACK = 2,
	UTASK_SSTEP_TRAPPED = 3,
};

enum usb3_link_state {
	USB3_LPM_U0 = 0,
	USB3_LPM_U1 = 1,
	USB3_LPM_U2 = 2,
	USB3_LPM_U3 = 3,
};

enum usb4_ba_index {
	USB4_BA_MAX_USB3 = 1,
	USB4_BA_MIN_DP_AUX = 2,
	USB4_BA_MIN_DP_MAIN = 3,
	USB4_BA_MAX_PCIE = 4,
	USB4_BA_MAX_HI = 5,
};

enum usb4_margin_sw_error_counter {
	USB4_MARGIN_SW_ERROR_COUNTER_NOP = 0,
	USB4_MARGIN_SW_ERROR_COUNTER_CLEAR = 1,
	USB4_MARGIN_SW_ERROR_COUNTER_START = 2,
	USB4_MARGIN_SW_ERROR_COUNTER_STOP = 3,
};

enum usb4_margining_lane {
	USB4_MARGINING_LANE_RX0 = 0,
	USB4_MARGINING_LANE_RX1 = 1,
	USB4_MARGINING_LANE_RX2 = 2,
	USB4_MARGINING_LANE_ALL = 7,
};

enum usb4_sb_opcode {
	USB4_SB_OPCODE_ERR = 542265925,
	USB4_SB_OPCODE_ONS = 1145914145,
	USB4_SB_OPCODE_ROUTER_OFFLINE = 1313166156,
	USB4_SB_OPCODE_ENUMERATE_RETIMERS = 1297436229,
	USB4_SB_OPCODE_SET_INBOUND_SBTX = 1347769164,
	USB4_SB_OPCODE_UNSET_INBOUND_SBTX = 1347769173,
	USB4_SB_OPCODE_QUERY_LAST_RETIMER = 1414742348,
	USB4_SB_OPCODE_QUERY_CABLE_RETIMER = 1380729411,
	USB4_SB_OPCODE_GET_NVM_SECTOR_SIZE = 1397968455,
	USB4_SB_OPCODE_NVM_SET_OFFSET = 1397772098,
	USB4_SB_OPCODE_NVM_BLOCK_WRITE = 1464552514,
	USB4_SB_OPCODE_NVM_AUTH_WRITE = 1213486401,
	USB4_SB_OPCODE_NVM_READ = 1381123649,
	USB4_SB_OPCODE_READ_LANE_MARGINING_CAP = 1346585682,
	USB4_SB_OPCODE_RUN_HW_LANE_MARGINING = 1196247122,
	USB4_SB_OPCODE_RUN_SW_LANE_MARGINING = 1196249938,
	USB4_SB_OPCODE_READ_SW_MARGIN_ERR = 1465074770,
};

enum usb4_sb_target {
	USB4_SB_TARGET_ROUTER = 0,
	USB4_SB_TARGET_PARTNER = 1,
	USB4_SB_TARGET_RETIMER = 2,
};

enum usb4_switch_op {
	USB4_SWITCH_OP_QUERY_DP_RESOURCE = 16,
	USB4_SWITCH_OP_ALLOC_DP_RESOURCE = 17,
	USB4_SWITCH_OP_DEALLOC_DP_RESOURCE = 18,
	USB4_SWITCH_OP_NVM_WRITE = 32,
	USB4_SWITCH_OP_NVM_AUTH = 33,
	USB4_SWITCH_OP_NVM_READ = 34,
	USB4_SWITCH_OP_NVM_SET_OFFSET = 35,
	USB4_SWITCH_OP_DROM_READ = 36,
	USB4_SWITCH_OP_NVM_SECTOR_SIZE = 37,
	USB4_SWITCH_OP_BUFFER_ALLOC = 51,
};

enum usb_charger_state {
	USB_CHARGER_DEFAULT = 0,
	USB_CHARGER_PRESENT = 1,
	USB_CHARGER_ABSENT = 2,
};

enum usb_charger_type {
	UNKNOWN_TYPE = 0,
	SDP_TYPE = 1,
	DCP_TYPE = 2,
	CDP_TYPE = 3,
	ACA_TYPE = 4,
};

enum usb_dev_authorize_policy {
	USB_DEVICE_AUTHORIZE_NONE = 0,
	USB_DEVICE_AUTHORIZE_ALL = 1,
	USB_DEVICE_AUTHORIZE_INTERNAL = 2,
};

enum usb_device_speed {
	USB_SPEED_UNKNOWN = 0,
	USB_SPEED_LOW = 1,
	USB_SPEED_FULL = 2,
	USB_SPEED_HIGH = 3,
	USB_SPEED_WIRELESS = 4,
	USB_SPEED_SUPER = 5,
	USB_SPEED_SUPER_PLUS = 6,
};

enum usb_device_state {
	USB_STATE_NOTATTACHED = 0,
	USB_STATE_ATTACHED = 1,
	USB_STATE_POWERED = 2,
	USB_STATE_RECONNECTING = 3,
	USB_STATE_UNAUTHENTICATED = 4,
	USB_STATE_DEFAULT = 5,
	USB_STATE_ADDRESS = 6,
	USB_STATE_CONFIGURED = 7,
	USB_STATE_SUSPENDED = 8,
};

enum usb_dr_mode {
	USB_DR_MODE_UNKNOWN = 0,
	USB_DR_MODE_HOST = 1,
	USB_DR_MODE_PERIPHERAL = 2,
	USB_DR_MODE_OTG = 3,
};

enum usb_interface_condition {
	USB_INTERFACE_UNBOUND = 0,
	USB_INTERFACE_BINDING = 1,
	USB_INTERFACE_BOUND = 2,
	USB_INTERFACE_UNBINDING = 3,
};

enum usb_led_event {
	USB_LED_EVENT_HOST = 0,
	USB_LED_EVENT_GADGET = 1,
};

enum usb_link_tunnel_mode {
	USB_LINK_UNKNOWN = 0,
	USB_LINK_NATIVE = 1,
	USB_LINK_TUNNELED = 2,
};

enum usb_otg_state {
	OTG_STATE_UNDEFINED = 0,
	OTG_STATE_B_IDLE = 1,
	OTG_STATE_B_SRP_INIT = 2,
	OTG_STATE_B_PERIPHERAL = 3,
	OTG_STATE_B_WAIT_ACON = 4,
	OTG_STATE_B_HOST = 5,
	OTG_STATE_A_IDLE = 6,
	OTG_STATE_A_WAIT_VRISE = 7,
	OTG_STATE_A_WAIT_BCON = 8,
	OTG_STATE_A_HOST = 9,
	OTG_STATE_A_SUSPEND = 10,
	OTG_STATE_A_PERIPHERAL = 11,
	OTG_STATE_A_WAIT_VFALL = 12,
	OTG_STATE_A_VBUS_ERR = 13,
};

enum usb_phy_events {
	USB_EVENT_NONE = 0,
	USB_EVENT_VBUS = 1,
	USB_EVENT_ID = 2,
	USB_EVENT_CHARGER = 3,
	USB_EVENT_ENUMERATED = 4,
};

enum usb_phy_interface {
	USBPHY_INTERFACE_MODE_UNKNOWN = 0,
	USBPHY_INTERFACE_MODE_UTMI = 1,
	USBPHY_INTERFACE_MODE_UTMIW = 2,
	USBPHY_INTERFACE_MODE_ULPI = 3,
	USBPHY_INTERFACE_MODE_SERIAL = 4,
	USBPHY_INTERFACE_MODE_HSIC = 5,
};

enum usb_phy_type {
	USB_PHY_TYPE_UNDEFINED = 0,
	USB_PHY_TYPE_USB2 = 1,
	USB_PHY_TYPE_USB3 = 2,
};

enum usb_port_connect_type {
	USB_PORT_CONNECT_TYPE_UNKNOWN = 0,
	USB_PORT_CONNECT_TYPE_HOT_PLUG = 1,
	USB_PORT_CONNECT_TYPE_HARD_WIRED = 2,
	USB_PORT_NOT_USED = 3,
};

enum usb_role {
	USB_ROLE_NONE = 0,
	USB_ROLE_HOST = 1,
	USB_ROLE_DEVICE = 2,
};

enum usb_ssp_rate {
	USB_SSP_GEN_UNKNOWN = 0,
	USB_SSP_GEN_2x1 = 1,
	USB_SSP_GEN_1x2 = 2,
	USB_SSP_GEN_2x2 = 3,
};

enum usb_wireless_status {
	USB_WIRELESS_STATUS_NA = 0,
	USB_WIRELESS_STATUS_DISCONNECTED = 1,
	USB_WIRELESS_STATUS_CONNECTED = 2,
};

enum utf16_endian {
	UTF16_HOST_ENDIAN = 0,
	UTF16_LITTLE_ENDIAN = 1,
	UTF16_BIG_ENDIAN = 2,
};

enum utf8_normalization {
	UTF8_NFDI = 0,
	UTF8_NFDICF = 1,
	UTF8_NMAX = 2,
};

enum uts_proc {
	UTS_PROC_ARCH = 0,
	UTS_PROC_OSTYPE = 1,
	UTS_PROC_OSRELEASE = 2,
	UTS_PROC_VERSION = 3,
	UTS_PROC_HOSTNAME = 4,
	UTS_PROC_DOMAINNAME = 5,
};

enum v4l2_av1_segment_feature {
	V4L2_AV1_SEG_LVL_ALT_Q = 0,
	V4L2_AV1_SEG_LVL_ALT_LF_Y_V = 1,
	V4L2_AV1_SEG_LVL_REF_FRAME = 5,
	V4L2_AV1_SEG_LVL_REF_SKIP = 6,
	V4L2_AV1_SEG_LVL_REF_GLOBALMV = 7,
	V4L2_AV1_SEG_LVL_MAX = 8,
};

enum v4l2_fwnode_bus_type {
	V4L2_FWNODE_BUS_TYPE_GUESS = 0,
	V4L2_FWNODE_BUS_TYPE_CSI2_CPHY = 1,
	V4L2_FWNODE_BUS_TYPE_CSI1 = 2,
	V4L2_FWNODE_BUS_TYPE_CCP2 = 3,
	V4L2_FWNODE_BUS_TYPE_CSI2_DPHY = 4,
	V4L2_FWNODE_BUS_TYPE_PARALLEL = 5,
	V4L2_FWNODE_BUS_TYPE_BT656 = 6,
	V4L2_FWNODE_BUS_TYPE_DPI = 7,
	NR_OF_V4L2_FWNODE_BUS_TYPE = 8,
};

enum v4l2_preemphasis {
	V4L2_PREEMPHASIS_DISABLED = 0,
	V4L2_PREEMPHASIS_50_uS = 1,
	V4L2_PREEMPHASIS_75_uS = 2,
};

enum vc_ctl_state {
	ESnormal = 0,
	ESesc = 1,
	ESsquare = 2,
	ESgetpars = 3,
	ESfunckey = 4,
	EShash = 5,
	ESsetG0 = 6,
	ESsetG1 = 7,
	ESpercent = 8,
	EScsiignore = 9,
	ESnonstd = 10,
	ESpalette = 11,
	ESosc = 12,
	ESANSI_first = 12,
	ESapc = 13,
	ESpm = 14,
	ESdcs = 15,
	ESANSI_last = 15,
};

enum vc_intensity {
	VCI_HALF_BRIGHT = 0,
	VCI_NORMAL = 1,
	VCI_BOLD = 2,
	VCI_MASK = 3,
};

enum vdso_clock_mode {
	VDSO_CLOCKMODE_NONE = 0,
	VDSO_CLOCKMODE_CPU = 1,
	VDSO_CLOCKMODE_MAX = 2,
	VDSO_CLOCKMODE_TIMENS = 2147483647,
};

enum verifier_phase {
	CHECK_META = 0,
	CHECK_TYPE = 1,
};

enum vers_op {
	NFSD_SET = 0,
	NFSD_CLEAR = 1,
	NFSD_TEST = 2,
	NFSD_AVAIL = 3,
};

enum vesa_blank_mode {
	VESA_NO_BLANKING = 0,
	VESA_VSYNC_SUSPEND = 1,
	VESA_HSYNC_SUSPEND = 2,
	VESA_POWERDOWN = 3,
	VESA_BLANK_MAX = 3,
};

enum vhost_task_flags {
	VHOST_TASK_FLAGS_STOP = 0,
	VHOST_TASK_FLAGS_KILLED = 1,
};

enum visit_state {
	NOT_VISITED = 0,
	VISITED = 1,
	RESOLVED = 2,
};

enum vlan_flags {
	VLAN_FLAG_REORDER_HDR = 1,
	VLAN_FLAG_GVRP = 2,
	VLAN_FLAG_LOOSE_BINDING = 4,
	VLAN_FLAG_MVRP = 8,
	VLAN_FLAG_BRIDGE_BINDING = 16,
};

enum vlan_protos {
	VLAN_PROTO_8021Q = 0,
	VLAN_PROTO_8021AD = 1,
	VLAN_PROTO_NUM = 2,
};

enum vm_event_item {
	PGPGIN = 0,
	PGPGOUT = 1,
	PSWPIN = 2,
	PSWPOUT = 3,
	PGALLOC_DMA32 = 4,
	PGALLOC_NORMAL = 5,
	PGALLOC_MOVABLE = 6,
	ALLOCSTALL_DMA32 = 7,
	ALLOCSTALL_NORMAL = 8,
	ALLOCSTALL_MOVABLE = 9,
	PGSCAN_SKIP_DMA32 = 10,
	PGSCAN_SKIP_NORMAL = 11,
	PGSCAN_SKIP_MOVABLE = 12,
	PGFREE = 13,
	PGACTIVATE = 14,
	PGDEACTIVATE = 15,
	PGLAZYFREE = 16,
	PGFAULT = 17,
	PGMAJFAULT = 18,
	PGLAZYFREED = 19,
	PGREFILL = 20,
	PGREUSE = 21,
	PGSTEAL_KSWAPD = 22,
	PGSTEAL_DIRECT = 23,
	PGSTEAL_KHUGEPAGED = 24,
	PGSCAN_KSWAPD = 25,
	PGSCAN_DIRECT = 26,
	PGSCAN_KHUGEPAGED = 27,
	PGSCAN_DIRECT_THROTTLE = 28,
	PGSCAN_ANON = 29,
	PGSCAN_FILE = 30,
	PGSTEAL_ANON = 31,
	PGSTEAL_FILE = 32,
	PGSCAN_ZONE_RECLAIM_SUCCESS = 33,
	PGSCAN_ZONE_RECLAIM_FAILED = 34,
	PGINODESTEAL = 35,
	SLABS_SCANNED = 36,
	KSWAPD_INODESTEAL = 37,
	KSWAPD_LOW_WMARK_HIT_QUICKLY = 38,
	KSWAPD_HIGH_WMARK_HIT_QUICKLY = 39,
	PAGEOUTRUN = 40,
	PGROTATED = 41,
	DROP_PAGECACHE = 42,
	DROP_SLAB = 43,
	OOM_KILL = 44,
	NUMA_PTE_UPDATES = 45,
	NUMA_HUGE_PTE_UPDATES = 46,
	NUMA_HINT_FAULTS = 47,
	NUMA_HINT_FAULTS_LOCAL = 48,
	NUMA_PAGE_MIGRATE = 49,
	PGMIGRATE_SUCCESS = 50,
	PGMIGRATE_FAIL = 51,
	THP_MIGRATION_SUCCESS = 52,
	THP_MIGRATION_FAIL = 53,
	THP_MIGRATION_SPLIT = 54,
	COMPACTMIGRATE_SCANNED = 55,
	COMPACTFREE_SCANNED = 56,
	COMPACTISOLATED = 57,
	COMPACTSTALL = 58,
	COMPACTFAIL = 59,
	COMPACTSUCCESS = 60,
	KCOMPACTD_WAKE = 61,
	KCOMPACTD_MIGRATE_SCANNED = 62,
	KCOMPACTD_FREE_SCANNED = 63,
	HTLB_BUDDY_PGALLOC = 64,
	HTLB_BUDDY_PGALLOC_FAIL = 65,
	CMA_ALLOC_SUCCESS = 66,
	CMA_ALLOC_FAIL = 67,
	UNEVICTABLE_PGCULLED = 68,
	UNEVICTABLE_PGSCANNED = 69,
	UNEVICTABLE_PGRESCUED = 70,
	UNEVICTABLE_PGMLOCKED = 71,
	UNEVICTABLE_PGMUNLOCKED = 72,
	UNEVICTABLE_PGCLEARED = 73,
	UNEVICTABLE_PGSTRANDED = 74,
	THP_FAULT_ALLOC = 75,
	THP_FAULT_FALLBACK = 76,
	THP_FAULT_FALLBACK_CHARGE = 77,
	THP_COLLAPSE_ALLOC = 78,
	THP_COLLAPSE_ALLOC_FAILED = 79,
	THP_FILE_ALLOC = 80,
	THP_FILE_FALLBACK = 81,
	THP_FILE_FALLBACK_CHARGE = 82,
	THP_FILE_MAPPED = 83,
	THP_SPLIT_PAGE = 84,
	THP_SPLIT_PAGE_FAILED = 85,
	THP_DEFERRED_SPLIT_PAGE = 86,
	THP_UNDERUSED_SPLIT_PAGE = 87,
	THP_SPLIT_PMD = 88,
	THP_SCAN_EXCEED_NONE_PTE = 89,
	THP_SCAN_EXCEED_SWAP_PTE = 90,
	THP_SCAN_EXCEED_SHARED_PTE = 91,
	THP_ZERO_PAGE_ALLOC = 92,
	THP_ZERO_PAGE_ALLOC_FAILED = 93,
	THP_SWPOUT = 94,
	THP_SWPOUT_FALLBACK = 95,
	BALLOON_INFLATE = 96,
	BALLOON_DEFLATE = 97,
	BALLOON_MIGRATE = 98,
	SWAP_RA = 99,
	SWAP_RA_HIT = 100,
	SWPIN_ZERO = 101,
	SWPOUT_ZERO = 102,
	KSM_SWPIN_COPY = 103,
	COW_KSM = 104,
	ZSWPIN = 105,
	ZSWPOUT = 106,
	ZSWPWB = 107,
	NR_VM_EVENT_ITEMS = 108,
};

enum vm_fault_reason {
	VM_FAULT_OOM = 1,
	VM_FAULT_SIGBUS = 2,
	VM_FAULT_MAJOR = 4,
	VM_FAULT_HWPOISON = 16,
	VM_FAULT_HWPOISON_LARGE = 32,
	VM_FAULT_SIGSEGV = 64,
	VM_FAULT_NOPAGE = 256,
	VM_FAULT_LOCKED = 512,
	VM_FAULT_RETRY = 1024,
	VM_FAULT_FALLBACK = 2048,
	VM_FAULT_DONE_COW = 4096,
	VM_FAULT_NEEDDSYNC = 8192,
	VM_FAULT_COMPLETED = 16384,
	VM_FAULT_HINDEX_MASK = 983040,
};

enum vm_stat_item {
	NR_DIRTY_THRESHOLD = 0,
	NR_DIRTY_BG_THRESHOLD = 1,
	NR_MEMMAP_PAGES = 2,
	NR_MEMMAP_BOOT_PAGES = 3,
	NR_VM_STAT_ITEMS = 4,
};

enum vma_merge_flags {
	VMG_FLAG_DEFAULT = 0,
	VMG_FLAG_JUST_EXPAND = 1,
};

enum vma_merge_state {
	VMA_MERGE_START = 0,
	VMA_MERGE_ERROR_NOMEM = 1,
	VMA_MERGE_NOMERGE = 2,
	VMA_MERGE_SUCCESS = 3,
};

enum vma_resv_mode {
	VMA_NEEDS_RESV = 0,
	VMA_COMMIT_RESV = 1,
	VMA_END_RESV = 2,
	VMA_ADD_RESV = 3,
	VMA_DEL_RESV = 4,
};

enum vmpressure_levels {
	VMPRESSURE_LOW = 0,
	VMPRESSURE_MEDIUM = 1,
	VMPRESSURE_CRITICAL = 2,
	VMPRESSURE_NUM_LEVELS = 3,
};

enum vmpressure_modes {
	VMPRESSURE_NO_PASSTHROUGH = 0,
	VMPRESSURE_HIERARCHY = 1,
	VMPRESSURE_LOCAL = 2,
	VMPRESSURE_NUM_MODES = 3,
};

enum vmscan_throttle_state {
	VMSCAN_THROTTLE_WRITEBACK = 0,
	VMSCAN_THROTTLE_ISOLATED = 1,
	VMSCAN_THROTTLE_NOPROGRESS = 2,
	VMSCAN_THROTTLE_CONGESTED = 3,
	NR_VMSCAN_THROTTLE = 4,
};

enum vp_vq_vector_policy {
	VP_VQ_VECTOR_POLICY_EACH = 0,
	VP_VQ_VECTOR_POLICY_SHARED_SLOW = 1,
	VP_VQ_VECTOR_POLICY_SHARED = 2,
};

enum vvar_pages {
	VVAR_GENERIC_PAGE_OFFSET = 0,
	VVAR_TIMENS_PAGE_OFFSET = 1,
	VVAR_LOONGARCH_PAGES_START = 2,
	VVAR_LOONGARCH_PAGES_END = 3,
	VVAR_NR_PAGES = 4,
};

enum wb_reason {
	WB_REASON_BACKGROUND = 0,
	WB_REASON_VMSCAN = 1,
	WB_REASON_SYNC = 2,
	WB_REASON_PERIODIC = 3,
	WB_REASON_LAPTOP_TIMER = 4,
	WB_REASON_FS_FREE_SPACE = 5,
	WB_REASON_FORKER_THREAD = 6,
	WB_REASON_FOREIGN_FLUSH = 7,
	WB_REASON_MAX = 8,
};

enum wb_stat_item {
	WB_RECLAIMABLE = 0,
	WB_WRITEBACK = 1,
	WB_DIRTIED = 2,
	WB_WRITTEN = 3,
	NR_WB_STAT_ITEMS = 4,
};

enum wb_state {
	WB_registered = 0,
	WB_writeback_running = 1,
	WB_has_dirty_io = 2,
	WB_start_all = 3,
};

enum wbt_flags {
	WBT_TRACKED = 1,
	WBT_READ = 2,
	WBT_SWAP = 4,
	WBT_DISCARD = 8,
	WBT_NR_BITS = 4,
};

enum why_no_delegation4 {
	WND4_NOT_WANTED = 0,
	WND4_CONTENTION = 1,
	WND4_RESOURCE = 2,
	WND4_NOT_SUPP_FTYPE = 3,
	WND4_WRITE_DELEG_NOT_SUPP_FTYPE = 4,
	WND4_NOT_SUPP_UPGRADE = 5,
	WND4_NOT_SUPP_DOWNGRADE = 6,
	WND4_CANCELLED = 7,
	WND4_IS_DIR = 8,
};

enum wiphy_flags {
	WIPHY_FLAG_SUPPORTS_EXT_KEK_KCK = 1,
	WIPHY_FLAG_SUPPORTS_MLO = 2,
	WIPHY_FLAG_SPLIT_SCAN_6GHZ = 4,
	WIPHY_FLAG_NETNS_OK = 8,
	WIPHY_FLAG_PS_ON_BY_DEFAULT = 16,
	WIPHY_FLAG_4ADDR_AP = 32,
	WIPHY_FLAG_4ADDR_STATION = 64,
	WIPHY_FLAG_CONTROL_PORT_PROTOCOL = 128,
	WIPHY_FLAG_IBSS_RSN = 256,
	WIPHY_FLAG_DISABLE_WEXT = 512,
	WIPHY_FLAG_MESH_AUTH = 1024,
	WIPHY_FLAG_SUPPORTS_EXT_KCK_32 = 2048,
	WIPHY_FLAG_SUPPORTS_NSTR_NONPRIMARY = 4096,
	WIPHY_FLAG_SUPPORTS_FW_ROAM = 8192,
	WIPHY_FLAG_AP_UAPSD = 16384,
	WIPHY_FLAG_SUPPORTS_TDLS = 32768,
	WIPHY_FLAG_TDLS_EXTERNAL_SETUP = 65536,
	WIPHY_FLAG_HAVE_AP_SME = 131072,
	WIPHY_FLAG_REPORTS_OBSS = 262144,
	WIPHY_FLAG_AP_PROBE_RESP_OFFLOAD = 524288,
	WIPHY_FLAG_OFFCHAN_TX = 1048576,
	WIPHY_FLAG_HAS_REMAIN_ON_CHANNEL = 2097152,
	WIPHY_FLAG_SUPPORTS_5_10_MHZ = 4194304,
	WIPHY_FLAG_HAS_CHANNEL_SWITCH = 8388608,
	WIPHY_FLAG_NOTIFY_REGDOM_BY_DRIVER = 16777216,
	WIPHY_FLAG_CHANNEL_CHANGE_ON_BEACON = 33554432,
};

enum work_bits {
	WORK_STRUCT_PENDING_BIT = 0,
	WORK_STRUCT_INACTIVE_BIT = 1,
	WORK_STRUCT_PWQ_BIT = 2,
	WORK_STRUCT_LINKED_BIT = 3,
	WORK_STRUCT_FLAG_BITS = 4,
	WORK_STRUCT_COLOR_SHIFT = 4,
	WORK_STRUCT_COLOR_BITS = 4,
	WORK_STRUCT_PWQ_SHIFT = 8,
	WORK_OFFQ_FLAG_SHIFT = 4,
	WORK_OFFQ_BH_BIT = 4,
	WORK_OFFQ_FLAG_END = 5,
	WORK_OFFQ_FLAG_BITS = 1,
	WORK_OFFQ_DISABLE_SHIFT = 5,
	WORK_OFFQ_DISABLE_BITS = 16,
	WORK_OFFQ_POOL_SHIFT = 21,
	WORK_OFFQ_LEFT = 43,
	WORK_OFFQ_POOL_BITS = 31,
};

enum work_cancel_flags {
	WORK_CANCEL_DELAYED = 1,
	WORK_CANCEL_DISABLE = 2,
};

enum work_flags {
	WORK_STRUCT_PENDING = 1,
	WORK_STRUCT_INACTIVE = 2,
	WORK_STRUCT_PWQ = 4,
	WORK_STRUCT_LINKED = 8,
	WORK_STRUCT_STATIC = 0,
};

enum worker_flags {
	WORKER_DIE = 2,
	WORKER_IDLE = 4,
	WORKER_PREP = 8,
	WORKER_CPU_INTENSIVE = 64,
	WORKER_UNBOUND = 128,
	WORKER_REBOUND = 256,
	WORKER_NOT_RUNNING = 456,
};

enum worker_pool_flags {
	POOL_BH = 1,
	POOL_MANAGER_ACTIVE = 2,
	POOL_DISASSOCIATED = 4,
	POOL_BH_DRAINING = 8,
};

enum wq_affn_scope {
	WQ_AFFN_DFL = 0,
	WQ_AFFN_CPU = 1,
	WQ_AFFN_SMT = 2,
	WQ_AFFN_CACHE = 3,
	WQ_AFFN_NUMA = 4,
	WQ_AFFN_SYSTEM = 5,
	WQ_AFFN_NR_TYPES = 6,
};

enum wq_consts {
	WQ_MAX_ACTIVE = 2048,
	WQ_UNBOUND_MAX_ACTIVE = 2048,
	WQ_DFL_ACTIVE = 1024,
	WQ_DFL_MIN_ACTIVE = 8,
};

enum wq_flags {
	WQ_BH = 1,
	WQ_UNBOUND = 2,
	WQ_FREEZABLE = 4,
	WQ_MEM_RECLAIM = 8,
	WQ_HIGHPRI = 16,
	WQ_CPU_INTENSIVE = 32,
	WQ_SYSFS = 64,
	WQ_POWER_EFFICIENT = 128,
	__WQ_DESTROYING = 32768,
	__WQ_DRAINING = 65536,
	__WQ_ORDERED = 131072,
	__WQ_LEGACY = 262144,
	__WQ_BH_ALLOWS = 17,
};

enum wq_internal_consts {
	NR_STD_WORKER_POOLS = 2,
	UNBOUND_POOL_HASH_ORDER = 6,
	BUSY_WORKER_HASH_ORDER = 6,
	MAX_IDLE_WORKERS_RATIO = 4,
	IDLE_WORKER_TIMEOUT = 75000,
	MAYDAY_INITIAL_TIMEOUT = 2,
	MAYDAY_INTERVAL = 25,
	CREATE_COOLDOWN = 250,
	RESCUER_NICE_LEVEL = -20,
	HIGHPRI_NICE_LEVEL = -20,
	WQ_NAME_LEN = 32,
	WORKER_ID_LEN = 42,
};

enum wq_misc_consts {
	WORK_NR_COLORS = 16,
	WORK_CPU_UNBOUND = 256,
	WORK_BUSY_PENDING = 1,
	WORK_BUSY_RUNNING = 2,
	WORKER_DESC_LEN = 32,
};

enum writeback_sync_modes {
	WB_SYNC_NONE = 0,
	WB_SYNC_ALL = 1,
};

enum wx_dec_ptype_etype {
	WX_DEC_PTYPE_ETYPE_NONE = 0,
	WX_DEC_PTYPE_ETYPE_IPIP = 1,
	WX_DEC_PTYPE_ETYPE_IG = 2,
	WX_DEC_PTYPE_ETYPE_IGM = 3,
	WX_DEC_PTYPE_ETYPE_IGMV = 4,
};

enum wx_dec_ptype_ip {
	WX_DEC_PTYPE_IP_NONE = 0,
	WX_DEC_PTYPE_IP_IPV4 = 1,
	WX_DEC_PTYPE_IP_IPV6 = 2,
	WX_DEC_PTYPE_IP_FGV4 = 5,
	WX_DEC_PTYPE_IP_FGV6 = 6,
};

enum wx_dec_ptype_layer {
	WX_DEC_PTYPE_LAYER_NONE = 0,
	WX_DEC_PTYPE_LAYER_PAY2 = 1,
	WX_DEC_PTYPE_LAYER_PAY3 = 2,
	WX_DEC_PTYPE_LAYER_PAY4 = 3,
};

enum wx_dec_ptype_mac {
	WX_DEC_PTYPE_MAC_IP = 0,
	WX_DEC_PTYPE_MAC_L2 = 2,
	WX_DEC_PTYPE_MAC_FCOE = 3,
};

enum wx_dec_ptype_prot {
	WX_DEC_PTYPE_PROT_NONE = 0,
	WX_DEC_PTYPE_PROT_UDP = 1,
	WX_DEC_PTYPE_PROT_TCP = 2,
	WX_DEC_PTYPE_PROT_SCTP = 3,
	WX_DEC_PTYPE_PROT_ICMP = 4,
	WX_DEC_PTYPE_PROT_TS = 5,
};

enum wx_eeprom_type {
	wx_eeprom_uninitialized = 0,
	wx_eeprom_spi = 1,
	wx_flash = 2,
	wx_eeprom_none = 3,
};

enum wx_isb_idx {
	WX_ISB_HEADER = 0,
	WX_ISB_MISC = 1,
	WX_ISB_VEC0 = 2,
	WX_ISB_VEC1 = 3,
	WX_ISB_MAX = 4,
};

enum wx_l2_ptypes {
	WX_PTYPE_L2_ABORTED = 16,
	WX_PTYPE_L2_MAC = 17,
	WX_PTYPE_L2_IPV4_FRAG = 33,
	WX_PTYPE_L2_IPV4 = 34,
	WX_PTYPE_L2_IPV4_UDP = 35,
	WX_PTYPE_L2_IPV4_TCP = 36,
	WX_PTYPE_L2_IPV4_SCTP = 37,
	WX_PTYPE_L2_IPV6_FRAG = 41,
	WX_PTYPE_L2_IPV6 = 42,
	WX_PTYPE_L2_IPV6_UDP = 43,
	WX_PTYPE_L2_IPV6_TCP = 44,
	WX_PTYPE_L2_IPV6_SCTP = 45,
	WX_PTYPE_L2_TUN4_MAC = 160,
	WX_PTYPE_L2_TUN6_MAC = 224,
};

enum wx_mac_type {
	wx_mac_unknown = 0,
	wx_mac_sp = 1,
	wx_mac_em = 2,
};

enum wx_pf_flags {
	WX_FLAG_FDIR_CAPABLE = 0,
	WX_FLAG_FDIR_HASH = 1,
	WX_FLAG_FDIR_PERFECT = 2,
	WX_PF_FLAGS_NBITS = 3,
};

enum wx_reset_type {
	WX_LAN_RESET = 0,
	WX_SW_RESET = 1,
	WX_GLOBAL_RESET = 2,
};

enum wx_ring_f_enum {
	RING_F_NONE___2 = 0,
	RING_F_RSS___2 = 1,
	RING_F_FDIR___2 = 2,
	RING_F_ARRAY_SIZE___2 = 3,
};

enum wx_state {
	WX_STATE_RESETTING = 0,
	WX_STATE_NBITS = 1,
};

enum wx_tx_flags {
	WX_TX_FLAGS_HW_VLAN = 1,
	WX_TX_FLAGS_TSO = 2,
	WX_TX_FLAGS_TSTAMP = 4,
	WX_TX_FLAGS_CC = 8,
	WX_TX_FLAGS_IPV4 = 16,
	WX_TX_FLAGS_CSUM = 32,
	WX_TX_FLAGS_OUTER_IPV4 = 256,
	WX_TX_FLAGS_LINKSEC = 512,
	WX_TX_FLAGS_IPSEC = 1024,
	WX_TX_FLAGS_SW_VLAN = 64,
};

enum x509_actions {
	ACT_x509_extract_key_data = 0,
	ACT_x509_extract_name_segment = 1,
	ACT_x509_note_OID = 2,
	ACT_x509_note_issuer = 3,
	ACT_x509_note_not_after = 4,
	ACT_x509_note_not_before = 5,
	ACT_x509_note_params = 6,
	ACT_x509_note_serial = 7,
	ACT_x509_note_sig_algo = 8,
	ACT_x509_note_signature = 9,
	ACT_x509_note_subject = 10,
	ACT_x509_note_tbs_certificate = 11,
	ACT_x509_process_extension = 12,
	NR__x509_actions = 13,
};

enum x509_akid_actions {
	ACT_x509_akid_note_kid = 0,
	ACT_x509_akid_note_name = 1,
	ACT_x509_akid_note_serial = 2,
	ACT_x509_extract_name_segment___2 = 3,
	ACT_x509_note_OID___2 = 4,
	NR__x509_akid_actions = 5,
};

enum xa_lock_type {
	XA_LOCK_IRQ = 1,
	XA_LOCK_BH = 2,
};

enum xbtree_key_contig {
	XBTREE_KEY_GAP = 0,
	XBTREE_KEY_CONTIGUOUS = 1,
	XBTREE_KEY_OVERLAP = 2,
};

enum xbtree_recpacking {
	XBTREE_RECPACKING_EMPTY = 0,
	XBTREE_RECPACKING_SPARSE = 1,
	XBTREE_RECPACKING_FULL = 2,
};

enum xdp_action {
	XDP_ABORTED = 0,
	XDP_DROP = 1,
	XDP_PASS = 2,
	XDP_TX = 3,
	XDP_REDIRECT = 4,
};

enum xdp_buff_flags {
	XDP_FLAGS_HAS_FRAGS = 1,
	XDP_FLAGS_FRAGS_PF_MEMALLOC = 2,
};

enum xdp_mem_type {
	MEM_TYPE_PAGE_SHARED = 0,
	MEM_TYPE_PAGE_ORDER0 = 1,
	MEM_TYPE_PAGE_POOL = 2,
	MEM_TYPE_XSK_BUFF_POOL = 3,
	MEM_TYPE_MAX = 4,
};

enum xdp_rss_hash_type {
	XDP_RSS_L3_IPV4 = 1,
	XDP_RSS_L3_IPV6 = 2,
	XDP_RSS_L3_DYNHDR = 4,
	XDP_RSS_L4 = 8,
	XDP_RSS_L4_TCP = 16,
	XDP_RSS_L4_UDP = 32,
	XDP_RSS_L4_SCTP = 64,
	XDP_RSS_L4_IPSEC = 128,
	XDP_RSS_L4_ICMP = 256,
	XDP_RSS_TYPE_NONE = 0,
	XDP_RSS_TYPE_L2 = 0,
	XDP_RSS_TYPE_L3_IPV4 = 1,
	XDP_RSS_TYPE_L3_IPV6 = 2,
	XDP_RSS_TYPE_L3_IPV4_OPT = 5,
	XDP_RSS_TYPE_L3_IPV6_EX = 6,
	XDP_RSS_TYPE_L4_ANY = 8,
	XDP_RSS_TYPE_L4_IPV4_TCP = 25,
	XDP_RSS_TYPE_L4_IPV4_UDP = 41,
	XDP_RSS_TYPE_L4_IPV4_SCTP = 73,
	XDP_RSS_TYPE_L4_IPV4_IPSEC = 137,
	XDP_RSS_TYPE_L4_IPV4_ICMP = 265,
	XDP_RSS_TYPE_L4_IPV6_TCP = 26,
	XDP_RSS_TYPE_L4_IPV6_UDP = 42,
	XDP_RSS_TYPE_L4_IPV6_SCTP = 74,
	XDP_RSS_TYPE_L4_IPV6_IPSEC = 138,
	XDP_RSS_TYPE_L4_IPV6_ICMP = 266,
	XDP_RSS_TYPE_L4_IPV6_TCP_EX = 30,
	XDP_RSS_TYPE_L4_IPV6_UDP_EX = 46,
	XDP_RSS_TYPE_L4_IPV6_SCTP_EX = 78,
};

enum xdp_rx_metadata {
	XDP_METADATA_KFUNC_RX_TIMESTAMP = 0,
	XDP_METADATA_KFUNC_RX_HASH = 1,
	XDP_METADATA_KFUNC_RX_VLAN_TAG = 2,
	MAX_XDP_METADATA_KFUNC = 3,
};

enum xen_domain_type {
	XEN_NATIVE = 0,
	XEN_PV_DOMAIN = 1,
	XEN_HVM_DOMAIN = 2,
};

enum xfrm_ae_ftype_t {
	XFRM_AE_UNSPEC = 0,
	XFRM_AE_RTHR = 1,
	XFRM_AE_RVAL = 2,
	XFRM_AE_LVAL = 4,
	XFRM_AE_ETHR = 8,
	XFRM_AE_CR = 16,
	XFRM_AE_CE = 32,
	XFRM_AE_CU = 64,
	__XFRM_AE_MAX = 65,
};

enum xfrm_attr_type_t {
	XFRMA_UNSPEC = 0,
	XFRMA_ALG_AUTH = 1,
	XFRMA_ALG_CRYPT = 2,
	XFRMA_ALG_COMP = 3,
	XFRMA_ENCAP = 4,
	XFRMA_TMPL = 5,
	XFRMA_SA = 6,
	XFRMA_POLICY = 7,
	XFRMA_SEC_CTX = 8,
	XFRMA_LTIME_VAL = 9,
	XFRMA_REPLAY_VAL = 10,
	XFRMA_REPLAY_THRESH = 11,
	XFRMA_ETIMER_THRESH = 12,
	XFRMA_SRCADDR = 13,
	XFRMA_COADDR = 14,
	XFRMA_LASTUSED = 15,
	XFRMA_POLICY_TYPE = 16,
	XFRMA_MIGRATE = 17,
	XFRMA_ALG_AEAD = 18,
	XFRMA_KMADDRESS = 19,
	XFRMA_ALG_AUTH_TRUNC = 20,
	XFRMA_MARK = 21,
	XFRMA_TFCPAD = 22,
	XFRMA_REPLAY_ESN_VAL = 23,
	XFRMA_SA_EXTRA_FLAGS = 24,
	XFRMA_PROTO = 25,
	XFRMA_ADDRESS_FILTER = 26,
	XFRMA_PAD = 27,
	XFRMA_OFFLOAD_DEV = 28,
	XFRMA_SET_MARK = 29,
	XFRMA_SET_MARK_MASK = 30,
	XFRMA_IF_ID = 31,
	XFRMA_MTIMER_THRESH = 32,
	XFRMA_SA_DIR = 33,
	XFRMA_NAT_KEEPALIVE_INTERVAL = 34,
	XFRMA_SA_PCPU = 35,
	XFRMA_IPTFS_DROP_TIME = 36,
	XFRMA_IPTFS_REORDER_WINDOW = 37,
	XFRMA_IPTFS_DONT_FRAG = 38,
	XFRMA_IPTFS_INIT_DELAY = 39,
	XFRMA_IPTFS_MAX_QSIZE = 40,
	XFRMA_IPTFS_PKT_SIZE = 41,
	__XFRMA_MAX = 42,
};

enum xfrm_nlgroups {
	XFRMNLGRP_NONE = 0,
	XFRMNLGRP_ACQUIRE = 1,
	XFRMNLGRP_EXPIRE = 2,
	XFRMNLGRP_SA = 3,
	XFRMNLGRP_POLICY = 4,
	XFRMNLGRP_AEVENTS = 5,
	XFRMNLGRP_REPORT = 6,
	XFRMNLGRP_MIGRATE = 7,
	XFRMNLGRP_MAPPING = 8,
	__XFRMNLGRP_MAX = 9,
};

enum xfrm_pol_inexact_candidate_type {
	XFRM_POL_CAND_BOTH = 0,
	XFRM_POL_CAND_SADDR = 1,
	XFRM_POL_CAND_DADDR = 2,
	XFRM_POL_CAND_ANY = 3,
	XFRM_POL_CAND_MAX = 4,
};

enum xfrm_replay_mode {
	XFRM_REPLAY_MODE_LEGACY = 0,
	XFRM_REPLAY_MODE_BMP = 1,
	XFRM_REPLAY_MODE_ESN = 2,
};

enum xfrm_sa_dir {
	XFRM_SA_DIR_IN = 1,
	XFRM_SA_DIR_OUT = 2,
};

enum xfrm_sadattr_type_t {
	XFRMA_SAD_UNSPEC = 0,
	XFRMA_SAD_CNT = 1,
	XFRMA_SAD_HINFO = 2,
	__XFRMA_SAD_MAX = 3,
};

enum xfrm_spdattr_type_t {
	XFRMA_SPD_UNSPEC = 0,
	XFRMA_SPD_INFO = 1,
	XFRMA_SPD_HINFO = 2,
	XFRMA_SPD_IPV4_HTHRESH = 3,
	XFRMA_SPD_IPV6_HTHRESH = 4,
	__XFRMA_SPD_MAX = 5,
};

enum xfs_ag_resv_type {
	XFS_AG_RESV_NONE = 0,
	XFS_AG_RESV_AGFL = 1,
	XFS_AG_RESV_METADATA = 2,
	XFS_AG_RESV_RMAPBT = 3,
	XFS_AG_RESV_IGNORE = 4,
	XFS_AG_RESV_METAFILE = 5,
};

enum xfs_attr_defer_op {
	XFS_ATTR_DEFER_SET = 0,
	XFS_ATTR_DEFER_REMOVE = 1,
	XFS_ATTR_DEFER_REPLACE = 2,
};

enum xfs_attr_update {
	XFS_ATTRUPDATE_REMOVE = 0,
	XFS_ATTRUPDATE_UPSERT = 1,
	XFS_ATTRUPDATE_CREATE = 2,
	XFS_ATTRUPDATE_REPLACE = 3,
};

enum xfs_blft {
	XFS_BLFT_UNKNOWN_BUF = 0,
	XFS_BLFT_UDQUOT_BUF = 1,
	XFS_BLFT_PDQUOT_BUF = 2,
	XFS_BLFT_GDQUOT_BUF = 3,
	XFS_BLFT_BTREE_BUF = 4,
	XFS_BLFT_AGF_BUF = 5,
	XFS_BLFT_AGFL_BUF = 6,
	XFS_BLFT_AGI_BUF = 7,
	XFS_BLFT_DINO_BUF = 8,
	XFS_BLFT_SYMLINK_BUF = 9,
	XFS_BLFT_DIR_BLOCK_BUF = 10,
	XFS_BLFT_DIR_DATA_BUF = 11,
	XFS_BLFT_DIR_FREE_BUF = 12,
	XFS_BLFT_DIR_LEAF1_BUF = 13,
	XFS_BLFT_DIR_LEAFN_BUF = 14,
	XFS_BLFT_DA_NODE_BUF = 15,
	XFS_BLFT_ATTR_LEAF_BUF = 16,
	XFS_BLFT_ATTR_RMT_BUF = 17,
	XFS_BLFT_SB_BUF = 18,
	XFS_BLFT_RTBITMAP_BUF = 19,
	XFS_BLFT_RTSUMMARY_BUF = 20,
	XFS_BLFT_MAX_BUF = 32,
};

enum xfs_bmap_intent_type {
	XFS_BMAP_MAP = 1,
	XFS_BMAP_UNMAP = 2,
};

enum xfs_btree_type {
	XFS_BTREE_TYPE_AG = 0,
	XFS_BTREE_TYPE_INODE = 1,
	XFS_BTREE_TYPE_MEM = 2,
};

enum xfs_dacmp {
	XFS_CMP_DIFFERENT = 0,
	XFS_CMP_EXACT = 1,
	XFS_CMP_CASE = 2,
};

enum xfs_dax_mode {
	XFS_DAX_INODE = 0,
	XFS_DAX_ALWAYS = 1,
	XFS_DAX_NEVER = 2,
};

enum xfs_delattr_state {
	XFS_DAS_UNINIT = 0,
	XFS_DAS_SF_ADD = 1,
	XFS_DAS_SF_REMOVE = 2,
	XFS_DAS_LEAF_ADD = 3,
	XFS_DAS_LEAF_REMOVE = 4,
	XFS_DAS_NODE_ADD = 5,
	XFS_DAS_NODE_REMOVE = 6,
	XFS_DAS_LEAF_SET_RMT = 7,
	XFS_DAS_LEAF_ALLOC_RMT = 8,
	XFS_DAS_LEAF_REPLACE = 9,
	XFS_DAS_LEAF_REMOVE_OLD = 10,
	XFS_DAS_LEAF_REMOVE_RMT = 11,
	XFS_DAS_LEAF_REMOVE_ATTR = 12,
	XFS_DAS_NODE_SET_RMT = 13,
	XFS_DAS_NODE_ALLOC_RMT = 14,
	XFS_DAS_NODE_REPLACE = 15,
	XFS_DAS_NODE_REMOVE_OLD = 16,
	XFS_DAS_NODE_REMOVE_RMT = 17,
	XFS_DAS_NODE_REMOVE_ATTR = 18,
	XFS_DAS_DONE = 19,
};

enum xfs_dinode_fmt {
	XFS_DINODE_FMT_DEV = 0,
	XFS_DINODE_FMT_LOCAL = 1,
	XFS_DINODE_FMT_EXTENTS = 2,
	XFS_DINODE_FMT_BTREE = 3,
	XFS_DINODE_FMT_UUID = 4,
	XFS_DINODE_FMT_META_BTREE = 5,
};

enum xfs_dir2_fmt {
	XFS_DIR2_FMT_SF = 0,
	XFS_DIR2_FMT_BLOCK = 1,
	XFS_DIR2_FMT_LEAF = 2,
	XFS_DIR2_FMT_NODE = 3,
	XFS_DIR2_FMT_ERROR = 4,
};

enum xfs_experimental_feat {
	XFS_EXPERIMENTAL_PNFS = 0,
	XFS_EXPERIMENTAL_SCRUB = 1,
	XFS_EXPERIMENTAL_SHRINK = 2,
	XFS_EXPERIMENTAL_LARP = 3,
	XFS_EXPERIMENTAL_LBS = 4,
	XFS_EXPERIMENTAL_EXCHRANGE = 5,
	XFS_EXPERIMENTAL_PPTR = 6,
	XFS_EXPERIMENTAL_METADIR = 7,
	XFS_EXPERIMENTAL_MAX = 8,
};

enum xfs_fstrm_alloc {
	XFS_PICK_USERDATA = 1,
	XFS_PICK_LOWSPACE = 2,
};

enum xfs_group_type {
	XG_TYPE_AG = 0,
	XG_TYPE_RTG = 1,
	XG_TYPE_MAX = 2,
} __attribute__((mode(byte)));

enum xfs_icwalk_goal {
	XFS_ICWALK_BLOCKGC = 1,
	XFS_ICWALK_RECLAIM = 0,
};

enum xfs_metafile_type {
	XFS_METAFILE_UNKNOWN = 0,
	XFS_METAFILE_DIR = 1,
	XFS_METAFILE_USRQUOTA = 2,
	XFS_METAFILE_GRPQUOTA = 3,
	XFS_METAFILE_PRJQUOTA = 4,
	XFS_METAFILE_RTBITMAP = 5,
	XFS_METAFILE_RTSUMMARY = 6,
	XFS_METAFILE_RTRMAP = 7,
	XFS_METAFILE_RTREFCOUNT = 8,
	XFS_METAFILE_MAX = 9,
} __attribute__((mode(byte)));

enum xfs_refc_adjust_op {
	XFS_REFCOUNT_ADJUST_INCREASE = 1,
	XFS_REFCOUNT_ADJUST_DECREASE = -1,
	XFS_REFCOUNT_ADJUST_COW_ALLOC = 0,
	XFS_REFCOUNT_ADJUST_COW_FREE = -1,
};

enum xfs_refc_domain {
	XFS_REFC_DOMAIN_SHARED = 0,
	XFS_REFC_DOMAIN_COW = 1,
};

enum xfs_refcount_intent_type {
	XFS_REFCOUNT_INCREASE = 1,
	XFS_REFCOUNT_DECREASE = 2,
	XFS_REFCOUNT_ALLOC_COW = 3,
	XFS_REFCOUNT_FREE_COW = 4,
};

enum xfs_rmap_intent_type {
	XFS_RMAP_MAP = 0,
	XFS_RMAP_MAP_SHARED = 1,
	XFS_RMAP_UNMAP = 2,
	XFS_RMAP_UNMAP_SHARED = 3,
	XFS_RMAP_CONVERT = 4,
	XFS_RMAP_CONVERT_SHARED = 5,
	XFS_RMAP_ALLOC = 6,
	XFS_RMAP_FREE = 7,
};

enum xfs_rtg_inodes {
	XFS_RTGI_BITMAP = 0,
	XFS_RTGI_SUMMARY = 1,
	XFS_RTGI_RMAP = 2,
	XFS_RTGI_REFCOUNT = 3,
	XFS_RTGI_MAX = 4,
};

enum xhci_cancelled_td_status {
	TD_DIRTY = 0,
	TD_HALTED = 1,
	TD_CLEARING_CACHE = 2,
	TD_CLEARING_CACHE_DEFERRED = 3,
	TD_CLEARED = 4,
};

enum xhci_ep_reset_type {
	EP_HARD_RESET = 0,
	EP_SOFT_RESET = 1,
};

enum xhci_overhead_type {
	LS_OVERHEAD_TYPE = 0,
	FS_OVERHEAD_TYPE = 1,
	HS_OVERHEAD_TYPE = 2,
};

enum xhci_ring_type {
	TYPE_CTRL = 0,
	TYPE_ISOC = 1,
	TYPE_BULK = 2,
	TYPE_INTR = 3,
	TYPE_STREAM = 4,
	TYPE_COMMAND = 5,
	TYPE_EVENT = 6,
};

enum xhci_setup_dev {
	SETUP_CONTEXT_ONLY = 0,
	SETUP_CONTEXT_ADDRESS = 1,
};

enum xlog_iclog_state {
	XLOG_STATE_ACTIVE = 0,
	XLOG_STATE_WANT_SYNC = 1,
	XLOG_STATE_SYNCING = 2,
	XLOG_STATE_DONE_SYNC = 3,
	XLOG_STATE_CALLBACK = 4,
	XLOG_STATE_DIRTY = 5,
};

enum xlog_recover_reorder {
	XLOG_REORDER_BUFFER_LIST = 0,
	XLOG_REORDER_ITEM_LIST = 1,
	XLOG_REORDER_INODE_BUFFER_LIST = 2,
	XLOG_REORDER_CANCEL_LIST = 3,
};

enum xprt_transports {
	XPRT_TRANSPORT_UDP = 17,
	XPRT_TRANSPORT_TCP = 6,
	XPRT_TRANSPORT_BC_TCP = -2147483642,
	XPRT_TRANSPORT_RDMA = 256,
	XPRT_TRANSPORT_BC_RDMA = -2147483392,
	XPRT_TRANSPORT_LOCAL = 257,
	XPRT_TRANSPORT_TCP_TLS = 258,
};

enum xprt_xid_rb_cmp {
	XID_RB_EQUAL = 0,
	XID_RB_LEFT = 1,
	XID_RB_RIGHT = 2,
};

enum xprtsec_policies {
	RPC_XPRTSEC_NONE = 0,
	RPC_XPRTSEC_TLS_ANON = 1,
	RPC_XPRTSEC_TLS_X509 = 2,
};

enum xps_map_type {
	XPS_CPUS = 0,
	XPS_RXQS = 1,
	XPS_MAPS_MAX = 2,
};

enum xz_check {
	XZ_CHECK_NONE = 0,
	XZ_CHECK_CRC32 = 1,
	XZ_CHECK_CRC64 = 4,
	XZ_CHECK_SHA256 = 10,
};

enum xz_mode {
	XZ_SINGLE = 0,
	XZ_PREALLOC = 1,
	XZ_DYNALLOC = 2,
};

enum xz_ret {
	XZ_OK = 0,
	XZ_STREAM_END = 1,
	XZ_UNSUPPORTED_CHECK = 2,
	XZ_MEM_ERROR = 3,
	XZ_MEMLIMIT_ERROR = 4,
	XZ_FORMAT_ERROR = 5,
	XZ_OPTIONS_ERROR = 6,
	XZ_DATA_ERROR = 7,
	XZ_BUF_ERROR = 8,
};

enum zbc_zone_alignment_method {
	ZBC_CONSTANT_ZONE_LENGTH = 1,
	ZBC_CONSTANT_ZONE_START_OFFSET = 8,
};

enum zbc_zone_cond {
	ZBC_ZONE_COND_NO_WP = 0,
	ZBC_ZONE_COND_EMPTY = 1,
	ZBC_ZONE_COND_IMP_OPEN = 2,
	ZBC_ZONE_COND_EXP_OPEN = 3,
	ZBC_ZONE_COND_CLOSED = 4,
	ZBC_ZONE_COND_READONLY = 13,
	ZBC_ZONE_COND_FULL = 14,
	ZBC_ZONE_COND_OFFLINE = 15,
};

enum zbc_zone_type {
	ZBC_ZONE_TYPE_CONV = 1,
	ZBC_ZONE_TYPE_SEQWRITE_REQ = 2,
	ZBC_ZONE_TYPE_SEQWRITE_PREF = 3,
	ZBC_ZONE_TYPE_SEQ_OR_BEFORE_REQ = 4,
	ZBC_ZONE_TYPE_GAP = 5,
};

enum zone_flags {
	ZONE_BOOSTED_WATERMARK = 0,
	ZONE_RECLAIM_ACTIVE = 1,
	ZONE_BELOW_HIGH = 2,
};

enum zone_stat_item {
	NR_FREE_PAGES = 0,
	NR_ZONE_LRU_BASE = 1,
	NR_ZONE_INACTIVE_ANON = 1,
	NR_ZONE_ACTIVE_ANON = 2,
	NR_ZONE_INACTIVE_FILE = 3,
	NR_ZONE_ACTIVE_FILE = 4,
	NR_ZONE_UNEVICTABLE = 5,
	NR_ZONE_WRITE_PENDING = 6,
	NR_MLOCK = 7,
	NR_BOUNCE = 8,
	NR_ZSPAGES = 9,
	NR_FREE_CMA_PAGES = 10,
	NR_VM_ZONE_STAT_ITEMS = 11,
};

enum zone_type {
	ZONE_DMA32 = 0,
	ZONE_NORMAL = 1,
	ZONE_MOVABLE = 2,
	__MAX_NR_ZONES = 3,
};

enum zone_watermarks {
	WMARK_MIN = 0,
	WMARK_LOW = 1,
	WMARK_HIGH = 2,
	WMARK_PROMO = 3,
	NR_WMARK = 4,
};

enum zpool_mapmode {
	ZPOOL_MM_RW = 0,
	ZPOOL_MM_RO = 1,
	ZPOOL_MM_WO = 2,
	ZPOOL_MM_DEFAULT = 0,
};

enum zs_mapmode {
	ZS_MM_RW = 0,
	ZS_MM_RO = 1,
	ZS_MM_WO = 2,
};

enum zswap_init_type {
	ZSWAP_UNINIT = 0,
	ZSWAP_INIT_SUCCEED = 1,
	ZSWAP_INIT_FAILED = 2,
};

typedef _Bool bool;

typedef __int128 unsigned __u128;

typedef __u128 u128;

typedef u128 freelist_full_t;

typedef char *__kernel_caddr_t;

typedef char __pad_after_uframe[0];

typedef char __pad_before_uframe[0];

typedef char acpi_bus_id[8];

typedef char acpi_device_class[20];

typedef char acpi_device_name[40];

typedef char *acpi_string;

typedef __kernel_caddr_t caddr_t;

typedef const char (* const ethnl_string_array_t)[32];

typedef int __kernel_clockid_t;

typedef int __kernel_daddr_t;

typedef int __kernel_ipc_pid_t;

typedef int __kernel_key_t;

typedef int __kernel_mqd_t;

typedef int __kernel_pid_t;

typedef int __kernel_rwf_t;

typedef int __kernel_timer_t;

typedef int __s32;

typedef int class_get_unused_fd_t;

typedef __kernel_clockid_t clockid_t;

typedef __s32 s32;

typedef s32 compat_int_t;

typedef s32 compat_ssize_t;

typedef int cydp_t;

typedef s32 dma_cookie_t;

typedef int ext2_grpblk_t;

typedef int ext4_grpblk_t;

typedef int folio_walk_flags_t;

typedef int fpb_t;

typedef int fpi_t;

typedef s32 int32_t;

typedef int32_t key_serial_t;

typedef __kernel_key_t key_t;

typedef int kprobe_opcode_t;

typedef int mhp_t;

typedef int mpi_size_t;

typedef __kernel_mqd_t mqd_t;

typedef s32 old_time32_t;

typedef int pci_power_t;

typedef __kernel_pid_t pid_t;

typedef int rmap_t;

typedef __kernel_rwf_t rwf_t;

typedef __s32 sctp_assoc_t;

typedef int snd_ctl_elem_iface_t;

typedef int snd_ctl_elem_type_t;

typedef int snd_pcm_access_t;

typedef int snd_pcm_format_t;

typedef int snd_pcm_hw_param_t;

typedef int snd_pcm_state_t;

typedef int snd_pcm_subformat_t;

typedef int suspend_state_t;

typedef __kernel_timer_t timer_t;

typedef long int __kernel_long_t;

typedef __kernel_long_t __kernel_clock_t;

typedef __kernel_long_t __kernel_off_t;

typedef __kernel_long_t __kernel_old_time_t;

typedef __kernel_long_t __kernel_ptrdiff_t;

typedef __kernel_long_t __kernel_ssize_t;

typedef __kernel_long_t __kernel_suseconds_t;

typedef __kernel_clock_t clock_t;

typedef long int intptr_t;

typedef long int mpi_limb_signed_t;

typedef __kernel_off_t off_t;

typedef __kernel_ptrdiff_t ptrdiff_t;

typedef long int snd_pcm_sframes_t;

typedef __kernel_ssize_t ssize_t;

typedef __kernel_suseconds_t suseconds_t;

typedef long int word_type;

typedef long long int __s64;

typedef __s64 Elf64_Sxword;

typedef long long int __kernel_loff_t;

typedef long long int __kernel_time64_t;

typedef __s64 s64;

typedef s64 compat_loff_t;

typedef s64 int64_t;

typedef s64 ktime_t;

typedef __kernel_loff_t loff_t;

typedef long long int qsize_t;

typedef __s64 time64_t;

typedef int64_t xfs_csn_t;

typedef __s64 xfs_daddr_t;

typedef __s64 xfs_off_t;

typedef xfs_off_t xfs_dir2_off_t;

typedef int64_t xfs_fsize_t;

typedef int64_t xfs_lsn_t;

typedef long long unsigned int __u64;

typedef __u64 Elf64_Addr;

typedef __u64 Elf64_Off;

typedef __u64 Elf64_Xword;

typedef __u64 __le64;

typedef __le64 U64;

typedef __u64 u64;

typedef u64 uint64_t;

typedef uint64_t U64___2;

typedef U64___2 ZSTD_VecMask;

typedef __u64 __addrpair;

typedef __u64 __be64;

typedef __u64 __virtio64;

typedef u64 acpi_bus_address;

typedef u64 acpi_io_address;

typedef u64 acpi_physical_address;

typedef u64 acpi_size;

typedef u64 async_cookie_t;

typedef __u64 blist_flags_t;

typedef u64 blkcnt_t;

typedef u64 clientid4;

typedef u64 compat_u64;

typedef u64 dma_addr_t;

typedef u64 efi_physical_addr_t;

typedef long long unsigned int ext4_fsblk_t;

typedef __be64 fdt64_t;

typedef u64 gfn_t;

typedef u64 gpa_t;

typedef u64 io_req_flags_t;

typedef u64 netdev_features_t;

typedef u64 pci_bus_addr_t;

typedef u64 phys_addr_t;

typedef __u64 rds_rdma_cookie_t;

typedef phys_addr_t resource_size_t;

typedef u64 sci_t;

typedef u64 sector_t;

typedef __u64 timeu64_t;

typedef u64 u_int64_t;

typedef u64 unative_t;

typedef u64 upf_t;

typedef uint64_t vli_type;

typedef uint64_t xfbno_t;

typedef __be64 xfs_bmbt_ptr_t;

typedef uint64_t xfs_bmbt_rec_base_t;

typedef uint64_t xfs_extnum_t;

typedef uint64_t xfs_filblks_t;

typedef uint64_t xfs_fileoff_t;

typedef uint64_t xfs_fsblock_t;

typedef long long unsigned int xfs_ino_t;

typedef uint64_t xfs_inofree_t;

typedef uint64_t xfs_log_timestamp_t;

typedef uint64_t xfs_qcnt_t;

typedef uint64_t xfs_rfsblock_t;

typedef uint64_t xfs_rtblock_t;

typedef uint64_t xfs_rtbxlen_t;

typedef __be64 xfs_rtrefcount_ptr_t;

typedef __be64 xfs_rtrmap_ptr_t;

typedef uint64_t xfs_rtxnum_t;

typedef __be64 xfs_timestamp_t;

typedef uint64_t xfs_ufsize_t;

typedef long unsigned int __kernel_ulong_t;

typedef __kernel_ulong_t __kernel_size_t;

typedef __kernel_size_t size_t;

typedef size_t HUF_CElt;

typedef long unsigned int mpi_limb_t;

typedef mpi_limb_t UWtype;

typedef __kernel_ulong_t aio_context_t;

typedef long unsigned int cycles_t;

typedef long unsigned int efi_status_t;

typedef long unsigned int elf_greg_t;

typedef elf_greg_t elf_gregset_t[45];

typedef long unsigned int ext2_fsblk_t;

typedef __kernel_ulong_t ino_t;

typedef long unsigned int irq_hw_number_t;

typedef long unsigned int kernel_ulong_t;

typedef long unsigned int kimage_entry_t;

typedef long unsigned int kvm_pte_t;

typedef mpi_limb_t *mpi_ptr_t;

typedef long unsigned int netmem_ref;

typedef long unsigned int perf_trace_t[1024];

typedef long unsigned int pte_marker;

typedef long unsigned int snd_pcm_uframes_t;

typedef long unsigned int uLong;

typedef long unsigned int uintptr_t;

typedef long unsigned int ulg;

typedef long unsigned int ulong;

typedef uintptr_t uptrval;

typedef long unsigned int vm_flags_t;

typedef short int __s16;

typedef __s16 s16;

typedef s16 int16_t;

typedef int16_t S16;

typedef short unsigned int __u16;

typedef __u16 Elf32_Half;

typedef __u16 Elf64_Half;

typedef short unsigned int ush;

typedef ush Pos;

typedef __u16 __le16;

typedef __le16 U16;

typedef __u16 u16;

typedef u16 uint16_t;

typedef uint16_t U16___2;

typedef __u16 __be16;

typedef __u16 __hc16;

typedef short unsigned int __kernel_gid16_t;

typedef short unsigned int __kernel_sa_family_t;

typedef short unsigned int __kernel_uid16_t;

typedef __u16 __sum16;

typedef __u16 __virtio16;

typedef u16 acpi_owner_id;

typedef u16 acpi_rs_length;

typedef u16 blk_short_t;

typedef __u16 comp_t;

typedef u16 efi_char16_t;

typedef __kernel_gid16_t gid16_t;

typedef u16 hda_nid_t;

typedef short unsigned int mifi_t;

typedef short unsigned int pci_bus_flags_t;

typedef short unsigned int pci_dev_flags_t;

typedef __u16 port_id;

typedef __kernel_sa_family_t sa_family_t;

typedef u16 u_int16_t;

typedef short unsigned int u_short;

typedef u16 ucs2_char_t;

typedef __kernel_uid16_t uid16_t;

typedef __u16 uio_meta_flags_t;

typedef short unsigned int umode_t;

typedef short unsigned int ushort;

typedef short unsigned int vifi_t;

typedef u16 wchar_t;

typedef uint16_t xfs_dir2_data_off_t;

typedef signed char __s8;

typedef __s8 s8;

typedef s8 int8_t;

typedef unsigned char __u8;

typedef __u8 u8;

typedef u8 uint8_t;

typedef uint8_t BYTE;

typedef unsigned char Byte;

typedef u8 U8;

typedef uint8_t U8___2;

typedef u8 acpi_adr_space_type;

typedef u8 blk_status_t;

typedef unsigned char cc_t;

typedef uint8_t dchars;

typedef u8 dscp_t;

typedef uint8_t dstring;

typedef __u8 dvd_challenge[10];

typedef __u8 dvd_key[5];

typedef u8 efi_bool_t;

typedef __u8 rds_tos_t;

typedef u8 rmap_age_t;

typedef unsigned char u_char;

typedef u8 u_int8_t;

typedef unsigned char uch;

typedef uint8_t xfs_dqtype_t;

typedef unsigned int __u32;

typedef __u32 Elf32_Addr;

typedef __u32 Elf32_Off;

typedef __u32 Elf32_Word;

typedef __u32 Elf64_Word;

typedef unsigned int FSE_CTable;

typedef unsigned int FSE_DTable;

typedef __u32 u32;

typedef u32 uint32_t;

typedef uint32_t U32;

typedef U32 HUF_DTable;

typedef unsigned int IPos;

typedef unsigned int OM_uint32;

typedef __u32 __le32;

typedef __le32 U32___2;

typedef unsigned int UHWtype;

typedef __u32 __be32;

typedef __u32 __hc32;

typedef u32 __kernel_dev_t;

typedef unsigned int __kernel_gid32_t;

typedef unsigned int __kernel_gid_t;

typedef unsigned int __kernel_mode_t;

typedef unsigned int __kernel_old_dev_t;

typedef unsigned int __kernel_uid32_t;

typedef unsigned int __kernel_uid_t;

typedef unsigned int __poll_t;

typedef __u32 __portpair;

typedef __u32 __virtio32;

typedef __u32 __wsum;

typedef u32 acpi_event_status;

typedef u32 acpi_mutex_handle;

typedef u32 acpi_name;

typedef u32 acpi_object_type;

typedef u32 acpi_rsdesc_size;

typedef u32 acpi_status;

typedef unsigned int autofs_wqt_t;

typedef unsigned int blk_features_t;

typedef unsigned int blk_flags_t;

typedef unsigned int blk_insert_t;

typedef unsigned int blk_mode_t;

typedef __u32 blk_mq_req_flags_t;

typedef __u32 blk_opf_t;

typedef unsigned int blk_qc_t;

typedef u32 compat_caddr_t;

typedef u32 compat_size_t;

typedef u32 compat_uint_t;

typedef u32 compat_ulong_t;

typedef u32 compat_uptr_t;

typedef u32 depot_flags_t;

typedef u32 depot_stack_handle_t;

typedef __kernel_dev_t dev_t;

typedef unsigned int drm_magic_t;

typedef u32 efi_cc_event_algorithm_bitmap_t;

typedef u32 efi_cc_event_log_bitmap_t;

typedef u32 efi_cc_event_log_format_t;

typedef u32 efi_cc_mr_index_t;

typedef u32 efi_tcg2_event_log_format;

typedef u32 errseq_t;

typedef unsigned int ext4_group_t;

typedef __u32 ext4_lblk_t;

typedef __be32 fdt32_t;

typedef unsigned int fgf_t;

typedef unsigned int fmode_t;

typedef unsigned int fop_flags_t;

typedef unsigned int gfp_t;

typedef __kernel_gid32_t gid_t;

typedef __u32 if_mask;

typedef unsigned int ioasid_t;

typedef unsigned int iov_iter_extraction_t;

typedef unsigned int isolate_mode_t;

typedef u32 ixgbe_autoneg_advertised;

typedef u32 ixgbe_link_speed;

typedef unsigned int kasan_vmalloc_flags_t;

typedef uint32_t key_perm_t;

typedef __kernel_mode_t mode_t;

typedef u32 nlink_t;

typedef u32 note_buf_t[128];

typedef __u32 nvme_submit_flags_t;

typedef unsigned int pci_channel_state_t;

typedef unsigned int pci_ers_result_t;

typedef unsigned int pgtbl_mod_mask;

typedef u32 phandle;

typedef u32 phys_cpuid_t;

typedef unsigned int pipe_index_t;

typedef uint32_t prid_t;

typedef __kernel_uid32_t projid_t;

typedef __kernel_uid32_t qid_t;

typedef U32 rankValCol_t[13];

typedef __u32 req_flags_t;

typedef u32 rpc_authflavor_t;

typedef __be32 rpc_fraghdr;

typedef unsigned int sk_buff_data_t;

typedef unsigned int slab_flags_t;

typedef unsigned int speed_t;

typedef unsigned int t_key;

typedef unsigned int tcflag_t;

typedef unsigned int tid_t;

typedef unsigned int uInt;

typedef unsigned int u_int;

typedef u32 u_int32_t;

typedef uint32_t udf_pblk_t;

typedef unsigned int uffd_flags_t;

typedef __kernel_uid32_t uid_t;

typedef unsigned int uint;

typedef u32 unicode_t;

typedef u32 uprobe_opcode_t;

typedef unsigned int upstat_t;

typedef u32 usb_port_location_t;

typedef unsigned int vm_fault_t;

typedef unsigned int xa_mark_t;

typedef u32 xdp_features_t;

typedef uint32_t xfs_aextnum_t;

typedef uint32_t xfs_agblock_t;

typedef uint32_t xfs_agino_t;

typedef uint32_t xfs_agnumber_t;

typedef unsigned int xfs_buf_flags_t;

typedef uint32_t xfs_dablk_t;

typedef uint32_t xfs_dahash_t;

typedef __u32 xfs_dev_t;

typedef uint xfs_dir2_data_aoff_t;

typedef uint32_t xfs_dir2_dataptr_t;

typedef uint32_t xfs_dir2_db_t;

typedef uint32_t xfs_dqid_t;

typedef uint32_t xfs_extlen_t;

typedef __u32 xfs_nlink_t;

typedef uint32_t xfs_rgblock_t;

typedef uint32_t xfs_rgnumber_t;

typedef uint32_t xfs_rtxlen_t;

typedef uint32_t xlog_tid_t;

typedef unsigned int zap_flags_t;

typedef struct {
	size_t bitContainer;
	unsigned int bitPos;
	char *startPtr;
	char *ptr;
	char *endPtr;
} BIT_CStream_t;

typedef struct {
	size_t bitContainer;
	unsigned int bitsConsumed;
	const char *ptr;
	const char *start;
	const char *limitPtr;
} BIT_DStream_t;

typedef struct {
	BYTE maxTableLog;
	BYTE tableType;
	BYTE tableLog;
	BYTE reserved;
} DTableDesc;

struct DWstruct {
	int low;
	int high;
};

typedef union {
	struct DWstruct s;
	long long int ll;
} DWunion;

typedef struct {
	ptrdiff_t value;
	const void *stateTable;
	const void *symbolTT;
	unsigned int stateLog;
} FSE_CState_t;

typedef struct {
	size_t state;
	const void *table;
} FSE_DState_t;

typedef struct {
	U16___2 tableLog;
	U16___2 fastMode;
} FSE_DTableHeader;

typedef struct {
	short int ncount[256];
	FSE_DTable dtable[0];
} FSE_DecompressWksp;

typedef struct {
	short unsigned int newState;
	unsigned char symbol;
	unsigned char nbBits;
} FSE_decode_t;

typedef struct {
	int deltaFindState;
	U32 deltaNbBits;
} FSE_symbolCompressionTransform;

typedef struct {
	size_t bitContainer[2];
	size_t bitPos[2];
	BYTE *startPtr;
	BYTE *ptr;
	BYTE *endPtr;
} HUF_CStream_t;

typedef struct {
	FSE_CTable CTable[59];
	U32 scratchBuffer[41];
	unsigned int count[13];
	S16 norm[13];
} HUF_CompressWeightsWksp;

typedef struct {
	BYTE nbBits;
	BYTE byte;
} HUF_DEltX1;

typedef struct {
	U16___2 sequence;
	BYTE nbBits;
	BYTE length;
} HUF_DEltX2;

typedef struct {
	U32 rankVal[13];
	U32 rankStart[13];
	U32 statsWksp[218];
	BYTE symbols[256];
	BYTE huffWeight[256];
} HUF_ReadDTableX1_Workspace;

typedef struct {
	BYTE symbol;
} sortedSymbol_t;

typedef struct {
	U32 rankVal[156];
	U32 rankStats[13];
	U32 rankStart0[15];
	sortedSymbol_t sortedSymbol[256];
	BYTE weightList[256];
	U32 calleeWksp[218];
} HUF_ReadDTableX2_Workspace;

typedef struct {
	HUF_CompressWeightsWksp wksp;
	BYTE bitsToWeight[13];
	BYTE huffWeight[255];
} HUF_WriteCTableWksp;

struct nodeElt_s {
	U32 count;
	U16___2 parent;
	BYTE byte;
	BYTE nbBits;
};

typedef struct nodeElt_s nodeElt;

typedef nodeElt huffNodeTable[512];

typedef struct {
	U16___2 base;
	U16___2 curr;
} rankPos;

typedef struct {
	huffNodeTable huffNodeTbl;
	rankPos rankPosition[192];
} HUF_buildCTable_wksp_tables;

typedef struct {
	unsigned int count[256];
	HUF_CElt CTable[257];
	union {
		HUF_buildCTable_wksp_tables buildCTable_wksp;
		HUF_WriteCTableWksp writeCTable_wksp;
		U32 hist_wksp[1024];
	} wksps;
} HUF_compress_tables_t;

struct buffer_head;

typedef struct {
	__le32 *p;
	__le32 key;
	struct buffer_head *bh;
} Indirect;

typedef struct {
	const uint8_t *externalDict;
	size_t extDictSize;
	const uint8_t *prefixEnd;
	size_t prefixSize;
} LZ4_streamDecode_t_internal;

typedef union {
	long long unsigned int table[4];
	LZ4_streamDecode_t_internal internal_donotuse;
} LZ4_streamDecode_t;

struct folio;

typedef struct {
	struct folio *v;
} Sector;

typedef struct {
	unsigned int offset;
	unsigned int litLength;
	unsigned int matchLength;
	unsigned int rep;
} ZSTD_Sequence;

typedef struct {
	int collectSequences;
	ZSTD_Sequence *seqStart;
	size_t seqIndex;
	size_t maxSequences;
} SeqCollector;

typedef struct {
	S16 norm[53];
	U32 wksp[285];
} ZSTD_BuildCTableWksp;

struct ZSTD_DDict_s;

typedef struct ZSTD_DDict_s ZSTD_DDict;

typedef struct {
	const ZSTD_DDict **ddictPtrTable;
	size_t ddictPtrTableSize;
	size_t ddictPtrCount;
} ZSTD_DDictHashSet;

struct seqDef_s;

typedef struct seqDef_s seqDef;

typedef struct {
	seqDef *sequencesStart;
	seqDef *sequences;
	BYTE *litStart;
	BYTE *lit;
	BYTE *llCode;
	BYTE *mlCode;
	BYTE *ofCode;
	size_t maxNbSeq;
	size_t maxNbLit;
	ZSTD_longLengthType_e longLengthType;
	U32 longLengthPos;
} seqStore_t;

typedef struct {
	symbolEncodingType_e hType;
	BYTE hufDesBuffer[128];
	size_t hufDesSize;
} ZSTD_hufCTablesMetadata_t;

typedef struct {
	symbolEncodingType_e llType;
	symbolEncodingType_e ofType;
	symbolEncodingType_e mlType;
	BYTE fseTablesBuffer[133];
	size_t fseTablesSize;
	size_t lastCountSize;
} ZSTD_fseCTablesMetadata_t;

typedef struct {
	ZSTD_hufCTablesMetadata_t hufMetadata;
	ZSTD_fseCTablesMetadata_t fseMetadata;
} ZSTD_entropyCTablesMetadata_t;

typedef struct {
	seqStore_t fullSeqStoreChunk;
	seqStore_t firstHalfSeqStore;
	seqStore_t secondHalfSeqStore;
	seqStore_t currSeqStore;
	seqStore_t nextSeqStore;
	U32 partitions[196];
	ZSTD_entropyCTablesMetadata_t entropyMetadata;
} ZSTD_blockSplitCtx;

typedef struct {
	HUF_CElt CTable[257];
	HUF_repeat repeatMode;
} ZSTD_hufCTables_t;

typedef struct {
	FSE_CTable offcodeCTable[193];
	FSE_CTable matchlengthCTable[363];
	FSE_CTable litlengthCTable[329];
	FSE_repeat offcode_repeatMode;
	FSE_repeat matchlength_repeatMode;
	FSE_repeat litlength_repeatMode;
} ZSTD_fseCTables_t;

typedef struct {
	ZSTD_hufCTables_t huf;
	ZSTD_fseCTables_t fse;
} ZSTD_entropyCTables_t;

typedef struct {
	ZSTD_entropyCTables_t entropy;
	U32 rep[3];
} ZSTD_compressedBlockState_t;

typedef struct {
	const BYTE *nextSrc;
	const BYTE *base;
	const BYTE *dictBase;
	U32 dictLimit;
	U32 lowLimit;
	U32 nbOverflowCorrections;
} ZSTD_window_t;

typedef struct {
	U32 off;
	U32 len;
} ZSTD_match_t;

typedef struct {
	int price;
	U32 off;
	U32 mlen;
	U32 litlen;
	U32 rep[3];
} ZSTD_optimal_t;

typedef struct {
	unsigned int *litFreq;
	unsigned int *litLengthFreq;
	unsigned int *matchLengthFreq;
	unsigned int *offCodeFreq;
	ZSTD_match_t *matchTable;
	ZSTD_optimal_t *priceTable;
	U32 litSum;
	U32 litLengthSum;
	U32 matchLengthSum;
	U32 offCodeSum;
	U32 litSumBasePrice;
	U32 litLengthSumBasePrice;
	U32 matchLengthSumBasePrice;
	U32 offCodeSumBasePrice;
	ZSTD_OptPrice_e priceType;
	const ZSTD_entropyCTables_t *symbolCosts;
	ZSTD_paramSwitch_e literalCompressionMode;
} optState_t;

typedef struct {
	unsigned int windowLog;
	unsigned int chainLog;
	unsigned int hashLog;
	unsigned int searchLog;
	unsigned int minMatch;
	unsigned int targetLength;
	ZSTD_strategy strategy;
} ZSTD_compressionParameters;

typedef struct {
	U32 offset;
	U32 litLength;
	U32 matchLength;
} rawSeq;

typedef struct {
	rawSeq *seq;
	size_t pos;
	size_t posInSequence;
	size_t size;
	size_t capacity;
} rawSeqStore_t;

struct ZSTD_matchState_t;

typedef struct ZSTD_matchState_t ZSTD_matchState_t;

struct ZSTD_matchState_t {
	ZSTD_window_t window;
	U32 loadedDictEnd;
	U32 nextToUpdate;
	U32 hashLog3;
	U32 rowHashLog;
	U16___2 *tagTable;
	U32 hashCache[8];
	U32 *hashTable;
	U32 *hashTable3;
	U32 *chainTable;
	U32 forceNonContiguous;
	int dedicatedDictSearch;
	optState_t opt;
	const ZSTD_matchState_t *dictMatchState;
	ZSTD_compressionParameters cParams;
	const rawSeqStore_t *ldmSeqStore;
};

typedef struct {
	ZSTD_compressedBlockState_t *prevCBlock;
	ZSTD_compressedBlockState_t *nextCBlock;
	ZSTD_matchState_t matchState;
} ZSTD_blockState_t;

typedef struct {
	size_t error;
	int lowerBound;
	int upperBound;
} ZSTD_bounds;

typedef struct {
	U32 f1c;
	U32 f1d;
	U32 f7b;
	U32 f7c;
} ZSTD_cpuid_t;

typedef void * (*ZSTD_allocFunction)(void *, size_t);

typedef void (*ZSTD_freeFunction)(void *, void *);

typedef struct {
	ZSTD_allocFunction customAlloc;
	ZSTD_freeFunction customFree;
	void *opaque;
} ZSTD_customMem;

typedef struct {
	void *workspace;
	void *workspaceEnd;
	void *objectEnd;
	void *tableEnd;
	void *tableValidEnd;
	void *allocStart;
	BYTE allocFailed;
	int workspaceOversizedDuration;
	ZSTD_cwksp_alloc_phase_e phase;
	ZSTD_cwksp_static_alloc_e isStatic;
} ZSTD_cwksp;

typedef struct {
	U16___2 nextState;
	BYTE nbAdditionalBits;
	BYTE nbBits;
	U32 baseValue;
} ZSTD_seqSymbol;

typedef struct {
	ZSTD_seqSymbol LLTable[513];
	ZSTD_seqSymbol OFTable[257];
	ZSTD_seqSymbol MLTable[513];
	HUF_DTable hufTable[4097];
	U32 rep[3];
	U32 workspace[157];
} ZSTD_entropyDTables_t;

typedef struct {
	long long unsigned int frameContentSize;
	long long unsigned int windowSize;
	unsigned int blockSizeMax;
	ZSTD_frameType_e frameType;
	unsigned int headerSize;
	unsigned int dictID;
	unsigned int checksumFlag;
} ZSTD_frameHeader;

typedef struct {
	int contentSizeFlag;
	int checksumFlag;
	int noDictIDFlag;
} ZSTD_frameParameters;

typedef struct {
	long long unsigned int ingested;
	long long unsigned int consumed;
	long long unsigned int produced;
	long long unsigned int flushed;
	unsigned int currentJobID;
	unsigned int nbActiveWorkers;
} ZSTD_frameProgression;

typedef struct {
	size_t compressedSize;
	long long unsigned int decompressedBound;
} ZSTD_frameSizeInfo;

typedef struct {
	size_t state;
	const ZSTD_seqSymbol *table;
} ZSTD_fseState;

struct ZSTD_CDict_s;

typedef struct ZSTD_CDict_s ZSTD_CDict;

typedef struct {
	void *dictBuffer;
	const void *dict;
	size_t dictSize;
	ZSTD_dictContentType_e dictContentType;
	ZSTD_CDict *cdict;
} ZSTD_localDict;

typedef struct {
	rawSeqStore_t seqStore;
	U32 startPosInBlock;
	U32 endPosInBlock;
	U32 offset;
} ZSTD_optLdm_t;

typedef struct {
	ZSTD_compressionParameters cParams;
	ZSTD_frameParameters fParams;
} ZSTD_parameters;

typedef struct {
	U32 fastMode;
	U32 tableLog;
} ZSTD_seqSymbol_header;

typedef struct {
	U32 litLength;
	U32 matchLength;
} ZSTD_sequenceLength;

typedef struct {
	U32 idx;
	U32 posInSequence;
	size_t posInSrc;
} ZSTD_sequencePosition;

typedef struct {
	U32 LLtype;
	U32 Offtype;
	U32 MLtype;
	size_t size;
	size_t lastCountSize;
} ZSTD_symbolEncodingTypeStats_t;

typedef struct {
	long unsigned int fds_bits[16];
} __kernel_fd_set;

typedef struct {
	int val[2];
} __kernel_fsid_t;

struct mbox_out {
	u8 cmd;
	u8 cmdid;
	u16 numsectors;
	u32 lba;
	u32 xferaddr;
	u8 logdrv;
	u8 numsgelements;
	u8 resvd;
} __attribute__((packed));

struct mbox_in {
	volatile u8 busy;
	volatile u8 numstatus;
	volatile u8 status;
	volatile u8 completed[46];
	volatile u8 poll;
	volatile u8 ack;
};

typedef struct {
	struct mbox_out m_out;
	struct mbox_in m_in;
} mbox_t;

typedef struct {
	u32 xfer_segment_lo;
	u32 xfer_segment_hi;
	mbox_t mbox;
} __attribute__((packed)) mbox64_t;

struct list_head {
	struct list_head *next;
	struct list_head *prev;
};

typedef struct {
	u32 data_size;
	u32 config_signature;
	u8 fw_version[16];
	u8 bios_version[16];
	u8 product_name[80];
	u8 max_commands;
	u8 nchannels;
	u8 fc_loop_present;
	u8 mem_type;
	u32 signature;
	u16 dram_size;
	u16 subsysid;
	u16 subsysvid;
	u8 notify_counters;
	u8 pad1k[889];
} mega_product_info;

typedef struct {
	u32 address;
	u32 length;
} mega_sglist;

typedef struct {
	u64 address;
	u32 length;
} __attribute__((packed)) mega_sgl64;

typedef struct {
	u8 timeout: 3;
	u8 ars: 1;
	u8 reserved: 3;
	u8 islogical: 1;
	u8 logdrv;
	u8 channel;
	u8 target;
	u8 queuetag;
	u8 queueaction;
	u8 cdb[10];
	u8 cdblen;
	u8 reqsenselen;
	u8 reqsensearea[32];
	u8 numsgelements;
	u8 scsistatus;
	u32 dataxferaddr;
	u32 dataxferlen;
} mega_passthru;

typedef struct {
	u8 timeout: 3;
	u8 ars: 1;
	u8 rsvd1: 1;
	u8 cd_rom: 1;
	u8 rsvd2: 1;
	u8 islogical: 1;
	u8 logdrv;
	u8 channel;
	u8 target;
	u8 queuetag;
	u8 queueaction;
	u8 cdblen;
	u8 rsvd3;
	u8 cdb[16];
	u8 numsgelements;
	u8 status;
	u8 reqsenselen;
	u8 reqsensearea[32];
	u8 rsvd4;
	u32 dataxferaddr;
	u32 dataxferlen;
} mega_ext_passthru;

struct scsi_cmnd;

typedef struct {
	int idx;
	u32 state;
	struct list_head list;
	u8 raw_mbox[66];
	u32 dma_type;
	u32 dma_direction;
	struct scsi_cmnd *cmd;
	dma_addr_t dma_h_bulkdata;
	dma_addr_t dma_h_sgdata;
	mega_sglist *sgl;
	mega_sgl64 *sgl64;
	dma_addr_t sgl_dma_addr;
	mega_passthru *pthru;
	dma_addr_t pthru_dma_addr;
	mega_ext_passthru *epthru;
	dma_addr_t epthru_dma_addr;
} scb_t;

typedef struct {
	int counter;
} atomic_t;

struct qspinlock {
	union {
		atomic_t val;
		struct {
			u8 locked;
			u8 pending;
		};
		struct {
			u16 locked_pending;
			u16 tail;
		};
	};
};

typedef struct qspinlock arch_spinlock_t;

struct raw_spinlock {
	arch_spinlock_t raw_lock;
};

struct spinlock {
	union {
		struct raw_spinlock rlock;
	};
};

typedef struct spinlock spinlock_t;

typedef struct {
	s64 counter;
} atomic64_t;

typedef atomic64_t atomic_long_t;

typedef struct raw_spinlock raw_spinlock_t;

struct optimistic_spin_queue {
	atomic_t tail;
};

struct mutex {
	atomic_long_t owner;
	raw_spinlock_t wait_lock;
	struct optimistic_spin_queue osq;
	struct list_head wait_list;
};

struct swait_queue_head {
	raw_spinlock_t lock;
	struct list_head task_list;
};

struct completion {
	unsigned int done;
	struct swait_queue_head wait;
};

struct pci_dev;

struct Scsi_Host;

struct proc_dir_entry;

typedef struct {
	int this_id;
	u32 flag;
	long unsigned int base;
	void *mmio_base;
	mbox64_t *una_mbox64;
	dma_addr_t una_mbox64_dma;
	volatile mbox64_t *mbox64;
	volatile mbox_t *mbox;
	dma_addr_t mbox_dma;
	struct pci_dev *dev;
	struct list_head free_list;
	struct list_head pending_list;
	struct list_head completed_list;
	struct Scsi_Host *host;
	u8 *mega_buffer;
	dma_addr_t buf_dma_handle;
	mega_product_info product_info;
	u8 max_cmds;
	scb_t *scb_list;
	atomic_t pend_cmds;
	u8 numldrv;
	u8 fw_version[7];
	u8 bios_version[7];
	struct proc_dir_entry *controller_proc_dir_entry;
	int has_64bit_addr;
	int support_ext_cdb;
	int boot_ldrv_enabled;
	int boot_ldrv;
	int boot_pdrv_enabled;
	int boot_pdrv_ch;
	int boot_pdrv_tgt;
	int support_random_del;
	int read_ldidmap;
	atomic_t quiescent;
	spinlock_t lock;
	u8 logdrv_chan[9];
	int mega_ch_class;
	u8 sglen;
	scb_t int_scb;
	struct mutex int_mtx;
	int int_status;
	struct completion int_waitq;
	int has_cluster;
} adapter_t;

struct tasklet_struct {
	struct tasklet_struct *next;
	long unsigned int state;
	atomic_t count;
	bool use_callback;
	union {
		void (*func)(long unsigned int);
		void (*callback)(struct tasklet_struct *);
	};
	long unsigned int data;
};

typedef struct {
	caddr_t ccb;
	struct list_head list;
	long unsigned int gp;
	unsigned int sno;
	struct scsi_cmnd *scp;
	uint32_t state;
	uint32_t dma_direction;
	uint32_t dma_type;
	uint16_t dev_channel;
	uint16_t dev_target;
	uint32_t status;
} scb_t___2;

typedef struct {
	struct tasklet_struct dpc_h;
	struct pci_dev *pdev;
	struct Scsi_Host *host;
	spinlock_t lock;
	uint8_t quiescent;
	int outstanding_cmds;
	scb_t___2 *kscb_list;
	struct list_head kscb_pool;
	spinlock_t kscb_pool_lock;
	struct list_head pend_list;
	spinlock_t pend_list_lock;
	struct list_head completed_list;
	spinlock_t completed_list_lock;
	uint16_t sglen;
	int device_ids[1040];
	caddr_t raid_device;
	uint8_t max_channel;
	uint16_t max_target;
	uint8_t max_lun;
	uint32_t unique_id;
	int irq;
	uint8_t ito;
	caddr_t ibuf;
	dma_addr_t ibuf_dma_h;
	scb_t___2 *uscb_list;
	struct list_head uscb_pool;
	spinlock_t uscb_pool_lock;
	int max_cmds;
	uint8_t fw_version[16];
	uint8_t bios_version[16];
	uint8_t max_cdb_sz;
	uint8_t ha;
	uint16_t init_id;
	uint16_t max_sectors;
	uint16_t cmd_per_lun;
	atomic_t being_detached;
} adapter_t___2;

typedef struct {
	u8 channel;
	u8 target;
} adp_device;

typedef struct {
	u32 start_blk;
	u32 num_blks;
	adp_device device[32];
} adp_span_40ld;

typedef struct {
	u32 start_blk;
	u32 num_blks;
	adp_device device[8];
} adp_span_8ld;

typedef struct {
	U32 tableTime;
	U32 decode256Time;
} algo_time_t;

typedef struct {
	u32 count;
	uint32_t *element;
} bitmap4;

typedef struct {
	blockType_e blockType;
	U32 lastBlock;
	U32 origSize;
} blockProperties_t;

typedef struct {
	union {
		void *kernel;
		void *user;
	};
	bool is_kernel: 1;
} sockptr_t;

typedef sockptr_t bpfptr_t;

typedef struct {
	unsigned int interval;
	unsigned int timeout;
} cisco_proto;

typedef struct {
	int *lock;
	long unsigned int flags;
} class_core_lock_t;

typedef struct {
	void *lock;
} class_cpus_read_lock_t;

typedef struct {
	raw_spinlock_t *lock;
	raw_spinlock_t *lock2;
} class_double_raw_spinlock_t;

struct rq;

typedef struct {
	struct rq *lock;
	struct rq *lock2;
} class_double_rq_lock_t;

typedef struct {
	void *lock;
} class_irq_t;

typedef struct {
	void *lock;
	long unsigned int flags;
} class_irqsave_t;

struct snd_pcm_substream;

typedef struct {
	struct snd_pcm_substream *lock;
} class_pcm_stream_lock_irq_t;

typedef struct {
	struct snd_pcm_substream *lock;
	long unsigned int flags;
} class_pcm_stream_lock_irqsave_t;

typedef struct {
	void *lock;
} class_preempt_notrace_t;

typedef struct {
	void *lock;
} class_preempt_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_irq_t;

typedef struct {
	raw_spinlock_t *lock;
	long unsigned int flags;
} class_raw_spinlock_irqsave_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_t;

typedef struct {
	void *lock;
} class_rcu_t;

typedef struct {
	void *lock;
} class_rcu_tasks_trace_t;

struct qrwlock {
	union {
		atomic_t cnts;
		struct {
			u8 wlocked;
			u8 __lstate[3];
		};
	};
	arch_spinlock_t wait_lock;
};

typedef struct qrwlock arch_rwlock_t;

typedef struct {
	arch_rwlock_t raw_lock;
} rwlock_t;

typedef struct {
	rwlock_t *lock;
	long unsigned int flags;
} class_read_lock_irqsave_t;

struct pin_cookie {};

struct rq_flags {
	long unsigned int flags;
	struct pin_cookie cookie;
};

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irq_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irqsave_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_irq_t;

typedef struct {
	spinlock_t *lock;
	long unsigned int flags;
} class_spinlock_irqsave_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_t;

struct srcu_struct;

typedef struct {
	struct srcu_struct *lock;
	int idx;
} class_srcu_t;

struct task_struct;

typedef struct {
	struct task_struct *lock;
	struct rq *rq;
	struct rq_flags rf;
} class_task_rq_lock_t;

typedef struct {
	rwlock_t *lock;
} class_write_lock_irq_t;

typedef struct {
	rwlock_t *lock;
	long unsigned int flags;
} class_write_lock_irqsave_t;

typedef struct {
	u32 cl_boot;
	u32 cl_id;
} clientid_t;

typedef struct {
	unsigned char op;
	unsigned char bits;
	short unsigned int val;
} code;

typedef struct {
	clientid_t so_clid;
	u32 so_id;
} stateid_opaque_t;

typedef struct {
	u32 si_generation;
	stateid_opaque_t si_opaque;
} stateid_t;

struct refcount_struct {
	atomic_t refs;
};

typedef struct refcount_struct refcount_t;

typedef struct {
	stateid_t cs_stid;
	unsigned char cs_type;
	refcount_t cs_count;
} copy_stateid_t;

typedef struct {
	__be16 disc_information_length;
	__u8 disc_status: 2;
	__u8 border_status: 2;
	__u8 erasable: 1;
	__u8 reserved1: 3;
	__u8 n_first_track;
	__u8 n_sessions_lsb;
	__u8 first_track_lsb;
	__u8 last_track_lsb;
	__u8 mrw_status: 2;
	__u8 dbit: 1;
	__u8 reserved2: 2;
	__u8 uru: 1;
	__u8 dbc_v: 1;
	__u8 did_v: 1;
	__u8 disc_type;
	__u8 n_sessions_msb;
	__u8 first_track_msb;
	__u8 last_track_msb;
	__u32 disc_id;
	__u32 lead_in;
	__u32 lead_out;
	__u8 disc_bar_code[8];
	__u8 reserved3;
	__u8 n_opc;
} disc_information;

typedef struct {
	u8 span_depth;
	u8 level;
	u8 read_ahead;
	u8 stripe_sz;
	u8 status;
	u8 write_mode;
	u8 direct_io;
	u8 row_size;
} logdrv_param;

typedef struct {
	logdrv_param lparam;
	adp_span_40ld span[8];
} logdrv_40ld;

typedef struct {
	u8 type;
	u8 cur_status;
	u8 tag_depth;
	u8 sync_neg;
	u32 size;
} phys_drv;

typedef struct {
	u8 nlog_drives;
	u8 resvd[3];
	logdrv_40ld ldrv[40];
	phys_drv pdrv[75];
} disk_array_40ld;

typedef struct {
	logdrv_param lparam;
	adp_span_8ld span[8];
} logdrv_8ld;

typedef struct {
	u8 nlog_drives;
	u8 resvd[3];
	logdrv_8ld ldrv[8];
	phys_drv pdrv[75];
} disk_array_8ld;

typedef struct {
	long unsigned int bits[1];
} dma_cap_mask_t;

struct dvd_lu_send_agid {
	__u8 type;
	unsigned int agid: 2;
};

struct dvd_host_send_challenge {
	__u8 type;
	unsigned int agid: 2;
	dvd_challenge chal;
};

struct dvd_send_key {
	__u8 type;
	unsigned int agid: 2;
	dvd_key key;
};

struct dvd_lu_send_challenge {
	__u8 type;
	unsigned int agid: 2;
	dvd_challenge chal;
};

struct dvd_lu_send_title_key {
	__u8 type;
	unsigned int agid: 2;
	dvd_key title_key;
	int lba;
	unsigned int cpm: 1;
	unsigned int cp_sec: 1;
	unsigned int cgms: 2;
};

struct dvd_lu_send_asf {
	__u8 type;
	unsigned int agid: 2;
	unsigned int asf: 1;
};

struct dvd_host_send_rpcstate {
	__u8 type;
	__u8 pdrc;
};

struct dvd_lu_send_rpcstate {
	__u8 type: 2;
	__u8 vra: 3;
	__u8 ucca: 3;
	__u8 region_mask;
	__u8 rpc_scheme;
};

typedef union {
	__u8 type;
	struct dvd_lu_send_agid lsa;
	struct dvd_host_send_challenge hsc;
	struct dvd_send_key lsk;
	struct dvd_lu_send_challenge lsc;
	struct dvd_send_key hsk;
	struct dvd_lu_send_title_key lstk;
	struct dvd_lu_send_asf lsasf;
	struct dvd_host_send_rpcstate hrpcs;
	struct dvd_lu_send_rpcstate lrpcs;
} dvd_authinfo;

struct dvd_layer {
	__u8 book_version: 4;
	__u8 book_type: 4;
	__u8 min_rate: 4;
	__u8 disc_size: 4;
	__u8 layer_type: 4;
	__u8 track_path: 1;
	__u8 nlayers: 2;
	char: 1;
	__u8 track_density: 4;
	__u8 linear_density: 4;
	__u8 bca: 1;
	__u32 start_sector;
	__u32 end_sector;
	__u32 end_sector_l0;
};

struct dvd_physical {
	__u8 type;
	__u8 layer_num;
	struct dvd_layer layer[4];
};

struct dvd_copyright {
	__u8 type;
	__u8 layer_num;
	__u8 cpst;
	__u8 rmi;
};

struct dvd_disckey {
	__u8 type;
	unsigned int agid: 2;
	__u8 value[2048];
};

struct dvd_bca {
	__u8 type;
	int len;
	__u8 value[188];
};

struct dvd_manufact {
	__u8 type;
	__u8 layer_num;
	int len;
	__u8 value[2048];
};

typedef union {
	__u8 type;
	struct dvd_physical physical;
	struct dvd_copyright copyright;
	struct dvd_disckey disckey;
	struct dvd_bca bca;
	struct dvd_manufact manufact;
} dvd_struct;

typedef struct {
	u64 length;
	u64 data;
} efi_capsule_block_desc_t;

typedef struct {
	__u8 b[16];
} guid_t;

typedef guid_t efi_guid_t;

typedef struct {
	efi_guid_t guid;
	u32 headersize;
	u32 flags;
	u32 imagesize;
} efi_capsule_header_t;

typedef struct {
	u8 major;
	u8 minor;
} efi_cc_version_t;

typedef struct {
	u8 type;
	u8 sub_type;
} efi_cc_type_t;

typedef struct {
	u8 size;
	efi_cc_version_t structure_version;
	efi_cc_version_t protocol_version;
	efi_cc_event_algorithm_bitmap_t hash_algorithm_bitmap;
	efi_cc_event_log_bitmap_t supported_event_logs;
	efi_cc_type_t cc_type;
} efi_cc_boot_service_cap_t;

typedef struct {
	efi_guid_t guid;
	u32 table;
} efi_config_table_32_t;

typedef struct {
	efi_guid_t guid;
	u64 table;
} efi_config_table_64_t;

typedef union {
	struct {
		efi_guid_t guid;
		void *table;
	};
	efi_config_table_32_t mixed_mode;
} efi_config_table_t;

typedef struct {
	efi_guid_t guid;
	long unsigned int *ptr;
	const char name[16];
} efi_config_table_type_t;

typedef struct {
	u16 year;
	u8 month;
	u8 day;
	u8 hour;
	u8 minute;
	u8 second;
	u8 pad1;
	u32 nanosecond;
	s16 timezone;
	u8 daylight;
	u8 pad2;
} efi_time_t;

typedef struct {
	u64 size;
	u64 file_size;
	u64 phys_size;
	efi_time_t create_time;
	efi_time_t last_access_time;
	efi_time_t modification_time;
	__u64 attribute;
	efi_char16_t filename[0];
} efi_file_info_t;

typedef struct {
	u32 red_mask;
	u32 green_mask;
	u32 blue_mask;
	u32 reserved_mask;
} efi_pixel_bitmask_t;

typedef struct {
	u32 version;
	u32 horizontal_resolution;
	u32 vertical_resolution;
	int pixel_format;
	efi_pixel_bitmask_t pixel_information;
	u32 pixels_per_scan_line;
} efi_graphics_output_mode_info_t;

typedef struct {
	u16 scan_code;
	efi_char16_t unicode_char;
} efi_input_key_t;

typedef struct {
	u32 attributes;
	u16 file_path_list_length;
	u8 variable_data[0];
} __attribute__((packed)) efi_load_option_t;

struct efi_generic_dev_path;

typedef struct efi_generic_dev_path efi_device_path_protocol_t;

typedef struct {
	u32 attributes;
	u16 file_path_list_length;
	const efi_char16_t *description;
	const efi_device_path_protocol_t *file_path_list;
	u32 optional_data_size;
	const void *optional_data;
} efi_load_option_unpacked_t;

typedef void *efi_handle_t;

typedef struct {
	u64 signature;
	u32 revision;
	u32 headersize;
	u32 crc32;
	u32 reserved;
} efi_table_hdr_t;

typedef struct {
	u32 resolution;
	u32 accuracy;
	u8 sets_to_zero;
} efi_time_cap_t;

typedef efi_status_t efi_get_time_t(efi_time_t *, efi_time_cap_t *);

typedef efi_status_t efi_set_time_t(efi_time_t *);

typedef efi_status_t efi_get_wakeup_time_t(efi_bool_t *, efi_bool_t *, efi_time_t *);

typedef efi_status_t efi_set_wakeup_time_t(efi_bool_t, efi_time_t *);

typedef struct {
	u32 type;
	u32 pad;
	u64 phys_addr;
	u64 virt_addr;
	u64 num_pages;
	u64 attribute;
} efi_memory_desc_t;

typedef efi_status_t efi_set_virtual_address_map_t(long unsigned int, long unsigned int, u32, efi_memory_desc_t *);

typedef efi_status_t efi_get_variable_t(efi_char16_t *, efi_guid_t *, u32 *, long unsigned int *, void *);

typedef efi_status_t efi_get_next_variable_t(long unsigned int *, efi_char16_t *, efi_guid_t *);

typedef efi_status_t efi_set_variable_t(efi_char16_t *, efi_guid_t *, u32, long unsigned int, void *);

typedef efi_status_t efi_get_next_high_mono_count_t(u32 *);

typedef void efi_reset_system_t(int, efi_status_t, long unsigned int, efi_char16_t *);

typedef efi_status_t efi_update_capsule_t(efi_capsule_header_t **, long unsigned int, long unsigned int);

typedef efi_status_t efi_query_capsule_caps_t(efi_capsule_header_t **, long unsigned int, u64 *, int *);

typedef efi_status_t efi_query_variable_info_t(u32, u64 *, u64 *, u64 *);

typedef struct {
	efi_table_hdr_t hdr;
	u32 get_time;
	u32 set_time;
	u32 get_wakeup_time;
	u32 set_wakeup_time;
	u32 set_virtual_address_map;
	u32 convert_pointer;
	u32 get_variable;
	u32 get_next_variable;
	u32 set_variable;
	u32 get_next_high_mono_count;
	u32 reset_system;
	u32 update_capsule;
	u32 query_capsule_caps;
	u32 query_variable_info;
} efi_runtime_services_32_t;

typedef union {
	struct {
		efi_table_hdr_t hdr;
		efi_get_time_t *get_time;
		efi_set_time_t *set_time;
		efi_get_wakeup_time_t *get_wakeup_time;
		efi_set_wakeup_time_t *set_wakeup_time;
		efi_set_virtual_address_map_t *set_virtual_address_map;
		void *convert_pointer;
		efi_get_variable_t *get_variable;
		efi_get_next_variable_t *get_next_variable;
		efi_set_variable_t *set_variable;
		efi_get_next_high_mono_count_t *get_next_high_mono_count;
		efi_reset_system_t *reset_system;
		efi_update_capsule_t *update_capsule;
		efi_query_capsule_caps_t *query_capsule_caps;
		efi_query_variable_info_t *query_variable_info;
	};
	efi_runtime_services_32_t mixed_mode;
} efi_runtime_services_t;

typedef struct {
	efi_table_hdr_t hdr;
	u32 fw_vendor;
	u32 fw_revision;
	u32 con_in_handle;
	u32 con_in;
	u32 con_out_handle;
	u32 con_out;
	u32 stderr_handle;
	u32 stderr;
	u32 runtime;
	u32 boottime;
	u32 nr_tables;
	u32 tables;
} efi_system_table_32_t;

union efi_simple_text_input_protocol;

typedef union efi_simple_text_input_protocol efi_simple_text_input_protocol_t;

union efi_simple_text_output_protocol;

typedef union efi_simple_text_output_protocol efi_simple_text_output_protocol_t;

union efi_boot_services;

typedef union efi_boot_services efi_boot_services_t;

typedef union {
	struct {
		efi_table_hdr_t hdr;
		long unsigned int fw_vendor;
		u32 fw_revision;
		long unsigned int con_in_handle;
		efi_simple_text_input_protocol_t *con_in;
		long unsigned int con_out_handle;
		efi_simple_text_output_protocol_t *con_out;
		long unsigned int stderr_handle;
		long unsigned int stderr;
		efi_runtime_services_t *runtime;
		efi_boot_services_t *boottime;
		long unsigned int nr_tables;
		long unsigned int tables;
	};
	efi_system_table_32_t mixed_mode;
} efi_system_table_t;

typedef union {
	struct {
		u32 revision;
		efi_handle_t parent_handle;
		efi_system_table_t *system_table;
		efi_handle_t device_handle;
		void *file_path;
		void *reserved;
		u32 load_options_size;
		void *load_options;
		void *image_base;
		__u64 image_size;
		unsigned int image_code_type;
		unsigned int image_data_type;
		efi_status_t (*unload)(efi_handle_t);
	};
	struct {
		u32 revision;
		u32 parent_handle;
		u32 system_table;
		u32 device_handle;
		u32 file_path;
		u32 reserved;
		u32 load_options_size;
		u32 load_options;
		u32 image_base;
		__u64 image_size;
		u32 image_code_type;
		u32 image_data_type;
		u32 unload;
	} mixed_mode;
} efi_loaded_image_t;

typedef struct {
	u32 version;
	u32 num_entries;
	u32 desc_size;
	u32 flags;
	efi_memory_desc_t entry[0];
} efi_memory_attributes_table_t;

typedef struct {
	u32 read;
	u32 write;
} efi_pci_io_protocol_access_32_t;

typedef struct {
	void *read;
	void *write;
} efi_pci_io_protocol_access_t;

union efi_pci_io_protocol;

typedef union efi_pci_io_protocol efi_pci_io_protocol_t;

typedef efi_status_t (*efi_pci_io_protocol_cfg_t)(efi_pci_io_protocol_t *, EFI_PCI_IO_PROTOCOL_WIDTH, u32, long unsigned int, void *);

typedef struct {
	efi_pci_io_protocol_cfg_t read;
	efi_pci_io_protocol_cfg_t write;
} efi_pci_io_protocol_config_access_t;

typedef struct {
	u16 version;
	u16 length;
	u32 runtime_services_supported;
} efi_rt_properties_table_t;

typedef struct {
	__le16 e_tag;
	__le16 e_perm;
	__le32 e_id;
} ext2_acl_entry;

typedef struct {
	__le32 a_version;
} ext2_acl_header;

typedef struct {
	__le16 e_tag;
	__le16 e_perm;
	__le32 e_id;
} ext4_acl_entry;

typedef struct {
	__le32 a_version;
} ext4_acl_header;

typedef __kernel_fd_set fd_set;

typedef struct {
	long unsigned int *in;
	long unsigned int *out;
	long unsigned int *ex;
	long unsigned int *res_in;
	long unsigned int *res_out;
	long unsigned int *res_ex;
} fd_set_bits;

typedef struct {
	atomic64_t refcnt;
} file_ref_t;

typedef struct {
	unsigned int t391;
	unsigned int t392;
	unsigned int n391;
	unsigned int n392;
	unsigned int n393;
	short unsigned int lmi;
	short unsigned int dce;
} fr_proto;

typedef struct {
	unsigned int dlci;
} fr_proto_pvc;

typedef struct {
	unsigned int dlci;
	char master[16];
} fr_proto_pvc_info;

typedef union {
	struct {
		void *freelist;
		long unsigned int counter;
	};
	freelist_full_t full;
} freelist_aba_t;

typedef struct {
	long unsigned int v;
} freeptr_t;

typedef struct {
	long unsigned int key[2];
} hsiphash_key_t;

typedef struct {
	unsigned int ipi_irqs[4];
	unsigned int __softirq_pending;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	atomic_t message;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} irq_cpustat_t;

typedef struct {
	u64 val;
} kernel_cap_t;

typedef struct {
	gid_t val;
} kgid_t;

typedef struct {
	projid_t val;
} kprojid_t;

typedef struct {
	uid_t val;
} kuid_t;

typedef struct {
	U32 offset;
	U32 checksum;
} ldmEntry_t;

typedef struct {
	const BYTE *split;
	U32 hash;
	U32 checksum;
	ldmEntry_t *bucket;
} ldmMatchCandidate_t;

typedef struct {
	ZSTD_paramSwitch_e enableLdm;
	U32 hashLog;
	U32 bucketSizeLog;
	U32 minMatchLength;
	U32 hashRateLog;
	U32 windowLog;
} ldmParams_t;

typedef struct {
	U64___2 rolling;
	U64___2 stopMask;
} ldmRollingHashState_t;

typedef struct {
	ZSTD_window_t window;
	ldmEntry_t *hashTable;
	U32 loadedDictEnd;
	BYTE *bucketOffsets;
	size_t splitIndices[64];
	ldmMatchCandidate_t matchCandidates[64];
} ldmState_t;

typedef struct {
	__le64 b;
	__le64 a;
} le128;

typedef struct {
	atomic_long_t a;
} local_t;

typedef struct {
	local_t a;
} local64_t;

typedef struct {} local_lock_t;

typedef struct {} lockdep_map_p;

typedef struct {
	uint8_t cmd;
	uint8_t cmdid;
	uint16_t numsectors;
	uint32_t lba;
	uint32_t xferaddr;
	uint8_t logdrv;
	uint8_t numsge;
	uint8_t resvd;
	uint8_t busy;
	uint8_t numstatus;
	uint8_t status;
	uint8_t completed[46];
	uint8_t poll;
	uint8_t ack;
} __attribute__((packed)) mbox_t___2;

typedef struct {
	uint32_t xferaddr_lo;
	uint32_t xferaddr_hi;
	mbox_t___2 mbox32;
} __attribute__((packed)) mbox64_t___2;

typedef struct {
	uint64_t address;
	uint32_t length;
} __attribute__((packed)) mbox_sgl64;

typedef struct {
	uint32_t address;
	uint32_t length;
} mbox_sgl32;

typedef struct {
	uint8_t timeout: 3;
	uint8_t ars: 1;
	uint8_t reserved: 3;
	uint8_t islogical: 1;
	uint8_t logdrv;
	uint8_t channel;
	uint8_t target;
	uint8_t queuetag;
	uint8_t queueaction;
	uint8_t cdb[10];
	uint8_t cdblen;
	uint8_t reqsenselen;
	uint8_t reqsensearea[32];
	uint8_t numsge;
	uint8_t scsistatus;
	uint32_t dataxferaddr;
	uint32_t dataxferlen;
} mraid_passthru_t;

typedef struct {
	uint8_t timeout: 3;
	uint8_t ars: 1;
	uint8_t rsvd1: 1;
	uint8_t cd_rom: 1;
	uint8_t rsvd2: 1;
	uint8_t islogical: 1;
	uint8_t logdrv;
	uint8_t channel;
	uint8_t target;
	uint8_t queuetag;
	uint8_t queueaction;
	uint8_t cdblen;
	uint8_t rsvd3;
	uint8_t cdb[16];
	uint8_t numsge;
	uint8_t status;
	uint8_t reqsenselen;
	uint8_t reqsensearea[32];
	uint8_t rsvd4;
	uint32_t dataxferaddr;
	uint32_t dataxferlen;
} mraid_epassthru_t;

typedef struct {
	uint8_t *raw_mbox;
	mbox_t___2 *mbox;
	mbox64_t___2 *mbox64;
	dma_addr_t mbox_dma_h;
	mbox_sgl64 *sgl64;
	mbox_sgl32 *sgl32;
	dma_addr_t sgl_dma_h;
	mraid_passthru_t *pthru;
	dma_addr_t pthru_dma_h;
	mraid_epassthru_t *epthru;
	dma_addr_t epthru_dma_h;
	dma_addr_t buf_dma_h;
} mbox_ccb_t;

typedef struct {
	u8 max_commands;
	u8 rebuild_rate;
	u8 max_targ_per_chan;
	u8 nchannels;
	u8 fw_version[4];
	u16 age_of_flash;
	u8 chip_set_value;
	u8 dram_size;
	u8 cache_flush_interval;
	u8 bios_version[4];
	u8 board_type;
	u8 sense_alert;
	u8 write_config_count;
	u8 drive_inserted_count;
	u8 inserted_drive;
	u8 battery_status;
	u8 dec_fault_bus_info;
} mega_adp_info;

struct notify {
	u32 global_counter;
	u8 param_counter;
	u8 param_id;
	u16 param_val;
	u8 write_config_counter;
	u8 write_config_rsvd[3];
	u8 ldrv_op_counter;
	u8 ldrv_opid;
	u8 ldrv_opcmd;
	u8 ldrv_opstatus;
	u8 ldrv_state_counter;
	u8 ldrv_state_id;
	u8 ldrv_state_new;
	u8 ldrv_state_old;
	u8 pdrv_state_counter;
	u8 pdrv_state_id;
	u8 pdrv_state_new;
	u8 pdrv_state_old;
	u8 pdrv_fmt_counter;
	u8 pdrv_fmt_id;
	u8 pdrv_fmt_val;
	u8 pdrv_fmt_rsvd;
	u8 targ_xfer_counter;
	u8 targ_xfer_id;
	u8 targ_xfer_val;
	u8 targ_xfer_rsvd;
	u8 fcloop_id_chg_counter;
	u8 fcloopid_pdrvid;
	u8 fcloop_id0;
	u8 fcloop_id1;
	u8 fcloop_state_counter;
	u8 fcloop_state0;
	u8 fcloop_state1;
	u8 fcloop_state_rsvd;
};

typedef struct {
	u32 data_size;
	struct notify notify;
	u8 notify_rsvd[88];
	u8 rebuild_rate;
	u8 cache_flush_interval;
	u8 sense_alert;
	u8 drive_insert_count;
	u8 battery_status;
	u8 num_ldrv;
	u8 recon_state[5];
	u16 ldrv_op_status[5];
	u32 ldrv_size[40];
	u8 ldrv_prop[40];
	u8 ldrv_state[40];
	u8 pdrv_state[256];
	u16 pdrv_format[16];
	u8 targ_xfer[80];
	u8 pad1k[263];
} __attribute__((packed)) mega_inquiry3;

typedef struct {
	u8 num_ldrv;
	u8 rsvd[3];
	u32 ldrv_size[8];
	u8 ldrv_prop[8];
	u8 ldrv_state[8];
} mega_ldrv_info;

typedef struct {
	u8 pdrv_state[75];
	u8 rsvd;
} mega_pdrv_info;

typedef struct {
	u8 cmd;
	u8 cmdid;
	u8 opcode;
	u8 subopcode;
	u32 lba;
	u32 xferaddr;
	u8 logdrv;
	u8 rsvd[3];
	u8 numstatus;
	u8 status;
} __attribute__((packed)) megacmd_t;

typedef struct {
	u64 asid[256];
	void *vdso;
} mm_context_t;

struct mraid_pci_blk {
	caddr_t vaddr;
	dma_addr_t dma_addr;
};

struct wait_queue_head {
	spinlock_t lock;
	struct list_head head;
};

typedef struct wait_queue_head wait_queue_head_t;

struct dma_pool;

struct uioc;

typedef struct uioc uioc_t;

typedef struct {
	mbox64_t___2 *una_mbox64;
	dma_addr_t una_mbox64_dma;
	mbox_t___2 *mbox;
	mbox64_t___2 *mbox64;
	dma_addr_t mbox_dma;
	spinlock_t mailbox_lock;
	long unsigned int baseport;
	void *baseaddr;
	struct mraid_pci_blk mbox_pool[128];
	struct dma_pool *mbox_pool_handle;
	struct mraid_pci_blk epthru_pool[128];
	struct dma_pool *epthru_pool_handle;
	struct mraid_pci_blk sg_pool[128];
	struct dma_pool *sg_pool_handle;
	mbox_ccb_t ccb_list[128];
	mbox_ccb_t uccb_list[32];
	mbox64_t___2 umbox64[32];
	uint8_t pdrv_state[75];
	uint32_t last_disp;
	int hw_error;
	int fast_load;
	uint8_t channel_class;
	struct mutex sysfs_mtx;
	uioc_t *sysfs_uioc;
	mbox64_t___2 *sysfs_mbox64;
	caddr_t sysfs_buffer;
	dma_addr_t sysfs_buffer_dma;
	wait_queue_head_t sysfs_wait_q;
	int random_del_supported;
	uint16_t curr_ldmap[64];
} mraid_device_t;

typedef struct {
	mega_adp_info adapter_info;
	mega_ldrv_info logdrv_info;
	mega_pdrv_info pdrv_info;
} mraid_inquiry;

typedef struct {
	mraid_inquiry raid_inq;
	u16 phys_drv_format[5];
	u8 stack_attn;
	u8 modem_status;
	u8 rsvd[2];
} __attribute__((packed)) mraid_ext_inquiry;

typedef struct {
	uint32_t global_counter;
	uint8_t param_counter;
	uint8_t param_id;
	uint16_t param_val;
	uint8_t write_config_counter;
	uint8_t write_config_rsvd[3];
	uint8_t ldrv_op_counter;
	uint8_t ldrv_opid;
	uint8_t ldrv_opcmd;
	uint8_t ldrv_opstatus;
	uint8_t ldrv_state_counter;
	uint8_t ldrv_state_id;
	uint8_t ldrv_state_new;
	uint8_t ldrv_state_old;
	uint8_t pdrv_state_counter;
	uint8_t pdrv_state_id;
	uint8_t pdrv_state_new;
	uint8_t pdrv_state_old;
	uint8_t pdrv_fmt_counter;
	uint8_t pdrv_fmt_id;
	uint8_t pdrv_fmt_val;
	uint8_t pdrv_fmt_rsvd;
	uint8_t targ_xfer_counter;
	uint8_t targ_xfer_id;
	uint8_t targ_xfer_val;
	uint8_t targ_xfer_rsvd;
	uint8_t fcloop_id_chg_counter;
	uint8_t fcloopid_pdrvid;
	uint8_t fcloop_id0;
	uint8_t fcloop_id1;
	uint8_t fcloop_state_counter;
	uint8_t fcloop_state0;
	uint8_t fcloop_state1;
	uint8_t fcloop_state_rsvd;
} mraid_notify_t;

typedef struct {
	uint32_t data_size;
	mraid_notify_t notify;
	uint8_t notify_rsvd[88];
	uint8_t rebuild_rate;
	uint8_t cache_flush_int;
	uint8_t sense_alert;
	uint8_t drive_insert_count;
	uint8_t battery_status;
	uint8_t num_ldrv;
	uint8_t recon_state[5];
	uint16_t ldrv_op_status[5];
	uint32_t ldrv_size[40];
	uint8_t ldrv_prop[40];
	uint8_t ldrv_state[40];
	uint8_t pdrv_state[256];
	uint16_t pdrv_format[16];
	uint8_t targ_xfer[80];
	uint8_t pad1k[263];
} __attribute__((packed)) mraid_inquiry3_t;

typedef struct {
	uint32_t data_size;
	uint32_t config_signature;
	uint8_t fw_version[16];
	uint8_t bios_version[16];
	uint8_t product_name[80];
	uint8_t max_commands;
	uint8_t nchannels;
	uint8_t fc_loop_present;
	uint8_t mem_type;
	uint32_t signature;
	uint16_t dram_size;
	uint16_t subsysid;
	uint16_t subsysvid;
	uint8_t notify_counters;
	uint8_t pad1k[889];
} mraid_pinfo_t;

typedef struct {} netdevice_tracker;

typedef struct {} netns_tracker;

typedef struct {
	char data[8];
} nfs4_verifier;

typedef struct {
	char signature[8];
	u32 opcode;
	u32 adapno;
	union {
		u8 __raw_mbox[18];
		void *__uaddr;
	} __ua;
	u32 xferlen;
	u32 flags;
} nitioctl_t;

typedef struct {
	long unsigned int bits[1];
} nodemask_t;

typedef struct {
	long unsigned int pgd;
} pgd_t;

typedef struct {
	pgd_t pgd;
} p4d_t;

typedef struct {
	u64 pme;
} pagemap_entry_t;

typedef struct {
	u64 val;
} pfn_t;

typedef struct {
	long unsigned int pgprot;
} pgprot_t;

typedef struct {
	long unsigned int pmd;
} pmd_t;

typedef struct {
	long unsigned int bits[4];
} pnp_irq_mask_t;

struct net;

typedef struct {
	struct net *net;
} possible_net_t;

typedef struct {
	long unsigned int pte;
} pte_t;

typedef struct {
	p4d_t p4d;
} pud_t;

typedef struct {
	short unsigned int encoding;
	short unsigned int parity;
} raw_hdlc_proto;

typedef struct {
	atomic_t refcnt;
} rcuref_t;

typedef struct {
	size_t written;
	size_t count;
	union {
		char *buf;
		void *data;
	} arg;
	int error;
} read_descriptor_t;

typedef struct {
	u16 reg;
	u32 val;
} reg_val;

typedef union {
} release_pages_arg;

typedef struct {
	__u16 report_key_length;
	__u8 reserved1;
	__u8 reserved2;
	__u8 ucca: 3;
	__u8 vra: 3;
	__u8 type_code: 2;
	__u8 region_mask;
	__u8 rpc_scheme;
	__u8 reserved3;
} rpc_state_t;

typedef struct {
	BIT_DStream_t DStream;
	ZSTD_fseState stateLL;
	ZSTD_fseState stateOffb;
	ZSTD_fseState stateML;
	size_t prevOffset[3];
} seqState_t;

typedef struct {
	U32 *splitLocations;
	size_t idx;
} seqStoreSplits;

typedef struct {
	size_t litLength;
	size_t matchLength;
	size_t offset;
} seq_t;

struct seqcount {
	unsigned int sequence;
};

typedef struct seqcount seqcount_t;

typedef struct {
	seqcount_t seqcount;
} seqcount_latch_t;

struct seqcount_spinlock {
	seqcount_t seqcount;
};

typedef struct seqcount_spinlock seqcount_spinlock_t;

typedef struct {
	seqcount_spinlock_t seqcount;
	spinlock_t lock;
} seqlock_t;

typedef struct {
	long unsigned int sig[1];
} sigset_t;

typedef struct {
	u64 key[2];
} siphash_key_t;

typedef struct {
	spinlock_t slock;
	int owned;
	wait_queue_head_t wq;
} socket_lock_t;

typedef struct {
	char *from;
	char *to;
} substring_t;

typedef struct {
	long unsigned int val;
} swp_entry_t;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
} sync_serial_settings;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
	unsigned int slot_map;
} te1_settings;

typedef struct {
	__be16 track_information_length;
	__u8 track_lsb;
	__u8 session_lsb;
	__u8 reserved1;
	__u8 track_mode: 4;
	__u8 copy: 1;
	__u8 damage: 1;
	__u8 reserved2: 2;
	__u8 data_mode: 4;
	__u8 fp: 1;
	__u8 packet: 1;
	__u8 blank: 1;
	__u8 rt: 1;
	__u8 nwa_v: 1;
	__u8 lra_v: 1;
	__u8 reserved3: 6;
	__be32 track_start;
	__be32 next_writable;
	__be32 free_blocks;
	__be32 fixed_packet_size;
	__be32 track_size;
	__be32 last_rec_address;
} track_information;

typedef struct {
	int data;
	int audio;
	int cdi;
	int xa;
	long int error;
} tracktype;

typedef struct {
	local64_t v;
} u64_stats_t;

typedef struct {
	__u8 b[16];
} uuid_t;

typedef struct {
	gid_t val;
} vfsgid_t;

typedef struct {
	uid_t val;
} vfsuid_t;

typedef struct {
	short unsigned int dce;
	unsigned int modulo;
	unsigned int window;
	unsigned int t1;
	unsigned int t2;
	unsigned int n2;
} x25_hdlc_proto;

struct in6_addr {
	union {
		__u8 u6_addr8[16];
		__be16 u6_addr16[8];
		__be32 u6_addr32[4];
	} in6_u;
};

typedef union {
	__be32 a4;
	__be32 a6[4];
	struct in6_addr in6;
} xfrm_address_t;

typedef ZSTD_compressionParameters zstd_compression_parameters;

typedef ZSTD_customMem zstd_custom_mem;

typedef ZSTD_frameHeader zstd_frame_header;

typedef ZSTD_parameters zstd_parameters;

union ATTO_SAS_ADDRESS {
	U8 b[8];
	U16 w[4];
	U32___2 d[2];
	U64 q;
};

struct ATTO_SAS_NVRAM {
	u8 Signature[4];
	u8 Version;
	u8 Checksum;
	u8 Pad[10];
	u8 SasAddr[8];
	u8 Reserved[232];
};

struct DIAG_BUFFER_START {
	__le32 Size;
	__le32 DiagVersion;
	u8 BufferType;
	u8 Reserved[3];
	__le32 Reserved1;
	__le32 Reserved2;
	__le32 Reserved3;
};

struct IOV_111 {
	u8 maxVFsSupported;
	u8 numVFsEnabled;
	u8 requestorId;
	u8 reserved[5];
};

struct IO_REQUEST_INFO {
	u64 ldStartBlock;
	u32 numBlocks;
	u16 ldTgtId;
	u8 isRead;
	__le16 devHandle;
	u8 pd_interface;
	u64 pdBlock;
	u8 fpOkForIo;
	u8 IoforUnevenSpan;
	u8 start_span;
	u8 do_fp_rlbypass;
	u64 start_row;
	u8 span_arm;
	u8 pd_after_lb;
	u16 r1_alt_dev_handle;
	bool ra_capable;
	u8 data_arms;
};

struct LD_LOAD_BALANCE_INFO {
	u8 loadBalanceFlag;
	u8 reserved1;
	atomic_t scsi_pending_cmds[256];
	u64 last_accessed_block[256];
};

struct megasas_cmd_fusion;

struct STREAM_DETECT {
	u64 next_seq_lba;
	struct megasas_cmd_fusion *first_cmd_fusion;
	struct megasas_cmd_fusion *last_cmd_fusion;
	u32 count_cmds_in_stream;
	u16 num_sges_in_group;
	u8 is_read;
	u8 group_depth;
	bool group_flush;
	u8 reserved[7];
};

struct LD_STREAM_DETECT {
	bool write_back;
	bool fp_write_enabled;
	bool members_ssds;
	bool fp_cache_bypass_capable;
	u32 mru_bit_map;
	struct STREAM_DETECT stream_track[8];
};

struct _LD_SPAN_SET {
	u64 log_start_lba;
	u64 log_end_lba;
	u64 span_row_start;
	u64 span_row_end;
	u64 data_strip_start;
	u64 data_strip_end;
	u64 data_row_start;
	u64 data_row_end;
	u8 strip_offset[8];
	u32 span_row_data_width;
	u32 diff;
	u32 reserved[2];
};

typedef struct _LD_SPAN_SET LD_SPAN_SET;

struct LOG_BLOCK_SPAN_INFO {
	LD_SPAN_SET span_set[8];
};

typedef struct LOG_BLOCK_SPAN_INFO LD_SPAN_INFO;

typedef struct LOG_BLOCK_SPAN_INFO *PLD_SPAN_INFO;

struct MEGASAS_RAID_MFA_IO_REQUEST_DESCRIPTOR {
	u32 RequestFlags: 8;
	u32 MessageAddress1: 24;
	u32 MessageAddress2;
};

struct MPI2_DEFAULT_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 DescriptorTypeDependent;
};

struct MPI2_HIGH_PRIORITY_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 Reserved1;
};

struct MPI2_SCSI_IO_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 DevHandle;
};

struct MPI2_SCSI_TARGET_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 IoIndex;
};

struct MPI2_RAID_ACCEL_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 Reserved;
};

union MEGASAS_REQUEST_DESCRIPTOR_UNION {
	struct MPI2_DEFAULT_REQUEST_DESCRIPTOR Default;
	struct MPI2_HIGH_PRIORITY_REQUEST_DESCRIPTOR HighPriority;
	struct MPI2_SCSI_IO_REQUEST_DESCRIPTOR SCSIIO;
	struct MPI2_SCSI_TARGET_REQUEST_DESCRIPTOR SCSITarget;
	struct MPI2_RAID_ACCEL_REQUEST_DESCRIPTOR RAIDAccelerator;
	struct MEGASAS_RAID_MFA_IO_REQUEST_DESCRIPTOR MFAIo;
	union {
		struct {
			__le32 low;
			__le32 high;
		} u;
		__le64 Words;
	};
};

struct MPI25_IEEE_SGE_CHAIN64 {
	__le64 Address;
	__le32 Length;
	__le16 Reserved1;
	u8 NextChainOffset;
	u8 Flags;
};

struct MPI2_ADDRESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le32 ReplyFrameAddress;
};

struct MPI2_DEFAULT_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 DescriptorTypeDependent1;
	__le32 DescriptorTypeDependent2;
};

struct MPI2_IEEE_SGE_CHAIN32 {
	__le32 Address;
	__le32 FlagsLength;
};

struct MPI2_IEEE_SGE_CHAIN64 {
	__le64 Address;
	__le32 Length;
	__le16 Reserved1;
	u8 Reserved2;
	u8 Flags;
};

union MPI2_IEEE_SGE_CHAIN_UNION {
	struct MPI2_IEEE_SGE_CHAIN32 Chain32;
	struct MPI2_IEEE_SGE_CHAIN64 Chain64;
};

struct MPI2_IEEE_SGE_SIMPLE32 {
	__le32 Address;
	__le32 FlagsLength;
};

struct MPI2_IEEE_SGE_SIMPLE64 {
	__le64 Address;
	__le32 Length;
	__le16 Reserved1;
	u8 Reserved2;
	u8 Flags;
};

union MPI2_IEEE_SGE_SIMPLE_UNION {
	struct MPI2_IEEE_SGE_SIMPLE32 Simple32;
	struct MPI2_IEEE_SGE_SIMPLE64 Simple64;
};

struct MPI2_IOC_INIT_RDPQ_ARRAY_ENTRY {
	u64 RDPQBaseAddress;
	u32 Reserved1;
	u32 Reserved2;
};

struct MPI2_IOC_INIT_REQUEST {
	u8 WhoInit;
	u8 Reserved1;
	u8 ChainOffset;
	u8 Function;
	__le16 Reserved2;
	u8 Reserved3;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	__le16 Reserved4;
	__le16 MsgVersion;
	__le16 HeaderVersion;
	u32 Reserved5;
	__le16 Reserved6;
	u8 HostPageSize;
	u8 HostMSIxVectors;
	__le16 Reserved8;
	__le16 SystemRequestFrameSize;
	__le16 ReplyDescriptorPostQueueDepth;
	__le16 ReplyFreeQueueDepth;
	__le32 SenseBufferAddressHigh;
	__le32 SystemReplyAddressHigh;
	__le64 SystemRequestFrameBaseAddress;
	__le64 ReplyDescriptorPostQueueAddress;
	__le64 ReplyFreeQueueAddress;
	__le64 TimeStamp;
};

struct MPI2_RAID_ACCELERATOR_SUCCESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le32 Reserved;
};

struct MPI2_SCSI_IO_CDB_EEDP32 {
	u8 CDB[20];
	__be32 PrimaryReferenceTag;
	__be16 PrimaryApplicationTag;
	__be16 PrimaryApplicationTagMask;
	__le32 TransferLength;
};

struct MPI2_SGE_SIMPLE_UNION {
	__le32 FlagsLength;
	union {
		__le32 Address32;
		__le64 Address64;
	} u;
};

union MPI2_SCSI_IO_CDB_UNION {
	u8 CDB32[32];
	struct MPI2_SCSI_IO_CDB_EEDP32 EEDP32;
	struct MPI2_SGE_SIMPLE_UNION SGE;
};

struct RAID_CONTEXT {
	u8 type: 4;
	u8 nseg: 4;
	u8 resvd0;
	__le16 timeout_value;
	u8 reg_lock_flags;
	u8 resvd1;
	__le16 virtual_disk_tgt_id;
	__le64 reg_lock_row_lba;
	__le32 reg_lock_length;
	__le16 next_lmid;
	u8 ex_status;
	u8 status;
	u8 raid_flags;
	u8 num_sge;
	__le16 config_seq_num;
	u8 span_arm;
	u8 priority;
	u8 num_sge_ext;
	u8 resvd2;
};

struct RAID_CONTEXT_G35 {
	u16 nseg_type;
	u16 timeout_value;
	u16 routing_flags;
	u16 virtual_disk_tgt_id;
	__le64 reg_lock_row_lba;
	u32 reg_lock_length;
	union {
		u16 rmw_op_index;
		u16 peer_smid;
		u16 r56_arm_map;
	} flow_specific;
	u8 ex_status;
	u8 status;
	u8 raid_flags;
	u8 span_arm;
	u16 config_seq_num;
	union {
		struct {
			u16 num_sge: 12;
			u16 reserved: 3;
			u16 stream_detected: 1;
		} bits;
		u8 bytes[2];
	} u;
	u8 resvd2[2];
};

union RAID_CONTEXT_UNION {
	struct RAID_CONTEXT raid_context;
	struct RAID_CONTEXT_G35 raid_context_g35;
};

struct MPI2_SGE_CHAIN_UNION {
	__le16 Length;
	u8 NextChainOffset;
	u8 Flags;
	union {
		__le32 Address32;
		__le64 Address64;
	} u;
};

union MPI2_SGE_IO_UNION {
	struct MPI2_SGE_SIMPLE_UNION MpiSimple;
	struct MPI2_SGE_CHAIN_UNION MpiChain;
	union MPI2_IEEE_SGE_SIMPLE_UNION IeeeSimple;
	union MPI2_IEEE_SGE_CHAIN_UNION IeeeChain;
};

struct MPI2_RAID_SCSI_IO_REQUEST {
	__le16 DevHandle;
	u8 ChainOffset;
	u8 Function;
	__le16 Reserved1;
	u8 Reserved2;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	__le16 Reserved3;
	__le32 SenseBufferLowAddress;
	__le16 SGLFlags;
	u8 SenseBufferLength;
	u8 Reserved4;
	u8 SGLOffset0;
	u8 SGLOffset1;
	u8 SGLOffset2;
	u8 SGLOffset3;
	__le32 SkipCount;
	__le32 DataLength;
	__le32 BidirectionalDataLength;
	__le16 IoFlags;
	__le16 EEDPFlags;
	__le32 EEDPBlockSize;
	__le32 SecondaryReferenceTag;
	__le16 SecondaryApplicationTag;
	__le16 ApplicationTagTranslationMask;
	u8 LUN[8];
	__le32 Control;
	union MPI2_SCSI_IO_CDB_UNION CDB;
	union RAID_CONTEXT_UNION RaidContext;
	union {
		union MPI2_SGE_IO_UNION SGL;
		struct {
			struct {} __empty_SGLs;
			union MPI2_SGE_IO_UNION SGLs[0];
		};
	};
};

struct MPI2_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 TaskTag;
	__le16 Reserved1;
};

struct MPI2_TARGETASSIST_SUCCESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	u8 SequenceNumber;
	u8 Reserved1;
	__le16 IoIndex;
};

struct MPI2_TARGET_COMMAND_BUFFER_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	u8 VP_ID;
	u8 Flags;
	__le16 InitiatorDevHandle;
	__le16 IoIndex;
};

union MPI2_REPLY_DESCRIPTORS_UNION {
	struct MPI2_DEFAULT_REPLY_DESCRIPTOR Default;
	struct MPI2_ADDRESS_REPLY_DESCRIPTOR AddressReply;
	struct MPI2_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR SCSIIOSuccess;
	struct MPI2_TARGETASSIST_SUCCESS_REPLY_DESCRIPTOR TargetAssistSuccess;
	struct MPI2_TARGET_COMMAND_BUFFER_REPLY_DESCRIPTOR TargetCommandBuffer;
	struct MPI2_RAID_ACCELERATOR_SUCCESS_REPLY_DESCRIPTOR RAIDAcceleratorSuccess;
	__le64 Words;
};

struct MPI2_SCSI_TASK_MANAGE_REPLY {
	u16 DevHandle;
	u8 MsgLength;
	u8 Function;
	u8 ResponseCode;
	u8 TaskType;
	u8 Reserved1;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	u16 Reserved2;
	u16 Reserved3;
	u16 IOCStatus;
	u32 IOCLogInfo;
	u32 TerminationCount;
	u32 ResponseInfo;
};

struct MPI2_SCSI_TASK_MANAGE_REQUEST {
	u16 DevHandle;
	u8 ChainOffset;
	u8 Function;
	u8 Reserved1;
	u8 TaskType;
	u8 Reserved2;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	u16 Reserved3;
	u8 LUN[8];
	u32 Reserved4[7];
	u16 TaskMID;
	u16 Reserved5;
};

struct work_struct;

typedef void (*work_func_t)(struct work_struct *);

struct work_struct {
	atomic_long_t data;
	struct list_head entry;
	work_func_t func;
};

struct hlist_node {
	struct hlist_node *next;
	struct hlist_node **pprev;
};

struct timer_list {
	struct hlist_node entry;
	long unsigned int expires;
	void (*function)(struct timer_list *);
	u32 flags;
};

struct workqueue_struct;

struct delayed_work {
	struct work_struct work;
	struct timer_list timer;
	struct workqueue_struct *wq;
	int cpu;
};

struct MPT3SAS_ADAPTER;

typedef void (*MPT3SAS_FLUSH_RUNNING_CMDS)(struct MPT3SAS_ADAPTER *);

struct _internal_cmd {
	struct mutex mutex;
	struct completion done;
	void *reply;
	void *sense;
	u16 status;
	u16 smid;
};

typedef void (*MPT_ADD_SGE)(void *, u32, dma_addr_t);

struct _pcie_device;

typedef int (*MPT_BUILD_SG_SCMD)(struct MPT3SAS_ADAPTER *, struct scsi_cmnd *, u16, struct _pcie_device *);

typedef void (*MPT_BUILD_SG)(struct MPT3SAS_ADAPTER *, void *, dma_addr_t, size_t, dma_addr_t, size_t);

typedef void (*MPT_BUILD_ZERO_LEN_SGE)(struct MPT3SAS_ADAPTER *, void *);

struct _MPI26_NVME_ENCAPSULATED_REQUEST;

typedef struct _MPI26_NVME_ENCAPSULATED_REQUEST Mpi26NVMeEncapsulatedRequest_t;

typedef void (*NVME_BUILD_PRP)(struct MPT3SAS_ADAPTER *, u16, Mpi26NVMeEncapsulatedRequest_t *, dma_addr_t, size_t, dma_addr_t, size_t);

struct _MPI2_VERSION_STRUCT {
	U8 Dev;
	U8 Unit;
	U8 Minor;
	U8 Major;
};

typedef struct _MPI2_VERSION_STRUCT MPI2_VERSION_STRUCT;

union mpi3_version_union {
	MPI2_VERSION_STRUCT Struct;
	u32 Word;
};

struct mpt3sas_facts {
	u16 MsgVersion;
	u16 HeaderVersion;
	u8 IOCNumber;
	u8 VP_ID;
	u8 VF_ID;
	u16 IOCExceptions;
	u16 IOCStatus;
	u32 IOCLogInfo;
	u8 MaxChainDepth;
	u8 WhoInit;
	u8 NumberOfPorts;
	u8 MaxMSIxVectors;
	u16 RequestCredit;
	u16 ProductID;
	u32 IOCCapabilities;
	union mpi3_version_union FWVersion;
	u16 IOCRequestFrameSize;
	u16 IOCMaxChainSegmentSize;
	u16 MaxInitiators;
	u16 MaxTargets;
	u16 MaxSasExpanders;
	u16 MaxEnclosures;
	u16 ProtocolFlags;
	u16 HighPriorityCredit;
	u16 MaxReplyDescriptorPostQueueDepth;
	u8 ReplyFrameSize;
	u8 MaxVolumes;
	u16 MaxDevHandle;
	u16 MaxPersistentEntries;
	u16 MinDevHandle;
	u8 CurrentHostPageSize;
};

struct _MPI2_CONFIG_PAGE_HEADER {
	U8 PageVersion;
	U8 PageLength;
	U8 PageNumber;
	U8 PageType;
};

typedef struct _MPI2_CONFIG_PAGE_HEADER MPI2_CONFIG_PAGE_HEADER;

struct _MPI2_CONFIG_PAGE_MAN_0 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U8 ChipName[16];
	U8 ChipRevision[8];
	U8 BoardName[16];
	U8 BoardAssembly[16];
	U8 BoardTracerNumber[16];
};

typedef struct _MPI2_CONFIG_PAGE_MAN_0 Mpi2ManufacturingPage0_t;

struct Mpi2ManufacturingPage10_t {
	MPI2_CONFIG_PAGE_HEADER Header;
	U8 OEMIdentifier;
	U8 Reserved1;
	U16 Reserved2;
	U32___2 Reserved3;
	U32___2 GenericFlags0;
	U32___2 GenericFlags1;
	U32___2 Reserved4;
	U32___2 OEMSpecificFlags0;
	U32___2 OEMSpecificFlags1;
	U32___2 Reserved5[18];
};

struct Mpi2ManufacturingPage11_t {
	MPI2_CONFIG_PAGE_HEADER Header;
	__le32 Reserved1;
	u8 Reserved2;
	u8 EEDPTagMode;
	u8 Reserved3;
	u8 Reserved4;
	__le32 Reserved5[8];
	u16 AddlFlags2;
	u8 AddlFlags3;
	u8 Reserved6;
	__le32 Reserved7[7];
	u8 NVMeAbortTO;
	u8 NumPerDevEvents;
	u8 HostTraceBufferDecrementSizeKB;
	u8 HostTraceBufferFlags;
	u16 HostTraceBufferMaxSizeKB;
	u16 HostTraceBufferMinSizeKB;
	u8 CoreDumpTOSec;
	u8 TimeSyncInterval;
	u16 Reserved9;
	__le32 Reserved10;
};

struct _MPI2_BOOT_DEVICE_ADAPTER_ORDER {
	U32___2 Reserved1;
	U32___2 Reserved2;
	U32___2 Reserved3;
	U32___2 Reserved4;
	U32___2 Reserved5;
	U32___2 Reserved6;
};

typedef struct _MPI2_BOOT_DEVICE_ADAPTER_ORDER MPI2_BOOT_DEVICE_ADAPTER_ORDER;

struct _MPI2_BOOT_DEVICE_SAS_WWID {
	U64 SASAddress;
	U8 LUN[8];
	U32___2 Reserved1;
	U32___2 Reserved2;
};

typedef struct _MPI2_BOOT_DEVICE_SAS_WWID MPI2_BOOT_DEVICE_SAS_WWID;

struct _MPI2_BOOT_DEVICE_ENCLOSURE_SLOT {
	U64 EnclosureLogicalID;
	U32___2 Reserved1;
	U32___2 Reserved2;
	U16 SlotNumber;
	U16 Reserved3;
	U32___2 Reserved4;
};

typedef struct _MPI2_BOOT_DEVICE_ENCLOSURE_SLOT MPI2_BOOT_DEVICE_ENCLOSURE_SLOT;

struct _MPI2_BOOT_DEVICE_DEVICE_NAME {
	U64 DeviceName;
	U8 LUN[8];
	U32___2 Reserved1;
	U32___2 Reserved2;
};

typedef struct _MPI2_BOOT_DEVICE_DEVICE_NAME MPI2_BOOT_DEVICE_DEVICE_NAME;

union _MPI2_MPI2_BIOSPAGE2_BOOT_DEVICE {
	MPI2_BOOT_DEVICE_ADAPTER_ORDER AdapterOrder;
	MPI2_BOOT_DEVICE_SAS_WWID SasWwid;
	MPI2_BOOT_DEVICE_ENCLOSURE_SLOT EnclosureSlot;
	MPI2_BOOT_DEVICE_DEVICE_NAME DeviceName;
};

typedef union _MPI2_MPI2_BIOSPAGE2_BOOT_DEVICE MPI2_BIOSPAGE2_BOOT_DEVICE;

struct _MPI2_CONFIG_PAGE_BIOS_2 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U32___2 Reserved1;
	U32___2 Reserved2;
	U32___2 Reserved3;
	U32___2 Reserved4;
	U32___2 Reserved5;
	U32___2 Reserved6;
	U8 ReqBootDeviceForm;
	U8 Reserved7;
	U16 Reserved8;
	MPI2_BIOSPAGE2_BOOT_DEVICE RequestedBootDevice;
	U8 ReqAltBootDeviceForm;
	U8 Reserved9;
	U16 Reserved10;
	MPI2_BIOSPAGE2_BOOT_DEVICE RequestedAltBootDevice;
	U8 CurrentBootDeviceForm;
	U8 Reserved11;
	U16 Reserved12;
	MPI2_BIOSPAGE2_BOOT_DEVICE CurrentBootDevice;
} __attribute__((packed));

typedef struct _MPI2_CONFIG_PAGE_BIOS_2 Mpi2BiosPage2_t;

struct _MPI2_ADAPTER_INFO {
	U8 PciBusNumber;
	U8 PciDeviceAndFunctionNumber;
	U16 AdapterFlags;
};

typedef struct _MPI2_ADAPTER_INFO MPI2_ADAPTER_INFO;

struct _MPI2_ADAPTER_ORDER_AUX {
	U64 WWID;
	U32___2 Reserved1;
	U32___2 Reserved2;
};

typedef struct _MPI2_ADAPTER_ORDER_AUX MPI2_ADAPTER_ORDER_AUX;

struct _MPI2_CONFIG_PAGE_BIOS_3 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U32___2 GlobalFlags;
	U32___2 BiosVersion;
	MPI2_ADAPTER_INFO AdapterOrder[4];
	U32___2 Reserved1;
	MPI2_ADAPTER_ORDER_AUX AdapterOrderAux[4];
};

typedef struct _MPI2_CONFIG_PAGE_BIOS_3 Mpi2BiosPage3_t;

struct _MPI2_CONFIG_PAGE_IOC_8 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U8 NumDevsPerEnclosure;
	U8 Reserved1;
	U16 Reserved2;
	U16 MaxPersistentEntries;
	U16 MaxNumPhysicalMappedIDs;
	U16 Flags;
	U16 Reserved3;
	U16 IRVolumeMappingFlags;
	U16 Reserved4;
	U32___2 Reserved5;
};

typedef struct _MPI2_CONFIG_PAGE_IOC_8 Mpi2IOCPage8_t;

union _MPI2_VERSION_UNION {
	MPI2_VERSION_STRUCT Struct;
	U32___2 Word;
};

typedef union _MPI2_VERSION_UNION MPI2_VERSION_UNION;

struct _MPI2_CONFIG_PAGE_IO_UNIT_0 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U64 UniqueValue;
	MPI2_VERSION_UNION NvdataVersionDefault;
	MPI2_VERSION_UNION NvdataVersionPersistent;
} __attribute__((packed));

typedef struct _MPI2_CONFIG_PAGE_IO_UNIT_0 Mpi2IOUnitPage0_t;

struct _MPI2_CONFIG_PAGE_IO_UNIT_1 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U32___2 Flags;
};

typedef struct _MPI2_CONFIG_PAGE_IO_UNIT_1 Mpi2IOUnitPage1_t;

struct _MPI2_CONFIG_PAGE_IOC_1 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U32___2 Flags;
	U32___2 CoalescingTimeout;
	U8 CoalescingDepth;
	U8 PCISlotNum;
	U8 PCIBusNum;
	U8 PCIDomainSegment;
	U32___2 Reserved1;
	U32___2 ProductSpecific;
};

typedef struct _MPI2_CONFIG_PAGE_IOC_1 Mpi2IOCPage1_t;

struct _boot_device {
	int channel;
	void *device;
};

struct device;

struct hba_port;

struct _sas_phy;

struct sas_rphy;

struct _sas_node {
	struct list_head list;
	struct device *parent_dev;
	u8 num_phys;
	u64 sas_address;
	u16 handle;
	u64 sas_address_parent;
	u16 enclosure_handle;
	u64 enclosure_logical_id;
	u8 responding;
	u8 nr_phys_allocated;
	struct hba_port *port;
	struct _sas_phy *phy;
	struct list_head sas_port_list;
	struct sas_rphy *rphy;
};

struct htb_rel_query {
	u16 buffer_rel_condition;
	u16 reserved;
	u32 trigger_type;
	u32 trigger_info_dwords[2];
};

typedef u32 (*BASE_READ_REG)(const void *);

struct SL_WH_MASTER_TRIGGER_T {
	uint32_t MasterData;
};

struct SL_WH_EVENT_TRIGGER_T {
	uint16_t EventValue;
	uint16_t LogEntryQualifier;
};

struct SL_WH_EVENT_TRIGGERS_T {
	uint32_t ValidEntries;
	struct SL_WH_EVENT_TRIGGER_T EventTriggerEntry[20];
};

struct SL_WH_SCSI_TRIGGER_T {
	U8 ASCQ;
	U8 ASC;
	U8 SenseKey;
	U8 Reserved;
};

struct SL_WH_SCSI_TRIGGERS_T {
	uint32_t ValidEntries;
	struct SL_WH_SCSI_TRIGGER_T SCSITriggerEntry[20];
};

struct SL_WH_MPI_TRIGGER_T {
	uint16_t IOCStatus;
	uint16_t Reserved;
	uint32_t IocLogInfo;
};

struct SL_WH_MPI_TRIGGERS_T {
	uint32_t ValidEntries;
	struct SL_WH_MPI_TRIGGER_T MPITriggerEntry[20];
};

typedef void (*PUT_SMID_IO_FP_HIP)(struct MPT3SAS_ADAPTER *, u16, u16);

typedef void (*PUT_SMID_DEFAULT)(struct MPT3SAS_ADAPTER *, u16);

typedef u8 (*GET_MSIX_INDEX)(struct MPT3SAS_ADAPTER *, struct scsi_cmnd *);

struct _MPI2_SYSTEM_INTERFACE_REGS;

typedef struct _MPI2_SYSTEM_INTERFACE_REGS Mpi2SystemInterfaceRegs_t;

struct fw_event_work;

struct io_uring_poll_queue;

struct mpt3sas_port_facts;

struct pcie_sg_list;

struct chain_lookup;

struct request_tracker;

struct reply_post_struct;

struct _MPI2_IOC_INIT_RDPQ_ARRAY_ENTRY;

typedef struct _MPI2_IOC_INIT_RDPQ_ARRAY_ENTRY Mpi2IOCInitRDPQArrayEntry;

struct dentry;

struct MPT3SAS_ADAPTER {
	struct list_head list;
	struct Scsi_Host *shost;
	u8 id;
	int cpu_count;
	char name[32];
	char driver_name[24];
	char tmp_string[64];
	struct pci_dev *pdev;
	Mpi2SystemInterfaceRegs_t *chip;
	phys_addr_t chip_phys;
	int logging_level;
	int fwfault_debug;
	u8 ir_firmware;
	int bars;
	u8 mask_interrupts;
	char fault_reset_work_q_name[20];
	struct workqueue_struct *fault_reset_work_q;
	struct delayed_work fault_reset_work;
	struct workqueue_struct *firmware_event_thread;
	spinlock_t fw_event_lock;
	struct list_head fw_event_list;
	struct fw_event_work *current_event;
	u8 fw_events_cleanup;
	int aen_event_read_flag;
	u8 broadcast_aen_busy;
	u16 broadcast_aen_pending;
	u8 shost_recovery;
	u8 got_task_abort_from_ioctl;
	struct mutex reset_in_progress_mutex;
	struct mutex hostdiag_unlock_mutex;
	spinlock_t ioc_reset_in_progress_lock;
	u8 ioc_link_reset_in_progress;
	u8 ignore_loginfos;
	u8 remove_host;
	u8 pci_error_recovery;
	u8 wait_for_discovery_to_complete;
	u8 is_driver_loading;
	u8 port_enable_failed;
	u8 start_scan;
	u16 start_scan_failed;
	u8 msix_enable;
	u16 msix_vector_count;
	u8 *cpu_msix_table;
	u16 cpu_msix_table_sz;
	resource_size_t **reply_post_host_index;
	u32 ioc_reset_count;
	MPT3SAS_FLUSH_RUNNING_CMDS schedule_dead_ioc_flush_running_cmds;
	u32 non_operational_loop;
	u8 ioc_coredump_loop;
	u32 timestamp_update_count;
	u32 time_sync_interval;
	atomic64_t total_io_cnt;
	atomic64_t high_iops_outstanding;
	bool msix_load_balance;
	u16 thresh_hold;
	u8 high_iops_queues;
	u8 iopoll_q_start_index;
	u32 drv_internal_flags;
	u32 drv_support_bitmap;
	u32 dma_mask;
	bool enable_sdev_max_qd;
	bool use_32bit_dma;
	struct io_uring_poll_queue *io_uring_poll_queues;
	u8 scsi_io_cb_idx;
	u8 tm_cb_idx;
	u8 transport_cb_idx;
	u8 scsih_cb_idx;
	u8 ctl_cb_idx;
	u8 base_cb_idx;
	u8 port_enable_cb_idx;
	u8 config_cb_idx;
	u8 tm_tr_cb_idx;
	u8 tm_tr_volume_cb_idx;
	u8 tm_sas_control_cb_idx;
	struct _internal_cmd base_cmds;
	struct _internal_cmd port_enable_cmds;
	struct _internal_cmd transport_cmds;
	struct _internal_cmd scsih_cmds;
	struct _internal_cmd tm_cmds;
	struct _internal_cmd ctl_cmds;
	struct _internal_cmd config_cmds;
	MPT_ADD_SGE base_add_sg_single;
	MPT_BUILD_SG_SCMD build_sg_scmd;
	MPT_BUILD_SG build_sg;
	MPT_BUILD_ZERO_LEN_SGE build_zero_len_sge;
	u16 sge_size_ieee;
	u16 hba_mpi_version_belonged;
	MPT_BUILD_SG build_sg_mpi;
	MPT_BUILD_ZERO_LEN_SGE build_zero_len_sge_mpi;
	NVME_BUILD_PRP build_nvme_prp;
	u32 event_type[4];
	u32 event_context;
	void *event_log;
	u32 event_masks[4];
	u8 tm_custom_handling;
	u8 nvme_abort_timeout;
	u16 max_shutdown_latency;
	u16 max_wideport_qd;
	u16 max_narrowport_qd;
	u16 max_nvme_qd;
	u8 max_sata_qd;
	struct mpt3sas_facts facts;
	struct mpt3sas_facts prev_fw_facts;
	struct mpt3sas_port_facts *pfacts;
	Mpi2ManufacturingPage0_t manu_pg0;
	struct Mpi2ManufacturingPage10_t manu_pg10;
	struct Mpi2ManufacturingPage11_t manu_pg11;
	Mpi2BiosPage2_t bios_pg2;
	Mpi2BiosPage3_t bios_pg3;
	Mpi2IOCPage8_t ioc_pg8;
	Mpi2IOUnitPage0_t iounit_pg0;
	Mpi2IOUnitPage1_t iounit_pg1;
	Mpi2IOCPage1_t ioc_pg1_copy;
	struct _boot_device req_boot_device;
	struct _boot_device req_alt_boot_device;
	struct _boot_device current_boot_device;
	struct _sas_node sas_hba;
	struct list_head sas_expander_list;
	struct list_head enclosure_list;
	spinlock_t sas_node_lock;
	struct list_head sas_device_list;
	struct list_head sas_device_init_list;
	spinlock_t sas_device_lock;
	struct list_head pcie_device_list;
	struct list_head pcie_device_init_list;
	spinlock_t pcie_device_lock;
	struct list_head raid_device_list;
	spinlock_t raid_device_lock;
	u8 io_missing_delay;
	u16 device_missing_delay;
	int sas_id;
	int pcie_target_id;
	void *blocking_handles;
	void *pd_handles;
	u16 pd_handles_sz;
	void *pend_os_device_add;
	u16 pend_os_device_add_sz;
	u16 config_page_sz;
	void *config_page;
	dma_addr_t config_page_dma;
	void *config_vaddr;
	u16 hba_queue_depth;
	u16 sge_size;
	u16 scsiio_depth;
	u16 request_sz;
	u8 *request;
	dma_addr_t request_dma;
	u32 request_dma_sz;
	struct pcie_sg_list *pcie_sg_lookup;
	spinlock_t scsi_lookup_lock;
	int pending_io_count;
	wait_queue_head_t reset_wq;
	u16 *io_queue_num;
	struct dma_pool *pcie_sgl_dma_pool;
	u32 page_size;
	struct chain_lookup *chain_lookup;
	struct list_head free_chain_list;
	struct dma_pool *chain_dma_pool;
	ulong chain_pages;
	u16 max_sges_in_main_message;
	u16 max_sges_in_chain_message;
	u16 chains_needed_per_io;
	u32 chain_depth;
	u16 chain_segment_sz;
	u16 chains_per_prp_buffer;
	u16 hi_priority_smid;
	u8 *hi_priority;
	dma_addr_t hi_priority_dma;
	u16 hi_priority_depth;
	struct request_tracker *hpr_lookup;
	struct list_head hpr_free_list;
	u16 internal_smid;
	u8 *internal;
	dma_addr_t internal_dma;
	u16 internal_depth;
	struct request_tracker *internal_lookup;
	struct list_head internal_free_list;
	u8 *sense;
	dma_addr_t sense_dma;
	struct dma_pool *sense_dma_pool;
	u16 reply_sz;
	u8 *reply;
	dma_addr_t reply_dma;
	u32 reply_dma_max_address;
	u32 reply_dma_min_address;
	struct dma_pool *reply_dma_pool;
	u16 reply_free_queue_depth;
	__le32 *reply_free;
	dma_addr_t reply_free_dma;
	struct dma_pool *reply_free_dma_pool;
	u32 reply_free_host_index;
	u16 reply_post_queue_depth;
	struct reply_post_struct *reply_post;
	u8 rdpq_array_capable;
	u8 rdpq_array_enable;
	u8 rdpq_array_enable_assigned;
	struct dma_pool *reply_post_free_dma_pool;
	struct dma_pool *reply_post_free_array_dma_pool;
	Mpi2IOCInitRDPQArrayEntry *reply_post_free_array;
	dma_addr_t reply_post_free_array_dma;
	u8 reply_queue_count;
	struct list_head reply_queue_list;
	u8 combined_reply_queue;
	u8 combined_reply_index_count;
	u8 smp_affinity_enable;
	resource_size_t **replyPostRegisterIndex;
	struct list_head delayed_tr_list;
	struct list_head delayed_tr_volume_list;
	struct list_head delayed_sc_list;
	struct list_head delayed_event_ack_list;
	u8 temp_sensors_count;
	struct mutex pci_access_mutex;
	u8 *diag_buffer[3];
	u32 diag_buffer_sz[3];
	dma_addr_t diag_buffer_dma[3];
	u8 diag_buffer_status[3];
	u32 unique_id[3];
	u32 product_specific[69];
	u32 diagnostic_flags[3];
	u32 ring_buffer_offset;
	u32 ring_buffer_sz;
	struct htb_rel_query htb_rel;
	u8 reset_from_user;
	u8 is_warpdrive;
	u8 is_mcpu_endpoint;
	u8 hide_ir_msg;
	u8 mfg_pg10_hide_flag;
	u8 hide_drives;
	spinlock_t diag_trigger_lock;
	u8 diag_trigger_active;
	u8 atomic_desc_capable;
	BASE_READ_REG base_readl;
	BASE_READ_REG base_readl_ext_retry;
	struct SL_WH_MASTER_TRIGGER_T diag_trigger_master;
	struct SL_WH_EVENT_TRIGGERS_T diag_trigger_event;
	struct SL_WH_SCSI_TRIGGERS_T diag_trigger_scsi;
	struct SL_WH_MPI_TRIGGERS_T diag_trigger_mpi;
	u8 supports_trigger_pages;
	void *device_remove_in_progress;
	u16 device_remove_in_progress_sz;
	u8 is_gen35_ioc;
	u8 is_aero_ioc;
	struct dentry *debugfs_root;
	struct dentry *ioc_dump;
	PUT_SMID_IO_FP_HIP put_smid_scsi_io;
	PUT_SMID_IO_FP_HIP put_smid_fast_path;
	PUT_SMID_IO_FP_HIP put_smid_hi_priority;
	PUT_SMID_DEFAULT put_smid_default;
	GET_MSIX_INDEX get_msix_index_for_smlio;
	u8 multipath_on_hba;
	struct list_head port_table_list;
};

struct MPT3SAS_TARGET;

struct MPT3SAS_DEVICE {
	struct MPT3SAS_TARGET *sas_target;
	unsigned int lun;
	u32 flags;
	u8 configured_lun;
	u8 block;
	u8 tlr_snoop_check;
	u8 ignore_delay_remove;
	u8 ncq_prio_enable;
	long unsigned int ata_command_pending;
};

struct scsi_target;

struct _raid_device;

struct _sas_device;

struct MPT3SAS_TARGET {
	struct scsi_target *starget;
	u64 sas_address;
	struct _raid_device *raid_device;
	u16 handle;
	int num_luns;
	u32 flags;
	u8 deleted;
	u8 tm_busy;
	struct hba_port *port;
	struct _sas_device *sas_dev;
	struct _pcie_device *pcie_dev;
};

struct MPT3_IOCTL_EVENTS {
	uint32_t event;
	uint32_t context;
	uint8_t data[192];
};

struct MR_ARRAY_INFO {
	__le16 pd[32];
};

struct MR_CPU_AFFINITY_MASK {
	union {
		struct {
			u8 hw_path: 1;
			u8 cpu0: 1;
			u8 cpu1: 1;
			u8 cpu2: 1;
			u8 cpu3: 1;
			u8 reserved: 3;
		};
		u8 core_mask;
	};
};

struct MR_CTRL_HB_HOST_MEM {
	struct {
		u32 fwCounter;
		struct {
			u32 debugmode: 1;
			u32 reserved: 31;
		} debug;
		u32 reserved_fw[6];
		u32 driverCounter;
		u32 reserved_driver[7];
	} HB;
	u8 pad[960];
};

struct MR_DEV_HANDLE_INFO {
	__le16 curDevHdl;
	u8 validHandles;
	u8 interfaceType;
	__le16 devHandle[2];
};

struct MR_IO_AFFINITY {
	union {
		struct {
			struct MR_CPU_AFFINITY_MASK pdRead;
			struct MR_CPU_AFFINITY_MASK pdWrite;
			struct MR_CPU_AFFINITY_MASK ldRead;
			struct MR_CPU_AFFINITY_MASK ldWrite;
		};
		u32 word;
	};
	u8 maxCores;
	u8 reserved[3];
};

struct MR_LD_RAID {
	struct {
		u32 fpCapable: 1;
		u32 ra_capable: 1;
		u32 reserved5: 2;
		u32 ldPiMode: 4;
		u32 pdPiMode: 4;
		u32 encryptionType: 8;
		u32 fpWriteCapable: 1;
		u32 fpReadCapable: 1;
		u32 fpWriteAcrossStripe: 1;
		u32 fpReadAcrossStripe: 1;
		u32 fpNonRWCapable: 1;
		u32 tmCapable: 1;
		u32 fpBypassRegionLock: 1;
		u32 disable_coalescing: 1;
		u32 fp_rmw_capable: 1;
		u32 fp_cache_bypass_capable: 1;
		u32 reserved4: 2;
	} capability;
	__le32 reserved6;
	__le64 size;
	u8 spanDepth;
	u8 level;
	u8 stripeShift;
	u8 rowSize;
	u8 rowDataSize;
	u8 writeMode;
	u8 PRL;
	u8 SRL;
	__le16 targetId;
	u8 ldState;
	u8 regTypeReqOnWrite;
	u8 modFactor;
	u8 regTypeReqOnRead;
	__le16 seqNum;
	struct {
		u32 ldSyncRequired: 1;
		u32 regTypeReqOnReadIsValid: 1;
		u32 isEPD: 1;
		u32 enableSLDOnAllRWIOs: 1;
		u32 reserved: 28;
	} flags;
	u8 LUN[8];
	u8 fpIoTimeoutForLd;
	u8 ld_accept_priority_type;
	u8 reserved2[2];
	u32 logical_block_length;
	struct {
		u32 ld_pi_exp: 4;
		u32 ld_logical_block_exp: 4;
		u32 reserved1: 24;
	};
	struct MR_IO_AFFINITY cpuAffinity;
	u8 reserved3[64];
};

struct MR_LD_SPAN {
	__le64 startBlk;
	__le64 numBlks;
	__le16 arrayRef;
	u8 spanRowSize;
	u8 spanRowDataSize;
	u8 reserved[4];
};

struct MR_QUAD_ELEMENT {
	__le64 logStart;
	__le64 logEnd;
	__le64 offsetInSpan;
	__le32 diff;
	__le32 reserved1;
};

struct MR_SPAN_INFO {
	__le32 noElements;
	__le32 reserved1;
	struct MR_QUAD_ELEMENT quad[8];
};

struct MR_SPAN_BLOCK_INFO {
	__le64 num_rows;
	struct MR_LD_SPAN span;
	struct MR_SPAN_INFO block_span_info;
};

struct MR_LD_SPAN_MAP {
	struct MR_LD_RAID ldRaid;
	u8 dataArmMap[32];
	struct MR_SPAN_BLOCK_INFO spanBlock[8];
};

struct MR_DRV_RAID_MAP {
	__le32 totalSize;
	union {
		struct {
			__le32 maxLd;
			__le32 maxSpanDepth;
			__le32 maxRowSize;
			__le32 maxPdCount;
			__le32 maxArrays;
		} validationInfo;
		__le32 version[5];
	};
	u8 fpPdIoTimeoutSec;
	u8 reserved2[7];
	__le16 ldCount;
	__le16 arCount;
	__le16 spanCount;
	__le16 reserve3;
	struct MR_DEV_HANDLE_INFO devHndlInfo[512];
	u16 ldTgtIdToLd[512];
	struct MR_ARRAY_INFO arMapInfo[512];
	struct MR_LD_SPAN_MAP ldSpanMap[0];
};

struct MR_DRV_RAID_MAP_ALL {
	struct MR_DRV_RAID_MAP raidMap;
	struct MR_LD_SPAN_MAP ldSpanMap[512];
};

struct MR_DRV_SYSTEM_INFO {
	u8 infoVersion;
	u8 systemIdLength;
	u16 reserved0;
	u8 systemId[64];
	u8 reserved[1980];
};

struct MR_FW_RAID_MAP {
	__le32 totalSize;
	union {
		struct {
			__le32 maxLd;
			__le32 maxSpanDepth;
			__le32 maxRowSize;
			__le32 maxPdCount;
			__le32 maxArrays;
		} validationInfo;
		__le32 version[5];
	};
	__le32 ldCount;
	__le32 Reserved1;
	u8 ldTgtIdToLd[128];
	u8 fpPdIoTimeoutSec;
	u8 reserved2[7];
	struct MR_ARRAY_INFO arMapInfo[128];
	struct MR_DEV_HANDLE_INFO devHndlInfo[256];
	struct MR_LD_SPAN_MAP ldSpanMap[0];
};

struct MR_FW_RAID_MAP_ALL {
	struct MR_FW_RAID_MAP raidMap;
	struct MR_LD_SPAN_MAP ldSpanMap[64];
};

struct MR_RAID_MAP_DESC_TABLE {
	u32 raid_map_desc_type;
	u32 raid_map_desc_offset;
	u32 raid_map_desc_buffer_size;
	u32 raid_map_desc_elements;
};

struct MR_FW_RAID_MAP_DYNAMIC {
	u32 raid_map_size;
	u32 desc_table_offset;
	u32 desc_table_size;
	u32 desc_table_num_elements;
	u64 reserved1;
	u32 reserved2[3];
	u8 fp_pd_io_timeout_sec;
	u8 reserved3[3];
	u32 rmw_fp_seq_num;
	u16 ld_count;
	u16 ar_count;
	u16 span_count;
	u16 reserved4[3];
	union {
		struct {
			struct MR_DEV_HANDLE_INFO *dev_hndl_info;
			u16 *ld_tgt_id_to_ld;
			struct MR_ARRAY_INFO *ar_map_info;
			struct MR_LD_SPAN_MAP *ld_span_map;
		};
		u64 ptr_structure_size[4];
	};
	struct MR_RAID_MAP_DESC_TABLE raid_map_desc_table[4];
	u32 raid_map_desc_data[0];
};

struct MR_FW_RAID_MAP_EXT {
	u32 reserved;
	union {
		struct {
			u32 maxLd;
			u32 maxSpanDepth;
			u32 maxRowSize;
			u32 maxPdCount;
			u32 maxArrays;
		} validationInfo;
		u32 version[5];
	};
	u8 fpPdIoTimeoutSec;
	u8 reserved2[7];
	__le16 ldCount;
	__le16 arCount;
	__le16 spanCount;
	__le16 reserve3;
	struct MR_DEV_HANDLE_INFO devHndlInfo[256];
	u8 ldTgtIdToLd[256];
	struct MR_ARRAY_INFO arMapInfo[256];
	struct MR_LD_SPAN_MAP ldSpanMap[256];
};

struct MR_HOST_DEVICE_LIST_ENTRY {
	struct {
		union {
			struct {
				u8 is_sys_pd: 1;
				u8 reserved: 7;
			} bits;
			u8 byte;
		} u;
	} flags;
	u8 scsi_type;
	__le16 target_id;
	u8 reserved[4];
	__le64 sas_addr[2];
};

struct MR_HOST_DEVICE_LIST {
	__le32 size;
	__le32 count;
	__le32 reserved[2];
	struct MR_HOST_DEVICE_LIST_ENTRY host_device_list[0];
};

union MR_LD_REF {
	struct {
		u8 targetId;
		u8 reserved;
		__le16 seqNum;
	};
	__le32 ref;
};

struct MR_LD_LIST {
	__le32 ldCount;
	__le32 reserved;
	struct {
		union MR_LD_REF ref;
		u8 state;
		u8 reserved[3];
		__le64 size;
	} ldList[256];
};

struct MR_LD_TARGETID_LIST {
	__le32 size;
	__le32 count;
	u8 pad[3];
	u8 targetId[256];
};

struct MR_LD_TARGET_SYNC {
	u8 targetId;
	u8 reserved;
	__le16 seqNum;
};

struct MR_LD_VF_MAP {
	u32 size;
	union MR_LD_REF ref;
	u8 ldVfCount;
	u8 reserved[6];
	u8 policy[0];
};

struct MR_LD_VF_AFFILIATION {
	u32 size;
	u8 ldCount;
	u8 vfCount;
	u8 thisVf;
	u8 reserved[9];
	struct MR_LD_VF_MAP map[1];
};

struct MR_LD_VF_MAP_111 {
	u8 targetId;
	u8 reserved[3];
	u8 policy[8];
};

struct MR_LD_VF_AFFILIATION_111 {
	u8 vdCount;
	u8 vfCount;
	u8 thisVf;
	u8 reserved[5];
	struct MR_LD_VF_MAP_111 map[64];
};

struct MR_PD_ADDRESS {
	__le16 deviceId;
	u16 enclDeviceId;
	union {
		struct {
			u8 enclIndex;
			u8 slotNumber;
		} mrPdAddress;
		struct {
			u8 enclPosition;
			u8 enclConnectorIndex;
		} mrEnclAddress;
	};
	u8 scsiDevType;
	union {
		u8 connectedPortBitmap;
		u8 connectedPortNumbers;
	};
	u64 sasAddr[2];
};

struct MR_PD_CFG_SEQ {
	u16 seqNum;
	u16 devHandle;
	struct {
		u8 tmCapable: 1;
		u8 reserved: 7;
	} capability;
	u8 reserved;
	u16 pd_target_id;
};

struct MR_PD_CFG_SEQ_NUM_SYNC {
	__le32 size;
	__le32 count;
	struct MR_PD_CFG_SEQ seq[0];
};

union MR_PD_DDF_TYPE {
	struct {
		union {
			struct {
				u16 forcedPDGUID: 1;
				u16 inVD: 1;
				u16 isGlobalSpare: 1;
				u16 isSpare: 1;
				u16 isForeign: 1;
				u16 reserved: 7;
				u16 intf: 4;
			} pdType;
			u16 type;
		};
		u16 reserved;
	} ddf;
	struct {
		u32 reserved;
	} nonDisk;
	u32 type;
};

union MR_PD_REF {
	struct {
		u16 deviceId;
		u16 seqNum;
	} mrPdRef;
	u32 ref;
};

union MR_PROGRESS {
	struct {
		u16 progress;
		union {
			u16 elapsedSecs;
			u16 elapsedSecsForLastPercent;
		};
	} mrProgress;
	u32 w;
};

struct MR_PD_PROGRESS {
	struct {
		u32 rbld: 1;
		u32 patrol: 1;
		u32 clear: 1;
		u32 copyBack: 1;
		u32 erase: 1;
		u32 locate: 1;
		u32 reserved: 26;
	} active;
	union MR_PROGRESS rbld;
	union MR_PROGRESS patrol;
	union {
		union MR_PROGRESS clear;
		union MR_PROGRESS erase;
	};
	struct {
		u32 rbld: 1;
		u32 patrol: 1;
		u32 clear: 1;
		u32 copyBack: 1;
		u32 erase: 1;
		u32 reserved: 27;
	} pause;
	union MR_PROGRESS reserved[3];
};

struct MR_PD_INFO {
	union MR_PD_REF ref;
	u8 inquiryData[96];
	u8 vpdPage83[64];
	u8 notSupported;
	u8 scsiDevType;
	union {
		u8 connectedPortBitmap;
		u8 connectedPortNumbers;
	};
	u8 deviceSpeed;
	u32 mediaErrCount;
	u32 otherErrCount;
	u32 predFailCount;
	u32 lastPredFailEventSeqNum;
	u16 fwState;
	u8 disabledForRemoval;
	u8 linkSpeed;
	union MR_PD_DDF_TYPE state;
	struct {
		u8 count;
		u8 isPathBroken: 4;
		u8 reserved3: 3;
		u8 widePortCapable: 1;
		u8 connectorIndex[2];
		u8 reserved[4];
		u64 sasAddr[2];
		u8 reserved2[16];
	} pathInfo;
	u64 rawSize;
	u64 nonCoercedSize;
	u64 coercedSize;
	u16 enclDeviceId;
	u8 enclIndex;
	union {
		u8 slotNumber;
		u8 enclConnectorIndex;
	};
	struct MR_PD_PROGRESS progInfo;
	u8 badBlockTableFull;
	u8 unusableInCurrentConfig;
	u8 vpdPage83Ext[64];
	u8 powerState;
	u8 enclPosition;
	u32 allowedOps;
	u16 copyBackPartnerId;
	u16 enclPartnerDeviceId;
	struct {
		u16 fdeCapable: 1;
		u16 fdeEnabled: 1;
		u16 secured: 1;
		u16 locked: 1;
		u16 foreign: 1;
		u16 needsEKM: 1;
		u16 reserved: 10;
	} security;
	u8 mediaType;
	u8 notCertified;
	u8 bridgeVendor[8];
	u8 bridgeProductIdentification[16];
	u8 bridgeProductRevisionLevel[4];
	u8 satBridgeExists;
	u8 interfaceType;
	u8 temperature;
	u8 emulatedBlockSize;
	u16 userDataBlockSize;
	u16 reserved2;
	struct {
		u32 piType: 3;
		u32 piFormatted: 1;
		u32 piEligible: 1;
		u32 NCQ: 1;
		u32 WCE: 1;
		u32 commissionedSpare: 1;
		u32 emergencySpare: 1;
		u32 ineligibleForSSCD: 1;
		u32 ineligibleForLd: 1;
		u32 useSSEraseType: 1;
		u32 wceUnchanged: 1;
		u32 supportScsiUnmap: 1;
		u32 reserved: 18;
	} properties;
	u64 shieldDiagCompletionTime;
	u8 shieldCounter;
	u8 linkSpeedOther;
	u8 reserved4[2];
	struct {
		u32 bbmErrCountSupported: 1;
		u32 bbmErrCount: 31;
	} bbmErr;
	u8 reserved1[84];
} __attribute__((packed));

struct MR_PD_LIST {
	__le32 size;
	__le32 count;
	struct MR_PD_ADDRESS addr[1];
};

struct MR_PRIV_DEVICE {
	bool is_tm_capable;
	bool tm_busy;
	atomic_t sdev_priv_busy;
	atomic_t r1_ldio_hint;
	u8 interface_type;
	u8 task_abort_tmo;
	u8 target_reset_tmo;
};

struct MR_SNAPDUMP_PROPERTIES {
	u8 offload_num;
	u8 max_num_supported;
	u8 cur_num_supported;
	u8 trigger_min_num_sec_before_ocr;
	u8 reserved[12];
};

struct MR_TARGET_PROPERTIES {
	u32 max_io_size_kb;
	u32 device_qdepth;
	u32 sector_size;
	u8 reset_tmo;
	u8 reserved[499];
};

struct MR_TM_REQUEST {
	char request[128];
};

struct MR_TM_REPLY {
	char reply[128];
};

struct MR_TASK_MANAGE_REQUEST {
	struct MR_TM_REQUEST TmRequest;
	union {
		struct {
			u32 isTMForLD: 1;
			u32 isTMForPD: 1;
			u32 reserved1: 30;
			u32 reserved2;
		} tmReqFlags;
		struct MR_TM_REPLY TMReply;
	};
};

struct sk_buff;

struct sk_buff_list {
	struct sk_buff *next;
	struct sk_buff *prev;
};

struct sk_buff_head {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
		};
		struct sk_buff_list list;
	};
	__u32 qlen;
	spinlock_t lock;
};

struct qdisc_skb_head {
	struct sk_buff *head;
	struct sk_buff *tail;
	__u32 qlen;
	spinlock_t lock;
};

struct u64_stats_sync {};

struct gnet_stats_basic_sync {
	u64_stats_t bytes;
	u64_stats_t packets;
	struct u64_stats_sync syncp;
};

struct gnet_stats_queue {
	__u32 qlen;
	__u32 backlog;
	__u32 drops;
	__u32 requeues;
	__u32 overlimits;
};

struct callback_head {
	struct callback_head *next;
	void (*func)(struct callback_head *);
};

struct lock_class_key {};

struct Qdisc_ops;

struct qdisc_size_table;

struct netdev_queue;

struct net_rate_estimator;

struct Qdisc {
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	unsigned int flags;
	u32 limit;
	const struct Qdisc_ops *ops;
	struct qdisc_size_table *stab;
	struct hlist_node hash;
	u32 handle;
	u32 parent;
	struct netdev_queue *dev_queue;
	struct net_rate_estimator *rate_est;
	struct gnet_stats_basic_sync *cpu_bstats;
	struct gnet_stats_queue *cpu_qstats;
	int pad;
	refcount_t refcnt;
	long: 64;
	long: 64;
	long: 64;
	struct sk_buff_head gso_skb;
	struct qdisc_skb_head q;
	struct gnet_stats_basic_sync bstats;
	struct gnet_stats_queue qstats;
	int owner;
	long unsigned int state;
	long unsigned int state2;
	struct Qdisc *next_sched;
	struct sk_buff_head skb_bad_txq;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t busylock;
	spinlock_t seqlock;
	struct callback_head rcu;
	netdevice_tracker dev_tracker;
	struct lock_class_key root_lock_key;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long int privdata[0];
};

struct Qdisc_class_common {
	u32 classid;
	unsigned int filter_cnt;
	struct hlist_node hnode;
};

struct hlist_head;

struct Qdisc_class_hash {
	struct hlist_head *hash;
	unsigned int hashsize;
	unsigned int hashmask;
	unsigned int hashelems;
};

struct tcmsg;

struct netlink_ext_ack;

struct nlattr;

struct qdisc_walker;

struct tcf_block;

struct gnet_dump;

struct Qdisc_class_ops {
	unsigned int flags;
	struct netdev_queue * (*select_queue)(struct Qdisc *, struct tcmsg *);
	int (*graft)(struct Qdisc *, long unsigned int, struct Qdisc *, struct Qdisc **, struct netlink_ext_ack *);
	struct Qdisc * (*leaf)(struct Qdisc *, long unsigned int);
	void (*qlen_notify)(struct Qdisc *, long unsigned int);
	long unsigned int (*find)(struct Qdisc *, u32);
	int (*change)(struct Qdisc *, u32, u32, struct nlattr **, long unsigned int *, struct netlink_ext_ack *);
	int (*delete)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	void (*walk)(struct Qdisc *, struct qdisc_walker *);
	struct tcf_block * (*tcf_block)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	long unsigned int (*bind_tcf)(struct Qdisc *, long unsigned int, u32);
	void (*unbind_tcf)(struct Qdisc *, long unsigned int);
	int (*dump)(struct Qdisc *, long unsigned int, struct sk_buff *, struct tcmsg *);
	int (*dump_stats)(struct Qdisc *, long unsigned int, struct gnet_dump *);
};

struct module;

struct Qdisc_ops {
	struct Qdisc_ops *next;
	const struct Qdisc_class_ops *cl_ops;
	char id[16];
	int priv_size;
	unsigned int static_flags;
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	struct sk_buff * (*peek)(struct Qdisc *);
	int (*init)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*reset)(struct Qdisc *);
	void (*destroy)(struct Qdisc *);
	int (*change)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*attach)(struct Qdisc *);
	int (*change_tx_queue_len)(struct Qdisc *, unsigned int);
	void (*change_real_num_tx)(struct Qdisc *, unsigned int);
	int (*dump)(struct Qdisc *, struct sk_buff *);
	int (*dump_stats)(struct Qdisc *, struct gnet_dump *);
	void (*ingress_block_set)(struct Qdisc *, u32);
	void (*egress_block_set)(struct Qdisc *, u32);
	u32 (*ingress_block_get)(struct Qdisc *);
	u32 (*egress_block_get)(struct Qdisc *);
	struct module *owner;
};

struct RR_CL_s {
	__u8 location[8];
};

struct RR_NM_s {
	__u8 flags;
	char name[0];
};

struct RR_PL_s {
	__u8 location[8];
};

struct RR_PN_s {
	__u8 dev_high[8];
	__u8 dev_low[8];
};

struct RR_PX_s {
	__u8 mode[8];
	__u8 n_links[8];
	__u8 uid[8];
	__u8 gid[8];
};

struct RR_RR_s {
	__u8 flags[1];
};

struct SL_component {
	__u8 flags;
	__u8 len;
	__u8 text[0];
};

struct RR_SL_s {
	__u8 flags;
	struct SL_component link;
};

struct stamp {
	__u8 time[7];
};

struct RR_TF_s {
	__u8 flags;
	struct stamp times[0];
};

struct RR_ZF_s {
	__u8 algorithm[2];
	__u8 parms[2];
	__u8 real_size[8];
};

struct RxDesc {
	__le32 opts1;
	__le32 opts2;
	__le64 addr;
};

struct SL_WH_TRIGGERS_EVENT_DATA_T {
	uint32_t trigger_type;
	union {
		struct SL_WH_MASTER_TRIGGER_T master;
		struct SL_WH_EVENT_TRIGGER_T event;
		struct SL_WH_SCSI_TRIGGER_T scsi;
		struct SL_WH_MPI_TRIGGER_T mpi;
	} u;
};

struct SU_CE_s {
	__u8 extent[8];
	__u8 offset[8];
	__u8 size[8];
};

struct SU_ER_s {
	__u8 len_id;
	__u8 len_des;
	__u8 len_src;
	__u8 ext_ver;
	__u8 data[0];
};

struct SU_SP_s {
	__u8 magic[2];
	__u8 skip;
};

struct kref {
	refcount_t refcount;
};

struct blk_mq_queue_map {
	unsigned int *mq_map;
	unsigned int nr_queues;
	unsigned int queue_offset;
};

struct blk_mq_ops;

struct blk_mq_tags;

struct blk_mq_tag_set {
	const struct blk_mq_ops *ops;
	struct blk_mq_queue_map map[3];
	unsigned int nr_maps;
	unsigned int nr_hw_queues;
	unsigned int queue_depth;
	unsigned int reserved_tags;
	unsigned int cmd_size;
	int numa_node;
	unsigned int timeout;
	unsigned int flags;
	void *driver_data;
	struct blk_mq_tags **tags;
	struct blk_mq_tags *shared_tags;
	struct mutex tag_list_lock;
	struct list_head tag_list;
	struct srcu_struct *srcu;
};

struct kset;

struct kobj_type;

struct kernfs_node;

struct kobject {
	const char *name;
	struct list_head entry;
	struct kobject *parent;
	struct kset *kset;
	const struct kobj_type *ktype;
	struct kernfs_node *sd;
	struct kref kref;
	unsigned int state_initialized: 1;
	unsigned int state_in_sysfs: 1;
	unsigned int state_add_uevent_sent: 1;
	unsigned int state_remove_uevent_sent: 1;
	unsigned int uevent_suppress: 1;
};

struct dev_links_info {
	struct list_head suppliers;
	struct list_head consumers;
	struct list_head defer_sync;
	enum dl_dev_state status;
};

struct pm_message {
	int event;
};

typedef struct pm_message pm_message_t;

struct rb_node {
	long unsigned int __rb_parent_color;
	struct rb_node *rb_right;
	struct rb_node *rb_left;
};

struct timerqueue_node {
	struct rb_node node;
	ktime_t expires;
};

struct hrtimer_clock_base;

struct hrtimer {
	struct timerqueue_node node;
	ktime_t _softexpires;
	enum hrtimer_restart (*function)(struct hrtimer *);
	struct hrtimer_clock_base *base;
	u8 state;
	u8 is_rel;
	u8 is_soft;
	u8 is_hard;
};

struct wakeup_source;

struct wake_irq;

struct pm_subsys_data;

struct dev_pm_qos;

struct dev_pm_info {
	pm_message_t power_state;
	bool can_wakeup: 1;
	bool async_suspend: 1;
	bool in_dpm_list: 1;
	bool is_prepared: 1;
	bool is_suspended: 1;
	bool is_noirq_suspended: 1;
	bool is_late_suspended: 1;
	bool no_pm: 1;
	bool early_init: 1;
	bool direct_complete: 1;
	u32 driver_flags;
	spinlock_t lock;
	struct list_head entry;
	struct completion completion;
	struct wakeup_source *wakeup;
	bool wakeup_path: 1;
	bool syscore: 1;
	bool no_pm_callbacks: 1;
	bool async_in_progress: 1;
	bool must_resume: 1;
	bool set_active: 1;
	bool may_skip_resume: 1;
	struct hrtimer suspend_timer;
	u64 timer_expires;
	struct work_struct work;
	wait_queue_head_t wait_queue;
	struct wake_irq *wakeirq;
	atomic_t usage_count;
	atomic_t child_count;
	unsigned int disable_depth: 3;
	bool idle_notification: 1;
	bool request_pending: 1;
	bool deferred_resume: 1;
	bool needs_force_resume: 1;
	bool runtime_auto: 1;
	bool ignore_children: 1;
	bool no_callbacks: 1;
	bool irq_safe: 1;
	bool use_autosuspend: 1;
	bool timer_autosuspends: 1;
	bool memalloc_noio: 1;
	unsigned int links_count;
	enum rpm_request request;
	enum rpm_status runtime_status;
	enum rpm_status last_status;
	int runtime_error;
	int autosuspend_delay;
	u64 last_busy;
	u64 active_time;
	u64 suspended_time;
	u64 accounting_timestamp;
	struct pm_subsys_data *subsys_data;
	void (*set_latency_tolerance)(struct device *, s32);
	struct dev_pm_qos *qos;
};

struct irq_domain;

struct msi_device_data;

struct dev_msi_info {
	struct irq_domain *domain;
	struct msi_device_data *data;
};

struct dev_archdata {};

struct device_private;

struct device_type;

struct bus_type;

struct device_driver;

struct dev_pm_domain;

struct dev_pin_info;

struct bus_dma_region;

struct device_dma_parameters;

struct dma_coherent_mem;

struct cma;

struct io_tlb_mem;

struct device_node;

struct fwnode_handle;

struct class;

struct attribute_group;

struct iommu_group;

struct dev_iommu;

struct device_physical_location;

struct device {
	struct kobject kobj;
	struct device *parent;
	struct device_private *p;
	const char *init_name;
	const struct device_type *type;
	const struct bus_type *bus;
	struct device_driver *driver;
	void *platform_data;
	void *driver_data;
	struct mutex mutex;
	struct dev_links_info links;
	struct dev_pm_info power;
	struct dev_pm_domain *pm_domain;
	struct dev_pin_info *pins;
	struct dev_msi_info msi;
	u64 *dma_mask;
	u64 coherent_dma_mask;
	u64 bus_dma_limit;
	const struct bus_dma_region *dma_range_map;
	struct device_dma_parameters *dma_parms;
	struct list_head dma_pools;
	struct dma_coherent_mem *dma_mem;
	struct cma *cma_area;
	struct io_tlb_mem *dma_io_tlb_mem;
	struct dev_archdata archdata;
	struct device_node *of_node;
	struct fwnode_handle *fwnode;
	int numa_node;
	dev_t devt;
	u32 id;
	spinlock_t devres_lock;
	struct list_head devres_head;
	const struct class *class;
	const struct attribute_group **groups;
	void (*release)(struct device *);
	struct iommu_group *iommu_group;
	struct dev_iommu *iommu;
	struct device_physical_location *physical_location;
	enum device_removable removable;
	bool offline_disabled: 1;
	bool offline: 1;
	bool of_node_reused: 1;
	bool state_synced: 1;
	bool can_match: 1;
	bool dma_skip_sync: 1;
};

struct scsi_host_template;

struct scsi_transport_template;

struct Scsi_Host {
	struct list_head __devices;
	struct list_head __targets;
	struct list_head starved_list;
	spinlock_t default_lock;
	spinlock_t *host_lock;
	struct mutex scan_mutex;
	struct list_head eh_abort_list;
	struct list_head eh_cmd_q;
	struct task_struct *ehandler;
	struct completion *eh_action;
	wait_queue_head_t host_wait;
	const struct scsi_host_template *hostt;
	struct scsi_transport_template *transportt;
	struct kref tagset_refcnt;
	struct completion tagset_freed;
	struct blk_mq_tag_set tag_set;
	atomic_t host_blocked;
	unsigned int host_failed;
	unsigned int host_eh_scheduled;
	unsigned int host_no;
	int eh_deadline;
	long unsigned int last_reset;
	unsigned int max_channel;
	unsigned int max_id;
	u64 max_lun;
	unsigned int unique_id;
	short unsigned int max_cmd_len;
	int this_id;
	int can_queue;
	short int cmd_per_lun;
	short unsigned int sg_tablesize;
	short unsigned int sg_prot_tablesize;
	unsigned int max_sectors;
	unsigned int opt_sectors;
	unsigned int max_segment_size;
	unsigned int dma_alignment;
	long unsigned int dma_boundary;
	long unsigned int virt_boundary_mask;
	unsigned int nr_hw_queues;
	unsigned int nr_maps;
	unsigned int active_mode: 2;
	unsigned int host_self_blocked: 1;
	unsigned int reverse_ordering: 1;
	unsigned int tmf_in_progress: 1;
	unsigned int async_scan: 1;
	unsigned int eh_noresume: 1;
	unsigned int no_write_same: 1;
	unsigned int host_tagset: 1;
	unsigned int queuecommand_may_block: 1;
	unsigned int short_inquiry: 1;
	unsigned int no_scsi2_lun_in_cdb: 1;
	unsigned int no_highmem: 1;
	struct workqueue_struct *work_q;
	struct workqueue_struct *tmf_work_q;
	unsigned int max_host_blocked;
	unsigned int prot_capabilities;
	unsigned char prot_guard_type;
	long unsigned int base;
	long unsigned int io_port;
	unsigned char n_io_port;
	unsigned char dma_channel;
	unsigned int irq;
	enum scsi_host_state shost_state;
	struct device shost_gendev;
	struct device shost_dev;
	void *shost_data;
	struct device *dma_dev;
	int rpm_autosuspend_delay;
	long unsigned int hostdata[0];
};

struct TxDesc {
	__le32 opts1;
	__le32 opts2;
	__le64 addr;
};

struct ZSTD_CCtx_params_s {
	ZSTD_format_e format;
	ZSTD_compressionParameters cParams;
	ZSTD_frameParameters fParams;
	int compressionLevel;
	int forceWindow;
	size_t targetCBlockSize;
	int srcSizeHint;
	ZSTD_dictAttachPref_e attachDictPref;
	ZSTD_paramSwitch_e literalCompressionMode;
	int nbWorkers;
	size_t jobSize;
	int overlapLog;
	int rsyncable;
	ldmParams_t ldmParams;
	int enableDedicatedDictSearch;
	ZSTD_bufferMode_e inBufferMode;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_sequenceFormat_e blockDelimiters;
	int validateSequences;
	ZSTD_paramSwitch_e useBlockSplitter;
	ZSTD_paramSwitch_e useRowMatchFinder;
	int deterministicRefPrefix;
	ZSTD_customMem customMem;
};

typedef struct ZSTD_CCtx_params_s ZSTD_CCtx_params;

struct xxh64_state {
	uint64_t total_len;
	uint64_t v1;
	uint64_t v2;
	uint64_t v3;
	uint64_t v4;
	uint64_t mem64[4];
	uint32_t memsize;
};

struct POOL_ctx_s;

typedef struct POOL_ctx_s ZSTD_threadPool;

struct ZSTD_inBuffer_s {
	const void *src;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_inBuffer_s ZSTD_inBuffer;

struct ZSTD_prefixDict_s {
	const void *dict;
	size_t dictSize;
	ZSTD_dictContentType_e dictContentType;
};

typedef struct ZSTD_prefixDict_s ZSTD_prefixDict;

struct ZSTD_CCtx_s {
	ZSTD_compressionStage_e stage;
	int cParamsChanged;
	int bmi2;
	ZSTD_CCtx_params requestedParams;
	ZSTD_CCtx_params appliedParams;
	ZSTD_CCtx_params simpleApiParams;
	U32 dictID;
	size_t dictContentSize;
	ZSTD_cwksp workspace;
	size_t blockSize;
	long long unsigned int pledgedSrcSizePlusOne;
	long long unsigned int consumedSrcSize;
	long long unsigned int producedCSize;
	struct xxh64_state xxhState;
	ZSTD_customMem customMem;
	ZSTD_threadPool *pool;
	size_t staticSize;
	SeqCollector seqCollector;
	int isFirstBlock;
	int initialized;
	seqStore_t seqStore;
	ldmState_t ldmState;
	rawSeq *ldmSequences;
	size_t maxNbLdmSequences;
	rawSeqStore_t externSeqStore;
	ZSTD_blockState_t blockState;
	U32 *entropyWorkspace;
	ZSTD_buffered_policy_e bufferedPolicy;
	char *inBuff;
	size_t inBuffSize;
	size_t inToCompress;
	size_t inBuffPos;
	size_t inBuffTarget;
	char *outBuff;
	size_t outBuffSize;
	size_t outBuffContentSize;
	size_t outBuffFlushedSize;
	ZSTD_cStreamStage streamStage;
	U32 frameEnded;
	ZSTD_inBuffer expectedInBuffer;
	size_t expectedOutBufferSize;
	ZSTD_localDict localDict;
	const ZSTD_CDict *cdict;
	ZSTD_prefixDict prefixDict;
	ZSTD_blockSplitCtx blockSplitCtx;
};

typedef struct ZSTD_CCtx_s ZSTD_CCtx;

typedef ZSTD_CCtx ZSTD_CStream;

typedef ZSTD_CCtx zstd_cctx;

typedef ZSTD_CStream zstd_cstream;

struct ZSTD_CDict_s {
	const void *dictContent;
	size_t dictContentSize;
	ZSTD_dictContentType_e dictContentType;
	U32 *entropyWorkspace;
	ZSTD_cwksp workspace;
	ZSTD_matchState_t matchState;
	ZSTD_compressedBlockState_t cBlockState;
	ZSTD_customMem customMem;
	U32 dictID;
	int compressionLevel;
	ZSTD_paramSwitch_e useRowMatchFinder;
};

typedef ZSTD_CDict zstd_cdict;

struct ZSTD_outBuffer_s {
	void *dst;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_outBuffer_s ZSTD_outBuffer;

struct ZSTD_DCtx_s {
	const ZSTD_seqSymbol *LLTptr;
	const ZSTD_seqSymbol *MLTptr;
	const ZSTD_seqSymbol *OFTptr;
	const HUF_DTable *HUFptr;
	ZSTD_entropyDTables_t entropy;
	U32 workspace[640];
	const void *previousDstEnd;
	const void *prefixStart;
	const void *virtualStart;
	const void *dictEnd;
	size_t expected;
	ZSTD_frameHeader fParams;
	U64___2 processedCSize;
	U64___2 decodedSize;
	blockType_e bType;
	ZSTD_dStage stage;
	U32 litEntropy;
	U32 fseEntropy;
	struct xxh64_state xxhState;
	size_t headerSize;
	ZSTD_format_e format;
	ZSTD_forceIgnoreChecksum_e forceIgnoreChecksum;
	U32 validateChecksum;
	const BYTE *litPtr;
	ZSTD_customMem customMem;
	size_t litSize;
	size_t rleSize;
	size_t staticSize;
	ZSTD_DDict *ddictLocal;
	const ZSTD_DDict *ddict;
	U32 dictID;
	int ddictIsCold;
	ZSTD_dictUses_e dictUses;
	ZSTD_DDictHashSet *ddictSet;
	ZSTD_refMultipleDDicts_e refMultipleDDicts;
	ZSTD_dStreamStage streamStage;
	char *inBuff;
	size_t inBuffSize;
	size_t inPos;
	size_t maxWindowSize;
	char *outBuff;
	size_t outBuffSize;
	size_t outStart;
	size_t outEnd;
	size_t lhSize;
	U32 hostageByte;
	int noForwardProgress;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_outBuffer expectedOutBuffer;
	BYTE *litBuffer;
	const BYTE *litBufferEnd;
	ZSTD_litLocation_e litBufferLocation;
	BYTE litExtraBuffer[65568];
	BYTE headerBuffer[18];
	size_t oversizedDuration;
};

typedef struct ZSTD_DCtx_s ZSTD_DCtx;

typedef ZSTD_DCtx ZSTD_DStream;

typedef ZSTD_DCtx zstd_dctx;

typedef ZSTD_DStream zstd_dstream;

struct ZSTD_DDict_s {
	void *dictBuffer;
	const void *dictContent;
	size_t dictSize;
	ZSTD_entropyDTables_t entropy;
	U32 dictID;
	U32 entropyPresent;
	ZSTD_customMem cMem;
};

typedef ZSTD_DDict zstd_ddict;

typedef ZSTD_inBuffer zstd_in_buffer;

typedef ZSTD_outBuffer zstd_out_buffer;

union _MFI_CAPABILITIES {
	struct {
		u32 support_fp_remote_lun: 1;
		u32 support_additional_msix: 1;
		u32 support_fastpath_wb: 1;
		u32 support_max_255lds: 1;
		u32 support_ndrive_r1_lb: 1;
		u32 support_core_affinity: 1;
		u32 security_protocol_cmds_fw: 1;
		u32 support_ext_queue_depth: 1;
		u32 support_ext_io_size: 1;
		u32 support_vfid_in_ioframe: 1;
		u32 support_fp_rlbypass: 1;
		u32 support_qd_throttling: 1;
		u32 support_pd_map_target_id: 1;
		u32 support_64bit_mode: 1;
		u32 support_nvme_passthru: 1;
		u32 support_fw_exposed_dev_list: 1;
		u32 support_memdump: 1;
		u32 reserved: 15;
	} mfi_capabilities;
	__le32 reg;
};

typedef union _MFI_CAPABILITIES MFI_CAPABILITIES;

struct _MPI25_EVENT_DATA_SAS_DEVICE_DISCOVERY_ERROR {
	U16 DevHandle;
	U8 ReasonCode;
	U8 PhysicalPort;
	U32___2 Reserved1[2];
	U64 SASAddress;
	U32___2 Reserved2[2];
} __attribute__((packed));

typedef struct _MPI25_EVENT_DATA_SAS_DEVICE_DISCOVERY_ERROR Mpi25EventDataSasDeviceDiscoveryError_t;

struct _MPI2_IEEE_SGE_SIMPLE64 {
	U64 Address;
	U32___2 Length;
	U16 Reserved1;
	U8 Reserved2;
	U8 Flags;
};

typedef struct _MPI2_IEEE_SGE_SIMPLE64 MPI2_IEEE_SGE_SIMPLE64;

struct _MPI25_IEEE_SGE_CHAIN64 {
	U64 Address;
	U32___2 Length;
	U16 Reserved1;
	U8 NextChainOffset;
	U8 Flags;
};

typedef struct _MPI25_IEEE_SGE_CHAIN64 MPI25_IEEE_SGE_CHAIN64;

union _MPI25_SGE_IO_UNION {
	MPI2_IEEE_SGE_SIMPLE64 IeeeSimple;
	MPI25_IEEE_SGE_CHAIN64 IeeeChain;
};

typedef union _MPI25_SGE_IO_UNION MPI25_SGE_IO_UNION;

struct _MPI25_FW_UPLOAD_REQUEST {
	U8 ImageType;
	U8 Reserved1;
	U8 ChainOffset;
	U8 Function;
	U16 Reserved2;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
	U32___2 Reserved5;
	U32___2 Reserved6;
	U32___2 Reserved7;
	U32___2 ImageOffset;
	U32___2 ImageSize;
	MPI25_SGE_IO_UNION SGL;
};

typedef struct _MPI25_FW_UPLOAD_REQUEST Mpi25FWUploadRequest_t;

typedef struct _MPI25_IEEE_SGE_CHAIN64 Mpi25IeeeSgeChain64_t;

typedef struct _MPI25_IEEE_SGE_CHAIN64 *pMpi25IeeeSgeChain64_t;

struct _MPI2_SCSI_IO_CDB_EEDP32 {
	U8 CDB[20];
	__be32 PrimaryReferenceTag;
	U16 PrimaryApplicationTag;
	U16 PrimaryApplicationTagMask;
	U32___2 TransferLength;
};

typedef struct _MPI2_SCSI_IO_CDB_EEDP32 MPI2_SCSI_IO_CDB_EEDP32;

union _MPI25_SCSI_IO_CDB_UNION {
	U8 CDB32[32];
	MPI2_SCSI_IO_CDB_EEDP32 EEDP32;
	MPI2_IEEE_SGE_SIMPLE64 SGE;
};

typedef union _MPI25_SCSI_IO_CDB_UNION MPI25_SCSI_IO_CDB_UNION;

struct _MPI25_SCSI_IO_REQUEST {
	U16 DevHandle;
	U8 ChainOffset;
	U8 Function;
	U16 Reserved1;
	U8 Reserved2;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved3;
	U32___2 SenseBufferLowAddress;
	U8 DMAFlags;
	U8 Reserved5;
	U8 SenseBufferLength;
	U8 Reserved4;
	U8 SGLOffset0;
	U8 SGLOffset1;
	U8 SGLOffset2;
	U8 SGLOffset3;
	U32___2 SkipCount;
	U32___2 DataLength;
	U32___2 BidirectionalDataLength;
	U16 IoFlags;
	U16 EEDPFlags;
	U16 EEDPBlockSize;
	U16 Reserved6;
	U32___2 SecondaryReferenceTag;
	U16 SecondaryApplicationTag;
	U16 ApplicationTagTranslationMask;
	U8 LUN[8];
	U32___2 Control;
	MPI25_SCSI_IO_CDB_UNION CDB;
	MPI25_SGE_IO_UNION SGL;
};

typedef struct _MPI25_SCSI_IO_REQUEST Mpi25SCSIIORequest_t;

struct _MPI26_ATOMIC_REQUEST_DESCRIPTOR {
	U8 RequestFlags;
	U8 MSIxIndex;
	U16 SMID;
};

typedef struct _MPI26_ATOMIC_REQUEST_DESCRIPTOR Mpi26AtomicRequestDescriptor_t;

struct _MPI26_HASH_EXCLUSION_FORMAT {
	U32___2 Offset;
	U32___2 Size;
};

typedef struct _MPI26_HASH_EXCLUSION_FORMAT MPI26_HASH_EXCLUSION_FORMAT;

struct _MPI26_COMPONENT_IMAGE_HEADER {
	U32___2 Signature0;
	U32___2 LoadAddress;
	U32___2 DataSize;
	U32___2 StartAddress;
	U32___2 Signature1;
	U32___2 FlashOffset;
	U32___2 FlashSize;
	U32___2 VersionStringOffset;
	U32___2 BuildDateStringOffset;
	U32___2 BuildTimeStringOffset;
	U32___2 EnvironmentVariableOffset;
	U32___2 ApplicationSpecific;
	U32___2 Signature2;
	U32___2 HeaderSize;
	U32___2 Crc;
	U8 NotFlashImage;
	U8 Compressed;
	U16 Reserved3E;
	U32___2 SecondaryFlashOffset;
	U32___2 Reserved44;
	U32___2 Reserved48;
	MPI2_VERSION_UNION RMCInterfaceVersion;
	MPI2_VERSION_UNION Reserved50;
	MPI2_VERSION_UNION FWVersion;
	MPI2_VERSION_UNION NvdataVersion;
	MPI26_HASH_EXCLUSION_FORMAT HashExclusion[4];
	U32___2 NextImageHeaderOffset;
	U32___2 Reserved80[32];
};

typedef struct _MPI26_COMPONENT_IMAGE_HEADER Mpi26ComponentImageHeader_t;

struct _MPI2_CONFIG_EXTENDED_PAGE_HEADER {
	U8 PageVersion;
	U8 Reserved1;
	U8 PageNumber;
	U8 PageType;
	U16 ExtPageLength;
	U8 ExtPageType;
	U8 Reserved2;
};

typedef struct _MPI2_CONFIG_EXTENDED_PAGE_HEADER MPI2_CONFIG_EXTENDED_PAGE_HEADER;

struct _MPI26_CONFIG_PAGE_DRIVER_TRIGGER_0 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U16 TriggerFlags;
	U16 Reserved0xA;
	U32___2 Reserved0xC[61];
};

typedef struct _MPI26_CONFIG_PAGE_DRIVER_TRIGGER_0 Mpi26DriverTriggerPage0_t;

struct _MPI26_DRIVER_MASTER_TRIGGER_ENTRY {
	U32___2 MasterTriggerFlags;
};

typedef struct _MPI26_DRIVER_MASTER_TRIGGER_ENTRY MPI26_DRIVER_MASTER_TRIGGER_ENTRY;

struct _MPI26_CONFIG_PAGE_DRIVER_TRIGGER_1 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U16 NumMasterTrigger;
	U16 Reserved0xA;
	MPI26_DRIVER_MASTER_TRIGGER_ENTRY MasterTriggers[1];
};

typedef struct _MPI26_CONFIG_PAGE_DRIVER_TRIGGER_1 Mpi26DriverTriggerPage1_t;

struct _MPI26_DRIVER_MPI_EVENT_TRIGGER_ENTRY {
	U16 MPIEventCode;
	U16 MPIEventCodeSpecific;
};

typedef struct _MPI26_DRIVER_MPI_EVENT_TRIGGER_ENTRY MPI26_DRIVER_MPI_EVENT_TRIGGER_ENTRY;

struct _MPI26_CONFIG_PAGE_DRIVER_TRIGGER_2 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U16 NumMPIEventTrigger;
	U16 Reserved0xA;
	MPI26_DRIVER_MPI_EVENT_TRIGGER_ENTRY MPIEventTriggers[20];
};

typedef struct _MPI26_CONFIG_PAGE_DRIVER_TRIGGER_2 Mpi26DriverTriggerPage2_t;

struct _MPI26_DRIVER_SCSI_SENSE_TRIGGER_ENTRY {
	U8 ASCQ;
	U8 ASC;
	U8 SenseKey;
	U8 Reserved;
};

typedef struct _MPI26_DRIVER_SCSI_SENSE_TRIGGER_ENTRY MPI26_DRIVER_SCSI_SENSE_TRIGGER_ENTRY;

struct _MPI26_CONFIG_PAGE_DRIVER_TRIGGER_3 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U16 NumSCSISenseTrigger;
	U16 Reserved0xA;
	MPI26_DRIVER_SCSI_SENSE_TRIGGER_ENTRY SCSISenseTriggers[20];
};

typedef struct _MPI26_CONFIG_PAGE_DRIVER_TRIGGER_3 Mpi26DriverTriggerPage3_t;

struct _MPI26_DRIVER_IOCSTATUS_LOGINFO_TRIGGER_ENTRY {
	U16 IOCStatus;
	U16 Reserved;
	U32___2 LogInfo;
};

typedef struct _MPI26_DRIVER_IOCSTATUS_LOGINFO_TRIGGER_ENTRY MPI26_DRIVER_IOCSTATUS_LOGINFO_TRIGGER_ENTRY;

struct _MPI26_CONFIG_PAGE_DRIVER_TRIGGER_4 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U16 NumIOCStatusLogInfoTrigger;
	U16 Reserved0xA;
	MPI26_DRIVER_IOCSTATUS_LOGINFO_TRIGGER_ENTRY IOCStatusLoginfoTriggers[20];
};

typedef struct _MPI26_CONFIG_PAGE_DRIVER_TRIGGER_4 Mpi26DriverTriggerPage4_t;

struct _MPI26_CONFIG_PAGE_PCIEDEV_0 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U16 Slot;
	U16 EnclosureHandle;
	U64 WWID;
	U16 ParentDevHandle;
	U8 PortNum;
	U8 AccessStatus;
	U16 DevHandle;
	U8 PhysicalPort;
	U8 Reserved1;
	U32___2 DeviceInfo;
	U32___2 Flags;
	U8 SupportedLinkRates;
	U8 MaxPortWidth;
	U8 NegotiatedPortWidth;
	U8 NegotiatedLinkRate;
	U8 EnclosureLevel;
	U8 Reserved2;
	U16 Reserved3;
	U8 ConnectorName[4];
	U32___2 Reserved4;
	U32___2 Reserved5;
} __attribute__((packed));

typedef struct _MPI26_CONFIG_PAGE_PCIEDEV_0 Mpi26PCIeDevicePage0_t;

struct _MPI26_CONFIG_PAGE_PCIEDEV_2 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U16 DevHandle;
	U8 ControllerResetTO;
	U8 Reserved1;
	U32___2 MaximumDataTransferSize;
	U32___2 Capabilities;
	U16 NOIOB;
	U16 ShutdownLatency;
	U16 VendorID;
	U16 DeviceID;
	U16 SubsystemVendorID;
	U16 SubsystemID;
	U8 RevisionID;
	U8 Reserved21[3];
};

typedef struct _MPI26_CONFIG_PAGE_PCIEDEV_2 Mpi26PCIeDevicePage2_t;

struct _MPI26_PCIE_IO_UNIT1_PHY_DATA {
	U8 Link;
	U8 LinkFlags;
	U8 PhyFlags;
	U8 MaxMinLinkRate;
	U32___2 ControllerPhyDeviceInfo;
	U32___2 Reserved1;
};

typedef struct _MPI26_PCIE_IO_UNIT1_PHY_DATA MPI26_PCIE_IO_UNIT1_PHY_DATA;

struct _MPI26_CONFIG_PAGE_PIOUNIT_1 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U16 ControlFlags;
	U16 Reserved;
	U16 AdditionalControlFlags;
	U16 NVMeMaxQueueDepth;
	U8 NumPhys;
	U8 DMDReportPCIe;
	U16 Reserved2;
	MPI26_PCIE_IO_UNIT1_PHY_DATA PhyData[0];
};

typedef struct _MPI26_CONFIG_PAGE_PIOUNIT_1 Mpi26PCIeIOUnitPage1_t;

struct _MPI26_EVENT_DATA_ACTIVE_CABLE_EXCEPT {
	U32___2 ActiveCablePowerRequirement;
	U8 ReasonCode;
	U8 ReceptacleID;
	U16 Reserved1;
};

typedef struct _MPI26_EVENT_DATA_ACTIVE_CABLE_EXCEPT Mpi26EventDataActiveCableExcept_t;

struct _MPI26_EVENT_DATA_PCIE_DEVICE_STATUS_CHANGE {
	U16 TaskTag;
	U8 ReasonCode;
	U8 PhysicalPort;
	U8 ASC;
	U8 ASCQ;
	U16 DevHandle;
	U32___2 Reserved2;
	U64 WWID;
	U8 LUN[8];
} __attribute__((packed));

typedef struct _MPI26_EVENT_DATA_PCIE_DEVICE_STATUS_CHANGE Mpi26EventDataPCIeDeviceStatusChange_t;

struct _MPI26_EVENT_DATA_PCIE_ENUMERATION {
	U8 Flags;
	U8 ReasonCode;
	U8 PhysicalPort;
	U8 Reserved1;
	U32___2 EnumerationStatus;
};

typedef struct _MPI26_EVENT_DATA_PCIE_ENUMERATION Mpi26EventDataPCIeEnumeration_t;

struct _MPI26_EVENT_PCIE_TOPO_PORT_ENTRY {
	U16 AttachedDevHandle;
	U8 PortStatus;
	U8 Reserved1;
	U8 CurrentPortInfo;
	U8 Reserved2;
	U8 PreviousPortInfo;
	U8 Reserved3;
};

typedef struct _MPI26_EVENT_PCIE_TOPO_PORT_ENTRY MPI26_EVENT_PCIE_TOPO_PORT_ENTRY;

struct _MPI26_EVENT_DATA_PCIE_TOPOLOGY_CHANGE_LIST {
	U16 EnclosureHandle;
	U16 SwitchDevHandle;
	U8 NumPorts;
	U8 Reserved1;
	U16 Reserved2;
	U8 NumEntries;
	U8 StartPortNum;
	U8 SwitchStatus;
	U8 PhysicalPort;
	MPI26_EVENT_PCIE_TOPO_PORT_ENTRY PortEntry[0];
};

typedef struct _MPI26_EVENT_DATA_PCIE_TOPOLOGY_CHANGE_LIST Mpi26EventDataPCIeTopologyChangeList_t;

struct _MPI26_IOUNIT_CONTROL_REPLY {
	U8 Operation;
	U8 Reserved1;
	U8 MsgLength;
	U8 Function;
	U16 DevHandle;
	U8 IOCParameter;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved3;
	U16 Reserved4;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
};

typedef struct _MPI26_IOUNIT_CONTROL_REPLY Mpi26IoUnitControlReply_t;

struct _MPI26_IOUNIT_CONTROL_REQUEST {
	U8 Operation;
	U8 Reserved1;
	U8 ChainOffset;
	U8 Function;
	U16 DevHandle;
	U8 IOCParameter;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved3;
	U16 Reserved4;
	U8 PhyNum;
	U8 PrimFlags;
	U32___2 Primitive;
	U8 LookupMethod;
	U8 Reserved5;
	U16 SlotNumber;
	U64 LookupAddress;
	U32___2 IOCParameterValue;
	U32___2 Reserved7;
	U32___2 Reserved8;
} __attribute__((packed));

typedef struct _MPI26_IOUNIT_CONTROL_REQUEST Mpi26IoUnitControlRequest_t;

struct _MPI26_NVME_ENCAPSULATED_ERROR_REPLY {
	U16 DevHandle;
	U8 MsgLength;
	U8 Function;
	U16 EncapsulatedCommandLength;
	U8 Reserved1;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved2;
	U16 Reserved3;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
	U16 ErrorResponseCount;
	U16 Reserved4;
};

typedef struct _MPI26_NVME_ENCAPSULATED_ERROR_REPLY Mpi26NVMeEncapsulatedErrorReply_t;

struct _MPI26_NVME_ENCAPSULATED_REQUEST {
	U16 DevHandle;
	U8 ChainOffset;
	U8 Function;
	U16 EncapsulatedCommandLength;
	U8 Reserved1;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved2;
	U32___2 Reserved3;
	U64 ErrorResponseBaseAddress;
	U16 ErrorResponseAllocationLength;
	U16 Flags;
	U32___2 DataLength;
	U8 NVMe_Command[4];
} __attribute__((packed));

struct _MPI2_ADDRESS_REPLY_DESCRIPTOR {
	U8 ReplyFlags;
	U8 MSIxIndex;
	U16 SMID;
	U32___2 ReplyFrameAddress;
};

typedef struct _MPI2_ADDRESS_REPLY_DESCRIPTOR MPI2_ADDRESS_REPLY_DESCRIPTOR;

struct _MPI2_BIOS4_ENTRY {
	U64 ReassignmentWWID;
	U64 ReassignmentDeviceName;
};

typedef struct _MPI2_BIOS4_ENTRY MPI2_BIOS4_ENTRY;

typedef struct _MPI2_BOOT_DEVICE_DEVICE_NAME Mpi2BootDeviceDeviceName_t;

typedef struct _MPI2_BOOT_DEVICE_ENCLOSURE_SLOT Mpi2BootDeviceEnclosureSlot_t;

typedef struct _MPI2_BOOT_DEVICE_SAS_WWID Mpi2BootDeviceSasWwid_t;

struct _MPI2_CONFIG_PAGE_BIOS_4 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U8 NumPhys;
	U8 Reserved1;
	U16 Reserved2;
	MPI2_BIOS4_ENTRY Phy[0];
};

typedef struct _MPI2_CONFIG_PAGE_BIOS_4 Mpi2BiosPage4_t;

struct _MPI2_CONFIG_PAGE_EXPANDER_0 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U8 PhysicalPort;
	U8 ReportGenLength;
	U16 EnclosureHandle;
	U64 SASAddress;
	U32___2 DiscoveryStatus;
	U16 DevHandle;
	U16 ParentDevHandle;
	U16 ExpanderChangeCount;
	U16 ExpanderRouteIndexes;
	U8 NumPhys;
	U8 SASLevel;
	U16 Flags;
	U16 STPBusInactivityTimeLimit;
	U16 STPMaxConnectTimeLimit;
	U16 STP_SMP_NexusLossTime;
	U16 MaxNumRoutedSasAddresses;
	U64 ActiveZoneManagerSASAddress;
	U16 ZoneLockInactivityLimit;
	U16 Reserved1;
	U8 TimeToReducedFunc;
	U8 InitialTimeToReducedFunc;
	U8 MaxReducedFuncTime;
	U8 Reserved2;
} __attribute__((packed));

typedef struct _MPI2_CONFIG_PAGE_EXPANDER_0 Mpi2ExpanderPage0_t;

struct _MPI2_CONFIG_PAGE_EXPANDER_1 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U8 PhysicalPort;
	U8 Reserved1;
	U16 Reserved2;
	U8 NumPhys;
	U8 Phy;
	U16 NumTableEntriesProgrammed;
	U8 ProgrammedLinkRate;
	U8 HwLinkRate;
	U16 AttachedDevHandle;
	U32___2 PhyInfo;
	U32___2 AttachedDeviceInfo;
	U16 ExpanderDevHandle;
	U8 ChangeCount;
	U8 NegotiatedLinkRate;
	U8 PhyIdentifier;
	U8 AttachedPhyIdentifier;
	U8 Reserved3;
	U8 DiscoveryInfo;
	U32___2 AttachedPhyInfo;
	U8 ZoneGroup;
	U8 SelfConfigStatus;
	U16 Reserved4;
};

typedef struct _MPI2_CONFIG_PAGE_EXPANDER_1 Mpi2ExpanderPage1_t;

struct _MPI2_CONFIG_PAGE_IO_UNIT_3 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U8 GPIOCount;
	U8 Reserved1;
	U16 Reserved2;
	U16 GPIOVal[36];
};

typedef struct _MPI2_CONFIG_PAGE_IO_UNIT_3 Mpi2IOUnitPage3_t;

struct _MPI2_IOUNIT8_SENSOR {
	U16 Flags;
	U16 Reserved1;
	U16 Threshold[4];
	U32___2 Reserved2;
	U32___2 Reserved3;
	U32___2 Reserved4;
};

typedef struct _MPI2_IOUNIT8_SENSOR MPI2_IOUNIT8_SENSOR;

struct _MPI2_CONFIG_PAGE_IO_UNIT_8 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U32___2 Reserved1;
	U32___2 Reserved2;
	U8 NumSensors;
	U8 PollingInterval;
	U16 Reserved3;
	MPI2_IOUNIT8_SENSOR Sensor[0];
};

typedef struct _MPI2_CONFIG_PAGE_IO_UNIT_8 Mpi2IOUnitPage8_t;

struct _MPI2_CONFIG_PAGE_MAN_1 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U8 VPD[256];
};

typedef struct _MPI2_CONFIG_PAGE_MAN_1 Mpi2ManufacturingPage1_t;

struct _MPI2_MANPAGE7_CONNECTOR_INFO {
	U32___2 Pinout;
	U8 Connector[16];
	U8 Location;
	U8 ReceptacleID;
	U16 Slot;
	U16 Slotx2;
	U16 Slotx4;
};

typedef struct _MPI2_MANPAGE7_CONNECTOR_INFO MPI2_MANPAGE7_CONNECTOR_INFO;

struct _MPI2_CONFIG_PAGE_MAN_7 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U32___2 Reserved1;
	U32___2 Reserved2;
	U32___2 Flags;
	U8 EnclosureName[16];
	U8 NumPhys;
	U8 Reserved3;
	U16 Reserved4;
	MPI2_MANPAGE7_CONNECTOR_INFO ConnectorInfo[0];
};

typedef struct _MPI2_CONFIG_PAGE_MAN_7 Mpi2ManufacturingPage7_t;

struct _MPI2_RAIDCONFIG0_CONFIG_ELEMENT {
	U16 ElementFlags;
	U16 VolDevHandle;
	U8 HotSparePool;
	U8 PhysDiskNum;
	U16 PhysDiskDevHandle;
};

typedef struct _MPI2_RAIDCONFIG0_CONFIG_ELEMENT MPI2_RAIDCONFIG0_CONFIG_ELEMENT;

struct _MPI2_CONFIG_PAGE_RAID_CONFIGURATION_0 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U8 NumHotSpares;
	U8 NumPhysDisks;
	U8 NumVolumes;
	U8 ConfigNum;
	U32___2 Flags;
	U8 ConfigGUID[24];
	U32___2 Reserved1;
	U8 NumElements;
	U8 Reserved2;
	U16 Reserved3;
	MPI2_RAIDCONFIG0_CONFIG_ELEMENT ConfigElement[0];
};

typedef struct _MPI2_CONFIG_PAGE_RAID_CONFIGURATION_0 Mpi2RaidConfigurationPage0_t;

struct _MPI2_RAIDVOL0_SETTINGS {
	U16 Settings;
	U8 HotSparePool;
	U8 Reserved;
};

typedef struct _MPI2_RAIDVOL0_SETTINGS MPI2_RAIDVOL0_SETTINGS;

struct _MPI2_RAIDVOL0_PHYS_DISK {
	U8 RAIDSetNum;
	U8 PhysDiskMap;
	U8 PhysDiskNum;
	U8 Reserved;
};

typedef struct _MPI2_RAIDVOL0_PHYS_DISK MPI2_RAIDVOL0_PHYS_DISK;

struct _MPI2_CONFIG_PAGE_RAID_VOL_0 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U16 DevHandle;
	U8 VolumeState;
	U8 VolumeType;
	U32___2 VolumeStatusFlags;
	MPI2_RAIDVOL0_SETTINGS VolumeSettings;
	U64 MaxLBA;
	U32___2 StripeSize;
	U16 BlockSize;
	U16 Reserved1;
	U8 SupportedPhysDisks;
	U8 ResyncRate;
	U16 DataScrubDuration;
	U8 NumPhysDisks;
	U8 Reserved2;
	U8 Reserved3;
	U8 InactiveStatus;
	MPI2_RAIDVOL0_PHYS_DISK PhysDisk[0];
};

typedef struct _MPI2_CONFIG_PAGE_RAID_VOL_0 Mpi2RaidVolPage0_t;

struct _MPI2_CONFIG_PAGE_RAID_VOL_1 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U16 DevHandle;
	U16 Reserved0;
	U8 GUID[24];
	U8 Name[16];
	U64 WWID;
	U32___2 Reserved1;
	U32___2 Reserved2;
};

typedef struct _MPI2_CONFIG_PAGE_RAID_VOL_1 Mpi2RaidVolPage1_t;

struct _MPI2_RAIDPHYSDISK0_SETTINGS {
	U16 Reserved1;
	U8 HotSparePool;
	U8 Reserved2;
};

typedef struct _MPI2_RAIDPHYSDISK0_SETTINGS MPI2_RAIDPHYSDISK0_SETTINGS;

struct _MPI2_RAIDPHYSDISK0_INQUIRY_DATA {
	U8 VendorID[8];
	U8 ProductID[16];
	U8 ProductRevLevel[4];
	U8 SerialNum[32];
};

typedef struct _MPI2_RAIDPHYSDISK0_INQUIRY_DATA MPI2_RAIDPHYSDISK0_INQUIRY_DATA;

struct _MPI2_CONFIG_PAGE_RD_PDISK_0 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U16 DevHandle;
	U8 Reserved1;
	U8 PhysDiskNum;
	MPI2_RAIDPHYSDISK0_SETTINGS PhysDiskSettings;
	U32___2 Reserved2;
	MPI2_RAIDPHYSDISK0_INQUIRY_DATA InquiryData;
	U32___2 Reserved3;
	U8 PhysDiskState;
	U8 OfflineReason;
	U8 IncompatibleReason;
	U8 PhysDiskAttributes;
	U32___2 PhysDiskStatusFlags;
	U64 DeviceMaxLBA;
	U64 HostMaxLBA;
	U64 CoercedMaxLBA;
	U16 BlockSize;
	U16 Reserved5;
	U32___2 Reserved6;
};

typedef struct _MPI2_CONFIG_PAGE_RD_PDISK_0 Mpi2RaidPhysDiskPage0_t;

struct _MPI2_SAS_IO_UNIT0_PHY_DATA {
	U8 Port;
	U8 PortFlags;
	U8 PhyFlags;
	U8 NegotiatedLinkRate;
	U32___2 ControllerPhyDeviceInfo;
	U16 AttachedDevHandle;
	U16 ControllerDevHandle;
	U32___2 DiscoveryStatus;
	U32___2 Reserved;
};

typedef struct _MPI2_SAS_IO_UNIT0_PHY_DATA MPI2_SAS_IO_UNIT0_PHY_DATA;

struct _MPI2_CONFIG_PAGE_SASIOUNIT_0 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U32___2 Reserved1;
	U8 NumPhys;
	U8 Reserved2;
	U16 Reserved3;
	MPI2_SAS_IO_UNIT0_PHY_DATA PhyData[0];
};

typedef struct _MPI2_CONFIG_PAGE_SASIOUNIT_0 Mpi2SasIOUnitPage0_t;

struct _MPI2_SAS_IO_UNIT1_PHY_DATA {
	U8 Port;
	U8 PortFlags;
	U8 PhyFlags;
	U8 MaxMinLinkRate;
	U32___2 ControllerPhyDeviceInfo;
	U16 MaxTargetPortConnectTime;
	U16 Reserved1;
};

typedef struct _MPI2_SAS_IO_UNIT1_PHY_DATA MPI2_SAS_IO_UNIT1_PHY_DATA;

struct _MPI2_CONFIG_PAGE_SASIOUNIT_1 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U16 ControlFlags;
	U16 SASNarrowMaxQueueDepth;
	U16 AdditionalControlFlags;
	U16 SASWideMaxQueueDepth;
	U8 NumPhys;
	U8 SATAMaxQDepth;
	U8 ReportDeviceMissingDelay;
	U8 IODeviceMissingDelay;
	MPI2_SAS_IO_UNIT1_PHY_DATA PhyData[0];
};

typedef struct _MPI2_CONFIG_PAGE_SASIOUNIT_1 Mpi2SasIOUnitPage1_t;

struct _MPI2_CONFIG_PAGE_SAS_DEV_0 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U16 Slot;
	U16 EnclosureHandle;
	U64 SASAddress;
	U16 ParentDevHandle;
	U8 PhyNum;
	U8 AccessStatus;
	U16 DevHandle;
	U8 AttachedPhyIdentifier;
	U8 ZoneGroup;
	U32___2 DeviceInfo;
	U16 Flags;
	U8 PhysicalPort;
	U8 MaxPortConnections;
	U64 DeviceName;
	U8 PortGroups;
	U8 DmaGroup;
	U8 ControlGroup;
	U8 EnclosureLevel;
	U32___2 ConnectorName[4];
	U32___2 Reserved3;
} __attribute__((packed));

typedef struct _MPI2_CONFIG_PAGE_SAS_DEV_0 Mpi2SasDevicePage0_t;

struct _MPI2_CONFIG_PAGE_SAS_DEV_1 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U32___2 Reserved1;
	U64 SASAddress;
	U32___2 Reserved2;
	U16 DevHandle;
	U16 Reserved3;
	U8 InitialRegDeviceFIS[20];
} __attribute__((packed));

typedef struct _MPI2_CONFIG_PAGE_SAS_DEV_1 Mpi2SasDevicePage1_t;

struct _MPI2_CONFIG_PAGE_SAS_ENCLOSURE_0 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U32___2 Reserved1;
	U64 EnclosureLogicalID;
	U16 Flags;
	U16 EnclosureHandle;
	U16 NumSlots;
	U16 StartSlot;
	U8 ChassisSlot;
	U8 EnclosureLevel;
	U16 SEPDevHandle;
	U8 OEMRD;
	U8 Reserved1a;
	U16 Reserved2;
	U32___2 Reserved3;
} __attribute__((packed));

typedef struct _MPI2_CONFIG_PAGE_SAS_ENCLOSURE_0 Mpi2SasEnclosurePage0_t;

struct _MPI2_CONFIG_PAGE_SAS_PHY_0 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U16 OwnerDevHandle;
	U16 Reserved1;
	U16 AttachedDevHandle;
	U8 AttachedPhyIdentifier;
	U8 Reserved2;
	U32___2 AttachedPhyInfo;
	U8 ProgrammedLinkRate;
	U8 HwLinkRate;
	U8 ChangeCount;
	U8 Flags;
	U32___2 PhyInfo;
	U8 NegotiatedLinkRate;
	U8 Reserved3;
	U16 Reserved4;
};

typedef struct _MPI2_CONFIG_PAGE_SAS_PHY_0 Mpi2SasPhyPage0_t;

struct _MPI2_CONFIG_PAGE_SAS_PHY_1 {
	MPI2_CONFIG_EXTENDED_PAGE_HEADER Header;
	U32___2 Reserved1;
	U32___2 InvalidDwordCount;
	U32___2 RunningDisparityErrorCount;
	U32___2 LossDwordSynchCount;
	U32___2 PhyResetProblemCount;
};

typedef struct _MPI2_CONFIG_PAGE_SAS_PHY_1 Mpi2SasPhyPage1_t;

struct _MPI2_CONFIG_REPLY {
	U8 Action;
	U8 SGLFlags;
	U8 MsgLength;
	U8 Function;
	U16 ExtPageLength;
	U8 ExtPageType;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved1;
	U16 Reserved2;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
	MPI2_CONFIG_PAGE_HEADER Header;
};

typedef struct _MPI2_CONFIG_REPLY Mpi2ConfigReply_t;

struct _MPI2_SGE_SIMPLE_UNION {
	U32___2 FlagsLength;
	union {
		U32___2 Address32;
		U64 Address64;
	} u;
} __attribute__((packed));

typedef struct _MPI2_SGE_SIMPLE_UNION MPI2_SGE_SIMPLE_UNION;

struct _MPI2_SGE_CHAIN_UNION {
	U16 Length;
	U8 NextChainOffset;
	U8 Flags;
	union {
		U32___2 Address32;
		U64 Address64;
	} u;
} __attribute__((packed));

typedef struct _MPI2_SGE_CHAIN_UNION MPI2_SGE_CHAIN_UNION;

struct _MPI2_IEEE_SGE_SIMPLE32 {
	U32___2 Address;
	U32___2 FlagsLength;
};

typedef struct _MPI2_IEEE_SGE_SIMPLE32 MPI2_IEEE_SGE_SIMPLE32;

union _MPI2_IEEE_SGE_SIMPLE_UNION {
	MPI2_IEEE_SGE_SIMPLE32 Simple32;
	MPI2_IEEE_SGE_SIMPLE64 Simple64;
};

typedef union _MPI2_IEEE_SGE_SIMPLE_UNION MPI2_IEEE_SGE_SIMPLE_UNION;

typedef MPI2_IEEE_SGE_SIMPLE32 MPI2_IEEE_SGE_CHAIN32;

typedef MPI2_IEEE_SGE_SIMPLE64 MPI2_IEEE_SGE_CHAIN64;

union _MPI2_IEEE_SGE_CHAIN_UNION {
	MPI2_IEEE_SGE_CHAIN32 Chain32;
	MPI2_IEEE_SGE_CHAIN64 Chain64;
};

typedef union _MPI2_IEEE_SGE_CHAIN_UNION MPI2_IEEE_SGE_CHAIN_UNION;

union _MPI2_SGE_IO_UNION {
	MPI2_SGE_SIMPLE_UNION MpiSimple;
	MPI2_SGE_CHAIN_UNION MpiChain;
	MPI2_IEEE_SGE_SIMPLE_UNION IeeeSimple;
	MPI2_IEEE_SGE_CHAIN_UNION IeeeChain;
};

typedef union _MPI2_SGE_IO_UNION MPI2_SGE_IO_UNION;

struct _MPI2_CONFIG_REQUEST {
	U8 Action;
	U8 SGLFlags;
	U8 ChainOffset;
	U8 Function;
	U16 ExtPageLength;
	U8 ExtPageType;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved1;
	U8 Reserved2;
	U8 ProxyVF_ID;
	U16 Reserved4;
	U32___2 Reserved3;
	MPI2_CONFIG_PAGE_HEADER Header;
	U32___2 PageAddress;
	MPI2_SGE_IO_UNION PageBufferSGE;
} __attribute__((packed));

typedef struct _MPI2_CONFIG_REQUEST Mpi2ConfigRequest_t;

struct _MPI2_DEFAULT_REPLY {
	U16 FunctionDependent1;
	U8 MsgLength;
	U8 Function;
	U16 FunctionDependent2;
	U8 FunctionDependent3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved1;
	U16 FunctionDependent5;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
};

typedef struct _MPI2_DEFAULT_REPLY MPI2DefaultReply_t;

struct _MPI2_DEFAULT_REPLY_DESCRIPTOR {
	U8 ReplyFlags;
	U8 MSIxIndex;
	U16 DescriptorTypeDependent1;
	U32___2 DescriptorTypeDependent2;
};

typedef struct _MPI2_DEFAULT_REPLY_DESCRIPTOR MPI2_DEFAULT_REPLY_DESCRIPTOR;

struct _MPI2_DEFAULT_REQUEST_DESCRIPTOR {
	U8 RequestFlags;
	U8 MSIxIndex;
	U16 SMID;
	U16 LMID;
	U16 DescriptorTypeDependent;
};

typedef struct _MPI2_DEFAULT_REQUEST_DESCRIPTOR MPI2_DEFAULT_REQUEST_DESCRIPTOR;

struct _MPI2_DIAG_BUFFER_POST_REPLY {
	U8 ExtendedType;
	U8 BufferType;
	U8 MsgLength;
	U8 Function;
	U16 Reserved2;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
	U16 Reserved5;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
	U32___2 TransferLength;
};

typedef struct _MPI2_DIAG_BUFFER_POST_REPLY Mpi2DiagBufferPostReply_t;

struct _MPI2_DIAG_BUFFER_POST_REQUEST {
	U8 ExtendedType;
	U8 BufferType;
	U8 ChainOffset;
	U8 Function;
	U16 Reserved2;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
	U64 BufferAddress;
	U32___2 BufferLength;
	U32___2 Reserved5;
	U32___2 Reserved6;
	U32___2 Flags;
	U32___2 ProductSpecific[23];
} __attribute__((packed));

typedef struct _MPI2_DIAG_BUFFER_POST_REQUEST Mpi2DiagBufferPostRequest_t;

struct _MPI2_DIAG_RELEASE_REPLY {
	U8 Reserved1;
	U8 BufferType;
	U8 MsgLength;
	U8 Function;
	U16 Reserved2;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
	U16 Reserved5;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
};

typedef struct _MPI2_DIAG_RELEASE_REPLY Mpi2DiagReleaseReply_t;

struct _MPI2_DIAG_RELEASE_REQUEST {
	U8 Reserved1;
	U8 BufferType;
	U8 ChainOffset;
	U8 Function;
	U16 Reserved2;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
};

typedef struct _MPI2_DIAG_RELEASE_REQUEST Mpi2DiagReleaseRequest_t;

struct _MPI2_EVENT_ACK_REQUEST {
	U16 Reserved1;
	U8 ChainOffset;
	U8 Function;
	U16 Reserved2;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
	U16 Event;
	U16 Reserved5;
	U32___2 EventContext;
};

typedef struct _MPI2_EVENT_ACK_REQUEST Mpi2EventAckRequest_t;

struct _MPI2_EVENT_IR_CONFIG_ELEMENT {
	U16 ElementFlags;
	U16 VolDevHandle;
	U8 ReasonCode;
	U8 PhysDiskNum;
	U16 PhysDiskDevHandle;
};

typedef struct _MPI2_EVENT_IR_CONFIG_ELEMENT MPI2_EVENT_IR_CONFIG_ELEMENT;

struct _MPI2_EVENT_DATA_IR_CONFIG_CHANGE_LIST {
	U8 NumElements;
	U8 Reserved1;
	U8 Reserved2;
	U8 ConfigNum;
	U32___2 Flags;
	MPI2_EVENT_IR_CONFIG_ELEMENT ConfigElement[0];
};

typedef struct _MPI2_EVENT_DATA_IR_CONFIG_CHANGE_LIST Mpi2EventDataIrConfigChangeList_t;

struct _MPI2_EVENT_DATA_IR_OPERATION_STATUS {
	U16 VolDevHandle;
	U16 Reserved1;
	U8 RAIDOperation;
	U8 PercentComplete;
	U16 Reserved2;
	U32___2 ElapsedSeconds;
};

typedef struct _MPI2_EVENT_DATA_IR_OPERATION_STATUS Mpi2EventDataIrOperationStatus_t;

struct _MPI2_EVENT_DATA_IR_PHYSICAL_DISK {
	U16 Reserved1;
	U8 ReasonCode;
	U8 PhysDiskNum;
	U16 PhysDiskDevHandle;
	U16 Reserved2;
	U16 Slot;
	U16 EnclosureHandle;
	U32___2 NewValue;
	U32___2 PreviousValue;
};

typedef struct _MPI2_EVENT_DATA_IR_PHYSICAL_DISK Mpi2EventDataIrPhysicalDisk_t;

struct _MPI2_EVENT_DATA_IR_VOLUME {
	U16 VolDevHandle;
	U8 ReasonCode;
	U8 Reserved1;
	U32___2 NewValue;
	U32___2 PreviousValue;
};

typedef struct _MPI2_EVENT_DATA_IR_VOLUME Mpi2EventDataIrVolume_t;

struct _MPI2_EVENT_DATA_LOG_ENTRY_ADDED {
	U64 TimeStamp;
	U32___2 Reserved1;
	U16 LogSequence;
	U16 LogEntryQualifier;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved2;
	U8 LogData[28];
};

typedef struct _MPI2_EVENT_DATA_LOG_ENTRY_ADDED Mpi2EventDataLogEntryAdded_t;

struct _MPI2_EVENT_DATA_SAS_BROADCAST_PRIMITIVE {
	U8 PhyNum;
	U8 Port;
	U8 PortWidth;
	U8 Primitive;
};

typedef struct _MPI2_EVENT_DATA_SAS_BROADCAST_PRIMITIVE Mpi2EventDataSasBroadcastPrimitive_t;

struct _MPI2_EVENT_DATA_SAS_DEVICE_STATUS_CHANGE {
	U16 TaskTag;
	U8 ReasonCode;
	U8 PhysicalPort;
	U8 ASC;
	U8 ASCQ;
	U16 DevHandle;
	U32___2 Reserved2;
	U64 SASAddress;
	U8 LUN[8];
} __attribute__((packed));

typedef struct _MPI2_EVENT_DATA_SAS_DEVICE_STATUS_CHANGE Mpi2EventDataSasDeviceStatusChange_t;

struct _MPI2_EVENT_DATA_SAS_DISCOVERY {
	U8 Flags;
	U8 ReasonCode;
	U8 PhysicalPort;
	U8 Reserved1;
	U32___2 DiscoveryStatus;
};

typedef struct _MPI2_EVENT_DATA_SAS_DISCOVERY Mpi2EventDataSasDiscovery_t;

struct _MPI2_EVENT_DATA_SAS_ENCL_DEV_STATUS_CHANGE {
	U16 EnclosureHandle;
	U8 ReasonCode;
	U8 PhysicalPort;
	U64 EnclosureLogicalID;
	U16 NumSlots;
	U16 StartSlot;
	U32___2 PhyBits;
} __attribute__((packed));

typedef struct _MPI2_EVENT_DATA_SAS_ENCL_DEV_STATUS_CHANGE Mpi2EventDataSasEnclDevStatusChange_t;

struct _MPI2_EVENT_SAS_TOPO_PHY_ENTRY {
	U16 AttachedDevHandle;
	U8 LinkRate;
	U8 PhyStatus;
};

typedef struct _MPI2_EVENT_SAS_TOPO_PHY_ENTRY MPI2_EVENT_SAS_TOPO_PHY_ENTRY;

struct _MPI2_EVENT_DATA_SAS_TOPOLOGY_CHANGE_LIST {
	U16 EnclosureHandle;
	U16 ExpanderDevHandle;
	U8 NumPhys;
	U8 Reserved1;
	U16 Reserved2;
	U8 NumEntries;
	U8 StartPhyNum;
	U8 ExpStatus;
	U8 PhysicalPort;
	MPI2_EVENT_SAS_TOPO_PHY_ENTRY PHY[0];
};

typedef struct _MPI2_EVENT_DATA_SAS_TOPOLOGY_CHANGE_LIST Mpi2EventDataSasTopologyChangeList_t;

struct _MPI2_EVENT_DATA_TEMPERATURE {
	U16 Status;
	U8 SensorNum;
	U8 Reserved1;
	U16 CurrentTemperature;
	U16 Reserved2;
	U32___2 Reserved3;
	U32___2 Reserved4;
};

typedef struct _MPI2_EVENT_DATA_TEMPERATURE Mpi2EventDataTemperature_t;

typedef struct _MPI2_EVENT_IR_CONFIG_ELEMENT Mpi2EventIrConfigElement_t;

struct _MPI2_EVENT_NOTIFICATION_REPLY {
	U16 EventDataLength;
	U8 MsgLength;
	U8 Function;
	U16 Reserved1;
	U8 AckRequired;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved2;
	U16 Reserved3;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
	U16 Event;
	U16 Reserved4;
	U32___2 EventContext;
	U32___2 EventData[0];
};

typedef struct _MPI2_EVENT_NOTIFICATION_REPLY Mpi2EventNotificationReply_t;

struct _MPI2_EVENT_NOTIFICATION_REQUEST {
	U16 Reserved1;
	U8 ChainOffset;
	U8 Function;
	U16 Reserved2;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
	U32___2 Reserved5;
	U32___2 Reserved6;
	U32___2 EventMasks[4];
	U16 SASBroadcastPrimitiveMasks;
	U16 SASNotifyPrimitiveMasks;
	U32___2 Reserved8;
};

typedef struct _MPI2_EVENT_NOTIFICATION_REQUEST Mpi2EventNotificationRequest_t;

struct _MPI2_FW_IMAGE_HEADER {
	U32___2 Signature;
	U32___2 Signature0;
	U32___2 Signature1;
	U32___2 Signature2;
	MPI2_VERSION_UNION MPIVersion;
	MPI2_VERSION_UNION FWVersion;
	MPI2_VERSION_UNION NVDATAVersion;
	MPI2_VERSION_UNION PackageVersion;
	U16 VendorID;
	U16 ProductID;
	U16 ProtocolFlags;
	U16 Reserved26;
	U32___2 IOCCapabilities;
	U32___2 ImageSize;
	U32___2 NextImageHeaderOffset;
	U32___2 Checksum;
	U32___2 Reserved38;
	U32___2 Reserved3C;
	U32___2 Reserved40;
	U32___2 Reserved44;
	U32___2 Reserved48;
	U32___2 Reserved4C;
	U32___2 Reserved50;
	U32___2 Reserved54;
	U32___2 Reserved58;
	U32___2 Reserved5C;
	U32___2 BootFlags;
	U32___2 FirmwareVersionNameWhat;
	U8 FirmwareVersionName[32];
	U32___2 VendorNameWhat;
	U8 VendorName[32];
	U32___2 PackageNameWhat;
	U8 PackageName[32];
	U32___2 ReservedD0;
	U32___2 ReservedD4;
	U32___2 ReservedD8;
	U32___2 ReservedDC;
	U32___2 ReservedE0;
	U32___2 ReservedE4;
	U32___2 ReservedE8;
	U32___2 ReservedEC;
	U32___2 ReservedF0;
	U32___2 ReservedF4;
	U32___2 ReservedF8;
	U32___2 ReservedFC;
};

typedef struct _MPI2_FW_IMAGE_HEADER Mpi2FWImageHeader_t;

struct _MPI2_FW_UPLOAD_REPLY {
	U8 ImageType;
	U8 Reserved1;
	U8 MsgLength;
	U8 Function;
	U16 Reserved2;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
	U16 Reserved5;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
	U32___2 ActualImageSize;
};

typedef struct _MPI2_FW_UPLOAD_REPLY Mpi2FWUploadReply_t;

struct _MPI2_HIGH_PRIORITY_REQUEST_DESCRIPTOR {
	U8 RequestFlags;
	U8 MSIxIndex;
	U16 SMID;
	U16 LMID;
	U16 Reserved1;
};

typedef struct _MPI2_HIGH_PRIORITY_REQUEST_DESCRIPTOR MPI2_HIGH_PRIORITY_REQUEST_DESCRIPTOR;

struct _MPI2_IOC_FACTS_REPLY {
	U16 MsgVersion;
	U8 MsgLength;
	U8 Function;
	U16 HeaderVersion;
	U8 IOCNumber;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved1;
	U16 IOCExceptions;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
	U8 MaxChainDepth;
	U8 WhoInit;
	U8 NumberOfPorts;
	U8 MaxMSIxVectors;
	U16 RequestCredit;
	U16 ProductID;
	U32___2 IOCCapabilities;
	MPI2_VERSION_UNION FWVersion;
	U16 IOCRequestFrameSize;
	U16 IOCMaxChainSegmentSize;
	U16 MaxInitiators;
	U16 MaxTargets;
	U16 MaxSasExpanders;
	U16 MaxEnclosures;
	U16 ProtocolFlags;
	U16 HighPriorityCredit;
	U16 MaxReplyDescriptorPostQueueDepth;
	U8 ReplyFrameSize;
	U8 MaxVolumes;
	U16 MaxDevHandle;
	U16 MaxPersistentEntries;
	U16 MinDevHandle;
	U8 CurrentHostPageSize;
	U8 Reserved4;
	U8 SGEModifierMask;
	U8 SGEModifierValue;
	U8 SGEModifierShift;
	U8 Reserved5;
};

typedef struct _MPI2_IOC_FACTS_REPLY Mpi2IOCFactsReply_t;

struct _MPI2_IOC_FACTS_REQUEST {
	U16 Reserved1;
	U8 ChainOffset;
	U8 Function;
	U16 Reserved2;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
};

typedef struct _MPI2_IOC_FACTS_REQUEST Mpi2IOCFactsRequest_t;

struct _MPI2_IOC_INIT_RDPQ_ARRAY_ENTRY {
	U64 RDPQBaseAddress;
	U32___2 Reserved1;
	U32___2 Reserved2;
};

struct _MPI2_IOC_INIT_REPLY {
	U8 WhoInit;
	U8 Reserved1;
	U8 MsgLength;
	U8 Function;
	U16 Reserved2;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
	U16 Reserved5;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
};

typedef struct _MPI2_IOC_INIT_REPLY Mpi2IOCInitReply_t;

struct _MPI2_IOC_INIT_REQUEST {
	U8 WhoInit;
	U8 Reserved1;
	U8 ChainOffset;
	U8 Function;
	U16 Reserved2;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
	U16 MsgVersion;
	U16 HeaderVersion;
	U32___2 Reserved5;
	U16 ConfigurationFlags;
	U8 HostPageSize;
	U8 HostMSIxVectors;
	U16 Reserved8;
	U16 SystemRequestFrameSize;
	U16 ReplyDescriptorPostQueueDepth;
	U16 ReplyFreeQueueDepth;
	U32___2 SenseBufferAddressHigh;
	U32___2 SystemReplyAddressHigh;
	U64 SystemRequestFrameBaseAddress;
	U64 ReplyDescriptorPostQueueAddress;
	U64 ReplyFreeQueueAddress;
	U64 TimeStamp;
};

typedef struct _MPI2_IOC_INIT_REQUEST Mpi2IOCInitRequest_t;

typedef union _MPI2_MPI2_BIOSPAGE2_BOOT_DEVICE Mpi2BiosPage2BootDevice_t;

struct _MPI2_PORT_ENABLE_REPLY {
	U16 Reserved1;
	U8 MsgLength;
	U8 Function;
	U8 Reserved2;
	U8 PortFlags;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
	U16 Reserved5;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
};

typedef struct _MPI2_PORT_ENABLE_REPLY Mpi2PortEnableReply_t;

struct _MPI2_PORT_ENABLE_REQUEST {
	U16 Reserved1;
	U8 ChainOffset;
	U8 Function;
	U8 Reserved2;
	U8 PortFlags;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
};

typedef struct _MPI2_PORT_ENABLE_REQUEST Mpi2PortEnableRequest_t;

struct _MPI2_PORT_FACTS_REPLY {
	U16 Reserved1;
	U8 MsgLength;
	U8 Function;
	U16 Reserved2;
	U8 PortNumber;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved3;
	U16 Reserved4;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
	U8 Reserved5;
	U8 PortType;
	U16 Reserved6;
	U16 MaxPostedCmdBuffers;
	U16 Reserved7;
};

typedef struct _MPI2_PORT_FACTS_REPLY Mpi2PortFactsReply_t;

struct _MPI2_PORT_FACTS_REQUEST {
	U16 Reserved1;
	U8 ChainOffset;
	U8 Function;
	U16 Reserved2;
	U8 PortNumber;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved3;
};

typedef struct _MPI2_PORT_FACTS_REQUEST Mpi2PortFactsRequest_t;

struct _MPI2_RAID_ACCELERATOR_SUCCESS_REPLY_DESCRIPTOR {
	U8 ReplyFlags;
	U8 MSIxIndex;
	U16 SMID;
	U32___2 Reserved;
};

typedef struct _MPI2_RAID_ACCELERATOR_SUCCESS_REPLY_DESCRIPTOR MPI2_RAID_ACCELERATOR_SUCCESS_REPLY_DESCRIPTOR;

typedef MPI2_RAID_ACCELERATOR_SUCCESS_REPLY_DESCRIPTOR MPI26_PCIE_ENCAPSULATED_SUCCESS_REPLY_DESCRIPTOR;

struct _MPI2_RAID_ACCEL_REQUEST_DESCRIPTOR {
	U8 RequestFlags;
	U8 MSIxIndex;
	U16 SMID;
	U16 LMID;
	U16 Reserved;
};

typedef struct _MPI2_RAID_ACCEL_REQUEST_DESCRIPTOR MPI2_RAID_ACCEL_REQUEST_DESCRIPTOR;

struct _MPI2_RAID_ACTION_RATE_DATA {
	U8 RateToChange;
	U8 RateOrMode;
	U16 DataScrubDuration;
};

typedef struct _MPI2_RAID_ACTION_RATE_DATA MPI2_RAID_ACTION_RATE_DATA;

struct _MPI2_RAID_ACTION_START_RAID_FUNCTION {
	U8 RAIDFunction;
	U8 Flags;
	U16 Reserved1;
};

typedef struct _MPI2_RAID_ACTION_START_RAID_FUNCTION MPI2_RAID_ACTION_START_RAID_FUNCTION;

struct _MPI2_RAID_ACTION_STOP_RAID_FUNCTION {
	U8 RAIDFunction;
	U8 Flags;
	U16 Reserved1;
};

typedef struct _MPI2_RAID_ACTION_STOP_RAID_FUNCTION MPI2_RAID_ACTION_STOP_RAID_FUNCTION;

struct _MPI2_RAID_ACTION_HOT_SPARE {
	U8 HotSparePool;
	U8 Reserved1;
	U16 DevHandle;
};

typedef struct _MPI2_RAID_ACTION_HOT_SPARE MPI2_RAID_ACTION_HOT_SPARE;

struct _MPI2_RAID_ACTION_FW_UPDATE_MODE {
	U8 Flags;
	U8 DeviceFirmwareUpdateModeTimeout;
	U16 Reserved1;
};

typedef struct _MPI2_RAID_ACTION_FW_UPDATE_MODE MPI2_RAID_ACTION_FW_UPDATE_MODE;

union _MPI2_RAID_ACTION_DATA {
	U32___2 Word;
	MPI2_RAID_ACTION_RATE_DATA Rates;
	MPI2_RAID_ACTION_START_RAID_FUNCTION StartRaidFunction;
	MPI2_RAID_ACTION_STOP_RAID_FUNCTION StopRaidFunction;
	MPI2_RAID_ACTION_HOT_SPARE HotSpare;
	MPI2_RAID_ACTION_FW_UPDATE_MODE FwUpdateMode;
};

typedef union _MPI2_RAID_ACTION_DATA MPI2_RAID_ACTION_DATA;

struct _MPI2_RAID_VOL_INDICATOR {
	U64 TotalBlocks;
	U64 BlocksRemaining;
	U32___2 Flags;
	U32___2 ElapsedSeconds;
};

typedef struct _MPI2_RAID_VOL_INDICATOR MPI2_RAID_VOL_INDICATOR;

struct _MPI2_RAID_COMPATIBILITY_RESULT_STRUCT {
	U8 State;
	U8 Reserved1;
	U16 Reserved2;
	U32___2 GenericAttributes;
	U32___2 OEMSpecificAttributes;
	U32___2 Reserved3;
	U32___2 Reserved4;
};

typedef struct _MPI2_RAID_COMPATIBILITY_RESULT_STRUCT MPI2_RAID_COMPATIBILITY_RESULT_STRUCT;

union _MPI2_RAID_ACTION_REPLY_DATA {
	U32___2 Word[6];
	MPI2_RAID_VOL_INDICATOR RaidVolumeIndicator;
	U16 VolDevHandle;
	U8 VolumeState;
	U8 PhysDiskNum;
	MPI2_RAID_COMPATIBILITY_RESULT_STRUCT RaidCompatibilityResult;
};

typedef union _MPI2_RAID_ACTION_REPLY_DATA MPI2_RAID_ACTION_REPLY_DATA;

struct _MPI2_RAID_ACTION_REPLY {
	U8 Action;
	U8 Reserved1;
	U8 MsgLength;
	U8 Function;
	U16 VolDevHandle;
	U8 PhysDiskNum;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved2;
	U16 Reserved3;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
	MPI2_RAID_ACTION_REPLY_DATA ActionData;
} __attribute__((packed));

typedef struct _MPI2_RAID_ACTION_REPLY Mpi2RaidActionReply_t;

struct _MPI2_RAID_ACTION_REQUEST {
	U8 Action;
	U8 Reserved1;
	U8 ChainOffset;
	U8 Function;
	U16 VolDevHandle;
	U8 PhysDiskNum;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved2;
	U32___2 Reserved3;
	MPI2_RAID_ACTION_DATA ActionDataWord;
	MPI2_SGE_SIMPLE_UNION ActionDataSGE;
};

typedef struct _MPI2_RAID_ACTION_REQUEST Mpi2RaidActionRequest_t;

struct _MPI2_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR {
	U8 ReplyFlags;
	U8 MSIxIndex;
	U16 SMID;
	U16 TaskTag;
	U16 Reserved1;
};

typedef struct _MPI2_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR MPI2_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR;

struct _MPI2_TARGETASSIST_SUCCESS_REPLY_DESCRIPTOR {
	U8 ReplyFlags;
	U8 MSIxIndex;
	U16 SMID;
	U8 SequenceNumber;
	U8 Reserved1;
	U16 IoIndex;
};

typedef struct _MPI2_TARGETASSIST_SUCCESS_REPLY_DESCRIPTOR MPI2_TARGETASSIST_SUCCESS_REPLY_DESCRIPTOR;

struct _MPI2_TARGET_COMMAND_BUFFER_REPLY_DESCRIPTOR {
	U8 ReplyFlags;
	U8 MSIxIndex;
	U8 VP_ID;
	U8 Flags;
	U16 InitiatorDevHandle;
	U16 IoIndex;
};

typedef struct _MPI2_TARGET_COMMAND_BUFFER_REPLY_DESCRIPTOR MPI2_TARGET_COMMAND_BUFFER_REPLY_DESCRIPTOR;

typedef MPI2_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR MPI25_FP_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR;

union _MPI2_REPLY_DESCRIPTORS_UNION {
	MPI2_DEFAULT_REPLY_DESCRIPTOR Default;
	MPI2_ADDRESS_REPLY_DESCRIPTOR AddressReply;
	MPI2_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR SCSIIOSuccess;
	MPI2_TARGETASSIST_SUCCESS_REPLY_DESCRIPTOR TargetAssistSuccess;
	MPI2_TARGET_COMMAND_BUFFER_REPLY_DESCRIPTOR TargetCommandBuffer;
	MPI2_RAID_ACCELERATOR_SUCCESS_REPLY_DESCRIPTOR RAIDAcceleratorSuccess;
	MPI25_FP_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR FastPathSCSIIOSuccess;
	MPI26_PCIE_ENCAPSULATED_SUCCESS_REPLY_DESCRIPTOR PCIeEncapsulatedSuccess;
	U64 Words;
};

typedef union _MPI2_REPLY_DESCRIPTORS_UNION Mpi2ReplyDescriptorsUnion_t;

struct _MPI2_SCSI_IO_REQUEST_DESCRIPTOR {
	U8 RequestFlags;
	U8 MSIxIndex;
	U16 SMID;
	U16 LMID;
	U16 DevHandle;
};

typedef struct _MPI2_SCSI_IO_REQUEST_DESCRIPTOR MPI2_SCSI_IO_REQUEST_DESCRIPTOR;

struct _MPI2_SCSI_TARGET_REQUEST_DESCRIPTOR {
	U8 RequestFlags;
	U8 MSIxIndex;
	U16 SMID;
	U16 LMID;
	U16 IoIndex;
};

typedef struct _MPI2_SCSI_TARGET_REQUEST_DESCRIPTOR MPI2_SCSI_TARGET_REQUEST_DESCRIPTOR;

typedef MPI2_SCSI_IO_REQUEST_DESCRIPTOR MPI25_FP_SCSI_IO_REQUEST_DESCRIPTOR;

typedef MPI2_SCSI_IO_REQUEST_DESCRIPTOR MPI26_PCIE_ENCAPSULATED_REQUEST_DESCRIPTOR;

union _MPI2_REQUEST_DESCRIPTOR_UNION {
	MPI2_DEFAULT_REQUEST_DESCRIPTOR Default;
	MPI2_HIGH_PRIORITY_REQUEST_DESCRIPTOR HighPriority;
	MPI2_SCSI_IO_REQUEST_DESCRIPTOR SCSIIO;
	MPI2_SCSI_TARGET_REQUEST_DESCRIPTOR SCSITarget;
	MPI2_RAID_ACCEL_REQUEST_DESCRIPTOR RAIDAccelerator;
	MPI25_FP_SCSI_IO_REQUEST_DESCRIPTOR FastPathSCSIIO;
	MPI26_PCIE_ENCAPSULATED_REQUEST_DESCRIPTOR PCIeEncapsulated;
	U64 Words;
};

typedef union _MPI2_REQUEST_DESCRIPTOR_UNION Mpi2RequestDescriptorUnion_t;

struct _MPI2_REQUEST_HEADER {
	U16 FunctionDependent1;
	U8 ChainOffset;
	U8 Function;
	U16 FunctionDependent2;
	U8 FunctionDependent3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved1;
};

typedef struct _MPI2_REQUEST_HEADER MPI2RequestHeader_t;

struct _MPI2_SAS_IOUNIT_CONTROL_REPLY {
	U8 Operation;
	U8 Reserved1;
	U8 MsgLength;
	U8 Function;
	U16 DevHandle;
	U8 IOCParameter;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved3;
	U16 Reserved4;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
};

typedef struct _MPI2_SAS_IOUNIT_CONTROL_REPLY Mpi2SasIoUnitControlReply_t;

struct _MPI2_SAS_IOUNIT_CONTROL_REQUEST {
	U8 Operation;
	U8 Reserved1;
	U8 ChainOffset;
	U8 Function;
	U16 DevHandle;
	U8 IOCParameter;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved3;
	U16 Reserved4;
	U8 PhyNum;
	U8 PrimFlags;
	U32___2 Primitive;
	U8 LookupMethod;
	U8 Reserved5;
	U16 SlotNumber;
	U64 LookupAddress;
	U32___2 IOCParameterValue;
	U32___2 Reserved7;
	U32___2 Reserved8;
} __attribute__((packed));

typedef struct _MPI2_SAS_IOUNIT_CONTROL_REQUEST Mpi2SasIoUnitControlRequest_t;

union _MPI2_SCSI_IO_CDB_UNION {
	U8 CDB32[32];
	MPI2_SCSI_IO_CDB_EEDP32 EEDP32;
	MPI2_SGE_SIMPLE_UNION SGE;
};

typedef union _MPI2_SCSI_IO_CDB_UNION MPI2_SCSI_IO_CDB_UNION;

struct _MPI2_SCSI_IO_REPLY {
	U16 DevHandle;
	U8 MsgLength;
	U8 Function;
	U16 Reserved1;
	U8 Reserved2;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved3;
	U8 SCSIStatus;
	U8 SCSIState;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
	U32___2 TransferCount;
	U32___2 SenseCount;
	U32___2 ResponseInfo;
	U16 TaskTag;
	U16 SCSIStatusQualifier;
	U32___2 BidirectionalTransferCount;
	U32___2 EEDPErrorOffset;
	U16 EEDPObservedAppTag;
	U16 EEDPObservedGuard;
	U32___2 EEDPObservedRefTag;
};

typedef struct _MPI2_SCSI_IO_REPLY Mpi2SCSIIOReply_t;

struct _MPI2_SCSI_IO_REQUEST {
	U16 DevHandle;
	U8 ChainOffset;
	U8 Function;
	U16 Reserved1;
	U8 Reserved2;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved3;
	U32___2 SenseBufferLowAddress;
	U16 SGLFlags;
	U8 SenseBufferLength;
	U8 Reserved4;
	U8 SGLOffset0;
	U8 SGLOffset1;
	U8 SGLOffset2;
	U8 SGLOffset3;
	U32___2 SkipCount;
	U32___2 DataLength;
	U32___2 BidirectionalDataLength;
	U16 IoFlags;
	U16 EEDPFlags;
	U32___2 EEDPBlockSize;
	U32___2 SecondaryReferenceTag;
	U16 SecondaryApplicationTag;
	U16 ApplicationTagTranslationMask;
	U8 LUN[8];
	U32___2 Control;
	MPI2_SCSI_IO_CDB_UNION CDB;
	MPI2_SGE_IO_UNION SGL;
};

typedef struct _MPI2_SCSI_IO_REQUEST Mpi2SCSIIORequest_t;

struct _MPI2_SCSI_TASK_MANAGE_REPLY {
	U16 DevHandle;
	U8 MsgLength;
	U8 Function;
	U8 ResponseCode;
	U8 TaskType;
	U8 Reserved1;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved2;
	U16 Reserved3;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
	U32___2 TerminationCount;
	U32___2 ResponseInfo;
};

typedef struct _MPI2_SCSI_TASK_MANAGE_REPLY Mpi2SCSITaskManagementReply_t;

struct _MPI2_SCSI_TASK_MANAGE_REQUEST {
	U16 DevHandle;
	U8 ChainOffset;
	U8 Function;
	U8 Reserved1;
	U8 TaskType;
	U8 Reserved2;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved3;
	U8 LUN[8];
	U32___2 Reserved4[7];
	U16 TaskMID;
	U16 Reserved5;
};

typedef struct _MPI2_SCSI_TASK_MANAGE_REQUEST Mpi2SCSITaskManagementRequest_t;

struct _MPI2_SEP_REPLY {
	U16 DevHandle;
	U8 MsgLength;
	U8 Function;
	U8 Action;
	U8 Flags;
	U8 Reserved1;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved2;
	U16 Reserved3;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
	U32___2 SlotStatus;
	U32___2 Reserved4;
	U16 Slot;
	U16 EnclosureHandle;
};

typedef struct _MPI2_SEP_REPLY Mpi2SepReply_t;

struct _MPI2_SEP_REQUEST {
	U16 DevHandle;
	U8 ChainOffset;
	U8 Function;
	U8 Action;
	U8 Flags;
	U8 Reserved1;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved2;
	U32___2 SlotStatus;
	U32___2 Reserved3;
	U32___2 Reserved4;
	U32___2 Reserved5;
	U16 Slot;
	U16 EnclosureHandle;
};

typedef struct _MPI2_SEP_REQUEST Mpi2SepRequest_t;

struct _MPI2_SGE_SIMPLE32 {
	U32___2 FlagsLength;
	U32___2 Address;
};

typedef struct _MPI2_SGE_SIMPLE32 Mpi2SGESimple32_t;

struct _MPI2_SGE_SIMPLE64 {
	U32___2 FlagsLength;
	U64 Address;
} __attribute__((packed));

typedef struct _MPI2_SGE_SIMPLE64 Mpi2SGESimple64_t;

union _MPI2_SIMPLE_SGE_UNION {
	MPI2_SGE_SIMPLE_UNION MpiSimple;
	MPI2_IEEE_SGE_SIMPLE_UNION IeeeSimple;
};

typedef union _MPI2_SIMPLE_SGE_UNION MPI2_SIMPLE_SGE_UNION;

struct _MPI2_SMP_PASSTHROUGH_REPLY {
	U8 PassthroughFlags;
	U8 PhysicalPort;
	U8 MsgLength;
	U8 Function;
	U16 ResponseDataLength;
	U8 SGLFlags;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved1;
	U8 Reserved2;
	U8 SASStatus;
	U16 IOCStatus;
	U32___2 IOCLogInfo;
	U32___2 Reserved3;
	U8 ResponseData[4];
};

typedef struct _MPI2_SMP_PASSTHROUGH_REPLY Mpi2SmpPassthroughReply_t;

struct _MPI2_SMP_PASSTHROUGH_REQUEST {
	U8 PassthroughFlags;
	U8 PhysicalPort;
	U8 ChainOffset;
	U8 Function;
	U16 RequestDataLength;
	U8 SGLFlags;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved1;
	U32___2 Reserved2;
	U64 SASAddress;
	U32___2 Reserved3;
	U32___2 Reserved4;
	MPI2_SIMPLE_SGE_UNION SGL;
};

typedef struct _MPI2_SMP_PASSTHROUGH_REQUEST Mpi2SmpPassthroughRequest_t;

struct _MPI2_SYSTEM_INTERFACE_REGS {
	U32___2 Doorbell;
	U32___2 WriteSequence;
	U32___2 HostDiagnostic;
	U32___2 Reserved1;
	U32___2 DiagRWData;
	U32___2 DiagRWAddressLow;
	U32___2 DiagRWAddressHigh;
	U32___2 Reserved2[5];
	U32___2 HostInterruptStatus;
	U32___2 HostInterruptMask;
	U32___2 DCRData;
	U32___2 DCRAddress;
	U32___2 Reserved3[2];
	U32___2 ReplyFreeHostIndex;
	U32___2 Reserved4[8];
	U32___2 ReplyPostHostIndex;
	U32___2 Reserved5;
	U32___2 HCBSize;
	U32___2 HCBAddressLow;
	U32___2 HCBAddressHigh;
	U32___2 Reserved6[12];
	U32___2 Scratchpad[4];
	U32___2 RequestDescriptorPostLow;
	U32___2 RequestDescriptorPostHigh;
	U32___2 AtomicRequestDescriptorPost;
	U32___2 Reserved7[13];
};

struct _MPI2_TOOLBOX_CLEAN_REQUEST {
	U8 Tool;
	U8 Reserved1;
	U8 ChainOffset;
	U8 Function;
	U16 Reserved2;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
	U32___2 Flags;
};

typedef struct _MPI2_TOOLBOX_CLEAN_REQUEST Mpi2ToolboxCleanRequest_t;

struct _MPI2_TOOLBOX_MEM_MOVE_REQUEST {
	U8 Tool;
	U8 Reserved1;
	U8 ChainOffset;
	U8 Function;
	U16 Reserved2;
	U8 Reserved3;
	U8 MsgFlags;
	U8 VP_ID;
	U8 VF_ID;
	U16 Reserved4;
	MPI2_SGE_SIMPLE_UNION SGL;
};

typedef struct _MPI2_TOOLBOX_MEM_MOVE_REQUEST Mpi2ToolboxMemMoveRequest_t;

struct __aio_sigset {
	const sigset_t *sigmask;
	size_t sigsetsize;
};

struct llist_node {
	struct llist_node *next;
};

struct __call_single_node {
	struct llist_node llist;
	union {
		unsigned int u_flags;
		atomic_t a_flags;
	};
	u16 src;
	u16 dst;
};

typedef void (*smp_call_func_t)(void *);

struct __call_single_data {
	struct __call_single_node node;
	smp_call_func_t func;
	void *info;
};

typedef struct __call_single_data call_single_data_t;

struct cpumask;

struct __cmp_key {
	const struct cpumask *cpus;
	struct cpumask ***masks;
	int node;
	int cpu;
	int w;
};

struct drm_connector;

struct drm_connector_state;

struct __drm_connnectors_state {
	struct drm_connector *ptr;
	struct drm_connector_state *state;
	struct drm_connector_state *old_state;
	struct drm_connector_state *new_state;
	s32 *out_fence_ptr;
};

struct drm_crtc;

struct drm_crtc_state;

struct drm_crtc_commit;

struct __drm_crtcs_state {
	struct drm_crtc *ptr;
	struct drm_crtc_state *state;
	struct drm_crtc_state *old_state;
	struct drm_crtc_state *new_state;
	struct drm_crtc_commit *commit;
	s32 *out_fence_ptr;
	u64 last_vblank_count;
};

struct drm_plane;

struct drm_plane_state;

struct __drm_planes_state {
	struct drm_plane *ptr;
	struct drm_plane_state *state;
	struct drm_plane_state *old_state;
	struct drm_plane_state *new_state;
};

struct drm_private_obj;

struct drm_private_state;

struct __drm_private_objs_state {
	struct drm_private_obj *ptr;
	struct drm_private_state *state;
	struct drm_private_state *old_state;
	struct drm_private_state *new_state;
};

struct __fb_timings {
	u32 dclk;
	u32 hfreq;
	u32 vfreq;
	u32 hactive;
	u32 vactive;
	u32 hblank;
	u32 vblank;
	u32 htotal;
	u32 vtotal;
};

struct genradix_root;

struct __genradix {
	struct genradix_root *root;
};

struct pmu;

struct cgroup;

struct __group_key {
	int cpu;
	struct pmu *pmu;
	struct cgroup *cgroup;
};

struct __ip6_tnl_parm {
	char name[16];
	int link;
	__u8 proto;
	__u8 encap_limit;
	__u8 hop_limit;
	bool collect_md;
	__be32 flowinfo;
	__u32 flags;
	struct in6_addr laddr;
	struct in6_addr raddr;
	long unsigned int i_flags[1];
	long unsigned int o_flags[1];
	__be32 i_key;
	__be32 o_key;
	__u32 fwmark;
	__u32 index;
	__u8 erspan_ver;
	__u8 dir;
	__u16 hwid;
};

struct __kernel_timespec {
	__kernel_time64_t tv_sec;
	long long int tv_nsec;
};

struct __kernel_itimerspec {
	struct __kernel_timespec it_interval;
	struct __kernel_timespec it_value;
};

struct __kernel_old_timeval {
	__kernel_long_t tv_sec;
	__kernel_long_t tv_usec;
};

struct __kernel_old_itimerval {
	struct __kernel_old_timeval it_interval;
	struct __kernel_old_timeval it_value;
};

struct __kernel_old_timespec {
	__kernel_old_time_t tv_sec;
	long int tv_nsec;
};

struct __kernel_sock_timeval {
	__s64 tv_sec;
	__s64 tv_usec;
};

struct __kernel_sockaddr_storage {
	union {
		struct {
			__kernel_sa_family_t ss_family;
			char __data[126];
		};
		void *__align;
	};
};

struct __kernel_timex_timeval {
	__kernel_time64_t tv_sec;
	long long int tv_usec;
};

struct __kernel_timex {
	unsigned int modes;
	long long int offset;
	long long int freq;
	long long int maxerror;
	long long int esterror;
	int status;
	long long int constant;
	long long int precision;
	long long int tolerance;
	struct __kernel_timex_timeval time;
	long long int tick;
	long long int ppsfreq;
	long long int jitter;
	int shift;
	long long int stabil;
	long long int jitcnt;
	long long int calcnt;
	long long int errcnt;
	long long int stbcnt;
	int tai;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct __kfifo {
	unsigned int in;
	unsigned int out;
	unsigned int mask;
	unsigned int esize;
	void *data;
};

struct __large_struct {
	long unsigned int buf[100];
};

struct net_device;

struct __rt6_probe_work {
	struct work_struct work;
	struct in6_addr target;
	struct net_device *dev;
	netdevice_tracker dev_tracker;
};

union sigval {
	int sival_int;
	void *sival_ptr;
};

typedef union sigval sigval_t;

union __sifields {
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
	} _kill;
	struct {
		__kernel_timer_t _tid;
		int _overrun;
		sigval_t _sigval;
		int _sys_private;
	} _timer;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		sigval_t _sigval;
	} _rt;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		int _status;
		__kernel_clock_t _utime;
		__kernel_clock_t _stime;
	} _sigchld;
	struct {
		void *_addr;
		union {
			int _trapno;
			short int _addr_lsb;
			struct {
				char _dummy_bnd[8];
				void *_lower;
				void *_upper;
			} _addr_bnd;
			struct {
				char _dummy_pkey[8];
				__u32 _pkey;
			} _addr_pkey;
			struct {
				long unsigned int _data;
				__u32 _type;
				__u32 _flags;
			} _perf;
		};
	} _sigfault;
	struct {
		long int _band;
		int _fd;
	} _sigpoll;
	struct {
		void *_call_addr;
		int _syscall;
		unsigned int _arch;
	} _sigsys;
};

struct bpf_flow_keys;

struct bpf_sock;

struct __sk_buff {
	__u32 len;
	__u32 pkt_type;
	__u32 mark;
	__u32 queue_mapping;
	__u32 protocol;
	__u32 vlan_present;
	__u32 vlan_tci;
	__u32 vlan_proto;
	__u32 priority;
	__u32 ingress_ifindex;
	__u32 ifindex;
	__u32 tc_index;
	__u32 cb[5];
	__u32 hash;
	__u32 tc_classid;
	__u32 data;
	__u32 data_end;
	__u32 napi_id;
	__u32 family;
	__u32 remote_ip4;
	__u32 local_ip4;
	__u32 remote_ip6[4];
	__u32 local_ip6[4];
	__u32 remote_port;
	__u32 local_port;
	__u32 data_meta;
	union {
		struct bpf_flow_keys *flow_keys;
	};
	__u64 tstamp;
	__u32 wire_len;
	__u32 gso_segs;
	union {
		struct bpf_sock *sk;
	};
	__u32 gso_size;
	__u8 tstamp_type;
	__u64 hwtstamp;
};

struct __track_dentry_update_args {
	struct dentry *dentry;
	int op;
};

struct __track_range_args {
	ext4_lblk_t start;
	ext4_lblk_t end;
};

struct __una_u32 {
	u32 x;
};

struct inode;

struct __uprobe_key {
	struct inode *inode;
	loff_t offset;
};

struct __user_cap_data_struct {
	__u32 effective;
	__u32 permitted;
	__u32 inheritable;
};

typedef struct __user_cap_data_struct *cap_user_data_t;

struct __user_cap_header_struct {
	__u32 version;
	int pid;
};

typedef struct __user_cap_header_struct *cap_user_header_t;

struct __xfsstats {
	uint32_t xs_allocx;
	uint32_t xs_allocb;
	uint32_t xs_freex;
	uint32_t xs_freeb;
	uint32_t xs_abt_lookup;
	uint32_t xs_abt_compare;
	uint32_t xs_abt_insrec;
	uint32_t xs_abt_delrec;
	uint32_t xs_blk_mapr;
	uint32_t xs_blk_mapw;
	uint32_t xs_blk_unmap;
	uint32_t xs_add_exlist;
	uint32_t xs_del_exlist;
	uint32_t xs_look_exlist;
	uint32_t xs_cmp_exlist;
	uint32_t xs_bmbt_lookup;
	uint32_t xs_bmbt_compare;
	uint32_t xs_bmbt_insrec;
	uint32_t xs_bmbt_delrec;
	uint32_t xs_dir_lookup;
	uint32_t xs_dir_create;
	uint32_t xs_dir_remove;
	uint32_t xs_dir_getdents;
	uint32_t xs_trans_sync;
	uint32_t xs_trans_async;
	uint32_t xs_trans_empty;
	uint32_t xs_ig_attempts;
	uint32_t xs_ig_found;
	uint32_t xs_ig_frecycle;
	uint32_t xs_ig_missed;
	uint32_t xs_ig_dup;
	uint32_t xs_ig_reclaims;
	uint32_t xs_ig_attrchg;
	uint32_t xs_log_writes;
	uint32_t xs_log_blocks;
	uint32_t xs_log_noiclogs;
	uint32_t xs_log_force;
	uint32_t xs_log_force_sleep;
	uint32_t xs_try_logspace;
	uint32_t xs_sleep_logspace;
	uint32_t xs_push_ail;
	uint32_t xs_push_ail_success;
	uint32_t xs_push_ail_pushbuf;
	uint32_t xs_push_ail_pinned;
	uint32_t xs_push_ail_locked;
	uint32_t xs_push_ail_flushing;
	uint32_t xs_push_ail_restarts;
	uint32_t xs_push_ail_flush;
	uint32_t xs_xstrat_quick;
	uint32_t xs_xstrat_split;
	uint32_t xs_write_calls;
	uint32_t xs_read_calls;
	uint32_t xs_attr_get;
	uint32_t xs_attr_set;
	uint32_t xs_attr_remove;
	uint32_t xs_attr_list;
	uint32_t xs_iflush_count;
	uint32_t xs_icluster_flushcnt;
	uint32_t xs_icluster_flushinode;
	uint32_t vn_active;
	uint32_t vn_alloc;
	uint32_t vn_get;
	uint32_t vn_hold;
	uint32_t vn_rele;
	uint32_t vn_reclaim;
	uint32_t vn_remove;
	uint32_t vn_free;
	uint32_t xb_get;
	uint32_t xb_create;
	uint32_t xb_get_locked;
	uint32_t xb_get_locked_waited;
	uint32_t xb_busy_locked;
	uint32_t xb_miss_locked;
	uint32_t xb_page_retries;
	uint32_t xb_page_found;
	uint32_t xb_get_read;
	uint32_t xs_abtb_2[15];
	uint32_t xs_abtc_2[15];
	uint32_t xs_bmbt_2[15];
	uint32_t xs_ibt_2[15];
	uint32_t xs_fibt_2[15];
	uint32_t xs_rmap_2[15];
	uint32_t xs_refcbt_2[15];
	uint32_t xs_rmap_mem_2[15];
	uint32_t xs_rcbag_2[15];
	uint32_t xs_rtrmap_2[15];
	uint32_t xs_rtrmap_mem_2[15];
	uint32_t xs_rtrefcbt_2[15];
	uint32_t xs_qm_dqreclaims;
	uint32_t xs_qm_dqreclaim_misses;
	uint32_t xs_qm_dquot_dups;
	uint32_t xs_qm_dqcachemisses;
	uint32_t xs_qm_dqcachehits;
	uint32_t xs_qm_dqwants;
	uint32_t xs_qm_dquot;
	uint32_t xs_qm_dquot_unused;
	uint64_t xs_xstrat_bytes;
	uint64_t xs_write_bytes;
	uint64_t xs_read_bytes;
	uint64_t defer_relog;
};

struct _bpf_dtab_netdev {
	struct net_device *dev;
};

struct sctx_info;

struct _ctx_layout {
	struct sctx_info *addr;
	unsigned int size;
};

struct jump_entry;

struct static_key_mod;

struct static_key {
	atomic_t enabled;
	union {
		long unsigned int type;
		struct jump_entry *entries;
		struct static_key_mod *next;
	};
};

struct static_key_true {
	struct static_key key;
};

struct static_key_false {
	struct static_key key;
};

struct _ddebug {
	const char *modname;
	const char *function;
	const char *filename;
	const char *format;
	unsigned int lineno: 18;
	unsigned int class_id: 6;
	unsigned int flags: 8;
	union {
		struct static_key_true dd_key_true;
		struct static_key_false dd_key_false;
	} key;
};

struct _enclosure_node {
	struct list_head list;
	Mpi2SasEnclosurePage0_t pg0;
};

struct _event_ack_list {
	struct list_head list;
	U16 Event;
	U32___2 EventContext;
};

struct _flow_keys_digest_data {
	__be16 n_proto;
	u8 ip_proto;
	u8 padding;
	__be32 ports;
	__be32 src;
	__be32 dst;
};

struct _gpt_entry_attributes {
	u64 required_to_function: 1;
	u64 reserved: 47;
	u64 type_guid_specific: 16;
};

typedef struct _gpt_entry_attributes gpt_entry_attributes;

struct _gpt_entry {
	efi_guid_t partition_type_guid;
	efi_guid_t unique_partition_guid;
	__le64 starting_lba;
	__le64 ending_lba;
	gpt_entry_attributes attributes;
	__le16 partition_name[36];
};

typedef struct _gpt_entry gpt_entry;

struct _gpt_header {
	__le64 signature;
	__le32 revision;
	__le32 header_size;
	__le32 header_crc32;
	__le32 reserved1;
	__le64 my_lba;
	__le64 alternate_lba;
	__le64 first_usable_lba;
	__le64 last_usable_lba;
	efi_guid_t disk_guid;
	__le64 partition_entry_lba;
	__le32 num_partition_entries;
	__le32 sizeof_partition_entry;
	__le32 partition_entry_array_crc32;
} __attribute__((packed));

typedef struct _gpt_header gpt_header;

struct _gpt_mbr_record {
	u8 boot_indicator;
	u8 start_head;
	u8 start_sector;
	u8 start_track;
	u8 os_type;
	u8 end_head;
	u8 end_sector;
	u8 end_track;
	__le32 starting_lba;
	__le32 size_in_lba;
};

typedef struct _gpt_mbr_record gpt_mbr_record;

struct kvm_stats_desc {
	__u32 flags;
	__s16 exponent;
	__u16 size;
	__u32 offset;
	__u32 bucket_size;
	char name[0];
};

struct _kvm_stats_desc {
	struct kvm_stats_desc desc;
	char name[48];
};

struct _legacy_mbr {
	u8 boot_code[440];
	__le32 unique_mbr_signature;
	__le16 unknown;
	gpt_mbr_record partition_record[4];
	__le16 signature;
} __attribute__((packed));

typedef struct _legacy_mbr legacy_mbr;

struct _pcie_device {
	struct list_head list;
	struct scsi_target *starget;
	u64 wwid;
	u16 handle;
	u32 device_info;
	int id;
	int channel;
	u16 slot;
	u8 port_num;
	u8 responding;
	u8 fast_path;
	u32 nvme_mdts;
	u16 enclosure_handle;
	u64 enclosure_logical_id;
	u8 enclosure_level;
	u8 connector_name[4];
	u8 *serial_number;
	u8 reset_timeout;
	u8 access_status;
	u16 shutdown_latency;
	struct kref refcount;
};

struct scsi_device;

struct _raid_device {
	struct list_head list;
	struct scsi_target *starget;
	struct scsi_device *sdev;
	u64 wwid;
	u16 handle;
	u16 block_sz;
	int id;
	int channel;
	u8 volume_type;
	u8 num_pds;
	u8 responding;
	u8 percent_complete;
	u8 direct_io_enabled;
	u8 stripe_exponent;
	u8 block_exponent;
	u64 max_lba;
	u32 stripe_sz;
	u32 device_info;
	u16 pd_handle[8];
};

struct _sas_device {
	struct list_head list;
	struct scsi_target *starget;
	u64 sas_address;
	u64 device_name;
	u16 handle;
	u64 sas_address_parent;
	u16 enclosure_handle;
	u64 enclosure_logical_id;
	u16 volume_handle;
	u64 volume_wwid;
	u32 device_info;
	int id;
	int channel;
	u16 slot;
	u8 phy;
	u8 responding;
	u8 fast_path;
	u8 pfa_led_on;
	u8 pend_sas_rphy_add;
	u8 enclosure_level;
	u8 chassis_slot;
	u8 is_chassis_slot_valid;
	u8 connector_name[5];
	struct kref refcount;
	u8 port_type;
	struct hba_port *port;
	struct sas_rphy *rphy;
};

struct sas_identify {
	enum sas_device_type device_type;
	enum sas_protocol initiator_port_protocols;
	enum sas_protocol target_port_protocols;
	u64 sas_address;
	u8 phy_identifier;
};

struct sas_phy;

struct _sas_phy {
	struct list_head port_siblings;
	struct sas_identify identify;
	struct sas_identify remote_identify;
	struct sas_phy *phy;
	u8 phy_id;
	u16 handle;
	u16 attached_handle;
	u8 phy_belongs_to_port;
	u8 hba_vphy;
	struct hba_port *port;
};

struct sas_port;

struct _sas_port {
	struct list_head port_list;
	u8 num_phys;
	struct sas_identify remote_identify;
	struct sas_rphy *rphy;
	struct sas_port *port;
	struct hba_port *hba_port;
	struct list_head phy_list;
};

struct _sc_list {
	struct list_head list;
	u16 handle;
};

struct strp_msg {
	int full_len;
	int offset;
};

struct _strp_msg {
	struct strp_msg strp;
	int accum_len;
};

struct _tr_list {
	struct list_head list;
	u16 handle;
	u16 state;
};

struct aa_policydb;

struct aa_attachment {
	const char *xmatch_str;
	struct aa_policydb *xmatch;
	unsigned int xmatch_len;
	int xattr_count;
	char **xattrs;
};

struct aa_label;

struct aa_audit_rule {
	struct aa_label *label;
};

union aa_buffer {
	struct list_head list;
	struct {
		struct {} __empty_buffer;
		char buffer[0];
	};
};

struct aa_caps {
	kernel_cap_t allow;
	kernel_cap_t audit;
	kernel_cap_t denied;
	kernel_cap_t quiet;
	kernel_cap_t kill;
	kernel_cap_t extended;
};

struct rhash_head {
	struct rhash_head *next;
};

struct aa_data {
	char *key;
	u32 size;
	char *data;
	struct rhash_head head;
};

struct table_header;

struct aa_dfa {
	struct kref count;
	u16 flags;
	u32 max_oob;
	struct table_header *tables[8];
};

struct aa_ext {
	void *start;
	void *end;
	void *pos;
	u32 version;
};

struct aa_file_ctx {
	spinlock_t lock;
	struct aa_label *label;
	u32 allow;
};

struct aa_proxy;

struct aa_profile;

struct aa_label {
	struct kref count;
	struct rb_node node;
	struct callback_head rcu;
	struct aa_proxy *proxy;
	char *hname;
	long int flags;
	u32 secid;
	int size;
	struct aa_profile *vec[0];
};

struct rb_root {
	struct rb_node *rb_node;
};

struct aa_labelset {
	rwlock_t lock;
	struct rb_root root;
};

struct aa_load_ent {
	struct list_head list;
	struct aa_profile *new;
	struct aa_profile *old;
	struct aa_profile *rename;
	const char *ns_name;
};

struct aa_ns;

struct aa_loaddata {
	struct kref count;
	struct list_head list;
	struct work_struct work;
	struct dentry *dents[6];
	struct aa_ns *ns;
	char *name;
	size_t size;
	size_t compressed_size;
	long int revision;
	int abi;
	unsigned char *hash;
	char *data;
};

struct aa_local_cache {
	unsigned int hold;
	unsigned int count;
	struct list_head head;
};

struct aa_policy {
	const char *name;
	char *hname;
	struct list_head list;
	struct list_head profiles;
};

struct aa_ns_acct {
	int max_size;
	int max_count;
	int size;
	int count;
};

struct aa_ns {
	struct aa_policy base;
	struct aa_ns *parent;
	struct mutex lock;
	struct aa_ns_acct acct;
	struct aa_profile *unconfined;
	struct list_head sub_ns;
	atomic_t uniq_null;
	long int uniq_id;
	int level;
	long int revision;
	wait_queue_head_t wait;
	struct aa_labelset labels;
	struct list_head rawdata_list;
	struct dentry *dents[13];
};

struct aa_perms {
	u32 allow;
	u32 deny;
	u32 subtree;
	u32 cond;
	u32 kill;
	u32 complain;
	u32 prompt;
	u32 audit;
	u32 quiet;
	u32 hide;
	u32 xindex;
	u32 tag;
	u32 label;
};

struct aa_str_table {
	int size;
	char **table;
};

struct aa_policydb {
	struct kref count;
	struct aa_dfa *dfa;
	struct {
		struct aa_perms *perms;
		u32 size;
	};
	struct aa_str_table trans;
	unsigned int start[33];
};

struct rhashtable;

struct aa_profile {
	struct aa_policy base;
	struct aa_profile *parent;
	struct aa_ns *ns;
	const char *rename;
	enum audit_mode audit;
	long int mode;
	u32 path_flags;
	const char *disconnected;
	struct aa_attachment attach;
	struct list_head rules;
	struct aa_loaddata *rawdata;
	unsigned char *hash;
	char *dirname;
	struct dentry *dents[9];
	struct rhashtable *data;
	struct aa_label label;
};

struct aa_proxy {
	struct kref count;
	struct aa_label *label;
};

struct aa_revision {
	struct aa_ns *ns;
	long int last_read;
};

struct rlimit {
	__kernel_ulong_t rlim_cur;
	__kernel_ulong_t rlim_max;
};

struct aa_rlimit {
	unsigned int mask;
	struct rlimit limits[16];
};

struct aa_secmark;

struct aa_ruleset {
	struct list_head list;
	int size;
	struct aa_policydb *policy;
	struct aa_policydb *file;
	struct aa_caps caps;
	struct aa_rlimit rlimits;
	int secmark_count;
	struct aa_secmark *secmark;
};

struct aa_secmark {
	u8 audit;
	u8 deny;
	u32 secid;
	char *label;
};

struct file_operations;

struct aa_sfs_entry {
	const char *name;
	struct dentry *dentry;
	umode_t mode;
	enum aa_sfs_type v_type;
	union {
		bool boolean;
		char *string;
		long unsigned int u64;
		struct aa_sfs_entry *files;
	} v;
	const struct file_operations *file_ops;
};

struct aa_sk_ctx {
	struct aa_label *label;
	struct aa_label *peer;
};

struct aa_task_ctx {
	struct aa_label *nnp;
	struct aa_label *onexec;
	struct aa_label *previous;
	u64 token;
};

struct seq_net_private {
	struct net *net;
	netns_tracker ns_tracker;
};

struct ac6_iter_state {
	struct seq_net_private p;
	struct net_device *dev;
};

struct access_coordinate {
	unsigned int read_bandwidth;
	unsigned int write_bandwidth;
	unsigned int read_latency;
	unsigned int write_latency;
};

struct access_report_info {
	struct callback_head work;
	const char *access;
	struct task_struct *target;
	struct task_struct *agent;
};

struct accessmap {
	u32 access;
	int how;
};

struct acct_v3 {
	char ac_flag;
	char ac_version;
	__u16 ac_tty;
	__u32 ac_exitcode;
	__u32 ac_uid;
	__u32 ac_gid;
	__u32 ac_pid;
	__u32 ac_ppid;
	__u32 ac_btime;
	__u32 ac_etime;
	comp_t ac_utime;
	comp_t ac_stime;
	comp_t ac_mem;
	comp_t ac_io;
	comp_t ac_rw;
	comp_t ac_minflt;
	comp_t ac_majflt;
	comp_t ac_swaps;
	char ac_comm[16];
};

typedef struct acct_v3 acct_t;

struct ack_sample {
	u32 pkts_acked;
	s32 rtt_us;
	u32 in_flight;
};

struct crypto_tfm;

struct cipher_alg {
	unsigned int cia_min_keysize;
	unsigned int cia_max_keysize;
	int (*cia_setkey)(struct crypto_tfm *, const u8 *, unsigned int);
	void (*cia_encrypt)(struct crypto_tfm *, u8 *, const u8 *);
	void (*cia_decrypt)(struct crypto_tfm *, u8 *, const u8 *);
};

struct compress_alg {
	int (*coa_compress)(struct crypto_tfm *, const u8 *, unsigned int, u8 *, unsigned int *);
	int (*coa_decompress)(struct crypto_tfm *, const u8 *, unsigned int, u8 *, unsigned int *);
};

struct crypto_type;

struct crypto_alg {
	struct list_head cra_list;
	struct list_head cra_users;
	u32 cra_flags;
	unsigned int cra_blocksize;
	unsigned int cra_ctxsize;
	unsigned int cra_alignmask;
	int cra_priority;
	refcount_t cra_refcnt;
	char cra_name[128];
	char cra_driver_name[128];
	const struct crypto_type *cra_type;
	union {
		struct cipher_alg cipher;
		struct compress_alg compress;
	} cra_u;
	int (*cra_init)(struct crypto_tfm *);
	void (*cra_exit)(struct crypto_tfm *);
	void (*cra_destroy)(struct crypto_alg *);
	struct module *cra_module;
};

struct comp_alg_common {
	struct crypto_alg base;
};

struct acomp_req;

struct scatterlist;

struct crypto_acomp;

struct acomp_alg {
	int (*compress)(struct acomp_req *);
	int (*decompress)(struct acomp_req *);
	void (*dst_free)(struct scatterlist *);
	int (*init)(struct crypto_acomp *);
	void (*exit)(struct crypto_acomp *);
	unsigned int reqsize;
	union {
		struct {
			struct crypto_alg base;
		};
		struct comp_alg_common calg;
	};
};

typedef void (*crypto_completion_t)(void *, int);

struct crypto_async_request {
	struct list_head list;
	crypto_completion_t complete;
	void *data;
	struct crypto_tfm *tfm;
	u32 flags;
};

struct acomp_req {
	struct crypto_async_request base;
	struct scatterlist *src;
	struct scatterlist *dst;
	unsigned int slen;
	unsigned int dlen;
	u32 flags;
	void *__ctx[0];
};

struct power_supply;

union power_supply_propval;

struct power_supply_desc {
	const char *name;
	enum power_supply_type type;
	u8 charge_behaviours;
	u32 charge_types;
	u32 usb_types;
	const enum power_supply_property *properties;
	size_t num_properties;
	int (*get_property)(struct power_supply *, enum power_supply_property, union power_supply_propval *);
	int (*set_property)(struct power_supply *, enum power_supply_property, const union power_supply_propval *);
	int (*property_is_writeable)(struct power_supply *, enum power_supply_property);
	void (*external_power_changed)(struct power_supply *);
	void (*set_charged)(struct power_supply *);
	bool no_thermal;
	int use_for_apm;
};

struct notifier_block;

typedef int (*notifier_fn_t)(struct notifier_block *, long unsigned int, void *);

struct notifier_block {
	notifier_fn_t notifier_call;
	struct notifier_block *next;
	int priority;
};

struct acpi_device;

struct acpi_ac {
	struct power_supply *charger;
	struct power_supply_desc charger_desc;
	struct acpi_device *device;
	long long unsigned int state;
	struct notifier_block battery_nb;
};

struct acpi_address16_attribute {
	u16 granularity;
	u16 minimum;
	u16 maximum;
	u16 translation_offset;
	u16 address_length;
};

struct acpi_address32_attribute {
	u32 granularity;
	u32 minimum;
	u32 maximum;
	u32 translation_offset;
	u32 address_length;
};

struct acpi_address64_attribute {
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
};

struct acpi_namespace_node;

struct acpi_address_range {
	struct acpi_address_range *next;
	struct acpi_namespace_node *region_node;
	acpi_physical_address start_address;
	acpi_physical_address end_address;
};

struct acpi_battery {
	struct mutex lock;
	struct mutex sysfs_lock;
	struct power_supply *bat;
	struct power_supply_desc bat_desc;
	struct acpi_device *device;
	struct notifier_block pm_nb;
	struct list_head list;
	long unsigned int update_time;
	int revision;
	int rate_now;
	int capacity_now;
	int voltage_now;
	int design_capacity;
	int full_charge_capacity;
	int technology;
	int design_voltage;
	int design_capacity_warning;
	int design_capacity_low;
	int cycle_count;
	int measurement_accuracy;
	int max_sampling_time;
	int min_sampling_time;
	int max_averaging_interval;
	int min_averaging_interval;
	int capacity_granularity_1;
	int capacity_granularity_2;
	int alarm;
	char model_number[64];
	char serial_number[64];
	char type[64];
	char oem_info[64];
	int state;
	int power_unit;
	long unsigned int flags;
};

struct acpi_battery_hook {
	const char *name;
	int (*add_battery)(struct power_supply *, struct acpi_battery_hook *);
	int (*remove_battery)(struct power_supply *, struct acpi_battery_hook *);
	struct list_head list;
};

struct acpi_bit_register_info {
	u8 parent_register;
	u8 bit_position;
	u16 access_bit_mask;
};

struct acpi_buffer {
	acpi_size length;
	void *pointer;
};

struct acpi_bus_event {
	struct list_head node;
	acpi_device_class device_class;
	acpi_bus_id bus_id;
	u32 type;
	u32 data;
};

struct acpi_bus_type {
	struct list_head list;
	const char *name;
	bool (*match)(struct device *);
	struct acpi_device * (*find_companion)(struct device *);
	void (*setup)(struct device *);
};

struct input_dev;

struct acpi_button {
	unsigned int type;
	struct input_dev *input;
	char phys[32];
	long unsigned int pushed;
	int last_state;
	ktime_t last_time;
	bool suspended;
	bool lid_state_initialized;
};

struct acpi_cdat_header {
	u8 type;
	u8 reserved;
	u16 length;
};

struct acpi_cedt_header {
	u8 type;
	u8 reserved;
	u16 length;
};

struct acpi_cedt_cfmws {
	struct acpi_cedt_header header;
	u32 reserved1;
	u64 base_hpa;
	u64 window_size;
	u8 interleave_ways;
	u8 interleave_arithmetic;
	u16 reserved2;
	u32 granularity;
	u16 restrictions;
	u16 qtg_id;
	u32 interleave_targets[0];
} __attribute__((packed));

struct acpi_comment_node {
	char *comment;
	struct acpi_comment_node *next;
};

struct acpi_common_descriptor {
	void *common_pointer;
	u8 descriptor_type;
};

struct acpi_common_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
};

struct acpi_connection_info {
	u8 *connection;
	u16 length;
	u8 access_length;
};

union acpi_parse_object;

struct acpi_control_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u16 opcode;
	union acpi_parse_object *predicate_op;
	u8 *aml_predicate_start;
	u8 *package_end;
	u64 loop_timeout;
};

struct acpi_create_field_info {
	struct acpi_namespace_node *region_node;
	struct acpi_namespace_node *field_node;
	struct acpi_namespace_node *register_node;
	struct acpi_namespace_node *data_register_node;
	struct acpi_namespace_node *connection_node;
	u8 *resource_buffer;
	u32 bank_value;
	u32 field_bit_position;
	u32 field_bit_length;
	u16 resource_length;
	u16 pin_number_index;
	u8 field_flags;
	u8 attribute;
	u8 field_type;
	u8 access_length;
};

struct acpi_csrt_group {
	u32 length;
	u32 vendor_id;
	u32 subvendor_id;
	u16 device_id;
	u16 subdevice_id;
	u16 revision;
	u16 reserved;
	u32 shared_info_length;
};

struct acpi_csrt_shared_info {
	u16 major_version;
	u16 minor_version;
	u32 mmio_base_low;
	u32 mmio_base_high;
	u32 gsi_interrupt;
	u8 interrupt_polarity;
	u8 interrupt_mode;
	u8 num_channels;
	u8 dma_address_width;
	u16 base_request_line;
	u16 num_handshake_signals;
	u32 max_block_size;
};

struct attribute {
	const char *name;
	umode_t mode;
};

struct address_space;

struct file;

struct vm_area_struct;

struct bin_attribute {
	struct attribute attr;
	size_t size;
	void *private;
	struct address_space * (*f_mapping)(void);
	ssize_t (*read)(struct file *, struct kobject *, struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*read_new)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write)(struct file *, struct kobject *, struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write_new)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	loff_t (*llseek)(struct file *, struct kobject *, const struct bin_attribute *, loff_t, int);
	int (*mmap)(struct file *, struct kobject *, const struct bin_attribute *, struct vm_area_struct *);
};

struct acpi_data_attr {
	struct bin_attribute attr;
	u64 addr;
};

typedef void *acpi_handle;

struct fwnode_operations;

struct fwnode_handle {
	struct fwnode_handle *secondary;
	const struct fwnode_operations *ops;
	struct device *dev;
	struct list_head suppliers;
	struct list_head consumers;
	u8 flags;
};

union acpi_object;

struct acpi_device_data {
	const union acpi_object *pointer;
	struct list_head properties;
	const union acpi_object *of_compatible;
	struct list_head subnodes;
};

struct acpi_data_node {
	struct list_head sibling;
	const char *name;
	acpi_handle handle;
	struct fwnode_handle fwnode;
	struct fwnode_handle *parent;
	struct acpi_device_data data;
	struct kobject kobj;
	struct completion kobj_done;
};

struct acpi_data_node_attr {
	struct attribute attr;
	ssize_t (*show)(struct acpi_data_node *, char *);
	ssize_t (*store)(struct acpi_data_node *, const char *, size_t);
};

struct acpi_data_obj {
	char *name;
	int (*fn)(void *, struct acpi_data_attr *);
};

struct acpi_data_table_mapping {
	void *pointer;
};

struct acpi_dep_data {
	struct list_head node;
	acpi_handle supplier;
	acpi_handle consumer;
	bool honor_dep;
	bool met;
	bool free_when_met;
};

union acpi_operand_object;

struct acpi_object_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
};

struct acpi_object_integer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 fill[3];
	u64 value;
};

struct acpi_object_string {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	char *pointer;
	u32 length;
};

struct acpi_object_buffer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 *pointer;
	u32 length;
	u32 aml_length;
	u8 *aml_start;
	struct acpi_namespace_node *node;
};

struct acpi_object_package {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *node;
	union acpi_operand_object **elements;
	u8 *aml_start;
	u32 aml_length;
	u32 count;
};

struct acpi_object_event {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	void *os_semaphore;
};

struct acpi_walk_state;

typedef acpi_status (*acpi_internal_method)(struct acpi_walk_state *);

struct acpi_object_method {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 info_flags;
	u8 param_count;
	u8 sync_level;
	union acpi_operand_object *mutex;
	union acpi_operand_object *node;
	u8 *aml_start;
	union {
		acpi_internal_method implementation;
		union acpi_operand_object *handler;
	} dispatch;
	u32 aml_length;
	acpi_owner_id owner_id;
	u8 thread_count;
};

struct acpi_thread_state;

struct acpi_object_mutex {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 sync_level;
	u16 acquisition_depth;
	void *os_mutex;
	u64 thread_id;
	struct acpi_thread_state *owner_thread;
	union acpi_operand_object *prev;
	union acpi_operand_object *next;
	struct acpi_namespace_node *node;
	u8 original_sync_level;
};

struct acpi_object_region {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 space_id;
	struct acpi_namespace_node *node;
	union acpi_operand_object *handler;
	union acpi_operand_object *next;
	acpi_physical_address address;
	u32 length;
	void *pointer;
};

struct acpi_object_notify_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
};

struct acpi_gpe_block_info;

struct acpi_object_device {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	struct acpi_gpe_block_info *gpe_block;
};

struct acpi_object_power_resource {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	u32 system_level;
	u32 resource_order;
};

struct acpi_object_processor {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 proc_id;
	u8 length;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	acpi_io_address address;
};

struct acpi_object_thermal_zone {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
};

struct acpi_object_field_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *region_obj;
};

struct acpi_object_region_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u16 resource_length;
	union acpi_operand_object *region_obj;
	u8 *resource_buffer;
	u16 pin_number_index;
	u8 *internal_pcc_buffer;
};

struct acpi_object_buffer_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u8 is_create_field;
	union acpi_operand_object *buffer_obj;
};

struct acpi_object_bank_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *region_obj;
	union acpi_operand_object *bank_obj;
};

struct acpi_object_index_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *index_obj;
	union acpi_operand_object *data_obj;
};

typedef void (*acpi_notify_handler)(acpi_handle, u32, void *);

struct acpi_object_notify_handler {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *node;
	u32 handler_type;
	acpi_notify_handler handler;
	void *context;
	union acpi_operand_object *next[2];
};

typedef acpi_status (*acpi_adr_space_handler)(u32, acpi_physical_address, u32, u64 *, void *, void *);

typedef acpi_status (*acpi_adr_space_setup)(acpi_handle, u32, void *, void **);

struct acpi_object_addr_handler {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 space_id;
	u8 handler_flags;
	acpi_adr_space_handler handler;
	struct acpi_namespace_node *node;
	void *context;
	void *context_mutex;
	acpi_adr_space_setup setup;
	union acpi_operand_object *region_list;
	union acpi_operand_object *next;
};

struct acpi_object_reference {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 class;
	u8 target_type;
	u8 resolved;
	void *object;
	struct acpi_namespace_node *node;
	union acpi_operand_object **where;
	u8 *index_pointer;
	u8 *aml;
	u32 value;
};

struct acpi_object_extra {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *method_REG;
	struct acpi_namespace_node *scope_node;
	void *region_context;
	u8 *aml_start;
	u32 aml_length;
};

typedef void (*acpi_object_handler)(acpi_handle, void *);

struct acpi_object_data {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	acpi_object_handler handler;
	void *pointer;
};

struct acpi_object_cache_list {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *next;
};

union acpi_name_union {
	u32 integer;
	char ascii[4];
};

struct acpi_namespace_node {
	union acpi_operand_object *object;
	u8 descriptor_type;
	u8 type;
	u16 flags;
	union acpi_name_union name;
	struct acpi_namespace_node *parent;
	struct acpi_namespace_node *child;
	struct acpi_namespace_node *peer;
	acpi_owner_id owner_id;
};

union acpi_operand_object {
	struct acpi_object_common common;
	struct acpi_object_integer integer;
	struct acpi_object_string string;
	struct acpi_object_buffer buffer;
	struct acpi_object_package package;
	struct acpi_object_event event;
	struct acpi_object_method method;
	struct acpi_object_mutex mutex;
	struct acpi_object_region region;
	struct acpi_object_notify_common common_notify;
	struct acpi_object_device device;
	struct acpi_object_power_resource power_resource;
	struct acpi_object_processor processor;
	struct acpi_object_thermal_zone thermal_zone;
	struct acpi_object_field_common common_field;
	struct acpi_object_region_field field;
	struct acpi_object_buffer_field buffer_field;
	struct acpi_object_bank_field bank_field;
	struct acpi_object_index_field index_field;
	struct acpi_object_notify_handler notify;
	struct acpi_object_addr_handler address_space;
	struct acpi_object_reference reference;
	struct acpi_object_extra extra;
	struct acpi_object_data data;
	struct acpi_object_cache_list cache;
	struct acpi_namespace_node node;
};

union acpi_parse_value {
	u64 integer;
	u32 size;
	char *string;
	u8 *buffer;
	char *name;
	union acpi_parse_object *arg;
};

struct acpi_parse_obj_common {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
};

struct acpi_parse_obj_named {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
	char *path;
	u8 *data;
	u32 length;
	u32 name;
};

struct acpi_parse_obj_asl {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
	union acpi_parse_object *child;
	union acpi_parse_object *parent_method;
	char *filename;
	u8 file_changed;
	char *parent_filename;
	char *external_name;
	char *namepath;
	char name_seg[4];
	u32 extra_value;
	u32 column;
	u32 line_number;
	u32 logical_line_number;
	u32 logical_byte_offset;
	u32 end_line;
	u32 end_logical_line;
	u32 acpi_btype;
	u32 aml_length;
	u32 aml_subtree_length;
	u32 final_aml_length;
	u32 final_aml_offset;
	u32 compile_flags;
	u16 parse_opcode;
	u8 aml_opcode_length;
	u8 aml_pkg_len_bytes;
	u8 extra;
	char parse_op_name[20];
};

union acpi_parse_object {
	struct acpi_parse_obj_common common;
	struct acpi_parse_obj_named named;
	struct acpi_parse_obj_asl asl;
};

union acpi_descriptor {
	struct acpi_common_descriptor common;
	union acpi_operand_object object;
	struct acpi_namespace_node node;
	union acpi_parse_object op;
};

struct acpi_device_id {
	__u8 id[16];
	kernel_ulong_t driver_data;
	__u32 cls;
	__u32 cls_msk;
};

struct acpi_dev_match_info {
	struct acpi_device_id hid[2];
	const char *uid;
	s64 hrv;
};

struct acpi_dev_walk_context {
	int (*fn)(struct acpi_device *, void *);
	void *data;
};

struct acpi_device_status {
	u32 present: 1;
	u32 enabled: 1;
	u32 show_in_ui: 1;
	u32 functional: 1;
	u32 battery_present: 1;
	u32 reserved: 27;
};

struct acpi_device_flags {
	u32 dynamic_status: 1;
	u32 removable: 1;
	u32 ejectable: 1;
	u32 power_manageable: 1;
	u32 match_driver: 1;
	u32 initialized: 1;
	u32 visited: 1;
	u32 hotplug_notify: 1;
	u32 is_dock_station: 1;
	u32 of_compatible_ok: 1;
	u32 coherent_dma: 1;
	u32 cca_seen: 1;
	u32 enumeration_by_parent: 1;
	u32 honor_deps: 1;
	u32 reserved: 18;
};

struct acpi_pnp_type {
	u32 hardware_id: 1;
	u32 bus_address: 1;
	u32 platform_id: 1;
	u32 backlight: 1;
	u32 reserved: 28;
};

struct acpi_device_pnp {
	acpi_bus_id bus_id;
	int instance_no;
	struct acpi_pnp_type type;
	acpi_bus_address bus_address;
	char *unique_id;
	struct list_head ids;
	acpi_device_name device_name;
	acpi_device_class device_class;
};

struct acpi_device_power_flags {
	u32 explicit_get: 1;
	u32 power_resources: 1;
	u32 inrush_current: 1;
	u32 power_removed: 1;
	u32 ignore_parent: 1;
	u32 dsw_present: 1;
	u32 reserved: 26;
};

struct acpi_device_power_state {
	struct list_head resources;
	struct {
		u8 valid: 1;
		u8 explicit_set: 1;
		u8 reserved: 6;
	} flags;
	int power;
	int latency;
};

struct acpi_device_power {
	int state;
	struct acpi_device_power_flags flags;
	struct acpi_device_power_state states[5];
	u8 state_for_enumeration;
};

struct acpi_device_wakeup_flags {
	u8 valid: 1;
	u8 notifier_present: 1;
};

struct acpi_device_wakeup_context {
	void (*func)(struct acpi_device_wakeup_context *);
	struct device *dev;
};

struct acpi_device_wakeup {
	acpi_handle gpe_device;
	u64 gpe_number;
	u64 sleep_state;
	struct list_head resources;
	struct acpi_device_wakeup_flags flags;
	struct acpi_device_wakeup_context context;
	struct wakeup_source *ws;
	int prepare_count;
	int enable_count;
};

struct acpi_device_perf_flags {
	u8 reserved: 8;
};

struct acpi_device_perf_state;

struct acpi_device_perf {
	int state;
	struct acpi_device_perf_flags flags;
	int state_count;
	struct acpi_device_perf_state *states;
};

struct acpi_device_dir {
	struct proc_dir_entry *entry;
};

struct acpi_scan_handler;

struct acpi_hotplug_context;

struct acpi_device_software_nodes;

struct acpi_gpio_mapping;

struct acpi_device {
	u32 pld_crc;
	int device_type;
	acpi_handle handle;
	struct fwnode_handle fwnode;
	struct list_head wakeup_list;
	struct list_head del_list;
	struct acpi_device_status status;
	struct acpi_device_flags flags;
	struct acpi_device_pnp pnp;
	struct acpi_device_power power;
	struct acpi_device_wakeup wakeup;
	struct acpi_device_perf performance;
	struct acpi_device_dir dir;
	struct acpi_device_data data;
	struct acpi_scan_handler *handler;
	struct acpi_hotplug_context *hp;
	struct acpi_device_software_nodes *swnodes;
	const struct acpi_gpio_mapping *driver_gpios;
	void *driver_data;
	struct device dev;
	unsigned int physical_node_count;
	unsigned int dep_unmet;
	struct list_head physical_node_list;
	struct mutex physical_node_lock;
	void (*remove)(struct acpi_device *);
};

struct xarray {
	spinlock_t xa_lock;
	gfp_t xa_flags;
	void *xa_head;
};

struct ida {
	struct xarray xa;
};

struct acpi_device_bus_id {
	const char *bus_id;
	struct ida instance_ida;
	struct list_head node;
};

struct acpi_pnp_device_id {
	u32 length;
	char *string;
};

struct acpi_pnp_device_id_list {
	u32 count;
	u32 list_size;
	struct acpi_pnp_device_id ids[0];
};

struct acpi_device_info {
	u32 info_size;
	u32 name;
	acpi_object_type type;
	u8 param_count;
	u16 valid;
	u8 flags;
	u8 highest_dstates[4];
	u8 lowest_dstates[5];
	u64 address;
	struct acpi_pnp_device_id hardware_id;
	struct acpi_pnp_device_id unique_id;
	struct acpi_pnp_device_id class_code;
	struct acpi_pnp_device_id_list compatible_id_list;
};

typedef int (*acpi_op_add)(struct acpi_device *);

typedef void (*acpi_op_remove)(struct acpi_device *);

typedef void (*acpi_op_notify)(struct acpi_device *, u32);

struct acpi_device_ops {
	acpi_op_add add;
	acpi_op_remove remove;
	acpi_op_notify notify;
};

struct acpi_device_perf_state {
	struct {
		u8 valid: 1;
		u8 reserved: 7;
	} flags;
	u8 power;
	u8 performance;
	int latency;
};

struct acpi_device_physical_node {
	struct list_head node;
	struct device *dev;
	unsigned int node_id;
	bool put_online: 1;
};

struct acpi_device_properties {
	struct list_head list;
	const guid_t *guid;
	union acpi_object *properties;
	void **bufs;
};

struct property_entry {
	const char *name;
	size_t length;
	bool is_inline;
	enum dev_prop_type type;
	union {
		const void *pointer;
		union {
			u8 u8_data[8];
			u16 u16_data[4];
			u32 u32_data[2];
			u64 u64_data[1];
			const char *str[1];
		} value;
	};
};

struct software_node;

struct software_node_ref_args {
	const struct software_node *node;
	unsigned int nargs;
	u64 args[8];
};

struct acpi_device_software_node_port {
	char port_name[9];
	u32 data_lanes[8];
	u32 lane_polarities[9];
	u64 link_frequencies[8];
	unsigned int port_nr;
	bool crs_csi2_local;
	struct property_entry port_props[2];
	struct property_entry ep_props[8];
	struct software_node_ref_args remote_ep[1];
};

struct acpi_device_software_nodes {
	struct property_entry dev_props[6];
	struct software_node *nodes;
	const struct software_node **nodeptrs;
	struct acpi_device_software_node_port *ports;
	unsigned int num_ports;
};

struct acpi_table_desc;

struct acpi_evaluate_info;

struct acpi_device_walk_info {
	struct acpi_table_desc *table_desc;
	struct acpi_evaluate_info *evaluate_info;
	u32 device_count;
	u32 num_STA;
	u32 num_INI;
};

struct dma_chan;

struct acpi_dma_spec;

struct acpi_dma {
	struct list_head dma_controllers;
	struct device *dev;
	struct dma_chan * (*acpi_dma_xlate)(struct acpi_dma_spec *, struct acpi_dma *);
	void *data;
	short unsigned int base_request_line;
	short unsigned int end_request_line;
};

typedef bool (*dma_filter_fn)(struct dma_chan *, void *);

struct acpi_dma_filter_info {
	dma_cap_mask_t dma_cap;
	dma_filter_fn filter_fn;
};

struct acpi_dma_spec {
	int chan_id;
	int slave_id;
	struct device *dev;
};

struct acpi_dma_parser_data {
	struct acpi_dma_spec dma_spec;
	size_t index;
	size_t n;
};

struct of_device_id;

struct dev_pm_ops;

struct driver_private;

struct device_driver {
	const char *name;
	const struct bus_type *bus;
	struct module *owner;
	const char *mod_name;
	bool suppress_bind_attrs;
	enum probe_type probe_type;
	const struct of_device_id *of_match_table;
	const struct acpi_device_id *acpi_match_table;
	int (*probe)(struct device *);
	void (*sync_state)(struct device *);
	int (*remove)(struct device *);
	void (*shutdown)(struct device *);
	int (*suspend)(struct device *, pm_message_t);
	int (*resume)(struct device *);
	const struct attribute_group **groups;
	const struct attribute_group **dev_groups;
	const struct dev_pm_ops *pm;
	void (*coredump)(struct device *);
	struct driver_private *p;
};

struct acpi_driver {
	char name[80];
	char class[80];
	const struct acpi_device_id *ids;
	unsigned int flags;
	struct acpi_device_ops ops;
	struct device_driver drv;
};

struct transaction;

struct acpi_ec {
	acpi_handle handle;
	int gpe;
	int irq;
	long unsigned int command_addr;
	long unsigned int data_addr;
	bool global_lock;
	long unsigned int flags;
	long unsigned int reference_count;
	struct mutex mutex;
	wait_queue_head_t wait;
	struct list_head list;
	struct transaction *curr;
	spinlock_t lock;
	struct work_struct work;
	long unsigned int timestamp;
	enum acpi_ec_event_state event_state;
	unsigned int events_to_process;
	unsigned int events_in_progress;
	unsigned int queries_in_progress;
	bool busy_polling;
	unsigned int polling_guard;
};

struct transaction {
	const u8 *wdata;
	u8 *rdata;
	short unsigned int irq_count;
	u8 command;
	u8 wi;
	u8 ri;
	u8 wlen;
	u8 rlen;
	u8 flags;
};

struct acpi_ec_query_handler;

struct acpi_ec_query {
	struct transaction transaction;
	struct work_struct work;
	struct acpi_ec_query_handler *handler;
	struct acpi_ec *ec;
};

typedef int (*acpi_ec_query_func)(void *);

struct acpi_ec_query_handler {
	struct list_head node;
	acpi_ec_query_func func;
	acpi_handle handle;
	void *data;
	u8 query_bit;
	struct kref kref;
};

union acpi_predefined_info;

struct acpi_evaluate_info {
	struct acpi_namespace_node *prefix_node;
	const char *relative_pathname;
	union acpi_operand_object **parameters;
	struct acpi_namespace_node *node;
	union acpi_operand_object *obj_desc;
	char *full_pathname;
	const union acpi_predefined_info *predefined;
	union acpi_operand_object *return_object;
	union acpi_operand_object *parent_package;
	u32 return_flags;
	u32 return_btype;
	u16 param_count;
	u16 node_flags;
	u8 pass_number;
	u8 return_object_type;
	u8 flags;
};

struct acpi_exception_info {
	char *name;
};

struct acpi_fadt_info {
	const char *name;
	u16 address64;
	u16 address32;
	u16 length;
	u8 default_length;
	u8 flags;
};

struct acpi_generic_address;

struct acpi_fadt_pm_info {
	struct acpi_generic_address *target;
	u16 source;
	u8 register_num;
};

struct acpi_fan_fif {
	u8 revision;
	u8 fine_grain_ctrl;
	u8 step_size;
	u8 low_speed_notification;
};

struct device_attribute {
	struct attribute attr;
	ssize_t (*show)(struct device *, struct device_attribute *, char *);
	ssize_t (*store)(struct device *, struct device_attribute *, const char *, size_t);
};

struct acpi_fan_fps;

struct thermal_cooling_device;

struct acpi_fan {
	bool acpi4;
	struct acpi_fan_fif fif;
	struct acpi_fan_fps *fps;
	int fps_count;
	struct thermal_cooling_device *cdev;
	struct device_attribute fst_speed;
	struct device_attribute fine_grain_control;
};

struct acpi_fan_fps {
	u64 control;
	u64 trip_point;
	u64 speed;
	u64 noise_level;
	u64 power;
	char name[20];
	struct device_attribute dev_attr;
};

struct acpi_fan_fst {
	u64 revision;
	u64 control;
	u64 speed;
};

struct acpi_ffh_info {
	u64 offset;
	u64 length;
};

typedef u32 (*acpi_event_handler)(void *);

struct acpi_fixed_event_handler {
	acpi_event_handler handler;
	void *context;
};

struct acpi_fixed_event_info {
	u8 status_register_id;
	u8 enable_register_id;
	u16 status_bit_mask;
	u16 enable_bit_mask;
};

struct acpi_ged_device {
	struct device *dev;
	struct list_head event_list;
};

struct acpi_ged_event {
	struct list_head node;
	struct device *dev;
	unsigned int gsi;
	unsigned int irq;
	acpi_handle handle;
};

struct acpi_ged_handler_info {
	struct acpi_ged_handler_info *next;
	u32 int_id;
	struct acpi_namespace_node *evt_method;
};

struct acpi_generic_address {
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_width;
	u64 address;
} __attribute__((packed));

struct acpi_update_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	union acpi_operand_object *object;
};

struct acpi_scope_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	struct acpi_namespace_node *node;
};

struct acpi_pscope_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u32 arg_count;
	union acpi_parse_object *op;
	u8 *arg_end;
	u8 *pkg_end;
	u32 arg_list;
};

struct acpi_pkg_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u32 index;
	union acpi_operand_object *source_object;
	union acpi_operand_object *dest_object;
	struct acpi_walk_state *walk_state;
	void *this_target_obj;
	u32 num_packages;
};

struct acpi_thread_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u8 current_sync_level;
	struct acpi_walk_state *walk_state_list;
	union acpi_operand_object *acquired_mutex_list;
	u64 thread_id;
};

struct acpi_result_values {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	union acpi_operand_object *obj_desc[8];
};

struct acpi_global_notify_handler;

struct acpi_notify_info {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u8 handler_list_id;
	struct acpi_namespace_node *node;
	union acpi_operand_object *handler_list_head;
	struct acpi_global_notify_handler *global;
};

union acpi_generic_state {
	struct acpi_common_state common;
	struct acpi_control_state control;
	struct acpi_update_state update;
	struct acpi_scope_state scope;
	struct acpi_pscope_state parse_scope;
	struct acpi_pkg_state pkg;
	struct acpi_thread_state thread;
	struct acpi_result_values results;
	struct acpi_notify_info notify;
};

struct acpi_genl_event {
	acpi_device_class device_class;
	char bus_id[15];
	u32 type;
	u32 data;
};

typedef acpi_status (*acpi_walk_callback)(acpi_handle, u32, void *, void **);

struct acpi_get_devices_info {
	acpi_walk_callback user_function;
	void *context;
	const char *hid;
};

struct acpi_global_notify_handler {
	acpi_notify_handler handler;
	void *context;
};

struct acpi_gpe_address {
	u8 space_id;
	u64 address;
};

struct acpi_gpe_xrupt_info;

struct acpi_gpe_register_info;

struct acpi_gpe_event_info;

struct acpi_gpe_block_info {
	struct acpi_namespace_node *node;
	struct acpi_gpe_block_info *previous;
	struct acpi_gpe_block_info *next;
	struct acpi_gpe_xrupt_info *xrupt_block;
	struct acpi_gpe_register_info *register_info;
	struct acpi_gpe_event_info *event_info;
	u64 address;
	u32 register_count;
	u16 gpe_count;
	u16 block_base_number;
	u8 space_id;
	u8 initialized;
};

struct acpi_gpe_block_status_context {
	struct acpi_gpe_register_info *gpe_skip_register_info;
	u8 gpe_skip_mask;
	u8 retval;
};

struct acpi_gpe_device_info {
	u32 index;
	u32 next_block_base_index;
	acpi_status status;
	struct acpi_namespace_node *gpe_device;
};

struct acpi_gpe_handler_info;

struct acpi_gpe_notify_info;

union acpi_gpe_dispatch_info {
	struct acpi_namespace_node *method_node;
	struct acpi_gpe_handler_info *handler;
	struct acpi_gpe_notify_info *notify_list;
};

struct acpi_gpe_event_info {
	union acpi_gpe_dispatch_info dispatch;
	struct acpi_gpe_register_info *register_info;
	u8 flags;
	u8 gpe_number;
	u8 runtime_count;
	u8 disable_for_dispatch;
};

typedef u32 (*acpi_gpe_handler)(acpi_handle, u32, void *);

struct acpi_gpe_handler_info {
	acpi_gpe_handler address;
	void *context;
	struct acpi_namespace_node *method_node;
	u8 original_flags;
	u8 originally_enabled;
};

struct acpi_gpe_notify_info {
	struct acpi_namespace_node *device_node;
	struct acpi_gpe_notify_info *next;
};

struct acpi_gpe_register_info {
	struct acpi_gpe_address status_address;
	struct acpi_gpe_address enable_address;
	u16 base_gpe_number;
	u8 enable_for_wake;
	u8 enable_for_run;
	u8 mask_for_run;
	u8 enable_mask;
};

struct acpi_gpe_walk_info {
	struct acpi_namespace_node *gpe_device;
	struct acpi_gpe_block_info *gpe_block;
	u16 count;
	acpi_owner_id owner_id;
	u8 execute_by_owner_id;
};

struct acpi_gpe_xrupt_info {
	struct acpi_gpe_xrupt_info *previous;
	struct acpi_gpe_xrupt_info *next;
	struct acpi_gpe_block_info *gpe_block_list_head;
	u32 interrupt_number;
};

struct gpio_chip;

struct acpi_gpio_chip {
	struct acpi_connection_info conn_info;
	struct list_head conns;
	struct mutex conn_lock;
	struct gpio_chip *chip;
	struct list_head events;
	struct list_head deferred_req_irqs_list_entry;
};

struct gpio_desc;

struct acpi_gpio_connection {
	struct list_head node;
	unsigned int pin;
	struct gpio_desc *desc;
};

typedef irqreturn_t (*irq_handler_t)(int, void *);

struct acpi_gpio_event {
	struct list_head node;
	acpi_handle handle;
	irq_handler_t handler;
	unsigned int pin;
	unsigned int irq;
	long unsigned int irqflags;
	bool irq_is_wake;
	bool irq_requested;
	struct gpio_desc *desc;
};

struct acpi_gpio_info {
	struct acpi_device *adev;
	enum gpiod_flags flags;
	bool gpioint;
	int pin_config;
	int polarity;
	int triggering;
	bool wake_capable;
	unsigned int debounce;
	unsigned int quirks;
};

struct acpi_gpio_lookup {
	struct acpi_gpio_info info;
	int index;
	u16 pin_index;
	bool active_low;
	struct gpio_desc *desc;
	int n;
};

struct acpi_gpio_params;

struct acpi_gpio_mapping {
	const char *name;
	const struct acpi_gpio_params *data;
	unsigned int size;
	unsigned int quirks;
};

struct acpi_gpio_params {
	unsigned int crs_entry_index;
	unsigned int line_index;
	bool active_low;
};

struct acpi_gpiolib_dmi_quirk {
	bool no_edge_events_on_boot;
	char *ignore_wake;
	char *ignore_interrupt;
};

struct acpi_handle_list {
	u32 count;
	acpi_handle *handles;
};

struct acpi_hardware_id {
	struct list_head list;
	const char *id;
};

struct acpi_hmat_structure {
	u16 type;
	u16 reserved;
	u32 length;
};

typedef int (*acpi_hp_notify)(struct acpi_device *, u32);

typedef void (*acpi_hp_uevent)(struct acpi_device *, u32);

typedef void (*acpi_hp_fixup)(struct acpi_device *);

struct acpi_hotplug_context {
	struct acpi_device *self;
	acpi_hp_notify notify;
	acpi_hp_uevent uevent;
	acpi_hp_fixup fixup;
};

struct acpi_hotplug_profile {
	struct kobject kobj;
	int (*scan_dependent)(struct acpi_device *);
	void (*notify_online)(struct acpi_device *);
	bool enabled: 1;
	bool demand_offline: 1;
};

struct acpi_hp_work {
	struct work_struct work;
	struct acpi_device *adev;
	u32 src;
};

struct acpi_init_walk_info {
	u32 table_index;
	u32 object_count;
	u32 method_count;
	u32 serial_method_count;
	u32 non_serial_method_count;
	u32 serialized_method_count;
	u32 device_count;
	u32 op_region_count;
	u32 field_count;
	u32 buffer_count;
	u32 package_count;
	u32 op_region_init;
	u32 field_init;
	u32 buffer_init;
	u32 package_init;
	acpi_owner_id owner_id;
};

struct acpi_interface_info {
	char *name;
	struct acpi_interface_info *next;
	u8 flags;
	u8 value;
};

struct acpi_io_attribute {
	u8 range_type;
	u8 translation;
	u8 translation_type;
	u8 reserved1;
};

struct rcu_work {
	struct work_struct work;
	struct callback_head rcu;
	struct workqueue_struct *wq;
};

struct acpi_ioremap {
	struct list_head list;
	void *virt;
	acpi_physical_address phys;
	acpi_size size;
	union {
		long unsigned int refcount;
		struct rcu_work rwork;
	} track;
};

struct irq_fwspec;

struct acpi_irq_parse_one_ctx {
	int rc;
	unsigned int index;
	long unsigned int *res_flags;
	struct irq_fwspec *fwspec;
};

struct acpi_lpat {
	int temp;
	int raw;
};

struct acpi_lpat_conversion_table {
	struct acpi_lpat *lpat;
	int lpat_count;
};

struct acpi_lpi_state {
	u32 min_residency;
	u32 wake_latency;
	u32 flags;
	u32 arch_flags;
	u32 res_cnt_freq;
	u32 enable_parent_state;
	u64 address;
	u8 index;
	u8 entry_method;
	char desc[32];
};

struct acpi_lpi_states_array {
	unsigned int size;
	unsigned int composite_states_size;
	struct acpi_lpi_state *entries;
	struct acpi_lpi_state *composite_states[8];
};

struct acpi_subtable_header {
	u8 type;
	u8 length;
};

struct acpi_madt_bio_pic {
	struct acpi_subtable_header header;
	u8 version;
	u64 address;
	u16 size;
	u16 id;
	u16 gsi_base;
} __attribute__((packed));

struct acpi_madt_core_pic {
	struct acpi_subtable_header header;
	u8 version;
	u32 processor_id;
	u32 core_id;
	u32 flags;
} __attribute__((packed));

struct acpi_madt_eio_pic {
	struct acpi_subtable_header header;
	u8 version;
	u8 cascade;
	u8 node;
	u64 node_map;
} __attribute__((packed));

struct acpi_madt_generic_distributor {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 gic_id;
	u64 base_address;
	u32 global_irq_base;
	u8 version;
	u8 reserved2[3];
};

struct acpi_madt_generic_interrupt {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 cpu_interface_number;
	u32 uid;
	u32 flags;
	u32 parking_version;
	u32 performance_interrupt;
	u64 parked_address;
	u64 base_address;
	u64 gicv_base_address;
	u64 gich_base_address;
	u32 vgic_interrupt;
	u64 gicr_base_address;
	u64 arm_mpidr;
	u8 efficiency_class;
	u8 reserved2[1];
	u16 spe_interrupt;
	u16 trbe_interrupt;
} __attribute__((packed));

struct acpi_madt_ht_pic {
	struct acpi_subtable_header header;
	u8 version;
	u64 address;
	u16 size;
	u8 cascade[8];
} __attribute__((packed));

struct acpi_madt_interrupt_override {
	struct acpi_subtable_header header;
	u8 bus;
	u8 source_irq;
	u32 global_irq;
	u16 inti_flags;
} __attribute__((packed));

struct acpi_madt_interrupt_source {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u8 type;
	u8 id;
	u8 eid;
	u8 io_sapic_vector;
	u32 global_irq;
	u32 flags;
};

struct acpi_madt_io_apic {
	struct acpi_subtable_header header;
	u8 id;
	u8 reserved;
	u32 address;
	u32 global_irq_base;
};

struct acpi_madt_io_sapic {
	struct acpi_subtable_header header;
	u8 id;
	u8 reserved;
	u32 global_irq_base;
	u64 address;
};

struct acpi_madt_lio_pic {
	struct acpi_subtable_header header;
	u8 version;
	u64 address;
	u16 size;
	u8 cascade[2];
	u32 cascade_map[2];
} __attribute__((packed));

struct acpi_madt_local_apic {
	struct acpi_subtable_header header;
	u8 processor_id;
	u8 id;
	u32 lapic_flags;
};

struct acpi_madt_local_apic_nmi {
	struct acpi_subtable_header header;
	u8 processor_id;
	u16 inti_flags;
	u8 lint;
} __attribute__((packed));

struct acpi_madt_local_apic_override {
	struct acpi_subtable_header header;
	u16 reserved;
	u64 address;
} __attribute__((packed));

struct acpi_madt_local_sapic {
	struct acpi_subtable_header header;
	u8 processor_id;
	u8 id;
	u8 eid;
	u8 reserved[3];
	u32 lapic_flags;
	u32 uid;
	char uid_string[0];
};

struct acpi_madt_local_x2apic {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 local_apic_id;
	u32 lapic_flags;
	u32 uid;
};

struct acpi_madt_local_x2apic_nmi {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u32 uid;
	u8 lint;
	u8 reserved[3];
};

struct acpi_madt_lpc_pic {
	struct acpi_subtable_header header;
	u8 version;
	u64 address;
	u16 size;
	u8 cascade;
} __attribute__((packed));

struct acpi_madt_msi_pic {
	struct acpi_subtable_header header;
	u8 version;
	u64 msg_address;
	u32 start;
	u32 count;
} __attribute__((packed));

struct acpi_madt_multiproc_wakeup {
	struct acpi_subtable_header header;
	u16 version;
	u32 reserved;
	u64 mailbox_address;
	u64 reset_vector;
};

struct acpi_madt_nmi_source {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u32 global_irq;
};

struct acpi_madt_rintc {
	struct acpi_subtable_header header;
	u8 version;
	u8 reserved;
	u32 flags;
	u64 hart_id;
	u32 uid;
	u32 ext_intc_id;
	u64 imsic_addr;
	u32 imsic_size;
} __attribute__((packed));

struct acpi_mcfg_allocation {
	u64 address;
	u16 pci_segment;
	u8 start_bus_number;
	u8 end_bus_number;
	u32 reserved;
};

struct acpi_mem_mapping {
	acpi_physical_address physical_address;
	u8 *logical_address;
	acpi_size length;
	struct acpi_mem_mapping *next_mm;
};

struct acpi_mem_space_context {
	u32 length;
	acpi_physical_address address;
	struct acpi_mem_mapping *cur_mm;
	struct acpi_mem_mapping *first_mm;
};

struct acpi_memory_attribute {
	u8 write_protect;
	u8 caching;
	u8 range_type;
	u8 translation;
};

struct acpi_memory_device {
	struct acpi_device *device;
	struct list_head res_list;
	int mgid;
};

struct acpi_memory_info {
	struct list_head list;
	u64 start_addr;
	u64 length;
	short unsigned int caching;
	short unsigned int write_protect;
	unsigned int enabled: 1;
};

struct acpi_mutex_info {
	void *mutex;
	u32 use_count;
	u64 thread_id;
};

struct acpi_name_info {
	char name[4];
	u16 argument_list;
	u8 expected_btypes;
} __attribute__((packed));

struct acpi_namestring_info {
	const char *external_name;
	const char *next_external_char;
	char *internal_name;
	u32 length;
	u32 num_segments;
	u32 num_carats;
	u8 fully_qualified;
};

struct acpi_nhlt_config {
	u32 capabilities_size;
	u8 capabilities[0];
};

struct acpi_nhlt_gendevice_config {
	u8 virtual_slot;
	u8 config_type;
};

struct acpi_nhlt_micdevice_config {
	u8 virtual_slot;
	u8 config_type;
	u8 array_type;
};

struct acpi_nhlt_vendor_mic_config {
	u8 type;
	u8 panel;
	u16 speaker_position_distance;
	u16 horizontal_offset;
	u16 vertical_offset;
	u8 frequency_low_band;
	u8 frequency_high_band;
	u16 direction_angle;
	u16 elevation_angle;
	u16 work_vertical_angle_begin;
	u16 work_vertical_angle_end;
	u16 work_horizontal_angle_begin;
	u16 work_horizontal_angle_end;
};

struct acpi_nhlt_vendor_micdevice_config {
	u8 virtual_slot;
	u8 config_type;
	u8 array_type;
	u8 mics_count;
	struct acpi_nhlt_vendor_mic_config mics[0];
};

union acpi_nhlt_device_config {
	u8 virtual_slot;
	struct acpi_nhlt_gendevice_config gen;
	struct acpi_nhlt_micdevice_config mic;
	struct acpi_nhlt_vendor_micdevice_config vendor_mic;
};

struct acpi_nhlt_endpoint {
	u32 length;
	u8 link_type;
	u8 instance_id;
	u16 vendor_id;
	u16 device_id;
	u16 revision_id;
	u32 subsystem_id;
	u8 device_type;
	u8 direction;
	u8 virtual_bus_id;
} __attribute__((packed));

struct acpi_nhlt_wave_formatext {
	u16 format_tag;
	u16 channel_count;
	u32 samples_per_sec;
	u32 avg_bytes_per_sec;
	u16 block_align;
	u16 bits_per_sample;
	u16 extra_format_size;
	u16 valid_bits_per_sample;
	u32 channel_mask;
	u8 subformat[16];
};

struct acpi_nhlt_format_config {
	struct acpi_nhlt_wave_formatext format;
	struct acpi_nhlt_config config;
};

struct acpi_nhlt_formats_config {
	u8 formats_count;
	struct acpi_nhlt_format_config formats[0];
} __attribute__((packed));

union acpi_object {
	acpi_object_type type;
	struct {
		acpi_object_type type;
		u64 value;
	} integer;
	struct {
		acpi_object_type type;
		u32 length;
		char *pointer;
	} string;
	struct {
		acpi_object_type type;
		u32 length;
		u8 *pointer;
	} buffer;
	struct {
		acpi_object_type type;
		u32 count;
		union acpi_object *elements;
	} package;
	struct {
		acpi_object_type type;
		acpi_object_type actual_type;
		acpi_handle handle;
	} reference;
	struct {
		acpi_object_type type;
		u32 proc_id;
		acpi_io_address pblk_address;
		u32 pblk_length;
	} processor;
	struct {
		acpi_object_type type;
		u32 system_level;
		u32 resource_order;
	} power_resource;
};

struct acpi_object_list {
	u32 count;
	union acpi_object *pointer;
};

struct acpi_offsets {
	size_t offset;
	u8 mode;
};

struct acpi_opcode_info {
	u32 parse_args;
	u32 runtime_args;
	u16 flags;
	u8 object_type;
	u8 class;
	u8 type;
};

typedef void (*acpi_osd_exec_callback)(void *);

struct acpi_os_dpc {
	acpi_osd_exec_callback function;
	void *context;
	struct work_struct work;
};

struct acpi_osc_context {
	char *uuid_str;
	int rev;
	struct acpi_buffer cap;
	struct acpi_buffer ret;
};

struct acpi_osi_config {
	u8 default_disabling;
	unsigned int linux_enable: 1;
	unsigned int linux_dmi: 1;
	unsigned int linux_cmdline: 1;
	unsigned int darwin_enable: 1;
	unsigned int darwin_dmi: 1;
	unsigned int darwin_cmdline: 1;
};

struct acpi_osi_entry {
	char string[64];
	bool enable;
};

struct acpi_package_info {
	u8 type;
	u8 object_type1;
	u8 count1;
	u8 object_type2;
	u8 count2;
	u16 reserved;
} __attribute__((packed));

struct acpi_package_info2 {
	u8 type;
	u8 count;
	u8 object_type[4];
	u8 reserved;
};

struct acpi_package_info3 {
	u8 type;
	u8 count;
	u8 object_type[2];
	u8 tail_object_type;
	u16 reserved;
} __attribute__((packed));

struct acpi_package_info4 {
	u8 type;
	u8 object_type1;
	u8 count1;
	u8 sub_object_types;
	u8 pkg_count;
	u16 reserved;
} __attribute__((packed));

struct acpi_parse_state {
	u8 *aml_start;
	u8 *aml;
	u8 *aml_end;
	u8 *pkg_start;
	u8 *pkg_end;
	union acpi_parse_object *start_op;
	struct acpi_namespace_node *start_node;
	union acpi_generic_state *scope;
	union acpi_parse_object *start_scope;
	u32 aml_size;
};

struct acpi_pcc_info {
	u8 subspace_id;
	u16 length;
	u8 *internal_buffer;
};

struct acpi_pci_device {
	acpi_handle device;
	struct acpi_pci_device *next;
};

struct acpi_pci_id {
	u16 segment;
	u16 bus;
	u16 device;
	u16 function;
};

struct acpi_pci_link_irq {
	u32 active;
	u8 triggering;
	u8 polarity;
	u8 resource_type;
	u8 possible_count;
	u32 possible[16];
	u8 initialized: 1;
	u8 reserved: 7;
};

struct acpi_pci_link {
	struct list_head list;
	struct acpi_device *device;
	struct acpi_pci_link_irq irq;
	int refcnt;
};

struct resource {
	resource_size_t start;
	resource_size_t end;
	const char *name;
	long unsigned int flags;
	long unsigned int desc;
	struct resource *parent;
	struct resource *sibling;
	struct resource *child;
};

struct pci_bus;

struct acpi_pci_root {
	struct acpi_device *device;
	struct pci_bus *bus;
	u16 segment;
	int bridge_type;
	struct resource secondary;
	u32 osc_support_set;
	u32 osc_control_set;
	u32 osc_ext_support_set;
	u32 osc_ext_control_set;
	phys_addr_t mcfg_addr;
};

struct acpi_pci_root_ops;

struct acpi_pci_root_info {
	struct acpi_pci_root *root;
	struct acpi_device *bridge;
	struct acpi_pci_root_ops *ops;
	struct list_head resources;
	char name[16];
};

struct pci_ops;

struct acpi_pci_root_ops {
	struct pci_ops *pci_ops;
	int (*init_info)(struct acpi_pci_root_info *);
	void (*release_info)(struct acpi_pci_root_info *);
	int (*prepare_resources)(struct acpi_pci_root_info *);
};

struct acpi_pci_routing_table {
	u32 length;
	u32 pin;
	u64 address;
	u32 source_index;
	union {
		char pad[4];
		struct {
			struct {} __Empty_source;
			char source[0];
		};
	};
};

struct pci_slot;

struct acpi_pci_slot {
	struct pci_slot *pci_slot;
	struct list_head list;
};

struct acpi_pct_register {
	u8 descriptor;
	u16 length;
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 reserved;
	u64 address;
} __attribute__((packed));

struct acpi_pkg_info {
	u8 *free_space;
	acpi_size length;
	u32 object_space;
	u32 num_packages;
};

struct acpi_platform_list {
	char oem_id[7];
	char oem_table_id[9];
	u32 oem_revision;
	char *table;
	enum acpi_predicate pred;
	char *reason;
	u32 data;
};

struct acpi_pld_info {
	u8 revision;
	u8 ignore_color;
	u8 red;
	u8 green;
	u8 blue;
	u16 width;
	u16 height;
	u8 user_visible;
	u8 dock;
	u8 lid;
	u8 panel;
	u8 vertical_position;
	u8 horizontal_position;
	u8 shape;
	u8 group_orientation;
	u8 group_token;
	u8 group_position;
	u8 bay;
	u8 ejectable;
	u8 ospm_eject_required;
	u8 cabinet_number;
	u8 card_cage_number;
	u8 reference;
	u8 rotation;
	u8 order;
	u8 reserved;
	u16 vertical_offset;
	u16 horizontal_offset;
};

struct acpi_port_info {
	char *name;
	u16 start;
	u16 end;
	u8 osi_dependency;
};

struct acpi_power_dependent_device {
	struct device *dev;
	struct list_head node;
};

struct acpi_power_register {
	u8 descriptor;
	u16 length;
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed));

struct acpi_power_resource {
	struct acpi_device device;
	struct list_head list_node;
	u32 system_level;
	u32 order;
	unsigned int ref_count;
	u8 state;
	struct mutex resource_lock;
	struct list_head dependents;
};

struct acpi_power_resource_entry {
	struct list_head node;
	struct acpi_power_resource *resource;
};

struct acpi_pptt_cache {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 flags;
	u32 next_level_of_cache;
	u32 size;
	u32 number_of_sets;
	u8 associativity;
	u8 attributes;
	u16 line_size;
};

struct acpi_pptt_cache_v1 {
	u32 cache_id;
};

struct acpi_pptt_processor {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 flags;
	u32 parent;
	u32 acpi_processor_id;
	u32 number_of_priv_resources;
};

union acpi_predefined_info {
	struct acpi_name_info info;
	struct acpi_package_info ret_info;
	struct acpi_package_info2 ret_info2;
	struct acpi_package_info3 ret_info3;
	struct acpi_package_info4 ret_info4;
};

struct acpi_predefined_names {
	const char *name;
	u8 type;
	char *val;
};

struct acpi_prmt_module_header {
	u16 revision;
	u16 length;
};

struct acpi_probe_entry;

typedef bool (*acpi_probe_entry_validate_subtbl)(struct acpi_subtable_header *, struct acpi_probe_entry *);

struct acpi_table_header;

typedef int (*acpi_tbl_table_handler)(struct acpi_table_header *);

union acpi_subtable_headers;

typedef int (*acpi_tbl_entry_handler)(union acpi_subtable_headers *, const long unsigned int);

struct acpi_probe_entry {
	__u8 id[5];
	__u8 type;
	acpi_probe_entry_validate_subtbl subtable_valid;
	union {
		acpi_tbl_table_handler probe_table;
		acpi_tbl_entry_handler probe_subtbl;
	};
	kernel_ulong_t driver_data;
};

struct acpi_processor_flags {
	u8 power: 1;
	u8 performance: 1;
	u8 throttling: 1;
	u8 limit: 1;
	u8 bm_control: 1;
	u8 bm_check: 1;
	u8 has_cst: 1;
	u8 has_lpi: 1;
	u8 power_setup_done: 1;
	u8 bm_rld_set: 1;
	u8 previously_online: 1;
};

struct acpi_processor_cx {
	u8 valid;
	u8 type;
	u32 address;
	u8 entry_method;
	u8 index;
	u32 latency;
	u8 bm_sts_skip;
	char desc[32];
};

struct acpi_processor_power {
	int count;
	union {
		struct acpi_processor_cx states[8];
		struct acpi_lpi_state lpi_states[8];
	};
	int timer_broadcast_on_state;
};

struct acpi_tsd_package {
	u64 num_entries;
	u64 revision;
	u64 domain;
	u64 coord_type;
	u64 num_processors;
};

struct cpumask {
	long unsigned int bits[4];
};

typedef struct cpumask cpumask_var_t[1];

struct acpi_processor_tx {
	u16 power;
	u16 performance;
};

struct acpi_processor_tx_tss;

struct acpi_processor;

struct acpi_processor_throttling {
	unsigned int state;
	unsigned int platform_limit;
	struct acpi_pct_register control_register;
	struct acpi_pct_register status_register;
	unsigned int state_count;
	struct acpi_processor_tx_tss *states_tss;
	struct acpi_tsd_package domain_info;
	cpumask_var_t shared_cpu_map;
	int (*acpi_processor_get_throttling)(struct acpi_processor *);
	int (*acpi_processor_set_throttling)(struct acpi_processor *, int, bool);
	u32 address;
	u8 duty_offset;
	u8 duty_width;
	u8 tsd_valid_flag;
	unsigned int shared_type;
	struct acpi_processor_tx states[16];
};

struct acpi_processor_lx {
	int px;
	int tx;
};

struct acpi_processor_limit {
	struct acpi_processor_lx state;
	struct acpi_processor_lx thermal;
	struct acpi_processor_lx user;
};

struct plist_node {
	int prio;
	struct list_head prio_list;
	struct list_head node_list;
};

struct freq_constraints;

struct freq_qos_request {
	enum freq_qos_req_type type;
	struct plist_node pnode;
	struct freq_constraints *qos;
};

struct acpi_processor_performance;

struct acpi_processor {
	acpi_handle handle;
	u32 acpi_id;
	phys_cpuid_t phys_id;
	u32 id;
	u32 pblk;
	int performance_platform_limit;
	int throttling_platform_limit;
	struct acpi_processor_flags flags;
	struct acpi_processor_power power;
	struct acpi_processor_performance *performance;
	struct acpi_processor_throttling throttling;
	struct acpi_processor_limit limit;
	struct thermal_cooling_device *cdev;
	struct device *dev;
	struct freq_qos_request perflib_req;
	struct freq_qos_request thermal_req;
};

struct acpi_processor_errata {
	u8 smp;
	struct {
		u8 throttle: 1;
		u8 fdma: 1;
		u8 reserved: 6;
		u32 bmisx;
	} piix4;
};

struct acpi_psd_package {
	u64 num_entries;
	u64 revision;
	u64 domain;
	u64 coord_type;
	u64 num_processors;
};

struct acpi_processor_px;

struct acpi_processor_performance {
	unsigned int state;
	unsigned int platform_limit;
	struct acpi_pct_register control_register;
	struct acpi_pct_register status_register;
	unsigned int state_count;
	struct acpi_processor_px *states;
	struct acpi_psd_package domain_info;
	cpumask_var_t shared_cpu_map;
	unsigned int shared_type;
};

struct acpi_processor_px {
	u64 core_frequency;
	u64 power;
	u64 transition_latency;
	u64 bus_master_latency;
	u64 control;
	u64 status;
};

struct acpi_processor_throttling_arg {
	struct acpi_processor *pr;
	int target_state;
	bool force;
};

struct acpi_processor_tx_tss {
	u64 freqpercentage;
	u64 power;
	u64 transition_latency;
	u64 control;
	u64 status;
};

struct acpi_prt_entry {
	struct acpi_pci_id id;
	u8 pin;
	acpi_handle link;
	u32 index;
};

struct acpi_reg_walk_info {
	u32 function;
	u32 reg_run_count;
	acpi_adr_space_type space_id;
};

typedef acpi_status (*acpi_repair_function)(struct acpi_evaluate_info *, union acpi_operand_object **);

struct acpi_repair_info {
	char name[4];
	acpi_repair_function repair_function;
};

struct acpi_resource_irq {
	u8 descriptor_length;
	u8 triggering;
	u8 polarity;
	u8 shareable;
	u8 wake_capable;
	u8 interrupt_count;
	union {
		u8 interrupt;
		struct {
			struct {} __Empty_interrupts;
			u8 interrupts[0];
		};
	};
};

struct acpi_resource_dma {
	u8 type;
	u8 bus_master;
	u8 transfer;
	u8 channel_count;
	union {
		u8 channel;
		struct {
			struct {} __Empty_channels;
			u8 channels[0];
		};
	};
};

struct acpi_resource_start_dependent {
	u8 descriptor_length;
	u8 compatibility_priority;
	u8 performance_robustness;
};

struct acpi_resource_io {
	u8 io_decode;
	u8 alignment;
	u8 address_length;
	u16 minimum;
	u16 maximum;
} __attribute__((packed));

struct acpi_resource_fixed_io {
	u16 address;
	u8 address_length;
} __attribute__((packed));

struct acpi_resource_fixed_dma {
	u16 request_lines;
	u16 channels;
	u8 width;
} __attribute__((packed));

struct acpi_resource_vendor {
	u16 byte_length;
	u8 byte_data[0];
};

struct acpi_resource_vendor_typed {
	u16 byte_length;
	u8 uuid_subtype;
	u8 uuid[16];
	u8 byte_data[0];
} __attribute__((packed));

struct acpi_resource_end_tag {
	u8 checksum;
};

struct acpi_resource_memory24 {
	u8 write_protect;
	u16 minimum;
	u16 maximum;
	u16 alignment;
	u16 address_length;
} __attribute__((packed));

struct acpi_resource_memory32 {
	u8 write_protect;
	u32 minimum;
	u32 maximum;
	u32 alignment;
	u32 address_length;
} __attribute__((packed));

struct acpi_resource_fixed_memory32 {
	u8 write_protect;
	u32 address;
	u32 address_length;
} __attribute__((packed));

union acpi_resource_attribute {
	struct acpi_memory_attribute mem;
	struct acpi_io_attribute io;
	u8 type_specific;
};

struct acpi_resource_source {
	u8 index;
	u16 string_length;
	char *string_ptr;
} __attribute__((packed));

struct acpi_resource_address16 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address16_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_address32 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address32_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_address64 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address64_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_extended_address64 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	u8 revision_ID;
	struct acpi_address64_attribute address;
	u64 type_specific;
} __attribute__((packed));

struct acpi_resource_extended_irq {
	u8 producer_consumer;
	u8 triggering;
	u8 polarity;
	u8 shareable;
	u8 wake_capable;
	u8 interrupt_count;
	struct acpi_resource_source resource_source;
	union {
		u32 interrupt;
		struct {
			struct {} __Empty_interrupts;
			u32 interrupts[0];
		};
	};
} __attribute__((packed));

struct acpi_resource_generic_register {
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed));

struct acpi_resource_gpio {
	u8 revision_id;
	u8 connection_type;
	u8 producer_consumer;
	u8 pin_config;
	u8 shareable;
	u8 wake_capable;
	u8 io_restriction;
	u8 triggering;
	u8 polarity;
	u16 drive_strength;
	u16 debounce_timeout;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_i2c_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 access_mode;
	u16 slave_address;
	u32 connection_speed;
} __attribute__((packed));

struct acpi_resource_spi_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 wire_mode;
	u8 device_polarity;
	u8 data_bit_length;
	u8 clock_phase;
	u8 clock_polarity;
	u16 device_selection;
	u32 connection_speed;
} __attribute__((packed));

struct acpi_resource_uart_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 endian;
	u8 data_bits;
	u8 stop_bits;
	u8 flow_control;
	u8 parity;
	u8 lines_enabled;
	u16 rx_fifo_size;
	u16 tx_fifo_size;
	u32 default_baud_rate;
} __attribute__((packed));

struct acpi_resource_csi2_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 local_port_instance;
	u8 phy_type;
} __attribute__((packed));

struct acpi_resource_common_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_function {
	u8 revision_id;
	u8 pin_config;
	u8 shareable;
	u16 function_number;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_config {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_label {
	u16 string_length;
	char *string_ptr;
} __attribute__((packed));

struct acpi_resource_pin_group {
	u8 revision_id;
	u8 producer_consumer;
	u16 pin_table_length;
	u16 vendor_length;
	u16 *pin_table;
	struct acpi_resource_label resource_label;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_group_function {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u16 function_number;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	struct acpi_resource_label resource_source_label;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_group_config {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	struct acpi_resource_label resource_source_label;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_clock_input {
	u8 revision_id;
	u8 mode;
	u8 scale;
	u16 frequency_divisor;
	u32 frequency_numerator;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_address {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
};

union acpi_resource_data {
	struct acpi_resource_irq irq;
	struct acpi_resource_dma dma;
	struct acpi_resource_start_dependent start_dpf;
	struct acpi_resource_io io;
	struct acpi_resource_fixed_io fixed_io;
	struct acpi_resource_fixed_dma fixed_dma;
	struct acpi_resource_vendor vendor;
	struct acpi_resource_vendor_typed vendor_typed;
	struct acpi_resource_end_tag end_tag;
	struct acpi_resource_memory24 memory24;
	struct acpi_resource_memory32 memory32;
	struct acpi_resource_fixed_memory32 fixed_memory32;
	struct acpi_resource_address16 address16;
	struct acpi_resource_address32 address32;
	struct acpi_resource_address64 address64;
	struct acpi_resource_extended_address64 ext_address64;
	struct acpi_resource_extended_irq extended_irq;
	struct acpi_resource_generic_register generic_reg;
	struct acpi_resource_gpio gpio;
	struct acpi_resource_i2c_serialbus i2c_serial_bus;
	struct acpi_resource_spi_serialbus spi_serial_bus;
	struct acpi_resource_uart_serialbus uart_serial_bus;
	struct acpi_resource_csi2_serialbus csi2_serial_bus;
	struct acpi_resource_common_serialbus common_serial_bus;
	struct acpi_resource_pin_function pin_function;
	struct acpi_resource_pin_config pin_config;
	struct acpi_resource_pin_group pin_group;
	struct acpi_resource_pin_group_function pin_group_function;
	struct acpi_resource_pin_group_config pin_group_config;
	struct acpi_resource_clock_input clock_input;
	struct acpi_resource_address address;
};

struct acpi_resource {
	u32 type;
	u32 length;
	union acpi_resource_data data;
};

struct acpi_rsconvert_info {
	u8 opcode;
	u8 resource_offset;
	u8 aml_offset;
	u8 value;
};

struct acpi_rw_lock {
	void *writer_mutex;
	void *reader_mutex;
	u32 num_readers;
};

struct acpi_scan_clear_dep_work {
	struct work_struct work;
	struct acpi_device *adev;
};

struct acpi_scan_handler {
	struct list_head list_node;
	const struct acpi_device_id *ids;
	bool (*match)(const char *, const struct acpi_device_id **);
	int (*attach)(struct acpi_device *, const struct acpi_device_id *);
	void (*detach)(struct acpi_device *);
	void (*post_eject)(struct acpi_device *);
	void (*bind)(struct device *);
	void (*unbind)(struct device *);
	struct acpi_hotplug_profile hotplug;
};

typedef u32 (*acpi_sci_handler)(void *);

struct acpi_sci_handler_info {
	struct acpi_sci_handler_info *next;
	acpi_sci_handler address;
	void *context;
};

struct acpi_signal_fatal_info {
	u32 type;
	u32 code;
	u32 argument;
};

typedef acpi_status (*acpi_object_converter)(struct acpi_namespace_node *, union acpi_operand_object *, union acpi_operand_object **);

struct acpi_simple_repair_info {
	char name[4];
	u32 unexpected_btypes;
	u32 package_index;
	acpi_object_converter object_converter;
};

struct spi_controller;

struct acpi_spi_lookup {
	struct spi_controller *ctlr;
	u32 max_speed_hz;
	u32 mode;
	int irq;
	u8 bits_per_word;
	u8 chip_select;
	int n;
	int index;
};

struct acpi_srat_cpu_affinity {
	struct acpi_subtable_header header;
	u8 proximity_domain_lo;
	u8 apic_id;
	u32 flags;
	u8 local_sapic_eid;
	u8 proximity_domain_hi[3];
	u32 clock_domain;
};

struct acpi_srat_generic_affinity {
	struct acpi_subtable_header header;
	u8 reserved;
	u8 device_handle_type;
	u32 proximity_domain;
	u8 device_handle[16];
	u32 flags;
	u32 reserved1;
};

struct acpi_srat_gicc_affinity {
	struct acpi_subtable_header header;
	u32 proximity_domain;
	u32 acpi_processor_uid;
	u32 flags;
	u32 clock_domain;
} __attribute__((packed));

struct acpi_srat_mem_affinity {
	struct acpi_subtable_header header;
	u32 proximity_domain;
	u16 reserved;
	u64 base_address;
	u64 length;
	u32 reserved1;
	u32 flags;
	u64 reserved2;
} __attribute__((packed));

struct acpi_srat_rintc_affinity {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 proximity_domain;
	u32 acpi_processor_uid;
	u32 flags;
	u32 clock_domain;
};

struct acpi_srat_x2apic_cpu_affinity {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 proximity_domain;
	u32 apic_id;
	u32 flags;
	u32 clock_domain;
	u32 reserved2;
};

struct acpi_subtable_entry {
	union acpi_subtable_headers *hdr;
	enum acpi_subtable_type type;
};

union acpi_subtable_headers {
	struct acpi_subtable_header common;
	struct acpi_hmat_structure hmat;
	struct acpi_prmt_module_header prmt;
	struct acpi_cedt_header cedt;
	struct acpi_cdat_header cdat;
};

typedef int (*acpi_tbl_entry_handler_arg)(union acpi_subtable_headers *, void *, const long unsigned int);

struct acpi_subtable_proc {
	int id;
	acpi_tbl_entry_handler handler;
	acpi_tbl_entry_handler_arg handler_arg;
	void *arg;
	int count;
};

struct acpi_table_attr {
	struct bin_attribute attr;
	char name[4];
	int instance;
	char filename[8];
	struct list_head node;
};

struct acpi_table_header {
	char signature[4];
	u32 length;
	u8 revision;
	u8 checksum;
	char oem_id[6];
	char oem_table_id[8];
	u32 oem_revision;
	char asl_compiler_id[4];
	u32 asl_compiler_revision;
};

struct acpi_table_bert {
	struct acpi_table_header header;
	u32 region_length;
	u64 address;
};

struct acpi_table_bgrt {
	struct acpi_table_header header;
	u16 version;
	u8 status;
	u8 image_type;
	u64 image_address;
	u32 image_offset_x;
	u32 image_offset_y;
};

struct acpi_table_ccel {
	struct acpi_table_header header;
	u8 CCtype;
	u8 Ccsub_type;
	u16 reserved;
	u64 log_area_minimum_length;
	u64 log_area_start_address;
};

struct acpi_table_cdat {
	u32 length;
	u8 revision;
	u8 checksum;
	u8 reserved[6];
	u32 sequence;
};

struct acpi_table_csrt {
	struct acpi_table_header header;
};

struct acpi_table_desc {
	acpi_physical_address address;
	struct acpi_table_header *pointer;
	u32 length;
	union acpi_name_union signature;
	acpi_owner_id owner_id;
	u8 flags;
	u16 validation_count;
};

struct acpi_table_ecdt {
	struct acpi_table_header header;
	struct acpi_generic_address control;
	struct acpi_generic_address data;
	u32 uid;
	u8 gpe;
	u8 id[0];
} __attribute__((packed));

struct acpi_table_facs {
	char signature[4];
	u32 length;
	u32 hardware_signature;
	u32 firmware_waking_vector;
	u32 global_lock;
	u32 flags;
	u64 xfirmware_waking_vector;
	u8 version;
	u8 reserved[3];
	u32 ospm_flags;
	u8 reserved1[24];
};

struct acpi_table_fadt {
	struct acpi_table_header header;
	u32 facs;
	u32 dsdt;
	u8 model;
	u8 preferred_profile;
	u16 sci_interrupt;
	u32 smi_command;
	u8 acpi_enable;
	u8 acpi_disable;
	u8 s4_bios_request;
	u8 pstate_control;
	u32 pm1a_event_block;
	u32 pm1b_event_block;
	u32 pm1a_control_block;
	u32 pm1b_control_block;
	u32 pm2_control_block;
	u32 pm_timer_block;
	u32 gpe0_block;
	u32 gpe1_block;
	u8 pm1_event_length;
	u8 pm1_control_length;
	u8 pm2_control_length;
	u8 pm_timer_length;
	u8 gpe0_block_length;
	u8 gpe1_block_length;
	u8 gpe1_base;
	u8 cst_control;
	u16 c2_latency;
	u16 c3_latency;
	u16 flush_size;
	u16 flush_stride;
	u8 duty_offset;
	u8 duty_width;
	u8 day_alarm;
	u8 month_alarm;
	u8 century;
	u16 boot_flags;
	u8 reserved;
	u32 flags;
	struct acpi_generic_address reset_register;
	u8 reset_value;
	u16 arm_boot_flags;
	u8 minor_revision;
	u64 Xfacs;
	u64 Xdsdt;
	struct acpi_generic_address xpm1a_event_block;
	struct acpi_generic_address xpm1b_event_block;
	struct acpi_generic_address xpm1a_control_block;
	struct acpi_generic_address xpm1b_control_block;
	struct acpi_generic_address xpm2_control_block;
	struct acpi_generic_address xpm_timer_block;
	struct acpi_generic_address xgpe0_block;
	struct acpi_generic_address xgpe1_block;
	struct acpi_generic_address sleep_control;
	struct acpi_generic_address sleep_status;
	u64 hypervisor_id;
} __attribute__((packed));

struct acpi_table_list {
	struct acpi_table_desc *tables;
	u32 current_table_count;
	u32 max_table_count;
	u8 flags;
};

struct acpi_table_madt {
	struct acpi_table_header header;
	u32 address;
	u32 flags;
};

struct acpi_table_mcfg {
	struct acpi_table_header header;
	u8 reserved[8];
};

struct acpi_table_nhlt {
	struct acpi_table_header header;
	u8 endpoints_count;
} __attribute__((packed));

struct acpi_table_rsdp {
	char signature[8];
	u8 checksum;
	char oem_id[6];
	u8 revision;
	u32 rsdt_physical_address;
	u32 length;
	u64 xsdt_physical_address;
	u8 extended_checksum;
	u8 reserved[3];
} __attribute__((packed));

struct acpi_table_slit {
	struct acpi_table_header header;
	u64 locality_count;
	u8 entry[0];
} __attribute__((packed));

struct acpi_table_spcr {
	struct acpi_table_header header;
	u8 interface_type;
	u8 reserved[3];
	struct acpi_generic_address serial_port;
	u8 interrupt_type;
	u8 pc_interrupt;
	u32 interrupt;
	u8 baud_rate;
	u8 parity;
	u8 stop_bits;
	u8 flow_control;
	u8 terminal_type;
	u8 language;
	u16 pci_device_id;
	u16 pci_vendor_id;
	u8 pci_bus;
	u8 pci_device;
	u8 pci_function;
	u32 pci_flags;
	u8 pci_segment;
	u32 uart_clk_freq;
	u32 precise_baudrate;
	u16 name_space_string_length;
	u16 name_space_string_offset;
	char name_space_string[0];
} __attribute__((packed));

struct acpi_table_srat {
	struct acpi_table_header header;
	u32 table_revision;
	u64 reserved;
};

struct acpi_table_stao {
	struct acpi_table_header header;
	u8 ignore_uart;
} __attribute__((packed));

struct acpi_tad_driver_data {
	u32 capabilities;
};

struct acpi_tad_rt {
	u16 year;
	u8 month;
	u8 day;
	u8 hour;
	u8 minute;
	u8 second;
	u8 valid;
	u16 msec;
	s16 tz;
	u8 daylight;
	u8 padding[3];
};

struct acpi_thermal_trip {
	long unsigned int temp_dk;
	struct acpi_handle_list devices;
};

struct acpi_thermal_passive {
	struct acpi_thermal_trip trip;
	long unsigned int tc1;
	long unsigned int tc2;
	long unsigned int delay;
};

struct acpi_thermal_active {
	struct acpi_thermal_trip trip;
};

struct acpi_thermal_trips {
	struct acpi_thermal_passive passive;
	struct acpi_thermal_active active[10];
};

struct thermal_zone_device;

struct acpi_thermal {
	struct acpi_device *device;
	acpi_bus_id name;
	long unsigned int temp_dk;
	long unsigned int last_temp_dk;
	long unsigned int polling_frequency;
	volatile u8 zombie;
	struct acpi_thermal_trips trips;
	struct thermal_zone_device *thermal_zone;
	int kelvin_offset;
	struct work_struct thermal_check_work;
	struct mutex thermal_check_lock;
	refcount_t thermal_check_count;
};

struct acpi_vector_group {
	int node;
	int pci_segment;
	struct irq_domain *parent;
};

struct acpi_vendor_uuid {
	u8 subtype;
	u8 data[16];
};

struct acpi_vendor_walk_info {
	struct acpi_vendor_uuid *uuid;
	struct acpi_buffer *buffer;
	acpi_status status;
};

struct acpi_wakeup_handler {
	struct list_head list_node;
	bool (*wakeup)(void *);
	void *context;
};

typedef acpi_status (*acpi_parse_downwards)(struct acpi_walk_state *, union acpi_parse_object **);

typedef acpi_status (*acpi_parse_upwards)(struct acpi_walk_state *);

struct acpi_walk_state {
	struct acpi_walk_state *next;
	u8 descriptor_type;
	u8 walk_type;
	u16 opcode;
	u8 next_op_info;
	u8 num_operands;
	u8 operand_index;
	acpi_owner_id owner_id;
	u8 last_predicate;
	u8 current_result;
	u8 return_used;
	u8 scope_depth;
	u8 pass_number;
	u8 namespace_override;
	u8 result_size;
	u8 result_count;
	u8 *aml;
	u32 arg_types;
	u32 method_breakpoint;
	u32 user_breakpoint;
	u32 parse_flags;
	struct acpi_parse_state parser_state;
	u32 prev_arg_types;
	u32 arg_count;
	u16 method_nesting_depth;
	u8 method_is_nested;
	struct acpi_namespace_node arguments[7];
	struct acpi_namespace_node local_variables[8];
	union acpi_operand_object *operands[9];
	union acpi_operand_object **params;
	u8 *aml_last_while;
	union acpi_operand_object **caller_return_desc;
	union acpi_generic_state *control_state;
	struct acpi_namespace_node *deferred_node;
	union acpi_operand_object *implicit_return_obj;
	struct acpi_namespace_node *method_call_node;
	union acpi_parse_object *method_call_op;
	union acpi_operand_object *method_desc;
	struct acpi_namespace_node *method_node;
	char *method_pathname;
	union acpi_parse_object *op;
	const struct acpi_opcode_info *op_info;
	union acpi_parse_object *origin;
	union acpi_operand_object *result_obj;
	union acpi_generic_state *results;
	union acpi_operand_object *return_desc;
	union acpi_generic_state *scope_info;
	union acpi_parse_object *prev_op;
	union acpi_parse_object *next_op;
	struct acpi_thread_state *thread;
	acpi_parse_downwards descending_callback;
	acpi_parse_upwards ascending_callback;
};

struct pnp_dev;

struct acpipnp_parse_option_s {
	struct pnp_dev *dev;
	unsigned int option_flags;
};

struct action_cache {
	long unsigned int allow_native[8];
};

struct action_devres {
	void *data;
	void (*action)(void *);
};

struct action_gate_entry {
	u8 gate_state;
	u32 interval;
	s32 ipv;
	s32 maxoctets;
};

struct action_ops {
	int (*pre_action)(struct snd_pcm_substream *, snd_pcm_state_t);
	int (*do_action)(struct snd_pcm_substream *, snd_pcm_state_t);
	void (*undo_action)(struct snd_pcm_substream *, snd_pcm_state_t);
	void (*post_action)(struct snd_pcm_substream *, snd_pcm_state_t);
};

struct irq_poll;

typedef int irq_poll_fn(struct irq_poll *, int);

struct irq_poll {
	struct list_head list;
	long unsigned int state;
	int weight;
	irq_poll_fn *poll;
};

struct adapter_reply_queue {
	struct MPT3SAS_ADAPTER *ioc;
	u8 msix_index;
	u32 reply_post_host_index;
	Mpi2ReplyDescriptorsUnion_t *reply_post_free;
	char name[32];
	atomic_t busy;
	u32 os_irq;
	struct irq_poll irqpoll;
	bool irq_poll_scheduled;
	bool irq_line_enable;
	bool is_iouring_poll_q;
	struct list_head list;
};

struct rw_semaphore {
	atomic_long_t count;
	atomic_long_t owner;
	struct optimistic_spin_queue osq;
	raw_spinlock_t wait_lock;
	struct list_head wait_list;
};

struct rb_root_cached {
	struct rb_root rb_root;
	struct rb_node *rb_leftmost;
};

struct address_space_operations;

struct address_space {
	struct inode *host;
	struct xarray i_pages;
	struct rw_semaphore invalidate_lock;
	gfp_t gfp_mask;
	atomic_t i_mmap_writable;
	struct rb_root_cached i_mmap;
	long unsigned int nrpages;
	long unsigned int writeback_index;
	const struct address_space_operations *a_ops;
	long unsigned int flags;
	errseq_t wb_err;
	spinlock_t i_private_lock;
	struct list_head i_private_list;
	struct rw_semaphore i_mmap_rwsem;
	void *i_private_data;
};

struct page;

struct writeback_control;

struct readahead_control;

struct kiocb;

struct iov_iter;

struct swap_info_struct;

struct address_space_operations {
	int (*writepage)(struct page *, struct writeback_control *);
	int (*read_folio)(struct file *, struct folio *);
	int (*writepages)(struct address_space *, struct writeback_control *);
	bool (*dirty_folio)(struct address_space *, struct folio *);
	void (*readahead)(struct readahead_control *);
	int (*write_begin)(struct file *, struct address_space *, loff_t, unsigned int, struct folio **, void **);
	int (*write_end)(struct file *, struct address_space *, loff_t, unsigned int, unsigned int, struct folio *, void *);
	sector_t (*bmap)(struct address_space *, sector_t);
	void (*invalidate_folio)(struct folio *, size_t, size_t);
	bool (*release_folio)(struct folio *, gfp_t);
	void (*free_folio)(struct folio *);
	ssize_t (*direct_IO)(struct kiocb *, struct iov_iter *);
	int (*migrate_folio)(struct address_space *, struct folio *, struct folio *, enum migrate_mode);
	int (*launder_folio)(struct folio *);
	bool (*is_partially_uptodate)(struct folio *, size_t, size_t);
	void (*is_dirty_writeback)(struct folio *, bool *, bool *);
	int (*error_remove_folio)(struct address_space *, struct folio *);
	int (*swap_activate)(struct swap_info_struct *, struct file *, sector_t *);
	void (*swap_deactivate)(struct file *);
	int (*swap_rw)(struct kiocb *, struct iov_iter *);
};

struct adjust_trip_data {
	struct acpi_thermal *tz;
	u32 event;
};

struct advisor_ctx {
	ktime_t start_scan;
	long unsigned int scan_time;
	long unsigned int change;
	long long unsigned int cpu_time;
};

struct crypto_aead;

struct aead_request;

struct aead_alg {
	int (*setkey)(struct crypto_aead *, const u8 *, unsigned int);
	int (*setauthsize)(struct crypto_aead *, unsigned int);
	int (*encrypt)(struct aead_request *);
	int (*decrypt)(struct aead_request *);
	int (*init)(struct crypto_aead *);
	void (*exit)(struct crypto_aead *);
	unsigned int ivsize;
	unsigned int maxauthsize;
	unsigned int chunksize;
	struct crypto_alg base;
};

struct crypto_template;

struct crypto_spawn;

struct crypto_instance {
	struct crypto_alg alg;
	struct crypto_template *tmpl;
	union {
		struct hlist_node list;
		struct crypto_spawn *spawns;
	};
	struct work_struct free_work;
	void *__ctx[0];
};

struct aead_instance {
	void (*free)(struct aead_instance *);
	union {
		struct {
			char head[64];
			struct crypto_instance base;
		} s;
		struct aead_alg alg;
	};
};

struct aead_request {
	struct crypto_async_request base;
	unsigned int assoclen;
	unsigned int cryptlen;
	u8 *iv;
	struct scatterlist *src;
	struct scatterlist *dst;
	void *__ctx[0];
};

struct aead_testvec;

struct aead_test_suite {
	const struct aead_testvec *vecs;
	unsigned int count;
	unsigned int einval_allowed: 1;
	unsigned int aad_iv: 1;
};

struct aead_testvec {
	const char *key;
	const char *iv;
	const char *ptext;
	const char *assoc;
	const char *ctext;
	unsigned char novrfy;
	unsigned char wk;
	unsigned char klen;
	unsigned int plen;
	unsigned int clen;
	unsigned int alen;
	int setkey_error;
	int setauthsize_error;
	int crypt_error;
};

struct pcie_tlp_log {
	u32 dw[4];
	u32 prefix[4];
};

struct aer_capability_regs {
	u32 header;
	u32 uncor_status;
	u32 uncor_mask;
	u32 uncor_severity;
	u32 cor_status;
	u32 cor_mask;
	u32 cap_control;
	struct pcie_tlp_log header_log;
	u32 root_command;
	u32 root_status;
	u16 cor_err_source;
	u16 uncor_err_source;
};

struct aer_err_info {
	struct pci_dev *dev[5];
	int error_dev_num;
	unsigned int id: 16;
	unsigned int severity: 2;
	unsigned int __pad1: 5;
	unsigned int multi_error_valid: 1;
	unsigned int first_error: 5;
	unsigned int __pad2: 2;
	unsigned int tlp_header_valid: 1;
	unsigned int status;
	unsigned int mask;
	struct pcie_tlp_log tlp;
};

struct aer_err_source {
	u32 status;
	u32 id;
};

struct aer_rpc {
	struct pci_dev *rpd;
	struct {
		union {
			struct __kfifo kfifo;
			struct aer_err_source *type;
			const struct aer_err_source *const_type;
			char (*rectype)[0];
			struct aer_err_source *ptr;
			const struct aer_err_source *ptr_const;
		};
		struct aer_err_source buf[128];
	} aer_fifo;
};

struct aer_stats {
	u64 dev_cor_errs[16];
	u64 dev_fatal_errs[27];
	u64 dev_nonfatal_errs[27];
	u64 dev_total_cor_errs;
	u64 dev_total_fatal_errs;
	u64 dev_total_nonfatal_errs;
	u64 rootport_total_cor_errs;
	u64 rootport_total_fatal_errs;
	u64 rootport_total_nonfatal_errs;
};

struct affinity_context {
	const struct cpumask *new_mask;
	struct cpumask *user_mask;
	unsigned int flags;
};

struct aggregate_control {
	long int *aggregate;
	long int *local;
	long int *pending;
	long int *ppending;
	long int *cstat;
	long int *cstat_prev;
	int size;
};

struct component_master_ops;

struct component_match;

struct aggregate_device {
	struct list_head node;
	bool bound;
	const struct component_master_ops *ops;
	struct device *parent;
	struct component_match *match;
};

struct xfs_btree_ops;

struct aghdr_init_data {
	xfs_agblock_t agno;
	xfs_extlen_t agsize;
	struct list_head buffer_list;
	xfs_rfsblock_t nfree;
	xfs_daddr_t daddr;
	size_t numblks;
	const struct xfs_btree_ops *bc_ops;
};

struct hash_alg_common {
	unsigned int digestsize;
	unsigned int statesize;
	struct crypto_alg base;
};

struct ahash_request;

struct crypto_ahash;

struct ahash_alg {
	int (*init)(struct ahash_request *);
	int (*update)(struct ahash_request *);
	int (*final)(struct ahash_request *);
	int (*finup)(struct ahash_request *);
	int (*digest)(struct ahash_request *);
	int (*export)(struct ahash_request *, void *);
	int (*import)(struct ahash_request *, const void *);
	int (*setkey)(struct crypto_ahash *, const u8 *, unsigned int);
	int (*init_tfm)(struct crypto_ahash *);
	void (*exit_tfm)(struct crypto_ahash *);
	int (*clone_tfm)(struct crypto_ahash *, struct crypto_ahash *);
	struct hash_alg_common halg;
};

struct ahash_instance {
	void (*free)(struct ahash_instance *);
	union {
		struct {
			char head[96];
			struct crypto_instance base;
		} s;
		struct ahash_alg alg;
	};
};

struct ahash_request {
	struct crypto_async_request base;
	unsigned int nbytes;
	struct scatterlist *src;
	u8 *result;
	void *priv;
	void *__ctx[0];
};

struct ahci_cmd_hdr {
	__le32 opts;
	__le32 status;
	__le32 tbl_addr;
	__le32 tbl_addr_hi;
	__le32 reserved[4];
};

struct ahci_dwc_plat_data;

struct platform_device;

struct ahci_dwc_host_priv {
	const struct ahci_dwc_plat_data *pdata;
	struct platform_device *pdev;
	u32 timv;
	u32 dmacr[32];
};

struct ahci_host_priv;

struct ahci_dwc_plat_data {
	unsigned int pflags;
	unsigned int hflags;
	int (*init)(struct ahci_host_priv *);
	int (*reinit)(struct ahci_host_priv *);
	void (*clear)(struct ahci_host_priv *);
};

struct ata_link;

struct ahci_em_priv {
	enum sw_activity blink_policy;
	struct timer_list timer;
	long unsigned int saved_activity;
	long unsigned int activity;
	long unsigned int led_state;
	struct ata_link *link;
};

struct regulator;

struct clk_bulk_data;

struct reset_control;

struct phy;

struct ata_port;

struct ata_host;

struct ahci_host_priv {
	unsigned int flags;
	u32 mask_port_map;
	void *mmio;
	u32 cap;
	u32 cap2;
	u32 version;
	u32 port_map;
	u32 saved_cap;
	u32 saved_cap2;
	u32 saved_port_map;
	u32 saved_port_cap[32];
	u32 em_loc;
	u32 em_buf_sz;
	u32 em_msg_type;
	u32 remapped_nvme;
	bool got_runtime_pm;
	unsigned int n_clks;
	struct clk_bulk_data *clks;
	unsigned int f_rsts;
	struct reset_control *rsts;
	struct regulator **target_pwrs;
	struct regulator *ahci_regulator;
	struct regulator *phy_regulator;
	struct phy **phys;
	unsigned int nports;
	void *plat_data;
	unsigned int irq;
	void (*start_engine)(struct ata_port *);
	int (*stop_engine)(struct ata_port *);
	irqreturn_t (*irq_handler)(int, void *);
	int (*get_irq_vector)(struct ata_host *, int);
};

struct ahci_port_priv {
	struct ata_link *active_link;
	struct ahci_cmd_hdr *cmd_slot;
	dma_addr_t cmd_slot_dma;
	void *cmd_tbl;
	dma_addr_t cmd_tbl_dma;
	void *rx_fis;
	dma_addr_t rx_fis_dma;
	unsigned int ncq_saw_d2h: 1;
	unsigned int ncq_saw_dmas: 1;
	unsigned int ncq_saw_sdb: 1;
	spinlock_t lock;
	u32 intr_mask;
	bool fbs_supported;
	bool fbs_enabled;
	int fbs_last_dev;
	struct ahci_em_priv em_priv[15];
	char *irq_desc;
};

struct ahci_sg {
	__le32 addr;
	__le32 addr_hi;
	__le32 reserved;
	__le32 flags_size;
};

struct wait_page_queue;

struct kiocb {
	struct file *ki_filp;
	loff_t ki_pos;
	void (*ki_complete)(struct kiocb *, long int);
	void *private;
	int ki_flags;
	u16 ki_ioprio;
	union {
		struct wait_page_queue *ki_waitq;
		ssize_t (*dio_complete)(void *);
	};
};

struct cred;

struct fsync_iocb {
	struct file *file;
	struct work_struct work;
	bool datasync;
	struct cred *creds;
};

struct wait_queue_entry;

typedef int (*wait_queue_func_t)(struct wait_queue_entry *, unsigned int, int, void *);

struct wait_queue_entry {
	unsigned int flags;
	void *private;
	wait_queue_func_t func;
	struct list_head entry;
};

struct poll_iocb {
	struct file *file;
	struct wait_queue_head *head;
	__poll_t events;
	bool cancelled;
	bool work_scheduled;
	bool work_need_resched;
	struct wait_queue_entry wait;
	struct work_struct work;
};

typedef int kiocb_cancel_fn(struct kiocb *);

struct io_event {
	__u64 data;
	__u64 obj;
	__s64 res;
	__s64 res2;
};

struct kioctx;

struct eventfd_ctx;

struct aio_kiocb {
	union {
		struct file *ki_filp;
		struct kiocb rw;
		struct fsync_iocb fsync;
		struct poll_iocb poll;
	};
	struct kioctx *ki_ctx;
	kiocb_cancel_fn *ki_cancel;
	struct io_event ki_res;
	struct list_head ki_list;
	refcount_t ki_refcnt;
	struct eventfd_ctx *ki_eventfd;
};

struct poll_table_struct;

typedef void (*poll_queue_proc)(struct file *, wait_queue_head_t *, struct poll_table_struct *);

struct poll_table_struct {
	poll_queue_proc _qproc;
	__poll_t _key;
};

struct aio_poll_table {
	struct poll_table_struct pt;
	struct aio_kiocb *iocb;
	bool queued;
	int error;
};

struct aio_ring {
	unsigned int id;
	unsigned int nr;
	unsigned int head;
	unsigned int tail;
	unsigned int magic;
	unsigned int compat_features;
	unsigned int incompat_features;
	unsigned int header_length;
	struct io_event io_events[0];
};

struct aio_waiter {
	struct wait_queue_entry w;
	size_t min_nr;
};

struct akcipher_request;

struct crypto_akcipher;

struct akcipher_alg {
	int (*encrypt)(struct akcipher_request *);
	int (*decrypt)(struct akcipher_request *);
	int (*set_pub_key)(struct crypto_akcipher *, const void *, unsigned int);
	int (*set_priv_key)(struct crypto_akcipher *, const void *, unsigned int);
	unsigned int (*max_size)(struct crypto_akcipher *);
	int (*init)(struct crypto_akcipher *);
	void (*exit)(struct crypto_akcipher *);
	struct crypto_alg base;
};

struct akcipher_instance {
	void (*free)(struct akcipher_instance *);
	union {
		struct {
			char head[56];
			struct crypto_instance base;
		} s;
		struct akcipher_alg alg;
	};
};

struct akcipher_request {
	struct crypto_async_request base;
	struct scatterlist *src;
	struct scatterlist *dst;
	unsigned int src_len;
	unsigned int dst_len;
	void *__ctx[0];
};

struct akcipher_testvec;

struct akcipher_test_suite {
	const struct akcipher_testvec *vecs;
	unsigned int count;
};

struct akcipher_testvec {
	const unsigned char *key;
	const unsigned char *m;
	const unsigned char *c;
	unsigned int key_len;
	unsigned int m_size;
	unsigned int c_size;
	bool public_key_vec;
};

struct alarm {
	struct timerqueue_node node;
	struct hrtimer timer;
	void (*function)(struct alarm *, ktime_t);
	enum alarmtimer_type type;
	int state;
	void *data;
};

struct timerqueue_head {
	struct rb_root_cached rb_root;
};

struct timespec64;

struct alarm_base {
	spinlock_t lock;
	struct timerqueue_head timerqueue;
	ktime_t (*get_ktime)(void);
	void (*get_timespec)(struct timespec64 *);
	clockid_t base_clockid;
};

struct alc298_samsung_amp_desc {
	unsigned char nid;
	short unsigned int init_seq[4];
};

struct alc298_samsung_v2_amp_desc {
	short unsigned int nid;
	int init_seq_size;
	short unsigned int init_seq[36];
};

struct alc_codec_rename_pci_table {
	unsigned int codec_vendor_id;
	short unsigned int pci_subvendor;
	short unsigned int pci_subdevice;
	const char *name;
};

struct alc_codec_rename_table {
	unsigned int vendor_id;
	short unsigned int coef_mask;
	short unsigned int coef_bits;
	const char *name;
};

struct alc_coef_led {
	unsigned int idx;
	unsigned int mask;
	unsigned int on;
	unsigned int off;
};

struct alc_customize_define {
	unsigned int sku_cfg;
	unsigned char port_connectivity;
	unsigned char check_sum;
	unsigned char customization;
	unsigned char external_amp;
	unsigned int enable_pcbeep: 1;
	unsigned int platform_type: 1;
	unsigned int swap: 1;
	unsigned int override: 1;
	unsigned int fixup: 1;
};

struct hda_multi_out {
	int num_dacs;
	const hda_nid_t *dac_nids;
	hda_nid_t hp_nid;
	hda_nid_t hp_out_nid[5];
	hda_nid_t extra_out_nid[5];
	hda_nid_t dig_out_nid;
	const hda_nid_t *follower_dig_outs;
	int max_channels;
	int dig_out_used;
	int no_share_stream;
	int share_spdif;
	unsigned int analog_rates;
	unsigned int analog_maxbps;
	u64 analog_formats;
	unsigned int spdif_rates;
	unsigned int spdif_maxbps;
	u64 spdif_formats;
};

struct hda_input_mux_item {
	char label[32];
	unsigned int index;
};

struct hda_input_mux {
	unsigned int num_items;
	struct hda_input_mux_item items[36];
};

struct auto_pin_cfg_item {
	hda_nid_t pin;
	int type;
	unsigned int is_headset_mic: 1;
	unsigned int is_headphone_mic: 1;
	unsigned int has_boost_on_pin: 1;
	int order;
};

struct auto_pin_cfg {
	int line_outs;
	hda_nid_t line_out_pins[5];
	int speaker_outs;
	hda_nid_t speaker_pins[5];
	int hp_outs;
	int line_out_type;
	hda_nid_t hp_pins[5];
	int num_inputs;
	struct auto_pin_cfg_item inputs[18];
	int dig_outs;
	hda_nid_t dig_out_pins[2];
	hda_nid_t dig_in_pin;
	hda_nid_t mono_out_pin;
	int dig_out_type[2];
	int dig_in_type;
};

struct snd_array {
	unsigned int used;
	unsigned int alloced;
	unsigned int elem_size;
	unsigned int alloc_align;
	void *list;
};

struct automic_entry {
	hda_nid_t pin;
	int idx;
	unsigned int attr;
};

struct snd_kcontrol;

struct hda_codec;

struct hda_vmaster_mute_hook {
	struct snd_kcontrol *sw_kctl;
	void (*hook)(void *, int);
	struct hda_codec *codec;
};

struct hda_amp_list;

struct hda_loopback_check {
	const struct hda_amp_list *amplist;
	int power_on;
};

struct hda_multi_io {
	hda_nid_t pin;
	hda_nid_t dac;
	unsigned int ctl_in;
};

struct hda_pcm_stream;

struct hda_pcm;

struct badness_table;

struct snd_ctl_elem_value;

struct hda_jack_callback;

struct led_classdev;

struct hda_gen_spec {
	char stream_name_analog[32];
	const struct hda_pcm_stream *stream_analog_playback;
	const struct hda_pcm_stream *stream_analog_capture;
	char stream_name_alt_analog[32];
	const struct hda_pcm_stream *stream_analog_alt_playback;
	const struct hda_pcm_stream *stream_analog_alt_capture;
	char stream_name_digital[32];
	const struct hda_pcm_stream *stream_digital_playback;
	const struct hda_pcm_stream *stream_digital_capture;
	unsigned int active_streams;
	struct mutex pcm_mutex;
	struct hda_multi_out multiout;
	hda_nid_t alt_dac_nid;
	hda_nid_t follower_dig_outs[3];
	int dig_out_type;
	unsigned int num_adc_nids;
	hda_nid_t adc_nids[18];
	hda_nid_t dig_in_nid;
	hda_nid_t mixer_nid;
	hda_nid_t mixer_merge_nid;
	const char *input_labels[36];
	int input_label_idxs[36];
	hda_nid_t cur_adc;
	unsigned int cur_adc_stream_tag;
	unsigned int cur_adc_format;
	struct hda_input_mux input_mux;
	unsigned int cur_mux[3];
	int min_channel_count;
	int ext_channel_count;
	int const_channel_count;
	struct hda_pcm *pcm_rec[3];
	struct auto_pin_cfg autocfg;
	struct snd_array kctls;
	hda_nid_t private_dac_nids[5];
	hda_nid_t imux_pins[36];
	unsigned int dyn_adc_idx[36];
	hda_nid_t shared_mic_vref_pin;
	hda_nid_t hp_mic_pin;
	int hp_mic_mux_idx;
	int num_all_dacs;
	hda_nid_t all_dacs[16];
	int num_all_adcs;
	hda_nid_t all_adcs[18];
	struct snd_array paths;
	int out_paths[5];
	int hp_paths[5];
	int speaker_paths[5];
	int aamix_out_paths[3];
	int digout_paths[5];
	int input_paths[648];
	int loopback_paths[36];
	int loopback_merge_path;
	int digin_path;
	int am_num_entries;
	struct automic_entry am_entry[3];
	unsigned int hp_jack_present: 1;
	unsigned int line_jack_present: 1;
	unsigned int speaker_muted: 1;
	unsigned int line_out_muted: 1;
	unsigned int auto_mic: 1;
	unsigned int automute_speaker: 1;
	unsigned int automute_lo: 1;
	unsigned int detect_hp: 1;
	unsigned int detect_lo: 1;
	unsigned int automute_speaker_possible: 1;
	unsigned int automute_lo_possible: 1;
	unsigned int master_mute: 1;
	unsigned int keep_vref_in_automute: 1;
	unsigned int line_in_auto_switch: 1;
	unsigned int auto_mute_via_amp: 1;
	unsigned int suppress_auto_mute: 1;
	unsigned int suppress_auto_mic: 1;
	unsigned int need_dac_fix: 1;
	unsigned int hp_mic: 1;
	unsigned int suppress_hp_mic_detect: 1;
	unsigned int no_primary_hp: 1;
	unsigned int no_multi_io: 1;
	unsigned int multi_cap_vol: 1;
	unsigned int inv_dmic_split: 1;
	unsigned int own_eapd_ctl: 1;
	unsigned int keep_eapd_on: 1;
	unsigned int vmaster_mute_led: 1;
	unsigned int mic_mute_led: 1;
	unsigned int indep_hp: 1;
	unsigned int prefer_hp_amp: 1;
	unsigned int add_stereo_mix_input: 2;
	unsigned int add_jack_modes: 1;
	unsigned int power_down_unused: 1;
	unsigned int dac_min_mute: 1;
	unsigned int suppress_vmaster: 1;
	unsigned int no_analog: 1;
	unsigned int dyn_adc_switch: 1;
	unsigned int indep_hp_enabled: 1;
	unsigned int have_aamix_ctl: 1;
	unsigned int hp_mic_jack_modes: 1;
	unsigned int skip_verbs: 1;
	u64 mute_bits;
	u64 out_vol_mask;
	const struct badness_table *main_out_badness;
	const struct badness_table *extra_out_badness;
	const hda_nid_t *preferred_dacs;
	bool aamix_mode;
	hda_nid_t beep_nid;
	hda_nid_t vmaster_nid;
	unsigned int vmaster_tlv[4];
	struct hda_vmaster_mute_hook vmaster_mute;
	struct hda_loopback_check loopback;
	struct snd_array loopback_list;
	int multi_ios;
	struct hda_multi_io multi_io[4];
	void (*init_hook)(struct hda_codec *);
	void (*automute_hook)(struct hda_codec *);
	void (*cap_sync_hook)(struct hda_codec *, struct snd_kcontrol *, struct snd_ctl_elem_value *);
	void (*pcm_playback_hook)(struct hda_pcm_stream *, struct hda_codec *, struct snd_pcm_substream *, int);
	void (*pcm_capture_hook)(struct hda_pcm_stream *, struct hda_codec *, struct snd_pcm_substream *, int);
	void (*hp_automute_hook)(struct hda_codec *, struct hda_jack_callback *);
	void (*line_automute_hook)(struct hda_codec *, struct hda_jack_callback *);
	void (*mic_autoswitch_hook)(struct hda_codec *, struct hda_jack_callback *);
	struct led_classdev *led_cdevs[2];
};

struct hda_component {
	struct device *dev;
	char name[50];
	struct acpi_device *adev;
	bool acpi_notifications_supported;
	void (*acpi_notify)(acpi_handle, u32, struct device *);
	void (*pre_playback_hook)(struct device *, int);
	void (*playback_hook)(struct device *, int);
	void (*post_playback_hook)(struct device *, int);
};

struct hda_component_parent {
	struct mutex mutex;
	struct hda_codec *codec;
	struct hda_component comps[4];
};

struct alc_spec {
	struct hda_gen_spec gen;
	struct alc_customize_define cdefine;
	unsigned int parse_flags;
	unsigned int gpio_mask;
	unsigned int gpio_dir;
	unsigned int gpio_data;
	bool gpio_write_delay;
	int mute_led_polarity;
	int micmute_led_polarity;
	hda_nid_t mute_led_nid;
	hda_nid_t cap_mute_led_nid;
	unsigned int gpio_mute_led_mask;
	unsigned int gpio_mic_led_mask;
	struct alc_coef_led mute_led_coef;
	struct alc_coef_led mic_led_coef;
	struct mutex coef_mutex;
	hda_nid_t headset_mic_pin;
	hda_nid_t headphone_mic_pin;
	int current_headset_mode;
	int current_headset_type;
	void (*init_hook)(struct hda_codec *);
	void (*power_hook)(struct hda_codec *);
	void (*shutup)(struct hda_codec *);
	int init_amp;
	int codec_variant;
	unsigned int has_alc5505_dsp: 1;
	unsigned int no_depop_delay: 1;
	unsigned int done_hp_init: 1;
	unsigned int no_shutup_pins: 1;
	unsigned int ultra_low_power: 1;
	unsigned int has_hs_key: 1;
	unsigned int no_internal_mic_pin: 1;
	unsigned int en_3kpull_low: 1;
	int num_speaker_amps;
	hda_nid_t pll_nid;
	unsigned int pll_coef_idx;
	unsigned int pll_coef_bit;
	unsigned int coef0;
	struct input_dev *kb_dev;
	u8 alc_mute_keycode_map[1];
	struct hda_component_parent comps;
};

struct alert_data {
	short unsigned int addr;
	enum i2c_alert_protocol type;
	unsigned int data;
};

struct cipher_testvec;

struct cipher_test_suite {
	const struct cipher_testvec *vecs;
	unsigned int count;
};

struct comp_testvec;

struct comp_test_suite {
	struct {
		const struct comp_testvec *vecs;
		unsigned int count;
	} comp;
	struct {
		const struct comp_testvec *vecs;
		unsigned int count;
	} decomp;
};

struct hash_testvec;

struct hash_test_suite {
	const struct hash_testvec *vecs;
	unsigned int count;
};

struct cprng_testvec;

struct cprng_test_suite {
	const struct cprng_testvec *vecs;
	unsigned int count;
};

struct drbg_testvec;

struct drbg_test_suite {
	const struct drbg_testvec *vecs;
	unsigned int count;
};

struct sig_testvec;

struct sig_test_suite {
	const struct sig_testvec *vecs;
	unsigned int count;
};

struct kpp_testvec;

struct kpp_test_suite {
	const struct kpp_testvec *vecs;
	unsigned int count;
};

struct alg_test_desc {
	const char *alg;
	const char *generic_driver;
	int (*test)(const struct alg_test_desc *, const char *, u32, u32);
	int fips_allowed;
	union {
		struct aead_test_suite aead;
		struct cipher_test_suite cipher;
		struct comp_test_suite comp;
		struct hash_test_suite hash;
		struct cprng_test_suite cprng;
		struct drbg_test_suite drbg;
		struct akcipher_test_suite akcipher;
		struct sig_test_suite sig;
		struct kpp_test_suite kpp;
	} suite;
};

struct alias_prop {
	struct list_head link;
	const char *alias;
	struct device_node *np;
	int id;
	char stem[0];
};

struct allocDescImpUse {
	__le16 flags;
	uint8_t impUse[4];
};

struct tag {
	__le16 tagIdent;
	__le16 descVersion;
	uint8_t tagChecksum;
	uint8_t reserved;
	__le16 tagSerialNum;
	__le16 descCRC;
	__le16 descCRCLength;
	__le32 tagLocation;
};

struct allocExtDesc {
	struct tag descTag;
	__le32 previousAllocExtLocation;
	__le32 lengthAllocDescs;
};

struct alloc_chunk_ctl {
	u64 start;
	u64 type;
	int num_stripes;
	int sub_stripes;
	int dev_stripes;
	int devs_max;
	int devs_min;
	int devs_increment;
	int ncopies;
	int nparity;
	u64 max_stripe_size;
	u64 max_chunk_size;
	u64 dev_extent_min;
	u64 stripe_size;
	u64 chunk_size;
	int ndevs;
};

struct zonelist;

struct zoneref;

struct alloc_context {
	struct zonelist *zonelist;
	nodemask_t *nodemask;
	struct zoneref *preferred_zoneref;
	int migratetype;
	enum zone_type highest_zoneidx;
	bool spread_dirty_pages;
};

struct codetag {
	unsigned int flags;
	unsigned int lineno;
	const char *modname;
	const char *function;
	const char *filename;
};

struct alloc_tag_counters;

struct alloc_tag {
	struct codetag ct;
	struct alloc_tag_counters *counters;
};

struct alloc_tag_counters {
	u64 bytes;
	u64 calls;
};

struct alps_bitmap_point {
	int start_bit;
	int num_bits;
};

struct input_mt_pos {
	s16 x;
	s16 y;
};

struct alps_fields {
	unsigned int x_map;
	unsigned int y_map;
	unsigned int fingers;
	int pressure;
	struct input_mt_pos st;
	struct input_mt_pos mt[4];
	unsigned int first_mp: 1;
	unsigned int is_mp: 1;
	unsigned int left: 1;
	unsigned int right: 1;
	unsigned int middle: 1;
	unsigned int ts_left: 1;
	unsigned int ts_right: 1;
	unsigned int ts_middle: 1;
};

struct psmouse;

struct alps_nibble_commands;

struct alps_data {
	struct psmouse *psmouse;
	struct input_dev *dev2;
	struct input_dev *dev3;
	char phys2[32];
	char phys3[32];
	struct delayed_work dev3_register_work;
	const struct alps_nibble_commands *nibble_commands;
	int addr_command;
	u16 proto_version;
	u8 byte0;
	u8 mask0;
	u8 dev_id[3];
	u8 fw_ver[3];
	int flags;
	int x_max;
	int y_max;
	int x_bits;
	int y_bits;
	unsigned int x_res;
	unsigned int y_res;
	int (*hw_init)(struct psmouse *);
	void (*process_packet)(struct psmouse *);
	int (*decode_fields)(struct alps_fields *, unsigned char *, struct psmouse *);
	void (*set_abs_params)(struct alps_data *, struct input_dev *);
	int prev_fin;
	int multi_packet;
	int second_touch;
	unsigned char multi_data[6];
	struct alps_fields f;
	u8 quirks;
	struct timer_list timer;
};

struct alps_protocol_info {
	u16 version;
	u8 byte0;
	u8 mask0;
	unsigned int flags;
};

struct alps_model_info {
	u8 signature[3];
	struct alps_protocol_info protocol_info;
};

struct alps_nibble_commands {
	int command;
	unsigned char data;
};

struct alt_instr {
	s32 instr_offset;
	s32 replace_offset;
	u16 feature;
	u8 instrlen;
	u8 replacementlen;
};

struct amba_cs_uci_id {
	unsigned int devarch;
	unsigned int devarch_mask;
	unsigned int devtype;
	void *data;
};

struct device_dma_parameters {
	unsigned int max_segment_size;
	unsigned int min_align_mask;
	long unsigned int segment_boundary_mask;
};

struct clk;

struct amba_device {
	struct device dev;
	struct resource res;
	struct clk *pclk;
	struct device_dma_parameters dma_parms;
	unsigned int periphid;
	struct mutex periphid_lock;
	unsigned int cid;
	struct amba_cs_uci_id uci;
	unsigned int irq[9];
	const char *driver_override;
};

struct amd_chipset_type {
	enum amd_chipset_gen gen;
	u8 rev;
};

struct amd_chipset_info {
	struct pci_dev *nb_dev;
	struct pci_dev *smbus_dev;
	int nb_type;
	struct amd_chipset_type sb_type;
	int isoc_reqs;
	int probe_count;
	bool need_pll_quirk;
};

struct amiga_parport_state {
	unsigned char data;
	unsigned char datadir;
	unsigned char status;
	unsigned char statusdir;
};

struct aml_resource_small_header {
	u8 descriptor_type;
};

struct aml_resource_large_header {
	u8 descriptor_type;
	u16 resource_length;
} __attribute__((packed));

struct aml_resource_irq {
	u8 descriptor_type;
	u16 irq_mask;
	u8 flags;
} __attribute__((packed));

struct aml_resource_dma {
	u8 descriptor_type;
	u8 dma_channel_mask;
	u8 flags;
};

struct aml_resource_start_dependent {
	u8 descriptor_type;
	u8 flags;
};

struct aml_resource_end_dependent {
	u8 descriptor_type;
};

struct aml_resource_io {
	u8 descriptor_type;
	u8 flags;
	u16 minimum;
	u16 maximum;
	u8 alignment;
	u8 address_length;
};

struct aml_resource_fixed_io {
	u8 descriptor_type;
	u16 address;
	u8 address_length;
} __attribute__((packed));

struct aml_resource_fixed_dma {
	u8 descriptor_type;
	u16 request_lines;
	u16 channels;
	u8 width;
} __attribute__((packed));

struct aml_resource_vendor_small {
	u8 descriptor_type;
};

struct aml_resource_end_tag {
	u8 descriptor_type;
	u8 checksum;
};

struct aml_resource_memory24 {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u16 minimum;
	u16 maximum;
	u16 alignment;
	u16 address_length;
} __attribute__((packed));

struct aml_resource_generic_register {
	u8 descriptor_type;
	u16 resource_length;
	u8 address_space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed));

struct aml_resource_vendor_large {
	u8 descriptor_type;
	u16 resource_length;
} __attribute__((packed));

struct aml_resource_memory32 {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u32 minimum;
	u32 maximum;
	u32 alignment;
	u32 address_length;
} __attribute__((packed));

struct aml_resource_fixed_memory32 {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u32 address;
	u32 address_length;
} __attribute__((packed));

struct aml_resource_address16 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u16 granularity;
	u16 minimum;
	u16 maximum;
	u16 translation_offset;
	u16 address_length;
} __attribute__((packed));

struct aml_resource_address32 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u32 granularity;
	u32 minimum;
	u32 maximum;
	u32 translation_offset;
	u32 address_length;
} __attribute__((packed));

struct aml_resource_address64 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
} __attribute__((packed));

struct aml_resource_extended_address64 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u8 revision_ID;
	u8 reserved;
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
	u64 type_specific;
} __attribute__((packed));

struct aml_resource_extended_irq {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u8 interrupt_count;
	union {
		u32 interrupt;
		struct {
			struct {} __Empty_interrupts;
			u32 interrupts[0];
		};
	};
} __attribute__((packed));

struct aml_resource_gpio {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 connection_type;
	u16 flags;
	u16 int_flags;
	u8 pin_config;
	u16 drive_strength;
	u16 debounce_timeout;
	u16 pin_table_offset;
	u8 res_source_index;
	u16 res_source_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_i2c_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
	u32 connection_speed;
	u16 slave_address;
} __attribute__((packed));

struct aml_resource_spi_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
	u32 connection_speed;
	u8 data_bit_length;
	u8 clock_phase;
	u8 clock_polarity;
	u16 device_selection;
} __attribute__((packed));

struct aml_resource_uart_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
	u32 default_baud_rate;
	u16 rx_fifo_size;
	u16 tx_fifo_size;
	u8 parity;
	u8 lines_enabled;
} __attribute__((packed));

struct aml_resource_csi2_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
} __attribute__((packed));

struct aml_resource_common_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
} __attribute__((packed));

struct aml_resource_pin_function {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u8 pin_config;
	u16 function_number;
	u16 pin_table_offset;
	u8 res_source_index;
	u16 res_source_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_pin_config {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 pin_table_offset;
	u8 res_source_index;
	u16 res_source_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_pin_group {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u16 pin_table_offset;
	u16 label_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_pin_group_function {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u16 function_number;
	u8 res_source_index;
	u16 res_source_offset;
	u16 res_source_label_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_pin_group_config {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u8 pin_config_type;
	u32 pin_config_value;
	u8 res_source_index;
	u16 res_source_offset;
	u16 res_source_label_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_clock_input {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u16 frequency_divisor;
	u32 frequency_numerator;
} __attribute__((packed));

struct aml_resource_address {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
} __attribute__((packed));

union aml_resource {
	u8 descriptor_type;
	struct aml_resource_small_header small_header;
	struct aml_resource_large_header large_header;
	struct aml_resource_irq irq;
	struct aml_resource_dma dma;
	struct aml_resource_start_dependent start_dpf;
	struct aml_resource_end_dependent end_dpf;
	struct aml_resource_io io;
	struct aml_resource_fixed_io fixed_io;
	struct aml_resource_fixed_dma fixed_dma;
	struct aml_resource_vendor_small vendor_small;
	struct aml_resource_end_tag end_tag;
	struct aml_resource_memory24 memory24;
	struct aml_resource_generic_register generic_reg;
	struct aml_resource_vendor_large vendor_large;
	struct aml_resource_memory32 memory32;
	struct aml_resource_fixed_memory32 fixed_memory32;
	struct aml_resource_address16 address16;
	struct aml_resource_address32 address32;
	struct aml_resource_address64 address64;
	struct aml_resource_extended_address64 ext_address64;
	struct aml_resource_extended_irq extended_irq;
	struct aml_resource_gpio gpio;
	struct aml_resource_i2c_serialbus i2c_serial_bus;
	struct aml_resource_spi_serialbus spi_serial_bus;
	struct aml_resource_uart_serialbus uart_serial_bus;
	struct aml_resource_csi2_serialbus csi2_serial_bus;
	struct aml_resource_common_serialbus common_serial_bus;
	struct aml_resource_pin_function pin_function;
	struct aml_resource_pin_config pin_config;
	struct aml_resource_pin_group pin_group;
	struct aml_resource_pin_group_function pin_group_function;
	struct aml_resource_pin_group_config pin_group_config;
	struct aml_resource_clock_input clock_input;
	struct aml_resource_address address;
	u32 dword_item;
	u16 word_item;
	u8 byte_item;
};

struct analog_param_field {
	unsigned int even;
	unsigned int odd;
};

struct analog_param_range {
	unsigned int min;
	unsigned int typ;
	unsigned int max;
};

struct analog_parameters {
	unsigned int num_lines;
	unsigned int line_duration_ns;
	struct analog_param_range hact_ns;
	struct analog_param_range hfp_ns;
	struct analog_param_range hslen_ns;
	struct analog_param_range hbp_ns;
	struct analog_param_range hblk_ns;
	unsigned int bt601_hfp;
	struct analog_param_field vfp_lines;
	struct analog_param_field vslen_lines;
	struct analog_param_field vbp_lines;
};

struct extent_ad {
	__le32 extLength;
	__le32 extLocation;
};

struct anchorVolDescPtr {
	struct tag descTag;
	struct extent_ad mainVolDescSeqExt;
	struct extent_ad reserveVolDescSeqExt;
	uint8_t reserved[480];
};

struct kobj_uevent_env;

struct kobj_ns_type_operations;

struct class {
	const char *name;
	const struct attribute_group **class_groups;
	const struct attribute_group **dev_groups;
	int (*dev_uevent)(const struct device *, struct kobj_uevent_env *);
	char * (*devnode)(const struct device *, umode_t *);
	void (*class_release)(const struct class *);
	void (*dev_release)(struct device *);
	int (*shutdown_pre)(struct device *);
	const struct kobj_ns_type_operations *ns_type;
	const void * (*namespace)(const struct device *);
	void (*get_ownership)(const struct device *, kuid_t *, kgid_t *);
	const struct dev_pm_ops *pm;
};

struct transport_container;

struct transport_class {
	struct class class;
	int (*setup)(struct transport_container *, struct device *, struct device *);
	int (*configure)(struct transport_container *, struct device *, struct device *);
	int (*remove)(struct transport_container *, struct device *, struct device *);
};

struct klist_node;

struct klist {
	spinlock_t k_lock;
	struct list_head k_list;
	void (*get)(struct klist_node *);
	void (*put)(struct klist_node *);
};

struct attribute_container {
	struct list_head node;
	struct klist containers;
	struct class *class;
	const struct attribute_group *grp;
	struct device_attribute **attrs;
	int (*match)(struct attribute_container *, struct device *);
	long unsigned int flags;
};

struct anon_transport_class {
	struct transport_class tclass;
	struct attribute_container container;
};

struct anon_vma {
	struct anon_vma *root;
	struct rw_semaphore rwsem;
	atomic_t refcount;
	long unsigned int num_children;
	long unsigned int num_active_vmas;
	struct anon_vma *parent;
	struct rb_root_cached rb_root;
};

struct anon_vma_chain {
	struct vm_area_struct *vma;
	struct anon_vma *anon_vma;
	struct list_head same_vma;
	struct rb_node rb;
	long unsigned int rb_subtree_last;
};

struct anon_vma_name {
	struct kref kref;
	char name[0];
};

struct apd_private_data;

struct apd_device_desc {
	unsigned int fixed_clk_rate;
	struct property_entry *properties;
	int (*setup)(struct apd_private_data *);
};

struct apd_private_data {
	struct clk *clk;
	struct acpi_device *adev;
	const struct apd_device_desc *dev_desc;
};

struct aperture_range {
	struct device *dev;
	resource_size_t base;
	resource_size_t size;
	struct list_head lh;
	void (*detach)(struct device *);
};

struct api_context {
	struct completion done;
	int status;
};

struct vfsmount;

struct path {
	struct vfsmount *mnt;
	struct dentry *dentry;
};

struct lsm_network_audit;

struct lsm_ioctlop_audit;

struct lsm_ibpkey_audit;

struct lsm_ibendport_audit;

struct selinux_audit_data;

struct apparmor_audit_data;

struct common_audit_data {
	char type;
	union {
		struct path path;
		struct dentry *dentry;
		struct inode *inode;
		struct lsm_network_audit *net;
		int cap;
		int ipc_id;
		struct task_struct *tsk;
		struct {
			key_serial_t key;
			char *key_desc;
		} key_struct;
		char *kmod_name;
		struct lsm_ioctlop_audit *op;
		struct file *file;
		struct lsm_ibpkey_audit *ibpkey;
		struct lsm_ibendport_audit *ibendport;
		int reason;
		const char *anonclass;
		u16 nlmsg_type;
	} u;
	union {
		struct selinux_audit_data *selinux_audit_data;
		struct apparmor_audit_data *apparmor_audit_data;
	};
};

struct sock;

struct apparmor_audit_data {
	int error;
	int type;
	u16 class;
	const char *op;
	const struct cred *subj_cred;
	struct aa_label *subj_label;
	const char *name;
	const char *info;
	u32 request;
	u32 denied;
	union {
		struct {
			struct aa_label *peer;
			union {
				struct {
					const char *target;
					kuid_t ouid;
				} fs;
				struct {
					int rlim;
					long unsigned int max;
				} rlim;
				struct {
					int signal;
					int unmappedsig;
				};
				struct {
					int type;
					int protocol;
					struct sock *peer_sk;
					void *addr;
					int addrlen;
				} net;
			};
		};
		struct {
			struct aa_profile *profile;
			const char *ns;
			long int pos;
		} iface;
		struct {
			const char *src_name;
			const char *type;
			const char *trans;
			const char *data;
			long unsigned int flags;
		} mnt;
		struct {
			struct aa_label *target;
		} uring;
	};
	struct common_audit_data common;
};

struct workqueue_attrs;

struct pool_workqueue;

struct apply_wqattrs_ctx {
	struct workqueue_struct *wq;
	struct workqueue_attrs *attrs;
	struct list_head list;
	struct pool_workqueue *dfl_pwq;
	struct pool_workqueue *pwq_tbl[0];
};

struct arch_elf_state {
	int fp_abi;
	int interp_fp_abi;
};

struct arch_hw_breakpoint_ctrl {
	u32 __reserved: 28;
	u32 len: 2;
	u32 type: 2;
};

struct arch_hw_breakpoint {
	u64 address;
	u64 mask;
	struct arch_hw_breakpoint_ctrl ctrl;
};

struct arch_io_reserve_memtype_wc_devres {
	resource_size_t start;
	resource_size_t size;
};

struct arch_msi_msg_addr_hi {
	u32 address_hi;
};

typedef struct arch_msi_msg_addr_hi arch_msi_msg_addr_hi_t;

struct arch_msi_msg_addr_lo {
	u32 address_lo;
};

typedef struct arch_msi_msg_addr_lo arch_msi_msg_addr_lo_t;

struct arch_msi_msg_data {
	u32 data;
};

typedef struct arch_msi_msg_data arch_msi_msg_data_t;

struct arch_specific_insn {
	int dummy;
};

struct arch_uprobe {
	long unsigned int resume_era;
	u32 insn[2];
	u32 ixol[2];
	bool simulate;
};

struct arch_uprobe_task {
	long unsigned int saved_trap_nr;
};

struct arch_vdso_time_data {};

struct arg_dev_net_ip {
	struct net *net;
	struct in6_addr *addr;
};

struct arg_netdev_event {
	const struct net_device *dev;
	union {
		unsigned char nh_flags;
		long unsigned int event;
	};
};

struct args_askumount {
	__u32 may_umount;
};

struct args_expire {
	__u32 how;
};

struct args_fail {
	__u32 token;
	__s32 status;
};

struct args_in {
	__u32 type;
};

struct args_out {
	__u32 devid;
	__u32 magic;
};

struct args_ismountpoint {
	union {
		struct args_in in;
		struct args_out out;
	};
};

struct args_openmount {
	__u32 devid;
};

struct args_protosubver {
	__u32 sub_version;
};

struct args_protover {
	__u32 version;
};

struct args_ready {
	__u32 token;
};

struct args_requester {
	__u32 uid;
	__u32 gid;
};

struct args_setpipefd {
	__s32 pipefd;
};

struct args_timeout {
	__u64 timeout;
};

struct arphdr {
	__be16 ar_hrd;
	__be16 ar_pro;
	unsigned char ar_hln;
	unsigned char ar_pln;
	__be16 ar_op;
};

struct sockaddr {
	sa_family_t sa_family;
	union {
		char sa_data_min[14];
		struct {
			struct {} __empty_sa_data;
			char sa_data[0];
		};
	};
};

struct arpreq {
	struct sockaddr arp_pa;
	struct sockaddr arp_ha;
	int arp_flags;
	struct sockaddr arp_netmask;
	char arp_dev[16];
};

struct trace_array;

struct trace_buffer;

struct trace_array_cpu;

struct array_buffer {
	struct trace_array *tr;
	struct trace_buffer *buffer;
	struct trace_array_cpu *data;
	u64 time_start;
	int cpu;
};

struct sas_work {
	struct list_head drain_node;
	struct work_struct work;
};

struct asd_sas_phy;

struct asd_sas_event {
	struct sas_work work;
	struct asd_sas_phy *phy;
	int event;
};

struct asd_sas_port;

struct sas_ha_struct;

struct asd_sas_phy {
	atomic_t event_nr;
	int in_shutdown;
	int error;
	int suspended;
	struct sas_phy *phy;
	int enabled;
	int id;
	enum sas_protocol iproto;
	enum sas_protocol tproto;
	enum sas_phy_role role;
	enum sas_oob_mode oob_mode;
	enum sas_linkrate linkrate;
	u8 *sas_addr;
	u8 attached_sas_addr[8];
	spinlock_t frame_rcvd_lock;
	u8 *frame_rcvd;
	int frame_rcvd_size;
	spinlock_t sas_prim_lock;
	u32 sas_prim;
	struct list_head port_phy_el;
	struct asd_sas_port *port;
	struct sas_ha_struct *ha;
	void *lldd_phy;
};

struct sas_discovery_event {
	struct sas_work work;
	struct asd_sas_port *port;
};

struct sas_discovery {
	struct sas_discovery_event disc_work[4];
	long unsigned int pending;
	u8 fanout_sas_addr[8];
	u8 eeds_a[8];
	u8 eeds_b[8];
	int max_level;
};

struct domain_device;

struct asd_sas_port {
	struct sas_discovery disc;
	struct domain_device *port_dev;
	spinlock_t dev_list_lock;
	struct list_head dev_list;
	struct list_head disco_list;
	struct list_head destroy_list;
	struct list_head sas_port_del_list;
	enum sas_linkrate linkrate;
	struct sas_work work;
	int suspended;
	int id;
	u8 sas_addr[8];
	u8 attached_sas_addr[8];
	enum sas_protocol iproto;
	enum sas_protocol tproto;
	enum sas_oob_mode oob_mode;
	spinlock_t phy_list_lock;
	struct list_head phy_list;
	int num_phys;
	u32 phy_mask;
	struct sas_ha_struct *ha;
	struct sas_port *port;
	void *lldd_port;
};

typedef int (*asn1_action_t)(void *, size_t, unsigned char, const void *, size_t);

struct asn1_decoder {
	const unsigned char *machine;
	size_t machlen;
	const asn1_action_t *actions;
};

struct assoc_array_ptr;

struct assoc_array {
	struct assoc_array_ptr *root;
	long unsigned int nr_leaves_on_tree;
};

struct assoc_array_node;

struct assoc_array_delete_collapse_context {
	struct assoc_array_node *node;
	const void *skip_leaf;
	int slot;
};

struct assoc_array_ops;

struct assoc_array_edit {
	struct callback_head rcu;
	struct assoc_array *array;
	const struct assoc_array_ops *ops;
	const struct assoc_array_ops *ops_for_excised_subtree;
	struct assoc_array_ptr *leaf;
	struct assoc_array_ptr **leaf_p;
	struct assoc_array_ptr *dead_leaf;
	struct assoc_array_ptr *new_meta[3];
	struct assoc_array_ptr *excised_meta[1];
	struct assoc_array_ptr *excised_subtree;
	struct assoc_array_ptr **set_backpointers[16];
	struct assoc_array_ptr *set_backpointers_to;
	struct assoc_array_node *adjust_count_on;
	long int adjust_count_by;
	struct {
		struct assoc_array_ptr **ptr;
		struct assoc_array_ptr *to;
	} set[2];
	struct {
		u8 *p;
		u8 to;
	} set_parent_slot[1];
	u8 segment_cache[17];
};

struct assoc_array_node {
	struct assoc_array_ptr *back_pointer;
	u8 parent_slot;
	struct assoc_array_ptr *slots[16];
	long unsigned int nr_leaves_on_branch;
};

struct assoc_array_ops {
	long unsigned int (*get_key_chunk)(const void *, int);
	long unsigned int (*get_object_key_chunk)(const void *, int);
	bool (*compare_object)(const void *, const void *);
	int (*diff_objects)(const void *, const void *);
	void (*free_object)(void *);
};

struct assoc_array_shortcut {
	struct assoc_array_ptr *back_pointer;
	int parent_slot;
	int skip_to_level;
	struct assoc_array_ptr *next_node;
	long unsigned int index_key[0];
};

struct assoc_array_walk_result {
	struct {
		struct assoc_array_node *node;
		int level;
		int slot;
	} terminal_node;
	struct {
		struct assoc_array_shortcut *shortcut;
		int level;
		int sc_level;
		long unsigned int sc_segments;
		long unsigned int dissimilarity;
	} wrong_shortcut;
};

struct ast2300_dram_param {
	u32 dram_type;
	u32 dram_chipid;
	u32 dram_freq;
	u32 vram_size;
	u32 odt;
	u32 wodt;
	u32 rodt;
	u32 dram_config;
	u32 reg_PERIOD;
	u32 reg_MADJ;
	u32 reg_SADJ;
	u32 reg_MRS;
	u32 reg_EMRS;
	u32 reg_AC1;
	u32 reg_AC2;
	u32 reg_DQSIC;
	u32 reg_DRV;
	u32 reg_IOZ;
	u32 reg_DQIDLY;
	u32 reg_FREQ;
	u32 madj_max;
	u32 dll2_finetune_step;
};

struct drm_object_properties;

struct drm_mode_object {
	uint32_t id;
	uint32_t type;
	struct drm_object_properties *properties;
	struct kref refcount;
	void (*free_cb)(struct kref *);
};

struct drm_scrambling {
	bool supported;
	bool low_rates;
};

struct drm_scdc {
	bool supported;
	bool read_request;
	struct drm_scrambling scrambling;
};

struct drm_hdmi_dsc_cap {
	bool v_1p2;
	bool native_420;
	bool all_bpp;
	u8 bpc_supported;
	u8 max_slices;
	int clk_per_slice;
	u8 max_lanes;
	u8 max_frl_rate_per_lane;
	u8 total_chunk_kbytes;
};

struct drm_hdmi_info {
	struct drm_scdc scdc;
	long unsigned int y420_vdb_modes[4];
	long unsigned int y420_cmdb_modes[4];
	u8 y420_dc_modes;
	u8 max_frl_rate_per_lane;
	u8 max_lanes;
	struct drm_hdmi_dsc_cap dsc_cap;
};

struct drm_monitor_range_info {
	u16 min_vfreq;
	u16 max_vfreq;
};

struct drm_luminance_range_info {
	u32 min_luminance;
	u32 max_luminance;
};

struct drm_display_info {
	unsigned int width_mm;
	unsigned int height_mm;
	unsigned int bpc;
	enum subpixel_order subpixel_order;
	int panel_orientation;
	u32 color_formats;
	const u32 *bus_formats;
	unsigned int num_bus_formats;
	u32 bus_flags;
	int max_tmds_clock;
	bool dvi_dual;
	bool is_hdmi;
	bool has_audio;
	bool has_hdmi_infoframe;
	bool rgb_quant_range_selectable;
	u8 edid_hdmi_rgb444_dc_modes;
	u8 edid_hdmi_ycbcr444_dc_modes;
	u8 cea_rev;
	struct drm_hdmi_info hdmi;
	bool non_desktop;
	struct drm_monitor_range_info monitor_range;
	struct drm_luminance_range_info luminance_range;
	u8 mso_stream_count;
	u8 mso_pixel_overlap;
	u32 max_dsc_bpp;
	u8 *vics;
	int vics_len;
	u32 quirks;
	u16 source_physical_address;
};

struct drm_property;

struct drm_object_properties {
	int count;
	struct drm_property *properties[64];
	uint64_t values[64];
};

struct drm_privacy_screen;

struct drm_connector_tv_margins {
	unsigned int bottom;
	unsigned int left;
	unsigned int right;
	unsigned int top;
};

struct drm_cmdline_mode {
	char name[32];
	bool specified;
	bool refresh_specified;
	bool bpp_specified;
	unsigned int pixel_clock;
	int xres;
	int yres;
	int bpp;
	int refresh;
	bool rb;
	bool interlace;
	bool cvt;
	bool margins;
	enum drm_connector_force force;
	unsigned int rotation_reflection;
	enum drm_panel_orientation panel_orientation;
	struct drm_connector_tv_margins tv_margins;
	enum drm_connector_tv_mode tv_mode;
	bool tv_mode_specified;
};

struct hdr_static_metadata {
	__u8 eotf;
	__u8 metadata_type;
	__u16 max_cll;
	__u16 max_fall;
	__u16 min_cll;
};

struct hdr_sink_metadata {
	__u32 metadata_type;
	union {
		struct hdr_static_metadata hdmi_type1;
	};
};

struct hdmi_any_infoframe {
	enum hdmi_infoframe_type type;
	unsigned char version;
	unsigned char length;
};

struct hdmi_avi_infoframe {
	enum hdmi_infoframe_type type;
	unsigned char version;
	unsigned char length;
	bool itc;
	unsigned char pixel_repeat;
	enum hdmi_colorspace colorspace;
	enum hdmi_scan_mode scan_mode;
	enum hdmi_colorimetry colorimetry;
	enum hdmi_picture_aspect picture_aspect;
	enum hdmi_active_aspect active_aspect;
	enum hdmi_extended_colorimetry extended_colorimetry;
	enum hdmi_quantization_range quantization_range;
	enum hdmi_nups nups;
	unsigned char video_code;
	enum hdmi_ycc_quantization_range ycc_quantization_range;
	enum hdmi_content_type content_type;
	short unsigned int top_bar;
	short unsigned int bottom_bar;
	short unsigned int left_bar;
	short unsigned int right_bar;
};

struct hdmi_spd_infoframe {
	enum hdmi_infoframe_type type;
	unsigned char version;
	unsigned char length;
	char vendor[8];
	char product[16];
	enum hdmi_spd_sdi sdi;
};

struct hdmi_vendor_infoframe {
	enum hdmi_infoframe_type type;
	unsigned char version;
	unsigned char length;
	unsigned int oui;
	u8 vic;
	enum hdmi_3d_structure s3d_struct;
	unsigned int s3d_ext_data;
};

union hdmi_vendor_any_infoframe {
	struct {
		enum hdmi_infoframe_type type;
		unsigned char version;
		unsigned char length;
		unsigned int oui;
	} any;
	struct hdmi_vendor_infoframe hdmi;
};

struct hdmi_audio_infoframe {
	enum hdmi_infoframe_type type;
	unsigned char version;
	unsigned char length;
	unsigned char channels;
	enum hdmi_audio_coding_type coding_type;
	enum hdmi_audio_sample_size sample_size;
	enum hdmi_audio_sample_frequency sample_frequency;
	enum hdmi_audio_coding_type_ext coding_type_ext;
	unsigned char channel_allocation;
	unsigned char level_shift_value;
	bool downmix_inhibit;
};

struct hdmi_drm_infoframe {
	enum hdmi_infoframe_type type;
	unsigned char version;
	unsigned char length;
	enum hdmi_eotf eotf;
	enum hdmi_metadata_type metadata_type;
	struct {
		u16 x;
		u16 y;
	} display_primaries[3];
	struct {
		u16 x;
		u16 y;
	} white_point;
	u16 max_display_mastering_luminance;
	u16 min_display_mastering_luminance;
	u16 max_cll;
	u16 max_fall;
};

union hdmi_infoframe {
	struct hdmi_any_infoframe any;
	struct hdmi_avi_infoframe avi;
	struct hdmi_spd_infoframe spd;
	union hdmi_vendor_any_infoframe vendor;
	struct hdmi_audio_infoframe audio;
	struct hdmi_drm_infoframe drm;
};

struct drm_connector_hdmi_infoframe {
	union hdmi_infoframe data;
	bool set;
};

struct drm_connector_hdmi_funcs;

struct drm_connector_hdmi {
	unsigned char vendor[8];
	unsigned char product[16];
	long unsigned int supported_formats;
	const struct drm_connector_hdmi_funcs *funcs;
	struct {
		struct mutex lock;
		struct drm_connector_hdmi_infoframe audio;
	} infoframes;
};

struct drm_connector_hdmi_audio_funcs;

struct drm_connector_hdmi_audio {
	const struct drm_connector_hdmi_audio_funcs *funcs;
	struct platform_device *codec_pdev;
	struct mutex lock;
	void (*plugged_cb)(struct device *, bool);
	struct device *plugged_cb_dev;
	bool last_state;
	int dai_port;
};

struct drm_device;

struct drm_connector_funcs;

struct drm_property_blob;

struct drm_connector_helper_funcs;

struct drm_edid;

struct drm_encoder;

struct i2c_adapter;

struct drm_tile_group;

struct drm_connector {
	struct drm_device *dev;
	struct device *kdev;
	struct device_attribute *attr;
	struct fwnode_handle *fwnode;
	struct list_head head;
	struct list_head global_connector_list_entry;
	struct drm_mode_object base;
	char *name;
	struct mutex mutex;
	unsigned int index;
	int connector_type;
	int connector_type_id;
	bool interlace_allowed;
	bool doublescan_allowed;
	bool stereo_allowed;
	bool ycbcr_420_allowed;
	enum drm_connector_registration_state registration_state;
	struct list_head modes;
	enum drm_connector_status status;
	struct list_head probed_modes;
	struct drm_display_info display_info;
	const struct drm_connector_funcs *funcs;
	struct drm_property_blob *edid_blob_ptr;
	struct drm_object_properties properties;
	struct drm_property *scaling_mode_property;
	struct drm_property *vrr_capable_property;
	struct drm_property *colorspace_property;
	struct drm_property_blob *path_blob_ptr;
	unsigned int max_bpc;
	struct drm_property *max_bpc_property;
	struct drm_privacy_screen *privacy_screen;
	struct notifier_block privacy_screen_notifier;
	struct drm_property *privacy_screen_sw_state_property;
	struct drm_property *privacy_screen_hw_state_property;
	struct drm_property *broadcast_rgb_property;
	uint8_t polled;
	int dpms;
	const struct drm_connector_helper_funcs *helper_private;
	struct drm_cmdline_mode cmdline_mode;
	enum drm_connector_force force;
	const struct drm_edid *edid_override;
	struct mutex edid_override_mutex;
	u64 epoch_counter;
	u32 possible_encoders;
	struct drm_encoder *encoder;
	uint8_t eld[128];
	struct mutex eld_mutex;
	bool latency_present[2];
	int video_latency[2];
	int audio_latency[2];
	struct i2c_adapter *ddc;
	int null_edid_counter;
	unsigned int bad_edid_counter;
	bool edid_corrupt;
	u8 real_edid_checksum;
	struct dentry *debugfs_entry;
	struct drm_connector_state *state;
	struct drm_property_blob *tile_blob_ptr;
	bool has_tile;
	struct drm_tile_group *tile_group;
	bool tile_is_single_monitor;
	uint8_t num_h_tile;
	uint8_t num_v_tile;
	uint8_t tile_h_loc;
	uint8_t tile_v_loc;
	uint16_t tile_h_size;
	uint16_t tile_v_size;
	struct llist_node free_node;
	struct hdr_sink_metadata hdr_sink_metadata;
	struct drm_connector_hdmi hdmi;
	struct drm_connector_hdmi_audio hdmi_audio;
};

struct ast_connector {
	struct drm_connector base;
	enum drm_connector_status physical_status;
};

struct drm_display_mode {
	int clock;
	u16 hdisplay;
	u16 hsync_start;
	u16 hsync_end;
	u16 htotal;
	u16 hskew;
	u16 vdisplay;
	u16 vsync_start;
	u16 vsync_end;
	u16 vtotal;
	u16 vscan;
	u32 flags;
	int crtc_clock;
	u16 crtc_hdisplay;
	u16 crtc_hblank_start;
	u16 crtc_hblank_end;
	u16 crtc_hsync_start;
	u16 crtc_hsync_end;
	u16 crtc_htotal;
	u16 crtc_hskew;
	u16 crtc_vdisplay;
	u16 crtc_vblank_start;
	u16 crtc_vblank_end;
	u16 crtc_vsync_start;
	u16 crtc_vsync_end;
	u16 crtc_vtotal;
	u16 width_mm;
	u16 height_mm;
	u8 type;
	bool expose_to_userspace;
	struct list_head head;
	char name[32];
	enum drm_mode_status status;
	enum hdmi_picture_aspect picture_aspect_ratio;
};

struct drm_pending_vblank_event;

struct drm_atomic_state;

struct drm_crtc_state {
	struct drm_crtc *crtc;
	bool enable;
	bool active;
	bool planes_changed: 1;
	bool mode_changed: 1;
	bool active_changed: 1;
	bool connectors_changed: 1;
	bool zpos_changed: 1;
	bool color_mgmt_changed: 1;
	bool no_vblank: 1;
	u32 plane_mask;
	u32 connector_mask;
	u32 encoder_mask;
	struct drm_display_mode adjusted_mode;
	struct drm_display_mode mode;
	struct drm_property_blob *mode_blob;
	struct drm_property_blob *degamma_lut;
	struct drm_property_blob *ctm;
	struct drm_property_blob *gamma_lut;
	u32 target_vblank;
	bool async_flip;
	bool vrr_enabled;
	bool self_refresh_active;
	enum drm_scaling_filter scaling_filter;
	struct drm_pending_vblank_event *event;
	struct drm_crtc_commit *commit;
	struct drm_atomic_state *state;
};

struct ast_vbios_stdtable;

struct ast_vbios_enhtable;

struct ast_vbios_mode_info {
	const struct ast_vbios_stdtable *std_table;
	const struct ast_vbios_enhtable *enh_table;
};

struct drm_format_info;

struct ast_crtc_state {
	struct drm_crtc_state base;
	const struct drm_format_info *format;
	struct ast_vbios_mode_info vbios_mode_info;
};

struct i2c_algo_bit_data {
	void *data;
	void (*setsda)(void *, int);
	void (*setscl)(void *, int);
	int (*getsda)(void *);
	int (*getscl)(void *);
	int (*pre_xfer)(struct i2c_adapter *);
	void (*post_xfer)(struct i2c_adapter *);
	int udelay;
	int timeout;
	bool can_do_atomic;
};

struct rt_mutex_base {
	raw_spinlock_t wait_lock;
	struct rb_root_cached waiters;
	struct task_struct *owner;
};

struct rt_mutex {
	struct rt_mutex_base rtmutex;
};

struct i2c_algorithm;

struct i2c_lock_operations;

struct i2c_bus_recovery_info;

struct i2c_adapter_quirks;

struct i2c_adapter {
	struct module *owner;
	unsigned int class;
	const struct i2c_algorithm *algo;
	void *algo_data;
	const struct i2c_lock_operations *lock_ops;
	struct rt_mutex bus_lock;
	struct rt_mutex mux_lock;
	int timeout;
	int retries;
	struct device dev;
	long unsigned int locked_flags;
	int nr;
	char name[48];
	struct completion dev_released;
	struct mutex userspace_clients_lock;
	struct list_head userspace_clients;
	struct i2c_bus_recovery_info *bus_recovery_info;
	const struct i2c_adapter_quirks *quirks;
	struct irq_domain *host_notify_domain;
	struct regulator *bus_regulator;
	struct dentry *debugfs;
	long unsigned int addrs_in_instantiation[2];
};

struct ast_device;

struct ast_ddc {
	struct ast_device *ast;
	struct i2c_algo_bit_data bit;
	struct i2c_adapter adapter;
};

struct ww_acquire_ctx;

struct ww_mutex {
	struct mutex base;
	struct ww_acquire_ctx *ctx;
};

struct drm_modeset_lock {
	struct ww_mutex mutex;
	struct list_head head;
};

struct idr {
	struct xarray idr_rt;
	unsigned int idr_base;
	unsigned int idr_next;
};

struct llist_head {
	struct llist_node *first;
};

struct drm_modeset_acquire_ctx;

struct drm_mode_config_funcs;

struct drm_mode_config_helper_funcs;

struct drm_mode_config {
	struct mutex mutex;
	struct drm_modeset_lock connection_mutex;
	struct drm_modeset_acquire_ctx *acquire_ctx;
	struct mutex idr_mutex;
	struct idr object_idr;
	struct idr tile_idr;
	struct mutex fb_lock;
	int num_fb;
	struct list_head fb_list;
	spinlock_t connector_list_lock;
	int num_connector;
	struct ida connector_ida;
	struct list_head connector_list;
	struct llist_head connector_free_list;
	struct work_struct connector_free_work;
	int num_encoder;
	struct list_head encoder_list;
	int num_total_plane;
	struct list_head plane_list;
	struct raw_spinlock panic_lock;
	int num_crtc;
	struct list_head crtc_list;
	struct list_head property_list;
	struct list_head privobj_list;
	int min_width;
	int min_height;
	int max_width;
	int max_height;
	const struct drm_mode_config_funcs *funcs;
	bool poll_enabled;
	bool poll_running;
	bool delayed_event;
	struct delayed_work output_poll_work;
	struct mutex blob_lock;
	struct list_head property_blob_list;
	struct drm_property *edid_property;
	struct drm_property *dpms_property;
	struct drm_property *path_property;
	struct drm_property *tile_property;
	struct drm_property *link_status_property;
	struct drm_property *plane_type_property;
	struct drm_property *prop_src_x;
	struct drm_property *prop_src_y;
	struct drm_property *prop_src_w;
	struct drm_property *prop_src_h;
	struct drm_property *prop_crtc_x;
	struct drm_property *prop_crtc_y;
	struct drm_property *prop_crtc_w;
	struct drm_property *prop_crtc_h;
	struct drm_property *prop_fb_id;
	struct drm_property *prop_in_fence_fd;
	struct drm_property *prop_out_fence_ptr;
	struct drm_property *prop_crtc_id;
	struct drm_property *prop_fb_damage_clips;
	struct drm_property *prop_active;
	struct drm_property *prop_mode_id;
	struct drm_property *prop_vrr_enabled;
	struct drm_property *dvi_i_subconnector_property;
	struct drm_property *dvi_i_select_subconnector_property;
	struct drm_property *dp_subconnector_property;
	struct drm_property *tv_subconnector_property;
	struct drm_property *tv_select_subconnector_property;
	struct drm_property *legacy_tv_mode_property;
	struct drm_property *tv_mode_property;
	struct drm_property *tv_left_margin_property;
	struct drm_property *tv_right_margin_property;
	struct drm_property *tv_top_margin_property;
	struct drm_property *tv_bottom_margin_property;
	struct drm_property *tv_brightness_property;
	struct drm_property *tv_contrast_property;
	struct drm_property *tv_flicker_reduction_property;
	struct drm_property *tv_overscan_property;
	struct drm_property *tv_saturation_property;
	struct drm_property *tv_hue_property;
	struct drm_property *scaling_mode_property;
	struct drm_property *aspect_ratio_property;
	struct drm_property *content_type_property;
	struct drm_property *degamma_lut_property;
	struct drm_property *degamma_lut_size_property;
	struct drm_property *ctm_property;
	struct drm_property *gamma_lut_property;
	struct drm_property *gamma_lut_size_property;
	struct drm_property *suggested_x_property;
	struct drm_property *suggested_y_property;
	struct drm_property *non_desktop_property;
	struct drm_property *panel_orientation_property;
	struct drm_property *writeback_fb_id_property;
	struct drm_property *writeback_pixel_formats_property;
	struct drm_property *writeback_out_fence_ptr_property;
	struct drm_property *hdr_output_metadata_property;
	struct drm_property *content_protection_property;
	struct drm_property *hdcp_content_type_property;
	uint32_t preferred_depth;
	uint32_t prefer_shadow;
	bool quirk_addfb_prefer_xbgr_30bpp;
	bool quirk_addfb_prefer_host_byte_order;
	bool async_page_flip;
	bool fb_modifiers_not_supported;
	bool normalize_zpos;
	struct drm_property *modifiers_property;
	struct drm_property *size_hints_property;
	uint32_t cursor_width;
	uint32_t cursor_height;
	struct drm_atomic_state *suspend_state;
	const struct drm_mode_config_helper_funcs *helper_private;
};

struct drm_vram_mm;

struct drm_driver;

struct drm_minor;

struct drm_master;

struct drm_vblank_crtc;

struct drm_vma_offset_manager;

struct drm_fb_helper;

struct drm_device {
	int if_version;
	struct kref ref;
	struct device *dev;
	struct {
		struct list_head resources;
		void *final_kfree;
		spinlock_t lock;
	} managed;
	const struct drm_driver *driver;
	void *dev_private;
	struct drm_minor *primary;
	struct drm_minor *render;
	struct drm_minor *accel;
	bool registered;
	struct drm_master *master;
	u32 driver_features;
	bool unplugged;
	struct inode *anon_inode;
	char *unique;
	struct mutex struct_mutex;
	struct mutex master_mutex;
	atomic_t open_count;
	struct mutex filelist_mutex;
	struct list_head filelist;
	struct list_head filelist_internal;
	struct mutex clientlist_mutex;
	struct list_head clientlist;
	bool vblank_disable_immediate;
	struct drm_vblank_crtc *vblank;
	spinlock_t vblank_time_lock;
	spinlock_t vbl_lock;
	u32 max_vblank_count;
	struct list_head vblank_event_list;
	spinlock_t event_lock;
	unsigned int num_crtcs;
	struct drm_mode_config mode_config;
	struct mutex object_name_lock;
	struct idr object_name_idr;
	struct drm_vma_offset_manager *vma_offset_manager;
	struct drm_vram_mm *vram_mm;
	enum switch_power_state switch_power_state;
	struct drm_fb_helper *fb_helper;
	struct dentry *debugfs_root;
};

struct kmsg_dump_detail;

struct kmsg_dumper {
	struct list_head list;
	void (*dump)(struct kmsg_dumper *, struct kmsg_dump_detail *);
	enum kmsg_dump_reason max_reason;
	bool registered;
};

struct drm_framebuffer;

struct drm_plane_funcs;

struct drm_plane_helper_funcs;

struct drm_plane {
	struct drm_device *dev;
	struct list_head head;
	char *name;
	struct drm_modeset_lock mutex;
	struct drm_mode_object base;
	uint32_t possible_crtcs;
	uint32_t *format_types;
	unsigned int format_count;
	bool format_default;
	uint64_t *modifiers;
	unsigned int modifier_count;
	struct drm_crtc *crtc;
	struct drm_framebuffer *fb;
	struct drm_framebuffer *old_fb;
	const struct drm_plane_funcs *funcs;
	struct drm_object_properties properties;
	enum drm_plane_type type;
	unsigned int index;
	const struct drm_plane_helper_funcs *helper_private;
	struct drm_plane_state *state;
	struct drm_property *alpha_property;
	struct drm_property *zpos_property;
	struct drm_property *rotation_property;
	struct drm_property *blend_mode_property;
	struct drm_property *color_encoding_property;
	struct drm_property *color_range_property;
	struct drm_property *scaling_filter_property;
	struct drm_property *hotspot_x_property;
	struct drm_property *hotspot_y_property;
	struct kmsg_dumper kmsg_panic;
};

struct ast_plane {
	struct drm_plane base;
	void *vaddr;
	u64 offset;
	long unsigned int size;
};

struct drm_crtc_crc_entry;

struct drm_crtc_crc {
	spinlock_t lock;
	const char *source;
	bool opened;
	bool overflow;
	struct drm_crtc_crc_entry *entries;
	int head;
	int tail;
	size_t values_cnt;
	wait_queue_head_t wq;
};

struct drm_crtc_funcs;

struct drm_crtc_helper_funcs;

struct drm_self_refresh_data;

struct drm_crtc {
	struct drm_device *dev;
	struct device_node *port;
	struct list_head head;
	char *name;
	struct drm_modeset_lock mutex;
	struct drm_mode_object base;
	struct drm_plane *primary;
	struct drm_plane *cursor;
	unsigned int index;
	int cursor_x;
	int cursor_y;
	bool enabled;
	struct drm_display_mode mode;
	struct drm_display_mode hwmode;
	int x;
	int y;
	const struct drm_crtc_funcs *funcs;
	uint32_t gamma_size;
	uint16_t *gamma_store;
	const struct drm_crtc_helper_funcs *helper_private;
	struct drm_object_properties properties;
	struct drm_property *scaling_filter_property;
	struct drm_crtc_state *state;
	struct list_head commit_list;
	spinlock_t commit_lock;
	struct dentry *debugfs_entry;
	struct drm_crtc_crc crc;
	unsigned int fence_context;
	spinlock_t fence_lock;
	long unsigned int fence_seqno;
	char timeline_name[32];
	struct drm_self_refresh_data *self_refresh_data;
};

struct drm_encoder_funcs;

struct drm_encoder_helper_funcs;

struct drm_encoder {
	struct drm_device *dev;
	struct list_head head;
	struct drm_mode_object base;
	char *name;
	int encoder_type;
	unsigned int index;
	uint32_t possible_crtcs;
	uint32_t possible_clones;
	struct drm_crtc *crtc;
	struct list_head bridge_chain;
	const struct drm_encoder_funcs *funcs;
	const struct drm_encoder_helper_funcs *helper_private;
	struct dentry *debugfs_entry;
};

struct firmware;

struct ast_device {
	struct drm_device base;
	void *regs;
	void *ioregs;
	void *dp501_fw_buf;
	enum ast_config_mode config_mode;
	enum ast_chip chip;
	uint32_t dram_bus_width;
	uint32_t dram_type;
	uint32_t mclk;
	void *vram;
	long unsigned int vram_base;
	long unsigned int vram_size;
	long unsigned int vram_fb_available;
	struct mutex modeset_lock;
	enum ast_tx_chip tx_chip;
	struct ast_plane primary_plane;
	struct ast_plane cursor_plane;
	struct drm_crtc crtc;
	union {
		struct {
			struct drm_encoder encoder;
			struct ast_connector connector;
		} vga;
		struct {
			struct drm_encoder encoder;
			struct ast_connector connector;
		} sil164;
		struct {
			struct drm_encoder encoder;
			struct ast_connector connector;
		} dp501;
		struct {
			struct drm_encoder encoder;
			struct ast_connector connector;
		} astdp;
	} output;
	bool support_wide_screen;
	u8 *dp501_fw_addr;
	const struct firmware *dp501_fw;
};

struct ast_dramstruct {
	u16 index;
	u32 data;
};

struct ast_vbios_dclk_info {
	u8 param1;
	u8 param2;
	u8 param3;
};

struct ast_vbios_enhtable {
	u32 ht;
	u32 hde;
	u32 hfp;
	u32 hsync;
	u32 vt;
	u32 vde;
	u32 vfp;
	u32 vsync;
	u32 dclk_index;
	u32 flags;
	u32 refresh_rate;
	u32 refresh_rate_index;
	u32 mode_id;
};

struct ast_vbios_stdtable {
	u8 misc;
	u8 seq[4];
	u8 crtc[25];
	u8 ar[20];
	u8 gr[9];
};

struct asym_cap_data {
	struct list_head link;
	struct callback_head rcu;
	long unsigned int capacity;
	long unsigned int cpus[0];
};

struct asymmetric_key_id {
	short unsigned int len;
	unsigned char data[0];
};

struct asymmetric_key_ids {
	void *id[3];
};

struct key_preparsed_payload;

struct asymmetric_key_parser {
	struct list_head link;
	struct module *owner;
	const char *name;
	int (*parse)(struct key_preparsed_payload *);
};

struct key;

struct seq_file;

struct kernel_pkey_params;

struct kernel_pkey_query;

struct public_key_signature;

struct asymmetric_key_subtype {
	struct module *owner;
	const char *name;
	short unsigned int name_len;
	void (*describe)(const struct key *, struct seq_file *);
	void (*destroy)(void *, void *);
	int (*query)(const struct kernel_pkey_params *, struct kernel_pkey_query *);
	int (*eds_op)(struct kernel_pkey_params *, const void *, void *);
	int (*verify_signature)(const struct key *, const struct public_key_signature *);
};

struct usb_dev_state;

struct pid;

struct urb;

struct usb_memory;

struct async {
	struct list_head asynclist;
	struct usb_dev_state *ps;
	struct pid *pid;
	const struct cred *cred;
	unsigned int signr;
	unsigned int ifnum;
	void *userbuffer;
	void *userurb;
	sigval_t userurb_sigval;
	struct urb *urb;
	struct usb_memory *usbm;
	unsigned int mem_usage;
	int status;
	u8 bulk_addr;
	u8 bulk_status;
};

struct btrfs_work;

typedef void (*btrfs_func_t)(struct btrfs_work *);

typedef void (*btrfs_ordered_func_t)(struct btrfs_work *, bool);

struct btrfs_workqueue;

struct btrfs_work {
	btrfs_func_t func;
	btrfs_ordered_func_t ordered_func;
	struct work_struct normal_work;
	struct list_head ordered_list;
	struct btrfs_workqueue *wq;
	long unsigned int flags;
};

struct btrfs_inode;

struct cgroup_subsys_state;

struct async_cow;

struct async_chunk {
	struct btrfs_inode *inode;
	struct folio *locked_folio;
	u64 start;
	u64 end;
	blk_opf_t write_flags;
	struct list_head extents;
	struct cgroup_subsys_state *blkcg_css;
	struct btrfs_work work;
	struct async_cow *async_cow;
};

struct async_cow {
	atomic_t num_chunks;
	struct async_chunk chunks[0];
};

struct async_domain {
	struct list_head pending;
	unsigned int registered: 1;
};

typedef void (*async_func_t)(void *, async_cookie_t);

struct async_entry {
	struct list_head domain_list;
	struct list_head global_list;
	struct work_struct work;
	async_cookie_t cookie;
	async_func_t func;
	void *data;
	struct async_domain *domain;
};

struct async_extent {
	u64 start;
	u64 ram_size;
	u64 compressed_size;
	struct folio **folios;
	long unsigned int nr_folios;
	int compress_type;
	struct list_head list;
};

struct io_poll {
	struct file *file;
	struct wait_queue_head *head;
	__poll_t events;
	int retries;
	struct wait_queue_entry wait;
};

struct async_poll {
	struct io_poll poll;
	struct io_poll *double_poll;
};

struct async_scan_data {
	struct list_head list;
	struct Scsi_Host *shost;
	struct completion prev_finished;
};

struct nvme_ctrl;

struct async_scan_info {
	struct nvme_ctrl *ctrl;
	atomic_t next_nsid;
	__le32 *ns_list;
};

struct btrfs_device;

struct btrfs_io_context;

struct btrfs_io_stripe {
	struct btrfs_device *dev;
	u64 physical;
	u64 length;
	bool rst_search_commit_root;
	struct btrfs_io_context *bioc;
};

struct btrfs_bio;

struct async_submit_bio {
	struct btrfs_bio *bbio;
	struct btrfs_io_context *bioc;
	struct btrfs_io_stripe smap;
	int mirror_num;
	struct btrfs_work work;
};

struct ata_acpi_drive {
	u32 pio;
	u32 dma;
};

struct ata_acpi_gtf {
	u8 tf[7];
};

struct ata_acpi_gtm {
	struct ata_acpi_drive drive[2];
	u32 flags;
};

struct ata_device;

struct ata_acpi_hotplug_context {
	struct acpi_hotplug_context hp;
	union {
		struct ata_port *ap;
		struct ata_device *dev;
	} data;
};

struct ata_bmdma_prd {
	__le32 addr;
	__le32 flags_len;
};

struct ata_cdl {
	u8 desc_log_buf[512];
	u8 ncq_sense_log_buf[1024];
};

struct ata_cpr {
	u8 num;
	u8 num_storage_elements;
	u64 start_lba;
	u64 num_lbas;
};

struct ata_cpr_log {
	u8 nr_cpr;
	struct ata_cpr cpr[0];
};

struct ata_dev_quirks_entry {
	const char *model_num;
	const char *model_rev;
	unsigned int quirks;
};

struct ata_ering_entry {
	unsigned int eflags;
	unsigned int err_mask;
	u64 timestamp;
};

struct ata_ering {
	int cursor;
	struct ata_ering_entry ring[32];
};

struct ata_device {
	struct ata_link *link;
	unsigned int devno;
	unsigned int quirks;
	long unsigned int flags;
	struct scsi_device *sdev;
	void *private_data;
	union acpi_object *gtf_cache;
	unsigned int gtf_filter;
	struct device tdev;
	u64 n_sectors;
	u64 n_native_sectors;
	unsigned int class;
	long unsigned int unpark_deadline;
	u8 pio_mode;
	u8 dma_mode;
	u8 xfer_mode;
	unsigned int xfer_shift;
	unsigned int multi_count;
	unsigned int max_sectors;
	unsigned int cdb_len;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	u16 cylinders;
	u16 heads;
	u16 sectors;
	long: 64;
	long: 64;
	long: 64;
	union {
		u16 id[256];
		u32 gscr[128];
	};
	u8 devslp_timing[8];
	u8 ncq_send_recv_cmds[20];
	u8 ncq_non_data_cmds[64];
	u32 zac_zoned_cap;
	u32 zac_zones_optimal_open;
	u32 zac_zones_optimal_nonseq;
	u32 zac_zones_max_open;
	struct ata_cpr_log *cpr_log;
	struct ata_cdl *cdl;
	int spdn_cnt;
	struct ata_ering ering;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	u8 sector_buf[512];
};

struct ata_eh_cmd_timeout_ent {
	const u8 *commands;
	const unsigned int *timeouts;
};

struct ata_eh_info {
	struct ata_device *dev;
	u32 serror;
	unsigned int err_mask;
	unsigned int action;
	unsigned int dev_action[2];
	unsigned int flags;
	unsigned int probe_mask;
	char desc[80];
	int desc_len;
};

struct ata_eh_context {
	struct ata_eh_info i;
	int tries[2];
	int cmd_timeout_idx[16];
	unsigned int classes[2];
	unsigned int did_probe_mask;
	unsigned int unloaded_mask;
	unsigned int saved_ncq_enabled;
	u8 saved_xfer_mode[2];
	long unsigned int last_reset;
};

struct ata_force_param {
	const char *name;
	u8 cbl;
	u8 spd_limit;
	unsigned int xfer_mask;
	unsigned int quirk_on;
	unsigned int quirk_off;
	u16 lflags_on;
	u16 lflags_off;
};

struct ata_force_ent {
	int port;
	int device;
	struct ata_force_param param;
};

struct ata_port_operations;

struct ata_host {
	spinlock_t lock;
	struct device *dev;
	void * const *iomap;
	unsigned int n_ports;
	unsigned int n_tags;
	void *private_data;
	struct ata_port_operations *ops;
	long unsigned int flags;
	struct kref kref;
	struct mutex eh_mutex;
	struct task_struct *eh_owner;
	struct ata_port *simplex_claimed;
	struct ata_port *ports[0];
};

struct transport_container {
	struct attribute_container ac;
	const struct attribute_group *statistics;
};

struct scsi_transport_template {
	struct transport_container host_attrs;
	struct transport_container target_attrs;
	struct transport_container device_attrs;
	int (*user_scan)(struct Scsi_Host *, uint, uint, u64);
	int device_size;
	int device_private_offset;
	int target_size;
	int target_private_offset;
	int host_size;
	unsigned int create_work_queue: 1;
	void (*eh_strategy_handler)(struct Scsi_Host *);
};

struct ata_internal {
	struct scsi_transport_template t;
	struct device_attribute private_port_attrs[3];
	struct device_attribute private_link_attrs[3];
	struct device_attribute private_dev_attrs[9];
	struct transport_container link_attr_cont;
	struct transport_container dev_attr_cont;
	struct device_attribute *link_attrs[4];
	struct device_attribute *port_attrs[4];
	struct device_attribute *dev_attrs[10];
};

struct ata_ioports {
	void *cmd_addr;
	void *data_addr;
	void *error_addr;
	void *feature_addr;
	void *nsect_addr;
	void *lbal_addr;
	void *lbam_addr;
	void *lbah_addr;
	void *device_addr;
	void *status_addr;
	void *command_addr;
	void *altstatus_addr;
	void *ctl_addr;
	void *bmdma_addr;
	void *scr_addr;
};

struct ata_link {
	struct ata_port *ap;
	int pmp;
	struct device tdev;
	unsigned int active_tag;
	u32 sactive;
	unsigned int flags;
	u32 saved_scontrol;
	unsigned int hw_sata_spd_limit;
	unsigned int sata_spd_limit;
	unsigned int sata_spd;
	enum ata_lpm_policy lpm_policy;
	struct ata_eh_info eh_info;
	struct ata_eh_context eh_context;
	long: 64;
	long: 64;
	struct ata_device device[2];
	long unsigned int last_lpm_change;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct ata_taskfile {
	long unsigned int flags;
	u8 protocol;
	u8 ctl;
	u8 hob_feature;
	u8 hob_nsect;
	u8 hob_lbal;
	u8 hob_lbam;
	u8 hob_lbah;
	union {
		u8 error;
		u8 feature;
	};
	u8 nsect;
	u8 lbal;
	u8 lbam;
	u8 lbah;
	u8 device;
	union {
		u8 status;
		u8 command;
	};
	u32 auxiliary;
};

struct scatterlist {
	long unsigned int page_link;
	unsigned int offset;
	unsigned int length;
	dma_addr_t dma_address;
};

struct ata_queued_cmd;

typedef void (*ata_qc_cb_t)(struct ata_queued_cmd *);

struct ata_queued_cmd {
	struct ata_port *ap;
	struct ata_device *dev;
	struct scsi_cmnd *scsicmd;
	void (*scsidone)(struct scsi_cmnd *);
	struct ata_taskfile tf;
	u8 cdb[16];
	long unsigned int flags;
	unsigned int tag;
	unsigned int hw_tag;
	unsigned int n_elem;
	unsigned int orig_n_elem;
	int dma_dir;
	unsigned int sect_size;
	unsigned int nbytes;
	unsigned int extrabytes;
	unsigned int curbytes;
	struct scatterlist sgent;
	struct scatterlist *sg;
	struct scatterlist *cursg;
	unsigned int cursg_ofs;
	unsigned int err_mask;
	struct ata_taskfile result_tf;
	ata_qc_cb_t complete_fn;
	void *private_data;
	void *lldd_task;
};

struct ata_port_stats {
	long unsigned int unhandled_irq;
	long unsigned int idle_irq;
	long unsigned int rw_reqbuf;
};

struct ata_port {
	struct Scsi_Host *scsi_host;
	struct ata_port_operations *ops;
	spinlock_t *lock;
	long unsigned int flags;
	unsigned int pflags;
	unsigned int print_id;
	unsigned int port_no;
	struct ata_ioports ioaddr;
	u8 ctl;
	u8 last_ctl;
	struct ata_link *sff_pio_task_link;
	struct delayed_work sff_pio_task;
	struct ata_bmdma_prd *bmdma_prd;
	dma_addr_t bmdma_prd_dma;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	unsigned int cbl;
	struct ata_queued_cmd qcmd[33];
	u64 qc_active;
	int nr_active_links;
	long: 64;
	long: 64;
	long: 64;
	struct ata_link link;
	struct ata_link *slave_link;
	int nr_pmp_links;
	struct ata_link *pmp_link;
	struct ata_link *excl_link;
	struct ata_port_stats stats;
	struct ata_host *host;
	struct device *dev;
	struct device tdev;
	struct mutex scsi_scan_mutex;
	struct delayed_work hotplug_task;
	struct delayed_work scsi_rescan_task;
	unsigned int hsm_task_state;
	struct list_head eh_done_q;
	wait_queue_head_t eh_wait_q;
	int eh_tries;
	struct completion park_req_pending;
	pm_message_t pm_mesg;
	enum ata_lpm_policy target_lpm_policy;
	struct timer_list fastdrain_timer;
	unsigned int fastdrain_cnt;
	async_cookie_t cookie;
	int em_message_type;
	void *private_data;
	struct ata_acpi_gtm __acpi_init_gtm;
};

struct ata_port_info {
	long unsigned int flags;
	long unsigned int link_flags;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	struct ata_port_operations *port_ops;
	void *private_data;
};

typedef int (*ata_prereset_fn_t)(struct ata_link *, long unsigned int);

typedef int (*ata_reset_fn_t)(struct ata_link *, unsigned int *, long unsigned int);

typedef void (*ata_postreset_fn_t)(struct ata_link *, unsigned int *);

struct ata_port_operations {
	int (*qc_defer)(struct ata_queued_cmd *);
	int (*check_atapi_dma)(struct ata_queued_cmd *);
	enum ata_completion_errors (*qc_prep)(struct ata_queued_cmd *);
	unsigned int (*qc_issue)(struct ata_queued_cmd *);
	void (*qc_fill_rtf)(struct ata_queued_cmd *);
	void (*qc_ncq_fill_rtf)(struct ata_port *, u64);
	int (*cable_detect)(struct ata_port *);
	unsigned int (*mode_filter)(struct ata_device *, unsigned int);
	void (*set_piomode)(struct ata_port *, struct ata_device *);
	void (*set_dmamode)(struct ata_port *, struct ata_device *);
	int (*set_mode)(struct ata_link *, struct ata_device **);
	unsigned int (*read_id)(struct ata_device *, struct ata_taskfile *, __le16 *);
	void (*dev_config)(struct ata_device *);
	void (*freeze)(struct ata_port *);
	void (*thaw)(struct ata_port *);
	ata_prereset_fn_t prereset;
	ata_reset_fn_t softreset;
	ata_reset_fn_t hardreset;
	ata_postreset_fn_t postreset;
	ata_prereset_fn_t pmp_prereset;
	ata_reset_fn_t pmp_softreset;
	ata_reset_fn_t pmp_hardreset;
	ata_postreset_fn_t pmp_postreset;
	void (*error_handler)(struct ata_port *);
	void (*lost_interrupt)(struct ata_port *);
	void (*post_internal_cmd)(struct ata_queued_cmd *);
	void (*sched_eh)(struct ata_port *);
	void (*end_eh)(struct ata_port *);
	int (*scr_read)(struct ata_link *, unsigned int, u32 *);
	int (*scr_write)(struct ata_link *, unsigned int, u32);
	void (*pmp_attach)(struct ata_port *);
	void (*pmp_detach)(struct ata_port *);
	int (*set_lpm)(struct ata_link *, enum ata_lpm_policy, unsigned int);
	int (*port_suspend)(struct ata_port *, pm_message_t);
	int (*port_resume)(struct ata_port *);
	int (*port_start)(struct ata_port *);
	void (*port_stop)(struct ata_port *);
	void (*host_stop)(struct ata_host *);
	void (*sff_dev_select)(struct ata_port *, unsigned int);
	void (*sff_set_devctl)(struct ata_port *, u8);
	u8 (*sff_check_status)(struct ata_port *);
	u8 (*sff_check_altstatus)(struct ata_port *);
	void (*sff_tf_load)(struct ata_port *, const struct ata_taskfile *);
	void (*sff_tf_read)(struct ata_port *, struct ata_taskfile *);
	void (*sff_exec_command)(struct ata_port *, const struct ata_taskfile *);
	unsigned int (*sff_data_xfer)(struct ata_queued_cmd *, unsigned char *, unsigned int, int);
	void (*sff_irq_on)(struct ata_port *);
	bool (*sff_irq_check)(struct ata_port *);
	void (*sff_irq_clear)(struct ata_port *);
	void (*sff_drain_fifo)(struct ata_queued_cmd *);
	void (*bmdma_setup)(struct ata_queued_cmd *);
	void (*bmdma_start)(struct ata_queued_cmd *);
	void (*bmdma_stop)(struct ata_queued_cmd *);
	u8 (*bmdma_status)(struct ata_port *);
	ssize_t (*em_show)(struct ata_port *, char *);
	ssize_t (*em_store)(struct ata_port *, const char *, size_t);
	ssize_t (*sw_activity_show)(struct ata_device *, char *);
	ssize_t (*sw_activity_store)(struct ata_device *, enum sw_activity);
	ssize_t (*transmit_led_message)(struct ata_port *, u32, ssize_t);
	const struct ata_port_operations *inherits;
};

struct ata_show_ering_arg {
	char *buf;
	int written;
};

struct ata_task_resp {
	u16 frame_len;
	u8 ending_fis[24];
};

struct ata_timing {
	short unsigned int mode;
	short unsigned int setup;
	short unsigned int act8b;
	short unsigned int rec8b;
	short unsigned int cyc8b;
	short unsigned int active;
	short unsigned int recover;
	short unsigned int dmack_hold;
	short unsigned int cycle;
	short unsigned int udma;
};

struct ata_xfer_ent {
	int shift;
	int bits;
	u8 base;
};

struct ps2dev;

typedef enum ps2_disposition (*ps2_pre_receive_handler_t)(struct ps2dev *, u8, unsigned int);

typedef void (*ps2_receive_handler_t)(struct ps2dev *, u8);

struct serio;

struct ps2dev {
	struct serio *serio;
	struct mutex cmd_mutex;
	wait_queue_head_t wait;
	long unsigned int flags;
	u8 cmdbuf[8];
	u8 cmdcnt;
	u8 nak;
	ps2_pre_receive_handler_t pre_receive_handler;
	ps2_receive_handler_t receive_handler;
};

struct vivaldi_data {
	u32 function_row_physmap[24];
	unsigned int num_function_row_keys;
};

struct atkbd {
	struct ps2dev ps2dev;
	struct input_dev *dev;
	char name[64];
	char phys[32];
	short unsigned int id;
	short unsigned int keycode[512];
	long unsigned int force_release_mask[8];
	unsigned char set;
	bool translated;
	bool extra;
	bool write;
	bool softrepeat;
	bool softraw;
	bool scroll;
	bool enabled;
	unsigned char emul;
	bool resend;
	bool release;
	long unsigned int xl_bit;
	unsigned int last;
	long unsigned int time;
	long unsigned int err_count;
	struct delayed_work event_work;
	long unsigned int event_jiffies;
	long unsigned int event_mask;
	struct mutex mutex;
	struct vivaldi_data vdata;
};

struct atomic_notifier_head {
	spinlock_t lock;
	struct notifier_block *head;
};

struct attribute_group {
	const char *name;
	umode_t (*is_visible)(struct kobject *, struct attribute *, int);
	umode_t (*is_bin_visible)(struct kobject *, const struct bin_attribute *, int);
	size_t (*bin_size)(struct kobject *, const struct bin_attribute *, int);
	struct attribute **attrs;
	union {
		struct bin_attribute **bin_attrs;
		const struct bin_attribute * const *bin_attrs_new;
	};
};

struct hdmi_audio_infoframe___2 {
	u8 type;
	u8 ver;
	u8 len;
	u8 checksum;
	u8 CC02_CT47;
	u8 SS01_SF24;
	u8 CXT04;
	u8 CA;
	u8 LFEPBL01_LSV36_DM_INH7;
};

struct dp_audio_infoframe {
	u8 type;
	u8 len;
	u8 ver;
	u8 CC02_CT47;
	u8 SS01_SF24;
	u8 CXT04;
	u8 CA;
	u8 LFEPBL01_LSV36_DM_INH7;
};

union audio_infoframe {
	struct hdmi_audio_infoframe___2 hdmi;
	struct dp_audio_infoframe dp;
	struct {
		struct {} __empty_bytes;
		u8 bytes[0];
	};
};

struct audit_aux_data {
	struct audit_aux_data *next;
	int type;
};

struct audit_cap_data {
	kernel_cap_t permitted;
	kernel_cap_t inheritable;
	union {
		unsigned int fE;
		kernel_cap_t effective;
	};
	kernel_cap_t ambient;
	kuid_t rootid;
};

struct audit_aux_data_bprm_fcaps {
	struct audit_aux_data d;
	struct audit_cap_data fcap;
	unsigned int fcap_ver;
	struct audit_cap_data old_pcap;
	struct audit_cap_data new_pcap;
};

struct lsm_prop_selinux {
	u32 secid;
};

struct lsm_prop_smack {};

struct lsm_prop_apparmor {
	struct aa_label *label;
};

struct lsm_prop_bpf {};

struct lsm_prop {
	struct lsm_prop_selinux selinux;
	struct lsm_prop_smack smack;
	struct lsm_prop_apparmor apparmor;
	struct lsm_prop_bpf bpf;
};

struct audit_aux_data_pids {
	struct audit_aux_data d;
	pid_t target_pid[16];
	kuid_t target_auid[16];
	kuid_t target_uid[16];
	unsigned int target_sessionid[16];
	struct lsm_prop target_ref[16];
	char target_comm[256];
	int pid_count;
};

struct audit_context;

struct audit_buffer {
	struct sk_buff *skb;
	struct audit_context *ctx;
	gfp_t gfp_mask;
};

struct audit_cache {
	const struct cred *ad_subj_cred;
	u64 ktime_ns_expiration[41];
};

struct audit_tree;

struct audit_node {
	struct list_head list;
	struct audit_tree *owner;
	unsigned int index;
};

struct fsnotify_mark;

struct audit_chunk {
	struct list_head hash;
	long unsigned int key;
	struct fsnotify_mark *mark;
	struct list_head trees;
	int count;
	atomic_long_t refs;
	struct callback_head head;
	struct audit_node owners[0];
};

struct timespec64 {
	time64_t tv_sec;
	long int tv_nsec;
};

struct filename;

struct audit_names {
	struct list_head list;
	struct filename *name;
	int name_len;
	bool hidden;
	long unsigned int ino;
	dev_t dev;
	umode_t mode;
	kuid_t uid;
	kgid_t gid;
	dev_t rdev;
	struct lsm_prop oprop;
	struct audit_cap_data fcap;
	unsigned int fcap_ver;
	unsigned char type;
	bool should_free;
};

struct mq_attr {
	__kernel_long_t mq_flags;
	__kernel_long_t mq_maxmsg;
	__kernel_long_t mq_msgsize;
	__kernel_long_t mq_curmsgs;
	__kernel_long_t __reserved[4];
};

struct open_how {
	__u64 flags;
	__u64 mode;
	__u64 resolve;
};

struct audit_ntp_val {
	long long int oldval;
	long long int newval;
};

struct audit_ntp_data {
	struct audit_ntp_val vals[6];
};

struct audit_proctitle {
	int len;
	char *value;
};

struct audit_tree_refs;

struct audit_context {
	int dummy;
	enum {
		AUDIT_CTX_UNUSED = 0,
		AUDIT_CTX_SYSCALL = 1,
		AUDIT_CTX_URING = 2,
	} context;
	enum audit_state state;
	enum audit_state current_state;
	unsigned int serial;
	int major;
	int uring_op;
	struct timespec64 ctime;
	long unsigned int argv[4];
	long int return_code;
	u64 prio;
	int return_valid;
	struct audit_names preallocated_names[5];
	int name_count;
	struct list_head names_list;
	char *filterkey;
	struct path pwd;
	struct audit_aux_data *aux;
	struct audit_aux_data *aux_pids;
	struct __kernel_sockaddr_storage *sockaddr;
	size_t sockaddr_len;
	pid_t ppid;
	kuid_t uid;
	kuid_t euid;
	kuid_t suid;
	kuid_t fsuid;
	kgid_t gid;
	kgid_t egid;
	kgid_t sgid;
	kgid_t fsgid;
	long unsigned int personality;
	int arch;
	pid_t target_pid;
	kuid_t target_auid;
	kuid_t target_uid;
	unsigned int target_sessionid;
	struct lsm_prop target_ref;
	char target_comm[16];
	struct audit_tree_refs *trees;
	struct audit_tree_refs *first_trees;
	struct list_head killed_trees;
	int tree_count;
	int type;
	union {
		struct {
			int nargs;
			long int args[6];
		} socketcall;
		struct {
			kuid_t uid;
			kgid_t gid;
			umode_t mode;
			struct lsm_prop oprop;
			int has_perm;
			uid_t perm_uid;
			gid_t perm_gid;
			umode_t perm_mode;
			long unsigned int qbytes;
		} ipc;
		struct {
			mqd_t mqdes;
			struct mq_attr mqstat;
		} mq_getsetattr;
		struct {
			mqd_t mqdes;
			int sigev_signo;
		} mq_notify;
		struct {
			mqd_t mqdes;
			size_t msg_len;
			unsigned int msg_prio;
			struct timespec64 abs_timeout;
		} mq_sendrecv;
		struct {
			int oflag;
			umode_t mode;
			struct mq_attr attr;
		} mq_open;
		struct {
			pid_t pid;
			struct audit_cap_data cap;
		} capset;
		struct {
			int fd;
			int flags;
		} mmap;
		struct open_how openat2;
		struct {
			int argc;
		} execve;
		struct {
			char *name;
		} module;
		struct {
			struct audit_ntp_data ntp_data;
			struct timespec64 tk_injoffset;
		} time;
	};
	int fds[2];
	struct audit_proctitle proctitle;
};

struct audit_ctl_mutex {
	struct mutex lock;
	void *owner;
};

struct audit_field;

struct audit_watch;

struct audit_fsnotify_mark;

struct audit_krule {
	u32 pflags;
	u32 flags;
	u32 listnr;
	u32 action;
	u32 mask[64];
	u32 buflen;
	u32 field_count;
	char *filterkey;
	struct audit_field *fields;
	struct audit_field *arch_f;
	struct audit_field *inode_f;
	struct audit_watch *watch;
	struct audi