//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappconfiguration_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appconfiguration/armappconfiguration/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appconfiguration/resource-manager/Microsoft.AppConfiguration/stable/2023-03-01/examples/CheckNameAvailable.json
func ExampleOperationsClient_CheckNameAvailability_configurationStoresCheckNameAvailable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOperationsClient().CheckNameAvailability(ctx, armappconfiguration.CheckNameAvailabilityParameters{
		Name: to.Ptr("contoso"),
		Type: to.Ptr(armappconfiguration.ConfigurationResourceTypeMicrosoftAppConfigurationConfigurationStores),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NameAvailabilityStatus = armappconfiguration.NameAvailabilityStatus{
	// 	Message: to.Ptr("The specified name is available."),
	// 	NameAvailable: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appconfiguration/resource-manager/Microsoft.AppConfiguration/stable/2023-03-01/examples/CheckNameNotAvailable.json
func ExampleOperationsClient_CheckNameAvailability_configurationStoresCheckNameNotAvailable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOperationsClient().CheckNameAvailability(ctx, armappconfiguration.CheckNameAvailabilityParameters{
		Name: to.Ptr("contoso"),
		Type: to.Ptr(armappconfiguration.ConfigurationResourceTypeMicrosoftAppConfigurationConfigurationStores),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NameAvailabilityStatus = armappconfiguration.NameAvailabilityStatus{
	// 	Message: to.Ptr("The specified name is already in use."),
	// 	NameAvailable: to.Ptr(false),
	// 	Reason: to.Ptr("AlreadyExists"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appconfiguration/resource-manager/Microsoft.AppConfiguration/stable/2023-03-01/examples/OperationsList.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(&armappconfiguration.OperationsClientListOptions{SkipToken: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationDefinitionListResult = armappconfiguration.OperationDefinitionListResult{
		// 	Value: []*armappconfiguration.OperationDefinition{
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/operations/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Lists all of the operations supported by Microsoft App Configuration."),
		// 				Operation: to.Ptr("List Operations"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Operation"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/register/action"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Registers a subscription to use Microsoft App Configuration."),
		// 				Operation: to.Ptr("Register for Microsoft App Configuration"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Microsoft App Configuration"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/unregister/action"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Unregisters a subscription from using Microsoft App Configuration."),
		// 				Operation: to.Ptr("Unregister for Microsoft App Configuration"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Microsoft App Configuration"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/locations/operationsStatus/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Get the status of an operation."),
		// 				Operation: to.Ptr("Get Operation Status"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/checkNameAvailability/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Check whether the resource name is available for use."),
		// 				Operation: to.Ptr("Check Name Availability"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/locations/checkNameAvailability/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Check whether the resource name is available for use."),
		// 				Operation: to.Ptr("Check Name Availability"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Gets the properties of the specified configuration store or lists all the configuration stores under the specified resource group or subscription."),
		// 				Operation: to.Ptr("Get Configuration Store or List Configuration Stores"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Configuration Store"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/write"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Create or update a configuration store with the specified parameters."),
		// 				Operation: to.Ptr("Create or Update Configuration Store"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Configuration Store"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/delete"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Deletes a configuration store."),
		// 				Operation: to.Ptr("Delete Configuration Store"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Configuration Store"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/ListKeys/action"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Lists the API keys for the specified configuration store."),
		// 				Operation: to.Ptr("List Configuration Store API Keys"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Configuration Store"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/RegenerateKey/action"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Regenerates of the API key's for the specified configuration store."),
		// 				Operation: to.Ptr("Regenerate Configuration Store API Key"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Configuration Store"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/ListKeyValue/action"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Lists a key-value for the specified configuration store."),
		// 				Operation: to.Ptr("List Configuration Store Key-Value"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Configuration Store"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/eventGridFilters/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Gets the properties of the specified configuration store event grid filter or lists all the configuration store event grid filters under the specified configuration store."),
		// 				Operation: to.Ptr("Get Configuration Store Event Grid Filter or List Configuration Store Event Grid Filters"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Configuration Store Event Grid Filter"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/eventGridFilters/write"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Create or update a configuration store event grid filter with the specified parameters."),
		// 				Operation: to.Ptr("Create or Update Configuration Store Event Grid Filter"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Configuration Store Event Grid Filter"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/eventGridFilters/delete"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Deletes a configuration store event grid filter."),
		// 				Operation: to.Ptr("Delete Configuration Store Event Grid Filter"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Configuration Store Event Grid Filter"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/providers/Microsoft.Insights/metricDefinitions/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Retrieve all metric definitions for Microsoft App Configuration."),
		// 				Operation: to.Ptr("Read Configuration Store Metric Definitions"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Microsoft App Configuration Metric Definition."),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr("System"),
		// 			Properties: &armappconfiguration.OperationProperties{
		// 				ServiceSpecification: &armappconfiguration.ServiceSpecification{
		// 					MetricSpecifications: []*armappconfiguration.MetricSpecification{
		// 						{
		// 							Name: to.Ptr("HttpIncomingRequestCount"),
		// 							AggregationType: to.Ptr("Count"),
		// 							Dimensions: []*armappconfiguration.MetricDimension{
		// 								{
		// 									Name: to.Ptr("StatusCode"),
		// 									DisplayName: to.Ptr("HttpStatusCode"),
		// 									InternalName: to.Ptr("StatusCode"),
		// 								},
		// 								{
		// 									Name: to.Ptr("Authentication"),
		// 									DisplayName: to.Ptr("AuthenticationScheme"),
		// 									InternalName: to.Ptr("Authentication"),
		// 							}},
		// 							DisplayDescription: to.Ptr("Total number of incoming http requests."),
		// 							DisplayName: to.Ptr("HttpIncomingRequestCount"),
		// 							FillGapWithZero: to.Ptr(true),
		// 							InternalMetricName: to.Ptr("HttpIncomingRequestCount"),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("HttpIncomingRequestDuration"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Dimensions: []*armappconfiguration.MetricDimension{
		// 								{
		// 									Name: to.Ptr("StatusCode"),
		// 									DisplayName: to.Ptr("HttpStatusCode"),
		// 									InternalName: to.Ptr("StatusCode"),
		// 								},
		// 								{
		// 									Name: to.Ptr("Authentication"),
		// 									DisplayName: to.Ptr("AuthenticationScheme"),
		// 									InternalName: to.Ptr("Authentication"),
		// 							}},
		// 							DisplayDescription: to.Ptr("Latency on an http request."),
		// 							DisplayName: to.Ptr("HttpIncomingRequestDuration"),
		// 							FillGapWithZero: to.Ptr(true),
		// 							InternalMetricName: to.Ptr("HttpIncomingRequestDuration"),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("ThrottledHttpRequestCount"),
		// 							AggregationType: to.Ptr("Count"),
		// 							DisplayDescription: to.Ptr("Throttled http requests."),
		// 							DisplayName: to.Ptr("ThrottledHttpRequestCount"),
		// 							FillGapWithZero: to.Ptr(true),
		// 							InternalMetricName: to.Ptr("ThrottledHttpRequestCount"),
		// 							Unit: to.Ptr("Count"),
		// 					}},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/providers/Microsoft.Insights/diagnosticSettings/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Read all Diagnostic Settings values for a Configuration Store."),
		// 				Operation: to.Ptr("Read Configuration Store Diagnostic Settings"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Configuration Store"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr("System"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/providers/Microsoft.Insights/diagnosticSettings/write"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Write/Overwrite Diagnostic Settings for Microsoft App Configuration."),
		// 				Operation: to.Ptr("Write Configuration Store Diagnostic Settings"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Configuration Store"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr("System"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/providers/Microsoft.Insights/logDefinitions/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Retrieve all log definitions for Microsoft App Configuration."),
		// 				Operation: to.Ptr("Read Configuration Store Log Definitions"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Microsoft App Configuration Log Definition."),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Properties: &armappconfiguration.OperationProperties{
		// 				ServiceSpecification: &armappconfiguration.ServiceSpecification{
		// 					LogSpecifications: []*armappconfiguration.LogSpecification{
		// 						{
		// 							Name: to.Ptr("HttpRequest"),
		// 							DisplayName: to.Ptr("HTTP Requests"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Audit"),
		// 							DisplayName: to.Ptr("Audit"),
		// 					}},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/privateEndpointConnectionProxies/validate/action"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Validate a private endpoint connection proxy under the specified configuration store."),
		// 				Operation: to.Ptr("Validate Private Endpoint Connection Proxy"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Private Endpoint Connection Proxy"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/privateEndpointConnectionProxies/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Get a private endpoint connection proxy under the specified configuration store."),
		// 				Operation: to.Ptr("Get Private Endpoint Connection Proxy"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Private Endpoint Connection Proxy"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/privateEndpointConnectionProxies/write"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Create or update a private endpoint connection proxy under the specified configuration store."),
		// 				Operation: to.Ptr("Create or Update Private Endpoint Connection Proxy"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Private Endpoint Connection Proxy"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/privateEndpointConnectionProxies/delete"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Delete a private endpoint connection proxy under the specified configuration store."),
		// 				Operation: to.Ptr("Delete Private Endpoint Connection Proxy"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Private Endpoint Connection Proxy"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/privateEndpointConnections/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Get a private endpoint connection or list private endpoint connections under the specified configuration store."),
		// 				Operation: to.Ptr("Get Private Endpoint Connection or List Private Endpoint Connections"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Private Endpoint Connection"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/privateEndpointConnections/write"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Approve or reject a private endpoint connection under the specified configuration store."),
		// 				Operation: to.Ptr("Approve or Reject Private Endpoint Connection"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Private Endpoint Connection"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/privateEndpointConnections/delete"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Delete a private endpoint connection under the specified configuration store."),
		// 				Operation: to.Ptr("Delete Private Endpoint Connection"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Private Endpoint Connection"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/PrivateEndpointConnectionsApproval/action"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Auto-Approve a private endpoint connection under the specified configuration store."),
		// 				Operation: to.Ptr("Auto-Approve Private Endpoint Connection"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Private Endpoint Connection"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/privateLinkResources/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Lists all the private link resources under the specified configuration store."),
		// 				Operation: to.Ptr("List Private Link"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Private Link"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/keyValues/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Reads a key-value from the configuration store."),
		// 				Operation: to.Ptr("Read Key-Value"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Key-Value"),
		// 			},
		// 			IsDataAction: to.Ptr(true),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/keyValues/write"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Creates or updates a key-value in the configuration store."),
		// 				Operation: to.Ptr("Write Key-Value"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Key-Value"),
		// 			},
		// 			IsDataAction: to.Ptr(true),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/configurationStores/keyValues/delete"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Deletes an existing key-value from the configuration store."),
		// 				Operation: to.Ptr("Delete Key-Value"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Key-Value"),
		// 			},
		// 			IsDataAction: to.Ptr(true),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/locations/deletedConfigurationStores/read"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Gets the properties of the specified deleted configuration store or lists all the deleted configuration stores under the specified subscription."),
		// 				Operation: to.Ptr("Get Deleted Configuration Store or List Deleted Configuration Stores"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Deleted Configuration Store"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AppConfiguration/locations/deletedConfigurationStores/purge/action"),
		// 			Display: &armappconfiguration.OperationDefinitionDisplay{
		// 				Description: to.Ptr("Purge the specified deleted configuration store."),
		// 				Operation: to.Ptr("Purge Deleted Configuration Store"),
		// 				Provider: to.Ptr("Microsoft App Configuration"),
		// 				Resource: to.Ptr("Deleted Configuration Store"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appconfiguration/resource-manager/Microsoft.AppConfiguration/stable/2023-03-01/examples/RegionalCheckNameAvailable.json
func ExampleOperationsClient_RegionalCheckNameAvailability_configurationStoresCheckNameAvailable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOperationsClient().RegionalCheckNameAvailability(ctx, "westus", armappconfiguration.CheckNameAvailabilityParameters{
		Name: to.Ptr("contoso"),
		Type: to.Ptr(armappconfiguration.ConfigurationResourceTypeMicrosoftAppConfigurationConfigurationStores),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NameAvailabilityStatus = armappconfiguration.NameAvailabilityStatus{
	// 	Message: to.Ptr("The specified name is available."),
	// 	NameAvailable: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appconfiguration/resource-manager/Microsoft.AppConfiguration/stable/2023-03-01/examples/RegionalCheckNameNotAvailable.json
func ExampleOperationsClient_RegionalCheckNameAvailability_configurationStoresCheckNameNotAvailable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOperationsClient().RegionalCheckNameAvailability(ctx, "westus", armappconfiguration.CheckNameAvailabilityParameters{
		Name: to.Ptr("contoso"),
		Type: to.Ptr(armappconfiguration.ConfigurationResourceTypeMicrosoftAppConfigurationConfigurationStores),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NameAvailabilityStatus = armappconfiguration.NameAvailabilityStatus{
	// 	Message: to.Ptr("The specified name is already in use."),
	// 	NameAvailable: to.Ptr(false),
	// 	Reason: to.Ptr("AlreadyExists"),
	// }
}
