//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armbatch.ClientFactory type.
type ServerFactory struct {
	AccountServer                   AccountServer
	ApplicationServer               ApplicationServer
	ApplicationPackageServer        ApplicationPackageServer
	CertificateServer               CertificateServer
	LocationServer                  LocationServer
	OperationsServer                OperationsServer
	PoolServer                      PoolServer
	PrivateEndpointConnectionServer PrivateEndpointConnectionServer
	PrivateLinkResourceServer       PrivateLinkResourceServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armbatch.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armbatch.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                               *ServerFactory
	trMu                              sync.Mutex
	trAccountServer                   *AccountServerTransport
	trApplicationServer               *ApplicationServerTransport
	trApplicationPackageServer        *ApplicationPackageServerTransport
	trCertificateServer               *CertificateServerTransport
	trLocationServer                  *LocationServerTransport
	trOperationsServer                *OperationsServerTransport
	trPoolServer                      *PoolServerTransport
	trPrivateEndpointConnectionServer *PrivateEndpointConnectionServerTransport
	trPrivateLinkResourceServer       *PrivateLinkResourceServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AccountClient":
		initServer(s, &s.trAccountServer, func() *AccountServerTransport { return NewAccountServerTransport(&s.srv.AccountServer) })
		resp, err = s.trAccountServer.Do(req)
	case "ApplicationClient":
		initServer(s, &s.trApplicationServer, func() *ApplicationServerTransport { return NewApplicationServerTransport(&s.srv.ApplicationServer) })
		resp, err = s.trApplicationServer.Do(req)
	case "ApplicationPackageClient":
		initServer(s, &s.trApplicationPackageServer, func() *ApplicationPackageServerTransport {
			return NewApplicationPackageServerTransport(&s.srv.ApplicationPackageServer)
		})
		resp, err = s.trApplicationPackageServer.Do(req)
	case "CertificateClient":
		initServer(s, &s.trCertificateServer, func() *CertificateServerTransport { return NewCertificateServerTransport(&s.srv.CertificateServer) })
		resp, err = s.trCertificateServer.Do(req)
	case "LocationClient":
		initServer(s, &s.trLocationServer, func() *LocationServerTransport { return NewLocationServerTransport(&s.srv.LocationServer) })
		resp, err = s.trLocationServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PoolClient":
		initServer(s, &s.trPoolServer, func() *PoolServerTransport { return NewPoolServerTransport(&s.srv.PoolServer) })
		resp, err = s.trPoolServer.Do(req)
	case "PrivateEndpointConnectionClient":
		initServer(s, &s.trPrivateEndpointConnectionServer, func() *PrivateEndpointConnectionServerTransport {
			return NewPrivateEndpointConnectionServerTransport(&s.srv.PrivateEndpointConnectionServer)
		})
		resp, err = s.trPrivateEndpointConnectionServer.Do(req)
	case "PrivateLinkResourceClient":
		initServer(s, &s.trPrivateLinkResourceServer, func() *PrivateLinkResourceServerTransport {
			return NewPrivateLinkResourceServerTransport(&s.srv.PrivateLinkResourceServer)
		})
		resp, err = s.trPrivateLinkResourceServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
