//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/edgeorder/armedgeorder"
	"net/http"
	"net/url"
	"regexp"
)

// ManagementServer is a fake server for instances of the armedgeorder.ManagementClient type.
type ManagementServer struct {
	// CancelOrderItem is the fake for method ManagementClient.CancelOrderItem
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	CancelOrderItem func(ctx context.Context, orderItemName string, resourceGroupName string, cancellationReason armedgeorder.CancellationReason, options *armedgeorder.ManagementClientCancelOrderItemOptions) (resp azfake.Responder[armedgeorder.ManagementClientCancelOrderItemResponse], errResp azfake.ErrorResponder)

	// BeginCreateAddress is the fake for method ManagementClient.BeginCreateAddress
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateAddress func(ctx context.Context, addressName string, resourceGroupName string, addressResource armedgeorder.AddressResource, options *armedgeorder.ManagementClientBeginCreateAddressOptions) (resp azfake.PollerResponder[armedgeorder.ManagementClientCreateAddressResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrderItem is the fake for method ManagementClient.BeginCreateOrderItem
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrderItem func(ctx context.Context, orderItemName string, resourceGroupName string, orderItemResource armedgeorder.OrderItemResource, options *armedgeorder.ManagementClientBeginCreateOrderItemOptions) (resp azfake.PollerResponder[armedgeorder.ManagementClientCreateOrderItemResponse], errResp azfake.ErrorResponder)

	// BeginDeleteAddressByName is the fake for method ManagementClient.BeginDeleteAddressByName
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteAddressByName func(ctx context.Context, addressName string, resourceGroupName string, options *armedgeorder.ManagementClientBeginDeleteAddressByNameOptions) (resp azfake.PollerResponder[armedgeorder.ManagementClientDeleteAddressByNameResponse], errResp azfake.ErrorResponder)

	// BeginDeleteOrderItemByName is the fake for method ManagementClient.BeginDeleteOrderItemByName
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteOrderItemByName func(ctx context.Context, orderItemName string, resourceGroupName string, options *armedgeorder.ManagementClientBeginDeleteOrderItemByNameOptions) (resp azfake.PollerResponder[armedgeorder.ManagementClientDeleteOrderItemByNameResponse], errResp azfake.ErrorResponder)

	// GetAddressByName is the fake for method ManagementClient.GetAddressByName
	// HTTP status codes to indicate success: http.StatusOK
	GetAddressByName func(ctx context.Context, addressName string, resourceGroupName string, options *armedgeorder.ManagementClientGetAddressByNameOptions) (resp azfake.Responder[armedgeorder.ManagementClientGetAddressByNameResponse], errResp azfake.ErrorResponder)

	// GetOrderByName is the fake for method ManagementClient.GetOrderByName
	// HTTP status codes to indicate success: http.StatusOK
	GetOrderByName func(ctx context.Context, orderName string, resourceGroupName string, location string, options *armedgeorder.ManagementClientGetOrderByNameOptions) (resp azfake.Responder[armedgeorder.ManagementClientGetOrderByNameResponse], errResp azfake.ErrorResponder)

	// GetOrderItemByName is the fake for method ManagementClient.GetOrderItemByName
	// HTTP status codes to indicate success: http.StatusOK
	GetOrderItemByName func(ctx context.Context, orderItemName string, resourceGroupName string, options *armedgeorder.ManagementClientGetOrderItemByNameOptions) (resp azfake.Responder[armedgeorder.ManagementClientGetOrderItemByNameResponse], errResp azfake.ErrorResponder)

	// NewListAddressesAtResourceGroupLevelPager is the fake for method ManagementClient.NewListAddressesAtResourceGroupLevelPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAddressesAtResourceGroupLevelPager func(resourceGroupName string, options *armedgeorder.ManagementClientListAddressesAtResourceGroupLevelOptions) (resp azfake.PagerResponder[armedgeorder.ManagementClientListAddressesAtResourceGroupLevelResponse])

	// NewListAddressesAtSubscriptionLevelPager is the fake for method ManagementClient.NewListAddressesAtSubscriptionLevelPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAddressesAtSubscriptionLevelPager func(options *armedgeorder.ManagementClientListAddressesAtSubscriptionLevelOptions) (resp azfake.PagerResponder[armedgeorder.ManagementClientListAddressesAtSubscriptionLevelResponse])

	// NewListConfigurationsPager is the fake for method ManagementClient.NewListConfigurationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListConfigurationsPager func(configurationsRequest armedgeorder.ConfigurationsRequest, options *armedgeorder.ManagementClientListConfigurationsOptions) (resp azfake.PagerResponder[armedgeorder.ManagementClientListConfigurationsResponse])

	// NewListOperationsPager is the fake for method ManagementClient.NewListOperationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListOperationsPager func(options *armedgeorder.ManagementClientListOperationsOptions) (resp azfake.PagerResponder[armedgeorder.ManagementClientListOperationsResponse])

	// NewListOrderAtResourceGroupLevelPager is the fake for method ManagementClient.NewListOrderAtResourceGroupLevelPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListOrderAtResourceGroupLevelPager func(resourceGroupName string, options *armedgeorder.ManagementClientListOrderAtResourceGroupLevelOptions) (resp azfake.PagerResponder[armedgeorder.ManagementClientListOrderAtResourceGroupLevelResponse])

	// NewListOrderAtSubscriptionLevelPager is the fake for method ManagementClient.NewListOrderAtSubscriptionLevelPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListOrderAtSubscriptionLevelPager func(options *armedgeorder.ManagementClientListOrderAtSubscriptionLevelOptions) (resp azfake.PagerResponder[armedgeorder.ManagementClientListOrderAtSubscriptionLevelResponse])

	// NewListOrderItemsAtResourceGroupLevelPager is the fake for method ManagementClient.NewListOrderItemsAtResourceGroupLevelPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListOrderItemsAtResourceGroupLevelPager func(resourceGroupName string, options *armedgeorder.ManagementClientListOrderItemsAtResourceGroupLevelOptions) (resp azfake.PagerResponder[armedgeorder.ManagementClientListOrderItemsAtResourceGroupLevelResponse])

	// NewListOrderItemsAtSubscriptionLevelPager is the fake for method ManagementClient.NewListOrderItemsAtSubscriptionLevelPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListOrderItemsAtSubscriptionLevelPager func(options *armedgeorder.ManagementClientListOrderItemsAtSubscriptionLevelOptions) (resp azfake.PagerResponder[armedgeorder.ManagementClientListOrderItemsAtSubscriptionLevelResponse])

	// NewListProductFamiliesPager is the fake for method ManagementClient.NewListProductFamiliesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListProductFamiliesPager func(productFamiliesRequest armedgeorder.ProductFamiliesRequest, options *armedgeorder.ManagementClientListProductFamiliesOptions) (resp azfake.PagerResponder[armedgeorder.ManagementClientListProductFamiliesResponse])

	// NewListProductFamiliesMetadataPager is the fake for method ManagementClient.NewListProductFamiliesMetadataPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListProductFamiliesMetadataPager func(options *armedgeorder.ManagementClientListProductFamiliesMetadataOptions) (resp azfake.PagerResponder[armedgeorder.ManagementClientListProductFamiliesMetadataResponse])

	// BeginReturnOrderItem is the fake for method ManagementClient.BeginReturnOrderItem
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginReturnOrderItem func(ctx context.Context, orderItemName string, resourceGroupName string, returnOrderItemDetails armedgeorder.ReturnOrderItemDetails, options *armedgeorder.ManagementClientBeginReturnOrderItemOptions) (resp azfake.PollerResponder[armedgeorder.ManagementClientReturnOrderItemResponse], errResp azfake.ErrorResponder)

	// BeginUpdateAddress is the fake for method ManagementClient.BeginUpdateAddress
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateAddress func(ctx context.Context, addressName string, resourceGroupName string, addressUpdateParameter armedgeorder.AddressUpdateParameter, options *armedgeorder.ManagementClientBeginUpdateAddressOptions) (resp azfake.PollerResponder[armedgeorder.ManagementClientUpdateAddressResponse], errResp azfake.ErrorResponder)

	// BeginUpdateOrderItem is the fake for method ManagementClient.BeginUpdateOrderItem
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateOrderItem func(ctx context.Context, orderItemName string, resourceGroupName string, orderItemUpdateParameter armedgeorder.OrderItemUpdateParameter, options *armedgeorder.ManagementClientBeginUpdateOrderItemOptions) (resp azfake.PollerResponder[armedgeorder.ManagementClientUpdateOrderItemResponse], errResp azfake.ErrorResponder)
}

// NewManagementServerTransport creates a new instance of ManagementServerTransport with the provided implementation.
// The returned ManagementServerTransport instance is connected to an instance of armedgeorder.ManagementClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagementServerTransport(srv *ManagementServer) *ManagementServerTransport {
	return &ManagementServerTransport{
		srv:                        srv,
		beginCreateAddress:         newTracker[azfake.PollerResponder[armedgeorder.ManagementClientCreateAddressResponse]](),
		beginCreateOrderItem:       newTracker[azfake.PollerResponder[armedgeorder.ManagementClientCreateOrderItemResponse]](),
		beginDeleteAddressByName:   newTracker[azfake.PollerResponder[armedgeorder.ManagementClientDeleteAddressByNameResponse]](),
		beginDeleteOrderItemByName: newTracker[azfake.PollerResponder[armedgeorder.ManagementClientDeleteOrderItemByNameResponse]](),
		newListAddressesAtResourceGroupLevelPager:  newTracker[azfake.PagerResponder[armedgeorder.ManagementClientListAddressesAtResourceGroupLevelResponse]](),
		newListAddressesAtSubscriptionLevelPager:   newTracker[azfake.PagerResponder[armedgeorder.ManagementClientListAddressesAtSubscriptionLevelResponse]](),
		newListConfigurationsPager:                 newTracker[azfake.PagerResponder[armedgeorder.ManagementClientListConfigurationsResponse]](),
		newListOperationsPager:                     newTracker[azfake.PagerResponder[armedgeorder.ManagementClientListOperationsResponse]](),
		newListOrderAtResourceGroupLevelPager:      newTracker[azfake.PagerResponder[armedgeorder.ManagementClientListOrderAtResourceGroupLevelResponse]](),
		newListOrderAtSubscriptionLevelPager:       newTracker[azfake.PagerResponder[armedgeorder.ManagementClientListOrderAtSubscriptionLevelResponse]](),
		newListOrderItemsAtResourceGroupLevelPager: newTracker[azfake.PagerResponder[armedgeorder.ManagementClientListOrderItemsAtResourceGroupLevelResponse]](),
		newListOrderItemsAtSubscriptionLevelPager:  newTracker[azfake.PagerResponder[armedgeorder.ManagementClientListOrderItemsAtSubscriptionLevelResponse]](),
		newListProductFamiliesPager:                newTracker[azfake.PagerResponder[armedgeorder.ManagementClientListProductFamiliesResponse]](),
		newListProductFamiliesMetadataPager:        newTracker[azfake.PagerResponder[armedgeorder.ManagementClientListProductFamiliesMetadataResponse]](),
		beginReturnOrderItem:                       newTracker[azfake.PollerResponder[armedgeorder.ManagementClientReturnOrderItemResponse]](),
		beginUpdateAddress:                         newTracker[azfake.PollerResponder[armedgeorder.ManagementClientUpdateAddressResponse]](),
		beginUpdateOrderItem:                       newTracker[azfake.PollerResponder[armedgeorder.ManagementClientUpdateOrderItemResponse]](),
	}
}

// ManagementServerTransport connects instances of armedgeorder.ManagementClient to instances of ManagementServer.
// Don't use this type directly, use NewManagementServerTransport instead.
type ManagementServerTransport struct {
	srv                                        *ManagementServer
	beginCreateAddress                         *tracker[azfake.PollerResponder[armedgeorder.ManagementClientCreateAddressResponse]]
	beginCreateOrderItem                       *tracker[azfake.PollerResponder[armedgeorder.ManagementClientCreateOrderItemResponse]]
	beginDeleteAddressByName                   *tracker[azfake.PollerResponder[armedgeorder.ManagementClientDeleteAddressByNameResponse]]
	beginDeleteOrderItemByName                 *tracker[azfake.PollerResponder[armedgeorder.ManagementClientDeleteOrderItemByNameResponse]]
	newListAddressesAtResourceGroupLevelPager  *tracker[azfake.PagerResponder[armedgeorder.ManagementClientListAddressesAtResourceGroupLevelResponse]]
	newListAddressesAtSubscriptionLevelPager   *tracker[azfake.PagerResponder[armedgeorder.ManagementClientListAddressesAtSubscriptionLevelResponse]]
	newListConfigurationsPager                 *tracker[azfake.PagerResponder[armedgeorder.ManagementClientListConfigurationsResponse]]
	newListOperationsPager                     *tracker[azfake.PagerResponder[armedgeorder.ManagementClientListOperationsResponse]]
	newListOrderAtResourceGroupLevelPager      *tracker[azfake.PagerResponder[armedgeorder.ManagementClientListOrderAtResourceGroupLevelResponse]]
	newListOrderAtSubscriptionLevelPager       *tracker[azfake.PagerResponder[armedgeorder.ManagementClientListOrderAtSubscriptionLevelResponse]]
	newListOrderItemsAtResourceGroupLevelPager *tracker[azfake.PagerResponder[armedgeorder.ManagementClientListOrderItemsAtResourceGroupLevelResponse]]
	newListOrderItemsAtSubscriptionLevelPager  *tracker[azfake.PagerResponder[armedgeorder.ManagementClientListOrderItemsAtSubscriptionLevelResponse]]
	newListProductFamiliesPager                *tracker[azfake.PagerResponder[armedgeorder.ManagementClientListProductFamiliesResponse]]
	newListProductFamiliesMetadataPager        *tracker[azfake.PagerResponder[armedgeorder.ManagementClientListProductFamiliesMetadataResponse]]
	beginReturnOrderItem                       *tracker[azfake.PollerResponder[armedgeorder.ManagementClientReturnOrderItemResponse]]
	beginUpdateAddress                         *tracker[azfake.PollerResponder[armedgeorder.ManagementClientUpdateAddressResponse]]
	beginUpdateOrderItem                       *tracker[azfake.PollerResponder[armedgeorder.ManagementClientUpdateOrderItemResponse]]
}

// Do implements the policy.Transporter interface for ManagementServerTransport.
func (m *ManagementServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagementClient.CancelOrderItem":
		resp, err = m.dispatchCancelOrderItem(req)
	case "ManagementClient.BeginCreateAddress":
		resp, err = m.dispatchBeginCreateAddress(req)
	case "ManagementClient.BeginCreateOrderItem":
		resp, err = m.dispatchBeginCreateOrderItem(req)
	case "ManagementClient.BeginDeleteAddressByName":
		resp, err = m.dispatchBeginDeleteAddressByName(req)
	case "ManagementClient.BeginDeleteOrderItemByName":
		resp, err = m.dispatchBeginDeleteOrderItemByName(req)
	case "ManagementClient.GetAddressByName":
		resp, err = m.dispatchGetAddressByName(req)
	case "ManagementClient.GetOrderByName":
		resp, err = m.dispatchGetOrderByName(req)
	case "ManagementClient.GetOrderItemByName":
		resp, err = m.dispatchGetOrderItemByName(req)
	case "ManagementClient.NewListAddressesAtResourceGroupLevelPager":
		resp, err = m.dispatchNewListAddressesAtResourceGroupLevelPager(req)
	case "ManagementClient.NewListAddressesAtSubscriptionLevelPager":
		resp, err = m.dispatchNewListAddressesAtSubscriptionLevelPager(req)
	case "ManagementClient.NewListConfigurationsPager":
		resp, err = m.dispatchNewListConfigurationsPager(req)
	case "ManagementClient.NewListOperationsPager":
		resp, err = m.dispatchNewListOperationsPager(req)
	case "ManagementClient.NewListOrderAtResourceGroupLevelPager":
		resp, err = m.dispatchNewListOrderAtResourceGroupLevelPager(req)
	case "ManagementClient.NewListOrderAtSubscriptionLevelPager":
		resp, err = m.dispatchNewListOrderAtSubscriptionLevelPager(req)
	case "ManagementClient.NewListOrderItemsAtResourceGroupLevelPager":
		resp, err = m.dispatchNewListOrderItemsAtResourceGroupLevelPager(req)
	case "ManagementClient.NewListOrderItemsAtSubscriptionLevelPager":
		resp, err = m.dispatchNewListOrderItemsAtSubscriptionLevelPager(req)
	case "ManagementClient.NewListProductFamiliesPager":
		resp, err = m.dispatchNewListProductFamiliesPager(req)
	case "ManagementClient.NewListProductFamiliesMetadataPager":
		resp, err = m.dispatchNewListProductFamiliesMetadataPager(req)
	case "ManagementClient.BeginReturnOrderItem":
		resp, err = m.dispatchBeginReturnOrderItem(req)
	case "ManagementClient.BeginUpdateAddress":
		resp, err = m.dispatchBeginUpdateAddress(req)
	case "ManagementClient.BeginUpdateOrderItem":
		resp, err = m.dispatchBeginUpdateOrderItem(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchCancelOrderItem(req *http.Request) (*http.Response, error) {
	if m.srv.CancelOrderItem == nil {
		return nil, &nonRetriableError{errors.New("fake for method CancelOrderItem not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/orderItems/(?P<orderItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armedgeorder.CancellationReason](req)
	if err != nil {
		return nil, err
	}
	orderItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("orderItemName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.CancelOrderItem(req.Context(), orderItemNameParam, resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchBeginCreateAddress(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateAddress == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateAddress not implemented")}
	}
	beginCreateAddress := m.beginCreateAddress.get(req)
	if beginCreateAddress == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/addresses/(?P<addressName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armedgeorder.AddressResource](req)
		if err != nil {
			return nil, err
		}
		addressNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("addressName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateAddress(req.Context(), addressNameParam, resourceGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateAddress = &respr
		m.beginCreateAddress.add(req, beginCreateAddress)
	}

	resp, err := server.PollerResponderNext(beginCreateAddress, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginCreateAddress.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateAddress) {
		m.beginCreateAddress.remove(req)
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchBeginCreateOrderItem(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateOrderItem == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrderItem not implemented")}
	}
	beginCreateOrderItem := m.beginCreateOrderItem.get(req)
	if beginCreateOrderItem == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/orderItems/(?P<orderItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armedgeorder.OrderItemResource](req)
		if err != nil {
			return nil, err
		}
		orderItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("orderItemName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateOrderItem(req.Context(), orderItemNameParam, resourceGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrderItem = &respr
		m.beginCreateOrderItem.add(req, beginCreateOrderItem)
	}

	resp, err := server.PollerResponderNext(beginCreateOrderItem, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginCreateOrderItem.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrderItem) {
		m.beginCreateOrderItem.remove(req)
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchBeginDeleteAddressByName(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDeleteAddressByName == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteAddressByName not implemented")}
	}
	beginDeleteAddressByName := m.beginDeleteAddressByName.get(req)
	if beginDeleteAddressByName == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/addresses/(?P<addressName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		addressNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("addressName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDeleteAddressByName(req.Context(), addressNameParam, resourceGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteAddressByName = &respr
		m.beginDeleteAddressByName.add(req, beginDeleteAddressByName)
	}

	resp, err := server.PollerResponderNext(beginDeleteAddressByName, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDeleteAddressByName.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteAddressByName) {
		m.beginDeleteAddressByName.remove(req)
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchBeginDeleteOrderItemByName(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDeleteOrderItemByName == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteOrderItemByName not implemented")}
	}
	beginDeleteOrderItemByName := m.beginDeleteOrderItemByName.get(req)
	if beginDeleteOrderItemByName == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/orderItems/(?P<orderItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		orderItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("orderItemName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDeleteOrderItemByName(req.Context(), orderItemNameParam, resourceGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteOrderItemByName = &respr
		m.beginDeleteOrderItemByName.add(req, beginDeleteOrderItemByName)
	}

	resp, err := server.PollerResponderNext(beginDeleteOrderItemByName, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDeleteOrderItemByName.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteOrderItemByName) {
		m.beginDeleteOrderItemByName.remove(req)
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchGetAddressByName(req *http.Request) (*http.Response, error) {
	if m.srv.GetAddressByName == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAddressByName not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/addresses/(?P<addressName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	addressNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("addressName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetAddressByName(req.Context(), addressNameParam, resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AddressResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchGetOrderByName(req *http.Request) (*http.Response, error) {
	if m.srv.GetOrderByName == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetOrderByName not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/orders/(?P<orderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	orderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("orderName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetOrderByName(req.Context(), orderNameParam, resourceGroupNameParam, locationParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).OrderResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchGetOrderItemByName(req *http.Request) (*http.Response, error) {
	if m.srv.GetOrderItemByName == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetOrderItemByName not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/orderItems/(?P<orderItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	orderItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("orderItemName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armedgeorder.ManagementClientGetOrderItemByNameOptions
	if expandParam != nil {
		options = &armedgeorder.ManagementClientGetOrderItemByNameOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := m.srv.GetOrderItemByName(req.Context(), orderItemNameParam, resourceGroupNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).OrderItemResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchNewListAddressesAtResourceGroupLevelPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListAddressesAtResourceGroupLevelPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAddressesAtResourceGroupLevelPager not implemented")}
	}
	newListAddressesAtResourceGroupLevelPager := m.newListAddressesAtResourceGroupLevelPager.get(req)
	if newListAddressesAtResourceGroupLevelPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/addresses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armedgeorder.ManagementClientListAddressesAtResourceGroupLevelOptions
		if filterParam != nil || skipTokenParam != nil {
			options = &armedgeorder.ManagementClientListAddressesAtResourceGroupLevelOptions{
				Filter:    filterParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := m.srv.NewListAddressesAtResourceGroupLevelPager(resourceGroupNameParam, options)
		newListAddressesAtResourceGroupLevelPager = &resp
		m.newListAddressesAtResourceGroupLevelPager.add(req, newListAddressesAtResourceGroupLevelPager)
		server.PagerResponderInjectNextLinks(newListAddressesAtResourceGroupLevelPager, req, func(page *armedgeorder.ManagementClientListAddressesAtResourceGroupLevelResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAddressesAtResourceGroupLevelPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListAddressesAtResourceGroupLevelPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAddressesAtResourceGroupLevelPager) {
		m.newListAddressesAtResourceGroupLevelPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchNewListAddressesAtSubscriptionLevelPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListAddressesAtSubscriptionLevelPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAddressesAtSubscriptionLevelPager not implemented")}
	}
	newListAddressesAtSubscriptionLevelPager := m.newListAddressesAtSubscriptionLevelPager.get(req)
	if newListAddressesAtSubscriptionLevelPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/addresses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armedgeorder.ManagementClientListAddressesAtSubscriptionLevelOptions
		if filterParam != nil || skipTokenParam != nil {
			options = &armedgeorder.ManagementClientListAddressesAtSubscriptionLevelOptions{
				Filter:    filterParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := m.srv.NewListAddressesAtSubscriptionLevelPager(options)
		newListAddressesAtSubscriptionLevelPager = &resp
		m.newListAddressesAtSubscriptionLevelPager.add(req, newListAddressesAtSubscriptionLevelPager)
		server.PagerResponderInjectNextLinks(newListAddressesAtSubscriptionLevelPager, req, func(page *armedgeorder.ManagementClientListAddressesAtSubscriptionLevelResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAddressesAtSubscriptionLevelPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListAddressesAtSubscriptionLevelPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAddressesAtSubscriptionLevelPager) {
		m.newListAddressesAtSubscriptionLevelPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchNewListConfigurationsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListConfigurationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListConfigurationsPager not implemented")}
	}
	newListConfigurationsPager := m.newListConfigurationsPager.get(req)
	if newListConfigurationsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/listConfigurations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		body, err := server.UnmarshalRequestAsJSON[armedgeorder.ConfigurationsRequest](req)
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armedgeorder.ManagementClientListConfigurationsOptions
		if skipTokenParam != nil {
			options = &armedgeorder.ManagementClientListConfigurationsOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := m.srv.NewListConfigurationsPager(body, options)
		newListConfigurationsPager = &resp
		m.newListConfigurationsPager.add(req, newListConfigurationsPager)
		server.PagerResponderInjectNextLinks(newListConfigurationsPager, req, func(page *armedgeorder.ManagementClientListConfigurationsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListConfigurationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListConfigurationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListConfigurationsPager) {
		m.newListConfigurationsPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchNewListOperationsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListOperationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListOperationsPager not implemented")}
	}
	newListOperationsPager := m.newListOperationsPager.get(req)
	if newListOperationsPager == nil {
		resp := m.srv.NewListOperationsPager(nil)
		newListOperationsPager = &resp
		m.newListOperationsPager.add(req, newListOperationsPager)
		server.PagerResponderInjectNextLinks(newListOperationsPager, req, func(page *armedgeorder.ManagementClientListOperationsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListOperationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListOperationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListOperationsPager) {
		m.newListOperationsPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchNewListOrderAtResourceGroupLevelPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListOrderAtResourceGroupLevelPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListOrderAtResourceGroupLevelPager not implemented")}
	}
	newListOrderAtResourceGroupLevelPager := m.newListOrderAtResourceGroupLevelPager.get(req)
	if newListOrderAtResourceGroupLevelPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/orders`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armedgeorder.ManagementClientListOrderAtResourceGroupLevelOptions
		if skipTokenParam != nil {
			options = &armedgeorder.ManagementClientListOrderAtResourceGroupLevelOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := m.srv.NewListOrderAtResourceGroupLevelPager(resourceGroupNameParam, options)
		newListOrderAtResourceGroupLevelPager = &resp
		m.newListOrderAtResourceGroupLevelPager.add(req, newListOrderAtResourceGroupLevelPager)
		server.PagerResponderInjectNextLinks(newListOrderAtResourceGroupLevelPager, req, func(page *armedgeorder.ManagementClientListOrderAtResourceGroupLevelResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListOrderAtResourceGroupLevelPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListOrderAtResourceGroupLevelPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListOrderAtResourceGroupLevelPager) {
		m.newListOrderAtResourceGroupLevelPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchNewListOrderAtSubscriptionLevelPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListOrderAtSubscriptionLevelPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListOrderAtSubscriptionLevelPager not implemented")}
	}
	newListOrderAtSubscriptionLevelPager := m.newListOrderAtSubscriptionLevelPager.get(req)
	if newListOrderAtSubscriptionLevelPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/orders`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armedgeorder.ManagementClientListOrderAtSubscriptionLevelOptions
		if skipTokenParam != nil {
			options = &armedgeorder.ManagementClientListOrderAtSubscriptionLevelOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := m.srv.NewListOrderAtSubscriptionLevelPager(options)
		newListOrderAtSubscriptionLevelPager = &resp
		m.newListOrderAtSubscriptionLevelPager.add(req, newListOrderAtSubscriptionLevelPager)
		server.PagerResponderInjectNextLinks(newListOrderAtSubscriptionLevelPager, req, func(page *armedgeorder.ManagementClientListOrderAtSubscriptionLevelResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListOrderAtSubscriptionLevelPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListOrderAtSubscriptionLevelPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListOrderAtSubscriptionLevelPager) {
		m.newListOrderAtSubscriptionLevelPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchNewListOrderItemsAtResourceGroupLevelPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListOrderItemsAtResourceGroupLevelPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListOrderItemsAtResourceGroupLevelPager not implemented")}
	}
	newListOrderItemsAtResourceGroupLevelPager := m.newListOrderItemsAtResourceGroupLevelPager.get(req)
	if newListOrderItemsAtResourceGroupLevelPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/orderItems`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armedgeorder.ManagementClientListOrderItemsAtResourceGroupLevelOptions
		if filterParam != nil || expandParam != nil || skipTokenParam != nil {
			options = &armedgeorder.ManagementClientListOrderItemsAtResourceGroupLevelOptions{
				Filter:    filterParam,
				Expand:    expandParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := m.srv.NewListOrderItemsAtResourceGroupLevelPager(resourceGroupNameParam, options)
		newListOrderItemsAtResourceGroupLevelPager = &resp
		m.newListOrderItemsAtResourceGroupLevelPager.add(req, newListOrderItemsAtResourceGroupLevelPager)
		server.PagerResponderInjectNextLinks(newListOrderItemsAtResourceGroupLevelPager, req, func(page *armedgeorder.ManagementClientListOrderItemsAtResourceGroupLevelResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListOrderItemsAtResourceGroupLevelPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListOrderItemsAtResourceGroupLevelPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListOrderItemsAtResourceGroupLevelPager) {
		m.newListOrderItemsAtResourceGroupLevelPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchNewListOrderItemsAtSubscriptionLevelPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListOrderItemsAtSubscriptionLevelPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListOrderItemsAtSubscriptionLevelPager not implemented")}
	}
	newListOrderItemsAtSubscriptionLevelPager := m.newListOrderItemsAtSubscriptionLevelPager.get(req)
	if newListOrderItemsAtSubscriptionLevelPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/orderItems`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armedgeorder.ManagementClientListOrderItemsAtSubscriptionLevelOptions
		if filterParam != nil || expandParam != nil || skipTokenParam != nil {
			options = &armedgeorder.ManagementClientListOrderItemsAtSubscriptionLevelOptions{
				Filter:    filterParam,
				Expand:    expandParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := m.srv.NewListOrderItemsAtSubscriptionLevelPager(options)
		newListOrderItemsAtSubscriptionLevelPager = &resp
		m.newListOrderItemsAtSubscriptionLevelPager.add(req, newListOrderItemsAtSubscriptionLevelPager)
		server.PagerResponderInjectNextLinks(newListOrderItemsAtSubscriptionLevelPager, req, func(page *armedgeorder.ManagementClientListOrderItemsAtSubscriptionLevelResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListOrderItemsAtSubscriptionLevelPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListOrderItemsAtSubscriptionLevelPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListOrderItemsAtSubscriptionLevelPager) {
		m.newListOrderItemsAtSubscriptionLevelPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchNewListProductFamiliesPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListProductFamiliesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListProductFamiliesPager not implemented")}
	}
	newListProductFamiliesPager := m.newListProductFamiliesPager.get(req)
	if newListProductFamiliesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/listProductFamilies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		body, err := server.UnmarshalRequestAsJSON[armedgeorder.ProductFamiliesRequest](req)
		if err != nil {
			return nil, err
		}
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armedgeorder.ManagementClientListProductFamiliesOptions
		if expandParam != nil || skipTokenParam != nil {
			options = &armedgeorder.ManagementClientListProductFamiliesOptions{
				Expand:    expandParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := m.srv.NewListProductFamiliesPager(body, options)
		newListProductFamiliesPager = &resp
		m.newListProductFamiliesPager.add(req, newListProductFamiliesPager)
		server.PagerResponderInjectNextLinks(newListProductFamiliesPager, req, func(page *armedgeorder.ManagementClientListProductFamiliesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListProductFamiliesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListProductFamiliesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListProductFamiliesPager) {
		m.newListProductFamiliesPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchNewListProductFamiliesMetadataPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListProductFamiliesMetadataPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListProductFamiliesMetadataPager not implemented")}
	}
	newListProductFamiliesMetadataPager := m.newListProductFamiliesMetadataPager.get(req)
	if newListProductFamiliesMetadataPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/productFamiliesMetadata`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armedgeorder.ManagementClientListProductFamiliesMetadataOptions
		if skipTokenParam != nil {
			options = &armedgeorder.ManagementClientListProductFamiliesMetadataOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := m.srv.NewListProductFamiliesMetadataPager(options)
		newListProductFamiliesMetadataPager = &resp
		m.newListProductFamiliesMetadataPager.add(req, newListProductFamiliesMetadataPager)
		server.PagerResponderInjectNextLinks(newListProductFamiliesMetadataPager, req, func(page *armedgeorder.ManagementClientListProductFamiliesMetadataResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListProductFamiliesMetadataPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListProductFamiliesMetadataPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListProductFamiliesMetadataPager) {
		m.newListProductFamiliesMetadataPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchBeginReturnOrderItem(req *http.Request) (*http.Response, error) {
	if m.srv.BeginReturnOrderItem == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReturnOrderItem not implemented")}
	}
	beginReturnOrderItem := m.beginReturnOrderItem.get(req)
	if beginReturnOrderItem == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/orderItems/(?P<orderItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/return`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armedgeorder.ReturnOrderItemDetails](req)
		if err != nil {
			return nil, err
		}
		orderItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("orderItemName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginReturnOrderItem(req.Context(), orderItemNameParam, resourceGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReturnOrderItem = &respr
		m.beginReturnOrderItem.add(req, beginReturnOrderItem)
	}

	resp, err := server.PollerResponderNext(beginReturnOrderItem, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginReturnOrderItem.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReturnOrderItem) {
		m.beginReturnOrderItem.remove(req)
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchBeginUpdateAddress(req *http.Request) (*http.Response, error) {
	if m.srv.BeginUpdateAddress == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateAddress not implemented")}
	}
	beginUpdateAddress := m.beginUpdateAddress.get(req)
	if beginUpdateAddress == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/addresses/(?P<addressName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armedgeorder.AddressUpdateParameter](req)
		if err != nil {
			return nil, err
		}
		addressNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("addressName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		var options *armedgeorder.ManagementClientBeginUpdateAddressOptions
		if ifMatchParam != nil {
			options = &armedgeorder.ManagementClientBeginUpdateAddressOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := m.srv.BeginUpdateAddress(req.Context(), addressNameParam, resourceGroupNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateAddress = &respr
		m.beginUpdateAddress.add(req, beginUpdateAddress)
	}

	resp, err := server.PollerResponderNext(beginUpdateAddress, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginUpdateAddress.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateAddress) {
		m.beginUpdateAddress.remove(req)
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchBeginUpdateOrderItem(req *http.Request) (*http.Response, error) {
	if m.srv.BeginUpdateOrderItem == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateOrderItem not implemented")}
	}
	beginUpdateOrderItem := m.beginUpdateOrderItem.get(req)
	if beginUpdateOrderItem == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrder/orderItems/(?P<orderItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armedgeorder.OrderItemUpdateParameter](req)
		if err != nil {
			return nil, err
		}
		orderItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("orderItemName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		var options *armedgeorder.ManagementClientBeginUpdateOrderItemOptions
		if ifMatchParam != nil {
			options = &armedgeorder.ManagementClientBeginUpdateOrderItemOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := m.srv.BeginUpdateOrderItem(req.Context(), orderItemNameParam, resourceGroupNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateOrderItem = &respr
		m.beginUpdateOrderItem.add(req, beginUpdateOrderItem)
	}

	resp, err := server.PollerResponderNext(beginUpdateOrderItem, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginUpdateOrderItem.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateOrderItem) {
		m.beginUpdateOrderItem.remove(req)
	}

	return resp, nil
}
