//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmonitor_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/GetMultiResourceMetric.json
func ExampleMetricsClient_ListAtSubscriptionScope_getSubscriptionLevelMetricData() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricsClient().ListAtSubscriptionScope(ctx, "westus2", &armmonitor.MetricsClientListAtSubscriptionScopeOptions{Timespan: to.Ptr("2021-06-08T19:00:00Z/2021-06-12T01:00:00Z"),
		Interval:            to.Ptr("PT6H"),
		Metricnames:         to.Ptr("Data Disk Max Burst IOPS"),
		Aggregation:         to.Ptr("count"),
		Top:                 to.Ptr[int32](10),
		Orderby:             to.Ptr("count desc"),
		Filter:              to.Ptr("LUN eq '0' and Microsoft.ResourceId eq '*'"),
		ResultType:          nil,
		Metricnamespace:     to.Ptr("microsoft.compute/virtualmachines"),
		AutoAdjustTimegrain: to.Ptr(true),
		ValidateDimensions:  to.Ptr(false),
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SubscriptionScopeMetricResponse = armmonitor.SubscriptionScopeMetricResponse{
	// 	Cost: to.Ptr[int32](4679),
	// 	Interval: to.Ptr("PT6H"),
	// 	Namespace: to.Ptr("microsoft.compute/virtualmachines"),
	// 	Resourceregion: to.Ptr("westus2"),
	// 	Timespan: to.Ptr("2021-06-08T19:00:00Z/2021-06-12T01:00:00Z"),
	// 	Value: []*armmonitor.SubscriptionScopeMetric{
	// 		{
	// 			Name: &armmonitor.LocalizableString{
	// 				LocalizedValue: to.Ptr("Data Disk Max Burst IOPS"),
	// 				Value: to.Ptr("Data Disk Max Burst IOPS"),
	// 			},
	// 			Type: to.Ptr("Microsoft.Insights/metrics"),
	// 			DisplayDescription: to.Ptr("Maximum IOPS Data Disk can achieve with bursting"),
	// 			ErrorCode: to.Ptr("Success"),
	// 			ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/Microsoft.Insights/metrics/Data Disk Max Burst IOPS"),
	// 			Timeseries: []*armmonitor.TimeSeriesElement{
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-08T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](413),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T19:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("microsoft.resourceid"),
	// 								Value: to.Ptr("microsoft.resourceid"),
	// 							},
	// 							Value: to.Ptr("/subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/resourceGroups/sas1/providers/Microsoft.Compute/virtualMachines/sas1-dev"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-08T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](133),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T19:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("microsoft.resourceid"),
	// 								Value: to.Ptr("microsoft.resourceid"),
	// 							},
	// 							Value: to.Ptr("/subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/resourceGroups/sas2/providers/Microsoft.Compute/virtualMachines/sas2-vm"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-08T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](78),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T19:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("microsoft.resourceid"),
	// 								Value: to.Ptr("microsoft.resourceid"),
	// 							},
	// 							Value: to.Ptr("/subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/resourceGroups/sas3/providers/Microsoft.Compute/virtualMachines/sas3-vm"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-08T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T19:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("microsoft.resourceid"),
	// 								Value: to.Ptr("microsoft.resourceid"),
	// 							},
	// 							Value: to.Ptr("/subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/resourceGroups/sas4/providers/Microsoft.Compute/virtualMachines/sas4-vm"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-08T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T19:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("microsoft.resourceid"),
	// 								Value: to.Ptr("microsoft.resourceid"),
	// 							},
	// 							Value: to.Ptr("/subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/resourceGroups/sas5/providers/Microsoft.Compute/virtualMachines/sas5-vm-asc"),
	// 					}},
	// 			}},
	// 			Unit: to.Ptr(armmonitor.MetricUnitCount),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/GetMultiResourceMetricMetadata.json
func ExampleMetricsClient_ListAtSubscriptionScope_getSubscriptionLevelMetricMetadata() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricsClient().ListAtSubscriptionScope(ctx, "westus2", &armmonitor.MetricsClientListAtSubscriptionScopeOptions{Timespan: to.Ptr("2021-06-10T02:23:16.129Z/2021-06-12T02:23:16.129Z"),
		Interval:            nil,
		Metricnames:         to.Ptr("Data Disk Max Burst IOPS"),
		Aggregation:         nil,
		Top:                 nil,
		Orderby:             nil,
		Filter:              to.Ptr("LUN eq '0'"),
		ResultType:          nil,
		Metricnamespace:     to.Ptr("microsoft.compute/virtualmachines"),
		AutoAdjustTimegrain: nil,
		ValidateDimensions:  nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SubscriptionScopeMetricResponse = armmonitor.SubscriptionScopeMetricResponse{
	// 	Interval: to.Ptr("PT1M"),
	// 	Namespace: to.Ptr("microsoft.compute/virtualmachines"),
	// 	Resourceregion: to.Ptr("westus2"),
	// 	Timespan: to.Ptr("2021-06-10T02:23:16Z/2021-06-12T02:23:16Z"),
	// 	Value: []*armmonitor.SubscriptionScopeMetric{
	// 		{
	// 			Name: &armmonitor.LocalizableString{
	// 				LocalizedValue: to.Ptr("Data Disk Read Bytes/Sec"),
	// 				Value: to.Ptr("Data Disk Read Bytes/sec"),
	// 			},
	// 			Type: to.Ptr("Microsoft.Insights/metrics"),
	// 			DisplayDescription: to.Ptr("Bytes/Sec read from a single disk during monitoring period"),
	// 			ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/Microsoft.Insights/metrics/Data Disk Read Bytes/sec"),
	// 			Timeseries: []*armmonitor.TimeSeriesElement{
	// 				{
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("lun"),
	// 								Value: to.Ptr("lun"),
	// 							},
	// 							Value: to.Ptr("0"),
	// 					}},
	// 				},
	// 				{
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("lun"),
	// 								Value: to.Ptr("lun"),
	// 							},
	// 							Value: to.Ptr("1"),
	// 					}},
	// 			}},
	// 			Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/PostMultiResourceMetricBody.json
func ExampleMetricsClient_ListAtSubscriptionScopePost_postRequestForSubscriptionLevelMetricDataUsingBodyParams() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricsClient().ListAtSubscriptionScopePost(ctx, "westus2", &armmonitor.MetricsClientListAtSubscriptionScopePostOptions{Timespan: nil,
		Interval:            nil,
		Metricnames:         nil,
		Aggregation:         nil,
		Top:                 nil,
		Orderby:             nil,
		Filter:              nil,
		ResultType:          nil,
		Metricnamespace:     nil,
		AutoAdjustTimegrain: nil,
		ValidateDimensions:  nil,
		Body: &armmonitor.SubscriptionScopeMetricsRequestBodyParameters{
			Aggregation:         to.Ptr("count"),
			AutoAdjustTimegrain: to.Ptr(true),
			Filter:              to.Ptr("LUN eq '0' and Microsoft.ResourceId eq '*'"),
			Interval:            to.Ptr("PT6H"),
			MetricNames:         to.Ptr("Data Disk Max Burst IOPS"),
			MetricNamespace:     to.Ptr("microsoft.compute/virtualmachines"),
			OrderBy:             to.Ptr("count desc"),
			RollUpBy:            to.Ptr("LUN"),
			Timespan:            to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "NaN-NaN-NaNTNaN:NaN:NaN.NaNZ"); return t }()),
			Top:                 to.Ptr[int32](10),
			ValidateDimensions:  to.Ptr(false),
		},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SubscriptionScopeMetricResponse = armmonitor.SubscriptionScopeMetricResponse{
	// 	Cost: to.Ptr[int32](4679),
	// 	Interval: to.Ptr("PT6H"),
	// 	Namespace: to.Ptr("microsoft.compute/virtualmachines"),
	// 	Resourceregion: to.Ptr("westus2"),
	// 	Timespan: to.Ptr("2021-06-08T19:00:00Z/2021-06-12T01:00:00Z"),
	// 	Value: []*armmonitor.SubscriptionScopeMetric{
	// 		{
	// 			Name: &armmonitor.LocalizableString{
	// 				LocalizedValue: to.Ptr("Data Disk Max Burst IOPS"),
	// 				Value: to.Ptr("Data Disk Max Burst IOPS"),
	// 			},
	// 			Type: to.Ptr("Microsoft.Insights/metrics"),
	// 			DisplayDescription: to.Ptr("Maximum IOPS Data Disk can achieve with bursting"),
	// 			ErrorCode: to.Ptr("Success"),
	// 			ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/Microsoft.Insights/metrics/Data Disk Max Burst IOPS"),
	// 			Timeseries: []*armmonitor.TimeSeriesElement{
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-08T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](413),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T19:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("microsoft.resourceid"),
	// 								Value: to.Ptr("microsoft.resourceid"),
	// 							},
	// 							Value: to.Ptr("/subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/resourceGroups/sas1/providers/Microsoft.Compute/virtualMachines/sas1-dev"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-08T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](133),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T19:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("microsoft.resourceid"),
	// 								Value: to.Ptr("microsoft.resourceid"),
	// 							},
	// 							Value: to.Ptr("/subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/resourceGroups/sas2/providers/Microsoft.Compute/virtualMachines/sas2-vm"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-08T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](78),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T19:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("microsoft.resourceid"),
	// 								Value: to.Ptr("microsoft.resourceid"),
	// 							},
	// 							Value: to.Ptr("/subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/resourceGroups/sas3/providers/Microsoft.Compute/virtualMachines/sas3-vm"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-08T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T19:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("microsoft.resourceid"),
	// 								Value: to.Ptr("microsoft.resourceid"),
	// 							},
	// 							Value: to.Ptr("/subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/resourceGroups/sas4/providers/Microsoft.Compute/virtualMachines/sas4-vm"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-08T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T19:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T01:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T07:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T13:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Count: to.Ptr[float64](72),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-11T19:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("microsoft.resourceid"),
	// 								Value: to.Ptr("microsoft.resourceid"),
	// 							},
	// 							Value: to.Ptr("/subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/resourceGroups/sas5/providers/Microsoft.Compute/virtualMachines/sas5-vm-asc"),
	// 					}},
	// 			}},
	// 			Unit: to.Ptr(armmonitor.MetricUnitCount),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/GetMetric.json
func ExampleMetricsClient_List_getMetricForData() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricsClient().List(ctx, "subscriptions/1f3fa6d2-851c-4a91-9087-1a050f3a9c38/resourceGroups/todking/providers/Microsoft.Storage/storageAccounts/tkfileserv/blobServices/default", &armmonitor.MetricsClientListOptions{Timespan: to.Ptr("2021-04-20T09:00:00.000Z/2021-04-20T14:00:00.000Z"),
		Interval:            to.Ptr("PT6H"),
		Metricnames:         to.Ptr("BlobCount,BlobCapacity"),
		Aggregation:         to.Ptr("average,minimum,maximum"),
		Top:                 to.Ptr[int32](5),
		Orderby:             to.Ptr("average asc"),
		Filter:              to.Ptr("Tier eq '*'"),
		ResultType:          nil,
		Metricnamespace:     to.Ptr("Microsoft.Storage/storageAccounts/blobServices"),
		AutoAdjustTimegrain: to.Ptr(true),
		ValidateDimensions:  to.Ptr(false),
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Response = armmonitor.Response{
	// 	Cost: to.Ptr[int32](598),
	// 	Interval: to.Ptr("PT1H"),
	// 	Namespace: to.Ptr("microsoft.storage/storageaccounts/blobservices"),
	// 	Resourceregion: to.Ptr("westus2"),
	// 	Timespan: to.Ptr("2021-04-20T09:00:00Z/2021-04-20T14:00:00Z"),
	// 	Value: []*armmonitor.Metric{
	// 		{
	// 			Name: &armmonitor.LocalizableString{
	// 				LocalizedValue: to.Ptr("Blob Count"),
	// 				Value: to.Ptr("BlobCount"),
	// 			},
	// 			Type: to.Ptr("Microsoft.Insights/metrics"),
	// 			DisplayDescription: to.Ptr("The number of blob objects stored in the storage account."),
	// 			ErrorCode: to.Ptr("Success"),
	// 			ID: to.Ptr("/subscriptions/1f3fa6d2-851c-4a91-9087-1a050f3a9c38/resourceGroups/todking/providers/Microsoft.Storage/storageAccounts/tkfileserv/blobServices/default/providers/Microsoft.Insights/metrics/BlobCount"),
	// 			Timeseries: []*armmonitor.TimeSeriesElement{
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Average: to.Ptr[float64](7),
	// 							Maximum: to.Ptr[float64](7),
	// 							Minimum: to.Ptr[float64](7),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T09:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](7),
	// 							Maximum: to.Ptr[float64](7),
	// 							Minimum: to.Ptr[float64](7),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T10:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](7),
	// 							Maximum: to.Ptr[float64](7),
	// 							Minimum: to.Ptr[float64](7),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T11:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](7),
	// 							Maximum: to.Ptr[float64](7),
	// 							Minimum: to.Ptr[float64](7),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T12:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](7),
	// 							Maximum: to.Ptr[float64](7),
	// 							Minimum: to.Ptr[float64](7),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T13:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Hot"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Average: to.Ptr[float64](2),
	// 							Maximum: to.Ptr[float64](2),
	// 							Minimum: to.Ptr[float64](2),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T09:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](2),
	// 							Maximum: to.Ptr[float64](2),
	// 							Minimum: to.Ptr[float64](2),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T10:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](2),
	// 							Maximum: to.Ptr[float64](2),
	// 							Minimum: to.Ptr[float64](2),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T11:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](2),
	// 							Maximum: to.Ptr[float64](2),
	// 							Minimum: to.Ptr[float64](2),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T12:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](2),
	// 							Maximum: to.Ptr[float64](2),
	// 							Minimum: to.Ptr[float64](2),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T13:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Standard"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T09:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T10:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T11:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T12:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T13:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Cool"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T09:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T10:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T11:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T12:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T13:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Archive"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T09:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T10:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T11:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T12:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T13:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Untiered"),
	// 					}},
	// 			}},
	// 			Unit: to.Ptr(armmonitor.UnitCount),
	// 		},
	// 		{
	// 			Name: &armmonitor.LocalizableString{
	// 				LocalizedValue: to.Ptr("Blob Capacity"),
	// 				Value: to.Ptr("BlobCapacity"),
	// 			},
	// 			Type: to.Ptr("Microsoft.Insights/metrics"),
	// 			DisplayDescription: to.Ptr("The amount of storage used by the storage account’s Blob service in bytes."),
	// 			ErrorCode: to.Ptr("Success"),
	// 			ID: to.Ptr("/subscriptions/1f3fa6d2-851c-4a91-9087-1a050f3a9c38/resourceGroups/todking/providers/Microsoft.Storage/storageAccounts/tkfileserv/blobServices/default/providers/Microsoft.Insights/metrics/BlobCapacity"),
	// 			Timeseries: []*armmonitor.TimeSeriesElement{
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Average: to.Ptr[float64](621492),
	// 							Maximum: to.Ptr[float64](621492),
	// 							Minimum: to.Ptr[float64](621492),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T09:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](621492),
	// 							Maximum: to.Ptr[float64](621492),
	// 							Minimum: to.Ptr[float64](621492),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T10:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](621492),
	// 							Maximum: to.Ptr[float64](621492),
	// 							Minimum: to.Ptr[float64](621492),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T11:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](621492),
	// 							Maximum: to.Ptr[float64](621492),
	// 							Minimum: to.Ptr[float64](621492),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T12:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](621492),
	// 							Maximum: to.Ptr[float64](621492),
	// 							Minimum: to.Ptr[float64](621492),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T13:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Standard"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Average: to.Ptr[float64](4733),
	// 							Maximum: to.Ptr[float64](4733),
	// 							Minimum: to.Ptr[float64](4733),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T09:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](4733),
	// 							Maximum: to.Ptr[float64](4733),
	// 							Minimum: to.Ptr[float64](4733),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T10:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](4733),
	// 							Maximum: to.Ptr[float64](4733),
	// 							Minimum: to.Ptr[float64](4733),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T11:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](4733),
	// 							Maximum: to.Ptr[float64](4733),
	// 							Minimum: to.Ptr[float64](4733),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T12:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](4733),
	// 							Maximum: to.Ptr[float64](4733),
	// 							Minimum: to.Ptr[float64](4733),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T13:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Hot"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T09:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T10:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T11:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T12:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T13:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Archive"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T09:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T10:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T11:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T12:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T13:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Untiered"),
	// 					}},
	// 				},
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T09:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T10:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T11:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T12:00:00.000Z"); return t}()),
	// 						},
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							Maximum: to.Ptr[float64](0),
	// 							Minimum: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-20T13:00:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Cool"),
	// 					}},
	// 			}},
	// 			Unit: to.Ptr(armmonitor.UnitBytes),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/GetMetricMetadata.json
func ExampleMetricsClient_List_getMetricForMetadata() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricsClient().List(ctx, "subscriptions/1f3fa6d2-851c-4a91-9087-1a050f3a9c38/resourceGroups/todking/providers/Microsoft.Storage/storageAccounts/tkfileserv/blobServices/default", &armmonitor.MetricsClientListOptions{Timespan: to.Ptr("2017-04-14T02:20:00Z/2017-04-14T04:20:00Z"),
		Interval:            nil,
		Metricnames:         nil,
		Aggregation:         nil,
		Top:                 nil,
		Orderby:             nil,
		Filter:              to.Ptr("Tier eq '*'"),
		ResultType:          nil,
		Metricnamespace:     to.Ptr("Microsoft.Storage/storageAccounts/blobServices"),
		AutoAdjustTimegrain: nil,
		ValidateDimensions:  nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Response = armmonitor.Response{
	// 	Interval: to.Ptr("PT1H"),
	// 	Namespace: to.Ptr("microsoft.storage/storageaccounts/blobservices"),
	// 	Resourceregion: to.Ptr("westus2"),
	// 	Timespan: to.Ptr("2021-04-15T02:18:00Z/2021-04-22T02:18:00Z"),
	// 	Value: []*armmonitor.Metric{
	// 		{
	// 			Name: &armmonitor.LocalizableString{
	// 				LocalizedValue: to.Ptr("Blob Count"),
	// 				Value: to.Ptr("BlobCount"),
	// 			},
	// 			Type: to.Ptr("Microsoft.Insights/metrics"),
	// 			DisplayDescription: to.Ptr("The number of blob objects stored in the storage account."),
	// 			ID: to.Ptr("/subscriptions/1f3fa6d2-851c-4a91-9087-1a050f3a9c38/resourceGroups/todking/providers/Microsoft.Storage/storageAccounts/tkfileserv/blobServices/default/providers/Microsoft.Insights/metrics/BlobCount"),
	// 			Timeseries: []*armmonitor.TimeSeriesElement{
	// 				{
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Cool"),
	// 					}},
	// 				},
	// 				{
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Archive"),
	// 					}},
	// 				},
	// 				{
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Standard"),
	// 					}},
	// 				},
	// 				{
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Untiered"),
	// 					}},
	// 				},
	// 				{
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 						{
	// 							Name: &armmonitor.LocalizableString{
	// 								LocalizedValue: to.Ptr("tier"),
	// 								Value: to.Ptr("tier"),
	// 							},
	// 							Value: to.Ptr("Hot"),
	// 					}},
	// 			}},
	// 			Unit: to.Ptr(armmonitor.UnitCount),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/GetMetricError.json
func ExampleMetricsClient_List_getMetricWithError() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricsClient().List(ctx, "subscriptions/ac41e21f-afd6-4a79-8070-f01eba278f97/resourceGroups/todking/providers/Microsoft.DocumentDb/databaseAccounts/tk-cosmos-mongo", &armmonitor.MetricsClientListOptions{Timespan: to.Ptr("2021-06-07T21:51:00Z/2021-06-08T01:51:00Z"),
		Interval:            to.Ptr("FULL"),
		Metricnames:         to.Ptr("MongoRequestsCount,MongoRequests"),
		Aggregation:         to.Ptr("average"),
		Top:                 nil,
		Orderby:             nil,
		Filter:              nil,
		ResultType:          nil,
		Metricnamespace:     to.Ptr("microsoft.documentdb/databaseaccounts"),
		AutoAdjustTimegrain: to.Ptr(true),
		ValidateDimensions:  to.Ptr(false),
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Response = armmonitor.Response{
	// 	Cost: to.Ptr[int32](239),
	// 	Interval: to.Ptr("PT4H"),
	// 	Namespace: to.Ptr("microsoft.documentdb/databaseaccounts"),
	// 	Resourceregion: to.Ptr("westus2"),
	// 	Timespan: to.Ptr("2021-06-07T21:51:00Z/2021-06-08T01:51:00Z"),
	// 	Value: []*armmonitor.Metric{
	// 		{
	// 			Name: &armmonitor.LocalizableString{
	// 				LocalizedValue: to.Ptr("(deprecated) Mongo Request Rate"),
	// 				Value: to.Ptr("MongoRequestsCount"),
	// 			},
	// 			Type: to.Ptr("Microsoft.Insights/metrics"),
	// 			ErrorCode: to.Ptr("InvalidSamplingType"),
	// 			ErrorMessage: to.Ptr("Sampling type is not found. Metric:CosmosDBCustomer,AzureMonitor,MongoRequests, SamplingType:NullableAverage."),
	// 			ID: to.Ptr("/subscriptions/ac41e21f-afd6-4a79-8070-f01eba278f97/resourceGroups/todking/providers/Microsoft.DocumentDb/databaseAccounts/tk-cosmos-mongo/providers/Microsoft.Insights/metrics/MongoRequestsCount"),
	// 			Timeseries: []*armmonitor.TimeSeriesElement{
	// 			},
	// 			Unit: to.Ptr(armmonitor.UnitCountPerSecond),
	// 		},
	// 		{
	// 			Name: &armmonitor.LocalizableString{
	// 				LocalizedValue: to.Ptr("Mongo Requests"),
	// 				Value: to.Ptr("MongoRequests"),
	// 			},
	// 			Type: to.Ptr("Microsoft.Insights/metrics"),
	// 			DisplayDescription: to.Ptr("Number of Mongo Requests Made"),
	// 			ErrorCode: to.Ptr("Success"),
	// 			ID: to.Ptr("/subscriptions/ac41e21f-afd6-4a79-8070-f01eba278f97/resourceGroups/todking/providers/Microsoft.DocumentDb/databaseAccounts/tk-cosmos-mongo/providers/Microsoft.Insights/metrics/MongoRequests"),
	// 			Timeseries: []*armmonitor.TimeSeriesElement{
	// 				{
	// 					Data: []*armmonitor.MetricValue{
	// 						{
	// 							Average: to.Ptr[float64](0),
	// 							TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-07T21:51:00.000Z"); return t}()),
	// 					}},
	// 					Metadatavalues: []*armmonitor.MetadataValue{
	// 					},
	// 			}},
	// 			Unit: to.Ptr(armmonitor.UnitCount),
	// 	}},
	// }
}
