//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup/v3"
	"net/http"
	"net/url"
	"regexp"
)

// RestoresServer is a fake server for instances of the armrecoveryservicesbackup.RestoresClient type.
type RestoresServer struct {
	// BeginTrigger is the fake for method RestoresClient.BeginTrigger
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginTrigger func(ctx context.Context, vaultName string, resourceGroupName string, fabricName string, containerName string, protectedItemName string, recoveryPointID string, parameters armrecoveryservicesbackup.RestoreRequestResource, options *armrecoveryservicesbackup.RestoresClientBeginTriggerOptions) (resp azfake.PollerResponder[armrecoveryservicesbackup.RestoresClientTriggerResponse], errResp azfake.ErrorResponder)
}

// NewRestoresServerTransport creates a new instance of RestoresServerTransport with the provided implementation.
// The returned RestoresServerTransport instance is connected to an instance of armrecoveryservicesbackup.RestoresClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRestoresServerTransport(srv *RestoresServer) *RestoresServerTransport {
	return &RestoresServerTransport{
		srv:          srv,
		beginTrigger: newTracker[azfake.PollerResponder[armrecoveryservicesbackup.RestoresClientTriggerResponse]](),
	}
}

// RestoresServerTransport connects instances of armrecoveryservicesbackup.RestoresClient to instances of RestoresServer.
// Don't use this type directly, use NewRestoresServerTransport instead.
type RestoresServerTransport struct {
	srv          *RestoresServer
	beginTrigger *tracker[azfake.PollerResponder[armrecoveryservicesbackup.RestoresClientTriggerResponse]]
}

// Do implements the policy.Transporter interface for RestoresServerTransport.
func (r *RestoresServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RestoresClient.BeginTrigger":
		resp, err = r.dispatchBeginTrigger(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RestoresServerTransport) dispatchBeginTrigger(req *http.Request) (*http.Response, error) {
	if r.srv.BeginTrigger == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTrigger not implemented")}
	}
	beginTrigger := r.beginTrigger.get(req)
	if beginTrigger == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/protectionContainers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/protectedItems/(?P<protectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recoveryPoints/(?P<recoveryPointId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restore`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 7 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicesbackup.RestoreRequestResource](req)
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		protectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectedItemName")])
		if err != nil {
			return nil, err
		}
		recoveryPointIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("recoveryPointId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginTrigger(req.Context(), vaultNameParam, resourceGroupNameParam, fabricNameParam, containerNameParam, protectedItemNameParam, recoveryPointIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTrigger = &respr
		r.beginTrigger.add(req, beginTrigger)
	}

	resp, err := server.PollerResponderNext(beginTrigger, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		r.beginTrigger.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTrigger) {
		r.beginTrigger.remove(req)
	}

	return resp, nil
}
