// graph-tool -- a general graph modification and manipulation thingy
//
// Copyright (C) 2006-2025 Tiago de Paula Peixoto <tiago@skewed.de>
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License as published by the Free
// Software Foundation; either version 3 of the License, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include "graph_tool.hh"
#include "random.hh"

#include <boost/python.hpp>

#include "graph_potts.hh"
#include "graph_potts_gibbs.hh"
#include "../loops/gibbs_loop.hh"

using namespace boost;
using namespace graph_tool;

GEN_DISPATCH(potts_state, PottsState, POTTS_STATE_params)

template <class State>
GEN_DISPATCH(gibbs_potts_state, Gibbs<State>::template GibbsPottsState,
             GIBBS_POTTS_STATE_params(State))

python::object do_potts_gibbs_sweep(python::object ogibbs_state,
                                    python::object opotts_state,
                                    rng_t& rng)
{
    python::object ret;
    auto dispatch = [&](auto& potts_state)
    {
        typedef typename std::remove_reference<decltype(potts_state)>::type
            state_t;

        gibbs_potts_state<state_t>::make_dispatch
           (ogibbs_state,
            [&](auto& s)
            {
                auto ret_ = gibbs_sweep(*s, rng);
                ret = tuple_apply([&](auto&... args){ return python::make_tuple(args...); }, ret_);
            });
    };
    potts_state::dispatch(opotts_state, dispatch);
    return ret;
}

#define __MOD__ inference
#include "module_registry.hh"
REGISTER_MOD
([]
{
    using namespace boost::python;
    def("potts_gibbs_sweep", &do_potts_gibbs_sweep);
});
