# Read value for a variable from VERSION.
MACRO(MYSQL_GET_CONFIG_VALUE keyword var)
 IF(NOT ${var})
   FILE (STRINGS ${SERVER_SOURCE_DIR}/VERSION str REGEX "^[ ]*${keyword}=")
   IF(str)
     STRING(REPLACE "${keyword}=" "" str ${str})
     STRING(REGEX REPLACE  "[ ].*" ""  str "${str}")
     SET(${var} ${str})
   ENDIF()
 ENDIF()
ENDMACRO()


function(get_linux_lsb_release_information)
    # made like in autobake script but for rhel too, cause aws linux gives
    # wrong CMAKE_SYSTEM for eg: Linux-5.4.0-1029-aws
    FIND_PROGRAM(LSB_RELEASE_EXEC lsb_release)
    if(NOT LSB_RELEASE_EXEC)
        MESSAGE(FATAL_ERROR "Could not detect lsb_release executable, can not gather required information")
    endif()

    EXECUTE_PROCESS(COMMAND "${LSB_RELEASE_EXEC}" --short --id OUTPUT_VARIABLE LSB_RELEASE_ID_SHORT OUTPUT_STRIP_TRAILING_WHITESPACE)
    MESSAGE(STATUS "LSB_RELEASE_ID_SHORT ${LSB_RELEASE_ID_SHORT}")
    STRING(TOLOWER ${LSB_RELEASE_ID_SHORT} LSB_RELEASE_ID_SHORT)
    MESSAGE(STATUS "LSB_RELEASE_ID_SHORT ${LSB_RELEASE_ID_SHORT}")

    EXECUTE_PROCESS(COMMAND "${LSB_RELEASE_EXEC}" --short --release OUTPUT_VARIABLE LSB_RELEASE_VERSION_SHORT OUTPUT_STRIP_TRAILING_WHITESPACE)
    MESSAGE(STATUS "LSB_RELEASE_VERSION_SHORT ${LSB_RELEASE_VERSION_SHORT}")
    EXECUTE_PROCESS(COMMAND "${LSB_RELEASE_EXEC}" --short --codename OUTPUT_VARIABLE LSB_RELEASE_CODENAME_SHORT OUTPUT_STRIP_TRAILING_WHITESPACE)

    SET(LSB_RELEASE_ID_SHORT "${LSB_RELEASE_ID_SHORT}" PARENT_SCOPE)
    SET(LSB_RELEASE_VERSION_SHORT "${LSB_RELEASE_VERSION_SHORT}" PARENT_SCOPE)
endfunction()


# Read mysql version for configure script
MACRO(GET_MYSQL_VERSION)
  MYSQL_GET_CONFIG_VALUE("MYSQL_VERSION_MAJOR" MAJOR_VERSION)
  MYSQL_GET_CONFIG_VALUE("MYSQL_VERSION_MINOR" MINOR_VERSION)
  MYSQL_GET_CONFIG_VALUE("MYSQL_VERSION_PATCH" PATCH_VERSION)
  MYSQL_GET_CONFIG_VALUE("MYSQL_VERSION_EXTRA" EXTRA_VERSION)
  MYSQL_GET_CONFIG_VALUE("SERVER_MATURITY" SERVER_MATURITY)

  IF(NOT "${MAJOR_VERSION}" MATCHES "[0-9]+" OR
   NOT "${MINOR_VERSION}" MATCHES "[0-9]+" OR
   NOT "${PATCH_VERSION}" MATCHES "[0-9]+")
    MESSAGE(FATAL_ERROR "VERSION file cannot be parsed.")
  ENDIF()
  IF((NOT TINY_VERSION) AND (EXTRA_VERSION MATCHES "[\\-][0-9]+"))
    STRING(REPLACE "-" "" TINY_VERSION "${EXTRA_VERSION}")
  ELSE()
    SET(TINY_VERSION "0")
  ENDIF()
  SET(VERSION "${MAJOR_VERSION}.${MINOR_VERSION}.${PATCH_VERSION}${EXTRA_VERSION}")
  SET(SERVER_VERSION ${VERSION})
  MESSAGE(STATUS "MariaDB ${VERSION}")
  SET(MYSQL_BASE_VERSION "${MAJOR_VERSION}.${MINOR_VERSION}" CACHE INTERNAL "MySQL Base version")
  SET(MYSQL_NO_DASH_VERSION "${MAJOR_VERSION}.${MINOR_VERSION}.${PATCH_VERSION}")
  MATH(EXPR MYSQL_VERSION_ID "10000*${MAJOR_VERSION} + 100*${MINOR_VERSION} + ${PATCH_VERSION}")
  MARK_AS_ADVANCED(VERSION MYSQL_VERSION_ID MYSQL_BASE_VERSION)
  SET(CPACK_PACKAGE_VERSION_MAJOR ${MAJOR_VERSION})
  SET(CPACK_PACKAGE_VERSION_MINOR ${MINOR_VERSION})
  SET(CPACK_PACKAGE_VERSION_PATCH ${PATCH_VERSION}${EXTRA_VERSION})
ENDMACRO()
