# mhd.m4

#  This file is part of TALER
#  Copyright (C) 2022, 2025 Taler Systems SA
#
#  TALER is free software; you can redistribute it and/or modify it under the
#  terms of the GNU General Public License as published by the Free Software
#  Foundation; either version 3, or (at your option) any later version.
#
#  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along with
#  TALER; see the file COPYING.  If not, If not, see <http://www.gnu.org/license>

# serial 2

dnl MHD_VERSION_AT_LEAST([VERSION])
dnl
dnl Check that microhttpd.h defines MHD_VERSION and compare it against
dnl the required version without executing compiled code.
dnl This allows for cross-compilation scenarios to work correctly.
dnl
dnl If the check fails, display error message and exit.
dnl Uses AX_COMPARE_VERSION to compare versions.
dnl Sets shell var mhd_cv_version with detected version.
dnl
AC_DEFUN([MHD_VERSION_AT_LEAST],
[
  AC_MSG_CHECKING([for libmicrohttpd version >= $1])

  # Try to get version by compiling & running a test program (won't work for cross-compilation)
  AC_RUN_IFELSE([AC_LANG_PROGRAM([[
    #include <stdio.h>
    #include <microhttpd.h>
  ]],[[
    int v = MHD_VERSION;
    FILE *f = fopen("conftest.out", "w");
    if (f == NULL) return 1;
    fprintf(f, "%d.%d.%d\n",
            (v >> 24) & 0xff,
            (v >> 16) & 0xff,
            (v >>  8) & 0xff);
    fclose(f);
    return 0;
  ]])],
    [mhd_cv_version=$(cat conftest.out)
     rm -f conftest.out],
    [mhd_cv_version=0],
    [
      # Cross compiling mode - compute version via macros
      AC_COMPUTE_INT([mhd_major], [(MHD_VERSION >> 24) & 0xff], [[#include <microhttpd.h>]], [mhd_major=0])
      AC_COMPUTE_INT([mhd_minor], [(MHD_VERSION >> 16) & 0xff], [[#include <microhttpd.h>]], [mhd_minor=0])
      AC_COMPUTE_INT([mhd_micro], [(MHD_VERSION >> 8) & 0xff], [[#include <microhttpd.h>]], [mhd_micro=0])
      mhd_cv_version="$mhd_major.$mhd_minor.$mhd_micro"
    ])

  # Compare version and report result
  AX_COMPARE_VERSION([$mhd_cv_version],[ge],[$1],
    [AC_MSG_RESULT([yes ($mhd_cv_version)])],
    [AC_MSG_RESULT([no ($mhd_cv_version)])
     AC_MSG_ERROR([[
***
*** You need libmicrohttpd >= $1 to build this program.
*** ]])])
])

# mhd.m4 ends here
