/*
   This file is part of TALER
   Copyright (C) 2024 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file exchangedb/pg_select_aml_statistics.h
 * @brief implementation of the select_aml_statistics function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_SELECT_AML_STATISTICS_H
#define PG_SELECT_AML_STATISTICS_H

#include "taler/taler_util.h"
#include "taler/taler_json_lib.h"
#include "taler/taler_exchangedb_plugin.h"

/**
 * Obtain the AML statistics for a given set of @a names and
 * timeframe.
 *
 * @param cls closure
 * @param num_names length of the @e names array
 * @param names array of names of the statistics to fetch
 * @param start_date start of time range
 * @param end_date end of time range
 * @param cb function to call on each statistic
 * @param cb_cls closure for @a cb
 * @return database transaction status
 */
enum GNUNET_DB_QueryStatus
TEH_PG_select_aml_statistics (
  void *cls,
  size_t num_names,
  const char *names[static num_names],
  struct GNUNET_TIME_Timestamp start_date,
  struct GNUNET_TIME_Timestamp end_date,
  TALER_EXCHANGEDB_AmlStatisticsCallback cb,
  void *cb_cls);

#endif
