/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_insert_order_blinded_sigs.h
 * @brief Implementation of the insert blinded sigs by order_id function for Postgres
 * @author Bohdan Potuzhnyi
 */
#ifndef PG_INSERT_BLIND_SIGS_ORD_H
#define PG_INSERT_BLIND_SIGS_ORD_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Store (or update) the Donau *blinded* signature JSON for an order.
 *
 * @param cls closure (our `struct PostgresClosure *`)
 * @param order_id     business-level order identifier
 * @param i index of the @a blinded_sig in the output token array
 * @param hash hash of the @a blinded_sig
 * @param blind_sig blinded signature for the token outputs
 * @return GNUNET_DB status code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_insert_order_blinded_sigs (
  void *cls,
  const char *order_id,
  uint32_t i,
  const struct GNUNET_HashCode *hash,
  const struct GNUNET_CRYPTO_BlindedSignature *blind_sig);

#endif
