/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Florian Dold <dold@taler.net>
 */

import { i18n, setupI18n } from "@gnu-taler/taler-util";
import * as tests from "../../tests/hook.js";
import { DefaultForm } from "../forms-ui.js";
import { design_multi_upload } from "./multi_upload.js";

setupI18n("en", {});

export const EmptyForm = tests.createExample(DefaultForm, {
  initial: {},
  design: design_multi_upload(i18n, {
    REQUESTED_FILES: [
      {
        REQUESTED_FILE_ID: "doc_xyz",
        REQUESTED_FILE_TITLE: "Doc XYZ",
        REQUESTED_FILE_DESCRIPTION: "Please upload document XYZ",
      },
      {
        REQUESTED_FILE_ID: "doc_abc",
        REQUESTED_FILE_TITLE: "Doc ABC",
        REQUESTED_FILE_DESCRIPTION: "Please upload document ABC",
      },
    ],
  }),
});

export default { title: "multi_upload" };
