# Norwegian Bokmål (nb) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                    | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | -------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987.                                              | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5.                                                 | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987.                                              | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4.                                                 | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1.                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                                 | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Q1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                 | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1. kvartal                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. kvartal                                         | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                  | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1.                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                                 | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Q1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                 | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1. kvartal                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. kvartal                                         | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2.                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                 | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | feb.                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                               | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | februar                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                               | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | F                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                  | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2.                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                 | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | feb.                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                               | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | februar                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                               | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | F                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                  | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1.                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                                | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1.                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                                | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28.                                                | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365.                                               | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | man                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | man                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | man                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | mandag                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fredag                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | M                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                  | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | ma                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                 | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | man                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | mandag                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fredag                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | M                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                  | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | ma                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                 | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | man                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | mandag                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fredag                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | M                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                  | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | ma                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                 | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                 | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | man                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | mandag                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fredag                                             | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | M                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                  | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | ma                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                 | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | a                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                  | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                               | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | a                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                  | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | på morg.                                           | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | på etterm.                                         | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvelden                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                          | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | på morg.                                           | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | på etterm.                                         | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvelden                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                          | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | på morg.                                           | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | på etterm.                                         | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvelden                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                          | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | på morgenen                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | på ettermiddagen                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvelden                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                          | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | på morg.                                           | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | på etterm.                                         | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvelden                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                          | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11.                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11.                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11.                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                                | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11.                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                                | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1.                                                 | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55.                                                | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1.                                                 | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55.                                                | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11.02.1987                                         | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453                                         | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11. feb. 1987                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. mai 1453                                       | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11. februar 1987                                   | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. mai 1453                                       | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | onsdag 11. februar 1987                            | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | søndag 29. mai 1453                                | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                              | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                              | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                           | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                           | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                     | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                             | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | kl. 23:59:59 GMT+00:00                             | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11.02.1987 12:13                                   | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453 23:59                                   | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11. feb. 1987 12:13:14                             | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. mai 1453 23:59:59                              | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11. februar 1987 kl. 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. mai 1453 kl. 23:59:59 GMT+0                    | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | onsdag 11. februar 1987 kl. kl. 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | søndag 29. mai 1453 kl. kl. 23:59:59 GMT+00:00     | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result                | `includeSeconds: true`  | `addSuffix: true`           |
| ------------------------ | --------------------- | ----------------------- | --------------------------- |
| 2006-01-01T00:00:00.000Z | omtrent seks år       | omtrent seks år         | om omtrent seks år          |
| 2005-01-01T00:00:00.000Z | omtrent fem år        | omtrent fem år          | om omtrent fem år           |
| 2004-01-01T00:00:00.000Z | omtrent fire år       | omtrent fire år         | om omtrent fire år          |
| 2003-01-01T00:00:00.000Z | omtrent tre år        | omtrent tre år          | om omtrent tre år           |
| 2002-01-01T00:00:00.000Z | omtrent to år         | omtrent to år           | om omtrent to år            |
| 2001-06-01T00:00:00.000Z | over ett år           | over ett år             | om over ett år              |
| 2001-02-01T00:00:00.000Z | omtrent ett år        | omtrent ett år          | om omtrent ett år           |
| 2001-01-01T00:00:00.000Z | omtrent ett år        | omtrent ett år          | om omtrent ett år           |
| 2000-06-01T00:00:00.000Z | fem måneder           | fem måneder             | om fem måneder              |
| 2000-03-01T00:00:00.000Z | to måneder            | to måneder              | om to måneder               |
| 2000-02-01T00:00:00.000Z | omtrent en måned      | omtrent en måned        | om omtrent en måned         |
| 2000-01-15T00:00:00.000Z | 14 dager              | 14 dager                | om 14 dager                 |
| 2000-01-02T00:00:00.000Z | en dag                | en dag                  | om en dag                   |
| 2000-01-01T06:00:00.000Z | omtrent seks timer    | omtrent seks timer      | om omtrent seks timer       |
| 2000-01-01T01:00:00.000Z | omtrent en time       | omtrent en time         | om omtrent en time          |
| 2000-01-01T00:45:00.000Z | omtrent en time       | omtrent en time         | om omtrent en time          |
| 2000-01-01T00:30:00.000Z | 30 minutter           | 30 minutter             | om 30 minutter              |
| 2000-01-01T00:15:00.000Z | 15 minutter           | 15 minutter             | om 15 minutter              |
| 2000-01-01T00:01:00.000Z | ett minutt            | ett minutt              | om ett minutt               |
| 2000-01-01T00:00:25.000Z | mindre enn ett minutt | et halvt minutt         | om mindre enn ett minutt    |
| 2000-01-01T00:00:15.000Z | mindre enn ett minutt | mindre enn 20 sekunder  | om mindre enn ett minutt    |
| 2000-01-01T00:00:05.000Z | mindre enn ett minutt | mindre enn ti sekunder  | om mindre enn ett minutt    |
| 2000-01-01T00:00:00.000Z | mindre enn ett minutt | mindre enn fem sekunder | mindre enn ett minutt siden |
| 1999-12-31T23:59:55.000Z | mindre enn ett minutt | mindre enn ti sekunder  | mindre enn ett minutt siden |
| 1999-12-31T23:59:45.000Z | mindre enn ett minutt | mindre enn 20 sekunder  | mindre enn ett minutt siden |
| 1999-12-31T23:59:35.000Z | mindre enn ett minutt | et halvt minutt         | mindre enn ett minutt siden |
| 1999-12-31T23:59:00.000Z | ett minutt            | ett minutt              | ett minutt siden            |
| 1999-12-31T23:45:00.000Z | 15 minutter           | 15 minutter             | 15 minutter siden           |
| 1999-12-31T23:30:00.000Z | 30 minutter           | 30 minutter             | 30 minutter siden           |
| 1999-12-31T23:15:00.000Z | omtrent en time       | omtrent en time         | omtrent en time siden       |
| 1999-12-31T23:00:00.000Z | omtrent en time       | omtrent en time         | omtrent en time siden       |
| 1999-12-31T18:00:00.000Z | omtrent seks timer    | omtrent seks timer      | omtrent seks timer siden    |
| 1999-12-30T00:00:00.000Z | to dager              | to dager                | to dager siden              |
| 1999-12-15T00:00:00.000Z | 17 dager              | 17 dager                | 17 dager siden              |
| 1999-12-01T00:00:00.000Z | omtrent en måned      | omtrent en måned        | omtrent en måned siden      |
| 1999-11-01T00:00:00.000Z | to måneder            | to måneder              | to måneder siden            |
| 1999-06-01T00:00:00.000Z | sju måneder           | sju måneder             | sju måneder siden           |
| 1999-01-01T00:00:00.000Z | omtrent ett år        | omtrent ett år          | omtrent ett år siden        |
| 1998-12-01T00:00:00.000Z | omtrent ett år        | omtrent ett år          | omtrent ett år siden        |
| 1998-06-01T00:00:00.000Z | over ett år           | over ett år             | over ett år siden           |
| 1998-01-01T00:00:00.000Z | omtrent to år         | omtrent to år           | omtrent to år siden         |
| 1997-01-01T00:00:00.000Z | omtrent tre år        | omtrent tre år          | omtrent tre år siden        |
| 1996-01-01T00:00:00.000Z | omtrent fire år       | omtrent fire år         | omtrent fire år siden       |
| 1995-01-01T00:00:00.000Z | omtrent fem år        | omtrent fem år          | omtrent fem år siden        |
| 1994-01-01T00:00:00.000Z | omtrent seks år       | omtrent seks år         | omtrent seks år siden       |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result        | `addSuffix: true`   | With forced unit (i.e. `hour`) |
| ------------------------ | ------------- | ------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | seks år       | om seks år          | 52608 timer                    |
| 2005-01-01T00:00:00.000Z | fem år        | om fem år           | 43848 timer                    |
| 2004-01-01T00:00:00.000Z | fire år       | om fire år          | 35064 timer                    |
| 2003-01-01T00:00:00.000Z | tre år        | om tre år           | 26304 timer                    |
| 2002-01-01T00:00:00.000Z | to år         | om to år            | 17544 timer                    |
| 2001-06-01T00:00:00.000Z | ett år        | om ett år           | 12408 timer                    |
| 2001-02-01T00:00:00.000Z | ett år        | om ett år           | 9528 timer                     |
| 2001-01-01T00:00:00.000Z | ett år        | om ett år           | 8784 timer                     |
| 2000-06-01T00:00:00.000Z | fem måneder   | om fem måneder      | 3648 timer                     |
| 2000-03-01T00:00:00.000Z | to måneder    | om to måneder       | 1440 timer                     |
| 2000-02-01T00:00:00.000Z | en måned      | om en måned         | 744 timer                      |
| 2000-01-15T00:00:00.000Z | 14 dager      | om 14 dager         | 336 timer                      |
| 2000-01-02T00:00:00.000Z | en dag        | om en dag           | 24 timer                       |
| 2000-01-01T06:00:00.000Z | seks timer    | om seks timer       | seks timer                     |
| 2000-01-01T01:00:00.000Z | en time       | om en time          | en time                        |
| 2000-01-01T00:45:00.000Z | 45 minutter   | om 45 minutter      | en time                        |
| 2000-01-01T00:30:00.000Z | 30 minutter   | om 30 minutter      | en time                        |
| 2000-01-01T00:15:00.000Z | 15 minutter   | om 15 minutter      | null timer                     |
| 2000-01-01T00:01:00.000Z | ett minutt    | om ett minutt       | null timer                     |
| 2000-01-01T00:00:25.000Z | 25 sekunder   | om 25 sekunder      | null timer                     |
| 2000-01-01T00:00:15.000Z | 15 sekunder   | om 15 sekunder      | null timer                     |
| 2000-01-01T00:00:05.000Z | fem sekunder  | om fem sekunder     | null timer                     |
| 2000-01-01T00:00:00.000Z | null sekunder | null sekunder siden | null timer                     |
| 1999-12-31T23:59:55.000Z | fem sekunder  | fem sekunder siden  | null timer                     |
| 1999-12-31T23:59:45.000Z | 15 sekunder   | 15 sekunder siden   | null timer                     |
| 1999-12-31T23:59:35.000Z | 25 sekunder   | 25 sekunder siden   | null timer                     |
| 1999-12-31T23:59:00.000Z | ett minutt    | ett minutt siden    | null timer                     |
| 1999-12-31T23:45:00.000Z | 15 minutter   | 15 minutter siden   | null timer                     |
| 1999-12-31T23:30:00.000Z | 30 minutter   | 30 minutter siden   | en time                        |
| 1999-12-31T23:15:00.000Z | 45 minutter   | 45 minutter siden   | en time                        |
| 1999-12-31T23:00:00.000Z | en time       | en time siden       | en time                        |
| 1999-12-31T18:00:00.000Z | seks timer    | seks timer siden    | seks timer                     |
| 1999-12-30T00:00:00.000Z | to dager      | to dager siden      | 48 timer                       |
| 1999-12-15T00:00:00.000Z | 17 dager      | 17 dager siden      | 408 timer                      |
| 1999-12-01T00:00:00.000Z | en måned      | en måned siden      | 744 timer                      |
| 1999-11-01T00:00:00.000Z | to måneder    | to måneder siden    | 1464 timer                     |
| 1999-06-01T00:00:00.000Z | sju måneder   | sju måneder siden   | 5136 timer                     |
| 1999-01-01T00:00:00.000Z | ett år        | ett år siden        | 8760 timer                     |
| 1998-12-01T00:00:00.000Z | ett år        | ett år siden        | 9504 timer                     |
| 1998-06-01T00:00:00.000Z | to år         | to år siden         | 13896 timer                    |
| 1998-01-01T00:00:00.000Z | to år         | to år siden         | 17520 timer                    |
| 1997-01-01T00:00:00.000Z | tre år        | tre år siden        | 26280 timer                    |
| 1996-01-01T00:00:00.000Z | fire år       | fire år siden       | 35064 timer                    |
| 1995-01-01T00:00:00.000Z | fem år        | fem år siden        | 43824 timer                    |
| 1994-01-01T00:00:00.000Z | seks år       | seks år siden       | 52584 timer                    |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                   |
| ------------------------ | ------------------------ |
| 2000-01-10T00:00:00.000Z | 10.01.2000               |
| 2000-01-05T00:00:00.000Z | onsdag kl. 00:00         |
| 2000-01-02T00:00:00.000Z | i morgen kl. 00:00       |
| 2000-01-01T00:00:00.000Z | i dag kl. 00:00          |
| 1999-12-31T00:00:00.000Z | i går kl. 00:00          |
| 1999-12-27T00:00:00.000Z | forrige mandag kl. 00:00 |
| 1999-12-21T00:00:00.000Z | 21.12.1999               |
