/*! For license information please see settings-vue-settings-admin-ai.js.LICENSE.txt */
(()=>{var e,n={36792:(e,n,r)=>{"use strict";var o=r(85471),i=r(65043),a=r(32073),s=r(88837),l=r(67607),c=r(54332),u=r(80910),d=r(432),f=r.n(d);const p={name:"DragVerticalIcon",emits:["click"],props:{title:{type:String},fillColor:{type:String,default:"currentColor"},size:{type:Number,default:24}}};var h=r(14486);const g=(0,h.A)(p,(function(){var t=this,e=t._self._c;return e("span",t._b({staticClass:"material-design-icon drag-vertical-icon",attrs:{"aria-hidden":!t.title||null,"aria-label":t.title,role:"img"},on:{click:function(e){return t.$emit("click",e)}}},"span",t.$attrs,!1),[e("svg",{staticClass:"material-design-icon__svg",attrs:{fill:t.fillColor,width:t.size,height:t.size,viewBox:"0 0 24 24"}},[e("path",{attrs:{d:"M9,3H11V5H9V3M13,3H15V5H13V3M9,7H11V9H9V7M13,7H15V9H13V7M9,11H11V13H9V11M13,11H15V13H13V11M9,15H11V17H9V15M13,15H15V17H13V15M9,19H11V21H9V19M13,19H15V21H13V19Z"}},[t.title?e("title",[t._v(t._s(t.title))]):t._e()])])])}),[],!1,null,null,null).exports;var v=r(10620),m=r(41645),b=r(32981),y=r(63814),x=r(96763);const w={name:"AdminAI",components:{NcCheckboxRadioSwitch:a.A,NcSettingsSection:s.A,NcSelect:l.A,draggable:f(),DragVerticalIcon:g,ArrowDownIcon:v.A,ArrowUpIcon:m.A,NcButton:c.A,NcNoteCard:u.A},data:()=>({loading:!1,dirty:!1,groups:[],loadingGroups:!1,sttProviders:(0,b.C)("settings","ai-stt-providers"),translationProviders:(0,b.C)("settings","ai-translation-providers"),textProcessingProviders:(0,b.C)("settings","ai-text-processing-providers"),textProcessingTaskTypes:(0,b.C)("settings","ai-text-processing-task-types"),text2imageProviders:(0,b.C)("settings","ai-text2image-providers"),settings:(0,b.C)("settings","ai-settings")}),computed:{hasStt(){return this.sttProviders.length>0},hasTextProcessing(){return Object.keys(this.settings["ai.textprocessing_provider_preferences"]).length>0&&Array.isArray(this.textProcessingTaskTypes)},tpTaskTypes(){return Object.keys(this.settings["ai.textprocessing_provider_preferences"]).filter((t=>!!this.getTaskType(t)))},hasText2ImageProviders(){return this.text2imageProviders.length>0}},methods:{moveUp(t){this.settings["ai.translation_provider_preferences"].splice(Math.min(t-1,0),0,...this.settings["ai.translation_provider_preferences"].splice(t,1)),this.saveChanges()},moveDown(t){this.settings["ai.translation_provider_preferences"].splice(t+1,0,...this.settings["ai.translation_provider_preferences"].splice(t,1)),this.saveChanges()},async saveChanges(){this.loading=!0;const t={settings:this.settings};try{await i.Ay.put((0,y.Jv)("/settings/api/admin/ai"),t)}catch(t){x.error("could not save changes",t)}this.loading=!1},getTaskType(t){return Array.isArray(this.textProcessingTaskTypes)?this.textProcessingTaskTypes.find((e=>e.class===t)):null}}};var _=r(85072),S=r.n(_),C=r(97825),E=r.n(C),A=r(77659),T=r.n(A),D=r(55056),O=r.n(D),N=r(10540),k=r.n(N),M=r(41113),P=r.n(M),I=r(90645),j={};j.styleTagTransform=P(),j.setAttributes=O(),j.insert=T().bind(null,"head"),j.domAPI=E(),j.insertStyleElement=k(),S()(I.A,j),I.A&&I.A.locals&&I.A.locals;const R=(0,h.A)(w,(function(){var t=this,e=t._self._c;return e("div",[e("NcSettingsSection",{attrs:{name:t.t("settings","Machine translation"),description:t.t("settings","Machine translation can be implemented by different apps. Here you can define the precedence of the machine translation apps you have installed at the moment.")}},[e("draggable",{on:{change:t.saveChanges},model:{value:t.settings["ai.translation_provider_preferences"],callback:function(e){t.$set(t.settings,"ai.translation_provider_preferences",e)},expression:"settings['ai.translation_provider_preferences']"}},t._l(t.settings["ai.translation_provider_preferences"],(function(n,r){var o;return e("div",{key:n,staticClass:"draggable__item"},[e("DragVerticalIcon"),t._v(" "),e("span",{staticClass:"draggable__number"},[t._v(t._s(r+1))]),t._v(" "+t._s(null===(o=t.translationProviders.find((t=>t.class===n)))||void 0===o?void 0:o.name)+"\n\t\t\t\t"),e("NcButton",{attrs:{"aria-label":"Move up",type:"tertiary"},on:{click:function(e){return t.moveUp(r)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ArrowUpIcon")]},proxy:!0}],null,!0)}),t._v(" "),e("NcButton",{attrs:{"aria-label":"Move down",type:"tertiary"},on:{click:function(e){return t.moveDown(r)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ArrowDownIcon")]},proxy:!0}],null,!0)})],1)})),0)],1),t._v(" "),e("NcSettingsSection",{attrs:{name:t.t("settings","Speech-To-Text"),description:t.t("settings","Speech-To-Text can be implemented by different apps. Here you can set which app should be used.")}},[t._l(t.sttProviders,(function(n){return[e("NcCheckboxRadioSwitch",{key:n.class,attrs:{checked:t.settings["ai.stt_provider"],value:n.class,name:"stt_provider",type:"radio"},on:{"update:checked":[function(e){return t.$set(t.settings,"ai.stt_provider",e)},t.saveChanges]}},[t._v("\n\t\t\t\t"+t._s(n.name)+"\n\t\t\t")])]})),t._v(" "),t.hasStt?t._e():[e("NcNoteCard",{attrs:{type:"info"}},[t._v("\n\t\t\t\t"+t._s(t.t("settings","None of your currently installed apps provide Speech-To-Text functionality"))+"\n\t\t\t")])]],2),t._v(" "),e("NcSettingsSection",{attrs:{name:t.t("settings","Image generation"),description:t.t("settings","Image generation can be implemented by different apps. Here you can set which app should be used.")}},[t._l(t.text2imageProviders,(function(n){return[e("NcCheckboxRadioSwitch",{key:n.id,attrs:{checked:t.settings["ai.text2image_provider"],value:n.id,name:"text2image_provider",type:"radio"},on:{"update:checked":[function(e){return t.$set(t.settings,"ai.text2image_provider",e)},t.saveChanges]}},[t._v("\n\t\t\t\t"+t._s(n.name)+"\n\t\t\t")])]})),t._v(" "),t.hasText2ImageProviders?t._e():[e("NcNoteCard",{attrs:{type:"info"}},[t._v("\n\t\t\t\t"+t._s(t.t("settings","None of your currently installed apps provide image generation functionality"))+"\n\t\t\t")])]],2),t._v(" "),e("NcSettingsSection",{attrs:{name:t.t("settings","Text processing"),description:t.t("settings","Text processing tasks can be implemented by different apps. Here you can set which app should be used for which task.")}},[t._l(t.tpTaskTypes,(function(n){return[e("div",{key:n},[e("h3",[t._v(t._s(t.t("settings","Task:"))+" "+t._s(t.getTaskType(n).name))]),t._v(" "),e("p",[t._v(t._s(t.getTaskType(n).description))]),t._v(" "),e("p",[t._v(" ")]),t._v(" "),e("NcSelect",{attrs:{clearable:!1,options:t.textProcessingProviders.filter((t=>t.taskType===n)).map((t=>t.class))},on:{input:t.saveChanges},scopedSlots:t._u([{key:"option",fn:function(e){var n;let{label:r}=e;return[t._v("\n\t\t\t\t\t\t"+t._s(null===(n=t.textProcessingProviders.find((t=>t.class===r)))||void 0===n?void 0:n.name)+"\n\t\t\t\t\t")]}},{key:"selected-option",fn:function(e){var n;let{label:r}=e;return[t._v("\n\t\t\t\t\t\t"+t._s(null===(n=t.textProcessingProviders.find((t=>t.class===r)))||void 0===n?void 0:n.name)+"\n\t\t\t\t\t")]}}],null,!0),model:{value:t.settings["ai.textprocessing_provider_preferences"][n],callback:function(e){t.$set(t.settings["ai.textprocessing_provider_preferences"],n,e)},expression:"settings['ai.textprocessing_provider_preferences'][type]"}}),t._v(" "),e("p",[t._v(" ")])],1)]})),t._v(" "),t.hasTextProcessing?t._e():[e("NcNoteCard",{attrs:{type:"info"}},[t._v("\n\t\t\t\t"+t._s(t.t("settings","None of your currently installed apps provide Text processing functionality"))+"\n\t\t\t")])]],2)],1)}),[],!1,null,"39c1c180",null).exports;r.nc=btoa(OC.requestToken),o.Ay.prototype.t=t,window.OC=window.OC||{},window.OC.Settings=window.OC.Settings||{},(new(o.Ay.extend(R))).$mount("#ai-settings")},90645:(t,e,n)=>{"use strict";n.d(e,{A:()=>s});var r=n(71354),o=n.n(r),i=n(76314),a=n.n(i)()(o());a.push([t.id,"\n.draggable__item[data-v-39c1c180] {\n\tmargin-bottom: 5px;\n  display: flex;\n  align-items: center;\n}\n.draggable__item[data-v-39c1c180],\n.draggable__item *[data-v-39c1c180] {\n  cursor: grab;\n}\n.draggable__number[data-v-39c1c180] {\n\tborder-radius: 20px;\n\tborder: 2px solid var(--color-primary-default);\n\tcolor: var(--color-primary-default);\n  padding: 0px 7px;\n\tmargin-right: 3px;\n}\n.drag-vertical-icon[data-v-39c1c180] {\n  float: left;\n}\n","",{version:3,sources:["webpack://./apps/settings/src/components/AdminAI.vue"],names:[],mappings:";AAmLA;CACA,kBAAA;EACA,aAAA;EACA,mBAAA;AACA;AAEA;;EAEA,YAAA;AACA;AAEA;CACA,mBAAA;CACA,8CAAA;CACA,mCAAA;EACA,gBAAA;CACA,iBAAA;AACA;AAEA;EACA,WAAA;AACA",sourcesContent:["<template>\n\t<div>\n\t\t<NcSettingsSection :name=\"t('settings', 'Machine translation')\"\n\t\t\t:description=\"t('settings', 'Machine translation can be implemented by different apps. Here you can define the precedence of the machine translation apps you have installed at the moment.')\">\n\t\t\t<draggable v-model=\"settings['ai.translation_provider_preferences']\" @change=\"saveChanges\">\n\t\t\t\t<div v-for=\"(providerClass, i) in settings['ai.translation_provider_preferences']\" :key=\"providerClass\" class=\"draggable__item\">\n\t\t\t\t\t<DragVerticalIcon /> <span class=\"draggable__number\">{{ i + 1 }}</span> {{ translationProviders.find(p => p.class === providerClass)?.name }}\n\t\t\t\t\t<NcButton aria-label=\"Move up\" type=\"tertiary\" @click=\"moveUp(i)\">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<ArrowUpIcon />\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</NcButton>\n\t\t\t\t\t<NcButton aria-label=\"Move down\" type=\"tertiary\" @click=\"moveDown(i)\">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<ArrowDownIcon />\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</NcButton>\n\t\t\t\t</div>\n\t\t\t</draggable>\n\t\t</NcSettingsSection>\n\t\t<NcSettingsSection :name=\"t('settings', 'Speech-To-Text')\"\n\t\t\t:description=\"t('settings', 'Speech-To-Text can be implemented by different apps. Here you can set which app should be used.')\">\n\t\t\t<template v-for=\"provider in sttProviders\">\n\t\t\t\t<NcCheckboxRadioSwitch :key=\"provider.class\"\n\t\t\t\t\t:checked.sync=\"settings['ai.stt_provider']\"\n\t\t\t\t\t:value=\"provider.class\"\n\t\t\t\t\tname=\"stt_provider\"\n\t\t\t\t\ttype=\"radio\"\n\t\t\t\t\t@update:checked=\"saveChanges\">\n\t\t\t\t\t{{ provider.name }}\n\t\t\t\t</NcCheckboxRadioSwitch>\n\t\t\t</template>\n\t\t\t<template v-if=\"!hasStt\">\n\t\t\t\t<NcNoteCard type=\"info\">\n\t\t\t\t\t{{ t('settings', 'None of your currently installed apps provide Speech-To-Text functionality') }}\n\t\t\t\t</NcNoteCard>\n\t\t\t</template>\n\t\t</NcSettingsSection>\n\t\t<NcSettingsSection :name=\"t('settings', 'Image generation')\"\n\t\t\t:description=\"t('settings', 'Image generation can be implemented by different apps. Here you can set which app should be used.')\">\n\t\t\t<template v-for=\"provider in text2imageProviders\">\n\t\t\t\t<NcCheckboxRadioSwitch :key=\"provider.id\"\n\t\t\t\t\t:checked.sync=\"settings['ai.text2image_provider']\"\n\t\t\t\t\t:value=\"provider.id\"\n\t\t\t\t\tname=\"text2image_provider\"\n\t\t\t\t\ttype=\"radio\"\n\t\t\t\t\t@update:checked=\"saveChanges\">\n\t\t\t\t\t{{ provider.name }}\n\t\t\t\t</NcCheckboxRadioSwitch>\n\t\t\t</template>\n\t\t\t<template v-if=\"!hasText2ImageProviders\">\n\t\t\t\t<NcNoteCard type=\"info\">\n\t\t\t\t\t{{ t('settings', 'None of your currently installed apps provide image generation functionality') }}\n\t\t\t\t</NcNoteCard>\n\t\t\t</template>\n\t\t</NcSettingsSection>\n\t\t<NcSettingsSection :name=\"t('settings', 'Text processing')\"\n\t\t\t:description=\"t('settings', 'Text processing tasks can be implemented by different apps. Here you can set which app should be used for which task.')\">\n\t\t\t<template v-for=\"type in tpTaskTypes\">\n\t\t\t\t<div :key=\"type\">\n\t\t\t\t\t<h3>{{ t('settings', 'Task:') }} {{ getTaskType(type).name }}</h3>\n\t\t\t\t\t<p>{{ getTaskType(type).description }}</p>\n\t\t\t\t\t<p>&nbsp;</p>\n\t\t\t\t\t<NcSelect v-model=\"settings['ai.textprocessing_provider_preferences'][type]\"\n\t\t\t\t\t\t:clearable=\"false\"\n\t\t\t\t\t\t:options=\"textProcessingProviders.filter(p => p.taskType === type).map(p => p.class)\"\n\t\t\t\t\t\t@input=\"saveChanges\">\n\t\t\t\t\t\t<template #option=\"{label}\">\n\t\t\t\t\t\t\t{{ textProcessingProviders.find(p => p.class === label)?.name }}\n\t\t\t\t\t\t</template>\n\t\t\t\t\t\t<template #selected-option=\"{label}\">\n\t\t\t\t\t\t\t{{ textProcessingProviders.find(p => p.class === label)?.name }}\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</NcSelect>\n\t\t\t\t\t<p>&nbsp;</p>\n\t\t\t\t</div>\n\t\t\t</template>\n\t\t\t<template v-if=\"!hasTextProcessing\">\n\t\t\t\t<NcNoteCard type=\"info\">\n\t\t\t\t\t{{ t('settings', 'None of your currently installed apps provide Text processing functionality') }}\n\t\t\t\t</NcNoteCard>\n\t\t\t</template>\n\t\t</NcSettingsSection>\n\t</div>\n</template>\n\n<script>\nimport axios from '@nextcloud/axios'\nimport NcCheckboxRadioSwitch from '@nextcloud/vue/dist/Components/NcCheckboxRadioSwitch.js'\nimport NcSettingsSection from '@nextcloud/vue/dist/Components/NcSettingsSection.js'\nimport NcSelect from '@nextcloud/vue/dist/Components/NcSelect.js'\nimport NcButton from '@nextcloud/vue/dist/Components/NcButton.js'\nimport NcNoteCard from '@nextcloud/vue/dist/Components/NcNoteCard.js'\nimport draggable from 'vuedraggable'\nimport DragVerticalIcon from 'vue-material-design-icons/DragVertical.vue'\nimport ArrowDownIcon from 'vue-material-design-icons/ArrowDown.vue'\nimport ArrowUpIcon from 'vue-material-design-icons/ArrowUp.vue'\nimport { loadState } from '@nextcloud/initial-state'\n\nimport { generateUrl } from '@nextcloud/router'\n\nexport default {\n\tname: 'AdminAI',\n\tcomponents: {\n\t\tNcCheckboxRadioSwitch,\n\t\tNcSettingsSection,\n\t\tNcSelect,\n\t\tdraggable,\n\t\tDragVerticalIcon,\n\t\tArrowDownIcon,\n\t\tArrowUpIcon,\n\t\tNcButton,\n\t\tNcNoteCard,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tloading: false,\n\t\t\tdirty: false,\n\t\t\tgroups: [],\n\t\t\tloadingGroups: false,\n\t\t\tsttProviders: loadState('settings', 'ai-stt-providers'),\n\t\t\ttranslationProviders: loadState('settings', 'ai-translation-providers'),\n\t\t\ttextProcessingProviders: loadState('settings', 'ai-text-processing-providers'),\n\t\t\ttextProcessingTaskTypes: loadState('settings', 'ai-text-processing-task-types'),\n\t\t\ttext2imageProviders: loadState('settings', 'ai-text2image-providers'),\n\t\t\tsettings: loadState('settings', 'ai-settings'),\n\t\t}\n\t},\n\tcomputed: {\n\t\thasStt() {\n\t\t\treturn this.sttProviders.length > 0\n\t\t},\n\t\thasTextProcessing() {\n\t\t\treturn Object.keys(this.settings['ai.textprocessing_provider_preferences']).length > 0 && Array.isArray(this.textProcessingTaskTypes)\n\t\t},\n\t\ttpTaskTypes() {\n\t\t\treturn Object.keys(this.settings['ai.textprocessing_provider_preferences']).filter(type => !!this.getTaskType(type))\n\t\t},\n\t\thasText2ImageProviders() {\n\t\t  return this.text2imageProviders.length > 0\n\t\t},\n\t},\n\tmethods: {\n\t  moveUp(i) {\n\t\t\tthis.settings['ai.translation_provider_preferences'].splice(\n\t\t\t  Math.min(i - 1, 0),\n\t\t\t\t0,\n\t\t\t\t...this.settings['ai.translation_provider_preferences'].splice(i, 1),\n\t\t\t)\n\t\t\tthis.saveChanges()\n\t\t},\n\t\tmoveDown(i) {\n\t\t\tthis.settings['ai.translation_provider_preferences'].splice(\n\t\t\t\ti + 1,\n\t\t\t\t0,\n\t\t\t\t...this.settings['ai.translation_provider_preferences'].splice(i, 1),\n\t\t\t)\n\t\t\tthis.saveChanges()\n\t\t},\n\t\tasync saveChanges() {\n\t\t\tthis.loading = true\n\t\t\tconst data = { settings: this.settings }\n\t\t\ttry {\n\t\t\t\tawait axios.put(generateUrl('/settings/api/admin/ai'), data)\n\t\t\t} catch (err) {\n\t\t\t\tconsole.error('could not save changes', err)\n\t\t\t}\n\t\t\tthis.loading = false\n\t\t},\n\t\tgetTaskType(type) {\n\t\t  if (!Array.isArray(this.textProcessingTaskTypes)) {\n\t\t\t\treturn null\n\t\t\t}\n\t\t\treturn this.textProcessingTaskTypes.find(taskType => taskType.class === type)\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.draggable__item {\n\tmargin-bottom: 5px;\n  display: flex;\n  align-items: center;\n}\n\n.draggable__item,\n.draggable__item * {\n  cursor: grab;\n}\n\n.draggable__number {\n\tborder-radius: 20px;\n\tborder: 2px solid var(--color-primary-default);\n\tcolor: var(--color-primary-default);\n  padding: 0px 7px;\n\tmargin-right: 3px;\n}\n\n.drag-vertical-icon {\n  float: left;\n}\n</style>\n"],sourceRoot:""}]);const s=a},10246:(t,e,n)=>{"use strict";function r(t){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},r(t)}function o(t,e,n){return e in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}function i(){return i=Object.assign||function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(t[r]=n[r])}return t},i.apply(this,arguments)}function a(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{},r=Object.keys(n);"function"==typeof Object.getOwnPropertySymbols&&(r=r.concat(Object.getOwnPropertySymbols(n).filter((function(t){return Object.getOwnPropertyDescriptor(n,t).enumerable})))),r.forEach((function(e){o(t,e,n[e])}))}return t}function s(t){if("undefined"!=typeof window&&window.navigator)return!!navigator.userAgent.match(t)}n.r(e),n.d(e,{MultiDrag:()=>ve,Sortable:()=>Lt,Swap:()=>ie,default:()=>ye});var l=s(/(?:Trident.*rv[ :]?11\.|msie|iemobile|Windows Phone)/i),c=s(/Edge/i),u=s(/firefox/i),d=s(/safari/i)&&!s(/chrome/i)&&!s(/android/i),f=s(/iP(ad|od|hone)/i),p=s(/chrome/i)&&s(/android/i),h={capture:!1,passive:!1};function g(t,e,n){t.addEventListener(e,n,!l&&h)}function v(t,e,n){t.removeEventListener(e,n,!l&&h)}function m(t,e){if(e){if(">"===e[0]&&(e=e.substring(1)),t)try{if(t.matches)return t.matches(e);if(t.msMatchesSelector)return t.msMatchesSelector(e);if(t.webkitMatchesSelector)return t.webkitMatchesSelector(e)}catch(t){return!1}return!1}}function b(t){return t.host&&t!==document&&t.host.nodeType?t.host:t.parentNode}function y(t,e,n,r){if(t){n=n||document;do{if(null!=e&&(">"===e[0]?t.parentNode===n&&m(t,e):m(t,e))||r&&t===n)return t;if(t===n)break}while(t=b(t))}return null}var x,w=/\s+/g;function _(t,e,n){if(t&&e)if(t.classList)t.classList[n?"add":"remove"](e);else{var r=(" "+t.className+" ").replace(w," ").replace(" "+e+" "," ");t.className=(r+(n?" "+e:"")).replace(w," ")}}function S(t,e,n){var r=t&&t.style;if(r){if(void 0===n)return document.defaultView&&document.defaultView.getComputedStyle?n=document.defaultView.getComputedStyle(t,""):t.currentStyle&&(n=t.currentStyle),void 0===e?n:n[e];e in r||-1!==e.indexOf("webkit")||(e="-webkit-"+e),r[e]=n+("string"==typeof n?"":"px")}}function C(t,e){var n="";if("string"==typeof t)n=t;else do{var r=S(t,"transform");r&&"none"!==r&&(n=r+" "+n)}while(!e&&(t=t.parentNode));var o=window.DOMMatrix||window.WebKitCSSMatrix||window.CSSMatrix||window.MSCSSMatrix;return o&&new o(n)}function E(t,e,n){if(t){var r=t.getElementsByTagName(e),o=0,i=r.length;if(n)for(;o<i;o++)n(r[o],o);return r}return[]}function A(){return document.scrollingElement||document.documentElement}function T(t,e,n,r,o){if(t.getBoundingClientRect||t===window){var i,a,s,c,u,d,f;if(t!==window&&t!==A()?(a=(i=t.getBoundingClientRect()).top,s=i.left,c=i.bottom,u=i.right,d=i.height,f=i.width):(a=0,s=0,c=window.innerHeight,u=window.innerWidth,d=window.innerHeight,f=window.innerWidth),(e||n)&&t!==window&&(o=o||t.parentNode,!l))do{if(o&&o.getBoundingClientRect&&("none"!==S(o,"transform")||n&&"static"!==S(o,"position"))){var p=o.getBoundingClientRect();a-=p.top+parseInt(S(o,"border-top-width")),s-=p.left+parseInt(S(o,"border-left-width")),c=a+i.height,u=s+i.width;break}}while(o=o.parentNode);if(r&&t!==window){var h=C(o||t),g=h&&h.a,v=h&&h.d;h&&(c=(a/=v)+(d/=v),u=(s/=g)+(f/=g))}return{top:a,left:s,bottom:c,right:u,width:f,height:d}}}function D(t,e,n){for(var r=P(t,!0),o=T(t)[e];r;){var i=T(r)[n];if(!("top"===n||"left"===n?o>=i:o<=i))return r;if(r===A())break;r=P(r,!1)}return!1}function O(t,e,n){for(var r=0,o=0,i=t.children;o<i.length;){if("none"!==i[o].style.display&&i[o]!==Lt.ghost&&i[o]!==Lt.dragged&&y(i[o],n.draggable,t,!1)){if(r===e)return i[o];r++}o++}return null}function N(t,e){for(var n=t.lastElementChild;n&&(n===Lt.ghost||"none"===S(n,"display")||e&&!m(n,e));)n=n.previousElementSibling;return n||null}function k(t,e){var n=0;if(!t||!t.parentNode)return-1;for(;t=t.previousElementSibling;)"TEMPLATE"===t.nodeName.toUpperCase()||t===Lt.clone||e&&!m(t,e)||n++;return n}function M(t){var e=0,n=0,r=A();if(t)do{var o=C(t),i=o.a,a=o.d;e+=t.scrollLeft*i,n+=t.scrollTop*a}while(t!==r&&(t=t.parentNode));return[e,n]}function P(t,e){if(!t||!t.getBoundingClientRect)return A();var n=t,r=!1;do{if(n.clientWidth<n.scrollWidth||n.clientHeight<n.scrollHeight){var o=S(n);if(n.clientWidth<n.scrollWidth&&("auto"==o.overflowX||"scroll"==o.overflowX)||n.clientHeight<n.scrollHeight&&("auto"==o.overflowY||"scroll"==o.overflowY)){if(!n.getBoundingClientRect||n===document.body)return A();if(r||e)return n;r=!0}}}while(n=n.parentNode);return A()}function I(t,e){return Math.round(t.top)===Math.round(e.top)&&Math.round(t.left)===Math.round(e.left)&&Math.round(t.height)===Math.round(e.height)&&Math.round(t.width)===Math.round(e.width)}function j(t,e){return function(){if(!x){var n=arguments;1===n.length?t.call(this,n[0]):t.apply(this,n),x=setTimeout((function(){x=void 0}),e)}}}function R(t,e,n){t.scrollLeft+=e,t.scrollTop+=n}function L(t){var e=window.Polymer,n=window.jQuery||window.Zepto;return e&&e.dom?e.dom(t).cloneNode(!0):n?n(t).clone(!0)[0]:t.cloneNode(!0)}function H(t,e){S(t,"position","absolute"),S(t,"top",e.top),S(t,"left",e.left),S(t,"width",e.width),S(t,"height",e.height)}function F(t){S(t,"position",""),S(t,"top",""),S(t,"left",""),S(t,"width",""),S(t,"height","")}var B="Sortable"+(new Date).getTime();var V=[],$={initializeByDefault:!0},X={mount:function(t){for(var e in $)$.hasOwnProperty(e)&&!(e in t)&&(t[e]=$[e]);V.push(t)},pluginEvent:function(t,e,n){var r=this;this.eventCanceled=!1,n.cancel=function(){r.eventCanceled=!0};var o=t+"Global";V.forEach((function(r){e[r.pluginName]&&(e[r.pluginName][o]&&e[r.pluginName][o](a({sortable:e},n)),e.options[r.pluginName]&&e[r.pluginName][t]&&e[r.pluginName][t](a({sortable:e},n)))}))},initializePlugins:function(t,e,n,r){for(var o in V.forEach((function(r){var o=r.pluginName;if(t.options[o]||r.initializeByDefault){var a=new r(t,e,t.options);a.sortable=t,a.options=t.options,t[o]=a,i(n,a.defaults)}})),t.options)if(t.options.hasOwnProperty(o)){var a=this.modifyOption(t,o,t.options[o]);void 0!==a&&(t.options[o]=a)}},getEventProperties:function(t,e){var n={};return V.forEach((function(r){"function"==typeof r.eventProperties&&i(n,r.eventProperties.call(e[r.pluginName],t))})),n},modifyOption:function(t,e,n){var r;return V.forEach((function(o){t[o.pluginName]&&o.optionListeners&&"function"==typeof o.optionListeners[e]&&(r=o.optionListeners[e].call(t[o.pluginName],n))})),r}};function Y(t){var e=t.sortable,n=t.rootEl,r=t.name,o=t.targetEl,i=t.cloneEl,s=t.toEl,u=t.fromEl,d=t.oldIndex,f=t.newIndex,p=t.oldDraggableIndex,h=t.newDraggableIndex,g=t.originalEvent,v=t.putSortable,m=t.extraEventProperties;if(e=e||n&&n[B]){var b,y=e.options,x="on"+r.charAt(0).toUpperCase()+r.substr(1);!window.CustomEvent||l||c?(b=document.createEvent("Event")).initEvent(r,!0,!0):b=new CustomEvent(r,{bubbles:!0,cancelable:!0}),b.to=s||n,b.from=u||n,b.item=o||n,b.clone=i,b.oldIndex=d,b.newIndex=f,b.oldDraggableIndex=p,b.newDraggableIndex=h,b.originalEvent=g,b.pullMode=v?v.lastPutMode:void 0;var w=a({},m,X.getEventProperties(r,e));for(var _ in w)b[_]=w[_];n&&n.dispatchEvent(b),y[x]&&y[x].call(e,b)}}var U=function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=n.evt,o=function(t,e){if(null==t)return{};var n,r,o=function(t,e){if(null==t)return{};var n,r,o={},i=Object.keys(t);for(r=0;r<i.length;r++)n=i[r],e.indexOf(n)>=0||(o[n]=t[n]);return o}(t,e);if(Object.getOwnPropertySymbols){var i=Object.getOwnPropertySymbols(t);for(r=0;r<i.length;r++)n=i[r],e.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(t,n)&&(o[n]=t[n])}return o}(n,["evt"]);X.pluginEvent.bind(Lt)(t,e,a({dragEl:G,parentEl:z,ghostEl:K,rootEl:q,nextEl:J,lastDownEl:Z,cloneEl:Q,cloneHidden:tt,dragStarted:pt,putSortable:at,activeSortable:Lt.active,originalEvent:r,oldIndex:et,oldDraggableIndex:rt,newIndex:nt,newDraggableIndex:ot,hideGhostForTarget:Pt,unhideGhostForTarget:It,cloneNowHidden:function(){tt=!0},cloneNowShown:function(){tt=!1},dispatchSortableEvent:function(t){W({sortable:e,name:t,originalEvent:r})}},o))};function W(t){Y(a({putSortable:at,cloneEl:Q,targetEl:G,rootEl:q,oldIndex:et,oldDraggableIndex:rt,newIndex:nt,newDraggableIndex:ot},t))}var G,z,K,q,J,Z,Q,tt,et,nt,rt,ot,it,at,st,lt,ct,ut,dt,ft,pt,ht,gt,vt,mt,bt=!1,yt=!1,xt=[],wt=!1,_t=!1,St=[],Ct=!1,Et=[],At="undefined"!=typeof document,Tt=f,Dt=c||l?"cssFloat":"float",Ot=At&&!p&&!f&&"draggable"in document.createElement("div"),Nt=function(){if(At){if(l)return!1;var t=document.createElement("x");return t.style.cssText="pointer-events:auto","auto"===t.style.pointerEvents}}(),kt=function(t,e){var n=S(t),r=parseInt(n.width)-parseInt(n.paddingLeft)-parseInt(n.paddingRight)-parseInt(n.borderLeftWidth)-parseInt(n.borderRightWidth),o=O(t,0,e),i=O(t,1,e),a=o&&S(o),s=i&&S(i),l=a&&parseInt(a.marginLeft)+parseInt(a.marginRight)+T(o).width,c=s&&parseInt(s.marginLeft)+parseInt(s.marginRight)+T(i).width;if("flex"===n.display)return"column"===n.flexDirection||"column-reverse"===n.flexDirection?"vertical":"horizontal";if("grid"===n.display)return n.gridTemplateColumns.split(" ").length<=1?"vertical":"horizontal";if(o&&a.float&&"none"!==a.float){var u="left"===a.float?"left":"right";return!i||"both"!==s.clear&&s.clear!==u?"horizontal":"vertical"}return o&&("block"===a.display||"flex"===a.display||"table"===a.display||"grid"===a.display||l>=r&&"none"===n[Dt]||i&&"none"===n[Dt]&&l+c>r)?"vertical":"horizontal"},Mt=function(t){function e(t,n){return function(r,o,i,a){var s=r.options.group.name&&o.options.group.name&&r.options.group.name===o.options.group.name;if(null==t&&(n||s))return!0;if(null==t||!1===t)return!1;if(n&&"clone"===t)return t;if("function"==typeof t)return e(t(r,o,i,a),n)(r,o,i,a);var l=(n?r:o).options.group.name;return!0===t||"string"==typeof t&&t===l||t.join&&t.indexOf(l)>-1}}var n={},o=t.group;o&&"object"==r(o)||(o={name:o}),n.name=o.name,n.checkPull=e(o.pull,!0),n.checkPut=e(o.put),n.revertClone=o.revertClone,t.group=n},Pt=function(){!Nt&&K&&S(K,"display","none")},It=function(){!Nt&&K&&S(K,"display","")};At&&document.addEventListener("click",(function(t){if(yt)return t.preventDefault(),t.stopPropagation&&t.stopPropagation(),t.stopImmediatePropagation&&t.stopImmediatePropagation(),yt=!1,!1}),!0);var jt=function(t){if(G){t=t.touches?t.touches[0]:t;var e=(o=t.clientX,i=t.clientY,xt.some((function(t){if(!N(t)){var e=T(t),n=t[B].options.emptyInsertThreshold,r=o>=e.left-n&&o<=e.right+n,s=i>=e.top-n&&i<=e.bottom+n;return n&&r&&s?a=t:void 0}})),a);if(e){var n={};for(var r in t)t.hasOwnProperty(r)&&(n[r]=t[r]);n.target=n.rootEl=e,n.preventDefault=void 0,n.stopPropagation=void 0,e[B]._onDragOver(n)}}var o,i,a},Rt=function(t){G&&G.parentNode[B]._isOutsideThisEl(t.target)};function Lt(t,e){if(!t||!t.nodeType||1!==t.nodeType)throw"Sortable: `el` must be an HTMLElement, not ".concat({}.toString.call(t));this.el=t,this.options=e=i({},e),t[B]=this;var n,r,o={group:null,sort:!0,disabled:!1,store:null,handle:null,draggable:/^[uo]l$/i.test(t.nodeName)?">li":">*",swapThreshold:1,invertSwap:!1,invertedSwapThreshold:null,removeCloneOnHide:!0,direction:function(){return kt(t,this.options)},ghostClass:"sortable-ghost",chosenClass:"sortable-chosen",dragClass:"sortable-drag",ignore:"a, img",filter:null,preventOnFilter:!0,animation:0,easing:null,setData:function(t,e){t.setData("Text",e.textContent)},dropBubble:!1,dragoverBubble:!1,dataIdAttr:"data-id",delay:0,delayOnTouchOnly:!1,touchStartThreshold:(Number.parseInt?Number:window).parseInt(window.devicePixelRatio,10)||1,forceFallback:!1,fallbackClass:"sortable-fallback",fallbackOnBody:!1,fallbackTolerance:0,fallbackOffset:{x:0,y:0},supportPointer:!1!==Lt.supportPointer&&"PointerEvent"in window,emptyInsertThreshold:5};for(var s in X.initializePlugins(this,t,o),o)!(s in e)&&(e[s]=o[s]);for(var l in Mt(e),this)"_"===l.charAt(0)&&"function"==typeof this[l]&&(this[l]=this[l].bind(this));this.nativeDraggable=!e.forceFallback&&Ot,this.nativeDraggable&&(this.options.touchStartThreshold=1),e.supportPointer?g(t,"pointerdown",this._onTapStart):(g(t,"mousedown",this._onTapStart),g(t,"touchstart",this._onTapStart)),this.nativeDraggable&&(g(t,"dragover",this),g(t,"dragenter",this)),xt.push(this.el),e.store&&e.store.get&&this.sort(e.store.get(this)||[]),i(this,(r=[],{captureAnimationState:function(){r=[],this.options.animation&&[].slice.call(this.el.children).forEach((function(t){if("none"!==S(t,"display")&&t!==Lt.ghost){r.push({target:t,rect:T(t)});var e=a({},r[r.length-1].rect);if(t.thisAnimationDuration){var n=C(t,!0);n&&(e.top-=n.f,e.left-=n.e)}t.fromRect=e}}))},addAnimationState:function(t){r.push(t)},removeAnimationState:function(t){r.splice(function(t,e){for(var n in t)if(t.hasOwnProperty(n))for(var r in e)if(e.hasOwnProperty(r)&&e[r]===t[n][r])return Number(n);return-1}(r,{target:t}),1)},animateAll:function(t){var e=this;if(!this.options.animation)return clearTimeout(n),void("function"==typeof t&&t());var o=!1,i=0;r.forEach((function(t){var n=0,r=t.target,a=r.fromRect,s=T(r),l=r.prevFromRect,c=r.prevToRect,u=t.rect,d=C(r,!0);d&&(s.top-=d.f,s.left-=d.e),r.toRect=s,r.thisAnimationDuration&&I(l,s)&&!I(a,s)&&(u.top-s.top)/(u.left-s.left)==(a.top-s.top)/(a.left-s.left)&&(n=function(t,e,n,r){return Math.sqrt(Math.pow(e.top-t.top,2)+Math.pow(e.left-t.left,2))/Math.sqrt(Math.pow(e.top-n.top,2)+Math.pow(e.left-n.left,2))*r.animation}(u,l,c,e.options)),I(s,a)||(r.prevFromRect=a,r.prevToRect=s,n||(n=e.options.animation),e.animate(r,u,s,n)),n&&(o=!0,i=Math.max(i,n),clearTimeout(r.animationResetTimer),r.animationResetTimer=setTimeout((function(){r.animationTime=0,r.prevFromRect=null,r.fromRect=null,r.prevToRect=null,r.thisAnimationDuration=null}),n),r.thisAnimationDuration=n)})),clearTimeout(n),o?n=setTimeout((function(){"function"==typeof t&&t()}),i):"function"==typeof t&&t(),r=[]},animate:function(t,e,n,r){if(r){S(t,"transition",""),S(t,"transform","");var o=C(this.el),i=o&&o.a,a=o&&o.d,s=(e.left-n.left)/(i||1),l=(e.top-n.top)/(a||1);t.animatingX=!!s,t.animatingY=!!l,S(t,"transform","translate3d("+s+"px,"+l+"px,0)"),function(t){t.offsetWidth}(t),S(t,"transition","transform "+r+"ms"+(this.options.easing?" "+this.options.easing:"")),S(t,"transform","translate3d(0,0,0)"),"number"==typeof t.animated&&clearTimeout(t.animated),t.animated=setTimeout((function(){S(t,"transition",""),S(t,"transform",""),t.animated=!1,t.animatingX=!1,t.animatingY=!1}),r)}}}))}function Ht(t,e,n,r,o,i,a,s){var u,d,f=t[B],p=f.options.onMove;return!window.CustomEvent||l||c?(u=document.createEvent("Event")).initEvent("move",!0,!0):u=new CustomEvent("move",{bubbles:!0,cancelable:!0}),u.to=e,u.from=t,u.dragged=n,u.draggedRect=r,u.related=o||e,u.relatedRect=i||T(e),u.willInsertAfter=s,u.originalEvent=a,t.dispatchEvent(u),p&&(d=p.call(f,u,a)),d}function Ft(t){t.draggable=!1}function Bt(){Ct=!1}function Vt(t){for(var e=t.tagName+t.className+t.src+t.href+t.textContent,n=e.length,r=0;n--;)r+=e.charCodeAt(n);return r.toString(36)}function $t(t){return setTimeout(t,0)}function Xt(t){return clearTimeout(t)}Lt.prototype={constructor:Lt,_isOutsideThisEl:function(t){this.el.contains(t)||t===this.el||(ht=null)},_getDirection:function(t,e){return"function"==typeof this.options.direction?this.options.direction.call(this,t,e,G):this.options.direction},_onTapStart:function(t){if(t.cancelable){var e=this,n=this.el,r=this.options,o=r.preventOnFilter,i=t.type,a=t.touches&&t.touches[0]||t.pointerType&&"touch"===t.pointerType&&t,s=(a||t).target,l=t.target.shadowRoot&&(t.path&&t.path[0]||t.composedPath&&t.composedPath()[0])||s,c=r.filter;if(function(t){Et.length=0;for(var e=t.getElementsByTagName("input"),n=e.length;n--;){var r=e[n];r.checked&&Et.push(r)}}(n),!G&&!(/mousedown|pointerdown/.test(i)&&0!==t.button||r.disabled||l.isContentEditable||(s=y(s,r.draggable,n,!1))&&s.animated||Z===s)){if(et=k(s),rt=k(s,r.draggable),"function"==typeof c){if(c.call(this,t,s,this))return W({sortable:e,rootEl:l,name:"filter",targetEl:s,toEl:n,fromEl:n}),U("filter",e,{evt:t}),void(o&&t.cancelable&&t.preventDefault())}else if(c&&(c=c.split(",").some((function(r){if(r=y(l,r.trim(),n,!1))return W({sortable:e,rootEl:r,name:"filter",targetEl:s,fromEl:n,toEl:n}),U("filter",e,{evt:t}),!0}))))return void(o&&t.cancelable&&t.preventDefault());r.handle&&!y(l,r.handle,n,!1)||this._prepareDragStart(t,a,s)}}},_prepareDragStart:function(t,e,n){var r,o=this,i=o.el,a=o.options,s=i.ownerDocument;if(n&&!G&&n.parentNode===i){var d=T(n);if(q=i,z=(G=n).parentNode,J=G.nextSibling,Z=n,it=a.group,Lt.dragged=G,st={target:G,clientX:(e||t).clientX,clientY:(e||t).clientY},dt=st.clientX-d.left,ft=st.clientY-d.top,this._lastX=(e||t).clientX,this._lastY=(e||t).clientY,G.style["will-change"]="all",r=function(){U("delayEnded",o,{evt:t}),Lt.eventCanceled?o._onDrop():(o._disableDelayedDragEvents(),!u&&o.nativeDraggable&&(G.draggable=!0),o._triggerDragStart(t,e),W({sortable:o,name:"choose",originalEvent:t}),_(G,a.chosenClass,!0))},a.ignore.split(",").forEach((function(t){E(G,t.trim(),Ft)})),g(s,"dragover",jt),g(s,"mousemove",jt),g(s,"touchmove",jt),g(s,"mouseup",o._onDrop),g(s,"touchend",o._onDrop),g(s,"touchcancel",o._onDrop),u&&this.nativeDraggable&&(this.options.touchStartThreshold=4,G.draggable=!0),U("delayStart",this,{evt:t}),!a.delay||a.delayOnTouchOnly&&!e||this.nativeDraggable&&(c||l))r();else{if(Lt.eventCanceled)return void this._onDrop();g(s,"mouseup",o._disableDelayedDrag),g(s,"touchend",o._disableDelayedDrag),g(s,"touchcancel",o._disableDelayedDrag),g(s,"mousemove",o._delayedDragTouchMoveHandler),g(s,"touchmove",o._delayedDragTouchMoveHandler),a.supportPointer&&g(s,"pointermove",o._delayedDragTouchMoveHandler),o._dragStartTimer=setTimeout(r,a.delay)}}},_delayedDragTouchMoveHandler:function(t){var e=t.touches?t.touches[0]:t;Math.max(Math.abs(e.clientX-this._lastX),Math.abs(e.clientY-this._lastY))>=Math.floor(this.options.touchStartThreshold/(this.nativeDraggable&&window.devicePixelRatio||1))&&this._disableDelayedDrag()},_disableDelayedDrag:function(){G&&Ft(G),clearTimeout(this._dragStartTimer),this._disableDelayedDragEvents()},_disableDelayedDragEvents:function(){var t=this.el.ownerDocument;v(t,"mouseup",this._disableDelayedDrag),v(t,"touchend",this._disableDelayedDrag),v(t,"touchcancel",this._disableDelayedDrag),v(t,"mousemove",this._delayedDragTouchMoveHandler),v(t,"touchmove",this._delayedDragTouchMoveHandler),v(t,"pointermove",this._delayedDragTouchMoveHandler)},_triggerDragStart:function(t,e){e=e||"touch"==t.pointerType&&t,!this.nativeDraggable||e?this.options.supportPointer?g(document,"pointermove",this._onTouchMove):g(document,e?"touchmove":"mousemove",this._onTouchMove):(g(G,"dragend",this),g(q,"dragstart",this._onDragStart));try{document.selection?$t((function(){document.selection.empty()})):window.getSelection().removeAllRanges()}catch(t){}},_dragStarted:function(t,e){if(bt=!1,q&&G){U("dragStarted",this,{evt:e}),this.nativeDraggable&&g(document,"dragover",Rt);var n=this.options;!t&&_(G,n.dragClass,!1),_(G,n.ghostClass,!0),Lt.active=this,t&&this._appendGhost(),W({sortable:this,name:"start",originalEvent:e})}else this._nulling()},_emulateDragOver:function(){if(lt){this._lastX=lt.clientX,this._lastY=lt.clientY,Pt();for(var t=document.elementFromPoint(lt.clientX,lt.clientY),e=t;t&&t.shadowRoot&&(t=t.shadowRoot.elementFromPoint(lt.clientX,lt.clientY))!==e;)e=t;if(G.parentNode[B]._isOutsideThisEl(t),e)do{if(e[B]&&e[B]._onDragOver({clientX:lt.clientX,clientY:lt.clientY,target:t,rootEl:e})&&!this.options.dragoverBubble)break;t=e}while(e=e.parentNode);It()}},_onTouchMove:function(t){if(st){var e=this.options,n=e.fallbackTolerance,r=e.fallbackOffset,o=t.touches?t.touches[0]:t,i=K&&C(K,!0),a=K&&i&&i.a,s=K&&i&&i.d,l=Tt&&mt&&M(mt),c=(o.clientX-st.clientX+r.x)/(a||1)+(l?l[0]-St[0]:0)/(a||1),u=(o.clientY-st.clientY+r.y)/(s||1)+(l?l[1]-St[1]:0)/(s||1);if(!Lt.active&&!bt){if(n&&Math.max(Math.abs(o.clientX-this._lastX),Math.abs(o.clientY-this._lastY))<n)return;this._onDragStart(t,!0)}if(K){i?(i.e+=c-(ct||0),i.f+=u-(ut||0)):i={a:1,b:0,c:0,d:1,e:c,f:u};var d="matrix(".concat(i.a,",").concat(i.b,",").concat(i.c,",").concat(i.d,",").concat(i.e,",").concat(i.f,")");S(K,"webkitTransform",d),S(K,"mozTransform",d),S(K,"msTransform",d),S(K,"transform",d),ct=c,ut=u,lt=o}t.cancelable&&t.preventDefault()}},_appendGhost:function(){if(!K){var t=this.options.fallbackOnBody?document.body:q,e=T(G,!0,Tt,!0,t),n=this.options;if(Tt){for(mt=t;"static"===S(mt,"position")&&"none"===S(mt,"transform")&&mt!==document;)mt=mt.parentNode;mt!==document.body&&mt!==document.documentElement?(mt===document&&(mt=A()),e.top+=mt.scrollTop,e.left+=mt.scrollLeft):mt=A(),St=M(mt)}_(K=G.cloneNode(!0),n.ghostClass,!1),_(K,n.fallbackClass,!0),_(K,n.dragClass,!0),S(K,"transition",""),S(K,"transform",""),S(K,"box-sizing","border-box"),S(K,"margin",0),S(K,"top",e.top),S(K,"left",e.left),S(K,"width",e.width),S(K,"height",e.height),S(K,"opacity","0.8"),S(K,"position",Tt?"absolute":"fixed"),S(K,"zIndex","100000"),S(K,"pointerEvents","none"),Lt.ghost=K,t.appendChild(K),S(K,"transform-origin",dt/parseInt(K.style.width)*100+"% "+ft/parseInt(K.style.height)*100+"%")}},_onDragStart:function(t,e){var n=this,r=t.dataTransfer,o=n.options;U("dragStart",this,{evt:t}),Lt.eventCanceled?this._onDrop():(U("setupClone",this),Lt.eventCanceled||((Q=L(G)).draggable=!1,Q.style["will-change"]="",this._hideClone(),_(Q,this.options.chosenClass,!1),Lt.clone=Q),n.cloneId=$t((function(){U("clone",n),Lt.eventCanceled||(n.options.removeCloneOnHide||q.insertBefore(Q,G),n._hideClone(),W({sortable:n,name:"clone"}))})),!e&&_(G,o.dragClass,!0),e?(yt=!0,n._loopId=setInterval(n._emulateDragOver,50)):(v(document,"mouseup",n._onDrop),v(document,"touchend",n._onDrop),v(document,"touchcancel",n._onDrop),r&&(r.effectAllowed="move",o.setData&&o.setData.call(n,r,G)),g(document,"drop",n),S(G,"transform","translateZ(0)")),bt=!0,n._dragStartId=$t(n._dragStarted.bind(n,e,t)),g(document,"selectstart",n),pt=!0,d&&S(document.body,"user-select","none"))},_onDragOver:function(t){var e,n,r,o,i=this.el,s=t.target,l=this.options,c=l.group,u=Lt.active,d=it===c,f=l.sort,p=at||u,h=this,g=!1;if(!Ct){if(void 0!==t.preventDefault&&t.cancelable&&t.preventDefault(),s=y(s,l.draggable,i,!0),L("dragOver"),Lt.eventCanceled)return g;if(G.contains(t.target)||s.animated&&s.animatingX&&s.animatingY||h._ignoreWhileAnimating===s)return F(!1);if(yt=!1,u&&!l.disabled&&(d?f||(r=!q.contains(G)):at===this||(this.lastPutMode=it.checkPull(this,u,G,t))&&c.checkPut(this,u,G,t))){if(o="vertical"===this._getDirection(t,s),e=T(G),L("dragOverValid"),Lt.eventCanceled)return g;if(r)return z=q,H(),this._hideClone(),L("revert"),Lt.eventCanceled||(J?q.insertBefore(G,J):q.appendChild(G)),F(!0);var v=N(i,l.draggable);if(!v||function(t,e,n){var r=T(N(n.el,n.options.draggable));return e?t.clientX>r.right+10||t.clientX<=r.right&&t.clientY>r.bottom&&t.clientX>=r.left:t.clientX>r.right&&t.clientY>r.top||t.clientX<=r.right&&t.clientY>r.bottom+10}(t,o,this)&&!v.animated){if(v===G)return F(!1);if(v&&i===t.target&&(s=v),s&&(n=T(s)),!1!==Ht(q,i,G,e,s,n,t,!!s))return H(),i.appendChild(G),z=i,V(),F(!0)}else if(s.parentNode===i){n=T(s);var m,b,x,w=G.parentNode!==i,C=!function(t,e,n){var r=n?t.left:t.top,o=n?t.right:t.bottom,i=n?t.width:t.height,a=n?e.left:e.top,s=n?e.right:e.bottom,l=n?e.width:e.height;return r===a||o===s||r+i/2===a+l/2}(G.animated&&G.toRect||e,s.animated&&s.toRect||n,o),E=o?"top":"left",A=D(s,"top","top")||D(G,"top","top"),O=A?A.scrollTop:void 0;if(ht!==s&&(b=n[E],wt=!1,_t=!C&&l.invertSwap||w),m=function(t,e,n,r,o,i,a,s){var l=r?t.clientY:t.clientX,c=r?n.height:n.width,u=r?n.top:n.left,d=r?n.bottom:n.right,f=!1;if(!a)if(s&&vt<c*o){if(!wt&&(1===gt?l>u+c*i/2:l<d-c*i/2)&&(wt=!0),wt)f=!0;else if(1===gt?l<u+vt:l>d-vt)return-gt}else if(l>u+c*(1-o)/2&&l<d-c*(1-o)/2)return function(t){return k(G)<k(t)?1:-1}(e);return(f=f||a)&&(l<u+c*i/2||l>d-c*i/2)?l>u+c/2?1:-1:0}(t,s,n,o,C?1:l.swapThreshold,null==l.invertedSwapThreshold?l.swapThreshold:l.invertedSwapThreshold,_t,ht===s),0!==m){var M=k(G);do{M-=m,x=z.children[M]}while(x&&("none"===S(x,"display")||x===K))}if(0===m||x===s)return F(!1);ht=s,gt=m;var P=s.nextElementSibling,I=!1,j=Ht(q,i,G,e,s,n,t,I=1===m);if(!1!==j)return 1!==j&&-1!==j||(I=1===j),Ct=!0,setTimeout(Bt,30),H(),I&&!P?i.appendChild(G):s.parentNode.insertBefore(G,I?P:s),A&&R(A,0,O-A.scrollTop),z=G.parentNode,void 0===b||_t||(vt=Math.abs(b-T(s)[E])),V(),F(!0)}if(i.contains(G))return F(!1)}return!1}function L(l,c){U(l,h,a({evt:t,isOwner:d,axis:o?"vertical":"horizontal",revert:r,dragRect:e,targetRect:n,canSort:f,fromSortable:p,target:s,completed:F,onMove:function(n,r){return Ht(q,i,G,e,n,T(n),t,r)},changed:V},c))}function H(){L("dragOverAnimationCapture"),h.captureAnimationState(),h!==p&&p.captureAnimationState()}function F(e){return L("dragOverCompleted",{insertion:e}),e&&(d?u._hideClone():u._showClone(h),h!==p&&(_(G,at?at.options.ghostClass:u.options.ghostClass,!1),_(G,l.ghostClass,!0)),at!==h&&h!==Lt.active?at=h:h===Lt.active&&at&&(at=null),p===h&&(h._ignoreWhileAnimating=s),h.animateAll((function(){L("dragOverAnimationComplete"),h._ignoreWhileAnimating=null})),h!==p&&(p.animateAll(),p._ignoreWhileAnimating=null)),(s===G&&!G.animated||s===i&&!s.animated)&&(ht=null),l.dragoverBubble||t.rootEl||s===document||(G.parentNode[B]._isOutsideThisEl(t.target),!e&&jt(t)),!l.dragoverBubble&&t.stopPropagation&&t.stopPropagation(),g=!0}function V(){nt=k(G),ot=k(G,l.draggable),W({sortable:h,name:"change",toEl:i,newIndex:nt,newDraggableIndex:ot,originalEvent:t})}},_ignoreWhileAnimating:null,_offMoveEvents:function(){v(document,"mousemove",this._onTouchMove),v(document,"touchmove",this._onTouchMove),v(document,"pointermove",this._onTouchMove),v(document,"dragover",jt),v(document,"mousemove",jt),v(document,"touchmove",jt)},_offUpEvents:function(){var t=this.el.ownerDocument;v(t,"mouseup",this._onDrop),v(t,"touchend",this._onDrop),v(t,"pointerup",this._onDrop),v(t,"touchcancel",this._onDrop),v(document,"selectstart",this)},_onDrop:function(t){var e=this.el,n=this.options;nt=k(G),ot=k(G,n.draggable),U("drop",this,{evt:t}),z=G&&G.parentNode,nt=k(G),ot=k(G,n.draggable),Lt.eventCanceled||(bt=!1,_t=!1,wt=!1,clearInterval(this._loopId),clearTimeout(this._dragStartTimer),Xt(this.cloneId),Xt(this._dragStartId),this.nativeDraggable&&(v(document,"drop",this),v(e,"dragstart",this._onDragStart)),this._offMoveEvents(),this._offUpEvents(),d&&S(document.body,"user-select",""),S(G,"transform",""),t&&(pt&&(t.cancelable&&t.preventDefault(),!n.dropBubble&&t.stopPropagation()),K&&K.parentNode&&K.parentNode.removeChild(K),(q===z||at&&"clone"!==at.lastPutMode)&&Q&&Q.parentNode&&Q.parentNode.removeChild(Q),G&&(this.nativeDraggable&&v(G,"dragend",this),Ft(G),G.style["will-change"]="",pt&&!bt&&_(G,at?at.options.ghostClass:this.options.ghostClass,!1),_(G,this.options.chosenClass,!1),W({sortable:this,name:"unchoose",toEl:z,newIndex:null,newDraggableIndex:null,originalEvent:t}),q!==z?(nt>=0&&(W({rootEl:z,name:"add",toEl:z,fromEl:q,originalEvent:t}),W({sortable:this,name:"remove",toEl:z,originalEvent:t}),W({rootEl:z,name:"sort",toEl:z,fromEl:q,originalEvent:t}),W({sortable:this,name:"sort",toEl:z,originalEvent:t})),at&&at.save()):nt!==et&&nt>=0&&(W({sortable:this,name:"update",toEl:z,originalEvent:t}),W({sortable:this,name:"sort",toEl:z,originalEvent:t})),Lt.active&&(null!=nt&&-1!==nt||(nt=et,ot=rt),W({sortable:this,name:"end",toEl:z,originalEvent:t}),this.save())))),this._nulling()},_nulling:function(){U("nulling",this),q=G=z=K=J=Q=Z=tt=st=lt=pt=nt=ot=et=rt=ht=gt=at=it=Lt.dragged=Lt.ghost=Lt.clone=Lt.active=null,Et.forEach((function(t){t.checked=!0})),Et.length=ct=ut=0},handleEvent:function(t){switch(t.type){case"drop":case"dragend":this._onDrop(t);break;case"dragenter":case"dragover":G&&(this._onDragOver(t),function(t){t.dataTransfer&&(t.dataTransfer.dropEffect="move"),t.cancelable&&t.preventDefault()}(t));break;case"selectstart":t.preventDefault()}},toArray:function(){for(var t,e=[],n=this.el.children,r=0,o=n.length,i=this.options;r<o;r++)y(t=n[r],i.draggable,this.el,!1)&&e.push(t.getAttribute(i.dataIdAttr)||Vt(t));return e},sort:function(t){var e={},n=this.el;this.toArray().forEach((function(t,r){var o=n.children[r];y(o,this.options.draggable,n,!1)&&(e[t]=o)}),this),t.forEach((function(t){e[t]&&(n.removeChild(e[t]),n.appendChild(e[t]))}))},save:function(){var t=this.options.store;t&&t.set&&t.set(this)},closest:function(t,e){return y(t,e||this.options.draggable,this.el,!1)},option:function(t,e){var n=this.options;if(void 0===e)return n[t];var r=X.modifyOption(this,t,e);n[t]=void 0!==r?r:e,"group"===t&&Mt(n)},destroy:function(){U("destroy",this);var t=this.el;t[B]=null,v(t,"mousedown",this._onTapStart),v(t,"touchstart",this._onTapStart),v(t,"pointerdown",this._onTapStart),this.nativeDraggable&&(v(t,"dragover",this),v(t,"dragenter",this)),Array.prototype.forEach.call(t.querySelectorAll("[draggable]"),(function(t){t.removeAttribute("draggable")})),this._onDrop(),this._disableDelayedDragEvents(),xt.splice(xt.indexOf(this.el),1),this.el=t=null},_hideClone:function(){if(!tt){if(U("hideClone",this),Lt.eventCanceled)return;S(Q,"display","none"),this.options.removeCloneOnHide&&Q.parentNode&&Q.parentNode.removeChild(Q),tt=!0}},_showClone:function(t){if("clone"===t.lastPutMode){if(tt){if(U("showClone",this),Lt.eventCanceled)return;q.contains(G)&&!this.options.group.revertClone?q.insertBefore(Q,G):J?q.insertBefore(Q,J):q.appendChild(Q),this.options.group.revertClone&&this.animate(G,Q),S(Q,"display",""),tt=!1}}else this._hideClone()}},At&&g(document,"touchmove",(function(t){(Lt.active||bt)&&t.cancelable&&t.preventDefault()})),Lt.utils={on:g,off:v,css:S,find:E,is:function(t,e){return!!y(t,e,t,!1)},extend:function(t,e){if(t&&e)for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t},throttle:j,closest:y,toggleClass:_,clone:L,index:k,nextTick:$t,cancelNextTick:Xt,detectDirection:kt,getChild:O},Lt.get=function(t){return t[B]},Lt.mount=function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];e[0].constructor===Array&&(e=e[0]),e.forEach((function(t){if(!t.prototype||!t.prototype.constructor)throw"Sortable: Mounted plugin must be a constructor function, not ".concat({}.toString.call(t));t.utils&&(Lt.utils=a({},Lt.utils,t.utils)),X.mount(t)}))},Lt.create=function(t,e){return new Lt(t,e)},Lt.version="1.10.2";var Yt,Ut,Wt,Gt,zt,Kt,qt=[],Jt=!1;function Zt(){qt.forEach((function(t){clearInterval(t.pid)})),qt=[]}function Qt(){clearInterval(Kt)}var te,ee=j((function(t,e,n,r){if(e.scroll){var o,i=(t.touches?t.touches[0]:t).clientX,a=(t.touches?t.touches[0]:t).clientY,s=e.scrollSensitivity,l=e.scrollSpeed,c=A(),u=!1;Ut!==n&&(Ut=n,Zt(),Yt=e.scroll,o=e.scrollFn,!0===Yt&&(Yt=P(n,!0)));var d=0,f=Yt;do{var p=f,h=T(p),g=h.top,v=h.bottom,m=h.left,b=h.right,y=h.width,x=h.height,w=void 0,_=void 0,C=p.scrollWidth,E=p.scrollHeight,D=S(p),O=p.scrollLeft,N=p.scrollTop;p===c?(w=y<C&&("auto"===D.overflowX||"scroll"===D.overflowX||"visible"===D.overflowX),_=x<E&&("auto"===D.overflowY||"scroll"===D.overflowY||"visible"===D.overflowY)):(w=y<C&&("auto"===D.overflowX||"scroll"===D.overflowX),_=x<E&&("auto"===D.overflowY||"scroll"===D.overflowY));var k=w&&(Math.abs(b-i)<=s&&O+y<C)-(Math.abs(m-i)<=s&&!!O),M=_&&(Math.abs(v-a)<=s&&N+x<E)-(Math.abs(g-a)<=s&&!!N);if(!qt[d])for(var I=0;I<=d;I++)qt[I]||(qt[I]={});qt[d].vx==k&&qt[d].vy==M&&qt[d].el===p||(qt[d].el=p,qt[d].vx=k,qt[d].vy=M,clearInterval(qt[d].pid),0==k&&0==M||(u=!0,qt[d].pid=setInterval(function(){r&&0===this.layer&&Lt.active._onTouchMove(zt);var e=qt[this.layer].vy?qt[this.layer].vy*l:0,n=qt[this.layer].vx?qt[this.layer].vx*l:0;"function"==typeof o&&"continue"!==o.call(Lt.dragged.parentNode[B],n,e,t,zt,qt[this.layer].el)||R(qt[this.layer].el,n,e)}.bind({layer:d}),24))),d++}while(e.bubbleScroll&&f!==c&&(f=P(f,!1)));Jt=u}}),30),ne=function(t){var e=t.originalEvent,n=t.putSortable,r=t.dragEl,o=t.activeSortable,i=t.dispatchSortableEvent,a=t.hideGhostForTarget,s=t.unhideGhostForTarget;if(e){var l=n||o;a();var c=e.changedTouches&&e.changedTouches.length?e.changedTouches[0]:e,u=document.elementFromPoint(c.clientX,c.clientY);s(),l&&!l.el.contains(u)&&(i("spill"),this.onSpill({dragEl:r,putSortable:n}))}};function re(){}function oe(){}function ie(){function t(){this.defaults={swapClass:"sortable-swap-highlight"}}return t.prototype={dragStart:function(t){var e=t.dragEl;te=e},dragOverValid:function(t){var e=t.completed,n=t.target,r=t.onMove,o=t.activeSortable,i=t.changed,a=t.cancel;if(o.options.swap){var s=this.sortable.el,l=this.options;if(n&&n!==s){var c=te;!1!==r(n)?(_(n,l.swapClass,!0),te=n):te=null,c&&c!==te&&_(c,l.swapClass,!1)}i(),e(!0),a()}},drop:function(t){var e,n,r,o,i,a,s=t.activeSortable,l=t.putSortable,c=t.dragEl,u=l||this.sortable,d=this.options;te&&_(te,d.swapClass,!1),te&&(d.swap||l&&l.options.swap)&&c!==te&&(u.captureAnimationState(),u!==s&&s.captureAnimationState(),n=te,i=(e=c).parentNode,a=n.parentNode,i&&a&&!i.isEqualNode(n)&&!a.isEqualNode(e)&&(r=k(e),o=k(n),i.isEqualNode(a)&&r<o&&o++,i.insertBefore(n,i.children[r]),a.insertBefore(e,a.children[o])),u.animateAll(),u!==s&&s.animateAll())},nulling:function(){te=null}},i(t,{pluginName:"swap",eventProperties:function(){return{swapItem:te}}})}re.prototype={startIndex:null,dragStart:function(t){var e=t.oldDraggableIndex;this.startIndex=e},onSpill:function(t){var e=t.dragEl,n=t.putSortable;this.sortable.captureAnimationState(),n&&n.captureAnimationState();var r=O(this.sortable.el,this.startIndex,this.options);r?this.sortable.el.insertBefore(e,r):this.sortable.el.appendChild(e),this.sortable.animateAll(),n&&n.animateAll()},drop:ne},i(re,{pluginName:"revertOnSpill"}),oe.prototype={onSpill:function(t){var e=t.dragEl,n=t.putSortable||this.sortable;n.captureAnimationState(),e.parentNode&&e.parentNode.removeChild(e),n.animateAll()},drop:ne},i(oe,{pluginName:"removeOnSpill"});var ae,se,le,ce,ue,de=[],fe=[],pe=!1,he=!1,ge=!1;function ve(){function t(t){for(var e in this)"_"===e.charAt(0)&&"function"==typeof this[e]&&(this[e]=this[e].bind(this));t.options.supportPointer?g(document,"pointerup",this._deselectMultiDrag):(g(document,"mouseup",this._deselectMultiDrag),g(document,"touchend",this._deselectMultiDrag)),g(document,"keydown",this._checkKeyDown),g(document,"keyup",this._checkKeyUp),this.defaults={selectedClass:"sortable-selected",multiDragKey:null,setData:function(e,n){var r="";de.length&&se===t?de.forEach((function(t,e){r+=(e?", ":"")+t.textContent})):r=n.textContent,e.setData("Text",r)}}}return t.prototype={multiDragKeyDown:!1,isMultiDrag:!1,delayStartGlobal:function(t){var e=t.dragEl;le=e},delayEnded:function(){this.isMultiDrag=~de.indexOf(le)},setupClone:function(t){var e=t.sortable,n=t.cancel;if(this.isMultiDrag){for(var r=0;r<de.length;r++)fe.push(L(de[r])),fe[r].sortableIndex=de[r].sortableIndex,fe[r].draggable=!1,fe[r].style["will-change"]="",_(fe[r],this.options.selectedClass,!1),de[r]===le&&_(fe[r],this.options.chosenClass,!1);e._hideClone(),n()}},clone:function(t){var e=t.sortable,n=t.rootEl,r=t.dispatchSortableEvent,o=t.cancel;this.isMultiDrag&&(this.options.removeCloneOnHide||de.length&&se===e&&(me(!0,n),r("clone"),o()))},showClone:function(t){var e=t.cloneNowShown,n=t.rootEl,r=t.cancel;this.isMultiDrag&&(me(!1,n),fe.forEach((function(t){S(t,"display","")})),e(),ue=!1,r())},hideClone:function(t){var e=this,n=(t.sortable,t.cloneNowHidden),r=t.cancel;this.isMultiDrag&&(fe.forEach((function(t){S(t,"display","none"),e.options.removeCloneOnHide&&t.parentNode&&t.parentNode.removeChild(t)})),n(),ue=!0,r())},dragStartGlobal:function(t){t.sortable,!this.isMultiDrag&&se&&se.multiDrag._deselectMultiDrag(),de.forEach((function(t){t.sortableIndex=k(t)})),de=de.sort((function(t,e){return t.sortableIndex-e.sortableIndex})),ge=!0},dragStarted:function(t){var e=this,n=t.sortable;if(this.isMultiDrag){if(this.options.sort&&(n.captureAnimationState(),this.options.animation)){de.forEach((function(t){t!==le&&S(t,"position","absolute")}));var r=T(le,!1,!0,!0);de.forEach((function(t){t!==le&&H(t,r)})),he=!0,pe=!0}n.animateAll((function(){he=!1,pe=!1,e.options.animation&&de.forEach((function(t){F(t)})),e.options.sort&&be()}))}},dragOver:function(t){var e=t.target,n=t.completed,r=t.cancel;he&&~de.indexOf(e)&&(n(!1),r())},revert:function(t){var e=t.fromSortable,n=t.rootEl,r=t.sortable,o=t.dragRect;de.length>1&&(de.forEach((function(t){r.addAnimationState({target:t,rect:he?T(t):o}),F(t),t.fromRect=o,e.removeAnimationState(t)})),he=!1,function(t,e){de.forEach((function(n,r){var o=e.children[n.sortableIndex+(t?Number(r):0)];o?e.insertBefore(n,o):e.appendChild(n)}))}(!this.options.removeCloneOnHide,n))},dragOverCompleted:function(t){var e=t.sortable,n=t.isOwner,r=t.insertion,o=t.activeSortable,i=t.parentEl,a=t.putSortable,s=this.options;if(r){if(n&&o._hideClone(),pe=!1,s.animation&&de.length>1&&(he||!n&&!o.options.sort&&!a)){var l=T(le,!1,!0,!0);de.forEach((function(t){t!==le&&(H(t,l),i.appendChild(t))})),he=!0}if(!n)if(he||be(),de.length>1){var c=ue;o._showClone(e),o.options.animation&&!ue&&c&&fe.forEach((function(t){o.addAnimationState({target:t,rect:ce}),t.fromRect=ce,t.thisAnimationDuration=null}))}else o._showClone(e)}},dragOverAnimationCapture:function(t){var e=t.dragRect,n=t.isOwner,r=t.activeSortable;if(de.forEach((function(t){t.thisAnimationDuration=null})),r.options.animation&&!n&&r.multiDrag.isMultiDrag){ce=i({},e);var o=C(le,!0);ce.top-=o.f,ce.left-=o.e}},dragOverAnimationComplete:function(){he&&(he=!1,be())},drop:function(t){var e=t.originalEvent,n=t.rootEl,r=t.parentEl,o=t.sortable,i=t.dispatchSortableEvent,a=t.oldIndex,s=t.putSortable,l=s||this.sortable;if(e){var c=this.options,u=r.children;if(!ge)if(c.multiDragKey&&!this.multiDragKeyDown&&this._deselectMultiDrag(),_(le,c.selectedClass,!~de.indexOf(le)),~de.indexOf(le))de.splice(de.indexOf(le),1),ae=null,Y({sortable:o,rootEl:n,name:"deselect",targetEl:le,originalEvt:e});else{if(de.push(le),Y({sortable:o,rootEl:n,name:"select",targetEl:le,originalEvt:e}),e.shiftKey&&ae&&o.el.contains(ae)){var d,f,p=k(ae),h=k(le);if(~p&&~h&&p!==h)for(h>p?(f=p,d=h):(f=h,d=p+1);f<d;f++)~de.indexOf(u[f])||(_(u[f],c.selectedClass,!0),de.push(u[f]),Y({sortable:o,rootEl:n,name:"select",targetEl:u[f],originalEvt:e}))}else ae=le;se=l}if(ge&&this.isMultiDrag){if((r[B].options.sort||r!==n)&&de.length>1){var g=T(le),v=k(le,":not(."+this.options.selectedClass+")");if(!pe&&c.animation&&(le.thisAnimationDuration=null),l.captureAnimationState(),!pe&&(c.animation&&(le.fromRect=g,de.forEach((function(t){if(t.thisAnimationDuration=null,t!==le){var e=he?T(t):g;t.fromRect=e,l.addAnimationState({target:t,rect:e})}}))),be(),de.forEach((function(t){u[v]?r.insertBefore(t,u[v]):r.appendChild(t),v++})),a===k(le))){var m=!1;de.forEach((function(t){t.sortableIndex===k(t)||(m=!0)})),m&&i("update")}de.forEach((function(t){F(t)})),l.animateAll()}se=l}(n===r||s&&"clone"!==s.lastPutMode)&&fe.forEach((function(t){t.parentNode&&t.parentNode.removeChild(t)}))}},nullingGlobal:function(){this.isMultiDrag=ge=!1,fe.length=0},destroyGlobal:function(){this._deselectMultiDrag(),v(document,"pointerup",this._deselectMultiDrag),v(document,"mouseup",this._deselectMultiDrag),v(document,"touchend",this._deselectMultiDrag),v(document,"keydown",this._checkKeyDown),v(document,"keyup",this._checkKeyUp)},_deselectMultiDrag:function(t){if(!(void 0!==ge&&ge||se!==this.sortable||t&&y(t.target,this.options.draggable,this.sortable.el,!1)||t&&0!==t.button))for(;de.length;){var e=de[0];_(e,this.options.selectedClass,!1),de.shift(),Y({sortable:this.sortable,rootEl:this.sortable.el,name:"deselect",targetEl:e,originalEvt:t})}},_checkKeyDown:function(t){t.key===this.options.multiDragKey&&(this.multiDragKeyDown=!0)},_checkKeyUp:function(t){t.key===this.options.multiDragKey&&(this.multiDragKeyDown=!1)}},i(t,{pluginName:"multiDrag",utils:{select:function(t){var e=t.parentNode[B];e&&e.options.multiDrag&&!~de.indexOf(t)&&(se&&se!==e&&(se.multiDrag._deselectMultiDrag(),se=e),_(t,e.options.selectedClass,!0),de.push(t))},deselect:function(t){var e=t.parentNode[B],n=de.indexOf(t);e&&e.options.multiDrag&&~n&&(_(t,e.options.selectedClass,!1),de.splice(n,1))}},eventProperties:function(){var t,e=this,n=[],r=[];return de.forEach((function(t){var o;n.push({multiDragElement:t,index:t.sortableIndex}),o=he&&t!==le?-1:he?k(t,":not(."+e.options.selectedClass+")"):k(t),r.push({multiDragElement:t,index:o})})),{items:(t=de,function(t){if(Array.isArray(t)){for(var e=0,n=new Array(t.length);e<t.length;e++)n[e]=t[e];return n}}(t)||function(t){if(Symbol.iterator in Object(t)||"[object Arguments]"===Object.prototype.toString.call(t))return Array.from(t)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()),clones:[].concat(fe),oldIndicies:n,newIndicies:r}},optionListeners:{multiDragKey:function(t){return"ctrl"===(t=t.toLowerCase())?t="Control":t.length>1&&(t=t.charAt(0).toUpperCase()+t.substr(1)),t}}})}function me(t,e){fe.forEach((function(n,r){var o=e.children[n.sortableIndex+(t?Number(r):0)];o?e.insertBefore(n,o):e.appendChild(n)}))}function be(){de.forEach((function(t){t!==le&&t.parentNode&&t.parentNode.removeChild(t)}))}Lt.mount(new function(){function t(){for(var t in this.defaults={scroll:!0,scrollSensitivity:30,scrollSpeed:10,bubbleScroll:!0},this)"_"===t.charAt(0)&&"function"==typeof this[t]&&(this[t]=this[t].bind(this))}return t.prototype={dragStarted:function(t){var e=t.originalEvent;this.sortable.nativeDraggable?g(document,"dragover",this._handleAutoScroll):this.options.supportPointer?g(document,"pointermove",this._handleFallbackAutoScroll):e.touches?g(document,"touchmove",this._handleFallbackAutoScroll):g(document,"mousemove",this._handleFallbackAutoScroll)},dragOverCompleted:function(t){var e=t.originalEvent;this.options.dragOverBubble||e.rootEl||this._handleAutoScroll(e)},drop:function(){this.sortable.nativeDraggable?v(document,"dragover",this._handleAutoScroll):(v(document,"pointermove",this._handleFallbackAutoScroll),v(document,"touchmove",this._handleFallbackAutoScroll),v(document,"mousemove",this._handleFallbackAutoScroll)),Qt(),Zt(),clearTimeout(x),x=void 0},nulling:function(){zt=Ut=Yt=Jt=Kt=Wt=Gt=null,qt.length=0},_handleFallbackAutoScroll:function(t){this._handleAutoScroll(t,!0)},_handleAutoScroll:function(t,e){var n=this,r=(t.touches?t.touches[0]:t).clientX,o=(t.touches?t.touches[0]:t).clientY,i=document.elementFromPoint(r,o);if(zt=t,e||c||l||d){ee(t,this.options,i,e);var a=P(i,!0);!Jt||Kt&&r===Wt&&o===Gt||(Kt&&Qt(),Kt=setInterval((function(){var i=P(document.elementFromPoint(r,o),!0);i!==a&&(a=i,Zt()),ee(t,n.options,i,e)}),10),Wt=r,Gt=o)}else{if(!this.options.bubbleScroll||P(i,!0)===A())return void Zt();ee(t,this.options,P(i,!1),!1)}}},i(t,{pluginName:"scroll",initializeByDefault:!0})}),Lt.mount(oe,re);const ye=Lt},432:function(t,e,n){var r;"undefined"!=typeof self&&self,r=function(t){return function(t){var e={};function n(r){if(e[r])return e[r].exports;var o=e[r]={i:r,l:!1,exports:{}};return t[r].call(o.exports,o,o.exports,n),o.l=!0,o.exports}return n.m=t,n.c=e,n.d=function(t,e,r){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:r})},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var o in t)n.d(r,o,function(e){return t[e]}.bind(null,o));return r},n.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(e,"a",e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="",n(n.s="fb15")}({"01f9":function(t,e,n){"use strict";var r=n("2d00"),o=n("5ca1"),i=n("2aba"),a=n("32e9"),s=n("84f2"),l=n("41a0"),c=n("7f20"),u=n("38fd"),d=n("2b4c")("iterator"),f=!([].keys&&"next"in[].keys()),p="keys",h="values",g=function(){return this};t.exports=function(t,e,n,v,m,b,y){l(n,e,v);var x,w,_,S=function(t){if(!f&&t in T)return T[t];switch(t){case p:case h:return function(){return new n(this,t)}}return function(){return new n(this,t)}},C=e+" Iterator",E=m==h,A=!1,T=t.prototype,D=T[d]||T["@@iterator"]||m&&T[m],O=D||S(m),N=m?E?S("entries"):O:void 0,k="Array"==e&&T.entries||D;if(k&&(_=u(k.call(new t)))!==Object.prototype&&_.next&&(c(_,C,!0),r||"function"==typeof _[d]||a(_,d,g)),E&&D&&D.name!==h&&(A=!0,O=function(){return D.call(this)}),r&&!y||!f&&!A&&T[d]||a(T,d,O),s[e]=O,s[C]=g,m)if(x={values:E?O:S(h),keys:b?O:S(p),entries:N},y)for(w in x)w in T||i(T,w,x[w]);else o(o.P+o.F*(f||A),e,x);return x}},"02f4":function(t,e,n){var r=n("4588"),o=n("be13");t.exports=function(t){return function(e,n){var i,a,s=String(o(e)),l=r(n),c=s.length;return l<0||l>=c?t?"":void 0:(i=s.charCodeAt(l))<55296||i>56319||l+1===c||(a=s.charCodeAt(l+1))<56320||a>57343?t?s.charAt(l):i:t?s.slice(l,l+2):a-56320+(i-55296<<10)+65536}}},"0390":function(t,e,n){"use strict";var r=n("02f4")(!0);t.exports=function(t,e,n){return e+(n?r(t,e).length:1)}},"0bfb":function(t,e,n){"use strict";var r=n("cb7c");t.exports=function(){var t=r(this),e="";return t.global&&(e+="g"),t.ignoreCase&&(e+="i"),t.multiline&&(e+="m"),t.unicode&&(e+="u"),t.sticky&&(e+="y"),e}},"0d58":function(t,e,n){var r=n("ce10"),o=n("e11e");t.exports=Object.keys||function(t){return r(t,o)}},1495:function(t,e,n){var r=n("86cc"),o=n("cb7c"),i=n("0d58");t.exports=n("9e1e")?Object.defineProperties:function(t,e){o(t);for(var n,a=i(e),s=a.length,l=0;s>l;)r.f(t,n=a[l++],e[n]);return t}},"214f":function(t,e,n){"use strict";n("b0c5");var r=n("2aba"),o=n("32e9"),i=n("79e5"),a=n("be13"),s=n("2b4c"),l=n("520a"),c=s("species"),u=!i((function(){var t=/./;return t.exec=function(){var t=[];return t.groups={a:"7"},t},"7"!=="".replace(t,"$<a>")})),d=function(){var t=/(?:)/,e=t.exec;t.exec=function(){return e.apply(this,arguments)};var n="ab".split(t);return 2===n.length&&"a"===n[0]&&"b"===n[1]}();t.exports=function(t,e,n){var f=s(t),p=!i((function(){var e={};return e[f]=function(){return 7},7!=""[t](e)})),h=p?!i((function(){var e=!1,n=/a/;return n.exec=function(){return e=!0,null},"split"===t&&(n.constructor={},n.constructor[c]=function(){return n}),n[f](""),!e})):void 0;if(!p||!h||"replace"===t&&!u||"split"===t&&!d){var g=/./[f],v=n(a,f,""[t],(function(t,e,n,r,o){return e.exec===l?p&&!o?{done:!0,value:g.call(e,n,r)}:{done:!0,value:t.call(n,e,r)}:{done:!1}})),m=v[0],b=v[1];r(String.prototype,t,m),o(RegExp.prototype,f,2==e?function(t,e){return b.call(t,this,e)}:function(t){return b.call(t,this)})}}},"230e":function(t,e,n){var r=n("d3f4"),o=n("7726").document,i=r(o)&&r(o.createElement);t.exports=function(t){return i?o.createElement(t):{}}},"23c6":function(t,e,n){var r=n("2d95"),o=n("2b4c")("toStringTag"),i="Arguments"==r(function(){return arguments}());t.exports=function(t){var e,n,a;return void 0===t?"Undefined":null===t?"Null":"string"==typeof(n=function(t,e){try{return t[e]}catch(t){}}(e=Object(t),o))?n:i?r(e):"Object"==(a=r(e))&&"function"==typeof e.callee?"Arguments":a}},2621:function(t,e){e.f=Object.getOwnPropertySymbols},"2aba":function(t,e,n){var r=n("7726"),o=n("32e9"),i=n("69a8"),a=n("ca5a")("src"),s=n("fa5b"),l="toString",c=(""+s).split(l);n("8378").inspectSource=function(t){return s.call(t)},(t.exports=function(t,e,n,s){var l="function"==typeof n;l&&(i(n,"name")||o(n,"name",e)),t[e]!==n&&(l&&(i(n,a)||o(n,a,t[e]?""+t[e]:c.join(String(e)))),t===r?t[e]=n:s?t[e]?t[e]=n:o(t,e,n):(delete t[e],o(t,e,n)))})(Function.prototype,l,(function(){return"function"==typeof this&&this[a]||s.call(this)}))},"2aeb":function(t,e,n){var r=n("cb7c"),o=n("1495"),i=n("e11e"),a=n("613b")("IE_PROTO"),s=function(){},l="prototype",c=function(){var t,e=n("230e")("iframe"),r=i.length;for(e.style.display="none",n("fab2").appendChild(e),e.src="javascript:",(t=e.contentWindow.document).open(),t.write("<script>document.F=Object<\/script>"),t.close(),c=t.F;r--;)delete c[l][i[r]];return c()};t.exports=Object.create||function(t,e){var n;return null!==t?(s[l]=r(t),n=new s,s[l]=null,n[a]=t):n=c(),void 0===e?n:o(n,e)}},"2b4c":function(t,e,n){var r=n("5537")("wks"),o=n("ca5a"),i=n("7726").Symbol,a="function"==typeof i;(t.exports=function(t){return r[t]||(r[t]=a&&i[t]||(a?i:o)("Symbol."+t))}).store=r},"2d00":function(t,e){t.exports=!1},"2d95":function(t,e){var n={}.toString;t.exports=function(t){return n.call(t).slice(8,-1)}},"2fdb":function(t,e,n){"use strict";var r=n("5ca1"),o=n("d2c8"),i="includes";r(r.P+r.F*n("5147")(i),"String",{includes:function(t){return!!~o(this,t,i).indexOf(t,arguments.length>1?arguments[1]:void 0)}})},"32e9":function(t,e,n){var r=n("86cc"),o=n("4630");t.exports=n("9e1e")?function(t,e,n){return r.f(t,e,o(1,n))}:function(t,e,n){return t[e]=n,t}},"38fd":function(t,e,n){var r=n("69a8"),o=n("4bf8"),i=n("613b")("IE_PROTO"),a=Object.prototype;t.exports=Object.getPrototypeOf||function(t){return t=o(t),r(t,i)?t[i]:"function"==typeof t.constructor&&t instanceof t.constructor?t.constructor.prototype:t instanceof Object?a:null}},"41a0":function(t,e,n){"use strict";var r=n("2aeb"),o=n("4630"),i=n("7f20"),a={};n("32e9")(a,n("2b4c")("iterator"),(function(){return this})),t.exports=function(t,e,n){t.prototype=r(a,{next:o(1,n)}),i(t,e+" Iterator")}},"456d":function(t,e,n){var r=n("4bf8"),o=n("0d58");n("5eda")("keys",(function(){return function(t){return o(r(t))}}))},4588:function(t,e){var n=Math.ceil,r=Math.floor;t.exports=function(t){return isNaN(t=+t)?0:(t>0?r:n)(t)}},4630:function(t,e){t.exports=function(t,e){return{enumerable:!(1&t),configurable:!(2&t),writable:!(4&t),value:e}}},"4bf8":function(t,e,n){var r=n("be13");t.exports=function(t){return Object(r(t))}},5147:function(t,e,n){var r=n("2b4c")("match");t.exports=function(t){var e=/./;try{"/./"[t](e)}catch(n){try{return e[r]=!1,!"/./"[t](e)}catch(t){}}return!0}},"520a":function(t,e,n){"use strict";var r,o,i=n("0bfb"),a=RegExp.prototype.exec,s=String.prototype.replace,l=a,c="lastIndex",u=(r=/a/,o=/b*/g,a.call(r,"a"),a.call(o,"a"),0!==r[c]||0!==o[c]),d=void 0!==/()??/.exec("")[1];(u||d)&&(l=function(t){var e,n,r,o,l=this;return d&&(n=new RegExp("^"+l.source+"$(?!\\s)",i.call(l))),u&&(e=l[c]),r=a.call(l,t),u&&r&&(l[c]=l.global?r.index+r[0].length:e),d&&r&&r.length>1&&s.call(r[0],n,(function(){for(o=1;o<arguments.length-2;o++)void 0===arguments[o]&&(r[o]=void 0)})),r}),t.exports=l},"52a7":function(t,e){e.f={}.propertyIsEnumerable},5537:function(t,e,n){var r=n("8378"),o=n("7726"),i="__core-js_shared__",a=o[i]||(o[i]={});(t.exports=function(t,e){return a[t]||(a[t]=void 0!==e?e:{})})("versions",[]).push({version:r.version,mode:n("2d00")?"pure":"global",copyright:"© 2019 Denis Pushkarev (zloirock.ru)"})},"5ca1":function(t,e,n){var r=n("7726"),o=n("8378"),i=n("32e9"),a=n("2aba"),s=n("9b43"),l="prototype",c=function(t,e,n){var u,d,f,p,h=t&c.F,g=t&c.G,v=t&c.S,m=t&c.P,b=t&c.B,y=g?r:v?r[e]||(r[e]={}):(r[e]||{})[l],x=g?o:o[e]||(o[e]={}),w=x[l]||(x[l]={});for(u in g&&(n=e),n)f=((d=!h&&y&&void 0!==y[u])?y:n)[u],p=b&&d?s(f,r):m&&"function"==typeof f?s(Function.call,f):f,y&&a(y,u,f,t&c.U),x[u]!=f&&i(x,u,p),m&&w[u]!=f&&(w[u]=f)};r.core=o,c.F=1,c.G=2,c.S=4,c.P=8,c.B=16,c.W=32,c.U=64,c.R=128,t.exports=c},"5eda":function(t,e,n){var r=n("5ca1"),o=n("8378"),i=n("79e5");t.exports=function(t,e){var n=(o.Object||{})[t]||Object[t],a={};a[t]=e(n),r(r.S+r.F*i((function(){n(1)})),"Object",a)}},"5f1b":function(t,e,n){"use strict";var r=n("23c6"),o=RegExp.prototype.exec;t.exports=function(t,e){var n=t.exec;if("function"==typeof n){var i=n.call(t,e);if("object"!=typeof i)throw new TypeError("RegExp exec method returned something other than an Object or null");return i}if("RegExp"!==r(t))throw new TypeError("RegExp#exec called on incompatible receiver");return o.call(t,e)}},"613b":function(t,e,n){var r=n("5537")("keys"),o=n("ca5a");t.exports=function(t){return r[t]||(r[t]=o(t))}},"626a":function(t,e,n){var r=n("2d95");t.exports=Object("z").propertyIsEnumerable(0)?Object:function(t){return"String"==r(t)?t.split(""):Object(t)}},6762:function(t,e,n){"use strict";var r=n("5ca1"),o=n("c366")(!0);r(r.P,"Array",{includes:function(t){return o(this,t,arguments.length>1?arguments[1]:void 0)}}),n("9c6c")("includes")},6821:function(t,e,n){var r=n("626a"),o=n("be13");t.exports=function(t){return r(o(t))}},"69a8":function(t,e){var n={}.hasOwnProperty;t.exports=function(t,e){return n.call(t,e)}},"6a99":function(t,e,n){var r=n("d3f4");t.exports=function(t,e){if(!r(t))return t;var n,o;if(e&&"function"==typeof(n=t.toString)&&!r(o=n.call(t)))return o;if("function"==typeof(n=t.valueOf)&&!r(o=n.call(t)))return o;if(!e&&"function"==typeof(n=t.toString)&&!r(o=n.call(t)))return o;throw TypeError("Can't convert object to primitive value")}},7333:function(t,e,n){"use strict";var r=n("0d58"),o=n("2621"),i=n("52a7"),a=n("4bf8"),s=n("626a"),l=Object.assign;t.exports=!l||n("79e5")((function(){var t={},e={},n=Symbol(),r="abcdefghijklmnopqrst";return t[n]=7,r.split("").forEach((function(t){e[t]=t})),7!=l({},t)[n]||Object.keys(l({},e)).join("")!=r}))?function(t,e){for(var n=a(t),l=arguments.length,c=1,u=o.f,d=i.f;l>c;)for(var f,p=s(arguments[c++]),h=u?r(p).concat(u(p)):r(p),g=h.length,v=0;g>v;)d.call(p,f=h[v++])&&(n[f]=p[f]);return n}:l},7726:function(t,e){var n=t.exports="undefined"!=typeof window&&window.Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=n)},"77f1":function(t,e,n){var r=n("4588"),o=Math.max,i=Math.min;t.exports=function(t,e){return(t=r(t))<0?o(t+e,0):i(t,e)}},"79e5":function(t,e){t.exports=function(t){try{return!!t()}catch(t){return!0}}},"7f20":function(t,e,n){var r=n("86cc").f,o=n("69a8"),i=n("2b4c")("toStringTag");t.exports=function(t,e,n){t&&!o(t=n?t:t.prototype,i)&&r(t,i,{configurable:!0,value:e})}},8378:function(t,e){var n=t.exports={version:"2.6.5"};"number"==typeof __e&&(__e=n)},"84f2":function(t,e){t.exports={}},"86cc":function(t,e,n){var r=n("cb7c"),o=n("c69a"),i=n("6a99"),a=Object.defineProperty;e.f=n("9e1e")?Object.defineProperty:function(t,e,n){if(r(t),e=i(e,!0),r(n),o)try{return a(t,e,n)}catch(t){}if("get"in n||"set"in n)throw TypeError("Accessors not supported!");return"value"in n&&(t[e]=n.value),t}},"9b43":function(t,e,n){var r=n("d8e8");t.exports=function(t,e,n){if(r(t),void 0===e)return t;switch(n){case 1:return function(n){return t.call(e,n)};case 2:return function(n,r){return t.call(e,n,r)};case 3:return function(n,r,o){return t.call(e,n,r,o)}}return function(){return t.apply(e,arguments)}}},"9c6c":function(t,e,n){var r=n("2b4c")("unscopables"),o=Array.prototype;null==o[r]&&n("32e9")(o,r,{}),t.exports=function(t){o[r][t]=!0}},"9def":function(t,e,n){var r=n("4588"),o=Math.min;t.exports=function(t){return t>0?o(r(t),9007199254740991):0}},"9e1e":function(t,e,n){t.exports=!n("79e5")((function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a}))},a352:function(e,n){e.exports=t},a481:function(t,e,n){"use strict";var r=n("cb7c"),o=n("4bf8"),i=n("9def"),a=n("4588"),s=n("0390"),l=n("5f1b"),c=Math.max,u=Math.min,d=Math.floor,f=/\$([$&`']|\d\d?|<[^>]*>)/g,p=/\$([$&`']|\d\d?)/g;n("214f")("replace",2,(function(t,e,n,h){return[function(r,o){var i=t(this),a=null==r?void 0:r[e];return void 0!==a?a.call(r,i,o):n.call(String(i),r,o)},function(t,e){var o=h(n,t,this,e);if(o.done)return o.value;var d=r(t),f=String(this),p="function"==typeof e;p||(e=String(e));var v=d.global;if(v){var m=d.unicode;d.lastIndex=0}for(var b=[];;){var y=l(d,f);if(null===y)break;if(b.push(y),!v)break;""===String(y[0])&&(d.lastIndex=s(f,i(d.lastIndex),m))}for(var x,w="",_=0,S=0;S<b.length;S++){y=b[S];for(var C=String(y[0]),E=c(u(a(y.index),f.length),0),A=[],T=1;T<y.length;T++)A.push(void 0===(x=y[T])?x:String(x));var D=y.groups;if(p){var O=[C].concat(A,E,f);void 0!==D&&O.push(D);var N=String(e.apply(void 0,O))}else N=g(C,f,E,A,D,e);E>=_&&(w+=f.slice(_,E)+N,_=E+C.length)}return w+f.slice(_)}];function g(t,e,r,i,a,s){var l=r+t.length,c=i.length,u=p;return void 0!==a&&(a=o(a),u=f),n.call(s,u,(function(n,o){var s;switch(o.charAt(0)){case"$":return"$";case"&":return t;case"`":return e.slice(0,r);case"'":return e.slice(l);case"<":s=a[o.slice(1,-1)];break;default:var u=+o;if(0===u)return n;if(u>c){var f=d(u/10);return 0===f?n:f<=c?void 0===i[f-1]?o.charAt(1):i[f-1]+o.charAt(1):n}s=i[u-1]}return void 0===s?"":s}))}}))},aae3:function(t,e,n){var r=n("d3f4"),o=n("2d95"),i=n("2b4c")("match");t.exports=function(t){var e;return r(t)&&(void 0!==(e=t[i])?!!e:"RegExp"==o(t))}},ac6a:function(t,e,n){for(var r=n("cadf"),o=n("0d58"),i=n("2aba"),a=n("7726"),s=n("32e9"),l=n("84f2"),c=n("2b4c"),u=c("iterator"),d=c("toStringTag"),f=l.Array,p={CSSRuleList:!0,CSSStyleDeclaration:!1,CSSValueList:!1,ClientRectList:!1,DOMRectList:!1,DOMStringList:!1,DOMTokenList:!0,DataTransferItemList:!1,FileList:!1,HTMLAllCollection:!1,HTMLCollection:!1,HTMLFormElement:!1,HTMLSelectElement:!1,MediaList:!0,MimeTypeArray:!1,NamedNodeMap:!1,NodeList:!0,PaintRequestList:!1,Plugin:!1,PluginArray:!1,SVGLengthList:!1,SVGNumberList:!1,SVGPathSegList:!1,SVGPointList:!1,SVGStringList:!1,SVGTransformList:!1,SourceBufferList:!1,StyleSheetList:!0,TextTrackCueList:!1,TextTrackList:!1,TouchList:!1},h=o(p),g=0;g<h.length;g++){var v,m=h[g],b=p[m],y=a[m],x=y&&y.prototype;if(x&&(x[u]||s(x,u,f),x[d]||s(x,d,m),l[m]=f,b))for(v in r)x[v]||i(x,v,r[v],!0)}},b0c5:function(t,e,n){"use strict";var r=n("520a");n("5ca1")({target:"RegExp",proto:!0,forced:r!==/./.exec},{exec:r})},be13:function(t,e){t.exports=function(t){if(null==t)throw TypeError("Can't call method on  "+t);return t}},c366:function(t,e,n){var r=n("6821"),o=n("9def"),i=n("77f1");t.exports=function(t){return function(e,n,a){var s,l=r(e),c=o(l.length),u=i(a,c);if(t&&n!=n){for(;c>u;)if((s=l[u++])!=s)return!0}else for(;c>u;u++)if((t||u in l)&&l[u]===n)return t||u||0;return!t&&-1}}},c649:function(t,e,n){"use strict";(function(t){n.d(e,"c",(function(){return c})),n.d(e,"a",(function(){return s})),n.d(e,"b",(function(){return i})),n.d(e,"d",(function(){return l})),n("a481");var r,o,i="undefined"!=typeof window?window.console:t.console,a=/-(\w)/g,s=(r=function(t){return t.replace(a,(function(t,e){return e?e.toUpperCase():""}))},o=Object.create(null),function(t){return o[t]||(o[t]=r(t))});function l(t){null!==t.parentElement&&t.parentElement.removeChild(t)}function c(t,e,n){var r=0===n?t.children[0]:t.children[n-1].nextSibling;t.insertBefore(e,r)}}).call(this,n("c8ba"))},c69a:function(t,e,n){t.exports=!n("9e1e")&&!n("79e5")((function(){return 7!=Object.defineProperty(n("230e")("div"),"a",{get:function(){return 7}}).a}))},c8ba:function(t,e){var n;n=function(){return this}();try{n=n||new Function("return this")()}catch(t){"object"==typeof window&&(n=window)}t.exports=n},ca5a:function(t,e){var n=0,r=Math.random();t.exports=function(t){return"Symbol(".concat(void 0===t?"":t,")_",(++n+r).toString(36))}},cadf:function(t,e,n){"use strict";var r=n("9c6c"),o=n("d53b"),i=n("84f2"),a=n("6821");t.exports=n("01f9")(Array,"Array",(function(t,e){this._t=a(t),this._i=0,this._k=e}),(function(){var t=this._t,e=this._k,n=this._i++;return!t||n>=t.length?(this._t=void 0,o(1)):o(0,"keys"==e?n:"values"==e?t[n]:[n,t[n]])}),"values"),i.Arguments=i.Array,r("keys"),r("values"),r("entries")},cb7c:function(t,e,n){var r=n("d3f4");t.exports=function(t){if(!r(t))throw TypeError(t+" is not an object!");return t}},ce10:function(t,e,n){var r=n("69a8"),o=n("6821"),i=n("c366")(!1),a=n("613b")("IE_PROTO");t.exports=function(t,e){var n,s=o(t),l=0,c=[];for(n in s)n!=a&&r(s,n)&&c.push(n);for(;e.length>l;)r(s,n=e[l++])&&(~i(c,n)||c.push(n));return c}},d2c8:function(t,e,n){var r=n("aae3"),o=n("be13");t.exports=function(t,e,n){if(r(e))throw TypeError("String#"+n+" doesn't accept regex!");return String(o(t))}},d3f4:function(t,e){t.exports=function(t){return"object"==typeof t?null!==t:"function"==typeof t}},d53b:function(t,e){t.exports=function(t,e){return{value:e,done:!!t}}},d8e8:function(t,e){t.exports=function(t){if("function"!=typeof t)throw TypeError(t+" is not a function!");return t}},e11e:function(t,e){t.exports="constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf".split(",")},f559:function(t,e,n){"use strict";var r=n("5ca1"),o=n("9def"),i=n("d2c8"),a="startsWith",s=""[a];r(r.P+r.F*n("5147")(a),"String",{startsWith:function(t){var e=i(this,t,a),n=o(Math.min(arguments.length>1?arguments[1]:void 0,e.length)),r=String(t);return s?s.call(e,r,n):e.slice(n,n+r.length)===r}})},f6fd:function(t,e){!function(t){var e="currentScript",n=t.getElementsByTagName("script");e in t||Object.defineProperty(t,e,{get:function(){try{throw new Error}catch(r){var t,e=(/.*at [^\(]*\((.*):.+:.+\)$/gi.exec(r.stack)||[!1])[1];for(t in n)if(n[t].src==e||"interactive"==n[t].readyState)return n[t];return null}}})}(document)},f751:function(t,e,n){var r=n("5ca1");r(r.S+r.F,"Object",{assign:n("7333")})},fa5b:function(t,e,n){t.exports=n("5537")("native-function-to-string",Function.toString)},fab2:function(t,e,n){var r=n("7726").document;t.exports=r&&r.documentElement},fb15:function(t,e,n){"use strict";var r;function o(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,r=new Array(e);n<e;n++)r[n]=t[n];return r}function i(t,e){if(t){if("string"==typeof t)return o(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);return"Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(t):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?o(t,e):void 0}}function a(t){return function(t){if(Array.isArray(t))return o(t)}(t)||function(t){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(t))return Array.from(t)}(t)||i(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}n.r(e),"undefined"!=typeof window&&(n("f6fd"),(r=window.document.currentScript)&&(r=r.src.match(/(.+\/)[^/]+\.js(\?.*)?$/))&&(n.p=r[1])),n("f751"),n("f559"),n("ac6a"),n("cadf"),n("456d"),n("6762"),n("2fdb");var s=n("a352"),l=n.n(s),c=n("c649");function u(t,e){var n=this;this.$nextTick((function(){return n.$emit(t.toLowerCase(),e)}))}function d(t){var e=this;return function(n){null!==e.realList&&e["onDrag"+t](n),u.call(e,t,n)}}function f(t){return["transition-group","TransitionGroup"].includes(t)}function p(t,e,n){return t[n]||(e[n]?e[n]():void 0)}var h=["Start","Add","Remove","Update","End"],g=["Choose","Unchoose","Sort","Filter","Clone"],v=["Move"].concat(h,g).map((function(t){return"on"+t})),m=null,b={name:"draggable",inheritAttrs:!1,props:{options:Object,list:{type:Array,required:!1,default:null},value:{type:Array,required:!1,default:null},noTransitionOnDrag:{type:Boolean,default:!1},clone:{type:Function,default:function(t){return t}},element:{type:String,default:"div"},tag:{type:String,default:null},move:{type:Function,default:null},componentData:{type:Object,required:!1,default:null}},data:function(){return{transitionMode:!1,noneFunctionalComponentMode:!1}},render:function(t){var e=this.$slots.default;this.transitionMode=function(t){if(!t||1!==t.length)return!1;var e,n,r=(e=t,n=1,function(t){if(Array.isArray(t))return t}(e)||function(t,e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(t)){var n=[],r=!0,o=!1,i=void 0;try{for(var a,s=t[Symbol.iterator]();!(r=(a=s.next()).done)&&(n.push(a.value),!e||n.length!==e);r=!0);}catch(t){o=!0,i=t}finally{try{r||null==s.return||s.return()}finally{if(o)throw i}}return n}}(e,n)||i(e,n)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}())[0].componentOptions;return!!r&&f(r.tag)}(e);var n=function(t,e,n){var r=0,o=0,i=p(e,n,"header");i&&(r=i.length,t=t?[].concat(a(i),a(t)):a(i));var s=p(e,n,"footer");return s&&(o=s.length,t=t?[].concat(a(t),a(s)):a(s)),{children:t,headerOffset:r,footerOffset:o}}(e,this.$slots,this.$scopedSlots),r=n.children,o=n.headerOffset,s=n.footerOffset;this.headerOffset=o,this.footerOffset=s;var l=function(t,e){var n=null,r=function(t,e){n=function(t,e,n){return void 0===n||((t=t||{})[e]=n),t}(n,t,e)};if(r("attrs",Object.keys(t).filter((function(t){return"id"===t||t.startsWith("data-")})).reduce((function(e,n){return e[n]=t[n],e}),{})),!e)return n;var o=e.on,i=e.props,a=e.attrs;return r("on",o),r("props",i),Object.assign(n.attrs,a),n}(this.$attrs,this.componentData);return t(this.getTag(),l,r)},created:function(){null!==this.list&&null!==this.value&&c.b.error("Value and list props are mutually exclusive! Please set one or another."),"div"!==this.element&&c.b.warn("Element props is deprecated please use tag props instead. See https://github.com/SortableJS/Vue.Draggable/blob/master/documentation/migrate.md#element-props"),void 0!==this.options&&c.b.warn("Options props is deprecated, add sortable options directly as vue.draggable item, or use v-bind. See https://github.com/SortableJS/Vue.Draggable/blob/master/documentation/migrate.md#options-props")},mounted:function(){var t=this;if(this.noneFunctionalComponentMode=this.getTag().toLowerCase()!==this.$el.nodeName.toLowerCase()&&!this.getIsFunctional(),this.noneFunctionalComponentMode&&this.transitionMode)throw new Error("Transition-group inside component is not supported. Please alter tag value or remove transition-group. Current tag value: ".concat(this.getTag()));var e={};h.forEach((function(n){e["on"+n]=d.call(t,n)})),g.forEach((function(n){e["on"+n]=u.bind(t,n)}));var n=Object.keys(this.$attrs).reduce((function(e,n){return e[Object(c.a)(n)]=t.$attrs[n],e}),{}),r=Object.assign({},this.options,n,e,{onMove:function(e,n){return t.onDragMove(e,n)}});!("draggable"in r)&&(r.draggable=">*"),this._sortable=new l.a(this.rootContainer,r),this.computeIndexes()},beforeDestroy:function(){void 0!==this._sortable&&this._sortable.destroy()},computed:{rootContainer:function(){return this.transitionMode?this.$el.children[0]:this.$el},realList:function(){return this.list?this.list:this.value}},watch:{options:{handler:function(t){this.updateOptions(t)},deep:!0},$attrs:{handler:function(t){this.updateOptions(t)},deep:!0},realList:function(){this.computeIndexes()}},methods:{getIsFunctional:function(){var t=this._vnode.fnOptions;return t&&t.functional},getTag:function(){return this.tag||this.element},updateOptions:function(t){for(var e in t){var n=Object(c.a)(e);-1===v.indexOf(n)&&this._sortable.option(n,t[e])}},getChildrenNodes:function(){if(this.noneFunctionalComponentMode)return this.$children[0].$slots.default;var t=this.$slots.default;return this.transitionMode?t[0].child.$slots.default:t},computeIndexes:function(){var t=this;this.$nextTick((function(){t.visibleIndexes=function(t,e,n,r){if(!t)return[];var o=t.map((function(t){return t.elm})),i=e.length-r,s=a(e).map((function(t,e){return e>=i?o.length:o.indexOf(t)}));return n?s.filter((function(t){return-1!==t})):s}(t.getChildrenNodes(),t.rootContainer.children,t.transitionMode,t.footerOffset)}))},getUnderlyingVm:function(t){var e,n,r=(e=this.getChildrenNodes()||[],n=t,e.map((function(t){return t.elm})).indexOf(n));return-1===r?null:{index:r,element:this.realList[r]}},getUnderlyingPotencialDraggableComponent:function(t){var e=t.__vue__;return e&&e.$options&&f(e.$options._componentTag)?e.$parent:!("realList"in e)&&1===e.$children.length&&"realList"in e.$children[0]?e.$children[0]:e},emitChanges:function(t){var e=this;this.$nextTick((function(){e.$emit("change",t)}))},alterList:function(t){if(this.list)t(this.list);else{var e=a(this.value);t(e),this.$emit("input",e)}},spliceList:function(){var t=arguments;this.alterList((function(e){return e.splice.apply(e,a(t))}))},updatePosition:function(t,e){this.alterList((function(n){return n.splice(e,0,n.splice(t,1)[0])}))},getRelatedContextFromMoveEvent:function(t){var e=t.to,n=t.related,r=this.getUnderlyingPotencialDraggableComponent(e);if(!r)return{component:r};var o=r.realList,i={list:o,component:r};if(e!==n&&o&&r.getUnderlyingVm){var a=r.getUnderlyingVm(n);if(a)return Object.assign(a,i)}return i},getVmIndex:function(t){var e=this.visibleIndexes,n=e.length;return t>n-1?n:e[t]},getComponent:function(){return this.$slots.default[0].componentInstance},resetTransitionData:function(t){if(this.noTransitionOnDrag&&this.transitionMode){this.getChildrenNodes()[t].data=null;var e=this.getComponent();e.children=[],e.kept=void 0}},onDragStart:function(t){this.context=this.getUnderlyingVm(t.item),t.item._underlying_vm_=this.clone(this.context.element),m=t.item},onDragAdd:function(t){var e=t.item._underlying_vm_;if(void 0!==e){Object(c.d)(t.item);var n=this.getVmIndex(t.newIndex);this.spliceList(n,0,e),this.computeIndexes();var r={element:e,newIndex:n};this.emitChanges({added:r})}},onDragRemove:function(t){if(Object(c.c)(this.rootContainer,t.item,t.oldIndex),"clone"!==t.pullMode){var e=this.context.index;this.spliceList(e,1);var n={element:this.context.element,oldIndex:e};this.resetTransitionData(e),this.emitChanges({removed:n})}else Object(c.d)(t.clone)},onDragUpdate:function(t){Object(c.d)(t.item),Object(c.c)(t.from,t.item,t.oldIndex);var e=this.context.index,n=this.getVmIndex(t.newIndex);this.updatePosition(e,n);var r={element:this.context.element,oldIndex:e,newIndex:n};this.emitChanges({moved:r})},updateProperty:function(t,e){t.hasOwnProperty(e)&&(t[e]+=this.headerOffset)},computeFutureIndex:function(t,e){if(!t.element)return 0;var n=a(e.to.children).filter((function(t){return"none"!==t.style.display})),r=n.indexOf(e.related),o=t.component.getVmIndex(r);return-1===n.indexOf(m)&&e.willInsertAfter?o+1:o},onDragMove:function(t,e){var n=this.move;if(!n||!this.realList)return!0;var r=this.getRelatedContextFromMoveEvent(t),o=this.context,i=this.computeFutureIndex(r,t);return Object.assign(o,{futureIndex:i}),n(Object.assign({},t,{relatedContext:r,draggedContext:o}),e)},onDragEnd:function(){this.computeIndexes(),m=null}}};"undefined"!=typeof window&&"Vue"in window&&window.Vue.component("draggable",b);var y=b;e.default=y}}).default},t.exports=r(n(10246))}},r={};function o(t){var e=r[t];if(void 0!==e)return e.exports;var i=r[t]={id:t,loaded:!1,exports:{}};return n[t].call(i.exports,i,i.exports,o),i.loaded=!0,i.exports}o.m=n,e=[],o.O=(t,n,r,i)=>{if(!n){var a=1/0;for(u=0;u<e.length;u++){n=e[u][0],r=e[u][1],i=e[u][2];for(var s=!0,l=0;l<n.length;l++)(!1&i||a>=i)&&Object.keys(o.O).every((t=>o.O[t](n[l])))?n.splice(l--,1):(s=!1,i<a&&(a=i));if(s){e.splice(u--,1);var c=r();void 0!==c&&(t=c)}}return t}i=i||0;for(var u=e.length;u>0&&e[u-1][2]>i;u--)e[u]=e[u-1];e[u]=[n,r,i]},o.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return o.d(e,{a:e}),e},o.d=(t,e)=>{for(var n in e)o.o(e,n)&&!o.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:e[n]})},o.e=()=>Promise.resolve(),o.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(t){if("object"==typeof window)return window}}(),o.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),o.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},o.nmd=t=>(t.paths=[],t.children||(t.children=[]),t),o.j=3012,(()=>{o.b=document.baseURI||self.location.href;var t={3012:0};o.O.j=e=>0===t[e];var e=(e,n)=>{var r,i,a=n[0],s=n[1],l=n[2],c=0;if(a.some((e=>0!==t[e]))){for(r in s)o.o(s,r)&&(o.m[r]=s[r]);if(l)var u=l(o)}for(e&&e(n);c<a.length;c++)i=a[c],o.o(t,i)&&t[i]&&t[i][0](),t[i]=0;return o.O(u)},n=self.webpackChunknextcloud=self.webpackChunknextcloud||[];n.forEach(e.bind(null,0)),n.push=e.bind(null,n.push.bind(n))})(),o.nc=void 0;var i=o.O(void 0,[4208],(()=>o(36792)));i=o.O(i)})();
//# sourceMappingURL=settings-vue-settings-admin-ai.js.map?v=c7d37c324537712ca9f7