/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class LabelRenderer
extends JLabel {
    private static final LabelRendererUI UI = new LabelRendererUI();
    private static final int DIRTY = Integer.MIN_VALUE;
    private int x;
    private int y;
    private Insets insets = new Insets(0, 0, 0, 0);
    private Dimension preferredSize;
    private FontMetrics fontMetrics;
    private String text;
    private Icon icon;
    private Color foreground;
    private boolean enabled;
    private int iconWidth;
    private int iconHeight;
    private int iconTextGap;
    private int textWidth;
    private int fontAscent;

    public LabelRenderer() {
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(1);
        this.setSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.setOpaque(false);
        this.setEnabled(true);
        this.iconTextGap = super.getIconTextGap();
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public Insets getInsets(Insets insets) {
        return this.insets;
    }

    @Override
    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        if (this.preferredSize.width == Integer.MIN_VALUE) {
            this.textWidth = this.text == null || this.text.isEmpty() ? 0 : this.fontMetrics.stringWidth(this.text);
            this.preferredSize.width = this.iconWidth + this.textWidth;
            if (this.iconWidth > 0 && this.textWidth > 0) {
                this.preferredSize.width += this.iconTextGap;
            }
        }
        if (this.preferredSize.height == Integer.MIN_VALUE) {
            this.fontAscent = this.fontMetrics.getAscent();
            this.preferredSize.height = this.fontAscent + this.fontMetrics.getDescent();
        }
        return this.preferredSize;
    }

    @Override
    public void setUI(LabelUI ui) {
        super.setUI(UI);
    }

    private void resetPreferredSize(boolean width, boolean height) {
        if (this.preferredSize == null) {
            return;
        }
        if (width) {
            this.preferredSize.width = Integer.MIN_VALUE;
        }
        if (height) {
            this.preferredSize.height = Integer.MIN_VALUE;
        }
    }

    protected void prePaint(Graphics g, int x, int y) {
    }

    protected void postPaint(Graphics g, int x, int y) {
    }

    @Override
    public void paint(Graphics g) {
        Graphics cg = this.getComponentGraphics(g);
        this.prePaint(cg, this.x, this.y);
        int xx = this.x;
        if (this.iconWidth > 0) {
            int yy = (this.preferredSize.height - this.iconHeight) / 2;
            this.icon.paintIcon(this, cg, xx, this.y + yy);
            xx += this.iconWidth + this.iconTextGap;
        }
        if (this.textWidth > 0) {
            UI.paintEnabledText(this, cg, this.text, xx, this.y + this.fontAscent);
        }
        this.postPaint(cg, this.x, this.y);
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.resetPreferredSize(true, false);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setIcon(Icon icon) {
        int oldIconWidth = this.iconWidth;
        this.iconWidth = icon == null ? 0 : icon.getIconWidth();
        this.iconHeight = icon == null ? 0 : icon.getIconHeight();
        this.icon = icon;
        if (oldIconWidth != this.iconWidth) {
            this.resetPreferredSize(true, false);
        }
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.fontMetrics;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = super.getFontMetrics(font);
        this.resetPreferredSize(true, true);
    }

    @Override
    public int getIconTextGap() {
        return this.iconTextGap;
    }

    @Override
    public void setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
        this.resetPreferredSize(true, false);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void setDisplayedMnemonic(int key) {
    }

    @Override
    public void setDisplayedMnemonic(char aChar) {
    }

    @Override
    public void setDisplayedMnemonicIndex(int index) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    private static class LabelRendererUI
    extends BasicLabelUI {
        private LabelRendererUI() {
        }

        @Override
        protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
            super.paintEnabledText(l, g, s, textX, textY);
        }
    }
}

