/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.cpu;

import org.graalvm.visualvm.lib.jfluid.global.CommonConstants;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsSnapshot;
import org.graalvm.visualvm.lib.ui.cpu.CPUResUserActionsHandler;
import org.graalvm.visualvm.lib.ui.cpu.CPUResultsPanel;
import org.graalvm.visualvm.lib.ui.cpu.ScreenshotProvider;

public abstract class SnapshotCPUResultsPanel
extends CPUResultsPanel
implements CommonConstants,
ScreenshotProvider {
    protected CPUResultsSnapshot snapshot;

    public SnapshotCPUResultsPanel(CPUResUserActionsHandler actionsHandler, Boolean sampling) {
        super(actionsHandler, sampling);
    }

    public void setDataToDisplay(CPUResultsSnapshot snapshot, int view) {
        this.snapshot = snapshot;
        this.currentView = view;
    }

    public CPUResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    protected boolean isCloseable() {
        return false;
    }

    @Override
    protected String[] getMethodClassNameAndSig(int methodId, int currentView) {
        return this.snapshot.getMethodClassNameAndSig(methodId, currentView);
    }

    @Override
    protected void showReverseCallGraph(int threadId, int methodId, int currentView, int sortingColumn, boolean sortingOrder) {
        this.actionsHandler.showReverseCallGraph(this.snapshot, threadId, methodId, currentView, sortingColumn, sortingOrder);
    }

    @Override
    protected void showSubtreeCallGraph(CCTNode node, int currentView, int sortingColumn, boolean sortingOrder) {
        this.actionsHandler.showSubtreeCallGraph(this.snapshot, node, currentView, sortingColumn, sortingOrder);
    }

    @Override
    protected boolean supportsReverseCallGraph() {
        return true;
    }

    @Override
    protected boolean supportsSubtreeCallGraph() {
        return true;
    }
}

