import { PortInfo } from '@serialport/bindings-cpp';
import { Adapter, DiscoverableUSBAdapter } from './tstype';
export declare function matchUSBAdapter(adapter: Adapter, path: string): Promise<boolean>;
export declare function findUSBAdapter(adapter?: Adapter, path?: string): Promise<[adapter: DiscoverableUSBAdapter, path: PortInfo['path']] | undefined>;
export declare function findmDNSAdapter(path: string): Promise<[adapter: Adapter, path: string]>;
export declare function findTCPAdapter(path: string, adapter?: Adapter): Promise<[adapter: Adapter, path: string]>;
/**
 * Discover adapter using mDNS, TCP or USB.
 *
 * @param adapter The adapter type.
 *   - mDNS: Unused.
 *   - TCP: Required, cannot discover at this time.
 *   - USB: Optional, limits the discovery to the specified adapter type.
 * @param path The path to the adapter.
 *   - mDNS: Required, serves to initiate the discovery.
 *   - TCP: Required, cannot discover at this time.
 *   - USB: Optional, limits the discovery to the specified path.
 * @returns adapter An adapter type supported by Z2M. While result is TS-typed, this should be validated against actual values before use.
 * @returns path Path to adapter.
 */
export declare function discoverAdapter(adapter?: Adapter, path?: string): Promise<[adapter: Adapter, path: string]>;
//# sourceMappingURL=adapterDiscovery.d.ts.map