/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao;

import ca.sqlpower.dao.SPTransactionElement;

public class PersistedSPObject
implements SPTransactionElement,
Comparable<PersistedSPObject> {
    private final String parentUUID;
    private final String type;
    private final String uuid;
    private final int index;
    private boolean loaded = false;

    public PersistedSPObject(String parentUUID, String type, String uuid, int index) {
        this.parentUUID = parentUUID;
        this.type = type;
        this.uuid = uuid;
        this.index = index;
    }

    public String getParentUUID() {
        return this.parentUUID;
    }

    public String getType() {
        return this.type;
    }

    public String getSimpleType() {
        String[] s = this.type.split("\\.");
        return s[s.length - 1];
    }

    public String getUUID() {
        return this.uuid;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return "PersistedSPObject: uuid " + this.uuid + ", parent uuid " + this.parentUUID + ", type " + this.type + ", index " + this.index + ", loaded " + this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PersistedSPObject pwo = (PersistedSPObject)obj;
        if (this.getParentUUID() == null && pwo.getParentUUID() != null || this.getParentUUID() != null && !this.getParentUUID().equals(pwo.getParentUUID())) {
            return false;
        }
        return this.getType().equals(pwo.getType()) && this.getUUID().equals(pwo.getUUID()) && this.getIndex() == pwo.getIndex() && this.isLoaded() == pwo.isLoaded();
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + (this.parentUUID == null ? 0 : this.parentUUID.hashCode());
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.uuid.hashCode();
        result = 31 * result + this.index;
        result = 31 * result + (this.loaded ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(PersistedSPObject o) {
        return (this.getUUID() + this.getParentUUID()).compareTo(o.getUUID() + o.getParentUUID());
    }
}

