/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.enterprise.client;

import ca.sqlpower.enterprise.client.Grant;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;

public class User
extends AbstractSPObject
implements UserDetails {
    public static List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(Grant.class);
    private final List<Grant> grants;
    private String password;
    private GrantedAuthority[] authorities = null;
    private String fullName = null;
    private String email = null;

    @Constructor
    public User(@ConstructorParameter(propertyName="name") String username, @ConstructorParameter(propertyName="password") String password) {
        assert (username != null);
        this.grants = new ArrayList<Grant>();
        this.password = password;
        super.setName(username);
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof Grant) {
            return this.removeGrant((Grant)child);
        }
        return false;
    }

    @NonProperty
    public List<Grant> getChildren() {
        return this.grants;
    }

    @Override
    @NonProperty
    public <T extends SPObject> List<T> getChildren(Class<T> type) {
        if (type.equals(Grant.class)) {
            return this.grants;
        }
        return Collections.emptyList();
    }

    @NonProperty
    public List<SPObject> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void removeDependency(SPObject dependency) {
    }

    @Accessor
    public String getPassword() {
        return this.password;
    }

    @Mutator
    public void setPassword(String password) {
        String oldPassword = this.password;
        this.password = password;
        this.firePropertyChange("password", oldPassword, password);
    }

    public void addGrant(Grant grant) {
        this.addGrant(grant, this.grants.size());
    }

    public void addGrant(Grant grant, int index) {
        this.childPositionOffset(grant.getClass());
        this.grants.add(index, grant);
        grant.setParent(this);
        this.fireChildAdded(Grant.class, grant, index);
    }

    public boolean removeGrant(Grant grant) {
        boolean wasRemoved = false;
        if (this.grants.contains(grant)) {
            int index = this.grants.indexOf(grant);
            wasRemoved = this.grants.remove(grant);
            this.fireChildRemoved(Grant.class, grant, index);
        }
        return wasRemoved;
    }

    @Override
    protected void addChildImpl(SPObject child, int index) {
        this.addGrant((Grant)child, index);
    }

    @Accessor
    public String getFullName() {
        return this.fullName;
    }

    @Mutator
    public void setFullName(String fullName) {
        String oldName = this.fullName;
        this.fullName = fullName;
        this.firePropertyChange("fullName", oldName, this.fullName);
    }

    @Accessor
    public String getEmail() {
        return this.email;
    }

    @Mutator
    public void setEmail(String email) {
        String oldEmail = this.email;
        this.email = email;
        this.firePropertyChange("email", oldEmail, this.email);
    }

    @Transient
    @Accessor
    public List<Grant> getGrants() {
        return this.grants;
    }

    @Transient
    @Accessor
    public GrantedAuthority[] getAuthorities() {
        if (this.authorities == null) {
            throw new RuntimeException("Programmatic error. The user manager has to fill in this user's groups before passing back to the security framework.");
        }
        return this.authorities;
    }

    @Transient
    @Mutator
    public void setAuthorities(GrantedAuthority[] authorities) {
        this.authorities = authorities;
    }

    @Transient
    @Accessor
    public String getUsername() {
        return super.getName();
    }

    @Transient
    @Accessor
    public boolean isAccountNonExpired() {
        return true;
    }

    @Transient
    @Accessor
    public boolean isAccountNonLocked() {
        return true;
    }

    @Transient
    @Accessor
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Transient
    @Accessor
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    @NonProperty
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        ArrayList<Class<? extends SPObject>> childTypes = new ArrayList<Class<? extends SPObject>>();
        childTypes.add(Grant.class);
        return childTypes;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        throw new NotSerializableException();
    }

    private void writeObject(ObjectOutputStream ois) throws IOException {
        throw new NotSerializableException();
    }
}

