/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.querypen;

import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.query.Container;
import ca.sqlpower.query.ContainerChildEvent;
import ca.sqlpower.query.ContainerChildListener;
import ca.sqlpower.query.Item;
import ca.sqlpower.query.StringItem;
import ca.sqlpower.swingui.querypen.CleanupPNode;
import ca.sqlpower.swingui.querypen.ConstantPNode;
import ca.sqlpower.swingui.querypen.EditStyledTextListener;
import ca.sqlpower.swingui.querypen.EditablePStyledText;
import ca.sqlpower.swingui.querypen.QueryPen;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolox.event.PNotification;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import edu.umd.cs.piccolox.nodes.PClip;
import edu.umd.cs.piccolox.nodes.PStyledText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ConstantsPane
extends PNode
implements CleanupPNode {
    private static final Logger logger = Logger.getLogger(ConstantsPane.class);
    private static final String TITLE_STRING = "CONSTANTS";
    private static final int BORDER_SIZE = 5;
    private static final int STROKE_SIZE = 2;
    private static final String ADDING_ITEM_STRING = "Add...";
    private final PCanvas canvas;
    private final QueryPen queryPen;
    private final Container model;
    private final List<PropertyChangeListener> changeListeners;
    private PPath outerRect;
    private PStyledText aliasHeader;
    private PStyledText whereHeader;
    private PStyledText columnHeader;
    private EditablePStyledText addingNewItemPNode;
    private final List<ConstantPNode> constantPNodeList;
    private final PropertyChangeListener itemChangedListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("position")) {
                ConstantsPane.this.translate(ConstantsPane.this.model.getPosition().getX() - ConstantsPane.this.getGlobalBounds().getX(), ConstantsPane.this.model.getPosition().getY() - ConstantsPane.this.getGlobalBounds().getY());
            }
            for (PropertyChangeListener l : ConstantsPane.this.changeListeners) {
                l.propertyChange(evt);
            }
        }
    };
    private final ContainerChildListener childListener = new ContainerChildListener(){

        @Override
        public void containerChildRemoved(ContainerChildEvent evt) {
            int constantPosition = -1;
            for (ConstantPNode constantNode : ConstantsPane.this.constantPNodeList) {
                if (constantNode.getItem() != evt.getChild()) continue;
                constantPosition = ConstantsPane.this.constantPNodeList.indexOf(constantNode);
                ConstantsPane.this.constantPNodeList.remove(constantNode);
                constantNode.removeChangeListener(ConstantsPane.this.resizeListener);
                ConstantsPane.this.removeChild(constantNode);
                break;
            }
            if (constantPosition != -1) {
                for (int i = constantPosition; i < ConstantsPane.this.constantPNodeList.size(); ++i) {
                    ((ConstantPNode)ConstantsPane.this.constantPNodeList.get(i)).translate(0.0, -ConstantsPane.this.title.getHeight() - 5.0);
                }
                ConstantsPane.this.repositionAndResize();
            }
        }

        @Override
        public void containerChildAdded(ContainerChildEvent evt) {
            ConstantsPane.this.addItem(evt.getChild());
        }
    };
    private PStyledText title;
    private PropertyChangeListener resizeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            for (PropertyChangeListener listener : ConstantsPane.this.changeListeners) {
                listener.propertyChange(evt);
            }
            ConstantsPane.this.repositionAndResize();
        }
    };
    private PNode header;
    private PSwing allSelectCheckbox;
    private PPath headerBackground;
    private PClip headerBackClip;
    private PNode whereBackground;
    private final SPVariableHelper variables;

    public ConstantsPane(QueryPen mouseState, PCanvas canvas, Container containerModel) {
        this(mouseState, canvas, containerModel, null);
    }

    public ConstantsPane(QueryPen mouseState, PCanvas canvas, Container containerModel, SPVariableHelper variables) {
        this.queryPen = mouseState;
        this.canvas = canvas;
        this.model = containerModel;
        this.variables = variables;
        this.changeListeners = new ArrayList<PropertyChangeListener>();
        this.constantPNodeList = new ArrayList<ConstantPNode>();
        this.model.addPropertyChangeListener(this.itemChangedListener);
        this.model.addChildListener(this.childListener);
        this.title = new EditablePStyledText(TITLE_STRING, mouseState, canvas);
        this.addChild((PNode)this.title);
        this.header = new PNode();
        this.header.translate(0.0, this.title.getHeight() + 5.0);
        final JCheckBox checkbox = new JCheckBox();
        checkbox.setOpaque(false);
        checkbox.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ConstantPNode node : ConstantsPane.this.constantPNodeList) {
                    if (node.isInSelect() == ((JCheckBox)e.getSource()).isSelected()) continue;
                    node.setSelected(checkbox.isSelected());
                }
            }
        });
        this.allSelectCheckbox = new PSwing((JComponent)checkbox);
        this.header.addChild((PNode)this.allSelectCheckbox);
        this.columnHeader = new EditablePStyledText("select all/none", mouseState, canvas);
        double headerYPos = (this.allSelectCheckbox.getFullBounds().getHeight() - this.columnHeader.getHeight()) / 2.0;
        double checkboxWidth = this.allSelectCheckbox.getFullBounds().getWidth();
        this.columnHeader.translate(checkboxWidth, headerYPos);
        this.header.addChild((PNode)this.columnHeader);
        this.aliasHeader = new EditablePStyledText("alias", mouseState, canvas);
        this.aliasHeader.translate(checkboxWidth + this.columnHeader.getWidth() + 10.0, headerYPos);
        this.header.addChild((PNode)this.aliasHeader);
        this.whereHeader = new EditablePStyledText("where", mouseState, canvas);
        double whereHeaderX = checkboxWidth + this.columnHeader.getWidth() + this.aliasHeader.getWidth() + 15.0;
        this.whereHeader.translate(whereHeaderX, headerYPos);
        this.header.addChild((PNode)this.whereHeader);
        this.addChild(this.header);
        this.addingNewItemPNode = new EditablePStyledText(ADDING_ITEM_STRING, mouseState, canvas);
        this.addingNewItemPNode.addEditStyledTextListener(new EditStyledTextListener(){

            @Override
            public void editingStopping() {
                String text = ConstantsPane.this.addingNewItemPNode.getEditorPane().getText();
                if (!text.equals(ConstantsPane.ADDING_ITEM_STRING) && text.trim().length() > 0) {
                    ConstantsPane.this.model.addItem(new StringItem(text));
                }
                ConstantsPane.this.addingNewItemPNode.getEditorPane().setText(ConstantsPane.ADDING_ITEM_STRING);
                ConstantsPane.this.addingNewItemPNode.syncWithDocument();
            }

            @Override
            public void editingStarting() {
                ConstantsPane.this.addingNewItemPNode.getEditorPane().setText("");
            }
        });
        this.addingNewItemPNode.translate(0.0, (this.title.getHeight() + 5.0) * 2.0 + 5.0);
        this.addChild((PNode)this.addingNewItemPNode);
        this.outerRect = PPath.createRoundRectangle((float)-5.0f, (float)-5.0f, (float)((float)(this.getFullBounds().getWidth() + 10.0)), (float)((float)(this.getFullBounds().getHeight() + 15.0)), (float)8.0f, (float)8.0f);
        this.outerRect.setStroke((Stroke)new BasicStroke(2.0f));
        this.headerBackground = PPath.createRoundRectangle((float)-5.0f, (float)-5.0f, (float)((float)this.outerRect.getWidth() - 1.0f), (float)((float)(this.title.getHeight() + 5.0) * 2.0f + 5.0f + 8.0f), (float)8.0f, (float)8.0f);
        this.headerBackground.setStrokePaint((Paint)new Color(0xFFFFFF, true));
        this.headerBackClip = new PClip();
        this.headerBackClip.addChild((PNode)this.headerBackground);
        float headerClipHeight = (float)(this.title.getHeight() + 5.0) * 2.0f + 10.0f;
        this.headerBackClip.setPathToRectangle((float)this.outerRect.getX(), (float)this.outerRect.getY(), (float)this.outerRect.getWidth(), headerClipHeight);
        this.headerBackClip.setStrokePaint((Paint)new Color(0xFFFFFF, true));
        this.whereBackground = new PNode();
        this.whereBackground.translate(this.outerRect.getX() + whereHeaderX + 5.0, this.outerRect.getY() + (double)headerClipHeight);
        this.whereBackground.setWidth(this.outerRect.getWidth() - whereHeaderX - 2.0 - 5.0 - 1.0);
        this.whereBackground.setHeight(this.outerRect.getHeight() - (double)headerClipHeight - 2.0 - 1.0);
        this.whereBackground.setPaint((Paint)QueryPen.WHERE_BACKGROUND_COLOUR);
        this.addChild(this.whereBackground);
        this.addChild((PNode)this.headerBackClip);
        this.addChild((PNode)this.outerRect);
        this.whereBackground.moveToBack();
        this.headerBackClip.moveToBack();
        this.outerRect.moveToBack();
        this.setBounds((Rectangle2D)this.outerRect.getBounds());
        this.translate(-this.getGlobalBounds().getX(), -this.getGlobalBounds().getY());
        this.translate(containerModel.getPosition().getX(), containerModel.getPosition().getY());
        logger.debug((Object)("Loaded constants pane in position " + this.getGlobalBounds().getX() + ", " + this.getGlobalBounds().getY()));
        for (Item item : this.model.getItems()) {
            this.addItem(item);
        }
        this.addInputEventListener((PInputEventListener)new PDragSequenceEventHandler(){

            protected void endDrag(PInputEvent e) {
                super.endDrag(e);
                ConstantsPane.this.model.setPosition(new Point2D.Double(ConstantsPane.this.getGlobalBounds().getX(), ConstantsPane.this.getGlobalBounds().getY()));
                logger.debug((Object)("Setting position " + ConstantsPane.this.getGlobalBounds().getX() + ", " + ConstantsPane.this.getGlobalBounds().getY()));
            }
        });
        PNotificationCenter.defaultCenter().addListener((Object)this, "setFocusAppearance", "SELECTION_CHANGED_NOTIFICATION", null);
        this.setFocusAppearance(new PNotification(null, null, null));
    }

    private void repositionAndResize() {
        this.addingNewItemPNode.translate(0.0, (this.title.getHeight() + 5.0) * (double)(2 + this.constantPNodeList.size()) + 5.0 - this.addingNewItemPNode.getFullBounds().getY());
        double translateAliasX = this.columnHeader.getFullBounds().getX() + this.columnHeader.getWidth() + 5.0;
        for (ConstantPNode node : this.constantPNodeList) {
            translateAliasX = Math.max(translateAliasX, node.getAliasOffset());
        }
        this.aliasHeader.translate(translateAliasX - this.aliasHeader.getFullBounds().getX(), 0.0);
        this.whereHeader.translate(translateAliasX - this.aliasHeader.getFullBounds().getX(), 0.0);
        for (ConstantPNode node : this.constantPNodeList) {
            node.setAliasXPosition(translateAliasX);
        }
        double translateWhereX = this.aliasHeader.getFullBounds().getX() + this.aliasHeader.getWidth() + 5.0;
        logger.debug((Object)("Translating where: max x is " + translateWhereX));
        for (ConstantPNode node : this.constantPNodeList) {
            translateWhereX = Math.max(translateWhereX, node.getWhereOffset());
            logger.debug((Object)("Translating where: max x is " + translateWhereX));
        }
        logger.debug((Object)("Translating where header " + translateWhereX + " from " + this.whereHeader.getFullBounds().getX()));
        this.whereHeader.translate(translateWhereX - this.whereHeader.getFullBounds().getX(), 0.0);
        for (ConstantPNode node : this.constantPNodeList) {
            node.setWhereXPosition(translateWhereX);
        }
        double maxWidth = this.header.getFullBounds().getWidth();
        for (ConstantPNode node : this.constantPNodeList) {
            maxWidth = Math.max(maxWidth, node.getFullBounds().getWidth());
        }
        this.outerRect.setWidth(maxWidth + 10.0);
        this.headerBackground.setWidth(maxWidth + 10.0);
        this.headerBackClip.setWidth(maxWidth + 10.0);
        this.outerRect.setHeight((this.title.getHeight() + 5.0) * (double)(3 + this.constantPNodeList.size()) + 10.0);
        this.whereBackground.translate(translateWhereX - this.whereBackground.getFullBounds().getX(), 0.0);
        this.whereBackground.setWidth(this.outerRect.getWidth() - this.whereBackground.getFullBounds().getX() - 2.0 - 5.0 - 1.0);
        this.whereBackground.setHeight(this.outerRect.getHeight() - this.whereBackground.getFullBounds().getY() - 2.0 - 5.0 - 1.0);
        this.setBounds((Rectangle2D)this.outerRect.getBounds());
    }

    public boolean fullPick(PPickPath pickPath) {
        if (super.fullPick(pickPath)) {
            PNode picked = pickPath.getPickedNode();
            for (ConstantPNode node : this.constantPNodeList) {
                if (!node.getAllNodes().contains(picked)) continue;
                return true;
            }
            if (picked == this.addingNewItemPNode || picked == this.allSelectCheckbox) {
                return true;
            }
            while (picked != this) {
                pickPath.popTransform(picked.getTransformReference(false));
                pickPath.popNode(picked);
                picked = pickPath.getPickedNode();
            }
            return true;
        }
        return false;
    }

    public void setFocusAppearance(PNotification notification) {
        boolean hasFocus = this.queryPen.getMultipleSelectEventHandler().getSelection().contains(this);
        if (hasFocus) {
            this.outerRect.setStrokePaint((Paint)QueryPen.SELECTED_CONTAINER_COLOUR);
            this.headerBackground.setPaint((Paint)QueryPen.SELECTED_CONTAINER_COLOUR);
            this.moveToFront();
        } else {
            this.outerRect.setStrokePaint((Paint)QueryPen.UNSELECTED_CONTAINER_COLOUR);
            this.headerBackground.setPaint((Paint)QueryPen.UNSELECTED_CONTAINER_GRADIENT_COLOUR);
        }
    }

    public void addItem(Item item) {
        ConstantPNode newConstantNode = new ConstantPNode(item, this.queryPen, this.canvas, this.variables);
        newConstantNode.addChangeListener(this.resizeListener);
        newConstantNode.translate(0.0, (this.title.getHeight() + 5.0) * (double)(2 + this.constantPNodeList.size()) + 5.0);
        this.constantPNodeList.add(newConstantNode);
        this.addChild(newConstantNode);
        this.repositionAndResize();
    }

    public void addChangeListener(PropertyChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(PropertyChangeListener l) {
        this.changeListeners.remove(l);
    }

    @Override
    public void cleanup() {
        this.model.removePropertyChangeListener(this.itemChangedListener);
        this.model.removeChildListener(this.childListener);
        for (Object o : this.getAllNodes()) {
            if (!(o instanceof CleanupPNode) || o == this) continue;
            ((CleanupPNode)o).cleanup();
        }
        PNotificationCenter.defaultCenter().removeListener((Object)this);
    }

    public Container getModel() {
        return this.model;
    }
}

