/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.etl.kettle.KettleRepositoryDirectoryChooser;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.Messages;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;

public class UserRepositoryDirectoryChooser
implements KettleRepositoryDirectoryChooser {
    private static final Logger logger = Logger.getLogger(UserRepositoryDirectoryChooser.class);
    private JFrame parent;
    private RepositoryDirectory directory = null;

    public UserRepositoryDirectoryChooser(JFrame parent) {
        this.parent = parent;
    }

    @Override
    public RepositoryDirectory selectDirectory(Repository repo) {
        final JDialog chooserDialog = new JDialog(this.parent);
        chooserDialog.setTitle(Messages.getString("UserRepositoryDirectoryChooser.selectRepositoryDialogTitle"));
        FormLayout layout = new FormLayout("10dlu, 2dlu, fill:pref:grow, 12dlu", "pref, fill:pref:grow, pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.nextColumn(2);
        builder.append(Messages.getString("UserRepositoryDirectoryChooser.chooseDirectory"));
        builder.nextLine();
        DefaultMutableTreeNode root = this.populateTree(repo.getDirectoryTree());
        final JTree tree = new JTree(root);
        builder.append("");
        JScrollPane scrollPane = new JScrollPane(tree);
        scrollPane.setPreferredSize(new Dimension(200, 350));
        builder.append((Component)scrollPane);
        ButtonBarBuilder buttonBar = new ButtonBarBuilder();
        buttonBar.addGlue();
        JButton okButton = new JButton(Messages.getString("UserRepositoryDirectoryChooser.okOption"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (tree.getSelectionPath() == null) {
                    return;
                }
                UserRepositoryDirectoryChooser.this.directory = (RepositoryDirectory)((DefaultMutableTreeNode)tree.getSelectionPath().getLastPathComponent()).getUserObject();
                chooserDialog.dispose();
            }
        });
        buttonBar.addGridded((JComponent)okButton);
        buttonBar.addRelatedGap();
        JButton cancelButton = new JButton(Messages.getString("UserRepositoryDirectoryChooser.cancelOption"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserRepositoryDirectoryChooser.this.directory = null;
                chooserDialog.dispose();
            }
        });
        buttonBar.addGridded((JComponent)cancelButton);
        builder.nextLine();
        builder.append("");
        builder.add((Component)buttonBar.getPanel());
        chooserDialog.add(builder.getPanel());
        chooserDialog.setModal(true);
        Runnable promptUser = new Runnable(){

            @Override
            public void run() {
                chooserDialog.pack();
                chooserDialog.setLocationRelativeTo(UserRepositoryDirectoryChooser.this.parent);
                chooserDialog.setVisible(true);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            promptUser.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(promptUser);
            }
            catch (InterruptedException e) {
                ASUtils.showExceptionDialogNoReport(this.parent, "While queing the dialog's pack, setVisible and setLocation, we were interrupted", e);
            }
            catch (InvocationTargetException e) {
                ASUtils.showExceptionDialogNoReport(this.parent, "While queing the dialog's pack, setVisible and setLocation, an InvocationTargetException was thrown", e);
            }
        }
        return this.directory;
    }

    private DefaultMutableTreeNode populateTree(RepositoryDirectory rootDir) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootDir);
        int numIterations = rootDir.getNrSubdirectories();
        for (int i = 0; i < numIterations; ++i) {
            logger.debug((Object)("Populating the tree: on iteration " + i + " of " + numIterations));
            RepositoryDirectory childDir = rootDir.getSubdirectory(i);
            DefaultMutableTreeNode child = this.populateTree(childDir);
            root.add(child);
        }
        return root;
    }
}

