/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.critic;

import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticGrouping;
import ca.sqlpower.architect.swingui.critic.CriticManagerPanel;
import ca.sqlpower.architect.swingui.critic.CriticSettingsPanel;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.swingui.DataEntryPanel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CriticGroupingPanel
implements DataEntryPanel {
    private final CriticGrouping grouping;
    private final JPanel panel;
    private final JCheckBox enabledCheckbox;
    private final CriticSettingsTreeModel treeModel;
    private final TreeCellRenderer treeCellRenderer = new TreeCellRenderer(){

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof CriticGrouping) {
                return new JLabel(((CriticGrouping)((Object)value)).getPlatformType());
            }
            if (value instanceof CriticAndSettings) {
                int preferredCriticPanelSize = 0;
                for (CriticSettingsPanel panel : CriticGroupingPanel.this.settingsPanels.values()) {
                    preferredCriticPanelSize = Math.max(preferredCriticPanelSize, panel.getPanel().getPreferredSize().width);
                }
                preferredCriticPanelSize = Math.max(CriticGroupingPanel.this.parentPanel.getPreferredCriticPanelSize(), preferredCriticPanelSize);
                CriticGroupingPanel.this.parentPanel.setPreferredCriticPanelSize(preferredCriticPanelSize);
                JComponent thisSettingsPanel = ((CriticSettingsPanel)CriticGroupingPanel.this.settingsPanels.get((CriticAndSettings)value)).getPanel();
                thisSettingsPanel.setPreferredSize(new Dimension(preferredCriticPanelSize, thisSettingsPanel.getPreferredSize().height));
                for (Component c : thisSettingsPanel.getComponents()) {
                    c.setEnabled(tree.isEnabled());
                }
                return thisSettingsPanel;
            }
            return null;
        }
    };
    private final Map<CriticAndSettings, CriticSettingsPanel> settingsPanels = new HashMap<CriticAndSettings, CriticSettingsPanel>();
    private final SPListener groupListener = new AbstractSPListener(){

        public void propertyChanged(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                CriticGroupingPanel.this.enabledCheckbox.setSelected((Boolean)evt.getNewValue());
            }
        }
    };
    private final CriticManagerPanel parentPanel;

    public CriticGroupingPanel(CriticGrouping grouping, CriticManagerPanel parentPanel) {
        this.grouping = grouping;
        this.parentPanel = parentPanel;
        this.panel = new JPanel();
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref, 0dlu, pref:grow", "top:pref"), this.panel);
        for (CriticAndSettings settings : grouping.getSettings()) {
            CriticSettingsPanel settingsPanel = parentPanel.getSettingsPanelFactory().createCriticsSettingsPanel(settings);
            this.settingsPanels.put(settings, settingsPanel);
        }
        this.treeModel = new CriticSettingsTreeModel(grouping, this.settingsPanels.values());
        this.enabledCheckbox = new JCheckBox();
        this.enabledCheckbox.setSelected(grouping.isEnabled());
        builder.append((Component)this.enabledCheckbox);
        grouping.addSPListener(this.groupListener);
        final JTree settingsTree = new JTree(this.treeModel);
        settingsTree.setCellRenderer(this.treeCellRenderer);
        settingsTree.setRowHeight(0);
        settingsTree.setShowsRootHandles(true);
        GroupingTreeCellEditor treeCellEditor = new GroupingTreeCellEditor();
        settingsTree.setCellEditor(treeCellEditor);
        settingsTree.setEditable(true);
        treeCellEditor.isCellEditable(new EventObject(settingsTree));
        settingsTree.setBackground(this.panel.getBackground());
        builder.append((Component)settingsTree);
        this.enabledCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                settingsTree.setEnabled(CriticGroupingPanel.this.enabledCheckbox.isSelected());
                settingsTree.setEditable(CriticGroupingPanel.this.enabledCheckbox.isSelected());
            }
        });
        settingsTree.setEnabled(this.enabledCheckbox.isSelected());
        settingsTree.setEditable(this.enabledCheckbox.isSelected());
    }

    public boolean applyChanges() {
        this.grouping.setEnabled(this.enabledCheckbox.isSelected());
        for (CriticSettingsPanel panel : this.settingsPanels.values()) {
            if (panel.applyChanges()) continue;
            return false;
        }
        return true;
    }

    public void discardChanges() {
        for (CriticSettingsPanel panel : this.settingsPanels.values()) {
            panel.discardChanges();
        }
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        if (this.enabledCheckbox.isSelected() != this.grouping.isEnabled()) {
            return true;
        }
        for (CriticSettingsPanel panel : this.settingsPanels.values()) {
            if (!panel.hasUnsavedChanges()) continue;
            return true;
        }
        return false;
    }

    public void cleanup() {
        this.grouping.removeSPListener(this.groupListener);
        for (CriticSettingsPanel panel : this.settingsPanels.values()) {
            panel.cleanup();
        }
    }

    public void revalidateTree() {
        this.treeModel.repaintTreeNodes();
    }

    private class CriticSettingsTreeModel
    implements TreeModel {
        private final List<TreeModelListener> treeListeners = new ArrayList<TreeModelListener>();
        private final PropertyChangeListener criticSettingsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CriticSettingsPanel source = (CriticSettingsPanel)evt.getSource();
                for (int i = CriticSettingsTreeModel.this.treeListeners.size() - 1; i >= 0; --i) {
                    ((TreeModelListener)CriticSettingsTreeModel.this.treeListeners.get(i)).treeNodesChanged(new TreeModelEvent(evt.getSource(), new TreePath(new Object[]{CriticSettingsTreeModel.this.grouping, source.getSettings()})));
                }
            }
        };
        private final CriticGrouping grouping;

        public CriticSettingsTreeModel(CriticGrouping grouping, Collection<CriticSettingsPanel> panels) {
            this.grouping = grouping;
            for (CriticSettingsPanel childPanel : panels) {
                childPanel.addPropertyChangeListener(this.criticSettingsListener);
            }
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            throw new UnsupportedOperationException("This should not be allowed at this point. Only when users can create their own critics will this need to change.");
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.treeListeners.remove(l);
        }

        @Override
        public boolean isLeaf(Object node) {
            return node instanceof CriticAndSettings;
        }

        @Override
        public Object getRoot() {
            return this.grouping;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return ((SPObject)parent).getChildren().indexOf(child);
        }

        @Override
        public int getChildCount(Object parent) {
            return ((SPObject)parent).getChildren().size();
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((SPObject)parent).getChildren().get(index);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.treeListeners.add(l);
        }

        public void repaintTreeNodes() {
            for (CriticSettingsPanel settingsPanel : CriticGroupingPanel.this.settingsPanels.values()) {
                for (int i = this.treeListeners.size() - 1; i >= 0; --i) {
                    this.treeListeners.get(i).treeNodesChanged(new TreeModelEvent((Object)CriticGroupingPanel.this, new Object[]{this.grouping, settingsPanel.getSettings()}));
                }
            }
        }
    }

    private class GroupingTreeCellEditor
    implements TreeCellEditor {
        private final List<CellEditorListener> editorListeners = new ArrayList<CellEditorListener>();

        private GroupingTreeCellEditor() {
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject e) {
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.editorListeners.remove(l);
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.editorListeners.add(l);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            if (value instanceof CriticAndSettings) {
                return ((CriticSettingsPanel)CriticGroupingPanel.this.settingsPanels.get((CriticAndSettings)value)).getPanel();
            }
            return tree.getCellRenderer().getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, false);
        }
    }
}

