/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getxmldata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getxmldata.GetXMLData;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataData;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataField;
import org.pentaho.di.trans.steps.getxmldata.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetXMLDataMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final String[] RequiredFilesDesc = new String[]{Messages.getString("System.Combo.No"), Messages.getString("System.Combo.Yes")};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private String[] fileName;
    private String[] fileMask;
    private String[] fileRequired;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private String loopxpath;
    private GetXMLDataField[] inputFields;
    private String encoding;
    private String xmlField;
    private boolean inFields;
    private boolean IsAFile;
    private boolean addResultFile;
    private boolean nameSpaceAware;
    private boolean validating;
    private boolean usetoken;
    private boolean IsIgnoreEmptyFile;
    private boolean doNotFailIfNoFile;
    private boolean ignorecomments;
    private boolean readurl;
    private String prunePath;

    public boolean addResultFile() {
        return this.addResultFile;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isReadUrl() {
        return this.readurl;
    }

    public void setReadUrl(boolean readurl) {
        this.readurl = readurl;
    }

    public void setAddResultFile(boolean addResultFile) {
        this.addResultFile = addResultFile;
    }

    public GetXMLDataField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(GetXMLDataField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String getXMLField() {
        return this.xmlField;
    }

    public void setXMLField(String xmlField) {
        this.xmlField = xmlField;
    }

    public boolean isInFields() {
        return this.inFields;
    }

    public void setInFields(boolean inFields) {
        this.inFields = inFields;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getLoopXPath() {
        return this.loopxpath;
    }

    public void setLoopXPath(String loopxpath) {
        this.loopxpath = loopxpath;
    }

    public void setuseToken(boolean usetoken) {
        this.usetoken = usetoken;
    }

    public boolean isuseToken() {
        return this.usetoken;
    }

    public boolean isIgnoreEmptyFile() {
        return this.IsIgnoreEmptyFile;
    }

    public void setIgnoreEmptyFile(boolean IsIgnoreEmptyFile) {
        this.IsIgnoreEmptyFile = IsIgnoreEmptyFile;
    }

    public boolean isdoNotFailIfNoFile() {
        return this.doNotFailIfNoFile;
    }

    public void setdoNotFailIfNoFile(boolean doNotFailIfNoFile) {
        this.doNotFailIfNoFile = doNotFailIfNoFile;
    }

    public boolean isIgnoreComments() {
        return this.ignorecomments;
    }

    public void setIgnoreComments(boolean ignorecomments) {
        this.ignorecomments = ignorecomments;
    }

    public void setNamespaceAware(boolean nameSpaceAware) {
        this.nameSpaceAware = nameSpaceAware;
    }

    public boolean isNamespaceAware() {
        return this.nameSpaceAware;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean getIsAFile() {
        return this.IsAFile;
    }

    public void setIsAFile(boolean IsAFile) {
        this.IsAFile = IsAFile;
    }

    public String getPrunePath() {
        return this.prunePath;
    }

    public void setPrunePath(String prunePath) {
        this.prunePath = prunePath;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        int i;
        GetXMLDataMeta retval = (GetXMLDataMeta)super.clone();
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        retval.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            retval.fileName[i] = this.fileName[i];
            retval.fileMask[i] = this.fileMask[i];
            retval.fileRequired[i] = this.fileRequired[i];
        }
        for (i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (GetXMLDataField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(400);
        retval.append("    ").append(XMLHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"addresultfile", (boolean)this.addResultFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"namespaceaware", (boolean)this.nameSpaceAware));
        retval.append("    ").append(XMLHandler.addTagValue((String)"ignorecomments", (boolean)this.ignorecomments));
        retval.append("    ").append(XMLHandler.addTagValue((String)"readurl", (boolean)this.readurl));
        retval.append("    ").append(XMLHandler.addTagValue((String)"validating", (boolean)this.validating));
        retval.append("    " + XMLHandler.addTagValue((String)"usetoken", (boolean)this.usetoken));
        retval.append("    " + XMLHandler.addTagValue((String)"IsIgnoreEmptyFile", (boolean)this.IsIgnoreEmptyFile));
        retval.append("    " + XMLHandler.addTagValue((String)"doNotFailIfNoFile", (boolean)this.doNotFailIfNoFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    <file>").append(Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
        }
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            GetXMLDataField field = this.inputFields[i];
            retval.append(field.getXML());
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"loopxpath", (String)this.loopxpath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"IsInFields", (boolean)this.inFields));
        retval.append("    ").append(XMLHandler.addTagValue((String)"IsAFile", (boolean)this.IsAFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"XmlField", (String)this.xmlField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"prunePath", (String)this.prunePath));
        return retval.toString();
    }

    public String getRequiredFilesDesc(String tt) {
        if (Const.isEmpty((String)tt)) {
            return RequiredFilesDesc[0];
        }
        if (tt.equalsIgnoreCase(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            this.includeFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.addResultFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addresultfile"));
            this.nameSpaceAware = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"namespaceaware"));
            this.ignorecomments = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"ignorecomments"));
            this.readurl = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"readurl"));
            this.validating = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"validating"));
            this.usetoken = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"usetoken"));
            this.IsIgnoreEmptyFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"IsIgnoreEmptyFile"));
            this.doNotFailIfNoFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"doNotFailIfNoFile"));
            this.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
            }
            for (i = 0; i < nrFields; ++i) {
                GetXMLDataField field;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new GetXMLDataField(fnode);
            }
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            this.loopxpath = XMLHandler.getTagValue((Node)stepnode, (String)"loopxpath");
            this.inFields = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"IsInFields"));
            this.IsAFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"IsAFile"));
            this.xmlField = XMLHandler.getTagValue((Node)stepnode, (String)"XmlField");
            this.prunePath = XMLHandler.getTagValue((Node)stepnode, (String)"prunePath");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("GetXMLDataMeta.Exception.ErrorLoadingXML", e.toString()));
        }
    }

    public void allocate(int nrfiles, int nrfields) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.inputFields = new GetXMLDataField[nrfields];
    }

    @Override
    public void setDefault() {
        int i;
        this.usetoken = false;
        this.IsIgnoreEmptyFile = false;
        this.doNotFailIfNoFile = true;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.IsAFile = false;
        this.addResultFile = false;
        this.nameSpaceAware = false;
        this.ignorecomments = false;
        this.readurl = false;
        this.validating = false;
        int nrFiles = 0;
        int nrFields = 0;
        this.loopxpath = "";
        this.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.fileRequired[i] = RequiredFilesCode[0];
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new GetXMLDataField("field" + (i + 1));
        }
        this.rowLimit = 0L;
        this.inFields = false;
        this.xmlField = "";
        this.prunePath = "";
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta v;
        for (int i = 0; i < this.inputFields.length; ++i) {
            GetXMLDataField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            ValueMeta v2 = new ValueMeta(space.environmentSubstitute(field.getName()), type);
            v2.setLength(field.getLength());
            v2.setPrecision(field.getPrecision());
            v2.setOrigin(name);
            v2.setConversionMask(field.getFormat());
            v2.setDecimalSymbol(field.getDecimalSymbol());
            v2.setGroupingSymbol(field.getGroupSymbol());
            v2.setCurrencySymbol(field.getCurrencySymbol());
            r.addValueMeta((ValueMetaInterface)v2);
        }
        if (this.includeFilename) {
            v = new ValueMeta(space.environmentSubstitute(this.filenameField), 2);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber) {
            v = new ValueMeta(space.environmentSubstitute(this.rowNumberField), 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.addResultFile = rep.getStepAttributeBoolean(id_step, "addresultfile");
            this.nameSpaceAware = rep.getStepAttributeBoolean(id_step, "namespaceaware");
            this.ignorecomments = rep.getStepAttributeBoolean(id_step, "ignorecomments");
            this.readurl = rep.getStepAttributeBoolean(id_step, "readurl");
            this.validating = rep.getStepAttributeBoolean(id_step, "validating");
            this.usetoken = rep.getStepAttributeBoolean(id_step, "usetoken");
            this.IsIgnoreEmptyFile = rep.getStepAttributeBoolean(id_step, "IsIgnoreEmptyFile");
            this.doNotFailIfNoFile = rep.getStepAttributeBoolean(id_step, "doNotFailIfNoFile");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            this.loopxpath = rep.getStepAttributeString(id_step, "loopxpath");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            int nrFiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                this.fileRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
            }
            for (i = 0; i < nrFields; ++i) {
                GetXMLDataField field = new GetXMLDataField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setXPath(rep.getStepAttributeString(id_step, i, "field_xpath"));
                field.setElementType(GetXMLDataField.getElementTypeByCode(rep.getStepAttributeString(id_step, i, "element_type")));
                field.setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(GetXMLDataField.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
            this.inFields = rep.getStepAttributeBoolean(id_step, "IsInFields");
            this.IsAFile = rep.getStepAttributeBoolean(id_step, "IsAFile");
            this.xmlField = rep.getStepAttributeString(id_step, "XmlField");
            this.prunePath = rep.getStepAttributeString(id_step, "prunePath");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("GetXMLDataMeta.Exception.ErrorReadingRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "addresultfile", this.addResultFile);
            rep.saveStepAttribute(id_transformation, id_step, "namespaceaware", this.nameSpaceAware);
            rep.saveStepAttribute(id_transformation, id_step, "ignorecomments", this.ignorecomments);
            rep.saveStepAttribute(id_transformation, id_step, "readurl", this.readurl);
            rep.saveStepAttribute(id_transformation, id_step, "validating", this.validating);
            rep.saveStepAttribute(id_transformation, id_step, "usetoken", this.usetoken);
            rep.saveStepAttribute(id_transformation, id_step, "IsIgnoreEmptyFile", this.IsIgnoreEmptyFile);
            rep.saveStepAttribute(id_transformation, id_step, "doNotFailIfNoFile", this.doNotFailIfNoFile);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "loopxpath", this.loopxpath);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_mask", this.fileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_required", this.fileRequired[i]);
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                GetXMLDataField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_xpath", field.getXPath());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "element_type", field.getElementTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_repeat", field.isRepeated());
            }
            rep.saveStepAttribute(id_transformation, id_step, "IsInFields", this.inFields);
            rep.saveStepAttribute(id_transformation, id_step, "IsAFile", this.IsAFile);
            rep.saveStepAttribute(id_transformation, id_step, "XmlField", this.xmlField);
            rep.saveStepAttribute(id_transformation, id_step, "prunePath", this.prunePath);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("GetXMLDataMeta.Exception.ErrorSavingToRepository", "" + id_step), (Throwable)e);
        }
    }

    public FileInputList getFiles(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.fileRequired);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (input.length <= 0) {
            cr = new CheckResult(4, Messages.getString("GetXMLDataMeta.CheckResult.NoInputExpected"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("GetXMLDataMeta.CheckResult.NoInput"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.getLoopXPath() == null || Const.isEmpty((String)this.getLoopXPath())) {
            cr = new CheckResult(4, Messages.getString("GetXMLDataMeta.CheckResult.NoLoopXpath"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.getInputFields().length <= 0) {
            cr = new CheckResult(4, Messages.getString("GetXMLDataMeta.CheckResult.NoInputField"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.isInFields()) {
            if (Const.isEmpty((String)this.getXMLField())) {
                cr = new CheckResult(4, Messages.getString("GetXMLDataMeta.CheckResult.NoField"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, Messages.getString("GetXMLDataMeta.CheckResult.FieldOk"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            FileInputList fileInputList = this.getFiles(transMeta);
            if (fileInputList == null || fileInputList.getFiles().size() == 0) {
                cr = new CheckResult(4, Messages.getString("GetXMLDataMeta.CheckResult.NoFiles"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, Messages.getString("GetXMLDataMeta.CheckResult.FilesOk", "" + fileInputList.getFiles().size()), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new GetXMLData(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GetXMLDataData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            FileInputList fileList;
            ArrayList<String> newFilenames = new ArrayList<String>();
            if (!this.isInFields() && (fileList = this.getFiles(space)).getFiles().size() > 0) {
                for (FileObject fileObject : fileList.getFiles()) {
                    if (!fileObject.exists()) continue;
                    newFilenames.add(fileObject.getName().getPath());
                }
                this.fileName = newFilenames.toArray(new String[newFilenames.size()]);
                this.fileMask = new String[newFilenames.size()];
                this.fileRequired = new String[newFilenames.size()];
                for (int i = 0; i < newFilenames.size(); ++i) {
                    this.fileRequired[i] = "Y";
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

