/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.config.OrderedFilterBeanDefinitionDecorator;
import org.springframework.security.config.SecurityConfigurationException;
import org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.FilterSecurityInterceptor;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;
import org.springframework.security.providers.anonymous.AnonymousProcessingFilter;
import org.springframework.security.ui.ExceptionTranslationFilter;
import org.springframework.security.ui.webapp.AuthenticationProcessingFilterEntryPoint;
import org.springframework.security.util.FilterChainProxy;

public class FilterChainProxyPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private Log logger = LogFactory.getLog(this.getClass());
    private ListableBeanFactory beanFactory;
    static /* synthetic */ Class class$org$springframework$security$context$HttpSessionContextIntegrationFilter;
    static /* synthetic */ Class class$org$springframework$security$ui$webapp$AuthenticationProcessingFilter;
    static /* synthetic */ Class class$org$springframework$security$ui$SessionFixationProtectionFilter;
    static /* synthetic */ Class class$org$springframework$security$ui$basicauth$BasicProcessingFilter;
    static /* synthetic */ Class class$org$springframework$security$wrapper$SecurityContextHolderAwareRequestFilter;
    static /* synthetic */ Class class$org$springframework$security$ui$ExceptionTranslationFilter;
    static /* synthetic */ Class class$org$springframework$security$intercept$web$FilterSecurityInterceptor;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Ordered filter;
        int i;
        if (!"_filterChainProxy".equals(beanName)) {
            return bean;
        }
        FilterChainProxy filterChainProxy = (FilterChainProxy)bean;
        ConfigUtils.FilterChainList filterList = (ConfigUtils.FilterChainList)this.beanFactory.getBean("_filterChainList");
        ArrayList<Ordered> filters = new ArrayList<Ordered>(filterList.getFilters());
        Collections.sort(filters, new OrderComparator());
        this.logger.info((Object)("Checking sorted filter chain: " + filters));
        for (i = 0; i < filters.size(); ++i) {
            filter = (Ordered)filters.get(i);
            if (i <= 0) continue;
            Ordered previous = (Ordered)filters.get(i - 1);
            if (filter.getOrder() != previous.getOrder()) continue;
            throw new SecurityConfigurationException("Filters '" + this.unwrapFilter(filter) + "' and '" + this.unwrapFilter(previous) + "' have the same 'order' value. When using custom filters, " + "please make sure the positions do not conflict with default filters. " + "Alternatively you can disable the default filters by removing the corresponding " + "child elements from <http> and avoiding the use of <http auto-config='true'>.");
        }
        this.logger.info((Object)"Filter chain...");
        for (i = 0; i < filters.size(); ++i) {
            filter = this.unwrapFilter(filters.get(i));
            this.logger.info((Object)("[" + i + "] - " + filter));
            filters.set(i, filter);
        }
        this.checkFilterStack(filters);
        Map filterMap = filterChainProxy.getFilterChainMap();
        filterMap.put(filterChainProxy.getMatcher().getUniversalMatchPattern(), filters);
        filterChainProxy.setFilterChainMap(filterMap);
        this.checkLoginPageIsntProtected(filterChainProxy);
        this.logger.info((Object)("FilterChainProxy: " + filterChainProxy));
        return bean;
    }

    private void checkFilterStack(List filters) {
        this.checkForDuplicates(class$org$springframework$security$context$HttpSessionContextIntegrationFilter == null ? (class$org$springframework$security$context$HttpSessionContextIntegrationFilter = FilterChainProxyPostProcessor.class$("org.springframework.security.context.HttpSessionContextIntegrationFilter")) : class$org$springframework$security$context$HttpSessionContextIntegrationFilter, filters);
        this.checkForDuplicates(class$org$springframework$security$ui$webapp$AuthenticationProcessingFilter == null ? (class$org$springframework$security$ui$webapp$AuthenticationProcessingFilter = FilterChainProxyPostProcessor.class$("org.springframework.security.ui.webapp.AuthenticationProcessingFilter")) : class$org$springframework$security$ui$webapp$AuthenticationProcessingFilter, filters);
        this.checkForDuplicates(class$org$springframework$security$ui$SessionFixationProtectionFilter == null ? (class$org$springframework$security$ui$SessionFixationProtectionFilter = FilterChainProxyPostProcessor.class$("org.springframework.security.ui.SessionFixationProtectionFilter")) : class$org$springframework$security$ui$SessionFixationProtectionFilter, filters);
        this.checkForDuplicates(class$org$springframework$security$ui$basicauth$BasicProcessingFilter == null ? (class$org$springframework$security$ui$basicauth$BasicProcessingFilter = FilterChainProxyPostProcessor.class$("org.springframework.security.ui.basicauth.BasicProcessingFilter")) : class$org$springframework$security$ui$basicauth$BasicProcessingFilter, filters);
        this.checkForDuplicates(class$org$springframework$security$wrapper$SecurityContextHolderAwareRequestFilter == null ? (class$org$springframework$security$wrapper$SecurityContextHolderAwareRequestFilter = FilterChainProxyPostProcessor.class$("org.springframework.security.wrapper.SecurityContextHolderAwareRequestFilter")) : class$org$springframework$security$wrapper$SecurityContextHolderAwareRequestFilter, filters);
        this.checkForDuplicates(class$org$springframework$security$ui$ExceptionTranslationFilter == null ? (class$org$springframework$security$ui$ExceptionTranslationFilter = FilterChainProxyPostProcessor.class$("org.springframework.security.ui.ExceptionTranslationFilter")) : class$org$springframework$security$ui$ExceptionTranslationFilter, filters);
        this.checkForDuplicates(class$org$springframework$security$intercept$web$FilterSecurityInterceptor == null ? (class$org$springframework$security$intercept$web$FilterSecurityInterceptor = FilterChainProxyPostProcessor.class$("org.springframework.security.intercept.web.FilterSecurityInterceptor")) : class$org$springframework$security$intercept$web$FilterSecurityInterceptor, filters);
    }

    private void checkForDuplicates(Class clazz, List filters) {
        for (int i = 0; i < filters.size(); ++i) {
            Filter f1 = (Filter)filters.get(i);
            if (!clazz.isAssignableFrom(f1.getClass())) continue;
            for (int j = i + 1; j < filters.size(); ++j) {
                Filter f2 = (Filter)filters.get(j);
                if (!clazz.isAssignableFrom(f2.getClass())) continue;
                this.logger.warn((Object)("Possible error: Filters at position " + i + " and " + j + " are both " + "instances of " + clazz.getName()));
                return;
            }
        }
    }

    private void checkLoginPageIsntProtected(FilterChainProxy fcp) {
        ExceptionTranslationFilter etf = (ExceptionTranslationFilter)this.beanFactory.getBean("_exceptionTranslationFilter");
        if (etf.getAuthenticationEntryPoint() instanceof AuthenticationProcessingFilterEntryPoint) {
            String loginPage = ((AuthenticationProcessingFilterEntryPoint)etf.getAuthenticationEntryPoint()).getLoginFormUrl();
            List filters = fcp.getFilters(loginPage);
            this.logger.info((Object)("Checking whether login URL '" + loginPage + "' is accessible with your configuration"));
            if (filters == null || filters.isEmpty()) {
                this.logger.debug((Object)"Filter chain is empty for the login page");
                return;
            }
            if (loginPage.equals("/spring_security_login") && this.beanFactory.containsBean("_defaultLoginPageFilter")) {
                this.logger.debug((Object)"Default generated login page is in use");
                return;
            }
            FilterSecurityInterceptor fsi = (FilterSecurityInterceptor)this.beanFactory.getBean("_filterSecurityInterceptor");
            DefaultFilterInvocationDefinitionSource fids = (DefaultFilterInvocationDefinitionSource)fsi.getObjectDefinitionSource();
            ConfigAttributeDefinition cad = fids.lookupAttributes(loginPage, "POST");
            if (cad == null) {
                this.logger.debug((Object)"No access attributes defined for login page URL");
                if (fsi.isRejectPublicInvocations()) {
                    this.logger.warn((Object)"FilterSecurityInterceptor is configured to reject public invocations. Your login page may not be accessible.");
                }
                return;
            }
            if (!this.beanFactory.containsBean("_anonymousProcessingFilter")) {
                this.logger.warn((Object)"The login page is being protected by the filter chain, but you don't appear to have anonymous authentication enabled. This is almost certainly an error.");
                return;
            }
            AnonymousProcessingFilter anonPF = (AnonymousProcessingFilter)this.beanFactory.getBean("_anonymousProcessingFilter");
            AnonymousAuthenticationToken token = new AnonymousAuthenticationToken("key", anonPF.getUserAttribute().getPassword(), anonPF.getUserAttribute().getAuthorities());
            try {
                fsi.getAccessDecisionManager().decide(token, new Object(), cad);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Anonymous access to the login page doesn't appear to be enabled. This is almost certainly an error. Please check your configuration allows unauthenticated access to the configured login page. (Simulated access was rejected: " + e + ")"));
            }
        }
    }

    private Filter unwrapFilter(Object filter) {
        if (filter instanceof OrderedFilterBeanDefinitionDecorator.OrderedFilterDecorator) {
            return ((OrderedFilterBeanDefinitionDecorator.OrderedFilterDecorator)filter).getDelegate();
        }
        return (Filter)filter;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

