/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;

public final class FileTypeUtil
implements SyntaxConstants {
    private Map<String, List<String>> map;
    private static final boolean DEFAULT_IGNORE_BACKUP_EXTENSIONS = true;
    private static final FileTypeUtil INSTANCE = new FileTypeUtil();

    private FileTypeUtil() {
        this.initializeFilters();
    }

    public static FileTypeUtil get() {
        return INSTANCE;
    }

    public static Pattern fileFilterToPattern(String fileFilter) {
        String pattern = FileTypeUtil.fileFilterToPatternImpl(fileFilter);
        int flags = RSyntaxUtilities.isOsCaseSensitive() ? 0 : 66;
        return Pattern.compile(pattern, flags);
    }

    private static String fileFilterToPatternImpl(String filter) {
        StringBuilder sb = new StringBuilder("^");
        block6: for (int i = 0; i < filter.length(); ++i) {
            char ch = filter.charAt(i);
            switch (ch) {
                case '.': {
                    sb.append("\\.");
                    continue block6;
                }
                case '*': {
                    sb.append(".*");
                    continue block6;
                }
                case '?': {
                    sb.append('.');
                    continue block6;
                }
                case '$': {
                    sb.append("\\$");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.append('$').toString();
    }

    public Map<String, List<String>> getDefaultContentTypeToFilterMap() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.map.entrySet()) {
            result.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return result;
    }

    public String guessContentType(RSyntaxTextArea textArea) {
        String firstLine;
        String style = "text/plain";
        try {
            int endOffs = textArea.getLineEndOffset(0);
            if (textArea.getLineCount() > 1) {
                --endOffs;
            }
            firstLine = textArea.getText(0, endOffs);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return "text/plain";
        }
        if (firstLine.startsWith("#!")) {
            int space = firstLine.indexOf(32, 2);
            if (space > -1) {
                if (firstLine.startsWith("#!/usr/bin/env")) {
                    int space2 = firstLine.indexOf(32, space + 1);
                    if (space2 == -1) {
                        space2 = firstLine.length();
                    }
                    firstLine = firstLine.substring(space + 1, space2);
                } else {
                    firstLine = firstLine.substring(2, space);
                }
            }
            if (firstLine.endsWith("sh")) {
                style = "text/unix";
            } else if (firstLine.endsWith("perl")) {
                style = "text/perl";
            } else if (firstLine.endsWith("php")) {
                style = "text/php";
            } else if (firstLine.endsWith("python")) {
                style = "text/python";
            } else if (firstLine.endsWith("lua")) {
                style = "text/lua";
            } else if (firstLine.endsWith("ruby")) {
                style = "text/ruby";
            }
        } else if (firstLine.startsWith("<?xml") && firstLine.endsWith("?>")) {
            style = "text/xml";
        } else if (firstLine.startsWith("<!doctype html")) {
            style = "text/html";
        }
        return style;
    }

    public String guessContentType(File file) {
        return this.guessContentType(file, null);
    }

    public String guessContentType(File file, Map<String, List<String>> filters) {
        return this.guessContentType(file, filters, true);
    }

    public String guessContentType(File file, boolean ignoreBackupExtensions) {
        return this.guessContentType(file, null, ignoreBackupExtensions);
    }

    public String guessContentType(File file, Map<String, List<String>> filters, boolean ignoreBackupExtensions) {
        String style;
        if (file == null) {
            return "text/plain";
        }
        String fileName = file.getName();
        if (filters == null) {
            filters = this.map;
        }
        fileName = fileName.toLowerCase();
        if (ignoreBackupExtensions) {
            fileName = FileTypeUtil.stripBackupExtensions(fileName);
        }
        return (style = FileTypeUtil.guessContentTypeImpl(fileName, filters)) != null ? style : "text/plain";
    }

    private static String guessContentTypeImpl(String fileName, Map<String, List<String>> filters) {
        String syntaxStyle = null;
        block0: for (Map.Entry<String, List<String>> entry : filters.entrySet()) {
            for (String filter : entry.getValue()) {
                Pattern p = FileTypeUtil.fileFilterToPattern(filter);
                if (!p.matcher(fileName).matches()) continue;
                syntaxStyle = entry.getKey();
                if (filter.contains("*") || filter.contains("?")) continue;
                continue block0;
            }
        }
        return syntaxStyle;
    }

    private static void initFiltersImpl(Map<String, List<String>> map, String syntax, String ... filters) {
        map.put(syntax, Arrays.asList(filters));
    }

    private void initializeFilters() {
        this.map = new HashMap<String, List<String>>();
        FileTypeUtil.initFiltersImpl(this.map, "text/actionscript", "*.as", "*.asc");
        FileTypeUtil.initFiltersImpl(this.map, "text/asm6502", "*.s");
        FileTypeUtil.initFiltersImpl(this.map, "text/asm", "*.asm");
        FileTypeUtil.initFiltersImpl(this.map, "text/bbcode", "*.bbc");
        FileTypeUtil.initFiltersImpl(this.map, "text/c", "*.c");
        FileTypeUtil.initFiltersImpl(this.map, "text/clojure", "*.clj");
        FileTypeUtil.initFiltersImpl(this.map, "text/cpp", "*.cpp", "*.cxx", "*.h", "*.hpp");
        FileTypeUtil.initFiltersImpl(this.map, "text/cs", "*.cs");
        FileTypeUtil.initFiltersImpl(this.map, "text/css", "*.css");
        FileTypeUtil.initFiltersImpl(this.map, "text/csv", "*.csv");
        FileTypeUtil.initFiltersImpl(this.map, "text/d", "*.d");
        FileTypeUtil.initFiltersImpl(this.map, "text/dart", "*.dart");
        FileTypeUtil.initFiltersImpl(this.map, "text/delphi", "*.pas");
        FileTypeUtil.initFiltersImpl(this.map, "text/dockerfile", "*.dockerfile", "Dockerfile");
        FileTypeUtil.initFiltersImpl(this.map, "text/dtd", "*.dtd");
        FileTypeUtil.initFiltersImpl(this.map, "text/fortran", "*.f", "*.for", "*.fort", "*.f77", "*.f90");
        FileTypeUtil.initFiltersImpl(this.map, "text/golang", "*.go");
        FileTypeUtil.initFiltersImpl(this.map, "text/groovy", "*.groovy", "*.gradle", "*.grv", "*.gy", "*.gvy", "*.gsh");
        FileTypeUtil.initFiltersImpl(this.map, "text/handlebars", "*.hbs", "*.handlebars");
        FileTypeUtil.initFiltersImpl(this.map, "text/hosts", "hosts");
        FileTypeUtil.initFiltersImpl(this.map, "text/htaccess", ".htaccess");
        FileTypeUtil.initFiltersImpl(this.map, "text/html", "*.htm", "*.html");
        FileTypeUtil.initFiltersImpl(this.map, "text/ini", "*.ini", ".editorconfig");
        FileTypeUtil.initFiltersImpl(this.map, "text/java", "*.java");
        FileTypeUtil.initFiltersImpl(this.map, "text/javascript", "*.js", "*.jsx");
        FileTypeUtil.initFiltersImpl(this.map, "text/jshintrc", ".jshintrc", "tslint.json");
        FileTypeUtil.initFiltersImpl(this.map, "text/json", "*.json");
        FileTypeUtil.initFiltersImpl(this.map, "text/jsp", "*.jsp");
        FileTypeUtil.initFiltersImpl(this.map, "text/kotlin", "*.kt", "*.kts");
        FileTypeUtil.initFiltersImpl(this.map, "text/latex", "*.tex", "*.ltx", "*.latex");
        FileTypeUtil.initFiltersImpl(this.map, "text/less", "*.less");
        FileTypeUtil.initFiltersImpl(this.map, "text/lisp", "*.cl", "*.clisp", "*.el", "*.l", "*.lisp", "*.lsp", "*.ml");
        FileTypeUtil.initFiltersImpl(this.map, "text/lua", "*.lua");
        FileTypeUtil.initFiltersImpl(this.map, "text/makefile", "Makefile", "makefile");
        FileTypeUtil.initFiltersImpl(this.map, "text/markdown", "*.md");
        FileTypeUtil.initFiltersImpl(this.map, "text/mxml", "*.mxml");
        FileTypeUtil.initFiltersImpl(this.map, "text/nsis", "*.nsi");
        FileTypeUtil.initFiltersImpl(this.map, "text/perl", "*.perl", "*.pl", "*.pm");
        FileTypeUtil.initFiltersImpl(this.map, "text/php", "*.php");
        FileTypeUtil.initFiltersImpl(this.map, "text/properties", "*.properties");
        FileTypeUtil.initFiltersImpl(this.map, "text/proto", "*.proto");
        FileTypeUtil.initFiltersImpl(this.map, "text/python", "*.py");
        FileTypeUtil.initFiltersImpl(this.map, "text/ruby", "*.rb", "Vagrantfile");
        FileTypeUtil.initFiltersImpl(this.map, "text/sas", "*.sas");
        FileTypeUtil.initFiltersImpl(this.map, "text/scala", "*.scala");
        FileTypeUtil.initFiltersImpl(this.map, "text/sql", "*.sql");
        FileTypeUtil.initFiltersImpl(this.map, "text/tcl", "*.tcl", "*.tk");
        FileTypeUtil.initFiltersImpl(this.map, "text/typescript", "*.ts", "*.tsx");
        FileTypeUtil.initFiltersImpl(this.map, "text/unix", "*.sh", "*.?sh");
        FileTypeUtil.initFiltersImpl(this.map, "text/vb", "*.vb");
        FileTypeUtil.initFiltersImpl(this.map, "text/bat", "*.bat", "*.cmd");
        FileTypeUtil.initFiltersImpl(this.map, "text/xml", "*.xml", "*.xsl", "*.xsd", "*.xslt", "*.wsdl", "*.svg", "*.tmx", "*.pom", "*.manifest");
        FileTypeUtil.initFiltersImpl(this.map, "text/yaml", "*.yml", "*.yaml");
    }

    public static String stripBackupExtensions(String fileName) {
        if (fileName != null) {
            if (fileName.endsWith(".bak") || fileName.endsWith(".old")) {
                fileName = fileName.substring(0, fileName.length() - 4);
            } else if (fileName.endsWith(".orig")) {
                fileName = fileName.substring(0, fileName.length() - 5);
            }
        }
        return fileName;
    }
}

