/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import com.android.aapt.Resources;
import com.google.protobuf.InvalidProtocolBufferException;
import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.StringUtils;
import jadx.core.xmlgen.XMLChar;
import jadx.core.xmlgen.XmlDeobf;
import jadx.core.xmlgen.XmlGenUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class ProtoXMLParser {
    private Map<String, String> nsMap;
    private final Map<String, String> tagAttrDeobfNames = new HashMap<String, String>();
    private ICodeWriter writer;
    private final RootNode rootNode;
    private String currentTag;
    private String appPackageName;

    public ProtoXMLParser(RootNode rootNode) {
        this.rootNode = rootNode;
    }

    public synchronized ICodeInfo parse(InputStream inputStream) throws IOException {
        this.nsMap = new HashMap<String, String>();
        this.writer = this.rootNode.makeCodeWriter();
        this.writer.add("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.decode(this.decodeProto(inputStream));
        this.nsMap = null;
        return this.writer.finish();
    }

    private void decode(Resources.XmlNode n) throws IOException {
        if (n.hasSource()) {
            this.writer.attachSourceLine(n.getSource().getLineNumber());
        }
        this.writer.add(StringUtils.escapeXML(n.getText().trim()));
        if (n.hasElement()) {
            this.decode(n.getElement());
        }
    }

    private void decode(Resources.XmlElement e) throws IOException {
        int i;
        String tag = this.deobfClassName(e.getName());
        this.currentTag = tag = this.getValidTagAttributeName(tag);
        this.writer.startLine('<').add(tag);
        for (i = 0; i < e.getNamespaceDeclarationCount(); ++i) {
            this.decode(e.getNamespaceDeclaration(i));
        }
        for (i = 0; i < e.getAttributeCount(); ++i) {
            this.decode(e.getAttribute(i));
        }
        if (e.getChildCount() > 0) {
            this.writer.add('>');
            this.writer.incIndent();
            for (i = 0; i < e.getChildCount(); ++i) {
                HashMap<String, String> oldNsMap = new HashMap<String, String>(this.nsMap);
                this.decode(e.getChild(i));
                this.nsMap = oldNsMap;
            }
            this.writer.decIndent();
            this.writer.startLine("</").add(tag).add('>');
        } else {
            this.writer.add("/>");
        }
    }

    private void decode(Resources.XmlAttribute a) {
        this.writer.add(' ');
        String namespace = a.getNamespaceUri();
        if (!namespace.isEmpty()) {
            this.writer.add(this.nsMap.get(namespace)).add(':');
        }
        String name = a.getName();
        String value = this.deobfClassName(a.getValue());
        this.writer.add(name).add("=\"").add(StringUtils.escapeXML(value)).add('\"');
        this.memorizePackageName(name, value);
    }

    private void decode(Resources.XmlNamespace n) {
        String prefix = n.getPrefix();
        String uri = n.getUri();
        this.nsMap.put(uri, prefix);
        this.writer.add(" xmlns:").add(prefix).add("=\"").add(uri).add('\"');
    }

    private void memorizePackageName(String attrName, String attrValue) {
        if ("manifest".equals(this.currentTag) && "package".equals(attrName)) {
            this.appPackageName = attrValue;
        }
    }

    private String deobfClassName(String className) {
        String newName = XmlDeobf.deobfClassName(this.rootNode, className, this.appPackageName);
        if (newName != null) {
            return newName;
        }
        return className;
    }

    private String getValidTagAttributeName(String originalName) {
        String generated;
        if (XMLChar.isValidName(originalName)) {
            return originalName;
        }
        if (this.tagAttrDeobfNames.containsKey(originalName)) {
            return this.tagAttrDeobfNames.get(originalName);
        }
        while (this.tagAttrDeobfNames.containsValue(generated = ProtoXMLParser.generateTagAttrName())) {
        }
        this.tagAttrDeobfNames.put(originalName, generated);
        return generated;
    }

    private static String generateTagAttrName() {
        int length = 6;
        Random r = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= 6; ++i) {
            sb.append((char)(r.nextInt(26) + 97));
        }
        return sb.toString();
    }

    private Resources.XmlNode decodeProto(InputStream inputStream) throws InvalidProtocolBufferException, IOException {
        return Resources.XmlNode.parseFrom((byte[])XmlGenUtils.readData(inputStream));
    }
}

