/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.search.providers;

import jadx.gui.jobs.Cancelable;
import jadx.gui.jobs.ITaskProgress;
import jadx.gui.search.ISearchProvider;
import jadx.gui.treemodel.JNode;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MergedSearchProvider
implements ISearchProvider {
    private final List<ISearchProvider> list = new ArrayList<ISearchProvider>();
    private int current;
    private int total;

    public void add(ISearchProvider provider) {
        this.list.add(provider);
    }

    public void prepare() {
        this.current = this.list.isEmpty() ? -1 : 0;
        this.total = this.list.stream().mapToInt(ITaskProgress::total).sum();
    }

    @Override
    @Nullable
    public JNode next(Cancelable cancelable) {
        if (this.current == -1) {
            return null;
        }
        do {
            JNode next;
            if ((next = this.list.get(this.current).next(cancelable)) != null) {
                return next;
            }
            ++this.current;
        } while (this.current < this.list.size() && !cancelable.isCanceled());
        this.current = -1;
        return null;
    }

    @Override
    public int progress() {
        return this.list.stream().mapToInt(ITaskProgress::progress).sum();
    }

    @Override
    public int total() {
        return this.total;
    }
}

