/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.newmerge;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class JarAccessory
extends JPanel
implements PropertyChangeListener,
ActionListener {
    private DefaultListModel hsModel = new DefaultListModel();
    private File file = null;
    private JTextField nameField;
    private JTextField urlField;
    private GridBagLayout gb = new GridBagLayout();
    private GridBagConstraints gc = new GridBagConstraints();
    private JLabel nameLabel = new JLabel("Name:");
    private JLabel urlLabel = new JLabel("URL:");
    private JFileChooser fileChooser;

    public JarAccessory() {
        this.setBorder(new TitledBorder("HelpSet"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.createHSPanel(), "Center");
    }

    public JarAccessory(JFileChooser jFileChooser) {
        this();
        this.fileChooser = jFileChooser;
        if (jFileChooser != null) {
            jFileChooser.addPropertyChangeListener(this);
            jFileChooser.addActionListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("SelectedFileChangedProperty")) {
            String string2;
            this.file = (File)propertyChangeEvent.getNewValue();
            if (this.isShowing() && (string2 = this.getExtension(this.file)) != null) {
                if (string2.equals("jar")) {
                    this.handleJar(this.file);
                } else if (string2.equals("hs")) {
                    this.handleHs(this.file);
                }
            }
        }
    }

    public String getExtension(File file) {
        String string;
        int n;
        String string2 = null;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    public void handleJar(File file) {
        Object object;
        try {
            object = new JarFile(file);
            Enumeration<JarEntry> enumeration = ((JarFile)object).entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                if (!string.endsWith(".hs")) continue;
                this.nameField.setText(string);
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = file.getPath();
        this.urlField.setText("file:" + (String)object);
    }

    public void handleHs(File file) {
        String string = file.getName();
        this.nameField.setText(string);
        String string2 = file.getPath();
        this.urlField.setText("file:" + string2);
    }

    public JTabbedPane createHSPanel() {
        this.nameField = new JTextField(20);
        this.urlField = new JTextField(20);
        this.nameField.setEditable(false);
        this.urlField.setEditable(false);
        this.nameField.setBackground(Color.white);
        this.urlField.setBackground(Color.white);
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.gb);
        this.setPlace(this.nameLabel, 0, 0, 17, jPanel);
        this.setPlace(this.nameField, 0, 1, 17, jPanel);
        this.setPlace(this.urlLabel, 0, 2, 17, jPanel);
        this.setPlace(this.urlField, 0, 3, 17, jPanel);
        jTabbedPane.add("File", jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JList jList = new JList(this.hsModel);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jPanel2.add((Component)jScrollPane, "Center");
        jTabbedPane.add("Summary", jPanel2);
        return jTabbedPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ApproveSelection")) {
            this.hsModel.addElement(this.fileChooser.getSelectedFile().getName());
        }
    }

    public void removeFromModel() {
        if (this.hsModel != null && this.hsModel.getSize() > 0) {
            this.hsModel.removeElementAt(this.hsModel.getSize() - 1);
        }
    }

    public String getName() {
        if (this.nameField != null) {
            return this.nameField.getText();
        }
        return null;
    }

    public void setPlace(Component component, int n, int n2, int n3, Container container) {
        this.gc.gridx = n;
        this.gc.gridy = n2;
        this.gc.insets = new Insets(4, 4, 4, 4);
        this.gc.anchor = n3;
        this.gb.setConstraints(component, this.gc);
        container.add(component);
    }
}

