/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.preferences.filesystem;

import java.io.File;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.preferences.base.ConfigFactory;
import org.jfree.report.modules.preferences.filesystem.FileConfigStorage;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializeException;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializer;

public class FileConfigStoreModuleInitializer
implements ModuleInitializer {
    public static final String USER_BASEDIR_CONFIG_KEY = "org.jfree.report.modules.misc.configstore.filesystem.UserTargetDir";
    public static final String SYSTEM_BASEDIR_CONFIG_KEY = "org.jfree.report.modules.misc.configstore.filesystem.SystemTargetDir";

    public void performInit() throws ModuleInitializeException {
        String string = JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(USER_BASEDIR_CONFIG_KEY, "~/.jfreereport/user");
        String string2 = JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(SYSTEM_BASEDIR_CONFIG_KEY, "~/.jfreereport/system");
        ConfigFactory configFactory = ConfigFactory.getInstance();
        configFactory.defineUserStorage(new FileConfigStorage(this.getStoragePath(string)));
        configFactory.defineSystemStorage(new FileConfigStorage(this.getStoragePath(string2)));
    }

    private File getStoragePath(String string) throws ModuleInitializeException {
        File file;
        if (!string.startsWith("~/")) {
            file = new File(string);
        } else {
            try {
                String string2 = System.getProperty("user.home");
                if (string.equals("~/")) {
                    file = new File(string2);
                } else {
                    string = "." + string.substring(1);
                    file = new File(string2, string);
                }
            }
            catch (Exception exception) {
                throw new ModuleInitializeException("Failed to create the file config storage.", exception);
            }
        }
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new ModuleInitializeException("Unable to create the specified directory.");
            }
        } else if (!file.canRead() || !file.canWrite()) {
            throw new ModuleInitializeException("Unable to access the specified directory.");
        }
        return file;
    }
}

