/*
 * Decompiled with CFR 0.152.
 */
package org.ruby_http_parser;

import http_parser.HTTPException;
import http_parser.HTTPMethod;
import http_parser.lolevel.HTTPCallback;
import http_parser.lolevel.HTTPDataCallback;
import http_parser.lolevel.HTTPParser;
import http_parser.lolevel.ParserSettings;
import java.nio.ByteBuffer;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyHttpParser
extends RubyObject {
    public static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyHttpParser(ruby, rubyClass);
        }
    };
    private Ruby runtime;
    private http_parser.HTTPParser parser;
    private ParserSettings settings;
    private RubyClass eParserError;
    private RubyHash headers;
    private IRubyObject on_message_begin;
    private IRubyObject on_headers_complete;
    private IRubyObject on_body;
    private IRubyObject on_message_complete;
    private IRubyObject requestUrl;
    private IRubyObject requestPath;
    private IRubyObject queryString;
    private IRubyObject fragment;
    private IRubyObject header_value_type;
    private IRubyObject upgradeData;
    private IRubyObject callback_object;
    private boolean completed;
    private byte[] _current_header;
    private byte[] _last_header;
    private static final Encoding UTF8 = UTF8Encoding.INSTANCE;

    @JRubyMethod(name={"strict?"}, module=true)
    public static IRubyObject strict(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newBoolean(true);
    }

    byte[] fetchBytes(ByteBuffer byteBuffer, int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = byteBuffer.position();
        byteBuffer.position(n);
        byteBuffer.get(byArray);
        byteBuffer.position(n3);
        return byArray;
    }

    public RubyHttpParser(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.runtime = ruby;
        this.eParserError = (RubyClass)ruby.getModule("HTTP").getClass("Parser").getConstant("Error");
        this.on_message_begin = null;
        this.on_headers_complete = null;
        this.on_body = null;
        this.on_message_complete = null;
        this.callback_object = null;
        this.completed = false;
        this.header_value_type = ruby.getModule("HTTP").getClass("Parser").getInstanceVariable("@default_header_value_type");
        this.initSettings();
        this.init();
    }

    private void initSettings() {
        this.settings = new ParserSettings();
        this.settings.on_url = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                byte[] byArray = RubyHttpParser.this.fetchBytes(byteBuffer, n, n2);
                if (RubyHttpParser.this.runtime.is1_9() || RubyHttpParser.this.runtime.is2_0()) {
                    ((RubyString)RubyHttpParser.this.requestUrl).cat(byArray, 0, byArray.length, UTF8);
                } else {
                    ((RubyString)RubyHttpParser.this.requestUrl).cat(byArray);
                }
                return 0;
            }
        };
        this.settings.on_header_field = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                byte[] byArray = RubyHttpParser.this.fetchBytes(byteBuffer, n, n2);
                if (RubyHttpParser.this._current_header == null) {
                    RubyHttpParser.access$302(RubyHttpParser.this, byArray);
                } else {
                    byte[] byArray2 = new byte[RubyHttpParser.this._current_header.length + byArray.length];
                    System.arraycopy(RubyHttpParser.this._current_header, 0, byArray2, 0, RubyHttpParser.this._current_header.length);
                    System.arraycopy(byArray, 0, byArray2, RubyHttpParser.this._current_header.length, byArray.length);
                    RubyHttpParser.access$302(RubyHttpParser.this, byArray2);
                }
                return 0;
            }
        };
        final RubySymbol rubySymbol = this.runtime.newSymbol("arrays");
        final RubySymbol rubySymbol2 = this.runtime.newSymbol("mixed");
        final RubySymbol rubySymbol3 = this.runtime.newSymbol("stop");
        final RubySymbol rubySymbol4 = this.runtime.newSymbol("reset");
        this.settings.on_header_value = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                byte[] byArray = RubyHttpParser.this.fetchBytes(byteBuffer, n, n2);
                ThreadContext threadContext = RubyHttpParser.this.headers.getRuntime().getCurrentContext();
                boolean bl = false;
                if (RubyHttpParser.this._current_header != null) {
                    bl = true;
                    RubyHttpParser.access$502(RubyHttpParser.this, RubyHttpParser.this._current_header);
                    RubyHttpParser.access$302(RubyHttpParser.this, null);
                }
                RubyString rubyString = RubyString.newString((Ruby)RubyHttpParser.this.runtime, (ByteList)new ByteList(RubyHttpParser.this._last_header, UTF8, false));
                IRubyObject iRubyObject = RubyHttpParser.this.headers.op_aref(threadContext, (IRubyObject)rubyString);
                if (bl) {
                    if (iRubyObject.isNil()) {
                        if (RubyHttpParser.this.header_value_type == rubySymbol) {
                            RubyHttpParser.this.headers.op_aset(threadContext, (IRubyObject)rubyString, (IRubyObject)RubyArray.newArrayLight((Ruby)RubyHttpParser.this.runtime, (IRubyObject)RubyString.newStringLight((Ruby)RubyHttpParser.this.runtime, (int)10, (Encoding)UTF8)));
                        } else {
                            RubyHttpParser.this.headers.op_aset(threadContext, (IRubyObject)rubyString, (IRubyObject)RubyString.newStringLight((Ruby)RubyHttpParser.this.runtime, (int)10, (Encoding)UTF8));
                        }
                    } else if (RubyHttpParser.this.header_value_type == rubySymbol2) {
                        if (iRubyObject instanceof RubyString) {
                            RubyHttpParser.this.headers.op_aset(threadContext, (IRubyObject)rubyString, (IRubyObject)RubyArray.newArrayLight((Ruby)RubyHttpParser.this.runtime, (IRubyObject[])new IRubyObject[]{iRubyObject, RubyString.newStringLight((Ruby)RubyHttpParser.this.runtime, (int)10, (Encoding)UTF8)}));
                        } else {
                            ((RubyArray)iRubyObject).add((Object)RubyString.newStringLight((Ruby)RubyHttpParser.this.runtime, (int)10, (Encoding)UTF8));
                        }
                    } else if (RubyHttpParser.this.header_value_type == rubySymbol) {
                        ((RubyArray)iRubyObject).add((Object)RubyString.newStringLight((Ruby)RubyHttpParser.this.runtime, (int)10, (Encoding)UTF8));
                    } else if (RubyHttpParser.this.runtime.is1_9() || RubyHttpParser.this.runtime.is2_0()) {
                        ((RubyString)iRubyObject).cat(44, UTF8).cat(32, UTF8);
                    } else {
                        ((RubyString)iRubyObject).cat(44).cat(32);
                    }
                    iRubyObject = RubyHttpParser.this.headers.op_aref(threadContext, (IRubyObject)rubyString);
                }
                if (iRubyObject instanceof RubyArray) {
                    iRubyObject = ((RubyArray)iRubyObject).entry(-1);
                }
                if (RubyHttpParser.this.runtime.is1_9() || RubyHttpParser.this.runtime.is2_0()) {
                    ((RubyString)iRubyObject).cat(byArray, 0, byArray.length, UTF8);
                } else {
                    ((RubyString)iRubyObject).cat(byArray);
                }
                return 0;
            }
        };
        this.settings.on_message_begin = new HTTPCallback(){

            public int cb(HTTPParser hTTPParser) {
                RubyHttpParser.this.headers = new RubyHash(RubyHttpParser.this.runtime);
                if (RubyHttpParser.this.runtime.is1_9() || RubyHttpParser.this.runtime.is2_0()) {
                    RubyHttpParser.this.requestUrl = (IRubyObject)RubyString.newEmptyString((Ruby)RubyHttpParser.this.runtime, (Encoding)UTF8);
                    RubyHttpParser.this.requestPath = (IRubyObject)RubyString.newEmptyString((Ruby)RubyHttpParser.this.runtime, (Encoding)UTF8);
                    RubyHttpParser.this.queryString = (IRubyObject)RubyString.newEmptyString((Ruby)RubyHttpParser.this.runtime, (Encoding)UTF8);
                    RubyHttpParser.this.fragment = (IRubyObject)RubyString.newEmptyString((Ruby)RubyHttpParser.this.runtime, (Encoding)UTF8);
                    RubyHttpParser.this.upgradeData = (IRubyObject)RubyString.newEmptyString((Ruby)RubyHttpParser.this.runtime, (Encoding)UTF8);
                } else {
                    RubyHttpParser.this.requestUrl = (IRubyObject)RubyString.newEmptyString((Ruby)RubyHttpParser.this.runtime);
                    RubyHttpParser.this.requestPath = (IRubyObject)RubyString.newEmptyString((Ruby)RubyHttpParser.this.runtime);
                    RubyHttpParser.this.queryString = (IRubyObject)RubyString.newEmptyString((Ruby)RubyHttpParser.this.runtime);
                    RubyHttpParser.this.fragment = (IRubyObject)RubyString.newEmptyString((Ruby)RubyHttpParser.this.runtime);
                    RubyHttpParser.this.upgradeData = (IRubyObject)RubyString.newEmptyString((Ruby)RubyHttpParser.this.runtime);
                }
                IRubyObject iRubyObject = RubyHttpParser.this.runtime.getNil();
                if (RubyHttpParser.this.callback_object != null) {
                    if (((RubyObject)RubyHttpParser.this.callback_object).respondsTo("on_message_begin")) {
                        ThreadContext threadContext = RubyHttpParser.this.callback_object.getRuntime().getCurrentContext();
                        iRubyObject = RubyHttpParser.this.callback_object.callMethod(threadContext, "on_message_begin");
                    }
                } else if (RubyHttpParser.this.on_message_begin != null) {
                    ThreadContext threadContext = RubyHttpParser.this.on_message_begin.getRuntime().getCurrentContext();
                    iRubyObject = RubyHttpParser.this.on_message_begin.callMethod(threadContext, "call");
                }
                if (iRubyObject == rubySymbol3) {
                    throw new StopException();
                }
                return 0;
            }
        };
        this.settings.on_message_complete = new HTTPCallback(){

            public int cb(HTTPParser hTTPParser) {
                IRubyObject iRubyObject = RubyHttpParser.this.runtime.getNil();
                RubyHttpParser.this.completed = true;
                if (RubyHttpParser.this.callback_object != null) {
                    if (((RubyObject)RubyHttpParser.this.callback_object).respondsTo("on_message_complete")) {
                        ThreadContext threadContext = RubyHttpParser.this.callback_object.getRuntime().getCurrentContext();
                        iRubyObject = RubyHttpParser.this.callback_object.callMethod(threadContext, "on_message_complete");
                    }
                } else if (RubyHttpParser.this.on_message_complete != null) {
                    ThreadContext threadContext = RubyHttpParser.this.on_message_complete.getRuntime().getCurrentContext();
                    iRubyObject = RubyHttpParser.this.on_message_complete.callMethod(threadContext, "call");
                }
                if (iRubyObject == rubySymbol3) {
                    throw new StopException();
                }
                return 0;
            }
        };
        this.settings.on_headers_complete = new HTTPCallback(){

            public int cb(HTTPParser hTTPParser) {
                IRubyObject iRubyObject = RubyHttpParser.this.runtime.getNil();
                if (RubyHttpParser.this.callback_object != null) {
                    if (((RubyObject)RubyHttpParser.this.callback_object).respondsTo("on_headers_complete")) {
                        ThreadContext threadContext = RubyHttpParser.this.callback_object.getRuntime().getCurrentContext();
                        iRubyObject = RubyHttpParser.this.callback_object.callMethod(threadContext, "on_headers_complete", (IRubyObject)RubyHttpParser.this.headers);
                    }
                } else if (RubyHttpParser.this.on_headers_complete != null) {
                    ThreadContext threadContext = RubyHttpParser.this.on_headers_complete.getRuntime().getCurrentContext();
                    iRubyObject = RubyHttpParser.this.on_headers_complete.callMethod(threadContext, "call", (IRubyObject)RubyHttpParser.this.headers);
                }
                if (iRubyObject == rubySymbol3) {
                    throw new StopException();
                }
                if (iRubyObject == rubySymbol4) {
                    return 1;
                }
                return 0;
            }
        };
        this.settings.on_body = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                IRubyObject iRubyObject = RubyHttpParser.this.runtime.getNil();
                byte[] byArray = RubyHttpParser.this.fetchBytes(byteBuffer, n, n2);
                if (RubyHttpParser.this.callback_object != null) {
                    if (((RubyObject)RubyHttpParser.this.callback_object).respondsTo("on_body")) {
                        ThreadContext threadContext = RubyHttpParser.this.callback_object.getRuntime().getCurrentContext();
                        iRubyObject = RubyHttpParser.this.callback_object.callMethod(threadContext, "on_body", (IRubyObject)RubyString.newString((Ruby)RubyHttpParser.this.runtime, (ByteList)new ByteList(byArray, UTF8, false)));
                    }
                } else if (RubyHttpParser.this.on_body != null) {
                    ThreadContext threadContext = RubyHttpParser.this.on_body.getRuntime().getCurrentContext();
                    iRubyObject = RubyHttpParser.this.on_body.callMethod(threadContext, "call", (IRubyObject)RubyString.newString((Ruby)RubyHttpParser.this.runtime, (ByteList)new ByteList(byArray, UTF8, false)));
                }
                if (iRubyObject == rubySymbol3) {
                    throw new StopException();
                }
                return 0;
            }
        };
    }

    private void init() {
        this.parser = new http_parser.HTTPParser();
        this.parser.HTTP_PARSER_STRICT = true;
        this.headers = null;
        this.requestUrl = this.runtime.getNil();
        this.requestPath = this.runtime.getNil();
        this.queryString = this.runtime.getNil();
        this.fragment = this.runtime.getNil();
        this.upgradeData = this.runtime.getNil();
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize() {
        return this;
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(IRubyObject iRubyObject) {
        this.callback_object = iRubyObject;
        return this.initialize();
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.header_value_type = iRubyObject2;
        return this.initialize(iRubyObject);
    }

    @JRubyMethod(name={"on_message_begin="})
    public IRubyObject set_on_message_begin(IRubyObject iRubyObject) {
        this.on_message_begin = iRubyObject;
        return iRubyObject;
    }

    @JRubyMethod(name={"on_headers_complete="})
    public IRubyObject set_on_headers_complete(IRubyObject iRubyObject) {
        this.on_headers_complete = iRubyObject;
        return iRubyObject;
    }

    @JRubyMethod(name={"on_body="})
    public IRubyObject set_on_body(IRubyObject iRubyObject) {
        this.on_body = iRubyObject;
        return iRubyObject;
    }

    @JRubyMethod(name={"on_message_complete="})
    public IRubyObject set_on_message_complete(IRubyObject iRubyObject) {
        this.on_message_complete = iRubyObject;
        return iRubyObject;
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject execute(IRubyObject iRubyObject) {
        RubyString rubyString = (RubyString)iRubyObject;
        ByteList byteList = rubyString.getByteList();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize());
        boolean bl = false;
        try {
            this.parser.execute(this.settings, byteBuffer);
        }
        catch (HTTPException hTTPException) {
            throw new RaiseException(this.runtime, this.eParserError, hTTPException.getMessage(), true);
        }
        catch (StopException stopException) {
            bl = true;
        }
        if (this.parser.getUpgrade()) {
            byte[] byArray = this.fetchBytes(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
            if (this.runtime.is1_9() || this.runtime.is2_0()) {
                ((RubyString)this.upgradeData).cat(byArray, 0, byArray.length, UTF8);
            } else {
                ((RubyString)this.upgradeData).cat(byArray);
            }
        } else if (byteBuffer.hasRemaining() && !this.completed && !bl) {
            throw new RaiseException(this.runtime, this.eParserError, "Could not parse data entirely", true);
        }
        return RubyNumeric.int2fix((Ruby)this.runtime, (long)byteBuffer.position());
    }

    @JRubyMethod(name={"keep_alive?"})
    public IRubyObject shouldKeepAlive() {
        return this.runtime.newBoolean(this.parser.shouldKeepAlive());
    }

    @JRubyMethod(name={"upgrade?"})
    public IRubyObject shouldUpgrade() {
        return this.runtime.newBoolean(this.parser.getUpgrade());
    }

    @JRubyMethod(name={"http_major"})
    public IRubyObject httpMajor() {
        if (this.parser.getMajor() == 0 && this.parser.getMinor() == 0) {
            return this.runtime.getNil();
        }
        return RubyNumeric.int2fix((Ruby)this.runtime, (long)this.parser.getMajor());
    }

    @JRubyMethod(name={"http_minor"})
    public IRubyObject httpMinor() {
        if (this.parser.getMajor() == 0 && this.parser.getMinor() == 0) {
            return this.runtime.getNil();
        }
        return RubyNumeric.int2fix((Ruby)this.runtime, (long)this.parser.getMinor());
    }

    @JRubyMethod(name={"http_version"})
    public IRubyObject httpVersion() {
        if (this.parser.getMajor() == 0 && this.parser.getMinor() == 0) {
            return this.runtime.getNil();
        }
        return this.runtime.newArray(this.httpMajor(), this.httpMinor());
    }

    @JRubyMethod(name={"http_method"})
    public IRubyObject httpMethod() {
        HTTPMethod hTTPMethod = this.parser.getHTTPMethod();
        if (hTTPMethod != null) {
            return this.runtime.newString(new String(hTTPMethod.bytes));
        }
        return this.runtime.getNil();
    }

    @JRubyMethod(name={"status_code"})
    public IRubyObject statusCode() {
        int n = this.parser.getStatusCode();
        if (n != 0) {
            return RubyNumeric.int2fix((Ruby)this.runtime, (long)n);
        }
        return this.runtime.getNil();
    }

    @JRubyMethod(name={"headers"})
    public IRubyObject getHeaders() {
        return this.headers == null ? this.runtime.getNil() : this.headers;
    }

    @JRubyMethod(name={"request_url"})
    public IRubyObject getRequestUrl() {
        return this.requestUrl == null ? this.runtime.getNil() : this.requestUrl;
    }

    @JRubyMethod(name={"request_path"})
    public IRubyObject getRequestPath() {
        return this.requestPath == null ? this.runtime.getNil() : this.requestPath;
    }

    @JRubyMethod(name={"query_string"})
    public IRubyObject getQueryString() {
        return this.queryString == null ? this.runtime.getNil() : this.queryString;
    }

    @JRubyMethod(name={"fragment"})
    public IRubyObject getFragment() {
        return this.fragment == null ? this.runtime.getNil() : this.fragment;
    }

    @JRubyMethod(name={"header_value_type"})
    public IRubyObject getHeaderValueType() {
        return this.header_value_type == null ? this.runtime.getNil() : this.header_value_type;
    }

    @JRubyMethod(name={"header_value_type="})
    public IRubyObject set_header_value_type(IRubyObject iRubyObject) {
        String string = iRubyObject.toString();
        if (string != "mixed" && string != "arrays" && string != "strings") {
            throw this.runtime.newArgumentError("Invalid header value type");
        }
        this.header_value_type = iRubyObject;
        return iRubyObject;
    }

    @JRubyMethod(name={"upgrade_data"})
    public IRubyObject upgradeData() {
        return this.upgradeData == null ? this.runtime.getNil() : this.upgradeData;
    }

    @JRubyMethod(name={"reset!"})
    public IRubyObject reset() {
        this.init();
        return this.runtime.getTrue();
    }

    static /* synthetic */ byte[] access$302(RubyHttpParser rubyHttpParser, byte[] byArray) {
        rubyHttpParser._current_header = byArray;
        return byArray;
    }

    static /* synthetic */ byte[] access$502(RubyHttpParser rubyHttpParser, byte[] byArray) {
        rubyHttpParser._last_header = byArray;
        return byArray;
    }

    public class StopException
    extends RuntimeException {
    }
}

