/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals.c14n;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nokogiri.internals.c14n.CanonicalizationException;
import nokogiri.internals.c14n.HelperNodeList;
import nokogiri.internals.c14n.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class ElementProxy {
    protected Element constructionElement = null;
    protected String baseURI = null;
    protected Document doc = null;
    private static Map<String, String> prefixMappings = new ConcurrentHashMap<String, String>();

    public ElementProxy() {
    }

    public ElementProxy(Document document) {
        if (document == null) {
            throw new RuntimeException("Document is null");
        }
        this.doc = document;
        this.constructionElement = this.createElementForFamilyLocal(this.doc, this.getBaseNamespace(), this.getBaseLocalName());
    }

    public ElementProxy(Element element, String string) throws CanonicalizationException {
        if (element == null) {
            throw new CanonicalizationException("ElementProxy.nullElement");
        }
        this.doc = element.getOwnerDocument();
        this.constructionElement = element;
        this.baseURI = string;
        this.guaranteeThatElementInCorrectSpace();
    }

    public abstract String getBaseNamespace();

    public abstract String getBaseLocalName();

    protected Element createElementForFamilyLocal(Document document, String string, String string2) {
        Element element;
        if (string == null) {
            element = document.createElementNS(null, string2);
        } else {
            String string3 = this.getBaseNamespace();
            String string4 = ElementProxy.getDefaultPrefix(string3);
            if (string4 == null || string4.length() == 0) {
                element = document.createElementNS(string, string2);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string);
            } else {
                element = document.createElementNS(string, string4 + ":" + string2);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string4, string);
            }
        }
        return element;
    }

    public static Element createElementForFamily(Document document, String string, String string2) {
        Element element;
        String string3 = ElementProxy.getDefaultPrefix(string);
        if (string == null) {
            element = document.createElementNS(null, string2);
        } else if (string3 == null || string3.length() == 0) {
            element = document.createElementNS(string, string2);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string);
        } else {
            element = document.createElementNS(string, string3 + ":" + string2);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string3, string);
        }
        return element;
    }

    public final Element getElement() {
        return this.constructionElement;
    }

    public final NodeList getElementPlusReturns() {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(this.doc.createTextNode("\n"));
        helperNodeList.appendChild(this.getElement());
        helperNodeList.appendChild(this.doc.createTextNode("\n"));
        return helperNodeList;
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    void guaranteeThatElementInCorrectSpace() throws CanonicalizationException {
        String string = this.getBaseLocalName();
        String string2 = this.getBaseNamespace();
        String string3 = this.constructionElement.getLocalName();
        String string4 = this.constructionElement.getNamespaceURI();
        if (!string2.equals(string4) && !string.equals(string3)) {
            Object[] objectArray = new Object[]{string4 + ":" + string3, string2 + ":" + string};
            throw new CanonicalizationException("xml.WrongElement", objectArray);
        }
    }

    public void addText(String string) {
        if (string != null) {
            Text text = this.doc.createTextNode(string);
            this.constructionElement.appendChild(text);
        }
    }

    public String getTextFromChildElement(String string, String string2) {
        return XMLUtils.selectNode(this.constructionElement.getFirstChild(), string2, string, 0).getTextContent();
    }

    public String getTextFromTextChild() {
        return XMLUtils.getFullTextChildrenFromElement(this.constructionElement);
    }

    public int length(String string, String string2) {
        int n = 0;
        for (Node node = this.constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!string2.equals(node.getLocalName()) || !string.equals(node.getNamespaceURI())) continue;
            ++n;
        }
        return n;
    }

    public static String getDefaultPrefix(String string) {
        return prefixMappings.get(string);
    }
}

