/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.sax;

import com.thaiopensource.util.Uri;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import com.thaiopensource.xml.sax.ResolverInstantiationException;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Resolver
implements XMLReaderCreator {
    private final URIResolver uriResolver;
    private final URIResolver uriResolverWrapper;
    private final EntityResolver entityResolver;
    private final XMLReaderCreator xrc;

    private Resolver(XMLReaderCreator xMLReaderCreator, URIResolver uRIResolver, EntityResolver entityResolver) {
        this.xrc = xMLReaderCreator == null ? new Jaxp11XMLReaderCreator() : xMLReaderCreator;
        this.entityResolver = entityResolver;
        this.uriResolver = uRIResolver;
        this.uriResolverWrapper = new URIResolverImpl();
    }

    @Override
    public XMLReader createXMLReader() throws SAXException {
        XMLReader xMLReader = this.xrc.createXMLReader();
        if (this.entityResolver != null) {
            xMLReader.setEntityResolver(this.entityResolver);
        }
        return xMLReader;
    }

    public SAXSource resolve(String string, String string2) throws IOException, SAXException {
        Source source = null;
        if (this.uriResolver != null) {
            try {
                source = this.uriResolver.resolve(string, string2);
            }
            catch (TransformerException transformerException) {
                Throwable throwable = transformerException.getException();
                if (throwable.getMessage() == null || throwable.getMessage().equals(transformerException.getMessage())) {
                    if (throwable instanceof SAXException) {
                        throw (SAXException)throwable;
                    }
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    if (throwable instanceof Exception) {
                        throw new SAXException((Exception)throwable);
                    }
                }
                throw new SAXException(transformerException);
            }
        }
        return this.resolveFinish(source, string, string2);
    }

    private SAXSource resolveFinish(Source source, String string, String string2) throws IOException, SAXException {
        String string3;
        InputSource inputSource;
        SAXSource sAXSource = null;
        if (source != null) {
            if (source instanceof SAXSource) {
                sAXSource = (SAXSource)source;
            } else {
                inputSource = SAXSource.sourceToInputSource(source);
                if (inputSource == null) {
                    string3 = source.getSystemId();
                    inputSource = new InputSource(string3);
                }
                sAXSource = new SAXSource(inputSource);
            }
        }
        if (sAXSource == null) {
            inputSource = null;
            string3 = Uri.resolve(string2, string);
            if (this.uriResolver == null && this.entityResolver != null) {
                inputSource = this.entityResolver.resolveEntity(null, string3);
            }
            if (inputSource == null) {
                inputSource = new InputSource(string3);
            }
            sAXSource = new SAXSource(inputSource);
        }
        return sAXSource;
    }

    public URIResolver getURIResolver() {
        return this.uriResolverWrapper;
    }

    public InputSource open(InputSource inputSource) throws IOException, SAXException {
        if (inputSource.getCharacterStream() != null || inputSource.getByteStream() != null) {
            return inputSource;
        }
        String string = inputSource.getSystemId();
        if (string == null) {
            throw new IllegalArgumentException("byteStream, charStream and systemId of the InputSource are all null");
        }
        String string2 = Uri.escapeDisallowedChars(string);
        URL uRL = new URL(string2);
        InputSource inputSource2 = new InputSource(string);
        inputSource2.setPublicId(inputSource.getPublicId());
        inputSource2.setEncoding(inputSource.getEncoding());
        inputSource2.setByteStream(uRL.openStream());
        return inputSource2;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public static Resolver newInstance() {
        return new Resolver(null, null, null);
    }

    public static Resolver newInstance(URIResolver uRIResolver) {
        return new Resolver(null, uRIResolver, null);
    }

    public static Resolver newInstance(EntityResolver entityResolver) {
        return new Resolver(null, null, entityResolver);
    }

    public static Resolver newInstance(URIResolver uRIResolver, EntityResolver entityResolver) {
        return new Resolver(null, uRIResolver, entityResolver);
    }

    public static Resolver newInstance(XMLReaderCreator xMLReaderCreator, URIResolver uRIResolver, EntityResolver entityResolver) {
        return new Resolver(xMLReaderCreator, uRIResolver, entityResolver);
    }

    public static Resolver newInstance(String string, ClassLoader classLoader) throws ResolverInstantiationException {
        Object obj;
        try {
            if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null && (classLoader = ClassLoader.getSystemClassLoader()) == null) {
                throw new ResolverInstantiationException("no class loader");
            }
            obj = classLoader.loadClass(string).newInstance();
        }
        catch (Exception exception) {
            throw new ResolverInstantiationException(exception);
        }
        if (obj instanceof Resolver) {
            return (Resolver)obj;
        }
        EntityResolver entityResolver = null;
        URIResolver uRIResolver = null;
        if (obj instanceof EntityResolver) {
            entityResolver = (EntityResolver)obj;
        }
        if (obj instanceof URIResolver) {
            uRIResolver = (URIResolver)obj;
        }
        if (entityResolver == null && uRIResolver == null) {
            throw new ResolverInstantiationException(string + " not an instance of javax.xml.transform.URIResolver, org.xml.sax.EntityResolver or com.thaiopensource.xml.sax.Resolver");
        }
        return new Resolver(null, uRIResolver, entityResolver);
    }

    private class URIResolverImpl
    implements URIResolver {
        private URIResolverImpl() {
        }

        @Override
        public Source resolve(String string, String string2) throws TransformerException {
            Source source = null;
            if (Resolver.this.uriResolver != null) {
                source = Resolver.this.uriResolver.resolve(string, string2);
            }
            try {
                SAXSource sAXSource = Resolver.this.resolveFinish(source, string, string2);
                if (sAXSource.getXMLReader() == null) {
                    sAXSource = new SAXSource(Resolver.this.createXMLReader(), sAXSource.getInputSource());
                }
                return sAXSource;
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
        }
    }
}

