/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.shared.common.sanity.SanityManager;

final class ClobUpdatableReader
extends Reader {
    private Reader streamReader;
    private long pos;
    private long lastUpdateCount = -1L;
    private final EmbedClob clob;
    private InternalClob iClob;
    private final long maxPos;
    private volatile boolean closed = false;

    public ClobUpdatableReader(EmbedClob clob) throws IOException, SQLException {
        this(clob, 1L, Long.MAX_VALUE);
    }

    public ClobUpdatableReader(EmbedClob clob, long initialPos, long length) throws IOException, SQLException {
        SanityManager.ASSERT((initialPos > 0L ? 1 : 0) != 0);
        SanityManager.ASSERT((length > 0L ? 1 : 0) != 0);
        this.clob = clob;
        this.iClob = clob.getInternalClob();
        this.pos = initialPos;
        long tmpMaxPos = initialPos + length;
        if (tmpMaxPos < length || tmpMaxPos < initialPos) {
            tmpMaxPos = Long.MAX_VALUE;
        }
        this.maxPos = tmpMaxPos;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        if (this.pos >= this.maxPos) {
            return -1;
        }
        this.updateReaderIfRequired();
        int retVal = this.streamReader.read();
        if (retVal > 0) {
            ++this.pos;
        }
        return retVal;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        if (this.pos >= this.maxPos) {
            return -1;
        }
        this.updateReaderIfRequired();
        int adjustedLen = (int)Math.min((long)len, this.maxPos - this.pos);
        int readCount = this.streamReader.read(cbuf, off, adjustedLen);
        if (readCount > 0) {
            this.pos += (long)readCount;
        }
        return readCount;
    }

    @Override
    public long skip(long len) throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        if (this.pos >= this.maxPos) {
            return 0L;
        }
        this.updateReaderIfRequired();
        long adjustedLen = Math.min(len, this.maxPos - this.pos);
        long skipped = this.streamReader.skip(adjustedLen);
        if (skipped > 0L) {
            this.pos += skipped;
        }
        return skipped;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.streamReader != null) {
                this.streamReader.close();
            }
        }
    }

    private void updateReaderIfRequired() throws IOException {
        if (this.iClob.isReleased()) {
            this.iClob = this.clob.getInternalClob();
            this.lastUpdateCount = -1L;
            if (this.iClob.isReleased()) {
                this.close();
                return;
            }
        }
        if (this.lastUpdateCount != this.iClob.getUpdateCount()) {
            this.lastUpdateCount = this.iClob.getUpdateCount();
            try {
                this.streamReader = this.iClob.getReader(this.pos);
            }
            catch (SQLException sqle) {
                throw new IOException(sqle.getMessage());
            }
        }
    }
}

