/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.SystemAggregator;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class OrderableAggregator
extends SystemAggregator {
    protected DataValueDescriptor value;

    OrderableAggregator() {
    }

    @Override
    public void setup(ClassFactory cf, String aggregateName, DataTypeDescriptor returnDataType) {
    }

    @Override
    public void merge(ExecAggregator addend) throws StandardException {
        SanityManager.ASSERT((boolean)(addend instanceof OrderableAggregator), (String)"addend is supposed to be the same type of aggregator for the merge operator");
        DataValueDescriptor bv = ((OrderableAggregator)addend).value;
        if (bv != null) {
            this.accumulate(bv);
        }
    }

    @Override
    public DataValueDescriptor getResult() throws StandardException {
        return this.value;
    }

    @Override
    public String toString() {
        try {
            return "OrderableAggregator: " + this.value.getString();
        }
        catch (StandardException e) {
            return super.toString() + ":" + e.getMessage();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.value = (DataValueDescriptor)in.readObject();
    }
}

