/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.google.common.hash.Hashing;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.net.NetworkInterface;
import java.util.Enumeration;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public abstract class AzureServiceClient
extends ServiceClient {
    private static final String MAC_ADDRESS_HASH;
    private static final String OS;
    private static final String JAVA_VERSION;

    protected AzureServiceClient(String baseUrl, ServiceClientCredentials credentials) {
        this(baseUrl, credentials, new OkHttpClient.Builder(), new Retrofit.Builder());
    }

    protected AzureServiceClient(String baseUrl, ServiceClientCredentials credentials, OkHttpClient.Builder clientBuilder, Retrofit.Builder restBuilder) {
        this(new RestClient.Builder(clientBuilder, restBuilder).withBaseUrl(baseUrl).withCredentials(credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).build());
    }

    protected AzureServiceClient(RestClient restClient) {
        super(restClient);
    }

    public String userAgent() {
        return String.format("Azure-SDK-For-Java/%s OS:%s MacAddressHash:%s Java:%s", ((Object)((Object)this)).getClass().getPackage().getImplementationVersion(), OS, MAC_ADDRESS_HASH, JAVA_VERSION);
    }

    static {
        OS = System.getProperty("os.name") + "/" + System.getProperty("os.version");
        String macAddress = "Unknown";
        try {
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                NetworkInterface network = networks.nextElement();
                byte[] mac = network.getHardwareAddress();
                if (mac == null) continue;
                macAddress = Hashing.sha256().hashBytes(mac).toString();
                break;
            }
        }
        catch (Throwable networks) {
            // empty catch block
        }
        MAC_ADDRESS_HASH = macAddress;
        String version = System.getProperty("java.version");
        JAVA_VERSION = version != null ? version : "Unknown";
    }
}

