/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class GpsmtaProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().expression("([^ ]+) ").number("(d+) ").number("(-?d+.d+) ").number("(-?d+.d+) ").number("(d+) ").number("(d+) ").number("(d+) ").number("(d+) ").number("(d+) ").number("(d+) ").number("(d+) ").number("(d)").any().compile();

    public GpsmtaProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        String time = parser.next();
        position.setTime(new Date(Long.parseLong(time) * 1000L));
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setSpeed(parser.nextInt().intValue());
        position.setCourse(parser.nextInt().intValue());
        position.setAccuracy(parser.nextInt().intValue());
        position.setAltitude(parser.nextInt().intValue());
        position.set("status", parser.nextInt());
        position.set("batteryLevel", parser.nextInt());
        position.set("temp1", parser.nextInt());
        position.set("charge", parser.nextInt() == 1);
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(time, remoteAddress));
        }
        return position;
    }
}

