/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.Container;

public class ComponentMaximiser {
    private final Container container;
    private Component containerChild;
    private Container parentMaximisedComponent;
    private Component maximisedComponent;

    public ComponentMaximiser(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("Parameter container must not be null.");
        }
        this.container = container;
    }

    public void maximiseComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Parameter component must not be null.");
        }
        if (this.maximisedComponent != null) {
            return;
        }
        this.maximisedComponent = component;
        this.parentMaximisedComponent = component.getParent();
        this.containerChild = this.container.getComponent(0);
        this.parentMaximisedComponent.remove(component);
        this.container.remove(this.containerChild);
        this.container.add(component);
        this.container.validate();
    }

    public void unmaximiseComponent() {
        if (this.maximisedComponent == null) {
            return;
        }
        this.container.remove(this.maximisedComponent);
        this.container.add(this.containerChild);
        this.parentMaximisedComponent.add(this.maximisedComponent);
        this.container.validate();
        this.containerChild = null;
        this.parentMaximisedComponent = null;
        this.maximisedComponent = null;
    }

    public boolean isComponentMaximised() {
        return this.maximisedComponent != null;
    }

    public Component getMaximisedComponent() {
        return this.maximisedComponent;
    }
}

