/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.ControlTransfer;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.JavaClassLoader;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.MemoryClassLoader;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public abstract class Function
extends Operator
implements Serializable {
    private LispObject propertyList = Lisp.NIL;
    private int callCount;
    private int hotCount;
    public final LispObject loadedFrom;
    public static final Primitive FUNCTION_CLASS_BYTES = new pf_function_class_bytes();
    private static final ThreadLocal<Boolean> serializingClosure = new ThreadLocal();

    protected Function() {
        LispObject loadTruename = Symbol.LOAD_TRUENAME.symbolValueNoThrow();
        LispObject loadTruenameFasl = Symbol.LOAD_TRUENAME_FASL.symbolValueNoThrow();
        this.loadedFrom = loadTruenameFasl != null ? loadTruenameFasl : (loadTruename != null ? loadTruename : Lisp.NIL);
    }

    public Function(String name) {
        this(name, (String)null);
    }

    public Function(String name, String arglist2) {
        this();
        if (arglist2 != null) {
            this.setLambdaList(new SimpleString(arglist2));
        }
        if (name != null) {
            Symbol symbol = Symbol.addFunction(name.toUpperCase(), this);
            if (Lisp.cold) {
                symbol.setBuiltInFunction(true);
            }
            this.setLambdaName(symbol);
        }
    }

    public Function(Symbol symbol) {
        this(symbol, null, null);
    }

    public Function(Symbol symbol, String arglist2) {
        this(symbol, arglist2, null);
    }

    public Function(Symbol symbol, String arglist2, String docstring) {
        this();
        symbol.setSymbolFunction(this);
        if (Lisp.cold) {
            symbol.setBuiltInFunction(true);
        }
        this.setLambdaName(symbol);
        if (arglist2 != null) {
            this.setLambdaList(new SimpleString(arglist2));
        }
        if (docstring != null) {
            symbol.setDocumentation(Symbol.FUNCTION, new SimpleString(docstring));
        }
    }

    public Function(String name, Package pkg) {
        this(name, pkg, false);
    }

    public Function(String name, Package pkg, boolean exported) {
        this(name, pkg, exported, null, null);
    }

    public Function(String name, Package pkg, boolean exported, String arglist2) {
        this(name, pkg, exported, arglist2, null);
    }

    public Function(String name, Package pkg, boolean exported, String arglist2, String docstring) {
        this();
        if (arglist2 instanceof String) {
            this.setLambdaList(new SimpleString(arglist2));
        }
        if (name != null) {
            Symbol symbol = exported ? pkg.internAndExport(name.toUpperCase()) : pkg.intern(name.toUpperCase());
            symbol.setSymbolFunction(this);
            if (Lisp.cold) {
                symbol.setBuiltInFunction(true);
            }
            this.setLambdaName(symbol);
            if (docstring != null) {
                symbol.setDocumentation(Symbol.FUNCTION, new SimpleString(docstring));
            }
        }
    }

    public Function(LispObject name) {
        this();
        this.setLambdaName(name);
    }

    public Function(LispObject name, LispObject lambdaList) {
        this();
        this.setLambdaName(name);
        this.setLambdaList(lambdaList);
    }

    @Override
    public LispObject typeOf() {
        return Symbol.FUNCTION;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.FUNCTION;
    }

    @Override
    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.FUNCTION) {
            return Lisp.T;
        }
        if (typeSpecifier == Symbol.COMPILED_FUNCTION) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.FUNCTION) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    @Override
    public final LispObject getPropertyList() {
        if (this.propertyList == null) {
            this.propertyList = Lisp.NIL;
        }
        return this.propertyList;
    }

    @Override
    public final void setPropertyList(LispObject obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        this.propertyList = obj;
    }

    public final void setClassBytes(byte[] bytes) {
        this.propertyList = Lisp.putf(this.propertyList, Symbol.CLASS_BYTES, new JavaObject(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LispObject getClassBytes() {
        LispObject o = Lisp.getf(this.propertyList, Symbol.CLASS_BYTES, Lisp.NIL);
        if (o != Lisp.NIL) {
            return o;
        }
        ClassLoader c = this.getClass().getClassLoader();
        if (c instanceof JavaClassLoader) {
            LispThread thread = LispThread.currentThread();
            SpecialBindingsMark mark = thread.markSpecialBindings();
            try {
                thread.bindSpecial(Symbol.LOAD_TRUENAME, this.loadedFrom);
                JavaObject javaObject = new JavaObject(((JavaClassLoader)c).getFunctionClassBytes(this));
                return javaObject;
            }
            catch (Throwable t) {
                if (t instanceof ControlTransfer) {
                    throw (ControlTransfer)t;
                }
                Symbol symbol = Lisp.NIL;
                return symbol;
            }
            finally {
                thread.resetSpecialBindings(mark);
            }
        }
        return Lisp.NIL;
    }

    @Override
    public LispObject execute() {
        return Lisp.error(new WrongNumberOfArgumentsException(this, 0));
    }

    @Override
    public LispObject execute(LispObject arg) {
        return Lisp.error(new WrongNumberOfArgumentsException(this, 1));
    }

    @Override
    public LispObject execute(LispObject first, LispObject second) {
        return Lisp.error(new WrongNumberOfArgumentsException(this, 2));
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third) {
        return Lisp.error(new WrongNumberOfArgumentsException(this, 3));
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
        return Lisp.error(new WrongNumberOfArgumentsException(this, 4));
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
        return Lisp.error(new WrongNumberOfArgumentsException(this, 5));
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
        return Lisp.error(new WrongNumberOfArgumentsException(this, 6));
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
        return Lisp.error(new WrongNumberOfArgumentsException(this, 7));
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eighth) {
        return Lisp.error(new WrongNumberOfArgumentsException(this, 8));
    }

    @Override
    public LispObject execute(LispObject[] args) {
        return Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String printObject() {
        LispObject name = this.getLambdaName();
        if (name != null && name != Lisp.NIL) {
            return this.unreadableString(name.princToString());
        }
        LispObject lambdaList = this.getLambdaList();
        if (lambdaList != null) {
            StringBuilder sb = new StringBuilder("FUNCTION ");
            sb.append("(LAMBDA ");
            if (lambdaList == Lisp.NIL) {
                sb.append("()");
            } else {
                LispThread thread = LispThread.currentThread();
                SpecialBindingsMark mark = thread.markSpecialBindings();
                thread.bindSpecial(Symbol.PRINT_LENGTH, Fixnum.THREE);
                try {
                    sb.append(lambdaList.printObject());
                }
                finally {
                    thread.resetSpecialBindings(mark);
                }
            }
            sb.append(")");
            return this.unreadableString(sb.toString());
        }
        return this.unreadableString("FUNCTION");
    }

    public final void argCountError() {
        Lisp.error(new WrongNumberOfArgumentsException(this));
    }

    @Override
    public final int getCallCount() {
        return this.callCount;
    }

    @Override
    public void setCallCount(int n) {
        this.callCount = n;
    }

    @Override
    public final void incrementCallCount() {
        ++this.callCount;
    }

    @Override
    public final int getHotCount() {
        return this.hotCount;
    }

    @Override
    public void setHotCount(int n) {
        this.hotCount = n;
    }

    @Override
    public final void incrementHotCount() {
        ++this.hotCount;
    }

    public Object writeReplace() throws ObjectStreamException {
        if (this.shouldSerializeByName()) {
            return new SerializedNamedFunction((Symbol)this.getLambdaName());
        }
        if (this.getClassBytes() == Lisp.NIL || serializingClosure.get() != null) {
            return this;
        }
        return new SerializedLocalFunction(this);
    }

    protected boolean shouldSerializeByName() {
        LispObject lambdaName = this.getLambdaName();
        return lambdaName instanceof Symbol && lambdaName.getSymbolFunction() == this;
    }

    public static class SerializedLocalFunction
    implements Serializable {
        final LispObject className;
        final LispObject classBytes;
        final byte[] serializedFunction;

        public SerializedLocalFunction(Function function) {
            this.className = new SimpleString(function.getClass().getName());
            this.classBytes = function.getClassBytes();
            serializingClosure.set(true);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new ObjectOutputStream(baos).writeObject(function);
                this.serializedFunction = baos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                serializingClosure.remove();
            }
        }

        public Object readResolve() throws InvalidObjectException {
            MemoryClassLoader loader = new MemoryClassLoader();
            MemoryClassLoader.PUT_MEMORY_FUNCTION.execute(JavaObject.getInstance(loader), this.className, this.classBytes);
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(this.serializedFunction);
                return new ObjectInputStreamWithClassLoader(in, loader).readObject();
            }
            catch (Exception e) {
                InvalidObjectException ex = new InvalidObjectException("Could not read the serialized function back");
                ex.initCause(e);
                throw ex;
            }
        }
    }

    public static class ObjectInputStreamWithClassLoader
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        public ObjectInputStreamWithClassLoader(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return Class.forName(desc.getName(), false, this.classLoader);
        }
    }

    public static class SerializedNamedFunction
    implements Serializable {
        private final Symbol name;

        public SerializedNamedFunction(Symbol name) {
            this.name = name;
        }

        public Object readResolve() {
            return this.name.getSymbolFunctionOrDie();
        }
    }

    public static final class pf_function_class_bytes
    extends Primitive {
        public pf_function_class_bytes() {
            super("function-class-bytes", Lisp.PACKAGE_SYS, false, "function");
        }

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof Function) {
                return ((Function)arg).getClassBytes();
            }
            return Lisp.type_error(arg, Symbol.FUNCTION);
        }
    }
}

