/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SlaveServerJobStatus {
    public static final String XML_TAG = "jobstatus";
    private String jobName;
    private String statusDescription;
    private String errorDescription;
    private String loggingString;
    private Result result;

    public SlaveServerJobStatus() {
    }

    public SlaveServerJobStatus(String transName, String statusDescription) {
        this();
        this.jobName = transName;
        this.statusDescription = statusDescription;
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<jobstatus>").append(Const.CR);
        xml.append(XMLHandler.addTagValue((String)"jobname", (String)this.jobName));
        xml.append(XMLHandler.addTagValue((String)"status_desc", (String)this.statusDescription));
        xml.append(XMLHandler.addTagValue((String)"error_desc", (String)this.errorDescription));
        xml.append(XMLHandler.addTagValue((String)"logging_string", (String)XMLHandler.buildCDATA((String)this.loggingString)));
        if (this.result != null) {
            try {
                String resultXML = this.result.getXML();
                xml.append(resultXML);
            }
            catch (IOException e) {
                LogWriter.getInstance().logError("Slave server job status", "Unable to serialize result object as XML", (Throwable)e);
            }
        }
        xml.append("</jobstatus>");
        return xml.toString();
    }

    public SlaveServerJobStatus(Node jobStatusNode) {
        this();
        this.jobName = XMLHandler.getTagValue((Node)jobStatusNode, (String)"jobname");
        this.statusDescription = XMLHandler.getTagValue((Node)jobStatusNode, (String)"status_desc");
        this.errorDescription = XMLHandler.getTagValue((Node)jobStatusNode, (String)"error_desc");
        String loggingString64 = XMLHandler.getTagValue((Node)jobStatusNode, (String)"logging_string");
        try {
            byte[] bytes = new byte[]{};
            if (loggingString64 != null) {
                bytes = Base64.decodeBase64((byte[])loggingString64.getBytes());
            }
            if (bytes.length > 0) {
                int c;
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                GZIPInputStream gzip = new GZIPInputStream(bais);
                StringBuffer buffer = new StringBuffer();
                while ((c = gzip.read()) != -1) {
                    buffer.append((char)c);
                }
                gzip.close();
                this.loggingString = buffer.toString();
            } else {
                this.loggingString = "";
            }
        }
        catch (IOException e) {
            this.loggingString = "Unable to decode logging from remote server : " + e.toString() + Const.CR + Const.getStackTracker((Throwable)e) + Const.CR;
        }
        Node resultNode = XMLHandler.getSubNode((Node)jobStatusNode, (String)"result");
        if (resultNode != null) {
            try {
                this.result = new Result(resultNode);
            }
            catch (IOException e) {
                this.loggingString = this.loggingString + "Unable to serialize result object as XML" + Const.CR + Const.getStackTracker((Throwable)e) + Const.CR;
            }
        }
    }

    public static SlaveServerJobStatus fromXML(String xml) throws KettleXMLException {
        Document document = XMLHandler.loadXMLString((String)xml);
        SlaveServerJobStatus status = new SlaveServerJobStatus(XMLHandler.getSubNode((Node)document, (String)XML_TAG));
        return status;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getLoggingString() {
        return this.loggingString;
    }

    public void setLoggingString(String loggingString) {
        this.loggingString = loggingString;
    }

    public boolean isRunning() {
        return this.getStatusDescription().equalsIgnoreCase("Running") || this.getStatusDescription().equalsIgnoreCase("Initializing");
    }

    public boolean isWaiting() {
        return this.getStatusDescription().equalsIgnoreCase("Waiting");
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }
}

