
(define-library (srfi 160 u64)
  (export
   make-u64vector
   u64?
   u64vector?
   u64vector-ref
   u64vector-set!
   u64vector-length
   (rename uvector-unfold u64vector-unfold)
   (rename uvector-unfold-right u64vector-unfold-right)
   (rename vector-copy u64vector-copy)
   (rename vector-reverse-copy u64vector-reverse-copy)
   (rename vector-append u64vector-append)
   (rename vector-concatenate u64vector-concatenate)
   (rename vector-append-subvectors u64vector-append-subvectors)
   (rename vector-empty? u64vector-empty?)
   (rename vector= u64vector=)
   (rename vector-take u64vector-take)
   (rename vector-take-right u64vector-take-right)
   (rename vector-drop u64vector-drop)
   (rename vector-drop-right u64vector-drop-right)
   (rename vector-segment u64vector-segment)
   (rename vector-fold u64vector-fold)
   (rename vector-fold-right u64vector-fold-right)
   (rename vector-map u64vector-map)
   (rename vector-map! u64vector-map!)
   (rename vector-for-each u64vector-for-each)
   (rename vector-count u64vector-count)
   (rename vector-cumulate u64vector-cumulate)
   (rename vector-take-while u64vector-take-while)
   (rename vector-take-while-right u64vector-take-while-right)
   (rename vector-drop-while u64vector-drop-while)
   (rename vector-drop-while-right u64vector-drop-while-right)
   (rename vector-index u64vector-index)
   (rename vector-index-right u64vector-index-right)
   (rename vector-skip u64vector-skip)
   (rename vector-skip-right u64vector-skip-right)
   (rename vector-binary-search u64vector-binary-search)
   (rename vector-any u64vector-any)
   (rename vector-every u64vector-every)
   (rename vector-partition u64vector-partition)
   (rename vector-filter u64vector-filter)
   (rename vector-remove u64vector-remove)
   (rename vector-swap! u64vector-swap!)
   (rename vector-fill! u64vector-fill!)
   (rename vector-reverse! u64vector-reverse!)
   (rename vector-copy! u64vector-copy!)
   (rename vector-reverse-copy! u64vector-reverse-copy!)
   (rename reverse-vector->list reverse-u64vector->list)
   (rename reverse-list->vector reverse-list->u64vector)
   (rename uvector->vector u64vector->vector)
   (rename vector->uvector vector->u64vector)
   (rename make-vector-generator make-u64vector-generator)
   (rename write-vector write-u64vector))
  (import (except (scheme base)
                  vector-append vector-copy vector-copy!
                  vector-map vector-for-each)
          (scheme write)
          (srfi 160 base))
  (begin
    (define uvector? u64vector?)
    (define make-uvector make-u64vector)
    (define vector u64vector)
    (define uvector->list u64vector->list)
    (define list->uvector list->u64vector)
    (define uvector->list u64vector->list)
    (define uvector-length u64vector-length)
    (define uvector-ref u64vector-ref)
    (define uvector-set! u64vector-set!))
  (include "uvector.scm"))
