/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java;

import jadx.api.plugins.utils.CommonFileUtils;
import jadx.api.plugins.utils.ZipSecurity;
import jadx.plugins.input.java.JavaClassReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaInputLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JavaInputLoader.class);
    private static final int MAX_MAGIC_SIZE = 4;
    private static final byte[] JAVA_CLASS_FILE_MAGIC = new byte[]{-54, -2, -70, -66};
    private static final byte[] ZIP_FILE_MAGIC = new byte[]{80, 75, 3, 4};
    private int classUniqId = 1;

    public List<JavaClassReader> collectFiles(List<Path> inputFiles) {
        return inputFiles.stream().map(Path::toFile).map(this::loadFromFile).filter(list -> !list.isEmpty()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<JavaClassReader> loadInputStream(InputStream in, String name) throws IOException {
        return this.loadReader(in, name, null, null);
    }

    public JavaClassReader loadClass(byte[] content, String fileName) {
        return new JavaClassReader(this.getNextUniqId(), fileName, content);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<JavaClassReader> loadFromFile(File file) {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            List<JavaClassReader> list = this.loadReader(inputStream, file.getName(), file, null);
            return list;
        }
        catch (Exception e) {
            LOG.error("File open error: {}", (Object)file.getAbsolutePath(), (Object)e);
            return Collections.emptyList();
        }
    }

    private List<JavaClassReader> loadReader(InputStream in, String name, @Nullable File file, @Nullable String parentFileName) throws IOException {
        byte[] magic = new byte[4];
        if (in.read(magic) != magic.length) {
            return Collections.emptyList();
        }
        if (JavaInputLoader.isStartWithBytes(magic, JAVA_CLASS_FILE_MAGIC) || name.endsWith(".class")) {
            byte[] data = CommonFileUtils.loadBytes((byte[])magic, (InputStream)in);
            String source = JavaInputLoader.concatSource(parentFileName, name);
            JavaClassReader reader = new JavaClassReader(this.getNextUniqId(), source, data);
            return Collections.singletonList(reader);
        }
        if (JavaInputLoader.isStartWithBytes(magic, ZIP_FILE_MAGIC) || CommonFileUtils.isZipFileExt((String)name)) {
            if (file != null) {
                return this.collectFromZip(file, name);
            }
            File zipFile = CommonFileUtils.saveToTempFile((byte[])magic, (InputStream)in, (String)".zip").toFile();
            List<JavaClassReader> readers = this.collectFromZip(zipFile, JavaInputLoader.concatSource(parentFileName, name));
            CommonFileUtils.safeDeleteFile((File)zipFile);
            return readers;
        }
        return Collections.emptyList();
    }

    private static String concatSource(@Nullable String parentFileName, String name) {
        if (parentFileName == null) {
            return name;
        }
        return parentFileName + ':' + name;
    }

    private List<JavaClassReader> collectFromZip(File file, String name) {
        ArrayList<JavaClassReader> result = new ArrayList<JavaClassReader>();
        try {
            ZipSecurity.readZipEntries((File)file, (entry, in) -> {
                try {
                    String entryName = entry.getName();
                    if (entryName.startsWith("META-INF/versions/")) {
                        return;
                    }
                    result.addAll(this.loadReader((InputStream)in, entryName, null, name));
                }
                catch (Exception e) {
                    LOG.error("Failed to read zip entry: {}", entry, (Object)e);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Failed to process zip file: {}", (Object)file.getAbsolutePath(), (Object)e);
        }
        return result;
    }

    public static boolean isStartWithBytes(byte[] fileMagic, byte[] expectedBytes) {
        int len = expectedBytes.length;
        if (fileMagic.length < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (fileMagic[i] == expectedBytes[i]) continue;
            return false;
        }
        return true;
    }

    private int getNextUniqId() {
        return this.classUniqId++;
    }
}

