/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities.general;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Hk2ThreadLocal<V> {
    private static final Object NULL = new Object();
    private final Map<Key, Object> locals = new ConcurrentHashMap<Key, Object>();
    private final ReferenceQueue<Thread> queue = new ReferenceQueue();

    protected V initialValue() {
        return null;
    }

    public V get() {
        this.removeStaleEntries();
        Key key = Hk2ThreadLocal.newLookupKey();
        Object value2 = this.locals.get(key);
        if (value2 == null) {
            value2 = this.initialValue();
            this.locals.put(Hk2ThreadLocal.newStorageKey(this.queue), Hk2ThreadLocal.maskNull(value2));
        } else {
            value2 = Hk2ThreadLocal.unmaskNull(value2);
        }
        return (V)value2;
    }

    public void set(V value2) {
        Key key = Hk2ThreadLocal.newStorageKey(this.queue);
        this.locals.put(key, Hk2ThreadLocal.maskNull(value2));
    }

    public void remove() {
        Key key = Hk2ThreadLocal.newLookupKey();
        this.locals.remove(key);
    }

    public void removeAll() {
        this.locals.clear();
    }

    public int getSize() {
        this.removeStaleEntries();
        return this.locals.size();
    }

    private void removeStaleEntries() {
        Reference<Thread> queued;
        while ((queued = this.queue.poll()) != null) {
            Key key = (Key)queued;
            this.locals.remove(key);
        }
    }

    private static Object maskNull(Object value2) {
        return value2 == null ? NULL : value2;
    }

    private static Object unmaskNull(Object value2) {
        return value2 == NULL ? null : value2;
    }

    private static Key newStorageKey(ReferenceQueue<Thread> queue) {
        return new Key(Thread.currentThread(), queue);
    }

    private static Key newLookupKey() {
        return new Key(Thread.currentThread(), null);
    }

    private static class Key
    extends WeakReference<Thread> {
        private final long threadId;
        private final int hash;

        private Key(Thread thread2, ReferenceQueue<Thread> queue) {
            super(thread2, queue);
            this.threadId = thread2.getId();
            this.hash = thread2.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return other.threadId == this.threadId;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

