/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.parsing;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class StandardExtensionElementProvider
extends ExtensionElementProvider<StandardExtensionElement> {
    public static StandardExtensionElementProvider INSTANCE = new StandardExtensionElementProvider();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public StandardExtensionElement parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        int i;
        String name = parser2.getName();
        String namespace = parser2.getNamespace();
        StandardExtensionElement.Builder builder2 = StandardExtensionElement.builder(name, namespace);
        int namespaceCount = parser2.getNamespaceCount();
        int attributeCount = parser2.getAttributeCount();
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>(namespaceCount + attributeCount);
        for (i = 0; i < namespaceCount; ++i) {
            String nsprefix = parser2.getNamespacePrefix(i);
            if (nsprefix == null) continue;
            assert (StringUtils.isNotEmpty((CharSequence)nsprefix));
            String nsuri = parser2.getNamespaceUri(i);
            attributes.put("xmlns:" + nsprefix, nsuri);
        }
        for (i = 0; i < attributeCount; ++i) {
            String attributePrefix = parser2.getAttributePrefix(i);
            String attributeName = parser2.getAttributeName(i);
            String attributeValue = parser2.getAttributeValue(i);
            String attributeKey = StringUtils.isNullOrEmpty((CharSequence)attributePrefix) ? attributeName : attributePrefix + ':' + attributeName;
            attributes.put(attributeKey, attributeValue);
        }
        builder2.addAttributes(attributes);
        block7: while (true) {
            XmlPullParser.Event event = parser2.next();
            switch (event) {
                case START_ELEMENT: {
                    builder2.addElement(this.parse(parser2, parser2.getDepth(), xmlEnvironment));
                    break;
                }
                case TEXT_CHARACTERS: {
                    builder2.setText(parser2.getText());
                    break;
                }
                case END_ELEMENT: {
                    if (initialDepth == parser2.getDepth()) break block7;
                }
            }
        }
        ParserUtils.assertAtEndTag(parser2);
        return builder2.build();
    }
}

