/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import org.apache.ivy.Ivy;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.AbstractURLHandler;
import org.apache.ivy.util.url.IvyAuthenticator;
import org.apache.ivy.util.url.URLHandler;

public class BasicURLHandler
extends AbstractURLHandler {
    @Override
    public URLHandler.URLInfo getURLInfo(URL uRL) {
        return this.getURLInfo(uRL, 0);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URLHandler.URLInfo getURLInfo(URL uRL, int n) {
        URLConnection uRLConnection;
        block13: {
            if ("http".equals(uRL.getProtocol()) || "https".equals(uRL.getProtocol())) {
                IvyAuthenticator.install();
            }
            uRLConnection = null;
            try {
                uRL = this.normalizeToURL(uRL);
                uRLConnection = uRL.openConnection();
                uRLConnection.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
                if (uRLConnection instanceof HttpURLConnection) {
                    Object object = (HttpURLConnection)uRLConnection;
                    if (this.getRequestMethod() == 2) {
                        ((HttpURLConnection)object).setRequestMethod("HEAD");
                    }
                    if (this.checkStatusCode(uRL, (HttpURLConnection)object)) {
                        String string = BasicURLHandler.getCharSetFromContentType(uRLConnection.getContentType());
                        object = new URLHandler.URLInfo(true, ((URLConnection)object).getContentLength(), uRLConnection.getLastModified(), string);
                        this.disconnect(uRLConnection);
                        return object;
                    }
                    break block13;
                }
                int n2 = uRLConnection.getContentLength();
                if (n2 <= 0) {
                    URLHandler.URLInfo uRLInfo = UNAVAILABLE;
                    this.disconnect(uRLConnection);
                    return uRLInfo;
                }
                String string = BasicURLHandler.getCharSetFromContentType(uRLConnection.getContentType());
                URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, n2, uRLConnection.getLastModified(), string);
                this.disconnect(uRLConnection);
                return uRLInfo;
            }
            catch (UnknownHostException unknownHostException) {
                Message.warn("Host " + unknownHostException.getMessage() + " not found. url=" + uRL);
                Message.info("You probably access the destination server through a proxy server that is not well configured.");
                this.disconnect(uRLConnection);
                return UNAVAILABLE;
                {
                    catch (Throwable throwable) {
                        this.disconnect(uRLConnection);
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    Message.error("Server access Error: " + iOException.getMessage() + " url=" + uRL);
                    this.disconnect(uRLConnection);
                    return UNAVAILABLE;
                }
            }
        }
        this.disconnect(uRLConnection);
        return UNAVAILABLE;
    }

    public static String getCharSetFromContentType(String stringArray) {
        String string = null;
        if (stringArray != null) {
            stringArray = stringArray.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (!string2.toLowerCase().startsWith("charset=")) continue;
                string = string2.substring(8);
            }
        }
        if (string == null || string.length() == 0) {
            string = "ISO-8859-1";
        }
        return string;
    }

    private boolean checkStatusCode(URL uRL, HttpURLConnection httpURLConnection) throws IOException {
        int n = httpURLConnection.getResponseCode();
        if (n == 200) {
            return true;
        }
        if ("HEAD".equals(httpURLConnection.getRequestMethod()) && n == 204) {
            return true;
        }
        Message.debug("HTTP response status: " + n + " url=" + uRL);
        if (n == 407) {
            Message.warn("Your proxy requires authentication.");
        } else if (String.valueOf(n).startsWith("4")) {
            Message.verbose("CLIENT ERROR: " + httpURLConnection.getResponseMessage() + " url=" + uRL);
        } else if (String.valueOf(n).startsWith("5")) {
            Message.error("SERVER ERROR: " + httpURLConnection.getResponseMessage() + " url=" + uRL);
        }
        return false;
    }

    @Override
    public InputStream openStream(URL object) throws IOException {
        if ("http".equals(((URL)object).getProtocol()) || "https".equals(((URL)object).getProtocol())) {
            IvyAuthenticator.install();
        }
        URLConnection uRLConnection = null;
        try {
            int n;
            Object object2;
            object = this.normalizeToURL((URL)object);
            uRLConnection = ((URL)object).openConnection();
            uRLConnection.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
            uRLConnection.setRequestProperty("Accept-Encoding", "gzip,deflate");
            if (uRLConnection instanceof HttpURLConnection && !this.checkStatusCode((URL)object, (HttpURLConnection)(object2 = (HttpURLConnection)uRLConnection))) {
                throw new IOException("The HTTP response code for " + object + " did not indicate a success. See log for more detail.");
            }
            object2 = this.getDecodingInputStream(uRLConnection.getContentEncoding(), uRLConnection.getInputStream());
            object = new ByteArrayOutputStream();
            byte[] byArray = new byte[65536];
            while ((n = ((InputStream)object2).read(byArray)) > 0) {
                ((ByteArrayOutputStream)object).write(byArray, 0, n);
            }
            object = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            this.disconnect(uRLConnection);
            return object;
        }
        catch (Throwable throwable) {
            this.disconnect(uRLConnection);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void download(URL uRL, File file, CopyProgressListener copyProgressListener) throws IOException {
        if ("http".equals(uRL.getProtocol()) || "https".equals(uRL.getProtocol())) {
            IvyAuthenticator.install();
        }
        URLConnection uRLConnection = null;
        try {
            int n;
            Object object;
            uRL = this.normalizeToURL(uRL);
            uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
            uRLConnection.setRequestProperty("Accept-Encoding", "gzip,deflate");
            if (uRLConnection instanceof HttpURLConnection) {
                object = (HttpURLConnection)uRLConnection;
                n = ((HttpURLConnection)object).getResponseCode();
                if (n == 302 || n == 301) {
                    String string = ((URLConnection)object).getHeaderField("Location");
                    string = URLDecoder.decode(string, "UTF-8");
                    uRL = new URL(string);
                    this.download(uRL, file, copyProgressListener);
                    this.disconnect(uRLConnection);
                    this.disconnect(uRLConnection);
                    return;
                }
                if (!this.checkStatusCode(uRL, (HttpURLConnection)object)) {
                    throw new IOException("The HTTP response code for " + uRL + " did not indicate a success. See log for more detail.");
                }
            }
            object = this.getDecodingInputStream(uRLConnection.getContentEncoding(), uRLConnection.getInputStream());
            FileUtil.copy((InputStream)object, file, copyProgressListener);
            if (uRLConnection.getContentEncoding() == null && (n = uRLConnection.getContentLength()) != -1 && file.length() != (long)n) {
                file.delete();
                throw new IOException("Downloaded file size doesn't match expected Content Length for " + uRL + ". Please retry.");
            }
            long l = uRLConnection.getLastModified();
            if (l > 0L) {
                file.setLastModified(l);
            }
            this.disconnect(uRLConnection);
            return;
        }
        catch (Throwable throwable) {
            this.disconnect(uRLConnection);
            throw throwable;
        }
    }

    private void disconnect(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            if (!"HEAD".equals(((HttpURLConnection)uRLConnection).getRequestMethod())) {
                this.readResponseBody((HttpURLConnection)uRLConnection);
            }
            ((HttpURLConnection)uRLConnection).disconnect();
            return;
        }
        if (uRLConnection != null) {
            try {
                uRLConnection.getInputStream().close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readResponseBody(HttpURLConnection object) {
        byte[] byArray;
        block21: {
            byArray = new byte[65536];
            InputStream inputStream = null;
            try {
                inputStream = ((URLConnection)object).getInputStream();
                while (inputStream.read(byArray) > 0) {
                }
                if (inputStream == null) break block21;
            }
            catch (IOException iOException) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
                break block21;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if ((object = ((HttpURLConnection)object).getErrorStream()) == null) return;
        try {
            while (((InputStream)object).read(byArray) > 0) {
            }
        }
        catch (IOException iOException) {
            try {
                ((InputStream)object).close();
                return;
            }
            catch (IOException iOException3) {
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)object).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)object).close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

