/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.PageViewport;
import org.apache.fop.render.java2d.Java2DRenderer;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;

public class PNGRenderer
extends Java2DRenderer {
    public static final String MIME_TYPE = "image/png";
    private static final String PNG_FILE_EXTENSION = "png";
    private String filePrefix;
    private File outputDir;
    private OutputStream firstOutputStream;

    public String getMimeType() {
        return MIME_TYPE;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        log.info((Object)"rendering areas to PNG");
        this.setOutputDirectory();
        this.firstOutputStream = outputStream;
    }

    private void setOutputDirectory() throws IOException {
        File f = this.getUserAgent().getOutputFile();
        if (f == null) {
            this.outputDir = null;
            this.filePrefix = null;
        } else {
            this.outputDir = f.getParentFile();
            String s = f.getName();
            int i = s.lastIndexOf(".");
            if (i > 0) {
                String extension = s.substring(i + 1).toLowerCase();
                if (!PNG_FILE_EXTENSION.equals(extension)) {
                    throw new IOException("Invalid file extension ('" + extension + "') specified");
                }
            } else if (i == -1) {
                i = s.length();
            } else {
                throw new IOException("Invalid file name ('" + s + "') specified");
            }
            if (s.charAt(i - 1) == '1') {
                --i;
            }
            this.filePrefix = s.substring(0, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRenderer() throws IOException {
        super.stopRenderer();
        for (int i = 0; i < this.pageViewportList.size(); ++i) {
            OutputStream os = this.getCurrentOutputStream(i);
            if (os == null) {
                log.warn((Object)"No filename information available. Stopping early after the first page.");
                break;
            }
            try {
                BufferedImage image = this.getPageImage((PageViewport)this.pageViewportList.get(i));
                log.debug((Object)("Encoding page " + (i + 1)));
                ImageWriterParams params = new ImageWriterParams();
                params.setResolution(Math.round(this.userAgent.getTargetResolution()));
                ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor(this.getMimeType());
                if (writer == null) {
                    throw new IOException("Could not get an ImageWriter to produce " + this.getMimeType() + ". The most likely explanation for this is a class" + " loading problem.");
                }
                log.debug((Object)("Writing image using " + writer.getClass().getName()));
                writer.writeImage((RenderedImage)image, os, params);
                continue;
            }
            finally {
                if (os != this.firstOutputStream) {
                    IOUtils.closeQuietly((OutputStream)os);
                }
            }
        }
    }

    private OutputStream getCurrentOutputStream(int pageNumber) {
        if (pageNumber == 0) {
            return this.firstOutputStream;
        }
        if (this.filePrefix == null) {
            return null;
        }
        File f = new File(this.outputDir, this.filePrefix + (pageNumber + 1) + "." + PNG_FILE_EXTENSION);
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            return os;
        }
        catch (FileNotFoundException e) {
            new FOPException("Can't build the OutputStream\n" + e);
            return null;
        }
    }
}

