/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import jakarta.inject.Inject;
import org.traccar.BaseProtocol;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerServer;
import org.traccar.config.Config;
import org.traccar.protocol.TotemFrameDecoder;
import org.traccar.protocol.TotemProtocolDecoder;
import org.traccar.protocol.TotemProtocolEncoder;
import org.traccar.protocol.TotemProtocolSmsEncoder;

public class TotemProtocol
extends BaseProtocol {
    @Inject
    public TotemProtocol(Config config) {
        this.setSupportedDataCommands("custom", "rebootDevice", "factoryReset", "getVersion", "positionSingle", "engineResume", "engineStop");
        this.setTextCommandEncoder(new TotemProtocolSmsEncoder(this));
        this.setSupportedTextCommands("custom", "rebootDevice", "factoryReset", "getVersion", "positionSingle", "engineResume", "engineStop");
        this.addServer(new TrackerServer(config, this.getName(), false){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                pipeline.addLast((ChannelHandler)new TotemFrameDecoder());
                pipeline.addLast((ChannelHandler)new StringEncoder());
                pipeline.addLast((ChannelHandler)new StringDecoder());
                pipeline.addLast((ChannelHandler)new TotemProtocolEncoder(TotemProtocol.this));
                pipeline.addLast((ChannelHandler)new TotemProtocolDecoder(TotemProtocol.this));
            }
        });
    }
}

