/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class WialonProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_ANY = new PatternBuilder().number("d.d;").optional().expression("([^#]+)?").text("#").expression("([^#]+)").text("#").expression("(.*)").compile();
    private static final Pattern PATTERN = new PatternBuilder().number("(?:NA|(dd)(dd)(dd));").number("(?:NA|(dd)(dd)(dd));").number("(?:NA|(d+)(dd.d+));").expression("(?:NA|([NS]));").number("(?:NA|(d+)(dd.d+));").expression("(?:NA|([EW]));").number("(?:NA|(d+.?d*))?;").number("(?:NA|(d+.?d*))?;").number("(?:NA|(-?d+.?d*));").number("(?:NA|(d+))").groupBegin().text(";").number("(?:NA|(d+.?d*));").number("(?:NA|(d+));").number("(?:NA|(d+));").expression("(?:NA|([^;]*));").expression("(?:NA|([^;]*));").expression("(?:NA|([^;]*))").groupEnd("?").any().compile();

    public WialonProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, String type, Integer number) {
        if (channel != null) {
            StringBuilder response = new StringBuilder("#A");
            response.append(type);
            response.append("#");
            if (number != null) {
                response.append(number);
            }
            response.append("\r\n");
            channel.writeAndFlush((Object)new NetworkMessage(response.toString(), remoteAddress));
        }
    }

    private Position decodePosition(Channel channel, SocketAddress remoteAddress, String id, String substring) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        Parser parser = new Parser(PATTERN, substring);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (parser.hasNext(6)) {
            position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        } else {
            position.setTime(new Date());
        }
        if (parser.hasNextAny(9)) {
            position.setLatitude(parser.nextCoordinate());
            position.setLongitude(parser.nextCoordinate());
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
            position.setCourse(parser.nextDouble(0.0));
            position.setAltitude(parser.nextDouble(0.0));
        } else {
            this.getLastLocation(position, position.getDeviceTime());
        }
        if (parser.hasNext()) {
            int satellites = parser.nextInt(0);
            position.setValid(satellites >= 3);
            position.set("sat", satellites);
        }
        position.set("hdop", parser.nextDouble());
        position.set("input", parser.next());
        position.set("output", parser.next());
        if (parser.hasNext()) {
            String[] values = parser.next().split(",");
            for (int i = 0; i < values.length; ++i) {
                position.set("adc" + (i + 1), values[i]);
            }
        }
        position.set("driverUniqueId", parser.next());
        if (parser.hasNext()) {
            String[] values;
            for (String param : values = parser.next().split(",")) {
                Matcher paramParser = Pattern.compile("(.*):[1-3]:(.*)").matcher(param);
                if (!paramParser.matches()) continue;
                String key = paramParser.group(1).toLowerCase();
                String value = paramParser.group(2);
                try {
                    if (key.equals("accuracy")) {
                        position.setAccuracy(Double.parseDouble(value));
                        continue;
                    }
                    position.set(key, Double.parseDouble(value));
                }
                catch (NumberFormatException e) {
                    if (value.equalsIgnoreCase("true")) {
                        position.set(key, true);
                        continue;
                    }
                    if (value.equalsIgnoreCase("false")) {
                        position.set(key, false);
                        continue;
                    }
                    position.set(key, value);
                }
            }
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        Parser parser = new Parser(PATTERN_ANY, sentence);
        if (!parser.matches()) {
            return null;
        }
        String id = parser.next();
        String type = parser.next();
        String data = parser.next();
        switch (type) {
            case "L": {
                String[] values = data.split(";");
                String imei = values[0].indexOf(46) >= 0 ? values[1] : values[0];
                DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
                if (deviceSession == null) break;
                this.sendResponse(channel, remoteAddress, type, 1);
                break;
            }
            case "P": {
                this.sendResponse(channel, remoteAddress, type, null);
                break;
            }
            case "D": 
            case "SD": {
                Position position = this.decodePosition(channel, remoteAddress, id, data);
                if (position == null) break;
                this.sendResponse(channel, remoteAddress, "D", 1);
                return position;
            }
            case "B": {
                String[] messages = data.split("\\|");
                LinkedList<Position> positions = new LinkedList<Position>();
                for (String message : messages) {
                    Position position = this.decodePosition(channel, remoteAddress, id, message);
                    if (position == null) continue;
                    position.set("archive", true);
                    positions.add(position);
                }
                this.sendResponse(channel, remoteAddress, type, messages.length);
                if (positions.isEmpty()) break;
                return positions;
            }
            case "M": {
                DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
                if (deviceSession == null) break;
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                this.getLastLocation(position, new Date());
                position.setValid(false);
                position.set("result", data);
                this.sendResponse(channel, remoteAddress, type, 1);
                return position;
            }
        }
        return null;
    }
}

